# This file was auto-generated by Fern from our API Definition.

from ....core.unchecked_base_model import UncheckedBaseModel
import pydantic
import typing
from ....core.pydantic_utilities import IS_PYDANTIC_V2


class ExternalReference(UncheckedBaseModel):
    source_name: str = pydantic.Field()
    """
    The source_name property specifies the name of the source that provided the external reference.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description property provides a human-readable explanation of the external reference.
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The url property specifies the URL of the external reference.
    """

    hash: typing.Optional[str] = pydantic.Field(default=None)
    """
    The hash property specifies a hash value that uniquely identifies the external reference.
    """

    external_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The external_id property specifies an identifier used by the source of the external reference.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
