# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class IndicatorTypeOv(str, enum.Enum):
    ANOMALOUS_ACTIVITY = "anomalous_activity"
    ANONYMIZATION = "anonymization"
    BENIGN = "benign"
    COMPROMISED = "compromised"
    MALICIOUS_ACTIVITY = "malicious_activity"
    ATTRIBUTION = "attribution"
    UNKNOWN = "unknown"
    _UNKNOWN = "__INDICATORTYPEOV_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "IndicatorTypeOv":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        anomalous_activity: typing.Callable[[], T_Result],
        anonymization: typing.Callable[[], T_Result],
        benign: typing.Callable[[], T_Result],
        compromised: typing.Callable[[], T_Result],
        malicious_activity: typing.Callable[[], T_Result],
        attribution: typing.Callable[[], T_Result],
        unknown: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is IndicatorTypeOv.ANOMALOUS_ACTIVITY:
            return anomalous_activity()
        if self is IndicatorTypeOv.ANONYMIZATION:
            return anonymization()
        if self is IndicatorTypeOv.BENIGN:
            return benign()
        if self is IndicatorTypeOv.COMPROMISED:
            return compromised()
        if self is IndicatorTypeOv.MALICIOUS_ACTIVITY:
            return malicious_activity()
        if self is IndicatorTypeOv.ATTRIBUTION:
            return attribution()
        if self is IndicatorTypeOv.UNKNOWN:
            return unknown()
        return _unknown_member(self._value_)
