# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations
from ...core.unchecked_base_model import UncheckedBaseModel
import typing
from ...common.types.id import Id
from ...engine.types.object import Object
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import pydantic
import typing_extensions
from ...core.unchecked_base_model import UnionMetadata


class Actor_Agent(UncheckedBaseModel):
    """
    The actor object either relates gives a summary of an actor in an escalation policy or gives full details of an actor. This depends on the capabilities of the ticketing provider. An actor is someone or something that will be notified when certain conditions are met. It can either be an agent, a group, or a schedule.
    """

    type: typing.Literal["agent"] = "agent"
    uid: Id
    full_name: str
    email_addr: typing.Optional[str] = None
    phone_number: typing.Optional[str] = None
    time_zone: typing.Optional[str] = None
    job_title: typing.Optional[str] = None
    unmapped: typing.Optional[Object] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class Actor_AgentSummary(UncheckedBaseModel):
    """
    The actor object either relates gives a summary of an actor in an escalation policy or gives full details of an actor. This depends on the capabilities of the ticketing provider. An actor is someone or something that will be notified when certain conditions are met. It can either be an agent, a group, or a schedule.
    """

    type: typing.Literal["agent_summary"] = "agent_summary"
    id: Id
    name: str
    additional_properties: bool

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class Actor_GroupSummary(UncheckedBaseModel):
    """
    The actor object either relates gives a summary of an actor in an escalation policy or gives full details of an actor. This depends on the capabilities of the ticketing provider. An actor is someone or something that will be notified when certain conditions are met. It can either be an agent, a group, or a schedule.
    """

    type: typing.Literal["group_summary"] = "group_summary"
    id: Id
    name: typing.Optional[str] = None
    additional_properties: bool

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class Actor_ScheduleSummary(UncheckedBaseModel):
    """
    The actor object either relates gives a summary of an actor in an escalation policy or gives full details of an actor. This depends on the capabilities of the ticketing provider. An actor is someone or something that will be notified when certain conditions are met. It can either be an agent, a group, or a schedule.
    """

    type: typing.Literal["schedule_summary"] = "schedule_summary"
    id: Id
    name: typing.Optional[str] = None
    additional_properties: bool

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


Actor = typing_extensions.Annotated[
    typing.Union[
        Actor_Agent, Actor_AgentSummary, Actor_GroupSummary, Actor_ScheduleSummary
    ],
    UnionMetadata(discriminant="type"),
]
