# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class RemoteFieldScope(str, enum.Enum):
    STANDARD = "standard"
    INTEGRATION_CUSTOM = "integration_custom"
    PROJECT_CUSTOM = "project_custom"
    TICKET_CUSTOM = "ticket_custom"
    UNKNOWN = "unknown"
    _UNKNOWN = "__REMOTEFIELDSCOPE_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "RemoteFieldScope":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        standard: typing.Callable[[], T_Result],
        integration_custom: typing.Callable[[], T_Result],
        project_custom: typing.Callable[[], T_Result],
        ticket_custom: typing.Callable[[], T_Result],
        unknown: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is RemoteFieldScope.STANDARD:
            return standard()
        if self is RemoteFieldScope.INTEGRATION_CUSTOM:
            return integration_custom()
        if self is RemoteFieldScope.PROJECT_CUSTOM:
            return project_custom()
        if self is RemoteFieldScope.TICKET_CUSTOM:
            return ticket_custom()
        if self is RemoteFieldScope.UNKNOWN:
            return unknown()
        return _unknown_member(self._value_)
