# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import pydantic
import typing
from .user import User
from .scan_schedule import ScanSchedule
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ScanConfiguration(UncheckedBaseModel):
    """
    Configuration options of a scan.
    """

    uid: str = pydantic.Field()
    """
    ID of the scan.
    """

    name: str = pydantic.Field()
    """
    Name of the scan.
    """

    creation_time: typing.Optional[int] = pydantic.Field(default=None)
    """
    Time when the scan was created.
    """

    last_modified_time: typing.Optional[int] = pydantic.Field(default=None)
    """
    Time when the scan was last modified.
    """

    owner: typing.Optional[User] = pydantic.Field(default=None)
    """
    User that owns the scan.
    """

    schedule: typing.Optional[ScanSchedule] = pydantic.Field(default=None)
    """
    Schedule of the scan if it is a recurring scan.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
