# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class VulnerabilityStateFilterValue(str, enum.Enum):
    """
    The normalized state identifier of a security finding
    """

    UNKNOWN = "Unknown"
    NEW = "New"
    IN_PROGRESS = "InProgress"
    RESOLVED = "Resolved"
    OTHER = "Other"
    _UNKNOWN = "__VULNERABILITYSTATEFILTERVALUE_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "VulnerabilityStateFilterValue":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        unknown: typing.Callable[[], T_Result],
        new: typing.Callable[[], T_Result],
        in_progress: typing.Callable[[], T_Result],
        resolved: typing.Callable[[], T_Result],
        other: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is VulnerabilityStateFilterValue.UNKNOWN:
            return unknown()
        if self is VulnerabilityStateFilterValue.NEW:
            return new()
        if self is VulnerabilityStateFilterValue.IN_PROGRESS:
            return in_progress()
        if self is VulnerabilityStateFilterValue.RESOLVED:
            return resolved()
        if self is VulnerabilityStateFilterValue.OTHER:
            return other()
        return _unknown_member(self._value_)
