# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import pydantic
import typing
from .provider_filter import ProviderFilter
from .request_body import RequestBody
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ProviderOperations(UncheckedBaseModel):
    id: str = pydantic.Field()
    """
    Unique identifier for the operation.
    """

    name: str = pydantic.Field()
    """
    Name of the operation.
    """

    fullname: typing.Optional[str] = pydantic.Field(default=None)
    """
    Display name of the operation.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of the operation.
    """

    request_method: typing.Optional[str] = pydantic.Field(default=None)
    """
    HTTP method used for the operation.
    """

    request_path: typing.Optional[str] = pydantic.Field(default=None)
    """
    URI template path for the operation, including path parameters.
    """

    supported: bool = pydantic.Field()
    """
    Whether the operation is supported by the provider.
    """

    required_fields: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of fields in the request body that are required by the
    provider for this operation. Due to limitations of the OpenAPI
    format these fields may be marked as optional, even though they
    are in fact required by this provider.
    """

    supported_response_fields: typing.Optional[typing.List[str]] = pydantic.Field(
        default=None
    )
    """
    List of fields that may be returned in the response body. Any
    fields not listed in this array are not supported by this
    provider and will not be returned in the response body.
    """

    filters: typing.Optional[typing.List[ProviderFilter]] = pydantic.Field(default=None)
    """
    Filters that can be applied to this operation.
    """

    request_body: typing.Optional[RequestBody] = pydantic.Field(default=None)
    """
    This field is only available if the operation supports a request
    body. Describes the request body and its schema.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
