# This file was auto-generated by Fern from our API Definition.

from ...common.types.base import Base
from .custom_id import CustomId
import pydantic
from ...organization_base.types.organization_id import OrganizationId
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class Custom(Base):
    id: CustomId
    fullname: str = pydantic.Field()
    """
    Human friendly display name for this custom provider.
    """

    organization_id: OrganizationId = pydantic.Field()
    """
    Organization that manages this custom provider.
    """

    data: str = pydantic.Field()
    """
    The YAML custom provider definition. Must follow the custom provider definition schema.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
