# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class MappingDataType(str, enum.Enum):
    STRING = "string"
    NUMBER = "number"
    DATETIME = "datetime"
    BOOLEAN = "boolean"
    ARRAY = "array"
    ANY = "any"
    _UNKNOWN = "__MAPPINGDATATYPE_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "MappingDataType":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        string: typing.Callable[[], T_Result],
        number: typing.Callable[[], T_Result],
        datetime: typing.Callable[[], T_Result],
        boolean: typing.Callable[[], T_Result],
        array: typing.Callable[[], T_Result],
        any: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is MappingDataType.STRING:
            return string()
        if self is MappingDataType.NUMBER:
            return number()
        if self is MappingDataType.DATETIME:
            return datetime()
        if self is MappingDataType.BOOLEAN:
            return boolean()
        if self is MappingDataType.ARRAY:
            return array()
        if self is MappingDataType.ANY:
            return any()
        return _unknown_member(self._value_)
