# This file was auto-generated by Fern from our API Definition.

from ...common.types.base import Base
from .member_id import MemberId
from .state import State
import datetime as dt
import pydantic
import typing
from ...role_base.types.role_name import RoleName
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Member(Base):
    id: MemberId
    state: State
    last_logon: dt.datetime = pydantic.Field()
    """
    Last logon time
    """

    fullname: str = pydantic.Field()
    """
    User's full display name.
    """

    nickname: typing.Optional[str] = pydantic.Field(default=None)
    """
    User's nickname
    """

    picture: typing.Optional[str] = pydantic.Field(default=None)
    """
    Url of user's picture
    """

    ttl: str
    token_ttl: str
    expires: dt.datetime
    pin_expires: dt.datetime
    role_binding: typing.List[RoleName] = pydantic.Field()
    """
    Roles granted to this member. Tokens inherit this access.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
