# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from ...common.types.id import Id
import pydantic
import datetime as dt
import typing
from .operation_trigger_type import OperationTriggerType
from ...operation_base.types.operation_status import OperationStatus
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class OperationExecutionEvent(UncheckedBaseModel):
    """
    A single execution of an operation, capturing start time, completion time,
    and metrics for that specific run.
    """

    execution_id: Id = pydantic.Field()
    """
    Unique identifier for this execution
    """

    operation_id: Id = pydantic.Field()
    """
    ID of the operation that was executed
    """

    started_at: dt.datetime = pydantic.Field()
    """
    When this execution started
    """

    completed_at: dt.datetime = pydantic.Field()
    """
    When this execution completed
    """

    account_id: Id = pydantic.Field()
    """
    Account ID containing the integration
    """

    integration_id: Id = pydantic.Field()
    """
    Integration ID used for the operation
    """

    integration_point_id: typing.Optional[Id] = pydantic.Field(default=None)
    """
    Integration-point ID if triggered by a schedule, omitted if manually triggered
    via the API
    """

    operation: str = pydantic.Field()
    """
    Name of the operation (e.g., "assets_query_devices")
    """

    trigger_type: OperationTriggerType = pydantic.Field()
    """
    How this execution was triggered
    """

    trigger_source: str = pydantic.Field()
    """
    Source of trigger - "manual" for API calls, integration-point ID for scheduled
    """

    status: OperationStatus = pydantic.Field()
    """
    Final status of the execution
    """

    records_processed: int = pydantic.Field()
    """
    Approximate number of records processed
    """

    cpu_time: int = pydantic.Field()
    """
    CPU time in microseconds
    """

    in_bytes: int = pydantic.Field()
    """
    Number of bytes sent to sink integration
    """

    duration: int = pydantic.Field()
    """
    Total execution duration in microseconds
    """

    initial_cursor: typing.Optional[str] = pydantic.Field(default=None)
    """
    Cursor value at execution start
    """

    final_cursor: typing.Optional[str] = pydantic.Field(default=None)
    """
    Cursor value at execution completion
    """

    error: typing.Optional[str] = pydantic.Field(default=None)
    """
    Error message if execution failed
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
