# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .scheduled_operation_id import ScheduledOperationId
import pydantic
from .operation_frequency import OperationFrequency
import typing
from .operation_incremental_pull_config import OperationIncrementalPullConfig
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class OperationSchedule(UncheckedBaseModel):
    operation: ScheduledOperationId = pydantic.Field()
    """
    ID of the operation to schedule (e.g., query_alerts, query_endpoints).
    """

    enabled: bool = pydantic.Field()
    """
    Whether the schedule is active. When false, no executions will occur.
    """

    frequency: OperationFrequency = pydantic.Field()
    """
    How often the operation should execute (e.g., every 4 hours).
    If an execution takes longer than the interval, the next execution
    will start immediately after the previous one completes.
    """

    filters: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Optional filters to apply when querying data from the source API.
    Format and available filters depend on the specific operation.
    Example: "severity[eq]critical" or "status[eq]active".
    """

    backfill_from_time: typing.Optional[str] = pydantic.Field(default=None)
    """
    Starting point for the initial data collection. No data before this time will be fetched.
    Accepts:
    
    - RFC 3339 datetime: "2024-01-01T00:00:00Z"
    - Relative duration: "7d" (7 days ago), "24h" (24 hours ago), "30m" (30 minutes ago)
    - "max": Collect all available historical data
      If not specified, starts from the operation's creation time.
    """

    incremental_config: typing.Optional[OperationIncrementalPullConfig] = (
        pydantic.Field(default=None)
    )
    """
    Configuration for how data is fetched on each execution.
    By default, operations fetch only data that changed since the last run (incremental)
    and the time filter used depends on the operation.
    Use this to override the default behavior or switch to full snapshots.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
