# This file was auto-generated by Fern from our API Definition.

from ..core.client_wrapper import SyncClientWrapper
import typing
from ..core.request_options import RequestOptions
from .types.list_operations_response import ListOperationsResponse
from ..core.unchecked_base_model import construct_type
from ..common.errors.bad_request_error import BadRequestError
from ..common.types.problem import Problem
from ..common.errors.unauthorized_error import UnauthorizedError
from ..common.errors.forbidden_error import ForbiddenError
from ..common.errors.not_found_error import NotFoundError
from ..common.errors.method_not_allowed_error import MethodNotAllowedError
from ..common.errors.conflict_error import ConflictError
from ..common.errors.unsupported_media_type_error import UnsupportedMediaTypeError
from ..common.errors.too_many_requests_error import TooManyRequestsError
from ..common.errors.internal_server_error import InternalServerError
from json.decoder import JSONDecodeError
from ..core.api_error import ApiError
from ..operation_history.types.list_execution_history_response import (
    ListExecutionHistoryResponse,
)
from ..core.client_wrapper import AsyncClientWrapper


class OperationsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        limit: typing.Optional[int] = None,
        start_after: typing.Optional[str] = None,
        order: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        filter: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListOperationsResponse:
        """
        Returns a list of all `Asynchronous Operations` objects.

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of `Asynchronous Operations` objects to return in this page. Defaults to 100.

        start_after : typing.Optional[str]
            Return `Asynchronous Operations` objects starting after this `name`.

        order : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Select a field to order the results by. Defaults to `id`. To control the direction of the sorting, append
            `[asc]` or `[desc]` to the field id. For example, `id[desc]` will sort the results by `id` in descending order.
            The ordering defaults to `asc` if not specified. May be used multiple times to order by multiple fields, and the
            ordering is applied in the order the fields are specified.

        filter : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Filter results by this query. For more information on filtering, refer to our Filtering Guide. Defaults to no filter.
            If used more than once, the queries are ANDed together.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListOperationsResponse

        Examples
        --------
        from synqly import SynqlyManagement

        client = SynqlyManagement(
            token="YOUR_TOKEN",
        )
        client.operations.list(
            limit=1,
            start_after="string",
            order="string",
            filter="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/jobs",
            method="GET",
            params={
                "limit": limit,
                "start_after": start_after,
                "order": order,
                "filter": filter,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ListOperationsResponse,
                    construct_type(
                        type_=ListOperationsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 409:
                raise ConflictError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 415:
                raise UnsupportedMediaTypeError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def list_execution_history(
        self,
        *,
        filter: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        order: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        limit: typing.Optional[int] = None,
        start_after: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListExecutionHistoryResponse:
        """
        Returns the execution history for all operations.
        History is stored for the configured retention period (default 4 weeks).

        Parameters
        ----------
        filter : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Filter operation execution history by this query.
            Available filters:

            - `id[eq]` - Filter by specific operation ID
            - `integration_id[eq]` - Filter by specific integration ID
            - `account_id[eq]` - Filter by specific account ID
            - `execution_id[eq]` - Filter by specific execution ID
            - `started_at[gte]` - Filter executions started at or after a specific datetime (RFC3339 format)
            - `started_at[lte]` - Filter executions started at or before a specific datetime (RFC3339 format)
            - `started_at[gt]` - Filter executions started after a specific datetime
            - `started_at[lt]` - Filter executions started before a specific datetime
            - `operation_id[eq]` - Filter by operation name (e.g., "assets_query_devices")
              If used more than once, the queries are ANDed together.

        order : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Select a field to order the results by. Defaults to `started_at[desc]`. To control the direction of the sorting, append
            `[asc]` or `[desc]` to the field id. For example, `started_at[asc]` will sort the results by `started_at` in ascending order.
            The ordering defaults to `desc` if not specified. May be used multiple times to order by multiple fields, and the
            ordering is applied in the order the fields are specified.

        limit : typing.Optional[int]
            Number of results to return (default 100, max 500)

        start_after : typing.Optional[str]
            Return execution history starting after this cursor.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListExecutionHistoryResponse

        Examples
        --------
        from synqly import SynqlyManagement

        client = SynqlyManagement(
            token="YOUR_TOKEN",
        )
        client.operations.list_execution_history(
            filter="string",
            order="string",
            limit=1,
            start_after="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/jobs/history",
            method="GET",
            params={
                "filter": filter,
                "order": order,
                "limit": limit,
                "start_after": start_after,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ListExecutionHistoryResponse,
                    construct_type(
                        type_=ListExecutionHistoryResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncOperationsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        limit: typing.Optional[int] = None,
        start_after: typing.Optional[str] = None,
        order: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        filter: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListOperationsResponse:
        """
        Returns a list of all `Asynchronous Operations` objects.

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of `Asynchronous Operations` objects to return in this page. Defaults to 100.

        start_after : typing.Optional[str]
            Return `Asynchronous Operations` objects starting after this `name`.

        order : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Select a field to order the results by. Defaults to `id`. To control the direction of the sorting, append
            `[asc]` or `[desc]` to the field id. For example, `id[desc]` will sort the results by `id` in descending order.
            The ordering defaults to `asc` if not specified. May be used multiple times to order by multiple fields, and the
            ordering is applied in the order the fields are specified.

        filter : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Filter results by this query. For more information on filtering, refer to our Filtering Guide. Defaults to no filter.
            If used more than once, the queries are ANDed together.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListOperationsResponse

        Examples
        --------
        import asyncio

        from synqly import AsyncSynqlyManagement

        client = AsyncSynqlyManagement(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.operations.list(
                limit=1,
                start_after="string",
                order="string",
                filter="string",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/jobs",
            method="GET",
            params={
                "limit": limit,
                "start_after": start_after,
                "order": order,
                "filter": filter,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ListOperationsResponse,
                    construct_type(
                        type_=ListOperationsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 409:
                raise ConflictError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 415:
                raise UnsupportedMediaTypeError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def list_execution_history(
        self,
        *,
        filter: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        order: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        limit: typing.Optional[int] = None,
        start_after: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListExecutionHistoryResponse:
        """
        Returns the execution history for all operations.
        History is stored for the configured retention period (default 4 weeks).

        Parameters
        ----------
        filter : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Filter operation execution history by this query.
            Available filters:

            - `id[eq]` - Filter by specific operation ID
            - `integration_id[eq]` - Filter by specific integration ID
            - `account_id[eq]` - Filter by specific account ID
            - `execution_id[eq]` - Filter by specific execution ID
            - `started_at[gte]` - Filter executions started at or after a specific datetime (RFC3339 format)
            - `started_at[lte]` - Filter executions started at or before a specific datetime (RFC3339 format)
            - `started_at[gt]` - Filter executions started after a specific datetime
            - `started_at[lt]` - Filter executions started before a specific datetime
            - `operation_id[eq]` - Filter by operation name (e.g., "assets_query_devices")
              If used more than once, the queries are ANDed together.

        order : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Select a field to order the results by. Defaults to `started_at[desc]`. To control the direction of the sorting, append
            `[asc]` or `[desc]` to the field id. For example, `started_at[asc]` will sort the results by `started_at` in ascending order.
            The ordering defaults to `desc` if not specified. May be used multiple times to order by multiple fields, and the
            ordering is applied in the order the fields are specified.

        limit : typing.Optional[int]
            Number of results to return (default 100, max 500)

        start_after : typing.Optional[str]
            Return execution history starting after this cursor.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListExecutionHistoryResponse

        Examples
        --------
        import asyncio

        from synqly import AsyncSynqlyManagement

        client = AsyncSynqlyManagement(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.operations.list_execution_history(
                filter="string",
                order="string",
                limit=1,
                start_after="string",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/jobs/history",
            method="GET",
            params={
                "filter": filter,
                "order": order,
                "limit": limit,
                "start_after": start_after,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ListExecutionHistoryResponse,
                    construct_type(
                        type_=ListExecutionHistoryResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
