# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import pydantic
import typing
import datetime as dt
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class OrganizationWebhookSecret(UncheckedBaseModel):
    value: str = pydantic.Field()
    """
    Secret used for signing webhooks. This value is used to verify the authenticity of the webhook payload.
    """

    expires: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Time when this secret expires and can no longer be used again.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
