# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .hcl_app_scan_on_cloud_credential import HclAppScanOnCloudCredential
import pydantic
from .hcl_app_scan_on_cloud_url import HclAppScanOnCloudUrl
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class AppsecHclAppScanOnCloud(UncheckedBaseModel):
    """
    Configuration for HCL AppScan on Cloud as an application security provider.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/hcl-appscan-appsec-setup)
    """

    credential: HclAppScanOnCloudCredential = pydantic.Field()
    """
    Credentials used for accessing the HCL AppScan on Cloud API.
    """

    url: HclAppScanOnCloudUrl = pydantic.Field()
    """
    Base URL for the HCL AppScan on Cloud API. This URL should be the same as the URL used to access the HCL AppScan on Cloud web interface.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
