# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .axonius_credential import AxoniusCredential
import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class AssetsAxonius(UncheckedBaseModel):
    """
    Configuration for the Axonius Assets Provider

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/axonius-asset-setup)
    """

    credential: AxoniusCredential
    url: str = pydantic.Field()
    """
    Base URL for the Axonius API.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
