# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .ivanti_credential import IvantiCredential
import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class AssetsIvantiNeurons(UncheckedBaseModel):
    """
    Configuration for Ivanti Neurons as an Assets Provider

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/ivanti-asset-setup)
    """

    account_identifier: str
    credential: IvantiCredential
    url: str = pydantic.Field()
    """
    Base URL for the Ivanti Neurons API.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
