# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import pydantic
import typing
from .custom_endpoint import CustomEndpoint
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CustomSynqly(UncheckedBaseModel):
    """
    Configuration for Synqly Custom Provider.
    """

    custom_id: str = pydantic.Field()
    """
    Customer provider ID associated with this credential configuration
    """

    endpoints: typing.Dict[str, CustomEndpoint] = pydantic.Field()
    """
    Custom endpoints. Review the custom provider definition for the custom_id you supplied for the list of endpoints that must be defined. All endpoint in the provider definition are required.
    """

    tags: typing.Dict[str, str] = pydantic.Field()
    """
    Tags that customize how provider requests are made, such as supplying a URL path parameter or account ID. Review the custom provider definition for the custom_id you supplied for the list of tags that must be defined. All tags in the provider definition are required.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
