# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import pydantic
from .teams_credential import TeamsCredential
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class NotificationsTeams(UncheckedBaseModel):
    """
    Configuration for Microsoft Teams.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/teams-notification-setup)
    """

    channel_id: str = pydantic.Field()
    """
    Identifier of the channel to send messages to.
    """

    credential: TeamsCredential
    endpoint: typing.Optional[str] = pydantic.Field(default=None)
    """
    URL of the endpoint to send messages to. Only required if OAuth Client Credentials are used for authentication.
    """

    team_id: str = pydantic.Field()
    """
    Identifier of the team to send messages to.
    """

    tenant_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Azure Directory (tenant) ID. Only required if OAuth Client Credentials are used for authentication.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
