# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .crowd_strike_credential import CrowdStrikeCredential
import pydantic
import typing
from .crowdstrike_hec_credential import CrowdstrikeHecCredential
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class SiemCrowdstrike(UncheckedBaseModel):
    """
    Configuration for CrowdStrike Falcon® Next-Gen SIEM.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/crowdstrike-siem-setup)
    """

    credential: CrowdStrikeCredential = pydantic.Field()
    """
    The credential to use for the CrowdStrike Falcon NextGen SIEM tenant.
    """

    hec_credential: typing.Optional[CrowdstrikeHecCredential] = pydantic.Field(
        default=None
    )
    """
    Token credential to use for connecting to the CrowdStrike HEC service. If not provided, sending events to CrowdStrike is disabled.
    """

    hec_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The generated CrowdStrike HEC URL provided with your token.
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Base URL for the CrowdStrike Falcon® Next-Gen SIEM API.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
