# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .google_chronicle_credential import GoogleChronicleCredential
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class SiemGoogleChronicle(UncheckedBaseModel):
    """
    Configuration for Google Security Operations (formerly Google Chronicle) as a SIEM Provider connecting via the older Backstory and Malachite APIs.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/google-chronicle-setup)
    """

    customer_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The customer ID reported when writing events. This field is required if writing events.
    """

    ingestion_credential: typing.Optional[GoogleChronicleCredential] = pydantic.Field(
        default=None
    )
    """
    Credentials used for writing events. If not specified then writing events is disabled.
    """

    ingestion_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Base URL for the Google SecOps Ingestion API.
    """

    search_credential: GoogleChronicleCredential = pydantic.Field()
    """
    Credentials used for querying and reading events.
    """

    search_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Base URL for the Google SecOps Search API.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
