# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import typing
from .splunk_hec_token import SplunkHecToken
import pydantic
from .splunk_search_credential import SplunkSearchCredential
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class SiemSplunk(UncheckedBaseModel):
    """
    Configuration for Splunk Enterprise Security.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/splunk-setup)
    """

    hec_credential: typing.Optional[SplunkHecToken] = pydantic.Field(default=None)
    """
    Credential to use when connecting to the Splunk HEC service. If not provided, sending events to Splunk is disabled.
    """

    hec_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    URL for the Splunk HEC endpoint. Must include the full path to the HEC endpoint.
    """

    index: typing.Optional[str] = pydantic.Field(default=None)
    """
    Splunk index to send events to. If not provided, will use the default index for the Splunk collector.
    """

    search_service_credential: SplunkSearchCredential = pydantic.Field()
    """
    Credential used when authenticating with the Splunk Search Service.
    """

    search_service_url: str = pydantic.Field()
    """
    URL used when connecting to the Splunk Search Service.
    """

    skip_tls_verify: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When true, skips verification of the Splunk TLS certificate.
    """

    source: typing.Optional[str] = pydantic.Field(default=None)
    """
    Splunk source to send events to. If not provided the default source for the Splunk collector is used.
    """

    source_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    Splunk source type to send events to. If not provided the default source type for the Splunk collector is used.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
