# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import typing
from .elasticsearch_auth_options import ElasticsearchAuthOptions
import pydantic
from .elasticsearch_credential import ElasticsearchCredential
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class SinkElasticsearch(UncheckedBaseModel):
    """
    Configuration for Elasticsearch.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/elastic-setup)
    """

    auth_options: typing.Optional[ElasticsearchAuthOptions] = None
    create_index: str = pydantic.Field()
    """
    The index or data stream to use when writing events.
    """

    credential: ElasticsearchCredential
    skip_tls_verify: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When true, skips verification of the Elasticsearch TLS certificate.
    """

    url: str = pydantic.Field()
    """
    Base URL for the Elasticsearch API.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
