# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .ivanti_credential_ticketing import IvantiCredentialTicketing
import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class TicketingIvanti(UncheckedBaseModel):
    """
    Configuration for the Ivanti Neurons Ticketing Provider

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/ivanti-ticketing-setup)
    """

    credential: IvantiCredentialTicketing
    url: str = pydantic.Field()
    """
    Base URL for the Ivanti ITSM API. This should be the base URL for your Ivanti instance, without any path components.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
