# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import datetime as dt
import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class TimeseriesResult(UncheckedBaseModel):
    """
    Status timeseries object
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Interval time
    """

    succeeded: int = pydantic.Field()
    """
    Succeeded count
    """

    failed: int = pydantic.Field()
    """
    Failed count
    """

    cpu_time: int = pydantic.Field()
    """
    Cpu time in microseconds
    """

    in_bytes: int = pydantic.Field()
    """
    API input byte count
    """

    out_bytes: int = pydantic.Field()
    """
    API output byte count
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
