# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ...role_base.types.resources import Resources
from ...permissionset_base.types.permissions import Permissions
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CreateTokenRequest(UncheckedBaseModel):
    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique short name for this token (lowercase [a-z0-9_-], can be used in URLs). Also used for case insensitive duplicate name detection and default sort order. Defaults to TokenId if both name and fullname are not specified.
    """

    fullname: typing.Optional[str] = pydantic.Field(default=None)
    """
    Human friendly display name for this Token, will auto-generate 'name' field (if 'name' is not specified). Defaults to the same value as the 'name' field if not specified.
    """

    resources: Resources = pydantic.Field()
    """
    Limit access to supplied resources
    """

    permission_set: Permissions = pydantic.Field()
    """
    Limit access to supplied permissions
    """

    token_ttl: typing.Optional[str] = pydantic.Field(default=None)
    """
    Token time-to-live. If not provided, defaults to 24 hours. Use the format "1h", "1m", "1s" for hours, minutes, and seconds respectively, e.g., "24h" for 24 hours.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
