# Plato: A New Framework for Scalable Federated Learning Research

Welcome to Plato, a new software framework to facilitate scalable federated learning research.

## Getting Started

!!! tip "Installation and Setup"
    Get Plato up and running in your environment.

    - **[Installation](install.md)** - Install Plato and set up your development environment
    - **[Quick Start](quickstart.md)** - Get started with Plato quickly

## Configuration

!!! tip "Configuration Settings"
    Comprehensive guides for configuring all aspects of Plato.

    - **[Configuration Settings](configurations/overview.md)** - Overview of configuration options
    - **[General](configurations/general.md)** - General configuration settings
    - **[Clients](configurations/clients.md)** - Client configuration
    - **[Server](configurations/server.md)** - Server configuration
    - **[Data](configurations/data.md)** - Data handling configuration
    - **[Trainer](configurations/trainer.md)** - Training configuration
    - **[Algorithm](configurations/algorithm.md)** - Algorithm configuration
    - **[Results](configurations/results.md)** - Results and logging configuration
    - **[Parameters](configurations/parameters.md)** - Parameter configuration

## Examples

!!! tip "Available Example"
    Explore practical examples and algorithm implementations.

    - **[Getting Started Examples](examples/Getting%20Started.md)** - Basic examples to get you started

    ### Algorithm Examples
    - **[Server Aggregation Algorithms](examples/algorithms/1.%20Server%20Aggregation%20Algorithms.md)**
    - **[Secure Aggregation with Homomorphic Encryption](examples/algorithms/2.%20Secure%20Aggregation%20with%20Homomorphic%20Encryption.md)**
    - **[Asynchronous Federated Learning](examples/algorithms/3.%20Asynchronous%20Federated%20Learning%20Algorithms.md)**
    - **[Federated Unlearning](examples/algorithms/4.%20Federated%20Unlearning.md)**
    - **[Customized Client Training Loops](examples/algorithms/5.%20Algorithms%20with%20Customized%20Client%20Training%20Loops.md)**
    - **[Client Selection Algorithms](examples/algorithms/6.%20Client%20Selection%20Algorithms.md)**
    - **[Split Learning Algorithms](examples/algorithms/7.%20Split%20Learning%20Algorithms.md)**
    - **[Personalized Federated Learning](examples/algorithms/8.%20Personalized%20Federated%20Learning%20Algorithms.md)**
    - **[Self-Supervised Personalized FL](examples/algorithms/9.%20Personalized%20Federated%20Learning%20Algorithms%20based%20on%20Self-Supervised%20Learning.md)**
    - **[Neural Architecture Search](examples/algorithms/10.%20Algorithms%20based%20on%20Neural%20Architecture%20Search%20and%20Model%20Search.md)**
    - **[Three-layer Federated Learning](examples/algorithms/11.%20Three-layer%20Federated%20Learning%20Algorithms.md)**
    - **[Poisoning Detection](examples/algorithms/12.%20Poisoning%20Detection%20Algorithms.md)**
    - **[Model Pruning](examples/algorithms/13.%20Model%20Pruning%20Algorithms.md)**
    - **[Gradient Leakage Attacks and Defences](examples/algorithms/14.%20Gradient%20Leakage%20Attacks%20and%20Defences.md)**

## Development and Deployment

!!! tip "Development and Deployment"
    For developers and production deployments.

    - **[Developer's Guide](development.md)** - Contribute to Plato development
    - **[Deployment Guide](deployment.md)** - Deploy Plato in production environments

## API Reference

!!! tip "API Documentation"
    Detailed API reference for customizing Plato components.

    - **[Trainers](references/trainers.md)** - Customizing training loops and callbacks
    - **[Servers](references/servers.md)** - Customizing server behavior and aggregation
    - **[Clients](references/clients.md)** - Customizing client behavior and processing

## Additional Resources

!!! tip "Additional documentation and troubleshooting"
    - **[Miscellaneous](misc.md)** - Troubleshooting, testing, and additional notes
