from __future__ import annotations

import pytest
from mcp.types import ImageContent, TextContent

from hud.tools.computer.hud import HudComputerTool

# (action, kwargs)
CASES = [
    ("screenshot", {}),
    ("click", {"x": 1, "y": 1}),  # Removed pattern=[] to use Field default
    ("press", {"keys": ["ctrl", "c"]}),
    ("keydown", {"keys": ["shift"]}),
    ("keyup", {"keys": ["shift"]}),
    ("type", {"text": "hello"}),
    ("scroll", {"x": 10, "y": 10, "scroll_y": 20}),  # Added required x,y coordinates
    # Skip move test - it has Field parameter handling issues when called directly
    # ("move", {"x": 5, "y": 5}),  # x,y are for absolute positioning
    ("wait", {"time": 5}),
    ("drag", {"path": [(0, 0), (10, 10)]}),
    ("mouse_down", {}),
    ("mouse_up", {}),
    ("hold_key", {"text": "a", "duration": 0.1}),
]


@pytest.mark.asyncio
@pytest.mark.parametrize("action, params", CASES)
async def test_hud_computer_actions(action: str, params: dict):
    comp = HudComputerTool()
    blocks = await comp(action=action, **params)
    # Ensure at least one content block is returned
    assert blocks
    assert all(isinstance(b, ImageContent | TextContent) for b in blocks)
