# Generated by Django 4.2.2 on 2023-07-19 20:05

import django.db.models.deletion
from django.db import migrations, models

import lnschema_core.ids
import lnschema_core.users


class Migration(migrations.Migration):
    dependencies = [
        ("lnschema_core", "0008_file_hash_type_transform_parents"),
    ]

    operations = [
        migrations.AddField(
            model_name="file",
            name="feature_sets",
            field=models.ManyToManyField(related_name="files", to="lnschema_core.featureset"),
        ),
        migrations.RunSQL("insert into lnschema_core_file_feature_sets (id, file_id, featureset_id) select id, file_id, featureset_id from lnschema_core_featureset_files"),
        migrations.RemoveField(
            model_name="featureset",
            name="files",
        ),
        migrations.AddField(
            model_name="feature",
            name="unit",
            field=models.CharField(db_index=True, default=None, max_length=30, null=True),
        ),
        migrations.AlterField(
            model_name="feature",
            name="description",
            field=models.TextField(db_index=True, default=None, null=True),
        ),
        migrations.AlterField(
            model_name="feature",
            name="type",
            field=models.CharField(db_index=True, default=None, max_length=96, null=True),
        ),
        migrations.AlterField(
            model_name="featureset",
            name="field",
            field=models.CharField(max_length=64),
        ),
        migrations.AlterField(
            model_name="run",
            name="created_by",
            field=models.ForeignKey(
                default=lnschema_core.users.current_user_id, on_delete=django.db.models.deletion.CASCADE, related_name="created_runs", to="lnschema_core.user"
            ),
        ),
        migrations.AlterField(
            model_name="run",
            name="transform",
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name="runs", to="lnschema_core.transform"),
        ),
        migrations.CreateModel(
            name="Category",
            fields=[
                ("id", models.CharField(default=lnschema_core.ids.base62_12, max_length=12, primary_key=True, serialize=False)),
                ("name", models.CharField(db_index=True, max_length=128)),
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("updated_at", models.DateTimeField(auto_now=True, db_index=True)),
                (
                    "created_by",
                    models.ForeignKey(
                        default=lnschema_core.users.current_user_id, on_delete=django.db.models.deletion.PROTECT, related_name="created_categories", to="lnschema_core.user"
                    ),
                ),
                ("feature", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name="categories", to="lnschema_core.feature")),
            ],
            options={
                "unique_together": {("name", "feature")},
            },
        ),
        migrations.AddField(
            model_name="featureset",
            name="schema",
            field=models.CharField(default="core", max_length=64),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="featureset",
            name="field",
            field=models.CharField(db_index=True, max_length=64),
        ),
        migrations.AlterField(
            model_name="featureset",
            name="schema",
            field=models.CharField(db_index=True, max_length=64),
        ),
        migrations.AlterField(
            model_name="featureset",
            name="type",
            field=models.CharField(db_index=True, max_length=64),
        ),
    ]
