---
title: about
---
## What is an Agent-based Model (ABM)

> [!INFO]Definition
> An agent-based model (often called **ABM**) comprises diverse autonomous agents interacting with one another and their environment**.

ABM is simulated over time: agents make decisions and act based on their attributes and/or in response or anticipation of other agents’ behaviors or changes in the environment at each time step or event. Many agents' micro-level actions and interactions give rise to macro-level patterns and dynamics, typically the focus of analysis. The agents thus respond diversely to the contexts (*usually depicted by the model's parameters and variables*) they jointly created, and their actions' outcomes then lead to an [emergence] of the macro pattern.

## What are Social-ecological Systems (SESs)

> [!INFO]Definition
> ‘**Social-ecological systems**’ (SES) is a concept for understanding the intertwined nature of human and natural systems in an interconnected and interdependent way ^[@biggs2021].

**SESs** are not merely social plus ecological systems, but cohesive, integrated systems characterised by strong connections and feedbacks within and between social and ecological components that determine their overall dynamics ^[@folke2010]. As such, SES are a type of [complex adaptive system], and studying SESs often requires the methods or the applications to cover the social domains, ecological domains, and the [emergence] from their dynamic interdependence ^[@folke2016].

## ABM is an essential method in studying SES

**Several characteristics of ABM make it an essential method for SES research:**

1. It focuses on the change of an SES over time from mutual adaptations of agents and their environments.
2. It can lead to [emergence], -system-level outcomes from micro-level interactions and macro-level feedback.
3. its ability to represent the diversity and heterogeneity of human and non-human actors and the spatial characteristics of an SES.
4. its capacity serves as a virtual laboratory in which researchers and stakeholders can experiment with an SES to explore possible consequences of interventions.

## When and How ABM to Study SES

Agent-based models of SES are often developed for one of the following **purposes** ^[@biggs2021]:

- Exploring or explaining the [emergence] of social-ecological outcomes and understanding the SES's evolution over time.
- Assessing the impact of a new policy or disturbance on an SES that is understood as a [complex adaptive system], including potential unintended consequences.
- Supporting a participatory process that aims to enhance problem understanding.

## References


<!-- links -->
  [emergence]: concepts/emergence.md
  [complex adaptive system]: concepts/complex_adaptive_systems.md
