---
title: 关于
---
## 什么是基于智能体的模型（ABM）

> [!INFO] 定义
> 基于智能体的模型（通常称为 **ABM**）由多个自主智能体组成，它们彼此交互并与其环境交互。

ABM 随时间模拟：智能体根据其属性和/或响应或预期其他智能体的行为或环境的变化，在每个时间步或事件中做出决策和行动。许多智能体的微观层面行动和互动产生了宏观层面的模式和动态，这通常是分析的重点。因此，智能体对它们共同创建的上下文（*通常由模型的参数和变量描述*）做出不同的响应，然后它们行动的结果导致宏观模式的[涌现]。

## 什么是社会生态系统（SESs）

> [!INFO] 定义
> "**社会生态系统**"（SES）是一个概念，用于以相互关联和相互依存的方式理解人类和自然系统交织的本质 ^[@biggs2021]。

**SESs** 不仅仅是社会系统加生态系统，而是具有凝聚力的集成系统，其特征是社会和生态组成部分内部和之间的强连接和反馈，这些连接和反馈决定了它们的整体动态 ^[@folke2010]。因此，SES 是一种[复杂适应系统]，研究 SESs 通常需要方法或应用程序涵盖社会领域、生态领域以及它们动态相互依赖产生的[涌现] ^[@folke2016]。

## ABM 是研究 SES 的重要方法

**ABM 的几个特征使其成为 SES 研究的重要方法：**

1. 它关注 SES 随时间从智能体及其环境的相互适应而发生的变化。
2. 它可以导致[涌现] - 从微观层面的互动和宏观层面的反馈产生的系统层面结果。
3. 它能够表示人类和非人类行为者的多样性和异质性以及 SES 的空间特征。
4. 它的能力可作为虚拟实验室，研究人员和利益相关者可以在其中对 SES 进行实验，以探索干预措施的可能后果。

## 何时以及如何使用 ABM 研究 SES

SES 的基于智能体的模型通常为以下**目的**之一而开发 ^[@biggs2021]：

- 探索或解释社会生态结果的[涌现]，并理解 SES 随时间的演变。
- 评估新政策或干扰对被理解为[复杂适应系统]的 SES 的影响，包括潜在的意外后果。
- 支持旨在增强问题理解的参与式过程。

## 参考文献

<!-- links -->
  [涌现]: concepts/emergence.md
  [复杂适应系统]: concepts/complex_adaptive_systems.md

