# Complex Adaptive Systems (CAS)

The social-ecological systems (SES) literature now widely recognises that SES can be characterised as intertwined complex adaptive systems (CAS) ^[@biggs2021]. It means system-level patterns or behaviours cannot be explained by the individual components alone but arise from interactions among agents who adapt and learn about their environment.

Meanwhile, the conceptual foundation of agent-based modelling is complex adaptive systems theory ^[@arthur2018]. Six principles present a typology of characteristics that allows us to discern the qualities of CAS and offer suggestions on the practical implications of CAS-based approaches for assessing and applying appropriate methods to study ^[@biggs2021]:

=== "Constituted relationally"
	> Complex adaptive systems are constituted relationally, meaning that complex behaviour and structures emerge as a result of the recursive and aggregate patterns of relations between the component parts of systems.

=== "Adaptive"
	> Complex adaptive systems have adaptive capacities and self-organise and coevolve about contextual changes.

=== "Dynamic"
	> Dynamic relations characterise complex adaptive systems. In other words, the relationships in a system are constantly changing in rich and unexpected ways.

=== "Radically open"
	> Complex adaptive systems are radically open. In other words, the system's activity in relation to the environment constitutes the system itself.

=== "Contextual"
	> Complex adaptive systems are context-dependent, meaning CAS's function(s) are contingent on context.

=== "Complex causality and emergence"
	> Complex adaptive systems are characterised by complex causality and emergence. Cause-and-effect interactions in CAS are not unidirectional or linear, but are marked by complex recursive causal pathways that are non-linear and dynamic.
