from bam_masterdata.metadata.definitions import VocabularyTerm, VocabularyTypeDef
from bam_masterdata.metadata.entities import VocabularyType


class DefaultCollectionViews(VocabularyType):
    defs = VocabularyTypeDef(
        code="$DEFAULT_COLLECTION_VIEWS",
        description="""Default collection views""",
    )

    form_view = VocabularyTerm(
        code="FORM_VIEW",
        label="Form view",
        description="""""",
    )

    list_view = VocabularyTerm(
        code="LIST_VIEW",
        label="List view",
        description="""""",
    )


class StorageFormat(VocabularyType):
    defs = VocabularyTypeDef(
        code="$STORAGE_FORMAT",
        description="""The on-disk storage format of a data set""",
    )

    bds_directory = VocabularyTerm(
        code="BDS_DIRECTORY",
        label="",
        description="""""",
    )

    proprietary = VocabularyTerm(
        code="PROPRIETARY",
        label="",
        description="""""",
    )


class AccuracyClassVde0410(VocabularyType):
    defs = VocabularyTypeDef(
        code="ACCURACY_CLASS_VDE0410",
        description="""Accuracy Classes according to VDE 0410//Genauigkeitsklassen nach VDE 0410""",
    )

    accuracy_0_1 = VocabularyTerm(
        code="ACCURACY_0.1",
        label="Accuracy Class 0,1 (0,1 % Fullscale)",
        description="""Accuracy Class 0,1 (0,1 % Fullscale)//Genauigkeitsklasse 0,1 (0,1 % vom Skalenendwert)""",
    )

    accuracy_0_2 = VocabularyTerm(
        code="ACCURACY_0.2",
        label="Accuracy Class 0,2 (0,2 % Fullscale)",
        description="""Accuracy Class 0,2 (0,2 % Fullscale)//Genauigkeitsklasse 0,2 (0,2 % vom Skalenendwert)""",
    )

    accuracy_0_5 = VocabularyTerm(
        code="ACCURACY_0.5",
        label="Accuracy Class 0,5 (0,5 % Fullscale)",
        description="""Accuracy Class 0,5 (0,5 % Fullscale)//Genauigkeitsklasse 0,5 (0,5 % vom Skalenendwert)""",
    )

    accuracy_1 = VocabularyTerm(
        code="ACCURACY_1",
        label="Accuracy Class 1 (1 % Fullscale)",
        description="""Accuracy Class 1 (1 % Fullscale)//Genauigkeitsklasse 1 (1 % vom Skalenendwert)""",
    )

    accuracy_1_5 = VocabularyTerm(
        code="ACCURACY_1.5",
        label="Accuracy Class 1,5 (1,5 % Fullscale)",
        description="""Accuracy Class 1,5 (1,5 % Fullscale)//Genauigkeitsklasse 1,5 (1,5 % vom Skalenendwert)""",
    )

    accuracy_2_5 = VocabularyTerm(
        code="ACCURACY_2.5",
        label="Accuracy Class 2,5 (2,5 % Fullscale)",
        description="""Accuracy Class 2,5 (2,5 % Fullscale)//Genauigkeitsklasse 2,5 (2,5 % vom Skalenendwert)""",
    )

    accuracy_5 = VocabularyTerm(
        code="ACCURACY_5",
        label="Accuracy Class 5 (5 % Fullscale)",
        description="""Accuracy Class 5 (5 % Fullscale)//Genauigkeitsklasse 5 (5 % vom Skalenendwert)""",
    )


class AtomisticCalcType(VocabularyType):
    defs = VocabularyTypeDef(
        code="ATOMISTIC_CALC_TYPE",
        description="""Type of calculation//Art der Berechnung""",
    )

    atom_calc_mc = VocabularyTerm(
        code="ATOM_CALC_MC",
        label="Monte-Carlo",
        description="""Monte-Carlo calculation//Monte-Carlo Berechnung""",
    )

    atom_calc_md = VocabularyTerm(
        code="ATOM_CALC_MD",
        label="Molecular Dynamics",
        description="""Molecular dynamics (including ab initio)//Molekulardynamik (inklusive ab initio)""",
    )

    atom_calc_neb = VocabularyTerm(
        code="ATOM_CALC_NEB",
        label="NEB",
        description="""Nudged Elastic Band method//Geschobene Elastische Band Methode""",
    )

    atom_calc_sc = VocabularyTerm(
        code="ATOM_CALC_SC",
        label="Self-consistent Field",
        description="""Self-consistent field calculation//Selbstkonsistente Feldberechnung""",
    )

    atom_calc_struc_opt = VocabularyTerm(
        code="ATOM_CALC_STRUC_OPT",
        label="Minimization/Structural-optimization",
        description="""Minimization/structural-optimization//Minimierung/Strukturoptimierung""",
    )


class AtomKpointType(VocabularyType):
    defs = VocabularyTypeDef(
        code="ATOM_KPOINT_TYPE",
        description="""K-points specification type//K-Punkte-Spezifikation Typ""",
    )

    kpoints_kspacing = VocabularyTerm(
        code="KPOINTS_KSPACING",
        label="K-spacing",
        description="""K-spacing method//K-spacing Methode""",
    )

    kpoints_manual = VocabularyTerm(
        code="KPOINTS_MANUAL",
        label="Manually Defined",
        description="""Manually defined//Manuell definiert""",
    )

    kpoints_mp = VocabularyTerm(
        code="KPOINTS_MP",
        label="Monkhorst-Pack",
        description="""Monkhorst-Pack method//Monkhorst-Pack Methode""",
    )


class AtomPotentialStyle(VocabularyType):
    defs = VocabularyTypeDef(
        code="ATOM_POTENTIAL_STYLE",
        description="""Interatomic Potential Style//Interatomares Potential Stil""",
    )

    pot_style_eam = VocabularyTerm(
        code="POT_STYLE_EAM",
        label="Embedded Atom Model Potential",
        description="""Embedded atom model//Eingebettetes-Atom-Model""",
    )

    pot_style_ff = VocabularyTerm(
        code="POT_STYLE_FF",
        label="Force Field Potential",
        description="""Force field potential//Kraftfeld Potenzial""",
    )

    pot_style_lj = VocabularyTerm(
        code="POT_STYLE_LJ",
        label="Lennard-Jones Potential",
        description="""Lennard-Jones potential//Lennard-Jones Potenzial""",
    )

    pot_style_meam = VocabularyTerm(
        code="POT_STYLE_MEAM",
        label="Modified Embedded Atom Model Potential",
        description="""Modifiead embedded atom model//Modifiziertes Eingebettetes-Atom-Model""",
    )

    pot_style_mlip = VocabularyTerm(
        code="POT_STYLE_MLIP",
        label="Machine Learning Potential",
        description="""Machine learning potential//Machine-learning Potenzial""",
    )

    pot_style_sw = VocabularyTerm(
        code="POT_STYLE_SW",
        label="Stillinger-Weber Potential",
        description="""Stillinger-Weber potential//Stillinger-Weber Potenzial""",
    )

    pot_style_umlip = VocabularyTerm(
        code="POT_STYLE_UMLIP",
        label="Universal Machine Learning Potential",
        description="""Universal machine learning potential//Universelles Machine-learning Potenzial""",
    )


class AtomXcFunctional(VocabularyType):
    defs = VocabularyTypeDef(
        code="ATOM_XC_FUNCTIONAL",
        description="""Exchange-correlation functional//Austausch-Korrelations-Funktional""",
    )

    xc_func_b3lyp = VocabularyTerm(
        code="XC_FUNC_B3LYP",
        label="B3LYP",
        description="""B3LYP functional//B3LYP Funktional""",
    )

    xc_func_hse03 = VocabularyTerm(
        code="XC_FUNC_HSE03",
        label="HSE03",
        description="""HSE03 functional//HSE03 Funktional""",
    )

    xc_func_hse06 = VocabularyTerm(
        code="XC_FUNC_HSE06",
        label="HSE06",
        description="""HSE06 functional//HSE06 Funktional""",
    )

    xc_func_lda = VocabularyTerm(
        code="XC_FUNC_LDA",
        label="LDA",
        description="""Local Density Approximation//Lokale Dichtenäherung""",
    )

    xc_func_pbe = VocabularyTerm(
        code="XC_FUNC_PBE",
        label="PBE",
        description="""PBE-exchange-correlation functional//PBE-Austauschkorrelation Funktional""",
    )

    xc_func_pbe_sol = VocabularyTerm(
        code="XC_FUNC_PBE_SOL",
        label="PBEsol",
        description="""PBE functional revised for solids//PBE Funktional überarbeitet für Festkörper""",
    )

    xc_func_scan0 = VocabularyTerm(
        code="XC_FUNC_SCAN0",
        label="SCAN0",
        description="""SCAN0 functional//SCAN0 Funktional""",
    )


class AuxiliaryMaterialType(VocabularyType):
    defs = VocabularyTypeDef(
        code="AUXILIARY_MATERIAL_TYPE",
        description="""Auxiliary Material Types//Hilfsstofftyp""",
    )

    abrasive = VocabularyTerm(
        code="ABRASIVE",
        label="Abrasive",
        description="""Abrasive//Schleifmittel""",
    )

    adhesive = VocabularyTerm(
        code="ADHESIVE",
        label="Adhesive",
        description="""Adhesive//Klebstoff""",
    )

    cleaner = VocabularyTerm(
        code="CLEANER",
        label="Cleaner",
        description="""Cleaner//Reinigungsmittel""",
    )

    flux = VocabularyTerm(
        code="FLUX",
        label="Flux",
        description="""Flux//Flussmittel""",
    )

    lubricant = VocabularyTerm(
        code="LUBRICANT",
        label="Lubricant",
        description="""Lubricant//Schmierstoff""",
    )

    polishing_agent = VocabularyTerm(
        code="POLISHING_AGENT",
        label="Polishing Agent",
        description="""Polishing Agent//Poliermittel""",
    )

    razorblade = VocabularyTerm(
        code="RAZORBLADE",
        label="Razorblade",
        description="""Razorblade//Rasierklinge""",
    )

    solder = VocabularyTerm(
        code="SOLDER",
        label="Solder",
        description="""Solder//Lot""",
    )

    solvant = VocabularyTerm(
        code="SOLVANT",
        label="Solvent",
        description="""Solvent//Lösungsmittel""",
    )

    welding_additive = VocabularyTerm(
        code="WELDING_ADDITIVE",
        label="Welding Additive",
        description="""Welding Additive//Schweisszusatz""",
    )


class BamFieldOfActivity(VocabularyType):
    defs = VocabularyTypeDef(
        code="BAM_FIELD_OF_ACTIVITY",
        description="""BAM Field of Activity//BAM Aktivitätsfeld""",
    )

    anal_sci_chemical_composition_and_trace_analysis = VocabularyTerm(
        code="ANAL_SCI_CHEMICAL_COMPOSITION_AND_TRACE_ANALYSIS",
        label="Analytical Sciences: Chemical composition and trace analysis",
        description="""Analytical Sciences: Chemical composition and trace analysis//Analytical Sciences: Spurenanalytik und chemische Zusammensetzung""",
    )

    anal_sci_non_destructive_testing_and_spectroscopy = VocabularyTerm(
        code="ANAL_SCI_NON_DESTRUCTIVE_TESTING_AND_SPECTROSCOPY",
        label="Analytical Sciences: Non-destructive testing and spectroscopy",
        description="""Analytical Sciences: Non-destructive testing and spectroscopy//Analytical Sciences: Zerstörungsfreie Prüfung und Spektroskopie""",
    )

    anal_sci_quality_assurance_and_data_science = VocabularyTerm(
        code="ANAL_SCI_QUALITY_ASSURANCE_AND_DATA_SCIENCE",
        label="Analytical Sciences: Quality assurance and data science",
        description="""Analytical Sciences: Quality assurance and data science//Analytical Sciences: Qualitätssicherung und Data Science""",
    )

    anal_sci_sensor_technology = VocabularyTerm(
        code="ANAL_SCI_SENSOR_TECHNOLOGY",
        label="Analytical Sciences: Sensor technology",
        description="""Analytical Sciences: Sensor technology//Analytical Sciences: Sensorik""",
    )

    anal_sci_structure_analysis_and_materialography = VocabularyTerm(
        code="ANAL_SCI_STRUCTURE_ANALYSIS_AND_MATERIALOGRAPHY",
        label="Analytical Sciences: Structure analysis and materialography",
        description="""Analytical Sciences: Structure analysis and materialography//Analytical Sciences: Strukturanalytik und Materialographie""",
    )

    anal_sci_surface_and_interface_analysis = VocabularyTerm(
        code="ANAL_SCI_SURFACE_AND_INTERFACE_ANALYSIS",
        label="Analytical Sciences: Surface and interface analysis",
        description="""Analytical Sciences: Surface and interface analysis//Analytical Sciences: Oberflächen- und Grenzflächenanalytik""",
    )

    central_services_cross_sectional_tasks = VocabularyTerm(
        code="CENTRAL_SERVICES_CROSS_SECTIONAL_TASKS",
        label="Central Services: Cross-sectional tasks",
        description="""Central Services: Cross-sectional tasks//Zentrale Dienstleistungen: Querschnittsaufgaben""",
    )

    energy_electrical_energy_storage = VocabularyTerm(
        code="ENERGY_ELECTRICAL_ENERGY_STORAGE",
        label="Energy: Electrical energy storage (Priority Theme)",
        description="""Energy: Electrical energy storage (Priority Theme)//Energie: Elektrische Energiespeicher (EES) (Schwerpunktthema)""",
    )

    energy_electrical_energy_storage_and_conversion = VocabularyTerm(
        code="ENERGY_ELECTRICAL_ENERGY_STORAGE_AND_CONVERSION",
        label="Energy: Electrical energy storage and conversion",
        description="""Energy: Electrical energy storage and conversion//Energie: Elektrische Energiespeicher und -umwandlung""",
    )

    energy_h2_safety_at_bam = VocabularyTerm(
        code="ENERGY_H2_SAFETY_AT_BAM",
        label="Energy: H2Safety@BAM (Priority Theme)",
        description="""Energy: H2Safety@BAM (Priority Theme)//Energie: H2Safety@BAM (Schwerpunktthema)""",
    )

    energy_hydrogen = VocabularyTerm(
        code="ENERGY_HYDROGEN",
        label="Energy: Hydrogen",
        description="""Energy: Hydrogen//Energie: Wasserstoff""",
    )

    energy_radioactive_waste_disposal = VocabularyTerm(
        code="ENERGY_RADIOACTIVE_WASTE_DISPOSAL",
        label="Energy: Radioactive waste disposal",
        description="""Energy: Radioactive waste disposal//Energie: Kerntechnische Entsorgung""",
    )

    energy_wind_at_bam = VocabularyTerm(
        code="ENERGY_WIND_AT_BAM",
        label="Energy: Wind@BAM (Priority Theme)",
        description="""Energy: Wind@BAM (Priority Theme)//Energie: Wind@BAM (Schwerpunktthema)""",
    )

    energy_wind_energy = VocabularyTerm(
        code="ENERGY_WIND_ENERGY",
        label="Energy: Wind energy",
        description="""Energy: Wind energy//Energie: Windenergie""",
    )

    env_behaviour_of_materials_and_products_in_the_env = VocabularyTerm(
        code="ENV_BEHAVIOUR_OF_MATERIALS_AND_PRODUCTS_IN_THE_ENV",
        label="Environment: Behaviour of materials and products in the environment",
        description="""Environment: Behaviour of materials and products in the environment//Umwelt: Umweltverhalten von Materialien und Produkten""",
    )

    env_environmental_pollutants = VocabularyTerm(
        code="ENV_ENVIRONMENTAL_POLLUTANTS",
        label="Environment: Environmental pollutants",
        description="""Environment: Environmental pollutants//Umwelt: Umweltschadstoffe""",
    )

    env_microbiologically_influenced_corrosion = VocabularyTerm(
        code="ENV_MICROBIOLOGICALLY_INFLUENCED_CORROSION",
        label="Environment: Microbiologically influenced corrosion (Priority Theme)",
        description="""Environment: Microbiologically influenced corrosion (Priority Theme)//Umwelt: Mikrobiell induzierte Korrosion (MIC) (Schwerpunktthema)""",
    )

    env_resource_recovery_and_material_recycling = VocabularyTerm(
        code="ENV_RESOURCE_RECOVERY_AND_MATERIAL_RECYCLING",
        label="Environment: Resource recovery and material recycling",
        description="""Environment: Resource recovery and material recycling//Umwelt: Ressourcenrückgewinnung und Materialverwertung""",
    )

    infra_fire_science = VocabularyTerm(
        code="INFRA_FIRE_SCIENCE",
        label="Infrastructure: ‌Fire Science",
        description="""Infrastructure: ‌Fire Science//Infrastruktur: Fire Science""",
    )

    infra_safety_and_life_cycle_of_structures = VocabularyTerm(
        code="INFRA_SAFETY_AND_LIFE_CYCLE_OF_STRUCTURES",
        label="Infrastructure: Safety and life cycle of structures",
        description="""Infrastructure: Safety and life cycle of structures//Infrastruktur: Sicherheit und Lebensdauer von Bauwerken""",
    )

    infra_safety_of_industrial_fac_and_traffic_routes = VocabularyTerm(
        code="INFRA_SAFETY_OF_INDUSTRIAL_FAC_AND_TRAFFIC_ROUTES",
        label="Infrastructure: Safety of industrial facilities and traffic routes",
        description="""Infrastructure: Safety of industrial facilities and traffic routes//Infrastruktur: Sicherheit von Industrieanlagen und Verkehrswegen""",
    )

    infra_security = VocabularyTerm(
        code="INFRA_SECURITY",
        label="Infrastructure: ‌Security",
        description="""Infrastructure: ‌Security//Infrastruktur: Security""",
    )

    infra_transport_and_stor_of_danger_subst_and_goods = VocabularyTerm(
        code="INFRA_TRANSPORT_AND_STOR_OF_DANGER_SUBST_AND_GOODS",
        label="Infrastructure: Transport and storage of dangerous substances and goods",
        description="""Infrastructure: Transport and storage of dangerous substances and goods//Infrastruktur: Transport und Lagerung von Gefahrstoffen und -gütern""",
    )

    infra_transport_infrastructures = VocabularyTerm(
        code="INFRA_TRANSPORT_INFRASTRUCTURES",
        label="Infrastructure: Transport Infrastructures (Priority Theme)",
        description="""Infrastructure: Transport Infrastructures (Priority Theme)//Infrastruktur: Verkehrsinfrastrukturen (Schwerpunktthema)""",
    )

    material_additive_manufacturing = VocabularyTerm(
        code="MATERIAL_ADDITIVE_MANUFACTURING",
        label="Material: Additive Manufacturing",
        description="""Material: Additive Manufacturing//Material: Additive Fertigung""",
    )

    material_am_at_bam = VocabularyTerm(
        code="MATERIAL_AM_AT_BAM",
        label="Material: AM@BAM (Priority Theme)",
        description="""Material: AM@BAM (Priority Theme)//Material: AM@BAM (Schwerpunktthema)""",
    )

    material_degradation_and_life_cycle_of_materials = VocabularyTerm(
        code="MATERIAL_DEGRADATION_AND_LIFE_CYCLE_OF_MATERIALS",
        label="Material: Characterization of advanced materials and substances",
        description="""Material: Characterization of advanced materials and substances//Material: Charakterisierung neuer Materialien und Stoffe""",
    )

    material_materials_and_substances = VocabularyTerm(
        code="MATERIAL_MATERIALS_AND_SUBSTANCES",
        label="Material: Degradation and life cycle of materials",
        description="""Material: Degradation and life cycle of materials//Material: Degradation und Life Cycle von Werkstoffen und Materialien""",
    )

    material_material_design = VocabularyTerm(
        code="MATERIAL_MATERIAL_DESIGN",
        label="Material: Material design",
        description="""Material: Material design//Material: Materialdesign""",
    )

    material_nano_at_bam = VocabularyTerm(
        code="MATERIAL_NANO_AT_BAM",
        label="Material: Nano@BAM",
        description="""Material: Nano@BAM//Material: Nano@BAM""",
    )


class BamFloor(VocabularyType):
    defs = VocabularyTypeDef(
        code="BAM_FLOOR",
        description="""BAM Floor//BAM Etage""",
    )

    flo_ = VocabularyTerm(
        code="FLO_",
        label="[empty]",
        description="""Floor //Etage""",
    )

    flo_0 = VocabularyTerm(
        code="FLO_0",
        label="0",
        description="""Floor 0//Etage 0""",
    )

    flo_0_anbau_ost = VocabularyTerm(
        code="FLO_0_ANBAU_OST",
        label="0_Anbau Ost",
        description="""Floor 0_Anbau Ost//Etage 0_Anbau Ost""",
    )

    flo_0_anbau_west = VocabularyTerm(
        code="FLO_0_ANBAU_WEST",
        label="0_Anbau West",
        description="""Floor 0_Anbau West//Etage 0_Anbau West""",
    )

    flo_1 = VocabularyTerm(
        code="FLO_1",
        label="1",
        description="""Floor 1//Etage 1""",
    )

    flo_1a = VocabularyTerm(
        code="FLO_1A",
        label="1A",
        description="""Floor 1A//Etage 1A""",
    )

    flo_2 = VocabularyTerm(
        code="FLO_2",
        label="2",
        description="""Floor 2//Etage 2""",
    )

    flo_2a = VocabularyTerm(
        code="FLO_2A",
        label="2A",
        description="""Floor 2A//Etage 2A""",
    )

    flo_3 = VocabularyTerm(
        code="FLO_3",
        label="3",
        description="""Floor 3//Etage 3""",
    )

    flo_4 = VocabularyTerm(
        code="FLO_4",
        label="4",
        description="""Floor 4//Etage 4""",
    )

    flo_4_og = VocabularyTerm(
        code="FLO_4_OG",
        label="4.OG",
        description="""Floor 4.OG//Etage 4.OG""",
    )

    flo_5 = VocabularyTerm(
        code="FLO_5",
        label="5",
        description="""Floor 5//Etage 5""",
    )

    flo_5_og = VocabularyTerm(
        code="FLO_5_OG",
        label="5.OG",
        description="""Floor 5.OG//Etage 5.OG""",
    )

    flo_6 = VocabularyTerm(
        code="FLO_6",
        label="6",
        description="""Floor 6//Etage 6""",
    )

    flo_7 = VocabularyTerm(
        code="FLO_7",
        label="7",
        description="""Floor 7//Etage 7""",
    )

    flo_8 = VocabularyTerm(
        code="FLO_8",
        label="8",
        description="""Floor 8//Etage 8""",
    )

    flo__1 = VocabularyTerm(
        code="FLO_-1",
        label="-1",
        description="""Floor -1//Etage -1""",
    )

    flo__1_anbau_ost = VocabularyTerm(
        code="FLO_-1_ANBAU_OST",
        label="-1_Anbau Ost",
        description="""Floor -1_Anbau Ost//Etage -1_Anbau Ost""",
    )

    flo__1_anbau_west = VocabularyTerm(
        code="FLO_-1_ANBAU_WEST",
        label="-1_Anbau West",
        description="""Floor -1_Anbau West//Etage -1_Anbau West""",
    )

    flo__2 = VocabularyTerm(
        code="FLO_-2",
        label="-2",
        description="""Floor -2//Etage -2""",
    )

    flo__3 = VocabularyTerm(
        code="FLO_-3",
        label="-3",
        description="""Floor -3//Etage -3""",
    )


class BamFocusArea(VocabularyType):
    defs = VocabularyTypeDef(
        code="BAM_FOCUS_AREA",
        description="""BAM Focus Area//BAM Themenfeld""",
    )

    chemistry_and_process_engineering = VocabularyTerm(
        code="CHEMISTRY_AND_PROCESS_ENGINEERING",
        label="Chemistry and Process Engineering",
        description="""Chemistry and Process Engineering//Chemie und Prozesstechnik""",
    )

    energy = VocabularyTerm(
        code="ENERGY",
        label="Energy",
        description="""Energy//Energie""",
    )

    environment = VocabularyTerm(
        code="ENVIRONMENT",
        label="Environment",
        description="""Environment//Umwelt""",
    )

    infrastructure = VocabularyTerm(
        code="INFRASTRUCTURE",
        label="Infrastructure",
        description="""Infrastructure//Infrastruktur""",
    )

    materials = VocabularyTerm(
        code="MATERIALS",
        label="Materials",
        description="""Materials//Material""",
    )


class BamHouse(VocabularyType):
    defs = VocabularyTypeDef(
        code="BAM_HOUSE",
        description="""BAM House//BAM Gebäude/Haus""",
    )

    hou_7 = VocabularyTerm(
        code="HOU_7",
        label="7",
        description="""House 7//Haus 7""",
    )

    hou_8_01 = VocabularyTerm(
        code="HOU_8_01",
        label="8.01",
        description="""House 8.01//Haus 8.01""",
    )

    hou_8_02 = VocabularyTerm(
        code="HOU_8_02",
        label="8.02",
        description="""House 8.02//Haus 8.02""",
    )

    hou_8_03 = VocabularyTerm(
        code="HOU_8_03",
        label="8.03",
        description="""House 8.03//Haus 8.03""",
    )

    hou_8_05 = VocabularyTerm(
        code="HOU_8_05",
        label="8.05",
        description="""House 8.05//Haus 8.05""",
    )

    hou_8_06 = VocabularyTerm(
        code="HOU_8_06",
        label="8.06",
        description="""House 8.06//Haus 8.06""",
    )

    hou_8_15 = VocabularyTerm(
        code="HOU_8_15",
        label="8.15",
        description="""House 8.15//Haus 8.15""",
    )

    hou_8_17 = VocabularyTerm(
        code="HOU_8_17",
        label="8.17",
        description="""House 8.17//Haus 8.17""",
    )

    hou_8_18 = VocabularyTerm(
        code="HOU_8_18",
        label="8.18",
        description="""House 8.18//Haus 8.18""",
    )

    hou_9 = VocabularyTerm(
        code="HOU_9",
        label="9",
        description="""House 9//Haus 9""",
    )

    hou_01 = VocabularyTerm(
        code="HOU_01",
        label="01",
        description="""House 01//Haus 01""",
    )

    hou_02 = VocabularyTerm(
        code="HOU_02",
        label="02",
        description="""House 02//Haus 02""",
    )

    hou_03 = VocabularyTerm(
        code="HOU_03",
        label="03",
        description="""House 03//Haus 03""",
    )

    hou_04 = VocabularyTerm(
        code="HOU_04",
        label="04",
        description="""House 04//Haus 04""",
    )

    hou_05 = VocabularyTerm(
        code="HOU_05",
        label="05",
        description="""House 05//Haus 05""",
    )

    hou_06 = VocabularyTerm(
        code="HOU_06",
        label="06",
        description="""House 06//Haus 06""",
    )

    hou_07 = VocabularyTerm(
        code="HOU_07",
        label="07",
        description="""House 07//Haus 07""",
    )

    hou_08 = VocabularyTerm(
        code="HOU_08",
        label="08",
        description="""House 08//Haus 08""",
    )

    hou_09 = VocabularyTerm(
        code="HOU_09",
        label="09",
        description="""House 09//Haus 09""",
    )

    hou_10 = VocabularyTerm(
        code="HOU_10",
        label="10",
        description="""House 10//Haus 10""",
    )

    hou_12 = VocabularyTerm(
        code="HOU_12",
        label="12",
        description="""House 12//Haus 12""",
    )

    hou_15 = VocabularyTerm(
        code="HOU_15",
        label="15",
        description="""House 15//Haus 15""",
    )

    hou_16 = VocabularyTerm(
        code="HOU_16",
        label="16",
        description="""House 16//Haus 16""",
    )

    hou_20 = VocabularyTerm(
        code="HOU_20",
        label="20",
        description="""House 20//Haus 20""",
    )

    hou_21 = VocabularyTerm(
        code="HOU_21",
        label="21",
        description="""House 21//Haus 21""",
    )

    hou_22 = VocabularyTerm(
        code="HOU_22",
        label="22",
        description="""House 22//Haus 22""",
    )

    hou_23 = VocabularyTerm(
        code="HOU_23",
        label="23",
        description="""House 23//Haus 23""",
    )

    hou_24 = VocabularyTerm(
        code="HOU_24",
        label="24",
        description="""House 24//Haus 24""",
    )

    hou_25 = VocabularyTerm(
        code="HOU_25",
        label="25",
        description="""House 25//Haus 25""",
    )

    hou_26 = VocabularyTerm(
        code="HOU_26",
        label="26",
        description="""House 26//Haus 26""",
    )

    hou_30 = VocabularyTerm(
        code="HOU_30",
        label="30",
        description="""House 30//Haus 30""",
    )

    hou_40 = VocabularyTerm(
        code="HOU_40",
        label="40",
        description="""House 40//Haus 40""",
    )

    hou_41 = VocabularyTerm(
        code="HOU_41",
        label="41",
        description="""House 41//Haus 41""",
    )

    hou_42 = VocabularyTerm(
        code="HOU_42",
        label="42",
        description="""House 42//Haus 42""",
    )

    hou_43 = VocabularyTerm(
        code="HOU_43",
        label="43",
        description="""House 43//Haus 43""",
    )

    hou_44 = VocabularyTerm(
        code="HOU_44",
        label="44",
        description="""House 44//Haus 44""",
    )

    hou_50 = VocabularyTerm(
        code="HOU_50",
        label="50",
        description="""House 50//Haus 50""",
    )

    hou_51 = VocabularyTerm(
        code="HOU_51",
        label="51",
        description="""House 51//Haus 51""",
    )

    hou_60 = VocabularyTerm(
        code="HOU_60",
        label="60",
        description="""House 60//Haus 60""",
    )

    hou_80 = VocabularyTerm(
        code="HOU_80",
        label="80",
        description="""House 80//Haus 80""",
    )

    hou_81 = VocabularyTerm(
        code="HOU_81",
        label="81",
        description="""House 81//Haus 81""",
    )

    hou_82 = VocabularyTerm(
        code="HOU_82",
        label="82",
        description="""House 82//Haus 82""",
    )

    hou_83 = VocabularyTerm(
        code="HOU_83",
        label="83",
        description="""House 83//Haus 83""",
    )

    hou_86 = VocabularyTerm(
        code="HOU_86",
        label="86",
        description="""House 86//Haus 86""",
    )

    hou_88 = VocabularyTerm(
        code="HOU_88",
        label="88",
        description="""House 88//Haus 88""",
    )

    hou_89 = VocabularyTerm(
        code="HOU_89",
        label="89",
        description="""House 89//Haus 89""",
    )

    hou_90 = VocabularyTerm(
        code="HOU_90",
        label="90",
        description="""House 90//Haus 90""",
    )

    hou_91 = VocabularyTerm(
        code="HOU_91",
        label="91",
        description="""House 91//Haus 91""",
    )

    hou_92_1 = VocabularyTerm(
        code="HOU_92_1",
        label="92.1",
        description="""House 92.1//Haus 92.1""",
    )

    hou_92_2 = VocabularyTerm(
        code="HOU_92_2",
        label="92.2",
        description="""House 92.2//Haus 92.2""",
    )

    hou_93 = VocabularyTerm(
        code="HOU_93",
        label="93",
        description="""House 93//Haus 93""",
    )

    hou_94 = VocabularyTerm(
        code="HOU_94",
        label="94",
        description="""House 94//Haus 94""",
    )

    hou_95 = VocabularyTerm(
        code="HOU_95",
        label="95",
        description="""House 95//Haus 95""",
    )

    hou_96 = VocabularyTerm(
        code="HOU_96",
        label="96",
        description="""House 96//Haus 96""",
    )

    hou_97 = VocabularyTerm(
        code="HOU_97",
        label="97",
        description="""House 97//Haus 97""",
    )

    hou_98 = VocabularyTerm(
        code="HOU_98",
        label="98",
        description="""House 98//Haus 98""",
    )

    hou_101 = VocabularyTerm(
        code="HOU_101",
        label="101",
        description="""House 101//Haus 101""",
    )

    hou_103 = VocabularyTerm(
        code="HOU_103",
        label="103",
        description="""House 103//Haus 103""",
    )

    hou_104 = VocabularyTerm(
        code="HOU_104",
        label="104",
        description="""House 104//Haus 104""",
    )

    hou_105 = VocabularyTerm(
        code="HOU_105",
        label="105",
        description="""House 105//Haus 105""",
    )

    hou_106 = VocabularyTerm(
        code="HOU_106",
        label="106",
        description="""House 106//Haus 106""",
    )

    hou_107 = VocabularyTerm(
        code="HOU_107",
        label="107",
        description="""House 107//Haus 107""",
    )

    hou_108 = VocabularyTerm(
        code="HOU_108",
        label="108",
        description="""House 108//Haus 108""",
    )

    hou_109 = VocabularyTerm(
        code="HOU_109",
        label="109",
        description="""House 109//Haus 109""",
    )

    hou_110 = VocabularyTerm(
        code="HOU_110",
        label="110",
        description="""House 110//Haus 110""",
    )

    hou_111 = VocabularyTerm(
        code="HOU_111",
        label="111",
        description="""House 111//Haus 111""",
    )

    hou_112 = VocabularyTerm(
        code="HOU_112",
        label="112",
        description="""House 112//Haus 112""",
    )

    hou_201 = VocabularyTerm(
        code="HOU_201",
        label="201",
        description="""House 201//Haus 201""",
    )

    hou_202 = VocabularyTerm(
        code="HOU_202",
        label="202",
        description="""House 202//Haus 202""",
    )

    hou_203 = VocabularyTerm(
        code="HOU_203",
        label="203",
        description="""House 203//Haus 203""",
    )

    hou_204 = VocabularyTerm(
        code="HOU_204",
        label="204",
        description="""House 204//Haus 204""",
    )

    hou_205 = VocabularyTerm(
        code="HOU_205",
        label="205",
        description="""House 205//Haus 205""",
    )

    hou_206 = VocabularyTerm(
        code="HOU_206",
        label="206",
        description="""House 206//Haus 206""",
    )

    hou_207 = VocabularyTerm(
        code="HOU_207",
        label="207",
        description="""House 207//Haus 207""",
    )

    hou_208 = VocabularyTerm(
        code="HOU_208",
        label="208",
        description="""House 208//Haus 208""",
    )

    hou_209 = VocabularyTerm(
        code="HOU_209",
        label="209",
        description="""House 209//Haus 209""",
    )

    hou_301 = VocabularyTerm(
        code="HOU_301",
        label="301",
        description="""House 301//Haus 301""",
    )

    hou_302 = VocabularyTerm(
        code="HOU_302",
        label="302",
        description="""House 302//Haus 302""",
    )

    hou_303 = VocabularyTerm(
        code="HOU_303",
        label="303",
        description="""House 303//Haus 303""",
    )

    hou_304 = VocabularyTerm(
        code="HOU_304",
        label="304",
        description="""House 304//Haus 304""",
    )

    hou_305 = VocabularyTerm(
        code="HOU_305",
        label="305",
        description="""House 305//Haus 305""",
    )

    hou_306 = VocabularyTerm(
        code="HOU_306",
        label="306",
        description="""House 306//Haus 306""",
    )

    hou_307 = VocabularyTerm(
        code="HOU_307",
        label="307",
        description="""House 307//Haus 307""",
    )

    hou_308 = VocabularyTerm(
        code="HOU_308",
        label="308",
        description="""House 308//Haus 308""",
    )

    hou_309 = VocabularyTerm(
        code="HOU_309",
        label="309",
        description="""House 309//Haus 309""",
    )

    hou_310 = VocabularyTerm(
        code="HOU_310",
        label="310",
        description="""House 310//Haus 310""",
    )

    hou_311 = VocabularyTerm(
        code="HOU_311",
        label="311",
        description="""House 311//Haus 311""",
    )

    hou_312 = VocabularyTerm(
        code="HOU_312",
        label="312",
        description="""House 312//Haus 312""",
    )

    hou_313 = VocabularyTerm(
        code="HOU_313",
        label="313",
        description="""House 313//Haus 313""",
    )

    hou_314 = VocabularyTerm(
        code="HOU_314",
        label="314",
        description="""House 314//Haus 314""",
    )

    hou_315 = VocabularyTerm(
        code="HOU_315",
        label="315",
        description="""House 315//Haus 315""",
    )

    hou_316 = VocabularyTerm(
        code="HOU_316",
        label="316",
        description="""House 316//Haus 316""",
    )

    hou_317 = VocabularyTerm(
        code="HOU_317",
        label="317",
        description="""House 317//Haus 317""",
    )

    hou_318 = VocabularyTerm(
        code="HOU_318",
        label="318",
        description="""House 318//Haus 318""",
    )

    hou_319 = VocabularyTerm(
        code="HOU_319",
        label="319",
        description="""House 319//Haus 319""",
    )

    hou_320 = VocabularyTerm(
        code="HOU_320",
        label="320",
        description="""House 320//Haus 320""",
    )

    hou_401 = VocabularyTerm(
        code="HOU_401",
        label="401",
        description="""House 401//Haus 401""",
    )

    hou_402 = VocabularyTerm(
        code="HOU_402",
        label="402",
        description="""House 402//Haus 402""",
    )

    hou_411 = VocabularyTerm(
        code="HOU_411",
        label="411",
        description="""House 411//Haus 411""",
    )

    hou_412 = VocabularyTerm(
        code="HOU_412",
        label="412",
        description="""House 412//Haus 412""",
    )

    hou_413 = VocabularyTerm(
        code="HOU_413",
        label="413",
        description="""House 413//Haus 413""",
    )

    hou_414 = VocabularyTerm(
        code="HOU_414",
        label="414",
        description="""House 414//Haus 414""",
    )

    hou_421 = VocabularyTerm(
        code="HOU_421",
        label="421",
        description="""House 421//Haus 421""",
    )

    hou_422 = VocabularyTerm(
        code="HOU_422",
        label="422",
        description="""House 422//Haus 422""",
    )

    hou_423 = VocabularyTerm(
        code="HOU_423",
        label="423",
        description="""House 423//Haus 423""",
    )

    hou_424 = VocabularyTerm(
        code="HOU_424",
        label="424",
        description="""House 424//Haus 424""",
    )

    hou_425 = VocabularyTerm(
        code="HOU_425",
        label="425",
        description="""House 425//Haus 425""",
    )

    hou_426 = VocabularyTerm(
        code="HOU_426",
        label="426",
        description="""House 426//Haus 426""",
    )

    hou_427 = VocabularyTerm(
        code="HOU_427",
        label="427",
        description="""House 427//Haus 427""",
    )

    hou_431 = VocabularyTerm(
        code="HOU_431",
        label="431",
        description="""House 431//Haus 431""",
    )

    hou_432 = VocabularyTerm(
        code="HOU_432",
        label="432",
        description="""House 432//Haus 432""",
    )

    hou_433 = VocabularyTerm(
        code="HOU_433",
        label="433",
        description="""House 433//Haus 433""",
    )

    hou_434 = VocabularyTerm(
        code="HOU_434",
        label="434",
        description="""House 434//Haus 434""",
    )

    hou_441 = VocabularyTerm(
        code="HOU_441",
        label="441",
        description="""House 441//Haus 441""",
    )

    hou_442 = VocabularyTerm(
        code="HOU_442",
        label="442",
        description="""House 442//Haus 442""",
    )

    hou_443 = VocabularyTerm(
        code="HOU_443",
        label="443",
        description="""House 443//Haus 443""",
    )

    hou_444 = VocabularyTerm(
        code="HOU_444",
        label="444",
        description="""House 444//Haus 444""",
    )

    hou_445 = VocabularyTerm(
        code="HOU_445",
        label="445",
        description="""House 445//Haus 445""",
    )

    hou_446 = VocabularyTerm(
        code="HOU_446",
        label="446",
        description="""House 446//Haus 446""",
    )

    hou_447 = VocabularyTerm(
        code="HOU_447",
        label="447",
        description="""House 447//Haus 447""",
    )

    hou_448 = VocabularyTerm(
        code="HOU_448",
        label="448",
        description="""House 448//Haus 448""",
    )

    hou_449 = VocabularyTerm(
        code="HOU_449",
        label="449",
        description="""House 449//Haus 449""",
    )

    hou_451 = VocabularyTerm(
        code="HOU_451",
        label="451",
        description="""House 451//Haus 451""",
    )

    hou_452 = VocabularyTerm(
        code="HOU_452",
        label="452",
        description="""House 452//Haus 452""",
    )

    hou_501 = VocabularyTerm(
        code="HOU_501",
        label="501",
        description="""House 501//Haus 501""",
    )

    hou_507 = VocabularyTerm(
        code="HOU_507",
        label="507",
        description="""House 507//Haus 507""",
    )

    hou_530 = VocabularyTerm(
        code="HOU_530",
        label="530",
        description="""House 530//Haus 530""",
    )

    hou_601 = VocabularyTerm(
        code="HOU_601",
        label="601",
        description="""House 601//Haus 601""",
    )

    hou_602 = VocabularyTerm(
        code="HOU_602",
        label="602",
        description="""House 602//Haus 602""",
    )

    hou_603 = VocabularyTerm(
        code="HOU_603",
        label="603",
        description="""House 603//Haus 603""",
    )

    hou_604 = VocabularyTerm(
        code="HOU_604",
        label="604",
        description="""House 604//Haus 604""",
    )

    hou_bessy = VocabularyTerm(
        code="HOU_BESSY",
        label="BESSY",
        description="""House BESSY//Haus BESSY""",
    )

    hou_ec = VocabularyTerm(
        code="HOU_EC",
        label="EC",
        description="""House EC//Haus EC""",
    )

    hou_zbu = VocabularyTerm(
        code="HOU_ZBU",
        label="ZBU",
        description="""House ZBU//Haus ZBU""",
    )


class BamLocation(VocabularyType):
    defs = VocabularyTypeDef(
        code="BAM_LOCATION",
        description="""BAM Location//BAM Standort/Liegenschaft""",
    )

    loc_ah = VocabularyTerm(
        code="LOC_AH",
        label="AH",
        description="""BAM Branch Adlershof//BAM Zweiggelände Adlershof""",
    )

    loc_ahm = VocabularyTerm(
        code="LOC_AHM",
        label="AHM",
        description="""BAM Branch Adlershof rental object Europa-Center//BAM Zweiggelände Adlershof Mietobjekt Europa-Center""",
    )

    loc_fb = VocabularyTerm(
        code="LOC_FB",
        label="FB",
        description="""BAM Branch Fabeckstraße//BAM Zweiggelände Fabeckstraße""",
    )

    loc_tts = VocabularyTerm(
        code="LOC_TTS",
        label="TTS",
        description="""BAM Test Site for Technical Safety in Horstwalde//BAM Testgelände Technische Sicherheit in Horstwalde""",
    )

    loc_ue = VocabularyTerm(
        code="LOC_UE",
        label="UE",
        description="""BAM Headquarters Unter den Eichen//BAM Stammgelände Unter den Eichen""",
    )

    loc_uem = VocabularyTerm(
        code="LOC_UEM",
        label="UEM",
        description="""BAM Headquarters Unter den Eichen rental object//BAM Stammgelände Unter den Eichen Mietobjekt""",
    )


class BamLocationComplete(VocabularyType):
    defs = VocabularyTypeDef(
        code="BAM_LOCATION_COMPLETE",
        description="""Complete location (up to room level)//Komplette Ortsangabe (bis Raumlevel)""",
    )

    ahm_bessy_0_100 = VocabularyTerm(
        code="AHM_BESSY_0_100",
        label="AHM/BESSY/0/100",
        description="""AHM/BESSY/0/100""",
    )

    ahm_ec_4_og_401 = VocabularyTerm(
        code="AHM_EC_4_OG_401",
        label="AHM/EC/4.OG/401",
        description="""AHM/EC/4.OG/401""",
    )

    ahm_ec_4_og_402 = VocabularyTerm(
        code="AHM_EC_4_OG_402",
        label="AHM/EC/4.OG/402",
        description="""AHM/EC/4.OG/402""",
    )

    ahm_ec_4_og_403 = VocabularyTerm(
        code="AHM_EC_4_OG_403",
        label="AHM/EC/4.OG/403",
        description="""AHM/EC/4.OG/403""",
    )

    ahm_ec_4_og_405 = VocabularyTerm(
        code="AHM_EC_4_OG_405",
        label="AHM/EC/4.OG/405",
        description="""AHM/EC/4.OG/405""",
    )

    ahm_ec_4_og_406 = VocabularyTerm(
        code="AHM_EC_4_OG_406",
        label="AHM/EC/4.OG/406",
        description="""AHM/EC/4.OG/406""",
    )

    ahm_ec_4_og_407 = VocabularyTerm(
        code="AHM_EC_4_OG_407",
        label="AHM/EC/4.OG/407",
        description="""AHM/EC/4.OG/407""",
    )

    ahm_ec_4_og_407d = VocabularyTerm(
        code="AHM_EC_4_OG_407D",
        label="AHM/EC/4.OG/407D",
        description="""AHM/EC/4.OG/407D""",
    )

    ahm_ec_4_og_407f = VocabularyTerm(
        code="AHM_EC_4_OG_407F",
        label="AHM/EC/4.OG/407F",
        description="""AHM/EC/4.OG/407F""",
    )

    ahm_ec_4_og_407h = VocabularyTerm(
        code="AHM_EC_4_OG_407H",
        label="AHM/EC/4.OG/407H",
        description="""AHM/EC/4.OG/407H""",
    )

    ahm_ec_4_og_407t = VocabularyTerm(
        code="AHM_EC_4_OG_407T",
        label="AHM/EC/4.OG/407T",
        description="""AHM/EC/4.OG/407T""",
    )

    ahm_ec_4_og_408 = VocabularyTerm(
        code="AHM_EC_4_OG_408",
        label="AHM/EC/4.OG/408",
        description="""AHM/EC/4.OG/408""",
    )

    ahm_ec_4_og_410 = VocabularyTerm(
        code="AHM_EC_4_OG_410",
        label="AHM/EC/4.OG/410",
        description="""AHM/EC/4.OG/410""",
    )

    ahm_ec_4_og_411 = VocabularyTerm(
        code="AHM_EC_4_OG_411",
        label="AHM/EC/4.OG/411",
        description="""AHM/EC/4.OG/411""",
    )

    ahm_ec_4_og_412 = VocabularyTerm(
        code="AHM_EC_4_OG_412",
        label="AHM/EC/4.OG/412",
        description="""AHM/EC/4.OG/412""",
    )

    ahm_ec_4_og_413 = VocabularyTerm(
        code="AHM_EC_4_OG_413",
        label="AHM/EC/4.OG/413",
        description="""AHM/EC/4.OG/413""",
    )

    ahm_ec_4_og_414 = VocabularyTerm(
        code="AHM_EC_4_OG_414",
        label="AHM/EC/4.OG/414",
        description="""AHM/EC/4.OG/414""",
    )

    ahm_ec_4_og_415 = VocabularyTerm(
        code="AHM_EC_4_OG_415",
        label="AHM/EC/4.OG/415",
        description="""AHM/EC/4.OG/415""",
    )

    ahm_ec_4_og_416 = VocabularyTerm(
        code="AHM_EC_4_OG_416",
        label="AHM/EC/4.OG/416",
        description="""AHM/EC/4.OG/416""",
    )

    ahm_ec_4_og_417 = VocabularyTerm(
        code="AHM_EC_4_OG_417",
        label="AHM/EC/4.OG/417",
        description="""AHM/EC/4.OG/417""",
    )

    ahm_ec_4_og_418 = VocabularyTerm(
        code="AHM_EC_4_OG_418",
        label="AHM/EC/4.OG/418",
        description="""AHM/EC/4.OG/418""",
    )

    ahm_ec_4_og_419 = VocabularyTerm(
        code="AHM_EC_4_OG_419",
        label="AHM/EC/4.OG/419",
        description="""AHM/EC/4.OG/419""",
    )

    ahm_ec_4_og_420 = VocabularyTerm(
        code="AHM_EC_4_OG_420",
        label="AHM/EC/4.OG/420",
        description="""AHM/EC/4.OG/420""",
    )

    ahm_ec_4_og_421 = VocabularyTerm(
        code="AHM_EC_4_OG_421",
        label="AHM/EC/4.OG/421",
        description="""AHM/EC/4.OG/421""",
    )

    ahm_ec_4_og_422 = VocabularyTerm(
        code="AHM_EC_4_OG_422",
        label="AHM/EC/4.OG/422",
        description="""AHM/EC/4.OG/422""",
    )

    ahm_ec_4_og_423 = VocabularyTerm(
        code="AHM_EC_4_OG_423",
        label="AHM/EC/4.OG/423",
        description="""AHM/EC/4.OG/423""",
    )

    ahm_ec_4_og_424 = VocabularyTerm(
        code="AHM_EC_4_OG_424",
        label="AHM/EC/4.OG/424",
        description="""AHM/EC/4.OG/424""",
    )

    ahm_ec_4_og_425 = VocabularyTerm(
        code="AHM_EC_4_OG_425",
        label="AHM/EC/4.OG/425",
        description="""AHM/EC/4.OG/425""",
    )

    ahm_ec_4_og_426 = VocabularyTerm(
        code="AHM_EC_4_OG_426",
        label="AHM/EC/4.OG/426",
        description="""AHM/EC/4.OG/426""",
    )

    ahm_ec_4_og_427 = VocabularyTerm(
        code="AHM_EC_4_OG_427",
        label="AHM/EC/4.OG/427",
        description="""AHM/EC/4.OG/427""",
    )

    ahm_ec_4_og_428 = VocabularyTerm(
        code="AHM_EC_4_OG_428",
        label="AHM/EC/4.OG/428",
        description="""AHM/EC/4.OG/428""",
    )

    ahm_ec_4_og_429 = VocabularyTerm(
        code="AHM_EC_4_OG_429",
        label="AHM/EC/4.OG/429",
        description="""AHM/EC/4.OG/429""",
    )

    ahm_ec_4_og_430 = VocabularyTerm(
        code="AHM_EC_4_OG_430",
        label="AHM/EC/4.OG/430",
        description="""AHM/EC/4.OG/430""",
    )

    ahm_ec_4_og_431 = VocabularyTerm(
        code="AHM_EC_4_OG_431",
        label="AHM/EC/4.OG/431",
        description="""AHM/EC/4.OG/431""",
    )

    ahm_ec_4_og_431d = VocabularyTerm(
        code="AHM_EC_4_OG_431D",
        label="AHM/EC/4.OG/431D",
        description="""AHM/EC/4.OG/431D""",
    )

    ahm_ec_4_og_431f = VocabularyTerm(
        code="AHM_EC_4_OG_431F",
        label="AHM/EC/4.OG/431F",
        description="""AHM/EC/4.OG/431F""",
    )

    ahm_ec_4_og_431h = VocabularyTerm(
        code="AHM_EC_4_OG_431H",
        label="AHM/EC/4.OG/431H",
        description="""AHM/EC/4.OG/431H""",
    )

    ahm_ec_4_og_a1 = VocabularyTerm(
        code="AHM_EC_4_OG_A1",
        label="AHM/EC/4.OG/A1",
        description="""AHM/EC/4.OG/A1""",
    )

    ahm_ec_4_og_a2 = VocabularyTerm(
        code="AHM_EC_4_OG_A2",
        label="AHM/EC/4.OG/A2",
        description="""AHM/EC/4.OG/A2""",
    )

    ahm_ec_5_og_501 = VocabularyTerm(
        code="AHM_EC_5_OG_501",
        label="AHM/EC/5.OG/501",
        description="""AHM/EC/5.OG/501""",
    )

    ahm_ec_5_og_502 = VocabularyTerm(
        code="AHM_EC_5_OG_502",
        label="AHM/EC/5.OG/502",
        description="""AHM/EC/5.OG/502""",
    )

    ahm_ec_5_og_503 = VocabularyTerm(
        code="AHM_EC_5_OG_503",
        label="AHM/EC/5.OG/503",
        description="""AHM/EC/5.OG/503""",
    )

    ahm_ec_5_og_504 = VocabularyTerm(
        code="AHM_EC_5_OG_504",
        label="AHM/EC/5.OG/504",
        description="""AHM/EC/5.OG/504""",
    )

    ahm_ec_5_og_505 = VocabularyTerm(
        code="AHM_EC_5_OG_505",
        label="AHM/EC/5.OG/505",
        description="""AHM/EC/5.OG/505""",
    )

    ahm_ec_5_og_505d = VocabularyTerm(
        code="AHM_EC_5_OG_505D",
        label="AHM/EC/5.OG/505D",
        description="""AHM/EC/5.OG/505D""",
    )

    ahm_ec_5_og_505f = VocabularyTerm(
        code="AHM_EC_5_OG_505F",
        label="AHM/EC/5.OG/505F",
        description="""AHM/EC/5.OG/505F""",
    )

    ahm_ec_5_og_505h = VocabularyTerm(
        code="AHM_EC_5_OG_505H",
        label="AHM/EC/5.OG/505H",
        description="""AHM/EC/5.OG/505H""",
    )

    ahm_ec_5_og_505t = VocabularyTerm(
        code="AHM_EC_5_OG_505T",
        label="AHM/EC/5.OG/505T",
        description="""AHM/EC/5.OG/505T""",
    )

    ahm_ec_5_og_506 = VocabularyTerm(
        code="AHM_EC_5_OG_506",
        label="AHM/EC/5.OG/506",
        description="""AHM/EC/5.OG/506""",
    )

    ahm_ec_5_og_507 = VocabularyTerm(
        code="AHM_EC_5_OG_507",
        label="AHM/EC/5.OG/507",
        description="""AHM/EC/5.OG/507""",
    )

    ahm_ec_5_og_508 = VocabularyTerm(
        code="AHM_EC_5_OG_508",
        label="AHM/EC/5.OG/508",
        description="""AHM/EC/5.OG/508""",
    )

    ahm_ec_5_og_509 = VocabularyTerm(
        code="AHM_EC_5_OG_509",
        label="AHM/EC/5.OG/509",
        description="""AHM/EC/5.OG/509""",
    )

    ahm_ec_5_og_510 = VocabularyTerm(
        code="AHM_EC_5_OG_510",
        label="AHM/EC/5.OG/510",
        description="""AHM/EC/5.OG/510""",
    )

    ahm_ec_5_og_511 = VocabularyTerm(
        code="AHM_EC_5_OG_511",
        label="AHM/EC/5.OG/511",
        description="""AHM/EC/5.OG/511""",
    )

    ahm_ec_5_og_512 = VocabularyTerm(
        code="AHM_EC_5_OG_512",
        label="AHM/EC/5.OG/512",
        description="""AHM/EC/5.OG/512""",
    )

    ahm_ec_5_og_513 = VocabularyTerm(
        code="AHM_EC_5_OG_513",
        label="AHM/EC/5.OG/513",
        description="""AHM/EC/5.OG/513""",
    )

    ahm_ec_5_og_514 = VocabularyTerm(
        code="AHM_EC_5_OG_514",
        label="AHM/EC/5.OG/514",
        description="""AHM/EC/5.OG/514""",
    )

    ahm_ec_5_og_515 = VocabularyTerm(
        code="AHM_EC_5_OG_515",
        label="AHM/EC/5.OG/515",
        description="""AHM/EC/5.OG/515""",
    )

    ahm_ec_5_og_516 = VocabularyTerm(
        code="AHM_EC_5_OG_516",
        label="AHM/EC/5.OG/516",
        description="""AHM/EC/5.OG/516""",
    )

    ahm_ec_5_og_517 = VocabularyTerm(
        code="AHM_EC_5_OG_517",
        label="AHM/EC/5.OG/517",
        description="""AHM/EC/5.OG/517""",
    )

    ahm_ec_5_og_519 = VocabularyTerm(
        code="AHM_EC_5_OG_519",
        label="AHM/EC/5.OG/519",
        description="""AHM/EC/5.OG/519""",
    )

    ahm_ec_5_og_520 = VocabularyTerm(
        code="AHM_EC_5_OG_520",
        label="AHM/EC/5.OG/520",
        description="""AHM/EC/5.OG/520""",
    )

    ahm_ec_5_og_521 = VocabularyTerm(
        code="AHM_EC_5_OG_521",
        label="AHM/EC/5.OG/521",
        description="""AHM/EC/5.OG/521""",
    )

    ahm_ec_5_og_522 = VocabularyTerm(
        code="AHM_EC_5_OG_522",
        label="AHM/EC/5.OG/522",
        description="""AHM/EC/5.OG/522""",
    )

    ahm_ec_5_og_523 = VocabularyTerm(
        code="AHM_EC_5_OG_523",
        label="AHM/EC/5.OG/523",
        description="""AHM/EC/5.OG/523""",
    )

    ahm_ec_5_og_523d = VocabularyTerm(
        code="AHM_EC_5_OG_523D",
        label="AHM/EC/5.OG/523D",
        description="""AHM/EC/5.OG/523D""",
    )

    ahm_ec_5_og_523f = VocabularyTerm(
        code="AHM_EC_5_OG_523F",
        label="AHM/EC/5.OG/523F",
        description="""AHM/EC/5.OG/523F""",
    )

    ahm_ec_5_og_523h = VocabularyTerm(
        code="AHM_EC_5_OG_523H",
        label="AHM/EC/5.OG/523H",
        description="""AHM/EC/5.OG/523H""",
    )

    ahm_ec_5_og_a1 = VocabularyTerm(
        code="AHM_EC_5_OG_A1",
        label="AHM/EC/5.OG/A1",
        description="""AHM/EC/5.OG/A1""",
    )

    ahm_ec_5_og_a2 = VocabularyTerm(
        code="AHM_EC_5_OG_A2",
        label="AHM/EC/5.OG/A2",
        description="""AHM/EC/5.OG/A2""",
    )

    ahm_zbu_0_220 = VocabularyTerm(
        code="AHM_ZBU_0_220",
        label="AHM/ZBU/0/220",
        description="""AHM/ZBU/0/220""",
    )

    ahm_zbu_0_222 = VocabularyTerm(
        code="AHM_ZBU_0_222",
        label="AHM/ZBU/0/222",
        description="""AHM/ZBU/0/222""",
    )

    ahm_zbu_0_239 = VocabularyTerm(
        code="AHM_ZBU_0_239",
        label="AHM/ZBU/0/239",
        description="""AHM/ZBU/0/239""",
    )

    ahm_zbu_0_241 = VocabularyTerm(
        code="AHM_ZBU_0_241",
        label="AHM/ZBU/0/241",
        description="""AHM/ZBU/0/241""",
    )

    ah_8_01_0_100f = VocabularyTerm(
        code="AH_8_01_0_100F",
        label="AH/8.01/0/100F",
        description="""AH/8.01/0/100F""",
    )

    ah_8_01_0_100t = VocabularyTerm(
        code="AH_8_01_0_100T",
        label="AH/8.01/0/100T",
        description="""AH/8.01/0/100T""",
    )

    ah_8_01_0_101 = VocabularyTerm(
        code="AH_8_01_0_101",
        label="AH/8.01/0/101",
        description="""AH/8.01/0/101""",
    )

    ah_8_01_0_102b = VocabularyTerm(
        code="AH_8_01_0_102B",
        label="AH/8.01/0/102B",
        description="""AH/8.01/0/102B""",
    )

    ah_8_01_0_103 = VocabularyTerm(
        code="AH_8_01_0_103",
        label="AH/8.01/0/103",
        description="""AH/8.01/0/103""",
    )

    ah_8_01_0_104 = VocabularyTerm(
        code="AH_8_01_0_104",
        label="AH/8.01/0/104",
        description="""AH/8.01/0/104""",
    )

    ah_8_01_0_105 = VocabularyTerm(
        code="AH_8_01_0_105",
        label="AH/8.01/0/105",
        description="""AH/8.01/0/105""",
    )

    ah_8_01_0_106 = VocabularyTerm(
        code="AH_8_01_0_106",
        label="AH/8.01/0/106",
        description="""AH/8.01/0/106""",
    )

    ah_8_01_0_107 = VocabularyTerm(
        code="AH_8_01_0_107",
        label="AH/8.01/0/107",
        description="""AH/8.01/0/107""",
    )

    ah_8_01_0_108 = VocabularyTerm(
        code="AH_8_01_0_108",
        label="AH/8.01/0/108",
        description="""AH/8.01/0/108""",
    )

    ah_8_01_0_110 = VocabularyTerm(
        code="AH_8_01_0_110",
        label="AH/8.01/0/110",
        description="""AH/8.01/0/110""",
    )

    ah_8_01_0_113 = VocabularyTerm(
        code="AH_8_01_0_113",
        label="AH/8.01/0/113",
        description="""AH/8.01/0/113""",
    )

    ah_8_01_0_115 = VocabularyTerm(
        code="AH_8_01_0_115",
        label="AH/8.01/0/115",
        description="""AH/8.01/0/115""",
    )

    ah_8_01_0_116 = VocabularyTerm(
        code="AH_8_01_0_116",
        label="AH/8.01/0/116",
        description="""AH/8.01/0/116""",
    )

    ah_8_01_0_117 = VocabularyTerm(
        code="AH_8_01_0_117",
        label="AH/8.01/0/117",
        description="""AH/8.01/0/117""",
    )

    ah_8_01_0_119 = VocabularyTerm(
        code="AH_8_01_0_119",
        label="AH/8.01/0/119",
        description="""AH/8.01/0/119""",
    )

    ah_8_01_0_120 = VocabularyTerm(
        code="AH_8_01_0_120",
        label="AH/8.01/0/120",
        description="""AH/8.01/0/120""",
    )

    ah_8_01_0_121 = VocabularyTerm(
        code="AH_8_01_0_121",
        label="AH/8.01/0/121",
        description="""AH/8.01/0/121""",
    )

    ah_8_01_0_123 = VocabularyTerm(
        code="AH_8_01_0_123",
        label="AH/8.01/0/123",
        description="""AH/8.01/0/123""",
    )

    ah_8_01_0_124 = VocabularyTerm(
        code="AH_8_01_0_124",
        label="AH/8.01/0/124",
        description="""AH/8.01/0/124""",
    )

    ah_8_01_0_125 = VocabularyTerm(
        code="AH_8_01_0_125",
        label="AH/8.01/0/125",
        description="""AH/8.01/0/125""",
    )

    ah_8_01_0_126f = VocabularyTerm(
        code="AH_8_01_0_126F",
        label="AH/8.01/0/126F",
        description="""AH/8.01/0/126F""",
    )

    ah_8_01_0_126t = VocabularyTerm(
        code="AH_8_01_0_126T",
        label="AH/8.01/0/126T",
        description="""AH/8.01/0/126T""",
    )

    ah_8_01_0_128dh = VocabularyTerm(
        code="AH_8_01_0_128DH",
        label="AH/8.01/0/128DH",
        description="""AH/8.01/0/128DH""",
    )

    ah_8_01_0_aufzug = VocabularyTerm(
        code="AH_8_01_0_AUFZUG",
        label="AH/8.01/0/AUFZUG",
        description="""AH/8.01/0/AUFZUG""",
    )

    ah_8_01_1_200f = VocabularyTerm(
        code="AH_8_01_1_200F",
        label="AH/8.01/1/200F",
        description="""AH/8.01/1/200F""",
    )

    ah_8_01_1_200t = VocabularyTerm(
        code="AH_8_01_1_200T",
        label="AH/8.01/1/200T",
        description="""AH/8.01/1/200T""",
    )

    ah_8_01_1_201 = VocabularyTerm(
        code="AH_8_01_1_201",
        label="AH/8.01/1/201",
        description="""AH/8.01/1/201""",
    )

    ah_8_01_1_203 = VocabularyTerm(
        code="AH_8_01_1_203",
        label="AH/8.01/1/203",
        description="""AH/8.01/1/203""",
    )

    ah_8_01_1_204 = VocabularyTerm(
        code="AH_8_01_1_204",
        label="AH/8.01/1/204",
        description="""AH/8.01/1/204""",
    )

    ah_8_01_1_205 = VocabularyTerm(
        code="AH_8_01_1_205",
        label="AH/8.01/1/205",
        description="""AH/8.01/1/205""",
    )

    ah_8_01_1_206 = VocabularyTerm(
        code="AH_8_01_1_206",
        label="AH/8.01/1/206",
        description="""AH/8.01/1/206""",
    )

    ah_8_01_1_207 = VocabularyTerm(
        code="AH_8_01_1_207",
        label="AH/8.01/1/207",
        description="""AH/8.01/1/207""",
    )

    ah_8_01_1_210d = VocabularyTerm(
        code="AH_8_01_1_210D",
        label="AH/8.01/1/210D",
        description="""AH/8.01/1/210D""",
    )

    ah_8_01_1_213 = VocabularyTerm(
        code="AH_8_01_1_213",
        label="AH/8.01/1/213",
        description="""AH/8.01/1/213""",
    )

    ah_8_01_1_214 = VocabularyTerm(
        code="AH_8_01_1_214",
        label="AH/8.01/1/214",
        description="""AH/8.01/1/214""",
    )

    ah_8_01_1_215 = VocabularyTerm(
        code="AH_8_01_1_215",
        label="AH/8.01/1/215",
        description="""AH/8.01/1/215""",
    )

    ah_8_01_1_216 = VocabularyTerm(
        code="AH_8_01_1_216",
        label="AH/8.01/1/216",
        description="""AH/8.01/1/216""",
    )

    ah_8_01_1_217 = VocabularyTerm(
        code="AH_8_01_1_217",
        label="AH/8.01/1/217",
        description="""AH/8.01/1/217""",
    )

    ah_8_01_1_219 = VocabularyTerm(
        code="AH_8_01_1_219",
        label="AH/8.01/1/219",
        description="""AH/8.01/1/219""",
    )

    ah_8_01_1_220h = VocabularyTerm(
        code="AH_8_01_1_220H",
        label="AH/8.01/1/220H",
        description="""AH/8.01/1/220H""",
    )

    ah_8_01_1_221 = VocabularyTerm(
        code="AH_8_01_1_221",
        label="AH/8.01/1/221",
        description="""AH/8.01/1/221""",
    )

    ah_8_01_1_222 = VocabularyTerm(
        code="AH_8_01_1_222",
        label="AH/8.01/1/222",
        description="""AH/8.01/1/222""",
    )

    ah_8_01_1_224 = VocabularyTerm(
        code="AH_8_01_1_224",
        label="AH/8.01/1/224",
        description="""AH/8.01/1/224""",
    )

    ah_8_01_1_225 = VocabularyTerm(
        code="AH_8_01_1_225",
        label="AH/8.01/1/225",
        description="""AH/8.01/1/225""",
    )

    ah_8_01_1_226f = VocabularyTerm(
        code="AH_8_01_1_226F",
        label="AH/8.01/1/226F",
        description="""AH/8.01/1/226F""",
    )

    ah_8_01_1_226t = VocabularyTerm(
        code="AH_8_01_1_226T",
        label="AH/8.01/1/226T",
        description="""AH/8.01/1/226T""",
    )

    ah_8_01_1_228 = VocabularyTerm(
        code="AH_8_01_1_228",
        label="AH/8.01/1/228",
        description="""AH/8.01/1/228""",
    )

    ah_8_01_1_228b = VocabularyTerm(
        code="AH_8_01_1_228B",
        label="AH/8.01/1/228B",
        description="""AH/8.01/1/228B""",
    )

    ah_8_01_1_aufzug = VocabularyTerm(
        code="AH_8_01_1_AUFZUG",
        label="AH/8.01/1/AUFZUG",
        description="""AH/8.01/1/AUFZUG""",
    )

    ah_8_01_2_300f = VocabularyTerm(
        code="AH_8_01_2_300F",
        label="AH/8.01/2/300F",
        description="""AH/8.01/2/300F""",
    )

    ah_8_01_2_300t = VocabularyTerm(
        code="AH_8_01_2_300T",
        label="AH/8.01/2/300T",
        description="""AH/8.01/2/300T""",
    )

    ah_8_01_2_301 = VocabularyTerm(
        code="AH_8_01_2_301",
        label="AH/8.01/2/301",
        description="""AH/8.01/2/301""",
    )

    ah_8_01_2_303 = VocabularyTerm(
        code="AH_8_01_2_303",
        label="AH/8.01/2/303",
        description="""AH/8.01/2/303""",
    )

    ah_8_01_2_304 = VocabularyTerm(
        code="AH_8_01_2_304",
        label="AH/8.01/2/304",
        description="""AH/8.01/2/304""",
    )

    ah_8_01_2_305 = VocabularyTerm(
        code="AH_8_01_2_305",
        label="AH/8.01/2/305",
        description="""AH/8.01/2/305""",
    )

    ah_8_01_2_306 = VocabularyTerm(
        code="AH_8_01_2_306",
        label="AH/8.01/2/306",
        description="""AH/8.01/2/306""",
    )

    ah_8_01_2_307 = VocabularyTerm(
        code="AH_8_01_2_307",
        label="AH/8.01/2/307",
        description="""AH/8.01/2/307""",
    )

    ah_8_01_2_309 = VocabularyTerm(
        code="AH_8_01_2_309",
        label="AH/8.01/2/309",
        description="""AH/8.01/2/309""",
    )

    ah_8_01_2_310d = VocabularyTerm(
        code="AH_8_01_2_310D",
        label="AH/8.01/2/310D",
        description="""AH/8.01/2/310D""",
    )

    ah_8_01_2_313 = VocabularyTerm(
        code="AH_8_01_2_313",
        label="AH/8.01/2/313",
        description="""AH/8.01/2/313""",
    )

    ah_8_01_2_314 = VocabularyTerm(
        code="AH_8_01_2_314",
        label="AH/8.01/2/314",
        description="""AH/8.01/2/314""",
    )

    ah_8_01_2_315 = VocabularyTerm(
        code="AH_8_01_2_315",
        label="AH/8.01/2/315",
        description="""AH/8.01/2/315""",
    )

    ah_8_01_2_316 = VocabularyTerm(
        code="AH_8_01_2_316",
        label="AH/8.01/2/316",
        description="""AH/8.01/2/316""",
    )

    ah_8_01_2_317 = VocabularyTerm(
        code="AH_8_01_2_317",
        label="AH/8.01/2/317",
        description="""AH/8.01/2/317""",
    )

    ah_8_01_2_319 = VocabularyTerm(
        code="AH_8_01_2_319",
        label="AH/8.01/2/319",
        description="""AH/8.01/2/319""",
    )

    ah_8_01_2_320h = VocabularyTerm(
        code="AH_8_01_2_320H",
        label="AH/8.01/2/320H",
        description="""AH/8.01/2/320H""",
    )

    ah_8_01_2_321 = VocabularyTerm(
        code="AH_8_01_2_321",
        label="AH/8.01/2/321",
        description="""AH/8.01/2/321""",
    )

    ah_8_01_2_322 = VocabularyTerm(
        code="AH_8_01_2_322",
        label="AH/8.01/2/322",
        description="""AH/8.01/2/322""",
    )

    ah_8_01_2_324 = VocabularyTerm(
        code="AH_8_01_2_324",
        label="AH/8.01/2/324",
        description="""AH/8.01/2/324""",
    )

    ah_8_01_2_325 = VocabularyTerm(
        code="AH_8_01_2_325",
        label="AH/8.01/2/325",
        description="""AH/8.01/2/325""",
    )

    ah_8_01_2_326f = VocabularyTerm(
        code="AH_8_01_2_326F",
        label="AH/8.01/2/326F",
        description="""AH/8.01/2/326F""",
    )

    ah_8_01_2_326t = VocabularyTerm(
        code="AH_8_01_2_326T",
        label="AH/8.01/2/326T",
        description="""AH/8.01/2/326T""",
    )

    ah_8_01_2_328t = VocabularyTerm(
        code="AH_8_01_2_328T",
        label="AH/8.01/2/328T",
        description="""AH/8.01/2/328T""",
    )

    ah_8_01_2_aufzug = VocabularyTerm(
        code="AH_8_01_2_AUFZUG",
        label="AH/8.01/2/AUFZUG",
        description="""AH/8.01/2/AUFZUG""",
    )

    ah_8_01_3_400 = VocabularyTerm(
        code="AH_8_01_3_400",
        label="AH/8.01/3/400",
        description="""AH/8.01/3/400""",
    )

    ah_8_01_3_428t = VocabularyTerm(
        code="AH_8_01_3_428T",
        label="AH/8.01/3/428T",
        description="""AH/8.01/3/428T""",
    )

    ah_8_02_0_101 = VocabularyTerm(
        code="AH_8_02_0_101",
        label="AH/8.02/0/101",
        description="""AH/8.02/0/101""",
    )

    ah_8_02_0_102 = VocabularyTerm(
        code="AH_8_02_0_102",
        label="AH/8.02/0/102",
        description="""AH/8.02/0/102""",
    )

    ah_8_02_0_103 = VocabularyTerm(
        code="AH_8_02_0_103",
        label="AH/8.02/0/103",
        description="""AH/8.02/0/103""",
    )

    ah_8_02_0_104 = VocabularyTerm(
        code="AH_8_02_0_104",
        label="AH/8.02/0/104",
        description="""AH/8.02/0/104""",
    )

    ah_8_02_0_105 = VocabularyTerm(
        code="AH_8_02_0_105",
        label="AH/8.02/0/105",
        description="""AH/8.02/0/105""",
    )

    ah_8_03_0_100 = VocabularyTerm(
        code="AH_8_03_0_100",
        label="AH/8.03/0/100",
        description="""AH/8.03/0/100""",
    )

    ah_8_03_0_101 = VocabularyTerm(
        code="AH_8_03_0_101",
        label="AH/8.03/0/101",
        description="""AH/8.03/0/101""",
    )

    ah_8_03_0_102 = VocabularyTerm(
        code="AH_8_03_0_102",
        label="AH/8.03/0/102",
        description="""AH/8.03/0/102""",
    )

    ah_8_03_0_103 = VocabularyTerm(
        code="AH_8_03_0_103",
        label="AH/8.03/0/103",
        description="""AH/8.03/0/103""",
    )

    ah_8_03_0_104 = VocabularyTerm(
        code="AH_8_03_0_104",
        label="AH/8.03/0/104",
        description="""AH/8.03/0/104""",
    )

    ah_8_03_0_105 = VocabularyTerm(
        code="AH_8_03_0_105",
        label="AH/8.03/0/105",
        description="""AH/8.03/0/105""",
    )

    ah_8_05_0_eg_100a1 = VocabularyTerm(
        code="AH_8_05_0_EG_100A1",
        label="AH/8.05/0/EG.100A1",
        description="""AH/8.05/0/EG.100A1""",
    )

    ah_8_05_0_eg_100f = VocabularyTerm(
        code="AH_8_05_0_EG_100F",
        label="AH/8.05/0/EG.100F",
        description="""AH/8.05/0/EG.100F""",
    )

    ah_8_05_0_eg_100t = VocabularyTerm(
        code="AH_8_05_0_EG_100T",
        label="AH/8.05/0/EG.100T",
        description="""AH/8.05/0/EG.100T""",
    )

    ah_8_05_0_eg_101f = VocabularyTerm(
        code="AH_8_05_0_EG_101F",
        label="AH/8.05/0/EG.101F",
        description="""AH/8.05/0/EG.101F""",
    )

    ah_8_05_0_eg_104 = VocabularyTerm(
        code="AH_8_05_0_EG_104",
        label="AH/8.05/0/EG.104",
        description="""AH/8.05/0/EG.104""",
    )

    ah_8_05_0_eg_105 = VocabularyTerm(
        code="AH_8_05_0_EG_105",
        label="AH/8.05/0/EG.105",
        description="""AH/8.05/0/EG.105""",
    )

    ah_8_05_0_eg_106 = VocabularyTerm(
        code="AH_8_05_0_EG_106",
        label="AH/8.05/0/EG.106",
        description="""AH/8.05/0/EG.106""",
    )

    ah_8_05_0_eg_107f = VocabularyTerm(
        code="AH_8_05_0_EG_107F",
        label="AH/8.05/0/EG.107F",
        description="""AH/8.05/0/EG.107F""",
    )

    ah_8_05_0_eg_108 = VocabularyTerm(
        code="AH_8_05_0_EG_108",
        label="AH/8.05/0/EG.108",
        description="""AH/8.05/0/EG.108""",
    )

    ah_8_05_0_eg_108b = VocabularyTerm(
        code="AH_8_05_0_EG_108B",
        label="AH/8.05/0/EG.108B",
        description="""AH/8.05/0/EG.108B""",
    )

    ah_8_05_0_eg_109 = VocabularyTerm(
        code="AH_8_05_0_EG_109",
        label="AH/8.05/0/EG.109",
        description="""AH/8.05/0/EG.109""",
    )

    ah_8_05_0_eg_113 = VocabularyTerm(
        code="AH_8_05_0_EG_113",
        label="AH/8.05/0/EG.113",
        description="""AH/8.05/0/EG.113""",
    )

    ah_8_05_0_eg_115 = VocabularyTerm(
        code="AH_8_05_0_EG_115",
        label="AH/8.05/0/EG.115",
        description="""AH/8.05/0/EG.115""",
    )

    ah_8_05_0_eg_117 = VocabularyTerm(
        code="AH_8_05_0_EG_117",
        label="AH/8.05/0/EG.117",
        description="""AH/8.05/0/EG.117""",
    )

    ah_8_05_0_eg_118a2 = VocabularyTerm(
        code="AH_8_05_0_EG_118A2",
        label="AH/8.05/0/EG.118A2",
        description="""AH/8.05/0/EG.118A2""",
    )

    ah_8_05_0_eg_118f = VocabularyTerm(
        code="AH_8_05_0_EG_118F",
        label="AH/8.05/0/EG.118F",
        description="""AH/8.05/0/EG.118F""",
    )

    ah_8_05_0_eg_119 = VocabularyTerm(
        code="AH_8_05_0_EG_119",
        label="AH/8.05/0/EG.119",
        description="""AH/8.05/0/EG.119""",
    )

    ah_8_05_0_eg_121f = VocabularyTerm(
        code="AH_8_05_0_EG_121F",
        label="AH/8.05/0/EG.121F",
        description="""AH/8.05/0/EG.121F""",
    )

    ah_8_05_0_eg_122 = VocabularyTerm(
        code="AH_8_05_0_EG_122",
        label="AH/8.05/0/EG.122",
        description="""AH/8.05/0/EG.122""",
    )

    ah_8_05_0_eg_125c = VocabularyTerm(
        code="AH_8_05_0_EG_125C",
        label="AH/8.05/0/EG.125C",
        description="""AH/8.05/0/EG.125C""",
    )

    ah_8_05_0_eg_128 = VocabularyTerm(
        code="AH_8_05_0_EG_128",
        label="AH/8.05/0/EG.128",
        description="""AH/8.05/0/EG.128""",
    )

    ah_8_05_0_eg_128b = VocabularyTerm(
        code="AH_8_05_0_EG_128B",
        label="AH/8.05/0/EG.128B",
        description="""AH/8.05/0/EG.128B""",
    )

    ah_8_05_0_eg_128c = VocabularyTerm(
        code="AH_8_05_0_EG_128C",
        label="AH/8.05/0/EG.128C",
        description="""AH/8.05/0/EG.128C""",
    )

    ah_8_05_0_eg_129 = VocabularyTerm(
        code="AH_8_05_0_EG_129",
        label="AH/8.05/0/EG.129",
        description="""AH/8.05/0/EG.129""",
    )

    ah_8_05_0_eg_129c = VocabularyTerm(
        code="AH_8_05_0_EG_129C",
        label="AH/8.05/0/EG.129C",
        description="""AH/8.05/0/EG.129C""",
    )

    ah_8_05_0_eg_130 = VocabularyTerm(
        code="AH_8_05_0_EG_130",
        label="AH/8.05/0/EG.130",
        description="""AH/8.05/0/EG.130""",
    )

    ah_8_05_0_eg_131 = VocabularyTerm(
        code="AH_8_05_0_EG_131",
        label="AH/8.05/0/EG.131",
        description="""AH/8.05/0/EG.131""",
    )

    ah_8_05_0_eg_131c = VocabularyTerm(
        code="AH_8_05_0_EG_131C",
        label="AH/8.05/0/EG.131C",
        description="""AH/8.05/0/EG.131C""",
    )

    ah_8_05_0_eg_132t = VocabularyTerm(
        code="AH_8_05_0_EG_132T",
        label="AH/8.05/0/EG.132T",
        description="""AH/8.05/0/EG.132T""",
    )

    ah_8_05_0_eg_133f = VocabularyTerm(
        code="AH_8_05_0_EG_133F",
        label="AH/8.05/0/EG.133F",
        description="""AH/8.05/0/EG.133F""",
    )

    ah_8_05_0_eg_134f = VocabularyTerm(
        code="AH_8_05_0_EG_134F",
        label="AH/8.05/0/EG.134F",
        description="""AH/8.05/0/EG.134F""",
    )

    ah_8_05_0_eg_135 = VocabularyTerm(
        code="AH_8_05_0_EG_135",
        label="AH/8.05/0/EG.135",
        description="""AH/8.05/0/EG.135""",
    )

    ah_8_05_0_eg_136 = VocabularyTerm(
        code="AH_8_05_0_EG_136",
        label="AH/8.05/0/EG.136",
        description="""AH/8.05/0/EG.136""",
    )

    ah_8_05_0_eg_137 = VocabularyTerm(
        code="AH_8_05_0_EG_137",
        label="AH/8.05/0/EG.137",
        description="""AH/8.05/0/EG.137""",
    )

    ah_8_05_0_eg_137c = VocabularyTerm(
        code="AH_8_05_0_EG_137C",
        label="AH/8.05/0/EG.137C",
        description="""AH/8.05/0/EG.137C""",
    )

    ah_8_05_0_eg_138 = VocabularyTerm(
        code="AH_8_05_0_EG_138",
        label="AH/8.05/0/EG.138",
        description="""AH/8.05/0/EG.138""",
    )

    ah_8_05_0_eg_138b = VocabularyTerm(
        code="AH_8_05_0_EG_138B",
        label="AH/8.05/0/EG.138B",
        description="""AH/8.05/0/EG.138B""",
    )

    ah_8_05_0_eg_138c = VocabularyTerm(
        code="AH_8_05_0_EG_138C",
        label="AH/8.05/0/EG.138C",
        description="""AH/8.05/0/EG.138C""",
    )

    ah_8_05_0_eg_139 = VocabularyTerm(
        code="AH_8_05_0_EG_139",
        label="AH/8.05/0/EG.139",
        description="""AH/8.05/0/EG.139""",
    )

    ah_8_05_0_eg_139b = VocabularyTerm(
        code="AH_8_05_0_EG_139B",
        label="AH/8.05/0/EG.139B",
        description="""AH/8.05/0/EG.139B""",
    )

    ah_8_05_0_eg_139c = VocabularyTerm(
        code="AH_8_05_0_EG_139C",
        label="AH/8.05/0/EG.139C",
        description="""AH/8.05/0/EG.139C""",
    )

    ah_8_05_0_eg_140 = VocabularyTerm(
        code="AH_8_05_0_EG_140",
        label="AH/8.05/0/EG.140",
        description="""AH/8.05/0/EG.140""",
    )

    ah_8_05_0_eg_141h = VocabularyTerm(
        code="AH_8_05_0_EG_141H",
        label="AH/8.05/0/EG.141H",
        description="""AH/8.05/0/EG.141H""",
    )

    ah_8_05_0_eg_142d = VocabularyTerm(
        code="AH_8_05_0_EG_142D",
        label="AH/8.05/0/EG.142D",
        description="""AH/8.05/0/EG.142D""",
    )

    ah_8_05_0_eg_143 = VocabularyTerm(
        code="AH_8_05_0_EG_143",
        label="AH/8.05/0/EG.143",
        description="""AH/8.05/0/EG.143""",
    )

    ah_8_05_0_eg_144t = VocabularyTerm(
        code="AH_8_05_0_EG_144T",
        label="AH/8.05/0/EG.144T",
        description="""AH/8.05/0/EG.144T""",
    )

    ah_8_05_0_eg_145 = VocabularyTerm(
        code="AH_8_05_0_EG_145",
        label="AH/8.05/0/EG.145",
        description="""AH/8.05/0/EG.145""",
    )

    ah_8_05_0_eg_146 = VocabularyTerm(
        code="AH_8_05_0_EG_146",
        label="AH/8.05/0/EG.146",
        description="""AH/8.05/0/EG.146""",
    )

    ah_8_05_0_eg_147wc = VocabularyTerm(
        code="AH_8_05_0_EG_147WC",
        label="AH/8.05/0/EG.147WC",
        description="""AH/8.05/0/EG.147WC""",
    )

    ah_8_05_0_eg_152b = VocabularyTerm(
        code="AH_8_05_0_EG_152B",
        label="AH/8.05/0/EG.152B",
        description="""AH/8.05/0/EG.152B""",
    )

    ah_8_05_0_eg_153b = VocabularyTerm(
        code="AH_8_05_0_EG_153B",
        label="AH/8.05/0/EG.153B",
        description="""AH/8.05/0/EG.153B""",
    )

    ah_8_05_0_eg_154b = VocabularyTerm(
        code="AH_8_05_0_EG_154B",
        label="AH/8.05/0/EG.154B",
        description="""AH/8.05/0/EG.154B""",
    )

    ah_8_05_0_eg_157d = VocabularyTerm(
        code="AH_8_05_0_EG_157D",
        label="AH/8.05/0/EG.157D",
        description="""AH/8.05/0/EG.157D""",
    )

    ah_8_05_0_eg_158h = VocabularyTerm(
        code="AH_8_05_0_EG_158H",
        label="AH/8.05/0/EG.158H",
        description="""AH/8.05/0/EG.158H""",
    )

    ah_8_05_0_eg_160 = VocabularyTerm(
        code="AH_8_05_0_EG_160",
        label="AH/8.05/0/EG.160",
        description="""AH/8.05/0/EG.160""",
    )

    ah_8_05_0_eg_160f = VocabularyTerm(
        code="AH_8_05_0_EG_160F",
        label="AH/8.05/0/EG.160F",
        description="""AH/8.05/0/EG.160F""",
    )

    ah_8_05_0_eg_161 = VocabularyTerm(
        code="AH_8_05_0_EG_161",
        label="AH/8.05/0/EG.161",
        description="""AH/8.05/0/EG.161""",
    )

    ah_8_05_0_eg_161b = VocabularyTerm(
        code="AH_8_05_0_EG_161B",
        label="AH/8.05/0/EG.161B",
        description="""AH/8.05/0/EG.161B""",
    )

    ah_8_05_0_eg_161c = VocabularyTerm(
        code="AH_8_05_0_EG_161C",
        label="AH/8.05/0/EG.161C",
        description="""AH/8.05/0/EG.161C""",
    )

    ah_8_05_0_eg_162 = VocabularyTerm(
        code="AH_8_05_0_EG_162",
        label="AH/8.05/0/EG.162",
        description="""AH/8.05/0/EG.162""",
    )

    ah_8_05_0_eg_162b = VocabularyTerm(
        code="AH_8_05_0_EG_162B",
        label="AH/8.05/0/EG.162B",
        description="""AH/8.05/0/EG.162B""",
    )

    ah_8_05_0_eg_162c = VocabularyTerm(
        code="AH_8_05_0_EG_162C",
        label="AH/8.05/0/EG.162C",
        description="""AH/8.05/0/EG.162C""",
    )

    ah_8_05_0_eg_162f = VocabularyTerm(
        code="AH_8_05_0_EG_162F",
        label="AH/8.05/0/EG.162F",
        description="""AH/8.05/0/EG.162F""",
    )

    ah_8_05_0_eg_163 = VocabularyTerm(
        code="AH_8_05_0_EG_163",
        label="AH/8.05/0/EG.163",
        description="""AH/8.05/0/EG.163""",
    )

    ah_8_05_0_eg_163b = VocabularyTerm(
        code="AH_8_05_0_EG_163B",
        label="AH/8.05/0/EG.163B",
        description="""AH/8.05/0/EG.163B""",
    )

    ah_8_05_0_eg_164 = VocabularyTerm(
        code="AH_8_05_0_EG_164",
        label="AH/8.05/0/EG.164",
        description="""AH/8.05/0/EG.164""",
    )

    ah_8_05_0_eg_164b = VocabularyTerm(
        code="AH_8_05_0_EG_164B",
        label="AH/8.05/0/EG.164B",
        description="""AH/8.05/0/EG.164B""",
    )

    ah_8_05_0_eg_165 = VocabularyTerm(
        code="AH_8_05_0_EG_165",
        label="AH/8.05/0/EG.165",
        description="""AH/8.05/0/EG.165""",
    )

    ah_8_05_0_eg_166 = VocabularyTerm(
        code="AH_8_05_0_EG_166",
        label="AH/8.05/0/EG.166",
        description="""AH/8.05/0/EG.166""",
    )

    ah_8_05_0_eg_167 = VocabularyTerm(
        code="AH_8_05_0_EG_167",
        label="AH/8.05/0/EG.167",
        description="""AH/8.05/0/EG.167""",
    )

    ah_8_05_0_eg_168 = VocabularyTerm(
        code="AH_8_05_0_EG_168",
        label="AH/8.05/0/EG.168",
        description="""AH/8.05/0/EG.168""",
    )

    ah_8_05_0_eg_168b = VocabularyTerm(
        code="AH_8_05_0_EG_168B",
        label="AH/8.05/0/EG.168B",
        description="""AH/8.05/0/EG.168B""",
    )

    ah_8_05_0_eg_169b = VocabularyTerm(
        code="AH_8_05_0_EG_169B",
        label="AH/8.05/0/EG.169B",
        description="""AH/8.05/0/EG.169B""",
    )

    ah_8_05_0_eg_171 = VocabularyTerm(
        code="AH_8_05_0_EG_171",
        label="AH/8.05/0/EG.171",
        description="""AH/8.05/0/EG.171""",
    )

    ah_8_05_0_eg_171b = VocabularyTerm(
        code="AH_8_05_0_EG_171B",
        label="AH/8.05/0/EG.171B",
        description="""AH/8.05/0/EG.171B""",
    )

    ah_8_05_0_eg_171f = VocabularyTerm(
        code="AH_8_05_0_EG_171F",
        label="AH/8.05/0/EG.171F",
        description="""AH/8.05/0/EG.171F""",
    )

    ah_8_05_0_eg_172 = VocabularyTerm(
        code="AH_8_05_0_EG_172",
        label="AH/8.05/0/EG.172",
        description="""AH/8.05/0/EG.172""",
    )

    ah_8_05_0_eg_172b = VocabularyTerm(
        code="AH_8_05_0_EG_172B",
        label="AH/8.05/0/EG.172B",
        description="""AH/8.05/0/EG.172B""",
    )

    ah_8_05_0_eg_172c = VocabularyTerm(
        code="AH_8_05_0_EG_172C",
        label="AH/8.05/0/EG.172C",
        description="""AH/8.05/0/EG.172C""",
    )

    ah_8_05_0_eg_173 = VocabularyTerm(
        code="AH_8_05_0_EG_173",
        label="AH/8.05/0/EG.173",
        description="""AH/8.05/0/EG.173""",
    )

    ah_8_05_0_eg_174t = VocabularyTerm(
        code="AH_8_05_0_EG_174T",
        label="AH/8.05/0/EG.174T",
        description="""AH/8.05/0/EG.174T""",
    )

    ah_8_05_0_eg_175f = VocabularyTerm(
        code="AH_8_05_0_EG_175F",
        label="AH/8.05/0/EG.175F",
        description="""AH/8.05/0/EG.175F""",
    )

    ah_8_05_0_eg_176 = VocabularyTerm(
        code="AH_8_05_0_EG_176",
        label="AH/8.05/0/EG.176",
        description="""AH/8.05/0/EG.176""",
    )

    ah_8_05_0_eg_178 = VocabularyTerm(
        code="AH_8_05_0_EG_178",
        label="AH/8.05/0/EG.178",
        description="""AH/8.05/0/EG.178""",
    )

    ah_8_05_0_eg_180f = VocabularyTerm(
        code="AH_8_05_0_EG_180F",
        label="AH/8.05/0/EG.180F",
        description="""AH/8.05/0/EG.180F""",
    )

    ah_8_05_0_eg_181 = VocabularyTerm(
        code="AH_8_05_0_EG_181",
        label="AH/8.05/0/EG.181",
        description="""AH/8.05/0/EG.181""",
    )

    ah_8_05_0_eg_181c = VocabularyTerm(
        code="AH_8_05_0_EG_181C",
        label="AH/8.05/0/EG.181C",
        description="""AH/8.05/0/EG.181C""",
    )

    ah_8_05_0_eg_182 = VocabularyTerm(
        code="AH_8_05_0_EG_182",
        label="AH/8.05/0/EG.182",
        description="""AH/8.05/0/EG.182""",
    )

    ah_8_05_0_eg_183 = VocabularyTerm(
        code="AH_8_05_0_EG_183",
        label="AH/8.05/0/EG.183",
        description="""AH/8.05/0/EG.183""",
    )

    ah_8_05_0_eg_184 = VocabularyTerm(
        code="AH_8_05_0_EG_184",
        label="AH/8.05/0/EG.184",
        description="""AH/8.05/0/EG.184""",
    )

    ah_8_05_0_eg_185 = VocabularyTerm(
        code="AH_8_05_0_EG_185",
        label="AH/8.05/0/EG.185",
        description="""AH/8.05/0/EG.185""",
    )

    ah_8_05_0_eg_187 = VocabularyTerm(
        code="AH_8_05_0_EG_187",
        label="AH/8.05/0/EG.187",
        description="""AH/8.05/0/EG.187""",
    )

    ah_8_05_0_eg_190 = VocabularyTerm(
        code="AH_8_05_0_EG_190",
        label="AH/8.05/0/EG.190",
        description="""AH/8.05/0/EG.190""",
    )

    ah_8_05_0_eg_191 = VocabularyTerm(
        code="AH_8_05_0_EG_191",
        label="AH/8.05/0/EG.191",
        description="""AH/8.05/0/EG.191""",
    )

    ah_8_05_0_eg_191b = VocabularyTerm(
        code="AH_8_05_0_EG_191B",
        label="AH/8.05/0/EG.191B",
        description="""AH/8.05/0/EG.191B""",
    )

    ah_8_05_0_eg_191f = VocabularyTerm(
        code="AH_8_05_0_EG_191F",
        label="AH/8.05/0/EG.191F",
        description="""AH/8.05/0/EG.191F""",
    )

    ah_8_05_0_eg_192b = VocabularyTerm(
        code="AH_8_05_0_EG_192B",
        label="AH/8.05/0/EG.192B",
        description="""AH/8.05/0/EG.192B""",
    )

    ah_8_05_0_eg_192t = VocabularyTerm(
        code="AH_8_05_0_EG_192T",
        label="AH/8.05/0/EG.192T",
        description="""AH/8.05/0/EG.192T""",
    )

    ah_8_05_0_eg_193 = VocabularyTerm(
        code="AH_8_05_0_EG_193",
        label="AH/8.05/0/EG.193",
        description="""AH/8.05/0/EG.193""",
    )

    ah_8_05_0_eg_193c = VocabularyTerm(
        code="AH_8_05_0_EG_193C",
        label="AH/8.05/0/EG.193C",
        description="""AH/8.05/0/EG.193C""",
    )

    ah_8_05_0_eg_194 = VocabularyTerm(
        code="AH_8_05_0_EG_194",
        label="AH/8.05/0/EG.194",
        description="""AH/8.05/0/EG.194""",
    )

    ah_8_05_0_eg_194c = VocabularyTerm(
        code="AH_8_05_0_EG_194C",
        label="AH/8.05/0/EG.194C",
        description="""AH/8.05/0/EG.194C""",
    )

    ah_8_05_0_eg_196 = VocabularyTerm(
        code="AH_8_05_0_EG_196",
        label="AH/8.05/0/EG.196",
        description="""AH/8.05/0/EG.196""",
    )

    ah_8_05_0_eg_197f = VocabularyTerm(
        code="AH_8_05_0_EG_197F",
        label="AH/8.05/0/EG.197F",
        description="""AH/8.05/0/EG.197F""",
    )

    ah_8_05_0_eg_s01 = VocabularyTerm(
        code="AH_8_05_0_EG_S01",
        label="AH/8.05/0/EG.S01",
        description="""AH/8.05/0/EG.S01""",
    )

    ah_8_05_0_eg_s02 = VocabularyTerm(
        code="AH_8_05_0_EG_S02",
        label="AH/8.05/0/EG.S02",
        description="""AH/8.05/0/EG.S02""",
    )

    ah_8_05_0_eg_s03 = VocabularyTerm(
        code="AH_8_05_0_EG_S03",
        label="AH/8.05/0/EG.S03",
        description="""AH/8.05/0/EG.S03""",
    )

    ah_8_05_0_eg_s04 = VocabularyTerm(
        code="AH_8_05_0_EG_S04",
        label="AH/8.05/0/EG.S04",
        description="""AH/8.05/0/EG.S04""",
    )

    ah_8_05_0_eg_s05 = VocabularyTerm(
        code="AH_8_05_0_EG_S05",
        label="AH/8.05/0/EG.S05",
        description="""AH/8.05/0/EG.S05""",
    )

    ah_8_05_1_o1_200a1 = VocabularyTerm(
        code="AH_8_05_1_O1_200A1",
        label="AH/8.05/1/O1.200A1",
        description="""AH/8.05/1/O1.200A1""",
    )

    ah_8_05_1_o1_200f = VocabularyTerm(
        code="AH_8_05_1_O1_200F",
        label="AH/8.05/1/O1.200F",
        description="""AH/8.05/1/O1.200F""",
    )

    ah_8_05_1_o1_200t = VocabularyTerm(
        code="AH_8_05_1_O1_200T",
        label="AH/8.05/1/O1.200T",
        description="""AH/8.05/1/O1.200T""",
    )

    ah_8_05_1_o1_201 = VocabularyTerm(
        code="AH_8_05_1_O1_201",
        label="AH/8.05/1/O1.201",
        description="""AH/8.05/1/O1.201""",
    )

    ah_8_05_1_o1_201b = VocabularyTerm(
        code="AH_8_05_1_O1_201B",
        label="AH/8.05/1/O1.201B",
        description="""AH/8.05/1/O1.201B""",
    )

    ah_8_05_1_o1_201c = VocabularyTerm(
        code="AH_8_05_1_O1_201C",
        label="AH/8.05/1/O1.201C",
        description="""AH/8.05/1/O1.201C""",
    )

    ah_8_05_1_o1_202 = VocabularyTerm(
        code="AH_8_05_1_O1_202",
        label="AH/8.05/1/O1.202",
        description="""AH/8.05/1/O1.202""",
    )

    ah_8_05_1_o1_202b = VocabularyTerm(
        code="AH_8_05_1_O1_202B",
        label="AH/8.05/1/O1.202B",
        description="""AH/8.05/1/O1.202B""",
    )

    ah_8_05_1_o1_203 = VocabularyTerm(
        code="AH_8_05_1_O1_203",
        label="AH/8.05/1/O1.203",
        description="""AH/8.05/1/O1.203""",
    )

    ah_8_05_1_o1_204 = VocabularyTerm(
        code="AH_8_05_1_O1_204",
        label="AH/8.05/1/O1.204",
        description="""AH/8.05/1/O1.204""",
    )

    ah_8_05_1_o1_205 = VocabularyTerm(
        code="AH_8_05_1_O1_205",
        label="AH/8.05/1/O1.205",
        description="""AH/8.05/1/O1.205""",
    )

    ah_8_05_1_o1_206 = VocabularyTerm(
        code="AH_8_05_1_O1_206",
        label="AH/8.05/1/O1.206",
        description="""AH/8.05/1/O1.206""",
    )

    ah_8_05_1_o1_207f = VocabularyTerm(
        code="AH_8_05_1_O1_207F",
        label="AH/8.05/1/O1.207F",
        description="""AH/8.05/1/O1.207F""",
    )

    ah_8_05_1_o1_208 = VocabularyTerm(
        code="AH_8_05_1_O1_208",
        label="AH/8.05/1/O1.208",
        description="""AH/8.05/1/O1.208""",
    )

    ah_8_05_1_o1_209 = VocabularyTerm(
        code="AH_8_05_1_O1_209",
        label="AH/8.05/1/O1.209",
        description="""AH/8.05/1/O1.209""",
    )

    ah_8_05_1_o1_210 = VocabularyTerm(
        code="AH_8_05_1_O1_210",
        label="AH/8.05/1/O1.210",
        description="""AH/8.05/1/O1.210""",
    )

    ah_8_05_1_o1_211 = VocabularyTerm(
        code="AH_8_05_1_O1_211",
        label="AH/8.05/1/O1.211",
        description="""AH/8.05/1/O1.211""",
    )

    ah_8_05_1_o1_212 = VocabularyTerm(
        code="AH_8_05_1_O1_212",
        label="AH/8.05/1/O1.212",
        description="""AH/8.05/1/O1.212""",
    )

    ah_8_05_1_o1_213 = VocabularyTerm(
        code="AH_8_05_1_O1_213",
        label="AH/8.05/1/O1.213",
        description="""AH/8.05/1/O1.213""",
    )

    ah_8_05_1_o1_214 = VocabularyTerm(
        code="AH_8_05_1_O1_214",
        label="AH/8.05/1/O1.214",
        description="""AH/8.05/1/O1.214""",
    )

    ah_8_05_1_o1_215 = VocabularyTerm(
        code="AH_8_05_1_O1_215",
        label="AH/8.05/1/O1.215",
        description="""AH/8.05/1/O1.215""",
    )

    ah_8_05_1_o1_216 = VocabularyTerm(
        code="AH_8_05_1_O1_216",
        label="AH/8.05/1/O1.216",
        description="""AH/8.05/1/O1.216""",
    )

    ah_8_05_1_o1_217 = VocabularyTerm(
        code="AH_8_05_1_O1_217",
        label="AH/8.05/1/O1.217",
        description="""AH/8.05/1/O1.217""",
    )

    ah_8_05_1_o1_218 = VocabularyTerm(
        code="AH_8_05_1_O1_218",
        label="AH/8.05/1/O1.218",
        description="""AH/8.05/1/O1.218""",
    )

    ah_8_05_1_o1_218a2 = VocabularyTerm(
        code="AH_8_05_1_O1_218A2",
        label="AH/8.05/1/O1.218A2",
        description="""AH/8.05/1/O1.218A2""",
    )

    ah_8_05_1_o1_218f = VocabularyTerm(
        code="AH_8_05_1_O1_218F",
        label="AH/8.05/1/O1.218F",
        description="""AH/8.05/1/O1.218F""",
    )

    ah_8_05_1_o1_219 = VocabularyTerm(
        code="AH_8_05_1_O1_219",
        label="AH/8.05/1/O1.219",
        description="""AH/8.05/1/O1.219""",
    )

    ah_8_05_1_o1_220 = VocabularyTerm(
        code="AH_8_05_1_O1_220",
        label="AH/8.05/1/O1.220",
        description="""AH/8.05/1/O1.220""",
    )

    ah_8_05_1_o1_220c = VocabularyTerm(
        code="AH_8_05_1_O1_220C",
        label="AH/8.05/1/O1.220C",
        description="""AH/8.05/1/O1.220C""",
    )

    ah_8_05_1_o1_221f = VocabularyTerm(
        code="AH_8_05_1_O1_221F",
        label="AH/8.05/1/O1.221F",
        description="""AH/8.05/1/O1.221F""",
    )

    ah_8_05_1_o1_228 = VocabularyTerm(
        code="AH_8_05_1_O1_228",
        label="AH/8.05/1/O1.228",
        description="""AH/8.05/1/O1.228""",
    )

    ah_8_05_1_o1_228c = VocabularyTerm(
        code="AH_8_05_1_O1_228C",
        label="AH/8.05/1/O1.228C",
        description="""AH/8.05/1/O1.228C""",
    )

    ah_8_05_1_o1_229 = VocabularyTerm(
        code="AH_8_05_1_O1_229",
        label="AH/8.05/1/O1.229",
        description="""AH/8.05/1/O1.229""",
    )

    ah_8_05_1_o1_230 = VocabularyTerm(
        code="AH_8_05_1_O1_230",
        label="AH/8.05/1/O1.230",
        description="""AH/8.05/1/O1.230""",
    )

    ah_8_05_1_o1_230c = VocabularyTerm(
        code="AH_8_05_1_O1_230C",
        label="AH/8.05/1/O1.230C",
        description="""AH/8.05/1/O1.230C""",
    )

    ah_8_05_1_o1_231 = VocabularyTerm(
        code="AH_8_05_1_O1_231",
        label="AH/8.05/1/O1.231",
        description="""AH/8.05/1/O1.231""",
    )

    ah_8_05_1_o1_231c = VocabularyTerm(
        code="AH_8_05_1_O1_231C",
        label="AH/8.05/1/O1.231C",
        description="""AH/8.05/1/O1.231C""",
    )

    ah_8_05_1_o1_232c = VocabularyTerm(
        code="AH_8_05_1_O1_232C",
        label="AH/8.05/1/O1.232C",
        description="""AH/8.05/1/O1.232C""",
    )

    ah_8_05_1_o1_232t = VocabularyTerm(
        code="AH_8_05_1_O1_232T",
        label="AH/8.05/1/O1.232T",
        description="""AH/8.05/1/O1.232T""",
    )

    ah_8_05_1_o1_233c = VocabularyTerm(
        code="AH_8_05_1_O1_233C",
        label="AH/8.05/1/O1.233C",
        description="""AH/8.05/1/O1.233C""",
    )

    ah_8_05_1_o1_233f = VocabularyTerm(
        code="AH_8_05_1_O1_233F",
        label="AH/8.05/1/O1.233F",
        description="""AH/8.05/1/O1.233F""",
    )

    ah_8_05_1_o1_234c = VocabularyTerm(
        code="AH_8_05_1_O1_234C",
        label="AH/8.05/1/O1.234C",
        description="""AH/8.05/1/O1.234C""",
    )

    ah_8_05_1_o1_234f = VocabularyTerm(
        code="AH_8_05_1_O1_234F",
        label="AH/8.05/1/O1.234F",
        description="""AH/8.05/1/O1.234F""",
    )

    ah_8_05_1_o1_235 = VocabularyTerm(
        code="AH_8_05_1_O1_235",
        label="AH/8.05/1/O1.235",
        description="""AH/8.05/1/O1.235""",
    )

    ah_8_05_1_o1_235c = VocabularyTerm(
        code="AH_8_05_1_O1_235C",
        label="AH/8.05/1/O1.235C",
        description="""AH/8.05/1/O1.235C""",
    )

    ah_8_05_1_o1_236 = VocabularyTerm(
        code="AH_8_05_1_O1_236",
        label="AH/8.05/1/O1.236",
        description="""AH/8.05/1/O1.236""",
    )

    ah_8_05_1_o1_236c = VocabularyTerm(
        code="AH_8_05_1_O1_236C",
        label="AH/8.05/1/O1.236C",
        description="""AH/8.05/1/O1.236C""",
    )

    ah_8_05_1_o1_237 = VocabularyTerm(
        code="AH_8_05_1_O1_237",
        label="AH/8.05/1/O1.237",
        description="""AH/8.05/1/O1.237""",
    )

    ah_8_05_1_o1_237c = VocabularyTerm(
        code="AH_8_05_1_O1_237C",
        label="AH/8.05/1/O1.237C",
        description="""AH/8.05/1/O1.237C""",
    )

    ah_8_05_1_o1_238 = VocabularyTerm(
        code="AH_8_05_1_O1_238",
        label="AH/8.05/1/O1.238",
        description="""AH/8.05/1/O1.238""",
    )

    ah_8_05_1_o1_238c = VocabularyTerm(
        code="AH_8_05_1_O1_238C",
        label="AH/8.05/1/O1.238C",
        description="""AH/8.05/1/O1.238C""",
    )

    ah_8_05_1_o1_239c = VocabularyTerm(
        code="AH_8_05_1_O1_239C",
        label="AH/8.05/1/O1.239C",
        description="""AH/8.05/1/O1.239C""",
    )

    ah_8_05_1_o1_240 = VocabularyTerm(
        code="AH_8_05_1_O1_240",
        label="AH/8.05/1/O1.240",
        description="""AH/8.05/1/O1.240""",
    )

    ah_8_05_1_o1_241h = VocabularyTerm(
        code="AH_8_05_1_O1_241H",
        label="AH/8.05/1/O1.241H",
        description="""AH/8.05/1/O1.241H""",
    )

    ah_8_05_1_o1_242d = VocabularyTerm(
        code="AH_8_05_1_O1_242D",
        label="AH/8.05/1/O1.242D",
        description="""AH/8.05/1/O1.242D""",
    )

    ah_8_05_1_o1_243 = VocabularyTerm(
        code="AH_8_05_1_O1_243",
        label="AH/8.05/1/O1.243",
        description="""AH/8.05/1/O1.243""",
    )

    ah_8_05_1_o1_244t = VocabularyTerm(
        code="AH_8_05_1_O1_244T",
        label="AH/8.05/1/O1.244T",
        description="""AH/8.05/1/O1.244T""",
    )

    ah_8_05_1_o1_245 = VocabularyTerm(
        code="AH_8_05_1_O1_245",
        label="AH/8.05/1/O1.245",
        description="""AH/8.05/1/O1.245""",
    )

    ah_8_05_1_o1_246 = VocabularyTerm(
        code="AH_8_05_1_O1_246",
        label="AH/8.05/1/O1.246",
        description="""AH/8.05/1/O1.246""",
    )

    ah_8_05_1_o1_252 = VocabularyTerm(
        code="AH_8_05_1_O1_252",
        label="AH/8.05/1/O1.252",
        description="""AH/8.05/1/O1.252""",
    )

    ah_8_05_1_o1_252c = VocabularyTerm(
        code="AH_8_05_1_O1_252C",
        label="AH/8.05/1/O1.252C",
        description="""AH/8.05/1/O1.252C""",
    )

    ah_8_05_1_o1_252f = VocabularyTerm(
        code="AH_8_05_1_O1_252F",
        label="AH/8.05/1/O1.252F",
        description="""AH/8.05/1/O1.252F""",
    )

    ah_8_05_1_o1_253 = VocabularyTerm(
        code="AH_8_05_1_O1_253",
        label="AH/8.05/1/O1.253",
        description="""AH/8.05/1/O1.253""",
    )

    ah_8_05_1_o1_253d = VocabularyTerm(
        code="AH_8_05_1_O1_253D",
        label="AH/8.05/1/O1.253D",
        description="""AH/8.05/1/O1.253D""",
    )

    ah_8_05_1_o1_254 = VocabularyTerm(
        code="AH_8_05_1_O1_254",
        label="AH/8.05/1/O1.254",
        description="""AH/8.05/1/O1.254""",
    )

    ah_8_05_1_o1_254h = VocabularyTerm(
        code="AH_8_05_1_O1_254H",
        label="AH/8.05/1/O1.254H",
        description="""AH/8.05/1/O1.254H""",
    )

    ah_8_05_1_o1_255 = VocabularyTerm(
        code="AH_8_05_1_O1_255",
        label="AH/8.05/1/O1.255",
        description="""AH/8.05/1/O1.255""",
    )

    ah_8_05_1_o1_255c = VocabularyTerm(
        code="AH_8_05_1_O1_255C",
        label="AH/8.05/1/O1.255C",
        description="""AH/8.05/1/O1.255C""",
    )

    ah_8_05_1_o1_256 = VocabularyTerm(
        code="AH_8_05_1_O1_256",
        label="AH/8.05/1/O1.256",
        description="""AH/8.05/1/O1.256""",
    )

    ah_8_05_1_o1_257 = VocabularyTerm(
        code="AH_8_05_1_O1_257",
        label="AH/8.05/1/O1.257",
        description="""AH/8.05/1/O1.257""",
    )

    ah_8_05_1_o1_257d = VocabularyTerm(
        code="AH_8_05_1_O1_257D",
        label="AH/8.05/1/O1.257D",
        description="""AH/8.05/1/O1.257D""",
    )

    ah_8_05_1_o1_258 = VocabularyTerm(
        code="AH_8_05_1_O1_258",
        label="AH/8.05/1/O1.258",
        description="""AH/8.05/1/O1.258""",
    )

    ah_8_05_1_o1_258h = VocabularyTerm(
        code="AH_8_05_1_O1_258H",
        label="AH/8.05/1/O1.258H",
        description="""AH/8.05/1/O1.258H""",
    )

    ah_8_05_1_o1_259 = VocabularyTerm(
        code="AH_8_05_1_O1_259",
        label="AH/8.05/1/O1.259",
        description="""AH/8.05/1/O1.259""",
    )

    ah_8_05_1_o1_260 = VocabularyTerm(
        code="AH_8_05_1_O1_260",
        label="AH/8.05/1/O1.260",
        description="""AH/8.05/1/O1.260""",
    )

    ah_8_05_1_o1_261 = VocabularyTerm(
        code="AH_8_05_1_O1_261",
        label="AH/8.05/1/O1.261",
        description="""AH/8.05/1/O1.261""",
    )

    ah_8_05_1_o1_262f = VocabularyTerm(
        code="AH_8_05_1_O1_262F",
        label="AH/8.05/1/O1.262F",
        description="""AH/8.05/1/O1.262F""",
    )

    ah_8_05_1_o1_263 = VocabularyTerm(
        code="AH_8_05_1_O1_263",
        label="AH/8.05/1/O1.263",
        description="""AH/8.05/1/O1.263""",
    )

    ah_8_05_1_o1_263c = VocabularyTerm(
        code="AH_8_05_1_O1_263C",
        label="AH/8.05/1/O1.263C",
        description="""AH/8.05/1/O1.263C""",
    )

    ah_8_05_1_o1_264 = VocabularyTerm(
        code="AH_8_05_1_O1_264",
        label="AH/8.05/1/O1.264",
        description="""AH/8.05/1/O1.264""",
    )

    ah_8_05_1_o1_265 = VocabularyTerm(
        code="AH_8_05_1_O1_265",
        label="AH/8.05/1/O1.265",
        description="""AH/8.05/1/O1.265""",
    )

    ah_8_05_1_o1_266 = VocabularyTerm(
        code="AH_8_05_1_O1_266",
        label="AH/8.05/1/O1.266",
        description="""AH/8.05/1/O1.266""",
    )

    ah_8_05_1_o1_267 = VocabularyTerm(
        code="AH_8_05_1_O1_267",
        label="AH/8.05/1/O1.267",
        description="""AH/8.05/1/O1.267""",
    )

    ah_8_05_1_o1_268 = VocabularyTerm(
        code="AH_8_05_1_O1_268",
        label="AH/8.05/1/O1.268",
        description="""AH/8.05/1/O1.268""",
    )

    ah_8_05_1_o1_269 = VocabularyTerm(
        code="AH_8_05_1_O1_269",
        label="AH/8.05/1/O1.269",
        description="""AH/8.05/1/O1.269""",
    )

    ah_8_05_1_o1_270 = VocabularyTerm(
        code="AH_8_05_1_O1_270",
        label="AH/8.05/1/O1.270",
        description="""AH/8.05/1/O1.270""",
    )

    ah_8_05_1_o1_271 = VocabularyTerm(
        code="AH_8_05_1_O1_271",
        label="AH/8.05/1/O1.271",
        description="""AH/8.05/1/O1.271""",
    )

    ah_8_05_1_o1_272 = VocabularyTerm(
        code="AH_8_05_1_O1_272",
        label="AH/8.05/1/O1.272",
        description="""AH/8.05/1/O1.272""",
    )

    ah_8_05_1_o1_273 = VocabularyTerm(
        code="AH_8_05_1_O1_273",
        label="AH/8.05/1/O1.273",
        description="""AH/8.05/1/O1.273""",
    )

    ah_8_05_1_o1_274t = VocabularyTerm(
        code="AH_8_05_1_O1_274T",
        label="AH/8.05/1/O1.274T",
        description="""AH/8.05/1/O1.274T""",
    )

    ah_8_05_1_o1_275f = VocabularyTerm(
        code="AH_8_05_1_O1_275F",
        label="AH/8.05/1/O1.275F",
        description="""AH/8.05/1/O1.275F""",
    )

    ah_8_05_1_o1_281 = VocabularyTerm(
        code="AH_8_05_1_O1_281",
        label="AH/8.05/1/O1.281",
        description="""AH/8.05/1/O1.281""",
    )

    ah_8_05_1_o1_281c = VocabularyTerm(
        code="AH_8_05_1_O1_281C",
        label="AH/8.05/1/O1.281C",
        description="""AH/8.05/1/O1.281C""",
    )

    ah_8_05_1_o1_282 = VocabularyTerm(
        code="AH_8_05_1_O1_282",
        label="AH/8.05/1/O1.282",
        description="""AH/8.05/1/O1.282""",
    )

    ah_8_05_1_o1_282c = VocabularyTerm(
        code="AH_8_05_1_O1_282C",
        label="AH/8.05/1/O1.282C",
        description="""AH/8.05/1/O1.282C""",
    )

    ah_8_05_1_o1_282f = VocabularyTerm(
        code="AH_8_05_1_O1_282F",
        label="AH/8.05/1/O1.282F",
        description="""AH/8.05/1/O1.282F""",
    )

    ah_8_05_1_o1_283 = VocabularyTerm(
        code="AH_8_05_1_O1_283",
        label="AH/8.05/1/O1.283",
        description="""AH/8.05/1/O1.283""",
    )

    ah_8_05_1_o1_285 = VocabularyTerm(
        code="AH_8_05_1_O1_285",
        label="AH/8.05/1/O1.285",
        description="""AH/8.05/1/O1.285""",
    )

    ah_8_05_1_o1_285c = VocabularyTerm(
        code="AH_8_05_1_O1_285C",
        label="AH/8.05/1/O1.285C",
        description="""AH/8.05/1/O1.285C""",
    )

    ah_8_05_1_o1_286c = VocabularyTerm(
        code="AH_8_05_1_O1_286C",
        label="AH/8.05/1/O1.286C",
        description="""AH/8.05/1/O1.286C""",
    )

    ah_8_05_1_o1_287 = VocabularyTerm(
        code="AH_8_05_1_O1_287",
        label="AH/8.05/1/O1.287",
        description="""AH/8.05/1/O1.287""",
    )

    ah_8_05_1_o1_288c = VocabularyTerm(
        code="AH_8_05_1_O1_288C",
        label="AH/8.05/1/O1.288C",
        description="""AH/8.05/1/O1.288C""",
    )

    ah_8_05_1_o1_289 = VocabularyTerm(
        code="AH_8_05_1_O1_289",
        label="AH/8.05/1/O1.289",
        description="""AH/8.05/1/O1.289""",
    )

    ah_8_05_1_o1_289c = VocabularyTerm(
        code="AH_8_05_1_O1_289C",
        label="AH/8.05/1/O1.289C",
        description="""AH/8.05/1/O1.289C""",
    )

    ah_8_05_1_o1_290 = VocabularyTerm(
        code="AH_8_05_1_O1_290",
        label="AH/8.05/1/O1.290",
        description="""AH/8.05/1/O1.290""",
    )

    ah_8_05_1_o1_291 = VocabularyTerm(
        code="AH_8_05_1_O1_291",
        label="AH/8.05/1/O1.291",
        description="""AH/8.05/1/O1.291""",
    )

    ah_8_05_1_o1_291b = VocabularyTerm(
        code="AH_8_05_1_O1_291B",
        label="AH/8.05/1/O1.291B",
        description="""AH/8.05/1/O1.291B""",
    )

    ah_8_05_1_o1_291c = VocabularyTerm(
        code="AH_8_05_1_O1_291C",
        label="AH/8.05/1/O1.291C",
        description="""AH/8.05/1/O1.291C""",
    )

    ah_8_05_1_o1_291f = VocabularyTerm(
        code="AH_8_05_1_O1_291F",
        label="AH/8.05/1/O1.291F",
        description="""AH/8.05/1/O1.291F""",
    )

    ah_8_05_1_o1_292b = VocabularyTerm(
        code="AH_8_05_1_O1_292B",
        label="AH/8.05/1/O1.292B",
        description="""AH/8.05/1/O1.292B""",
    )

    ah_8_05_1_o1_292t = VocabularyTerm(
        code="AH_8_05_1_O1_292T",
        label="AH/8.05/1/O1.292T",
        description="""AH/8.05/1/O1.292T""",
    )

    ah_8_05_1_o1_293 = VocabularyTerm(
        code="AH_8_05_1_O1_293",
        label="AH/8.05/1/O1.293",
        description="""AH/8.05/1/O1.293""",
    )

    ah_8_05_1_o1_294 = VocabularyTerm(
        code="AH_8_05_1_O1_294",
        label="AH/8.05/1/O1.294",
        description="""AH/8.05/1/O1.294""",
    )

    ah_8_05_1_o1_294c = VocabularyTerm(
        code="AH_8_05_1_O1_294C",
        label="AH/8.05/1/O1.294C",
        description="""AH/8.05/1/O1.294C""",
    )

    ah_8_05_1_o1_295 = VocabularyTerm(
        code="AH_8_05_1_O1_295",
        label="AH/8.05/1/O1.295",
        description="""AH/8.05/1/O1.295""",
    )

    ah_8_05_1_o1_296 = VocabularyTerm(
        code="AH_8_05_1_O1_296",
        label="AH/8.05/1/O1.296",
        description="""AH/8.05/1/O1.296""",
    )

    ah_8_05_1_o1_297 = VocabularyTerm(
        code="AH_8_05_1_O1_297",
        label="AH/8.05/1/O1.297",
        description="""AH/8.05/1/O1.297""",
    )

    ah_8_05_1_o1_297f = VocabularyTerm(
        code="AH_8_05_1_O1_297F",
        label="AH/8.05/1/O1.297F",
        description="""AH/8.05/1/O1.297F""",
    )

    ah_8_05_1_o1_s01 = VocabularyTerm(
        code="AH_8_05_1_O1_S01",
        label="AH/8.05/1/O1.S01",
        description="""AH/8.05/1/O1.S01""",
    )

    ah_8_05_1_o1_s02 = VocabularyTerm(
        code="AH_8_05_1_O1_S02",
        label="AH/8.05/1/O1.S02",
        description="""AH/8.05/1/O1.S02""",
    )

    ah_8_05_1_o1_s03 = VocabularyTerm(
        code="AH_8_05_1_O1_S03",
        label="AH/8.05/1/O1.S03",
        description="""AH/8.05/1/O1.S03""",
    )

    ah_8_05_1_o1_s04 = VocabularyTerm(
        code="AH_8_05_1_O1_S04",
        label="AH/8.05/1/O1.S04",
        description="""AH/8.05/1/O1.S04""",
    )

    ah_8_05_1_o1_s05 = VocabularyTerm(
        code="AH_8_05_1_O1_S05",
        label="AH/8.05/1/O1.S05",
        description="""AH/8.05/1/O1.S05""",
    )

    ah_8_05_2_o2_300a1 = VocabularyTerm(
        code="AH_8_05_2_O2_300A1",
        label="AH/8.05/2/O2.300A1",
        description="""AH/8.05/2/O2.300A1""",
    )

    ah_8_05_2_o2_300f = VocabularyTerm(
        code="AH_8_05_2_O2_300F",
        label="AH/8.05/2/O2.300F",
        description="""AH/8.05/2/O2.300F""",
    )

    ah_8_05_2_o2_300t = VocabularyTerm(
        code="AH_8_05_2_O2_300T",
        label="AH/8.05/2/O2.300T",
        description="""AH/8.05/2/O2.300T""",
    )

    ah_8_05_2_o2_303 = VocabularyTerm(
        code="AH_8_05_2_O2_303",
        label="AH/8.05/2/O2.303",
        description="""AH/8.05/2/O2.303""",
    )

    ah_8_05_2_o2_305 = VocabularyTerm(
        code="AH_8_05_2_O2_305",
        label="AH/8.05/2/O2.305",
        description="""AH/8.05/2/O2.305""",
    )

    ah_8_05_2_o2_305b = VocabularyTerm(
        code="AH_8_05_2_O2_305B",
        label="AH/8.05/2/O2.305B",
        description="""AH/8.05/2/O2.305B""",
    )

    ah_8_05_2_o2_307f = VocabularyTerm(
        code="AH_8_05_2_O2_307F",
        label="AH/8.05/2/O2.307F",
        description="""AH/8.05/2/O2.307F""",
    )

    ah_8_05_2_o2_308 = VocabularyTerm(
        code="AH_8_05_2_O2_308",
        label="AH/8.05/2/O2.308",
        description="""AH/8.05/2/O2.308""",
    )

    ah_8_05_2_o2_309 = VocabularyTerm(
        code="AH_8_05_2_O2_309",
        label="AH/8.05/2/O2.309",
        description="""AH/8.05/2/O2.309""",
    )

    ah_8_05_2_o2_310 = VocabularyTerm(
        code="AH_8_05_2_O2_310",
        label="AH/8.05/2/O2.310",
        description="""AH/8.05/2/O2.310""",
    )

    ah_8_05_2_o2_312 = VocabularyTerm(
        code="AH_8_05_2_O2_312",
        label="AH/8.05/2/O2.312",
        description="""AH/8.05/2/O2.312""",
    )

    ah_8_05_2_o2_313 = VocabularyTerm(
        code="AH_8_05_2_O2_313",
        label="AH/8.05/2/O2.313",
        description="""AH/8.05/2/O2.313""",
    )

    ah_8_05_2_o2_314 = VocabularyTerm(
        code="AH_8_05_2_O2_314",
        label="AH/8.05/2/O2.314",
        description="""AH/8.05/2/O2.314""",
    )

    ah_8_05_2_o2_315 = VocabularyTerm(
        code="AH_8_05_2_O2_315",
        label="AH/8.05/2/O2.315",
        description="""AH/8.05/2/O2.315""",
    )

    ah_8_05_2_o2_316 = VocabularyTerm(
        code="AH_8_05_2_O2_316",
        label="AH/8.05/2/O2.316",
        description="""AH/8.05/2/O2.316""",
    )

    ah_8_05_2_o2_317 = VocabularyTerm(
        code="AH_8_05_2_O2_317",
        label="AH/8.05/2/O2.317",
        description="""AH/8.05/2/O2.317""",
    )

    ah_8_05_2_o2_318 = VocabularyTerm(
        code="AH_8_05_2_O2_318",
        label="AH/8.05/2/O2.318",
        description="""AH/8.05/2/O2.318""",
    )

    ah_8_05_2_o2_318a2 = VocabularyTerm(
        code="AH_8_05_2_O2_318A2",
        label="AH/8.05/2/O2.318A2",
        description="""AH/8.05/2/O2.318A2""",
    )

    ah_8_05_2_o2_318f = VocabularyTerm(
        code="AH_8_05_2_O2_318F",
        label="AH/8.05/2/O2.318F",
        description="""AH/8.05/2/O2.318F""",
    )

    ah_8_05_2_o2_320 = VocabularyTerm(
        code="AH_8_05_2_O2_320",
        label="AH/8.05/2/O2.320",
        description="""AH/8.05/2/O2.320""",
    )

    ah_8_05_2_o2_321f = VocabularyTerm(
        code="AH_8_05_2_O2_321F",
        label="AH/8.05/2/O2.321F",
        description="""AH/8.05/2/O2.321F""",
    )

    ah_8_05_2_o2_322c = VocabularyTerm(
        code="AH_8_05_2_O2_322C",
        label="AH/8.05/2/O2.322C",
        description="""AH/8.05/2/O2.322C""",
    )

    ah_8_05_2_o2_323 = VocabularyTerm(
        code="AH_8_05_2_O2_323",
        label="AH/8.05/2/O2.323",
        description="""AH/8.05/2/O2.323""",
    )

    ah_8_05_2_o2_323c = VocabularyTerm(
        code="AH_8_05_2_O2_323C",
        label="AH/8.05/2/O2.323C",
        description="""AH/8.05/2/O2.323C""",
    )

    ah_8_05_2_o2_324c = VocabularyTerm(
        code="AH_8_05_2_O2_324C",
        label="AH/8.05/2/O2.324C",
        description="""AH/8.05/2/O2.324C""",
    )

    ah_8_05_2_o2_325 = VocabularyTerm(
        code="AH_8_05_2_O2_325",
        label="AH/8.05/2/O2.325",
        description="""AH/8.05/2/O2.325""",
    )

    ah_8_05_2_o2_325c = VocabularyTerm(
        code="AH_8_05_2_O2_325C",
        label="AH/8.05/2/O2.325C",
        description="""AH/8.05/2/O2.325C""",
    )

    ah_8_05_2_o2_326 = VocabularyTerm(
        code="AH_8_05_2_O2_326",
        label="AH/8.05/2/O2.326",
        description="""AH/8.05/2/O2.326""",
    )

    ah_8_05_2_o2_326c = VocabularyTerm(
        code="AH_8_05_2_O2_326C",
        label="AH/8.05/2/O2.326C",
        description="""AH/8.05/2/O2.326C""",
    )

    ah_8_05_2_o2_327 = VocabularyTerm(
        code="AH_8_05_2_O2_327",
        label="AH/8.05/2/O2.327",
        description="""AH/8.05/2/O2.327""",
    )

    ah_8_05_2_o2_327c = VocabularyTerm(
        code="AH_8_05_2_O2_327C",
        label="AH/8.05/2/O2.327C",
        description="""AH/8.05/2/O2.327C""",
    )

    ah_8_05_2_o2_328 = VocabularyTerm(
        code="AH_8_05_2_O2_328",
        label="AH/8.05/2/O2.328",
        description="""AH/8.05/2/O2.328""",
    )

    ah_8_05_2_o2_328c = VocabularyTerm(
        code="AH_8_05_2_O2_328C",
        label="AH/8.05/2/O2.328C",
        description="""AH/8.05/2/O2.328C""",
    )

    ah_8_05_2_o2_329 = VocabularyTerm(
        code="AH_8_05_2_O2_329",
        label="AH/8.05/2/O2.329",
        description="""AH/8.05/2/O2.329""",
    )

    ah_8_05_2_o2_329c = VocabularyTerm(
        code="AH_8_05_2_O2_329C",
        label="AH/8.05/2/O2.329C",
        description="""AH/8.05/2/O2.329C""",
    )

    ah_8_05_2_o2_330 = VocabularyTerm(
        code="AH_8_05_2_O2_330",
        label="AH/8.05/2/O2.330",
        description="""AH/8.05/2/O2.330""",
    )

    ah_8_05_2_o2_330c = VocabularyTerm(
        code="AH_8_05_2_O2_330C",
        label="AH/8.05/2/O2.330C",
        description="""AH/8.05/2/O2.330C""",
    )

    ah_8_05_2_o2_331 = VocabularyTerm(
        code="AH_8_05_2_O2_331",
        label="AH/8.05/2/O2.331",
        description="""AH/8.05/2/O2.331""",
    )

    ah_8_05_2_o2_331c = VocabularyTerm(
        code="AH_8_05_2_O2_331C",
        label="AH/8.05/2/O2.331C",
        description="""AH/8.05/2/O2.331C""",
    )

    ah_8_05_2_o2_331f = VocabularyTerm(
        code="AH_8_05_2_O2_331F",
        label="AH/8.05/2/O2.331F",
        description="""AH/8.05/2/O2.331F""",
    )

    ah_8_05_2_o2_332f = VocabularyTerm(
        code="AH_8_05_2_O2_332F",
        label="AH/8.05/2/O2.332F",
        description="""AH/8.05/2/O2.332F""",
    )

    ah_8_05_2_o2_332t = VocabularyTerm(
        code="AH_8_05_2_O2_332T",
        label="AH/8.05/2/O2.332T",
        description="""AH/8.05/2/O2.332T""",
    )

    ah_8_05_2_o2_333f = VocabularyTerm(
        code="AH_8_05_2_O2_333F",
        label="AH/8.05/2/O2.333F",
        description="""AH/8.05/2/O2.333F""",
    )

    ah_8_05_2_o2_334f = VocabularyTerm(
        code="AH_8_05_2_O2_334F",
        label="AH/8.05/2/O2.334F",
        description="""AH/8.05/2/O2.334F""",
    )

    ah_8_05_2_o2_335 = VocabularyTerm(
        code="AH_8_05_2_O2_335",
        label="AH/8.05/2/O2.335",
        description="""AH/8.05/2/O2.335""",
    )

    ah_8_05_2_o2_336 = VocabularyTerm(
        code="AH_8_05_2_O2_336",
        label="AH/8.05/2/O2.336",
        description="""AH/8.05/2/O2.336""",
    )

    ah_8_05_2_o2_337 = VocabularyTerm(
        code="AH_8_05_2_O2_337",
        label="AH/8.05/2/O2.337",
        description="""AH/8.05/2/O2.337""",
    )

    ah_8_05_2_o2_337c = VocabularyTerm(
        code="AH_8_05_2_O2_337C",
        label="AH/8.05/2/O2.337C",
        description="""AH/8.05/2/O2.337C""",
    )

    ah_8_05_2_o2_338 = VocabularyTerm(
        code="AH_8_05_2_O2_338",
        label="AH/8.05/2/O2.338",
        description="""AH/8.05/2/O2.338""",
    )

    ah_8_05_2_o2_339 = VocabularyTerm(
        code="AH_8_05_2_O2_339",
        label="AH/8.05/2/O2.339",
        description="""AH/8.05/2/O2.339""",
    )

    ah_8_05_2_o2_340 = VocabularyTerm(
        code="AH_8_05_2_O2_340",
        label="AH/8.05/2/O2.340",
        description="""AH/8.05/2/O2.340""",
    )

    ah_8_05_2_o2_341h = VocabularyTerm(
        code="AH_8_05_2_O2_341H",
        label="AH/8.05/2/O2.341H",
        description="""AH/8.05/2/O2.341H""",
    )

    ah_8_05_2_o2_342d = VocabularyTerm(
        code="AH_8_05_2_O2_342D",
        label="AH/8.05/2/O2.342D",
        description="""AH/8.05/2/O2.342D""",
    )

    ah_8_05_2_o2_343 = VocabularyTerm(
        code="AH_8_05_2_O2_343",
        label="AH/8.05/2/O2.343",
        description="""AH/8.05/2/O2.343""",
    )

    ah_8_05_2_o2_344t = VocabularyTerm(
        code="AH_8_05_2_O2_344T",
        label="AH/8.05/2/O2.344T",
        description="""AH/8.05/2/O2.344T""",
    )

    ah_8_05_2_o2_345 = VocabularyTerm(
        code="AH_8_05_2_O2_345",
        label="AH/8.05/2/O2.345",
        description="""AH/8.05/2/O2.345""",
    )

    ah_8_05_2_o2_346 = VocabularyTerm(
        code="AH_8_05_2_O2_346",
        label="AH/8.05/2/O2.346",
        description="""AH/8.05/2/O2.346""",
    )

    ah_8_05_2_o2_352 = VocabularyTerm(
        code="AH_8_05_2_O2_352",
        label="AH/8.05/2/O2.352",
        description="""AH/8.05/2/O2.352""",
    )

    ah_8_05_2_o2_352c = VocabularyTerm(
        code="AH_8_05_2_O2_352C",
        label="AH/8.05/2/O2.352C",
        description="""AH/8.05/2/O2.352C""",
    )

    ah_8_05_2_o2_352f = VocabularyTerm(
        code="AH_8_05_2_O2_352F",
        label="AH/8.05/2/O2.352F",
        description="""AH/8.05/2/O2.352F""",
    )

    ah_8_05_2_o2_353 = VocabularyTerm(
        code="AH_8_05_2_O2_353",
        label="AH/8.05/2/O2.353",
        description="""AH/8.05/2/O2.353""",
    )

    ah_8_05_2_o2_354 = VocabularyTerm(
        code="AH_8_05_2_O2_354",
        label="AH/8.05/2/O2.354",
        description="""AH/8.05/2/O2.354""",
    )

    ah_8_05_2_o2_354c = VocabularyTerm(
        code="AH_8_05_2_O2_354C",
        label="AH/8.05/2/O2.354C",
        description="""AH/8.05/2/O2.354C""",
    )

    ah_8_05_2_o2_355 = VocabularyTerm(
        code="AH_8_05_2_O2_355",
        label="AH/8.05/2/O2.355",
        description="""AH/8.05/2/O2.355""",
    )

    ah_8_05_2_o2_355c = VocabularyTerm(
        code="AH_8_05_2_O2_355C",
        label="AH/8.05/2/O2.355C",
        description="""AH/8.05/2/O2.355C""",
    )

    ah_8_05_2_o2_356 = VocabularyTerm(
        code="AH_8_05_2_O2_356",
        label="AH/8.05/2/O2.356",
        description="""AH/8.05/2/O2.356""",
    )

    ah_8_05_2_o2_357 = VocabularyTerm(
        code="AH_8_05_2_O2_357",
        label="AH/8.05/2/O2.357",
        description="""AH/8.05/2/O2.357""",
    )

    ah_8_05_2_o2_357d = VocabularyTerm(
        code="AH_8_05_2_O2_357D",
        label="AH/8.05/2/O2.357D",
        description="""AH/8.05/2/O2.357D""",
    )

    ah_8_05_2_o2_358 = VocabularyTerm(
        code="AH_8_05_2_O2_358",
        label="AH/8.05/2/O2.358",
        description="""AH/8.05/2/O2.358""",
    )

    ah_8_05_2_o2_358h = VocabularyTerm(
        code="AH_8_05_2_O2_358H",
        label="AH/8.05/2/O2.358H",
        description="""AH/8.05/2/O2.358H""",
    )

    ah_8_05_2_o2_359 = VocabularyTerm(
        code="AH_8_05_2_O2_359",
        label="AH/8.05/2/O2.359",
        description="""AH/8.05/2/O2.359""",
    )

    ah_8_05_2_o2_360 = VocabularyTerm(
        code="AH_8_05_2_O2_360",
        label="AH/8.05/2/O2.360",
        description="""AH/8.05/2/O2.360""",
    )

    ah_8_05_2_o2_361 = VocabularyTerm(
        code="AH_8_05_2_O2_361",
        label="AH/8.05/2/O2.361",
        description="""AH/8.05/2/O2.361""",
    )

    ah_8_05_2_o2_362f = VocabularyTerm(
        code="AH_8_05_2_O2_362F",
        label="AH/8.05/2/O2.362F",
        description="""AH/8.05/2/O2.362F""",
    )

    ah_8_05_2_o2_363 = VocabularyTerm(
        code="AH_8_05_2_O2_363",
        label="AH/8.05/2/O2.363",
        description="""AH/8.05/2/O2.363""",
    )

    ah_8_05_2_o2_363c = VocabularyTerm(
        code="AH_8_05_2_O2_363C",
        label="AH/8.05/2/O2.363C",
        description="""AH/8.05/2/O2.363C""",
    )

    ah_8_05_2_o2_364 = VocabularyTerm(
        code="AH_8_05_2_O2_364",
        label="AH/8.05/2/O2.364",
        description="""AH/8.05/2/O2.364""",
    )

    ah_8_05_2_o2_365 = VocabularyTerm(
        code="AH_8_05_2_O2_365",
        label="AH/8.05/2/O2.365",
        description="""AH/8.05/2/O2.365""",
    )

    ah_8_05_2_o2_365c = VocabularyTerm(
        code="AH_8_05_2_O2_365C",
        label="AH/8.05/2/O2.365C",
        description="""AH/8.05/2/O2.365C""",
    )

    ah_8_05_2_o2_365f = VocabularyTerm(
        code="AH_8_05_2_O2_365F",
        label="AH/8.05/2/O2.365F",
        description="""AH/8.05/2/O2.365F""",
    )

    ah_8_05_2_o2_366 = VocabularyTerm(
        code="AH_8_05_2_O2_366",
        label="AH/8.05/2/O2.366",
        description="""AH/8.05/2/O2.366""",
    )

    ah_8_05_2_o2_366c = VocabularyTerm(
        code="AH_8_05_2_O2_366C",
        label="AH/8.05/2/O2.366C",
        description="""AH/8.05/2/O2.366C""",
    )

    ah_8_05_2_o2_367 = VocabularyTerm(
        code="AH_8_05_2_O2_367",
        label="AH/8.05/2/O2.367",
        description="""AH/8.05/2/O2.367""",
    )

    ah_8_05_2_o2_367c = VocabularyTerm(
        code="AH_8_05_2_O2_367C",
        label="AH/8.05/2/O2.367C",
        description="""AH/8.05/2/O2.367C""",
    )

    ah_8_05_2_o2_368 = VocabularyTerm(
        code="AH_8_05_2_O2_368",
        label="AH/8.05/2/O2.368",
        description="""AH/8.05/2/O2.368""",
    )

    ah_8_05_2_o2_368c = VocabularyTerm(
        code="AH_8_05_2_O2_368C",
        label="AH/8.05/2/O2.368C",
        description="""AH/8.05/2/O2.368C""",
    )

    ah_8_05_2_o2_369 = VocabularyTerm(
        code="AH_8_05_2_O2_369",
        label="AH/8.05/2/O2.369",
        description="""AH/8.05/2/O2.369""",
    )

    ah_8_05_2_o2_369c = VocabularyTerm(
        code="AH_8_05_2_O2_369C",
        label="AH/8.05/2/O2.369C",
        description="""AH/8.05/2/O2.369C""",
    )

    ah_8_05_2_o2_370 = VocabularyTerm(
        code="AH_8_05_2_O2_370",
        label="AH/8.05/2/O2.370",
        description="""AH/8.05/2/O2.370""",
    )

    ah_8_05_2_o2_370c = VocabularyTerm(
        code="AH_8_05_2_O2_370C",
        label="AH/8.05/2/O2.370C",
        description="""AH/8.05/2/O2.370C""",
    )

    ah_8_05_2_o2_371 = VocabularyTerm(
        code="AH_8_05_2_O2_371",
        label="AH/8.05/2/O2.371",
        description="""AH/8.05/2/O2.371""",
    )

    ah_8_05_2_o2_371c = VocabularyTerm(
        code="AH_8_05_2_O2_371C",
        label="AH/8.05/2/O2.371C",
        description="""AH/8.05/2/O2.371C""",
    )

    ah_8_05_2_o2_372 = VocabularyTerm(
        code="AH_8_05_2_O2_372",
        label="AH/8.05/2/O2.372",
        description="""AH/8.05/2/O2.372""",
    )

    ah_8_05_2_o2_373 = VocabularyTerm(
        code="AH_8_05_2_O2_373",
        label="AH/8.05/2/O2.373",
        description="""AH/8.05/2/O2.373""",
    )

    ah_8_05_2_o2_374t = VocabularyTerm(
        code="AH_8_05_2_O2_374T",
        label="AH/8.05/2/O2.374T",
        description="""AH/8.05/2/O2.374T""",
    )

    ah_8_05_2_o2_375f = VocabularyTerm(
        code="AH_8_05_2_O2_375F",
        label="AH/8.05/2/O2.375F",
        description="""AH/8.05/2/O2.375F""",
    )

    ah_8_05_2_o2_376 = VocabularyTerm(
        code="AH_8_05_2_O2_376",
        label="AH/8.05/2/O2.376",
        description="""AH/8.05/2/O2.376""",
    )

    ah_8_05_2_o2_377 = VocabularyTerm(
        code="AH_8_05_2_O2_377",
        label="AH/8.05/2/O2.377",
        description="""AH/8.05/2/O2.377""",
    )

    ah_8_05_2_o2_380f = VocabularyTerm(
        code="AH_8_05_2_O2_380F",
        label="AH/8.05/2/O2.380F",
        description="""AH/8.05/2/O2.380F""",
    )

    ah_8_05_2_o2_381c = VocabularyTerm(
        code="AH_8_05_2_O2_381C",
        label="AH/8.05/2/O2.381C",
        description="""AH/8.05/2/O2.381C""",
    )

    ah_8_05_2_o2_381f = VocabularyTerm(
        code="AH_8_05_2_O2_381F",
        label="AH/8.05/2/O2.381F",
        description="""AH/8.05/2/O2.381F""",
    )

    ah_8_05_2_o2_382 = VocabularyTerm(
        code="AH_8_05_2_O2_382",
        label="AH/8.05/2/O2.382",
        description="""AH/8.05/2/O2.382""",
    )

    ah_8_05_2_o2_382c = VocabularyTerm(
        code="AH_8_05_2_O2_382C",
        label="AH/8.05/2/O2.382C",
        description="""AH/8.05/2/O2.382C""",
    )

    ah_8_05_2_o2_383 = VocabularyTerm(
        code="AH_8_05_2_O2_383",
        label="AH/8.05/2/O2.383",
        description="""AH/8.05/2/O2.383""",
    )

    ah_8_05_2_o2_383c = VocabularyTerm(
        code="AH_8_05_2_O2_383C",
        label="AH/8.05/2/O2.383C",
        description="""AH/8.05/2/O2.383C""",
    )

    ah_8_05_2_o2_384 = VocabularyTerm(
        code="AH_8_05_2_O2_384",
        label="AH/8.05/2/O2.384",
        description="""AH/8.05/2/O2.384""",
    )

    ah_8_05_2_o2_384f = VocabularyTerm(
        code="AH_8_05_2_O2_384F",
        label="AH/8.05/2/O2.384F",
        description="""AH/8.05/2/O2.384F""",
    )

    ah_8_05_2_o2_385 = VocabularyTerm(
        code="AH_8_05_2_O2_385",
        label="AH/8.05/2/O2.385",
        description="""AH/8.05/2/O2.385""",
    )

    ah_8_05_2_o2_386 = VocabularyTerm(
        code="AH_8_05_2_O2_386",
        label="AH/8.05/2/O2.386",
        description="""AH/8.05/2/O2.386""",
    )

    ah_8_05_2_o2_387 = VocabularyTerm(
        code="AH_8_05_2_O2_387",
        label="AH/8.05/2/O2.387",
        description="""AH/8.05/2/O2.387""",
    )

    ah_8_05_2_o2_388 = VocabularyTerm(
        code="AH_8_05_2_O2_388",
        label="AH/8.05/2/O2.388",
        description="""AH/8.05/2/O2.388""",
    )

    ah_8_05_2_o2_389 = VocabularyTerm(
        code="AH_8_05_2_O2_389",
        label="AH/8.05/2/O2.389",
        description="""AH/8.05/2/O2.389""",
    )

    ah_8_05_2_o2_390 = VocabularyTerm(
        code="AH_8_05_2_O2_390",
        label="AH/8.05/2/O2.390",
        description="""AH/8.05/2/O2.390""",
    )

    ah_8_05_2_o2_390b = VocabularyTerm(
        code="AH_8_05_2_O2_390B",
        label="AH/8.05/2/O2.390B",
        description="""AH/8.05/2/O2.390B""",
    )

    ah_8_05_2_o2_390c = VocabularyTerm(
        code="AH_8_05_2_O2_390C",
        label="AH/8.05/2/O2.390C",
        description="""AH/8.05/2/O2.390C""",
    )

    ah_8_05_2_o2_391b = VocabularyTerm(
        code="AH_8_05_2_O2_391B",
        label="AH/8.05/2/O2.391B",
        description="""AH/8.05/2/O2.391B""",
    )

    ah_8_05_2_o2_391f = VocabularyTerm(
        code="AH_8_05_2_O2_391F",
        label="AH/8.05/2/O2.391F",
        description="""AH/8.05/2/O2.391F""",
    )

    ah_8_05_2_o2_392b = VocabularyTerm(
        code="AH_8_05_2_O2_392B",
        label="AH/8.05/2/O2.392B",
        description="""AH/8.05/2/O2.392B""",
    )

    ah_8_05_2_o2_392t = VocabularyTerm(
        code="AH_8_05_2_O2_392T",
        label="AH/8.05/2/O2.392T",
        description="""AH/8.05/2/O2.392T""",
    )

    ah_8_05_2_o2_393 = VocabularyTerm(
        code="AH_8_05_2_O2_393",
        label="AH/8.05/2/O2.393",
        description="""AH/8.05/2/O2.393""",
    )

    ah_8_05_2_o2_394 = VocabularyTerm(
        code="AH_8_05_2_O2_394",
        label="AH/8.05/2/O2.394",
        description="""AH/8.05/2/O2.394""",
    )

    ah_8_05_2_o2_395c = VocabularyTerm(
        code="AH_8_05_2_O2_395C",
        label="AH/8.05/2/O2.395C",
        description="""AH/8.05/2/O2.395C""",
    )

    ah_8_05_2_o2_396 = VocabularyTerm(
        code="AH_8_05_2_O2_396",
        label="AH/8.05/2/O2.396",
        description="""AH/8.05/2/O2.396""",
    )

    ah_8_05_2_o2_396c = VocabularyTerm(
        code="AH_8_05_2_O2_396C",
        label="AH/8.05/2/O2.396C",
        description="""AH/8.05/2/O2.396C""",
    )

    ah_8_05_2_o2_397 = VocabularyTerm(
        code="AH_8_05_2_O2_397",
        label="AH/8.05/2/O2.397",
        description="""AH/8.05/2/O2.397""",
    )

    ah_8_05_2_o2_397f = VocabularyTerm(
        code="AH_8_05_2_O2_397F",
        label="AH/8.05/2/O2.397F",
        description="""AH/8.05/2/O2.397F""",
    )

    ah_8_05_2_o2_s01 = VocabularyTerm(
        code="AH_8_05_2_O2_S01",
        label="AH/8.05/2/O2.S01",
        description="""AH/8.05/2/O2.S01""",
    )

    ah_8_05_2_o2_s02 = VocabularyTerm(
        code="AH_8_05_2_O2_S02",
        label="AH/8.05/2/O2.S02",
        description="""AH/8.05/2/O2.S02""",
    )

    ah_8_05_2_o2_s03 = VocabularyTerm(
        code="AH_8_05_2_O2_S03",
        label="AH/8.05/2/O2.S03",
        description="""AH/8.05/2/O2.S03""",
    )

    ah_8_05_2_o2_s04 = VocabularyTerm(
        code="AH_8_05_2_O2_S04",
        label="AH/8.05/2/O2.S04",
        description="""AH/8.05/2/O2.S04""",
    )

    ah_8_05_2_o2_s05 = VocabularyTerm(
        code="AH_8_05_2_O2_S05",
        label="AH/8.05/2/O2.S05",
        description="""AH/8.05/2/O2.S05""",
    )

    ah_8_05_3_dt_407 = VocabularyTerm(
        code="AH_8_05_3_DT_407",
        label="AH/8.05/3/DT.407",
        description="""AH/8.05/3/DT.407""",
    )

    ah_8_05_3_dt_418a2 = VocabularyTerm(
        code="AH_8_05_3_DT_418A2",
        label="AH/8.05/3/DT.418A2",
        description="""AH/8.05/3/DT.418A2""",
    )

    ah_8_05_3_dt_444t = VocabularyTerm(
        code="AH_8_05_3_DT_444T",
        label="AH/8.05/3/DT.444T",
        description="""AH/8.05/3/DT.444T""",
    )

    ah_8_05_3_dt_462 = VocabularyTerm(
        code="AH_8_05_3_DT_462",
        label="AH/8.05/3/DT.462",
        description="""AH/8.05/3/DT.462""",
    )

    ah_8_05_3_dt_s01 = VocabularyTerm(
        code="AH_8_05_3_DT_S01",
        label="AH/8.05/3/DT.S01",
        description="""AH/8.05/3/DT.S01""",
    )

    ah_8_05_3_dt_s02 = VocabularyTerm(
        code="AH_8_05_3_DT_S02",
        label="AH/8.05/3/DT.S02",
        description="""AH/8.05/3/DT.S02""",
    )

    ah_8_05_3_dt_s03 = VocabularyTerm(
        code="AH_8_05_3_DT_S03",
        label="AH/8.05/3/DT.S03",
        description="""AH/8.05/3/DT.S03""",
    )

    ah_8_05_3_dt_s04 = VocabularyTerm(
        code="AH_8_05_3_DT_S04",
        label="AH/8.05/3/DT.S04",
        description="""AH/8.05/3/DT.S04""",
    )

    ah_8_05_3_dt_s05 = VocabularyTerm(
        code="AH_8_05_3_DT_S05",
        label="AH/8.05/3/DT.S05",
        description="""AH/8.05/3/DT.S05""",
    )

    ah_8_05__1_u1_000 = VocabularyTerm(
        code="AH_8_05_-1_U1_000",
        label="AH/8.05/-1/U1.000",
        description="""AH/8.05/-1/U1.000""",
    )

    ah_8_05__1_u1_007 = VocabularyTerm(
        code="AH_8_05_-1_U1_007",
        label="AH/8.05/-1/U1.007",
        description="""AH/8.05/-1/U1.007""",
    )

    ah_8_05__1_u1_028 = VocabularyTerm(
        code="AH_8_05_-1_U1_028",
        label="AH/8.05/-1/U1.028",
        description="""AH/8.05/-1/U1.028""",
    )

    ah_8_05__1_u1_044t = VocabularyTerm(
        code="AH_8_05_-1_U1_044T",
        label="AH/8.05/-1/U1.044T",
        description="""AH/8.05/-1/U1.044T""",
    )

    ah_8_05__1_u1_062 = VocabularyTerm(
        code="AH_8_05_-1_U1_062",
        label="AH/8.05/-1/U1.062",
        description="""AH/8.05/-1/U1.062""",
    )

    ah_8_05__1_u1_083 = VocabularyTerm(
        code="AH_8_05_-1_U1_083",
        label="AH/8.05/-1/U1.083",
        description="""AH/8.05/-1/U1.083""",
    )

    ah_8_05__1_u1_092t = VocabularyTerm(
        code="AH_8_05_-1_U1_092T",
        label="AH/8.05/-1/U1.092T",
        description="""AH/8.05/-1/U1.092T""",
    )

    ah_8_06_0_101 = VocabularyTerm(
        code="AH_8_06_0_101",
        label="AH/8.06/0/101",
        description="""AH/8.06/0/101""",
    )

    ah_8_06_0_101b = VocabularyTerm(
        code="AH_8_06_0_101B",
        label="AH/8.06/0/101B",
        description="""AH/8.06/0/101B""",
    )

    ah_8_06_0_104 = VocabularyTerm(
        code="AH_8_06_0_104",
        label="AH/8.06/0/104",
        description="""AH/8.06/0/104""",
    )

    ah_8_06_0_105 = VocabularyTerm(
        code="AH_8_06_0_105",
        label="AH/8.06/0/105",
        description="""AH/8.06/0/105""",
    )

    ah_8_06_0_107 = VocabularyTerm(
        code="AH_8_06_0_107",
        label="AH/8.06/0/107",
        description="""AH/8.06/0/107""",
    )

    ah_8_06_0_107b = VocabularyTerm(
        code="AH_8_06_0_107B",
        label="AH/8.06/0/107B",
        description="""AH/8.06/0/107B""",
    )

    ah_8_06_0_108 = VocabularyTerm(
        code="AH_8_06_0_108",
        label="AH/8.06/0/108",
        description="""AH/8.06/0/108""",
    )

    ah_8_06_0_109 = VocabularyTerm(
        code="AH_8_06_0_109",
        label="AH/8.06/0/109",
        description="""AH/8.06/0/109""",
    )

    ah_8_06_0_110 = VocabularyTerm(
        code="AH_8_06_0_110",
        label="AH/8.06/0/110",
        description="""AH/8.06/0/110""",
    )

    ah_8_06_0_110b = VocabularyTerm(
        code="AH_8_06_0_110B",
        label="AH/8.06/0/110B",
        description="""AH/8.06/0/110B""",
    )

    ah_8_06_0_111 = VocabularyTerm(
        code="AH_8_06_0_111",
        label="AH/8.06/0/111",
        description="""AH/8.06/0/111""",
    )

    ah_8_06_0_113 = VocabularyTerm(
        code="AH_8_06_0_113",
        label="AH/8.06/0/113",
        description="""AH/8.06/0/113""",
    )

    ah_8_06_0_114 = VocabularyTerm(
        code="AH_8_06_0_114",
        label="AH/8.06/0/114",
        description="""AH/8.06/0/114""",
    )

    ah_8_06_0_115 = VocabularyTerm(
        code="AH_8_06_0_115",
        label="AH/8.06/0/115",
        description="""AH/8.06/0/115""",
    )

    ah_8_06_0_116 = VocabularyTerm(
        code="AH_8_06_0_116",
        label="AH/8.06/0/116",
        description="""AH/8.06/0/116""",
    )

    ah_8_06_0_117f = VocabularyTerm(
        code="AH_8_06_0_117F",
        label="AH/8.06/0/117F",
        description="""AH/8.06/0/117F""",
    )

    ah_8_06_0_118 = VocabularyTerm(
        code="AH_8_06_0_118",
        label="AH/8.06/0/118",
        description="""AH/8.06/0/118""",
    )

    ah_8_06_0_119f = VocabularyTerm(
        code="AH_8_06_0_119F",
        label="AH/8.06/0/119F",
        description="""AH/8.06/0/119F""",
    )

    ah_8_06_0_120f = VocabularyTerm(
        code="AH_8_06_0_120F",
        label="AH/8.06/0/120F",
        description="""AH/8.06/0/120F""",
    )

    ah_8_06_0_120h = VocabularyTerm(
        code="AH_8_06_0_120H",
        label="AH/8.06/0/120H",
        description="""AH/8.06/0/120H""",
    )

    ah_8_06_0_121d = VocabularyTerm(
        code="AH_8_06_0_121D",
        label="AH/8.06/0/121D",
        description="""AH/8.06/0/121D""",
    )

    ah_8_15_0_8_a1 = VocabularyTerm(
        code="AH_8_15_0_8_A1",
        label="AH/8.15/0/8.A1",
        description="""AH/8.15/0/8.A1""",
    )

    ah_8_15_0_8_a2 = VocabularyTerm(
        code="AH_8_15_0_8_A2",
        label="AH/8.15/0/8.A2",
        description="""AH/8.15/0/8.A2""",
    )

    ah_8_15_0_100f = VocabularyTerm(
        code="AH_8_15_0_100F",
        label="AH/8.15/0/100F",
        description="""AH/8.15/0/100F""",
    )

    ah_8_15_0_101 = VocabularyTerm(
        code="AH_8_15_0_101",
        label="AH/8.15/0/101",
        description="""AH/8.15/0/101""",
    )

    ah_8_15_0_101b = VocabularyTerm(
        code="AH_8_15_0_101B",
        label="AH/8.15/0/101B",
        description="""AH/8.15/0/101B""",
    )

    ah_8_15_0_101f = VocabularyTerm(
        code="AH_8_15_0_101F",
        label="AH/8.15/0/101F",
        description="""AH/8.15/0/101F""",
    )

    ah_8_15_0_101t = VocabularyTerm(
        code="AH_8_15_0_101T",
        label="AH/8.15/0/101T",
        description="""AH/8.15/0/101T""",
    )

    ah_8_15_0_102 = VocabularyTerm(
        code="AH_8_15_0_102",
        label="AH/8.15/0/102",
        description="""AH/8.15/0/102""",
    )

    ah_8_15_0_102b = VocabularyTerm(
        code="AH_8_15_0_102B",
        label="AH/8.15/0/102B",
        description="""AH/8.15/0/102B""",
    )

    ah_8_15_0_103 = VocabularyTerm(
        code="AH_8_15_0_103",
        label="AH/8.15/0/103",
        description="""AH/8.15/0/103""",
    )

    ah_8_15_0_104 = VocabularyTerm(
        code="AH_8_15_0_104",
        label="AH/8.15/0/104",
        description="""AH/8.15/0/104""",
    )

    ah_8_15_0_105f = VocabularyTerm(
        code="AH_8_15_0_105F",
        label="AH/8.15/0/105F",
        description="""AH/8.15/0/105F""",
    )

    ah_8_15_0_106 = VocabularyTerm(
        code="AH_8_15_0_106",
        label="AH/8.15/0/106",
        description="""AH/8.15/0/106""",
    )

    ah_8_15_0_107 = VocabularyTerm(
        code="AH_8_15_0_107",
        label="AH/8.15/0/107",
        description="""AH/8.15/0/107""",
    )

    ah_8_15_0_107b = VocabularyTerm(
        code="AH_8_15_0_107B",
        label="AH/8.15/0/107B",
        description="""AH/8.15/0/107B""",
    )

    ah_8_15_0_108 = VocabularyTerm(
        code="AH_8_15_0_108",
        label="AH/8.15/0/108",
        description="""AH/8.15/0/108""",
    )

    ah_8_15_0_109b = VocabularyTerm(
        code="AH_8_15_0_109B",
        label="AH/8.15/0/109B",
        description="""AH/8.15/0/109B""",
    )

    ah_8_15_0_111 = VocabularyTerm(
        code="AH_8_15_0_111",
        label="AH/8.15/0/111",
        description="""AH/8.15/0/111""",
    )

    ah_8_15_0_111b = VocabularyTerm(
        code="AH_8_15_0_111B",
        label="AH/8.15/0/111B",
        description="""AH/8.15/0/111B""",
    )

    ah_8_15_0_112 = VocabularyTerm(
        code="AH_8_15_0_112",
        label="AH/8.15/0/112",
        description="""AH/8.15/0/112""",
    )

    ah_8_15_0_113b = VocabularyTerm(
        code="AH_8_15_0_113B",
        label="AH/8.15/0/113B",
        description="""AH/8.15/0/113B""",
    )

    ah_8_15_0_114b = VocabularyTerm(
        code="AH_8_15_0_114B",
        label="AH/8.15/0/114B",
        description="""AH/8.15/0/114B""",
    )

    ah_8_15_0_116 = VocabularyTerm(
        code="AH_8_15_0_116",
        label="AH/8.15/0/116",
        description="""AH/8.15/0/116""",
    )

    ah_8_15_0_116d = VocabularyTerm(
        code="AH_8_15_0_116D",
        label="AH/8.15/0/116D",
        description="""AH/8.15/0/116D""",
    )

    ah_8_15_0_117 = VocabularyTerm(
        code="AH_8_15_0_117",
        label="AH/8.15/0/117",
        description="""AH/8.15/0/117""",
    )

    ah_8_15_0_117b = VocabularyTerm(
        code="AH_8_15_0_117B",
        label="AH/8.15/0/117B",
        description="""AH/8.15/0/117B""",
    )

    ah_8_15_0_118b = VocabularyTerm(
        code="AH_8_15_0_118B",
        label="AH/8.15/0/118B",
        description="""AH/8.15/0/118B""",
    )

    ah_8_15_0_119b = VocabularyTerm(
        code="AH_8_15_0_119B",
        label="AH/8.15/0/119B",
        description="""AH/8.15/0/119B""",
    )

    ah_8_15_0_120 = VocabularyTerm(
        code="AH_8_15_0_120",
        label="AH/8.15/0/120",
        description="""AH/8.15/0/120""",
    )

    ah_8_15_0_120h = VocabularyTerm(
        code="AH_8_15_0_120H",
        label="AH/8.15/0/120H",
        description="""AH/8.15/0/120H""",
    )

    ah_8_15_0_122 = VocabularyTerm(
        code="AH_8_15_0_122",
        label="AH/8.15/0/122",
        description="""AH/8.15/0/122""",
    )

    ah_8_15_0_122b = VocabularyTerm(
        code="AH_8_15_0_122B",
        label="AH/8.15/0/122B",
        description="""AH/8.15/0/122B""",
    )

    ah_8_15_0_123 = VocabularyTerm(
        code="AH_8_15_0_123",
        label="AH/8.15/0/123",
        description="""AH/8.15/0/123""",
    )

    ah_8_15_0_126 = VocabularyTerm(
        code="AH_8_15_0_126",
        label="AH/8.15/0/126",
        description="""AH/8.15/0/126""",
    )

    ah_8_15_0_126b = VocabularyTerm(
        code="AH_8_15_0_126B",
        label="AH/8.15/0/126B",
        description="""AH/8.15/0/126B""",
    )

    ah_8_15_0_127b = VocabularyTerm(
        code="AH_8_15_0_127B",
        label="AH/8.15/0/127B",
        description="""AH/8.15/0/127B""",
    )

    ah_8_15_0_128 = VocabularyTerm(
        code="AH_8_15_0_128",
        label="AH/8.15/0/128",
        description="""AH/8.15/0/128""",
    )

    ah_8_15_0_128b = VocabularyTerm(
        code="AH_8_15_0_128B",
        label="AH/8.15/0/128B",
        description="""AH/8.15/0/128B""",
    )

    ah_8_15_0_128dh = VocabularyTerm(
        code="AH_8_15_0_128DH",
        label="AH/8.15/0/128DH",
        description="""AH/8.15/0/128DH""",
    )

    ah_8_15_0_129b = VocabularyTerm(
        code="AH_8_15_0_129B",
        label="AH/8.15/0/129B",
        description="""AH/8.15/0/129B""",
    )

    ah_8_15_0_130dh = VocabularyTerm(
        code="AH_8_15_0_130DH",
        label="AH/8.15/0/130DH",
        description="""AH/8.15/0/130DH""",
    )

    ah_8_15_0_130f = VocabularyTerm(
        code="AH_8_15_0_130F",
        label="AH/8.15/0/130F",
        description="""AH/8.15/0/130F""",
    )

    ah_8_15_0_131 = VocabularyTerm(
        code="AH_8_15_0_131",
        label="AH/8.15/0/131",
        description="""AH/8.15/0/131""",
    )

    ah_8_15_0_131b = VocabularyTerm(
        code="AH_8_15_0_131B",
        label="AH/8.15/0/131B",
        description="""AH/8.15/0/131B""",
    )

    ah_8_15_0_132b = VocabularyTerm(
        code="AH_8_15_0_132B",
        label="AH/8.15/0/132B",
        description="""AH/8.15/0/132B""",
    )

    ah_8_15_0_135f = VocabularyTerm(
        code="AH_8_15_0_135F",
        label="AH/8.15/0/135F",
        description="""AH/8.15/0/135F""",
    )

    ah_8_15_0_136 = VocabularyTerm(
        code="AH_8_15_0_136",
        label="AH/8.15/0/136",
        description="""AH/8.15/0/136""",
    )

    ah_8_15_0_136f = VocabularyTerm(
        code="AH_8_15_0_136F",
        label="AH/8.15/0/136F",
        description="""AH/8.15/0/136F""",
    )

    ah_8_15_0_138 = VocabularyTerm(
        code="AH_8_15_0_138",
        label="AH/8.15/0/138",
        description="""AH/8.15/0/138""",
    )

    ah_8_15_0_138t = VocabularyTerm(
        code="AH_8_15_0_138T",
        label="AH/8.15/0/138T",
        description="""AH/8.15/0/138T""",
    )

    ah_8_15_0_139 = VocabularyTerm(
        code="AH_8_15_0_139",
        label="AH/8.15/0/139",
        description="""AH/8.15/0/139""",
    )

    ah_8_15_0_139f = VocabularyTerm(
        code="AH_8_15_0_139F",
        label="AH/8.15/0/139F",
        description="""AH/8.15/0/139F""",
    )

    ah_8_15_1_8_a1 = VocabularyTerm(
        code="AH_8_15_1_8_A1",
        label="AH/8.15/1/8.A1",
        description="""AH/8.15/1/8.A1""",
    )

    ah_8_15_1_8_a2 = VocabularyTerm(
        code="AH_8_15_1_8_A2",
        label="AH/8.15/1/8.A2",
        description="""AH/8.15/1/8.A2""",
    )

    ah_8_15_1_200 = VocabularyTerm(
        code="AH_8_15_1_200",
        label="AH/8.15/1/200",
        description="""AH/8.15/1/200""",
    )

    ah_8_15_1_200f = VocabularyTerm(
        code="AH_8_15_1_200F",
        label="AH/8.15/1/200F",
        description="""AH/8.15/1/200F""",
    )

    ah_8_15_1_200t = VocabularyTerm(
        code="AH_8_15_1_200T",
        label="AH/8.15/1/200T",
        description="""AH/8.15/1/200T""",
    )

    ah_8_15_1_201 = VocabularyTerm(
        code="AH_8_15_1_201",
        label="AH/8.15/1/201",
        description="""AH/8.15/1/201""",
    )

    ah_8_15_1_201f = VocabularyTerm(
        code="AH_8_15_1_201F",
        label="AH/8.15/1/201F",
        description="""AH/8.15/1/201F""",
    )

    ah_8_15_1_202 = VocabularyTerm(
        code="AH_8_15_1_202",
        label="AH/8.15/1/202",
        description="""AH/8.15/1/202""",
    )

    ah_8_15_1_203 = VocabularyTerm(
        code="AH_8_15_1_203",
        label="AH/8.15/1/203",
        description="""AH/8.15/1/203""",
    )

    ah_8_15_1_204 = VocabularyTerm(
        code="AH_8_15_1_204",
        label="AH/8.15/1/204",
        description="""AH/8.15/1/204""",
    )

    ah_8_15_1_205 = VocabularyTerm(
        code="AH_8_15_1_205",
        label="AH/8.15/1/205",
        description="""AH/8.15/1/205""",
    )

    ah_8_15_1_205b = VocabularyTerm(
        code="AH_8_15_1_205B",
        label="AH/8.15/1/205B",
        description="""AH/8.15/1/205B""",
    )

    ah_8_15_1_205f = VocabularyTerm(
        code="AH_8_15_1_205F",
        label="AH/8.15/1/205F",
        description="""AH/8.15/1/205F""",
    )

    ah_8_15_1_206 = VocabularyTerm(
        code="AH_8_15_1_206",
        label="AH/8.15/1/206",
        description="""AH/8.15/1/206""",
    )

    ah_8_15_1_207b = VocabularyTerm(
        code="AH_8_15_1_207B",
        label="AH/8.15/1/207B",
        description="""AH/8.15/1/207B""",
    )

    ah_8_15_1_208 = VocabularyTerm(
        code="AH_8_15_1_208",
        label="AH/8.15/1/208",
        description="""AH/8.15/1/208""",
    )

    ah_8_15_1_209 = VocabularyTerm(
        code="AH_8_15_1_209",
        label="AH/8.15/1/209",
        description="""AH/8.15/1/209""",
    )

    ah_8_15_1_209b = VocabularyTerm(
        code="AH_8_15_1_209B",
        label="AH/8.15/1/209B",
        description="""AH/8.15/1/209B""",
    )

    ah_8_15_1_210 = VocabularyTerm(
        code="AH_8_15_1_210",
        label="AH/8.15/1/210",
        description="""AH/8.15/1/210""",
    )

    ah_8_15_1_210b = VocabularyTerm(
        code="AH_8_15_1_210B",
        label="AH/8.15/1/210B",
        description="""AH/8.15/1/210B""",
    )

    ah_8_15_1_211 = VocabularyTerm(
        code="AH_8_15_1_211",
        label="AH/8.15/1/211",
        description="""AH/8.15/1/211""",
    )

    ah_8_15_1_211b = VocabularyTerm(
        code="AH_8_15_1_211B",
        label="AH/8.15/1/211B",
        description="""AH/8.15/1/211B""",
    )

    ah_8_15_1_212 = VocabularyTerm(
        code="AH_8_15_1_212",
        label="AH/8.15/1/212",
        description="""AH/8.15/1/212""",
    )

    ah_8_15_1_213b = VocabularyTerm(
        code="AH_8_15_1_213B",
        label="AH/8.15/1/213B",
        description="""AH/8.15/1/213B""",
    )

    ah_8_15_1_214 = VocabularyTerm(
        code="AH_8_15_1_214",
        label="AH/8.15/1/214",
        description="""AH/8.15/1/214""",
    )

    ah_8_15_1_214b = VocabularyTerm(
        code="AH_8_15_1_214B",
        label="AH/8.15/1/214B",
        description="""AH/8.15/1/214B""",
    )

    ah_8_15_1_215 = VocabularyTerm(
        code="AH_8_15_1_215",
        label="AH/8.15/1/215",
        description="""AH/8.15/1/215""",
    )

    ah_8_15_1_215h = VocabularyTerm(
        code="AH_8_15_1_215H",
        label="AH/8.15/1/215H",
        description="""AH/8.15/1/215H""",
    )

    ah_8_15_1_216 = VocabularyTerm(
        code="AH_8_15_1_216",
        label="AH/8.15/1/216",
        description="""AH/8.15/1/216""",
    )

    ah_8_15_1_216b = VocabularyTerm(
        code="AH_8_15_1_216B",
        label="AH/8.15/1/216B",
        description="""AH/8.15/1/216B""",
    )

    ah_8_15_1_217 = VocabularyTerm(
        code="AH_8_15_1_217",
        label="AH/8.15/1/217",
        description="""AH/8.15/1/217""",
    )

    ah_8_15_1_217b = VocabularyTerm(
        code="AH_8_15_1_217B",
        label="AH/8.15/1/217B",
        description="""AH/8.15/1/217B""",
    )

    ah_8_15_1_218 = VocabularyTerm(
        code="AH_8_15_1_218",
        label="AH/8.15/1/218",
        description="""AH/8.15/1/218""",
    )

    ah_8_15_1_218b = VocabularyTerm(
        code="AH_8_15_1_218B",
        label="AH/8.15/1/218B",
        description="""AH/8.15/1/218B""",
    )

    ah_8_15_1_219b = VocabularyTerm(
        code="AH_8_15_1_219B",
        label="AH/8.15/1/219B",
        description="""AH/8.15/1/219B""",
    )

    ah_8_15_1_220 = VocabularyTerm(
        code="AH_8_15_1_220",
        label="AH/8.15/1/220",
        description="""AH/8.15/1/220""",
    )

    ah_8_15_1_221 = VocabularyTerm(
        code="AH_8_15_1_221",
        label="AH/8.15/1/221",
        description="""AH/8.15/1/221""",
    )

    ah_8_15_1_221b = VocabularyTerm(
        code="AH_8_15_1_221B",
        label="AH/8.15/1/221B",
        description="""AH/8.15/1/221B""",
    )

    ah_8_15_1_222 = VocabularyTerm(
        code="AH_8_15_1_222",
        label="AH/8.15/1/222",
        description="""AH/8.15/1/222""",
    )

    ah_8_15_1_222b = VocabularyTerm(
        code="AH_8_15_1_222B",
        label="AH/8.15/1/222B",
        description="""AH/8.15/1/222B""",
    )

    ah_8_15_1_224 = VocabularyTerm(
        code="AH_8_15_1_224",
        label="AH/8.15/1/224",
        description="""AH/8.15/1/224""",
    )

    ah_8_15_1_224b = VocabularyTerm(
        code="AH_8_15_1_224B",
        label="AH/8.15/1/224B",
        description="""AH/8.15/1/224B""",
    )

    ah_8_15_1_225 = VocabularyTerm(
        code="AH_8_15_1_225",
        label="AH/8.15/1/225",
        description="""AH/8.15/1/225""",
    )

    ah_8_15_1_225d = VocabularyTerm(
        code="AH_8_15_1_225D",
        label="AH/8.15/1/225D",
        description="""AH/8.15/1/225D""",
    )

    ah_8_15_1_226 = VocabularyTerm(
        code="AH_8_15_1_226",
        label="AH/8.15/1/226",
        description="""AH/8.15/1/226""",
    )

    ah_8_15_1_227 = VocabularyTerm(
        code="AH_8_15_1_227",
        label="AH/8.15/1/227",
        description="""AH/8.15/1/227""",
    )

    ah_8_15_1_227b = VocabularyTerm(
        code="AH_8_15_1_227B",
        label="AH/8.15/1/227B",
        description="""AH/8.15/1/227B""",
    )

    ah_8_15_1_228 = VocabularyTerm(
        code="AH_8_15_1_228",
        label="AH/8.15/1/228",
        description="""AH/8.15/1/228""",
    )

    ah_8_15_1_229b = VocabularyTerm(
        code="AH_8_15_1_229B",
        label="AH/8.15/1/229B",
        description="""AH/8.15/1/229B""",
    )

    ah_8_15_1_231 = VocabularyTerm(
        code="AH_8_15_1_231",
        label="AH/8.15/1/231",
        description="""AH/8.15/1/231""",
    )

    ah_8_15_1_231b = VocabularyTerm(
        code="AH_8_15_1_231B",
        label="AH/8.15/1/231B",
        description="""AH/8.15/1/231B""",
    )

    ah_8_15_1_232 = VocabularyTerm(
        code="AH_8_15_1_232",
        label="AH/8.15/1/232",
        description="""AH/8.15/1/232""",
    )

    ah_8_15_1_233 = VocabularyTerm(
        code="AH_8_15_1_233",
        label="AH/8.15/1/233",
        description="""AH/8.15/1/233""",
    )

    ah_8_15_1_234 = VocabularyTerm(
        code="AH_8_15_1_234",
        label="AH/8.15/1/234",
        description="""AH/8.15/1/234""",
    )

    ah_8_15_1_235 = VocabularyTerm(
        code="AH_8_15_1_235",
        label="AH/8.15/1/235",
        description="""AH/8.15/1/235""",
    )

    ah_8_15_1_235f = VocabularyTerm(
        code="AH_8_15_1_235F",
        label="AH/8.15/1/235F",
        description="""AH/8.15/1/235F""",
    )

    ah_8_15_1_236 = VocabularyTerm(
        code="AH_8_15_1_236",
        label="AH/8.15/1/236",
        description="""AH/8.15/1/236""",
    )

    ah_8_15_1_238f = VocabularyTerm(
        code="AH_8_15_1_238F",
        label="AH/8.15/1/238F",
        description="""AH/8.15/1/238F""",
    )

    ah_8_15_1_238t = VocabularyTerm(
        code="AH_8_15_1_238T",
        label="AH/8.15/1/238T",
        description="""AH/8.15/1/238T""",
    )

    ah_8_15_1_239 = VocabularyTerm(
        code="AH_8_15_1_239",
        label="AH/8.15/1/239",
        description="""AH/8.15/1/239""",
    )

    ah_8_15_1_239f = VocabularyTerm(
        code="AH_8_15_1_239F",
        label="AH/8.15/1/239F",
        description="""AH/8.15/1/239F""",
    )

    ah_8_15_2_8_a1 = VocabularyTerm(
        code="AH_8_15_2_8_A1",
        label="AH/8.15/2/8.A1",
        description="""AH/8.15/2/8.A1""",
    )

    ah_8_15_2_8_a2 = VocabularyTerm(
        code="AH_8_15_2_8_A2",
        label="AH/8.15/2/8.A2",
        description="""AH/8.15/2/8.A2""",
    )

    ah_8_15_2_300 = VocabularyTerm(
        code="AH_8_15_2_300",
        label="AH/8.15/2/300",
        description="""AH/8.15/2/300""",
    )

    ah_8_15_2_300f = VocabularyTerm(
        code="AH_8_15_2_300F",
        label="AH/8.15/2/300F",
        description="""AH/8.15/2/300F""",
    )

    ah_8_15_2_300t = VocabularyTerm(
        code="AH_8_15_2_300T",
        label="AH/8.15/2/300T",
        description="""AH/8.15/2/300T""",
    )

    ah_8_15_2_301 = VocabularyTerm(
        code="AH_8_15_2_301",
        label="AH/8.15/2/301",
        description="""AH/8.15/2/301""",
    )

    ah_8_15_2_301f = VocabularyTerm(
        code="AH_8_15_2_301F",
        label="AH/8.15/2/301F",
        description="""AH/8.15/2/301F""",
    )

    ah_8_15_2_302 = VocabularyTerm(
        code="AH_8_15_2_302",
        label="AH/8.15/2/302",
        description="""AH/8.15/2/302""",
    )

    ah_8_15_2_304 = VocabularyTerm(
        code="AH_8_15_2_304",
        label="AH/8.15/2/304",
        description="""AH/8.15/2/304""",
    )

    ah_8_15_2_305 = VocabularyTerm(
        code="AH_8_15_2_305",
        label="AH/8.15/2/305",
        description="""AH/8.15/2/305""",
    )

    ah_8_15_2_305b = VocabularyTerm(
        code="AH_8_15_2_305B",
        label="AH/8.15/2/305B",
        description="""AH/8.15/2/305B""",
    )

    ah_8_15_2_305f = VocabularyTerm(
        code="AH_8_15_2_305F",
        label="AH/8.15/2/305F",
        description="""AH/8.15/2/305F""",
    )

    ah_8_15_2_306 = VocabularyTerm(
        code="AH_8_15_2_306",
        label="AH/8.15/2/306",
        description="""AH/8.15/2/306""",
    )

    ah_8_15_2_307 = VocabularyTerm(
        code="AH_8_15_2_307",
        label="AH/8.15/2/307",
        description="""AH/8.15/2/307""",
    )

    ah_8_15_2_307b = VocabularyTerm(
        code="AH_8_15_2_307B",
        label="AH/8.15/2/307B",
        description="""AH/8.15/2/307B""",
    )

    ah_8_15_2_308 = VocabularyTerm(
        code="AH_8_15_2_308",
        label="AH/8.15/2/308",
        description="""AH/8.15/2/308""",
    )

    ah_8_15_2_309 = VocabularyTerm(
        code="AH_8_15_2_309",
        label="AH/8.15/2/309",
        description="""AH/8.15/2/309""",
    )

    ah_8_15_2_309b = VocabularyTerm(
        code="AH_8_15_2_309B",
        label="AH/8.15/2/309B",
        description="""AH/8.15/2/309B""",
    )

    ah_8_15_2_310 = VocabularyTerm(
        code="AH_8_15_2_310",
        label="AH/8.15/2/310",
        description="""AH/8.15/2/310""",
    )

    ah_8_15_2_311b = VocabularyTerm(
        code="AH_8_15_2_311B",
        label="AH/8.15/2/311B",
        description="""AH/8.15/2/311B""",
    )

    ah_8_15_2_312 = VocabularyTerm(
        code="AH_8_15_2_312",
        label="AH/8.15/2/312",
        description="""AH/8.15/2/312""",
    )

    ah_8_15_2_313 = VocabularyTerm(
        code="AH_8_15_2_313",
        label="AH/8.15/2/313",
        description="""AH/8.15/2/313""",
    )

    ah_8_15_2_313b = VocabularyTerm(
        code="AH_8_15_2_313B",
        label="AH/8.15/2/313B",
        description="""AH/8.15/2/313B""",
    )

    ah_8_15_2_314 = VocabularyTerm(
        code="AH_8_15_2_314",
        label="AH/8.15/2/314",
        description="""AH/8.15/2/314""",
    )

    ah_8_15_2_314b = VocabularyTerm(
        code="AH_8_15_2_314B",
        label="AH/8.15/2/314B",
        description="""AH/8.15/2/314B""",
    )

    ah_8_15_2_315h = VocabularyTerm(
        code="AH_8_15_2_315H",
        label="AH/8.15/2/315H",
        description="""AH/8.15/2/315H""",
    )

    ah_8_15_2_316 = VocabularyTerm(
        code="AH_8_15_2_316",
        label="AH/8.15/2/316",
        description="""AH/8.15/2/316""",
    )

    ah_8_15_2_316b = VocabularyTerm(
        code="AH_8_15_2_316B",
        label="AH/8.15/2/316B",
        description="""AH/8.15/2/316B""",
    )

    ah_8_15_2_317 = VocabularyTerm(
        code="AH_8_15_2_317",
        label="AH/8.15/2/317",
        description="""AH/8.15/2/317""",
    )

    ah_8_15_2_317b = VocabularyTerm(
        code="AH_8_15_2_317B",
        label="AH/8.15/2/317B",
        description="""AH/8.15/2/317B""",
    )

    ah_8_15_2_318 = VocabularyTerm(
        code="AH_8_15_2_318",
        label="AH/8.15/2/318",
        description="""AH/8.15/2/318""",
    )

    ah_8_15_2_318b = VocabularyTerm(
        code="AH_8_15_2_318B",
        label="AH/8.15/2/318B",
        description="""AH/8.15/2/318B""",
    )

    ah_8_15_2_319 = VocabularyTerm(
        code="AH_8_15_2_319",
        label="AH/8.15/2/319",
        description="""AH/8.15/2/319""",
    )

    ah_8_15_2_319b = VocabularyTerm(
        code="AH_8_15_2_319B",
        label="AH/8.15/2/319B",
        description="""AH/8.15/2/319B""",
    )

    ah_8_15_2_320 = VocabularyTerm(
        code="AH_8_15_2_320",
        label="AH/8.15/2/320",
        description="""AH/8.15/2/320""",
    )

    ah_8_15_2_321 = VocabularyTerm(
        code="AH_8_15_2_321",
        label="AH/8.15/2/321",
        description="""AH/8.15/2/321""",
    )

    ah_8_15_2_321b = VocabularyTerm(
        code="AH_8_15_2_321B",
        label="AH/8.15/2/321B",
        description="""AH/8.15/2/321B""",
    )

    ah_8_15_2_322 = VocabularyTerm(
        code="AH_8_15_2_322",
        label="AH/8.15/2/322",
        description="""AH/8.15/2/322""",
    )

    ah_8_15_2_322b = VocabularyTerm(
        code="AH_8_15_2_322B",
        label="AH/8.15/2/322B",
        description="""AH/8.15/2/322B""",
    )

    ah_8_15_2_323 = VocabularyTerm(
        code="AH_8_15_2_323",
        label="AH/8.15/2/323",
        description="""AH/8.15/2/323""",
    )

    ah_8_15_2_324 = VocabularyTerm(
        code="AH_8_15_2_324",
        label="AH/8.15/2/324",
        description="""AH/8.15/2/324""",
    )

    ah_8_15_2_324b = VocabularyTerm(
        code="AH_8_15_2_324B",
        label="AH/8.15/2/324B",
        description="""AH/8.15/2/324B""",
    )

    ah_8_15_2_325d = VocabularyTerm(
        code="AH_8_15_2_325D",
        label="AH/8.15/2/325D",
        description="""AH/8.15/2/325D""",
    )

    ah_8_15_2_326 = VocabularyTerm(
        code="AH_8_15_2_326",
        label="AH/8.15/2/326",
        description="""AH/8.15/2/326""",
    )

    ah_8_15_2_327 = VocabularyTerm(
        code="AH_8_15_2_327",
        label="AH/8.15/2/327",
        description="""AH/8.15/2/327""",
    )

    ah_8_15_2_327b = VocabularyTerm(
        code="AH_8_15_2_327B",
        label="AH/8.15/2/327B",
        description="""AH/8.15/2/327B""",
    )

    ah_8_15_2_328 = VocabularyTerm(
        code="AH_8_15_2_328",
        label="AH/8.15/2/328",
        description="""AH/8.15/2/328""",
    )

    ah_8_15_2_329 = VocabularyTerm(
        code="AH_8_15_2_329",
        label="AH/8.15/2/329",
        description="""AH/8.15/2/329""",
    )

    ah_8_15_2_329b = VocabularyTerm(
        code="AH_8_15_2_329B",
        label="AH/8.15/2/329B",
        description="""AH/8.15/2/329B""",
    )

    ah_8_15_2_330 = VocabularyTerm(
        code="AH_8_15_2_330",
        label="AH/8.15/2/330",
        description="""AH/8.15/2/330""",
    )

    ah_8_15_2_331 = VocabularyTerm(
        code="AH_8_15_2_331",
        label="AH/8.15/2/331",
        description="""AH/8.15/2/331""",
    )

    ah_8_15_2_331b = VocabularyTerm(
        code="AH_8_15_2_331B",
        label="AH/8.15/2/331B",
        description="""AH/8.15/2/331B""",
    )

    ah_8_15_2_332 = VocabularyTerm(
        code="AH_8_15_2_332",
        label="AH/8.15/2/332",
        description="""AH/8.15/2/332""",
    )

    ah_8_15_2_333 = VocabularyTerm(
        code="AH_8_15_2_333",
        label="AH/8.15/2/333",
        description="""AH/8.15/2/333""",
    )

    ah_8_15_2_334 = VocabularyTerm(
        code="AH_8_15_2_334",
        label="AH/8.15/2/334",
        description="""AH/8.15/2/334""",
    )

    ah_8_15_2_335 = VocabularyTerm(
        code="AH_8_15_2_335",
        label="AH/8.15/2/335",
        description="""AH/8.15/2/335""",
    )

    ah_8_15_2_335f = VocabularyTerm(
        code="AH_8_15_2_335F",
        label="AH/8.15/2/335F",
        description="""AH/8.15/2/335F""",
    )

    ah_8_15_2_336 = VocabularyTerm(
        code="AH_8_15_2_336",
        label="AH/8.15/2/336",
        description="""AH/8.15/2/336""",
    )

    ah_8_15_2_338 = VocabularyTerm(
        code="AH_8_15_2_338",
        label="AH/8.15/2/338",
        description="""AH/8.15/2/338""",
    )

    ah_8_15_2_338f = VocabularyTerm(
        code="AH_8_15_2_338F",
        label="AH/8.15/2/338F",
        description="""AH/8.15/2/338F""",
    )

    ah_8_15_2_338t = VocabularyTerm(
        code="AH_8_15_2_338T",
        label="AH/8.15/2/338T",
        description="""AH/8.15/2/338T""",
    )

    ah_8_15_2_339 = VocabularyTerm(
        code="AH_8_15_2_339",
        label="AH/8.15/2/339",
        description="""AH/8.15/2/339""",
    )

    ah_8_15_2_339f = VocabularyTerm(
        code="AH_8_15_2_339F",
        label="AH/8.15/2/339F",
        description="""AH/8.15/2/339F""",
    )

    ah_8_15_3_8_a1 = VocabularyTerm(
        code="AH_8_15_3_8_A1",
        label="AH/8.15/3/8.A1",
        description="""AH/8.15/3/8.A1""",
    )

    ah_8_15_3_8_a2 = VocabularyTerm(
        code="AH_8_15_3_8_A2",
        label="AH/8.15/3/8.A2",
        description="""AH/8.15/3/8.A2""",
    )

    ah_8_15_3_400 = VocabularyTerm(
        code="AH_8_15_3_400",
        label="AH/8.15/3/400",
        description="""AH/8.15/3/400""",
    )

    ah_8_15_3_400f = VocabularyTerm(
        code="AH_8_15_3_400F",
        label="AH/8.15/3/400F",
        description="""AH/8.15/3/400F""",
    )

    ah_8_15_3_400t = VocabularyTerm(
        code="AH_8_15_3_400T",
        label="AH/8.15/3/400T",
        description="""AH/8.15/3/400T""",
    )

    ah_8_15_3_401 = VocabularyTerm(
        code="AH_8_15_3_401",
        label="AH/8.15/3/401",
        description="""AH/8.15/3/401""",
    )

    ah_8_15_3_401f = VocabularyTerm(
        code="AH_8_15_3_401F",
        label="AH/8.15/3/401F",
        description="""AH/8.15/3/401F""",
    )

    ah_8_15_3_402 = VocabularyTerm(
        code="AH_8_15_3_402",
        label="AH/8.15/3/402",
        description="""AH/8.15/3/402""",
    )

    ah_8_15_3_403 = VocabularyTerm(
        code="AH_8_15_3_403",
        label="AH/8.15/3/403",
        description="""AH/8.15/3/403""",
    )

    ah_8_15_3_404 = VocabularyTerm(
        code="AH_8_15_3_404",
        label="AH/8.15/3/404",
        description="""AH/8.15/3/404""",
    )

    ah_8_15_3_405 = VocabularyTerm(
        code="AH_8_15_3_405",
        label="AH/8.15/3/405",
        description="""AH/8.15/3/405""",
    )

    ah_8_15_3_405b = VocabularyTerm(
        code="AH_8_15_3_405B",
        label="AH/8.15/3/405B",
        description="""AH/8.15/3/405B""",
    )

    ah_8_15_3_405f = VocabularyTerm(
        code="AH_8_15_3_405F",
        label="AH/8.15/3/405F",
        description="""AH/8.15/3/405F""",
    )

    ah_8_15_3_406 = VocabularyTerm(
        code="AH_8_15_3_406",
        label="AH/8.15/3/406",
        description="""AH/8.15/3/406""",
    )

    ah_8_15_3_407b = VocabularyTerm(
        code="AH_8_15_3_407B",
        label="AH/8.15/3/407B",
        description="""AH/8.15/3/407B""",
    )

    ah_8_15_3_408 = VocabularyTerm(
        code="AH_8_15_3_408",
        label="AH/8.15/3/408",
        description="""AH/8.15/3/408""",
    )

    ah_8_15_3_409 = VocabularyTerm(
        code="AH_8_15_3_409",
        label="AH/8.15/3/409",
        description="""AH/8.15/3/409""",
    )

    ah_8_15_3_409b = VocabularyTerm(
        code="AH_8_15_3_409B",
        label="AH/8.15/3/409B",
        description="""AH/8.15/3/409B""",
    )

    ah_8_15_3_410 = VocabularyTerm(
        code="AH_8_15_3_410",
        label="AH/8.15/3/410",
        description="""AH/8.15/3/410""",
    )

    ah_8_15_3_411 = VocabularyTerm(
        code="AH_8_15_3_411",
        label="AH/8.15/3/411",
        description="""AH/8.15/3/411""",
    )

    ah_8_15_3_411b = VocabularyTerm(
        code="AH_8_15_3_411B",
        label="AH/8.15/3/411B",
        description="""AH/8.15/3/411B""",
    )

    ah_8_15_3_412 = VocabularyTerm(
        code="AH_8_15_3_412",
        label="AH/8.15/3/412",
        description="""AH/8.15/3/412""",
    )

    ah_8_15_3_413 = VocabularyTerm(
        code="AH_8_15_3_413",
        label="AH/8.15/3/413",
        description="""AH/8.15/3/413""",
    )

    ah_8_15_3_413b = VocabularyTerm(
        code="AH_8_15_3_413B",
        label="AH/8.15/3/413B",
        description="""AH/8.15/3/413B""",
    )

    ah_8_15_3_414 = VocabularyTerm(
        code="AH_8_15_3_414",
        label="AH/8.15/3/414",
        description="""AH/8.15/3/414""",
    )

    ah_8_15_3_414b = VocabularyTerm(
        code="AH_8_15_3_414B",
        label="AH/8.15/3/414B",
        description="""AH/8.15/3/414B""",
    )

    ah_8_15_3_415 = VocabularyTerm(
        code="AH_8_15_3_415",
        label="AH/8.15/3/415",
        description="""AH/8.15/3/415""",
    )

    ah_8_15_3_415h = VocabularyTerm(
        code="AH_8_15_3_415H",
        label="AH/8.15/3/415H",
        description="""AH/8.15/3/415H""",
    )

    ah_8_15_3_416 = VocabularyTerm(
        code="AH_8_15_3_416",
        label="AH/8.15/3/416",
        description="""AH/8.15/3/416""",
    )

    ah_8_15_3_416b = VocabularyTerm(
        code="AH_8_15_3_416B",
        label="AH/8.15/3/416B",
        description="""AH/8.15/3/416B""",
    )

    ah_8_15_3_417 = VocabularyTerm(
        code="AH_8_15_3_417",
        label="AH/8.15/3/417",
        description="""AH/8.15/3/417""",
    )

    ah_8_15_3_417b = VocabularyTerm(
        code="AH_8_15_3_417B",
        label="AH/8.15/3/417B",
        description="""AH/8.15/3/417B""",
    )

    ah_8_15_3_418 = VocabularyTerm(
        code="AH_8_15_3_418",
        label="AH/8.15/3/418",
        description="""AH/8.15/3/418""",
    )

    ah_8_15_3_418b = VocabularyTerm(
        code="AH_8_15_3_418B",
        label="AH/8.15/3/418B",
        description="""AH/8.15/3/418B""",
    )

    ah_8_15_3_419b = VocabularyTerm(
        code="AH_8_15_3_419B",
        label="AH/8.15/3/419B",
        description="""AH/8.15/3/419B""",
    )

    ah_8_15_3_420 = VocabularyTerm(
        code="AH_8_15_3_420",
        label="AH/8.15/3/420",
        description="""AH/8.15/3/420""",
    )

    ah_8_15_3_421 = VocabularyTerm(
        code="AH_8_15_3_421",
        label="AH/8.15/3/421",
        description="""AH/8.15/3/421""",
    )

    ah_8_15_3_421b = VocabularyTerm(
        code="AH_8_15_3_421B",
        label="AH/8.15/3/421B",
        description="""AH/8.15/3/421B""",
    )

    ah_8_15_3_422 = VocabularyTerm(
        code="AH_8_15_3_422",
        label="AH/8.15/3/422",
        description="""AH/8.15/3/422""",
    )

    ah_8_15_3_422b = VocabularyTerm(
        code="AH_8_15_3_422B",
        label="AH/8.15/3/422B",
        description="""AH/8.15/3/422B""",
    )

    ah_8_15_3_424 = VocabularyTerm(
        code="AH_8_15_3_424",
        label="AH/8.15/3/424",
        description="""AH/8.15/3/424""",
    )

    ah_8_15_3_424b = VocabularyTerm(
        code="AH_8_15_3_424B",
        label="AH/8.15/3/424B",
        description="""AH/8.15/3/424B""",
    )

    ah_8_15_3_425d = VocabularyTerm(
        code="AH_8_15_3_425D",
        label="AH/8.15/3/425D",
        description="""AH/8.15/3/425D""",
    )

    ah_8_15_3_426 = VocabularyTerm(
        code="AH_8_15_3_426",
        label="AH/8.15/3/426",
        description="""AH/8.15/3/426""",
    )

    ah_8_15_3_427 = VocabularyTerm(
        code="AH_8_15_3_427",
        label="AH/8.15/3/427",
        description="""AH/8.15/3/427""",
    )

    ah_8_15_3_427b = VocabularyTerm(
        code="AH_8_15_3_427B",
        label="AH/8.15/3/427B",
        description="""AH/8.15/3/427B""",
    )

    ah_8_15_3_428 = VocabularyTerm(
        code="AH_8_15_3_428",
        label="AH/8.15/3/428",
        description="""AH/8.15/3/428""",
    )

    ah_8_15_3_429 = VocabularyTerm(
        code="AH_8_15_3_429",
        label="AH/8.15/3/429",
        description="""AH/8.15/3/429""",
    )

    ah_8_15_3_429b = VocabularyTerm(
        code="AH_8_15_3_429B",
        label="AH/8.15/3/429B",
        description="""AH/8.15/3/429B""",
    )

    ah_8_15_3_430 = VocabularyTerm(
        code="AH_8_15_3_430",
        label="AH/8.15/3/430",
        description="""AH/8.15/3/430""",
    )

    ah_8_15_3_431 = VocabularyTerm(
        code="AH_8_15_3_431",
        label="AH/8.15/3/431",
        description="""AH/8.15/3/431""",
    )

    ah_8_15_3_431b = VocabularyTerm(
        code="AH_8_15_3_431B",
        label="AH/8.15/3/431B",
        description="""AH/8.15/3/431B""",
    )

    ah_8_15_3_432 = VocabularyTerm(
        code="AH_8_15_3_432",
        label="AH/8.15/3/432",
        description="""AH/8.15/3/432""",
    )

    ah_8_15_3_433 = VocabularyTerm(
        code="AH_8_15_3_433",
        label="AH/8.15/3/433",
        description="""AH/8.15/3/433""",
    )

    ah_8_15_3_434 = VocabularyTerm(
        code="AH_8_15_3_434",
        label="AH/8.15/3/434",
        description="""AH/8.15/3/434""",
    )

    ah_8_15_3_435 = VocabularyTerm(
        code="AH_8_15_3_435",
        label="AH/8.15/3/435",
        description="""AH/8.15/3/435""",
    )

    ah_8_15_3_435f = VocabularyTerm(
        code="AH_8_15_3_435F",
        label="AH/8.15/3/435F",
        description="""AH/8.15/3/435F""",
    )

    ah_8_15_3_436 = VocabularyTerm(
        code="AH_8_15_3_436",
        label="AH/8.15/3/436",
        description="""AH/8.15/3/436""",
    )

    ah_8_15_3_437 = VocabularyTerm(
        code="AH_8_15_3_437",
        label="AH/8.15/3/437",
        description="""AH/8.15/3/437""",
    )

    ah_8_15_3_438f = VocabularyTerm(
        code="AH_8_15_3_438F",
        label="AH/8.15/3/438F",
        description="""AH/8.15/3/438F""",
    )

    ah_8_15_3_438t = VocabularyTerm(
        code="AH_8_15_3_438T",
        label="AH/8.15/3/438T",
        description="""AH/8.15/3/438T""",
    )

    ah_8_15_3_439 = VocabularyTerm(
        code="AH_8_15_3_439",
        label="AH/8.15/3/439",
        description="""AH/8.15/3/439""",
    )

    ah_8_15_3_439f = VocabularyTerm(
        code="AH_8_15_3_439F",
        label="AH/8.15/3/439F",
        description="""AH/8.15/3/439F""",
    )

    ah_8_15_4_8_a1 = VocabularyTerm(
        code="AH_8_15_4_8_A1",
        label="AH/8.15/4/8.A1",
        description="""AH/8.15/4/8.A1""",
    )

    ah_8_15_4_8_a2 = VocabularyTerm(
        code="AH_8_15_4_8_A2",
        label="AH/8.15/4/8.A2",
        description="""AH/8.15/4/8.A2""",
    )

    ah_8_15_4_500 = VocabularyTerm(
        code="AH_8_15_4_500",
        label="AH/8.15/4/500",
        description="""AH/8.15/4/500""",
    )

    ah_8_15_4_500f = VocabularyTerm(
        code="AH_8_15_4_500F",
        label="AH/8.15/4/500F",
        description="""AH/8.15/4/500F""",
    )

    ah_8_15_4_500t = VocabularyTerm(
        code="AH_8_15_4_500T",
        label="AH/8.15/4/500T",
        description="""AH/8.15/4/500T""",
    )

    ah_8_15_4_501 = VocabularyTerm(
        code="AH_8_15_4_501",
        label="AH/8.15/4/501",
        description="""AH/8.15/4/501""",
    )

    ah_8_15_4_501f = VocabularyTerm(
        code="AH_8_15_4_501F",
        label="AH/8.15/4/501F",
        description="""AH/8.15/4/501F""",
    )

    ah_8_15_4_502 = VocabularyTerm(
        code="AH_8_15_4_502",
        label="AH/8.15/4/502",
        description="""AH/8.15/4/502""",
    )

    ah_8_15_4_503 = VocabularyTerm(
        code="AH_8_15_4_503",
        label="AH/8.15/4/503",
        description="""AH/8.15/4/503""",
    )

    ah_8_15_4_504 = VocabularyTerm(
        code="AH_8_15_4_504",
        label="AH/8.15/4/504",
        description="""AH/8.15/4/504""",
    )

    ah_8_15_4_505 = VocabularyTerm(
        code="AH_8_15_4_505",
        label="AH/8.15/4/505",
        description="""AH/8.15/4/505""",
    )

    ah_8_15_4_505b = VocabularyTerm(
        code="AH_8_15_4_505B",
        label="AH/8.15/4/505B",
        description="""AH/8.15/4/505B""",
    )

    ah_8_15_4_505f = VocabularyTerm(
        code="AH_8_15_4_505F",
        label="AH/8.15/4/505F",
        description="""AH/8.15/4/505F""",
    )

    ah_8_15_4_506 = VocabularyTerm(
        code="AH_8_15_4_506",
        label="AH/8.15/4/506",
        description="""AH/8.15/4/506""",
    )

    ah_8_15_4_507b = VocabularyTerm(
        code="AH_8_15_4_507B",
        label="AH/8.15/4/507B",
        description="""AH/8.15/4/507B""",
    )

    ah_8_15_4_508 = VocabularyTerm(
        code="AH_8_15_4_508",
        label="AH/8.15/4/508",
        description="""AH/8.15/4/508""",
    )

    ah_8_15_4_509 = VocabularyTerm(
        code="AH_8_15_4_509",
        label="AH/8.15/4/509",
        description="""AH/8.15/4/509""",
    )

    ah_8_15_4_509b = VocabularyTerm(
        code="AH_8_15_4_509B",
        label="AH/8.15/4/509B",
        description="""AH/8.15/4/509B""",
    )

    ah_8_15_4_510 = VocabularyTerm(
        code="AH_8_15_4_510",
        label="AH/8.15/4/510",
        description="""AH/8.15/4/510""",
    )

    ah_8_15_4_511 = VocabularyTerm(
        code="AH_8_15_4_511",
        label="AH/8.15/4/511",
        description="""AH/8.15/4/511""",
    )

    ah_8_15_4_511b = VocabularyTerm(
        code="AH_8_15_4_511B",
        label="AH/8.15/4/511B",
        description="""AH/8.15/4/511B""",
    )

    ah_8_15_4_512 = VocabularyTerm(
        code="AH_8_15_4_512",
        label="AH/8.15/4/512",
        description="""AH/8.15/4/512""",
    )

    ah_8_15_4_513 = VocabularyTerm(
        code="AH_8_15_4_513",
        label="AH/8.15/4/513",
        description="""AH/8.15/4/513""",
    )

    ah_8_15_4_513b = VocabularyTerm(
        code="AH_8_15_4_513B",
        label="AH/8.15/4/513B",
        description="""AH/8.15/4/513B""",
    )

    ah_8_15_4_514 = VocabularyTerm(
        code="AH_8_15_4_514",
        label="AH/8.15/4/514",
        description="""AH/8.15/4/514""",
    )

    ah_8_15_4_514b = VocabularyTerm(
        code="AH_8_15_4_514B",
        label="AH/8.15/4/514B",
        description="""AH/8.15/4/514B""",
    )

    ah_8_15_4_515b = VocabularyTerm(
        code="AH_8_15_4_515B",
        label="AH/8.15/4/515B",
        description="""AH/8.15/4/515B""",
    )

    ah_8_15_4_516 = VocabularyTerm(
        code="AH_8_15_4_516",
        label="AH/8.15/4/516",
        description="""AH/8.15/4/516""",
    )

    ah_8_15_4_516b = VocabularyTerm(
        code="AH_8_15_4_516B",
        label="AH/8.15/4/516B",
        description="""AH/8.15/4/516B""",
    )

    ah_8_15_4_517 = VocabularyTerm(
        code="AH_8_15_4_517",
        label="AH/8.15/4/517",
        description="""AH/8.15/4/517""",
    )

    ah_8_15_4_517b = VocabularyTerm(
        code="AH_8_15_4_517B",
        label="AH/8.15/4/517B",
        description="""AH/8.15/4/517B""",
    )

    ah_8_15_4_518 = VocabularyTerm(
        code="AH_8_15_4_518",
        label="AH/8.15/4/518",
        description="""AH/8.15/4/518""",
    )

    ah_8_15_4_518b = VocabularyTerm(
        code="AH_8_15_4_518B",
        label="AH/8.15/4/518B",
        description="""AH/8.15/4/518B""",
    )

    ah_8_15_4_519b = VocabularyTerm(
        code="AH_8_15_4_519B",
        label="AH/8.15/4/519B",
        description="""AH/8.15/4/519B""",
    )

    ah_8_15_4_520 = VocabularyTerm(
        code="AH_8_15_4_520",
        label="AH/8.15/4/520",
        description="""AH/8.15/4/520""",
    )

    ah_8_15_4_521 = VocabularyTerm(
        code="AH_8_15_4_521",
        label="AH/8.15/4/521",
        description="""AH/8.15/4/521""",
    )

    ah_8_15_4_521b = VocabularyTerm(
        code="AH_8_15_4_521B",
        label="AH/8.15/4/521B",
        description="""AH/8.15/4/521B""",
    )

    ah_8_15_4_522 = VocabularyTerm(
        code="AH_8_15_4_522",
        label="AH/8.15/4/522",
        description="""AH/8.15/4/522""",
    )

    ah_8_15_4_522b = VocabularyTerm(
        code="AH_8_15_4_522B",
        label="AH/8.15/4/522B",
        description="""AH/8.15/4/522B""",
    )

    ah_8_15_4_523 = VocabularyTerm(
        code="AH_8_15_4_523",
        label="AH/8.15/4/523",
        description="""AH/8.15/4/523""",
    )

    ah_8_15_4_523b = VocabularyTerm(
        code="AH_8_15_4_523B",
        label="AH/8.15/4/523B",
        description="""AH/8.15/4/523B""",
    )

    ah_8_15_4_524 = VocabularyTerm(
        code="AH_8_15_4_524",
        label="AH/8.15/4/524",
        description="""AH/8.15/4/524""",
    )

    ah_8_15_4_524d = VocabularyTerm(
        code="AH_8_15_4_524D",
        label="AH/8.15/4/524D",
        description="""AH/8.15/4/524D""",
    )

    ah_8_15_4_525b = VocabularyTerm(
        code="AH_8_15_4_525B",
        label="AH/8.15/4/525B",
        description="""AH/8.15/4/525B""",
    )

    ah_8_15_4_526 = VocabularyTerm(
        code="AH_8_15_4_526",
        label="AH/8.15/4/526",
        description="""AH/8.15/4/526""",
    )

    ah_8_15_4_527 = VocabularyTerm(
        code="AH_8_15_4_527",
        label="AH/8.15/4/527",
        description="""AH/8.15/4/527""",
    )

    ah_8_15_4_527b = VocabularyTerm(
        code="AH_8_15_4_527B",
        label="AH/8.15/4/527B",
        description="""AH/8.15/4/527B""",
    )

    ah_8_15_4_528 = VocabularyTerm(
        code="AH_8_15_4_528",
        label="AH/8.15/4/528",
        description="""AH/8.15/4/528""",
    )

    ah_8_15_4_529b = VocabularyTerm(
        code="AH_8_15_4_529B",
        label="AH/8.15/4/529B",
        description="""AH/8.15/4/529B""",
    )

    ah_8_15_4_530 = VocabularyTerm(
        code="AH_8_15_4_530",
        label="AH/8.15/4/530",
        description="""AH/8.15/4/530""",
    )

    ah_8_15_4_531 = VocabularyTerm(
        code="AH_8_15_4_531",
        label="AH/8.15/4/531",
        description="""AH/8.15/4/531""",
    )

    ah_8_15_4_531b = VocabularyTerm(
        code="AH_8_15_4_531B",
        label="AH/8.15/4/531B",
        description="""AH/8.15/4/531B""",
    )

    ah_8_15_4_532 = VocabularyTerm(
        code="AH_8_15_4_532",
        label="AH/8.15/4/532",
        description="""AH/8.15/4/532""",
    )

    ah_8_15_4_534 = VocabularyTerm(
        code="AH_8_15_4_534",
        label="AH/8.15/4/534",
        description="""AH/8.15/4/534""",
    )

    ah_8_15_4_535 = VocabularyTerm(
        code="AH_8_15_4_535",
        label="AH/8.15/4/535",
        description="""AH/8.15/4/535""",
    )

    ah_8_15_4_535f = VocabularyTerm(
        code="AH_8_15_4_535F",
        label="AH/8.15/4/535F",
        description="""AH/8.15/4/535F""",
    )

    ah_8_15_4_536 = VocabularyTerm(
        code="AH_8_15_4_536",
        label="AH/8.15/4/536",
        description="""AH/8.15/4/536""",
    )

    ah_8_15_4_538f = VocabularyTerm(
        code="AH_8_15_4_538F",
        label="AH/8.15/4/538F",
        description="""AH/8.15/4/538F""",
    )

    ah_8_15_4_538t = VocabularyTerm(
        code="AH_8_15_4_538T",
        label="AH/8.15/4/538T",
        description="""AH/8.15/4/538T""",
    )

    ah_8_15_4_539 = VocabularyTerm(
        code="AH_8_15_4_539",
        label="AH/8.15/4/539",
        description="""AH/8.15/4/539""",
    )

    ah_8_15_4_539f = VocabularyTerm(
        code="AH_8_15_4_539F",
        label="AH/8.15/4/539F",
        description="""AH/8.15/4/539F""",
    )

    ah_8_15_5_8_a1 = VocabularyTerm(
        code="AH_8_15_5_8_A1",
        label="AH/8.15/5/8.A1",
        description="""AH/8.15/5/8.A1""",
    )

    ah_8_15_5_8_a2 = VocabularyTerm(
        code="AH_8_15_5_8_A2",
        label="AH/8.15/5/8.A2",
        description="""AH/8.15/5/8.A2""",
    )

    ah_8_15_5_600 = VocabularyTerm(
        code="AH_8_15_5_600",
        label="AH/8.15/5/600",
        description="""AH/8.15/5/600""",
    )

    ah_8_15_5_600f = VocabularyTerm(
        code="AH_8_15_5_600F",
        label="AH/8.15/5/600F",
        description="""AH/8.15/5/600F""",
    )

    ah_8_15_5_600t = VocabularyTerm(
        code="AH_8_15_5_600T",
        label="AH/8.15/5/600T",
        description="""AH/8.15/5/600T""",
    )

    ah_8_15_5_601 = VocabularyTerm(
        code="AH_8_15_5_601",
        label="AH/8.15/5/601",
        description="""AH/8.15/5/601""",
    )

    ah_8_15_5_601f = VocabularyTerm(
        code="AH_8_15_5_601F",
        label="AH/8.15/5/601F",
        description="""AH/8.15/5/601F""",
    )

    ah_8_15_5_602 = VocabularyTerm(
        code="AH_8_15_5_602",
        label="AH/8.15/5/602",
        description="""AH/8.15/5/602""",
    )

    ah_8_15_5_603 = VocabularyTerm(
        code="AH_8_15_5_603",
        label="AH/8.15/5/603",
        description="""AH/8.15/5/603""",
    )

    ah_8_15_5_604 = VocabularyTerm(
        code="AH_8_15_5_604",
        label="AH/8.15/5/604",
        description="""AH/8.15/5/604""",
    )

    ah_8_15_5_605 = VocabularyTerm(
        code="AH_8_15_5_605",
        label="AH/8.15/5/605",
        description="""AH/8.15/5/605""",
    )

    ah_8_15_5_605b = VocabularyTerm(
        code="AH_8_15_5_605B",
        label="AH/8.15/5/605B",
        description="""AH/8.15/5/605B""",
    )

    ah_8_15_5_605f = VocabularyTerm(
        code="AH_8_15_5_605F",
        label="AH/8.15/5/605F",
        description="""AH/8.15/5/605F""",
    )

    ah_8_15_5_606 = VocabularyTerm(
        code="AH_8_15_5_606",
        label="AH/8.15/5/606",
        description="""AH/8.15/5/606""",
    )

    ah_8_15_5_607b = VocabularyTerm(
        code="AH_8_15_5_607B",
        label="AH/8.15/5/607B",
        description="""AH/8.15/5/607B""",
    )

    ah_8_15_5_608 = VocabularyTerm(
        code="AH_8_15_5_608",
        label="AH/8.15/5/608",
        description="""AH/8.15/5/608""",
    )

    ah_8_15_5_609 = VocabularyTerm(
        code="AH_8_15_5_609",
        label="AH/8.15/5/609",
        description="""AH/8.15/5/609""",
    )

    ah_8_15_5_609b = VocabularyTerm(
        code="AH_8_15_5_609B",
        label="AH/8.15/5/609B",
        description="""AH/8.15/5/609B""",
    )

    ah_8_15_5_610 = VocabularyTerm(
        code="AH_8_15_5_610",
        label="AH/8.15/5/610",
        description="""AH/8.15/5/610""",
    )

    ah_8_15_5_611b = VocabularyTerm(
        code="AH_8_15_5_611B",
        label="AH/8.15/5/611B",
        description="""AH/8.15/5/611B""",
    )

    ah_8_15_5_612 = VocabularyTerm(
        code="AH_8_15_5_612",
        label="AH/8.15/5/612",
        description="""AH/8.15/5/612""",
    )

    ah_8_15_5_613 = VocabularyTerm(
        code="AH_8_15_5_613",
        label="AH/8.15/5/613",
        description="""AH/8.15/5/613""",
    )

    ah_8_15_5_613b = VocabularyTerm(
        code="AH_8_15_5_613B",
        label="AH/8.15/5/613B",
        description="""AH/8.15/5/613B""",
    )

    ah_8_15_5_614 = VocabularyTerm(
        code="AH_8_15_5_614",
        label="AH/8.15/5/614",
        description="""AH/8.15/5/614""",
    )

    ah_8_15_5_614h = VocabularyTerm(
        code="AH_8_15_5_614H",
        label="AH/8.15/5/614H",
        description="""AH/8.15/5/614H""",
    )

    ah_8_15_5_615b = VocabularyTerm(
        code="AH_8_15_5_615B",
        label="AH/8.15/5/615B",
        description="""AH/8.15/5/615B""",
    )

    ah_8_15_5_616 = VocabularyTerm(
        code="AH_8_15_5_616",
        label="AH/8.15/5/616",
        description="""AH/8.15/5/616""",
    )

    ah_8_15_5_616b = VocabularyTerm(
        code="AH_8_15_5_616B",
        label="AH/8.15/5/616B",
        description="""AH/8.15/5/616B""",
    )

    ah_8_15_5_617 = VocabularyTerm(
        code="AH_8_15_5_617",
        label="AH/8.15/5/617",
        description="""AH/8.15/5/617""",
    )

    ah_8_15_5_617b = VocabularyTerm(
        code="AH_8_15_5_617B",
        label="AH/8.15/5/617B",
        description="""AH/8.15/5/617B""",
    )

    ah_8_15_5_618 = VocabularyTerm(
        code="AH_8_15_5_618",
        label="AH/8.15/5/618",
        description="""AH/8.15/5/618""",
    )

    ah_8_15_5_618b = VocabularyTerm(
        code="AH_8_15_5_618B",
        label="AH/8.15/5/618B",
        description="""AH/8.15/5/618B""",
    )

    ah_8_15_5_619b = VocabularyTerm(
        code="AH_8_15_5_619B",
        label="AH/8.15/5/619B",
        description="""AH/8.15/5/619B""",
    )

    ah_8_15_5_620 = VocabularyTerm(
        code="AH_8_15_5_620",
        label="AH/8.15/5/620",
        description="""AH/8.15/5/620""",
    )

    ah_8_15_5_621 = VocabularyTerm(
        code="AH_8_15_5_621",
        label="AH/8.15/5/621",
        description="""AH/8.15/5/621""",
    )

    ah_8_15_5_621b = VocabularyTerm(
        code="AH_8_15_5_621B",
        label="AH/8.15/5/621B",
        description="""AH/8.15/5/621B""",
    )

    ah_8_15_5_622 = VocabularyTerm(
        code="AH_8_15_5_622",
        label="AH/8.15/5/622",
        description="""AH/8.15/5/622""",
    )

    ah_8_15_5_622b = VocabularyTerm(
        code="AH_8_15_5_622B",
        label="AH/8.15/5/622B",
        description="""AH/8.15/5/622B""",
    )

    ah_8_15_5_623b = VocabularyTerm(
        code="AH_8_15_5_623B",
        label="AH/8.15/5/623B",
        description="""AH/8.15/5/623B""",
    )

    ah_8_15_5_624 = VocabularyTerm(
        code="AH_8_15_5_624",
        label="AH/8.15/5/624",
        description="""AH/8.15/5/624""",
    )

    ah_8_15_5_624d = VocabularyTerm(
        code="AH_8_15_5_624D",
        label="AH/8.15/5/624D",
        description="""AH/8.15/5/624D""",
    )

    ah_8_15_5_625 = VocabularyTerm(
        code="AH_8_15_5_625",
        label="AH/8.15/5/625",
        description="""AH/8.15/5/625""",
    )

    ah_8_15_5_625b = VocabularyTerm(
        code="AH_8_15_5_625B",
        label="AH/8.15/5/625B",
        description="""AH/8.15/5/625B""",
    )

    ah_8_15_5_626 = VocabularyTerm(
        code="AH_8_15_5_626",
        label="AH/8.15/5/626",
        description="""AH/8.15/5/626""",
    )

    ah_8_15_5_627 = VocabularyTerm(
        code="AH_8_15_5_627",
        label="AH/8.15/5/627",
        description="""AH/8.15/5/627""",
    )

    ah_8_15_5_627b = VocabularyTerm(
        code="AH_8_15_5_627B",
        label="AH/8.15/5/627B",
        description="""AH/8.15/5/627B""",
    )

    ah_8_15_5_628 = VocabularyTerm(
        code="AH_8_15_5_628",
        label="AH/8.15/5/628",
        description="""AH/8.15/5/628""",
    )

    ah_8_15_5_629b = VocabularyTerm(
        code="AH_8_15_5_629B",
        label="AH/8.15/5/629B",
        description="""AH/8.15/5/629B""",
    )

    ah_8_15_5_630 = VocabularyTerm(
        code="AH_8_15_5_630",
        label="AH/8.15/5/630",
        description="""AH/8.15/5/630""",
    )

    ah_8_15_5_631 = VocabularyTerm(
        code="AH_8_15_5_631",
        label="AH/8.15/5/631",
        description="""AH/8.15/5/631""",
    )

    ah_8_15_5_631b = VocabularyTerm(
        code="AH_8_15_5_631B",
        label="AH/8.15/5/631B",
        description="""AH/8.15/5/631B""",
    )

    ah_8_15_5_632 = VocabularyTerm(
        code="AH_8_15_5_632",
        label="AH/8.15/5/632",
        description="""AH/8.15/5/632""",
    )

    ah_8_15_5_634 = VocabularyTerm(
        code="AH_8_15_5_634",
        label="AH/8.15/5/634",
        description="""AH/8.15/5/634""",
    )

    ah_8_15_5_635 = VocabularyTerm(
        code="AH_8_15_5_635",
        label="AH/8.15/5/635",
        description="""AH/8.15/5/635""",
    )

    ah_8_15_5_635f = VocabularyTerm(
        code="AH_8_15_5_635F",
        label="AH/8.15/5/635F",
        description="""AH/8.15/5/635F""",
    )

    ah_8_15_5_636 = VocabularyTerm(
        code="AH_8_15_5_636",
        label="AH/8.15/5/636",
        description="""AH/8.15/5/636""",
    )

    ah_8_15_5_638f = VocabularyTerm(
        code="AH_8_15_5_638F",
        label="AH/8.15/5/638F",
        description="""AH/8.15/5/638F""",
    )

    ah_8_15_5_638t = VocabularyTerm(
        code="AH_8_15_5_638T",
        label="AH/8.15/5/638T",
        description="""AH/8.15/5/638T""",
    )

    ah_8_15_5_639 = VocabularyTerm(
        code="AH_8_15_5_639",
        label="AH/8.15/5/639",
        description="""AH/8.15/5/639""",
    )

    ah_8_15_5_639f = VocabularyTerm(
        code="AH_8_15_5_639F",
        label="AH/8.15/5/639F",
        description="""AH/8.15/5/639F""",
    )

    ah_8_15_6_8_a2 = VocabularyTerm(
        code="AH_8_15_6_8_A2",
        label="AH/8.15/6/8.A2",
        description="""AH/8.15/6/8.A2""",
    )

    ah_8_15_6_700t = VocabularyTerm(
        code="AH_8_15_6_700T",
        label="AH/8.15/6/700T",
        description="""AH/8.15/6/700T""",
    )

    ah_8_15_6_701 = VocabularyTerm(
        code="AH_8_15_6_701",
        label="AH/8.15/6/701",
        description="""AH/8.15/6/701""",
    )

    ah_8_15_6_705f = VocabularyTerm(
        code="AH_8_15_6_705F",
        label="AH/8.15/6/705F",
        description="""AH/8.15/6/705F""",
    )

    ah_8_15_6_706 = VocabularyTerm(
        code="AH_8_15_6_706",
        label="AH/8.15/6/706",
        description="""AH/8.15/6/706""",
    )

    ah_8_15_6_707f = VocabularyTerm(
        code="AH_8_15_6_707F",
        label="AH/8.15/6/707F",
        description="""AH/8.15/6/707F""",
    )

    ah_8_15_6_708 = VocabularyTerm(
        code="AH_8_15_6_708",
        label="AH/8.15/6/708",
        description="""AH/8.15/6/708""",
    )

    ah_8_15_6_712 = VocabularyTerm(
        code="AH_8_15_6_712",
        label="AH/8.15/6/712",
        description="""AH/8.15/6/712""",
    )

    ah_8_15_6_726 = VocabularyTerm(
        code="AH_8_15_6_726",
        label="AH/8.15/6/726",
        description="""AH/8.15/6/726""",
    )

    ah_8_15_6_730 = VocabularyTerm(
        code="AH_8_15_6_730",
        label="AH/8.15/6/730",
        description="""AH/8.15/6/730""",
    )

    ah_8_15_6_733f = VocabularyTerm(
        code="AH_8_15_6_733F",
        label="AH/8.15/6/733F",
        description="""AH/8.15/6/733F""",
    )

    ah_8_15_6_734f = VocabularyTerm(
        code="AH_8_15_6_734F",
        label="AH/8.15/6/734F",
        description="""AH/8.15/6/734F""",
    )

    ah_8_15_6_738t = VocabularyTerm(
        code="AH_8_15_6_738T",
        label="AH/8.15/6/738T",
        description="""AH/8.15/6/738T""",
    )

    ah_8_15_6_739 = VocabularyTerm(
        code="AH_8_15_6_739",
        label="AH/8.15/6/739",
        description="""AH/8.15/6/739""",
    )

    ah_8_15_7_801 = VocabularyTerm(
        code="AH_8_15_7_801",
        label="AH/8.15/7/801",
        description="""AH/8.15/7/801""",
    )

    ah_8_15_7_838t = VocabularyTerm(
        code="AH_8_15_7_838T",
        label="AH/8.15/7/838T",
        description="""AH/8.15/7/838T""",
    )

    ah_8_17_0_100 = VocabularyTerm(
        code="AH_8_17_0_100",
        label="AH/8.17/0/100",
        description="""AH/8.17/0/100""",
    )

    ah_8_17_0_100f = VocabularyTerm(
        code="AH_8_17_0_100F",
        label="AH/8.17/0/100F",
        description="""AH/8.17/0/100F""",
    )

    ah_8_17_0_103 = VocabularyTerm(
        code="AH_8_17_0_103",
        label="AH/8.17/0/103",
        description="""AH/8.17/0/103""",
    )

    ah_8_17_0_104 = VocabularyTerm(
        code="AH_8_17_0_104",
        label="AH/8.17/0/104",
        description="""AH/8.17/0/104""",
    )

    ah_8_17_0_105 = VocabularyTerm(
        code="AH_8_17_0_105",
        label="AH/8.17/0/105",
        description="""AH/8.17/0/105""",
    )

    ah_8_17_0_109 = VocabularyTerm(
        code="AH_8_17_0_109",
        label="AH/8.17/0/109",
        description="""AH/8.17/0/109""",
    )

    ah_8_17_0_110 = VocabularyTerm(
        code="AH_8_17_0_110",
        label="AH/8.17/0/110",
        description="""AH/8.17/0/110""",
    )

    ah_8_17_0_111 = VocabularyTerm(
        code="AH_8_17_0_111",
        label="AH/8.17/0/111",
        description="""AH/8.17/0/111""",
    )

    ah_8_17_0_113 = VocabularyTerm(
        code="AH_8_17_0_113",
        label="AH/8.17/0/113",
        description="""AH/8.17/0/113""",
    )

    ah_8_17_0_114 = VocabularyTerm(
        code="AH_8_17_0_114",
        label="AH/8.17/0/114",
        description="""AH/8.17/0/114""",
    )

    ah_8_18_0_101 = VocabularyTerm(
        code="AH_8_18_0_101",
        label="AH/8.18/0/101",
        description="""AH/8.18/0/101""",
    )

    ah_8_18_0_102 = VocabularyTerm(
        code="AH_8_18_0_102",
        label="AH/8.18/0/102",
        description="""AH/8.18/0/102""",
    )

    ah_8_18_0_103 = VocabularyTerm(
        code="AH_8_18_0_103",
        label="AH/8.18/0/103",
        description="""AH/8.18/0/103""",
    )

    ah_8_18_0_104 = VocabularyTerm(
        code="AH_8_18_0_104",
        label="AH/8.18/0/104",
        description="""AH/8.18/0/104""",
    )

    ah_8_18_0_105 = VocabularyTerm(
        code="AH_8_18_0_105",
        label="AH/8.18/0/105",
        description="""AH/8.18/0/105""",
    )

    ah_8_18_0_105b = VocabularyTerm(
        code="AH_8_18_0_105B",
        label="AH/8.18/0/105B",
        description="""AH/8.18/0/105B""",
    )

    ah_8_18_0_106 = VocabularyTerm(
        code="AH_8_18_0_106",
        label="AH/8.18/0/106",
        description="""AH/8.18/0/106""",
    )

    ah_8_18_0_106b = VocabularyTerm(
        code="AH_8_18_0_106B",
        label="AH/8.18/0/106B",
        description="""AH/8.18/0/106B""",
    )

    ah_8_18_0_107 = VocabularyTerm(
        code="AH_8_18_0_107",
        label="AH/8.18/0/107",
        description="""AH/8.18/0/107""",
    )

    ah_8_18_0_108 = VocabularyTerm(
        code="AH_8_18_0_108",
        label="AH/8.18/0/108",
        description="""AH/8.18/0/108""",
    )

    ah_8_18_0_109 = VocabularyTerm(
        code="AH_8_18_0_109",
        label="AH/8.18/0/109",
        description="""AH/8.18/0/109""",
    )

    ah_8_18_0_109f = VocabularyTerm(
        code="AH_8_18_0_109F",
        label="AH/8.18/0/109F",
        description="""AH/8.18/0/109F""",
    )

    ah_8_18_0_119d = VocabularyTerm(
        code="AH_8_18_0_119D",
        label="AH/8.18/0/119D",
        description="""AH/8.18/0/119D""",
    )

    ah_8_18_0_119h = VocabularyTerm(
        code="AH_8_18_0_119H",
        label="AH/8.18/0/119H",
        description="""AH/8.18/0/119H""",
    )

    fb_80_0_100 = VocabularyTerm(
        code="FB_80_0_100",
        label="FB/80/0/100",
        description="""FB/80/0/100""",
    )

    fb_80_0_100f = VocabularyTerm(
        code="FB_80_0_100F",
        label="FB/80/0/100F",
        description="""FB/80/0/100F""",
    )

    fb_80_0_100t = VocabularyTerm(
        code="FB_80_0_100T",
        label="FB/80/0/100T",
        description="""FB/80/0/100T""",
    )

    fb_80_0_101 = VocabularyTerm(
        code="FB_80_0_101",
        label="FB/80/0/101",
        description="""FB/80/0/101""",
    )

    fb_80_0_102 = VocabularyTerm(
        code="FB_80_0_102",
        label="FB/80/0/102",
        description="""FB/80/0/102""",
    )

    fb_80_0_108 = VocabularyTerm(
        code="FB_80_0_108",
        label="FB/80/0/108",
        description="""FB/80/0/108""",
    )

    fb_80_0_109 = VocabularyTerm(
        code="FB_80_0_109",
        label="FB/80/0/109",
        description="""FB/80/0/109""",
    )

    fb_80_0_109t = VocabularyTerm(
        code="FB_80_0_109T",
        label="FB/80/0/109T",
        description="""FB/80/0/109T""",
    )

    fb_80_0_110 = VocabularyTerm(
        code="FB_80_0_110",
        label="FB/80/0/110",
        description="""FB/80/0/110""",
    )

    fb_80_0_114 = VocabularyTerm(
        code="FB_80_0_114",
        label="FB/80/0/114",
        description="""FB/80/0/114""",
    )

    fb_80_0_116 = VocabularyTerm(
        code="FB_80_0_116",
        label="FB/80/0/116",
        description="""FB/80/0/116""",
    )

    fb_80_0_117 = VocabularyTerm(
        code="FB_80_0_117",
        label="FB/80/0/117",
        description="""FB/80/0/117""",
    )

    fb_80_0_117b = VocabularyTerm(
        code="FB_80_0_117B",
        label="FB/80/0/117B",
        description="""FB/80/0/117B""",
    )

    fb_80_0_117f = VocabularyTerm(
        code="FB_80_0_117F",
        label="FB/80/0/117F",
        description="""FB/80/0/117F""",
    )

    fb_80_0_118 = VocabularyTerm(
        code="FB_80_0_118",
        label="FB/80/0/118",
        description="""FB/80/0/118""",
    )

    fb_80_0_118b = VocabularyTerm(
        code="FB_80_0_118B",
        label="FB/80/0/118B",
        description="""FB/80/0/118B""",
    )

    fb_80_0_119 = VocabularyTerm(
        code="FB_80_0_119",
        label="FB/80/0/119",
        description="""FB/80/0/119""",
    )

    fb_80_0_119f = VocabularyTerm(
        code="FB_80_0_119F",
        label="FB/80/0/119F",
        description="""FB/80/0/119F""",
    )

    fb_80_0_120 = VocabularyTerm(
        code="FB_80_0_120",
        label="FB/80/0/120",
        description="""FB/80/0/120""",
    )

    fb_80_0_120b = VocabularyTerm(
        code="FB_80_0_120B",
        label="FB/80/0/120B",
        description="""FB/80/0/120B""",
    )

    fb_80_0_120f = VocabularyTerm(
        code="FB_80_0_120F",
        label="FB/80/0/120F",
        description="""FB/80/0/120F""",
    )

    fb_80_0_124 = VocabularyTerm(
        code="FB_80_0_124",
        label="FB/80/0/124",
        description="""FB/80/0/124""",
    )

    fb_80_0_126 = VocabularyTerm(
        code="FB_80_0_126",
        label="FB/80/0/126",
        description="""FB/80/0/126""",
    )

    fb_80_0_128 = VocabularyTerm(
        code="FB_80_0_128",
        label="FB/80/0/128",
        description="""FB/80/0/128""",
    )

    fb_80_0_129 = VocabularyTerm(
        code="FB_80_0_129",
        label="FB/80/0/129",
        description="""FB/80/0/129""",
    )

    fb_80_0_129f = VocabularyTerm(
        code="FB_80_0_129F",
        label="FB/80/0/129F",
        description="""FB/80/0/129F""",
    )

    fb_80_0_130 = VocabularyTerm(
        code="FB_80_0_130",
        label="FB/80/0/130",
        description="""FB/80/0/130""",
    )

    fb_80_0_130f = VocabularyTerm(
        code="FB_80_0_130F",
        label="FB/80/0/130F",
        description="""FB/80/0/130F""",
    )

    fb_80_0_131 = VocabularyTerm(
        code="FB_80_0_131",
        label="FB/80/0/131",
        description="""FB/80/0/131""",
    )

    fb_80_0_132 = VocabularyTerm(
        code="FB_80_0_132",
        label="FB/80/0/132",
        description="""FB/80/0/132""",
    )

    fb_80_0_133 = VocabularyTerm(
        code="FB_80_0_133",
        label="FB/80/0/133",
        description="""FB/80/0/133""",
    )

    fb_80_0_134 = VocabularyTerm(
        code="FB_80_0_134",
        label="FB/80/0/134",
        description="""FB/80/0/134""",
    )

    fb_80_0_134d = VocabularyTerm(
        code="FB_80_0_134D",
        label="FB/80/0/134D",
        description="""FB/80/0/134D""",
    )

    fb_80_0_134t = VocabularyTerm(
        code="FB_80_0_134T",
        label="FB/80/0/134T",
        description="""FB/80/0/134T""",
    )

    fb_80_0_134wc = VocabularyTerm(
        code="FB_80_0_134WC",
        label="FB/80/0/134WC",
        description="""FB/80/0/134WC""",
    )

    fb_80_0_135 = VocabularyTerm(
        code="FB_80_0_135",
        label="FB/80/0/135",
        description="""FB/80/0/135""",
    )

    fb_80_0_136 = VocabularyTerm(
        code="FB_80_0_136",
        label="FB/80/0/136",
        description="""FB/80/0/136""",
    )

    fb_80_0_137 = VocabularyTerm(
        code="FB_80_0_137",
        label="FB/80/0/137",
        description="""FB/80/0/137""",
    )

    fb_80_0_138 = VocabularyTerm(
        code="FB_80_0_138",
        label="FB/80/0/138",
        description="""FB/80/0/138""",
    )

    fb_80_0_139 = VocabularyTerm(
        code="FB_80_0_139",
        label="FB/80/0/139",
        description="""FB/80/0/139""",
    )

    fb_80_0_139b = VocabularyTerm(
        code="FB_80_0_139B",
        label="FB/80/0/139B",
        description="""FB/80/0/139B""",
    )

    fb_80_0_140 = VocabularyTerm(
        code="FB_80_0_140",
        label="FB/80/0/140",
        description="""FB/80/0/140""",
    )

    fb_80_0_141 = VocabularyTerm(
        code="FB_80_0_141",
        label="FB/80/0/141",
        description="""FB/80/0/141""",
    )

    fb_80_0_141b = VocabularyTerm(
        code="FB_80_0_141B",
        label="FB/80/0/141B",
        description="""FB/80/0/141B""",
    )

    fb_80_0_142 = VocabularyTerm(
        code="FB_80_0_142",
        label="FB/80/0/142",
        description="""FB/80/0/142""",
    )

    fb_80_0_142b = VocabularyTerm(
        code="FB_80_0_142B",
        label="FB/80/0/142B",
        description="""FB/80/0/142B""",
    )

    fb_80_0_143 = VocabularyTerm(
        code="FB_80_0_143",
        label="FB/80/0/143",
        description="""FB/80/0/143""",
    )

    fb_80_0_143d = VocabularyTerm(
        code="FB_80_0_143D",
        label="FB/80/0/143D",
        description="""FB/80/0/143D""",
    )

    fb_80_0_143h = VocabularyTerm(
        code="FB_80_0_143H",
        label="FB/80/0/143H",
        description="""FB/80/0/143H""",
    )

    fb_80_0_144 = VocabularyTerm(
        code="FB_80_0_144",
        label="FB/80/0/144",
        description="""FB/80/0/144""",
    )

    fb_80_0_145 = VocabularyTerm(
        code="FB_80_0_145",
        label="FB/80/0/145",
        description="""FB/80/0/145""",
    )

    fb_80_0_145t = VocabularyTerm(
        code="FB_80_0_145T",
        label="FB/80/0/145T",
        description="""FB/80/0/145T""",
    )

    fb_80_0_146 = VocabularyTerm(
        code="FB_80_0_146",
        label="FB/80/0/146",
        description="""FB/80/0/146""",
    )

    fb_80_0_147 = VocabularyTerm(
        code="FB_80_0_147",
        label="FB/80/0/147",
        description="""FB/80/0/147""",
    )

    fb_80_0_148 = VocabularyTerm(
        code="FB_80_0_148",
        label="FB/80/0/148",
        description="""FB/80/0/148""",
    )

    fb_80_0_149 = VocabularyTerm(
        code="FB_80_0_149",
        label="FB/80/0/149",
        description="""FB/80/0/149""",
    )

    fb_80_0_150 = VocabularyTerm(
        code="FB_80_0_150",
        label="FB/80/0/150",
        description="""FB/80/0/150""",
    )

    fb_80_0_150b = VocabularyTerm(
        code="FB_80_0_150B",
        label="FB/80/0/150B",
        description="""FB/80/0/150B""",
    )

    fb_80_0_150f = VocabularyTerm(
        code="FB_80_0_150F",
        label="FB/80/0/150F",
        description="""FB/80/0/150F""",
    )

    fb_80_0_151 = VocabularyTerm(
        code="FB_80_0_151",
        label="FB/80/0/151",
        description="""FB/80/0/151""",
    )

    fb_80_0_152 = VocabularyTerm(
        code="FB_80_0_152",
        label="FB/80/0/152",
        description="""FB/80/0/152""",
    )

    fb_80_0_153 = VocabularyTerm(
        code="FB_80_0_153",
        label="FB/80/0/153",
        description="""FB/80/0/153""",
    )

    fb_80_0_154 = VocabularyTerm(
        code="FB_80_0_154",
        label="FB/80/0/154",
        description="""FB/80/0/154""",
    )

    fb_80_0_155 = VocabularyTerm(
        code="FB_80_0_155",
        label="FB/80/0/155",
        description="""FB/80/0/155""",
    )

    fb_80_0_156 = VocabularyTerm(
        code="FB_80_0_156",
        label="FB/80/0/156",
        description="""FB/80/0/156""",
    )

    fb_80_0_157 = VocabularyTerm(
        code="FB_80_0_157",
        label="FB/80/0/157",
        description="""FB/80/0/157""",
    )

    fb_80_0_160 = VocabularyTerm(
        code="FB_80_0_160",
        label="FB/80/0/160",
        description="""FB/80/0/160""",
    )

    fb_80_0_160f = VocabularyTerm(
        code="FB_80_0_160F",
        label="FB/80/0/160F",
        description="""FB/80/0/160F""",
    )

    fb_80_0_161 = VocabularyTerm(
        code="FB_80_0_161",
        label="FB/80/0/161",
        description="""FB/80/0/161""",
    )

    fb_80_0_161t = VocabularyTerm(
        code="FB_80_0_161T",
        label="FB/80/0/161T",
        description="""FB/80/0/161T""",
    )

    fb_80_0_162 = VocabularyTerm(
        code="FB_80_0_162",
        label="FB/80/0/162",
        description="""FB/80/0/162""",
    )

    fb_80_0_162b = VocabularyTerm(
        code="FB_80_0_162B",
        label="FB/80/0/162B",
        description="""FB/80/0/162B""",
    )

    fb_80_0_162h = VocabularyTerm(
        code="FB_80_0_162H",
        label="FB/80/0/162H",
        description="""FB/80/0/162H""",
    )

    fb_80_0_164 = VocabularyTerm(
        code="FB_80_0_164",
        label="FB/80/0/164",
        description="""FB/80/0/164""",
    )

    fb_80_0_166 = VocabularyTerm(
        code="FB_80_0_166",
        label="FB/80/0/166",
        description="""FB/80/0/166""",
    )

    fb_80_0_168 = VocabularyTerm(
        code="FB_80_0_168",
        label="FB/80/0/168",
        description="""FB/80/0/168""",
    )

    fb_80_0_168f = VocabularyTerm(
        code="FB_80_0_168F",
        label="FB/80/0/168F",
        description="""FB/80/0/168F""",
    )

    fb_80_0_169 = VocabularyTerm(
        code="FB_80_0_169",
        label="FB/80/0/169",
        description="""FB/80/0/169""",
    )

    fb_80_0_169f = VocabularyTerm(
        code="FB_80_0_169F",
        label="FB/80/0/169F",
        description="""FB/80/0/169F""",
    )

    fb_80_0_170 = VocabularyTerm(
        code="FB_80_0_170",
        label="FB/80/0/170",
        description="""FB/80/0/170""",
    )

    fb_80_0_170b = VocabularyTerm(
        code="FB_80_0_170B",
        label="FB/80/0/170B",
        description="""FB/80/0/170B""",
    )

    fb_80_0_170f = VocabularyTerm(
        code="FB_80_0_170F",
        label="FB/80/0/170F",
        description="""FB/80/0/170F""",
    )

    fb_80_0_171 = VocabularyTerm(
        code="FB_80_0_171",
        label="FB/80/0/171",
        description="""FB/80/0/171""",
    )

    fb_80_0_172 = VocabularyTerm(
        code="FB_80_0_172",
        label="FB/80/0/172",
        description="""FB/80/0/172""",
    )

    fb_80_0_173t = VocabularyTerm(
        code="FB_80_0_173T",
        label="FB/80/0/173T",
        description="""FB/80/0/173T""",
    )

    fb_80_0_174 = VocabularyTerm(
        code="FB_80_0_174",
        label="FB/80/0/174",
        description="""FB/80/0/174""",
    )

    fb_80_0_175 = VocabularyTerm(
        code="FB_80_0_175",
        label="FB/80/0/175",
        description="""FB/80/0/175""",
    )

    fb_80_0_176 = VocabularyTerm(
        code="FB_80_0_176",
        label="FB/80/0/176",
        description="""FB/80/0/176""",
    )

    fb_80_0_177 = VocabularyTerm(
        code="FB_80_0_177",
        label="FB/80/0/177",
        description="""FB/80/0/177""",
    )

    fb_80_0_177f = VocabularyTerm(
        code="FB_80_0_177F",
        label="FB/80/0/177F",
        description="""FB/80/0/177F""",
    )

    fb_80_0_178 = VocabularyTerm(
        code="FB_80_0_178",
        label="FB/80/0/178",
        description="""FB/80/0/178""",
    )

    fb_80_0_178b = VocabularyTerm(
        code="FB_80_0_178B",
        label="FB/80/0/178B",
        description="""FB/80/0/178B""",
    )

    fb_80_0_178t = VocabularyTerm(
        code="FB_80_0_178T",
        label="FB/80/0/178T",
        description="""FB/80/0/178T""",
    )

    fb_80_0_179 = VocabularyTerm(
        code="FB_80_0_179",
        label="FB/80/0/179",
        description="""FB/80/0/179""",
    )

    fb_80_0_180 = VocabularyTerm(
        code="FB_80_0_180",
        label="FB/80/0/180",
        description="""FB/80/0/180""",
    )

    fb_80_0_181h = VocabularyTerm(
        code="FB_80_0_181H",
        label="FB/80/0/181H",
        description="""FB/80/0/181H""",
    )

    fb_80_0_182 = VocabularyTerm(
        code="FB_80_0_182",
        label="FB/80/0/182",
        description="""FB/80/0/182""",
    )

    fb_80_0_184 = VocabularyTerm(
        code="FB_80_0_184",
        label="FB/80/0/184",
        description="""FB/80/0/184""",
    )

    fb_80_0_185 = VocabularyTerm(
        code="FB_80_0_185",
        label="FB/80/0/185",
        description="""FB/80/0/185""",
    )

    fb_80_0_186 = VocabularyTerm(
        code="FB_80_0_186",
        label="FB/80/0/186",
        description="""FB/80/0/186""",
    )

    fb_80_0_186f = VocabularyTerm(
        code="FB_80_0_186F",
        label="FB/80/0/186F",
        description="""FB/80/0/186F""",
    )

    fb_80_0_187 = VocabularyTerm(
        code="FB_80_0_187",
        label="FB/80/0/187",
        description="""FB/80/0/187""",
    )

    fb_80_0_188 = VocabularyTerm(
        code="FB_80_0_188",
        label="FB/80/0/188",
        description="""FB/80/0/188""",
    )

    fb_80_0_189 = VocabularyTerm(
        code="FB_80_0_189",
        label="FB/80/0/189",
        description="""FB/80/0/189""",
    )

    fb_80_0_190 = VocabularyTerm(
        code="FB_80_0_190",
        label="FB/80/0/190",
        description="""FB/80/0/190""",
    )

    fb_80_0_190b = VocabularyTerm(
        code="FB_80_0_190B",
        label="FB/80/0/190B",
        description="""FB/80/0/190B""",
    )

    fb_80_0_190d = VocabularyTerm(
        code="FB_80_0_190D",
        label="FB/80/0/190D",
        description="""FB/80/0/190D""",
    )

    fb_80_0_190f = VocabularyTerm(
        code="FB_80_0_190F",
        label="FB/80/0/190F",
        description="""FB/80/0/190F""",
    )

    fb_80_0_191 = VocabularyTerm(
        code="FB_80_0_191",
        label="FB/80/0/191",
        description="""FB/80/0/191""",
    )

    fb_80_0_a1 = VocabularyTerm(
        code="FB_80_0_A1",
        label="FB/80/0/A1",
        description="""FB/80/0/A1""",
    )

    fb_80_1_200 = VocabularyTerm(
        code="FB_80_1_200",
        label="FB/80/1/200",
        description="""FB/80/1/200""",
    )

    fb_80_1_200f = VocabularyTerm(
        code="FB_80_1_200F",
        label="FB/80/1/200F",
        description="""FB/80/1/200F""",
    )

    fb_80_1_200t = VocabularyTerm(
        code="FB_80_1_200T",
        label="FB/80/1/200T",
        description="""FB/80/1/200T""",
    )

    fb_80_1_201 = VocabularyTerm(
        code="FB_80_1_201",
        label="FB/80/1/201",
        description="""FB/80/1/201""",
    )

    fb_80_1_202 = VocabularyTerm(
        code="FB_80_1_202",
        label="FB/80/1/202",
        description="""FB/80/1/202""",
    )

    fb_80_1_204 = VocabularyTerm(
        code="FB_80_1_204",
        label="FB/80/1/204",
        description="""FB/80/1/204""",
    )

    fb_80_1_206 = VocabularyTerm(
        code="FB_80_1_206",
        label="FB/80/1/206",
        description="""FB/80/1/206""",
    )

    fb_80_1_207h = VocabularyTerm(
        code="FB_80_1_207H",
        label="FB/80/1/207H",
        description="""FB/80/1/207H""",
    )

    fb_80_1_208 = VocabularyTerm(
        code="FB_80_1_208",
        label="FB/80/1/208",
        description="""FB/80/1/208""",
    )

    fb_80_1_209 = VocabularyTerm(
        code="FB_80_1_209",
        label="FB/80/1/209",
        description="""FB/80/1/209""",
    )

    fb_80_1_209t = VocabularyTerm(
        code="FB_80_1_209T",
        label="FB/80/1/209T",
        description="""FB/80/1/209T""",
    )

    fb_80_1_210 = VocabularyTerm(
        code="FB_80_1_210",
        label="FB/80/1/210",
        description="""FB/80/1/210""",
    )

    fb_80_1_214 = VocabularyTerm(
        code="FB_80_1_214",
        label="FB/80/1/214",
        description="""FB/80/1/214""",
    )

    fb_80_1_252 = VocabularyTerm(
        code="FB_80_1_252",
        label="FB/80/1/252",
        description="""FB/80/1/252""",
    )

    fb_80_1_254 = VocabularyTerm(
        code="FB_80_1_254",
        label="FB/80/1/254",
        description="""FB/80/1/254""",
    )

    fb_80_1_257 = VocabularyTerm(
        code="FB_80_1_257",
        label="FB/80/1/257",
        description="""FB/80/1/257""",
    )

    fb_80_1_257b = VocabularyTerm(
        code="FB_80_1_257B",
        label="FB/80/1/257B",
        description="""FB/80/1/257B""",
    )

    fb_80_1_258 = VocabularyTerm(
        code="FB_80_1_258",
        label="FB/80/1/258",
        description="""FB/80/1/258""",
    )

    fb_80_1_259 = VocabularyTerm(
        code="FB_80_1_259",
        label="FB/80/1/259",
        description="""FB/80/1/259""",
    )

    fb_80_1_260 = VocabularyTerm(
        code="FB_80_1_260",
        label="FB/80/1/260",
        description="""FB/80/1/260""",
    )

    fb_80_1_260f = VocabularyTerm(
        code="FB_80_1_260F",
        label="FB/80/1/260F",
        description="""FB/80/1/260F""",
    )

    fb_80_1_261d = VocabularyTerm(
        code="FB_80_1_261D",
        label="FB/80/1/261D",
        description="""FB/80/1/261D""",
    )

    fb_80_1_261t = VocabularyTerm(
        code="FB_80_1_261T",
        label="FB/80/1/261T",
        description="""FB/80/1/261T""",
    )

    fb_80_1_264 = VocabularyTerm(
        code="FB_80_1_264",
        label="FB/80/1/264",
        description="""FB/80/1/264""",
    )

    fb_80_1_a1 = VocabularyTerm(
        code="FB_80_1_A1",
        label="FB/80/1/A1",
        description="""FB/80/1/A1""",
    )

    fb_80_2_300 = VocabularyTerm(
        code="FB_80_2_300",
        label="FB/80/2/300",
        description="""FB/80/2/300""",
    )

    fb_80_2_300b = VocabularyTerm(
        code="FB_80_2_300B",
        label="FB/80/2/300B",
        description="""FB/80/2/300B""",
    )

    fb_80_2_300f = VocabularyTerm(
        code="FB_80_2_300F",
        label="FB/80/2/300F",
        description="""FB/80/2/300F""",
    )

    fb_80_2_301d = VocabularyTerm(
        code="FB_80_2_301D",
        label="FB/80/2/301D",
        description="""FB/80/2/301D""",
    )

    fb_80_2_302 = VocabularyTerm(
        code="FB_80_2_302",
        label="FB/80/2/302",
        description="""FB/80/2/302""",
    )

    fb_80_2_303h = VocabularyTerm(
        code="FB_80_2_303H",
        label="FB/80/2/303H",
        description="""FB/80/2/303H""",
    )

    fb_80_2_304 = VocabularyTerm(
        code="FB_80_2_304",
        label="FB/80/2/304",
        description="""FB/80/2/304""",
    )

    fb_80_2_305 = VocabularyTerm(
        code="FB_80_2_305",
        label="FB/80/2/305",
        description="""FB/80/2/305""",
    )

    fb_80_2_307b = VocabularyTerm(
        code="FB_80_2_307B",
        label="FB/80/2/307B",
        description="""FB/80/2/307B""",
    )

    fb_80_2_309 = VocabularyTerm(
        code="FB_80_2_309",
        label="FB/80/2/309",
        description="""FB/80/2/309""",
    )

    fb_80_2_309b = VocabularyTerm(
        code="FB_80_2_309B",
        label="FB/80/2/309B",
        description="""FB/80/2/309B""",
    )

    fb_80_2_309f = VocabularyTerm(
        code="FB_80_2_309F",
        label="FB/80/2/309F",
        description="""FB/80/2/309F""",
    )

    fb_80_2_309t = VocabularyTerm(
        code="FB_80_2_309T",
        label="FB/80/2/309T",
        description="""FB/80/2/309T""",
    )

    fb_80_2_310 = VocabularyTerm(
        code="FB_80_2_310",
        label="FB/80/2/310",
        description="""FB/80/2/310""",
    )

    fb_80_2_312 = VocabularyTerm(
        code="FB_80_2_312",
        label="FB/80/2/312",
        description="""FB/80/2/312""",
    )

    fb_80_2_357 = VocabularyTerm(
        code="FB_80_2_357",
        label="FB/80/2/357",
        description="""FB/80/2/357""",
    )

    fb_80_2_357b = VocabularyTerm(
        code="FB_80_2_357B",
        label="FB/80/2/357B",
        description="""FB/80/2/357B""",
    )

    fb_80_2_359 = VocabularyTerm(
        code="FB_80_2_359",
        label="FB/80/2/359",
        description="""FB/80/2/359""",
    )

    fb_80_2_359b = VocabularyTerm(
        code="FB_80_2_359B",
        label="FB/80/2/359B",
        description="""FB/80/2/359B""",
    )

    fb_80_2_360 = VocabularyTerm(
        code="FB_80_2_360",
        label="FB/80/2/360",
        description="""FB/80/2/360""",
    )

    fb_80_2_360f = VocabularyTerm(
        code="FB_80_2_360F",
        label="FB/80/2/360F",
        description="""FB/80/2/360F""",
    )

    fb_80_2_361 = VocabularyTerm(
        code="FB_80_2_361",
        label="FB/80/2/361",
        description="""FB/80/2/361""",
    )

    fb_80_2_361b = VocabularyTerm(
        code="FB_80_2_361B",
        label="FB/80/2/361B",
        description="""FB/80/2/361B""",
    )

    fb_80_2_361f = VocabularyTerm(
        code="FB_80_2_361F",
        label="FB/80/2/361F",
        description="""FB/80/2/361F""",
    )

    fb_80_2_361t = VocabularyTerm(
        code="FB_80_2_361T",
        label="FB/80/2/361T",
        description="""FB/80/2/361T""",
    )

    fb_80_2_362 = VocabularyTerm(
        code="FB_80_2_362",
        label="FB/80/2/362",
        description="""FB/80/2/362""",
    )

    fb_80__1_000 = VocabularyTerm(
        code="FB_80_-1_000",
        label="FB/80/-1/000",
        description="""FB/80/-1/000""",
    )

    fb_80__1_000f = VocabularyTerm(
        code="FB_80_-1_000F",
        label="FB/80/-1/000F",
        description="""FB/80/-1/000F""",
    )

    fb_80__1_000t = VocabularyTerm(
        code="FB_80_-1_000T",
        label="FB/80/-1/000T",
        description="""FB/80/-1/000T""",
    )

    fb_80__1_001 = VocabularyTerm(
        code="FB_80_-1_001",
        label="FB/80/-1/001",
        description="""FB/80/-1/001""",
    )

    fb_80__1_002 = VocabularyTerm(
        code="FB_80_-1_002",
        label="FB/80/-1/002",
        description="""FB/80/-1/002""",
    )

    fb_80__1_004 = VocabularyTerm(
        code="FB_80_-1_004",
        label="FB/80/-1/004",
        description="""FB/80/-1/004""",
    )

    fb_80__1_006 = VocabularyTerm(
        code="FB_80_-1_006",
        label="FB/80/-1/006",
        description="""FB/80/-1/006""",
    )

    fb_80__1_008 = VocabularyTerm(
        code="FB_80_-1_008",
        label="FB/80/-1/008",
        description="""FB/80/-1/008""",
    )

    fb_80__1_009 = VocabularyTerm(
        code="FB_80_-1_009",
        label="FB/80/-1/009",
        description="""FB/80/-1/009""",
    )

    fb_80__1_009t = VocabularyTerm(
        code="FB_80_-1_009T",
        label="FB/80/-1/009T",
        description="""FB/80/-1/009T""",
    )

    fb_80__1_010 = VocabularyTerm(
        code="FB_80_-1_010",
        label="FB/80/-1/010",
        description="""FB/80/-1/010""",
    )

    fb_80__1_012 = VocabularyTerm(
        code="FB_80_-1_012",
        label="FB/80/-1/012",
        description="""FB/80/-1/012""",
    )

    fb_80__1_014 = VocabularyTerm(
        code="FB_80_-1_014",
        label="FB/80/-1/014",
        description="""FB/80/-1/014""",
    )

    fb_80__1_016 = VocabularyTerm(
        code="FB_80_-1_016",
        label="FB/80/-1/016",
        description="""FB/80/-1/016""",
    )

    fb_80__1_017 = VocabularyTerm(
        code="FB_80_-1_017",
        label="FB/80/-1/017",
        description="""FB/80/-1/017""",
    )

    fb_80__1_018 = VocabularyTerm(
        code="FB_80_-1_018",
        label="FB/80/-1/018",
        description="""FB/80/-1/018""",
    )

    fb_80__1_019f = VocabularyTerm(
        code="FB_80_-1_019F",
        label="FB/80/-1/019F",
        description="""FB/80/-1/019F""",
    )

    fb_80__1_020 = VocabularyTerm(
        code="FB_80_-1_020",
        label="FB/80/-1/020",
        description="""FB/80/-1/020""",
    )

    fb_80__1_020f = VocabularyTerm(
        code="FB_80_-1_020F",
        label="FB/80/-1/020F",
        description="""FB/80/-1/020F""",
    )

    fb_80__1_021 = VocabularyTerm(
        code="FB_80_-1_021",
        label="FB/80/-1/021",
        description="""FB/80/-1/021""",
    )

    fb_80__1_022 = VocabularyTerm(
        code="FB_80_-1_022",
        label="FB/80/-1/022",
        description="""FB/80/-1/022""",
    )

    fb_80__1_023 = VocabularyTerm(
        code="FB_80_-1_023",
        label="FB/80/-1/023",
        description="""FB/80/-1/023""",
    )

    fb_80__1_025 = VocabularyTerm(
        code="FB_80_-1_025",
        label="FB/80/-1/025",
        description="""FB/80/-1/025""",
    )

    fb_80__1_026 = VocabularyTerm(
        code="FB_80_-1_026",
        label="FB/80/-1/026",
        description="""FB/80/-1/026""",
    )

    fb_80__1_027 = VocabularyTerm(
        code="FB_80_-1_027",
        label="FB/80/-1/027",
        description="""FB/80/-1/027""",
    )

    fb_80__1_028 = VocabularyTerm(
        code="FB_80_-1_028",
        label="FB/80/-1/028",
        description="""FB/80/-1/028""",
    )

    fb_80__1_029 = VocabularyTerm(
        code="FB_80_-1_029",
        label="FB/80/-1/029",
        description="""FB/80/-1/029""",
    )

    fb_80__1_029f = VocabularyTerm(
        code="FB_80_-1_029F",
        label="FB/80/-1/029F",
        description="""FB/80/-1/029F""",
    )

    fb_80__1_030f = VocabularyTerm(
        code="FB_80_-1_030F",
        label="FB/80/-1/030F",
        description="""FB/80/-1/030F""",
    )

    fb_80__1_031 = VocabularyTerm(
        code="FB_80_-1_031",
        label="FB/80/-1/031",
        description="""FB/80/-1/031""",
    )

    fb_80__1_032 = VocabularyTerm(
        code="FB_80_-1_032",
        label="FB/80/-1/032",
        description="""FB/80/-1/032""",
    )

    fb_80__1_032f = VocabularyTerm(
        code="FB_80_-1_032F",
        label="FB/80/-1/032F",
        description="""FB/80/-1/032F""",
    )

    fb_80__1_033 = VocabularyTerm(
        code="FB_80_-1_033",
        label="FB/80/-1/033",
        description="""FB/80/-1/033""",
    )

    fb_80__1_033f = VocabularyTerm(
        code="FB_80_-1_033F",
        label="FB/80/-1/033F",
        description="""FB/80/-1/033F""",
    )

    fb_80__1_034 = VocabularyTerm(
        code="FB_80_-1_034",
        label="FB/80/-1/034",
        description="""FB/80/-1/034""",
    )

    fb_80__1_034d = VocabularyTerm(
        code="FB_80_-1_034D",
        label="FB/80/-1/034D",
        description="""FB/80/-1/034D""",
    )

    fb_80__1_034f = VocabularyTerm(
        code="FB_80_-1_034F",
        label="FB/80/-1/034F",
        description="""FB/80/-1/034F""",
    )

    fb_80__1_034h = VocabularyTerm(
        code="FB_80_-1_034H",
        label="FB/80/-1/034H",
        description="""FB/80/-1/034H""",
    )

    fb_80__1_034t = VocabularyTerm(
        code="FB_80_-1_034T",
        label="FB/80/-1/034T",
        description="""FB/80/-1/034T""",
    )

    fb_80__1_035 = VocabularyTerm(
        code="FB_80_-1_035",
        label="FB/80/-1/035",
        description="""FB/80/-1/035""",
    )

    fb_80__1_035b = VocabularyTerm(
        code="FB_80_-1_035B",
        label="FB/80/-1/035B",
        description="""FB/80/-1/035B""",
    )

    fb_80__1_037 = VocabularyTerm(
        code="FB_80_-1_037",
        label="FB/80/-1/037",
        description="""FB/80/-1/037""",
    )

    fb_80__1_038 = VocabularyTerm(
        code="FB_80_-1_038",
        label="FB/80/-1/038",
        description="""FB/80/-1/038""",
    )

    fb_80__1_039 = VocabularyTerm(
        code="FB_80_-1_039",
        label="FB/80/-1/039",
        description="""FB/80/-1/039""",
    )

    fb_80__1_040 = VocabularyTerm(
        code="FB_80_-1_040",
        label="FB/80/-1/040",
        description="""FB/80/-1/040""",
    )

    fb_80__1_041 = VocabularyTerm(
        code="FB_80_-1_041",
        label="FB/80/-1/041",
        description="""FB/80/-1/041""",
    )

    fb_80__1_042 = VocabularyTerm(
        code="FB_80_-1_042",
        label="FB/80/-1/042",
        description="""FB/80/-1/042""",
    )

    fb_80__1_042t = VocabularyTerm(
        code="FB_80_-1_042T",
        label="FB/80/-1/042T",
        description="""FB/80/-1/042T""",
    )

    fb_80__1_043 = VocabularyTerm(
        code="FB_80_-1_043",
        label="FB/80/-1/043",
        description="""FB/80/-1/043""",
    )

    fb_80__1_044 = VocabularyTerm(
        code="FB_80_-1_044",
        label="FB/80/-1/044",
        description="""FB/80/-1/044""",
    )

    fb_80__1_045t = VocabularyTerm(
        code="FB_80_-1_045T",
        label="FB/80/-1/045T",
        description="""FB/80/-1/045T""",
    )

    fb_80__1_046 = VocabularyTerm(
        code="FB_80_-1_046",
        label="FB/80/-1/046",
        description="""FB/80/-1/046""",
    )

    fb_80__1_049 = VocabularyTerm(
        code="FB_80_-1_049",
        label="FB/80/-1/049",
        description="""FB/80/-1/049""",
    )

    fb_80__1_050 = VocabularyTerm(
        code="FB_80_-1_050",
        label="FB/80/-1/050",
        description="""FB/80/-1/050""",
    )

    fb_80__1_050b = VocabularyTerm(
        code="FB_80_-1_050B",
        label="FB/80/-1/050B",
        description="""FB/80/-1/050B""",
    )

    fb_80__1_050f = VocabularyTerm(
        code="FB_80_-1_050F",
        label="FB/80/-1/050F",
        description="""FB/80/-1/050F""",
    )

    fb_80__1_052 = VocabularyTerm(
        code="FB_80_-1_052",
        label="FB/80/-1/052",
        description="""FB/80/-1/052""",
    )

    fb_80__1_054 = VocabularyTerm(
        code="FB_80_-1_054",
        label="FB/80/-1/054",
        description="""FB/80/-1/054""",
    )

    fb_80__1_055 = VocabularyTerm(
        code="FB_80_-1_055",
        label="FB/80/-1/055",
        description="""FB/80/-1/055""",
    )

    fb_80__1_057 = VocabularyTerm(
        code="FB_80_-1_057",
        label="FB/80/-1/057",
        description="""FB/80/-1/057""",
    )

    fb_80__1_058 = VocabularyTerm(
        code="FB_80_-1_058",
        label="FB/80/-1/058",
        description="""FB/80/-1/058""",
    )

    fb_80__1_059 = VocabularyTerm(
        code="FB_80_-1_059",
        label="FB/80/-1/059",
        description="""FB/80/-1/059""",
    )

    fb_80__1_059h = VocabularyTerm(
        code="FB_80_-1_059H",
        label="FB/80/-1/059H",
        description="""FB/80/-1/059H""",
    )

    fb_80__1_060 = VocabularyTerm(
        code="FB_80_-1_060",
        label="FB/80/-1/060",
        description="""FB/80/-1/060""",
    )

    fb_80__1_060b = VocabularyTerm(
        code="FB_80_-1_060B",
        label="FB/80/-1/060B",
        description="""FB/80/-1/060B""",
    )

    fb_80__1_060f = VocabularyTerm(
        code="FB_80_-1_060F",
        label="FB/80/-1/060F",
        description="""FB/80/-1/060F""",
    )

    fb_80__1_061 = VocabularyTerm(
        code="FB_80_-1_061",
        label="FB/80/-1/061",
        description="""FB/80/-1/061""",
    )

    fb_80__1_061d = VocabularyTerm(
        code="FB_80_-1_061D",
        label="FB/80/-1/061D",
        description="""FB/80/-1/061D""",
    )

    fb_80__1_061t = VocabularyTerm(
        code="FB_80_-1_061T",
        label="FB/80/-1/061T",
        description="""FB/80/-1/061T""",
    )

    fb_80__1_062 = VocabularyTerm(
        code="FB_80_-1_062",
        label="FB/80/-1/062",
        description="""FB/80/-1/062""",
    )

    fb_80__1_062b = VocabularyTerm(
        code="FB_80_-1_062B",
        label="FB/80/-1/062B",
        description="""FB/80/-1/062B""",
    )

    fb_80__1_062f = VocabularyTerm(
        code="FB_80_-1_062F",
        label="FB/80/-1/062F",
        description="""FB/80/-1/062F""",
    )

    fb_80__1_064 = VocabularyTerm(
        code="FB_80_-1_064",
        label="FB/80/-1/064",
        description="""FB/80/-1/064""",
    )

    fb_80__1_066 = VocabularyTerm(
        code="FB_80_-1_066",
        label="FB/80/-1/066",
        description="""FB/80/-1/066""",
    )

    fb_80__1_068 = VocabularyTerm(
        code="FB_80_-1_068",
        label="FB/80/-1/068",
        description="""FB/80/-1/068""",
    )

    fb_80__1_068b = VocabularyTerm(
        code="FB_80_-1_068B",
        label="FB/80/-1/068B",
        description="""FB/80/-1/068B""",
    )

    fb_80__1_069 = VocabularyTerm(
        code="FB_80_-1_069",
        label="FB/80/-1/069",
        description="""FB/80/-1/069""",
    )

    fb_80__1_069f = VocabularyTerm(
        code="FB_80_-1_069F",
        label="FB/80/-1/069F",
        description="""FB/80/-1/069F""",
    )

    fb_80__1_070 = VocabularyTerm(
        code="FB_80_-1_070",
        label="FB/80/-1/070",
        description="""FB/80/-1/070""",
    )

    fb_80__1_070f = VocabularyTerm(
        code="FB_80_-1_070F",
        label="FB/80/-1/070F",
        description="""FB/80/-1/070F""",
    )

    fb_80__1_071 = VocabularyTerm(
        code="FB_80_-1_071",
        label="FB/80/-1/071",
        description="""FB/80/-1/071""",
    )

    fb_80__1_071b = VocabularyTerm(
        code="FB_80_-1_071B",
        label="FB/80/-1/071B",
        description="""FB/80/-1/071B""",
    )

    fb_80__1_072 = VocabularyTerm(
        code="FB_80_-1_072",
        label="FB/80/-1/072",
        description="""FB/80/-1/072""",
    )

    fb_80__1_073 = VocabularyTerm(
        code="FB_80_-1_073",
        label="FB/80/-1/073",
        description="""FB/80/-1/073""",
    )

    fb_80__1_073t = VocabularyTerm(
        code="FB_80_-1_073T",
        label="FB/80/-1/073T",
        description="""FB/80/-1/073T""",
    )

    fb_80__1_076 = VocabularyTerm(
        code="FB_80_-1_076",
        label="FB/80/-1/076",
        description="""FB/80/-1/076""",
    )

    fb_80__1_077f = VocabularyTerm(
        code="FB_80_-1_077F",
        label="FB/80/-1/077F",
        description="""FB/80/-1/077F""",
    )

    fb_80__1_078 = VocabularyTerm(
        code="FB_80_-1_078",
        label="FB/80/-1/078",
        description="""FB/80/-1/078""",
    )

    fb_80__1_078t = VocabularyTerm(
        code="FB_80_-1_078T",
        label="FB/80/-1/078T",
        description="""FB/80/-1/078T""",
    )

    fb_80__1_080 = VocabularyTerm(
        code="FB_80_-1_080",
        label="FB/80/-1/080",
        description="""FB/80/-1/080""",
    )

    fb_80__1_080b = VocabularyTerm(
        code="FB_80_-1_080B",
        label="FB/80/-1/080B",
        description="""FB/80/-1/080B""",
    )

    fb_80__1_080f = VocabularyTerm(
        code="FB_80_-1_080F",
        label="FB/80/-1/080F",
        description="""FB/80/-1/080F""",
    )

    fb_80__1_081 = VocabularyTerm(
        code="FB_80_-1_081",
        label="FB/80/-1/081",
        description="""FB/80/-1/081""",
    )

    fb_80__1_082 = VocabularyTerm(
        code="FB_80_-1_082",
        label="FB/80/-1/082",
        description="""FB/80/-1/082""",
    )

    fb_80__1_082b = VocabularyTerm(
        code="FB_80_-1_082B",
        label="FB/80/-1/082B",
        description="""FB/80/-1/082B""",
    )

    fb_80__1_084 = VocabularyTerm(
        code="FB_80_-1_084",
        label="FB/80/-1/084",
        description="""FB/80/-1/084""",
    )

    fb_80__1_084b = VocabularyTerm(
        code="FB_80_-1_084B",
        label="FB/80/-1/084B",
        description="""FB/80/-1/084B""",
    )

    fb_80__1_084t = VocabularyTerm(
        code="FB_80_-1_084T",
        label="FB/80/-1/084T",
        description="""FB/80/-1/084T""",
    )

    fb_80__1_085b = VocabularyTerm(
        code="FB_80_-1_085B",
        label="FB/80/-1/085B",
        description="""FB/80/-1/085B""",
    )

    fb_80__1_086 = VocabularyTerm(
        code="FB_80_-1_086",
        label="FB/80/-1/086",
        description="""FB/80/-1/086""",
    )

    fb_80__1_086b = VocabularyTerm(
        code="FB_80_-1_086B",
        label="FB/80/-1/086B",
        description="""FB/80/-1/086B""",
    )

    fb_80__1_087 = VocabularyTerm(
        code="FB_80_-1_087",
        label="FB/80/-1/087",
        description="""FB/80/-1/087""",
    )

    fb_80__1_087b = VocabularyTerm(
        code="FB_80_-1_087B",
        label="FB/80/-1/087B",
        description="""FB/80/-1/087B""",
    )

    fb_80__1_088 = VocabularyTerm(
        code="FB_80_-1_088",
        label="FB/80/-1/088",
        description="""FB/80/-1/088""",
    )

    fb_80__1_088b = VocabularyTerm(
        code="FB_80_-1_088B",
        label="FB/80/-1/088B",
        description="""FB/80/-1/088B""",
    )

    fb_80__1_089 = VocabularyTerm(
        code="FB_80_-1_089",
        label="FB/80/-1/089",
        description="""FB/80/-1/089""",
    )

    fb_80__1_090 = VocabularyTerm(
        code="FB_80_-1_090",
        label="FB/80/-1/090",
        description="""FB/80/-1/090""",
    )

    fb_80__1_090b = VocabularyTerm(
        code="FB_80_-1_090B",
        label="FB/80/-1/090B",
        description="""FB/80/-1/090B""",
    )

    fb_80__1_090f = VocabularyTerm(
        code="FB_80_-1_090F",
        label="FB/80/-1/090F",
        description="""FB/80/-1/090F""",
    )

    fb_80__1_091 = VocabularyTerm(
        code="FB_80_-1_091",
        label="FB/80/-1/091",
        description="""FB/80/-1/091""",
    )

    fb_80__1_093 = VocabularyTerm(
        code="FB_80_-1_093",
        label="FB/80/-1/093",
        description="""FB/80/-1/093""",
    )

    fb_80__1_a1 = VocabularyTerm(
        code="FB_80_-1_A1",
        label="FB/80/-1/A1",
        description="""FB/80/-1/A1""",
    )

    fb_81_0_100 = VocabularyTerm(
        code="FB_81_0_100",
        label="FB/81/0/100",
        description="""FB/81/0/100""",
    )

    fb_81_0_102 = VocabularyTerm(
        code="FB_81_0_102",
        label="FB/81/0/102",
        description="""FB/81/0/102""",
    )

    fb_81_0_104 = VocabularyTerm(
        code="FB_81_0_104",
        label="FB/81/0/104",
        description="""FB/81/0/104""",
    )

    fb_81_0_106f = VocabularyTerm(
        code="FB_81_0_106F",
        label="FB/81/0/106F",
        description="""FB/81/0/106F""",
    )

    fb_81_0_106h = VocabularyTerm(
        code="FB_81_0_106H",
        label="FB/81/0/106H",
        description="""FB/81/0/106H""",
    )

    fb_81_0_108 = VocabularyTerm(
        code="FB_81_0_108",
        label="FB/81/0/108",
        description="""FB/81/0/108""",
    )

    fb_81_0_110 = VocabularyTerm(
        code="FB_81_0_110",
        label="FB/81/0/110",
        description="""FB/81/0/110""",
    )

    fb_81_0_112 = VocabularyTerm(
        code="FB_81_0_112",
        label="FB/81/0/112",
        description="""FB/81/0/112""",
    )

    fb_82_0_100 = VocabularyTerm(
        code="FB_82_0_100",
        label="FB/82/0/100",
        description="""FB/82/0/100""",
    )

    fb_82_0_100f = VocabularyTerm(
        code="FB_82_0_100F",
        label="FB/82/0/100F",
        description="""FB/82/0/100F""",
    )

    fb_82_0_101t = VocabularyTerm(
        code="FB_82_0_101T",
        label="FB/82/0/101T",
        description="""FB/82/0/101T""",
    )

    fb_82_0_102 = VocabularyTerm(
        code="FB_82_0_102",
        label="FB/82/0/102",
        description="""FB/82/0/102""",
    )

    fb_82_0_103 = VocabularyTerm(
        code="FB_82_0_103",
        label="FB/82/0/103",
        description="""FB/82/0/103""",
    )

    fb_82_0_104 = VocabularyTerm(
        code="FB_82_0_104",
        label="FB/82/0/104",
        description="""FB/82/0/104""",
    )

    fb_82_0_107 = VocabularyTerm(
        code="FB_82_0_107",
        label="FB/82/0/107",
        description="""FB/82/0/107""",
    )

    fb_82_0_108 = VocabularyTerm(
        code="FB_82_0_108",
        label="FB/82/0/108",
        description="""FB/82/0/108""",
    )

    fb_82_0_109 = VocabularyTerm(
        code="FB_82_0_109",
        label="FB/82/0/109",
        description="""FB/82/0/109""",
    )

    fb_82_0_110 = VocabularyTerm(
        code="FB_82_0_110",
        label="FB/82/0/110",
        description="""FB/82/0/110""",
    )

    fb_82_0_151 = VocabularyTerm(
        code="FB_82_0_151",
        label="FB/82/0/151",
        description="""FB/82/0/151""",
    )

    fb_82_0_152 = VocabularyTerm(
        code="FB_82_0_152",
        label="FB/82/0/152",
        description="""FB/82/0/152""",
    )

    fb_82_0_153h = VocabularyTerm(
        code="FB_82_0_153H",
        label="FB/82/0/153H",
        description="""FB/82/0/153H""",
    )

    fb_82_0_154 = VocabularyTerm(
        code="FB_82_0_154",
        label="FB/82/0/154",
        description="""FB/82/0/154""",
    )

    fb_82_0_155d = VocabularyTerm(
        code="FB_82_0_155D",
        label="FB/82/0/155D",
        description="""FB/82/0/155D""",
    )

    fb_82_0_155wc = VocabularyTerm(
        code="FB_82_0_155WC",
        label="FB/82/0/155WC",
        description="""FB/82/0/155WC""",
    )

    fb_82_0_156 = VocabularyTerm(
        code="FB_82_0_156",
        label="FB/82/0/156",
        description="""FB/82/0/156""",
    )

    fb_82_0_157 = VocabularyTerm(
        code="FB_82_0_157",
        label="FB/82/0/157",
        description="""FB/82/0/157""",
    )

    fb_82_0_159 = VocabularyTerm(
        code="FB_82_0_159",
        label="FB/82/0/159",
        description="""FB/82/0/159""",
    )

    fb_82_0_160 = VocabularyTerm(
        code="FB_82_0_160",
        label="FB/82/0/160",
        description="""FB/82/0/160""",
    )

    fb_82_0_162t = VocabularyTerm(
        code="FB_82_0_162T",
        label="FB/82/0/162T",
        description="""FB/82/0/162T""",
    )

    fb_82_0_balkon_1 = VocabularyTerm(
        code="FB_82_0_BALKON_1",
        label="FB/82/0/Balkon_1",
        description="""FB/82/0/Balkon_1""",
    )

    fb_82_0_balkon_2 = VocabularyTerm(
        code="FB_82_0_BALKON_2",
        label="FB/82/0/Balkon_2",
        description="""FB/82/0/Balkon_2""",
    )

    fb_82_1_200 = VocabularyTerm(
        code="FB_82_1_200",
        label="FB/82/1/200",
        description="""FB/82/1/200""",
    )

    fb_82_1_200f = VocabularyTerm(
        code="FB_82_1_200F",
        label="FB/82/1/200F",
        description="""FB/82/1/200F""",
    )

    fb_82_1_201t = VocabularyTerm(
        code="FB_82_1_201T",
        label="FB/82/1/201T",
        description="""FB/82/1/201T""",
    )

    fb_82_1_202 = VocabularyTerm(
        code="FB_82_1_202",
        label="FB/82/1/202",
        description="""FB/82/1/202""",
    )

    fb_82_1_203 = VocabularyTerm(
        code="FB_82_1_203",
        label="FB/82/1/203",
        description="""FB/82/1/203""",
    )

    fb_82_1_204 = VocabularyTerm(
        code="FB_82_1_204",
        label="FB/82/1/204",
        description="""FB/82/1/204""",
    )

    fb_82_1_205 = VocabularyTerm(
        code="FB_82_1_205",
        label="FB/82/1/205",
        description="""FB/82/1/205""",
    )

    fb_82_1_207 = VocabularyTerm(
        code="FB_82_1_207",
        label="FB/82/1/207",
        description="""FB/82/1/207""",
    )

    fb_82_1_208 = VocabularyTerm(
        code="FB_82_1_208",
        label="FB/82/1/208",
        description="""FB/82/1/208""",
    )

    fb_82_1_209 = VocabularyTerm(
        code="FB_82_1_209",
        label="FB/82/1/209",
        description="""FB/82/1/209""",
    )

    fb_82_1_210 = VocabularyTerm(
        code="FB_82_1_210",
        label="FB/82/1/210",
        description="""FB/82/1/210""",
    )

    fb_82_1_251 = VocabularyTerm(
        code="FB_82_1_251",
        label="FB/82/1/251",
        description="""FB/82/1/251""",
    )

    fb_82_1_252 = VocabularyTerm(
        code="FB_82_1_252",
        label="FB/82/1/252",
        description="""FB/82/1/252""",
    )

    fb_82_1_253d = VocabularyTerm(
        code="FB_82_1_253D",
        label="FB/82/1/253D",
        description="""FB/82/1/253D""",
    )

    fb_82_1_254 = VocabularyTerm(
        code="FB_82_1_254",
        label="FB/82/1/254",
        description="""FB/82/1/254""",
    )

    fb_82_1_255h = VocabularyTerm(
        code="FB_82_1_255H",
        label="FB/82/1/255H",
        description="""FB/82/1/255H""",
    )

    fb_82_1_256 = VocabularyTerm(
        code="FB_82_1_256",
        label="FB/82/1/256",
        description="""FB/82/1/256""",
    )

    fb_82_1_257 = VocabularyTerm(
        code="FB_82_1_257",
        label="FB/82/1/257",
        description="""FB/82/1/257""",
    )

    fb_82_1_258 = VocabularyTerm(
        code="FB_82_1_258",
        label="FB/82/1/258",
        description="""FB/82/1/258""",
    )

    fb_82_1_260 = VocabularyTerm(
        code="FB_82_1_260",
        label="FB/82/1/260",
        description="""FB/82/1/260""",
    )

    fb_82_1_262t = VocabularyTerm(
        code="FB_82_1_262T",
        label="FB/82/1/262T",
        description="""FB/82/1/262T""",
    )

    fb_82_1_balkon_1 = VocabularyTerm(
        code="FB_82_1_BALKON_1",
        label="FB/82/1/Balkon_1",
        description="""FB/82/1/Balkon_1""",
    )

    fb_82_1_balkon_2 = VocabularyTerm(
        code="FB_82_1_BALKON_2",
        label="FB/82/1/Balkon_2",
        description="""FB/82/1/Balkon_2""",
    )

    fb_82_1_balkon_3 = VocabularyTerm(
        code="FB_82_1_BALKON_3",
        label="FB/82/1/Balkon_3",
        description="""FB/82/1/Balkon_3""",
    )

    fb_82_2_300f = VocabularyTerm(
        code="FB_82_2_300F",
        label="FB/82/2/300F",
        description="""FB/82/2/300F""",
    )

    fb_82_2_301t = VocabularyTerm(
        code="FB_82_2_301T",
        label="FB/82/2/301T",
        description="""FB/82/2/301T""",
    )

    fb_82__1_000 = VocabularyTerm(
        code="FB_82_-1_000",
        label="FB/82/-1/000",
        description="""FB/82/-1/000""",
    )

    fb_82__1_000f = VocabularyTerm(
        code="FB_82_-1_000F",
        label="FB/82/-1/000F",
        description="""FB/82/-1/000F""",
    )

    fb_82__1_001 = VocabularyTerm(
        code="FB_82_-1_001",
        label="FB/82/-1/001",
        description="""FB/82/-1/001""",
    )

    fb_82__1_001t = VocabularyTerm(
        code="FB_82_-1_001T",
        label="FB/82/-1/001T",
        description="""FB/82/-1/001T""",
    )

    fb_82__1_002 = VocabularyTerm(
        code="FB_82_-1_002",
        label="FB/82/-1/002",
        description="""FB/82/-1/002""",
    )

    fb_82__1_003 = VocabularyTerm(
        code="FB_82_-1_003",
        label="FB/82/-1/003",
        description="""FB/82/-1/003""",
    )

    fb_82__1_004 = VocabularyTerm(
        code="FB_82_-1_004",
        label="FB/82/-1/004",
        description="""FB/82/-1/004""",
    )

    fb_82__1_005 = VocabularyTerm(
        code="FB_82_-1_005",
        label="FB/82/-1/005",
        description="""FB/82/-1/005""",
    )

    fb_82__1_007 = VocabularyTerm(
        code="FB_82_-1_007",
        label="FB/82/-1/007",
        description="""FB/82/-1/007""",
    )

    fb_82__1_008 = VocabularyTerm(
        code="FB_82_-1_008",
        label="FB/82/-1/008",
        description="""FB/82/-1/008""",
    )

    fb_82__1_009 = VocabularyTerm(
        code="FB_82_-1_009",
        label="FB/82/-1/009",
        description="""FB/82/-1/009""",
    )

    fb_82__1_009f = VocabularyTerm(
        code="FB_82_-1_009F",
        label="FB/82/-1/009F",
        description="""FB/82/-1/009F""",
    )

    fb_82__1_010 = VocabularyTerm(
        code="FB_82_-1_010",
        label="FB/82/-1/010",
        description="""FB/82/-1/010""",
    )

    fb_82__1_052 = VocabularyTerm(
        code="FB_82_-1_052",
        label="FB/82/-1/052",
        description="""FB/82/-1/052""",
    )

    fb_82__1_053 = VocabularyTerm(
        code="FB_82_-1_053",
        label="FB/82/-1/053",
        description="""FB/82/-1/053""",
    )

    fb_82__1_054 = VocabularyTerm(
        code="FB_82_-1_054",
        label="FB/82/-1/054",
        description="""FB/82/-1/054""",
    )

    fb_82__1_055 = VocabularyTerm(
        code="FB_82_-1_055",
        label="FB/82/-1/055",
        description="""FB/82/-1/055""",
    )

    fb_82__1_056 = VocabularyTerm(
        code="FB_82_-1_056",
        label="FB/82/-1/056",
        description="""FB/82/-1/056""",
    )

    fb_82__1_056b = VocabularyTerm(
        code="FB_82_-1_056B",
        label="FB/82/-1/056B",
        description="""FB/82/-1/056B""",
    )

    fb_82__1_057 = VocabularyTerm(
        code="FB_82_-1_057",
        label="FB/82/-1/057",
        description="""FB/82/-1/057""",
    )

    fb_82__1_057b = VocabularyTerm(
        code="FB_82_-1_057B",
        label="FB/82/-1/057B",
        description="""FB/82/-1/057B""",
    )

    fb_82__1_058 = VocabularyTerm(
        code="FB_82_-1_058",
        label="FB/82/-1/058",
        description="""FB/82/-1/058""",
    )

    fb_82__1_060 = VocabularyTerm(
        code="FB_82_-1_060",
        label="FB/82/-1/060",
        description="""FB/82/-1/060""",
    )

    fb_82__1_062t = VocabularyTerm(
        code="FB_82_-1_062T",
        label="FB/82/-1/062T",
        description="""FB/82/-1/062T""",
    )

    fb_83_0_100 = VocabularyTerm(
        code="FB_83_0_100",
        label="FB/83/0/100",
        description="""FB/83/0/100""",
    )

    fb_86_0_95 = VocabularyTerm(
        code="FB_86_0_95",
        label="FB/86/0/95",
        description="""FB/86/0/95""",
    )

    fb_86_0_96 = VocabularyTerm(
        code="FB_86_0_96",
        label="FB/86/0/96",
        description="""FB/86/0/96""",
    )

    fb_86_0_96f = VocabularyTerm(
        code="FB_86_0_96F",
        label="FB/86/0/96F",
        description="""FB/86/0/96F""",
    )

    fb_86_0_97 = VocabularyTerm(
        code="FB_86_0_97",
        label="FB/86/0/97",
        description="""FB/86/0/97""",
    )

    fb_86_0_98 = VocabularyTerm(
        code="FB_86_0_98",
        label="FB/86/0/98",
        description="""FB/86/0/98""",
    )

    fb_86_0_98f = VocabularyTerm(
        code="FB_86_0_98F",
        label="FB/86/0/98F",
        description="""FB/86/0/98F""",
    )

    fb_86_0_99 = VocabularyTerm(
        code="FB_86_0_99",
        label="FB/86/0/99",
        description="""FB/86/0/99""",
    )

    fb_86_0_100 = VocabularyTerm(
        code="FB_86_0_100",
        label="FB/86/0/100",
        description="""FB/86/0/100""",
    )

    fb_86_0_100b = VocabularyTerm(
        code="FB_86_0_100B",
        label="FB/86/0/100B",
        description="""FB/86/0/100B""",
    )

    fb_86_0_100f = VocabularyTerm(
        code="FB_86_0_100F",
        label="FB/86/0/100F",
        description="""FB/86/0/100F""",
    )

    fb_86_0_101 = VocabularyTerm(
        code="FB_86_0_101",
        label="FB/86/0/101",
        description="""FB/86/0/101""",
    )

    fb_86_0_102 = VocabularyTerm(
        code="FB_86_0_102",
        label="FB/86/0/102",
        description="""FB/86/0/102""",
    )

    fb_86_0_104f = VocabularyTerm(
        code="FB_86_0_104F",
        label="FB/86/0/104F",
        description="""FB/86/0/104F""",
    )

    fb_86_0_106t = VocabularyTerm(
        code="FB_86_0_106T",
        label="FB/86/0/106T",
        description="""FB/86/0/106T""",
    )

    fb_86_0_107 = VocabularyTerm(
        code="FB_86_0_107",
        label="FB/86/0/107",
        description="""FB/86/0/107""",
    )

    fb_86_0_107b = VocabularyTerm(
        code="FB_86_0_107B",
        label="FB/86/0/107B",
        description="""FB/86/0/107B""",
    )

    fb_86_0_108 = VocabularyTerm(
        code="FB_86_0_108",
        label="FB/86/0/108",
        description="""FB/86/0/108""",
    )

    fb_86_0_108b = VocabularyTerm(
        code="FB_86_0_108B",
        label="FB/86/0/108B",
        description="""FB/86/0/108B""",
    )

    fb_86_0_109 = VocabularyTerm(
        code="FB_86_0_109",
        label="FB/86/0/109",
        description="""FB/86/0/109""",
    )

    fb_86_0_109b = VocabularyTerm(
        code="FB_86_0_109B",
        label="FB/86/0/109B",
        description="""FB/86/0/109B""",
    )

    fb_86_0_110 = VocabularyTerm(
        code="FB_86_0_110",
        label="FB/86/0/110",
        description="""FB/86/0/110""",
    )

    fb_86_0_110b = VocabularyTerm(
        code="FB_86_0_110B",
        label="FB/86/0/110B",
        description="""FB/86/0/110B""",
    )

    fb_86_0_110f = VocabularyTerm(
        code="FB_86_0_110F",
        label="FB/86/0/110F",
        description="""FB/86/0/110F""",
    )

    fb_86_0_111 = VocabularyTerm(
        code="FB_86_0_111",
        label="FB/86/0/111",
        description="""FB/86/0/111""",
    )

    fb_86_0_111b = VocabularyTerm(
        code="FB_86_0_111B",
        label="FB/86/0/111B",
        description="""FB/86/0/111B""",
    )

    fb_86_0_111f = VocabularyTerm(
        code="FB_86_0_111F",
        label="FB/86/0/111F",
        description="""FB/86/0/111F""",
    )

    fb_86_0_112 = VocabularyTerm(
        code="FB_86_0_112",
        label="FB/86/0/112",
        description="""FB/86/0/112""",
    )

    fb_86_0_113b = VocabularyTerm(
        code="FB_86_0_113B",
        label="FB/86/0/113B",
        description="""FB/86/0/113B""",
    )

    fb_86_0_113f = VocabularyTerm(
        code="FB_86_0_113F",
        label="FB/86/0/113F",
        description="""FB/86/0/113F""",
    )

    fb_86_0_114 = VocabularyTerm(
        code="FB_86_0_114",
        label="FB/86/0/114",
        description="""FB/86/0/114""",
    )

    fb_86_0_114b = VocabularyTerm(
        code="FB_86_0_114B",
        label="FB/86/0/114B",
        description="""FB/86/0/114B""",
    )

    fb_86_0_114d = VocabularyTerm(
        code="FB_86_0_114D",
        label="FB/86/0/114D",
        description="""FB/86/0/114D""",
    )

    fb_86_0_114h = VocabularyTerm(
        code="FB_86_0_114H",
        label="FB/86/0/114H",
        description="""FB/86/0/114H""",
    )

    fb_86_0_115 = VocabularyTerm(
        code="FB_86_0_115",
        label="FB/86/0/115",
        description="""FB/86/0/115""",
    )

    fb_86_0_116b = VocabularyTerm(
        code="FB_86_0_116B",
        label="FB/86/0/116B",
        description="""FB/86/0/116B""",
    )

    fb_86_0_116t = VocabularyTerm(
        code="FB_86_0_116T",
        label="FB/86/0/116T",
        description="""FB/86/0/116T""",
    )

    fb_86_0_117 = VocabularyTerm(
        code="FB_86_0_117",
        label="FB/86/0/117",
        description="""FB/86/0/117""",
    )

    fb_86_0_118 = VocabularyTerm(
        code="FB_86_0_118",
        label="FB/86/0/118",
        description="""FB/86/0/118""",
    )

    fb_86_0_119 = VocabularyTerm(
        code="FB_86_0_119",
        label="FB/86/0/119",
        description="""FB/86/0/119""",
    )

    fb_86_0_119b = VocabularyTerm(
        code="FB_86_0_119B",
        label="FB/86/0/119B",
        description="""FB/86/0/119B""",
    )

    fb_86_0_120 = VocabularyTerm(
        code="FB_86_0_120",
        label="FB/86/0/120",
        description="""FB/86/0/120""",
    )

    fb_86_0_121 = VocabularyTerm(
        code="FB_86_0_121",
        label="FB/86/0/121",
        description="""FB/86/0/121""",
    )

    fb_86_0_121b = VocabularyTerm(
        code="FB_86_0_121B",
        label="FB/86/0/121B",
        description="""FB/86/0/121B""",
    )

    fb_86_0_122 = VocabularyTerm(
        code="FB_86_0_122",
        label="FB/86/0/122",
        description="""FB/86/0/122""",
    )

    fb_86_0_122b = VocabularyTerm(
        code="FB_86_0_122B",
        label="FB/86/0/122B",
        description="""FB/86/0/122B""",
    )

    fb_86_0_123 = VocabularyTerm(
        code="FB_86_0_123",
        label="FB/86/0/123",
        description="""FB/86/0/123""",
    )

    fb_86_0_123f = VocabularyTerm(
        code="FB_86_0_123F",
        label="FB/86/0/123F",
        description="""FB/86/0/123F""",
    )

    fb_86_0_124 = VocabularyTerm(
        code="FB_86_0_124",
        label="FB/86/0/124",
        description="""FB/86/0/124""",
    )

    fb_86_0_124b = VocabularyTerm(
        code="FB_86_0_124B",
        label="FB/86/0/124B",
        description="""FB/86/0/124B""",
    )

    fb_86_0_125f = VocabularyTerm(
        code="FB_86_0_125F",
        label="FB/86/0/125F",
        description="""FB/86/0/125F""",
    )

    fb_86_0_125t = VocabularyTerm(
        code="FB_86_0_125T",
        label="FB/86/0/125T",
        description="""FB/86/0/125T""",
    )

    fb_86_0_126 = VocabularyTerm(
        code="FB_86_0_126",
        label="FB/86/0/126",
        description="""FB/86/0/126""",
    )

    fb_86_0_127 = VocabularyTerm(
        code="FB_86_0_127",
        label="FB/86/0/127",
        description="""FB/86/0/127""",
    )

    fb_86_0_128 = VocabularyTerm(
        code="FB_86_0_128",
        label="FB/86/0/128",
        description="""FB/86/0/128""",
    )

    fb_86_0_129 = VocabularyTerm(
        code="FB_86_0_129",
        label="FB/86/0/129",
        description="""FB/86/0/129""",
    )

    fb_86_0_130 = VocabularyTerm(
        code="FB_86_0_130",
        label="FB/86/0/130",
        description="""FB/86/0/130""",
    )

    fb_86_0_a1 = VocabularyTerm(
        code="FB_86_0_A1",
        label="FB/86/0/A1",
        description="""FB/86/0/A1""",
    )

    fb_86__1_000 = VocabularyTerm(
        code="FB_86_-1_000",
        label="FB/86/-1/000",
        description="""FB/86/-1/000""",
    )

    fb_86__1_000b = VocabularyTerm(
        code="FB_86_-1_000B",
        label="FB/86/-1/000B",
        description="""FB/86/-1/000B""",
    )

    fb_86__1_001 = VocabularyTerm(
        code="FB_86_-1_001",
        label="FB/86/-1/001",
        description="""FB/86/-1/001""",
    )

    fb_86__1_001t = VocabularyTerm(
        code="FB_86_-1_001T",
        label="FB/86/-1/001T",
        description="""FB/86/-1/001T""",
    )

    fb_86__1_003 = VocabularyTerm(
        code="FB_86_-1_003",
        label="FB/86/-1/003",
        description="""FB/86/-1/003""",
    )

    fb_86__1_004 = VocabularyTerm(
        code="FB_86_-1_004",
        label="FB/86/-1/004",
        description="""FB/86/-1/004""",
    )

    fb_86__1_004b = VocabularyTerm(
        code="FB_86_-1_004B",
        label="FB/86/-1/004B",
        description="""FB/86/-1/004B""",
    )

    fb_86__1_004f = VocabularyTerm(
        code="FB_86_-1_004F",
        label="FB/86/-1/004F",
        description="""FB/86/-1/004F""",
    )

    fb_86__1_005 = VocabularyTerm(
        code="FB_86_-1_005",
        label="FB/86/-1/005",
        description="""FB/86/-1/005""",
    )

    fb_86__1_005f = VocabularyTerm(
        code="FB_86_-1_005F",
        label="FB/86/-1/005F",
        description="""FB/86/-1/005F""",
    )

    fb_86__1_006 = VocabularyTerm(
        code="FB_86_-1_006",
        label="FB/86/-1/006",
        description="""FB/86/-1/006""",
    )

    fb_86__1_006b = VocabularyTerm(
        code="FB_86_-1_006B",
        label="FB/86/-1/006B",
        description="""FB/86/-1/006B""",
    )

    fb_86__1_006t = VocabularyTerm(
        code="FB_86_-1_006T",
        label="FB/86/-1/006T",
        description="""FB/86/-1/006T""",
    )

    fb_86__1_007 = VocabularyTerm(
        code="FB_86_-1_007",
        label="FB/86/-1/007",
        description="""FB/86/-1/007""",
    )

    fb_86__1_008 = VocabularyTerm(
        code="FB_86_-1_008",
        label="FB/86/-1/008",
        description="""FB/86/-1/008""",
    )

    fb_86__1_009 = VocabularyTerm(
        code="FB_86_-1_009",
        label="FB/86/-1/009",
        description="""FB/86/-1/009""",
    )

    fb_86__1_010f = VocabularyTerm(
        code="FB_86_-1_010F",
        label="FB/86/-1/010F",
        description="""FB/86/-1/010F""",
    )

    fb_86__1_011 = VocabularyTerm(
        code="FB_86_-1_011",
        label="FB/86/-1/011",
        description="""FB/86/-1/011""",
    )

    fb_86__1_012 = VocabularyTerm(
        code="FB_86_-1_012",
        label="FB/86/-1/012",
        description="""FB/86/-1/012""",
    )

    fb_86__1_014 = VocabularyTerm(
        code="FB_86_-1_014",
        label="FB/86/-1/014",
        description="""FB/86/-1/014""",
    )

    fb_86__1_016f = VocabularyTerm(
        code="FB_86_-1_016F",
        label="FB/86/-1/016F",
        description="""FB/86/-1/016F""",
    )

    fb_86__1_016t = VocabularyTerm(
        code="FB_86_-1_016T",
        label="FB/86/-1/016T",
        description="""FB/86/-1/016T""",
    )

    fb_86__1_017 = VocabularyTerm(
        code="FB_86_-1_017",
        label="FB/86/-1/017",
        description="""FB/86/-1/017""",
    )

    fb_86__1_017b = VocabularyTerm(
        code="FB_86_-1_017B",
        label="FB/86/-1/017B",
        description="""FB/86/-1/017B""",
    )

    fb_86__1_017d = VocabularyTerm(
        code="FB_86_-1_017D",
        label="FB/86/-1/017D",
        description="""FB/86/-1/017D""",
    )

    fb_86__1_018 = VocabularyTerm(
        code="FB_86_-1_018",
        label="FB/86/-1/018",
        description="""FB/86/-1/018""",
    )

    fb_86__1_019 = VocabularyTerm(
        code="FB_86_-1_019",
        label="FB/86/-1/019",
        description="""FB/86/-1/019""",
    )

    fb_86__1_020b = VocabularyTerm(
        code="FB_86_-1_020B",
        label="FB/86/-1/020B",
        description="""FB/86/-1/020B""",
    )

    fb_86__1_022 = VocabularyTerm(
        code="FB_86_-1_022",
        label="FB/86/-1/022",
        description="""FB/86/-1/022""",
    )

    fb_86__1_022b = VocabularyTerm(
        code="FB_86_-1_022B",
        label="FB/86/-1/022B",
        description="""FB/86/-1/022B""",
    )

    fb_86__1_023 = VocabularyTerm(
        code="FB_86_-1_023",
        label="FB/86/-1/023",
        description="""FB/86/-1/023""",
    )

    fb_86__1_024 = VocabularyTerm(
        code="FB_86_-1_024",
        label="FB/86/-1/024",
        description="""FB/86/-1/024""",
    )

    fb_86__1_024b = VocabularyTerm(
        code="FB_86_-1_024B",
        label="FB/86/-1/024B",
        description="""FB/86/-1/024B""",
    )

    fb_86__1_025 = VocabularyTerm(
        code="FB_86_-1_025",
        label="FB/86/-1/025",
        description="""FB/86/-1/025""",
    )

    fb_86__1_025b = VocabularyTerm(
        code="FB_86_-1_025B",
        label="FB/86/-1/025B",
        description="""FB/86/-1/025B""",
    )

    fb_86__1_025h = VocabularyTerm(
        code="FB_86_-1_025H",
        label="FB/86/-1/025H",
        description="""FB/86/-1/025H""",
    )

    fb_86__1_025t = VocabularyTerm(
        code="FB_86_-1_025T",
        label="FB/86/-1/025T",
        description="""FB/86/-1/025T""",
    )

    fb_86__1_026 = VocabularyTerm(
        code="FB_86_-1_026",
        label="FB/86/-1/026",
        description="""FB/86/-1/026""",
    )

    fb_86__1_027 = VocabularyTerm(
        code="FB_86_-1_027",
        label="FB/86/-1/027",
        description="""FB/86/-1/027""",
    )

    fb_86__1_029 = VocabularyTerm(
        code="FB_86_-1_029",
        label="FB/86/-1/029",
        description="""FB/86/-1/029""",
    )

    fb_86__1_031 = VocabularyTerm(
        code="FB_86_-1_031",
        label="FB/86/-1/031",
        description="""FB/86/-1/031""",
    )

    fb_86__1_033 = VocabularyTerm(
        code="FB_86_-1_033",
        label="FB/86/-1/033",
        description="""FB/86/-1/033""",
    )

    fb_86__1_080k = VocabularyTerm(
        code="FB_86_-1_080K",
        label="FB/86/-1/080K",
        description="""FB/86/-1/080K""",
    )

    fb_86__1_098 = VocabularyTerm(
        code="FB_86_-1_098",
        label="FB/86/-1/098",
        description="""FB/86/-1/098""",
    )

    fb_86__1_a1 = VocabularyTerm(
        code="FB_86_-1_A1",
        label="FB/86/-1/A1",
        description="""FB/86/-1/A1""",
    )

    fb_88_0_100 = VocabularyTerm(
        code="FB_88_0_100",
        label="FB/88/0/100",
        description="""FB/88/0/100""",
    )

    fb_88_0_100b = VocabularyTerm(
        code="FB_88_0_100B",
        label="FB/88/0/100B",
        description="""FB/88/0/100B""",
    )

    fb_88_0_107f = VocabularyTerm(
        code="FB_88_0_107F",
        label="FB/88/0/107F",
        description="""FB/88/0/107F""",
    )

    fb_88_0_107t = VocabularyTerm(
        code="FB_88_0_107T",
        label="FB/88/0/107T",
        description="""FB/88/0/107T""",
    )

    fb_88_0_109 = VocabularyTerm(
        code="FB_88_0_109",
        label="FB/88/0/109",
        description="""FB/88/0/109""",
    )

    fb_88_0_114f = VocabularyTerm(
        code="FB_88_0_114F",
        label="FB/88/0/114F",
        description="""FB/88/0/114F""",
    )

    fb_88_0_114h = VocabularyTerm(
        code="FB_88_0_114H",
        label="FB/88/0/114H",
        description="""FB/88/0/114H""",
    )

    fb_88_0_114t = VocabularyTerm(
        code="FB_88_0_114T",
        label="FB/88/0/114T",
        description="""FB/88/0/114T""",
    )

    fb_88_0_116 = VocabularyTerm(
        code="FB_88_0_116",
        label="FB/88/0/116",
        description="""FB/88/0/116""",
    )

    fb_88_0_119 = VocabularyTerm(
        code="FB_88_0_119",
        label="FB/88/0/119",
        description="""FB/88/0/119""",
    )

    fb_88_0_121 = VocabularyTerm(
        code="FB_88_0_121",
        label="FB/88/0/121",
        description="""FB/88/0/121""",
    )

    fb_88_0_122 = VocabularyTerm(
        code="FB_88_0_122",
        label="FB/88/0/122",
        description="""FB/88/0/122""",
    )

    fb_88_0_124f = VocabularyTerm(
        code="FB_88_0_124F",
        label="FB/88/0/124F",
        description="""FB/88/0/124F""",
    )

    fb_88_0_126 = VocabularyTerm(
        code="FB_88_0_126",
        label="FB/88/0/126",
        description="""FB/88/0/126""",
    )

    fb_88_0_128 = VocabularyTerm(
        code="FB_88_0_128",
        label="FB/88/0/128",
        description="""FB/88/0/128""",
    )

    fb_88_0_129 = VocabularyTerm(
        code="FB_88_0_129",
        label="FB/88/0/129",
        description="""FB/88/0/129""",
    )

    fb_88_0_130 = VocabularyTerm(
        code="FB_88_0_130",
        label="FB/88/0/130",
        description="""FB/88/0/130""",
    )

    fb_88_0_132 = VocabularyTerm(
        code="FB_88_0_132",
        label="FB/88/0/132",
        description="""FB/88/0/132""",
    )

    fb_88_0_135 = VocabularyTerm(
        code="FB_88_0_135",
        label="FB/88/0/135",
        description="""FB/88/0/135""",
    )

    fb_88_0_136f = VocabularyTerm(
        code="FB_88_0_136F",
        label="FB/88/0/136F",
        description="""FB/88/0/136F""",
    )

    fb_88_0_136t = VocabularyTerm(
        code="FB_88_0_136T",
        label="FB/88/0/136T",
        description="""FB/88/0/136T""",
    )

    fb_88_0_145 = VocabularyTerm(
        code="FB_88_0_145",
        label="FB/88/0/145",
        description="""FB/88/0/145""",
    )

    fb_88_0_149 = VocabularyTerm(
        code="FB_88_0_149",
        label="FB/88/0/149",
        description="""FB/88/0/149""",
    )

    fb_88_0_151f = VocabularyTerm(
        code="FB_88_0_151F",
        label="FB/88/0/151F",
        description="""FB/88/0/151F""",
    )

    fb_88_0_153t = VocabularyTerm(
        code="FB_88_0_153T",
        label="FB/88/0/153T",
        description="""FB/88/0/153T""",
    )

    fb_88_0_155 = VocabularyTerm(
        code="FB_88_0_155",
        label="FB/88/0/155",
        description="""FB/88/0/155""",
    )

    fb_88_1a_114ad = VocabularyTerm(
        code="FB_88_1A_114AD",
        label="FB/88/1A/114AD",
        description="""FB/88/1A/114AD""",
    )

    fb_88_1a_114at = VocabularyTerm(
        code="FB_88_1A_114AT",
        label="FB/88/1A/114AT",
        description="""FB/88/1A/114AT""",
    )

    fb_88_1a_116a = VocabularyTerm(
        code="FB_88_1A_116A",
        label="FB/88/1A/116A",
        description="""FB/88/1A/116A""",
    )

    fb_88_1_200 = VocabularyTerm(
        code="FB_88_1_200",
        label="FB/88/1/200",
        description="""FB/88/1/200""",
    )

    fb_88_1_204 = VocabularyTerm(
        code="FB_88_1_204",
        label="FB/88/1/204",
        description="""FB/88/1/204""",
    )

    fb_88_1_206 = VocabularyTerm(
        code="FB_88_1_206",
        label="FB/88/1/206",
        description="""FB/88/1/206""",
    )

    fb_88_1_207f = VocabularyTerm(
        code="FB_88_1_207F",
        label="FB/88/1/207F",
        description="""FB/88/1/207F""",
    )

    fb_88_1_207t = VocabularyTerm(
        code="FB_88_1_207T",
        label="FB/88/1/207T",
        description="""FB/88/1/207T""",
    )

    fb_88_1_209 = VocabularyTerm(
        code="FB_88_1_209",
        label="FB/88/1/209",
        description="""FB/88/1/209""",
    )

    fb_88_1_209b = VocabularyTerm(
        code="FB_88_1_209B",
        label="FB/88/1/209B",
        description="""FB/88/1/209B""",
    )

    fb_88_1_210 = VocabularyTerm(
        code="FB_88_1_210",
        label="FB/88/1/210",
        description="""FB/88/1/210""",
    )

    fb_88_1_210b = VocabularyTerm(
        code="FB_88_1_210B",
        label="FB/88/1/210B",
        description="""FB/88/1/210B""",
    )

    fb_88_1_213 = VocabularyTerm(
        code="FB_88_1_213",
        label="FB/88/1/213",
        description="""FB/88/1/213""",
    )

    fb_88_1_214d = VocabularyTerm(
        code="FB_88_1_214D",
        label="FB/88/1/214D",
        description="""FB/88/1/214D""",
    )

    fb_88_1_214h = VocabularyTerm(
        code="FB_88_1_214H",
        label="FB/88/1/214H",
        description="""FB/88/1/214H""",
    )

    fb_88_1_214t = VocabularyTerm(
        code="FB_88_1_214T",
        label="FB/88/1/214T",
        description="""FB/88/1/214T""",
    )

    fb_88_1_216 = VocabularyTerm(
        code="FB_88_1_216",
        label="FB/88/1/216",
        description="""FB/88/1/216""",
    )

    fb_88_1_219 = VocabularyTerm(
        code="FB_88_1_219",
        label="FB/88/1/219",
        description="""FB/88/1/219""",
    )

    fb_88_1_219b = VocabularyTerm(
        code="FB_88_1_219B",
        label="FB/88/1/219B",
        description="""FB/88/1/219B""",
    )

    fb_88_1_221 = VocabularyTerm(
        code="FB_88_1_221",
        label="FB/88/1/221",
        description="""FB/88/1/221""",
    )

    fb_88_1_222 = VocabularyTerm(
        code="FB_88_1_222",
        label="FB/88/1/222",
        description="""FB/88/1/222""",
    )

    fb_88_1_223 = VocabularyTerm(
        code="FB_88_1_223",
        label="FB/88/1/223",
        description="""FB/88/1/223""",
    )

    fb_88_1_225 = VocabularyTerm(
        code="FB_88_1_225",
        label="FB/88/1/225",
        description="""FB/88/1/225""",
    )

    fb_88_1_226 = VocabularyTerm(
        code="FB_88_1_226",
        label="FB/88/1/226",
        description="""FB/88/1/226""",
    )

    fb_88_1_227 = VocabularyTerm(
        code="FB_88_1_227",
        label="FB/88/1/227",
        description="""FB/88/1/227""",
    )

    fb_88_1_228 = VocabularyTerm(
        code="FB_88_1_228",
        label="FB/88/1/228",
        description="""FB/88/1/228""",
    )

    fb_88_1_230 = VocabularyTerm(
        code="FB_88_1_230",
        label="FB/88/1/230",
        description="""FB/88/1/230""",
    )

    fb_88_1_230f = VocabularyTerm(
        code="FB_88_1_230F",
        label="FB/88/1/230F",
        description="""FB/88/1/230F""",
    )

    fb_88_1_232 = VocabularyTerm(
        code="FB_88_1_232",
        label="FB/88/1/232",
        description="""FB/88/1/232""",
    )

    fb_88_1_232h = VocabularyTerm(
        code="FB_88_1_232H",
        label="FB/88/1/232H",
        description="""FB/88/1/232H""",
    )

    fb_88_1_236t = VocabularyTerm(
        code="FB_88_1_236T",
        label="FB/88/1/236T",
        description="""FB/88/1/236T""",
    )

    fb_88_1_245 = VocabularyTerm(
        code="FB_88_1_245",
        label="FB/88/1/245",
        description="""FB/88/1/245""",
    )

    fb_88_1_247 = VocabularyTerm(
        code="FB_88_1_247",
        label="FB/88/1/247",
        description="""FB/88/1/247""",
    )

    fb_88_1_249 = VocabularyTerm(
        code="FB_88_1_249",
        label="FB/88/1/249",
        description="""FB/88/1/249""",
    )

    fb_88_1_251h = VocabularyTerm(
        code="FB_88_1_251H",
        label="FB/88/1/251H",
        description="""FB/88/1/251H""",
    )

    fb_88_1_253f = VocabularyTerm(
        code="FB_88_1_253F",
        label="FB/88/1/253F",
        description="""FB/88/1/253F""",
    )

    fb_88_1_253t = VocabularyTerm(
        code="FB_88_1_253T",
        label="FB/88/1/253T",
        description="""FB/88/1/253T""",
    )

    fb_88_2_345 = VocabularyTerm(
        code="FB_88_2_345",
        label="FB/88/2/345",
        description="""FB/88/2/345""",
    )

    fb_88_2_347 = VocabularyTerm(
        code="FB_88_2_347",
        label="FB/88/2/347",
        description="""FB/88/2/347""",
    )

    fb_88_2_349 = VocabularyTerm(
        code="FB_88_2_349",
        label="FB/88/2/349",
        description="""FB/88/2/349""",
    )

    fb_88_2_351d = VocabularyTerm(
        code="FB_88_2_351D",
        label="FB/88/2/351D",
        description="""FB/88/2/351D""",
    )

    fb_88_2_353f = VocabularyTerm(
        code="FB_88_2_353F",
        label="FB/88/2/353F",
        description="""FB/88/2/353F""",
    )

    fb_88_2_353t = VocabularyTerm(
        code="FB_88_2_353T",
        label="FB/88/2/353T",
        description="""FB/88/2/353T""",
    )

    fb_88_3_447 = VocabularyTerm(
        code="FB_88_3_447",
        label="FB/88/3/447",
        description="""FB/88/3/447""",
    )

    fb_88_3_449 = VocabularyTerm(
        code="FB_88_3_449",
        label="FB/88/3/449",
        description="""FB/88/3/449""",
    )

    fb_88_3_453f = VocabularyTerm(
        code="FB_88_3_453F",
        label="FB/88/3/453F",
        description="""FB/88/3/453F""",
    )

    fb_88_3_453t = VocabularyTerm(
        code="FB_88_3_453T",
        label="FB/88/3/453T",
        description="""FB/88/3/453T""",
    )

    fb_88__1_007b = VocabularyTerm(
        code="FB_88_-1_007B",
        label="FB/88/-1/007B",
        description="""FB/88/-1/007B""",
    )

    fb_88__1_007f = VocabularyTerm(
        code="FB_88_-1_007F",
        label="FB/88/-1/007F",
        description="""FB/88/-1/007F""",
    )

    fb_88__1_007t = VocabularyTerm(
        code="FB_88_-1_007T",
        label="FB/88/-1/007T",
        description="""FB/88/-1/007T""",
    )

    fb_88__1_009d = VocabularyTerm(
        code="FB_88_-1_009D",
        label="FB/88/-1/009D",
        description="""FB/88/-1/009D""",
    )

    fb_88__1_011b = VocabularyTerm(
        code="FB_88_-1_011B",
        label="FB/88/-1/011B",
        description="""FB/88/-1/011B""",
    )

    fb_88__1_013b = VocabularyTerm(
        code="FB_88_-1_013B",
        label="FB/88/-1/013B",
        description="""FB/88/-1/013B""",
    )

    fb_88__1_015b = VocabularyTerm(
        code="FB_88_-1_015B",
        label="FB/88/-1/015B",
        description="""FB/88/-1/015B""",
    )

    fb_88__1_015h = VocabularyTerm(
        code="FB_88_-1_015H",
        label="FB/88/-1/015H",
        description="""FB/88/-1/015H""",
    )

    fb_88__1_017 = VocabularyTerm(
        code="FB_88_-1_017",
        label="FB/88/-1/017",
        description="""FB/88/-1/017""",
    )

    fb_88__1_017b = VocabularyTerm(
        code="FB_88_-1_017B",
        label="FB/88/-1/017B",
        description="""FB/88/-1/017B""",
    )

    fb_88__1_045 = VocabularyTerm(
        code="FB_88_-1_045",
        label="FB/88/-1/045",
        description="""FB/88/-1/045""",
    )

    fb_88__1_051 = VocabularyTerm(
        code="FB_88_-1_051",
        label="FB/88/-1/051",
        description="""FB/88/-1/051""",
    )

    fb_88__1_053t = VocabularyTerm(
        code="FB_88_-1_053T",
        label="FB/88/-1/053T",
        description="""FB/88/-1/053T""",
    )

    fb_89_0_100 = VocabularyTerm(
        code="FB_89_0_100",
        label="FB/89/0/100",
        description="""FB/89/0/100""",
    )

    fb_89_0_100f = VocabularyTerm(
        code="FB_89_0_100F",
        label="FB/89/0/100F",
        description="""FB/89/0/100F""",
    )

    fb_89_0_104 = VocabularyTerm(
        code="FB_89_0_104",
        label="FB/89/0/104",
        description="""FB/89/0/104""",
    )

    fb_89_0_108h = VocabularyTerm(
        code="FB_89_0_108H",
        label="FB/89/0/108H",
        description="""FB/89/0/108H""",
    )

    fb_89_0_108wc = VocabularyTerm(
        code="FB_89_0_108WC",
        label="FB/89/0/108WC",
        description="""FB/89/0/108WC""",
    )

    fb_89_0_109f = VocabularyTerm(
        code="FB_89_0_109F",
        label="FB/89/0/109F",
        description="""FB/89/0/109F""",
    )

    fb_89_0_109t = VocabularyTerm(
        code="FB_89_0_109T",
        label="FB/89/0/109T",
        description="""FB/89/0/109T""",
    )

    fb_89_0_111f = VocabularyTerm(
        code="FB_89_0_111F",
        label="FB/89/0/111F",
        description="""FB/89/0/111F""",
    )

    fb_89_0_113 = VocabularyTerm(
        code="FB_89_0_113",
        label="FB/89/0/113",
        description="""FB/89/0/113""",
    )

    fb_89_0_115 = VocabularyTerm(
        code="FB_89_0_115",
        label="FB/89/0/115",
        description="""FB/89/0/115""",
    )

    fb_89_0_117 = VocabularyTerm(
        code="FB_89_0_117",
        label="FB/89/0/117",
        description="""FB/89/0/117""",
    )

    fb_89_0_119 = VocabularyTerm(
        code="FB_89_0_119",
        label="FB/89/0/119",
        description="""FB/89/0/119""",
    )

    fb_89_0_120 = VocabularyTerm(
        code="FB_89_0_120",
        label="FB/89/0/120",
        description="""FB/89/0/120""",
    )

    fb_89_0_120f = VocabularyTerm(
        code="FB_89_0_120F",
        label="FB/89/0/120F",
        description="""FB/89/0/120F""",
    )

    fb_89_0_154 = VocabularyTerm(
        code="FB_89_0_154",
        label="FB/89/0/154",
        description="""FB/89/0/154""",
    )

    fb_89_0_156 = VocabularyTerm(
        code="FB_89_0_156",
        label="FB/89/0/156",
        description="""FB/89/0/156""",
    )

    fb_89_0_157 = VocabularyTerm(
        code="FB_89_0_157",
        label="FB/89/0/157",
        description="""FB/89/0/157""",
    )

    fb_89_0_159d = VocabularyTerm(
        code="FB_89_0_159D",
        label="FB/89/0/159D",
        description="""FB/89/0/159D""",
    )

    fb_89_0_160 = VocabularyTerm(
        code="FB_89_0_160",
        label="FB/89/0/160",
        description="""FB/89/0/160""",
    )

    fb_89_0_160f = VocabularyTerm(
        code="FB_89_0_160F",
        label="FB/89/0/160F",
        description="""FB/89/0/160F""",
    )

    fb_89_0_162 = VocabularyTerm(
        code="FB_89_0_162",
        label="FB/89/0/162",
        description="""FB/89/0/162""",
    )

    fb_89_0_162f = VocabularyTerm(
        code="FB_89_0_162F",
        label="FB/89/0/162F",
        description="""FB/89/0/162F""",
    )

    fb_89_0_164 = VocabularyTerm(
        code="FB_89_0_164",
        label="FB/89/0/164",
        description="""FB/89/0/164""",
    )

    fb_89_0_168 = VocabularyTerm(
        code="FB_89_0_168",
        label="FB/89/0/168",
        description="""FB/89/0/168""",
    )

    fb_89_0_172 = VocabularyTerm(
        code="FB_89_0_172",
        label="FB/89/0/172",
        description="""FB/89/0/172""",
    )

    fb_89_0_176t = VocabularyTerm(
        code="FB_89_0_176T",
        label="FB/89/0/176T",
        description="""FB/89/0/176T""",
    )

    fb_89_0_178 = VocabularyTerm(
        code="FB_89_0_178",
        label="FB/89/0/178",
        description="""FB/89/0/178""",
    )

    fb_89_0_179 = VocabularyTerm(
        code="FB_89_0_179",
        label="FB/89/0/179",
        description="""FB/89/0/179""",
    )

    fb_89_0_180f = VocabularyTerm(
        code="FB_89_0_180F",
        label="FB/89/0/180F",
        description="""FB/89/0/180F""",
    )

    fb_89_0_181f = VocabularyTerm(
        code="FB_89_0_181F",
        label="FB/89/0/181F",
        description="""FB/89/0/181F""",
    )

    fb_89_0_182 = VocabularyTerm(
        code="FB_89_0_182",
        label="FB/89/0/182",
        description="""FB/89/0/182""",
    )

    fb_89_0_183 = VocabularyTerm(
        code="FB_89_0_183",
        label="FB/89/0/183",
        description="""FB/89/0/183""",
    )

    fb_89_0_184 = VocabularyTerm(
        code="FB_89_0_184",
        label="FB/89/0/184",
        description="""FB/89/0/184""",
    )

    fb_89_0_186 = VocabularyTerm(
        code="FB_89_0_186",
        label="FB/89/0/186",
        description="""FB/89/0/186""",
    )

    fb_89_0_187 = VocabularyTerm(
        code="FB_89_0_187",
        label="FB/89/0/187",
        description="""FB/89/0/187""",
    )

    fb_89_0_188 = VocabularyTerm(
        code="FB_89_0_188",
        label="FB/89/0/188",
        description="""FB/89/0/188""",
    )

    fb_89_0_189 = VocabularyTerm(
        code="FB_89_0_189",
        label="FB/89/0/189",
        description="""FB/89/0/189""",
    )

    fb_89_0_190 = VocabularyTerm(
        code="FB_89_0_190",
        label="FB/89/0/190",
        description="""FB/89/0/190""",
    )

    fb_89_0_191 = VocabularyTerm(
        code="FB_89_0_191",
        label="FB/89/0/191",
        description="""FB/89/0/191""",
    )

    fb_89_0_192 = VocabularyTerm(
        code="FB_89_0_192",
        label="FB/89/0/192",
        description="""FB/89/0/192""",
    )

    fb_89_0_193 = VocabularyTerm(
        code="FB_89_0_193",
        label="FB/89/0/193",
        description="""FB/89/0/193""",
    )

    fb_89_0_194t = VocabularyTerm(
        code="FB_89_0_194T",
        label="FB/89/0/194T",
        description="""FB/89/0/194T""",
    )

    fb_89_0_195h = VocabularyTerm(
        code="FB_89_0_195H",
        label="FB/89/0/195H",
        description="""FB/89/0/195H""",
    )

    fb_89_0_196 = VocabularyTerm(
        code="FB_89_0_196",
        label="FB/89/0/196",
        description="""FB/89/0/196""",
    )

    fb_89_0_aufzugn = VocabularyTerm(
        code="FB_89_0_AUFZUGN",
        label="FB/89/0/AUFZUGN",
        description="""FB/89/0/AUFZUGN""",
    )

    fb_89_0_aufzugs = VocabularyTerm(
        code="FB_89_0_AUFZUGS",
        label="FB/89/0/AUFZUGS",
        description="""FB/89/0/AUFZUGS""",
    )

    fb_89_0_balkon_nord = VocabularyTerm(
        code="FB_89_0_BALKON_NORD",
        label="FB/89/0/Balkon Nord",
        description="""FB/89/0/Balkon Nord""",
    )

    fb_89_0_balkon_ost = VocabularyTerm(
        code="FB_89_0_BALKON_OST",
        label="FB/89/0/Balkon Ost",
        description="""FB/89/0/Balkon Ost""",
    )

    fb_89_0_balkon_s_d = VocabularyTerm(
        code="FB_89_0_BALKON_S_D",
        label="FB/89/0/Balkon Süd",
        description="""FB/89/0/Balkon Süd""",
    )

    fb_89_0_balkon_west = VocabularyTerm(
        code="FB_89_0_BALKON_WEST",
        label="FB/89/0/Balkon West",
        description="""FB/89/0/Balkon West""",
    )

    fb_89_1a_280af = VocabularyTerm(
        code="FB_89_1A_280AF",
        label="FB/89/1A/280AF",
        description="""FB/89/1A/280AF""",
    )

    fb_89_1a_281af = VocabularyTerm(
        code="FB_89_1A_281AF",
        label="FB/89/1A/281AF",
        description="""FB/89/1A/281AF""",
    )

    fb_89_1a_282a = VocabularyTerm(
        code="FB_89_1A_282A",
        label="FB/89/1A/282A",
        description="""FB/89/1A/282A""",
    )

    fb_89_1a_283a = VocabularyTerm(
        code="FB_89_1A_283A",
        label="FB/89/1A/283A",
        description="""FB/89/1A/283A""",
    )

    fb_89_1a_285a = VocabularyTerm(
        code="FB_89_1A_285A",
        label="FB/89/1A/285A",
        description="""FB/89/1A/285A""",
    )

    fb_89_1a_286a = VocabularyTerm(
        code="FB_89_1A_286A",
        label="FB/89/1A/286A",
        description="""FB/89/1A/286A""",
    )

    fb_89_1a_287a = VocabularyTerm(
        code="FB_89_1A_287A",
        label="FB/89/1A/287A",
        description="""FB/89/1A/287A""",
    )

    fb_89_1a_290a = VocabularyTerm(
        code="FB_89_1A_290A",
        label="FB/89/1A/290A",
        description="""FB/89/1A/290A""",
    )

    fb_89_1a_291a = VocabularyTerm(
        code="FB_89_1A_291A",
        label="FB/89/1A/291A",
        description="""FB/89/1A/291A""",
    )

    fb_89_1a_292a = VocabularyTerm(
        code="FB_89_1A_292A",
        label="FB/89/1A/292A",
        description="""FB/89/1A/292A""",
    )

    fb_89_1a_293a = VocabularyTerm(
        code="FB_89_1A_293A",
        label="FB/89/1A/293A",
        description="""FB/89/1A/293A""",
    )

    fb_89_1a_294at = VocabularyTerm(
        code="FB_89_1A_294AT",
        label="FB/89/1A/294AT",
        description="""FB/89/1A/294AT""",
    )

    fb_89_1a_295ah = VocabularyTerm(
        code="FB_89_1A_295AH",
        label="FB/89/1A/295AH",
        description="""FB/89/1A/295AH""",
    )

    fb_89_1a_296a = VocabularyTerm(
        code="FB_89_1A_296A",
        label="FB/89/1A/296A",
        description="""FB/89/1A/296A""",
    )

    fb_89_1a_aufzugn = VocabularyTerm(
        code="FB_89_1A_AUFZUGN",
        label="FB/89/1A/AUFZUGN",
        description="""FB/89/1A/AUFZUGN""",
    )

    fb_89_1_200 = VocabularyTerm(
        code="FB_89_1_200",
        label="FB/89/1/200",
        description="""FB/89/1/200""",
    )

    fb_89_1_200f = VocabularyTerm(
        code="FB_89_1_200F",
        label="FB/89/1/200F",
        description="""FB/89/1/200F""",
    )

    fb_89_1_204 = VocabularyTerm(
        code="FB_89_1_204",
        label="FB/89/1/204",
        description="""FB/89/1/204""",
    )

    fb_89_1_208 = VocabularyTerm(
        code="FB_89_1_208",
        label="FB/89/1/208",
        description="""FB/89/1/208""",
    )

    fb_89_1_209f = VocabularyTerm(
        code="FB_89_1_209F",
        label="FB/89/1/209F",
        description="""FB/89/1/209F""",
    )

    fb_89_1_209t = VocabularyTerm(
        code="FB_89_1_209T",
        label="FB/89/1/209T",
        description="""FB/89/1/209T""",
    )

    fb_89_1_211h = VocabularyTerm(
        code="FB_89_1_211H",
        label="FB/89/1/211H",
        description="""FB/89/1/211H""",
    )

    fb_89_1_213 = VocabularyTerm(
        code="FB_89_1_213",
        label="FB/89/1/213",
        description="""FB/89/1/213""",
    )

    fb_89_1_217 = VocabularyTerm(
        code="FB_89_1_217",
        label="FB/89/1/217",
        description="""FB/89/1/217""",
    )

    fb_89_1_254 = VocabularyTerm(
        code="FB_89_1_254",
        label="FB/89/1/254",
        description="""FB/89/1/254""",
    )

    fb_89_1_256 = VocabularyTerm(
        code="FB_89_1_256",
        label="FB/89/1/256",
        description="""FB/89/1/256""",
    )

    fb_89_1_257 = VocabularyTerm(
        code="FB_89_1_257",
        label="FB/89/1/257",
        description="""FB/89/1/257""",
    )

    fb_89_1_259d = VocabularyTerm(
        code="FB_89_1_259D",
        label="FB/89/1/259D",
        description="""FB/89/1/259D""",
    )

    fb_89_1_260 = VocabularyTerm(
        code="FB_89_1_260",
        label="FB/89/1/260",
        description="""FB/89/1/260""",
    )

    fb_89_1_260f = VocabularyTerm(
        code="FB_89_1_260F",
        label="FB/89/1/260F",
        description="""FB/89/1/260F""",
    )

    fb_89_1_262 = VocabularyTerm(
        code="FB_89_1_262",
        label="FB/89/1/262",
        description="""FB/89/1/262""",
    )

    fb_89_1_262f = VocabularyTerm(
        code="FB_89_1_262F",
        label="FB/89/1/262F",
        description="""FB/89/1/262F""",
    )

    fb_89_1_264 = VocabularyTerm(
        code="FB_89_1_264",
        label="FB/89/1/264",
        description="""FB/89/1/264""",
    )

    fb_89_1_268 = VocabularyTerm(
        code="FB_89_1_268",
        label="FB/89/1/268",
        description="""FB/89/1/268""",
    )

    fb_89_1_272 = VocabularyTerm(
        code="FB_89_1_272",
        label="FB/89/1/272",
        description="""FB/89/1/272""",
    )

    fb_89_1_276t = VocabularyTerm(
        code="FB_89_1_276T",
        label="FB/89/1/276T",
        description="""FB/89/1/276T""",
    )

    fb_89_1_277 = VocabularyTerm(
        code="FB_89_1_277",
        label="FB/89/1/277",
        description="""FB/89/1/277""",
    )

    fb_89_1_277f = VocabularyTerm(
        code="FB_89_1_277F",
        label="FB/89/1/277F",
        description="""FB/89/1/277F""",
    )

    fb_89_1_278 = VocabularyTerm(
        code="FB_89_1_278",
        label="FB/89/1/278",
        description="""FB/89/1/278""",
    )

    fb_89_1_278b = VocabularyTerm(
        code="FB_89_1_278B",
        label="FB/89/1/278B",
        description="""FB/89/1/278B""",
    )

    fb_89_1_279 = VocabularyTerm(
        code="FB_89_1_279",
        label="FB/89/1/279",
        description="""FB/89/1/279""",
    )

    fb_89_1_280f = VocabularyTerm(
        code="FB_89_1_280F",
        label="FB/89/1/280F",
        description="""FB/89/1/280F""",
    )

    fb_89_1_281 = VocabularyTerm(
        code="FB_89_1_281",
        label="FB/89/1/281",
        description="""FB/89/1/281""",
    )

    fb_89_1_281f = VocabularyTerm(
        code="FB_89_1_281F",
        label="FB/89/1/281F",
        description="""FB/89/1/281F""",
    )

    fb_89_1_282 = VocabularyTerm(
        code="FB_89_1_282",
        label="FB/89/1/282",
        description="""FB/89/1/282""",
    )

    fb_89_1_284 = VocabularyTerm(
        code="FB_89_1_284",
        label="FB/89/1/284",
        description="""FB/89/1/284""",
    )

    fb_89_1_285 = VocabularyTerm(
        code="FB_89_1_285",
        label="FB/89/1/285",
        description="""FB/89/1/285""",
    )

    fb_89_1_286 = VocabularyTerm(
        code="FB_89_1_286",
        label="FB/89/1/286",
        description="""FB/89/1/286""",
    )

    fb_89_1_287 = VocabularyTerm(
        code="FB_89_1_287",
        label="FB/89/1/287",
        description="""FB/89/1/287""",
    )

    fb_89_1_288 = VocabularyTerm(
        code="FB_89_1_288",
        label="FB/89/1/288",
        description="""FB/89/1/288""",
    )

    fb_89_1_289 = VocabularyTerm(
        code="FB_89_1_289",
        label="FB/89/1/289",
        description="""FB/89/1/289""",
    )

    fb_89_1_290 = VocabularyTerm(
        code="FB_89_1_290",
        label="FB/89/1/290",
        description="""FB/89/1/290""",
    )

    fb_89_1_292 = VocabularyTerm(
        code="FB_89_1_292",
        label="FB/89/1/292",
        description="""FB/89/1/292""",
    )

    fb_89_1_293 = VocabularyTerm(
        code="FB_89_1_293",
        label="FB/89/1/293",
        description="""FB/89/1/293""",
    )

    fb_89_1_294t = VocabularyTerm(
        code="FB_89_1_294T",
        label="FB/89/1/294T",
        description="""FB/89/1/294T""",
    )

    fb_89_1_295h = VocabularyTerm(
        code="FB_89_1_295H",
        label="FB/89/1/295H",
        description="""FB/89/1/295H""",
    )

    fb_89_1_296 = VocabularyTerm(
        code="FB_89_1_296",
        label="FB/89/1/296",
        description="""FB/89/1/296""",
    )

    fb_89_1_aufzugn = VocabularyTerm(
        code="FB_89_1_AUFZUGN",
        label="FB/89/1/AUFZUGN",
        description="""FB/89/1/AUFZUGN""",
    )

    fb_89_1_aufzugs = VocabularyTerm(
        code="FB_89_1_AUFZUGS",
        label="FB/89/1/AUFZUGS",
        description="""FB/89/1/AUFZUGS""",
    )

    fb_89_1_balkon_s_d = VocabularyTerm(
        code="FB_89_1_BALKON_S_D",
        label="FB/89/1/Balkon Süd",
        description="""FB/89/1/Balkon Süd""",
    )

    fb_89_1_balkon_west = VocabularyTerm(
        code="FB_89_1_BALKON_WEST",
        label="FB/89/1/Balkon West",
        description="""FB/89/1/Balkon West""",
    )

    fb_89_2_300 = VocabularyTerm(
        code="FB_89_2_300",
        label="FB/89/2/300",
        description="""FB/89/2/300""",
    )

    fb_89_2_300f = VocabularyTerm(
        code="FB_89_2_300F",
        label="FB/89/2/300F",
        description="""FB/89/2/300F""",
    )

    fb_89_2_304 = VocabularyTerm(
        code="FB_89_2_304",
        label="FB/89/2/304",
        description="""FB/89/2/304""",
    )

    fb_89_2_306 = VocabularyTerm(
        code="FB_89_2_306",
        label="FB/89/2/306",
        description="""FB/89/2/306""",
    )

    fb_89_2_308 = VocabularyTerm(
        code="FB_89_2_308",
        label="FB/89/2/308",
        description="""FB/89/2/308""",
    )

    fb_89_2_309h = VocabularyTerm(
        code="FB_89_2_309H",
        label="FB/89/2/309H",
        description="""FB/89/2/309H""",
    )

    fb_89_2_309t = VocabularyTerm(
        code="FB_89_2_309T",
        label="FB/89/2/309T",
        description="""FB/89/2/309T""",
    )

    fb_89_2_311f = VocabularyTerm(
        code="FB_89_2_311F",
        label="FB/89/2/311F",
        description="""FB/89/2/311F""",
    )

    fb_89_2_312f = VocabularyTerm(
        code="FB_89_2_312F",
        label="FB/89/2/312F",
        description="""FB/89/2/312F""",
    )

    fb_89_2_313 = VocabularyTerm(
        code="FB_89_2_313",
        label="FB/89/2/313",
        description="""FB/89/2/313""",
    )

    fb_89_2_315 = VocabularyTerm(
        code="FB_89_2_315",
        label="FB/89/2/315",
        description="""FB/89/2/315""",
    )

    fb_89_2_317 = VocabularyTerm(
        code="FB_89_2_317",
        label="FB/89/2/317",
        description="""FB/89/2/317""",
    )

    fb_89_2_320 = VocabularyTerm(
        code="FB_89_2_320",
        label="FB/89/2/320",
        description="""FB/89/2/320""",
    )

    fb_89_2_321 = VocabularyTerm(
        code="FB_89_2_321",
        label="FB/89/2/321",
        description="""FB/89/2/321""",
    )

    fb_89_2_323 = VocabularyTerm(
        code="FB_89_2_323",
        label="FB/89/2/323",
        description="""FB/89/2/323""",
    )

    fb_89_2_354 = VocabularyTerm(
        code="FB_89_2_354",
        label="FB/89/2/354",
        description="""FB/89/2/354""",
    )

    fb_89_2_356 = VocabularyTerm(
        code="FB_89_2_356",
        label="FB/89/2/356",
        description="""FB/89/2/356""",
    )

    fb_89_2_357 = VocabularyTerm(
        code="FB_89_2_357",
        label="FB/89/2/357",
        description="""FB/89/2/357""",
    )

    fb_89_2_359d = VocabularyTerm(
        code="FB_89_2_359D",
        label="FB/89/2/359D",
        description="""FB/89/2/359D""",
    )

    fb_89_2_360 = VocabularyTerm(
        code="FB_89_2_360",
        label="FB/89/2/360",
        description="""FB/89/2/360""",
    )

    fb_89_2_360f = VocabularyTerm(
        code="FB_89_2_360F",
        label="FB/89/2/360F",
        description="""FB/89/2/360F""",
    )

    fb_89_2_362 = VocabularyTerm(
        code="FB_89_2_362",
        label="FB/89/2/362",
        description="""FB/89/2/362""",
    )

    fb_89_2_362f = VocabularyTerm(
        code="FB_89_2_362F",
        label="FB/89/2/362F",
        description="""FB/89/2/362F""",
    )

    fb_89_2_364 = VocabularyTerm(
        code="FB_89_2_364",
        label="FB/89/2/364",
        description="""FB/89/2/364""",
    )

    fb_89_2_368 = VocabularyTerm(
        code="FB_89_2_368",
        label="FB/89/2/368",
        description="""FB/89/2/368""",
    )

    fb_89_2_372 = VocabularyTerm(
        code="FB_89_2_372",
        label="FB/89/2/372",
        description="""FB/89/2/372""",
    )

    fb_89_2_376t = VocabularyTerm(
        code="FB_89_2_376T",
        label="FB/89/2/376T",
        description="""FB/89/2/376T""",
    )

    fb_89_2_377f = VocabularyTerm(
        code="FB_89_2_377F",
        label="FB/89/2/377F",
        description="""FB/89/2/377F""",
    )

    fb_89_2_378 = VocabularyTerm(
        code="FB_89_2_378",
        label="FB/89/2/378",
        description="""FB/89/2/378""",
    )

    fb_89_2_378f = VocabularyTerm(
        code="FB_89_2_378F",
        label="FB/89/2/378F",
        description="""FB/89/2/378F""",
    )

    fb_89_2_378t = VocabularyTerm(
        code="FB_89_2_378T",
        label="FB/89/2/378T",
        description="""FB/89/2/378T""",
    )

    fb_89_2_379 = VocabularyTerm(
        code="FB_89_2_379",
        label="FB/89/2/379",
        description="""FB/89/2/379""",
    )

    fb_89_2_380 = VocabularyTerm(
        code="FB_89_2_380",
        label="FB/89/2/380",
        description="""FB/89/2/380""",
    )

    fb_89_2_380f = VocabularyTerm(
        code="FB_89_2_380F",
        label="FB/89/2/380F",
        description="""FB/89/2/380F""",
    )

    fb_89_2_381 = VocabularyTerm(
        code="FB_89_2_381",
        label="FB/89/2/381",
        description="""FB/89/2/381""",
    )

    fb_89_2_381f = VocabularyTerm(
        code="FB_89_2_381F",
        label="FB/89/2/381F",
        description="""FB/89/2/381F""",
    )

    fb_89_2_384 = VocabularyTerm(
        code="FB_89_2_384",
        label="FB/89/2/384",
        description="""FB/89/2/384""",
    )

    fb_89_2_385 = VocabularyTerm(
        code="FB_89_2_385",
        label="FB/89/2/385",
        description="""FB/89/2/385""",
    )

    fb_89_2_386 = VocabularyTerm(
        code="FB_89_2_386",
        label="FB/89/2/386",
        description="""FB/89/2/386""",
    )

    fb_89_2_387 = VocabularyTerm(
        code="FB_89_2_387",
        label="FB/89/2/387",
        description="""FB/89/2/387""",
    )

    fb_89_2_388 = VocabularyTerm(
        code="FB_89_2_388",
        label="FB/89/2/388",
        description="""FB/89/2/388""",
    )

    fb_89_2_389 = VocabularyTerm(
        code="FB_89_2_389",
        label="FB/89/2/389",
        description="""FB/89/2/389""",
    )

    fb_89_2_390 = VocabularyTerm(
        code="FB_89_2_390",
        label="FB/89/2/390",
        description="""FB/89/2/390""",
    )

    fb_89_2_391 = VocabularyTerm(
        code="FB_89_2_391",
        label="FB/89/2/391",
        description="""FB/89/2/391""",
    )

    fb_89_2_392 = VocabularyTerm(
        code="FB_89_2_392",
        label="FB/89/2/392",
        description="""FB/89/2/392""",
    )

    fb_89_2_393b = VocabularyTerm(
        code="FB_89_2_393B",
        label="FB/89/2/393B",
        description="""FB/89/2/393B""",
    )

    fb_89_2_393h = VocabularyTerm(
        code="FB_89_2_393H",
        label="FB/89/2/393H",
        description="""FB/89/2/393H""",
    )

    fb_89_2_394t = VocabularyTerm(
        code="FB_89_2_394T",
        label="FB/89/2/394T",
        description="""FB/89/2/394T""",
    )

    fb_89_2_395 = VocabularyTerm(
        code="FB_89_2_395",
        label="FB/89/2/395",
        description="""FB/89/2/395""",
    )

    fb_89_2_aufzugn = VocabularyTerm(
        code="FB_89_2_AUFZUGN",
        label="FB/89/2/AUFZUGN",
        description="""FB/89/2/AUFZUGN""",
    )

    fb_89_2_aufzugs = VocabularyTerm(
        code="FB_89_2_AUFZUGS",
        label="FB/89/2/AUFZUGS",
        description="""FB/89/2/AUFZUGS""",
    )

    fb_89_2_balkon_s_d = VocabularyTerm(
        code="FB_89_2_BALKON_S_D",
        label="FB/89/2/BALKON Süd",
        description="""FB/89/2/BALKON Süd""",
    )

    fb_89_2_balkon_west = VocabularyTerm(
        code="FB_89_2_BALKON_WEST",
        label="FB/89/2/BALKON West",
        description="""FB/89/2/BALKON West""",
    )

    fb_89_3_409t = VocabularyTerm(
        code="FB_89_3_409T",
        label="FB/89/3/409T",
        description="""FB/89/3/409T""",
    )

    fb_89_3_410 = VocabularyTerm(
        code="FB_89_3_410",
        label="FB/89/3/410",
        description="""FB/89/3/410""",
    )

    fb_89_3_470 = VocabularyTerm(
        code="FB_89_3_470",
        label="FB/89/3/470",
        description="""FB/89/3/470""",
    )

    fb_89_3_476t = VocabularyTerm(
        code="FB_89_3_476T",
        label="FB/89/3/476T",
        description="""FB/89/3/476T""",
    )

    fb_89_3_480 = VocabularyTerm(
        code="FB_89_3_480",
        label="FB/89/3/480",
        description="""FB/89/3/480""",
    )

    fb_89__1_000 = VocabularyTerm(
        code="FB_89_-1_000",
        label="FB/89/-1/000",
        description="""FB/89/-1/000""",
    )

    fb_89__1_000b = VocabularyTerm(
        code="FB_89_-1_000B",
        label="FB/89/-1/000B",
        description="""FB/89/-1/000B""",
    )

    fb_89__1_000f = VocabularyTerm(
        code="FB_89_-1_000F",
        label="FB/89/-1/000F",
        description="""FB/89/-1/000F""",
    )

    fb_89__1_004 = VocabularyTerm(
        code="FB_89_-1_004",
        label="FB/89/-1/004",
        description="""FB/89/-1/004""",
    )

    fb_89__1_006 = VocabularyTerm(
        code="FB_89_-1_006",
        label="FB/89/-1/006",
        description="""FB/89/-1/006""",
    )

    fb_89__1_007 = VocabularyTerm(
        code="FB_89_-1_007",
        label="FB/89/-1/007",
        description="""FB/89/-1/007""",
    )

    fb_89__1_008 = VocabularyTerm(
        code="FB_89_-1_008",
        label="FB/89/-1/008",
        description="""FB/89/-1/008""",
    )

    fb_89__1_009f = VocabularyTerm(
        code="FB_89_-1_009F",
        label="FB/89/-1/009F",
        description="""FB/89/-1/009F""",
    )

    fb_89__1_009t = VocabularyTerm(
        code="FB_89_-1_009T",
        label="FB/89/-1/009T",
        description="""FB/89/-1/009T""",
    )

    fb_89__1_011 = VocabularyTerm(
        code="FB_89_-1_011",
        label="FB/89/-1/011",
        description="""FB/89/-1/011""",
    )

    fb_89__1_013 = VocabularyTerm(
        code="FB_89_-1_013",
        label="FB/89/-1/013",
        description="""FB/89/-1/013""",
    )

    fb_89__1_017 = VocabularyTerm(
        code="FB_89_-1_017",
        label="FB/89/-1/017",
        description="""FB/89/-1/017""",
    )

    fb_89__1_019 = VocabularyTerm(
        code="FB_89_-1_019",
        label="FB/89/-1/019",
        description="""FB/89/-1/019""",
    )

    fb_89__1_020 = VocabularyTerm(
        code="FB_89_-1_020",
        label="FB/89/-1/020",
        description="""FB/89/-1/020""",
    )

    fb_89__1_020b = VocabularyTerm(
        code="FB_89_-1_020B",
        label="FB/89/-1/020B",
        description="""FB/89/-1/020B""",
    )

    fb_89__1_021 = VocabularyTerm(
        code="FB_89_-1_021",
        label="FB/89/-1/021",
        description="""FB/89/-1/021""",
    )

    fb_89__1_021b = VocabularyTerm(
        code="FB_89_-1_021B",
        label="FB/89/-1/021B",
        description="""FB/89/-1/021B""",
    )

    fb_89__1_054 = VocabularyTerm(
        code="FB_89_-1_054",
        label="FB/89/-1/054",
        description="""FB/89/-1/054""",
    )

    fb_89__1_056 = VocabularyTerm(
        code="FB_89_-1_056",
        label="FB/89/-1/056",
        description="""FB/89/-1/056""",
    )

    fb_89__1_057b = VocabularyTerm(
        code="FB_89_-1_057B",
        label="FB/89/-1/057B",
        description="""FB/89/-1/057B""",
    )

    fb_89__1_057h = VocabularyTerm(
        code="FB_89_-1_057H",
        label="FB/89/-1/057H",
        description="""FB/89/-1/057H""",
    )

    fb_89__1_059d = VocabularyTerm(
        code="FB_89_-1_059D",
        label="FB/89/-1/059D",
        description="""FB/89/-1/059D""",
    )

    fb_89__1_060 = VocabularyTerm(
        code="FB_89_-1_060",
        label="FB/89/-1/060",
        description="""FB/89/-1/060""",
    )

    fb_89__1_060f = VocabularyTerm(
        code="FB_89_-1_060F",
        label="FB/89/-1/060F",
        description="""FB/89/-1/060F""",
    )

    fb_89__1_062b = VocabularyTerm(
        code="FB_89_-1_062B",
        label="FB/89/-1/062B",
        description="""FB/89/-1/062B""",
    )

    fb_89__1_062f = VocabularyTerm(
        code="FB_89_-1_062F",
        label="FB/89/-1/062F",
        description="""FB/89/-1/062F""",
    )

    fb_89__1_064 = VocabularyTerm(
        code="FB_89_-1_064",
        label="FB/89/-1/064",
        description="""FB/89/-1/064""",
    )

    fb_89__1_068 = VocabularyTerm(
        code="FB_89_-1_068",
        label="FB/89/-1/068",
        description="""FB/89/-1/068""",
    )

    fb_89__1_072 = VocabularyTerm(
        code="FB_89_-1_072",
        label="FB/89/-1/072",
        description="""FB/89/-1/072""",
    )

    fb_89__1_076 = VocabularyTerm(
        code="FB_89_-1_076",
        label="FB/89/-1/076",
        description="""FB/89/-1/076""",
    )

    fb_89__1_076t = VocabularyTerm(
        code="FB_89_-1_076T",
        label="FB/89/-1/076T",
        description="""FB/89/-1/076T""",
    )

    fb_89__1_077f = VocabularyTerm(
        code="FB_89_-1_077F",
        label="FB/89/-1/077F",
        description="""FB/89/-1/077F""",
    )

    fb_89__1_078 = VocabularyTerm(
        code="FB_89_-1_078",
        label="FB/89/-1/078",
        description="""FB/89/-1/078""",
    )

    fb_89__1_078b = VocabularyTerm(
        code="FB_89_-1_078B",
        label="FB/89/-1/078B",
        description="""FB/89/-1/078B""",
    )

    fb_89__1_079 = VocabularyTerm(
        code="FB_89_-1_079",
        label="FB/89/-1/079",
        description="""FB/89/-1/079""",
    )

    fb_89__1_081 = VocabularyTerm(
        code="FB_89_-1_081",
        label="FB/89/-1/081",
        description="""FB/89/-1/081""",
    )

    fb_89__1_081f = VocabularyTerm(
        code="FB_89_-1_081F",
        label="FB/89/-1/081F",
        description="""FB/89/-1/081F""",
    )

    fb_89__1_083 = VocabularyTerm(
        code="FB_89_-1_083",
        label="FB/89/-1/083",
        description="""FB/89/-1/083""",
    )

    fb_89__1_084 = VocabularyTerm(
        code="FB_89_-1_084",
        label="FB/89/-1/084",
        description="""FB/89/-1/084""",
    )

    fb_89__1_085 = VocabularyTerm(
        code="FB_89_-1_085",
        label="FB/89/-1/085",
        description="""FB/89/-1/085""",
    )

    fb_89__1_086 = VocabularyTerm(
        code="FB_89_-1_086",
        label="FB/89/-1/086",
        description="""FB/89/-1/086""",
    )

    fb_89__1_087 = VocabularyTerm(
        code="FB_89_-1_087",
        label="FB/89/-1/087",
        description="""FB/89/-1/087""",
    )

    fb_89__1_088 = VocabularyTerm(
        code="FB_89_-1_088",
        label="FB/89/-1/088",
        description="""FB/89/-1/088""",
    )

    fb_89__1_091 = VocabularyTerm(
        code="FB_89_-1_091",
        label="FB/89/-1/091",
        description="""FB/89/-1/091""",
    )

    fb_89__1_092 = VocabularyTerm(
        code="FB_89_-1_092",
        label="FB/89/-1/092",
        description="""FB/89/-1/092""",
    )

    fb_89__1_093 = VocabularyTerm(
        code="FB_89_-1_093",
        label="FB/89/-1/093",
        description="""FB/89/-1/093""",
    )

    fb_89__1_094t = VocabularyTerm(
        code="FB_89_-1_094T",
        label="FB/89/-1/094T",
        description="""FB/89/-1/094T""",
    )

    fb_89__1_aufzugn = VocabularyTerm(
        code="FB_89_-1_AUFZUGN",
        label="FB/89/-1/AUFZUGN",
        description="""FB/89/-1/AUFZUGN""",
    )

    fb_89__1_aufzug_s = VocabularyTerm(
        code="FB_89_-1_AUFZUG_S",
        label="FB/89/-1/AUFZUG S",
        description="""FB/89/-1/AUFZUG S""",
    )

    tts_101_0_100b = VocabularyTerm(
        code="TTS_101_0_100B",
        label="TTS/101/0/100B",
        description="""TTS/101/0/100B""",
    )

    tts_101_0_100d = VocabularyTerm(
        code="TTS_101_0_100D",
        label="TTS/101/0/100D",
        description="""TTS/101/0/100D""",
    )

    tts_101_0_100f = VocabularyTerm(
        code="TTS_101_0_100F",
        label="TTS/101/0/100F",
        description="""TTS/101/0/100F""",
    )

    tts_101_0_101 = VocabularyTerm(
        code="TTS_101_0_101",
        label="TTS/101/0/101",
        description="""TTS/101/0/101""",
    )

    tts_101_0_102 = VocabularyTerm(
        code="TTS_101_0_102",
        label="TTS/101/0/102",
        description="""TTS/101/0/102""",
    )

    tts_101_0_102f = VocabularyTerm(
        code="TTS_101_0_102F",
        label="TTS/101/0/102F",
        description="""TTS/101/0/102F""",
    )

    tts_101_0_103 = VocabularyTerm(
        code="TTS_101_0_103",
        label="TTS/101/0/103",
        description="""TTS/101/0/103""",
    )

    tts_101_0_104 = VocabularyTerm(
        code="TTS_101_0_104",
        label="TTS/101/0/104",
        description="""TTS/101/0/104""",
    )

    tts_101_0_108 = VocabularyTerm(
        code="TTS_101_0_108",
        label="TTS/101/0/108",
        description="""TTS/101/0/108""",
    )

    tts_101_0_110 = VocabularyTerm(
        code="TTS_101_0_110",
        label="TTS/101/0/110",
        description="""TTS/101/0/110""",
    )

    tts_101_0_111h = VocabularyTerm(
        code="TTS_101_0_111H",
        label="TTS/101/0/111H",
        description="""TTS/101/0/111H""",
    )

    tts_101_0_112f = VocabularyTerm(
        code="TTS_101_0_112F",
        label="TTS/101/0/112F",
        description="""TTS/101/0/112F""",
    )

    tts_101_0_113f = VocabularyTerm(
        code="TTS_101_0_113F",
        label="TTS/101/0/113F",
        description="""TTS/101/0/113F""",
    )

    tts_101_0_113t = VocabularyTerm(
        code="TTS_101_0_113T",
        label="TTS/101/0/113T",
        description="""TTS/101/0/113T""",
    )

    tts_101_0_114 = VocabularyTerm(
        code="TTS_101_0_114",
        label="TTS/101/0/114",
        description="""TTS/101/0/114""",
    )

    tts_101_0_115 = VocabularyTerm(
        code="TTS_101_0_115",
        label="TTS/101/0/115",
        description="""TTS/101/0/115""",
    )

    tts_101_0_116 = VocabularyTerm(
        code="TTS_101_0_116",
        label="TTS/101/0/116",
        description="""TTS/101/0/116""",
    )

    tts_101_0_117 = VocabularyTerm(
        code="TTS_101_0_117",
        label="TTS/101/0/117",
        description="""TTS/101/0/117""",
    )

    tts_101_1_200 = VocabularyTerm(
        code="TTS_101_1_200",
        label="TTS/101/1/200",
        description="""TTS/101/1/200""",
    )

    tts_101_1_201 = VocabularyTerm(
        code="TTS_101_1_201",
        label="TTS/101/1/201",
        description="""TTS/101/1/201""",
    )

    tts_101_1_202 = VocabularyTerm(
        code="TTS_101_1_202",
        label="TTS/101/1/202",
        description="""TTS/101/1/202""",
    )

    tts_101_1_203 = VocabularyTerm(
        code="TTS_101_1_203",
        label="TTS/101/1/203",
        description="""TTS/101/1/203""",
    )

    tts_101_1_204 = VocabularyTerm(
        code="TTS_101_1_204",
        label="TTS/101/1/204",
        description="""TTS/101/1/204""",
    )

    tts_101_1_204f = VocabularyTerm(
        code="TTS_101_1_204F",
        label="TTS/101/1/204F",
        description="""TTS/101/1/204F""",
    )

    tts_101_1_205 = VocabularyTerm(
        code="TTS_101_1_205",
        label="TTS/101/1/205",
        description="""TTS/101/1/205""",
    )

    tts_101_1_206 = VocabularyTerm(
        code="TTS_101_1_206",
        label="TTS/101/1/206",
        description="""TTS/101/1/206""",
    )

    tts_101_1_208 = VocabularyTerm(
        code="TTS_101_1_208",
        label="TTS/101/1/208",
        description="""TTS/101/1/208""",
    )

    tts_101_1_209 = VocabularyTerm(
        code="TTS_101_1_209",
        label="TTS/101/1/209",
        description="""TTS/101/1/209""",
    )

    tts_101_1_210 = VocabularyTerm(
        code="TTS_101_1_210",
        label="TTS/101/1/210",
        description="""TTS/101/1/210""",
    )

    tts_101_1_211h = VocabularyTerm(
        code="TTS_101_1_211H",
        label="TTS/101/1/211H",
        description="""TTS/101/1/211H""",
    )

    tts_101_1_213t = VocabularyTerm(
        code="TTS_101_1_213T",
        label="TTS/101/1/213T",
        description="""TTS/101/1/213T""",
    )

    tts_101_1_214 = VocabularyTerm(
        code="TTS_101_1_214",
        label="TTS/101/1/214",
        description="""TTS/101/1/214""",
    )

    tts_101_1_215 = VocabularyTerm(
        code="TTS_101_1_215",
        label="TTS/101/1/215",
        description="""TTS/101/1/215""",
    )

    tts_101_1_216 = VocabularyTerm(
        code="TTS_101_1_216",
        label="TTS/101/1/216",
        description="""TTS/101/1/216""",
    )

    tts_103_0_100 = VocabularyTerm(
        code="TTS_103_0_100",
        label="TTS/103/0/100",
        description="""TTS/103/0/100""",
    )

    tts_103_0_101 = VocabularyTerm(
        code="TTS_103_0_101",
        label="TTS/103/0/101",
        description="""TTS/103/0/101""",
    )

    tts_103_0_102 = VocabularyTerm(
        code="TTS_103_0_102",
        label="TTS/103/0/102",
        description="""TTS/103/0/102""",
    )

    tts_104_0_100 = VocabularyTerm(
        code="TTS_104_0_100",
        label="TTS/104/0/100",
        description="""TTS/104/0/100""",
    )

    tts_105_0_100 = VocabularyTerm(
        code="TTS_105_0_100",
        label="TTS/105/0/100",
        description="""TTS/105/0/100""",
    )

    tts_106_0_100 = VocabularyTerm(
        code="TTS_106_0_100",
        label="TTS/106/0/100",
        description="""TTS/106/0/100""",
    )

    tts_107_0_100 = VocabularyTerm(
        code="TTS_107_0_100",
        label="TTS/107/0/100",
        description="""TTS/107/0/100""",
    )

    tts_108_0_100 = VocabularyTerm(
        code="TTS_108_0_100",
        label="TTS/108/0/100",
        description="""TTS/108/0/100""",
    )

    tts_109_0_100 = VocabularyTerm(
        code="TTS_109_0_100",
        label="TTS/109/0/100",
        description="""TTS/109/0/100""",
    )

    tts_110_0_100 = VocabularyTerm(
        code="TTS_110_0_100",
        label="TTS/110/0/100",
        description="""TTS/110/0/100""",
    )

    tts_111_0_100 = VocabularyTerm(
        code="TTS_111_0_100",
        label="TTS/111/0/100",
        description="""TTS/111/0/100""",
    )

    tts_112_0_100 = VocabularyTerm(
        code="TTS_112_0_100",
        label="TTS/112/0/100",
        description="""TTS/112/0/100""",
    )

    tts_201_0_100 = VocabularyTerm(
        code="TTS_201_0_100",
        label="TTS/201/0/100",
        description="""TTS/201/0/100""",
    )

    tts_201_0_100b = VocabularyTerm(
        code="TTS_201_0_100B",
        label="TTS/201/0/100B",
        description="""TTS/201/0/100B""",
    )

    tts_201_0_100f = VocabularyTerm(
        code="TTS_201_0_100F",
        label="TTS/201/0/100F",
        description="""TTS/201/0/100F""",
    )

    tts_201_0_100wc = VocabularyTerm(
        code="TTS_201_0_100WC",
        label="TTS/201/0/100WC",
        description="""TTS/201/0/100WC""",
    )

    tts_201_0_101 = VocabularyTerm(
        code="TTS_201_0_101",
        label="TTS/201/0/101",
        description="""TTS/201/0/101""",
    )

    tts_201_0_103 = VocabularyTerm(
        code="TTS_201_0_103",
        label="TTS/201/0/103",
        description="""TTS/201/0/103""",
    )

    tts_201_0_103t = VocabularyTerm(
        code="TTS_201_0_103T",
        label="TTS/201/0/103T",
        description="""TTS/201/0/103T""",
    )

    tts_201_0_104 = VocabularyTerm(
        code="TTS_201_0_104",
        label="TTS/201/0/104",
        description="""TTS/201/0/104""",
    )

    tts_201_0_105d = VocabularyTerm(
        code="TTS_201_0_105D",
        label="TTS/201/0/105D",
        description="""TTS/201/0/105D""",
    )

    tts_201_0_106 = VocabularyTerm(
        code="TTS_201_0_106",
        label="TTS/201/0/106",
        description="""TTS/201/0/106""",
    )

    tts_201_0_107h = VocabularyTerm(
        code="TTS_201_0_107H",
        label="TTS/201/0/107H",
        description="""TTS/201/0/107H""",
    )

    tts_201_0_108 = VocabularyTerm(
        code="TTS_201_0_108",
        label="TTS/201/0/108",
        description="""TTS/201/0/108""",
    )

    tts_201_0_111 = VocabularyTerm(
        code="TTS_201_0_111",
        label="TTS/201/0/111",
        description="""TTS/201/0/111""",
    )

    tts_201_0_111f = VocabularyTerm(
        code="TTS_201_0_111F",
        label="TTS/201/0/111F",
        description="""TTS/201/0/111F""",
    )

    tts_201_0_111t = VocabularyTerm(
        code="TTS_201_0_111T",
        label="TTS/201/0/111T",
        description="""TTS/201/0/111T""",
    )

    tts_201_0_112 = VocabularyTerm(
        code="TTS_201_0_112",
        label="TTS/201/0/112",
        description="""TTS/201/0/112""",
    )

    tts_201_0_112h = VocabularyTerm(
        code="TTS_201_0_112H",
        label="TTS/201/0/112H",
        description="""TTS/201/0/112H""",
    )

    tts_201_0_113 = VocabularyTerm(
        code="TTS_201_0_113",
        label="TTS/201/0/113",
        description="""TTS/201/0/113""",
    )

    tts_201_1_200 = VocabularyTerm(
        code="TTS_201_1_200",
        label="TTS/201/1/200",
        description="""TTS/201/1/200""",
    )

    tts_201_1_201 = VocabularyTerm(
        code="TTS_201_1_201",
        label="TTS/201/1/201",
        description="""TTS/201/1/201""",
    )

    tts_201_1_203t = VocabularyTerm(
        code="TTS_201_1_203T",
        label="TTS/201/1/203T",
        description="""TTS/201/1/203T""",
    )

    tts_201_1_205 = VocabularyTerm(
        code="TTS_201_1_205",
        label="TTS/201/1/205",
        description="""TTS/201/1/205""",
    )

    tts_201_1_206 = VocabularyTerm(
        code="TTS_201_1_206",
        label="TTS/201/1/206",
        description="""TTS/201/1/206""",
    )

    tts_201_1_207 = VocabularyTerm(
        code="TTS_201_1_207",
        label="TTS/201/1/207",
        description="""TTS/201/1/207""",
    )

    tts_201_1_208 = VocabularyTerm(
        code="TTS_201_1_208",
        label="TTS/201/1/208",
        description="""TTS/201/1/208""",
    )

    tts_201_1_210 = VocabularyTerm(
        code="TTS_201_1_210",
        label="TTS/201/1/210",
        description="""TTS/201/1/210""",
    )

    tts_201_1_211f = VocabularyTerm(
        code="TTS_201_1_211F",
        label="TTS/201/1/211F",
        description="""TTS/201/1/211F""",
    )

    tts_201_1_211t = VocabularyTerm(
        code="TTS_201_1_211T",
        label="TTS/201/1/211T",
        description="""TTS/201/1/211T""",
    )

    tts_201_1_212 = VocabularyTerm(
        code="TTS_201_1_212",
        label="TTS/201/1/212",
        description="""TTS/201/1/212""",
    )

    tts_201_1_213 = VocabularyTerm(
        code="TTS_201_1_213",
        label="TTS/201/1/213",
        description="""TTS/201/1/213""",
    )

    tts_202_0_23 = VocabularyTerm(
        code="TTS_202_0_23",
        label="TTS/202/0/23",
        description="""TTS/202/0/23""",
    )

    tts_202_0_32 = VocabularyTerm(
        code="TTS_202_0_32",
        label="TTS/202/0/32",
        description="""TTS/202/0/32""",
    )

    tts_202_0_52 = VocabularyTerm(
        code="TTS_202_0_52",
        label="TTS/202/0/52",
        description="""TTS/202/0/52""",
    )

    tts_202_0_101 = VocabularyTerm(
        code="TTS_202_0_101",
        label="TTS/202/0/101",
        description="""TTS/202/0/101""",
    )

    tts_203_0_101 = VocabularyTerm(
        code="TTS_203_0_101",
        label="TTS/203/0/101",
        description="""TTS/203/0/101""",
    )

    tts_204_0_100 = VocabularyTerm(
        code="TTS_204_0_100",
        label="TTS/204/0/100",
        description="""TTS/204/0/100""",
    )

    tts_204_0_102 = VocabularyTerm(
        code="TTS_204_0_102",
        label="TTS/204/0/102",
        description="""TTS/204/0/102""",
    )

    tts_205_0_100 = VocabularyTerm(
        code="TTS_205_0_100",
        label="TTS/205/0/100",
        description="""TTS/205/0/100""",
    )

    tts_206_0_100 = VocabularyTerm(
        code="TTS_206_0_100",
        label="TTS/206/0/100",
        description="""TTS/206/0/100""",
    )

    tts_206_0_100b = VocabularyTerm(
        code="TTS_206_0_100B",
        label="TTS/206/0/100B",
        description="""TTS/206/0/100B""",
    )

    tts_206_0_100f = VocabularyTerm(
        code="TTS_206_0_100F",
        label="TTS/206/0/100F",
        description="""TTS/206/0/100F""",
    )

    tts_206_0_101 = VocabularyTerm(
        code="TTS_206_0_101",
        label="TTS/206/0/101",
        description="""TTS/206/0/101""",
    )

    tts_206_0_101b = VocabularyTerm(
        code="TTS_206_0_101B",
        label="TTS/206/0/101B",
        description="""TTS/206/0/101B""",
    )

    tts_206_0_102 = VocabularyTerm(
        code="TTS_206_0_102",
        label="TTS/206/0/102",
        description="""TTS/206/0/102""",
    )

    tts_206_0_108 = VocabularyTerm(
        code="TTS_206_0_108",
        label="TTS/206/0/108",
        description="""TTS/206/0/108""",
    )

    tts_207_0_100 = VocabularyTerm(
        code="TTS_207_0_100",
        label="TTS/207/0/100",
        description="""TTS/207/0/100""",
    )

    tts_208_0_100 = VocabularyTerm(
        code="TTS_208_0_100",
        label="TTS/208/0/100",
        description="""TTS/208/0/100""",
    )

    tts_209_0_100 = VocabularyTerm(
        code="TTS_209_0_100",
        label="TTS/209/0/100",
        description="""TTS/209/0/100""",
    )

    tts_301_0_100 = VocabularyTerm(
        code="TTS_301_0_100",
        label="TTS/301/0/100",
        description="""TTS/301/0/100""",
    )

    tts_301_0_100f = VocabularyTerm(
        code="TTS_301_0_100F",
        label="TTS/301/0/100F",
        description="""TTS/301/0/100F""",
    )

    tts_301_0_101 = VocabularyTerm(
        code="TTS_301_0_101",
        label="TTS/301/0/101",
        description="""TTS/301/0/101""",
    )

    tts_301_0_102 = VocabularyTerm(
        code="TTS_301_0_102",
        label="TTS/301/0/102",
        description="""TTS/301/0/102""",
    )

    tts_302_0_100 = VocabularyTerm(
        code="TTS_302_0_100",
        label="TTS/302/0/100",
        description="""TTS/302/0/100""",
    )

    tts_302_0_100f = VocabularyTerm(
        code="TTS_302_0_100F",
        label="TTS/302/0/100F",
        description="""TTS/302/0/100F""",
    )

    tts_302_0_101 = VocabularyTerm(
        code="TTS_302_0_101",
        label="TTS/302/0/101",
        description="""TTS/302/0/101""",
    )

    tts_303_0_100 = VocabularyTerm(
        code="TTS_303_0_100",
        label="TTS/303/0/100",
        description="""TTS/303/0/100""",
    )

    tts_303_0_100f = VocabularyTerm(
        code="TTS_303_0_100F",
        label="TTS/303/0/100F",
        description="""TTS/303/0/100F""",
    )

    tts_303_0_101 = VocabularyTerm(
        code="TTS_303_0_101",
        label="TTS/303/0/101",
        description="""TTS/303/0/101""",
    )

    tts_304_0_100 = VocabularyTerm(
        code="TTS_304_0_100",
        label="TTS/304/0/100",
        description="""TTS/304/0/100""",
    )

    tts_304_0_100b = VocabularyTerm(
        code="TTS_304_0_100B",
        label="TTS/304/0/100B",
        description="""TTS/304/0/100B""",
    )

    tts_304_0_100f = VocabularyTerm(
        code="TTS_304_0_100F",
        label="TTS/304/0/100F",
        description="""TTS/304/0/100F""",
    )

    tts_304_0_101 = VocabularyTerm(
        code="TTS_304_0_101",
        label="TTS/304/0/101",
        description="""TTS/304/0/101""",
    )

    tts_304_0_102 = VocabularyTerm(
        code="TTS_304_0_102",
        label="TTS/304/0/102",
        description="""TTS/304/0/102""",
    )

    tts_305_0_100 = VocabularyTerm(
        code="TTS_305_0_100",
        label="TTS/305/0/100",
        description="""TTS/305/0/100""",
    )

    tts_305_0_100b = VocabularyTerm(
        code="TTS_305_0_100B",
        label="TTS/305/0/100B",
        description="""TTS/305/0/100B""",
    )

    tts_305_0_100f = VocabularyTerm(
        code="TTS_305_0_100F",
        label="TTS/305/0/100F",
        description="""TTS/305/0/100F""",
    )

    tts_305_0_101 = VocabularyTerm(
        code="TTS_305_0_101",
        label="TTS/305/0/101",
        description="""TTS/305/0/101""",
    )

    tts_305_0_102 = VocabularyTerm(
        code="TTS_305_0_102",
        label="TTS/305/0/102",
        description="""TTS/305/0/102""",
    )

    tts_306_0_101 = VocabularyTerm(
        code="TTS_306_0_101",
        label="TTS/306/0/101",
        description="""TTS/306/0/101""",
    )

    tts_306_0_101b = VocabularyTerm(
        code="TTS_306_0_101B",
        label="TTS/306/0/101B",
        description="""TTS/306/0/101B""",
    )

    tts_306_0_102 = VocabularyTerm(
        code="TTS_306_0_102",
        label="TTS/306/0/102",
        description="""TTS/306/0/102""",
    )

    tts_306_0_102b = VocabularyTerm(
        code="TTS_306_0_102B",
        label="TTS/306/0/102B",
        description="""TTS/306/0/102B""",
    )

    tts_306_0_103 = VocabularyTerm(
        code="TTS_306_0_103",
        label="TTS/306/0/103",
        description="""TTS/306/0/103""",
    )

    tts_306_0_104d = VocabularyTerm(
        code="TTS_306_0_104D",
        label="TTS/306/0/104D",
        description="""TTS/306/0/104D""",
    )

    tts_306_0_104f = VocabularyTerm(
        code="TTS_306_0_104F",
        label="TTS/306/0/104F",
        description="""TTS/306/0/104F""",
    )

    tts_306_0_104h = VocabularyTerm(
        code="TTS_306_0_104H",
        label="TTS/306/0/104H",
        description="""TTS/306/0/104H""",
    )

    tts_306_0_105 = VocabularyTerm(
        code="TTS_306_0_105",
        label="TTS/306/0/105",
        description="""TTS/306/0/105""",
    )

    tts_306_0_107 = VocabularyTerm(
        code="TTS_306_0_107",
        label="TTS/306/0/107",
        description="""TTS/306/0/107""",
    )

    tts_306_0_109 = VocabularyTerm(
        code="TTS_306_0_109",
        label="TTS/306/0/109",
        description="""TTS/306/0/109""",
    )

    tts_306_0_110 = VocabularyTerm(
        code="TTS_306_0_110",
        label="TTS/306/0/110",
        description="""TTS/306/0/110""",
    )

    tts_306_0_112 = VocabularyTerm(
        code="TTS_306_0_112",
        label="TTS/306/0/112",
        description="""TTS/306/0/112""",
    )

    tts_306_0_114 = VocabularyTerm(
        code="TTS_306_0_114",
        label="TTS/306/0/114",
        description="""TTS/306/0/114""",
    )

    tts_306_0_115 = VocabularyTerm(
        code="TTS_306_0_115",
        label="TTS/306/0/115",
        description="""TTS/306/0/115""",
    )

    tts_306_0_116 = VocabularyTerm(
        code="TTS_306_0_116",
        label="TTS/306/0/116",
        description="""TTS/306/0/116""",
    )

    tts_306_0_116b = VocabularyTerm(
        code="TTS_306_0_116B",
        label="TTS/306/0/116B",
        description="""TTS/306/0/116B""",
    )

    tts_307_0_100 = VocabularyTerm(
        code="TTS_307_0_100",
        label="TTS/307/0/100",
        description="""TTS/307/0/100""",
    )

    tts_308_0_100 = VocabularyTerm(
        code="TTS_308_0_100",
        label="TTS/308/0/100",
        description="""TTS/308/0/100""",
    )

    tts_308_0_100f = VocabularyTerm(
        code="TTS_308_0_100F",
        label="TTS/308/0/100F",
        description="""TTS/308/0/100F""",
    )

    tts_308_1_201 = VocabularyTerm(
        code="TTS_308_1_201",
        label="TTS/308/1/201",
        description="""TTS/308/1/201""",
    )

    tts_308_2_301 = VocabularyTerm(
        code="TTS_308_2_301",
        label="TTS/308/2/301",
        description="""TTS/308/2/301""",
    )

    tts_309_0_101 = VocabularyTerm(
        code="TTS_309_0_101",
        label="TTS/309/0/101",
        description="""TTS/309/0/101""",
    )

    tts_310_0_101 = VocabularyTerm(
        code="TTS_310_0_101",
        label="TTS/310/0/101",
        description="""TTS/310/0/101""",
    )

    tts_310_0_102 = VocabularyTerm(
        code="TTS_310_0_102",
        label="TTS/310/0/102",
        description="""TTS/310/0/102""",
    )

    tts_310_0_103 = VocabularyTerm(
        code="TTS_310_0_103",
        label="TTS/310/0/103",
        description="""TTS/310/0/103""",
    )

    tts_311_0_100 = VocabularyTerm(
        code="TTS_311_0_100",
        label="TTS/311/0/100",
        description="""TTS/311/0/100""",
    )

    tts_312_0_100 = VocabularyTerm(
        code="TTS_312_0_100",
        label="TTS/312/0/100",
        description="""TTS/312/0/100""",
    )

    tts_312_0_100f = VocabularyTerm(
        code="TTS_312_0_100F",
        label="TTS/312/0/100F",
        description="""TTS/312/0/100F""",
    )

    tts_312_0_102 = VocabularyTerm(
        code="TTS_312_0_102",
        label="TTS/312/0/102",
        description="""TTS/312/0/102""",
    )

    tts_312_0_104 = VocabularyTerm(
        code="TTS_312_0_104",
        label="TTS/312/0/104",
        description="""TTS/312/0/104""",
    )

    tts_313_0_100 = VocabularyTerm(
        code="TTS_313_0_100",
        label="TTS/313/0/100",
        description="""TTS/313/0/100""",
    )

    tts_314_0_100 = VocabularyTerm(
        code="TTS_314_0_100",
        label="TTS/314/0/100",
        description="""TTS/314/0/100""",
    )

    tts_315_0_100 = VocabularyTerm(
        code="TTS_315_0_100",
        label="TTS/315/0/100",
        description="""TTS/315/0/100""",
    )

    tts_316_0_100 = VocabularyTerm(
        code="TTS_316_0_100",
        label="TTS/316/0/100",
        description="""TTS/316/0/100""",
    )

    tts_317_0_100 = VocabularyTerm(
        code="TTS_317_0_100",
        label="TTS/317/0/100",
        description="""TTS/317/0/100""",
    )

    tts_318_0_100 = VocabularyTerm(
        code="TTS_318_0_100",
        label="TTS/318/0/100",
        description="""TTS/318/0/100""",
    )

    tts_318_0_101 = VocabularyTerm(
        code="TTS_318_0_101",
        label="TTS/318/0/101",
        description="""TTS/318/0/101""",
    )

    tts_318_0_102 = VocabularyTerm(
        code="TTS_318_0_102",
        label="TTS/318/0/102",
        description="""TTS/318/0/102""",
    )

    tts_319_0_100 = VocabularyTerm(
        code="TTS_319_0_100",
        label="TTS/319/0/100",
        description="""TTS/319/0/100""",
    )

    tts_319_0_101 = VocabularyTerm(
        code="TTS_319_0_101",
        label="TTS/319/0/101",
        description="""TTS/319/0/101""",
    )

    tts_319_0_101b = VocabularyTerm(
        code="TTS_319_0_101B",
        label="TTS/319/0/101B",
        description="""TTS/319/0/101B""",
    )

    tts_319_0_103 = VocabularyTerm(
        code="TTS_319_0_103",
        label="TTS/319/0/103",
        description="""TTS/319/0/103""",
    )

    tts_319_0_104 = VocabularyTerm(
        code="TTS_319_0_104",
        label="TTS/319/0/104",
        description="""TTS/319/0/104""",
    )

    tts_319_0_104f = VocabularyTerm(
        code="TTS_319_0_104F",
        label="TTS/319/0/104F",
        description="""TTS/319/0/104F""",
    )

    tts_319_0_105 = VocabularyTerm(
        code="TTS_319_0_105",
        label="TTS/319/0/105",
        description="""TTS/319/0/105""",
    )

    tts_319_0_106 = VocabularyTerm(
        code="TTS_319_0_106",
        label="TTS/319/0/106",
        description="""TTS/319/0/106""",
    )

    tts_319_0_107 = VocabularyTerm(
        code="TTS_319_0_107",
        label="TTS/319/0/107",
        description="""TTS/319/0/107""",
    )

    tts_319_0_109 = VocabularyTerm(
        code="TTS_319_0_109",
        label="TTS/319/0/109",
        description="""TTS/319/0/109""",
    )

    tts_319_0_111 = VocabularyTerm(
        code="TTS_319_0_111",
        label="TTS/319/0/111",
        description="""TTS/319/0/111""",
    )

    tts_319_0_113 = VocabularyTerm(
        code="TTS_319_0_113",
        label="TTS/319/0/113",
        description="""TTS/319/0/113""",
    )

    tts_319_0_115 = VocabularyTerm(
        code="TTS_319_0_115",
        label="TTS/319/0/115",
        description="""TTS/319/0/115""",
    )

    tts_319_0_115f = VocabularyTerm(
        code="TTS_319_0_115F",
        label="TTS/319/0/115F",
        description="""TTS/319/0/115F""",
    )

    tts_319_0_117h = VocabularyTerm(
        code="TTS_319_0_117H",
        label="TTS/319/0/117H",
        description="""TTS/319/0/117H""",
    )

    tts_319_0_119d = VocabularyTerm(
        code="TTS_319_0_119D",
        label="TTS/319/0/119D",
        description="""TTS/319/0/119D""",
    )

    tts_320_0_100 = VocabularyTerm(
        code="TTS_320_0_100",
        label="TTS/320/0/100",
        description="""TTS/320/0/100""",
    )

    tts_401_0_100 = VocabularyTerm(
        code="TTS_401_0_100",
        label="TTS/401/0/100",
        description="""TTS/401/0/100""",
    )

    tts_402_0_100 = VocabularyTerm(
        code="TTS_402_0_100",
        label="TTS/402/0/100",
        description="""TTS/402/0/100""",
    )

    tts_402_0_101 = VocabularyTerm(
        code="TTS_402_0_101",
        label="TTS/402/0/101",
        description="""TTS/402/0/101""",
    )

    tts_402_0_102 = VocabularyTerm(
        code="TTS_402_0_102",
        label="TTS/402/0/102",
        description="""TTS/402/0/102""",
    )

    tts_402_0_103 = VocabularyTerm(
        code="TTS_402_0_103",
        label="TTS/402/0/103",
        description="""TTS/402/0/103""",
    )

    tts_402_0_103f = VocabularyTerm(
        code="TTS_402_0_103F",
        label="TTS/402/0/103F",
        description="""TTS/402/0/103F""",
    )

    tts_402_0_104 = VocabularyTerm(
        code="TTS_402_0_104",
        label="TTS/402/0/104",
        description="""TTS/402/0/104""",
    )

    tts_411_0_100 = VocabularyTerm(
        code="TTS_411_0_100",
        label="TTS/411/0/100",
        description="""TTS/411/0/100""",
    )

    tts_412_0_100 = VocabularyTerm(
        code="TTS_412_0_100",
        label="TTS/412/0/100",
        description="""TTS/412/0/100""",
    )

    tts_412_0_100f = VocabularyTerm(
        code="TTS_412_0_100F",
        label="TTS/412/0/100F",
        description="""TTS/412/0/100F""",
    )

    tts_412_0_101 = VocabularyTerm(
        code="TTS_412_0_101",
        label="TTS/412/0/101",
        description="""TTS/412/0/101""",
    )

    tts_412_0_101f = VocabularyTerm(
        code="TTS_412_0_101F",
        label="TTS/412/0/101F",
        description="""TTS/412/0/101F""",
    )

    tts_412_0_102 = VocabularyTerm(
        code="TTS_412_0_102",
        label="TTS/412/0/102",
        description="""TTS/412/0/102""",
    )

    tts_412_0_103 = VocabularyTerm(
        code="TTS_412_0_103",
        label="TTS/412/0/103",
        description="""TTS/412/0/103""",
    )

    tts_412_0_104 = VocabularyTerm(
        code="TTS_412_0_104",
        label="TTS/412/0/104",
        description="""TTS/412/0/104""",
    )

    tts_412_0_105 = VocabularyTerm(
        code="TTS_412_0_105",
        label="TTS/412/0/105",
        description="""TTS/412/0/105""",
    )

    tts_412_0_106h = VocabularyTerm(
        code="TTS_412_0_106H",
        label="TTS/412/0/106H",
        description="""TTS/412/0/106H""",
    )

    tts_412_0_108d = VocabularyTerm(
        code="TTS_412_0_108D",
        label="TTS/412/0/108D",
        description="""TTS/412/0/108D""",
    )

    tts_412_0_109 = VocabularyTerm(
        code="TTS_412_0_109",
        label="TTS/412/0/109",
        description="""TTS/412/0/109""",
    )

    tts_412_0_110 = VocabularyTerm(
        code="TTS_412_0_110",
        label="TTS/412/0/110",
        description="""TTS/412/0/110""",
    )

    tts_412_0_113 = VocabularyTerm(
        code="TTS_412_0_113",
        label="TTS/412/0/113",
        description="""TTS/412/0/113""",
    )

    tts_412_0_114 = VocabularyTerm(
        code="TTS_412_0_114",
        label="TTS/412/0/114",
        description="""TTS/412/0/114""",
    )

    tts_412_0_117 = VocabularyTerm(
        code="TTS_412_0_117",
        label="TTS/412/0/117",
        description="""TTS/412/0/117""",
    )

    tts_412_0_118 = VocabularyTerm(
        code="TTS_412_0_118",
        label="TTS/412/0/118",
        description="""TTS/412/0/118""",
    )

    tts_413_0_100 = VocabularyTerm(
        code="TTS_413_0_100",
        label="TTS/413/0/100",
        description="""TTS/413/0/100""",
    )

    tts_413_0_101 = VocabularyTerm(
        code="TTS_413_0_101",
        label="TTS/413/0/101",
        description="""TTS/413/0/101""",
    )

    tts_413_0_102 = VocabularyTerm(
        code="TTS_413_0_102",
        label="TTS/413/0/102",
        description="""TTS/413/0/102""",
    )

    tts_414_0_100 = VocabularyTerm(
        code="TTS_414_0_100",
        label="TTS/414/0/100",
        description="""TTS/414/0/100""",
    )

    tts_414_0_102 = VocabularyTerm(
        code="TTS_414_0_102",
        label="TTS/414/0/102",
        description="""TTS/414/0/102""",
    )

    tts_414_0_103 = VocabularyTerm(
        code="TTS_414_0_103",
        label="TTS/414/0/103",
        description="""TTS/414/0/103""",
    )

    tts_414_0_104 = VocabularyTerm(
        code="TTS_414_0_104",
        label="TTS/414/0/104",
        description="""TTS/414/0/104""",
    )

    tts_414_0_106 = VocabularyTerm(
        code="TTS_414_0_106",
        label="TTS/414/0/106",
        description="""TTS/414/0/106""",
    )

    tts_414_0_107 = VocabularyTerm(
        code="TTS_414_0_107",
        label="TTS/414/0/107",
        description="""TTS/414/0/107""",
    )

    tts_414_0_108 = VocabularyTerm(
        code="TTS_414_0_108",
        label="TTS/414/0/108",
        description="""TTS/414/0/108""",
    )

    tts_414_0_109 = VocabularyTerm(
        code="TTS_414_0_109",
        label="TTS/414/0/109",
        description="""TTS/414/0/109""",
    )

    tts_421_0_100 = VocabularyTerm(
        code="TTS_421_0_100",
        label="TTS/421/0/100",
        description="""TTS/421/0/100""",
    )

    tts_422_0_100 = VocabularyTerm(
        code="TTS_422_0_100",
        label="TTS/422/0/100",
        description="""TTS/422/0/100""",
    )

    tts_423_0_100 = VocabularyTerm(
        code="TTS_423_0_100",
        label="TTS/423/0/100",
        description="""TTS/423/0/100""",
    )

    tts_424_0_100 = VocabularyTerm(
        code="TTS_424_0_100",
        label="TTS/424/0/100",
        description="""TTS/424/0/100""",
    )

    tts_425_0_100 = VocabularyTerm(
        code="TTS_425_0_100",
        label="TTS/425/0/100",
        description="""TTS/425/0/100""",
    )

    tts_426_0_100 = VocabularyTerm(
        code="TTS_426_0_100",
        label="TTS/426/0/100",
        description="""TTS/426/0/100""",
    )

    tts_427_0_100 = VocabularyTerm(
        code="TTS_427_0_100",
        label="TTS/427/0/100",
        description="""TTS/427/0/100""",
    )

    tts_431_0_100 = VocabularyTerm(
        code="TTS_431_0_100",
        label="TTS/431/0/100",
        description="""TTS/431/0/100""",
    )

    tts_432_0_100 = VocabularyTerm(
        code="TTS_432_0_100",
        label="TTS/432/0/100",
        description="""TTS/432/0/100""",
    )

    tts_433_0_100f = VocabularyTerm(
        code="TTS_433_0_100F",
        label="TTS/433/0/100F",
        description="""TTS/433/0/100F""",
    )

    tts_433_0_101 = VocabularyTerm(
        code="TTS_433_0_101",
        label="TTS/433/0/101",
        description="""TTS/433/0/101""",
    )

    tts_433_0_102 = VocabularyTerm(
        code="TTS_433_0_102",
        label="TTS/433/0/102",
        description="""TTS/433/0/102""",
    )

    tts_433_0_105d = VocabularyTerm(
        code="TTS_433_0_105D",
        label="TTS/433/0/105D",
        description="""TTS/433/0/105D""",
    )

    tts_433_0_106 = VocabularyTerm(
        code="TTS_433_0_106",
        label="TTS/433/0/106",
        description="""TTS/433/0/106""",
    )

    tts_433_0_107h = VocabularyTerm(
        code="TTS_433_0_107H",
        label="TTS/433/0/107H",
        description="""TTS/433/0/107H""",
    )

    tts_433_0_110 = VocabularyTerm(
        code="TTS_433_0_110",
        label="TTS/433/0/110",
        description="""TTS/433/0/110""",
    )

    tts_433_0_112 = VocabularyTerm(
        code="TTS_433_0_112",
        label="TTS/433/0/112",
        description="""TTS/433/0/112""",
    )

    tts_434_0_001 = VocabularyTerm(
        code="TTS_434_0_001",
        label="TTS/434/0/001",
        description="""TTS/434/0/001""",
    )

    tts_434_0_002 = VocabularyTerm(
        code="TTS_434_0_002",
        label="TTS/434/0/002",
        description="""TTS/434/0/002""",
    )

    tts_434_0_003 = VocabularyTerm(
        code="TTS_434_0_003",
        label="TTS/434/0/003",
        description="""TTS/434/0/003""",
    )

    tts_434_0_004 = VocabularyTerm(
        code="TTS_434_0_004",
        label="TTS/434/0/004",
        description="""TTS/434/0/004""",
    )

    tts_434_0_006 = VocabularyTerm(
        code="TTS_434_0_006",
        label="TTS/434/0/006",
        description="""TTS/434/0/006""",
    )

    tts_434_0_101 = VocabularyTerm(
        code="TTS_434_0_101",
        label="TTS/434/0/101",
        description="""TTS/434/0/101""",
    )

    tts_434_0_101f = VocabularyTerm(
        code="TTS_434_0_101F",
        label="TTS/434/0/101F",
        description="""TTS/434/0/101F""",
    )

    tts_434_0_102 = VocabularyTerm(
        code="TTS_434_0_102",
        label="TTS/434/0/102",
        description="""TTS/434/0/102""",
    )

    tts_434_0_103f = VocabularyTerm(
        code="TTS_434_0_103F",
        label="TTS/434/0/103F",
        description="""TTS/434/0/103F""",
    )

    tts_434_0_105d = VocabularyTerm(
        code="TTS_434_0_105D",
        label="TTS/434/0/105D",
        description="""TTS/434/0/105D""",
    )

    tts_434_0_105h = VocabularyTerm(
        code="TTS_434_0_105H",
        label="TTS/434/0/105H",
        description="""TTS/434/0/105H""",
    )

    tts_434_0_106 = VocabularyTerm(
        code="TTS_434_0_106",
        label="TTS/434/0/106",
        description="""TTS/434/0/106""",
    )

    tts_434_0_107 = VocabularyTerm(
        code="TTS_434_0_107",
        label="TTS/434/0/107",
        description="""TTS/434/0/107""",
    )

    tts_434_0_109 = VocabularyTerm(
        code="TTS_434_0_109",
        label="TTS/434/0/109",
        description="""TTS/434/0/109""",
    )

    tts_434_0_110 = VocabularyTerm(
        code="TTS_434_0_110",
        label="TTS/434/0/110",
        description="""TTS/434/0/110""",
    )

    tts_434_0_110f = VocabularyTerm(
        code="TTS_434_0_110F",
        label="TTS/434/0/110F",
        description="""TTS/434/0/110F""",
    )

    tts_434_0_111 = VocabularyTerm(
        code="TTS_434_0_111",
        label="TTS/434/0/111",
        description="""TTS/434/0/111""",
    )

    tts_434_0_113 = VocabularyTerm(
        code="TTS_434_0_113",
        label="TTS/434/0/113",
        description="""TTS/434/0/113""",
    )

    tts_434_0_114 = VocabularyTerm(
        code="TTS_434_0_114",
        label="TTS/434/0/114",
        description="""TTS/434/0/114""",
    )

    tts_434_0_115 = VocabularyTerm(
        code="TTS_434_0_115",
        label="TTS/434/0/115",
        description="""TTS/434/0/115""",
    )

    tts_434_0_117 = VocabularyTerm(
        code="TTS_434_0_117",
        label="TTS/434/0/117",
        description="""TTS/434/0/117""",
    )

    tts_434_0_118 = VocabularyTerm(
        code="TTS_434_0_118",
        label="TTS/434/0/118",
        description="""TTS/434/0/118""",
    )

    tts_434_0_119 = VocabularyTerm(
        code="TTS_434_0_119",
        label="TTS/434/0/119",
        description="""TTS/434/0/119""",
    )

    tts_434_0_119f = VocabularyTerm(
        code="TTS_434_0_119F",
        label="TTS/434/0/119F",
        description="""TTS/434/0/119F""",
    )

    tts_434_0_121 = VocabularyTerm(
        code="TTS_434_0_121",
        label="TTS/434/0/121",
        description="""TTS/434/0/121""",
    )

    tts_434_0_122 = VocabularyTerm(
        code="TTS_434_0_122",
        label="TTS/434/0/122",
        description="""TTS/434/0/122""",
    )

    tts_434_0_123 = VocabularyTerm(
        code="TTS_434_0_123",
        label="TTS/434/0/123",
        description="""TTS/434/0/123""",
    )

    tts_434_0_124 = VocabularyTerm(
        code="TTS_434_0_124",
        label="TTS/434/0/124",
        description="""TTS/434/0/124""",
    )

    tts_434_0_124b = VocabularyTerm(
        code="TTS_434_0_124B",
        label="TTS/434/0/124B",
        description="""TTS/434/0/124B""",
    )

    tts_434_0_124d = VocabularyTerm(
        code="TTS_434_0_124D",
        label="TTS/434/0/124D",
        description="""TTS/434/0/124D""",
    )

    tts_434_0_125 = VocabularyTerm(
        code="TTS_434_0_125",
        label="TTS/434/0/125",
        description="""TTS/434/0/125""",
    )

    tts_434_0_125b = VocabularyTerm(
        code="TTS_434_0_125B",
        label="TTS/434/0/125B",
        description="""TTS/434/0/125B""",
    )

    tts_434_0_125h = VocabularyTerm(
        code="TTS_434_0_125H",
        label="TTS/434/0/125H",
        description="""TTS/434/0/125H""",
    )

    tts_434_0_126 = VocabularyTerm(
        code="TTS_434_0_126",
        label="TTS/434/0/126",
        description="""TTS/434/0/126""",
    )

    tts_434_0_127 = VocabularyTerm(
        code="TTS_434_0_127",
        label="TTS/434/0/127",
        description="""TTS/434/0/127""",
    )

    tts_441_0_100 = VocabularyTerm(
        code="TTS_441_0_100",
        label="TTS/441/0/100",
        description="""TTS/441/0/100""",
    )

    tts_442_0_100 = VocabularyTerm(
        code="TTS_442_0_100",
        label="TTS/442/0/100",
        description="""TTS/442/0/100""",
    )

    tts_443_0_100 = VocabularyTerm(
        code="TTS_443_0_100",
        label="TTS/443/0/100",
        description="""TTS/443/0/100""",
    )

    tts_443_0_101 = VocabularyTerm(
        code="TTS_443_0_101",
        label="TTS/443/0/101",
        description="""TTS/443/0/101""",
    )

    tts_444_0_100 = VocabularyTerm(
        code="TTS_444_0_100",
        label="TTS/444/0/100",
        description="""TTS/444/0/100""",
    )

    tts_445_0_100 = VocabularyTerm(
        code="TTS_445_0_100",
        label="TTS/445/0/100",
        description="""TTS/445/0/100""",
    )

    tts_445_0_101 = VocabularyTerm(
        code="TTS_445_0_101",
        label="TTS/445/0/101",
        description="""TTS/445/0/101""",
    )

    tts_445_0_102 = VocabularyTerm(
        code="TTS_445_0_102",
        label="TTS/445/0/102",
        description="""TTS/445/0/102""",
    )

    tts_445_0_103 = VocabularyTerm(
        code="TTS_445_0_103",
        label="TTS/445/0/103",
        description="""TTS/445/0/103""",
    )

    tts_445_0_104 = VocabularyTerm(
        code="TTS_445_0_104",
        label="TTS/445/0/104",
        description="""TTS/445/0/104""",
    )

    tts_445_0_104d = VocabularyTerm(
        code="TTS_445_0_104D",
        label="TTS/445/0/104D",
        description="""TTS/445/0/104D""",
    )

    tts_445_0_105 = VocabularyTerm(
        code="TTS_445_0_105",
        label="TTS/445/0/105",
        description="""TTS/445/0/105""",
    )

    tts_445_0_106 = VocabularyTerm(
        code="TTS_445_0_106",
        label="TTS/445/0/106",
        description="""TTS/445/0/106""",
    )

    tts_445_0_108f = VocabularyTerm(
        code="TTS_445_0_108F",
        label="TTS/445/0/108F",
        description="""TTS/445/0/108F""",
    )

    tts_445_0_112h = VocabularyTerm(
        code="TTS_445_0_112H",
        label="TTS/445/0/112H",
        description="""TTS/445/0/112H""",
    )

    tts_445_0_114 = VocabularyTerm(
        code="TTS_445_0_114",
        label="TTS/445/0/114",
        description="""TTS/445/0/114""",
    )

    tts_445_0_116 = VocabularyTerm(
        code="TTS_445_0_116",
        label="TTS/445/0/116",
        description="""TTS/445/0/116""",
    )

    tts_446_0_100 = VocabularyTerm(
        code="TTS_446_0_100",
        label="TTS/446/0/100",
        description="""TTS/446/0/100""",
    )

    tts_447_0_100 = VocabularyTerm(
        code="TTS_447_0_100",
        label="TTS/447/0/100",
        description="""TTS/447/0/100""",
    )

    tts_448_0_100 = VocabularyTerm(
        code="TTS_448_0_100",
        label="TTS/448/0/100",
        description="""TTS/448/0/100""",
    )

    tts_448_0_101 = VocabularyTerm(
        code="TTS_448_0_101",
        label="TTS/448/0/101",
        description="""TTS/448/0/101""",
    )

    tts_449_0_100 = VocabularyTerm(
        code="TTS_449_0_100",
        label="TTS/449/0/100",
        description="""TTS/449/0/100""",
    )

    tts_451_0_100 = VocabularyTerm(
        code="TTS_451_0_100",
        label="TTS/451/0/100",
        description="""TTS/451/0/100""",
    )

    tts_452_0_100 = VocabularyTerm(
        code="TTS_452_0_100",
        label="TTS/452/0/100",
        description="""TTS/452/0/100""",
    )

    tts_501_0_100 = VocabularyTerm(
        code="TTS_501_0_100",
        label="TTS/501/0/100",
        description="""TTS/501/0/100""",
    )

    tts_501_0_101f = VocabularyTerm(
        code="TTS_501_0_101F",
        label="TTS/501/0/101F",
        description="""TTS/501/0/101F""",
    )

    tts_501_0_102 = VocabularyTerm(
        code="TTS_501_0_102",
        label="TTS/501/0/102",
        description="""TTS/501/0/102""",
    )

    tts_501_0_103 = VocabularyTerm(
        code="TTS_501_0_103",
        label="TTS/501/0/103",
        description="""TTS/501/0/103""",
    )

    tts_501_0_104 = VocabularyTerm(
        code="TTS_501_0_104",
        label="TTS/501/0/104",
        description="""TTS/501/0/104""",
    )

    tts_501_0_105 = VocabularyTerm(
        code="TTS_501_0_105",
        label="TTS/501/0/105",
        description="""TTS/501/0/105""",
    )

    tts_501_0_106 = VocabularyTerm(
        code="TTS_501_0_106",
        label="TTS/501/0/106",
        description="""TTS/501/0/106""",
    )

    tts_501_0_107 = VocabularyTerm(
        code="TTS_501_0_107",
        label="TTS/501/0/107",
        description="""TTS/501/0/107""",
    )

    tts_501_0_108 = VocabularyTerm(
        code="TTS_501_0_108",
        label="TTS/501/0/108",
        description="""TTS/501/0/108""",
    )

    tts_501_0_109 = VocabularyTerm(
        code="TTS_501_0_109",
        label="TTS/501/0/109",
        description="""TTS/501/0/109""",
    )

    tts_501_0_109f = VocabularyTerm(
        code="TTS_501_0_109F",
        label="TTS/501/0/109F",
        description="""TTS/501/0/109F""",
    )

    tts_501_0_110 = VocabularyTerm(
        code="TTS_501_0_110",
        label="TTS/501/0/110",
        description="""TTS/501/0/110""",
    )

    tts_501_0_110b = VocabularyTerm(
        code="TTS_501_0_110B",
        label="TTS/501/0/110B",
        description="""TTS/501/0/110B""",
    )

    tts_501_0_110f = VocabularyTerm(
        code="TTS_501_0_110F",
        label="TTS/501/0/110F",
        description="""TTS/501/0/110F""",
    )

    tts_501_0_111 = VocabularyTerm(
        code="TTS_501_0_111",
        label="TTS/501/0/111",
        description="""TTS/501/0/111""",
    )

    tts_501_0_112 = VocabularyTerm(
        code="TTS_501_0_112",
        label="TTS/501/0/112",
        description="""TTS/501/0/112""",
    )

    tts_501_0_113 = VocabularyTerm(
        code="TTS_501_0_113",
        label="TTS/501/0/113",
        description="""TTS/501/0/113""",
    )

    tts_501_0_113b = VocabularyTerm(
        code="TTS_501_0_113B",
        label="TTS/501/0/113B",
        description="""TTS/501/0/113B""",
    )

    tts_501_0_113f = VocabularyTerm(
        code="TTS_501_0_113F",
        label="TTS/501/0/113F",
        description="""TTS/501/0/113F""",
    )

    tts_501_0_114 = VocabularyTerm(
        code="TTS_501_0_114",
        label="TTS/501/0/114",
        description="""TTS/501/0/114""",
    )

    tts_501_0_115d = VocabularyTerm(
        code="TTS_501_0_115D",
        label="TTS/501/0/115D",
        description="""TTS/501/0/115D""",
    )

    tts_501_0_116h = VocabularyTerm(
        code="TTS_501_0_116H",
        label="TTS/501/0/116H",
        description="""TTS/501/0/116H""",
    )

    tts_501_0_117f = VocabularyTerm(
        code="TTS_501_0_117F",
        label="TTS/501/0/117F",
        description="""TTS/501/0/117F""",
    )

    tts_501_0_118wc = VocabularyTerm(
        code="TTS_501_0_118WC",
        label="TTS/501/0/118WC",
        description="""TTS/501/0/118WC""",
    )

    tts_501_0_119 = VocabularyTerm(
        code="TTS_501_0_119",
        label="TTS/501/0/119",
        description="""TTS/501/0/119""",
    )

    tts_501_0_120 = VocabularyTerm(
        code="TTS_501_0_120",
        label="TTS/501/0/120",
        description="""TTS/501/0/120""",
    )

    tts_501_0_121 = VocabularyTerm(
        code="TTS_501_0_121",
        label="TTS/501/0/121",
        description="""TTS/501/0/121""",
    )

    tts_501_0_122 = VocabularyTerm(
        code="TTS_501_0_122",
        label="TTS/501/0/122",
        description="""TTS/501/0/122""",
    )

    tts_501_0_123f = VocabularyTerm(
        code="TTS_501_0_123F",
        label="TTS/501/0/123F",
        description="""TTS/501/0/123F""",
    )

    tts_507_0_100 = VocabularyTerm(
        code="TTS_507_0_100",
        label="TTS/507/0/100",
        description="""TTS/507/0/100""",
    )

    tts_530_0_100 = VocabularyTerm(
        code="TTS_530_0_100",
        label="TTS/530/0/100",
        description="""TTS/530/0/100""",
    )

    tts_530_0_101 = VocabularyTerm(
        code="TTS_530_0_101",
        label="TTS/530/0/101",
        description="""TTS/530/0/101""",
    )

    tts_530_0_103 = VocabularyTerm(
        code="TTS_530_0_103",
        label="TTS/530/0/103",
        description="""TTS/530/0/103""",
    )

    tts_601_0_100 = VocabularyTerm(
        code="TTS_601_0_100",
        label="TTS/601/0/100",
        description="""TTS/601/0/100""",
    )

    tts_601_0_100f = VocabularyTerm(
        code="TTS_601_0_100F",
        label="TTS/601/0/100F",
        description="""TTS/601/0/100F""",
    )

    tts_601_0_102 = VocabularyTerm(
        code="TTS_601_0_102",
        label="TTS/601/0/102",
        description="""TTS/601/0/102""",
    )

    tts_601_0_103 = VocabularyTerm(
        code="TTS_601_0_103",
        label="TTS/601/0/103",
        description="""TTS/601/0/103""",
    )

    tts_601_0_104d = VocabularyTerm(
        code="TTS_601_0_104D",
        label="TTS/601/0/104D",
        description="""TTS/601/0/104D""",
    )

    tts_601_0_105 = VocabularyTerm(
        code="TTS_601_0_105",
        label="TTS/601/0/105",
        description="""TTS/601/0/105""",
    )

    tts_601_0_106h = VocabularyTerm(
        code="TTS_601_0_106H",
        label="TTS/601/0/106H",
        description="""TTS/601/0/106H""",
    )

    tts_602_0_100 = VocabularyTerm(
        code="TTS_602_0_100",
        label="TTS/602/0/100",
        description="""TTS/602/0/100""",
    )

    tts_603_0_100 = VocabularyTerm(
        code="TTS_603_0_100",
        label="TTS/603/0/100",
        description="""TTS/603/0/100""",
    )

    tts_604_0_100 = VocabularyTerm(
        code="TTS_604_0_100",
        label="TTS/604/0/100",
        description="""TTS/604/0/100""",
    )

    uem_7_0_100 = VocabularyTerm(
        code="UEM_7_0_100",
        label="UEM/7/0/100",
        description="""UEM/7/0/100""",
    )

    ue_01_0_100 = VocabularyTerm(
        code="UE_01_0_100",
        label="UE/01/0/100",
        description="""UE/01/0/100""",
    )

    ue_01_0_100f = VocabularyTerm(
        code="UE_01_0_100F",
        label="UE/01/0/100F",
        description="""UE/01/0/100F""",
    )

    ue_01_0_100t = VocabularyTerm(
        code="UE_01_0_100T",
        label="UE/01/0/100T",
        description="""UE/01/0/100T""",
    )

    ue_01_0_101 = VocabularyTerm(
        code="UE_01_0_101",
        label="UE/01/0/101",
        description="""UE/01/0/101""",
    )

    ue_01_0_101f = VocabularyTerm(
        code="UE_01_0_101F",
        label="UE/01/0/101F",
        description="""UE/01/0/101F""",
    )

    ue_01_0_102 = VocabularyTerm(
        code="UE_01_0_102",
        label="UE/01/0/102",
        description="""UE/01/0/102""",
    )

    ue_01_0_103 = VocabularyTerm(
        code="UE_01_0_103",
        label="UE/01/0/103",
        description="""UE/01/0/103""",
    )

    ue_01_0_104 = VocabularyTerm(
        code="UE_01_0_104",
        label="UE/01/0/104",
        description="""UE/01/0/104""",
    )

    ue_01_0_105 = VocabularyTerm(
        code="UE_01_0_105",
        label="UE/01/0/105",
        description="""UE/01/0/105""",
    )

    ue_01_0_107 = VocabularyTerm(
        code="UE_01_0_107",
        label="UE/01/0/107",
        description="""UE/01/0/107""",
    )

    ue_01_0_108 = VocabularyTerm(
        code="UE_01_0_108",
        label="UE/01/0/108",
        description="""UE/01/0/108""",
    )

    ue_01_0_109 = VocabularyTerm(
        code="UE_01_0_109",
        label="UE/01/0/109",
        description="""UE/01/0/109""",
    )

    ue_01_0_111 = VocabularyTerm(
        code="UE_01_0_111",
        label="UE/01/0/111",
        description="""UE/01/0/111""",
    )

    ue_01_0_111f = VocabularyTerm(
        code="UE_01_0_111F",
        label="UE/01/0/111F",
        description="""UE/01/0/111F""",
    )

    ue_01_0_112 = VocabularyTerm(
        code="UE_01_0_112",
        label="UE/01/0/112",
        description="""UE/01/0/112""",
    )

    ue_01_0_113 = VocabularyTerm(
        code="UE_01_0_113",
        label="UE/01/0/113",
        description="""UE/01/0/113""",
    )

    ue_01_0_115 = VocabularyTerm(
        code="UE_01_0_115",
        label="UE/01/0/115",
        description="""UE/01/0/115""",
    )

    ue_01_0_115b = VocabularyTerm(
        code="UE_01_0_115B",
        label="UE/01/0/115B",
        description="""UE/01/0/115B""",
    )

    ue_01_0_115d = VocabularyTerm(
        code="UE_01_0_115D",
        label="UE/01/0/115D",
        description="""UE/01/0/115D""",
    )

    ue_01_0_115f = VocabularyTerm(
        code="UE_01_0_115F",
        label="UE/01/0/115F",
        description="""UE/01/0/115F""",
    )

    ue_01_0_115wc = VocabularyTerm(
        code="UE_01_0_115WC",
        label="UE/01/0/115WC",
        description="""UE/01/0/115WC""",
    )

    ue_01_0_151 = VocabularyTerm(
        code="UE_01_0_151",
        label="UE/01/0/151",
        description="""UE/01/0/151""",
    )

    ue_01_0_151b = VocabularyTerm(
        code="UE_01_0_151B",
        label="UE/01/0/151B",
        description="""UE/01/0/151B""",
    )

    ue_01_0_151f = VocabularyTerm(
        code="UE_01_0_151F",
        label="UE/01/0/151F",
        description="""UE/01/0/151F""",
    )

    ue_01_0_152 = VocabularyTerm(
        code="UE_01_0_152",
        label="UE/01/0/152",
        description="""UE/01/0/152""",
    )

    ue_01_0_152a = VocabularyTerm(
        code="UE_01_0_152A",
        label="UE/01/0/152A",
        description="""UE/01/0/152A""",
    )

    ue_01_0_153 = VocabularyTerm(
        code="UE_01_0_153",
        label="UE/01/0/153",
        description="""UE/01/0/153""",
    )

    ue_01_0_155 = VocabularyTerm(
        code="UE_01_0_155",
        label="UE/01/0/155",
        description="""UE/01/0/155""",
    )

    ue_01_0_157 = VocabularyTerm(
        code="UE_01_0_157",
        label="UE/01/0/157",
        description="""UE/01/0/157""",
    )

    ue_01_0_161 = VocabularyTerm(
        code="UE_01_0_161",
        label="UE/01/0/161",
        description="""UE/01/0/161""",
    )

    ue_01_0_161f = VocabularyTerm(
        code="UE_01_0_161F",
        label="UE/01/0/161F",
        description="""UE/01/0/161F""",
    )

    ue_01_0_162 = VocabularyTerm(
        code="UE_01_0_162",
        label="UE/01/0/162",
        description="""UE/01/0/162""",
    )

    ue_01_0_163 = VocabularyTerm(
        code="UE_01_0_163",
        label="UE/01/0/163",
        description="""UE/01/0/163""",
    )

    ue_01_0_164 = VocabularyTerm(
        code="UE_01_0_164",
        label="UE/01/0/164",
        description="""UE/01/0/164""",
    )

    ue_01_0_165f = VocabularyTerm(
        code="UE_01_0_165F",
        label="UE/01/0/165F",
        description="""UE/01/0/165F""",
    )

    ue_01_0_165h = VocabularyTerm(
        code="UE_01_0_165H",
        label="UE/01/0/165H",
        description="""UE/01/0/165H""",
    )

    ue_01_0_a1 = VocabularyTerm(
        code="UE_01_0_A1",
        label="UE/01/0/A1",
        description="""UE/01/0/A1""",
    )

    ue_01_1_200 = VocabularyTerm(
        code="UE_01_1_200",
        label="UE/01/1/200",
        description="""UE/01/1/200""",
    )

    ue_01_1_200t = VocabularyTerm(
        code="UE_01_1_200T",
        label="UE/01/1/200T",
        description="""UE/01/1/200T""",
    )

    ue_01_1_201 = VocabularyTerm(
        code="UE_01_1_201",
        label="UE/01/1/201",
        description="""UE/01/1/201""",
    )

    ue_01_1_201f = VocabularyTerm(
        code="UE_01_1_201F",
        label="UE/01/1/201F",
        description="""UE/01/1/201F""",
    )

    ue_01_1_202 = VocabularyTerm(
        code="UE_01_1_202",
        label="UE/01/1/202",
        description="""UE/01/1/202""",
    )

    ue_01_1_203 = VocabularyTerm(
        code="UE_01_1_203",
        label="UE/01/1/203",
        description="""UE/01/1/203""",
    )

    ue_01_1_204 = VocabularyTerm(
        code="UE_01_1_204",
        label="UE/01/1/204",
        description="""UE/01/1/204""",
    )

    ue_01_1_204b = VocabularyTerm(
        code="UE_01_1_204B",
        label="UE/01/1/204B",
        description="""UE/01/1/204B""",
    )

    ue_01_1_205 = VocabularyTerm(
        code="UE_01_1_205",
        label="UE/01/1/205",
        description="""UE/01/1/205""",
    )

    ue_01_1_206 = VocabularyTerm(
        code="UE_01_1_206",
        label="UE/01/1/206",
        description="""UE/01/1/206""",
    )

    ue_01_1_207 = VocabularyTerm(
        code="UE_01_1_207",
        label="UE/01/1/207",
        description="""UE/01/1/207""",
    )

    ue_01_1_207f = VocabularyTerm(
        code="UE_01_1_207F",
        label="UE/01/1/207F",
        description="""UE/01/1/207F""",
    )

    ue_01_1_208 = VocabularyTerm(
        code="UE_01_1_208",
        label="UE/01/1/208",
        description="""UE/01/1/208""",
    )

    ue_01_1_209 = VocabularyTerm(
        code="UE_01_1_209",
        label="UE/01/1/209",
        description="""UE/01/1/209""",
    )

    ue_01_1_210 = VocabularyTerm(
        code="UE_01_1_210",
        label="UE/01/1/210",
        description="""UE/01/1/210""",
    )

    ue_01_1_211 = VocabularyTerm(
        code="UE_01_1_211",
        label="UE/01/1/211",
        description="""UE/01/1/211""",
    )

    ue_01_1_211f = VocabularyTerm(
        code="UE_01_1_211F",
        label="UE/01/1/211F",
        description="""UE/01/1/211F""",
    )

    ue_01_1_212 = VocabularyTerm(
        code="UE_01_1_212",
        label="UE/01/1/212",
        description="""UE/01/1/212""",
    )

    ue_01_1_213 = VocabularyTerm(
        code="UE_01_1_213",
        label="UE/01/1/213",
        description="""UE/01/1/213""",
    )

    ue_01_1_214 = VocabularyTerm(
        code="UE_01_1_214",
        label="UE/01/1/214",
        description="""UE/01/1/214""",
    )

    ue_01_1_215 = VocabularyTerm(
        code="UE_01_1_215",
        label="UE/01/1/215",
        description="""UE/01/1/215""",
    )

    ue_01_1_215h = VocabularyTerm(
        code="UE_01_1_215H",
        label="UE/01/1/215H",
        description="""UE/01/1/215H""",
    )

    ue_01_1_251 = VocabularyTerm(
        code="UE_01_1_251",
        label="UE/01/1/251",
        description="""UE/01/1/251""",
    )

    ue_01_1_251f = VocabularyTerm(
        code="UE_01_1_251F",
        label="UE/01/1/251F",
        description="""UE/01/1/251F""",
    )

    ue_01_1_252 = VocabularyTerm(
        code="UE_01_1_252",
        label="UE/01/1/252",
        description="""UE/01/1/252""",
    )

    ue_01_1_253 = VocabularyTerm(
        code="UE_01_1_253",
        label="UE/01/1/253",
        description="""UE/01/1/253""",
    )

    ue_01_1_255 = VocabularyTerm(
        code="UE_01_1_255",
        label="UE/01/1/255",
        description="""UE/01/1/255""",
    )

    ue_01_1_257 = VocabularyTerm(
        code="UE_01_1_257",
        label="UE/01/1/257",
        description="""UE/01/1/257""",
    )

    ue_01_1_259 = VocabularyTerm(
        code="UE_01_1_259",
        label="UE/01/1/259",
        description="""UE/01/1/259""",
    )

    ue_01_1_260 = VocabularyTerm(
        code="UE_01_1_260",
        label="UE/01/1/260",
        description="""UE/01/1/260""",
    )

    ue_01_1_261 = VocabularyTerm(
        code="UE_01_1_261",
        label="UE/01/1/261",
        description="""UE/01/1/261""",
    )

    ue_01_1_261f = VocabularyTerm(
        code="UE_01_1_261F",
        label="UE/01/1/261F",
        description="""UE/01/1/261F""",
    )

    ue_01_1_263 = VocabularyTerm(
        code="UE_01_1_263",
        label="UE/01/1/263",
        description="""UE/01/1/263""",
    )

    ue_01_1_264 = VocabularyTerm(
        code="UE_01_1_264",
        label="UE/01/1/264",
        description="""UE/01/1/264""",
    )

    ue_01_1_264b = VocabularyTerm(
        code="UE_01_1_264B",
        label="UE/01/1/264B",
        description="""UE/01/1/264B""",
    )

    ue_01_1_265 = VocabularyTerm(
        code="UE_01_1_265",
        label="UE/01/1/265",
        description="""UE/01/1/265""",
    )

    ue_01_1_265d = VocabularyTerm(
        code="UE_01_1_265D",
        label="UE/01/1/265D",
        description="""UE/01/1/265D""",
    )

    ue_01_1_a1 = VocabularyTerm(
        code="UE_01_1_A1",
        label="UE/01/1/A1",
        description="""UE/01/1/A1""",
    )

    ue_01_2_300 = VocabularyTerm(
        code="UE_01_2_300",
        label="UE/01/2/300",
        description="""UE/01/2/300""",
    )

    ue_01_2_300t = VocabularyTerm(
        code="UE_01_2_300T",
        label="UE/01/2/300T",
        description="""UE/01/2/300T""",
    )

    ue_01_2_301 = VocabularyTerm(
        code="UE_01_2_301",
        label="UE/01/2/301",
        description="""UE/01/2/301""",
    )

    ue_01_2_301f = VocabularyTerm(
        code="UE_01_2_301F",
        label="UE/01/2/301F",
        description="""UE/01/2/301F""",
    )

    ue_01_2_302 = VocabularyTerm(
        code="UE_01_2_302",
        label="UE/01/2/302",
        description="""UE/01/2/302""",
    )

    ue_01_2_303 = VocabularyTerm(
        code="UE_01_2_303",
        label="UE/01/2/303",
        description="""UE/01/2/303""",
    )

    ue_01_2_304 = VocabularyTerm(
        code="UE_01_2_304",
        label="UE/01/2/304",
        description="""UE/01/2/304""",
    )

    ue_01_2_304b = VocabularyTerm(
        code="UE_01_2_304B",
        label="UE/01/2/304B",
        description="""UE/01/2/304B""",
    )

    ue_01_2_305 = VocabularyTerm(
        code="UE_01_2_305",
        label="UE/01/2/305",
        description="""UE/01/2/305""",
    )

    ue_01_2_306 = VocabularyTerm(
        code="UE_01_2_306",
        label="UE/01/2/306",
        description="""UE/01/2/306""",
    )

    ue_01_2_307 = VocabularyTerm(
        code="UE_01_2_307",
        label="UE/01/2/307",
        description="""UE/01/2/307""",
    )

    ue_01_2_307b = VocabularyTerm(
        code="UE_01_2_307B",
        label="UE/01/2/307B",
        description="""UE/01/2/307B""",
    )

    ue_01_2_309 = VocabularyTerm(
        code="UE_01_2_309",
        label="UE/01/2/309",
        description="""UE/01/2/309""",
    )

    ue_01_2_310 = VocabularyTerm(
        code="UE_01_2_310",
        label="UE/01/2/310",
        description="""UE/01/2/310""",
    )

    ue_01_2_311 = VocabularyTerm(
        code="UE_01_2_311",
        label="UE/01/2/311",
        description="""UE/01/2/311""",
    )

    ue_01_2_311f = VocabularyTerm(
        code="UE_01_2_311F",
        label="UE/01/2/311F",
        description="""UE/01/2/311F""",
    )

    ue_01_2_312 = VocabularyTerm(
        code="UE_01_2_312",
        label="UE/01/2/312",
        description="""UE/01/2/312""",
    )

    ue_01_2_313 = VocabularyTerm(
        code="UE_01_2_313",
        label="UE/01/2/313",
        description="""UE/01/2/313""",
    )

    ue_01_2_314 = VocabularyTerm(
        code="UE_01_2_314",
        label="UE/01/2/314",
        description="""UE/01/2/314""",
    )

    ue_01_2_315d = VocabularyTerm(
        code="UE_01_2_315D",
        label="UE/01/2/315D",
        description="""UE/01/2/315D""",
    )

    ue_01_2_351 = VocabularyTerm(
        code="UE_01_2_351",
        label="UE/01/2/351",
        description="""UE/01/2/351""",
    )

    ue_01_2_351f = VocabularyTerm(
        code="UE_01_2_351F",
        label="UE/01/2/351F",
        description="""UE/01/2/351F""",
    )

    ue_01_2_352 = VocabularyTerm(
        code="UE_01_2_352",
        label="UE/01/2/352",
        description="""UE/01/2/352""",
    )

    ue_01_2_352b = VocabularyTerm(
        code="UE_01_2_352B",
        label="UE/01/2/352B",
        description="""UE/01/2/352B""",
    )

    ue_01_2_353 = VocabularyTerm(
        code="UE_01_2_353",
        label="UE/01/2/353",
        description="""UE/01/2/353""",
    )

    ue_01_2_354 = VocabularyTerm(
        code="UE_01_2_354",
        label="UE/01/2/354",
        description="""UE/01/2/354""",
    )

    ue_01_2_355 = VocabularyTerm(
        code="UE_01_2_355",
        label="UE/01/2/355",
        description="""UE/01/2/355""",
    )

    ue_01_2_357 = VocabularyTerm(
        code="UE_01_2_357",
        label="UE/01/2/357",
        description="""UE/01/2/357""",
    )

    ue_01_2_358 = VocabularyTerm(
        code="UE_01_2_358",
        label="UE/01/2/358",
        description="""UE/01/2/358""",
    )

    ue_01_2_359 = VocabularyTerm(
        code="UE_01_2_359",
        label="UE/01/2/359",
        description="""UE/01/2/359""",
    )

    ue_01_2_360 = VocabularyTerm(
        code="UE_01_2_360",
        label="UE/01/2/360",
        description="""UE/01/2/360""",
    )

    ue_01_2_361 = VocabularyTerm(
        code="UE_01_2_361",
        label="UE/01/2/361",
        description="""UE/01/2/361""",
    )

    ue_01_2_361f = VocabularyTerm(
        code="UE_01_2_361F",
        label="UE/01/2/361F",
        description="""UE/01/2/361F""",
    )

    ue_01_2_362 = VocabularyTerm(
        code="UE_01_2_362",
        label="UE/01/2/362",
        description="""UE/01/2/362""",
    )

    ue_01_2_363 = VocabularyTerm(
        code="UE_01_2_363",
        label="UE/01/2/363",
        description="""UE/01/2/363""",
    )

    ue_01_2_364 = VocabularyTerm(
        code="UE_01_2_364",
        label="UE/01/2/364",
        description="""UE/01/2/364""",
    )

    ue_01_2_365h = VocabularyTerm(
        code="UE_01_2_365H",
        label="UE/01/2/365H",
        description="""UE/01/2/365H""",
    )

    ue_01_2_a1 = VocabularyTerm(
        code="UE_01_2_A1",
        label="UE/01/2/A1",
        description="""UE/01/2/A1""",
    )

    ue_01_3_400f = VocabularyTerm(
        code="UE_01_3_400F",
        label="UE/01/3/400F",
        description="""UE/01/3/400F""",
    )

    ue_01_3_400t = VocabularyTerm(
        code="UE_01_3_400T",
        label="UE/01/3/400T",
        description="""UE/01/3/400T""",
    )

    ue_01_3_401 = VocabularyTerm(
        code="UE_01_3_401",
        label="UE/01/3/401",
        description="""UE/01/3/401""",
    )

    ue_01_3_402 = VocabularyTerm(
        code="UE_01_3_402",
        label="UE/01/3/402",
        description="""UE/01/3/402""",
    )

    ue_01_3_402b = VocabularyTerm(
        code="UE_01_3_402B",
        label="UE/01/3/402B",
        description="""UE/01/3/402B""",
    )

    ue_01_3_402t = VocabularyTerm(
        code="UE_01_3_402T",
        label="UE/01/3/402T",
        description="""UE/01/3/402T""",
    )

    ue_01_3_451 = VocabularyTerm(
        code="UE_01_3_451",
        label="UE/01/3/451",
        description="""UE/01/3/451""",
    )

    ue_01_3_452 = VocabularyTerm(
        code="UE_01_3_452",
        label="UE/01/3/452",
        description="""UE/01/3/452""",
    )

    ue_01_3_452t = VocabularyTerm(
        code="UE_01_3_452T",
        label="UE/01/3/452T",
        description="""UE/01/3/452T""",
    )

    ue_01_3_453 = VocabularyTerm(
        code="UE_01_3_453",
        label="UE/01/3/453",
        description="""UE/01/3/453""",
    )

    ue_01_3_a1 = VocabularyTerm(
        code="UE_01_3_A1",
        label="UE/01/3/A1",
        description="""UE/01/3/A1""",
    )

    ue_01_4_500t = VocabularyTerm(
        code="UE_01_4_500T",
        label="UE/01/4/500T",
        description="""UE/01/4/500T""",
    )

    ue_01_4_501 = VocabularyTerm(
        code="UE_01_4_501",
        label="UE/01/4/501",
        description="""UE/01/4/501""",
    )

    ue_01_5_601 = VocabularyTerm(
        code="UE_01_5_601",
        label="UE/01/5/601",
        description="""UE/01/5/601""",
    )

    ue_01__1_000 = VocabularyTerm(
        code="UE_01_-1_000",
        label="UE/01/-1/000",
        description="""UE/01/-1/000""",
    )

    ue_01__1_000t = VocabularyTerm(
        code="UE_01_-1_000T",
        label="UE/01/-1/000T",
        description="""UE/01/-1/000T""",
    )

    ue_01__1_000tb = VocabularyTerm(
        code="UE_01_-1_000TB",
        label="UE/01/-1/000TB",
        description="""UE/01/-1/000TB""",
    )

    ue_01__1_001 = VocabularyTerm(
        code="UE_01_-1_001",
        label="UE/01/-1/001",
        description="""UE/01/-1/001""",
    )

    ue_01__1_001b = VocabularyTerm(
        code="UE_01_-1_001B",
        label="UE/01/-1/001B",
        description="""UE/01/-1/001B""",
    )

    ue_01__1_001f = VocabularyTerm(
        code="UE_01_-1_001F",
        label="UE/01/-1/001F",
        description="""UE/01/-1/001F""",
    )

    ue_01__1_002 = VocabularyTerm(
        code="UE_01_-1_002",
        label="UE/01/-1/002",
        description="""UE/01/-1/002""",
    )

    ue_01__1_002f = VocabularyTerm(
        code="UE_01_-1_002F",
        label="UE/01/-1/002F",
        description="""UE/01/-1/002F""",
    )

    ue_01__1_003 = VocabularyTerm(
        code="UE_01_-1_003",
        label="UE/01/-1/003",
        description="""UE/01/-1/003""",
    )

    ue_01__1_004 = VocabularyTerm(
        code="UE_01_-1_004",
        label="UE/01/-1/004",
        description="""UE/01/-1/004""",
    )

    ue_01__1_005 = VocabularyTerm(
        code="UE_01_-1_005",
        label="UE/01/-1/005",
        description="""UE/01/-1/005""",
    )

    ue_01__1_007 = VocabularyTerm(
        code="UE_01_-1_007",
        label="UE/01/-1/007",
        description="""UE/01/-1/007""",
    )

    ue_01__1_008 = VocabularyTerm(
        code="UE_01_-1_008",
        label="UE/01/-1/008",
        description="""UE/01/-1/008""",
    )

    ue_01__1_009 = VocabularyTerm(
        code="UE_01_-1_009",
        label="UE/01/-1/009",
        description="""UE/01/-1/009""",
    )

    ue_01__1_011 = VocabularyTerm(
        code="UE_01_-1_011",
        label="UE/01/-1/011",
        description="""UE/01/-1/011""",
    )

    ue_01__1_011b = VocabularyTerm(
        code="UE_01_-1_011B",
        label="UE/01/-1/011B",
        description="""UE/01/-1/011B""",
    )

    ue_01__1_011f = VocabularyTerm(
        code="UE_01_-1_011F",
        label="UE/01/-1/011F",
        description="""UE/01/-1/011F""",
    )

    ue_01__1_012 = VocabularyTerm(
        code="UE_01_-1_012",
        label="UE/01/-1/012",
        description="""UE/01/-1/012""",
    )

    ue_01__1_014 = VocabularyTerm(
        code="UE_01_-1_014",
        label="UE/01/-1/014",
        description="""UE/01/-1/014""",
    )

    ue_01__1_015 = VocabularyTerm(
        code="UE_01_-1_015",
        label="UE/01/-1/015",
        description="""UE/01/-1/015""",
    )

    ue_01__1_015f = VocabularyTerm(
        code="UE_01_-1_015F",
        label="UE/01/-1/015F",
        description="""UE/01/-1/015F""",
    )

    ue_01__1_051 = VocabularyTerm(
        code="UE_01_-1_051",
        label="UE/01/-1/051",
        description="""UE/01/-1/051""",
    )

    ue_01__1_051f = VocabularyTerm(
        code="UE_01_-1_051F",
        label="UE/01/-1/051F",
        description="""UE/01/-1/051F""",
    )

    ue_01__1_052 = VocabularyTerm(
        code="UE_01_-1_052",
        label="UE/01/-1/052",
        description="""UE/01/-1/052""",
    )

    ue_01__1_053 = VocabularyTerm(
        code="UE_01_-1_053",
        label="UE/01/-1/053",
        description="""UE/01/-1/053""",
    )

    ue_01__1_054 = VocabularyTerm(
        code="UE_01_-1_054",
        label="UE/01/-1/054",
        description="""UE/01/-1/054""",
    )

    ue_01__1_055 = VocabularyTerm(
        code="UE_01_-1_055",
        label="UE/01/-1/055",
        description="""UE/01/-1/055""",
    )

    ue_01__1_055b = VocabularyTerm(
        code="UE_01_-1_055B",
        label="UE/01/-1/055B",
        description="""UE/01/-1/055B""",
    )

    ue_01__1_056 = VocabularyTerm(
        code="UE_01_-1_056",
        label="UE/01/-1/056",
        description="""UE/01/-1/056""",
    )

    ue_01__1_057 = VocabularyTerm(
        code="UE_01_-1_057",
        label="UE/01/-1/057",
        description="""UE/01/-1/057""",
    )

    ue_01__1_058 = VocabularyTerm(
        code="UE_01_-1_058",
        label="UE/01/-1/058",
        description="""UE/01/-1/058""",
    )

    ue_01__1_058b = VocabularyTerm(
        code="UE_01_-1_058B",
        label="UE/01/-1/058B",
        description="""UE/01/-1/058B""",
    )

    ue_01__1_059 = VocabularyTerm(
        code="UE_01_-1_059",
        label="UE/01/-1/059",
        description="""UE/01/-1/059""",
    )

    ue_01__1_061 = VocabularyTerm(
        code="UE_01_-1_061",
        label="UE/01/-1/061",
        description="""UE/01/-1/061""",
    )

    ue_01__1_061f = VocabularyTerm(
        code="UE_01_-1_061F",
        label="UE/01/-1/061F",
        description="""UE/01/-1/061F""",
    )

    ue_01__1_065 = VocabularyTerm(
        code="UE_01_-1_065",
        label="UE/01/-1/065",
        description="""UE/01/-1/065""",
    )

    ue_01__1_069 = VocabularyTerm(
        code="UE_01_-1_069",
        label="UE/01/-1/069",
        description="""UE/01/-1/069""",
    )

    ue_01__1_069f = VocabularyTerm(
        code="UE_01_-1_069F",
        label="UE/01/-1/069F",
        description="""UE/01/-1/069F""",
    )

    ue_01__1_a1 = VocabularyTerm(
        code="UE_01_-1_A1",
        label="UE/01/-1/A1",
        description="""UE/01/-1/A1""",
    )

    ue_02_0_101f = VocabularyTerm(
        code="UE_02_0_101F",
        label="UE/02/0/101F",
        description="""UE/02/0/101F""",
    )

    ue_02_0_102 = VocabularyTerm(
        code="UE_02_0_102",
        label="UE/02/0/102",
        description="""UE/02/0/102""",
    )

    ue_02_0_103f = VocabularyTerm(
        code="UE_02_0_103F",
        label="UE/02/0/103F",
        description="""UE/02/0/103F""",
    )

    ue_02_0_103t = VocabularyTerm(
        code="UE_02_0_103T",
        label="UE/02/0/103T",
        description="""UE/02/0/103T""",
    )

    ue_02_0_104d = VocabularyTerm(
        code="UE_02_0_104D",
        label="UE/02/0/104D",
        description="""UE/02/0/104D""",
    )

    ue_02_0_106h = VocabularyTerm(
        code="UE_02_0_106H",
        label="UE/02/0/106H",
        description="""UE/02/0/106H""",
    )

    ue_02_0_106wc = VocabularyTerm(
        code="UE_02_0_106WC",
        label="UE/02/0/106WC",
        description="""UE/02/0/106WC""",
    )

    ue_02_0_107 = VocabularyTerm(
        code="UE_02_0_107",
        label="UE/02/0/107",
        description="""UE/02/0/107""",
    )

    ue_02_0_107f = VocabularyTerm(
        code="UE_02_0_107F",
        label="UE/02/0/107F",
        description="""UE/02/0/107F""",
    )

    ue_02_0_108 = VocabularyTerm(
        code="UE_02_0_108",
        label="UE/02/0/108",
        description="""UE/02/0/108""",
    )

    ue_02_0_108b = VocabularyTerm(
        code="UE_02_0_108B",
        label="UE/02/0/108B",
        description="""UE/02/0/108B""",
    )

    ue_02_0_109 = VocabularyTerm(
        code="UE_02_0_109",
        label="UE/02/0/109",
        description="""UE/02/0/109""",
    )

    ue_02_0_110f = VocabularyTerm(
        code="UE_02_0_110F",
        label="UE/02/0/110F",
        description="""UE/02/0/110F""",
    )

    ue_02_0_111 = VocabularyTerm(
        code="UE_02_0_111",
        label="UE/02/0/111",
        description="""UE/02/0/111""",
    )

    ue_02_0_112 = VocabularyTerm(
        code="UE_02_0_112",
        label="UE/02/0/112",
        description="""UE/02/0/112""",
    )

    ue_02_0_113 = VocabularyTerm(
        code="UE_02_0_113",
        label="UE/02/0/113",
        description="""UE/02/0/113""",
    )

    ue_02_0_114 = VocabularyTerm(
        code="UE_02_0_114",
        label="UE/02/0/114",
        description="""UE/02/0/114""",
    )

    ue_02_0_115 = VocabularyTerm(
        code="UE_02_0_115",
        label="UE/02/0/115",
        description="""UE/02/0/115""",
    )

    ue_02_0_115t = VocabularyTerm(
        code="UE_02_0_115T",
        label="UE/02/0/115T",
        description="""UE/02/0/115T""",
    )

    ue_02_0_116 = VocabularyTerm(
        code="UE_02_0_116",
        label="UE/02/0/116",
        description="""UE/02/0/116""",
    )

    ue_02_0_117f = VocabularyTerm(
        code="UE_02_0_117F",
        label="UE/02/0/117F",
        description="""UE/02/0/117F""",
    )

    ue_02_0_118f = VocabularyTerm(
        code="UE_02_0_118F",
        label="UE/02/0/118F",
        description="""UE/02/0/118F""",
    )

    ue_02_0_118t = VocabularyTerm(
        code="UE_02_0_118T",
        label="UE/02/0/118T",
        description="""UE/02/0/118T""",
    )

    ue_02_0_119 = VocabularyTerm(
        code="UE_02_0_119",
        label="UE/02/0/119",
        description="""UE/02/0/119""",
    )

    ue_02_0_120 = VocabularyTerm(
        code="UE_02_0_120",
        label="UE/02/0/120",
        description="""UE/02/0/120""",
    )

    ue_02_1_203t = VocabularyTerm(
        code="UE_02_1_203T",
        label="UE/02/1/203T",
        description="""UE/02/1/203T""",
    )

    ue_02_1_204d = VocabularyTerm(
        code="UE_02_1_204D",
        label="UE/02/1/204D",
        description="""UE/02/1/204D""",
    )

    ue_02_1_206 = VocabularyTerm(
        code="UE_02_1_206",
        label="UE/02/1/206",
        description="""UE/02/1/206""",
    )

    ue_02_1_207 = VocabularyTerm(
        code="UE_02_1_207",
        label="UE/02/1/207",
        description="""UE/02/1/207""",
    )

    ue_02_1_209 = VocabularyTerm(
        code="UE_02_1_209",
        label="UE/02/1/209",
        description="""UE/02/1/209""",
    )

    ue_02_1_210 = VocabularyTerm(
        code="UE_02_1_210",
        label="UE/02/1/210",
        description="""UE/02/1/210""",
    )

    ue_02_1_210b = VocabularyTerm(
        code="UE_02_1_210B",
        label="UE/02/1/210B",
        description="""UE/02/1/210B""",
    )

    ue_02_1_211 = VocabularyTerm(
        code="UE_02_1_211",
        label="UE/02/1/211",
        description="""UE/02/1/211""",
    )

    ue_02_1_212 = VocabularyTerm(
        code="UE_02_1_212",
        label="UE/02/1/212",
        description="""UE/02/1/212""",
    )

    ue_02_1_213 = VocabularyTerm(
        code="UE_02_1_213",
        label="UE/02/1/213",
        description="""UE/02/1/213""",
    )

    ue_02_1_214 = VocabularyTerm(
        code="UE_02_1_214",
        label="UE/02/1/214",
        description="""UE/02/1/214""",
    )

    ue_02_1_215f = VocabularyTerm(
        code="UE_02_1_215F",
        label="UE/02/1/215F",
        description="""UE/02/1/215F""",
    )

    ue_02_1_215t = VocabularyTerm(
        code="UE_02_1_215T",
        label="UE/02/1/215T",
        description="""UE/02/1/215T""",
    )

    ue_02_1_216h = VocabularyTerm(
        code="UE_02_1_216H",
        label="UE/02/1/216H",
        description="""UE/02/1/216H""",
    )

    ue_02_1_balkon = VocabularyTerm(
        code="UE_02_1_BALKON",
        label="UE/02/1/Balkon",
        description="""UE/02/1/Balkon""",
    )

    ue_02_2_303t = VocabularyTerm(
        code="UE_02_2_303T",
        label="UE/02/2/303T",
        description="""UE/02/2/303T""",
    )

    ue_02_2_304 = VocabularyTerm(
        code="UE_02_2_304",
        label="UE/02/2/304",
        description="""UE/02/2/304""",
    )

    ue_02_2_306 = VocabularyTerm(
        code="UE_02_2_306",
        label="UE/02/2/306",
        description="""UE/02/2/306""",
    )

    ue_02_2_307 = VocabularyTerm(
        code="UE_02_2_307",
        label="UE/02/2/307",
        description="""UE/02/2/307""",
    )

    ue_02_2_309 = VocabularyTerm(
        code="UE_02_2_309",
        label="UE/02/2/309",
        description="""UE/02/2/309""",
    )

    ue_02_2_310 = VocabularyTerm(
        code="UE_02_2_310",
        label="UE/02/2/310",
        description="""UE/02/2/310""",
    )

    ue_02_2_311 = VocabularyTerm(
        code="UE_02_2_311",
        label="UE/02/2/311",
        description="""UE/02/2/311""",
    )

    ue_02_2_312 = VocabularyTerm(
        code="UE_02_2_312",
        label="UE/02/2/312",
        description="""UE/02/2/312""",
    )

    ue_02_2_313 = VocabularyTerm(
        code="UE_02_2_313",
        label="UE/02/2/313",
        description="""UE/02/2/313""",
    )

    ue_02_2_314 = VocabularyTerm(
        code="UE_02_2_314",
        label="UE/02/2/314",
        description="""UE/02/2/314""",
    )

    ue_02_2_315f = VocabularyTerm(
        code="UE_02_2_315F",
        label="UE/02/2/315F",
        description="""UE/02/2/315F""",
    )

    ue_02_2_315t = VocabularyTerm(
        code="UE_02_2_315T",
        label="UE/02/2/315T",
        description="""UE/02/2/315T""",
    )

    ue_02_2_316 = VocabularyTerm(
        code="UE_02_2_316",
        label="UE/02/2/316",
        description="""UE/02/2/316""",
    )

    ue_02__1_001f = VocabularyTerm(
        code="UE_02_-1_001F",
        label="UE/02/-1/001F",
        description="""UE/02/-1/001F""",
    )

    ue_02__1_003f = VocabularyTerm(
        code="UE_02_-1_003F",
        label="UE/02/-1/003F",
        description="""UE/02/-1/003F""",
    )

    ue_02__1_003t = VocabularyTerm(
        code="UE_02_-1_003T",
        label="UE/02/-1/003T",
        description="""UE/02/-1/003T""",
    )

    ue_02__1_004 = VocabularyTerm(
        code="UE_02_-1_004",
        label="UE/02/-1/004",
        description="""UE/02/-1/004""",
    )

    ue_02__1_005 = VocabularyTerm(
        code="UE_02_-1_005",
        label="UE/02/-1/005",
        description="""UE/02/-1/005""",
    )

    ue_02__1_007 = VocabularyTerm(
        code="UE_02_-1_007",
        label="UE/02/-1/007",
        description="""UE/02/-1/007""",
    )

    ue_02__1_008 = VocabularyTerm(
        code="UE_02_-1_008",
        label="UE/02/-1/008",
        description="""UE/02/-1/008""",
    )

    ue_02__1_009 = VocabularyTerm(
        code="UE_02_-1_009",
        label="UE/02/-1/009",
        description="""UE/02/-1/009""",
    )

    ue_02__1_010 = VocabularyTerm(
        code="UE_02_-1_010",
        label="UE/02/-1/010",
        description="""UE/02/-1/010""",
    )

    ue_02__1_011 = VocabularyTerm(
        code="UE_02_-1_011",
        label="UE/02/-1/011",
        description="""UE/02/-1/011""",
    )

    ue_02__1_013 = VocabularyTerm(
        code="UE_02_-1_013",
        label="UE/02/-1/013",
        description="""UE/02/-1/013""",
    )

    ue_02__1_014 = VocabularyTerm(
        code="UE_02_-1_014",
        label="UE/02/-1/014",
        description="""UE/02/-1/014""",
    )

    ue_02__1_014f = VocabularyTerm(
        code="UE_02_-1_014F",
        label="UE/02/-1/014F",
        description="""UE/02/-1/014F""",
    )

    ue_02__1_015 = VocabularyTerm(
        code="UE_02_-1_015",
        label="UE/02/-1/015",
        description="""UE/02/-1/015""",
    )

    ue_02__1_015f = VocabularyTerm(
        code="UE_02_-1_015F",
        label="UE/02/-1/015F",
        description="""UE/02/-1/015F""",
    )

    ue_02__1_016 = VocabularyTerm(
        code="UE_02_-1_016",
        label="UE/02/-1/016",
        description="""UE/02/-1/016""",
    )

    ue_02__1_018t = VocabularyTerm(
        code="UE_02_-1_018T",
        label="UE/02/-1/018T",
        description="""UE/02/-1/018T""",
    )

    ue_03_0_101 = VocabularyTerm(
        code="UE_03_0_101",
        label="UE/03/0/101",
        description="""UE/03/0/101""",
    )

    ue_03_0_102 = VocabularyTerm(
        code="UE_03_0_102",
        label="UE/03/0/102",
        description="""UE/03/0/102""",
    )

    ue_03_0_102f = VocabularyTerm(
        code="UE_03_0_102F",
        label="UE/03/0/102F",
        description="""UE/03/0/102F""",
    )

    ue_03_0_105 = VocabularyTerm(
        code="UE_03_0_105",
        label="UE/03/0/105",
        description="""UE/03/0/105""",
    )

    ue_03_0_115t = VocabularyTerm(
        code="UE_03_0_115T",
        label="UE/03/0/115T",
        description="""UE/03/0/115T""",
    )

    ue_03_0_116 = VocabularyTerm(
        code="UE_03_0_116",
        label="UE/03/0/116",
        description="""UE/03/0/116""",
    )

    ue_03_0_117 = VocabularyTerm(
        code="UE_03_0_117",
        label="UE/03/0/117",
        description="""UE/03/0/117""",
    )

    ue_03_0_118 = VocabularyTerm(
        code="UE_03_0_118",
        label="UE/03/0/118",
        description="""UE/03/0/118""",
    )

    ue_03_0_119 = VocabularyTerm(
        code="UE_03_0_119",
        label="UE/03/0/119",
        description="""UE/03/0/119""",
    )

    ue_03_0_121 = VocabularyTerm(
        code="UE_03_0_121",
        label="UE/03/0/121",
        description="""UE/03/0/121""",
    )

    ue_03_0_122 = VocabularyTerm(
        code="UE_03_0_122",
        label="UE/03/0/122",
        description="""UE/03/0/122""",
    )

    ue_03_0_124 = VocabularyTerm(
        code="UE_03_0_124",
        label="UE/03/0/124",
        description="""UE/03/0/124""",
    )

    ue_03_1a_101ab = VocabularyTerm(
        code="UE_03_1A_101AB",
        label="UE/03/1A/101AB",
        description="""UE/03/1A/101AB""",
    )

    ue_03_1a_101ad = VocabularyTerm(
        code="UE_03_1A_101AD",
        label="UE/03/1A/101AD",
        description="""UE/03/1A/101AD""",
    )

    ue_03_1a_102a = VocabularyTerm(
        code="UE_03_1A_102A",
        label="UE/03/1A/102A",
        description="""UE/03/1A/102A""",
    )

    ue_03_1a_115at = VocabularyTerm(
        code="UE_03_1A_115AT",
        label="UE/03/1A/115AT",
        description="""UE/03/1A/115AT""",
    )

    ue_03_1a_116a = VocabularyTerm(
        code="UE_03_1A_116A",
        label="UE/03/1A/116A",
        description="""UE/03/1A/116A""",
    )

    ue_03_1a_117a = VocabularyTerm(
        code="UE_03_1A_117A",
        label="UE/03/1A/117A",
        description="""UE/03/1A/117A""",
    )

    ue_03_1a_118a = VocabularyTerm(
        code="UE_03_1A_118A",
        label="UE/03/1A/118A",
        description="""UE/03/1A/118A""",
    )

    ue_03_1a_119a = VocabularyTerm(
        code="UE_03_1A_119A",
        label="UE/03/1A/119A",
        description="""UE/03/1A/119A""",
    )

    ue_03_1a_120a = VocabularyTerm(
        code="UE_03_1A_120A",
        label="UE/03/1A/120A",
        description="""UE/03/1A/120A""",
    )

    ue_03_1a_121a = VocabularyTerm(
        code="UE_03_1A_121A",
        label="UE/03/1A/121A",
        description="""UE/03/1A/121A""",
    )

    ue_03_1a_122a = VocabularyTerm(
        code="UE_03_1A_122A",
        label="UE/03/1A/122A",
        description="""UE/03/1A/122A""",
    )

    ue_03_1_201h = VocabularyTerm(
        code="UE_03_1_201H",
        label="UE/03/1/201H",
        description="""UE/03/1/201H""",
    )

    ue_03_1_202 = VocabularyTerm(
        code="UE_03_1_202",
        label="UE/03/1/202",
        description="""UE/03/1/202""",
    )

    ue_03_1_202f = VocabularyTerm(
        code="UE_03_1_202F",
        label="UE/03/1/202F",
        description="""UE/03/1/202F""",
    )

    ue_03_1_205 = VocabularyTerm(
        code="UE_03_1_205",
        label="UE/03/1/205",
        description="""UE/03/1/205""",
    )

    ue_03_1_206 = VocabularyTerm(
        code="UE_03_1_206",
        label="UE/03/1/206",
        description="""UE/03/1/206""",
    )

    ue_03_1_206f = VocabularyTerm(
        code="UE_03_1_206F",
        label="UE/03/1/206F",
        description="""UE/03/1/206F""",
    )

    ue_03_1_207 = VocabularyTerm(
        code="UE_03_1_207",
        label="UE/03/1/207",
        description="""UE/03/1/207""",
    )

    ue_03_1_208 = VocabularyTerm(
        code="UE_03_1_208",
        label="UE/03/1/208",
        description="""UE/03/1/208""",
    )

    ue_03_1_209 = VocabularyTerm(
        code="UE_03_1_209",
        label="UE/03/1/209",
        description="""UE/03/1/209""",
    )

    ue_03_1_209b = VocabularyTerm(
        code="UE_03_1_209B",
        label="UE/03/1/209B",
        description="""UE/03/1/209B""",
    )

    ue_03_1_210 = VocabularyTerm(
        code="UE_03_1_210",
        label="UE/03/1/210",
        description="""UE/03/1/210""",
    )

    ue_03_1_211 = VocabularyTerm(
        code="UE_03_1_211",
        label="UE/03/1/211",
        description="""UE/03/1/211""",
    )

    ue_03_1_212 = VocabularyTerm(
        code="UE_03_1_212",
        label="UE/03/1/212",
        description="""UE/03/1/212""",
    )

    ue_03_1_212f = VocabularyTerm(
        code="UE_03_1_212F",
        label="UE/03/1/212F",
        description="""UE/03/1/212F""",
    )

    ue_03_1_213 = VocabularyTerm(
        code="UE_03_1_213",
        label="UE/03/1/213",
        description="""UE/03/1/213""",
    )

    ue_03_1_214 = VocabularyTerm(
        code="UE_03_1_214",
        label="UE/03/1/214",
        description="""UE/03/1/214""",
    )

    ue_03_1_215t = VocabularyTerm(
        code="UE_03_1_215T",
        label="UE/03/1/215T",
        description="""UE/03/1/215T""",
    )

    ue_03_1_216 = VocabularyTerm(
        code="UE_03_1_216",
        label="UE/03/1/216",
        description="""UE/03/1/216""",
    )

    ue_03_1_217 = VocabularyTerm(
        code="UE_03_1_217",
        label="UE/03/1/217",
        description="""UE/03/1/217""",
    )

    ue_03_1_218 = VocabularyTerm(
        code="UE_03_1_218",
        label="UE/03/1/218",
        description="""UE/03/1/218""",
    )

    ue_03_1_219 = VocabularyTerm(
        code="UE_03_1_219",
        label="UE/03/1/219",
        description="""UE/03/1/219""",
    )

    ue_03_1_224 = VocabularyTerm(
        code="UE_03_1_224",
        label="UE/03/1/224",
        description="""UE/03/1/224""",
    )

    ue_03_1_224f = VocabularyTerm(
        code="UE_03_1_224F",
        label="UE/03/1/224F",
        description="""UE/03/1/224F""",
    )

    ue_03__1_015b = VocabularyTerm(
        code="UE_03_-1_015B",
        label="UE/03/-1/015B",
        description="""UE/03/-1/015B""",
    )

    ue_03__1_015t = VocabularyTerm(
        code="UE_03_-1_015T",
        label="UE/03/-1/015T",
        description="""UE/03/-1/015T""",
    )

    ue_03__1_017 = VocabularyTerm(
        code="UE_03_-1_017",
        label="UE/03/-1/017",
        description="""UE/03/-1/017""",
    )

    ue_03__1_017f = VocabularyTerm(
        code="UE_03_-1_017F",
        label="UE/03/-1/017F",
        description="""UE/03/-1/017F""",
    )

    ue_03__1_018 = VocabularyTerm(
        code="UE_03_-1_018",
        label="UE/03/-1/018",
        description="""UE/03/-1/018""",
    )

    ue_03__1_021 = VocabularyTerm(
        code="UE_03_-1_021",
        label="UE/03/-1/021",
        description="""UE/03/-1/021""",
    )

    ue_03__1_021f = VocabularyTerm(
        code="UE_03_-1_021F",
        label="UE/03/-1/021F",
        description="""UE/03/-1/021F""",
    )

    ue_03__1_022 = VocabularyTerm(
        code="UE_03_-1_022",
        label="UE/03/-1/022",
        description="""UE/03/-1/022""",
    )

    ue_03__1_024 = VocabularyTerm(
        code="UE_03_-1_024",
        label="UE/03/-1/024",
        description="""UE/03/-1/024""",
    )

    ue_03__1_024f = VocabularyTerm(
        code="UE_03_-1_024F",
        label="UE/03/-1/024F",
        description="""UE/03/-1/024F""",
    )

    ue_03__1_026 = VocabularyTerm(
        code="UE_03_-1_026",
        label="UE/03/-1/026",
        description="""UE/03/-1/026""",
    )

    ue_04_0_100 = VocabularyTerm(
        code="UE_04_0_100",
        label="UE/04/0/100",
        description="""UE/04/0/100""",
    )

    ue_04_0_100f = VocabularyTerm(
        code="UE_04_0_100F",
        label="UE/04/0/100F",
        description="""UE/04/0/100F""",
    )

    ue_04_0_101 = VocabularyTerm(
        code="UE_04_0_101",
        label="UE/04/0/101",
        description="""UE/04/0/101""",
    )

    ue_04_0_101t = VocabularyTerm(
        code="UE_04_0_101T",
        label="UE/04/0/101T",
        description="""UE/04/0/101T""",
    )

    ue_04_0_104 = VocabularyTerm(
        code="UE_04_0_104",
        label="UE/04/0/104",
        description="""UE/04/0/104""",
    )

    ue_04_0_105 = VocabularyTerm(
        code="UE_04_0_105",
        label="UE/04/0/105",
        description="""UE/04/0/105""",
    )

    ue_04_0_108 = VocabularyTerm(
        code="UE_04_0_108",
        label="UE/04/0/108",
        description="""UE/04/0/108""",
    )

    ue_04_0_109 = VocabularyTerm(
        code="UE_04_0_109",
        label="UE/04/0/109",
        description="""UE/04/0/109""",
    )

    ue_04_0_112 = VocabularyTerm(
        code="UE_04_0_112",
        label="UE/04/0/112",
        description="""UE/04/0/112""",
    )

    ue_04_0_113 = VocabularyTerm(
        code="UE_04_0_113",
        label="UE/04/0/113",
        description="""UE/04/0/113""",
    )

    ue_04_0_116 = VocabularyTerm(
        code="UE_04_0_116",
        label="UE/04/0/116",
        description="""UE/04/0/116""",
    )

    ue_04_0_117 = VocabularyTerm(
        code="UE_04_0_117",
        label="UE/04/0/117",
        description="""UE/04/0/117""",
    )

    ue_04_0_118 = VocabularyTerm(
        code="UE_04_0_118",
        label="UE/04/0/118",
        description="""UE/04/0/118""",
    )

    ue_04_0_119 = VocabularyTerm(
        code="UE_04_0_119",
        label="UE/04/0/119",
        description="""UE/04/0/119""",
    )

    ue_04_0_152 = VocabularyTerm(
        code="UE_04_0_152",
        label="UE/04/0/152",
        description="""UE/04/0/152""",
    )

    ue_04_1_200 = VocabularyTerm(
        code="UE_04_1_200",
        label="UE/04/1/200",
        description="""UE/04/1/200""",
    )

    ue_04_1_200f = VocabularyTerm(
        code="UE_04_1_200F",
        label="UE/04/1/200F",
        description="""UE/04/1/200F""",
    )

    ue_04_1_201 = VocabularyTerm(
        code="UE_04_1_201",
        label="UE/04/1/201",
        description="""UE/04/1/201""",
    )

    ue_04_1_201t = VocabularyTerm(
        code="UE_04_1_201T",
        label="UE/04/1/201T",
        description="""UE/04/1/201T""",
    )

    ue_04_1_204 = VocabularyTerm(
        code="UE_04_1_204",
        label="UE/04/1/204",
        description="""UE/04/1/204""",
    )

    ue_04_1_205 = VocabularyTerm(
        code="UE_04_1_205",
        label="UE/04/1/205",
        description="""UE/04/1/205""",
    )

    ue_04_1_208 = VocabularyTerm(
        code="UE_04_1_208",
        label="UE/04/1/208",
        description="""UE/04/1/208""",
    )

    ue_04_1_209 = VocabularyTerm(
        code="UE_04_1_209",
        label="UE/04/1/209",
        description="""UE/04/1/209""",
    )

    ue_04_1_212 = VocabularyTerm(
        code="UE_04_1_212",
        label="UE/04/1/212",
        description="""UE/04/1/212""",
    )

    ue_04_1_213 = VocabularyTerm(
        code="UE_04_1_213",
        label="UE/04/1/213",
        description="""UE/04/1/213""",
    )

    ue_04_1_216 = VocabularyTerm(
        code="UE_04_1_216",
        label="UE/04/1/216",
        description="""UE/04/1/216""",
    )

    ue_04_1_217 = VocabularyTerm(
        code="UE_04_1_217",
        label="UE/04/1/217",
        description="""UE/04/1/217""",
    )

    ue_04_1_219 = VocabularyTerm(
        code="UE_04_1_219",
        label="UE/04/1/219",
        description="""UE/04/1/219""",
    )

    ue_04_1_252 = VocabularyTerm(
        code="UE_04_1_252",
        label="UE/04/1/252",
        description="""UE/04/1/252""",
    )

    ue_04_2_300f = VocabularyTerm(
        code="UE_04_2_300F",
        label="UE/04/2/300F",
        description="""UE/04/2/300F""",
    )

    ue_04_2_301 = VocabularyTerm(
        code="UE_04_2_301",
        label="UE/04/2/301",
        description="""UE/04/2/301""",
    )

    ue_04_2_301t = VocabularyTerm(
        code="UE_04_2_301T",
        label="UE/04/2/301T",
        description="""UE/04/2/301T""",
    )

    ue_04_2_302 = VocabularyTerm(
        code="UE_04_2_302",
        label="UE/04/2/302",
        description="""UE/04/2/302""",
    )

    ue_04_2_303 = VocabularyTerm(
        code="UE_04_2_303",
        label="UE/04/2/303",
        description="""UE/04/2/303""",
    )

    ue_04_2_304 = VocabularyTerm(
        code="UE_04_2_304",
        label="UE/04/2/304",
        description="""UE/04/2/304""",
    )

    ue_04_2_305 = VocabularyTerm(
        code="UE_04_2_305",
        label="UE/04/2/305",
        description="""UE/04/2/305""",
    )

    ue_04_2_306 = VocabularyTerm(
        code="UE_04_2_306",
        label="UE/04/2/306",
        description="""UE/04/2/306""",
    )

    ue_04_2_307 = VocabularyTerm(
        code="UE_04_2_307",
        label="UE/04/2/307",
        description="""UE/04/2/307""",
    )

    ue_04_2_308 = VocabularyTerm(
        code="UE_04_2_308",
        label="UE/04/2/308",
        description="""UE/04/2/308""",
    )

    ue_04_2_309 = VocabularyTerm(
        code="UE_04_2_309",
        label="UE/04/2/309",
        description="""UE/04/2/309""",
    )

    ue_04_2_310 = VocabularyTerm(
        code="UE_04_2_310",
        label="UE/04/2/310",
        description="""UE/04/2/310""",
    )

    ue_04_2_311 = VocabularyTerm(
        code="UE_04_2_311",
        label="UE/04/2/311",
        description="""UE/04/2/311""",
    )

    ue_04_2_312 = VocabularyTerm(
        code="UE_04_2_312",
        label="UE/04/2/312",
        description="""UE/04/2/312""",
    )

    ue_04_2_313 = VocabularyTerm(
        code="UE_04_2_313",
        label="UE/04/2/313",
        description="""UE/04/2/313""",
    )

    ue_04_2_314 = VocabularyTerm(
        code="UE_04_2_314",
        label="UE/04/2/314",
        description="""UE/04/2/314""",
    )

    ue_04_2_315 = VocabularyTerm(
        code="UE_04_2_315",
        label="UE/04/2/315",
        description="""UE/04/2/315""",
    )

    ue_05_0_102t = VocabularyTerm(
        code="UE_05_0_102T",
        label="UE/05/0/102T",
        description="""UE/05/0/102T""",
    )

    ue_05_0_104 = VocabularyTerm(
        code="UE_05_0_104",
        label="UE/05/0/104",
        description="""UE/05/0/104""",
    )

    ue_05_0_107 = VocabularyTerm(
        code="UE_05_0_107",
        label="UE/05/0/107",
        description="""UE/05/0/107""",
    )

    ue_05_0_108 = VocabularyTerm(
        code="UE_05_0_108",
        label="UE/05/0/108",
        description="""UE/05/0/108""",
    )

    ue_05_0_111 = VocabularyTerm(
        code="UE_05_0_111",
        label="UE/05/0/111",
        description="""UE/05/0/111""",
    )

    ue_05_0_113 = VocabularyTerm(
        code="UE_05_0_113",
        label="UE/05/0/113",
        description="""UE/05/0/113""",
    )

    ue_05_0_114 = VocabularyTerm(
        code="UE_05_0_114",
        label="UE/05/0/114",
        description="""UE/05/0/114""",
    )

    ue_05_0_114f = VocabularyTerm(
        code="UE_05_0_114F",
        label="UE/05/0/114F",
        description="""UE/05/0/114F""",
    )

    ue_05_0_116 = VocabularyTerm(
        code="UE_05_0_116",
        label="UE/05/0/116",
        description="""UE/05/0/116""",
    )

    ue_05_0_117 = VocabularyTerm(
        code="UE_05_0_117",
        label="UE/05/0/117",
        description="""UE/05/0/117""",
    )

    ue_05_0_118 = VocabularyTerm(
        code="UE_05_0_118",
        label="UE/05/0/118",
        description="""UE/05/0/118""",
    )

    ue_05_0_119 = VocabularyTerm(
        code="UE_05_0_119",
        label="UE/05/0/119",
        description="""UE/05/0/119""",
    )

    ue_05_0_119h = VocabularyTerm(
        code="UE_05_0_119H",
        label="UE/05/0/119H",
        description="""UE/05/0/119H""",
    )

    ue_05_0_121d = VocabularyTerm(
        code="UE_05_0_121D",
        label="UE/05/0/121D",
        description="""UE/05/0/121D""",
    )

    ue_05_0_121f = VocabularyTerm(
        code="UE_05_0_121F",
        label="UE/05/0/121F",
        description="""UE/05/0/121F""",
    )

    ue_05_0_122f = VocabularyTerm(
        code="UE_05_0_122F",
        label="UE/05/0/122F",
        description="""UE/05/0/122F""",
    )

    ue_05_0_122t = VocabularyTerm(
        code="UE_05_0_122T",
        label="UE/05/0/122T",
        description="""UE/05/0/122T""",
    )

    ue_05_0_123 = VocabularyTerm(
        code="UE_05_0_123",
        label="UE/05/0/123",
        description="""UE/05/0/123""",
    )

    ue_05_0_123b = VocabularyTerm(
        code="UE_05_0_123B",
        label="UE/05/0/123B",
        description="""UE/05/0/123B""",
    )

    ue_05_0_125 = VocabularyTerm(
        code="UE_05_0_125",
        label="UE/05/0/125",
        description="""UE/05/0/125""",
    )

    ue_05_0_127 = VocabularyTerm(
        code="UE_05_0_127",
        label="UE/05/0/127",
        description="""UE/05/0/127""",
    )

    ue_05_0_131 = VocabularyTerm(
        code="UE_05_0_131",
        label="UE/05/0/131",
        description="""UE/05/0/131""",
    )

    ue_05_0_131t = VocabularyTerm(
        code="UE_05_0_131T",
        label="UE/05/0/131T",
        description="""UE/05/0/131T""",
    )

    ue_05_0_133 = VocabularyTerm(
        code="UE_05_0_133",
        label="UE/05/0/133",
        description="""UE/05/0/133""",
    )

    ue_05_0_134 = VocabularyTerm(
        code="UE_05_0_134",
        label="UE/05/0/134",
        description="""UE/05/0/134""",
    )

    ue_05_0_135 = VocabularyTerm(
        code="UE_05_0_135",
        label="UE/05/0/135",
        description="""UE/05/0/135""",
    )

    ue_05_0_136 = VocabularyTerm(
        code="UE_05_0_136",
        label="UE/05/0/136",
        description="""UE/05/0/136""",
    )

    ue_05_0_136b = VocabularyTerm(
        code="UE_05_0_136B",
        label="UE/05/0/136B",
        description="""UE/05/0/136B""",
    )

    ue_05_0_136f = VocabularyTerm(
        code="UE_05_0_136F",
        label="UE/05/0/136F",
        description="""UE/05/0/136F""",
    )

    ue_05_0_137 = VocabularyTerm(
        code="UE_05_0_137",
        label="UE/05/0/137",
        description="""UE/05/0/137""",
    )

    ue_05_0_a2 = VocabularyTerm(
        code="UE_05_0_A2",
        label="UE/05/0/A2",
        description="""UE/05/0/A2""",
    )

    ue_05_1a_231at = VocabularyTerm(
        code="UE_05_1A_231AT",
        label="UE/05/1A/231AT",
        description="""UE/05/1A/231AT""",
    )

    ue_05_1a_232a = VocabularyTerm(
        code="UE_05_1A_232A",
        label="UE/05/1A/232A",
        description="""UE/05/1A/232A""",
    )

    ue_05_1a_234awc = VocabularyTerm(
        code="UE_05_1A_234AWC",
        label="UE/05/1A/234AWC",
        description="""UE/05/1A/234AWC""",
    )

    ue_05_1a_235af = VocabularyTerm(
        code="UE_05_1A_235AF",
        label="UE/05/1A/235AF",
        description="""UE/05/1A/235AF""",
    )

    ue_05_1a_235at = VocabularyTerm(
        code="UE_05_1A_235AT",
        label="UE/05/1A/235AT",
        description="""UE/05/1A/235AT""",
    )

    ue_05_1a_236a = VocabularyTerm(
        code="UE_05_1A_236A",
        label="UE/05/1A/236A",
        description="""UE/05/1A/236A""",
    )

    ue_05_1a_238a = VocabularyTerm(
        code="UE_05_1A_238A",
        label="UE/05/1A/238A",
        description="""UE/05/1A/238A""",
    )

    ue_05_1_200t = VocabularyTerm(
        code="UE_05_1_200T",
        label="UE/05/1/200T",
        description="""UE/05/1/200T""",
    )

    ue_05_1_202t = VocabularyTerm(
        code="UE_05_1_202T",
        label="UE/05/1/202T",
        description="""UE/05/1/202T""",
    )

    ue_05_1_203 = VocabularyTerm(
        code="UE_05_1_203",
        label="UE/05/1/203",
        description="""UE/05/1/203""",
    )

    ue_05_1_205 = VocabularyTerm(
        code="UE_05_1_205",
        label="UE/05/1/205",
        description="""UE/05/1/205""",
    )

    ue_05_1_206 = VocabularyTerm(
        code="UE_05_1_206",
        label="UE/05/1/206",
        description="""UE/05/1/206""",
    )

    ue_05_1_207 = VocabularyTerm(
        code="UE_05_1_207",
        label="UE/05/1/207",
        description="""UE/05/1/207""",
    )

    ue_05_1_208 = VocabularyTerm(
        code="UE_05_1_208",
        label="UE/05/1/208",
        description="""UE/05/1/208""",
    )

    ue_05_1_211 = VocabularyTerm(
        code="UE_05_1_211",
        label="UE/05/1/211",
        description="""UE/05/1/211""",
    )

    ue_05_1_212 = VocabularyTerm(
        code="UE_05_1_212",
        label="UE/05/1/212",
        description="""UE/05/1/212""",
    )

    ue_05_1_213 = VocabularyTerm(
        code="UE_05_1_213",
        label="UE/05/1/213",
        description="""UE/05/1/213""",
    )

    ue_05_1_214 = VocabularyTerm(
        code="UE_05_1_214",
        label="UE/05/1/214",
        description="""UE/05/1/214""",
    )

    ue_05_1_214f = VocabularyTerm(
        code="UE_05_1_214F",
        label="UE/05/1/214F",
        description="""UE/05/1/214F""",
    )

    ue_05_1_215 = VocabularyTerm(
        code="UE_05_1_215",
        label="UE/05/1/215",
        description="""UE/05/1/215""",
    )

    ue_05_1_216 = VocabularyTerm(
        code="UE_05_1_216",
        label="UE/05/1/216",
        description="""UE/05/1/216""",
    )

    ue_05_1_216b = VocabularyTerm(
        code="UE_05_1_216B",
        label="UE/05/1/216B",
        description="""UE/05/1/216B""",
    )

    ue_05_1_218 = VocabularyTerm(
        code="UE_05_1_218",
        label="UE/05/1/218",
        description="""UE/05/1/218""",
    )

    ue_05_1_219 = VocabularyTerm(
        code="UE_05_1_219",
        label="UE/05/1/219",
        description="""UE/05/1/219""",
    )

    ue_05_1_219h = VocabularyTerm(
        code="UE_05_1_219H",
        label="UE/05/1/219H",
        description="""UE/05/1/219H""",
    )

    ue_05_1_220wc = VocabularyTerm(
        code="UE_05_1_220WC",
        label="UE/05/1/220WC",
        description="""UE/05/1/220WC""",
    )

    ue_05_1_221d = VocabularyTerm(
        code="UE_05_1_221D",
        label="UE/05/1/221D",
        description="""UE/05/1/221D""",
    )

    ue_05_1_221f = VocabularyTerm(
        code="UE_05_1_221F",
        label="UE/05/1/221F",
        description="""UE/05/1/221F""",
    )

    ue_05_1_224 = VocabularyTerm(
        code="UE_05_1_224",
        label="UE/05/1/224",
        description="""UE/05/1/224""",
    )

    ue_05_1_231 = VocabularyTerm(
        code="UE_05_1_231",
        label="UE/05/1/231",
        description="""UE/05/1/231""",
    )

    ue_05_1_231t = VocabularyTerm(
        code="UE_05_1_231T",
        label="UE/05/1/231T",
        description="""UE/05/1/231T""",
    )

    ue_05_1_233 = VocabularyTerm(
        code="UE_05_1_233",
        label="UE/05/1/233",
        description="""UE/05/1/233""",
    )

    ue_05_1_233f = VocabularyTerm(
        code="UE_05_1_233F",
        label="UE/05/1/233F",
        description="""UE/05/1/233F""",
    )

    ue_05_1_234 = VocabularyTerm(
        code="UE_05_1_234",
        label="UE/05/1/234",
        description="""UE/05/1/234""",
    )

    ue_05_1_235t = VocabularyTerm(
        code="UE_05_1_235T",
        label="UE/05/1/235T",
        description="""UE/05/1/235T""",
    )

    ue_05_1_a2 = VocabularyTerm(
        code="UE_05_1_A2",
        label="UE/05/1/A2",
        description="""UE/05/1/A2""",
    )

    ue_05__1_001 = VocabularyTerm(
        code="UE_05_-1_001",
        label="UE/05/-1/001",
        description="""UE/05/-1/001""",
    )

    ue_05__1_001h = VocabularyTerm(
        code="UE_05_-1_001H",
        label="UE/05/-1/001H",
        description="""UE/05/-1/001H""",
    )

    ue_05__1_002f = VocabularyTerm(
        code="UE_05_-1_002F",
        label="UE/05/-1/002F",
        description="""UE/05/-1/002F""",
    )

    ue_05__1_002t = VocabularyTerm(
        code="UE_05_-1_002T",
        label="UE/05/-1/002T",
        description="""UE/05/-1/002T""",
    )

    ue_05__1_005 = VocabularyTerm(
        code="UE_05_-1_005",
        label="UE/05/-1/005",
        description="""UE/05/-1/005""",
    )

    ue_05__1_006 = VocabularyTerm(
        code="UE_05_-1_006",
        label="UE/05/-1/006",
        description="""UE/05/-1/006""",
    )

    ue_05__1_007 = VocabularyTerm(
        code="UE_05_-1_007",
        label="UE/05/-1/007",
        description="""UE/05/-1/007""",
    )

    ue_05__1_008 = VocabularyTerm(
        code="UE_05_-1_008",
        label="UE/05/-1/008",
        description="""UE/05/-1/008""",
    )

    ue_05__1_009 = VocabularyTerm(
        code="UE_05_-1_009",
        label="UE/05/-1/009",
        description="""UE/05/-1/009""",
    )

    ue_05__1_010f = VocabularyTerm(
        code="UE_05_-1_010F",
        label="UE/05/-1/010F",
        description="""UE/05/-1/010F""",
    )

    ue_05__1_011 = VocabularyTerm(
        code="UE_05_-1_011",
        label="UE/05/-1/011",
        description="""UE/05/-1/011""",
    )

    ue_05__1_012 = VocabularyTerm(
        code="UE_05_-1_012",
        label="UE/05/-1/012",
        description="""UE/05/-1/012""",
    )

    ue_05__1_013 = VocabularyTerm(
        code="UE_05_-1_013",
        label="UE/05/-1/013",
        description="""UE/05/-1/013""",
    )

    ue_05__1_013b = VocabularyTerm(
        code="UE_05_-1_013B",
        label="UE/05/-1/013B",
        description="""UE/05/-1/013B""",
    )

    ue_05__1_013f = VocabularyTerm(
        code="UE_05_-1_013F",
        label="UE/05/-1/013F",
        description="""UE/05/-1/013F""",
    )

    ue_05__1_015 = VocabularyTerm(
        code="UE_05_-1_015",
        label="UE/05/-1/015",
        description="""UE/05/-1/015""",
    )

    ue_05__1_015f = VocabularyTerm(
        code="UE_05_-1_015F",
        label="UE/05/-1/015F",
        description="""UE/05/-1/015F""",
    )

    ue_05__1_017 = VocabularyTerm(
        code="UE_05_-1_017",
        label="UE/05/-1/017",
        description="""UE/05/-1/017""",
    )

    ue_05__1_018f = VocabularyTerm(
        code="UE_05_-1_018F",
        label="UE/05/-1/018F",
        description="""UE/05/-1/018F""",
    )

    ue_05__1_020 = VocabularyTerm(
        code="UE_05_-1_020",
        label="UE/05/-1/020",
        description="""UE/05/-1/020""",
    )

    ue_05__1_022t = VocabularyTerm(
        code="UE_05_-1_022T",
        label="UE/05/-1/022T",
        description="""UE/05/-1/022T""",
    )

    ue_05__1_024 = VocabularyTerm(
        code="UE_05_-1_024",
        label="UE/05/-1/024",
        description="""UE/05/-1/024""",
    )

    ue_05__1_024b = VocabularyTerm(
        code="UE_05_-1_024B",
        label="UE/05/-1/024B",
        description="""UE/05/-1/024B""",
    )

    ue_05__1_026 = VocabularyTerm(
        code="UE_05_-1_026",
        label="UE/05/-1/026",
        description="""UE/05/-1/026""",
    )

    ue_05__1_027 = VocabularyTerm(
        code="UE_05_-1_027",
        label="UE/05/-1/027",
        description="""UE/05/-1/027""",
    )

    ue_05__1_027b = VocabularyTerm(
        code="UE_05_-1_027B",
        label="UE/05/-1/027B",
        description="""UE/05/-1/027B""",
    )

    ue_05__1_031 = VocabularyTerm(
        code="UE_05_-1_031",
        label="UE/05/-1/031",
        description="""UE/05/-1/031""",
    )

    ue_05__1_031t = VocabularyTerm(
        code="UE_05_-1_031T",
        label="UE/05/-1/031T",
        description="""UE/05/-1/031T""",
    )

    ue_05__1_032 = VocabularyTerm(
        code="UE_05_-1_032",
        label="UE/05/-1/032",
        description="""UE/05/-1/032""",
    )

    ue_05__1_034 = VocabularyTerm(
        code="UE_05_-1_034",
        label="UE/05/-1/034",
        description="""UE/05/-1/034""",
    )

    ue_05__1_040 = VocabularyTerm(
        code="UE_05_-1_040",
        label="UE/05/-1/040",
        description="""UE/05/-1/040""",
    )

    ue_05__1_040b = VocabularyTerm(
        code="UE_05_-1_040B",
        label="UE/05/-1/040B",
        description="""UE/05/-1/040B""",
    )

    ue_05__1_041 = VocabularyTerm(
        code="UE_05_-1_041",
        label="UE/05/-1/041",
        description="""UE/05/-1/041""",
    )

    ue_05__1_042 = VocabularyTerm(
        code="UE_05_-1_042",
        label="UE/05/-1/042",
        description="""UE/05/-1/042""",
    )

    ue_05__1_042b = VocabularyTerm(
        code="UE_05_-1_042B",
        label="UE/05/-1/042B",
        description="""UE/05/-1/042B""",
    )

    ue_05__1_042f = VocabularyTerm(
        code="UE_05_-1_042F",
        label="UE/05/-1/042F",
        description="""UE/05/-1/042F""",
    )

    ue_05__1_043 = VocabularyTerm(
        code="UE_05_-1_043",
        label="UE/05/-1/043",
        description="""UE/05/-1/043""",
    )

    ue_05__1_043f = VocabularyTerm(
        code="UE_05_-1_043F",
        label="UE/05/-1/043F",
        description="""UE/05/-1/043F""",
    )

    ue_05__1_044 = VocabularyTerm(
        code="UE_05_-1_044",
        label="UE/05/-1/044",
        description="""UE/05/-1/044""",
    )

    ue_05__1_044d = VocabularyTerm(
        code="UE_05_-1_044D",
        label="UE/05/-1/044D",
        description="""UE/05/-1/044D""",
    )

    ue_05__1_044h = VocabularyTerm(
        code="UE_05_-1_044H",
        label="UE/05/-1/044H",
        description="""UE/05/-1/044H""",
    )

    ue_05__1_045 = VocabularyTerm(
        code="UE_05_-1_045",
        label="UE/05/-1/045",
        description="""UE/05/-1/045""",
    )

    ue_05__1_046 = VocabularyTerm(
        code="UE_05_-1_046",
        label="UE/05/-1/046",
        description="""UE/05/-1/046""",
    )

    ue_05__1_091 = VocabularyTerm(
        code="UE_05_-1_091",
        label="UE/05/-1/091",
        description="""UE/05/-1/091""",
    )

    ue_05__1_091k = VocabularyTerm(
        code="UE_05_-1_091K",
        label="UE/05/-1/091K",
        description="""UE/05/-1/091K""",
    )

    ue_05__1_093 = VocabularyTerm(
        code="UE_05_-1_093",
        label="UE/05/-1/093",
        description="""UE/05/-1/093""",
    )

    ue_05__1_a1 = VocabularyTerm(
        code="UE_05_-1_A1",
        label="UE/05/-1/A1",
        description="""UE/05/-1/A1""",
    )

    ue_05__2_0001f = VocabularyTerm(
        code="UE_05_-2_0001F",
        label="UE/05/-2/0001F",
        description="""UE/05/-2/0001F""",
    )

    ue_05__2_0002 = VocabularyTerm(
        code="UE_05_-2_0002",
        label="UE/05/-2/0002",
        description="""UE/05/-2/0002""",
    )

    ue_05__2_0002b = VocabularyTerm(
        code="UE_05_-2_0002B",
        label="UE/05/-2/0002B",
        description="""UE/05/-2/0002B""",
    )

    ue_05__2_0002f = VocabularyTerm(
        code="UE_05_-2_0002F",
        label="UE/05/-2/0002F",
        description="""UE/05/-2/0002F""",
    )

    ue_05__2_0002t = VocabularyTerm(
        code="UE_05_-2_0002T",
        label="UE/05/-2/0002T",
        description="""UE/05/-2/0002T""",
    )

    ue_05__2_0004 = VocabularyTerm(
        code="UE_05_-2_0004",
        label="UE/05/-2/0004",
        description="""UE/05/-2/0004""",
    )

    ue_05__2_0005 = VocabularyTerm(
        code="UE_05_-2_0005",
        label="UE/05/-2/0005",
        description="""UE/05/-2/0005""",
    )

    ue_05__2_0007f = VocabularyTerm(
        code="UE_05_-2_0007F",
        label="UE/05/-2/0007F",
        description="""UE/05/-2/0007F""",
    )

    ue_05__2_0009 = VocabularyTerm(
        code="UE_05_-2_0009",
        label="UE/05/-2/0009",
        description="""UE/05/-2/0009""",
    )

    ue_05__2_0011 = VocabularyTerm(
        code="UE_05_-2_0011",
        label="UE/05/-2/0011",
        description="""UE/05/-2/0011""",
    )

    ue_05__2_0011f = VocabularyTerm(
        code="UE_05_-2_0011F",
        label="UE/05/-2/0011F",
        description="""UE/05/-2/0011F""",
    )

    ue_05__2_0013 = VocabularyTerm(
        code="UE_05_-2_0013",
        label="UE/05/-2/0013",
        description="""UE/05/-2/0013""",
    )

    ue_05__2_0013b = VocabularyTerm(
        code="UE_05_-2_0013B",
        label="UE/05/-2/0013B",
        description="""UE/05/-2/0013B""",
    )

    ue_05__2_0013f = VocabularyTerm(
        code="UE_05_-2_0013F",
        label="UE/05/-2/0013F",
        description="""UE/05/-2/0013F""",
    )

    ue_05__2_0013t = VocabularyTerm(
        code="UE_05_-2_0013T",
        label="UE/05/-2/0013T",
        description="""UE/05/-2/0013T""",
    )

    ue_05__2_0014b = VocabularyTerm(
        code="UE_05_-2_0014B",
        label="UE/05/-2/0014B",
        description="""UE/05/-2/0014B""",
    )

    ue_05__2_0015b = VocabularyTerm(
        code="UE_05_-2_0015B",
        label="UE/05/-2/0015B",
        description="""UE/05/-2/0015B""",
    )

    ue_05__2_0016b = VocabularyTerm(
        code="UE_05_-2_0016B",
        label="UE/05/-2/0016B",
        description="""UE/05/-2/0016B""",
    )

    ue_05__2_0017b = VocabularyTerm(
        code="UE_05_-2_0017B",
        label="UE/05/-2/0017B",
        description="""UE/05/-2/0017B""",
    )

    ue_05__2_0017t = VocabularyTerm(
        code="UE_05_-2_0017T",
        label="UE/05/-2/0017T",
        description="""UE/05/-2/0017T""",
    )

    ue_05__2_0018b = VocabularyTerm(
        code="UE_05_-2_0018B",
        label="UE/05/-2/0018B",
        description="""UE/05/-2/0018B""",
    )

    ue_05__2_0019b = VocabularyTerm(
        code="UE_05_-2_0019B",
        label="UE/05/-2/0019B",
        description="""UE/05/-2/0019B""",
    )

    ue_05__2_0020b = VocabularyTerm(
        code="UE_05_-2_0020B",
        label="UE/05/-2/0020B",
        description="""UE/05/-2/0020B""",
    )

    ue_05__2_0021b = VocabularyTerm(
        code="UE_05_-2_0021B",
        label="UE/05/-2/0021B",
        description="""UE/05/-2/0021B""",
    )

    ue_05__2_0022b = VocabularyTerm(
        code="UE_05_-2_0022B",
        label="UE/05/-2/0022B",
        description="""UE/05/-2/0022B""",
    )

    ue_05__2_0023b = VocabularyTerm(
        code="UE_05_-2_0023B",
        label="UE/05/-2/0023B",
        description="""UE/05/-2/0023B""",
    )

    ue_05__2_0024b = VocabularyTerm(
        code="UE_05_-2_0024B",
        label="UE/05/-2/0024B",
        description="""UE/05/-2/0024B""",
    )

    ue_05__2_0027 = VocabularyTerm(
        code="UE_05_-2_0027",
        label="UE/05/-2/0027",
        description="""UE/05/-2/0027""",
    )

    ue_05__2_0027b = VocabularyTerm(
        code="UE_05_-2_0027B",
        label="UE/05/-2/0027B",
        description="""UE/05/-2/0027B""",
    )

    ue_05__2_0027f = VocabularyTerm(
        code="UE_05_-2_0027F",
        label="UE/05/-2/0027F",
        description="""UE/05/-2/0027F""",
    )

    ue_05__2_a1 = VocabularyTerm(
        code="UE_05_-2_A1",
        label="UE/05/-2/A1",
        description="""UE/05/-2/A1""",
    )

    ue_06_0_100b = VocabularyTerm(
        code="UE_06_0_100B",
        label="UE/06/0/100B",
        description="""UE/06/0/100B""",
    )

    ue_06_0_100t = VocabularyTerm(
        code="UE_06_0_100T",
        label="UE/06/0/100T",
        description="""UE/06/0/100T""",
    )

    ue_06_0_101 = VocabularyTerm(
        code="UE_06_0_101",
        label="UE/06/0/101",
        description="""UE/06/0/101""",
    )

    ue_06_0_102f = VocabularyTerm(
        code="UE_06_0_102F",
        label="UE/06/0/102F",
        description="""UE/06/0/102F""",
    )

    ue_06_0_105 = VocabularyTerm(
        code="UE_06_0_105",
        label="UE/06/0/105",
        description="""UE/06/0/105""",
    )

    ue_06_0_107 = VocabularyTerm(
        code="UE_06_0_107",
        label="UE/06/0/107",
        description="""UE/06/0/107""",
    )

    ue_06_0_109f = VocabularyTerm(
        code="UE_06_0_109F",
        label="UE/06/0/109F",
        description="""UE/06/0/109F""",
    )

    ue_06_0_110 = VocabularyTerm(
        code="UE_06_0_110",
        label="UE/06/0/110",
        description="""UE/06/0/110""",
    )

    ue_06_0_112 = VocabularyTerm(
        code="UE_06_0_112",
        label="UE/06/0/112",
        description="""UE/06/0/112""",
    )

    ue_06_0_114 = VocabularyTerm(
        code="UE_06_0_114",
        label="UE/06/0/114",
        description="""UE/06/0/114""",
    )

    ue_06_0_120 = VocabularyTerm(
        code="UE_06_0_120",
        label="UE/06/0/120",
        description="""UE/06/0/120""",
    )

    ue_06_0_122f = VocabularyTerm(
        code="UE_06_0_122F",
        label="UE/06/0/122F",
        description="""UE/06/0/122F""",
    )

    ue_06_0_125t = VocabularyTerm(
        code="UE_06_0_125T",
        label="UE/06/0/125T",
        description="""UE/06/0/125T""",
    )

    ue_06_0_a1 = VocabularyTerm(
        code="UE_06_0_A1",
        label="UE/06/0/A1",
        description="""UE/06/0/A1""",
    )

    ue_06_0_a2 = VocabularyTerm(
        code="UE_06_0_A2",
        label="UE/06/0/A2",
        description="""UE/06/0/A2""",
    )

    ue_06_1_200t = VocabularyTerm(
        code="UE_06_1_200T",
        label="UE/06/1/200T",
        description="""UE/06/1/200T""",
    )

    ue_06_1_201 = VocabularyTerm(
        code="UE_06_1_201",
        label="UE/06/1/201",
        description="""UE/06/1/201""",
    )

    ue_06_1_202 = VocabularyTerm(
        code="UE_06_1_202",
        label="UE/06/1/202",
        description="""UE/06/1/202""",
    )

    ue_06_1_204 = VocabularyTerm(
        code="UE_06_1_204",
        label="UE/06/1/204",
        description="""UE/06/1/204""",
    )

    ue_06_1_205h = VocabularyTerm(
        code="UE_06_1_205H",
        label="UE/06/1/205H",
        description="""UE/06/1/205H""",
    )

    ue_06_1_206d = VocabularyTerm(
        code="UE_06_1_206D",
        label="UE/06/1/206D",
        description="""UE/06/1/206D""",
    )

    ue_06_1_207 = VocabularyTerm(
        code="UE_06_1_207",
        label="UE/06/1/207",
        description="""UE/06/1/207""",
    )

    ue_06_1_208 = VocabularyTerm(
        code="UE_06_1_208",
        label="UE/06/1/208",
        description="""UE/06/1/208""",
    )

    ue_06_1_209 = VocabularyTerm(
        code="UE_06_1_209",
        label="UE/06/1/209",
        description="""UE/06/1/209""",
    )

    ue_06_1_210f = VocabularyTerm(
        code="UE_06_1_210F",
        label="UE/06/1/210F",
        description="""UE/06/1/210F""",
    )

    ue_06_1_211 = VocabularyTerm(
        code="UE_06_1_211",
        label="UE/06/1/211",
        description="""UE/06/1/211""",
    )

    ue_06_1_212 = VocabularyTerm(
        code="UE_06_1_212",
        label="UE/06/1/212",
        description="""UE/06/1/212""",
    )

    ue_06_1_213 = VocabularyTerm(
        code="UE_06_1_213",
        label="UE/06/1/213",
        description="""UE/06/1/213""",
    )

    ue_06_1_214 = VocabularyTerm(
        code="UE_06_1_214",
        label="UE/06/1/214",
        description="""UE/06/1/214""",
    )

    ue_06_1_215 = VocabularyTerm(
        code="UE_06_1_215",
        label="UE/06/1/215",
        description="""UE/06/1/215""",
    )

    ue_06_1_216 = VocabularyTerm(
        code="UE_06_1_216",
        label="UE/06/1/216",
        description="""UE/06/1/216""",
    )

    ue_06_1_217 = VocabularyTerm(
        code="UE_06_1_217",
        label="UE/06/1/217",
        description="""UE/06/1/217""",
    )

    ue_06_1_218 = VocabularyTerm(
        code="UE_06_1_218",
        label="UE/06/1/218",
        description="""UE/06/1/218""",
    )

    ue_06_1_219 = VocabularyTerm(
        code="UE_06_1_219",
        label="UE/06/1/219",
        description="""UE/06/1/219""",
    )

    ue_06_1_220 = VocabularyTerm(
        code="UE_06_1_220",
        label="UE/06/1/220",
        description="""UE/06/1/220""",
    )

    ue_06_1_221 = VocabularyTerm(
        code="UE_06_1_221",
        label="UE/06/1/221",
        description="""UE/06/1/221""",
    )

    ue_06_1_222f = VocabularyTerm(
        code="UE_06_1_222F",
        label="UE/06/1/222F",
        description="""UE/06/1/222F""",
    )

    ue_06_1_223h = VocabularyTerm(
        code="UE_06_1_223H",
        label="UE/06/1/223H",
        description="""UE/06/1/223H""",
    )

    ue_06_1_224d = VocabularyTerm(
        code="UE_06_1_224D",
        label="UE/06/1/224D",
        description="""UE/06/1/224D""",
    )

    ue_06_1_225t = VocabularyTerm(
        code="UE_06_1_225T",
        label="UE/06/1/225T",
        description="""UE/06/1/225T""",
    )

    ue_06_1_a1 = VocabularyTerm(
        code="UE_06_1_A1",
        label="UE/06/1/A1",
        description="""UE/06/1/A1""",
    )

    ue_06_1_a2 = VocabularyTerm(
        code="UE_06_1_A2",
        label="UE/06/1/A2",
        description="""UE/06/1/A2""",
    )

    ue_06__1_011 = VocabularyTerm(
        code="UE_06_-1_011",
        label="UE/06/-1/011",
        description="""UE/06/-1/011""",
    )

    ue_06__1_012 = VocabularyTerm(
        code="UE_06_-1_012",
        label="UE/06/-1/012",
        description="""UE/06/-1/012""",
    )

    ue_06__1_013 = VocabularyTerm(
        code="UE_06_-1_013",
        label="UE/06/-1/013",
        description="""UE/06/-1/013""",
    )

    ue_06__1_014 = VocabularyTerm(
        code="UE_06_-1_014",
        label="UE/06/-1/014",
        description="""UE/06/-1/014""",
    )

    ue_06__1_015 = VocabularyTerm(
        code="UE_06_-1_015",
        label="UE/06/-1/015",
        description="""UE/06/-1/015""",
    )

    ue_06__1_020 = VocabularyTerm(
        code="UE_06_-1_020",
        label="UE/06/-1/020",
        description="""UE/06/-1/020""",
    )

    ue_06__1_020f = VocabularyTerm(
        code="UE_06_-1_020F",
        label="UE/06/-1/020F",
        description="""UE/06/-1/020F""",
    )

    ue_06__1_022 = VocabularyTerm(
        code="UE_06_-1_022",
        label="UE/06/-1/022",
        description="""UE/06/-1/022""",
    )

    ue_06__1_022f = VocabularyTerm(
        code="UE_06_-1_022F",
        label="UE/06/-1/022F",
        description="""UE/06/-1/022F""",
    )

    ue_06__1_025t = VocabularyTerm(
        code="UE_06_-1_025T",
        label="UE/06/-1/025T",
        description="""UE/06/-1/025T""",
    )

    ue_06__1_a2 = VocabularyTerm(
        code="UE_06_-1_A2",
        label="UE/06/-1/A2",
        description="""UE/06/-1/A2""",
    )

    ue_07_0_100 = VocabularyTerm(
        code="UE_07_0_100",
        label="UE/07/0/100",
        description="""UE/07/0/100""",
    )

    ue_07_0_100f = VocabularyTerm(
        code="UE_07_0_100F",
        label="UE/07/0/100F",
        description="""UE/07/0/100F""",
    )

    ue_07_0_102 = VocabularyTerm(
        code="UE_07_0_102",
        label="UE/07/0/102",
        description="""UE/07/0/102""",
    )

    ue_07_0_103 = VocabularyTerm(
        code="UE_07_0_103",
        label="UE/07/0/103",
        description="""UE/07/0/103""",
    )

    ue_07_0_105 = VocabularyTerm(
        code="UE_07_0_105",
        label="UE/07/0/105",
        description="""UE/07/0/105""",
    )

    ue_07_0_106 = VocabularyTerm(
        code="UE_07_0_106",
        label="UE/07/0/106",
        description="""UE/07/0/106""",
    )

    ue_07_0_107 = VocabularyTerm(
        code="UE_07_0_107",
        label="UE/07/0/107",
        description="""UE/07/0/107""",
    )

    ue_07_0_108 = VocabularyTerm(
        code="UE_07_0_108",
        label="UE/07/0/108",
        description="""UE/07/0/108""",
    )

    ue_07_0_109 = VocabularyTerm(
        code="UE_07_0_109",
        label="UE/07/0/109",
        description="""UE/07/0/109""",
    )

    ue_07_0_110 = VocabularyTerm(
        code="UE_07_0_110",
        label="UE/07/0/110",
        description="""UE/07/0/110""",
    )

    ue_07_0_111 = VocabularyTerm(
        code="UE_07_0_111",
        label="UE/07/0/111",
        description="""UE/07/0/111""",
    )

    ue_07_0_111d = VocabularyTerm(
        code="UE_07_0_111D",
        label="UE/07/0/111D",
        description="""UE/07/0/111D""",
    )

    ue_07_0_111h = VocabularyTerm(
        code="UE_07_0_111H",
        label="UE/07/0/111H",
        description="""UE/07/0/111H""",
    )

    ue_07_0_112 = VocabularyTerm(
        code="UE_07_0_112",
        label="UE/07/0/112",
        description="""UE/07/0/112""",
    )

    ue_07_0_112b = VocabularyTerm(
        code="UE_07_0_112B",
        label="UE/07/0/112B",
        description="""UE/07/0/112B""",
    )

    ue_07_1_200 = VocabularyTerm(
        code="UE_07_1_200",
        label="UE/07/1/200",
        description="""UE/07/1/200""",
    )

    ue_07_1_200f = VocabularyTerm(
        code="UE_07_1_200F",
        label="UE/07/1/200F",
        description="""UE/07/1/200F""",
    )

    ue_07_1_201 = VocabularyTerm(
        code="UE_07_1_201",
        label="UE/07/1/201",
        description="""UE/07/1/201""",
    )

    ue_07_1_203 = VocabularyTerm(
        code="UE_07_1_203",
        label="UE/07/1/203",
        description="""UE/07/1/203""",
    )

    ue_07_1_204 = VocabularyTerm(
        code="UE_07_1_204",
        label="UE/07/1/204",
        description="""UE/07/1/204""",
    )

    ue_07_1_205 = VocabularyTerm(
        code="UE_07_1_205",
        label="UE/07/1/205",
        description="""UE/07/1/205""",
    )

    ue_07_1_206 = VocabularyTerm(
        code="UE_07_1_206",
        label="UE/07/1/206",
        description="""UE/07/1/206""",
    )

    ue_07_1_208 = VocabularyTerm(
        code="UE_07_1_208",
        label="UE/07/1/208",
        description="""UE/07/1/208""",
    )

    ue_07_1_209 = VocabularyTerm(
        code="UE_07_1_209",
        label="UE/07/1/209",
        description="""UE/07/1/209""",
    )

    ue_07_1_211 = VocabularyTerm(
        code="UE_07_1_211",
        label="UE/07/1/211",
        description="""UE/07/1/211""",
    )

    ue_07_1_212 = VocabularyTerm(
        code="UE_07_1_212",
        label="UE/07/1/212",
        description="""UE/07/1/212""",
    )

    ue_07_1_212b = VocabularyTerm(
        code="UE_07_1_212B",
        label="UE/07/1/212B",
        description="""UE/07/1/212B""",
    )

    ue_07_1_213 = VocabularyTerm(
        code="UE_07_1_213",
        label="UE/07/1/213",
        description="""UE/07/1/213""",
    )

    ue_07_1_213d = VocabularyTerm(
        code="UE_07_1_213D",
        label="UE/07/1/213D",
        description="""UE/07/1/213D""",
    )

    ue_07_1_213h = VocabularyTerm(
        code="UE_07_1_213H",
        label="UE/07/1/213H",
        description="""UE/07/1/213H""",
    )

    ue_08_0_101 = VocabularyTerm(
        code="UE_08_0_101",
        label="UE/08/0/101",
        description="""UE/08/0/101""",
    )

    ue_08_0_102 = VocabularyTerm(
        code="UE_08_0_102",
        label="UE/08/0/102",
        description="""UE/08/0/102""",
    )

    ue_08_0_103 = VocabularyTerm(
        code="UE_08_0_103",
        label="UE/08/0/103",
        description="""UE/08/0/103""",
    )

    ue_08_0_104 = VocabularyTerm(
        code="UE_08_0_104",
        label="UE/08/0/104",
        description="""UE/08/0/104""",
    )

    ue_08_0_105f = VocabularyTerm(
        code="UE_08_0_105F",
        label="UE/08/0/105F",
        description="""UE/08/0/105F""",
    )

    ue_08_0_106 = VocabularyTerm(
        code="UE_08_0_106",
        label="UE/08/0/106",
        description="""UE/08/0/106""",
    )

    ue_08_0_106t = VocabularyTerm(
        code="UE_08_0_106T",
        label="UE/08/0/106T",
        description="""UE/08/0/106T""",
    )

    ue_08_0_107 = VocabularyTerm(
        code="UE_08_0_107",
        label="UE/08/0/107",
        description="""UE/08/0/107""",
    )

    ue_08_0_107f = VocabularyTerm(
        code="UE_08_0_107F",
        label="UE/08/0/107F",
        description="""UE/08/0/107F""",
    )

    ue_08_0_108 = VocabularyTerm(
        code="UE_08_0_108",
        label="UE/08/0/108",
        description="""UE/08/0/108""",
    )

    ue_08_0_109d = VocabularyTerm(
        code="UE_08_0_109D",
        label="UE/08/0/109D",
        description="""UE/08/0/109D""",
    )

    ue_08_0_109f = VocabularyTerm(
        code="UE_08_0_109F",
        label="UE/08/0/109F",
        description="""UE/08/0/109F""",
    )

    ue_08_0_109h = VocabularyTerm(
        code="UE_08_0_109H",
        label="UE/08/0/109H",
        description="""UE/08/0/109H""",
    )

    ue_08_0_109wc = VocabularyTerm(
        code="UE_08_0_109WC",
        label="UE/08/0/109WC",
        description="""UE/08/0/109WC""",
    )

    ue_08_0_110 = VocabularyTerm(
        code="UE_08_0_110",
        label="UE/08/0/110",
        description="""UE/08/0/110""",
    )

    ue_08_0_111f = VocabularyTerm(
        code="UE_08_0_111F",
        label="UE/08/0/111F",
        description="""UE/08/0/111F""",
    )

    ue_08_0_112 = VocabularyTerm(
        code="UE_08_0_112",
        label="UE/08/0/112",
        description="""UE/08/0/112""",
    )

    ue_08_0_113 = VocabularyTerm(
        code="UE_08_0_113",
        label="UE/08/0/113",
        description="""UE/08/0/113""",
    )

    ue_08_0_114 = VocabularyTerm(
        code="UE_08_0_114",
        label="UE/08/0/114",
        description="""UE/08/0/114""",
    )

    ue_08_0_115 = VocabularyTerm(
        code="UE_08_0_115",
        label="UE/08/0/115",
        description="""UE/08/0/115""",
    )

    ue_08_0_116 = VocabularyTerm(
        code="UE_08_0_116",
        label="UE/08/0/116",
        description="""UE/08/0/116""",
    )

    ue_08_0_117 = VocabularyTerm(
        code="UE_08_0_117",
        label="UE/08/0/117",
        description="""UE/08/0/117""",
    )

    ue_08_0_118 = VocabularyTerm(
        code="UE_08_0_118",
        label="UE/08/0/118",
        description="""UE/08/0/118""",
    )

    ue_08_0_119 = VocabularyTerm(
        code="UE_08_0_119",
        label="UE/08/0/119",
        description="""UE/08/0/119""",
    )

    ue_08_0_a1 = VocabularyTerm(
        code="UE_08_0_A1",
        label="UE/08/0/A1",
        description="""UE/08/0/A1""",
    )

    ue_08__1_001 = VocabularyTerm(
        code="UE_08_-1_001",
        label="UE/08/-1/001",
        description="""UE/08/-1/001""",
    )

    ue_08__1_001t = VocabularyTerm(
        code="UE_08_-1_001T",
        label="UE/08/-1/001T",
        description="""UE/08/-1/001T""",
    )

    ue_08__1_006 = VocabularyTerm(
        code="UE_08_-1_006",
        label="UE/08/-1/006",
        description="""UE/08/-1/006""",
    )

    ue_08__1_006h = VocabularyTerm(
        code="UE_08_-1_006H",
        label="UE/08/-1/006H",
        description="""UE/08/-1/006H""",
    )

    ue_08__1_006t = VocabularyTerm(
        code="UE_08_-1_006T",
        label="UE/08/-1/006T",
        description="""UE/08/-1/006T""",
    )

    ue_08__1_008 = VocabularyTerm(
        code="UE_08_-1_008",
        label="UE/08/-1/008",
        description="""UE/08/-1/008""",
    )

    ue_08__1_008d = VocabularyTerm(
        code="UE_08_-1_008D",
        label="UE/08/-1/008D",
        description="""UE/08/-1/008D""",
    )

    ue_08__1_011 = VocabularyTerm(
        code="UE_08_-1_011",
        label="UE/08/-1/011",
        description="""UE/08/-1/011""",
    )

    ue_08__1_012 = VocabularyTerm(
        code="UE_08_-1_012",
        label="UE/08/-1/012",
        description="""UE/08/-1/012""",
    )

    ue_08__1_013 = VocabularyTerm(
        code="UE_08_-1_013",
        label="UE/08/-1/013",
        description="""UE/08/-1/013""",
    )

    ue_08__1_015 = VocabularyTerm(
        code="UE_08_-1_015",
        label="UE/08/-1/015",
        description="""UE/08/-1/015""",
    )

    ue_08__1_016 = VocabularyTerm(
        code="UE_08_-1_016",
        label="UE/08/-1/016",
        description="""UE/08/-1/016""",
    )

    ue_08__1_017 = VocabularyTerm(
        code="UE_08_-1_017",
        label="UE/08/-1/017",
        description="""UE/08/-1/017""",
    )

    ue_08__1_018 = VocabularyTerm(
        code="UE_08_-1_018",
        label="UE/08/-1/018",
        description="""UE/08/-1/018""",
    )

    ue_08__1_019 = VocabularyTerm(
        code="UE_08_-1_019",
        label="UE/08/-1/019",
        description="""UE/08/-1/019""",
    )

    ue_08__1_019t = VocabularyTerm(
        code="UE_08_-1_019T",
        label="UE/08/-1/019T",
        description="""UE/08/-1/019T""",
    )

    ue_08__1_a1 = VocabularyTerm(
        code="UE_08_-1_A1",
        label="UE/08/-1/A1",
        description="""UE/08/-1/A1""",
    )

    ue_09__1_001 = VocabularyTerm(
        code="UE_09_-1_001",
        label="UE/09/-1/001",
        description="""UE/09/-1/001""",
    )

    ue_09__1_002 = VocabularyTerm(
        code="UE_09_-1_002",
        label="UE/09/-1/002",
        description="""UE/09/-1/002""",
    )

    ue_09__1_003 = VocabularyTerm(
        code="UE_09_-1_003",
        label="UE/09/-1/003",
        description="""UE/09/-1/003""",
    )

    ue_10_0_116 = VocabularyTerm(
        code="UE_10_0_116",
        label="UE/10/0/116",
        description="""UE/10/0/116""",
    )

    ue_10_0_117 = VocabularyTerm(
        code="UE_10_0_117",
        label="UE/10/0/117",
        description="""UE/10/0/117""",
    )

    ue_10_0_118 = VocabularyTerm(
        code="UE_10_0_118",
        label="UE/10/0/118",
        description="""UE/10/0/118""",
    )

    ue_10_0_119 = VocabularyTerm(
        code="UE_10_0_119",
        label="UE/10/0/119",
        description="""UE/10/0/119""",
    )

    ue_10_0_119b = VocabularyTerm(
        code="UE_10_0_119B",
        label="UE/10/0/119B",
        description="""UE/10/0/119B""",
    )

    ue_10_0_120 = VocabularyTerm(
        code="UE_10_0_120",
        label="UE/10/0/120",
        description="""UE/10/0/120""",
    )

    ue_10_0_121 = VocabularyTerm(
        code="UE_10_0_121",
        label="UE/10/0/121",
        description="""UE/10/0/121""",
    )

    ue_10_0_122 = VocabularyTerm(
        code="UE_10_0_122",
        label="UE/10/0/122",
        description="""UE/10/0/122""",
    )

    ue_10_0_123 = VocabularyTerm(
        code="UE_10_0_123",
        label="UE/10/0/123",
        description="""UE/10/0/123""",
    )

    ue_10_0_124 = VocabularyTerm(
        code="UE_10_0_124",
        label="UE/10/0/124",
        description="""UE/10/0/124""",
    )

    ue_10_0_124f = VocabularyTerm(
        code="UE_10_0_124F",
        label="UE/10/0/124F",
        description="""UE/10/0/124F""",
    )

    ue_10_0_124t = VocabularyTerm(
        code="UE_10_0_124T",
        label="UE/10/0/124T",
        description="""UE/10/0/124T""",
    )

    ue_10_0_125 = VocabularyTerm(
        code="UE_10_0_125",
        label="UE/10/0/125",
        description="""UE/10/0/125""",
    )

    ue_10_0_126 = VocabularyTerm(
        code="UE_10_0_126",
        label="UE/10/0/126",
        description="""UE/10/0/126""",
    )

    ue_10_0_128 = VocabularyTerm(
        code="UE_10_0_128",
        label="UE/10/0/128",
        description="""UE/10/0/128""",
    )

    ue_10_0_129 = VocabularyTerm(
        code="UE_10_0_129",
        label="UE/10/0/129",
        description="""UE/10/0/129""",
    )

    ue_10_0_129b = VocabularyTerm(
        code="UE_10_0_129B",
        label="UE/10/0/129B",
        description="""UE/10/0/129B""",
    )

    ue_10_0_130 = VocabularyTerm(
        code="UE_10_0_130",
        label="UE/10/0/130",
        description="""UE/10/0/130""",
    )

    ue_10_0_131 = VocabularyTerm(
        code="UE_10_0_131",
        label="UE/10/0/131",
        description="""UE/10/0/131""",
    )

    ue_10_0_131b = VocabularyTerm(
        code="UE_10_0_131B",
        label="UE/10/0/131B",
        description="""UE/10/0/131B""",
    )

    ue_10_0_131f = VocabularyTerm(
        code="UE_10_0_131F",
        label="UE/10/0/131F",
        description="""UE/10/0/131F""",
    )

    ue_10_0_132 = VocabularyTerm(
        code="UE_10_0_132",
        label="UE/10/0/132",
        description="""UE/10/0/132""",
    )

    ue_10_0_133 = VocabularyTerm(
        code="UE_10_0_133",
        label="UE/10/0/133",
        description="""UE/10/0/133""",
    )

    ue_10_0_134 = VocabularyTerm(
        code="UE_10_0_134",
        label="UE/10/0/134",
        description="""UE/10/0/134""",
    )

    ue_10_0_135 = VocabularyTerm(
        code="UE_10_0_135",
        label="UE/10/0/135",
        description="""UE/10/0/135""",
    )

    ue_10_0_137 = VocabularyTerm(
        code="UE_10_0_137",
        label="UE/10/0/137",
        description="""UE/10/0/137""",
    )

    ue_10_0_141 = VocabularyTerm(
        code="UE_10_0_141",
        label="UE/10/0/141",
        description="""UE/10/0/141""",
    )

    ue_10_0_150 = VocabularyTerm(
        code="UE_10_0_150",
        label="UE/10/0/150",
        description="""UE/10/0/150""",
    )

    ue_10_0_150t = VocabularyTerm(
        code="UE_10_0_150T",
        label="UE/10/0/150T",
        description="""UE/10/0/150T""",
    )

    ue_10_0_a1 = VocabularyTerm(
        code="UE_10_0_A1",
        label="UE/10/0/A1",
        description="""UE/10/0/A1""",
    )

    ue_10_1a_131a = VocabularyTerm(
        code="UE_10_1A_131A",
        label="UE/10/1A/131A",
        description="""UE/10/1A/131A""",
    )

    ue_10_1a_132a = VocabularyTerm(
        code="UE_10_1A_132A",
        label="UE/10/1A/132A",
        description="""UE/10/1A/132A""",
    )

    ue_10_1a_135a = VocabularyTerm(
        code="UE_10_1A_135A",
        label="UE/10/1A/135A",
        description="""UE/10/1A/135A""",
    )

    ue_10_1a_150ad = VocabularyTerm(
        code="UE_10_1A_150AD",
        label="UE/10/1A/150AD",
        description="""UE/10/1A/150AD""",
    )

    ue_10_1a_150at = VocabularyTerm(
        code="UE_10_1A_150AT",
        label="UE/10/1A/150AT",
        description="""UE/10/1A/150AT""",
    )

    ue_10_1_216 = VocabularyTerm(
        code="UE_10_1_216",
        label="UE/10/1/216",
        description="""UE/10/1/216""",
    )

    ue_10_1_216b = VocabularyTerm(
        code="UE_10_1_216B",
        label="UE/10/1/216B",
        description="""UE/10/1/216B""",
    )

    ue_10_1_217 = VocabularyTerm(
        code="UE_10_1_217",
        label="UE/10/1/217",
        description="""UE/10/1/217""",
    )

    ue_10_1_218 = VocabularyTerm(
        code="UE_10_1_218",
        label="UE/10/1/218",
        description="""UE/10/1/218""",
    )

    ue_10_1_219 = VocabularyTerm(
        code="UE_10_1_219",
        label="UE/10/1/219",
        description="""UE/10/1/219""",
    )

    ue_10_1_219b = VocabularyTerm(
        code="UE_10_1_219B",
        label="UE/10/1/219B",
        description="""UE/10/1/219B""",
    )

    ue_10_1_221 = VocabularyTerm(
        code="UE_10_1_221",
        label="UE/10/1/221",
        description="""UE/10/1/221""",
    )

    ue_10_1_222 = VocabularyTerm(
        code="UE_10_1_222",
        label="UE/10/1/222",
        description="""UE/10/1/222""",
    )

    ue_10_1_223 = VocabularyTerm(
        code="UE_10_1_223",
        label="UE/10/1/223",
        description="""UE/10/1/223""",
    )

    ue_10_1_223b = VocabularyTerm(
        code="UE_10_1_223B",
        label="UE/10/1/223B",
        description="""UE/10/1/223B""",
    )

    ue_10_1_224 = VocabularyTerm(
        code="UE_10_1_224",
        label="UE/10/1/224",
        description="""UE/10/1/224""",
    )

    ue_10_1_224f = VocabularyTerm(
        code="UE_10_1_224F",
        label="UE/10/1/224F",
        description="""UE/10/1/224F""",
    )

    ue_10_1_224t = VocabularyTerm(
        code="UE_10_1_224T",
        label="UE/10/1/224T",
        description="""UE/10/1/224T""",
    )

    ue_10_1_225 = VocabularyTerm(
        code="UE_10_1_225",
        label="UE/10/1/225",
        description="""UE/10/1/225""",
    )

    ue_10_1_225b = VocabularyTerm(
        code="UE_10_1_225B",
        label="UE/10/1/225B",
        description="""UE/10/1/225B""",
    )

    ue_10_1_227 = VocabularyTerm(
        code="UE_10_1_227",
        label="UE/10/1/227",
        description="""UE/10/1/227""",
    )

    ue_10_1_228 = VocabularyTerm(
        code="UE_10_1_228",
        label="UE/10/1/228",
        description="""UE/10/1/228""",
    )

    ue_10_1_229 = VocabularyTerm(
        code="UE_10_1_229",
        label="UE/10/1/229",
        description="""UE/10/1/229""",
    )

    ue_10_1_231 = VocabularyTerm(
        code="UE_10_1_231",
        label="UE/10/1/231",
        description="""UE/10/1/231""",
    )

    ue_10_1_232 = VocabularyTerm(
        code="UE_10_1_232",
        label="UE/10/1/232",
        description="""UE/10/1/232""",
    )

    ue_10_1_232b = VocabularyTerm(
        code="UE_10_1_232B",
        label="UE/10/1/232B",
        description="""UE/10/1/232B""",
    )

    ue_10_1_232f = VocabularyTerm(
        code="UE_10_1_232F",
        label="UE/10/1/232F",
        description="""UE/10/1/232F""",
    )

    ue_10_1_233b = VocabularyTerm(
        code="UE_10_1_233B",
        label="UE/10/1/233B",
        description="""UE/10/1/233B""",
    )

    ue_10_1_234 = VocabularyTerm(
        code="UE_10_1_234",
        label="UE/10/1/234",
        description="""UE/10/1/234""",
    )

    ue_10_1_234b = VocabularyTerm(
        code="UE_10_1_234B",
        label="UE/10/1/234B",
        description="""UE/10/1/234B""",
    )

    ue_10_1_234c = VocabularyTerm(
        code="UE_10_1_234C",
        label="UE/10/1/234C",
        description="""UE/10/1/234C""",
    )

    ue_10_1_235 = VocabularyTerm(
        code="UE_10_1_235",
        label="UE/10/1/235",
        description="""UE/10/1/235""",
    )

    ue_10_1_236 = VocabularyTerm(
        code="UE_10_1_236",
        label="UE/10/1/236",
        description="""UE/10/1/236""",
    )

    ue_10_1_237 = VocabularyTerm(
        code="UE_10_1_237",
        label="UE/10/1/237",
        description="""UE/10/1/237""",
    )

    ue_10_1_238 = VocabularyTerm(
        code="UE_10_1_238",
        label="UE/10/1/238",
        description="""UE/10/1/238""",
    )

    ue_10_1_239 = VocabularyTerm(
        code="UE_10_1_239",
        label="UE/10/1/239",
        description="""UE/10/1/239""",
    )

    ue_10_1_240 = VocabularyTerm(
        code="UE_10_1_240",
        label="UE/10/1/240",
        description="""UE/10/1/240""",
    )

    ue_10_1_240b = VocabularyTerm(
        code="UE_10_1_240B",
        label="UE/10/1/240B",
        description="""UE/10/1/240B""",
    )

    ue_10_1_241 = VocabularyTerm(
        code="UE_10_1_241",
        label="UE/10/1/241",
        description="""UE/10/1/241""",
    )

    ue_10_1_242 = VocabularyTerm(
        code="UE_10_1_242",
        label="UE/10/1/242",
        description="""UE/10/1/242""",
    )

    ue_10_1_243 = VocabularyTerm(
        code="UE_10_1_243",
        label="UE/10/1/243",
        description="""UE/10/1/243""",
    )

    ue_10_1_244 = VocabularyTerm(
        code="UE_10_1_244",
        label="UE/10/1/244",
        description="""UE/10/1/244""",
    )

    ue_10_1_245 = VocabularyTerm(
        code="UE_10_1_245",
        label="UE/10/1/245",
        description="""UE/10/1/245""",
    )

    ue_10_1_247 = VocabularyTerm(
        code="UE_10_1_247",
        label="UE/10/1/247",
        description="""UE/10/1/247""",
    )

    ue_10_1_249 = VocabularyTerm(
        code="UE_10_1_249",
        label="UE/10/1/249",
        description="""UE/10/1/249""",
    )

    ue_10_1_250d = VocabularyTerm(
        code="UE_10_1_250D",
        label="UE/10/1/250D",
        description="""UE/10/1/250D""",
    )

    ue_10_1_250t = VocabularyTerm(
        code="UE_10_1_250T",
        label="UE/10/1/250T",
        description="""UE/10/1/250T""",
    )

    ue_10_1_a1 = VocabularyTerm(
        code="UE_10_1_A1",
        label="UE/10/1/A1",
        description="""UE/10/1/A1""",
    )

    ue_10_2_316 = VocabularyTerm(
        code="UE_10_2_316",
        label="UE/10/2/316",
        description="""UE/10/2/316""",
    )

    ue_10_2_316b = VocabularyTerm(
        code="UE_10_2_316B",
        label="UE/10/2/316B",
        description="""UE/10/2/316B""",
    )

    ue_10_2_318 = VocabularyTerm(
        code="UE_10_2_318",
        label="UE/10/2/318",
        description="""UE/10/2/318""",
    )

    ue_10_2_319 = VocabularyTerm(
        code="UE_10_2_319",
        label="UE/10/2/319",
        description="""UE/10/2/319""",
    )

    ue_10_2_319b = VocabularyTerm(
        code="UE_10_2_319B",
        label="UE/10/2/319B",
        description="""UE/10/2/319B""",
    )

    ue_10_2_320 = VocabularyTerm(
        code="UE_10_2_320",
        label="UE/10/2/320",
        description="""UE/10/2/320""",
    )

    ue_10_2_321 = VocabularyTerm(
        code="UE_10_2_321",
        label="UE/10/2/321",
        description="""UE/10/2/321""",
    )

    ue_10_2_321b = VocabularyTerm(
        code="UE_10_2_321B",
        label="UE/10/2/321B",
        description="""UE/10/2/321B""",
    )

    ue_10_2_322 = VocabularyTerm(
        code="UE_10_2_322",
        label="UE/10/2/322",
        description="""UE/10/2/322""",
    )

    ue_10_2_323 = VocabularyTerm(
        code="UE_10_2_323",
        label="UE/10/2/323",
        description="""UE/10/2/323""",
    )

    ue_10_2_323b = VocabularyTerm(
        code="UE_10_2_323B",
        label="UE/10/2/323B",
        description="""UE/10/2/323B""",
    )

    ue_10_2_324 = VocabularyTerm(
        code="UE_10_2_324",
        label="UE/10/2/324",
        description="""UE/10/2/324""",
    )

    ue_10_2_324f = VocabularyTerm(
        code="UE_10_2_324F",
        label="UE/10/2/324F",
        description="""UE/10/2/324F""",
    )

    ue_10_2_324t = VocabularyTerm(
        code="UE_10_2_324T",
        label="UE/10/2/324T",
        description="""UE/10/2/324T""",
    )

    ue_10_2_325 = VocabularyTerm(
        code="UE_10_2_325",
        label="UE/10/2/325",
        description="""UE/10/2/325""",
    )

    ue_10_2_325b = VocabularyTerm(
        code="UE_10_2_325B",
        label="UE/10/2/325B",
        description="""UE/10/2/325B""",
    )

    ue_10_2_326 = VocabularyTerm(
        code="UE_10_2_326",
        label="UE/10/2/326",
        description="""UE/10/2/326""",
    )

    ue_10_2_326wc = VocabularyTerm(
        code="UE_10_2_326WC",
        label="UE/10/2/326WC",
        description="""UE/10/2/326WC""",
    )

    ue_10_2_328 = VocabularyTerm(
        code="UE_10_2_328",
        label="UE/10/2/328",
        description="""UE/10/2/328""",
    )

    ue_10_2_329 = VocabularyTerm(
        code="UE_10_2_329",
        label="UE/10/2/329",
        description="""UE/10/2/329""",
    )

    ue_10_2_330 = VocabularyTerm(
        code="UE_10_2_330",
        label="UE/10/2/330",
        description="""UE/10/2/330""",
    )

    ue_10_2_331 = VocabularyTerm(
        code="UE_10_2_331",
        label="UE/10/2/331",
        description="""UE/10/2/331""",
    )

    ue_10_2_331b = VocabularyTerm(
        code="UE_10_2_331B",
        label="UE/10/2/331B",
        description="""UE/10/2/331B""",
    )

    ue_10_2_332 = VocabularyTerm(
        code="UE_10_2_332",
        label="UE/10/2/332",
        description="""UE/10/2/332""",
    )

    ue_10_2_332f = VocabularyTerm(
        code="UE_10_2_332F",
        label="UE/10/2/332F",
        description="""UE/10/2/332F""",
    )

    ue_10_2_333 = VocabularyTerm(
        code="UE_10_2_333",
        label="UE/10/2/333",
        description="""UE/10/2/333""",
    )

    ue_10_2_334 = VocabularyTerm(
        code="UE_10_2_334",
        label="UE/10/2/334",
        description="""UE/10/2/334""",
    )

    ue_10_2_334b = VocabularyTerm(
        code="UE_10_2_334B",
        label="UE/10/2/334B",
        description="""UE/10/2/334B""",
    )

    ue_10_2_335 = VocabularyTerm(
        code="UE_10_2_335",
        label="UE/10/2/335",
        description="""UE/10/2/335""",
    )

    ue_10_2_336 = VocabularyTerm(
        code="UE_10_2_336",
        label="UE/10/2/336",
        description="""UE/10/2/336""",
    )

    ue_10_2_337 = VocabularyTerm(
        code="UE_10_2_337",
        label="UE/10/2/337",
        description="""UE/10/2/337""",
    )

    ue_10_2_338 = VocabularyTerm(
        code="UE_10_2_338",
        label="UE/10/2/338",
        description="""UE/10/2/338""",
    )

    ue_10_2_339 = VocabularyTerm(
        code="UE_10_2_339",
        label="UE/10/2/339",
        description="""UE/10/2/339""",
    )

    ue_10_2_340 = VocabularyTerm(
        code="UE_10_2_340",
        label="UE/10/2/340",
        description="""UE/10/2/340""",
    )

    ue_10_2_341 = VocabularyTerm(
        code="UE_10_2_341",
        label="UE/10/2/341",
        description="""UE/10/2/341""",
    )

    ue_10_2_342 = VocabularyTerm(
        code="UE_10_2_342",
        label="UE/10/2/342",
        description="""UE/10/2/342""",
    )

    ue_10_2_343 = VocabularyTerm(
        code="UE_10_2_343",
        label="UE/10/2/343",
        description="""UE/10/2/343""",
    )

    ue_10_2_344 = VocabularyTerm(
        code="UE_10_2_344",
        label="UE/10/2/344",
        description="""UE/10/2/344""",
    )

    ue_10_2_345 = VocabularyTerm(
        code="UE_10_2_345",
        label="UE/10/2/345",
        description="""UE/10/2/345""",
    )

    ue_10_2_346 = VocabularyTerm(
        code="UE_10_2_346",
        label="UE/10/2/346",
        description="""UE/10/2/346""",
    )

    ue_10_2_346b = VocabularyTerm(
        code="UE_10_2_346B",
        label="UE/10/2/346B",
        description="""UE/10/2/346B""",
    )

    ue_10_2_347 = VocabularyTerm(
        code="UE_10_2_347",
        label="UE/10/2/347",
        description="""UE/10/2/347""",
    )

    ue_10_2_349 = VocabularyTerm(
        code="UE_10_2_349",
        label="UE/10/2/349",
        description="""UE/10/2/349""",
    )

    ue_10_2_350h = VocabularyTerm(
        code="UE_10_2_350H",
        label="UE/10/2/350H",
        description="""UE/10/2/350H""",
    )

    ue_10_2_350t = VocabularyTerm(
        code="UE_10_2_350T",
        label="UE/10/2/350T",
        description="""UE/10/2/350T""",
    )

    ue_10_2_a1 = VocabularyTerm(
        code="UE_10_2_A1",
        label="UE/10/2/A1",
        description="""UE/10/2/A1""",
    )

    ue_10_3_424 = VocabularyTerm(
        code="UE_10_3_424",
        label="UE/10/3/424",
        description="""UE/10/3/424""",
    )

    ue_10_3_424b = VocabularyTerm(
        code="UE_10_3_424B",
        label="UE/10/3/424B",
        description="""UE/10/3/424B""",
    )

    ue_10_3_424t = VocabularyTerm(
        code="UE_10_3_424T",
        label="UE/10/3/424T",
        description="""UE/10/3/424T""",
    )

    ue_10__1_017 = VocabularyTerm(
        code="UE_10_-1_017",
        label="UE/10/-1/017",
        description="""UE/10/-1/017""",
    )

    ue_10__1_018 = VocabularyTerm(
        code="UE_10_-1_018",
        label="UE/10/-1/018",
        description="""UE/10/-1/018""",
    )

    ue_10__1_019 = VocabularyTerm(
        code="UE_10_-1_019",
        label="UE/10/-1/019",
        description="""UE/10/-1/019""",
    )

    ue_10__1_020 = VocabularyTerm(
        code="UE_10_-1_020",
        label="UE/10/-1/020",
        description="""UE/10/-1/020""",
    )

    ue_10__1_021 = VocabularyTerm(
        code="UE_10_-1_021",
        label="UE/10/-1/021",
        description="""UE/10/-1/021""",
    )

    ue_10__1_021b = VocabularyTerm(
        code="UE_10_-1_021B",
        label="UE/10/-1/021B",
        description="""UE/10/-1/021B""",
    )

    ue_10__1_023 = VocabularyTerm(
        code="UE_10_-1_023",
        label="UE/10/-1/023",
        description="""UE/10/-1/023""",
    )

    ue_10__1_023b = VocabularyTerm(
        code="UE_10_-1_023B",
        label="UE/10/-1/023B",
        description="""UE/10/-1/023B""",
    )

    ue_10__1_023f = VocabularyTerm(
        code="UE_10_-1_023F",
        label="UE/10/-1/023F",
        description="""UE/10/-1/023F""",
    )

    ue_10__1_024 = VocabularyTerm(
        code="UE_10_-1_024",
        label="UE/10/-1/024",
        description="""UE/10/-1/024""",
    )

    ue_10__1_024b = VocabularyTerm(
        code="UE_10_-1_024B",
        label="UE/10/-1/024B",
        description="""UE/10/-1/024B""",
    )

    ue_10__1_024f = VocabularyTerm(
        code="UE_10_-1_024F",
        label="UE/10/-1/024F",
        description="""UE/10/-1/024F""",
    )

    ue_10__1_024t = VocabularyTerm(
        code="UE_10_-1_024T",
        label="UE/10/-1/024T",
        description="""UE/10/-1/024T""",
    )

    ue_10__1_024tb = VocabularyTerm(
        code="UE_10_-1_024TB",
        label="UE/10/-1/024TB",
        description="""UE/10/-1/024TB""",
    )

    ue_10__1_025f = VocabularyTerm(
        code="UE_10_-1_025F",
        label="UE/10/-1/025F",
        description="""UE/10/-1/025F""",
    )

    ue_10__1_026 = VocabularyTerm(
        code="UE_10_-1_026",
        label="UE/10/-1/026",
        description="""UE/10/-1/026""",
    )

    ue_10__1_027 = VocabularyTerm(
        code="UE_10_-1_027",
        label="UE/10/-1/027",
        description="""UE/10/-1/027""",
    )

    ue_10__1_028 = VocabularyTerm(
        code="UE_10_-1_028",
        label="UE/10/-1/028",
        description="""UE/10/-1/028""",
    )

    ue_10__1_029b = VocabularyTerm(
        code="UE_10_-1_029B",
        label="UE/10/-1/029B",
        description="""UE/10/-1/029B""",
    )

    ue_10__1_031 = VocabularyTerm(
        code="UE_10_-1_031",
        label="UE/10/-1/031",
        description="""UE/10/-1/031""",
    )

    ue_10__1_032 = VocabularyTerm(
        code="UE_10_-1_032",
        label="UE/10/-1/032",
        description="""UE/10/-1/032""",
    )

    ue_10__1_032f = VocabularyTerm(
        code="UE_10_-1_032F",
        label="UE/10/-1/032F",
        description="""UE/10/-1/032F""",
    )

    ue_10__1_033 = VocabularyTerm(
        code="UE_10_-1_033",
        label="UE/10/-1/033",
        description="""UE/10/-1/033""",
    )

    ue_10__1_035 = VocabularyTerm(
        code="UE_10_-1_035",
        label="UE/10/-1/035",
        description="""UE/10/-1/035""",
    )

    ue_10__1_035b = VocabularyTerm(
        code="UE_10_-1_035B",
        label="UE/10/-1/035B",
        description="""UE/10/-1/035B""",
    )

    ue_10__1_036 = VocabularyTerm(
        code="UE_10_-1_036",
        label="UE/10/-1/036",
        description="""UE/10/-1/036""",
    )

    ue_10__1_036b = VocabularyTerm(
        code="UE_10_-1_036B",
        label="UE/10/-1/036B",
        description="""UE/10/-1/036B""",
    )

    ue_10__1_037 = VocabularyTerm(
        code="UE_10_-1_037",
        label="UE/10/-1/037",
        description="""UE/10/-1/037""",
    )

    ue_10__1_039 = VocabularyTerm(
        code="UE_10_-1_039",
        label="UE/10/-1/039",
        description="""UE/10/-1/039""",
    )

    ue_10__1_041 = VocabularyTerm(
        code="UE_10_-1_041",
        label="UE/10/-1/041",
        description="""UE/10/-1/041""",
    )

    ue_10__1_041t = VocabularyTerm(
        code="UE_10_-1_041T",
        label="UE/10/-1/041T",
        description="""UE/10/-1/041T""",
    )

    ue_10__1_042 = VocabularyTerm(
        code="UE_10_-1_042",
        label="UE/10/-1/042",
        description="""UE/10/-1/042""",
    )

    ue_10__1_042f = VocabularyTerm(
        code="UE_10_-1_042F",
        label="UE/10/-1/042F",
        description="""UE/10/-1/042F""",
    )

    ue_10__1_043 = VocabularyTerm(
        code="UE_10_-1_043",
        label="UE/10/-1/043",
        description="""UE/10/-1/043""",
    )

    ue_10__1_a1 = VocabularyTerm(
        code="UE_10_-1_A1",
        label="UE/10/-1/A1",
        description="""UE/10/-1/A1""",
    )

    ue_12_0_100 = VocabularyTerm(
        code="UE_12_0_100",
        label="UE/12/0/100",
        description="""UE/12/0/100""",
    )

    ue_12_0_101f = VocabularyTerm(
        code="UE_12_0_101F",
        label="UE/12/0/101F",
        description="""UE/12/0/101F""",
    )

    ue_12_0_102 = VocabularyTerm(
        code="UE_12_0_102",
        label="UE/12/0/102",
        description="""UE/12/0/102""",
    )

    ue_12_0_105 = VocabularyTerm(
        code="UE_12_0_105",
        label="UE/12/0/105",
        description="""UE/12/0/105""",
    )

    ue_12_0_107 = VocabularyTerm(
        code="UE_12_0_107",
        label="UE/12/0/107",
        description="""UE/12/0/107""",
    )

    ue_12_0_109 = VocabularyTerm(
        code="UE_12_0_109",
        label="UE/12/0/109",
        description="""UE/12/0/109""",
    )

    ue_12_0_110 = VocabularyTerm(
        code="UE_12_0_110",
        label="UE/12/0/110",
        description="""UE/12/0/110""",
    )

    ue_12_0_110f = VocabularyTerm(
        code="UE_12_0_110F",
        label="UE/12/0/110F",
        description="""UE/12/0/110F""",
    )

    ue_12_0_111d = VocabularyTerm(
        code="UE_12_0_111D",
        label="UE/12/0/111D",
        description="""UE/12/0/111D""",
    )

    ue_12_0_113f = VocabularyTerm(
        code="UE_12_0_113F",
        label="UE/12/0/113F",
        description="""UE/12/0/113F""",
    )

    ue_12_0_113t = VocabularyTerm(
        code="UE_12_0_113T",
        label="UE/12/0/113T",
        description="""UE/12/0/113T""",
    )

    ue_12_0_114 = VocabularyTerm(
        code="UE_12_0_114",
        label="UE/12/0/114",
        description="""UE/12/0/114""",
    )

    ue_12_0_115 = VocabularyTerm(
        code="UE_12_0_115",
        label="UE/12/0/115",
        description="""UE/12/0/115""",
    )

    ue_12_0_117 = VocabularyTerm(
        code="UE_12_0_117",
        label="UE/12/0/117",
        description="""UE/12/0/117""",
    )

    ue_12_0_118 = VocabularyTerm(
        code="UE_12_0_118",
        label="UE/12/0/118",
        description="""UE/12/0/118""",
    )

    ue_12_0_119 = VocabularyTerm(
        code="UE_12_0_119",
        label="UE/12/0/119",
        description="""UE/12/0/119""",
    )

    ue_12_0_120 = VocabularyTerm(
        code="UE_12_0_120",
        label="UE/12/0/120",
        description="""UE/12/0/120""",
    )

    ue_12_0_121 = VocabularyTerm(
        code="UE_12_0_121",
        label="UE/12/0/121",
        description="""UE/12/0/121""",
    )

    ue_12_0_123 = VocabularyTerm(
        code="UE_12_0_123",
        label="UE/12/0/123",
        description="""UE/12/0/123""",
    )

    ue_12_0_125 = VocabularyTerm(
        code="UE_12_0_125",
        label="UE/12/0/125",
        description="""UE/12/0/125""",
    )

    ue_12_1_202 = VocabularyTerm(
        code="UE_12_1_202",
        label="UE/12/1/202",
        description="""UE/12/1/202""",
    )

    ue_12_1_203 = VocabularyTerm(
        code="UE_12_1_203",
        label="UE/12/1/203",
        description="""UE/12/1/203""",
    )

    ue_12_1_206 = VocabularyTerm(
        code="UE_12_1_206",
        label="UE/12/1/206",
        description="""UE/12/1/206""",
    )

    ue_12_1_206f = VocabularyTerm(
        code="UE_12_1_206F",
        label="UE/12/1/206F",
        description="""UE/12/1/206F""",
    )

    ue_12_1_207 = VocabularyTerm(
        code="UE_12_1_207",
        label="UE/12/1/207",
        description="""UE/12/1/207""",
    )

    ue_12_1_208 = VocabularyTerm(
        code="UE_12_1_208",
        label="UE/12/1/208",
        description="""UE/12/1/208""",
    )

    ue_12_1_209 = VocabularyTerm(
        code="UE_12_1_209",
        label="UE/12/1/209",
        description="""UE/12/1/209""",
    )

    ue_12_1_211h = VocabularyTerm(
        code="UE_12_1_211H",
        label="UE/12/1/211H",
        description="""UE/12/1/211H""",
    )

    ue_12_1_213f = VocabularyTerm(
        code="UE_12_1_213F",
        label="UE/12/1/213F",
        description="""UE/12/1/213F""",
    )

    ue_12_1_213t = VocabularyTerm(
        code="UE_12_1_213T",
        label="UE/12/1/213T",
        description="""UE/12/1/213T""",
    )

    ue_12_1_214 = VocabularyTerm(
        code="UE_12_1_214",
        label="UE/12/1/214",
        description="""UE/12/1/214""",
    )

    ue_12_1_215 = VocabularyTerm(
        code="UE_12_1_215",
        label="UE/12/1/215",
        description="""UE/12/1/215""",
    )

    ue_12_1_216 = VocabularyTerm(
        code="UE_12_1_216",
        label="UE/12/1/216",
        description="""UE/12/1/216""",
    )

    ue_12_1_216b = VocabularyTerm(
        code="UE_12_1_216B",
        label="UE/12/1/216B",
        description="""UE/12/1/216B""",
    )

    ue_12_1_217 = VocabularyTerm(
        code="UE_12_1_217",
        label="UE/12/1/217",
        description="""UE/12/1/217""",
    )

    ue_12_1_218 = VocabularyTerm(
        code="UE_12_1_218",
        label="UE/12/1/218",
        description="""UE/12/1/218""",
    )

    ue_12_1_218f = VocabularyTerm(
        code="UE_12_1_218F",
        label="UE/12/1/218F",
        description="""UE/12/1/218F""",
    )

    ue_12_1_219 = VocabularyTerm(
        code="UE_12_1_219",
        label="UE/12/1/219",
        description="""UE/12/1/219""",
    )

    ue_12_1_220 = VocabularyTerm(
        code="UE_12_1_220",
        label="UE/12/1/220",
        description="""UE/12/1/220""",
    )

    ue_12_1_220f = VocabularyTerm(
        code="UE_12_1_220F",
        label="UE/12/1/220F",
        description="""UE/12/1/220F""",
    )

    ue_12_1_221 = VocabularyTerm(
        code="UE_12_1_221",
        label="UE/12/1/221",
        description="""UE/12/1/221""",
    )

    ue_12_1_222 = VocabularyTerm(
        code="UE_12_1_222",
        label="UE/12/1/222",
        description="""UE/12/1/222""",
    )

    ue_12_2_301 = VocabularyTerm(
        code="UE_12_2_301",
        label="UE/12/2/301",
        description="""UE/12/2/301""",
    )

    ue_12_2_311 = VocabularyTerm(
        code="UE_12_2_311",
        label="UE/12/2/311",
        description="""UE/12/2/311""",
    )

    ue_12_2_313t = VocabularyTerm(
        code="UE_12_2_313T",
        label="UE/12/2/313T",
        description="""UE/12/2/313T""",
    )

    ue_12_2_314 = VocabularyTerm(
        code="UE_12_2_314",
        label="UE/12/2/314",
        description="""UE/12/2/314""",
    )

    ue_12_2_315 = VocabularyTerm(
        code="UE_12_2_315",
        label="UE/12/2/315",
        description="""UE/12/2/315""",
    )

    ue_12_2_316f = VocabularyTerm(
        code="UE_12_2_316F",
        label="UE/12/2/316F",
        description="""UE/12/2/316F""",
    )

    ue_12_2_320 = VocabularyTerm(
        code="UE_12_2_320",
        label="UE/12/2/320",
        description="""UE/12/2/320""",
    )

    ue_12_2_323 = VocabularyTerm(
        code="UE_12_2_323",
        label="UE/12/2/323",
        description="""UE/12/2/323""",
    )

    ue_12__1_001f = VocabularyTerm(
        code="UE_12_-1_001F",
        label="UE/12/-1/001F",
        description="""UE/12/-1/001F""",
    )

    ue_12__1_002 = VocabularyTerm(
        code="UE_12_-1_002",
        label="UE/12/-1/002",
        description="""UE/12/-1/002""",
    )

    ue_12__1_003 = VocabularyTerm(
        code="UE_12_-1_003",
        label="UE/12/-1/003",
        description="""UE/12/-1/003""",
    )

    ue_12__1_003b = VocabularyTerm(
        code="UE_12_-1_003B",
        label="UE/12/-1/003B",
        description="""UE/12/-1/003B""",
    )

    ue_12__1_005 = VocabularyTerm(
        code="UE_12_-1_005",
        label="UE/12/-1/005",
        description="""UE/12/-1/005""",
    )

    ue_12__1_007 = VocabularyTerm(
        code="UE_12_-1_007",
        label="UE/12/-1/007",
        description="""UE/12/-1/007""",
    )

    ue_12__1_009 = VocabularyTerm(
        code="UE_12_-1_009",
        label="UE/12/-1/009",
        description="""UE/12/-1/009""",
    )

    ue_12__1_009b = VocabularyTerm(
        code="UE_12_-1_009B",
        label="UE/12/-1/009B",
        description="""UE/12/-1/009B""",
    )

    ue_12__1_010 = VocabularyTerm(
        code="UE_12_-1_010",
        label="UE/12/-1/010",
        description="""UE/12/-1/010""",
    )

    ue_12__1_011d = VocabularyTerm(
        code="UE_12_-1_011D",
        label="UE/12/-1/011D",
        description="""UE/12/-1/011D""",
    )

    ue_12__1_013f = VocabularyTerm(
        code="UE_12_-1_013F",
        label="UE/12/-1/013F",
        description="""UE/12/-1/013F""",
    )

    ue_12__1_013t = VocabularyTerm(
        code="UE_12_-1_013T",
        label="UE/12/-1/013T",
        description="""UE/12/-1/013T""",
    )

    ue_12__1_014 = VocabularyTerm(
        code="UE_12_-1_014",
        label="UE/12/-1/014",
        description="""UE/12/-1/014""",
    )

    ue_12__1_015 = VocabularyTerm(
        code="UE_12_-1_015",
        label="UE/12/-1/015",
        description="""UE/12/-1/015""",
    )

    ue_12__1_017 = VocabularyTerm(
        code="UE_12_-1_017",
        label="UE/12/-1/017",
        description="""UE/12/-1/017""",
    )

    ue_12__1_018 = VocabularyTerm(
        code="UE_12_-1_018",
        label="UE/12/-1/018",
        description="""UE/12/-1/018""",
    )

    ue_12__1_019 = VocabularyTerm(
        code="UE_12_-1_019",
        label="UE/12/-1/019",
        description="""UE/12/-1/019""",
    )

    ue_12__1_020 = VocabularyTerm(
        code="UE_12_-1_020",
        label="UE/12/-1/020",
        description="""UE/12/-1/020""",
    )

    ue_12__1_021f = VocabularyTerm(
        code="UE_12_-1_021F",
        label="UE/12/-1/021F",
        description="""UE/12/-1/021F""",
    )

    ue_12__1_023 = VocabularyTerm(
        code="UE_12_-1_023",
        label="UE/12/-1/023",
        description="""UE/12/-1/023""",
    )

    ue_12__1_023t = VocabularyTerm(
        code="UE_12_-1_023T",
        label="UE/12/-1/023T",
        description="""UE/12/-1/023T""",
    )

    ue_15_0_104 = VocabularyTerm(
        code="UE_15_0_104",
        label="UE/15/0/104",
        description="""UE/15/0/104""",
    )

    ue_15__1_001 = VocabularyTerm(
        code="UE_15_-1_001",
        label="UE/15/-1/001",
        description="""UE/15/-1/001""",
    )

    ue_15__1_001f = VocabularyTerm(
        code="UE_15_-1_001F",
        label="UE/15/-1/001F",
        description="""UE/15/-1/001F""",
    )

    ue_15__1_002 = VocabularyTerm(
        code="UE_15_-1_002",
        label="UE/15/-1/002",
        description="""UE/15/-1/002""",
    )

    ue_15__1_003 = VocabularyTerm(
        code="UE_15_-1_003",
        label="UE/15/-1/003",
        description="""UE/15/-1/003""",
    )

    ue_15__1_004 = VocabularyTerm(
        code="UE_15_-1_004",
        label="UE/15/-1/004",
        description="""UE/15/-1/004""",
    )

    ue_15__1_005 = VocabularyTerm(
        code="UE_15_-1_005",
        label="UE/15/-1/005",
        description="""UE/15/-1/005""",
    )

    ue_15__1_006 = VocabularyTerm(
        code="UE_15_-1_006",
        label="UE/15/-1/006",
        description="""UE/15/-1/006""",
    )

    ue_16_0_101f = VocabularyTerm(
        code="UE_16_0_101F",
        label="UE/16/0/101F",
        description="""UE/16/0/101F""",
    )

    ue_16_0_101t = VocabularyTerm(
        code="UE_16_0_101T",
        label="UE/16/0/101T",
        description="""UE/16/0/101T""",
    )

    ue_16_0_102 = VocabularyTerm(
        code="UE_16_0_102",
        label="UE/16/0/102",
        description="""UE/16/0/102""",
    )

    ue_16_0_103 = VocabularyTerm(
        code="UE_16_0_103",
        label="UE/16/0/103",
        description="""UE/16/0/103""",
    )

    ue_16_0_104 = VocabularyTerm(
        code="UE_16_0_104",
        label="UE/16/0/104",
        description="""UE/16/0/104""",
    )

    ue_16_0_105 = VocabularyTerm(
        code="UE_16_0_105",
        label="UE/16/0/105",
        description="""UE/16/0/105""",
    )

    ue_16_1_201f = VocabularyTerm(
        code="UE_16_1_201F",
        label="UE/16/1/201F",
        description="""UE/16/1/201F""",
    )

    ue_16_1_201t = VocabularyTerm(
        code="UE_16_1_201T",
        label="UE/16/1/201T",
        description="""UE/16/1/201T""",
    )

    ue_16_1_202 = VocabularyTerm(
        code="UE_16_1_202",
        label="UE/16/1/202",
        description="""UE/16/1/202""",
    )

    ue_16_1_203 = VocabularyTerm(
        code="UE_16_1_203",
        label="UE/16/1/203",
        description="""UE/16/1/203""",
    )

    ue_16_1_204 = VocabularyTerm(
        code="UE_16_1_204",
        label="UE/16/1/204",
        description="""UE/16/1/204""",
    )

    ue_16__1_001f = VocabularyTerm(
        code="UE_16_-1_001F",
        label="UE/16/-1/001F",
        description="""UE/16/-1/001F""",
    )

    ue_16__1_001t = VocabularyTerm(
        code="UE_16_-1_001T",
        label="UE/16/-1/001T",
        description="""UE/16/-1/001T""",
    )

    ue_16__1_002b = VocabularyTerm(
        code="UE_16_-1_002B",
        label="UE/16/-1/002B",
        description="""UE/16/-1/002B""",
    )

    ue_16__1_002h = VocabularyTerm(
        code="UE_16_-1_002H",
        label="UE/16/-1/002H",
        description="""UE/16/-1/002H""",
    )

    ue_16__1_003 = VocabularyTerm(
        code="UE_16_-1_003",
        label="UE/16/-1/003",
        description="""UE/16/-1/003""",
    )

    ue_16__1_004 = VocabularyTerm(
        code="UE_16_-1_004",
        label="UE/16/-1/004",
        description="""UE/16/-1/004""",
    )

    ue_16__1_005 = VocabularyTerm(
        code="UE_16_-1_005",
        label="UE/16/-1/005",
        description="""UE/16/-1/005""",
    )

    ue_16__1_006 = VocabularyTerm(
        code="UE_16_-1_006",
        label="UE/16/-1/006",
        description="""UE/16/-1/006""",
    )

    ue_16__1_009 = VocabularyTerm(
        code="UE_16_-1_009",
        label="UE/16/-1/009",
        description="""UE/16/-1/009""",
    )

    ue_20_0_100 = VocabularyTerm(
        code="UE_20_0_100",
        label="UE/20/0/100",
        description="""UE/20/0/100""",
    )

    ue_20_0_100b = VocabularyTerm(
        code="UE_20_0_100B",
        label="UE/20/0/100B",
        description="""UE/20/0/100B""",
    )

    ue_20_0_101 = VocabularyTerm(
        code="UE_20_0_101",
        label="UE/20/0/101",
        description="""UE/20/0/101""",
    )

    ue_20_0_103 = VocabularyTerm(
        code="UE_20_0_103",
        label="UE/20/0/103",
        description="""UE/20/0/103""",
    )

    ue_20_0_104 = VocabularyTerm(
        code="UE_20_0_104",
        label="UE/20/0/104",
        description="""UE/20/0/104""",
    )

    ue_20_0_106 = VocabularyTerm(
        code="UE_20_0_106",
        label="UE/20/0/106",
        description="""UE/20/0/106""",
    )

    ue_20_0_107 = VocabularyTerm(
        code="UE_20_0_107",
        label="UE/20/0/107",
        description="""UE/20/0/107""",
    )

    ue_20_0_108 = VocabularyTerm(
        code="UE_20_0_108",
        label="UE/20/0/108",
        description="""UE/20/0/108""",
    )

    ue_20_0_109h = VocabularyTerm(
        code="UE_20_0_109H",
        label="UE/20/0/109H",
        description="""UE/20/0/109H""",
    )

    ue_20_0_109t = VocabularyTerm(
        code="UE_20_0_109T",
        label="UE/20/0/109T",
        description="""UE/20/0/109T""",
    )

    ue_20_0_110 = VocabularyTerm(
        code="UE_20_0_110",
        label="UE/20/0/110",
        description="""UE/20/0/110""",
    )

    ue_20_0_111 = VocabularyTerm(
        code="UE_20_0_111",
        label="UE/20/0/111",
        description="""UE/20/0/111""",
    )

    ue_20_0_112 = VocabularyTerm(
        code="UE_20_0_112",
        label="UE/20/0/112",
        description="""UE/20/0/112""",
    )

    ue_20_0_112f = VocabularyTerm(
        code="UE_20_0_112F",
        label="UE/20/0/112F",
        description="""UE/20/0/112F""",
    )

    ue_20_0_113 = VocabularyTerm(
        code="UE_20_0_113",
        label="UE/20/0/113",
        description="""UE/20/0/113""",
    )

    ue_20_0_113f = VocabularyTerm(
        code="UE_20_0_113F",
        label="UE/20/0/113F",
        description="""UE/20/0/113F""",
    )

    ue_20_0_114 = VocabularyTerm(
        code="UE_20_0_114",
        label="UE/20/0/114",
        description="""UE/20/0/114""",
    )

    ue_20_0_115 = VocabularyTerm(
        code="UE_20_0_115",
        label="UE/20/0/115",
        description="""UE/20/0/115""",
    )

    ue_20_0_116 = VocabularyTerm(
        code="UE_20_0_116",
        label="UE/20/0/116",
        description="""UE/20/0/116""",
    )

    ue_20_0_117b = VocabularyTerm(
        code="UE_20_0_117B",
        label="UE/20/0/117B",
        description="""UE/20/0/117B""",
    )

    ue_20_0_117wc = VocabularyTerm(
        code="UE_20_0_117WC",
        label="UE/20/0/117WC",
        description="""UE/20/0/117WC""",
    )

    ue_20_0_118f = VocabularyTerm(
        code="UE_20_0_118F",
        label="UE/20/0/118F",
        description="""UE/20/0/118F""",
    )

    ue_20_0_119t = VocabularyTerm(
        code="UE_20_0_119T",
        label="UE/20/0/119T",
        description="""UE/20/0/119T""",
    )

    ue_20_0_120 = VocabularyTerm(
        code="UE_20_0_120",
        label="UE/20/0/120",
        description="""UE/20/0/120""",
    )

    ue_20_0_121 = VocabularyTerm(
        code="UE_20_0_121",
        label="UE/20/0/121",
        description="""UE/20/0/121""",
    )

    ue_20_0_122 = VocabularyTerm(
        code="UE_20_0_122",
        label="UE/20/0/122",
        description="""UE/20/0/122""",
    )

    ue_20_0_123 = VocabularyTerm(
        code="UE_20_0_123",
        label="UE/20/0/123",
        description="""UE/20/0/123""",
    )

    ue_20_0_124 = VocabularyTerm(
        code="UE_20_0_124",
        label="UE/20/0/124",
        description="""UE/20/0/124""",
    )

    ue_20_0_126 = VocabularyTerm(
        code="UE_20_0_126",
        label="UE/20/0/126",
        description="""UE/20/0/126""",
    )

    ue_20_0_127 = VocabularyTerm(
        code="UE_20_0_127",
        label="UE/20/0/127",
        description="""UE/20/0/127""",
    )

    ue_20_0_198t = VocabularyTerm(
        code="UE_20_0_198T",
        label="UE/20/0/198T",
        description="""UE/20/0/198T""",
    )

    ue_20_0_a1 = VocabularyTerm(
        code="UE_20_0_A1",
        label="UE/20/0/A1",
        description="""UE/20/0/A1""",
    )

    ue_20_1_200 = VocabularyTerm(
        code="UE_20_1_200",
        label="UE/20/1/200",
        description="""UE/20/1/200""",
    )

    ue_20_1_202 = VocabularyTerm(
        code="UE_20_1_202",
        label="UE/20/1/202",
        description="""UE/20/1/202""",
    )

    ue_20_1_203 = VocabularyTerm(
        code="UE_20_1_203",
        label="UE/20/1/203",
        description="""UE/20/1/203""",
    )

    ue_20_1_205 = VocabularyTerm(
        code="UE_20_1_205",
        label="UE/20/1/205",
        description="""UE/20/1/205""",
    )

    ue_20_1_206 = VocabularyTerm(
        code="UE_20_1_206",
        label="UE/20/1/206",
        description="""UE/20/1/206""",
    )

    ue_20_1_207 = VocabularyTerm(
        code="UE_20_1_207",
        label="UE/20/1/207",
        description="""UE/20/1/207""",
    )

    ue_20_1_208 = VocabularyTerm(
        code="UE_20_1_208",
        label="UE/20/1/208",
        description="""UE/20/1/208""",
    )

    ue_20_1_209h = VocabularyTerm(
        code="UE_20_1_209H",
        label="UE/20/1/209H",
        description="""UE/20/1/209H""",
    )

    ue_20_1_209t = VocabularyTerm(
        code="UE_20_1_209T",
        label="UE/20/1/209T",
        description="""UE/20/1/209T""",
    )

    ue_20_1_210 = VocabularyTerm(
        code="UE_20_1_210",
        label="UE/20/1/210",
        description="""UE/20/1/210""",
    )

    ue_20_1_211 = VocabularyTerm(
        code="UE_20_1_211",
        label="UE/20/1/211",
        description="""UE/20/1/211""",
    )

    ue_20_1_212 = VocabularyTerm(
        code="UE_20_1_212",
        label="UE/20/1/212",
        description="""UE/20/1/212""",
    )

    ue_20_1_212f = VocabularyTerm(
        code="UE_20_1_212F",
        label="UE/20/1/212F",
        description="""UE/20/1/212F""",
    )

    ue_20_1_213 = VocabularyTerm(
        code="UE_20_1_213",
        label="UE/20/1/213",
        description="""UE/20/1/213""",
    )

    ue_20_1_213f = VocabularyTerm(
        code="UE_20_1_213F",
        label="UE/20/1/213F",
        description="""UE/20/1/213F""",
    )

    ue_20_1_214 = VocabularyTerm(
        code="UE_20_1_214",
        label="UE/20/1/214",
        description="""UE/20/1/214""",
    )

    ue_20_1_215 = VocabularyTerm(
        code="UE_20_1_215",
        label="UE/20/1/215",
        description="""UE/20/1/215""",
    )

    ue_20_1_216 = VocabularyTerm(
        code="UE_20_1_216",
        label="UE/20/1/216",
        description="""UE/20/1/216""",
    )

    ue_20_1_217 = VocabularyTerm(
        code="UE_20_1_217",
        label="UE/20/1/217",
        description="""UE/20/1/217""",
    )

    ue_20_1_217d = VocabularyTerm(
        code="UE_20_1_217D",
        label="UE/20/1/217D",
        description="""UE/20/1/217D""",
    )

    ue_20_1_218 = VocabularyTerm(
        code="UE_20_1_218",
        label="UE/20/1/218",
        description="""UE/20/1/218""",
    )

    ue_20_1_219t = VocabularyTerm(
        code="UE_20_1_219T",
        label="UE/20/1/219T",
        description="""UE/20/1/219T""",
    )

    ue_20_1_220 = VocabularyTerm(
        code="UE_20_1_220",
        label="UE/20/1/220",
        description="""UE/20/1/220""",
    )

    ue_20_1_221 = VocabularyTerm(
        code="UE_20_1_221",
        label="UE/20/1/221",
        description="""UE/20/1/221""",
    )

    ue_20_1_223 = VocabularyTerm(
        code="UE_20_1_223",
        label="UE/20/1/223",
        description="""UE/20/1/223""",
    )

    ue_20_1_224 = VocabularyTerm(
        code="UE_20_1_224",
        label="UE/20/1/224",
        description="""UE/20/1/224""",
    )

    ue_20_1_225 = VocabularyTerm(
        code="UE_20_1_225",
        label="UE/20/1/225",
        description="""UE/20/1/225""",
    )

    ue_20_1_226 = VocabularyTerm(
        code="UE_20_1_226",
        label="UE/20/1/226",
        description="""UE/20/1/226""",
    )

    ue_20_1_227 = VocabularyTerm(
        code="UE_20_1_227",
        label="UE/20/1/227",
        description="""UE/20/1/227""",
    )

    ue_20_1_298 = VocabularyTerm(
        code="UE_20_1_298",
        label="UE/20/1/298",
        description="""UE/20/1/298""",
    )

    ue_20_1_298b = VocabularyTerm(
        code="UE_20_1_298B",
        label="UE/20/1/298B",
        description="""UE/20/1/298B""",
    )

    ue_20_1_a1 = VocabularyTerm(
        code="UE_20_1_A1",
        label="UE/20/1/A1",
        description="""UE/20/1/A1""",
    )

    ue_20_2_300 = VocabularyTerm(
        code="UE_20_2_300",
        label="UE/20/2/300",
        description="""UE/20/2/300""",
    )

    ue_20_2_301 = VocabularyTerm(
        code="UE_20_2_301",
        label="UE/20/2/301",
        description="""UE/20/2/301""",
    )

    ue_20_2_302 = VocabularyTerm(
        code="UE_20_2_302",
        label="UE/20/2/302",
        description="""UE/20/2/302""",
    )

    ue_20_2_303 = VocabularyTerm(
        code="UE_20_2_303",
        label="UE/20/2/303",
        description="""UE/20/2/303""",
    )

    ue_20_2_304 = VocabularyTerm(
        code="UE_20_2_304",
        label="UE/20/2/304",
        description="""UE/20/2/304""",
    )

    ue_20_2_305 = VocabularyTerm(
        code="UE_20_2_305",
        label="UE/20/2/305",
        description="""UE/20/2/305""",
    )

    ue_20_2_306 = VocabularyTerm(
        code="UE_20_2_306",
        label="UE/20/2/306",
        description="""UE/20/2/306""",
    )

    ue_20_2_307 = VocabularyTerm(
        code="UE_20_2_307",
        label="UE/20/2/307",
        description="""UE/20/2/307""",
    )

    ue_20_2_308 = VocabularyTerm(
        code="UE_20_2_308",
        label="UE/20/2/308",
        description="""UE/20/2/308""",
    )

    ue_20_2_309h = VocabularyTerm(
        code="UE_20_2_309H",
        label="UE/20/2/309H",
        description="""UE/20/2/309H""",
    )

    ue_20_2_309t = VocabularyTerm(
        code="UE_20_2_309T",
        label="UE/20/2/309T",
        description="""UE/20/2/309T""",
    )

    ue_20_2_310 = VocabularyTerm(
        code="UE_20_2_310",
        label="UE/20/2/310",
        description="""UE/20/2/310""",
    )

    ue_20_2_311 = VocabularyTerm(
        code="UE_20_2_311",
        label="UE/20/2/311",
        description="""UE/20/2/311""",
    )

    ue_20_2_312 = VocabularyTerm(
        code="UE_20_2_312",
        label="UE/20/2/312",
        description="""UE/20/2/312""",
    )

    ue_20_2_312f = VocabularyTerm(
        code="UE_20_2_312F",
        label="UE/20/2/312F",
        description="""UE/20/2/312F""",
    )

    ue_20_2_313 = VocabularyTerm(
        code="UE_20_2_313",
        label="UE/20/2/313",
        description="""UE/20/2/313""",
    )

    ue_20_2_313f = VocabularyTerm(
        code="UE_20_2_313F",
        label="UE/20/2/313F",
        description="""UE/20/2/313F""",
    )

    ue_20_2_314 = VocabularyTerm(
        code="UE_20_2_314",
        label="UE/20/2/314",
        description="""UE/20/2/314""",
    )

    ue_20_2_315 = VocabularyTerm(
        code="UE_20_2_315",
        label="UE/20/2/315",
        description="""UE/20/2/315""",
    )

    ue_20_2_316 = VocabularyTerm(
        code="UE_20_2_316",
        label="UE/20/2/316",
        description="""UE/20/2/316""",
    )

    ue_20_2_317b = VocabularyTerm(
        code="UE_20_2_317B",
        label="UE/20/2/317B",
        description="""UE/20/2/317B""",
    )

    ue_20_2_317wc = VocabularyTerm(
        code="UE_20_2_317WC",
        label="UE/20/2/317WC",
        description="""UE/20/2/317WC""",
    )

    ue_20_2_319t = VocabularyTerm(
        code="UE_20_2_319T",
        label="UE/20/2/319T",
        description="""UE/20/2/319T""",
    )

    ue_20_2_320 = VocabularyTerm(
        code="UE_20_2_320",
        label="UE/20/2/320",
        description="""UE/20/2/320""",
    )

    ue_20_2_321 = VocabularyTerm(
        code="UE_20_2_321",
        label="UE/20/2/321",
        description="""UE/20/2/321""",
    )

    ue_20_2_323 = VocabularyTerm(
        code="UE_20_2_323",
        label="UE/20/2/323",
        description="""UE/20/2/323""",
    )

    ue_20_2_324 = VocabularyTerm(
        code="UE_20_2_324",
        label="UE/20/2/324",
        description="""UE/20/2/324""",
    )

    ue_20_2_325 = VocabularyTerm(
        code="UE_20_2_325",
        label="UE/20/2/325",
        description="""UE/20/2/325""",
    )

    ue_20_2_326 = VocabularyTerm(
        code="UE_20_2_326",
        label="UE/20/2/326",
        description="""UE/20/2/326""",
    )

    ue_20_2_327 = VocabularyTerm(
        code="UE_20_2_327",
        label="UE/20/2/327",
        description="""UE/20/2/327""",
    )

    ue_20_2_398 = VocabularyTerm(
        code="UE_20_2_398",
        label="UE/20/2/398",
        description="""UE/20/2/398""",
    )

    ue_20_2_a1 = VocabularyTerm(
        code="UE_20_2_A1",
        label="UE/20/2/A1",
        description="""UE/20/2/A1""",
    )

    ue_20_3_400 = VocabularyTerm(
        code="UE_20_3_400",
        label="UE/20/3/400",
        description="""UE/20/3/400""",
    )

    ue_20_3_400b = VocabularyTerm(
        code="UE_20_3_400B",
        label="UE/20/3/400B",
        description="""UE/20/3/400B""",
    )

    ue_20_3_401 = VocabularyTerm(
        code="UE_20_3_401",
        label="UE/20/3/401",
        description="""UE/20/3/401""",
    )

    ue_20_3_402 = VocabularyTerm(
        code="UE_20_3_402",
        label="UE/20/3/402",
        description="""UE/20/3/402""",
    )

    ue_20_3_403 = VocabularyTerm(
        code="UE_20_3_403",
        label="UE/20/3/403",
        description="""UE/20/3/403""",
    )

    ue_20_3_404 = VocabularyTerm(
        code="UE_20_3_404",
        label="UE/20/3/404",
        description="""UE/20/3/404""",
    )

    ue_20_3_405 = VocabularyTerm(
        code="UE_20_3_405",
        label="UE/20/3/405",
        description="""UE/20/3/405""",
    )

    ue_20_3_406 = VocabularyTerm(
        code="UE_20_3_406",
        label="UE/20/3/406",
        description="""UE/20/3/406""",
    )

    ue_20_3_407 = VocabularyTerm(
        code="UE_20_3_407",
        label="UE/20/3/407",
        description="""UE/20/3/407""",
    )

    ue_20_3_408 = VocabularyTerm(
        code="UE_20_3_408",
        label="UE/20/3/408",
        description="""UE/20/3/408""",
    )

    ue_20_3_409h = VocabularyTerm(
        code="UE_20_3_409H",
        label="UE/20/3/409H",
        description="""UE/20/3/409H""",
    )

    ue_20_3_409t = VocabularyTerm(
        code="UE_20_3_409T",
        label="UE/20/3/409T",
        description="""UE/20/3/409T""",
    )

    ue_20_3_410 = VocabularyTerm(
        code="UE_20_3_410",
        label="UE/20/3/410",
        description="""UE/20/3/410""",
    )

    ue_20_3_411 = VocabularyTerm(
        code="UE_20_3_411",
        label="UE/20/3/411",
        description="""UE/20/3/411""",
    )

    ue_20_3_412 = VocabularyTerm(
        code="UE_20_3_412",
        label="UE/20/3/412",
        description="""UE/20/3/412""",
    )

    ue_20_3_412f = VocabularyTerm(
        code="UE_20_3_412F",
        label="UE/20/3/412F",
        description="""UE/20/3/412F""",
    )

    ue_20_3_413 = VocabularyTerm(
        code="UE_20_3_413",
        label="UE/20/3/413",
        description="""UE/20/3/413""",
    )

    ue_20_3_413f = VocabularyTerm(
        code="UE_20_3_413F",
        label="UE/20/3/413F",
        description="""UE/20/3/413F""",
    )

    ue_20_3_414 = VocabularyTerm(
        code="UE_20_3_414",
        label="UE/20/3/414",
        description="""UE/20/3/414""",
    )

    ue_20_3_415 = VocabularyTerm(
        code="UE_20_3_415",
        label="UE/20/3/415",
        description="""UE/20/3/415""",
    )

    ue_20_3_416 = VocabularyTerm(
        code="UE_20_3_416",
        label="UE/20/3/416",
        description="""UE/20/3/416""",
    )

    ue_20_3_417 = VocabularyTerm(
        code="UE_20_3_417",
        label="UE/20/3/417",
        description="""UE/20/3/417""",
    )

    ue_20_3_417d = VocabularyTerm(
        code="UE_20_3_417D",
        label="UE/20/3/417D",
        description="""UE/20/3/417D""",
    )

    ue_20_3_419t = VocabularyTerm(
        code="UE_20_3_419T",
        label="UE/20/3/419T",
        description="""UE/20/3/419T""",
    )

    ue_20_3_420 = VocabularyTerm(
        code="UE_20_3_420",
        label="UE/20/3/420",
        description="""UE/20/3/420""",
    )

    ue_20_3_421 = VocabularyTerm(
        code="UE_20_3_421",
        label="UE/20/3/421",
        description="""UE/20/3/421""",
    )

    ue_20_3_423 = VocabularyTerm(
        code="UE_20_3_423",
        label="UE/20/3/423",
        description="""UE/20/3/423""",
    )

    ue_20_3_424 = VocabularyTerm(
        code="UE_20_3_424",
        label="UE/20/3/424",
        description="""UE/20/3/424""",
    )

    ue_20_3_425 = VocabularyTerm(
        code="UE_20_3_425",
        label="UE/20/3/425",
        description="""UE/20/3/425""",
    )

    ue_20_3_426 = VocabularyTerm(
        code="UE_20_3_426",
        label="UE/20/3/426",
        description="""UE/20/3/426""",
    )

    ue_20_3_427 = VocabularyTerm(
        code="UE_20_3_427",
        label="UE/20/3/427",
        description="""UE/20/3/427""",
    )

    ue_20_3_498 = VocabularyTerm(
        code="UE_20_3_498",
        label="UE/20/3/498",
        description="""UE/20/3/498""",
    )

    ue_20_3_a1 = VocabularyTerm(
        code="UE_20_3_A1",
        label="UE/20/3/A1",
        description="""UE/20/3/A1""",
    )

    ue_20_4_512 = VocabularyTerm(
        code="UE_20_4_512",
        label="UE/20/4/512",
        description="""UE/20/4/512""",
    )

    ue_20_4_513 = VocabularyTerm(
        code="UE_20_4_513",
        label="UE/20/4/513",
        description="""UE/20/4/513""",
    )

    ue_20_4_517 = VocabularyTerm(
        code="UE_20_4_517",
        label="UE/20/4/517",
        description="""UE/20/4/517""",
    )

    ue_20_4_519 = VocabularyTerm(
        code="UE_20_4_519",
        label="UE/20/4/519",
        description="""UE/20/4/519""",
    )

    ue_20_4_519t = VocabularyTerm(
        code="UE_20_4_519T",
        label="UE/20/4/519T",
        description="""UE/20/4/519T""",
    )

    ue_20_4_598 = VocabularyTerm(
        code="UE_20_4_598",
        label="UE/20/4/598",
        description="""UE/20/4/598""",
    )

    ue_20__1_000 = VocabularyTerm(
        code="UE_20_-1_000",
        label="UE/20/-1/000",
        description="""UE/20/-1/000""",
    )

    ue_20__1_001 = VocabularyTerm(
        code="UE_20_-1_001",
        label="UE/20/-1/001",
        description="""UE/20/-1/001""",
    )

    ue_20__1_002b = VocabularyTerm(
        code="UE_20_-1_002B",
        label="UE/20/-1/002B",
        description="""UE/20/-1/002B""",
    )

    ue_20__1_002c = VocabularyTerm(
        code="UE_20_-1_002C",
        label="UE/20/-1/002C",
        description="""UE/20/-1/002C""",
    )

    ue_20__1_002f = VocabularyTerm(
        code="UE_20_-1_002F",
        label="UE/20/-1/002F",
        description="""UE/20/-1/002F""",
    )

    ue_20__1_003 = VocabularyTerm(
        code="UE_20_-1_003",
        label="UE/20/-1/003",
        description="""UE/20/-1/003""",
    )

    ue_20__1_004 = VocabularyTerm(
        code="UE_20_-1_004",
        label="UE/20/-1/004",
        description="""UE/20/-1/004""",
    )

    ue_20__1_005 = VocabularyTerm(
        code="UE_20_-1_005",
        label="UE/20/-1/005",
        description="""UE/20/-1/005""",
    )

    ue_20__1_006 = VocabularyTerm(
        code="UE_20_-1_006",
        label="UE/20/-1/006",
        description="""UE/20/-1/006""",
    )

    ue_20__1_007 = VocabularyTerm(
        code="UE_20_-1_007",
        label="UE/20/-1/007",
        description="""UE/20/-1/007""",
    )

    ue_20__1_008 = VocabularyTerm(
        code="UE_20_-1_008",
        label="UE/20/-1/008",
        description="""UE/20/-1/008""",
    )

    ue_20__1_009 = VocabularyTerm(
        code="UE_20_-1_009",
        label="UE/20/-1/009",
        description="""UE/20/-1/009""",
    )

    ue_20__1_009t = VocabularyTerm(
        code="UE_20_-1_009T",
        label="UE/20/-1/009T",
        description="""UE/20/-1/009T""",
    )

    ue_20__1_010 = VocabularyTerm(
        code="UE_20_-1_010",
        label="UE/20/-1/010",
        description="""UE/20/-1/010""",
    )

    ue_20__1_011 = VocabularyTerm(
        code="UE_20_-1_011",
        label="UE/20/-1/011",
        description="""UE/20/-1/011""",
    )

    ue_20__1_012f = VocabularyTerm(
        code="UE_20_-1_012F",
        label="UE/20/-1/012F",
        description="""UE/20/-1/012F""",
    )

    ue_20__1_013f = VocabularyTerm(
        code="UE_20_-1_013F",
        label="UE/20/-1/013F",
        description="""UE/20/-1/013F""",
    )

    ue_20__1_013h = VocabularyTerm(
        code="UE_20_-1_013H",
        label="UE/20/-1/013H",
        description="""UE/20/-1/013H""",
    )

    ue_20__1_014 = VocabularyTerm(
        code="UE_20_-1_014",
        label="UE/20/-1/014",
        description="""UE/20/-1/014""",
    )

    ue_20__1_015 = VocabularyTerm(
        code="UE_20_-1_015",
        label="UE/20/-1/015",
        description="""UE/20/-1/015""",
    )

    ue_20__1_016 = VocabularyTerm(
        code="UE_20_-1_016",
        label="UE/20/-1/016",
        description="""UE/20/-1/016""",
    )

    ue_20__1_017 = VocabularyTerm(
        code="UE_20_-1_017",
        label="UE/20/-1/017",
        description="""UE/20/-1/017""",
    )

    ue_20__1_019t = VocabularyTerm(
        code="UE_20_-1_019T",
        label="UE/20/-1/019T",
        description="""UE/20/-1/019T""",
    )

    ue_20__1_021 = VocabularyTerm(
        code="UE_20_-1_021",
        label="UE/20/-1/021",
        description="""UE/20/-1/021""",
    )

    ue_20__1_023 = VocabularyTerm(
        code="UE_20_-1_023",
        label="UE/20/-1/023",
        description="""UE/20/-1/023""",
    )

    ue_20__1_024 = VocabularyTerm(
        code="UE_20_-1_024",
        label="UE/20/-1/024",
        description="""UE/20/-1/024""",
    )

    ue_20__1_025 = VocabularyTerm(
        code="UE_20_-1_025",
        label="UE/20/-1/025",
        description="""UE/20/-1/025""",
    )

    ue_20__1_026 = VocabularyTerm(
        code="UE_20_-1_026",
        label="UE/20/-1/026",
        description="""UE/20/-1/026""",
    )

    ue_20__1_027 = VocabularyTerm(
        code="UE_20_-1_027",
        label="UE/20/-1/027",
        description="""UE/20/-1/027""",
    )

    ue_20__1_a1 = VocabularyTerm(
        code="UE_20_-1_A1",
        label="UE/20/-1/A1",
        description="""UE/20/-1/A1""",
    )

    ue_21_0_117 = VocabularyTerm(
        code="UE_21_0_117",
        label="UE/21/0/117",
        description="""UE/21/0/117""",
    )

    ue_21_0_117b = VocabularyTerm(
        code="UE_21_0_117B",
        label="UE/21/0/117B",
        description="""UE/21/0/117B""",
    )

    ue_21_0_119 = VocabularyTerm(
        code="UE_21_0_119",
        label="UE/21/0/119",
        description="""UE/21/0/119""",
    )

    ue_21_0_121 = VocabularyTerm(
        code="UE_21_0_121",
        label="UE/21/0/121",
        description="""UE/21/0/121""",
    )

    ue_21_0_133 = VocabularyTerm(
        code="UE_21_0_133",
        label="UE/21/0/133",
        description="""UE/21/0/133""",
    )

    ue_21_0_134 = VocabularyTerm(
        code="UE_21_0_134",
        label="UE/21/0/134",
        description="""UE/21/0/134""",
    )

    ue_21_0_135f = VocabularyTerm(
        code="UE_21_0_135F",
        label="UE/21/0/135F",
        description="""UE/21/0/135F""",
    )

    ue_21_0_136 = VocabularyTerm(
        code="UE_21_0_136",
        label="UE/21/0/136",
        description="""UE/21/0/136""",
    )

    ue_21_0_137 = VocabularyTerm(
        code="UE_21_0_137",
        label="UE/21/0/137",
        description="""UE/21/0/137""",
    )

    ue_21_0_141 = VocabularyTerm(
        code="UE_21_0_141",
        label="UE/21/0/141",
        description="""UE/21/0/141""",
    )

    ue_21_0_143b = VocabularyTerm(
        code="UE_21_0_143B",
        label="UE/21/0/143B",
        description="""UE/21/0/143B""",
    )

    ue_21_0_145 = VocabularyTerm(
        code="UE_21_0_145",
        label="UE/21/0/145",
        description="""UE/21/0/145""",
    )

    ue_21_0_145b = VocabularyTerm(
        code="UE_21_0_145B",
        label="UE/21/0/145B",
        description="""UE/21/0/145B""",
    )

    ue_21_0_147 = VocabularyTerm(
        code="UE_21_0_147",
        label="UE/21/0/147",
        description="""UE/21/0/147""",
    )

    ue_21_0_151 = VocabularyTerm(
        code="UE_21_0_151",
        label="UE/21/0/151",
        description="""UE/21/0/151""",
    )

    ue_21_0_155f = VocabularyTerm(
        code="UE_21_0_155F",
        label="UE/21/0/155F",
        description="""UE/21/0/155F""",
    )

    ue_21_0_156 = VocabularyTerm(
        code="UE_21_0_156",
        label="UE/21/0/156",
        description="""UE/21/0/156""",
    )

    ue_21_0_156t = VocabularyTerm(
        code="UE_21_0_156T",
        label="UE/21/0/156T",
        description="""UE/21/0/156T""",
    )

    ue_21_0_157 = VocabularyTerm(
        code="UE_21_0_157",
        label="UE/21/0/157",
        description="""UE/21/0/157""",
    )

    ue_21_0_159 = VocabularyTerm(
        code="UE_21_0_159",
        label="UE/21/0/159",
        description="""UE/21/0/159""",
    )

    ue_21_0_161 = VocabularyTerm(
        code="UE_21_0_161",
        label="UE/21/0/161",
        description="""UE/21/0/161""",
    )

    ue_21_0_161b = VocabularyTerm(
        code="UE_21_0_161B",
        label="UE/21/0/161B",
        description="""UE/21/0/161B""",
    )

    ue_21_0_163 = VocabularyTerm(
        code="UE_21_0_163",
        label="UE/21/0/163",
        description="""UE/21/0/163""",
    )

    ue_21_0_163b = VocabularyTerm(
        code="UE_21_0_163B",
        label="UE/21/0/163B",
        description="""UE/21/0/163B""",
    )

    ue_21_0_167 = VocabularyTerm(
        code="UE_21_0_167",
        label="UE/21/0/167",
        description="""UE/21/0/167""",
    )

    ue_21_0_167b = VocabularyTerm(
        code="UE_21_0_167B",
        label="UE/21/0/167B",
        description="""UE/21/0/167B""",
    )

    ue_21_0_169 = VocabularyTerm(
        code="UE_21_0_169",
        label="UE/21/0/169",
        description="""UE/21/0/169""",
    )

    ue_21_0_176 = VocabularyTerm(
        code="UE_21_0_176",
        label="UE/21/0/176",
        description="""UE/21/0/176""",
    )

    ue_21_0_178 = VocabularyTerm(
        code="UE_21_0_178",
        label="UE/21/0/178",
        description="""UE/21/0/178""",
    )

    ue_21_0_180 = VocabularyTerm(
        code="UE_21_0_180",
        label="UE/21/0/180",
        description="""UE/21/0/180""",
    )

    ue_21_0_180f = VocabularyTerm(
        code="UE_21_0_180F",
        label="UE/21/0/180F",
        description="""UE/21/0/180F""",
    )

    ue_21_0_182 = VocabularyTerm(
        code="UE_21_0_182",
        label="UE/21/0/182",
        description="""UE/21/0/182""",
    )

    ue_21_0_184 = VocabularyTerm(
        code="UE_21_0_184",
        label="UE/21/0/184",
        description="""UE/21/0/184""",
    )

    ue_21_0_184b = VocabularyTerm(
        code="UE_21_0_184B",
        label="UE/21/0/184B",
        description="""UE/21/0/184B""",
    )

    ue_21_0_186 = VocabularyTerm(
        code="UE_21_0_186",
        label="UE/21/0/186",
        description="""UE/21/0/186""",
    )

    ue_21_0_186b = VocabularyTerm(
        code="UE_21_0_186B",
        label="UE/21/0/186B",
        description="""UE/21/0/186B""",
    )

    ue_21_0_aufzug = VocabularyTerm(
        code="UE_21_0_AUFZUG",
        label="UE/21/0/AUFZUG",
        description="""UE/21/0/AUFZUG""",
    )

    ue_21__1_033 = VocabularyTerm(
        code="UE_21_-1_033",
        label="UE/21/-1/033",
        description="""UE/21/-1/033""",
    )

    ue_21__1_034 = VocabularyTerm(
        code="UE_21_-1_034",
        label="UE/21/-1/034",
        description="""UE/21/-1/034""",
    )

    ue_21__1_035 = VocabularyTerm(
        code="UE_21_-1_035",
        label="UE/21/-1/035",
        description="""UE/21/-1/035""",
    )

    ue_21__1_035f = VocabularyTerm(
        code="UE_21_-1_035F",
        label="UE/21/-1/035F",
        description="""UE/21/-1/035F""",
    )

    ue_21__1_037 = VocabularyTerm(
        code="UE_21_-1_037",
        label="UE/21/-1/037",
        description="""UE/21/-1/037""",
    )

    ue_21__1_045 = VocabularyTerm(
        code="UE_21_-1_045",
        label="UE/21/-1/045",
        description="""UE/21/-1/045""",
    )

    ue_21__1_045b = VocabularyTerm(
        code="UE_21_-1_045B",
        label="UE/21/-1/045B",
        description="""UE/21/-1/045B""",
    )

    ue_21__1_047 = VocabularyTerm(
        code="UE_21_-1_047",
        label="UE/21/-1/047",
        description="""UE/21/-1/047""",
    )

    ue_21__1_049 = VocabularyTerm(
        code="UE_21_-1_049",
        label="UE/21/-1/049",
        description="""UE/21/-1/049""",
    )

    ue_21__1_056 = VocabularyTerm(
        code="UE_21_-1_056",
        label="UE/21/-1/056",
        description="""UE/21/-1/056""",
    )

    ue_21__1_056b = VocabularyTerm(
        code="UE_21_-1_056B",
        label="UE/21/-1/056B",
        description="""UE/21/-1/056B""",
    )

    ue_21__1_056f = VocabularyTerm(
        code="UE_21_-1_056F",
        label="UE/21/-1/056F",
        description="""UE/21/-1/056F""",
    )

    ue_21__1_056h = VocabularyTerm(
        code="UE_21_-1_056H",
        label="UE/21/-1/056H",
        description="""UE/21/-1/056H""",
    )

    ue_21__1_056t = VocabularyTerm(
        code="UE_21_-1_056T",
        label="UE/21/-1/056T",
        description="""UE/21/-1/056T""",
    )

    ue_21__1_057 = VocabularyTerm(
        code="UE_21_-1_057",
        label="UE/21/-1/057",
        description="""UE/21/-1/057""",
    )

    ue_21__1_058 = VocabularyTerm(
        code="UE_21_-1_058",
        label="UE/21/-1/058",
        description="""UE/21/-1/058""",
    )

    ue_21__1_059 = VocabularyTerm(
        code="UE_21_-1_059",
        label="UE/21/-1/059",
        description="""UE/21/-1/059""",
    )

    ue_21__1_060 = VocabularyTerm(
        code="UE_21_-1_060",
        label="UE/21/-1/060",
        description="""UE/21/-1/060""",
    )

    ue_21__1_060b = VocabularyTerm(
        code="UE_21_-1_060B",
        label="UE/21/-1/060B",
        description="""UE/21/-1/060B""",
    )

    ue_21__1_061 = VocabularyTerm(
        code="UE_21_-1_061",
        label="UE/21/-1/061",
        description="""UE/21/-1/061""",
    )

    ue_21__1_061b = VocabularyTerm(
        code="UE_21_-1_061B",
        label="UE/21/-1/061B",
        description="""UE/21/-1/061B""",
    )

    ue_21__1_061c = VocabularyTerm(
        code="UE_21_-1_061C",
        label="UE/21/-1/061C",
        description="""UE/21/-1/061C""",
    )

    ue_21__1_061d = VocabularyTerm(
        code="UE_21_-1_061D",
        label="UE/21/-1/061D",
        description="""UE/21/-1/061D""",
    )

    ue_21__1_062 = VocabularyTerm(
        code="UE_21_-1_062",
        label="UE/21/-1/062",
        description="""UE/21/-1/062""",
    )

    ue_21__1_062b = VocabularyTerm(
        code="UE_21_-1_062B",
        label="UE/21/-1/062B",
        description="""UE/21/-1/062B""",
    )

    ue_21__1_064 = VocabularyTerm(
        code="UE_21_-1_064",
        label="UE/21/-1/064",
        description="""UE/21/-1/064""",
    )

    ue_21__1_065 = VocabularyTerm(
        code="UE_21_-1_065",
        label="UE/21/-1/065",
        description="""UE/21/-1/065""",
    )

    ue_21__1_066 = VocabularyTerm(
        code="UE_21_-1_066",
        label="UE/21/-1/066",
        description="""UE/21/-1/066""",
    )

    ue_21__1_067 = VocabularyTerm(
        code="UE_21_-1_067",
        label="UE/21/-1/067",
        description="""UE/21/-1/067""",
    )

    ue_21__1_067b = VocabularyTerm(
        code="UE_21_-1_067B",
        label="UE/21/-1/067B",
        description="""UE/21/-1/067B""",
    )

    ue_21__1_068 = VocabularyTerm(
        code="UE_21_-1_068",
        label="UE/21/-1/068",
        description="""UE/21/-1/068""",
    )

    ue_21__1_069 = VocabularyTerm(
        code="UE_21_-1_069",
        label="UE/21/-1/069",
        description="""UE/21/-1/069""",
    )

    ue_21__1_069b = VocabularyTerm(
        code="UE_21_-1_069B",
        label="UE/21/-1/069B",
        description="""UE/21/-1/069B""",
    )

    ue_21__1_070b = VocabularyTerm(
        code="UE_21_-1_070B",
        label="UE/21/-1/070B",
        description="""UE/21/-1/070B""",
    )

    ue_21__1_070f = VocabularyTerm(
        code="UE_21_-1_070F",
        label="UE/21/-1/070F",
        description="""UE/21/-1/070F""",
    )

    ue_21__1_071 = VocabularyTerm(
        code="UE_21_-1_071",
        label="UE/21/-1/071",
        description="""UE/21/-1/071""",
    )

    ue_21__1_071t = VocabularyTerm(
        code="UE_21_-1_071T",
        label="UE/21/-1/071T",
        description="""UE/21/-1/071T""",
    )

    ue_21__1_072b = VocabularyTerm(
        code="UE_21_-1_072B",
        label="UE/21/-1/072B",
        description="""UE/21/-1/072B""",
    )

    ue_21__1_072c = VocabularyTerm(
        code="UE_21_-1_072C",
        label="UE/21/-1/072C",
        description="""UE/21/-1/072C""",
    )

    ue_21__1_072f = VocabularyTerm(
        code="UE_21_-1_072F",
        label="UE/21/-1/072F",
        description="""UE/21/-1/072F""",
    )

    ue_21__1_074f = VocabularyTerm(
        code="UE_21_-1_074F",
        label="UE/21/-1/074F",
        description="""UE/21/-1/074F""",
    )

    ue_21__1_074t = VocabularyTerm(
        code="UE_21_-1_074T",
        label="UE/21/-1/074T",
        description="""UE/21/-1/074T""",
    )

    ue_21__1_076 = VocabularyTerm(
        code="UE_21_-1_076",
        label="UE/21/-1/076",
        description="""UE/21/-1/076""",
    )

    ue_21__1_080 = VocabularyTerm(
        code="UE_21_-1_080",
        label="UE/21/-1/080",
        description="""UE/21/-1/080""",
    )

    ue_21__1_080b = VocabularyTerm(
        code="UE_21_-1_080B",
        label="UE/21/-1/080B",
        description="""UE/21/-1/080B""",
    )

    ue_21__1_082b = VocabularyTerm(
        code="UE_21_-1_082B",
        label="UE/21/-1/082B",
        description="""UE/21/-1/082B""",
    )

    ue_21__1_084 = VocabularyTerm(
        code="UE_21_-1_084",
        label="UE/21/-1/084",
        description="""UE/21/-1/084""",
    )

    ue_21__1_084b = VocabularyTerm(
        code="UE_21_-1_084B",
        label="UE/21/-1/084B",
        description="""UE/21/-1/084B""",
    )

    ue_21__1_084f = VocabularyTerm(
        code="UE_21_-1_084F",
        label="UE/21/-1/084F",
        description="""UE/21/-1/084F""",
    )

    ue_21__1_086 = VocabularyTerm(
        code="UE_21_-1_086",
        label="UE/21/-1/086",
        description="""UE/21/-1/086""",
    )

    ue_21__1_086b = VocabularyTerm(
        code="UE_21_-1_086B",
        label="UE/21/-1/086B",
        description="""UE/21/-1/086B""",
    )

    ue_21__1_086c = VocabularyTerm(
        code="UE_21_-1_086C",
        label="UE/21/-1/086C",
        description="""UE/21/-1/086C""",
    )

    ue_21__1_086f = VocabularyTerm(
        code="UE_21_-1_086F",
        label="UE/21/-1/086F",
        description="""UE/21/-1/086F""",
    )

    ue_21__1_090f = VocabularyTerm(
        code="UE_21_-1_090F",
        label="UE/21/-1/090F",
        description="""UE/21/-1/090F""",
    )

    ue_21__1_090t = VocabularyTerm(
        code="UE_21_-1_090T",
        label="UE/21/-1/090T",
        description="""UE/21/-1/090T""",
    )

    ue_21__1_092 = VocabularyTerm(
        code="UE_21_-1_092",
        label="UE/21/-1/092",
        description="""UE/21/-1/092""",
    )

    ue_21__1_092f = VocabularyTerm(
        code="UE_21_-1_092F",
        label="UE/21/-1/092F",
        description="""UE/21/-1/092F""",
    )

    ue_21__1_094 = VocabularyTerm(
        code="UE_21_-1_094",
        label="UE/21/-1/094",
        description="""UE/21/-1/094""",
    )

    ue_21__1_094b = VocabularyTerm(
        code="UE_21_-1_094B",
        label="UE/21/-1/094B",
        description="""UE/21/-1/094B""",
    )

    ue_21__1_096 = VocabularyTerm(
        code="UE_21_-1_096",
        label="UE/21/-1/096",
        description="""UE/21/-1/096""",
    )

    ue_21__1_096b = VocabularyTerm(
        code="UE_21_-1_096B",
        label="UE/21/-1/096B",
        description="""UE/21/-1/096B""",
    )

    ue_21__1_098 = VocabularyTerm(
        code="UE_21_-1_098",
        label="UE/21/-1/098",
        description="""UE/21/-1/098""",
    )

    ue_21__1_098b = VocabularyTerm(
        code="UE_21_-1_098B",
        label="UE/21/-1/098B",
        description="""UE/21/-1/098B""",
    )

    ue_21__1_098f = VocabularyTerm(
        code="UE_21_-1_098F",
        label="UE/21/-1/098F",
        description="""UE/21/-1/098F""",
    )

    ue_21__1_aufzug = VocabularyTerm(
        code="UE_21_-1_AUFZUG",
        label="UE/21/-1/AUFZUG",
        description="""UE/21/-1/AUFZUG""",
    )

    ue_22_0_138 = VocabularyTerm(
        code="UE_22_0_138",
        label="UE/22/0/138",
        description="""UE/22/0/138""",
    )

    ue_22__1_038 = VocabularyTerm(
        code="UE_22_-1_038",
        label="UE/22/-1/038",
        description="""UE/22/-1/038""",
    )

    ue_22__1_038t = VocabularyTerm(
        code="UE_22_-1_038T",
        label="UE/22/-1/038T",
        description="""UE/22/-1/038T""",
    )

    ue_23_0_100 = VocabularyTerm(
        code="UE_23_0_100",
        label="UE/23/0/100",
        description="""UE/23/0/100""",
    )

    ue_23_0_101t = VocabularyTerm(
        code="UE_23_0_101T",
        label="UE/23/0/101T",
        description="""UE/23/0/101T""",
    )

    ue_23_0_102 = VocabularyTerm(
        code="UE_23_0_102",
        label="UE/23/0/102",
        description="""UE/23/0/102""",
    )

    ue_23_0_103 = VocabularyTerm(
        code="UE_23_0_103",
        label="UE/23/0/103",
        description="""UE/23/0/103""",
    )

    ue_23_0_103_mob = VocabularyTerm(
        code="UE_23_0_103_MOB",
        label="UE/23/0/103 MOB",
        description="""UE/23/0/103 MOB""",
    )

    ue_23_0_104 = VocabularyTerm(
        code="UE_23_0_104",
        label="UE/23/0/104",
        description="""UE/23/0/104""",
    )

    ue_23_0_110 = VocabularyTerm(
        code="UE_23_0_110",
        label="UE/23/0/110",
        description="""UE/23/0/110""",
    )

    ue_23_0_112 = VocabularyTerm(
        code="UE_23_0_112",
        label="UE/23/0/112",
        description="""UE/23/0/112""",
    )

    ue_23_0_112h = VocabularyTerm(
        code="UE_23_0_112H",
        label="UE/23/0/112H",
        description="""UE/23/0/112H""",
    )

    ue_23_0_114b = VocabularyTerm(
        code="UE_23_0_114B",
        label="UE/23/0/114B",
        description="""UE/23/0/114B""",
    )

    ue_23_0_114t = VocabularyTerm(
        code="UE_23_0_114T",
        label="UE/23/0/114T",
        description="""UE/23/0/114T""",
    )

    ue_23_0_116b = VocabularyTerm(
        code="UE_23_0_116B",
        label="UE/23/0/116B",
        description="""UE/23/0/116B""",
    )

    ue_23_0_118 = VocabularyTerm(
        code="UE_23_0_118",
        label="UE/23/0/118",
        description="""UE/23/0/118""",
    )

    ue_23_0_120 = VocabularyTerm(
        code="UE_23_0_120",
        label="UE/23/0/120",
        description="""UE/23/0/120""",
    )

    ue_23_0_122 = VocabularyTerm(
        code="UE_23_0_122",
        label="UE/23/0/122",
        description="""UE/23/0/122""",
    )

    ue_23_0_124 = VocabularyTerm(
        code="UE_23_0_124",
        label="UE/23/0/124",
        description="""UE/23/0/124""",
    )

    ue_23_0_126b = VocabularyTerm(
        code="UE_23_0_126B",
        label="UE/23/0/126B",
        description="""UE/23/0/126B""",
    )

    ue_23_0_130 = VocabularyTerm(
        code="UE_23_0_130",
        label="UE/23/0/130",
        description="""UE/23/0/130""",
    )

    ue_23_0_130b = VocabularyTerm(
        code="UE_23_0_130B",
        label="UE/23/0/130B",
        description="""UE/23/0/130B""",
    )

    ue_23_0_131 = VocabularyTerm(
        code="UE_23_0_131",
        label="UE/23/0/131",
        description="""UE/23/0/131""",
    )

    ue_23_0_132 = VocabularyTerm(
        code="UE_23_0_132",
        label="UE/23/0/132",
        description="""UE/23/0/132""",
    )

    ue_23_0_134 = VocabularyTerm(
        code="UE_23_0_134",
        label="UE/23/0/134",
        description="""UE/23/0/134""",
    )

    ue_23_0_134t = VocabularyTerm(
        code="UE_23_0_134T",
        label="UE/23/0/134T",
        description="""UE/23/0/134T""",
    )

    ue_23_0_136 = VocabularyTerm(
        code="UE_23_0_136",
        label="UE/23/0/136",
        description="""UE/23/0/136""",
    )

    ue_23_0_139 = VocabularyTerm(
        code="UE_23_0_139",
        label="UE/23/0/139",
        description="""UE/23/0/139""",
    )

    ue_23_0_a1 = VocabularyTerm(
        code="UE_23_0_A1",
        label="UE/23/0/A1",
        description="""UE/23/0/A1""",
    )

    ue_23_0_a2 = VocabularyTerm(
        code="UE_23_0_A2",
        label="UE/23/0/A2",
        description="""UE/23/0/A2""",
    )

    ue_23_1a_101a = VocabularyTerm(
        code="UE_23_1A_101A",
        label="UE/23/1A/101A",
        description="""UE/23/1A/101A""",
    )

    ue_23_1a_101at = VocabularyTerm(
        code="UE_23_1A_101AT",
        label="UE/23/1A/101AT",
        description="""UE/23/1A/101AT""",
    )

    ue_23_1a_102af = VocabularyTerm(
        code="UE_23_1A_102AF",
        label="UE/23/1A/102AF",
        description="""UE/23/1A/102AF""",
    )

    ue_23_1a_104a = VocabularyTerm(
        code="UE_23_1A_104A",
        label="UE/23/1A/104A",
        description="""UE/23/1A/104A""",
    )

    ue_23_1a_108a = VocabularyTerm(
        code="UE_23_1A_108A",
        label="UE/23/1A/108A",
        description="""UE/23/1A/108A""",
    )

    ue_23_1a_110a = VocabularyTerm(
        code="UE_23_1A_110A",
        label="UE/23/1A/110A",
        description="""UE/23/1A/110A""",
    )

    ue_23_1a_112a = VocabularyTerm(
        code="UE_23_1A_112A",
        label="UE/23/1A/112A",
        description="""UE/23/1A/112A""",
    )

    ue_23_1a_112ad = VocabularyTerm(
        code="UE_23_1A_112AD",
        label="UE/23/1A/112AD",
        description="""UE/23/1A/112AD""",
    )

    ue_23_1a_114at = VocabularyTerm(
        code="UE_23_1A_114AT",
        label="UE/23/1A/114AT",
        description="""UE/23/1A/114AT""",
    )

    ue_23_1a_116a = VocabularyTerm(
        code="UE_23_1A_116A",
        label="UE/23/1A/116A",
        description="""UE/23/1A/116A""",
    )

    ue_23_1a_124a = VocabularyTerm(
        code="UE_23_1A_124A",
        label="UE/23/1A/124A",
        description="""UE/23/1A/124A""",
    )

    ue_23_1a_130a = VocabularyTerm(
        code="UE_23_1A_130A",
        label="UE/23/1A/130A",
        description="""UE/23/1A/130A""",
    )

    ue_23_1a_131a = VocabularyTerm(
        code="UE_23_1A_131A",
        label="UE/23/1A/131A",
        description="""UE/23/1A/131A""",
    )

    ue_23_1a_134at = VocabularyTerm(
        code="UE_23_1A_134AT",
        label="UE/23/1A/134AT",
        description="""UE/23/1A/134AT""",
    )

    ue_23_1a_a1 = VocabularyTerm(
        code="UE_23_1A_A1",
        label="UE/23/1A/A1",
        description="""UE/23/1A/A1""",
    )

    ue_23_1a_a2 = VocabularyTerm(
        code="UE_23_1A_A2",
        label="UE/23/1A/A2",
        description="""UE/23/1A/A2""",
    )

    ue_23_1_201t = VocabularyTerm(
        code="UE_23_1_201T",
        label="UE/23/1/201T",
        description="""UE/23/1/201T""",
    )

    ue_23_1_202 = VocabularyTerm(
        code="UE_23_1_202",
        label="UE/23/1/202",
        description="""UE/23/1/202""",
    )

    ue_23_1_202f = VocabularyTerm(
        code="UE_23_1_202F",
        label="UE/23/1/202F",
        description="""UE/23/1/202F""",
    )

    ue_23_1_203 = VocabularyTerm(
        code="UE_23_1_203",
        label="UE/23/1/203",
        description="""UE/23/1/203""",
    )

    ue_23_1_204 = VocabularyTerm(
        code="UE_23_1_204",
        label="UE/23/1/204",
        description="""UE/23/1/204""",
    )

    ue_23_1_206 = VocabularyTerm(
        code="UE_23_1_206",
        label="UE/23/1/206",
        description="""UE/23/1/206""",
    )

    ue_23_1_207b = VocabularyTerm(
        code="UE_23_1_207B",
        label="UE/23/1/207B",
        description="""UE/23/1/207B""",
    )

    ue_23_1_208 = VocabularyTerm(
        code="UE_23_1_208",
        label="UE/23/1/208",
        description="""UE/23/1/208""",
    )

    ue_23_1_209 = VocabularyTerm(
        code="UE_23_1_209",
        label="UE/23/1/209",
        description="""UE/23/1/209""",
    )

    ue_23_1_210 = VocabularyTerm(
        code="UE_23_1_210",
        label="UE/23/1/210",
        description="""UE/23/1/210""",
    )

    ue_23_1_211 = VocabularyTerm(
        code="UE_23_1_211",
        label="UE/23/1/211",
        description="""UE/23/1/211""",
    )

    ue_23_1_212 = VocabularyTerm(
        code="UE_23_1_212",
        label="UE/23/1/212",
        description="""UE/23/1/212""",
    )

    ue_23_1_213 = VocabularyTerm(
        code="UE_23_1_213",
        label="UE/23/1/213",
        description="""UE/23/1/213""",
    )

    ue_23_1_214 = VocabularyTerm(
        code="UE_23_1_214",
        label="UE/23/1/214",
        description="""UE/23/1/214""",
    )

    ue_23_1_216 = VocabularyTerm(
        code="UE_23_1_216",
        label="UE/23/1/216",
        description="""UE/23/1/216""",
    )

    ue_23_1_217 = VocabularyTerm(
        code="UE_23_1_217",
        label="UE/23/1/217",
        description="""UE/23/1/217""",
    )

    ue_23_1_218 = VocabularyTerm(
        code="UE_23_1_218",
        label="UE/23/1/218",
        description="""UE/23/1/218""",
    )

    ue_23_1_219 = VocabularyTerm(
        code="UE_23_1_219",
        label="UE/23/1/219",
        description="""UE/23/1/219""",
    )

    ue_23_1_220 = VocabularyTerm(
        code="UE_23_1_220",
        label="UE/23/1/220",
        description="""UE/23/1/220""",
    )

    ue_23_1_221 = VocabularyTerm(
        code="UE_23_1_221",
        label="UE/23/1/221",
        description="""UE/23/1/221""",
    )

    ue_23_1_222 = VocabularyTerm(
        code="UE_23_1_222",
        label="UE/23/1/222",
        description="""UE/23/1/222""",
    )

    ue_23_1_223 = VocabularyTerm(
        code="UE_23_1_223",
        label="UE/23/1/223",
        description="""UE/23/1/223""",
    )

    ue_23_1_225 = VocabularyTerm(
        code="UE_23_1_225",
        label="UE/23/1/225",
        description="""UE/23/1/225""",
    )

    ue_23_1_226 = VocabularyTerm(
        code="UE_23_1_226",
        label="UE/23/1/226",
        description="""UE/23/1/226""",
    )

    ue_23_1_227 = VocabularyTerm(
        code="UE_23_1_227",
        label="UE/23/1/227",
        description="""UE/23/1/227""",
    )

    ue_23_1_228 = VocabularyTerm(
        code="UE_23_1_228",
        label="UE/23/1/228",
        description="""UE/23/1/228""",
    )

    ue_23_1_229 = VocabularyTerm(
        code="UE_23_1_229",
        label="UE/23/1/229",
        description="""UE/23/1/229""",
    )

    ue_23_1_230d = VocabularyTerm(
        code="UE_23_1_230D",
        label="UE/23/1/230D",
        description="""UE/23/1/230D""",
    )

    ue_23_1_231b = VocabularyTerm(
        code="UE_23_1_231B",
        label="UE/23/1/231B",
        description="""UE/23/1/231B""",
    )

    ue_23_1_231h = VocabularyTerm(
        code="UE_23_1_231H",
        label="UE/23/1/231H",
        description="""UE/23/1/231H""",
    )

    ue_23_1_234t = VocabularyTerm(
        code="UE_23_1_234T",
        label="UE/23/1/234T",
        description="""UE/23/1/234T""",
    )

    ue_23_1_a1 = VocabularyTerm(
        code="UE_23_1_A1",
        label="UE/23/1/A1",
        description="""UE/23/1/A1""",
    )

    ue_23_1_a2 = VocabularyTerm(
        code="UE_23_1_A2",
        label="UE/23/1/A2",
        description="""UE/23/1/A2""",
    )

    ue_23_2a_101aaf = VocabularyTerm(
        code="UE_23_2A_101AAF",
        label="UE/23/2A/101AAF",
        description="""UE/23/2A/101AAF""",
    )

    ue_23_2a_101aat = VocabularyTerm(
        code="UE_23_2A_101AAT",
        label="UE/23/2A/101AAT",
        description="""UE/23/2A/101AAT""",
    )

    ue_23_2a_132aaf = VocabularyTerm(
        code="UE_23_2A_132AAF",
        label="UE/23/2A/132AAF",
        description="""UE/23/2A/132AAF""",
    )

    ue_23_2a_134aat = VocabularyTerm(
        code="UE_23_2A_134AAT",
        label="UE/23/2A/134AAT",
        description="""UE/23/2A/134AAT""",
    )

    ue_23_2a_a1 = VocabularyTerm(
        code="UE_23_2A_A1",
        label="UE/23/2A/A1",
        description="""UE/23/2A/A1""",
    )

    ue_23_2a_a2 = VocabularyTerm(
        code="UE_23_2A_A2",
        label="UE/23/2A/A2",
        description="""UE/23/2A/A2""",
    )

    ue_23_2_301t = VocabularyTerm(
        code="UE_23_2_301T",
        label="UE/23/2/301T",
        description="""UE/23/2/301T""",
    )

    ue_23_2_302 = VocabularyTerm(
        code="UE_23_2_302",
        label="UE/23/2/302",
        description="""UE/23/2/302""",
    )

    ue_23_2_302f = VocabularyTerm(
        code="UE_23_2_302F",
        label="UE/23/2/302F",
        description="""UE/23/2/302F""",
    )

    ue_23_2_303 = VocabularyTerm(
        code="UE_23_2_303",
        label="UE/23/2/303",
        description="""UE/23/2/303""",
    )

    ue_23_2_304 = VocabularyTerm(
        code="UE_23_2_304",
        label="UE/23/2/304",
        description="""UE/23/2/304""",
    )

    ue_23_2_306 = VocabularyTerm(
        code="UE_23_2_306",
        label="UE/23/2/306",
        description="""UE/23/2/306""",
    )

    ue_23_2_307 = VocabularyTerm(
        code="UE_23_2_307",
        label="UE/23/2/307",
        description="""UE/23/2/307""",
    )

    ue_23_2_308 = VocabularyTerm(
        code="UE_23_2_308",
        label="UE/23/2/308",
        description="""UE/23/2/308""",
    )

    ue_23_2_310 = VocabularyTerm(
        code="UE_23_2_310",
        label="UE/23/2/310",
        description="""UE/23/2/310""",
    )

    ue_23_2_311 = VocabularyTerm(
        code="UE_23_2_311",
        label="UE/23/2/311",
        description="""UE/23/2/311""",
    )

    ue_23_2_312 = VocabularyTerm(
        code="UE_23_2_312",
        label="UE/23/2/312",
        description="""UE/23/2/312""",
    )

    ue_23_2_313 = VocabularyTerm(
        code="UE_23_2_313",
        label="UE/23/2/313",
        description="""UE/23/2/313""",
    )

    ue_23_2_314 = VocabularyTerm(
        code="UE_23_2_314",
        label="UE/23/2/314",
        description="""UE/23/2/314""",
    )

    ue_23_2_315 = VocabularyTerm(
        code="UE_23_2_315",
        label="UE/23/2/315",
        description="""UE/23/2/315""",
    )

    ue_23_2_316 = VocabularyTerm(
        code="UE_23_2_316",
        label="UE/23/2/316",
        description="""UE/23/2/316""",
    )

    ue_23_2_317 = VocabularyTerm(
        code="UE_23_2_317",
        label="UE/23/2/317",
        description="""UE/23/2/317""",
    )

    ue_23_2_318 = VocabularyTerm(
        code="UE_23_2_318",
        label="UE/23/2/318",
        description="""UE/23/2/318""",
    )

    ue_23_2_319 = VocabularyTerm(
        code="UE_23_2_319",
        label="UE/23/2/319",
        description="""UE/23/2/319""",
    )

    ue_23_2_320 = VocabularyTerm(
        code="UE_23_2_320",
        label="UE/23/2/320",
        description="""UE/23/2/320""",
    )

    ue_23_2_321 = VocabularyTerm(
        code="UE_23_2_321",
        label="UE/23/2/321",
        description="""UE/23/2/321""",
    )

    ue_23_2_322 = VocabularyTerm(
        code="UE_23_2_322",
        label="UE/23/2/322",
        description="""UE/23/2/322""",
    )

    ue_23_2_323 = VocabularyTerm(
        code="UE_23_2_323",
        label="UE/23/2/323",
        description="""UE/23/2/323""",
    )

    ue_23_2_324 = VocabularyTerm(
        code="UE_23_2_324",
        label="UE/23/2/324",
        description="""UE/23/2/324""",
    )

    ue_23_2_325 = VocabularyTerm(
        code="UE_23_2_325",
        label="UE/23/2/325",
        description="""UE/23/2/325""",
    )

    ue_23_2_326 = VocabularyTerm(
        code="UE_23_2_326",
        label="UE/23/2/326",
        description="""UE/23/2/326""",
    )

    ue_23_2_327 = VocabularyTerm(
        code="UE_23_2_327",
        label="UE/23/2/327",
        description="""UE/23/2/327""",
    )

    ue_23_2_328 = VocabularyTerm(
        code="UE_23_2_328",
        label="UE/23/2/328",
        description="""UE/23/2/328""",
    )

    ue_23_2_330d = VocabularyTerm(
        code="UE_23_2_330D",
        label="UE/23/2/330D",
        description="""UE/23/2/330D""",
    )

    ue_23_2_331b = VocabularyTerm(
        code="UE_23_2_331B",
        label="UE/23/2/331B",
        description="""UE/23/2/331B""",
    )

    ue_23_2_331h = VocabularyTerm(
        code="UE_23_2_331H",
        label="UE/23/2/331H",
        description="""UE/23/2/331H""",
    )

    ue_23_2_334t = VocabularyTerm(
        code="UE_23_2_334T",
        label="UE/23/2/334T",
        description="""UE/23/2/334T""",
    )

    ue_23_2_a1 = VocabularyTerm(
        code="UE_23_2_A1",
        label="UE/23/2/A1",
        description="""UE/23/2/A1""",
    )

    ue_23_2_a2 = VocabularyTerm(
        code="UE_23_2_A2",
        label="UE/23/2/A2",
        description="""UE/23/2/A2""",
    )

    ue_23_3_401t = VocabularyTerm(
        code="UE_23_3_401T",
        label="UE/23/3/401T",
        description="""UE/23/3/401T""",
    )

    ue_23_3_402 = VocabularyTerm(
        code="UE_23_3_402",
        label="UE/23/3/402",
        description="""UE/23/3/402""",
    )

    ue_23_3_402f = VocabularyTerm(
        code="UE_23_3_402F",
        label="UE/23/3/402F",
        description="""UE/23/3/402F""",
    )

    ue_23_3_403 = VocabularyTerm(
        code="UE_23_3_403",
        label="UE/23/3/403",
        description="""UE/23/3/403""",
    )

    ue_23_3_405 = VocabularyTerm(
        code="UE_23_3_405",
        label="UE/23/3/405",
        description="""UE/23/3/405""",
    )

    ue_23_3_406 = VocabularyTerm(
        code="UE_23_3_406",
        label="UE/23/3/406",
        description="""UE/23/3/406""",
    )

    ue_23_3_408 = VocabularyTerm(
        code="UE_23_3_408",
        label="UE/23/3/408",
        description="""UE/23/3/408""",
    )

    ue_23_3_409 = VocabularyTerm(
        code="UE_23_3_409",
        label="UE/23/3/409",
        description="""UE/23/3/409""",
    )

    ue_23_3_410 = VocabularyTerm(
        code="UE_23_3_410",
        label="UE/23/3/410",
        description="""UE/23/3/410""",
    )

    ue_23_3_411 = VocabularyTerm(
        code="UE_23_3_411",
        label="UE/23/3/411",
        description="""UE/23/3/411""",
    )

    ue_23_3_412 = VocabularyTerm(
        code="UE_23_3_412",
        label="UE/23/3/412",
        description="""UE/23/3/412""",
    )

    ue_23_3_413 = VocabularyTerm(
        code="UE_23_3_413",
        label="UE/23/3/413",
        description="""UE/23/3/413""",
    )

    ue_23_3_414 = VocabularyTerm(
        code="UE_23_3_414",
        label="UE/23/3/414",
        description="""UE/23/3/414""",
    )

    ue_23_3_415 = VocabularyTerm(
        code="UE_23_3_415",
        label="UE/23/3/415",
        description="""UE/23/3/415""",
    )

    ue_23_3_416 = VocabularyTerm(
        code="UE_23_3_416",
        label="UE/23/3/416",
        description="""UE/23/3/416""",
    )

    ue_23_3_417 = VocabularyTerm(
        code="UE_23_3_417",
        label="UE/23/3/417",
        description="""UE/23/3/417""",
    )

    ue_23_3_418 = VocabularyTerm(
        code="UE_23_3_418",
        label="UE/23/3/418",
        description="""UE/23/3/418""",
    )

    ue_23_3_420 = VocabularyTerm(
        code="UE_23_3_420",
        label="UE/23/3/420",
        description="""UE/23/3/420""",
    )

    ue_23_3_421 = VocabularyTerm(
        code="UE_23_3_421",
        label="UE/23/3/421",
        description="""UE/23/3/421""",
    )

    ue_23_3_424 = VocabularyTerm(
        code="UE_23_3_424",
        label="UE/23/3/424",
        description="""UE/23/3/424""",
    )

    ue_23_3_425 = VocabularyTerm(
        code="UE_23_3_425",
        label="UE/23/3/425",
        description="""UE/23/3/425""",
    )

    ue_23_3_427 = VocabularyTerm(
        code="UE_23_3_427",
        label="UE/23/3/427",
        description="""UE/23/3/427""",
    )

    ue_23_3_428 = VocabularyTerm(
        code="UE_23_3_428",
        label="UE/23/3/428",
        description="""UE/23/3/428""",
    )

    ue_23_3_430d = VocabularyTerm(
        code="UE_23_3_430D",
        label="UE/23/3/430D",
        description="""UE/23/3/430D""",
    )

    ue_23_3_431b = VocabularyTerm(
        code="UE_23_3_431B",
        label="UE/23/3/431B",
        description="""UE/23/3/431B""",
    )

    ue_23_3_431h = VocabularyTerm(
        code="UE_23_3_431H",
        label="UE/23/3/431H",
        description="""UE/23/3/431H""",
    )

    ue_23_3_434t = VocabularyTerm(
        code="UE_23_3_434T",
        label="UE/23/3/434T",
        description="""UE/23/3/434T""",
    )

    ue_23_3_a1 = VocabularyTerm(
        code="UE_23_3_A1",
        label="UE/23/3/A1",
        description="""UE/23/3/A1""",
    )

    ue_23_3_a2 = VocabularyTerm(
        code="UE_23_3_A2",
        label="UE/23/3/A2",
        description="""UE/23/3/A2""",
    )

    ue_23_4_501 = VocabularyTerm(
        code="UE_23_4_501",
        label="UE/23/4/501",
        description="""UE/23/4/501""",
    )

    ue_23_4_501t = VocabularyTerm(
        code="UE_23_4_501T",
        label="UE/23/4/501T",
        description="""UE/23/4/501T""",
    )

    ue_23_4_502 = VocabularyTerm(
        code="UE_23_4_502",
        label="UE/23/4/502",
        description="""UE/23/4/502""",
    )

    ue_23_4_507 = VocabularyTerm(
        code="UE_23_4_507",
        label="UE/23/4/507",
        description="""UE/23/4/507""",
    )

    ue_23_4_509 = VocabularyTerm(
        code="UE_23_4_509",
        label="UE/23/4/509",
        description="""UE/23/4/509""",
    )

    ue_23_4_512 = VocabularyTerm(
        code="UE_23_4_512",
        label="UE/23/4/512",
        description="""UE/23/4/512""",
    )

    ue_23_4_530 = VocabularyTerm(
        code="UE_23_4_530",
        label="UE/23/4/530",
        description="""UE/23/4/530""",
    )

    ue_23_4_532 = VocabularyTerm(
        code="UE_23_4_532",
        label="UE/23/4/532",
        description="""UE/23/4/532""",
    )

    ue_23_4_534t = VocabularyTerm(
        code="UE_23_4_534T",
        label="UE/23/4/534T",
        description="""UE/23/4/534T""",
    )

    ue_23__1_001at = VocabularyTerm(
        code="UE_23_-1_001AT",
        label="UE/23/-1/001AT",
        description="""UE/23/-1/001AT""",
    )

    ue_23__1_002a = VocabularyTerm(
        code="UE_23_-1_002A",
        label="UE/23/-1/002A",
        description="""UE/23/-1/002A""",
    )

    ue_23__1_002at = VocabularyTerm(
        code="UE_23_-1_002AT",
        label="UE/23/-1/002AT",
        description="""UE/23/-1/002AT""",
    )

    ue_23__1_003a = VocabularyTerm(
        code="UE_23_-1_003A",
        label="UE/23/-1/003A",
        description="""UE/23/-1/003A""",
    )

    ue_23__1_003ab = VocabularyTerm(
        code="UE_23_-1_003AB",
        label="UE/23/-1/003AB",
        description="""UE/23/-1/003AB""",
    )

    ue_23__1_010a = VocabularyTerm(
        code="UE_23_-1_010A",
        label="UE/23/-1/010A",
        description="""UE/23/-1/010A""",
    )

    ue_23__1_010ab = VocabularyTerm(
        code="UE_23_-1_010AB",
        label="UE/23/-1/010AB",
        description="""UE/23/-1/010AB""",
    )

    ue_23__1_012ah = VocabularyTerm(
        code="UE_23_-1_012AH",
        label="UE/23/-1/012AH",
        description="""UE/23/-1/012AH""",
    )

    ue_23__1_013a = VocabularyTerm(
        code="UE_23_-1_013A",
        label="UE/23/-1/013A",
        description="""UE/23/-1/013A""",
    )

    ue_23__1_013af = VocabularyTerm(
        code="UE_23_-1_013AF",
        label="UE/23/-1/013AF",
        description="""UE/23/-1/013AF""",
    )

    ue_23__1_014at = VocabularyTerm(
        code="UE_23_-1_014AT",
        label="UE/23/-1/014AT",
        description="""UE/23/-1/014AT""",
    )

    ue_23__1_015a = VocabularyTerm(
        code="UE_23_-1_015A",
        label="UE/23/-1/015A",
        description="""UE/23/-1/015A""",
    )

    ue_23__1_017a = VocabularyTerm(
        code="UE_23_-1_017A",
        label="UE/23/-1/017A",
        description="""UE/23/-1/017A""",
    )

    ue_23__1_018a = VocabularyTerm(
        code="UE_23_-1_018A",
        label="UE/23/-1/018A",
        description="""UE/23/-1/018A""",
    )

    ue_23__1_022a = VocabularyTerm(
        code="UE_23_-1_022A",
        label="UE/23/-1/022A",
        description="""UE/23/-1/022A""",
    )

    ue_23__1_026a = VocabularyTerm(
        code="UE_23_-1_026A",
        label="UE/23/-1/026A",
        description="""UE/23/-1/026A""",
    )

    ue_23__1_030a = VocabularyTerm(
        code="UE_23_-1_030A",
        label="UE/23/-1/030A",
        description="""UE/23/-1/030A""",
    )

    ue_23__1_031a = VocabularyTerm(
        code="UE_23_-1_031A",
        label="UE/23/-1/031A",
        description="""UE/23/-1/031A""",
    )

    ue_23__1_034at = VocabularyTerm(
        code="UE_23_-1_034AT",
        label="UE/23/-1/034AT",
        description="""UE/23/-1/034AT""",
    )

    ue_23__1_037a = VocabularyTerm(
        code="UE_23_-1_037A",
        label="UE/23/-1/037A",
        description="""UE/23/-1/037A""",
    )

    ue_23__1_038a = VocabularyTerm(
        code="UE_23_-1_038A",
        label="UE/23/-1/038A",
        description="""UE/23/-1/038A""",
    )

    ue_23__1_a1 = VocabularyTerm(
        code="UE_23_-1_A1",
        label="UE/23/-1/A1",
        description="""UE/23/-1/A1""",
    )

    ue_23__1_a2 = VocabularyTerm(
        code="UE_23_-1_A2",
        label="UE/23/-1/A2",
        description="""UE/23/-1/A2""",
    )

    ue_23__2_001t = VocabularyTerm(
        code="UE_23_-2_001T",
        label="UE/23/-2/001T",
        description="""UE/23/-2/001T""",
    )

    ue_23__2_002 = VocabularyTerm(
        code="UE_23_-2_002",
        label="UE/23/-2/002",
        description="""UE/23/-2/002""",
    )

    ue_23__2_002b = VocabularyTerm(
        code="UE_23_-2_002B",
        label="UE/23/-2/002B",
        description="""UE/23/-2/002B""",
    )

    ue_23__2_002f = VocabularyTerm(
        code="UE_23_-2_002F",
        label="UE/23/-2/002F",
        description="""UE/23/-2/002F""",
    )

    ue_23__2_002t = VocabularyTerm(
        code="UE_23_-2_002T",
        label="UE/23/-2/002T",
        description="""UE/23/-2/002T""",
    )

    ue_23__2_003 = VocabularyTerm(
        code="UE_23_-2_003",
        label="UE/23/-2/003",
        description="""UE/23/-2/003""",
    )

    ue_23__2_003f = VocabularyTerm(
        code="UE_23_-2_003F",
        label="UE/23/-2/003F",
        description="""UE/23/-2/003F""",
    )

    ue_23__2_006 = VocabularyTerm(
        code="UE_23_-2_006",
        label="UE/23/-2/006",
        description="""UE/23/-2/006""",
    )

    ue_23__2_007 = VocabularyTerm(
        code="UE_23_-2_007",
        label="UE/23/-2/007",
        description="""UE/23/-2/007""",
    )

    ue_23__2_009b = VocabularyTerm(
        code="UE_23_-2_009B",
        label="UE/23/-2/009B",
        description="""UE/23/-2/009B""",
    )

    ue_23__2_010b = VocabularyTerm(
        code="UE_23_-2_010B",
        label="UE/23/-2/010B",
        description="""UE/23/-2/010B""",
    )

    ue_23__2_012 = VocabularyTerm(
        code="UE_23_-2_012",
        label="UE/23/-2/012",
        description="""UE/23/-2/012""",
    )

    ue_23__2_012b = VocabularyTerm(
        code="UE_23_-2_012B",
        label="UE/23/-2/012B",
        description="""UE/23/-2/012B""",
    )

    ue_23__2_012c = VocabularyTerm(
        code="UE_23_-2_012C",
        label="UE/23/-2/012C",
        description="""UE/23/-2/012C""",
    )

    ue_23__2_013b = VocabularyTerm(
        code="UE_23_-2_013B",
        label="UE/23/-2/013B",
        description="""UE/23/-2/013B""",
    )

    ue_23__2_014b = VocabularyTerm(
        code="UE_23_-2_014B",
        label="UE/23/-2/014B",
        description="""UE/23/-2/014B""",
    )

    ue_23__2_014d = VocabularyTerm(
        code="UE_23_-2_014D",
        label="UE/23/-2/014D",
        description="""UE/23/-2/014D""",
    )

    ue_23__2_014h = VocabularyTerm(
        code="UE_23_-2_014H",
        label="UE/23/-2/014H",
        description="""UE/23/-2/014H""",
    )

    ue_23__2_014t = VocabularyTerm(
        code="UE_23_-2_014T",
        label="UE/23/-2/014T",
        description="""UE/23/-2/014T""",
    )

    ue_23__2_015 = VocabularyTerm(
        code="UE_23_-2_015",
        label="UE/23/-2/015",
        description="""UE/23/-2/015""",
    )

    ue_23__2_016f = VocabularyTerm(
        code="UE_23_-2_016F",
        label="UE/23/-2/016F",
        description="""UE/23/-2/016F""",
    )

    ue_23__2_018 = VocabularyTerm(
        code="UE_23_-2_018",
        label="UE/23/-2/018",
        description="""UE/23/-2/018""",
    )

    ue_23__2_019f = VocabularyTerm(
        code="UE_23_-2_019F",
        label="UE/23/-2/019F",
        description="""UE/23/-2/019F""",
    )

    ue_23__2_020 = VocabularyTerm(
        code="UE_23_-2_020",
        label="UE/23/-2/020",
        description="""UE/23/-2/020""",
    )

    ue_23__2_020b = VocabularyTerm(
        code="UE_23_-2_020B",
        label="UE/23/-2/020B",
        description="""UE/23/-2/020B""",
    )

    ue_23__2_022 = VocabularyTerm(
        code="UE_23_-2_022",
        label="UE/23/-2/022",
        description="""UE/23/-2/022""",
    )

    ue_23__2_023b = VocabularyTerm(
        code="UE_23_-2_023B",
        label="UE/23/-2/023B",
        description="""UE/23/-2/023B""",
    )

    ue_23__2_025b = VocabularyTerm(
        code="UE_23_-2_025B",
        label="UE/23/-2/025B",
        description="""UE/23/-2/025B""",
    )

    ue_23__2_026 = VocabularyTerm(
        code="UE_23_-2_026",
        label="UE/23/-2/026",
        description="""UE/23/-2/026""",
    )

    ue_23__2_027 = VocabularyTerm(
        code="UE_23_-2_027",
        label="UE/23/-2/027",
        description="""UE/23/-2/027""",
    )

    ue_23__2_027b = VocabularyTerm(
        code="UE_23_-2_027B",
        label="UE/23/-2/027B",
        description="""UE/23/-2/027B""",
    )

    ue_23__2_029b = VocabularyTerm(
        code="UE_23_-2_029B",
        label="UE/23/-2/029B",
        description="""UE/23/-2/029B""",
    )

    ue_23__2_030 = VocabularyTerm(
        code="UE_23_-2_030",
        label="UE/23/-2/030",
        description="""UE/23/-2/030""",
    )

    ue_23__2_031f = VocabularyTerm(
        code="UE_23_-2_031F",
        label="UE/23/-2/031F",
        description="""UE/23/-2/031F""",
    )

    ue_23__2_031t = VocabularyTerm(
        code="UE_23_-2_031T",
        label="UE/23/-2/031T",
        description="""UE/23/-2/031T""",
    )

    ue_23__2_034 = VocabularyTerm(
        code="UE_23_-2_034",
        label="UE/23/-2/034",
        description="""UE/23/-2/034""",
    )

    ue_23__2_034b = VocabularyTerm(
        code="UE_23_-2_034B",
        label="UE/23/-2/034B",
        description="""UE/23/-2/034B""",
    )

    ue_23__2_034f = VocabularyTerm(
        code="UE_23_-2_034F",
        label="UE/23/-2/034F",
        description="""UE/23/-2/034F""",
    )

    ue_23__2_034t = VocabularyTerm(
        code="UE_23_-2_034T",
        label="UE/23/-2/034T",
        description="""UE/23/-2/034T""",
    )

    ue_23__2_037 = VocabularyTerm(
        code="UE_23_-2_037",
        label="UE/23/-2/037",
        description="""UE/23/-2/037""",
    )

    ue_23__2_038 = VocabularyTerm(
        code="UE_23_-2_038",
        label="UE/23/-2/038",
        description="""UE/23/-2/038""",
    )

    ue_23__2_a1 = VocabularyTerm(
        code="UE_23_-2_A1",
        label="UE/23/-2/A1",
        description="""UE/23/-2/A1""",
    )

    ue_23__2_a2 = VocabularyTerm(
        code="UE_23_-2_A2",
        label="UE/23/-2/A2",
        description="""UE/23/-2/A2""",
    )

    ue_23__3_0001t = VocabularyTerm(
        code="UE_23_-3_0001T",
        label="UE/23/-3/0001T",
        description="""UE/23/-3/0001T""",
    )

    ue_23__3_0002f = VocabularyTerm(
        code="UE_23_-3_0002F",
        label="UE/23/-3/0002F",
        description="""UE/23/-3/0002F""",
    )

    ue_23__3_0002t = VocabularyTerm(
        code="UE_23_-3_0002T",
        label="UE/23/-3/0002T",
        description="""UE/23/-3/0002T""",
    )

    ue_23__3_0003 = VocabularyTerm(
        code="UE_23_-3_0003",
        label="UE/23/-3/0003",
        description="""UE/23/-3/0003""",
    )

    ue_23__3_0003f = VocabularyTerm(
        code="UE_23_-3_0003F",
        label="UE/23/-3/0003F",
        description="""UE/23/-3/0003F""",
    )

    ue_23__3_0004 = VocabularyTerm(
        code="UE_23_-3_0004",
        label="UE/23/-3/0004",
        description="""UE/23/-3/0004""",
    )

    ue_23__3_0004b = VocabularyTerm(
        code="UE_23_-3_0004B",
        label="UE/23/-3/0004B",
        description="""UE/23/-3/0004B""",
    )

    ue_23__3_0007b = VocabularyTerm(
        code="UE_23_-3_0007B",
        label="UE/23/-3/0007B",
        description="""UE/23/-3/0007B""",
    )

    ue_23__3_0011b = VocabularyTerm(
        code="UE_23_-3_0011B",
        label="UE/23/-3/0011B",
        description="""UE/23/-3/0011B""",
    )

    ue_23__3_0012 = VocabularyTerm(
        code="UE_23_-3_0012",
        label="UE/23/-3/0012",
        description="""UE/23/-3/0012""",
    )

    ue_23__3_0012b = VocabularyTerm(
        code="UE_23_-3_0012B",
        label="UE/23/-3/0012B",
        description="""UE/23/-3/0012B""",
    )

    ue_23__3_0014b = VocabularyTerm(
        code="UE_23_-3_0014B",
        label="UE/23/-3/0014B",
        description="""UE/23/-3/0014B""",
    )

    ue_23__3_0014f = VocabularyTerm(
        code="UE_23_-3_0014F",
        label="UE/23/-3/0014F",
        description="""UE/23/-3/0014F""",
    )

    ue_23__3_0014t = VocabularyTerm(
        code="UE_23_-3_0014T",
        label="UE/23/-3/0014T",
        description="""UE/23/-3/0014T""",
    )

    ue_23__3_0015 = VocabularyTerm(
        code="UE_23_-3_0015",
        label="UE/23/-3/0015",
        description="""UE/23/-3/0015""",
    )

    ue_23__3_0015b = VocabularyTerm(
        code="UE_23_-3_0015B",
        label="UE/23/-3/0015B",
        description="""UE/23/-3/0015B""",
    )

    ue_23__3_0016 = VocabularyTerm(
        code="UE_23_-3_0016",
        label="UE/23/-3/0016",
        description="""UE/23/-3/0016""",
    )

    ue_23__3_0016b = VocabularyTerm(
        code="UE_23_-3_0016B",
        label="UE/23/-3/0016B",
        description="""UE/23/-3/0016B""",
    )

    ue_23__3_0017 = VocabularyTerm(
        code="UE_23_-3_0017",
        label="UE/23/-3/0017",
        description="""UE/23/-3/0017""",
    )

    ue_23__3_0017f = VocabularyTerm(
        code="UE_23_-3_0017F",
        label="UE/23/-3/0017F",
        description="""UE/23/-3/0017F""",
    )

    ue_23__3_0018b = VocabularyTerm(
        code="UE_23_-3_0018B",
        label="UE/23/-3/0018B",
        description="""UE/23/-3/0018B""",
    )

    ue_23__3_0018t = VocabularyTerm(
        code="UE_23_-3_0018T",
        label="UE/23/-3/0018T",
        description="""UE/23/-3/0018T""",
    )

    ue_23__3_0019 = VocabularyTerm(
        code="UE_23_-3_0019",
        label="UE/23/-3/0019",
        description="""UE/23/-3/0019""",
    )

    ue_23__3_0019b = VocabularyTerm(
        code="UE_23_-3_0019B",
        label="UE/23/-3/0019B",
        description="""UE/23/-3/0019B""",
    )

    ue_23__3_0019c = VocabularyTerm(
        code="UE_23_-3_0019C",
        label="UE/23/-3/0019C",
        description="""UE/23/-3/0019C""",
    )

    ue_23__3_a1 = VocabularyTerm(
        code="UE_23_-3_A1",
        label="UE/23/-3/A1",
        description="""UE/23/-3/A1""",
    )

    ue_24_0_187 = VocabularyTerm(
        code="UE_24_0_187",
        label="UE/24/0/187",
        description="""UE/24/0/187""",
    )

    ue_24_0_189 = VocabularyTerm(
        code="UE_24_0_189",
        label="UE/24/0/189",
        description="""UE/24/0/189""",
    )

    ue_24_0_191 = VocabularyTerm(
        code="UE_24_0_191",
        label="UE/24/0/191",
        description="""UE/24/0/191""",
    )

    ue_24_0_192f = VocabularyTerm(
        code="UE_24_0_192F",
        label="UE/24/0/192F",
        description="""UE/24/0/192F""",
    )

    ue_24_0_193 = VocabularyTerm(
        code="UE_24_0_193",
        label="UE/24/0/193",
        description="""UE/24/0/193""",
    )

    ue_24_0_193t = VocabularyTerm(
        code="UE_24_0_193T",
        label="UE/24/0/193T",
        description="""UE/24/0/193T""",
    )

    ue_24_0_195 = VocabularyTerm(
        code="UE_24_0_195",
        label="UE/24/0/195",
        description="""UE/24/0/195""",
    )

    ue_24_0_195f = VocabularyTerm(
        code="UE_24_0_195F",
        label="UE/24/0/195F",
        description="""UE/24/0/195F""",
    )

    ue_24_0_197 = VocabularyTerm(
        code="UE_24_0_197",
        label="UE/24/0/197",
        description="""UE/24/0/197""",
    )

    ue_24_0_199 = VocabularyTerm(
        code="UE_24_0_199",
        label="UE/24/0/199",
        description="""UE/24/0/199""",
    )

    ue_24_1_287 = VocabularyTerm(
        code="UE_24_1_287",
        label="UE/24/1/287",
        description="""UE/24/1/287""",
    )

    ue_24_1_288 = VocabularyTerm(
        code="UE_24_1_288",
        label="UE/24/1/288",
        description="""UE/24/1/288""",
    )

    ue_24_1_289 = VocabularyTerm(
        code="UE_24_1_289",
        label="UE/24/1/289",
        description="""UE/24/1/289""",
    )

    ue_24_1_290 = VocabularyTerm(
        code="UE_24_1_290",
        label="UE/24/1/290",
        description="""UE/24/1/290""",
    )

    ue_24_1_291 = VocabularyTerm(
        code="UE_24_1_291",
        label="UE/24/1/291",
        description="""UE/24/1/291""",
    )

    ue_24_1_292f = VocabularyTerm(
        code="UE_24_1_292F",
        label="UE/24/1/292F",
        description="""UE/24/1/292F""",
    )

    ue_24_1_293h = VocabularyTerm(
        code="UE_24_1_293H",
        label="UE/24/1/293H",
        description="""UE/24/1/293H""",
    )

    ue_24_1_293t = VocabularyTerm(
        code="UE_24_1_293T",
        label="UE/24/1/293T",
        description="""UE/24/1/293T""",
    )

    ue_24_1_294 = VocabularyTerm(
        code="UE_24_1_294",
        label="UE/24/1/294",
        description="""UE/24/1/294""",
    )

    ue_24__1_080 = VocabularyTerm(
        code="UE_24_-1_080",
        label="UE/24/-1/080",
        description="""UE/24/-1/080""",
    )

    ue_24__1_087 = VocabularyTerm(
        code="UE_24_-1_087",
        label="UE/24/-1/087",
        description="""UE/24/-1/087""",
    )

    ue_24__1_088 = VocabularyTerm(
        code="UE_24_-1_088",
        label="UE/24/-1/088",
        description="""UE/24/-1/088""",
    )

    ue_24__1_089 = VocabularyTerm(
        code="UE_24_-1_089",
        label="UE/24/-1/089",
        description="""UE/24/-1/089""",
    )

    ue_24__1_091 = VocabularyTerm(
        code="UE_24_-1_091",
        label="UE/24/-1/091",
        description="""UE/24/-1/091""",
    )

    ue_24__1_092f = VocabularyTerm(
        code="UE_24_-1_092F",
        label="UE/24/-1/092F",
        description="""UE/24/-1/092F""",
    )

    ue_24__1_093 = VocabularyTerm(
        code="UE_24_-1_093",
        label="UE/24/-1/093",
        description="""UE/24/-1/093""",
    )

    ue_24__1_093b = VocabularyTerm(
        code="UE_24_-1_093B",
        label="UE/24/-1/093B",
        description="""UE/24/-1/093B""",
    )

    ue_24__1_093h = VocabularyTerm(
        code="UE_24_-1_093H",
        label="UE/24/-1/093H",
        description="""UE/24/-1/093H""",
    )

    ue_24__1_093t = VocabularyTerm(
        code="UE_24_-1_093T",
        label="UE/24/-1/093T",
        description="""UE/24/-1/093T""",
    )

    ue_24__1_095 = VocabularyTerm(
        code="UE_24_-1_095",
        label="UE/24/-1/095",
        description="""UE/24/-1/095""",
    )

    ue_24__1_095f = VocabularyTerm(
        code="UE_24_-1_095F",
        label="UE/24/-1/095F",
        description="""UE/24/-1/095F""",
    )

    ue_24__1_097 = VocabularyTerm(
        code="UE_24_-1_097",
        label="UE/24/-1/097",
        description="""UE/24/-1/097""",
    )

    ue_24__1_099 = VocabularyTerm(
        code="UE_24_-1_099",
        label="UE/24/-1/099",
        description="""UE/24/-1/099""",
    )

    ue_25_0_100 = VocabularyTerm(
        code="UE_25_0_100",
        label="UE/25/0/100",
        description="""UE/25/0/100""",
    )

    ue_25_0_100f = VocabularyTerm(
        code="UE_25_0_100F",
        label="UE/25/0/100F",
        description="""UE/25/0/100F""",
    )

    ue_25_0_103t = VocabularyTerm(
        code="UE_25_0_103T",
        label="UE/25/0/103T",
        description="""UE/25/0/103T""",
    )

    ue_25_0_104 = VocabularyTerm(
        code="UE_25_0_104",
        label="UE/25/0/104",
        description="""UE/25/0/104""",
    )

    ue_25_0_105h = VocabularyTerm(
        code="UE_25_0_105H",
        label="UE/25/0/105H",
        description="""UE/25/0/105H""",
    )

    ue_25_0_107 = VocabularyTerm(
        code="UE_25_0_107",
        label="UE/25/0/107",
        description="""UE/25/0/107""",
    )

    ue_25_0_108 = VocabularyTerm(
        code="UE_25_0_108",
        label="UE/25/0/108",
        description="""UE/25/0/108""",
    )

    ue_25_0_108t = VocabularyTerm(
        code="UE_25_0_108T",
        label="UE/25/0/108T",
        description="""UE/25/0/108T""",
    )

    ue_25_0_110 = VocabularyTerm(
        code="UE_25_0_110",
        label="UE/25/0/110",
        description="""UE/25/0/110""",
    )

    ue_25_0_111 = VocabularyTerm(
        code="UE_25_0_111",
        label="UE/25/0/111",
        description="""UE/25/0/111""",
    )

    ue_25_0_111f = VocabularyTerm(
        code="UE_25_0_111F",
        label="UE/25/0/111F",
        description="""UE/25/0/111F""",
    )

    ue_25_0_112f = VocabularyTerm(
        code="UE_25_0_112F",
        label="UE/25/0/112F",
        description="""UE/25/0/112F""",
    )

    ue_25_0_115f = VocabularyTerm(
        code="UE_25_0_115F",
        label="UE/25/0/115F",
        description="""UE/25/0/115F""",
    )

    ue_25_0_116 = VocabularyTerm(
        code="UE_25_0_116",
        label="UE/25/0/116",
        description="""UE/25/0/116""",
    )

    ue_25_1_200f = VocabularyTerm(
        code="UE_25_1_200F",
        label="UE/25/1/200F",
        description="""UE/25/1/200F""",
    )

    ue_25_1_203f = VocabularyTerm(
        code="UE_25_1_203F",
        label="UE/25/1/203F",
        description="""UE/25/1/203F""",
    )

    ue_25_1_203t = VocabularyTerm(
        code="UE_25_1_203T",
        label="UE/25/1/203T",
        description="""UE/25/1/203T""",
    )

    ue_25_1_205 = VocabularyTerm(
        code="UE_25_1_205",
        label="UE/25/1/205",
        description="""UE/25/1/205""",
    )

    ue_25_1_206t = VocabularyTerm(
        code="UE_25_1_206T",
        label="UE/25/1/206T",
        description="""UE/25/1/206T""",
    )

    ue_25_1_207 = VocabularyTerm(
        code="UE_25_1_207",
        label="UE/25/1/207",
        description="""UE/25/1/207""",
    )

    ue_25_1_207f = VocabularyTerm(
        code="UE_25_1_207F",
        label="UE/25/1/207F",
        description="""UE/25/1/207F""",
    )

    ue_25_1_208 = VocabularyTerm(
        code="UE_25_1_208",
        label="UE/25/1/208",
        description="""UE/25/1/208""",
    )

    ue_25_1_208t = VocabularyTerm(
        code="UE_25_1_208T",
        label="UE/25/1/208T",
        description="""UE/25/1/208T""",
    )

    ue_25_1_210 = VocabularyTerm(
        code="UE_25_1_210",
        label="UE/25/1/210",
        description="""UE/25/1/210""",
    )

    ue_25_1_211 = VocabularyTerm(
        code="UE_25_1_211",
        label="UE/25/1/211",
        description="""UE/25/1/211""",
    )

    ue_25_1_211f = VocabularyTerm(
        code="UE_25_1_211F",
        label="UE/25/1/211F",
        description="""UE/25/1/211F""",
    )

    ue_25_1_212d = VocabularyTerm(
        code="UE_25_1_212D",
        label="UE/25/1/212D",
        description="""UE/25/1/212D""",
    )

    ue_25_1_212f = VocabularyTerm(
        code="UE_25_1_212F",
        label="UE/25/1/212F",
        description="""UE/25/1/212F""",
    )

    ue_25_1_213 = VocabularyTerm(
        code="UE_25_1_213",
        label="UE/25/1/213",
        description="""UE/25/1/213""",
    )

    ue_25_1_216 = VocabularyTerm(
        code="UE_25_1_216",
        label="UE/25/1/216",
        description="""UE/25/1/216""",
    )

    ue_25_2_300f = VocabularyTerm(
        code="UE_25_2_300F",
        label="UE/25/2/300F",
        description="""UE/25/2/300F""",
    )

    ue_25_2_300t = VocabularyTerm(
        code="UE_25_2_300T",
        label="UE/25/2/300T",
        description="""UE/25/2/300T""",
    )

    ue_25_2_301 = VocabularyTerm(
        code="UE_25_2_301",
        label="UE/25/2/301",
        description="""UE/25/2/301""",
    )

    ue_25_2_306 = VocabularyTerm(
        code="UE_25_2_306",
        label="UE/25/2/306",
        description="""UE/25/2/306""",
    )

    ue_25_2_306t = VocabularyTerm(
        code="UE_25_2_306T",
        label="UE/25/2/306T",
        description="""UE/25/2/306T""",
    )

    ue_25_2_307 = VocabularyTerm(
        code="UE_25_2_307",
        label="UE/25/2/307",
        description="""UE/25/2/307""",
    )

    ue_25_2_309 = VocabularyTerm(
        code="UE_25_2_309",
        label="UE/25/2/309",
        description="""UE/25/2/309""",
    )

    ue_25_2_310h = VocabularyTerm(
        code="UE_25_2_310H",
        label="UE/25/2/310H",
        description="""UE/25/2/310H""",
    )

    ue_25_2_311 = VocabularyTerm(
        code="UE_25_2_311",
        label="UE/25/2/311",
        description="""UE/25/2/311""",
    )

    ue_25_2_311f = VocabularyTerm(
        code="UE_25_2_311F",
        label="UE/25/2/311F",
        description="""UE/25/2/311F""",
    )

    ue_25_2_312 = VocabularyTerm(
        code="UE_25_2_312",
        label="UE/25/2/312",
        description="""UE/25/2/312""",
    )

    ue_25_2_313 = VocabularyTerm(
        code="UE_25_2_313",
        label="UE/25/2/313",
        description="""UE/25/2/313""",
    )

    ue_25_2_313b = VocabularyTerm(
        code="UE_25_2_313B",
        label="UE/25/2/313B",
        description="""UE/25/2/313B""",
    )

    ue_25_2_315 = VocabularyTerm(
        code="UE_25_2_315",
        label="UE/25/2/315",
        description="""UE/25/2/315""",
    )

    ue_25_2_315b = VocabularyTerm(
        code="UE_25_2_315B",
        label="UE/25/2/315B",
        description="""UE/25/2/315B""",
    )

    ue_25_2_316 = VocabularyTerm(
        code="UE_25_2_316",
        label="UE/25/2/316",
        description="""UE/25/2/316""",
    )

    ue_25_2_316b = VocabularyTerm(
        code="UE_25_2_316B",
        label="UE/25/2/316B",
        description="""UE/25/2/316B""",
    )

    ue_25_3_400f = VocabularyTerm(
        code="UE_25_3_400F",
        label="UE/25/3/400F",
        description="""UE/25/3/400F""",
    )

    ue_25_3_400t = VocabularyTerm(
        code="UE_25_3_400T",
        label="UE/25/3/400T",
        description="""UE/25/3/400T""",
    )

    ue_25_3_401 = VocabularyTerm(
        code="UE_25_3_401",
        label="UE/25/3/401",
        description="""UE/25/3/401""",
    )

    ue_25_3_413 = VocabularyTerm(
        code="UE_25_3_413",
        label="UE/25/3/413",
        description="""UE/25/3/413""",
    )

    ue_25_3_415 = VocabularyTerm(
        code="UE_25_3_415",
        label="UE/25/3/415",
        description="""UE/25/3/415""",
    )

    ue_25_3_416 = VocabularyTerm(
        code="UE_25_3_416",
        label="UE/25/3/416",
        description="""UE/25/3/416""",
    )

    ue_25__1_000f = VocabularyTerm(
        code="UE_25_-1_000F",
        label="UE/25/-1/000F",
        description="""UE/25/-1/000F""",
    )

    ue_25__1_003 = VocabularyTerm(
        code="UE_25_-1_003",
        label="UE/25/-1/003",
        description="""UE/25/-1/003""",
    )

    ue_25__1_004 = VocabularyTerm(
        code="UE_25_-1_004",
        label="UE/25/-1/004",
        description="""UE/25/-1/004""",
    )

    ue_25__1_004f = VocabularyTerm(
        code="UE_25_-1_004F",
        label="UE/25/-1/004F",
        description="""UE/25/-1/004F""",
    )

    ue_25__1_005d = VocabularyTerm(
        code="UE_25_-1_005D",
        label="UE/25/-1/005D",
        description="""UE/25/-1/005D""",
    )

    ue_25__1_007 = VocabularyTerm(
        code="UE_25_-1_007",
        label="UE/25/-1/007",
        description="""UE/25/-1/007""",
    )

    ue_25__1_007b = VocabularyTerm(
        code="UE_25_-1_007B",
        label="UE/25/-1/007B",
        description="""UE/25/-1/007B""",
    )

    ue_25__1_008 = VocabularyTerm(
        code="UE_25_-1_008",
        label="UE/25/-1/008",
        description="""UE/25/-1/008""",
    )

    ue_25__1_008t = VocabularyTerm(
        code="UE_25_-1_008T",
        label="UE/25/-1/008T",
        description="""UE/25/-1/008T""",
    )

    ue_25__1_011 = VocabularyTerm(
        code="UE_25_-1_011",
        label="UE/25/-1/011",
        description="""UE/25/-1/011""",
    )

    ue_25__1_012 = VocabularyTerm(
        code="UE_25_-1_012",
        label="UE/25/-1/012",
        description="""UE/25/-1/012""",
    )

    ue_25__1_013 = VocabularyTerm(
        code="UE_25_-1_013",
        label="UE/25/-1/013",
        description="""UE/25/-1/013""",
    )

    ue_25__1_015 = VocabularyTerm(
        code="UE_25_-1_015",
        label="UE/25/-1/015",
        description="""UE/25/-1/015""",
    )

    ue_25__1_015f = VocabularyTerm(
        code="UE_25_-1_015F",
        label="UE/25/-1/015F",
        description="""UE/25/-1/015F""",
    )

    ue_25__1_016 = VocabularyTerm(
        code="UE_25_-1_016",
        label="UE/25/-1/016",
        description="""UE/25/-1/016""",
    )

    ue_25__1_017 = VocabularyTerm(
        code="UE_25_-1_017",
        label="UE/25/-1/017",
        description="""UE/25/-1/017""",
    )

    ue_25__1_018 = VocabularyTerm(
        code="UE_25_-1_018",
        label="UE/25/-1/018",
        description="""UE/25/-1/018""",
    )

    ue_26_0_101b = VocabularyTerm(
        code="UE_26_0_101B",
        label="UE/26/0/101B",
        description="""UE/26/0/101B""",
    )

    ue_26_0_101d = VocabularyTerm(
        code="UE_26_0_101D",
        label="UE/26/0/101D",
        description="""UE/26/0/101D""",
    )

    ue_26_0_101f = VocabularyTerm(
        code="UE_26_0_101F",
        label="UE/26/0/101F",
        description="""UE/26/0/101F""",
    )

    ue_26_0_101h = VocabularyTerm(
        code="UE_26_0_101H",
        label="UE/26/0/101H",
        description="""UE/26/0/101H""",
    )

    ue_26_0_102 = VocabularyTerm(
        code="UE_26_0_102",
        label="UE/26/0/102",
        description="""UE/26/0/102""",
    )

    ue_26_0_103 = VocabularyTerm(
        code="UE_26_0_103",
        label="UE/26/0/103",
        description="""UE/26/0/103""",
    )

    ue_26_0_103b = VocabularyTerm(
        code="UE_26_0_103B",
        label="UE/26/0/103B",
        description="""UE/26/0/103B""",
    )

    ue_26_0_104 = VocabularyTerm(
        code="UE_26_0_104",
        label="UE/26/0/104",
        description="""UE/26/0/104""",
    )

    ue_30_0_anbau_ost_141 = VocabularyTerm(
        code="UE_30_0_ANBAU_OST_141",
        label="UE/30/0_Anbau Ost/141",
        description="""UE/30/0_Anbau Ost/141""",
    )

    ue_30_0_anbau_ost_143 = VocabularyTerm(
        code="UE_30_0_ANBAU_OST_143",
        label="UE/30/0_Anbau Ost/143",
        description="""UE/30/0_Anbau Ost/143""",
    )

    ue_30_0_anbau_ost_144 = VocabularyTerm(
        code="UE_30_0_ANBAU_OST_144",
        label="UE/30/0_Anbau Ost/144",
        description="""UE/30/0_Anbau Ost/144""",
    )

    ue_30_0_anbau_ost_145 = VocabularyTerm(
        code="UE_30_0_ANBAU_OST_145",
        label="UE/30/0_Anbau Ost/145",
        description="""UE/30/0_Anbau Ost/145""",
    )

    ue_30_0_anbau_ost_149f = VocabularyTerm(
        code="UE_30_0_ANBAU_OST_149F",
        label="UE/30/0_Anbau Ost/149F",
        description="""UE/30/0_Anbau Ost/149F""",
    )

    ue_30_0_anbau_ost_150 = VocabularyTerm(
        code="UE_30_0_ANBAU_OST_150",
        label="UE/30/0_Anbau Ost/150",
        description="""UE/30/0_Anbau Ost/150""",
    )

    ue_30_0_anbau_ost_150f = VocabularyTerm(
        code="UE_30_0_ANBAU_OST_150F",
        label="UE/30/0_Anbau Ost/150F",
        description="""UE/30/0_Anbau Ost/150F""",
    )

    ue_30_0_anbau_ost_151 = VocabularyTerm(
        code="UE_30_0_ANBAU_OST_151",
        label="UE/30/0_Anbau Ost/151",
        description="""UE/30/0_Anbau Ost/151""",
    )

    ue_30_0_anbau_ost_152 = VocabularyTerm(
        code="UE_30_0_ANBAU_OST_152",
        label="UE/30/0_Anbau Ost/152",
        description="""UE/30/0_Anbau Ost/152""",
    )

    ue_30_0_anbau_ost_156 = VocabularyTerm(
        code="UE_30_0_ANBAU_OST_156",
        label="UE/30/0_Anbau Ost/156",
        description="""UE/30/0_Anbau Ost/156""",
    )

    ue_30_0_anbau_ost_159 = VocabularyTerm(
        code="UE_30_0_ANBAU_OST_159",
        label="UE/30/0_Anbau Ost/159",
        description="""UE/30/0_Anbau Ost/159""",
    )

    ue_30_0_anbau_west_161 = VocabularyTerm(
        code="UE_30_0_ANBAU_WEST_161",
        label="UE/30/0_Anbau West/161",
        description="""UE/30/0_Anbau West/161""",
    )

    ue_30_0_anbau_west_162 = VocabularyTerm(
        code="UE_30_0_ANBAU_WEST_162",
        label="UE/30/0_Anbau West/162",
        description="""UE/30/0_Anbau West/162""",
    )

    ue_30_0_anbau_west_163 = VocabularyTerm(
        code="UE_30_0_ANBAU_WEST_163",
        label="UE/30/0_Anbau West/163",
        description="""UE/30/0_Anbau West/163""",
    )

    ue_30_0_anbau_west_164 = VocabularyTerm(
        code="UE_30_0_ANBAU_WEST_164",
        label="UE/30/0_Anbau West/164",
        description="""UE/30/0_Anbau West/164""",
    )

    ue_30_0_anbau_west_165 = VocabularyTerm(
        code="UE_30_0_ANBAU_WEST_165",
        label="UE/30/0_Anbau West/165",
        description="""UE/30/0_Anbau West/165""",
    )

    ue_30_0_anbau_west_166 = VocabularyTerm(
        code="UE_30_0_ANBAU_WEST_166",
        label="UE/30/0_Anbau West/166",
        description="""UE/30/0_Anbau West/166""",
    )

    ue_30_0_anbau_west_170f = VocabularyTerm(
        code="UE_30_0_ANBAU_WEST_170F",
        label="UE/30/0_Anbau West/170F",
        description="""UE/30/0_Anbau West/170F""",
    )

    ue_30_0_anbau_west_174 = VocabularyTerm(
        code="UE_30_0_ANBAU_WEST_174",
        label="UE/30/0_Anbau West/174",
        description="""UE/30/0_Anbau West/174""",
    )

    ue_30_0_anbau_west_175 = VocabularyTerm(
        code="UE_30_0_ANBAU_WEST_175",
        label="UE/30/0_Anbau West/175",
        description="""UE/30/0_Anbau West/175""",
    )

    ue_30_0_anbau_west_176 = VocabularyTerm(
        code="UE_30_0_ANBAU_WEST_176",
        label="UE/30/0_Anbau West/176",
        description="""UE/30/0_Anbau West/176""",
    )

    ue_30_0_anbau_west_178 = VocabularyTerm(
        code="UE_30_0_ANBAU_WEST_178",
        label="UE/30/0_Anbau West/178",
        description="""UE/30/0_Anbau West/178""",
    )

    ue_30_0_anbau_west_179 = VocabularyTerm(
        code="UE_30_0_ANBAU_WEST_179",
        label="UE/30/0_Anbau West/179",
        description="""UE/30/0_Anbau West/179""",
    )

    ue_30_0_eg_100f = VocabularyTerm(
        code="UE_30_0_EG_100F",
        label="UE/30/0/EG.100F",
        description="""UE/30/0/EG.100F""",
    )

    ue_30_0_eg_100t = VocabularyTerm(
        code="UE_30_0_EG_100T",
        label="UE/30/0/EG.100T",
        description="""UE/30/0/EG.100T""",
    )

    ue_30_0_eg_102f = VocabularyTerm(
        code="UE_30_0_EG_102F",
        label="UE/30/0/EG.102F",
        description="""UE/30/0/EG.102F""",
    )

    ue_30_0_eg_105a1 = VocabularyTerm(
        code="UE_30_0_EG_105A1",
        label="UE/30/0/EG.105A1",
        description="""UE/30/0/EG.105A1""",
    )

    ue_30_0_eg_105f = VocabularyTerm(
        code="UE_30_0_EG_105F",
        label="UE/30/0/EG.105F",
        description="""UE/30/0/EG.105F""",
    )

    ue_30_0_eg_106f = VocabularyTerm(
        code="UE_30_0_EG_106F",
        label="UE/30/0/EG.106F",
        description="""UE/30/0/EG.106F""",
    )

    ue_30_0_eg_108wc = VocabularyTerm(
        code="UE_30_0_EG_108WC",
        label="UE/30/0/EG.108WC",
        description="""UE/30/0/EG.108WC""",
    )

    ue_30_0_eg_109h = VocabularyTerm(
        code="UE_30_0_EG_109H",
        label="UE/30/0/EG.109H",
        description="""UE/30/0/EG.109H""",
    )

    ue_30_0_eg_110d = VocabularyTerm(
        code="UE_30_0_EG_110D",
        label="UE/30/0/EG.110D",
        description="""UE/30/0/EG.110D""",
    )

    ue_30_0_eg_112 = VocabularyTerm(
        code="UE_30_0_EG_112",
        label="UE/30/0/EG.112",
        description="""UE/30/0/EG.112""",
    )

    ue_30_0_eg_112b = VocabularyTerm(
        code="UE_30_0_EG_112B",
        label="UE/30/0/EG.112B",
        description="""UE/30/0/EG.112B""",
    )

    ue_30_0_eg_112c = VocabularyTerm(
        code="UE_30_0_EG_112C",
        label="UE/30/0/EG.112C",
        description="""UE/30/0/EG.112C""",
    )

    ue_30_0_eg_113 = VocabularyTerm(
        code="UE_30_0_EG_113",
        label="UE/30/0/EG.113",
        description="""UE/30/0/EG.113""",
    )

    ue_30_0_eg_113b = VocabularyTerm(
        code="UE_30_0_EG_113B",
        label="UE/30/0/EG.113B",
        description="""UE/30/0/EG.113B""",
    )

    ue_30_0_eg_113c = VocabularyTerm(
        code="UE_30_0_EG_113C",
        label="UE/30/0/EG.113C",
        description="""UE/30/0/EG.113C""",
    )

    ue_30_0_eg_113d = VocabularyTerm(
        code="UE_30_0_EG_113D",
        label="UE/30/0/EG.113D",
        description="""UE/30/0/EG.113D""",
    )

    ue_30_0_eg_113h = VocabularyTerm(
        code="UE_30_0_EG_113H",
        label="UE/30/0/EG.113H",
        description="""UE/30/0/EG.113H""",
    )

    ue_30_0_eg_115 = VocabularyTerm(
        code="UE_30_0_EG_115",
        label="UE/30/0/EG.115",
        description="""UE/30/0/EG.115""",
    )

    ue_30_0_eg_115b = VocabularyTerm(
        code="UE_30_0_EG_115B",
        label="UE/30/0/EG.115B",
        description="""UE/30/0/EG.115B""",
    )

    ue_30_0_eg_115c = VocabularyTerm(
        code="UE_30_0_EG_115C",
        label="UE/30/0/EG.115C",
        description="""UE/30/0/EG.115C""",
    )

    ue_30_0_eg_116 = VocabularyTerm(
        code="UE_30_0_EG_116",
        label="UE/30/0/EG.116",
        description="""UE/30/0/EG.116""",
    )

    ue_30_0_eg_118 = VocabularyTerm(
        code="UE_30_0_EG_118",
        label="UE/30/0/EG.118",
        description="""UE/30/0/EG.118""",
    )

    ue_30_0_eg_119f = VocabularyTerm(
        code="UE_30_0_EG_119F",
        label="UE/30/0/EG.119F",
        description="""UE/30/0/EG.119F""",
    )

    ue_30_0_eg_120a2 = VocabularyTerm(
        code="UE_30_0_EG_120A2",
        label="UE/30/0/EG.120A2",
        description="""UE/30/0/EG.120A2""",
    )

    ue_30_0_eg_120f = VocabularyTerm(
        code="UE_30_0_EG_120F",
        label="UE/30/0/EG.120F",
        description="""UE/30/0/EG.120F""",
    )

    ue_30_0_eg_121b = VocabularyTerm(
        code="UE_30_0_EG_121B",
        label="UE/30/0/EG.121B",
        description="""UE/30/0/EG.121B""",
    )

    ue_30_0_eg_121c = VocabularyTerm(
        code="UE_30_0_EG_121C",
        label="UE/30/0/EG.121C",
        description="""UE/30/0/EG.121C""",
    )

    ue_30_0_eg_121e = VocabularyTerm(
        code="UE_30_0_EG_121E",
        label="UE/30/0/EG.121E",
        description="""UE/30/0/EG.121E""",
    )

    ue_30_0_eg_121f = VocabularyTerm(
        code="UE_30_0_EG_121F",
        label="UE/30/0/EG.121F",
        description="""UE/30/0/EG.121F""",
    )

    ue_30_0_eg_121t = VocabularyTerm(
        code="UE_30_0_EG_121T",
        label="UE/30/0/EG.121T",
        description="""UE/30/0/EG.121T""",
    )

    ue_30_0_eg_122f = VocabularyTerm(
        code="UE_30_0_EG_122F",
        label="UE/30/0/EG.122F",
        description="""UE/30/0/EG.122F""",
    )

    ue_30_0_eg_123 = VocabularyTerm(
        code="UE_30_0_EG_123",
        label="UE/30/0/EG.123",
        description="""UE/30/0/EG.123""",
    )

    ue_30_0_eg_124 = VocabularyTerm(
        code="UE_30_0_EG_124",
        label="UE/30/0/EG.124",
        description="""UE/30/0/EG.124""",
    )

    ue_30_0_eg_124b = VocabularyTerm(
        code="UE_30_0_EG_124B",
        label="UE/30/0/EG.124B",
        description="""UE/30/0/EG.124B""",
    )

    ue_30_0_eg_124c = VocabularyTerm(
        code="UE_30_0_EG_124C",
        label="UE/30/0/EG.124C",
        description="""UE/30/0/EG.124C""",
    )

    ue_30_0_eg_124d = VocabularyTerm(
        code="UE_30_0_EG_124D",
        label="UE/30/0/EG.124D",
        description="""UE/30/0/EG.124D""",
    )

    ue_30_0_eg_125 = VocabularyTerm(
        code="UE_30_0_EG_125",
        label="UE/30/0/EG.125",
        description="""UE/30/0/EG.125""",
    )

    ue_30_0_eg_125b = VocabularyTerm(
        code="UE_30_0_EG_125B",
        label="UE/30/0/EG.125B",
        description="""UE/30/0/EG.125B""",
    )

    ue_30_0_eg_125c = VocabularyTerm(
        code="UE_30_0_EG_125C",
        label="UE/30/0/EG.125C",
        description="""UE/30/0/EG.125C""",
    )

    ue_30_0_eg_125h = VocabularyTerm(
        code="UE_30_0_EG_125H",
        label="UE/30/0/EG.125H",
        description="""UE/30/0/EG.125H""",
    )

    ue_30_0_eg_126 = VocabularyTerm(
        code="UE_30_0_EG_126",
        label="UE/30/0/EG.126",
        description="""UE/30/0/EG.126""",
    )

    ue_30_0_eg_126b = VocabularyTerm(
        code="UE_30_0_EG_126B",
        label="UE/30/0/EG.126B",
        description="""UE/30/0/EG.126B""",
    )

    ue_30_0_eg_127 = VocabularyTerm(
        code="UE_30_0_EG_127",
        label="UE/30/0/EG.127",
        description="""UE/30/0/EG.127""",
    )

    ue_30_0_eg_127b = VocabularyTerm(
        code="UE_30_0_EG_127B",
        label="UE/30/0/EG.127B",
        description="""UE/30/0/EG.127B""",
    )

    ue_30_0_eg_128 = VocabularyTerm(
        code="UE_30_0_EG_128",
        label="UE/30/0/EG.128",
        description="""UE/30/0/EG.128""",
    )

    ue_30_0_eg_128b = VocabularyTerm(
        code="UE_30_0_EG_128B",
        label="UE/30/0/EG.128B",
        description="""UE/30/0/EG.128B""",
    )

    ue_30_0_eg_128c = VocabularyTerm(
        code="UE_30_0_EG_128C",
        label="UE/30/0/EG.128C",
        description="""UE/30/0/EG.128C""",
    )

    ue_30_0_eg_128e = VocabularyTerm(
        code="UE_30_0_EG_128E",
        label="UE/30/0/EG.128E",
        description="""UE/30/0/EG.128E""",
    )

    ue_30_0_eg_128f = VocabularyTerm(
        code="UE_30_0_EG_128F",
        label="UE/30/0/EG.128F",
        description="""UE/30/0/EG.128F""",
    )

    ue_30_0_eg_129 = VocabularyTerm(
        code="UE_30_0_EG_129",
        label="UE/30/0/EG.129",
        description="""UE/30/0/EG.129""",
    )

    ue_30_0_eg_129b = VocabularyTerm(
        code="UE_30_0_EG_129B",
        label="UE/30/0/EG.129B",
        description="""UE/30/0/EG.129B""",
    )

    ue_30_0_eg_129f = VocabularyTerm(
        code="UE_30_0_EG_129F",
        label="UE/30/0/EG.129F",
        description="""UE/30/0/EG.129F""",
    )

    ue_30_0_eg_130 = VocabularyTerm(
        code="UE_30_0_EG_130",
        label="UE/30/0/EG.130",
        description="""UE/30/0/EG.130""",
    )

    ue_30_0_eg_150 = VocabularyTerm(
        code="UE_30_0_EG_150",
        label="UE/30/0/EG.150",
        description="""UE/30/0/EG.150""",
    )

    ue_30_0_eg_150f = VocabularyTerm(
        code="UE_30_0_EG_150F",
        label="UE/30/0/EG.150F",
        description="""UE/30/0/EG.150F""",
    )

    ue_30_0_eg_151 = VocabularyTerm(
        code="UE_30_0_EG_151",
        label="UE/30/0/EG.151",
        description="""UE/30/0/EG.151""",
    )

    ue_30_0_eg_152 = VocabularyTerm(
        code="UE_30_0_EG_152",
        label="UE/30/0/EG.152",
        description="""UE/30/0/EG.152""",
    )

    ue_30_0_eg_154 = VocabularyTerm(
        code="UE_30_0_EG_154",
        label="UE/30/0/EG.154",
        description="""UE/30/0/EG.154""",
    )

    ue_30_0_eg_156f = VocabularyTerm(
        code="UE_30_0_EG_156F",
        label="UE/30/0/EG.156F",
        description="""UE/30/0/EG.156F""",
    )

    ue_30_0_eg_157 = VocabularyTerm(
        code="UE_30_0_EG_157",
        label="UE/30/0/EG.157",
        description="""UE/30/0/EG.157""",
    )

    ue_30_0_eg_158 = VocabularyTerm(
        code="UE_30_0_EG_158",
        label="UE/30/0/EG.158",
        description="""UE/30/0/EG.158""",
    )

    ue_30_0_eg_159 = VocabularyTerm(
        code="UE_30_0_EG_159",
        label="UE/30/0/EG.159",
        description="""UE/30/0/EG.159""",
    )

    ue_30_0_eg_161 = VocabularyTerm(
        code="UE_30_0_EG_161",
        label="UE/30/0/EG.161",
        description="""UE/30/0/EG.161""",
    )

    ue_30_0_eg_162 = VocabularyTerm(
        code="UE_30_0_EG_162",
        label="UE/30/0/EG.162",
        description="""UE/30/0/EG.162""",
    )

    ue_30_0_eg_s00 = VocabularyTerm(
        code="UE_30_0_EG_S00",
        label="UE/30/0/EG.S00",
        description="""UE/30/0/EG.S00""",
    )

    ue_30_0_eg_s01 = VocabularyTerm(
        code="UE_30_0_EG_S01",
        label="UE/30/0/EG.S01",
        description="""UE/30/0/EG.S01""",
    )

    ue_30_0_eg_s02 = VocabularyTerm(
        code="UE_30_0_EG_S02",
        label="UE/30/0/EG.S02",
        description="""UE/30/0/EG.S02""",
    )

    ue_30_0_eg_s03 = VocabularyTerm(
        code="UE_30_0_EG_S03",
        label="UE/30/0/EG.S03",
        description="""UE/30/0/EG.S03""",
    )

    ue_30_0_eg_s04 = VocabularyTerm(
        code="UE_30_0_EG_S04",
        label="UE/30/0/EG.S04",
        description="""UE/30/0/EG.S04""",
    )

    ue_30_0_eg_s05 = VocabularyTerm(
        code="UE_30_0_EG_S05",
        label="UE/30/0/EG.S05",
        description="""UE/30/0/EG.S05""",
    )

    ue_30_0_eg_s06 = VocabularyTerm(
        code="UE_30_0_EG_S06",
        label="UE/30/0/EG.S06",
        description="""UE/30/0/EG.S06""",
    )

    ue_30_0_eg_s07 = VocabularyTerm(
        code="UE_30_0_EG_S07",
        label="UE/30/0/EG.S07",
        description="""UE/30/0/EG.S07""",
    )

    ue_30_0_eg_s08 = VocabularyTerm(
        code="UE_30_0_EG_S08",
        label="UE/30/0/EG.S08",
        description="""UE/30/0/EG.S08""",
    )

    ue_30_1_01_200f = VocabularyTerm(
        code="UE_30_1_01_200F",
        label="UE/30/1/01.200F",
        description="""UE/30/1/01.200F""",
    )

    ue_30_1_01_200t = VocabularyTerm(
        code="UE_30_1_01_200T",
        label="UE/30/1/01.200T",
        description="""UE/30/1/01.200T""",
    )

    ue_30_1_01_201 = VocabularyTerm(
        code="UE_30_1_01_201",
        label="UE/30/1/01.201",
        description="""UE/30/1/01.201""",
    )

    ue_30_1_01_202f = VocabularyTerm(
        code="UE_30_1_01_202F",
        label="UE/30/1/01.202F",
        description="""UE/30/1/01.202F""",
    )

    ue_30_1_01_203 = VocabularyTerm(
        code="UE_30_1_01_203",
        label="UE/30/1/01.203",
        description="""UE/30/1/01.203""",
    )

    ue_30_1_01_205 = VocabularyTerm(
        code="UE_30_1_01_205",
        label="UE/30/1/01.205",
        description="""UE/30/1/01.205""",
    )

    ue_30_1_01_205a1 = VocabularyTerm(
        code="UE_30_1_01_205A1",
        label="UE/30/1/01.205A1",
        description="""UE/30/1/01.205A1""",
    )

    ue_30_1_01_205f = VocabularyTerm(
        code="UE_30_1_01_205F",
        label="UE/30/1/01.205F",
        description="""UE/30/1/01.205F""",
    )

    ue_30_1_01_206 = VocabularyTerm(
        code="UE_30_1_01_206",
        label="UE/30/1/01.206",
        description="""UE/30/1/01.206""",
    )

    ue_30_1_01_206f = VocabularyTerm(
        code="UE_30_1_01_206F",
        label="UE/30/1/01.206F",
        description="""UE/30/1/01.206F""",
    )

    ue_30_1_01_207 = VocabularyTerm(
        code="UE_30_1_01_207",
        label="UE/30/1/01.207",
        description="""UE/30/1/01.207""",
    )

    ue_30_1_01_208 = VocabularyTerm(
        code="UE_30_1_01_208",
        label="UE/30/1/01.208",
        description="""UE/30/1/01.208""",
    )

    ue_30_1_01_210 = VocabularyTerm(
        code="UE_30_1_01_210",
        label="UE/30/1/01.210",
        description="""UE/30/1/01.210""",
    )

    ue_30_1_01_211 = VocabularyTerm(
        code="UE_30_1_01_211",
        label="UE/30/1/01.211",
        description="""UE/30/1/01.211""",
    )

    ue_30_1_01_212b = VocabularyTerm(
        code="UE_30_1_01_212B",
        label="UE/30/1/01.212B",
        description="""UE/30/1/01.212B""",
    )

    ue_30_1_01_212c = VocabularyTerm(
        code="UE_30_1_01_212C",
        label="UE/30/1/01.212C",
        description="""UE/30/1/01.212C""",
    )

    ue_30_1_01_213 = VocabularyTerm(
        code="UE_30_1_01_213",
        label="UE/30/1/01.213",
        description="""UE/30/1/01.213""",
    )

    ue_30_1_01_213b = VocabularyTerm(
        code="UE_30_1_01_213B",
        label="UE/30/1/01.213B",
        description="""UE/30/1/01.213B""",
    )

    ue_30_1_01_214 = VocabularyTerm(
        code="UE_30_1_01_214",
        label="UE/30/1/01.214",
        description="""UE/30/1/01.214""",
    )

    ue_30_1_01_214b = VocabularyTerm(
        code="UE_30_1_01_214B",
        label="UE/30/1/01.214B",
        description="""UE/30/1/01.214B""",
    )

    ue_30_1_01_216 = VocabularyTerm(
        code="UE_30_1_01_216",
        label="UE/30/1/01.216",
        description="""UE/30/1/01.216""",
    )

    ue_30_1_01_217 = VocabularyTerm(
        code="UE_30_1_01_217",
        label="UE/30/1/01.217",
        description="""UE/30/1/01.217""",
    )

    ue_30_1_01_217b = VocabularyTerm(
        code="UE_30_1_01_217B",
        label="UE/30/1/01.217B",
        description="""UE/30/1/01.217B""",
    )

    ue_30_1_01_219f = VocabularyTerm(
        code="UE_30_1_01_219F",
        label="UE/30/1/01.219F",
        description="""UE/30/1/01.219F""",
    )

    ue_30_1_01_220a2 = VocabularyTerm(
        code="UE_30_1_01_220A2",
        label="UE/30/1/01.220A2",
        description="""UE/30/1/01.220A2""",
    )

    ue_30_1_01_220f = VocabularyTerm(
        code="UE_30_1_01_220F",
        label="UE/30/1/01.220F",
        description="""UE/30/1/01.220F""",
    )

    ue_30_1_01_221b = VocabularyTerm(
        code="UE_30_1_01_221B",
        label="UE/30/1/01.221B",
        description="""UE/30/1/01.221B""",
    )

    ue_30_1_01_221c = VocabularyTerm(
        code="UE_30_1_01_221C",
        label="UE/30/1/01.221C",
        description="""UE/30/1/01.221C""",
    )

    ue_30_1_01_221e = VocabularyTerm(
        code="UE_30_1_01_221E",
        label="UE/30/1/01.221E",
        description="""UE/30/1/01.221E""",
    )

    ue_30_1_01_221f = VocabularyTerm(
        code="UE_30_1_01_221F",
        label="UE/30/1/01.221F",
        description="""UE/30/1/01.221F""",
    )

    ue_30_1_01_221t = VocabularyTerm(
        code="UE_30_1_01_221T",
        label="UE/30/1/01.221T",
        description="""UE/30/1/01.221T""",
    )

    ue_30_1_01_222f = VocabularyTerm(
        code="UE_30_1_01_222F",
        label="UE/30/1/01.222F",
        description="""UE/30/1/01.222F""",
    )

    ue_30_1_01_223 = VocabularyTerm(
        code="UE_30_1_01_223",
        label="UE/30/1/01.223",
        description="""UE/30/1/01.223""",
    )

    ue_30_1_01_224 = VocabularyTerm(
        code="UE_30_1_01_224",
        label="UE/30/1/01.224",
        description="""UE/30/1/01.224""",
    )

    ue_30_1_01_225 = VocabularyTerm(
        code="UE_30_1_01_225",
        label="UE/30/1/01.225",
        description="""UE/30/1/01.225""",
    )

    ue_30_1_01_225b = VocabularyTerm(
        code="UE_30_1_01_225B",
        label="UE/30/1/01.225B",
        description="""UE/30/1/01.225B""",
    )

    ue_30_1_01_226 = VocabularyTerm(
        code="UE_30_1_01_226",
        label="UE/30/1/01.226",
        description="""UE/30/1/01.226""",
    )

    ue_30_1_01_226b = VocabularyTerm(
        code="UE_30_1_01_226B",
        label="UE/30/1/01.226B",
        description="""UE/30/1/01.226B""",
    )

    ue_30_1_01_227 = VocabularyTerm(
        code="UE_30_1_01_227",
        label="UE/30/1/01.227",
        description="""UE/30/1/01.227""",
    )

    ue_30_1_01_227b = VocabularyTerm(
        code="UE_30_1_01_227B",
        label="UE/30/1/01.227B",
        description="""UE/30/1/01.227B""",
    )

    ue_30_1_01_228 = VocabularyTerm(
        code="UE_30_1_01_228",
        label="UE/30/1/01.228",
        description="""UE/30/1/01.228""",
    )

    ue_30_1_01_228b = VocabularyTerm(
        code="UE_30_1_01_228B",
        label="UE/30/1/01.228B",
        description="""UE/30/1/01.228B""",
    )

    ue_30_1_01_229 = VocabularyTerm(
        code="UE_30_1_01_229",
        label="UE/30/1/01.229",
        description="""UE/30/1/01.229""",
    )

    ue_30_1_01_229b = VocabularyTerm(
        code="UE_30_1_01_229B",
        label="UE/30/1/01.229B",
        description="""UE/30/1/01.229B""",
    )

    ue_30_1_01_229d = VocabularyTerm(
        code="UE_30_1_01_229D",
        label="UE/30/1/01.229D",
        description="""UE/30/1/01.229D""",
    )

    ue_30_1_01_229h = VocabularyTerm(
        code="UE_30_1_01_229H",
        label="UE/30/1/01.229H",
        description="""UE/30/1/01.229H""",
    )

    ue_30_1_01_230 = VocabularyTerm(
        code="UE_30_1_01_230",
        label="UE/30/1/01.230",
        description="""UE/30/1/01.230""",
    )

    ue_30_1_01_231 = VocabularyTerm(
        code="UE_30_1_01_231",
        label="UE/30/1/01.231",
        description="""UE/30/1/01.231""",
    )

    ue_30_1_01_232 = VocabularyTerm(
        code="UE_30_1_01_232",
        label="UE/30/1/01.232",
        description="""UE/30/1/01.232""",
    )

    ue_30_1_01_233 = VocabularyTerm(
        code="UE_30_1_01_233",
        label="UE/30/1/01.233",
        description="""UE/30/1/01.233""",
    )

    ue_30_1_01_s00 = VocabularyTerm(
        code="UE_30_1_01_S00",
        label="UE/30/1/01.S00",
        description="""UE/30/1/01.S00""",
    )

    ue_30_1_01_s01 = VocabularyTerm(
        code="UE_30_1_01_S01",
        label="UE/30/1/01.S01",
        description="""UE/30/1/01.S01""",
    )

    ue_30_1_01_s02 = VocabularyTerm(
        code="UE_30_1_01_S02",
        label="UE/30/1/01.S02",
        description="""UE/30/1/01.S02""",
    )

    ue_30_1_01_s03 = VocabularyTerm(
        code="UE_30_1_01_S03",
        label="UE/30/1/01.S03",
        description="""UE/30/1/01.S03""",
    )

    ue_30_1_01_s04 = VocabularyTerm(
        code="UE_30_1_01_S04",
        label="UE/30/1/01.S04",
        description="""UE/30/1/01.S04""",
    )

    ue_30_1_01_s05 = VocabularyTerm(
        code="UE_30_1_01_S05",
        label="UE/30/1/01.S05",
        description="""UE/30/1/01.S05""",
    )

    ue_30_1_01_s06 = VocabularyTerm(
        code="UE_30_1_01_S06",
        label="UE/30/1/01.S06",
        description="""UE/30/1/01.S06""",
    )

    ue_30_1_01_s08 = VocabularyTerm(
        code="UE_30_1_01_S08",
        label="UE/30/1/01.S08",
        description="""UE/30/1/01.S08""",
    )

    ue_30_1_01_s09 = VocabularyTerm(
        code="UE_30_1_01_S09",
        label="UE/30/1/01.S09",
        description="""UE/30/1/01.S09""",
    )

    ue_30_1_01_s10 = VocabularyTerm(
        code="UE_30_1_01_S10",
        label="UE/30/1/01.S10",
        description="""UE/30/1/01.S10""",
    )

    ue_30_1_01_s11 = VocabularyTerm(
        code="UE_30_1_01_S11",
        label="UE/30/1/01.S11",
        description="""UE/30/1/01.S11""",
    )

    ue_30_1_01_s12 = VocabularyTerm(
        code="UE_30_1_01_S12",
        label="UE/30/1/01.S12",
        description="""UE/30/1/01.S12""",
    )

    ue_30_1_01_s13 = VocabularyTerm(
        code="UE_30_1_01_S13",
        label="UE/30/1/01.S13",
        description="""UE/30/1/01.S13""",
    )

    ue_30_1_01_s14 = VocabularyTerm(
        code="UE_30_1_01_S14",
        label="UE/30/1/01.S14",
        description="""UE/30/1/01.S14""",
    )

    ue_30_1_01_s15 = VocabularyTerm(
        code="UE_30_1_01_S15",
        label="UE/30/1/01.S15",
        description="""UE/30/1/01.S15""",
    )

    ue_30_1_01_s16 = VocabularyTerm(
        code="UE_30_1_01_S16",
        label="UE/30/1/01.S16",
        description="""UE/30/1/01.S16""",
    )

    ue_30_2_02_300f = VocabularyTerm(
        code="UE_30_2_02_300F",
        label="UE/30/2/02.300F",
        description="""UE/30/2/02.300F""",
    )

    ue_30_2_02_300t = VocabularyTerm(
        code="UE_30_2_02_300T",
        label="UE/30/2/02.300T",
        description="""UE/30/2/02.300T""",
    )

    ue_30_2_02_301 = VocabularyTerm(
        code="UE_30_2_02_301",
        label="UE/30/2/02.301",
        description="""UE/30/2/02.301""",
    )

    ue_30_2_02_302f = VocabularyTerm(
        code="UE_30_2_02_302F",
        label="UE/30/2/02.302F",
        description="""UE/30/2/02.302F""",
    )

    ue_30_2_02_303 = VocabularyTerm(
        code="UE_30_2_02_303",
        label="UE/30/2/02.303",
        description="""UE/30/2/02.303""",
    )

    ue_30_2_02_305a1 = VocabularyTerm(
        code="UE_30_2_02_305A1",
        label="UE/30/2/02.305A1",
        description="""UE/30/2/02.305A1""",
    )

    ue_30_2_02_305f = VocabularyTerm(
        code="UE_30_2_02_305F",
        label="UE/30/2/02.305F",
        description="""UE/30/2/02.305F""",
    )

    ue_30_2_02_306f = VocabularyTerm(
        code="UE_30_2_02_306F",
        label="UE/30/2/02.306F",
        description="""UE/30/2/02.306F""",
    )

    ue_30_2_02_307 = VocabularyTerm(
        code="UE_30_2_02_307",
        label="UE/30/2/02.307",
        description="""UE/30/2/02.307""",
    )

    ue_30_2_02_308 = VocabularyTerm(
        code="UE_30_2_02_308",
        label="UE/30/2/02.308",
        description="""UE/30/2/02.308""",
    )

    ue_30_2_02_310 = VocabularyTerm(
        code="UE_30_2_02_310",
        label="UE/30/2/02.310",
        description="""UE/30/2/02.310""",
    )

    ue_30_2_02_311 = VocabularyTerm(
        code="UE_30_2_02_311",
        label="UE/30/2/02.311",
        description="""UE/30/2/02.311""",
    )

    ue_30_2_02_312 = VocabularyTerm(
        code="UE_30_2_02_312",
        label="UE/30/2/02.312",
        description="""UE/30/2/02.312""",
    )

    ue_30_2_02_312b = VocabularyTerm(
        code="UE_30_2_02_312B",
        label="UE/30/2/02.312B",
        description="""UE/30/2/02.312B""",
    )

    ue_30_2_02_312c = VocabularyTerm(
        code="UE_30_2_02_312C",
        label="UE/30/2/02.312C",
        description="""UE/30/2/02.312C""",
    )

    ue_30_2_02_313 = VocabularyTerm(
        code="UE_30_2_02_313",
        label="UE/30/2/02.313",
        description="""UE/30/2/02.313""",
    )

    ue_30_2_02_313b = VocabularyTerm(
        code="UE_30_2_02_313B",
        label="UE/30/2/02.313B",
        description="""UE/30/2/02.313B""",
    )

    ue_30_2_02_314 = VocabularyTerm(
        code="UE_30_2_02_314",
        label="UE/30/2/02.314",
        description="""UE/30/2/02.314""",
    )

    ue_30_2_02_314b = VocabularyTerm(
        code="UE_30_2_02_314B",
        label="UE/30/2/02.314B",
        description="""UE/30/2/02.314B""",
    )

    ue_30_2_02_315 = VocabularyTerm(
        code="UE_30_2_02_315",
        label="UE/30/2/02.315",
        description="""UE/30/2/02.315""",
    )

    ue_30_2_02_315b = VocabularyTerm(
        code="UE_30_2_02_315B",
        label="UE/30/2/02.315B",
        description="""UE/30/2/02.315B""",
    )

    ue_30_2_02_316 = VocabularyTerm(
        code="UE_30_2_02_316",
        label="UE/30/2/02.316",
        description="""UE/30/2/02.316""",
    )

    ue_30_2_02_317 = VocabularyTerm(
        code="UE_30_2_02_317",
        label="UE/30/2/02.317",
        description="""UE/30/2/02.317""",
    )

    ue_30_2_02_317b = VocabularyTerm(
        code="UE_30_2_02_317B",
        label="UE/30/2/02.317B",
        description="""UE/30/2/02.317B""",
    )

    ue_30_2_02_318 = VocabularyTerm(
        code="UE_30_2_02_318",
        label="UE/30/2/02.318",
        description="""UE/30/2/02.318""",
    )

    ue_30_2_02_319f = VocabularyTerm(
        code="UE_30_2_02_319F",
        label="UE/30/2/02.319F",
        description="""UE/30/2/02.319F""",
    )

    ue_30_2_02_320a2 = VocabularyTerm(
        code="UE_30_2_02_320A2",
        label="UE/30/2/02.320A2",
        description="""UE/30/2/02.320A2""",
    )

    ue_30_2_02_320f = VocabularyTerm(
        code="UE_30_2_02_320F",
        label="UE/30/2/02.320F",
        description="""UE/30/2/02.320F""",
    )

    ue_30_2_02_321b = VocabularyTerm(
        code="UE_30_2_02_321B",
        label="UE/30/2/02.321B",
        description="""UE/30/2/02.321B""",
    )

    ue_30_2_02_321c = VocabularyTerm(
        code="UE_30_2_02_321C",
        label="UE/30/2/02.321C",
        description="""UE/30/2/02.321C""",
    )

    ue_30_2_02_321e = VocabularyTerm(
        code="UE_30_2_02_321E",
        label="UE/30/2/02.321E",
        description="""UE/30/2/02.321E""",
    )

    ue_30_2_02_321f = VocabularyTerm(
        code="UE_30_2_02_321F",
        label="UE/30/2/02.321F",
        description="""UE/30/2/02.321F""",
    )

    ue_30_2_02_321t = VocabularyTerm(
        code="UE_30_2_02_321T",
        label="UE/30/2/02.321T",
        description="""UE/30/2/02.321T""",
    )

    ue_30_2_02_322f = VocabularyTerm(
        code="UE_30_2_02_322F",
        label="UE/30/2/02.322F",
        description="""UE/30/2/02.322F""",
    )

    ue_30_2_02_323 = VocabularyTerm(
        code="UE_30_2_02_323",
        label="UE/30/2/02.323",
        description="""UE/30/2/02.323""",
    )

    ue_30_2_02_324 = VocabularyTerm(
        code="UE_30_2_02_324",
        label="UE/30/2/02.324",
        description="""UE/30/2/02.324""",
    )

    ue_30_2_02_325 = VocabularyTerm(
        code="UE_30_2_02_325",
        label="UE/30/2/02.325",
        description="""UE/30/2/02.325""",
    )

    ue_30_2_02_325b = VocabularyTerm(
        code="UE_30_2_02_325B",
        label="UE/30/2/02.325B",
        description="""UE/30/2/02.325B""",
    )

    ue_30_2_02_326 = VocabularyTerm(
        code="UE_30_2_02_326",
        label="UE/30/2/02.326",
        description="""UE/30/2/02.326""",
    )

    ue_30_2_02_327 = VocabularyTerm(
        code="UE_30_2_02_327",
        label="UE/30/2/02.327",
        description="""UE/30/2/02.327""",
    )

    ue_30_2_02_328 = VocabularyTerm(
        code="UE_30_2_02_328",
        label="UE/30/2/02.328",
        description="""UE/30/2/02.328""",
    )

    ue_30_2_02_329 = VocabularyTerm(
        code="UE_30_2_02_329",
        label="UE/30/2/02.329",
        description="""UE/30/2/02.329""",
    )

    ue_30_2_02_329b = VocabularyTerm(
        code="UE_30_2_02_329B",
        label="UE/30/2/02.329B",
        description="""UE/30/2/02.329B""",
    )

    ue_30_2_02_329d = VocabularyTerm(
        code="UE_30_2_02_329D",
        label="UE/30/2/02.329D",
        description="""UE/30/2/02.329D""",
    )

    ue_30_2_02_329h = VocabularyTerm(
        code="UE_30_2_02_329H",
        label="UE/30/2/02.329H",
        description="""UE/30/2/02.329H""",
    )

    ue_30_2_02_330 = VocabularyTerm(
        code="UE_30_2_02_330",
        label="UE/30/2/02.330",
        description="""UE/30/2/02.330""",
    )

    ue_30_2_02_331 = VocabularyTerm(
        code="UE_30_2_02_331",
        label="UE/30/2/02.331",
        description="""UE/30/2/02.331""",
    )

    ue_30_2_02_332 = VocabularyTerm(
        code="UE_30_2_02_332",
        label="UE/30/2/02.332",
        description="""UE/30/2/02.332""",
    )

    ue_30_2_02_s01 = VocabularyTerm(
        code="UE_30_2_02_S01",
        label="UE/30/2/02.S01",
        description="""UE/30/2/02.S01""",
    )

    ue_30_2_02_s02 = VocabularyTerm(
        code="UE_30_2_02_S02",
        label="UE/30/2/02.S02",
        description="""UE/30/2/02.S02""",
    )

    ue_30_2_02_s03 = VocabularyTerm(
        code="UE_30_2_02_S03",
        label="UE/30/2/02.S03",
        description="""UE/30/2/02.S03""",
    )

    ue_30_2_02_s04 = VocabularyTerm(
        code="UE_30_2_02_S04",
        label="UE/30/2/02.S04",
        description="""UE/30/2/02.S04""",
    )

    ue_30_2_02_s05 = VocabularyTerm(
        code="UE_30_2_02_S05",
        label="UE/30/2/02.S05",
        description="""UE/30/2/02.S05""",
    )

    ue_30_2_02_s06 = VocabularyTerm(
        code="UE_30_2_02_S06",
        label="UE/30/2/02.S06",
        description="""UE/30/2/02.S06""",
    )

    ue_30_2_02_s08 = VocabularyTerm(
        code="UE_30_2_02_S08",
        label="UE/30/2/02.S08",
        description="""UE/30/2/02.S08""",
    )

    ue_30_2_02_s09 = VocabularyTerm(
        code="UE_30_2_02_S09",
        label="UE/30/2/02.S09",
        description="""UE/30/2/02.S09""",
    )

    ue_30_2_02_s10 = VocabularyTerm(
        code="UE_30_2_02_S10",
        label="UE/30/2/02.S10",
        description="""UE/30/2/02.S10""",
    )

    ue_30_2_02_s11 = VocabularyTerm(
        code="UE_30_2_02_S11",
        label="UE/30/2/02.S11",
        description="""UE/30/2/02.S11""",
    )

    ue_30_2_02_s12 = VocabularyTerm(
        code="UE_30_2_02_S12",
        label="UE/30/2/02.S12",
        description="""UE/30/2/02.S12""",
    )

    ue_30_2_02_s13 = VocabularyTerm(
        code="UE_30_2_02_S13",
        label="UE/30/2/02.S13",
        description="""UE/30/2/02.S13""",
    )

    ue_30_2_02_s14 = VocabularyTerm(
        code="UE_30_2_02_S14",
        label="UE/30/2/02.S14",
        description="""UE/30/2/02.S14""",
    )

    ue_30_2_02_s15 = VocabularyTerm(
        code="UE_30_2_02_S15",
        label="UE/30/2/02.S15",
        description="""UE/30/2/02.S15""",
    )

    ue_30_2_02_s16 = VocabularyTerm(
        code="UE_30_2_02_S16",
        label="UE/30/2/02.S16",
        description="""UE/30/2/02.S16""",
    )

    ue_30_3_03_400f = VocabularyTerm(
        code="UE_30_3_03_400F",
        label="UE/30/3/03.400F",
        description="""UE/30/3/03.400F""",
    )

    ue_30_3_03_400t = VocabularyTerm(
        code="UE_30_3_03_400T",
        label="UE/30/3/03.400T",
        description="""UE/30/3/03.400T""",
    )

    ue_30_3_03_401 = VocabularyTerm(
        code="UE_30_3_03_401",
        label="UE/30/3/03.401",
        description="""UE/30/3/03.401""",
    )

    ue_30_3_03_402f = VocabularyTerm(
        code="UE_30_3_03_402F",
        label="UE/30/3/03.402F",
        description="""UE/30/3/03.402F""",
    )

    ue_30_3_03_403 = VocabularyTerm(
        code="UE_30_3_03_403",
        label="UE/30/3/03.403",
        description="""UE/30/3/03.403""",
    )

    ue_30_3_03_405a1 = VocabularyTerm(
        code="UE_30_3_03_405A1",
        label="UE/30/3/03.405A1",
        description="""UE/30/3/03.405A1""",
    )

    ue_30_3_03_405f = VocabularyTerm(
        code="UE_30_3_03_405F",
        label="UE/30/3/03.405F",
        description="""UE/30/3/03.405F""",
    )

    ue_30_3_03_406 = VocabularyTerm(
        code="UE_30_3_03_406",
        label="UE/30/3/03.406",
        description="""UE/30/3/03.406""",
    )

    ue_30_3_03_406f = VocabularyTerm(
        code="UE_30_3_03_406F",
        label="UE/30/3/03.406F",
        description="""UE/30/3/03.406F""",
    )

    ue_30_3_03_407 = VocabularyTerm(
        code="UE_30_3_03_407",
        label="UE/30/3/03.407",
        description="""UE/30/3/03.407""",
    )

    ue_30_3_03_410 = VocabularyTerm(
        code="UE_30_3_03_410",
        label="UE/30/3/03.410",
        description="""UE/30/3/03.410""",
    )

    ue_30_3_03_411 = VocabularyTerm(
        code="UE_30_3_03_411",
        label="UE/30/3/03.411",
        description="""UE/30/3/03.411""",
    )

    ue_30_3_03_412 = VocabularyTerm(
        code="UE_30_3_03_412",
        label="UE/30/3/03.412",
        description="""UE/30/3/03.412""",
    )

    ue_30_3_03_412b = VocabularyTerm(
        code="UE_30_3_03_412B",
        label="UE/30/3/03.412B",
        description="""UE/30/3/03.412B""",
    )

    ue_30_3_03_412c = VocabularyTerm(
        code="UE_30_3_03_412C",
        label="UE/30/3/03.412C",
        description="""UE/30/3/03.412C""",
    )

    ue_30_3_03_413 = VocabularyTerm(
        code="UE_30_3_03_413",
        label="UE/30/3/03.413",
        description="""UE/30/3/03.413""",
    )

    ue_30_3_03_413b = VocabularyTerm(
        code="UE_30_3_03_413B",
        label="UE/30/3/03.413B",
        description="""UE/30/3/03.413B""",
    )

    ue_30_3_03_414 = VocabularyTerm(
        code="UE_30_3_03_414",
        label="UE/30/3/03.414",
        description="""UE/30/3/03.414""",
    )

    ue_30_3_03_414b = VocabularyTerm(
        code="UE_30_3_03_414B",
        label="UE/30/3/03.414B",
        description="""UE/30/3/03.414B""",
    )

    ue_30_3_03_416 = VocabularyTerm(
        code="UE_30_3_03_416",
        label="UE/30/3/03.416",
        description="""UE/30/3/03.416""",
    )

    ue_30_3_03_417b = VocabularyTerm(
        code="UE_30_3_03_417B",
        label="UE/30/3/03.417B",
        description="""UE/30/3/03.417B""",
    )

    ue_30_3_03_419f = VocabularyTerm(
        code="UE_30_3_03_419F",
        label="UE/30/3/03.419F",
        description="""UE/30/3/03.419F""",
    )

    ue_30_3_03_420a2 = VocabularyTerm(
        code="UE_30_3_03_420A2",
        label="UE/30/3/03.420A2",
        description="""UE/30/3/03.420A2""",
    )

    ue_30_3_03_420f = VocabularyTerm(
        code="UE_30_3_03_420F",
        label="UE/30/3/03.420F",
        description="""UE/30/3/03.420F""",
    )

    ue_30_3_03_421b = VocabularyTerm(
        code="UE_30_3_03_421B",
        label="UE/30/3/03.421B",
        description="""UE/30/3/03.421B""",
    )

    ue_30_3_03_421c = VocabularyTerm(
        code="UE_30_3_03_421C",
        label="UE/30/3/03.421C",
        description="""UE/30/3/03.421C""",
    )

    ue_30_3_03_421e = VocabularyTerm(
        code="UE_30_3_03_421E",
        label="UE/30/3/03.421E",
        description="""UE/30/3/03.421E""",
    )

    ue_30_3_03_421f = VocabularyTerm(
        code="UE_30_3_03_421F",
        label="UE/30/3/03.421F",
        description="""UE/30/3/03.421F""",
    )

    ue_30_3_03_421t = VocabularyTerm(
        code="UE_30_3_03_421T",
        label="UE/30/3/03.421T",
        description="""UE/30/3/03.421T""",
    )

    ue_30_3_03_422f = VocabularyTerm(
        code="UE_30_3_03_422F",
        label="UE/30/3/03.422F",
        description="""UE/30/3/03.422F""",
    )

    ue_30_3_03_423 = VocabularyTerm(
        code="UE_30_3_03_423",
        label="UE/30/3/03.423",
        description="""UE/30/3/03.423""",
    )

    ue_30_3_03_424 = VocabularyTerm(
        code="UE_30_3_03_424",
        label="UE/30/3/03.424",
        description="""UE/30/3/03.424""",
    )

    ue_30_3_03_425 = VocabularyTerm(
        code="UE_30_3_03_425",
        label="UE/30/3/03.425",
        description="""UE/30/3/03.425""",
    )

    ue_30_3_03_425b = VocabularyTerm(
        code="UE_30_3_03_425B",
        label="UE/30/3/03.425B",
        description="""UE/30/3/03.425B""",
    )

    ue_30_3_03_426 = VocabularyTerm(
        code="UE_30_3_03_426",
        label="UE/30/3/03.426",
        description="""UE/30/3/03.426""",
    )

    ue_30_3_03_426b = VocabularyTerm(
        code="UE_30_3_03_426B",
        label="UE/30/3/03.426B",
        description="""UE/30/3/03.426B""",
    )

    ue_30_3_03_427 = VocabularyTerm(
        code="UE_30_3_03_427",
        label="UE/30/3/03.427",
        description="""UE/30/3/03.427""",
    )

    ue_30_3_03_427b = VocabularyTerm(
        code="UE_30_3_03_427B",
        label="UE/30/3/03.427B",
        description="""UE/30/3/03.427B""",
    )

    ue_30_3_03_428 = VocabularyTerm(
        code="UE_30_3_03_428",
        label="UE/30/3/03.428",
        description="""UE/30/3/03.428""",
    )

    ue_30_3_03_428b = VocabularyTerm(
        code="UE_30_3_03_428B",
        label="UE/30/3/03.428B",
        description="""UE/30/3/03.428B""",
    )

    ue_30_3_03_429 = VocabularyTerm(
        code="UE_30_3_03_429",
        label="UE/30/3/03.429",
        description="""UE/30/3/03.429""",
    )

    ue_30_3_03_429b = VocabularyTerm(
        code="UE_30_3_03_429B",
        label="UE/30/3/03.429B",
        description="""UE/30/3/03.429B""",
    )

    ue_30_3_03_429d = VocabularyTerm(
        code="UE_30_3_03_429D",
        label="UE/30/3/03.429D",
        description="""UE/30/3/03.429D""",
    )

    ue_30_3_03_429h = VocabularyTerm(
        code="UE_30_3_03_429H",
        label="UE/30/3/03.429H",
        description="""UE/30/3/03.429H""",
    )

    ue_30_3_03_430 = VocabularyTerm(
        code="UE_30_3_03_430",
        label="UE/30/3/03.430",
        description="""UE/30/3/03.430""",
    )

    ue_30_3_03_431 = VocabularyTerm(
        code="UE_30_3_03_431",
        label="UE/30/3/03.431",
        description="""UE/30/3/03.431""",
    )

    ue_30_3_03_432 = VocabularyTerm(
        code="UE_30_3_03_432",
        label="UE/30/3/03.432",
        description="""UE/30/3/03.432""",
    )

    ue_30_3_03_s00 = VocabularyTerm(
        code="UE_30_3_03_S00",
        label="UE/30/3/03.S00",
        description="""UE/30/3/03.S00""",
    )

    ue_30_3_03_s01 = VocabularyTerm(
        code="UE_30_3_03_S01",
        label="UE/30/3/03.S01",
        description="""UE/30/3/03.S01""",
    )

    ue_30_3_03_s02 = VocabularyTerm(
        code="UE_30_3_03_S02",
        label="UE/30/3/03.S02",
        description="""UE/30/3/03.S02""",
    )

    ue_30_3_03_s03 = VocabularyTerm(
        code="UE_30_3_03_S03",
        label="UE/30/3/03.S03",
        description="""UE/30/3/03.S03""",
    )

    ue_30_3_03_s04 = VocabularyTerm(
        code="UE_30_3_03_S04",
        label="UE/30/3/03.S04",
        description="""UE/30/3/03.S04""",
    )

    ue_30_3_03_s05 = VocabularyTerm(
        code="UE_30_3_03_S05",
        label="UE/30/3/03.S05",
        description="""UE/30/3/03.S05""",
    )

    ue_30_3_03_s06 = VocabularyTerm(
        code="UE_30_3_03_S06",
        label="UE/30/3/03.S06",
        description="""UE/30/3/03.S06""",
    )

    ue_30_3_03_s07 = VocabularyTerm(
        code="UE_30_3_03_S07",
        label="UE/30/3/03.S07",
        description="""UE/30/3/03.S07""",
    )

    ue_30_3_03_s08 = VocabularyTerm(
        code="UE_30_3_03_S08",
        label="UE/30/3/03.S08",
        description="""UE/30/3/03.S08""",
    )

    ue_30_3_03_s09 = VocabularyTerm(
        code="UE_30_3_03_S09",
        label="UE/30/3/03.S09",
        description="""UE/30/3/03.S09""",
    )

    ue_30_3_03_s10 = VocabularyTerm(
        code="UE_30_3_03_S10",
        label="UE/30/3/03.S10",
        description="""UE/30/3/03.S10""",
    )

    ue_30_3_03_s11 = VocabularyTerm(
        code="UE_30_3_03_S11",
        label="UE/30/3/03.S11",
        description="""UE/30/3/03.S11""",
    )

    ue_30_3_03_s12 = VocabularyTerm(
        code="UE_30_3_03_S12",
        label="UE/30/3/03.S12",
        description="""UE/30/3/03.S12""",
    )

    ue_30_3_03_s13 = VocabularyTerm(
        code="UE_30_3_03_S13",
        label="UE/30/3/03.S13",
        description="""UE/30/3/03.S13""",
    )

    ue_30_3_03_s14 = VocabularyTerm(
        code="UE_30_3_03_S14",
        label="UE/30/3/03.S14",
        description="""UE/30/3/03.S14""",
    )

    ue_30_3_03_s15 = VocabularyTerm(
        code="UE_30_3_03_S15",
        label="UE/30/3/03.S15",
        description="""UE/30/3/03.S15""",
    )

    ue_30_3_03_s16 = VocabularyTerm(
        code="UE_30_3_03_S16",
        label="UE/30/3/03.S16",
        description="""UE/30/3/03.S16""",
    )

    ue_30_4_04_500f = VocabularyTerm(
        code="UE_30_4_04_500F",
        label="UE/30/4/04.500F",
        description="""UE/30/4/04.500F""",
    )

    ue_30_4_04_500t = VocabularyTerm(
        code="UE_30_4_04_500T",
        label="UE/30/4/04.500T",
        description="""UE/30/4/04.500T""",
    )

    ue_30_4_04_501 = VocabularyTerm(
        code="UE_30_4_04_501",
        label="UE/30/4/04.501",
        description="""UE/30/4/04.501""",
    )

    ue_30_4_04_502f = VocabularyTerm(
        code="UE_30_4_04_502F",
        label="UE/30/4/04.502F",
        description="""UE/30/4/04.502F""",
    )

    ue_30_4_04_503 = VocabularyTerm(
        code="UE_30_4_04_503",
        label="UE/30/4/04.503",
        description="""UE/30/4/04.503""",
    )

    ue_30_4_04_505 = VocabularyTerm(
        code="UE_30_4_04_505",
        label="UE/30/4/04.505",
        description="""UE/30/4/04.505""",
    )

    ue_30_4_04_505a1 = VocabularyTerm(
        code="UE_30_4_04_505A1",
        label="UE/30/4/04.505A1",
        description="""UE/30/4/04.505A1""",
    )

    ue_30_4_04_505f = VocabularyTerm(
        code="UE_30_4_04_505F",
        label="UE/30/4/04.505F",
        description="""UE/30/4/04.505F""",
    )

    ue_30_4_04_506 = VocabularyTerm(
        code="UE_30_4_04_506",
        label="UE/30/4/04.506",
        description="""UE/30/4/04.506""",
    )

    ue_30_4_04_506f = VocabularyTerm(
        code="UE_30_4_04_506F",
        label="UE/30/4/04.506F",
        description="""UE/30/4/04.506F""",
    )

    ue_30_4_04_507 = VocabularyTerm(
        code="UE_30_4_04_507",
        label="UE/30/4/04.507",
        description="""UE/30/4/04.507""",
    )

    ue_30_4_04_508 = VocabularyTerm(
        code="UE_30_4_04_508",
        label="UE/30/4/04.508",
        description="""UE/30/4/04.508""",
    )

    ue_30_4_04_510 = VocabularyTerm(
        code="UE_30_4_04_510",
        label="UE/30/4/04.510",
        description="""UE/30/4/04.510""",
    )

    ue_30_4_04_511 = VocabularyTerm(
        code="UE_30_4_04_511",
        label="UE/30/4/04.511",
        description="""UE/30/4/04.511""",
    )

    ue_30_4_04_512 = VocabularyTerm(
        code="UE_30_4_04_512",
        label="UE/30/4/04.512",
        description="""UE/30/4/04.512""",
    )

    ue_30_4_04_512b = VocabularyTerm(
        code="UE_30_4_04_512B",
        label="UE/30/4/04.512B",
        description="""UE/30/4/04.512B""",
    )

    ue_30_4_04_512c = VocabularyTerm(
        code="UE_30_4_04_512C",
        label="UE/30/4/04.512C",
        description="""UE/30/4/04.512C""",
    )

    ue_30_4_04_513 = VocabularyTerm(
        code="UE_30_4_04_513",
        label="UE/30/4/04.513",
        description="""UE/30/4/04.513""",
    )

    ue_30_4_04_513b = VocabularyTerm(
        code="UE_30_4_04_513B",
        label="UE/30/4/04.513B",
        description="""UE/30/4/04.513B""",
    )

    ue_30_4_04_514 = VocabularyTerm(
        code="UE_30_4_04_514",
        label="UE/30/4/04.514",
        description="""UE/30/4/04.514""",
    )

    ue_30_4_04_514b = VocabularyTerm(
        code="UE_30_4_04_514B",
        label="UE/30/4/04.514B",
        description="""UE/30/4/04.514B""",
    )

    ue_30_4_04_515 = VocabularyTerm(
        code="UE_30_4_04_515",
        label="UE/30/4/04.515",
        description="""UE/30/4/04.515""",
    )

    ue_30_4_04_516 = VocabularyTerm(
        code="UE_30_4_04_516",
        label="UE/30/4/04.516",
        description="""UE/30/4/04.516""",
    )

    ue_30_4_04_517 = VocabularyTerm(
        code="UE_30_4_04_517",
        label="UE/30/4/04.517",
        description="""UE/30/4/04.517""",
    )

    ue_30_4_04_517b = VocabularyTerm(
        code="UE_30_4_04_517B",
        label="UE/30/4/04.517B",
        description="""UE/30/4/04.517B""",
    )

    ue_30_4_04_518 = VocabularyTerm(
        code="UE_30_4_04_518",
        label="UE/30/4/04.518",
        description="""UE/30/4/04.518""",
    )

    ue_30_4_04_519f = VocabularyTerm(
        code="UE_30_4_04_519F",
        label="UE/30/4/04.519F",
        description="""UE/30/4/04.519F""",
    )

    ue_30_4_04_520a2 = VocabularyTerm(
        code="UE_30_4_04_520A2",
        label="UE/30/4/04.520A2",
        description="""UE/30/4/04.520A2""",
    )

    ue_30_4_04_520f = VocabularyTerm(
        code="UE_30_4_04_520F",
        label="UE/30/4/04.520F",
        description="""UE/30/4/04.520F""",
    )

    ue_30_4_04_521b = VocabularyTerm(
        code="UE_30_4_04_521B",
        label="UE/30/4/04.521B",
        description="""UE/30/4/04.521B""",
    )

    ue_30_4_04_521c = VocabularyTerm(
        code="UE_30_4_04_521C",
        label="UE/30/4/04.521C",
        description="""UE/30/4/04.521C""",
    )

    ue_30_4_04_521e = VocabularyTerm(
        code="UE_30_4_04_521E",
        label="UE/30/4/04.521E",
        description="""UE/30/4/04.521E""",
    )

    ue_30_4_04_521f = VocabularyTerm(
        code="UE_30_4_04_521F",
        label="UE/30/4/04.521F",
        description="""UE/30/4/04.521F""",
    )

    ue_30_4_04_521t = VocabularyTerm(
        code="UE_30_4_04_521T",
        label="UE/30/4/04.521T",
        description="""UE/30/4/04.521T""",
    )

    ue_30_4_04_522f = VocabularyTerm(
        code="UE_30_4_04_522F",
        label="UE/30/4/04.522F",
        description="""UE/30/4/04.522F""",
    )

    ue_30_4_04_523 = VocabularyTerm(
        code="UE_30_4_04_523",
        label="UE/30/4/04.523",
        description="""UE/30/4/04.523""",
    )

    ue_30_4_04_524 = VocabularyTerm(
        code="UE_30_4_04_524",
        label="UE/30/4/04.524",
        description="""UE/30/4/04.524""",
    )

    ue_30_4_04_525 = VocabularyTerm(
        code="UE_30_4_04_525",
        label="UE/30/4/04.525",
        description="""UE/30/4/04.525""",
    )

    ue_30_4_04_525b = VocabularyTerm(
        code="UE_30_4_04_525B",
        label="UE/30/4/04.525B",
        description="""UE/30/4/04.525B""",
    )

    ue_30_4_04_526 = VocabularyTerm(
        code="UE_30_4_04_526",
        label="UE/30/4/04.526",
        description="""UE/30/4/04.526""",
    )

    ue_30_4_04_527 = VocabularyTerm(
        code="UE_30_4_04_527",
        label="UE/30/4/04.527",
        description="""UE/30/4/04.527""",
    )

    ue_30_4_04_527b = VocabularyTerm(
        code="UE_30_4_04_527B",
        label="UE/30/4/04.527B",
        description="""UE/30/4/04.527B""",
    )

    ue_30_4_04_528 = VocabularyTerm(
        code="UE_30_4_04_528",
        label="UE/30/4/04.528",
        description="""UE/30/4/04.528""",
    )

    ue_30_4_04_528wc = VocabularyTerm(
        code="UE_30_4_04_528WC",
        label="UE/30/4/04.528WC",
        description="""UE/30/4/04.528WC""",
    )

    ue_30_4_04_529 = VocabularyTerm(
        code="UE_30_4_04_529",
        label="UE/30/4/04.529",
        description="""UE/30/4/04.529""",
    )

    ue_30_4_04_529b = VocabularyTerm(
        code="UE_30_4_04_529B",
        label="UE/30/4/04.529B",
        description="""UE/30/4/04.529B""",
    )

    ue_30_4_04_529d = VocabularyTerm(
        code="UE_30_4_04_529D",
        label="UE/30/4/04.529D",
        description="""UE/30/4/04.529D""",
    )

    ue_30_4_04_529h = VocabularyTerm(
        code="UE_30_4_04_529H",
        label="UE/30/4/04.529H",
        description="""UE/30/4/04.529H""",
    )

    ue_30_4_04_530 = VocabularyTerm(
        code="UE_30_4_04_530",
        label="UE/30/4/04.530",
        description="""UE/30/4/04.530""",
    )

    ue_30_4_04_531 = VocabularyTerm(
        code="UE_30_4_04_531",
        label="UE/30/4/04.531",
        description="""UE/30/4/04.531""",
    )

    ue_30_4_04_532 = VocabularyTerm(
        code="UE_30_4_04_532",
        label="UE/30/4/04.532",
        description="""UE/30/4/04.532""",
    )

    ue_30_4_04_s00 = VocabularyTerm(
        code="UE_30_4_04_S00",
        label="UE/30/4/04.S00",
        description="""UE/30/4/04.S00""",
    )

    ue_30_4_04_s01 = VocabularyTerm(
        code="UE_30_4_04_S01",
        label="UE/30/4/04.S01",
        description="""UE/30/4/04.S01""",
    )

    ue_30_4_04_s02 = VocabularyTerm(
        code="UE_30_4_04_S02",
        label="UE/30/4/04.S02",
        description="""UE/30/4/04.S02""",
    )

    ue_30_4_04_s03 = VocabularyTerm(
        code="UE_30_4_04_S03",
        label="UE/30/4/04.S03",
        description="""UE/30/4/04.S03""",
    )

    ue_30_4_04_s04 = VocabularyTerm(
        code="UE_30_4_04_S04",
        label="UE/30/4/04.S04",
        description="""UE/30/4/04.S04""",
    )

    ue_30_4_04_s05 = VocabularyTerm(
        code="UE_30_4_04_S05",
        label="UE/30/4/04.S05",
        description="""UE/30/4/04.S05""",
    )

    ue_30_4_04_s06 = VocabularyTerm(
        code="UE_30_4_04_S06",
        label="UE/30/4/04.S06",
        description="""UE/30/4/04.S06""",
    )

    ue_30_4_04_s07 = VocabularyTerm(
        code="UE_30_4_04_S07",
        label="UE/30/4/04.S07",
        description="""UE/30/4/04.S07""",
    )

    ue_30_4_04_s08 = VocabularyTerm(
        code="UE_30_4_04_S08",
        label="UE/30/4/04.S08",
        description="""UE/30/4/04.S08""",
    )

    ue_30_4_04_s09 = VocabularyTerm(
        code="UE_30_4_04_S09",
        label="UE/30/4/04.S09",
        description="""UE/30/4/04.S09""",
    )

    ue_30_4_04_s10 = VocabularyTerm(
        code="UE_30_4_04_S10",
        label="UE/30/4/04.S10",
        description="""UE/30/4/04.S10""",
    )

    ue_30_4_04_s11 = VocabularyTerm(
        code="UE_30_4_04_S11",
        label="UE/30/4/04.S11",
        description="""UE/30/4/04.S11""",
    )

    ue_30_4_04_s12 = VocabularyTerm(
        code="UE_30_4_04_S12",
        label="UE/30/4/04.S12",
        description="""UE/30/4/04.S12""",
    )

    ue_30_4_04_s13 = VocabularyTerm(
        code="UE_30_4_04_S13",
        label="UE/30/4/04.S13",
        description="""UE/30/4/04.S13""",
    )

    ue_30_4_04_s14 = VocabularyTerm(
        code="UE_30_4_04_S14",
        label="UE/30/4/04.S14",
        description="""UE/30/4/04.S14""",
    )

    ue_30_4_04_s15 = VocabularyTerm(
        code="UE_30_4_04_S15",
        label="UE/30/4/04.S15",
        description="""UE/30/4/04.S15""",
    )

    ue_30_4_04_s16 = VocabularyTerm(
        code="UE_30_4_04_S16",
        label="UE/30/4/04.S16",
        description="""UE/30/4/04.S16""",
    )

    ue_30_5_05_600f = VocabularyTerm(
        code="UE_30_5_05_600F",
        label="UE/30/5/05.600F",
        description="""UE/30/5/05.600F""",
    )

    ue_30_5_05_600t = VocabularyTerm(
        code="UE_30_5_05_600T",
        label="UE/30/5/05.600T",
        description="""UE/30/5/05.600T""",
    )

    ue_30_5_05_601 = VocabularyTerm(
        code="UE_30_5_05_601",
        label="UE/30/5/05.601",
        description="""UE/30/5/05.601""",
    )

    ue_30_5_05_602f = VocabularyTerm(
        code="UE_30_5_05_602F",
        label="UE/30/5/05.602F",
        description="""UE/30/5/05.602F""",
    )

    ue_30_5_05_603 = VocabularyTerm(
        code="UE_30_5_05_603",
        label="UE/30/5/05.603",
        description="""UE/30/5/05.603""",
    )

    ue_30_5_05_605 = VocabularyTerm(
        code="UE_30_5_05_605",
        label="UE/30/5/05.605",
        description="""UE/30/5/05.605""",
    )

    ue_30_5_05_605a1 = VocabularyTerm(
        code="UE_30_5_05_605A1",
        label="UE/30/5/05.605A1",
        description="""UE/30/5/05.605A1""",
    )

    ue_30_5_05_605f = VocabularyTerm(
        code="UE_30_5_05_605F",
        label="UE/30/5/05.605F",
        description="""UE/30/5/05.605F""",
    )

    ue_30_5_05_606 = VocabularyTerm(
        code="UE_30_5_05_606",
        label="UE/30/5/05.606",
        description="""UE/30/5/05.606""",
    )

    ue_30_5_05_606f = VocabularyTerm(
        code="UE_30_5_05_606F",
        label="UE/30/5/05.606F",
        description="""UE/30/5/05.606F""",
    )

    ue_30_5_05_607 = VocabularyTerm(
        code="UE_30_5_05_607",
        label="UE/30/5/05.607",
        description="""UE/30/5/05.607""",
    )

    ue_30_5_05_610 = VocabularyTerm(
        code="UE_30_5_05_610",
        label="UE/30/5/05.610",
        description="""UE/30/5/05.610""",
    )

    ue_30_5_05_612 = VocabularyTerm(
        code="UE_30_5_05_612",
        label="UE/30/5/05.612",
        description="""UE/30/5/05.612""",
    )

    ue_30_5_05_612b = VocabularyTerm(
        code="UE_30_5_05_612B",
        label="UE/30/5/05.612B",
        description="""UE/30/5/05.612B""",
    )

    ue_30_5_05_612c = VocabularyTerm(
        code="UE_30_5_05_612C",
        label="UE/30/5/05.612C",
        description="""UE/30/5/05.612C""",
    )

    ue_30_5_05_613 = VocabularyTerm(
        code="UE_30_5_05_613",
        label="UE/30/5/05.613",
        description="""UE/30/5/05.613""",
    )

    ue_30_5_05_613b = VocabularyTerm(
        code="UE_30_5_05_613B",
        label="UE/30/5/05.613B",
        description="""UE/30/5/05.613B""",
    )

    ue_30_5_05_614 = VocabularyTerm(
        code="UE_30_5_05_614",
        label="UE/30/5/05.614",
        description="""UE/30/5/05.614""",
    )

    ue_30_5_05_614b = VocabularyTerm(
        code="UE_30_5_05_614B",
        label="UE/30/5/05.614B",
        description="""UE/30/5/05.614B""",
    )

    ue_30_5_05_616 = VocabularyTerm(
        code="UE_30_5_05_616",
        label="UE/30/5/05.616",
        description="""UE/30/5/05.616""",
    )

    ue_30_5_05_616b = VocabularyTerm(
        code="UE_30_5_05_616B",
        label="UE/30/5/05.616B",
        description="""UE/30/5/05.616B""",
    )

    ue_30_5_05_617b = VocabularyTerm(
        code="UE_30_5_05_617B",
        label="UE/30/5/05.617B",
        description="""UE/30/5/05.617B""",
    )

    ue_30_5_05_619f = VocabularyTerm(
        code="UE_30_5_05_619F",
        label="UE/30/5/05.619F",
        description="""UE/30/5/05.619F""",
    )

    ue_30_5_05_620a2 = VocabularyTerm(
        code="UE_30_5_05_620A2",
        label="UE/30/5/05.620A2",
        description="""UE/30/5/05.620A2""",
    )

    ue_30_5_05_620f = VocabularyTerm(
        code="UE_30_5_05_620F",
        label="UE/30/5/05.620F",
        description="""UE/30/5/05.620F""",
    )

    ue_30_5_05_621b = VocabularyTerm(
        code="UE_30_5_05_621B",
        label="UE/30/5/05.621B",
        description="""UE/30/5/05.621B""",
    )

    ue_30_5_05_621c = VocabularyTerm(
        code="UE_30_5_05_621C",
        label="UE/30/5/05.621C",
        description="""UE/30/5/05.621C""",
    )

    ue_30_5_05_621e = VocabularyTerm(
        code="UE_30_5_05_621E",
        label="UE/30/5/05.621E",
        description="""UE/30/5/05.621E""",
    )

    ue_30_5_05_621f = VocabularyTerm(
        code="UE_30_5_05_621F",
        label="UE/30/5/05.621F",
        description="""UE/30/5/05.621F""",
    )

    ue_30_5_05_621t = VocabularyTerm(
        code="UE_30_5_05_621T",
        label="UE/30/5/05.621T",
        description="""UE/30/5/05.621T""",
    )

    ue_30_5_05_622f = VocabularyTerm(
        code="UE_30_5_05_622F",
        label="UE/30/5/05.622F",
        description="""UE/30/5/05.622F""",
    )

    ue_30_5_05_623 = VocabularyTerm(
        code="UE_30_5_05_623",
        label="UE/30/5/05.623",
        description="""UE/30/5/05.623""",
    )

    ue_30_5_05_624 = VocabularyTerm(
        code="UE_30_5_05_624",
        label="UE/30/5/05.624",
        description="""UE/30/5/05.624""",
    )

    ue_30_5_05_625 = VocabularyTerm(
        code="UE_30_5_05_625",
        label="UE/30/5/05.625",
        description="""UE/30/5/05.625""",
    )

    ue_30_5_05_625b = VocabularyTerm(
        code="UE_30_5_05_625B",
        label="UE/30/5/05.625B",
        description="""UE/30/5/05.625B""",
    )

    ue_30_5_05_626 = VocabularyTerm(
        code="UE_30_5_05_626",
        label="UE/30/5/05.626",
        description="""UE/30/5/05.626""",
    )

    ue_30_5_05_626b = VocabularyTerm(
        code="UE_30_5_05_626B",
        label="UE/30/5/05.626B",
        description="""UE/30/5/05.626B""",
    )

    ue_30_5_05_627 = VocabularyTerm(
        code="UE_30_5_05_627",
        label="UE/30/5/05.627",
        description="""UE/30/5/05.627""",
    )

    ue_30_5_05_628 = VocabularyTerm(
        code="UE_30_5_05_628",
        label="UE/30/5/05.628",
        description="""UE/30/5/05.628""",
    )

    ue_30_5_05_629 = VocabularyTerm(
        code="UE_30_5_05_629",
        label="UE/30/5/05.629",
        description="""UE/30/5/05.629""",
    )

    ue_30_5_05_629b = VocabularyTerm(
        code="UE_30_5_05_629B",
        label="UE/30/5/05.629B",
        description="""UE/30/5/05.629B""",
    )

    ue_30_5_05_629d = VocabularyTerm(
        code="UE_30_5_05_629D",
        label="UE/30/5/05.629D",
        description="""UE/30/5/05.629D""",
    )

    ue_30_5_05_629h = VocabularyTerm(
        code="UE_30_5_05_629H",
        label="UE/30/5/05.629H",
        description="""UE/30/5/05.629H""",
    )

    ue_30_5_05_630 = VocabularyTerm(
        code="UE_30_5_05_630",
        label="UE/30/5/05.630",
        description="""UE/30/5/05.630""",
    )

    ue_30_5_05_631 = VocabularyTerm(
        code="UE_30_5_05_631",
        label="UE/30/5/05.631",
        description="""UE/30/5/05.631""",
    )

    ue_30_5_05_632 = VocabularyTerm(
        code="UE_30_5_05_632",
        label="UE/30/5/05.632",
        description="""UE/30/5/05.632""",
    )

    ue_30_5_05_633 = VocabularyTerm(
        code="UE_30_5_05_633",
        label="UE/30/5/05.633",
        description="""UE/30/5/05.633""",
    )

    ue_30_5_05_s00 = VocabularyTerm(
        code="UE_30_5_05_S00",
        label="UE/30/5/05.S00",
        description="""UE/30/5/05.S00""",
    )

    ue_30_5_05_s01 = VocabularyTerm(
        code="UE_30_5_05_S01",
        label="UE/30/5/05.S01",
        description="""UE/30/5/05.S01""",
    )

    ue_30_5_05_s02 = VocabularyTerm(
        code="UE_30_5_05_S02",
        label="UE/30/5/05.S02",
        description="""UE/30/5/05.S02""",
    )

    ue_30_5_05_s03 = VocabularyTerm(
        code="UE_30_5_05_S03",
        label="UE/30/5/05.S03",
        description="""UE/30/5/05.S03""",
    )

    ue_30_5_05_s04 = VocabularyTerm(
        code="UE_30_5_05_S04",
        label="UE/30/5/05.S04",
        description="""UE/30/5/05.S04""",
    )

    ue_30_5_05_s05 = VocabularyTerm(
        code="UE_30_5_05_S05",
        label="UE/30/5/05.S05",
        description="""UE/30/5/05.S05""",
    )

    ue_30_5_05_s06 = VocabularyTerm(
        code="UE_30_5_05_S06",
        label="UE/30/5/05.S06",
        description="""UE/30/5/05.S06""",
    )

    ue_30_5_05_s07 = VocabularyTerm(
        code="UE_30_5_05_S07",
        label="UE/30/5/05.S07",
        description="""UE/30/5/05.S07""",
    )

    ue_30_5_05_s08 = VocabularyTerm(
        code="UE_30_5_05_S08",
        label="UE/30/5/05.S08",
        description="""UE/30/5/05.S08""",
    )

    ue_30_5_05_s09 = VocabularyTerm(
        code="UE_30_5_05_S09",
        label="UE/30/5/05.S09",
        description="""UE/30/5/05.S09""",
    )

    ue_30_5_05_s10 = VocabularyTerm(
        code="UE_30_5_05_S10",
        label="UE/30/5/05.S10",
        description="""UE/30/5/05.S10""",
    )

    ue_30_5_05_s11 = VocabularyTerm(
        code="UE_30_5_05_S11",
        label="UE/30/5/05.S11",
        description="""UE/30/5/05.S11""",
    )

    ue_30_5_05_s12 = VocabularyTerm(
        code="UE_30_5_05_S12",
        label="UE/30/5/05.S12",
        description="""UE/30/5/05.S12""",
    )

    ue_30_5_05_s13 = VocabularyTerm(
        code="UE_30_5_05_S13",
        label="UE/30/5/05.S13",
        description="""UE/30/5/05.S13""",
    )

    ue_30_5_05_s14 = VocabularyTerm(
        code="UE_30_5_05_S14",
        label="UE/30/5/05.S14",
        description="""UE/30/5/05.S14""",
    )

    ue_30_5_05_s15 = VocabularyTerm(
        code="UE_30_5_05_S15",
        label="UE/30/5/05.S15",
        description="""UE/30/5/05.S15""",
    )

    ue_30_5_05_s16 = VocabularyTerm(
        code="UE_30_5_05_S16",
        label="UE/30/5/05.S16",
        description="""UE/30/5/05.S16""",
    )

    ue_30_6_06_700f = VocabularyTerm(
        code="UE_30_6_06_700F",
        label="UE/30/6/06.700F",
        description="""UE/30/6/06.700F""",
    )

    ue_30_6_06_700t = VocabularyTerm(
        code="UE_30_6_06_700T",
        label="UE/30/6/06.700T",
        description="""UE/30/6/06.700T""",
    )

    ue_30_6_06_701 = VocabularyTerm(
        code="UE_30_6_06_701",
        label="UE/30/6/06.701",
        description="""UE/30/6/06.701""",
    )

    ue_30_6_06_702f = VocabularyTerm(
        code="UE_30_6_06_702F",
        label="UE/30/6/06.702F",
        description="""UE/30/6/06.702F""",
    )

    ue_30_6_06_703 = VocabularyTerm(
        code="UE_30_6_06_703",
        label="UE/30/6/06.703",
        description="""UE/30/6/06.703""",
    )

    ue_30_6_06_705 = VocabularyTerm(
        code="UE_30_6_06_705",
        label="UE/30/6/06.705",
        description="""UE/30/6/06.705""",
    )

    ue_30_6_06_705a1 = VocabularyTerm(
        code="UE_30_6_06_705A1",
        label="UE/30/6/06.705A1",
        description="""UE/30/6/06.705A1""",
    )

    ue_30_6_06_705f = VocabularyTerm(
        code="UE_30_6_06_705F",
        label="UE/30/6/06.705F",
        description="""UE/30/6/06.705F""",
    )

    ue_30_6_06_706 = VocabularyTerm(
        code="UE_30_6_06_706",
        label="UE/30/6/06.706",
        description="""UE/30/6/06.706""",
    )

    ue_30_6_06_706f = VocabularyTerm(
        code="UE_30_6_06_706F",
        label="UE/30/6/06.706F",
        description="""UE/30/6/06.706F""",
    )

    ue_30_6_06_708 = VocabularyTerm(
        code="UE_30_6_06_708",
        label="UE/30/6/06.708",
        description="""UE/30/6/06.708""",
    )

    ue_30_6_06_710 = VocabularyTerm(
        code="UE_30_6_06_710",
        label="UE/30/6/06.710",
        description="""UE/30/6/06.710""",
    )

    ue_30_6_06_712 = VocabularyTerm(
        code="UE_30_6_06_712",
        label="UE/30/6/06.712",
        description="""UE/30/6/06.712""",
    )

    ue_30_6_06_712b = VocabularyTerm(
        code="UE_30_6_06_712B",
        label="UE/30/6/06.712B",
        description="""UE/30/6/06.712B""",
    )

    ue_30_6_06_712c = VocabularyTerm(
        code="UE_30_6_06_712C",
        label="UE/30/6/06.712C",
        description="""UE/30/6/06.712C""",
    )

    ue_30_6_06_713 = VocabularyTerm(
        code="UE_30_6_06_713",
        label="UE/30/6/06.713",
        description="""UE/30/6/06.713""",
    )

    ue_30_6_06_713b = VocabularyTerm(
        code="UE_30_6_06_713B",
        label="UE/30/6/06.713B",
        description="""UE/30/6/06.713B""",
    )

    ue_30_6_06_714b = VocabularyTerm(
        code="UE_30_6_06_714B",
        label="UE/30/6/06.714B",
        description="""UE/30/6/06.714B""",
    )

    ue_30_6_06_715 = VocabularyTerm(
        code="UE_30_6_06_715",
        label="UE/30/6/06.715",
        description="""UE/30/6/06.715""",
    )

    ue_30_6_06_715b = VocabularyTerm(
        code="UE_30_6_06_715B",
        label="UE/30/6/06.715B",
        description="""UE/30/6/06.715B""",
    )

    ue_30_6_06_716b = VocabularyTerm(
        code="UE_30_6_06_716B",
        label="UE/30/6/06.716B",
        description="""UE/30/6/06.716B""",
    )

    ue_30_6_06_717 = VocabularyTerm(
        code="UE_30_6_06_717",
        label="UE/30/6/06.717",
        description="""UE/30/6/06.717""",
    )

    ue_30_6_06_719f = VocabularyTerm(
        code="UE_30_6_06_719F",
        label="UE/30/6/06.719F",
        description="""UE/30/6/06.719F""",
    )

    ue_30_6_06_720a2 = VocabularyTerm(
        code="UE_30_6_06_720A2",
        label="UE/30/6/06.720A2",
        description="""UE/30/6/06.720A2""",
    )

    ue_30_6_06_720f = VocabularyTerm(
        code="UE_30_6_06_720F",
        label="UE/30/6/06.720F",
        description="""UE/30/6/06.720F""",
    )

    ue_30_6_06_721b = VocabularyTerm(
        code="UE_30_6_06_721B",
        label="UE/30/6/06.721B",
        description="""UE/30/6/06.721B""",
    )

    ue_30_6_06_721c = VocabularyTerm(
        code="UE_30_6_06_721C",
        label="UE/30/6/06.721C",
        description="""UE/30/6/06.721C""",
    )

    ue_30_6_06_721e = VocabularyTerm(
        code="UE_30_6_06_721E",
        label="UE/30/6/06.721E",
        description="""UE/30/6/06.721E""",
    )

    ue_30_6_06_721f = VocabularyTerm(
        code="UE_30_6_06_721F",
        label="UE/30/6/06.721F",
        description="""UE/30/6/06.721F""",
    )

    ue_30_6_06_721t = VocabularyTerm(
        code="UE_30_6_06_721T",
        label="UE/30/6/06.721T",
        description="""UE/30/6/06.721T""",
    )

    ue_30_6_06_722f = VocabularyTerm(
        code="UE_30_6_06_722F",
        label="UE/30/6/06.722F",
        description="""UE/30/6/06.722F""",
    )

    ue_30_6_06_723 = VocabularyTerm(
        code="UE_30_6_06_723",
        label="UE/30/6/06.723",
        description="""UE/30/6/06.723""",
    )

    ue_30_6_06_724 = VocabularyTerm(
        code="UE_30_6_06_724",
        label="UE/30/6/06.724",
        description="""UE/30/6/06.724""",
    )

    ue_30_6_06_724b = VocabularyTerm(
        code="UE_30_6_06_724B",
        label="UE/30/6/06.724B",
        description="""UE/30/6/06.724B""",
    )

    ue_30_6_06_725 = VocabularyTerm(
        code="UE_30_6_06_725",
        label="UE/30/6/06.725",
        description="""UE/30/6/06.725""",
    )

    ue_30_6_06_725b = VocabularyTerm(
        code="UE_30_6_06_725B",
        label="UE/30/6/06.725B",
        description="""UE/30/6/06.725B""",
    )

    ue_30_6_06_726 = VocabularyTerm(
        code="UE_30_6_06_726",
        label="UE/30/6/06.726",
        description="""UE/30/6/06.726""",
    )

    ue_30_6_06_726b = VocabularyTerm(
        code="UE_30_6_06_726B",
        label="UE/30/6/06.726B",
        description="""UE/30/6/06.726B""",
    )

    ue_30_6_06_727 = VocabularyTerm(
        code="UE_30_6_06_727",
        label="UE/30/6/06.727",
        description="""UE/30/6/06.727""",
    )

    ue_30_6_06_727b = VocabularyTerm(
        code="UE_30_6_06_727B",
        label="UE/30/6/06.727B",
        description="""UE/30/6/06.727B""",
    )

    ue_30_6_06_728 = VocabularyTerm(
        code="UE_30_6_06_728",
        label="UE/30/6/06.728",
        description="""UE/30/6/06.728""",
    )

    ue_30_6_06_728b = VocabularyTerm(
        code="UE_30_6_06_728B",
        label="UE/30/6/06.728B",
        description="""UE/30/6/06.728B""",
    )

    ue_30_6_06_729 = VocabularyTerm(
        code="UE_30_6_06_729",
        label="UE/30/6/06.729",
        description="""UE/30/6/06.729""",
    )

    ue_30_6_06_729b = VocabularyTerm(
        code="UE_30_6_06_729B",
        label="UE/30/6/06.729B",
        description="""UE/30/6/06.729B""",
    )

    ue_30_6_06_729d = VocabularyTerm(
        code="UE_30_6_06_729D",
        label="UE/30/6/06.729D",
        description="""UE/30/6/06.729D""",
    )

    ue_30_6_06_729h = VocabularyTerm(
        code="UE_30_6_06_729H",
        label="UE/30/6/06.729H",
        description="""UE/30/6/06.729H""",
    )

    ue_30_6_06_730 = VocabularyTerm(
        code="UE_30_6_06_730",
        label="UE/30/6/06.730",
        description="""UE/30/6/06.730""",
    )

    ue_30_6_06_731 = VocabularyTerm(
        code="UE_30_6_06_731",
        label="UE/30/6/06.731",
        description="""UE/30/6/06.731""",
    )

    ue_30_6_06_732 = VocabularyTerm(
        code="UE_30_6_06_732",
        label="UE/30/6/06.732",
        description="""UE/30/6/06.732""",
    )

    ue_30_6_06_733 = VocabularyTerm(
        code="UE_30_6_06_733",
        label="UE/30/6/06.733",
        description="""UE/30/6/06.733""",
    )

    ue_30_6_06_s00 = VocabularyTerm(
        code="UE_30_6_06_S00",
        label="UE/30/6/06.S00",
        description="""UE/30/6/06.S00""",
    )

    ue_30_6_06_s01 = VocabularyTerm(
        code="UE_30_6_06_S01",
        label="UE/30/6/06.S01",
        description="""UE/30/6/06.S01""",
    )

    ue_30_6_06_s02 = VocabularyTerm(
        code="UE_30_6_06_S02",
        label="UE/30/6/06.S02",
        description="""UE/30/6/06.S02""",
    )

    ue_30_6_06_s03 = VocabularyTerm(
        code="UE_30_6_06_S03",
        label="UE/30/6/06.S03",
        description="""UE/30/6/06.S03""",
    )

    ue_30_6_06_s04 = VocabularyTerm(
        code="UE_30_6_06_S04",
        label="UE/30/6/06.S04",
        description="""UE/30/6/06.S04""",
    )

    ue_30_6_06_s05 = VocabularyTerm(
        code="UE_30_6_06_S05",
        label="UE/30/6/06.S05",
        description="""UE/30/6/06.S05""",
    )

    ue_30_6_06_s06 = VocabularyTerm(
        code="UE_30_6_06_S06",
        label="UE/30/6/06.S06",
        description="""UE/30/6/06.S06""",
    )

    ue_30_6_06_s07 = VocabularyTerm(
        code="UE_30_6_06_S07",
        label="UE/30/6/06.S07",
        description="""UE/30/6/06.S07""",
    )

    ue_30_6_06_s08 = VocabularyTerm(
        code="UE_30_6_06_S08",
        label="UE/30/6/06.S08",
        description="""UE/30/6/06.S08""",
    )

    ue_30_6_06_s09 = VocabularyTerm(
        code="UE_30_6_06_S09",
        label="UE/30/6/06.S09",
        description="""UE/30/6/06.S09""",
    )

    ue_30_6_06_s10 = VocabularyTerm(
        code="UE_30_6_06_S10",
        label="UE/30/6/06.S10",
        description="""UE/30/6/06.S10""",
    )

    ue_30_6_06_s11 = VocabularyTerm(
        code="UE_30_6_06_S11",
        label="UE/30/6/06.S11",
        description="""UE/30/6/06.S11""",
    )

    ue_30_6_06_s12 = VocabularyTerm(
        code="UE_30_6_06_S12",
        label="UE/30/6/06.S12",
        description="""UE/30/6/06.S12""",
    )

    ue_30_6_06_s13 = VocabularyTerm(
        code="UE_30_6_06_S13",
        label="UE/30/6/06.S13",
        description="""UE/30/6/06.S13""",
    )

    ue_30_6_06_s14 = VocabularyTerm(
        code="UE_30_6_06_S14",
        label="UE/30/6/06.S14",
        description="""UE/30/6/06.S14""",
    )

    ue_30_6_06_s15 = VocabularyTerm(
        code="UE_30_6_06_S15",
        label="UE/30/6/06.S15",
        description="""UE/30/6/06.S15""",
    )

    ue_30_6_06_s16 = VocabularyTerm(
        code="UE_30_6_06_S16",
        label="UE/30/6/06.S16",
        description="""UE/30/6/06.S16""",
    )

    ue_30_7_07_800f = VocabularyTerm(
        code="UE_30_7_07_800F",
        label="UE/30/7/07.800F",
        description="""UE/30/7/07.800F""",
    )

    ue_30_7_07_800t = VocabularyTerm(
        code="UE_30_7_07_800T",
        label="UE/30/7/07.800T",
        description="""UE/30/7/07.800T""",
    )

    ue_30_7_07_801 = VocabularyTerm(
        code="UE_30_7_07_801",
        label="UE/30/7/07.801",
        description="""UE/30/7/07.801""",
    )

    ue_30_7_07_802f = VocabularyTerm(
        code="UE_30_7_07_802F",
        label="UE/30/7/07.802F",
        description="""UE/30/7/07.802F""",
    )

    ue_30_7_07_803 = VocabularyTerm(
        code="UE_30_7_07_803",
        label="UE/30/7/07.803",
        description="""UE/30/7/07.803""",
    )

    ue_30_7_07_805a1 = VocabularyTerm(
        code="UE_30_7_07_805A1",
        label="UE/30/7/07.805A1",
        description="""UE/30/7/07.805A1""",
    )

    ue_30_7_07_805f = VocabularyTerm(
        code="UE_30_7_07_805F",
        label="UE/30/7/07.805F",
        description="""UE/30/7/07.805F""",
    )

    ue_30_7_07_806 = VocabularyTerm(
        code="UE_30_7_07_806",
        label="UE/30/7/07.806",
        description="""UE/30/7/07.806""",
    )

    ue_30_7_07_806f = VocabularyTerm(
        code="UE_30_7_07_806F",
        label="UE/30/7/07.806F",
        description="""UE/30/7/07.806F""",
    )

    ue_30_7_07_807 = VocabularyTerm(
        code="UE_30_7_07_807",
        label="UE/30/7/07.807",
        description="""UE/30/7/07.807""",
    )

    ue_30_7_07_810 = VocabularyTerm(
        code="UE_30_7_07_810",
        label="UE/30/7/07.810",
        description="""UE/30/7/07.810""",
    )

    ue_30_7_07_812 = VocabularyTerm(
        code="UE_30_7_07_812",
        label="UE/30/7/07.812",
        description="""UE/30/7/07.812""",
    )

    ue_30_7_07_812b = VocabularyTerm(
        code="UE_30_7_07_812B",
        label="UE/30/7/07.812B",
        description="""UE/30/7/07.812B""",
    )

    ue_30_7_07_812c = VocabularyTerm(
        code="UE_30_7_07_812C",
        label="UE/30/7/07.812C",
        description="""UE/30/7/07.812C""",
    )

    ue_30_7_07_813 = VocabularyTerm(
        code="UE_30_7_07_813",
        label="UE/30/7/07.813",
        description="""UE/30/7/07.813""",
    )

    ue_30_7_07_813b = VocabularyTerm(
        code="UE_30_7_07_813B",
        label="UE/30/7/07.813B",
        description="""UE/30/7/07.813B""",
    )

    ue_30_7_07_814 = VocabularyTerm(
        code="UE_30_7_07_814",
        label="UE/30/7/07.814",
        description="""UE/30/7/07.814""",
    )

    ue_30_7_07_815 = VocabularyTerm(
        code="UE_30_7_07_815",
        label="UE/30/7/07.815",
        description="""UE/30/7/07.815""",
    )

    ue_30_7_07_816 = VocabularyTerm(
        code="UE_30_7_07_816",
        label="UE/30/7/07.816",
        description="""UE/30/7/07.816""",
    )

    ue_30_7_07_816b = VocabularyTerm(
        code="UE_30_7_07_816B",
        label="UE/30/7/07.816B",
        description="""UE/30/7/07.816B""",
    )

    ue_30_7_07_819f = VocabularyTerm(
        code="UE_30_7_07_819F",
        label="UE/30/7/07.819F",
        description="""UE/30/7/07.819F""",
    )

    ue_30_7_07_820a2 = VocabularyTerm(
        code="UE_30_7_07_820A2",
        label="UE/30/7/07.820A2",
        description="""UE/30/7/07.820A2""",
    )

    ue_30_7_07_820f = VocabularyTerm(
        code="UE_30_7_07_820F",
        label="UE/30/7/07.820F",
        description="""UE/30/7/07.820F""",
    )

    ue_30_7_07_821b = VocabularyTerm(
        code="UE_30_7_07_821B",
        label="UE/30/7/07.821B",
        description="""UE/30/7/07.821B""",
    )

    ue_30_7_07_821c = VocabularyTerm(
        code="UE_30_7_07_821C",
        label="UE/30/7/07.821C",
        description="""UE/30/7/07.821C""",
    )

    ue_30_7_07_821e = VocabularyTerm(
        code="UE_30_7_07_821E",
        label="UE/30/7/07.821E",
        description="""UE/30/7/07.821E""",
    )

    ue_30_7_07_821f = VocabularyTerm(
        code="UE_30_7_07_821F",
        label="UE/30/7/07.821F",
        description="""UE/30/7/07.821F""",
    )

    ue_30_7_07_821t = VocabularyTerm(
        code="UE_30_7_07_821T",
        label="UE/30/7/07.821T",
        description="""UE/30/7/07.821T""",
    )

    ue_30_7_07_822f = VocabularyTerm(
        code="UE_30_7_07_822F",
        label="UE/30/7/07.822F",
        description="""UE/30/7/07.822F""",
    )

    ue_30_7_07_823 = VocabularyTerm(
        code="UE_30_7_07_823",
        label="UE/30/7/07.823",
        description="""UE/30/7/07.823""",
    )

    ue_30_7_07_824 = VocabularyTerm(
        code="UE_30_7_07_824",
        label="UE/30/7/07.824",
        description="""UE/30/7/07.824""",
    )

    ue_30_7_07_825 = VocabularyTerm(
        code="UE_30_7_07_825",
        label="UE/30/7/07.825",
        description="""UE/30/7/07.825""",
    )

    ue_30_7_07_826 = VocabularyTerm(
        code="UE_30_7_07_826",
        label="UE/30/7/07.826",
        description="""UE/30/7/07.826""",
    )

    ue_30_7_07_826b = VocabularyTerm(
        code="UE_30_7_07_826B",
        label="UE/30/7/07.826B",
        description="""UE/30/7/07.826B""",
    )

    ue_30_7_07_827 = VocabularyTerm(
        code="UE_30_7_07_827",
        label="UE/30/7/07.827",
        description="""UE/30/7/07.827""",
    )

    ue_30_7_07_827b = VocabularyTerm(
        code="UE_30_7_07_827B",
        label="UE/30/7/07.827B",
        description="""UE/30/7/07.827B""",
    )

    ue_30_7_07_828 = VocabularyTerm(
        code="UE_30_7_07_828",
        label="UE/30/7/07.828",
        description="""UE/30/7/07.828""",
    )

    ue_30_7_07_828b = VocabularyTerm(
        code="UE_30_7_07_828B",
        label="UE/30/7/07.828B",
        description="""UE/30/7/07.828B""",
    )

    ue_30_7_07_829 = VocabularyTerm(
        code="UE_30_7_07_829",
        label="UE/30/7/07.829",
        description="""UE/30/7/07.829""",
    )

    ue_30_7_07_829b = VocabularyTerm(
        code="UE_30_7_07_829B",
        label="UE/30/7/07.829B",
        description="""UE/30/7/07.829B""",
    )

    ue_30_7_07_829d = VocabularyTerm(
        code="UE_30_7_07_829D",
        label="UE/30/7/07.829D",
        description="""UE/30/7/07.829D""",
    )

    ue_30_7_07_829h = VocabularyTerm(
        code="UE_30_7_07_829H",
        label="UE/30/7/07.829H",
        description="""UE/30/7/07.829H""",
    )

    ue_30_7_07_830 = VocabularyTerm(
        code="UE_30_7_07_830",
        label="UE/30/7/07.830",
        description="""UE/30/7/07.830""",
    )

    ue_30_7_07_831 = VocabularyTerm(
        code="UE_30_7_07_831",
        label="UE/30/7/07.831",
        description="""UE/30/7/07.831""",
    )

    ue_30_7_07_832 = VocabularyTerm(
        code="UE_30_7_07_832",
        label="UE/30/7/07.832",
        description="""UE/30/7/07.832""",
    )

    ue_30_7_07_s00 = VocabularyTerm(
        code="UE_30_7_07_S00",
        label="UE/30/7/07.S00",
        description="""UE/30/7/07.S00""",
    )

    ue_30_7_07_s02 = VocabularyTerm(
        code="UE_30_7_07_S02",
        label="UE/30/7/07.S02",
        description="""UE/30/7/07.S02""",
    )

    ue_30_7_07_s03 = VocabularyTerm(
        code="UE_30_7_07_S03",
        label="UE/30/7/07.S03",
        description="""UE/30/7/07.S03""",
    )

    ue_30_7_07_s04 = VocabularyTerm(
        code="UE_30_7_07_S04",
        label="UE/30/7/07.S04",
        description="""UE/30/7/07.S04""",
    )

    ue_30_7_07_s05 = VocabularyTerm(
        code="UE_30_7_07_S05",
        label="UE/30/7/07.S05",
        description="""UE/30/7/07.S05""",
    )

    ue_30_7_07_s06 = VocabularyTerm(
        code="UE_30_7_07_S06",
        label="UE/30/7/07.S06",
        description="""UE/30/7/07.S06""",
    )

    ue_30_7_07_s07 = VocabularyTerm(
        code="UE_30_7_07_S07",
        label="UE/30/7/07.S07",
        description="""UE/30/7/07.S07""",
    )

    ue_30_7_07_s08 = VocabularyTerm(
        code="UE_30_7_07_S08",
        label="UE/30/7/07.S08",
        description="""UE/30/7/07.S08""",
    )

    ue_30_7_07_s09 = VocabularyTerm(
        code="UE_30_7_07_S09",
        label="UE/30/7/07.S09",
        description="""UE/30/7/07.S09""",
    )

    ue_30_7_07_s10 = VocabularyTerm(
        code="UE_30_7_07_S10",
        label="UE/30/7/07.S10",
        description="""UE/30/7/07.S10""",
    )

    ue_30_7_07_s11 = VocabularyTerm(
        code="UE_30_7_07_S11",
        label="UE/30/7/07.S11",
        description="""UE/30/7/07.S11""",
    )

    ue_30_7_07_s12 = VocabularyTerm(
        code="UE_30_7_07_S12",
        label="UE/30/7/07.S12",
        description="""UE/30/7/07.S12""",
    )

    ue_30_7_07_s13 = VocabularyTerm(
        code="UE_30_7_07_S13",
        label="UE/30/7/07.S13",
        description="""UE/30/7/07.S13""",
    )

    ue_30_7_07_s14 = VocabularyTerm(
        code="UE_30_7_07_S14",
        label="UE/30/7/07.S14",
        description="""UE/30/7/07.S14""",
    )

    ue_30_7_07_s15 = VocabularyTerm(
        code="UE_30_7_07_S15",
        label="UE/30/7/07.S15",
        description="""UE/30/7/07.S15""",
    )

    ue_30_7_07_s16 = VocabularyTerm(
        code="UE_30_7_07_S16",
        label="UE/30/7/07.S16",
        description="""UE/30/7/07.S16""",
    )

    ue_30_8_08_900 = VocabularyTerm(
        code="UE_30_8_08_900",
        label="UE/30/8/08.900",
        description="""UE/30/8/08.900""",
    )

    ue_30_8_08_900t = VocabularyTerm(
        code="UE_30_8_08_900T",
        label="UE/30/8/08.900T",
        description="""UE/30/8/08.900T""",
    )

    ue_30_8_08_901 = VocabularyTerm(
        code="UE_30_8_08_901",
        label="UE/30/8/08.901",
        description="""UE/30/8/08.901""",
    )

    ue_30_8_08_901f = VocabularyTerm(
        code="UE_30_8_08_901F",
        label="UE/30/8/08.901F",
        description="""UE/30/8/08.901F""",
    )

    ue_30_8_08_902f = VocabularyTerm(
        code="UE_30_8_08_902F",
        label="UE/30/8/08.902F",
        description="""UE/30/8/08.902F""",
    )

    ue_30_8_08_905a1 = VocabularyTerm(
        code="UE_30_8_08_905A1",
        label="UE/30/8/08.905A1",
        description="""UE/30/8/08.905A1""",
    )

    ue_30_8_08_905f = VocabularyTerm(
        code="UE_30_8_08_905F",
        label="UE/30/8/08.905F",
        description="""UE/30/8/08.905F""",
    )

    ue_30_8_08_920a2 = VocabularyTerm(
        code="UE_30_8_08_920A2",
        label="UE/30/8/08.920A2",
        description="""UE/30/8/08.920A2""",
    )

    ue_30_8_08_921 = VocabularyTerm(
        code="UE_30_8_08_921",
        label="UE/30/8/08.921",
        description="""UE/30/8/08.921""",
    )

    ue_30_8_08_921f = VocabularyTerm(
        code="UE_30_8_08_921F",
        label="UE/30/8/08.921F",
        description="""UE/30/8/08.921F""",
    )

    ue_30_8_08_921t = VocabularyTerm(
        code="UE_30_8_08_921T",
        label="UE/30/8/08.921T",
        description="""UE/30/8/08.921T""",
    )

    ue_30_8_08_922 = VocabularyTerm(
        code="UE_30_8_08_922",
        label="UE/30/8/08.922",
        description="""UE/30/8/08.922""",
    )

    ue_30_8_08_922f = VocabularyTerm(
        code="UE_30_8_08_922F",
        label="UE/30/8/08.922F",
        description="""UE/30/8/08.922F""",
    )

    ue_30_8_08_s00 = VocabularyTerm(
        code="UE_30_8_08_S00",
        label="UE/30/8/08.S00",
        description="""UE/30/8/08.S00""",
    )

    ue_30_9_1005 = VocabularyTerm(
        code="UE_30_9_1005",
        label="UE/30/9/1005",
        description="""UE/30/9/1005""",
    )

    ue_30_9_1005f = VocabularyTerm(
        code="UE_30_9_1005F",
        label="UE/30/9/1005F",
        description="""UE/30/9/1005F""",
    )

    ue_30_9_1025 = VocabularyTerm(
        code="UE_30_9_1025",
        label="UE/30/9/1025",
        description="""UE/30/9/1025""",
    )

    ue_30__1_anbau_ost_042 = VocabularyTerm(
        code="UE_30_-1_ANBAU_OST_042",
        label="UE/30/-1_Anbau Ost/042",
        description="""UE/30/-1_Anbau Ost/042""",
    )

    ue_30__1_anbau_ost_049 = VocabularyTerm(
        code="UE_30_-1_ANBAU_OST_049",
        label="UE/30/-1_Anbau Ost/049",
        description="""UE/30/-1_Anbau Ost/049""",
    )

    ue_30__1_anbau_ost_050 = VocabularyTerm(
        code="UE_30_-1_ANBAU_OST_050",
        label="UE/30/-1_Anbau Ost/050",
        description="""UE/30/-1_Anbau Ost/050""",
    )

    ue_30__1_anbau_ost_050f = VocabularyTerm(
        code="UE_30_-1_ANBAU_OST_050F",
        label="UE/30/-1_Anbau Ost/050F",
        description="""UE/30/-1_Anbau Ost/050F""",
    )

    ue_30__1_anbau_ost_051 = VocabularyTerm(
        code="UE_30_-1_ANBAU_OST_051",
        label="UE/30/-1_Anbau Ost/051",
        description="""UE/30/-1_Anbau Ost/051""",
    )

    ue_30__1_anbau_ost_051b = VocabularyTerm(
        code="UE_30_-1_ANBAU_OST_051B",
        label="UE/30/-1_Anbau Ost/051B",
        description="""UE/30/-1_Anbau Ost/051B""",
    )

    ue_30__1_anbau_ost_052 = VocabularyTerm(
        code="UE_30_-1_ANBAU_OST_052",
        label="UE/30/-1_Anbau Ost/052",
        description="""UE/30/-1_Anbau Ost/052""",
    )

    ue_30__1_anbau_ost_052b = VocabularyTerm(
        code="UE_30_-1_ANBAU_OST_052B",
        label="UE/30/-1_Anbau Ost/052B",
        description="""UE/30/-1_Anbau Ost/052B""",
    )

    ue_30__1_anbau_ost_052f = VocabularyTerm(
        code="UE_30_-1_ANBAU_OST_052F",
        label="UE/30/-1_Anbau Ost/052F",
        description="""UE/30/-1_Anbau Ost/052F""",
    )

    ue_30__1_anbau_ost_052t = VocabularyTerm(
        code="UE_30_-1_ANBAU_OST_052T",
        label="UE/30/-1_Anbau Ost/052T",
        description="""UE/30/-1_Anbau Ost/052T""",
    )

    ue_30__1_anbau_ost_056 = VocabularyTerm(
        code="UE_30_-1_ANBAU_OST_056",
        label="UE/30/-1_Anbau Ost/056",
        description="""UE/30/-1_Anbau Ost/056""",
    )

    ue_30__1_anbau_ost_059 = VocabularyTerm(
        code="UE_30_-1_ANBAU_OST_059",
        label="UE/30/-1_Anbau Ost/059",
        description="""UE/30/-1_Anbau Ost/059""",
    )

    ue_30__1_anbau_west_063 = VocabularyTerm(
        code="UE_30_-1_ANBAU_WEST_063",
        label="UE/30/-1_Anbau West/063",
        description="""UE/30/-1_Anbau West/063""",
    )

    ue_30__1_anbau_west_064 = VocabularyTerm(
        code="UE_30_-1_ANBAU_WEST_064",
        label="UE/30/-1_Anbau West/064",
        description="""UE/30/-1_Anbau West/064""",
    )

    ue_30__1_anbau_west_066 = VocabularyTerm(
        code="UE_30_-1_ANBAU_WEST_066",
        label="UE/30/-1_Anbau West/066",
        description="""UE/30/-1_Anbau West/066""",
    )

    ue_30__1_anbau_west_067 = VocabularyTerm(
        code="UE_30_-1_ANBAU_WEST_067",
        label="UE/30/-1_Anbau West/067",
        description="""UE/30/-1_Anbau West/067""",
    )

    ue_30__1_anbau_west_070f = VocabularyTerm(
        code="UE_30_-1_ANBAU_WEST_070F",
        label="UE/30/-1_Anbau West/070F",
        description="""UE/30/-1_Anbau West/070F""",
    )

    ue_30__1_anbau_west_070t = VocabularyTerm(
        code="UE_30_-1_ANBAU_WEST_070T",
        label="UE/30/-1_Anbau West/070T",
        description="""UE/30/-1_Anbau West/070T""",
    )

    ue_30__1_anbau_west_073 = VocabularyTerm(
        code="UE_30_-1_ANBAU_WEST_073",
        label="UE/30/-1_Anbau West/073",
        description="""UE/30/-1_Anbau West/073""",
    )

    ue_30__1_anbau_west_075 = VocabularyTerm(
        code="UE_30_-1_ANBAU_WEST_075",
        label="UE/30/-1_Anbau West/075",
        description="""UE/30/-1_Anbau West/075""",
    )

    ue_30__1_anbau_west_078 = VocabularyTerm(
        code="UE_30_-1_ANBAU_WEST_078",
        label="UE/30/-1_Anbau West/078",
        description="""UE/30/-1_Anbau West/078""",
    )

    ue_30__1_anbau_west_080 = VocabularyTerm(
        code="UE_30_-1_ANBAU_WEST_080",
        label="UE/30/-1_Anbau West/080",
        description="""UE/30/-1_Anbau West/080""",
    )

    ue_30__1_u1_000f = VocabularyTerm(
        code="UE_30_-1_U1_000F",
        label="UE/30/-1/U1.000F",
        description="""UE/30/-1/U1.000F""",
    )

    ue_30__1_u1_000t = VocabularyTerm(
        code="UE_30_-1_U1_000T",
        label="UE/30/-1/U1.000T",
        description="""UE/30/-1/U1.000T""",
    )

    ue_30__1_u1_002f = VocabularyTerm(
        code="UE_30_-1_U1_002F",
        label="UE/30/-1/U1.002F",
        description="""UE/30/-1/U1.002F""",
    )

    ue_30__1_u1_005a1 = VocabularyTerm(
        code="UE_30_-1_U1_005A1",
        label="UE/30/-1/U1.005A1",
        description="""UE/30/-1/U1.005A1""",
    )

    ue_30__1_u1_005f = VocabularyTerm(
        code="UE_30_-1_U1_005F",
        label="UE/30/-1/U1.005F",
        description="""UE/30/-1/U1.005F""",
    )

    ue_30__1_u1_006f = VocabularyTerm(
        code="UE_30_-1_U1_006F",
        label="UE/30/-1/U1.006F",
        description="""UE/30/-1/U1.006F""",
    )

    ue_30__1_u1_009 = VocabularyTerm(
        code="UE_30_-1_U1_009",
        label="UE/30/-1/U1.009",
        description="""UE/30/-1/U1.009""",
    )

    ue_30__1_u1_011b = VocabularyTerm(
        code="UE_30_-1_U1_011B",
        label="UE/30/-1/U1.011B",
        description="""UE/30/-1/U1.011B""",
    )

    ue_30__1_u1_012 = VocabularyTerm(
        code="UE_30_-1_U1_012",
        label="UE/30/-1/U1.012",
        description="""UE/30/-1/U1.012""",
    )

    ue_30__1_u1_012b = VocabularyTerm(
        code="UE_30_-1_U1_012B",
        label="UE/30/-1/U1.012B",
        description="""UE/30/-1/U1.012B""",
    )

    ue_30__1_u1_012c = VocabularyTerm(
        code="UE_30_-1_U1_012C",
        label="UE/30/-1/U1.012C",
        description="""UE/30/-1/U1.012C""",
    )

    ue_30__1_u1_013 = VocabularyTerm(
        code="UE_30_-1_U1_013",
        label="UE/30/-1/U1.013",
        description="""UE/30/-1/U1.013""",
    )

    ue_30__1_u1_013b = VocabularyTerm(
        code="UE_30_-1_U1_013B",
        label="UE/30/-1/U1.013B",
        description="""UE/30/-1/U1.013B""",
    )

    ue_30__1_u1_014d = VocabularyTerm(
        code="UE_30_-1_U1_014D",
        label="UE/30/-1/U1.014D",
        description="""UE/30/-1/U1.014D""",
    )

    ue_30__1_u1_014h = VocabularyTerm(
        code="UE_30_-1_U1_014H",
        label="UE/30/-1/U1.014H",
        description="""UE/30/-1/U1.014H""",
    )

    ue_30__1_u1_015 = VocabularyTerm(
        code="UE_30_-1_U1_015",
        label="UE/30/-1/U1.015",
        description="""UE/30/-1/U1.015""",
    )

    ue_30__1_u1_015b = VocabularyTerm(
        code="UE_30_-1_U1_015B",
        label="UE/30/-1/U1.015B",
        description="""UE/30/-1/U1.015B""",
    )

    ue_30__1_u1_015c = VocabularyTerm(
        code="UE_30_-1_U1_015C",
        label="UE/30/-1/U1.015C",
        description="""UE/30/-1/U1.015C""",
    )

    ue_30__1_u1_015e = VocabularyTerm(
        code="UE_30_-1_U1_015E",
        label="UE/30/-1/U1.015E",
        description="""UE/30/-1/U1.015E""",
    )

    ue_30__1_u1_016 = VocabularyTerm(
        code="UE_30_-1_U1_016",
        label="UE/30/-1/U1.016",
        description="""UE/30/-1/U1.016""",
    )

    ue_30__1_u1_016b = VocabularyTerm(
        code="UE_30_-1_U1_016B",
        label="UE/30/-1/U1.016B",
        description="""UE/30/-1/U1.016B""",
    )

    ue_30__1_u1_016c = VocabularyTerm(
        code="UE_30_-1_U1_016C",
        label="UE/30/-1/U1.016C",
        description="""UE/30/-1/U1.016C""",
    )

    ue_30__1_u1_016e = VocabularyTerm(
        code="UE_30_-1_U1_016E",
        label="UE/30/-1/U1.016E",
        description="""UE/30/-1/U1.016E""",
    )

    ue_30__1_u1_018 = VocabularyTerm(
        code="UE_30_-1_U1_018",
        label="UE/30/-1/U1.018",
        description="""UE/30/-1/U1.018""",
    )

    ue_30__1_u1_019f = VocabularyTerm(
        code="UE_30_-1_U1_019F",
        label="UE/30/-1/U1.019F",
        description="""UE/30/-1/U1.019F""",
    )

    ue_30__1_u1_020a2 = VocabularyTerm(
        code="UE_30_-1_U1_020A2",
        label="UE/30/-1/U1.020A2",
        description="""UE/30/-1/U1.020A2""",
    )

    ue_30__1_u1_020f = VocabularyTerm(
        code="UE_30_-1_U1_020F",
        label="UE/30/-1/U1.020F",
        description="""UE/30/-1/U1.020F""",
    )

    ue_30__1_u1_021b = VocabularyTerm(
        code="UE_30_-1_U1_021B",
        label="UE/30/-1/U1.021B",
        description="""UE/30/-1/U1.021B""",
    )

    ue_30__1_u1_021c = VocabularyTerm(
        code="UE_30_-1_U1_021C",
        label="UE/30/-1/U1.021C",
        description="""UE/30/-1/U1.021C""",
    )

    ue_30__1_u1_021f = VocabularyTerm(
        code="UE_30_-1_U1_021F",
        label="UE/30/-1/U1.021F",
        description="""UE/30/-1/U1.021F""",
    )

    ue_30__1_u1_021t = VocabularyTerm(
        code="UE_30_-1_U1_021T",
        label="UE/30/-1/U1.021T",
        description="""UE/30/-1/U1.021T""",
    )

    ue_30__1_u1_023 = VocabularyTerm(
        code="UE_30_-1_U1_023",
        label="UE/30/-1/U1.023",
        description="""UE/30/-1/U1.023""",
    )

    ue_30__1_u1_023b = VocabularyTerm(
        code="UE_30_-1_U1_023B",
        label="UE/30/-1/U1.023B",
        description="""UE/30/-1/U1.023B""",
    )

    ue_30__1_u1_023f = VocabularyTerm(
        code="UE_30_-1_U1_023F",
        label="UE/30/-1/U1.023F",
        description="""UE/30/-1/U1.023F""",
    )

    ue_30__1_u1_026b = VocabularyTerm(
        code="UE_30_-1_U1_026B",
        label="UE/30/-1/U1.026B",
        description="""UE/30/-1/U1.026B""",
    )

    ue_30__1_u1_026f = VocabularyTerm(
        code="UE_30_-1_U1_026F",
        label="UE/30/-1/U1.026F",
        description="""UE/30/-1/U1.026F""",
    )

    ue_30__1_u1_027 = VocabularyTerm(
        code="UE_30_-1_U1_027",
        label="UE/30/-1/U1.027",
        description="""UE/30/-1/U1.027""",
    )

    ue_30__1_u1_027b = VocabularyTerm(
        code="UE_30_-1_U1_027B",
        label="UE/30/-1/U1.027B",
        description="""UE/30/-1/U1.027B""",
    )

    ue_30__1_u1_028 = VocabularyTerm(
        code="UE_30_-1_U1_028",
        label="UE/30/-1/U1.028",
        description="""UE/30/-1/U1.028""",
    )

    ue_30__1_u1_029 = VocabularyTerm(
        code="UE_30_-1_U1_029",
        label="UE/30/-1/U1.029",
        description="""UE/30/-1/U1.029""",
    )

    ue_30__1_u1_029b = VocabularyTerm(
        code="UE_30_-1_U1_029B",
        label="UE/30/-1/U1.029B",
        description="""UE/30/-1/U1.029B""",
    )

    ue_30__1_u1_030b = VocabularyTerm(
        code="UE_30_-1_U1_030B",
        label="UE/30/-1/U1.030B",
        description="""UE/30/-1/U1.030B""",
    )

    ue_30__1_u1_030f = VocabularyTerm(
        code="UE_30_-1_U1_030F",
        label="UE/30/-1/U1.030F",
        description="""UE/30/-1/U1.030F""",
    )

    ue_30__1_u1_030t = VocabularyTerm(
        code="UE_30_-1_U1_030T",
        label="UE/30/-1/U1.030T",
        description="""UE/30/-1/U1.030T""",
    )

    ue_30__1_u1_031 = VocabularyTerm(
        code="UE_30_-1_U1_031",
        label="UE/30/-1/U1.031",
        description="""UE/30/-1/U1.031""",
    )

    ue_30__1_u1_032 = VocabularyTerm(
        code="UE_30_-1_U1_032",
        label="UE/30/-1/U1.032",
        description="""UE/30/-1/U1.032""",
    )

    ue_30__1_u1_034 = VocabularyTerm(
        code="UE_30_-1_U1_034",
        label="UE/30/-1/U1.034",
        description="""UE/30/-1/U1.034""",
    )

    ue_30__1_u1_036 = VocabularyTerm(
        code="UE_30_-1_U1_036",
        label="UE/30/-1/U1.036",
        description="""UE/30/-1/U1.036""",
    )

    ue_30__1_u1_042 = VocabularyTerm(
        code="UE_30_-1_U1_042",
        label="UE/30/-1/U1.042",
        description="""UE/30/-1/U1.042""",
    )

    ue_30__1_u1_043 = VocabularyTerm(
        code="UE_30_-1_U1_043",
        label="UE/30/-1/U1.043",
        description="""UE/30/-1/U1.043""",
    )

    ue_30__1_u1_044 = VocabularyTerm(
        code="UE_30_-1_U1_044",
        label="UE/30/-1/U1.044",
        description="""UE/30/-1/U1.044""",
    )

    ue_30__1_u1_045 = VocabularyTerm(
        code="UE_30_-1_U1_045",
        label="UE/30/-1/U1.045",
        description="""UE/30/-1/U1.045""",
    )

    ue_30__1_u1_046 = VocabularyTerm(
        code="UE_30_-1_U1_046",
        label="UE/30/-1/U1.046",
        description="""UE/30/-1/U1.046""",
    )

    ue_30__1_u1_047 = VocabularyTerm(
        code="UE_30_-1_U1_047",
        label="UE/30/-1/U1.047",
        description="""UE/30/-1/U1.047""",
    )

    ue_30__1_u1_048 = VocabularyTerm(
        code="UE_30_-1_U1_048",
        label="UE/30/-1/U1.048",
        description="""UE/30/-1/U1.048""",
    )

    ue_30__1_u1_049 = VocabularyTerm(
        code="UE_30_-1_U1_049",
        label="UE/30/-1/U1.049",
        description="""UE/30/-1/U1.049""",
    )

    ue_30__1_u1_049f = VocabularyTerm(
        code="UE_30_-1_U1_049F",
        label="UE/30/-1/U1.049F",
        description="""UE/30/-1/U1.049F""",
    )

    ue_30__1_u1_049t = VocabularyTerm(
        code="UE_30_-1_U1_049T",
        label="UE/30/-1/U1.049T",
        description="""UE/30/-1/U1.049T""",
    )

    ue_30__1_u1_050 = VocabularyTerm(
        code="UE_30_-1_U1_050",
        label="UE/30/-1/U1.050",
        description="""UE/30/-1/U1.050""",
    )

    ue_30__1_u1_050f = VocabularyTerm(
        code="UE_30_-1_U1_050F",
        label="UE/30/-1/U1.050F",
        description="""UE/30/-1/U1.050F""",
    )

    ue_30__1_u1_050fs01 = VocabularyTerm(
        code="UE_30_-1_U1_050FS01",
        label="UE/30/-1/U1.050FS01",
        description="""UE/30/-1/U1.050FS01""",
    )

    ue_30__1_u1_050fs02 = VocabularyTerm(
        code="UE_30_-1_U1_050FS02",
        label="UE/30/-1/U1.050FS02",
        description="""UE/30/-1/U1.050FS02""",
    )

    ue_30__1_u1_050t = VocabularyTerm(
        code="UE_30_-1_U1_050T",
        label="UE/30/-1/U1.050T",
        description="""UE/30/-1/U1.050T""",
    )

    ue_30__1_u1_054t = VocabularyTerm(
        code="UE_30_-1_U1_054T",
        label="UE/30/-1/U1.054T",
        description="""UE/30/-1/U1.054T""",
    )

    ue_30__1_u1_055 = VocabularyTerm(
        code="UE_30_-1_U1_055",
        label="UE/30/-1/U1.055",
        description="""UE/30/-1/U1.055""",
    )

    ue_30__1_u1_056 = VocabularyTerm(
        code="UE_30_-1_U1_056",
        label="UE/30/-1/U1.056",
        description="""UE/30/-1/U1.056""",
    )

    ue_30__1_u1_057 = VocabularyTerm(
        code="UE_30_-1_U1_057",
        label="UE/30/-1/U1.057",
        description="""UE/30/-1/U1.057""",
    )

    ue_30__1_u1_058 = VocabularyTerm(
        code="UE_30_-1_U1_058",
        label="UE/30/-1/U1.058",
        description="""UE/30/-1/U1.058""",
    )

    ue_30__1_u1_059 = VocabularyTerm(
        code="UE_30_-1_U1_059",
        label="UE/30/-1/U1.059",
        description="""UE/30/-1/U1.059""",
    )

    ue_30__1_u1_060 = VocabularyTerm(
        code="UE_30_-1_U1_060",
        label="UE/30/-1/U1.060",
        description="""UE/30/-1/U1.060""",
    )

    ue_30__1_u1_061 = VocabularyTerm(
        code="UE_30_-1_U1_061",
        label="UE/30/-1/U1.061",
        description="""UE/30/-1/U1.061""",
    )

    ue_30__1_u1_062 = VocabularyTerm(
        code="UE_30_-1_U1_062",
        label="UE/30/-1/U1.062",
        description="""UE/30/-1/U1.062""",
    )

    ue_30__1_u1_s16 = VocabularyTerm(
        code="UE_30_-1_U1_S16",
        label="UE/30/-1/U1.S16",
        description="""UE/30/-1/U1.S16""",
    )

    ue_30__2_u2_053 = VocabularyTerm(
        code="UE_30_-2_U2_053",
        label="UE/30/-2/U2.053",
        description="""UE/30/-2/U2.053""",
    )

    ue_30__2_u2_054 = VocabularyTerm(
        code="UE_30_-2_U2_054",
        label="UE/30/-2/U2.054",
        description="""UE/30/-2/U2.054""",
    )

    ue_30__2_u2_054t = VocabularyTerm(
        code="UE_30_-2_U2_054T",
        label="UE/30/-2/U2.054T",
        description="""UE/30/-2/U2.054T""",
    )

    ue_30__2_u2_055 = VocabularyTerm(
        code="UE_30_-2_U2_055",
        label="UE/30/-2/U2.055",
        description="""UE/30/-2/U2.055""",
    )

    ue_40_0_100 = VocabularyTerm(
        code="UE_40_0_100",
        label="UE/40/0/100",
        description="""UE/40/0/100""",
    )

    ue_40_0_101b = VocabularyTerm(
        code="UE_40_0_101B",
        label="UE/40/0/101B",
        description="""UE/40/0/101B""",
    )

    ue_40_0_101d = VocabularyTerm(
        code="UE_40_0_101D",
        label="UE/40/0/101D",
        description="""UE/40/0/101D""",
    )

    ue_40_0_101wc = VocabularyTerm(
        code="UE_40_0_101WC",
        label="UE/40/0/101WC",
        description="""UE/40/0/101WC""",
    )

    ue_40_0_102 = VocabularyTerm(
        code="UE_40_0_102",
        label="UE/40/0/102",
        description="""UE/40/0/102""",
    )

    ue_40_0_103f = VocabularyTerm(
        code="UE_40_0_103F",
        label="UE/40/0/103F",
        description="""UE/40/0/103F""",
    )

    ue_40_0_103t = VocabularyTerm(
        code="UE_40_0_103T",
        label="UE/40/0/103T",
        description="""UE/40/0/103T""",
    )

    ue_40_0_104 = VocabularyTerm(
        code="UE_40_0_104",
        label="UE/40/0/104",
        description="""UE/40/0/104""",
    )

    ue_40_0_105 = VocabularyTerm(
        code="UE_40_0_105",
        label="UE/40/0/105",
        description="""UE/40/0/105""",
    )

    ue_40_0_106 = VocabularyTerm(
        code="UE_40_0_106",
        label="UE/40/0/106",
        description="""UE/40/0/106""",
    )

    ue_40_0_108 = VocabularyTerm(
        code="UE_40_0_108",
        label="UE/40/0/108",
        description="""UE/40/0/108""",
    )

    ue_40_0_109 = VocabularyTerm(
        code="UE_40_0_109",
        label="UE/40/0/109",
        description="""UE/40/0/109""",
    )

    ue_40_0_110 = VocabularyTerm(
        code="UE_40_0_110",
        label="UE/40/0/110",
        description="""UE/40/0/110""",
    )

    ue_40_0_111 = VocabularyTerm(
        code="UE_40_0_111",
        label="UE/40/0/111",
        description="""UE/40/0/111""",
    )

    ue_40_0_112 = VocabularyTerm(
        code="UE_40_0_112",
        label="UE/40/0/112",
        description="""UE/40/0/112""",
    )

    ue_40_0_113 = VocabularyTerm(
        code="UE_40_0_113",
        label="UE/40/0/113",
        description="""UE/40/0/113""",
    )

    ue_40_0_114 = VocabularyTerm(
        code="UE_40_0_114",
        label="UE/40/0/114",
        description="""UE/40/0/114""",
    )

    ue_40_0_116 = VocabularyTerm(
        code="UE_40_0_116",
        label="UE/40/0/116",
        description="""UE/40/0/116""",
    )

    ue_40_0_118 = VocabularyTerm(
        code="UE_40_0_118",
        label="UE/40/0/118",
        description="""UE/40/0/118""",
    )

    ue_40_0_118f = VocabularyTerm(
        code="UE_40_0_118F",
        label="UE/40/0/118F",
        description="""UE/40/0/118F""",
    )

    ue_40_0_119 = VocabularyTerm(
        code="UE_40_0_119",
        label="UE/40/0/119",
        description="""UE/40/0/119""",
    )

    ue_40_0_120 = VocabularyTerm(
        code="UE_40_0_120",
        label="UE/40/0/120",
        description="""UE/40/0/120""",
    )

    ue_40_0_121 = VocabularyTerm(
        code="UE_40_0_121",
        label="UE/40/0/121",
        description="""UE/40/0/121""",
    )

    ue_40_0_122 = VocabularyTerm(
        code="UE_40_0_122",
        label="UE/40/0/122",
        description="""UE/40/0/122""",
    )

    ue_40_0_123 = VocabularyTerm(
        code="UE_40_0_123",
        label="UE/40/0/123",
        description="""UE/40/0/123""",
    )

    ue_40_0_124 = VocabularyTerm(
        code="UE_40_0_124",
        label="UE/40/0/124",
        description="""UE/40/0/124""",
    )

    ue_40_0_125 = VocabularyTerm(
        code="UE_40_0_125",
        label="UE/40/0/125",
        description="""UE/40/0/125""",
    )

    ue_40_0_126 = VocabularyTerm(
        code="UE_40_0_126",
        label="UE/40/0/126",
        description="""UE/40/0/126""",
    )

    ue_40_0_128 = VocabularyTerm(
        code="UE_40_0_128",
        label="UE/40/0/128",
        description="""UE/40/0/128""",
    )

    ue_40_0_129b = VocabularyTerm(
        code="UE_40_0_129B",
        label="UE/40/0/129B",
        description="""UE/40/0/129B""",
    )

    ue_40_0_129f = VocabularyTerm(
        code="UE_40_0_129F",
        label="UE/40/0/129F",
        description="""UE/40/0/129F""",
    )

    ue_40_0_129t = VocabularyTerm(
        code="UE_40_0_129T",
        label="UE/40/0/129T",
        description="""UE/40/0/129T""",
    )

    ue_40_0_131 = VocabularyTerm(
        code="UE_40_0_131",
        label="UE/40/0/131",
        description="""UE/40/0/131""",
    )

    ue_40_0_131h = VocabularyTerm(
        code="UE_40_0_131H",
        label="UE/40/0/131H",
        description="""UE/40/0/131H""",
    )

    ue_40_0_a1 = VocabularyTerm(
        code="UE_40_0_A1",
        label="UE/40/0/A1",
        description="""UE/40/0/A1""",
    )

    ue_40_0_a2 = VocabularyTerm(
        code="UE_40_0_A2",
        label="UE/40/0/A2",
        description="""UE/40/0/A2""",
    )

    ue_40_1_200 = VocabularyTerm(
        code="UE_40_1_200",
        label="UE/40/1/200",
        description="""UE/40/1/200""",
    )

    ue_40_1_201 = VocabularyTerm(
        code="UE_40_1_201",
        label="UE/40/1/201",
        description="""UE/40/1/201""",
    )

    ue_40_1_201h = VocabularyTerm(
        code="UE_40_1_201H",
        label="UE/40/1/201H",
        description="""UE/40/1/201H""",
    )

    ue_40_1_202 = VocabularyTerm(
        code="UE_40_1_202",
        label="UE/40/1/202",
        description="""UE/40/1/202""",
    )

    ue_40_1_203 = VocabularyTerm(
        code="UE_40_1_203",
        label="UE/40/1/203",
        description="""UE/40/1/203""",
    )

    ue_40_1_203d = VocabularyTerm(
        code="UE_40_1_203D",
        label="UE/40/1/203D",
        description="""UE/40/1/203D""",
    )

    ue_40_1_203f = VocabularyTerm(
        code="UE_40_1_203F",
        label="UE/40/1/203F",
        description="""UE/40/1/203F""",
    )

    ue_40_1_203t = VocabularyTerm(
        code="UE_40_1_203T",
        label="UE/40/1/203T",
        description="""UE/40/1/203T""",
    )

    ue_40_1_204 = VocabularyTerm(
        code="UE_40_1_204",
        label="UE/40/1/204",
        description="""UE/40/1/204""",
    )

    ue_40_1_205 = VocabularyTerm(
        code="UE_40_1_205",
        label="UE/40/1/205",
        description="""UE/40/1/205""",
    )

    ue_40_1_206 = VocabularyTerm(
        code="UE_40_1_206",
        label="UE/40/1/206",
        description="""UE/40/1/206""",
    )

    ue_40_1_207 = VocabularyTerm(
        code="UE_40_1_207",
        label="UE/40/1/207",
        description="""UE/40/1/207""",
    )

    ue_40_1_208 = VocabularyTerm(
        code="UE_40_1_208",
        label="UE/40/1/208",
        description="""UE/40/1/208""",
    )

    ue_40_1_209 = VocabularyTerm(
        code="UE_40_1_209",
        label="UE/40/1/209",
        description="""UE/40/1/209""",
    )

    ue_40_1_210 = VocabularyTerm(
        code="UE_40_1_210",
        label="UE/40/1/210",
        description="""UE/40/1/210""",
    )

    ue_40_1_212 = VocabularyTerm(
        code="UE_40_1_212",
        label="UE/40/1/212",
        description="""UE/40/1/212""",
    )

    ue_40_1_213 = VocabularyTerm(
        code="UE_40_1_213",
        label="UE/40/1/213",
        description="""UE/40/1/213""",
    )

    ue_40_1_214 = VocabularyTerm(
        code="UE_40_1_214",
        label="UE/40/1/214",
        description="""UE/40/1/214""",
    )

    ue_40_1_216 = VocabularyTerm(
        code="UE_40_1_216",
        label="UE/40/1/216",
        description="""UE/40/1/216""",
    )

    ue_40_1_217 = VocabularyTerm(
        code="UE_40_1_217",
        label="UE/40/1/217",
        description="""UE/40/1/217""",
    )

    ue_40_1_218 = VocabularyTerm(
        code="UE_40_1_218",
        label="UE/40/1/218",
        description="""UE/40/1/218""",
    )

    ue_40_1_218f = VocabularyTerm(
        code="UE_40_1_218F",
        label="UE/40/1/218F",
        description="""UE/40/1/218F""",
    )

    ue_40_1_219 = VocabularyTerm(
        code="UE_40_1_219",
        label="UE/40/1/219",
        description="""UE/40/1/219""",
    )

    ue_40_1_220 = VocabularyTerm(
        code="UE_40_1_220",
        label="UE/40/1/220",
        description="""UE/40/1/220""",
    )

    ue_40_1_222 = VocabularyTerm(
        code="UE_40_1_222",
        label="UE/40/1/222",
        description="""UE/40/1/222""",
    )

    ue_40_1_223 = VocabularyTerm(
        code="UE_40_1_223",
        label="UE/40/1/223",
        description="""UE/40/1/223""",
    )

    ue_40_1_226 = VocabularyTerm(
        code="UE_40_1_226",
        label="UE/40/1/226",
        description="""UE/40/1/226""",
    )

    ue_40_1_228 = VocabularyTerm(
        code="UE_40_1_228",
        label="UE/40/1/228",
        description="""UE/40/1/228""",
    )

    ue_40_1_229b = VocabularyTerm(
        code="UE_40_1_229B",
        label="UE/40/1/229B",
        description="""UE/40/1/229B""",
    )

    ue_40_1_229f = VocabularyTerm(
        code="UE_40_1_229F",
        label="UE/40/1/229F",
        description="""UE/40/1/229F""",
    )

    ue_40_1_229t = VocabularyTerm(
        code="UE_40_1_229T",
        label="UE/40/1/229T",
        description="""UE/40/1/229T""",
    )

    ue_40_1_230 = VocabularyTerm(
        code="UE_40_1_230",
        label="UE/40/1/230",
        description="""UE/40/1/230""",
    )

    ue_40_1_231 = VocabularyTerm(
        code="UE_40_1_231",
        label="UE/40/1/231",
        description="""UE/40/1/231""",
    )

    ue_40_1_231h = VocabularyTerm(
        code="UE_40_1_231H",
        label="UE/40/1/231H",
        description="""UE/40/1/231H""",
    )

    ue_40_1_a1 = VocabularyTerm(
        code="UE_40_1_A1",
        label="UE/40/1/A1",
        description="""UE/40/1/A1""",
    )

    ue_40_1_a2 = VocabularyTerm(
        code="UE_40_1_A2",
        label="UE/40/1/A2",
        description="""UE/40/1/A2""",
    )

    ue_40_2_300 = VocabularyTerm(
        code="UE_40_2_300",
        label="UE/40/2/300",
        description="""UE/40/2/300""",
    )

    ue_40_2_301 = VocabularyTerm(
        code="UE_40_2_301",
        label="UE/40/2/301",
        description="""UE/40/2/301""",
    )

    ue_40_2_301d = VocabularyTerm(
        code="UE_40_2_301D",
        label="UE/40/2/301D",
        description="""UE/40/2/301D""",
    )

    ue_40_2_302 = VocabularyTerm(
        code="UE_40_2_302",
        label="UE/40/2/302",
        description="""UE/40/2/302""",
    )

    ue_40_2_303 = VocabularyTerm(
        code="UE_40_2_303",
        label="UE/40/2/303",
        description="""UE/40/2/303""",
    )

    ue_40_2_303d = VocabularyTerm(
        code="UE_40_2_303D",
        label="UE/40/2/303D",
        description="""UE/40/2/303D""",
    )

    ue_40_2_303f = VocabularyTerm(
        code="UE_40_2_303F",
        label="UE/40/2/303F",
        description="""UE/40/2/303F""",
    )

    ue_40_2_303t = VocabularyTerm(
        code="UE_40_2_303T",
        label="UE/40/2/303T",
        description="""UE/40/2/303T""",
    )

    ue_40_2_304 = VocabularyTerm(
        code="UE_40_2_304",
        label="UE/40/2/304",
        description="""UE/40/2/304""",
    )

    ue_40_2_305 = VocabularyTerm(
        code="UE_40_2_305",
        label="UE/40/2/305",
        description="""UE/40/2/305""",
    )

    ue_40_2_306 = VocabularyTerm(
        code="UE_40_2_306",
        label="UE/40/2/306",
        description="""UE/40/2/306""",
    )

    ue_40_2_308 = VocabularyTerm(
        code="UE_40_2_308",
        label="UE/40/2/308",
        description="""UE/40/2/308""",
    )

    ue_40_2_309 = VocabularyTerm(
        code="UE_40_2_309",
        label="UE/40/2/309",
        description="""UE/40/2/309""",
    )

    ue_40_2_312 = VocabularyTerm(
        code="UE_40_2_312",
        label="UE/40/2/312",
        description="""UE/40/2/312""",
    )

    ue_40_2_313 = VocabularyTerm(
        code="UE_40_2_313",
        label="UE/40/2/313",
        description="""UE/40/2/313""",
    )

    ue_40_2_314 = VocabularyTerm(
        code="UE_40_2_314",
        label="UE/40/2/314",
        description="""UE/40/2/314""",
    )

    ue_40_2_316 = VocabularyTerm(
        code="UE_40_2_316",
        label="UE/40/2/316",
        description="""UE/40/2/316""",
    )

    ue_40_2_317 = VocabularyTerm(
        code="UE_40_2_317",
        label="UE/40/2/317",
        description="""UE/40/2/317""",
    )

    ue_40_2_318 = VocabularyTerm(
        code="UE_40_2_318",
        label="UE/40/2/318",
        description="""UE/40/2/318""",
    )

    ue_40_2_318f = VocabularyTerm(
        code="UE_40_2_318F",
        label="UE/40/2/318F",
        description="""UE/40/2/318F""",
    )

    ue_40_2_319 = VocabularyTerm(
        code="UE_40_2_319",
        label="UE/40/2/319",
        description="""UE/40/2/319""",
    )

    ue_40_2_320 = VocabularyTerm(
        code="UE_40_2_320",
        label="UE/40/2/320",
        description="""UE/40/2/320""",
    )

    ue_40_2_322 = VocabularyTerm(
        code="UE_40_2_322",
        label="UE/40/2/322",
        description="""UE/40/2/322""",
    )

    ue_40_2_323 = VocabularyTerm(
        code="UE_40_2_323",
        label="UE/40/2/323",
        description="""UE/40/2/323""",
    )

    ue_40_2_324 = VocabularyTerm(
        code="UE_40_2_324",
        label="UE/40/2/324",
        description="""UE/40/2/324""",
    )

    ue_40_2_326 = VocabularyTerm(
        code="UE_40_2_326",
        label="UE/40/2/326",
        description="""UE/40/2/326""",
    )

    ue_40_2_327 = VocabularyTerm(
        code="UE_40_2_327",
        label="UE/40/2/327",
        description="""UE/40/2/327""",
    )

    ue_40_2_328 = VocabularyTerm(
        code="UE_40_2_328",
        label="UE/40/2/328",
        description="""UE/40/2/328""",
    )

    ue_40_2_329b = VocabularyTerm(
        code="UE_40_2_329B",
        label="UE/40/2/329B",
        description="""UE/40/2/329B""",
    )

    ue_40_2_329f = VocabularyTerm(
        code="UE_40_2_329F",
        label="UE/40/2/329F",
        description="""UE/40/2/329F""",
    )

    ue_40_2_329t = VocabularyTerm(
        code="UE_40_2_329T",
        label="UE/40/2/329T",
        description="""UE/40/2/329T""",
    )

    ue_40_2_330 = VocabularyTerm(
        code="UE_40_2_330",
        label="UE/40/2/330",
        description="""UE/40/2/330""",
    )

    ue_40_2_331 = VocabularyTerm(
        code="UE_40_2_331",
        label="UE/40/2/331",
        description="""UE/40/2/331""",
    )

    ue_40_2_331h = VocabularyTerm(
        code="UE_40_2_331H",
        label="UE/40/2/331H",
        description="""UE/40/2/331H""",
    )

    ue_40_2_a1 = VocabularyTerm(
        code="UE_40_2_A1",
        label="UE/40/2/A1",
        description="""UE/40/2/A1""",
    )

    ue_40_2_a2 = VocabularyTerm(
        code="UE_40_2_A2",
        label="UE/40/2/A2",
        description="""UE/40/2/A2""",
    )

    ue_40_3_400 = VocabularyTerm(
        code="UE_40_3_400",
        label="UE/40/3/400",
        description="""UE/40/3/400""",
    )

    ue_40_3_401b = VocabularyTerm(
        code="UE_40_3_401B",
        label="UE/40/3/401B",
        description="""UE/40/3/401B""",
    )

    ue_40_3_401d = VocabularyTerm(
        code="UE_40_3_401D",
        label="UE/40/3/401D",
        description="""UE/40/3/401D""",
    )

    ue_40_3_401t = VocabularyTerm(
        code="UE_40_3_401T",
        label="UE/40/3/401T",
        description="""UE/40/3/401T""",
    )

    ue_40_3_402 = VocabularyTerm(
        code="UE_40_3_402",
        label="UE/40/3/402",
        description="""UE/40/3/402""",
    )

    ue_40_3_403f = VocabularyTerm(
        code="UE_40_3_403F",
        label="UE/40/3/403F",
        description="""UE/40/3/403F""",
    )

    ue_40_3_403t = VocabularyTerm(
        code="UE_40_3_403T",
        label="UE/40/3/403T",
        description="""UE/40/3/403T""",
    )

    ue_40_3_404 = VocabularyTerm(
        code="UE_40_3_404",
        label="UE/40/3/404",
        description="""UE/40/3/404""",
    )

    ue_40_3_405 = VocabularyTerm(
        code="UE_40_3_405",
        label="UE/40/3/405",
        description="""UE/40/3/405""",
    )

    ue_40_3_406 = VocabularyTerm(
        code="UE_40_3_406",
        label="UE/40/3/406",
        description="""UE/40/3/406""",
    )

    ue_40_3_408 = VocabularyTerm(
        code="UE_40_3_408",
        label="UE/40/3/408",
        description="""UE/40/3/408""",
    )

    ue_40_3_409 = VocabularyTerm(
        code="UE_40_3_409",
        label="UE/40/3/409",
        description="""UE/40/3/409""",
    )

    ue_40_3_410 = VocabularyTerm(
        code="UE_40_3_410",
        label="UE/40/3/410",
        description="""UE/40/3/410""",
    )

    ue_40_3_411 = VocabularyTerm(
        code="UE_40_3_411",
        label="UE/40/3/411",
        description="""UE/40/3/411""",
    )

    ue_40_3_412 = VocabularyTerm(
        code="UE_40_3_412",
        label="UE/40/3/412",
        description="""UE/40/3/412""",
    )

    ue_40_3_413 = VocabularyTerm(
        code="UE_40_3_413",
        label="UE/40/3/413",
        description="""UE/40/3/413""",
    )

    ue_40_3_416 = VocabularyTerm(
        code="UE_40_3_416",
        label="UE/40/3/416",
        description="""UE/40/3/416""",
    )

    ue_40_3_417 = VocabularyTerm(
        code="UE_40_3_417",
        label="UE/40/3/417",
        description="""UE/40/3/417""",
    )

    ue_40_3_418 = VocabularyTerm(
        code="UE_40_3_418",
        label="UE/40/3/418",
        description="""UE/40/3/418""",
    )

    ue_40_3_418f = VocabularyTerm(
        code="UE_40_3_418F",
        label="UE/40/3/418F",
        description="""UE/40/3/418F""",
    )

    ue_40_3_420 = VocabularyTerm(
        code="UE_40_3_420",
        label="UE/40/3/420",
        description="""UE/40/3/420""",
    )

    ue_40_3_421 = VocabularyTerm(
        code="UE_40_3_421",
        label="UE/40/3/421",
        description="""UE/40/3/421""",
    )

    ue_40_3_422 = VocabularyTerm(
        code="UE_40_3_422",
        label="UE/40/3/422",
        description="""UE/40/3/422""",
    )

    ue_40_3_423 = VocabularyTerm(
        code="UE_40_3_423",
        label="UE/40/3/423",
        description="""UE/40/3/423""",
    )

    ue_40_3_424 = VocabularyTerm(
        code="UE_40_3_424",
        label="UE/40/3/424",
        description="""UE/40/3/424""",
    )

    ue_40_3_425 = VocabularyTerm(
        code="UE_40_3_425",
        label="UE/40/3/425",
        description="""UE/40/3/425""",
    )

    ue_40_3_426 = VocabularyTerm(
        code="UE_40_3_426",
        label="UE/40/3/426",
        description="""UE/40/3/426""",
    )

    ue_40_3_428 = VocabularyTerm(
        code="UE_40_3_428",
        label="UE/40/3/428",
        description="""UE/40/3/428""",
    )

    ue_40_3_429b = VocabularyTerm(
        code="UE_40_3_429B",
        label="UE/40/3/429B",
        description="""UE/40/3/429B""",
    )

    ue_40_3_429f = VocabularyTerm(
        code="UE_40_3_429F",
        label="UE/40/3/429F",
        description="""UE/40/3/429F""",
    )

    ue_40_3_429t = VocabularyTerm(
        code="UE_40_3_429T",
        label="UE/40/3/429T",
        description="""UE/40/3/429T""",
    )

    ue_40_3_430 = VocabularyTerm(
        code="UE_40_3_430",
        label="UE/40/3/430",
        description="""UE/40/3/430""",
    )

    ue_40_3_431 = VocabularyTerm(
        code="UE_40_3_431",
        label="UE/40/3/431",
        description="""UE/40/3/431""",
    )

    ue_40_3_431h = VocabularyTerm(
        code="UE_40_3_431H",
        label="UE/40/3/431H",
        description="""UE/40/3/431H""",
    )

    ue_40_3_a1 = VocabularyTerm(
        code="UE_40_3_A1",
        label="UE/40/3/A1",
        description="""UE/40/3/A1""",
    )

    ue_40_3_a2 = VocabularyTerm(
        code="UE_40_3_A2",
        label="UE/40/3/A2",
        description="""UE/40/3/A2""",
    )

    ue_40_4_500b = VocabularyTerm(
        code="UE_40_4_500B",
        label="UE/40/4/500B",
        description="""UE/40/4/500B""",
    )

    ue_40_4_501f = VocabularyTerm(
        code="UE_40_4_501F",
        label="UE/40/4/501F",
        description="""UE/40/4/501F""",
    )

    ue_40_4_501t = VocabularyTerm(
        code="UE_40_4_501T",
        label="UE/40/4/501T",
        description="""UE/40/4/501T""",
    )

    ue_40_4_502b = VocabularyTerm(
        code="UE_40_4_502B",
        label="UE/40/4/502B",
        description="""UE/40/4/502B""",
    )

    ue_40_4_503f = VocabularyTerm(
        code="UE_40_4_503F",
        label="UE/40/4/503F",
        description="""UE/40/4/503F""",
    )

    ue_40_4_518 = VocabularyTerm(
        code="UE_40_4_518",
        label="UE/40/4/518",
        description="""UE/40/4/518""",
    )

    ue_40_4_527b = VocabularyTerm(
        code="UE_40_4_527B",
        label="UE/40/4/527B",
        description="""UE/40/4/527B""",
    )

    ue_40__1_001 = VocabularyTerm(
        code="UE_40_-1_001",
        label="UE/40/-1/001",
        description="""UE/40/-1/001""",
    )

    ue_40__1_002 = VocabularyTerm(
        code="UE_40_-1_002",
        label="UE/40/-1/002",
        description="""UE/40/-1/002""",
    )

    ue_40__1_002f = VocabularyTerm(
        code="UE_40_-1_002F",
        label="UE/40/-1/002F",
        description="""UE/40/-1/002F""",
    )

    ue_40__1_003f = VocabularyTerm(
        code="UE_40_-1_003F",
        label="UE/40/-1/003F",
        description="""UE/40/-1/003F""",
    )

    ue_40__1_003t = VocabularyTerm(
        code="UE_40_-1_003T",
        label="UE/40/-1/003T",
        description="""UE/40/-1/003T""",
    )

    ue_40__1_004 = VocabularyTerm(
        code="UE_40_-1_004",
        label="UE/40/-1/004",
        description="""UE/40/-1/004""",
    )

    ue_40__1_005 = VocabularyTerm(
        code="UE_40_-1_005",
        label="UE/40/-1/005",
        description="""UE/40/-1/005""",
    )

    ue_40__1_006 = VocabularyTerm(
        code="UE_40_-1_006",
        label="UE/40/-1/006",
        description="""UE/40/-1/006""",
    )

    ue_40__1_007 = VocabularyTerm(
        code="UE_40_-1_007",
        label="UE/40/-1/007",
        description="""UE/40/-1/007""",
    )

    ue_40__1_008 = VocabularyTerm(
        code="UE_40_-1_008",
        label="UE/40/-1/008",
        description="""UE/40/-1/008""",
    )

    ue_40__1_010 = VocabularyTerm(
        code="UE_40_-1_010",
        label="UE/40/-1/010",
        description="""UE/40/-1/010""",
    )

    ue_40__1_011 = VocabularyTerm(
        code="UE_40_-1_011",
        label="UE/40/-1/011",
        description="""UE/40/-1/011""",
    )

    ue_40__1_012 = VocabularyTerm(
        code="UE_40_-1_012",
        label="UE/40/-1/012",
        description="""UE/40/-1/012""",
    )

    ue_40__1_013 = VocabularyTerm(
        code="UE_40_-1_013",
        label="UE/40/-1/013",
        description="""UE/40/-1/013""",
    )

    ue_40__1_016 = VocabularyTerm(
        code="UE_40_-1_016",
        label="UE/40/-1/016",
        description="""UE/40/-1/016""",
    )

    ue_40__1_017t = VocabularyTerm(
        code="UE_40_-1_017T",
        label="UE/40/-1/017T",
        description="""UE/40/-1/017T""",
    )

    ue_40__1_018f = VocabularyTerm(
        code="UE_40_-1_018F",
        label="UE/40/-1/018F",
        description="""UE/40/-1/018F""",
    )

    ue_40__1_020 = VocabularyTerm(
        code="UE_40_-1_020",
        label="UE/40/-1/020",
        description="""UE/40/-1/020""",
    )

    ue_40__1_023 = VocabularyTerm(
        code="UE_40_-1_023",
        label="UE/40/-1/023",
        description="""UE/40/-1/023""",
    )

    ue_40__1_024 = VocabularyTerm(
        code="UE_40_-1_024",
        label="UE/40/-1/024",
        description="""UE/40/-1/024""",
    )

    ue_40__1_027 = VocabularyTerm(
        code="UE_40_-1_027",
        label="UE/40/-1/027",
        description="""UE/40/-1/027""",
    )

    ue_40__1_028f = VocabularyTerm(
        code="UE_40_-1_028F",
        label="UE/40/-1/028F",
        description="""UE/40/-1/028F""",
    )

    ue_40__1_029 = VocabularyTerm(
        code="UE_40_-1_029",
        label="UE/40/-1/029",
        description="""UE/40/-1/029""",
    )

    ue_40__1_029f = VocabularyTerm(
        code="UE_40_-1_029F",
        label="UE/40/-1/029F",
        description="""UE/40/-1/029F""",
    )

    ue_40__1_029t = VocabularyTerm(
        code="UE_40_-1_029T",
        label="UE/40/-1/029T",
        description="""UE/40/-1/029T""",
    )

    ue_40__1_030 = VocabularyTerm(
        code="UE_40_-1_030",
        label="UE/40/-1/030",
        description="""UE/40/-1/030""",
    )

    ue_40__1_031h = VocabularyTerm(
        code="UE_40_-1_031H",
        label="UE/40/-1/031H",
        description="""UE/40/-1/031H""",
    )

    ue_40__1_a1 = VocabularyTerm(
        code="UE_40_-1_A1",
        label="UE/40/-1/A1",
        description="""UE/40/-1/A1""",
    )

    ue_40__1_a2 = VocabularyTerm(
        code="UE_40_-1_A2",
        label="UE/40/-1/A2",
        description="""UE/40/-1/A2""",
    )

    ue_41_0_100 = VocabularyTerm(
        code="UE_41_0_100",
        label="UE/41/0/100",
        description="""UE/41/0/100""",
    )

    ue_41_0_100b = VocabularyTerm(
        code="UE_41_0_100B",
        label="UE/41/0/100B",
        description="""UE/41/0/100B""",
    )

    ue_41_0_101 = VocabularyTerm(
        code="UE_41_0_101",
        label="UE/41/0/101",
        description="""UE/41/0/101""",
    )

    ue_41_0_102 = VocabularyTerm(
        code="UE_41_0_102",
        label="UE/41/0/102",
        description="""UE/41/0/102""",
    )

    ue_41_0_105 = VocabularyTerm(
        code="UE_41_0_105",
        label="UE/41/0/105",
        description="""UE/41/0/105""",
    )

    ue_41_0_106b = VocabularyTerm(
        code="UE_41_0_106B",
        label="UE/41/0/106B",
        description="""UE/41/0/106B""",
    )

    ue_41_0_107 = VocabularyTerm(
        code="UE_41_0_107",
        label="UE/41/0/107",
        description="""UE/41/0/107""",
    )

    ue_41_0_108 = VocabularyTerm(
        code="UE_41_0_108",
        label="UE/41/0/108",
        description="""UE/41/0/108""",
    )

    ue_41_0_109 = VocabularyTerm(
        code="UE_41_0_109",
        label="UE/41/0/109",
        description="""UE/41/0/109""",
    )

    ue_41_0_110 = VocabularyTerm(
        code="UE_41_0_110",
        label="UE/41/0/110",
        description="""UE/41/0/110""",
    )

    ue_41_0_110f = VocabularyTerm(
        code="UE_41_0_110F",
        label="UE/41/0/110F",
        description="""UE/41/0/110F""",
    )

    ue_41_0_111 = VocabularyTerm(
        code="UE_41_0_111",
        label="UE/41/0/111",
        description="""UE/41/0/111""",
    )

    ue_41_0_111b = VocabularyTerm(
        code="UE_41_0_111B",
        label="UE/41/0/111B",
        description="""UE/41/0/111B""",
    )

    ue_41_0_113f = VocabularyTerm(
        code="UE_41_0_113F",
        label="UE/41/0/113F",
        description="""UE/41/0/113F""",
    )

    ue_41_0_113h = VocabularyTerm(
        code="UE_41_0_113H",
        label="UE/41/0/113H",
        description="""UE/41/0/113H""",
    )

    ue_41_0_113t = VocabularyTerm(
        code="UE_41_0_113T",
        label="UE/41/0/113T",
        description="""UE/41/0/113T""",
    )

    ue_41_0_114 = VocabularyTerm(
        code="UE_41_0_114",
        label="UE/41/0/114",
        description="""UE/41/0/114""",
    )

    ue_41_0_115 = VocabularyTerm(
        code="UE_41_0_115",
        label="UE/41/0/115",
        description="""UE/41/0/115""",
    )

    ue_41_0_115f = VocabularyTerm(
        code="UE_41_0_115F",
        label="UE/41/0/115F",
        description="""UE/41/0/115F""",
    )

    ue_41_0_118 = VocabularyTerm(
        code="UE_41_0_118",
        label="UE/41/0/118",
        description="""UE/41/0/118""",
    )

    ue_41_0_118b = VocabularyTerm(
        code="UE_41_0_118B",
        label="UE/41/0/118B",
        description="""UE/41/0/118B""",
    )

    ue_41_0_119 = VocabularyTerm(
        code="UE_41_0_119",
        label="UE/41/0/119",
        description="""UE/41/0/119""",
    )

    ue_41_0_120 = VocabularyTerm(
        code="UE_41_0_120",
        label="UE/41/0/120",
        description="""UE/41/0/120""",
    )

    ue_41_0_120b = VocabularyTerm(
        code="UE_41_0_120B",
        label="UE/41/0/120B",
        description="""UE/41/0/120B""",
    )

    ue_41_0_122 = VocabularyTerm(
        code="UE_41_0_122",
        label="UE/41/0/122",
        description="""UE/41/0/122""",
    )

    ue_41_0_122f = VocabularyTerm(
        code="UE_41_0_122F",
        label="UE/41/0/122F",
        description="""UE/41/0/122F""",
    )

    ue_41_0_123 = VocabularyTerm(
        code="UE_41_0_123",
        label="UE/41/0/123",
        description="""UE/41/0/123""",
    )

    ue_41_0_124 = VocabularyTerm(
        code="UE_41_0_124",
        label="UE/41/0/124",
        description="""UE/41/0/124""",
    )

    ue_41_0_124b = VocabularyTerm(
        code="UE_41_0_124B",
        label="UE/41/0/124B",
        description="""UE/41/0/124B""",
    )

    ue_41_0_126b = VocabularyTerm(
        code="UE_41_0_126B",
        label="UE/41/0/126B",
        description="""UE/41/0/126B""",
    )

    ue_41_0_128 = VocabularyTerm(
        code="UE_41_0_128",
        label="UE/41/0/128",
        description="""UE/41/0/128""",
    )

    ue_41_0_132b = VocabularyTerm(
        code="UE_41_0_132B",
        label="UE/41/0/132B",
        description="""UE/41/0/132B""",
    )

    ue_41_0_a1 = VocabularyTerm(
        code="UE_41_0_A1",
        label="UE/41/0/A1",
        description="""UE/41/0/A1""",
    )

    ue_41_1_210 = VocabularyTerm(
        code="UE_41_1_210",
        label="UE/41/1/210",
        description="""UE/41/1/210""",
    )

    ue_41_1_213t = VocabularyTerm(
        code="UE_41_1_213T",
        label="UE/41/1/213T",
        description="""UE/41/1/213T""",
    )

    ue_41_1_215 = VocabularyTerm(
        code="UE_41_1_215",
        label="UE/41/1/215",
        description="""UE/41/1/215""",
    )

    ue_41__1_000 = VocabularyTerm(
        code="UE_41_-1_000",
        label="UE/41/-1/000",
        description="""UE/41/-1/000""",
    )

    ue_41__1_001 = VocabularyTerm(
        code="UE_41_-1_001",
        label="UE/41/-1/001",
        description="""UE/41/-1/001""",
    )

    ue_41__1_002 = VocabularyTerm(
        code="UE_41_-1_002",
        label="UE/41/-1/002",
        description="""UE/41/-1/002""",
    )

    ue_41__1_004 = VocabularyTerm(
        code="UE_41_-1_004",
        label="UE/41/-1/004",
        description="""UE/41/-1/004""",
    )

    ue_41__1_005 = VocabularyTerm(
        code="UE_41_-1_005",
        label="UE/41/-1/005",
        description="""UE/41/-1/005""",
    )

    ue_41__1_008 = VocabularyTerm(
        code="UE_41_-1_008",
        label="UE/41/-1/008",
        description="""UE/41/-1/008""",
    )

    ue_41__1_009 = VocabularyTerm(
        code="UE_41_-1_009",
        label="UE/41/-1/009",
        description="""UE/41/-1/009""",
    )

    ue_41__1_010 = VocabularyTerm(
        code="UE_41_-1_010",
        label="UE/41/-1/010",
        description="""UE/41/-1/010""",
    )

    ue_41__1_010f = VocabularyTerm(
        code="UE_41_-1_010F",
        label="UE/41/-1/010F",
        description="""UE/41/-1/010F""",
    )

    ue_41__1_013 = VocabularyTerm(
        code="UE_41_-1_013",
        label="UE/41/-1/013",
        description="""UE/41/-1/013""",
    )

    ue_41__1_013f = VocabularyTerm(
        code="UE_41_-1_013F",
        label="UE/41/-1/013F",
        description="""UE/41/-1/013F""",
    )

    ue_41__1_013t = VocabularyTerm(
        code="UE_41_-1_013T",
        label="UE/41/-1/013T",
        description="""UE/41/-1/013T""",
    )

    ue_41__1_014 = VocabularyTerm(
        code="UE_41_-1_014",
        label="UE/41/-1/014",
        description="""UE/41/-1/014""",
    )

    ue_41__1_015 = VocabularyTerm(
        code="UE_41_-1_015",
        label="UE/41/-1/015",
        description="""UE/41/-1/015""",
    )

    ue_41__1_015f = VocabularyTerm(
        code="UE_41_-1_015F",
        label="UE/41/-1/015F",
        description="""UE/41/-1/015F""",
    )

    ue_41__1_015h = VocabularyTerm(
        code="UE_41_-1_015H",
        label="UE/41/-1/015H",
        description="""UE/41/-1/015H""",
    )

    ue_41__1_018 = VocabularyTerm(
        code="UE_41_-1_018",
        label="UE/41/-1/018",
        description="""UE/41/-1/018""",
    )

    ue_41__1_019 = VocabularyTerm(
        code="UE_41_-1_019",
        label="UE/41/-1/019",
        description="""UE/41/-1/019""",
    )

    ue_41__1_020f = VocabularyTerm(
        code="UE_41_-1_020F",
        label="UE/41/-1/020F",
        description="""UE/41/-1/020F""",
    )

    ue_41__1_022 = VocabularyTerm(
        code="UE_41_-1_022",
        label="UE/41/-1/022",
        description="""UE/41/-1/022""",
    )

    ue_41__1_022b = VocabularyTerm(
        code="UE_41_-1_022B",
        label="UE/41/-1/022B",
        description="""UE/41/-1/022B""",
    )

    ue_41__1_023 = VocabularyTerm(
        code="UE_41_-1_023",
        label="UE/41/-1/023",
        description="""UE/41/-1/023""",
    )

    ue_41__1_024 = VocabularyTerm(
        code="UE_41_-1_024",
        label="UE/41/-1/024",
        description="""UE/41/-1/024""",
    )

    ue_41__1_026 = VocabularyTerm(
        code="UE_41_-1_026",
        label="UE/41/-1/026",
        description="""UE/41/-1/026""",
    )

    ue_41__1_028 = VocabularyTerm(
        code="UE_41_-1_028",
        label="UE/41/-1/028",
        description="""UE/41/-1/028""",
    )

    ue_41__1_073 = VocabularyTerm(
        code="UE_41_-1_073",
        label="UE/41/-1/073",
        description="""UE/41/-1/073""",
    )

    ue_41__1_073b = VocabularyTerm(
        code="UE_41_-1_073B",
        label="UE/41/-1/073B",
        description="""UE/41/-1/073B""",
    )

    ue_41__1_074 = VocabularyTerm(
        code="UE_41_-1_074",
        label="UE/41/-1/074",
        description="""UE/41/-1/074""",
    )

    ue_41__1_075 = VocabularyTerm(
        code="UE_41_-1_075",
        label="UE/41/-1/075",
        description="""UE/41/-1/075""",
    )

    ue_41__1_075b = VocabularyTerm(
        code="UE_41_-1_075B",
        label="UE/41/-1/075B",
        description="""UE/41/-1/075B""",
    )

    ue_41__1_075f = VocabularyTerm(
        code="UE_41_-1_075F",
        label="UE/41/-1/075F",
        description="""UE/41/-1/075F""",
    )

    ue_41__1_075t = VocabularyTerm(
        code="UE_41_-1_075T",
        label="UE/41/-1/075T",
        description="""UE/41/-1/075T""",
    )

    ue_41__1_076b = VocabularyTerm(
        code="UE_41_-1_076B",
        label="UE/41/-1/076B",
        description="""UE/41/-1/076B""",
    )

    ue_41__1_077b = VocabularyTerm(
        code="UE_41_-1_077B",
        label="UE/41/-1/077B",
        description="""UE/41/-1/077B""",
    )

    ue_41__1_078b = VocabularyTerm(
        code="UE_41_-1_078B",
        label="UE/41/-1/078B",
        description="""UE/41/-1/078B""",
    )

    ue_41__1_079b = VocabularyTerm(
        code="UE_41_-1_079B",
        label="UE/41/-1/079B",
        description="""UE/41/-1/079B""",
    )

    ue_41__1_080b = VocabularyTerm(
        code="UE_41_-1_080B",
        label="UE/41/-1/080B",
        description="""UE/41/-1/080B""",
    )

    ue_41__1_a1 = VocabularyTerm(
        code="UE_41_-1_A1",
        label="UE/41/-1/A1",
        description="""UE/41/-1/A1""",
    )

    ue_42_0_115f = VocabularyTerm(
        code="UE_42_0_115F",
        label="UE/42/0/115F",
        description="""UE/42/0/115F""",
    )

    ue_42_0_127 = VocabularyTerm(
        code="UE_42_0_127",
        label="UE/42/0/127",
        description="""UE/42/0/127""",
    )

    ue_42_0_129 = VocabularyTerm(
        code="UE_42_0_129",
        label="UE/42/0/129",
        description="""UE/42/0/129""",
    )

    ue_42_0_131 = VocabularyTerm(
        code="UE_42_0_131",
        label="UE/42/0/131",
        description="""UE/42/0/131""",
    )

    ue_42_0_134 = VocabularyTerm(
        code="UE_42_0_134",
        label="UE/42/0/134",
        description="""UE/42/0/134""",
    )

    ue_42_0_134b = VocabularyTerm(
        code="UE_42_0_134B",
        label="UE/42/0/134B",
        description="""UE/42/0/134B""",
    )

    ue_42_0_135 = VocabularyTerm(
        code="UE_42_0_135",
        label="UE/42/0/135",
        description="""UE/42/0/135""",
    )

    ue_42_0_136 = VocabularyTerm(
        code="UE_42_0_136",
        label="UE/42/0/136",
        description="""UE/42/0/136""",
    )

    ue_42_0_137 = VocabularyTerm(
        code="UE_42_0_137",
        label="UE/42/0/137",
        description="""UE/42/0/137""",
    )

    ue_42_0_138 = VocabularyTerm(
        code="UE_42_0_138",
        label="UE/42/0/138",
        description="""UE/42/0/138""",
    )

    ue_42_0_139 = VocabularyTerm(
        code="UE_42_0_139",
        label="UE/42/0/139",
        description="""UE/42/0/139""",
    )

    ue_42_0_139f = VocabularyTerm(
        code="UE_42_0_139F",
        label="UE/42/0/139F",
        description="""UE/42/0/139F""",
    )

    ue_42_0_140 = VocabularyTerm(
        code="UE_42_0_140",
        label="UE/42/0/140",
        description="""UE/42/0/140""",
    )

    ue_42_0_141 = VocabularyTerm(
        code="UE_42_0_141",
        label="UE/42/0/141",
        description="""UE/42/0/141""",
    )

    ue_42_0_141d = VocabularyTerm(
        code="UE_42_0_141D",
        label="UE/42/0/141D",
        description="""UE/42/0/141D""",
    )

    ue_42_0_141h = VocabularyTerm(
        code="UE_42_0_141H",
        label="UE/42/0/141H",
        description="""UE/42/0/141H""",
    )

    ue_42_0_141t = VocabularyTerm(
        code="UE_42_0_141T",
        label="UE/42/0/141T",
        description="""UE/42/0/141T""",
    )

    ue_42_0_142 = VocabularyTerm(
        code="UE_42_0_142",
        label="UE/42/0/142",
        description="""UE/42/0/142""",
    )

    ue_42_0_143 = VocabularyTerm(
        code="UE_42_0_143",
        label="UE/42/0/143",
        description="""UE/42/0/143""",
    )

    ue_42_0_144 = VocabularyTerm(
        code="UE_42_0_144",
        label="UE/42/0/144",
        description="""UE/42/0/144""",
    )

    ue_42_0_145 = VocabularyTerm(
        code="UE_42_0_145",
        label="UE/42/0/145",
        description="""UE/42/0/145""",
    )

    ue_42_0_146 = VocabularyTerm(
        code="UE_42_0_146",
        label="UE/42/0/146",
        description="""UE/42/0/146""",
    )

    ue_42_0_147 = VocabularyTerm(
        code="UE_42_0_147",
        label="UE/42/0/147",
        description="""UE/42/0/147""",
    )

    ue_42_0_148 = VocabularyTerm(
        code="UE_42_0_148",
        label="UE/42/0/148",
        description="""UE/42/0/148""",
    )

    ue_42_0_149 = VocabularyTerm(
        code="UE_42_0_149",
        label="UE/42/0/149",
        description="""UE/42/0/149""",
    )

    ue_42_0_150 = VocabularyTerm(
        code="UE_42_0_150",
        label="UE/42/0/150",
        description="""UE/42/0/150""",
    )

    ue_42_0_158 = VocabularyTerm(
        code="UE_42_0_158",
        label="UE/42/0/158",
        description="""UE/42/0/158""",
    )

    ue_42_0_158b = VocabularyTerm(
        code="UE_42_0_158B",
        label="UE/42/0/158B",
        description="""UE/42/0/158B""",
    )

    ue_42_0_158f = VocabularyTerm(
        code="UE_42_0_158F",
        label="UE/42/0/158F",
        description="""UE/42/0/158F""",
    )

    ue_42_0_160 = VocabularyTerm(
        code="UE_42_0_160",
        label="UE/42/0/160",
        description="""UE/42/0/160""",
    )

    ue_42_0_160f = VocabularyTerm(
        code="UE_42_0_160F",
        label="UE/42/0/160F",
        description="""UE/42/0/160F""",
    )

    ue_42_0_164 = VocabularyTerm(
        code="UE_42_0_164",
        label="UE/42/0/164",
        description="""UE/42/0/164""",
    )

    ue_42_0_168 = VocabularyTerm(
        code="UE_42_0_168",
        label="UE/42/0/168",
        description="""UE/42/0/168""",
    )

    ue_42_1_241t = VocabularyTerm(
        code="UE_42_1_241T",
        label="UE/42/1/241T",
        description="""UE/42/1/241T""",
    )

    ue_42_1_260 = VocabularyTerm(
        code="UE_42_1_260",
        label="UE/42/1/260",
        description="""UE/42/1/260""",
    )

    ue_42__1_015f = VocabularyTerm(
        code="UE_42_-1_015F",
        label="UE/42/-1/015F",
        description="""UE/42/-1/015F""",
    )

    ue_42__1_027 = VocabularyTerm(
        code="UE_42_-1_027",
        label="UE/42/-1/027",
        description="""UE/42/-1/027""",
    )

    ue_42__1_031 = VocabularyTerm(
        code="UE_42_-1_031",
        label="UE/42/-1/031",
        description="""UE/42/-1/031""",
    )

    ue_42__1_034 = VocabularyTerm(
        code="UE_42_-1_034",
        label="UE/42/-1/034",
        description="""UE/42/-1/034""",
    )

    ue_42__1_034b = VocabularyTerm(
        code="UE_42_-1_034B",
        label="UE/42/-1/034B",
        description="""UE/42/-1/034B""",
    )

    ue_42__1_035 = VocabularyTerm(
        code="UE_42_-1_035",
        label="UE/42/-1/035",
        description="""UE/42/-1/035""",
    )

    ue_42__1_036 = VocabularyTerm(
        code="UE_42_-1_036",
        label="UE/42/-1/036",
        description="""UE/42/-1/036""",
    )

    ue_42__1_036b = VocabularyTerm(
        code="UE_42_-1_036B",
        label="UE/42/-1/036B",
        description="""UE/42/-1/036B""",
    )

    ue_42__1_037 = VocabularyTerm(
        code="UE_42_-1_037",
        label="UE/42/-1/037",
        description="""UE/42/-1/037""",
    )

    ue_42__1_037h = VocabularyTerm(
        code="UE_42_-1_037H",
        label="UE/42/-1/037H",
        description="""UE/42/-1/037H""",
    )

    ue_42__1_039 = VocabularyTerm(
        code="UE_42_-1_039",
        label="UE/42/-1/039",
        description="""UE/42/-1/039""",
    )

    ue_42__1_039b = VocabularyTerm(
        code="UE_42_-1_039B",
        label="UE/42/-1/039B",
        description="""UE/42/-1/039B""",
    )

    ue_42__1_039c = VocabularyTerm(
        code="UE_42_-1_039C",
        label="UE/42/-1/039C",
        description="""UE/42/-1/039C""",
    )

    ue_42__1_039f = VocabularyTerm(
        code="UE_42_-1_039F",
        label="UE/42/-1/039F",
        description="""UE/42/-1/039F""",
    )

    ue_42__1_040 = VocabularyTerm(
        code="UE_42_-1_040",
        label="UE/42/-1/040",
        description="""UE/42/-1/040""",
    )

    ue_42__1_041 = VocabularyTerm(
        code="UE_42_-1_041",
        label="UE/42/-1/041",
        description="""UE/42/-1/041""",
    )

    ue_42__1_041t = VocabularyTerm(
        code="UE_42_-1_041T",
        label="UE/42/-1/041T",
        description="""UE/42/-1/041T""",
    )

    ue_42__1_043 = VocabularyTerm(
        code="UE_42_-1_043",
        label="UE/42/-1/043",
        description="""UE/42/-1/043""",
    )

    ue_42__1_044 = VocabularyTerm(
        code="UE_42_-1_044",
        label="UE/42/-1/044",
        description="""UE/42/-1/044""",
    )

    ue_42__1_045 = VocabularyTerm(
        code="UE_42_-1_045",
        label="UE/42/-1/045",
        description="""UE/42/-1/045""",
    )

    ue_42__1_046 = VocabularyTerm(
        code="UE_42_-1_046",
        label="UE/42/-1/046",
        description="""UE/42/-1/046""",
    )

    ue_42__1_047 = VocabularyTerm(
        code="UE_42_-1_047",
        label="UE/42/-1/047",
        description="""UE/42/-1/047""",
    )

    ue_42__1_049 = VocabularyTerm(
        code="UE_42_-1_049",
        label="UE/42/-1/049",
        description="""UE/42/-1/049""",
    )

    ue_42__1_050 = VocabularyTerm(
        code="UE_42_-1_050",
        label="UE/42/-1/050",
        description="""UE/42/-1/050""",
    )

    ue_42__1_056 = VocabularyTerm(
        code="UE_42_-1_056",
        label="UE/42/-1/056",
        description="""UE/42/-1/056""",
    )

    ue_42__1_058 = VocabularyTerm(
        code="UE_42_-1_058",
        label="UE/42/-1/058",
        description="""UE/42/-1/058""",
    )

    ue_42__1_060 = VocabularyTerm(
        code="UE_42_-1_060",
        label="UE/42/-1/060",
        description="""UE/42/-1/060""",
    )

    ue_42__1_060f = VocabularyTerm(
        code="UE_42_-1_060F",
        label="UE/42/-1/060F",
        description="""UE/42/-1/060F""",
    )

    ue_42__1_062 = VocabularyTerm(
        code="UE_42_-1_062",
        label="UE/42/-1/062",
        description="""UE/42/-1/062""",
    )

    ue_42__1_064 = VocabularyTerm(
        code="UE_42_-1_064",
        label="UE/42/-1/064",
        description="""UE/42/-1/064""",
    )

    ue_42__1_066 = VocabularyTerm(
        code="UE_42_-1_066",
        label="UE/42/-1/066",
        description="""UE/42/-1/066""",
    )

    ue_42__1_068 = VocabularyTerm(
        code="UE_42_-1_068",
        label="UE/42/-1/068",
        description="""UE/42/-1/068""",
    )

    ue_42__1_081 = VocabularyTerm(
        code="UE_42_-1_081",
        label="UE/42/-1/081",
        description="""UE/42/-1/081""",
    )

    ue_42__1_082 = VocabularyTerm(
        code="UE_42_-1_082",
        label="UE/42/-1/082",
        description="""UE/42/-1/082""",
    )

    ue_42__1_083 = VocabularyTerm(
        code="UE_42_-1_083",
        label="UE/42/-1/083",
        description="""UE/42/-1/083""",
    )

    ue_42__1_084 = VocabularyTerm(
        code="UE_42_-1_084",
        label="UE/42/-1/084",
        description="""UE/42/-1/084""",
    )

    ue_42__1_085 = VocabularyTerm(
        code="UE_42_-1_085",
        label="UE/42/-1/085",
        description="""UE/42/-1/085""",
    )

    ue_43_0_100 = VocabularyTerm(
        code="UE_43_0_100",
        label="UE/43/0/100",
        description="""UE/43/0/100""",
    )

    ue_43_0_101 = VocabularyTerm(
        code="UE_43_0_101",
        label="UE/43/0/101",
        description="""UE/43/0/101""",
    )

    ue_43_0_102 = VocabularyTerm(
        code="UE_43_0_102",
        label="UE/43/0/102",
        description="""UE/43/0/102""",
    )

    ue_43_0_103 = VocabularyTerm(
        code="UE_43_0_103",
        label="UE/43/0/103",
        description="""UE/43/0/103""",
    )

    ue_43_0_104 = VocabularyTerm(
        code="UE_43_0_104",
        label="UE/43/0/104",
        description="""UE/43/0/104""",
    )

    ue_43_0_104f = VocabularyTerm(
        code="UE_43_0_104F",
        label="UE/43/0/104F",
        description="""UE/43/0/104F""",
    )

    ue_43_0_105 = VocabularyTerm(
        code="UE_43_0_105",
        label="UE/43/0/105",
        description="""UE/43/0/105""",
    )

    ue_43_0_105t = VocabularyTerm(
        code="UE_43_0_105T",
        label="UE/43/0/105T",
        description="""UE/43/0/105T""",
    )

    ue_43_0_106 = VocabularyTerm(
        code="UE_43_0_106",
        label="UE/43/0/106",
        description="""UE/43/0/106""",
    )

    ue_43_0_107 = VocabularyTerm(
        code="UE_43_0_107",
        label="UE/43/0/107",
        description="""UE/43/0/107""",
    )

    ue_43_0_108 = VocabularyTerm(
        code="UE_43_0_108",
        label="UE/43/0/108",
        description="""UE/43/0/108""",
    )

    ue_43_0_109f = VocabularyTerm(
        code="UE_43_0_109F",
        label="UE/43/0/109F",
        description="""UE/43/0/109F""",
    )

    ue_43_0_110 = VocabularyTerm(
        code="UE_43_0_110",
        label="UE/43/0/110",
        description="""UE/43/0/110""",
    )

    ue_43_0_110b = VocabularyTerm(
        code="UE_43_0_110B",
        label="UE/43/0/110B",
        description="""UE/43/0/110B""",
    )

    ue_43_0_111 = VocabularyTerm(
        code="UE_43_0_111",
        label="UE/43/0/111",
        description="""UE/43/0/111""",
    )

    ue_43_0_112 = VocabularyTerm(
        code="UE_43_0_112",
        label="UE/43/0/112",
        description="""UE/43/0/112""",
    )

    ue_43_0_114 = VocabularyTerm(
        code="UE_43_0_114",
        label="UE/43/0/114",
        description="""UE/43/0/114""",
    )

    ue_43_0_116 = VocabularyTerm(
        code="UE_43_0_116",
        label="UE/43/0/116",
        description="""UE/43/0/116""",
    )

    ue_43_0_118 = VocabularyTerm(
        code="UE_43_0_118",
        label="UE/43/0/118",
        description="""UE/43/0/118""",
    )

    ue_43_0_118b = VocabularyTerm(
        code="UE_43_0_118B",
        label="UE/43/0/118B",
        description="""UE/43/0/118B""",
    )

    ue_43_0_120 = VocabularyTerm(
        code="UE_43_0_120",
        label="UE/43/0/120",
        description="""UE/43/0/120""",
    )

    ue_43_0_120f = VocabularyTerm(
        code="UE_43_0_120F",
        label="UE/43/0/120F",
        description="""UE/43/0/120F""",
    )

    ue_43_0_122 = VocabularyTerm(
        code="UE_43_0_122",
        label="UE/43/0/122",
        description="""UE/43/0/122""",
    )

    ue_43_0_124 = VocabularyTerm(
        code="UE_43_0_124",
        label="UE/43/0/124",
        description="""UE/43/0/124""",
    )

    ue_43_0_126 = VocabularyTerm(
        code="UE_43_0_126",
        label="UE/43/0/126",
        description="""UE/43/0/126""",
    )

    ue_43_0_128 = VocabularyTerm(
        code="UE_43_0_128",
        label="UE/43/0/128",
        description="""UE/43/0/128""",
    )

    ue_43_0_130 = VocabularyTerm(
        code="UE_43_0_130",
        label="UE/43/0/130",
        description="""UE/43/0/130""",
    )

    ue_43_0_131t = VocabularyTerm(
        code="UE_43_0_131T",
        label="UE/43/0/131T",
        description="""UE/43/0/131T""",
    )

    ue_43_0_132 = VocabularyTerm(
        code="UE_43_0_132",
        label="UE/43/0/132",
        description="""UE/43/0/132""",
    )

    ue_43_0_132t = VocabularyTerm(
        code="UE_43_0_132T",
        label="UE/43/0/132T",
        description="""UE/43/0/132T""",
    )

    ue_43_0_a1 = VocabularyTerm(
        code="UE_43_0_A1",
        label="UE/43/0/A1",
        description="""UE/43/0/A1""",
    )

    ue_43_1_204f = VocabularyTerm(
        code="UE_43_1_204F",
        label="UE/43/1/204F",
        description="""UE/43/1/204F""",
    )

    ue_43_1_205f = VocabularyTerm(
        code="UE_43_1_205F",
        label="UE/43/1/205F",
        description="""UE/43/1/205F""",
    )

    ue_43_1_205t = VocabularyTerm(
        code="UE_43_1_205T",
        label="UE/43/1/205T",
        description="""UE/43/1/205T""",
    )

    ue_43_1_207 = VocabularyTerm(
        code="UE_43_1_207",
        label="UE/43/1/207",
        description="""UE/43/1/207""",
    )

    ue_43_1_209 = VocabularyTerm(
        code="UE_43_1_209",
        label="UE/43/1/209",
        description="""UE/43/1/209""",
    )

    ue_43_1_220 = VocabularyTerm(
        code="UE_43_1_220",
        label="UE/43/1/220",
        description="""UE/43/1/220""",
    )

    ue_43_1_220t = VocabularyTerm(
        code="UE_43_1_220T",
        label="UE/43/1/220T",
        description="""UE/43/1/220T""",
    )

    ue_43__1_001 = VocabularyTerm(
        code="UE_43_-1_001",
        label="UE/43/-1/001",
        description="""UE/43/-1/001""",
    )

    ue_43__1_002 = VocabularyTerm(
        code="UE_43_-1_002",
        label="UE/43/-1/002",
        description="""UE/43/-1/002""",
    )

    ue_43__1_002b = VocabularyTerm(
        code="UE_43_-1_002B",
        label="UE/43/-1/002B",
        description="""UE/43/-1/002B""",
    )

    ue_43__1_003h = VocabularyTerm(
        code="UE_43_-1_003H",
        label="UE/43/-1/003H",
        description="""UE/43/-1/003H""",
    )

    ue_43__1_004 = VocabularyTerm(
        code="UE_43_-1_004",
        label="UE/43/-1/004",
        description="""UE/43/-1/004""",
    )

    ue_43__1_004f = VocabularyTerm(
        code="UE_43_-1_004F",
        label="UE/43/-1/004F",
        description="""UE/43/-1/004F""",
    )

    ue_43__1_005 = VocabularyTerm(
        code="UE_43_-1_005",
        label="UE/43/-1/005",
        description="""UE/43/-1/005""",
    )

    ue_43__1_005f = VocabularyTerm(
        code="UE_43_-1_005F",
        label="UE/43/-1/005F",
        description="""UE/43/-1/005F""",
    )

    ue_43__1_005t = VocabularyTerm(
        code="UE_43_-1_005T",
        label="UE/43/-1/005T",
        description="""UE/43/-1/005T""",
    )

    ue_43__1_006 = VocabularyTerm(
        code="UE_43_-1_006",
        label="UE/43/-1/006",
        description="""UE/43/-1/006""",
    )

    ue_43__1_007 = VocabularyTerm(
        code="UE_43_-1_007",
        label="UE/43/-1/007",
        description="""UE/43/-1/007""",
    )

    ue_43__1_008 = VocabularyTerm(
        code="UE_43_-1_008",
        label="UE/43/-1/008",
        description="""UE/43/-1/008""",
    )

    ue_43__1_009f = VocabularyTerm(
        code="UE_43_-1_009F",
        label="UE/43/-1/009F",
        description="""UE/43/-1/009F""",
    )

    ue_43__1_011 = VocabularyTerm(
        code="UE_43_-1_011",
        label="UE/43/-1/011",
        description="""UE/43/-1/011""",
    )

    ue_43__1_a1 = VocabularyTerm(
        code="UE_43_-1_A1",
        label="UE/43/-1/A1",
        description="""UE/43/-1/A1""",
    )

    ue_43__2_0004f = VocabularyTerm(
        code="UE_43_-2_0004F",
        label="UE/43/-2/0004F",
        description="""UE/43/-2/0004F""",
    )

    ue_43__2_0005f = VocabularyTerm(
        code="UE_43_-2_0005F",
        label="UE/43/-2/0005F",
        description="""UE/43/-2/0005F""",
    )

    ue_43__2_0005t = VocabularyTerm(
        code="UE_43_-2_0005T",
        label="UE/43/-2/0005T",
        description="""UE/43/-2/0005T""",
    )

    ue_43__2_0006 = VocabularyTerm(
        code="UE_43_-2_0006",
        label="UE/43/-2/0006",
        description="""UE/43/-2/0006""",
    )

    ue_43__2_0008 = VocabularyTerm(
        code="UE_43_-2_0008",
        label="UE/43/-2/0008",
        description="""UE/43/-2/0008""",
    )

    ue_43__2_0010 = VocabularyTerm(
        code="UE_43_-2_0010",
        label="UE/43/-2/0010",
        description="""UE/43/-2/0010""",
    )

    ue_43__2_0010f = VocabularyTerm(
        code="UE_43_-2_0010F",
        label="UE/43/-2/0010F",
        description="""UE/43/-2/0010F""",
    )

    ue_43__2_0011 = VocabularyTerm(
        code="UE_43_-2_0011",
        label="UE/43/-2/0011",
        description="""UE/43/-2/0011""",
    )

    ue_43__2_0013 = VocabularyTerm(
        code="UE_43_-2_0013",
        label="UE/43/-2/0013",
        description="""UE/43/-2/0013""",
    )

    ue_43__2_0015 = VocabularyTerm(
        code="UE_43_-2_0015",
        label="UE/43/-2/0015",
        description="""UE/43/-2/0015""",
    )

    ue_43__2_0015b = VocabularyTerm(
        code="UE_43_-2_0015B",
        label="UE/43/-2/0015B",
        description="""UE/43/-2/0015B""",
    )

    ue_43__2_0017 = VocabularyTerm(
        code="UE_43_-2_0017",
        label="UE/43/-2/0017",
        description="""UE/43/-2/0017""",
    )

    ue_43__2_0017b = VocabularyTerm(
        code="UE_43_-2_0017B",
        label="UE/43/-2/0017B",
        description="""UE/43/-2/0017B""",
    )

    ue_43__2_0019 = VocabularyTerm(
        code="UE_43_-2_0019",
        label="UE/43/-2/0019",
        description="""UE/43/-2/0019""",
    )

    ue_43__2_0019b = VocabularyTerm(
        code="UE_43_-2_0019B",
        label="UE/43/-2/0019B",
        description="""UE/43/-2/0019B""",
    )

    ue_43__2_0019f = VocabularyTerm(
        code="UE_43_-2_0019F",
        label="UE/43/-2/0019F",
        description="""UE/43/-2/0019F""",
    )

    ue_43__2_0021 = VocabularyTerm(
        code="UE_43_-2_0021",
        label="UE/43/-2/0021",
        description="""UE/43/-2/0021""",
    )

    ue_43__2_0021b = VocabularyTerm(
        code="UE_43_-2_0021B",
        label="UE/43/-2/0021B",
        description="""UE/43/-2/0021B""",
    )

    ue_43__2_0025 = VocabularyTerm(
        code="UE_43_-2_0025",
        label="UE/43/-2/0025",
        description="""UE/43/-2/0025""",
    )

    ue_43__2_0025b = VocabularyTerm(
        code="UE_43_-2_0025B",
        label="UE/43/-2/0025B",
        description="""UE/43/-2/0025B""",
    )

    ue_43__2_0025c = VocabularyTerm(
        code="UE_43_-2_0025C",
        label="UE/43/-2/0025C",
        description="""UE/43/-2/0025C""",
    )

    ue_43__2_0027b = VocabularyTerm(
        code="UE_43_-2_0027B",
        label="UE/43/-2/0027B",
        description="""UE/43/-2/0027B""",
    )

    ue_43__2_0029 = VocabularyTerm(
        code="UE_43_-2_0029",
        label="UE/43/-2/0029",
        description="""UE/43/-2/0029""",
    )

    ue_43__2_0029b = VocabularyTerm(
        code="UE_43_-2_0029B",
        label="UE/43/-2/0029B",
        description="""UE/43/-2/0029B""",
    )

    ue_43__2_0030 = VocabularyTerm(
        code="UE_43_-2_0030",
        label="UE/43/-2/0030",
        description="""UE/43/-2/0030""",
    )

    ue_43__2_0030f = VocabularyTerm(
        code="UE_43_-2_0030F",
        label="UE/43/-2/0030F",
        description="""UE/43/-2/0030F""",
    )

    ue_43__2_0031 = VocabularyTerm(
        code="UE_43_-2_0031",
        label="UE/43/-2/0031",
        description="""UE/43/-2/0031""",
    )

    ue_43__2_0031t = VocabularyTerm(
        code="UE_43_-2_0031T",
        label="UE/43/-2/0031T",
        description="""UE/43/-2/0031T""",
    )

    ue_43__2_0032 = VocabularyTerm(
        code="UE_43_-2_0032",
        label="UE/43/-2/0032",
        description="""UE/43/-2/0032""",
    )

    ue_43__2_0032f = VocabularyTerm(
        code="UE_43_-2_0032F",
        label="UE/43/-2/0032F",
        description="""UE/43/-2/0032F""",
    )

    ue_43__2_0032t = VocabularyTerm(
        code="UE_43_-2_0032T",
        label="UE/43/-2/0032T",
        description="""UE/43/-2/0032T""",
    )

    ue_43__2_0033 = VocabularyTerm(
        code="UE_43_-2_0033",
        label="UE/43/-2/0033",
        description="""UE/43/-2/0033""",
    )

    ue_43__2_0033f = VocabularyTerm(
        code="UE_43_-2_0033F",
        label="UE/43/-2/0033F",
        description="""UE/43/-2/0033F""",
    )

    ue_43__2_0034 = VocabularyTerm(
        code="UE_43_-2_0034",
        label="UE/43/-2/0034",
        description="""UE/43/-2/0034""",
    )

    ue_43__2_0035 = VocabularyTerm(
        code="UE_43_-2_0035",
        label="UE/43/-2/0035",
        description="""UE/43/-2/0035""",
    )

    ue_43__2_0036 = VocabularyTerm(
        code="UE_43_-2_0036",
        label="UE/43/-2/0036",
        description="""UE/43/-2/0036""",
    )

    ue_43__2_0037 = VocabularyTerm(
        code="UE_43_-2_0037",
        label="UE/43/-2/0037",
        description="""UE/43/-2/0037""",
    )

    ue_43__2_0038 = VocabularyTerm(
        code="UE_43_-2_0038",
        label="UE/43/-2/0038",
        description="""UE/43/-2/0038""",
    )

    ue_43__2_0039 = VocabularyTerm(
        code="UE_43_-2_0039",
        label="UE/43/-2/0039",
        description="""UE/43/-2/0039""",
    )

    ue_43__2_0040t = VocabularyTerm(
        code="UE_43_-2_0040T",
        label="UE/43/-2/0040T",
        description="""UE/43/-2/0040T""",
    )

    ue_43__2_0041 = VocabularyTerm(
        code="UE_43_-2_0041",
        label="UE/43/-2/0041",
        description="""UE/43/-2/0041""",
    )

    ue_43__2_a1 = VocabularyTerm(
        code="UE_43_-2_A1",
        label="UE/43/-2/A1",
        description="""UE/43/-2/A1""",
    )

    ue_44_0_100 = VocabularyTerm(
        code="UE_44_0_100",
        label="UE/44/0/100",
        description="""UE/44/0/100""",
    )

    ue_44_0_101 = VocabularyTerm(
        code="UE_44_0_101",
        label="UE/44/0/101",
        description="""UE/44/0/101""",
    )

    ue_44_0_102 = VocabularyTerm(
        code="UE_44_0_102",
        label="UE/44/0/102",
        description="""UE/44/0/102""",
    )

    ue_44_0_105 = VocabularyTerm(
        code="UE_44_0_105",
        label="UE/44/0/105",
        description="""UE/44/0/105""",
    )

    ue_44_0_106 = VocabularyTerm(
        code="UE_44_0_106",
        label="UE/44/0/106",
        description="""UE/44/0/106""",
    )

    ue_44_0_108 = VocabularyTerm(
        code="UE_44_0_108",
        label="UE/44/0/108",
        description="""UE/44/0/108""",
    )

    ue_44_0_108b = VocabularyTerm(
        code="UE_44_0_108B",
        label="UE/44/0/108B",
        description="""UE/44/0/108B""",
    )

    ue_44_0_108f = VocabularyTerm(
        code="UE_44_0_108F",
        label="UE/44/0/108F",
        description="""UE/44/0/108F""",
    )

    ue_44_0_109 = VocabularyTerm(
        code="UE_44_0_109",
        label="UE/44/0/109",
        description="""UE/44/0/109""",
    )

    ue_44_0_110 = VocabularyTerm(
        code="UE_44_0_110",
        label="UE/44/0/110",
        description="""UE/44/0/110""",
    )

    ue_44_0_111 = VocabularyTerm(
        code="UE_44_0_111",
        label="UE/44/0/111",
        description="""UE/44/0/111""",
    )

    ue_44_0_113 = VocabularyTerm(
        code="UE_44_0_113",
        label="UE/44/0/113",
        description="""UE/44/0/113""",
    )

    ue_44_0_115 = VocabularyTerm(
        code="UE_44_0_115",
        label="UE/44/0/115",
        description="""UE/44/0/115""",
    )

    ue_44_0_116 = VocabularyTerm(
        code="UE_44_0_116",
        label="UE/44/0/116",
        description="""UE/44/0/116""",
    )

    ue_44_0_117 = VocabularyTerm(
        code="UE_44_0_117",
        label="UE/44/0/117",
        description="""UE/44/0/117""",
    )

    ue_44_0_119 = VocabularyTerm(
        code="UE_44_0_119",
        label="UE/44/0/119",
        description="""UE/44/0/119""",
    )

    ue_44_0_120 = VocabularyTerm(
        code="UE_44_0_120",
        label="UE/44/0/120",
        description="""UE/44/0/120""",
    )

    ue_44_0_121 = VocabularyTerm(
        code="UE_44_0_121",
        label="UE/44/0/121",
        description="""UE/44/0/121""",
    )

    ue_44_0_123 = VocabularyTerm(
        code="UE_44_0_123",
        label="UE/44/0/123",
        description="""UE/44/0/123""",
    )

    ue_44_0_124 = VocabularyTerm(
        code="UE_44_0_124",
        label="UE/44/0/124",
        description="""UE/44/0/124""",
    )

    ue_44_0_124b = VocabularyTerm(
        code="UE_44_0_124B",
        label="UE/44/0/124B",
        description="""UE/44/0/124B""",
    )

    ue_44_0_124f = VocabularyTerm(
        code="UE_44_0_124F",
        label="UE/44/0/124F",
        description="""UE/44/0/124F""",
    )

    ue_44_0_125 = VocabularyTerm(
        code="UE_44_0_125",
        label="UE/44/0/125",
        description="""UE/44/0/125""",
    )

    ue_44_0_127 = VocabularyTerm(
        code="UE_44_0_127",
        label="UE/44/0/127",
        description="""UE/44/0/127""",
    )

    ue_44_0_128 = VocabularyTerm(
        code="UE_44_0_128",
        label="UE/44/0/128",
        description="""UE/44/0/128""",
    )

    ue_44_0_128b = VocabularyTerm(
        code="UE_44_0_128B",
        label="UE/44/0/128B",
        description="""UE/44/0/128B""",
    )

    ue_44_0_129 = VocabularyTerm(
        code="UE_44_0_129",
        label="UE/44/0/129",
        description="""UE/44/0/129""",
    )

    ue_44_0_130 = VocabularyTerm(
        code="UE_44_0_130",
        label="UE/44/0/130",
        description="""UE/44/0/130""",
    )

    ue_44_0_130b = VocabularyTerm(
        code="UE_44_0_130B",
        label="UE/44/0/130B",
        description="""UE/44/0/130B""",
    )

    ue_44_0_131 = VocabularyTerm(
        code="UE_44_0_131",
        label="UE/44/0/131",
        description="""UE/44/0/131""",
    )

    ue_44_0_132t = VocabularyTerm(
        code="UE_44_0_132T",
        label="UE/44/0/132T",
        description="""UE/44/0/132T""",
    )

    ue_44_0_133 = VocabularyTerm(
        code="UE_44_0_133",
        label="UE/44/0/133",
        description="""UE/44/0/133""",
    )

    ue_44_0_135 = VocabularyTerm(
        code="UE_44_0_135",
        label="UE/44/0/135",
        description="""UE/44/0/135""",
    )

    ue_44_0_137f = VocabularyTerm(
        code="UE_44_0_137F",
        label="UE/44/0/137F",
        description="""UE/44/0/137F""",
    )

    ue_44_0_137t = VocabularyTerm(
        code="UE_44_0_137T",
        label="UE/44/0/137T",
        description="""UE/44/0/137T""",
    )

    ue_44_0_139d = VocabularyTerm(
        code="UE_44_0_139D",
        label="UE/44/0/139D",
        description="""UE/44/0/139D""",
    )

    ue_44_0_139h = VocabularyTerm(
        code="UE_44_0_139H",
        label="UE/44/0/139H",
        description="""UE/44/0/139H""",
    )

    ue_44_0_141 = VocabularyTerm(
        code="UE_44_0_141",
        label="UE/44/0/141",
        description="""UE/44/0/141""",
    )

    ue_44_0_143 = VocabularyTerm(
        code="UE_44_0_143",
        label="UE/44/0/143",
        description="""UE/44/0/143""",
    )

    ue_44_0_143f = VocabularyTerm(
        code="UE_44_0_143F",
        label="UE/44/0/143F",
        description="""UE/44/0/143F""",
    )

    ue_44_0_145 = VocabularyTerm(
        code="UE_44_0_145",
        label="UE/44/0/145",
        description="""UE/44/0/145""",
    )

    ue_44_0_147 = VocabularyTerm(
        code="UE_44_0_147",
        label="UE/44/0/147",
        description="""UE/44/0/147""",
    )

    ue_44_1_208 = VocabularyTerm(
        code="UE_44_1_208",
        label="UE/44/1/208",
        description="""UE/44/1/208""",
    )

    ue_44_1_224 = VocabularyTerm(
        code="UE_44_1_224",
        label="UE/44/1/224",
        description="""UE/44/1/224""",
    )

    ue_44_1_237t = VocabularyTerm(
        code="UE_44_1_237T",
        label="UE/44/1/237T",
        description="""UE/44/1/237T""",
    )

    ue_44__1_015 = VocabularyTerm(
        code="UE_44_-1_015",
        label="UE/44/-1/015",
        description="""UE/44/-1/015""",
    )

    ue_44__1_016 = VocabularyTerm(
        code="UE_44_-1_016",
        label="UE/44/-1/016",
        description="""UE/44/-1/016""",
    )

    ue_44__1_016t = VocabularyTerm(
        code="UE_44_-1_016T",
        label="UE/44/-1/016T",
        description="""UE/44/-1/016T""",
    )

    ue_44__1_020 = VocabularyTerm(
        code="UE_44_-1_020",
        label="UE/44/-1/020",
        description="""UE/44/-1/020""",
    )

    ue_44__1_021 = VocabularyTerm(
        code="UE_44_-1_021",
        label="UE/44/-1/021",
        description="""UE/44/-1/021""",
    )

    ue_44__1_022 = VocabularyTerm(
        code="UE_44_-1_022",
        label="UE/44/-1/022",
        description="""UE/44/-1/022""",
    )

    ue_44__1_022b = VocabularyTerm(
        code="UE_44_-1_022B",
        label="UE/44/-1/022B",
        description="""UE/44/-1/022B""",
    )

    ue_44__1_024f = VocabularyTerm(
        code="UE_44_-1_024F",
        label="UE/44/-1/024F",
        description="""UE/44/-1/024F""",
    )

    ue_44__1_025 = VocabularyTerm(
        code="UE_44_-1_025",
        label="UE/44/-1/025",
        description="""UE/44/-1/025""",
    )

    ue_44__1_027 = VocabularyTerm(
        code="UE_44_-1_027",
        label="UE/44/-1/027",
        description="""UE/44/-1/027""",
    )

    ue_44__1_028 = VocabularyTerm(
        code="UE_44_-1_028",
        label="UE/44/-1/028",
        description="""UE/44/-1/028""",
    )

    ue_44__1_028b = VocabularyTerm(
        code="UE_44_-1_028B",
        label="UE/44/-1/028B",
        description="""UE/44/-1/028B""",
    )

    ue_44__1_030 = VocabularyTerm(
        code="UE_44_-1_030",
        label="UE/44/-1/030",
        description="""UE/44/-1/030""",
    )

    ue_44__1_031 = VocabularyTerm(
        code="UE_44_-1_031",
        label="UE/44/-1/031",
        description="""UE/44/-1/031""",
    )

    ue_44__1_033 = VocabularyTerm(
        code="UE_44_-1_033",
        label="UE/44/-1/033",
        description="""UE/44/-1/033""",
    )

    ue_44__1_035 = VocabularyTerm(
        code="UE_44_-1_035",
        label="UE/44/-1/035",
        description="""UE/44/-1/035""",
    )

    ue_44__1_037f = VocabularyTerm(
        code="UE_44_-1_037F",
        label="UE/44/-1/037F",
        description="""UE/44/-1/037F""",
    )

    ue_44__1_037t = VocabularyTerm(
        code="UE_44_-1_037T",
        label="UE/44/-1/037T",
        description="""UE/44/-1/037T""",
    )

    ue_44__1_039 = VocabularyTerm(
        code="UE_44_-1_039",
        label="UE/44/-1/039",
        description="""UE/44/-1/039""",
    )

    ue_44__1_039h = VocabularyTerm(
        code="UE_44_-1_039H",
        label="UE/44/-1/039H",
        description="""UE/44/-1/039H""",
    )

    ue_44__1_041 = VocabularyTerm(
        code="UE_44_-1_041",
        label="UE/44/-1/041",
        description="""UE/44/-1/041""",
    )

    ue_44__1_041f = VocabularyTerm(
        code="UE_44_-1_041F",
        label="UE/44/-1/041F",
        description="""UE/44/-1/041F""",
    )

    ue_44__1_043 = VocabularyTerm(
        code="UE_44_-1_043",
        label="UE/44/-1/043",
        description="""UE/44/-1/043""",
    )

    ue_44__1_043f = VocabularyTerm(
        code="UE_44_-1_043F",
        label="UE/44/-1/043F",
        description="""UE/44/-1/043F""",
    )

    ue_44__1_045 = VocabularyTerm(
        code="UE_44_-1_045",
        label="UE/44/-1/045",
        description="""UE/44/-1/045""",
    )

    ue_44__1_047 = VocabularyTerm(
        code="UE_44_-1_047",
        label="UE/44/-1/047",
        description="""UE/44/-1/047""",
    )

    ue_44__1_048 = VocabularyTerm(
        code="UE_44_-1_048",
        label="UE/44/-1/048",
        description="""UE/44/-1/048""",
    )

    ue_44__1_048f = VocabularyTerm(
        code="UE_44_-1_048F",
        label="UE/44/-1/048F",
        description="""UE/44/-1/048F""",
    )

    ue_50_0_166 = VocabularyTerm(
        code="UE_50_0_166",
        label="UE/50/0/166",
        description="""UE/50/0/166""",
    )

    ue_50_0_167 = VocabularyTerm(
        code="UE_50_0_167",
        label="UE/50/0/167",
        description="""UE/50/0/167""",
    )

    ue_50_0_168 = VocabularyTerm(
        code="UE_50_0_168",
        label="UE/50/0/168",
        description="""UE/50/0/168""",
    )

    ue_50_0_170 = VocabularyTerm(
        code="UE_50_0_170",
        label="UE/50/0/170",
        description="""UE/50/0/170""",
    )

    ue_50_0_170b = VocabularyTerm(
        code="UE_50_0_170B",
        label="UE/50/0/170B",
        description="""UE/50/0/170B""",
    )

    ue_50_0_171 = VocabularyTerm(
        code="UE_50_0_171",
        label="UE/50/0/171",
        description="""UE/50/0/171""",
    )

    ue_50_0_172 = VocabularyTerm(
        code="UE_50_0_172",
        label="UE/50/0/172",
        description="""UE/50/0/172""",
    )

    ue_50_0_173 = VocabularyTerm(
        code="UE_50_0_173",
        label="UE/50/0/173",
        description="""UE/50/0/173""",
    )

    ue_50_0_174 = VocabularyTerm(
        code="UE_50_0_174",
        label="UE/50/0/174",
        description="""UE/50/0/174""",
    )

    ue_50_0_174b = VocabularyTerm(
        code="UE_50_0_174B",
        label="UE/50/0/174B",
        description="""UE/50/0/174B""",
    )

    ue_50_0_174f = VocabularyTerm(
        code="UE_50_0_174F",
        label="UE/50/0/174F",
        description="""UE/50/0/174F""",
    )

    ue_50_0_175 = VocabularyTerm(
        code="UE_50_0_175",
        label="UE/50/0/175",
        description="""UE/50/0/175""",
    )

    ue_50_0_177f = VocabularyTerm(
        code="UE_50_0_177F",
        label="UE/50/0/177F",
        description="""UE/50/0/177F""",
    )

    ue_50_0_177t = VocabularyTerm(
        code="UE_50_0_177T",
        label="UE/50/0/177T",
        description="""UE/50/0/177T""",
    )

    ue_50_0_178 = VocabularyTerm(
        code="UE_50_0_178",
        label="UE/50/0/178",
        description="""UE/50/0/178""",
    )

    ue_50_0_179 = VocabularyTerm(
        code="UE_50_0_179",
        label="UE/50/0/179",
        description="""UE/50/0/179""",
    )

    ue_50_0_180 = VocabularyTerm(
        code="UE_50_0_180",
        label="UE/50/0/180",
        description="""UE/50/0/180""",
    )

    ue_50_0_181 = VocabularyTerm(
        code="UE_50_0_181",
        label="UE/50/0/181",
        description="""UE/50/0/181""",
    )

    ue_50_0_182 = VocabularyTerm(
        code="UE_50_0_182",
        label="UE/50/0/182",
        description="""UE/50/0/182""",
    )

    ue_50_0_182b = VocabularyTerm(
        code="UE_50_0_182B",
        label="UE/50/0/182B",
        description="""UE/50/0/182B""",
    )

    ue_50_0_183 = VocabularyTerm(
        code="UE_50_0_183",
        label="UE/50/0/183",
        description="""UE/50/0/183""",
    )

    ue_50_0_185 = VocabularyTerm(
        code="UE_50_0_185",
        label="UE/50/0/185",
        description="""UE/50/0/185""",
    )

    ue_50_0_185f = VocabularyTerm(
        code="UE_50_0_185F",
        label="UE/50/0/185F",
        description="""UE/50/0/185F""",
    )

    ue_50_0_186 = VocabularyTerm(
        code="UE_50_0_186",
        label="UE/50/0/186",
        description="""UE/50/0/186""",
    )

    ue_50_0_187 = VocabularyTerm(
        code="UE_50_0_187",
        label="UE/50/0/187",
        description="""UE/50/0/187""",
    )

    ue_50_0_188 = VocabularyTerm(
        code="UE_50_0_188",
        label="UE/50/0/188",
        description="""UE/50/0/188""",
    )

    ue_50_0_189 = VocabularyTerm(
        code="UE_50_0_189",
        label="UE/50/0/189",
        description="""UE/50/0/189""",
    )

    ue_50_0_190 = VocabularyTerm(
        code="UE_50_0_190",
        label="UE/50/0/190",
        description="""UE/50/0/190""",
    )

    ue_50_0_191 = VocabularyTerm(
        code="UE_50_0_191",
        label="UE/50/0/191",
        description="""UE/50/0/191""",
    )

    ue_50_0_192 = VocabularyTerm(
        code="UE_50_0_192",
        label="UE/50/0/192",
        description="""UE/50/0/192""",
    )

    ue_50_0_193 = VocabularyTerm(
        code="UE_50_0_193",
        label="UE/50/0/193",
        description="""UE/50/0/193""",
    )

    ue_50_0_193b = VocabularyTerm(
        code="UE_50_0_193B",
        label="UE/50/0/193B",
        description="""UE/50/0/193B""",
    )

    ue_50_0_194 = VocabularyTerm(
        code="UE_50_0_194",
        label="UE/50/0/194",
        description="""UE/50/0/194""",
    )

    ue_50_0_198 = VocabularyTerm(
        code="UE_50_0_198",
        label="UE/50/0/198",
        description="""UE/50/0/198""",
    )

    ue_50_0_198t = VocabularyTerm(
        code="UE_50_0_198T",
        label="UE/50/0/198T",
        description="""UE/50/0/198T""",
    )

    ue_50_0_a1 = VocabularyTerm(
        code="UE_50_0_A1",
        label="UE/50/0/A1",
        description="""UE/50/0/A1""",
    )

    ue_50_1a_185a = VocabularyTerm(
        code="UE_50_1A_185A",
        label="UE/50/1A/185A",
        description="""UE/50/1A/185A""",
    )

    ue_50_1a_185af = VocabularyTerm(
        code="UE_50_1A_185AF",
        label="UE/50/1A/185AF",
        description="""UE/50/1A/185AF""",
    )

    ue_50_1a_187a = VocabularyTerm(
        code="UE_50_1A_187A",
        label="UE/50/1A/187A",
        description="""UE/50/1A/187A""",
    )

    ue_50_1a_188a = VocabularyTerm(
        code="UE_50_1A_188A",
        label="UE/50/1A/188A",
        description="""UE/50/1A/188A""",
    )

    ue_50_1a_188ab = VocabularyTerm(
        code="UE_50_1A_188AB",
        label="UE/50/1A/188AB",
        description="""UE/50/1A/188AB""",
    )

    ue_50_1a_188af = VocabularyTerm(
        code="UE_50_1A_188AF",
        label="UE/50/1A/188AF",
        description="""UE/50/1A/188AF""",
    )

    ue_50_1a_189a = VocabularyTerm(
        code="UE_50_1A_189A",
        label="UE/50/1A/189A",
        description="""UE/50/1A/189A""",
    )

    ue_50_1a_190a = VocabularyTerm(
        code="UE_50_1A_190A",
        label="UE/50/1A/190A",
        description="""UE/50/1A/190A""",
    )

    ue_50_1a_191a = VocabularyTerm(
        code="UE_50_1A_191A",
        label="UE/50/1A/191A",
        description="""UE/50/1A/191A""",
    )

    ue_50_1a_192a = VocabularyTerm(
        code="UE_50_1A_192A",
        label="UE/50/1A/192A",
        description="""UE/50/1A/192A""",
    )

    ue_50_1a_194a = VocabularyTerm(
        code="UE_50_1A_194A",
        label="UE/50/1A/194A",
        description="""UE/50/1A/194A""",
    )

    ue_50_1a_196a = VocabularyTerm(
        code="UE_50_1A_196A",
        label="UE/50/1A/196A",
        description="""UE/50/1A/196A""",
    )

    ue_50_1a_198a = VocabularyTerm(
        code="UE_50_1A_198A",
        label="UE/50/1A/198A",
        description="""UE/50/1A/198A""",
    )

    ue_50_1a_198at = VocabularyTerm(
        code="UE_50_1A_198AT",
        label="UE/50/1A/198AT",
        description="""UE/50/1A/198AT""",
    )

    ue_50_1_266 = VocabularyTerm(
        code="UE_50_1_266",
        label="UE/50/1/266",
        description="""UE/50/1/266""",
    )

    ue_50_1_267 = VocabularyTerm(
        code="UE_50_1_267",
        label="UE/50/1/267",
        description="""UE/50/1/267""",
    )

    ue_50_1_268 = VocabularyTerm(
        code="UE_50_1_268",
        label="UE/50/1/268",
        description="""UE/50/1/268""",
    )

    ue_50_1_270 = VocabularyTerm(
        code="UE_50_1_270",
        label="UE/50/1/270",
        description="""UE/50/1/270""",
    )

    ue_50_1_271 = VocabularyTerm(
        code="UE_50_1_271",
        label="UE/50/1/271",
        description="""UE/50/1/271""",
    )

    ue_50_1_272 = VocabularyTerm(
        code="UE_50_1_272",
        label="UE/50/1/272",
        description="""UE/50/1/272""",
    )

    ue_50_1_273 = VocabularyTerm(
        code="UE_50_1_273",
        label="UE/50/1/273",
        description="""UE/50/1/273""",
    )

    ue_50_1_274 = VocabularyTerm(
        code="UE_50_1_274",
        label="UE/50/1/274",
        description="""UE/50/1/274""",
    )

    ue_50_1_275 = VocabularyTerm(
        code="UE_50_1_275",
        label="UE/50/1/275",
        description="""UE/50/1/275""",
    )

    ue_50_1_276 = VocabularyTerm(
        code="UE_50_1_276",
        label="UE/50/1/276",
        description="""UE/50/1/276""",
    )

    ue_50_1_276b = VocabularyTerm(
        code="UE_50_1_276B",
        label="UE/50/1/276B",
        description="""UE/50/1/276B""",
    )

    ue_50_1_277f = VocabularyTerm(
        code="UE_50_1_277F",
        label="UE/50/1/277F",
        description="""UE/50/1/277F""",
    )

    ue_50_1_277t = VocabularyTerm(
        code="UE_50_1_277T",
        label="UE/50/1/277T",
        description="""UE/50/1/277T""",
    )

    ue_50_1_278 = VocabularyTerm(
        code="UE_50_1_278",
        label="UE/50/1/278",
        description="""UE/50/1/278""",
    )

    ue_50_1_280 = VocabularyTerm(
        code="UE_50_1_280",
        label="UE/50/1/280",
        description="""UE/50/1/280""",
    )

    ue_50_1_281 = VocabularyTerm(
        code="UE_50_1_281",
        label="UE/50/1/281",
        description="""UE/50/1/281""",
    )

    ue_50_1_282 = VocabularyTerm(
        code="UE_50_1_282",
        label="UE/50/1/282",
        description="""UE/50/1/282""",
    )

    ue_50_1_283 = VocabularyTerm(
        code="UE_50_1_283",
        label="UE/50/1/283",
        description="""UE/50/1/283""",
    )

    ue_50_1_284 = VocabularyTerm(
        code="UE_50_1_284",
        label="UE/50/1/284",
        description="""UE/50/1/284""",
    )

    ue_50_1_284f = VocabularyTerm(
        code="UE_50_1_284F",
        label="UE/50/1/284F",
        description="""UE/50/1/284F""",
    )

    ue_50_1_284t = VocabularyTerm(
        code="UE_50_1_284T",
        label="UE/50/1/284T",
        description="""UE/50/1/284T""",
    )

    ue_50_1_285 = VocabularyTerm(
        code="UE_50_1_285",
        label="UE/50/1/285",
        description="""UE/50/1/285""",
    )

    ue_50_1_286 = VocabularyTerm(
        code="UE_50_1_286",
        label="UE/50/1/286",
        description="""UE/50/1/286""",
    )

    ue_50_1_287 = VocabularyTerm(
        code="UE_50_1_287",
        label="UE/50/1/287",
        description="""UE/50/1/287""",
    )

    ue_50_1_288 = VocabularyTerm(
        code="UE_50_1_288",
        label="UE/50/1/288",
        description="""UE/50/1/288""",
    )

    ue_50_1_289 = VocabularyTerm(
        code="UE_50_1_289",
        label="UE/50/1/289",
        description="""UE/50/1/289""",
    )

    ue_50_1_290 = VocabularyTerm(
        code="UE_50_1_290",
        label="UE/50/1/290",
        description="""UE/50/1/290""",
    )

    ue_50_1_291 = VocabularyTerm(
        code="UE_50_1_291",
        label="UE/50/1/291",
        description="""UE/50/1/291""",
    )

    ue_50_1_292 = VocabularyTerm(
        code="UE_50_1_292",
        label="UE/50/1/292",
        description="""UE/50/1/292""",
    )

    ue_50_1_293 = VocabularyTerm(
        code="UE_50_1_293",
        label="UE/50/1/293",
        description="""UE/50/1/293""",
    )

    ue_50_1_294 = VocabularyTerm(
        code="UE_50_1_294",
        label="UE/50/1/294",
        description="""UE/50/1/294""",
    )

    ue_50_1_295 = VocabularyTerm(
        code="UE_50_1_295",
        label="UE/50/1/295",
        description="""UE/50/1/295""",
    )

    ue_50_1_296 = VocabularyTerm(
        code="UE_50_1_296",
        label="UE/50/1/296",
        description="""UE/50/1/296""",
    )

    ue_50_1_296b = VocabularyTerm(
        code="UE_50_1_296B",
        label="UE/50/1/296B",
        description="""UE/50/1/296B""",
    )

    ue_50_1_297 = VocabularyTerm(
        code="UE_50_1_297",
        label="UE/50/1/297",
        description="""UE/50/1/297""",
    )

    ue_50_1_299 = VocabularyTerm(
        code="UE_50_1_299",
        label="UE/50/1/299",
        description="""UE/50/1/299""",
    )

    ue_50_1_299b = VocabularyTerm(
        code="UE_50_1_299B",
        label="UE/50/1/299B",
        description="""UE/50/1/299B""",
    )

    ue_50_1_a1 = VocabularyTerm(
        code="UE_50_1_A1",
        label="UE/50/1/A1",
        description="""UE/50/1/A1""",
    )

    ue_50_2_366 = VocabularyTerm(
        code="UE_50_2_366",
        label="UE/50/2/366",
        description="""UE/50/2/366""",
    )

    ue_50_2_367 = VocabularyTerm(
        code="UE_50_2_367",
        label="UE/50/2/367",
        description="""UE/50/2/367""",
    )

    ue_50_2_368 = VocabularyTerm(
        code="UE_50_2_368",
        label="UE/50/2/368",
        description="""UE/50/2/368""",
    )

    ue_50_2_368b = VocabularyTerm(
        code="UE_50_2_368B",
        label="UE/50/2/368B",
        description="""UE/50/2/368B""",
    )

    ue_50_2_369 = VocabularyTerm(
        code="UE_50_2_369",
        label="UE/50/2/369",
        description="""UE/50/2/369""",
    )

    ue_50_2_370 = VocabularyTerm(
        code="UE_50_2_370",
        label="UE/50/2/370",
        description="""UE/50/2/370""",
    )

    ue_50_2_371 = VocabularyTerm(
        code="UE_50_2_371",
        label="UE/50/2/371",
        description="""UE/50/2/371""",
    )

    ue_50_2_372 = VocabularyTerm(
        code="UE_50_2_372",
        label="UE/50/2/372",
        description="""UE/50/2/372""",
    )

    ue_50_2_373 = VocabularyTerm(
        code="UE_50_2_373",
        label="UE/50/2/373",
        description="""UE/50/2/373""",
    )

    ue_50_2_375 = VocabularyTerm(
        code="UE_50_2_375",
        label="UE/50/2/375",
        description="""UE/50/2/375""",
    )

    ue_50_2_376 = VocabularyTerm(
        code="UE_50_2_376",
        label="UE/50/2/376",
        description="""UE/50/2/376""",
    )

    ue_50_2_376b = VocabularyTerm(
        code="UE_50_2_376B",
        label="UE/50/2/376B",
        description="""UE/50/2/376B""",
    )

    ue_50_2_377f = VocabularyTerm(
        code="UE_50_2_377F",
        label="UE/50/2/377F",
        description="""UE/50/2/377F""",
    )

    ue_50_2_377t = VocabularyTerm(
        code="UE_50_2_377T",
        label="UE/50/2/377T",
        description="""UE/50/2/377T""",
    )

    ue_50_2_378 = VocabularyTerm(
        code="UE_50_2_378",
        label="UE/50/2/378",
        description="""UE/50/2/378""",
    )

    ue_50_2_378b = VocabularyTerm(
        code="UE_50_2_378B",
        label="UE/50/2/378B",
        description="""UE/50/2/378B""",
    )

    ue_50_2_379d = VocabularyTerm(
        code="UE_50_2_379D",
        label="UE/50/2/379D",
        description="""UE/50/2/379D""",
    )

    ue_50_2_380 = VocabularyTerm(
        code="UE_50_2_380",
        label="UE/50/2/380",
        description="""UE/50/2/380""",
    )

    ue_50_2_380b = VocabularyTerm(
        code="UE_50_2_380B",
        label="UE/50/2/380B",
        description="""UE/50/2/380B""",
    )

    ue_50_2_381 = VocabularyTerm(
        code="UE_50_2_381",
        label="UE/50/2/381",
        description="""UE/50/2/381""",
    )

    ue_50_2_382 = VocabularyTerm(
        code="UE_50_2_382",
        label="UE/50/2/382",
        description="""UE/50/2/382""",
    )

    ue_50_2_383 = VocabularyTerm(
        code="UE_50_2_383",
        label="UE/50/2/383",
        description="""UE/50/2/383""",
    )

    ue_50_2_384 = VocabularyTerm(
        code="UE_50_2_384",
        label="UE/50/2/384",
        description="""UE/50/2/384""",
    )

    ue_50_2_384f = VocabularyTerm(
        code="UE_50_2_384F",
        label="UE/50/2/384F",
        description="""UE/50/2/384F""",
    )

    ue_50_2_385 = VocabularyTerm(
        code="UE_50_2_385",
        label="UE/50/2/385",
        description="""UE/50/2/385""",
    )

    ue_50_2_386 = VocabularyTerm(
        code="UE_50_2_386",
        label="UE/50/2/386",
        description="""UE/50/2/386""",
    )

    ue_50_2_387 = VocabularyTerm(
        code="UE_50_2_387",
        label="UE/50/2/387",
        description="""UE/50/2/387""",
    )

    ue_50_2_388 = VocabularyTerm(
        code="UE_50_2_388",
        label="UE/50/2/388",
        description="""UE/50/2/388""",
    )

    ue_50_2_389 = VocabularyTerm(
        code="UE_50_2_389",
        label="UE/50/2/389",
        description="""UE/50/2/389""",
    )

    ue_50_2_390 = VocabularyTerm(
        code="UE_50_2_390",
        label="UE/50/2/390",
        description="""UE/50/2/390""",
    )

    ue_50_2_390b = VocabularyTerm(
        code="UE_50_2_390B",
        label="UE/50/2/390B",
        description="""UE/50/2/390B""",
    )

    ue_50_2_391 = VocabularyTerm(
        code="UE_50_2_391",
        label="UE/50/2/391",
        description="""UE/50/2/391""",
    )

    ue_50_2_392 = VocabularyTerm(
        code="UE_50_2_392",
        label="UE/50/2/392",
        description="""UE/50/2/392""",
    )

    ue_50_2_393 = VocabularyTerm(
        code="UE_50_2_393",
        label="UE/50/2/393",
        description="""UE/50/2/393""",
    )

    ue_50_2_394 = VocabularyTerm(
        code="UE_50_2_394",
        label="UE/50/2/394",
        description="""UE/50/2/394""",
    )

    ue_50_2_395 = VocabularyTerm(
        code="UE_50_2_395",
        label="UE/50/2/395",
        description="""UE/50/2/395""",
    )

    ue_50_2_396 = VocabularyTerm(
        code="UE_50_2_396",
        label="UE/50/2/396",
        description="""UE/50/2/396""",
    )

    ue_50_2_397 = VocabularyTerm(
        code="UE_50_2_397",
        label="UE/50/2/397",
        description="""UE/50/2/397""",
    )

    ue_50_2_398 = VocabularyTerm(
        code="UE_50_2_398",
        label="UE/50/2/398",
        description="""UE/50/2/398""",
    )

    ue_50_2_398t = VocabularyTerm(
        code="UE_50_2_398T",
        label="UE/50/2/398T",
        description="""UE/50/2/398T""",
    )

    ue_50_2_399 = VocabularyTerm(
        code="UE_50_2_399",
        label="UE/50/2/399",
        description="""UE/50/2/399""",
    )

    ue_50_2_a1 = VocabularyTerm(
        code="UE_50_2_A1",
        label="UE/50/2/A1",
        description="""UE/50/2/A1""",
    )

    ue_50_3_477 = VocabularyTerm(
        code="UE_50_3_477",
        label="UE/50/3/477",
        description="""UE/50/3/477""",
    )

    ue_50_3_477b = VocabularyTerm(
        code="UE_50_3_477B",
        label="UE/50/3/477B",
        description="""UE/50/3/477B""",
    )

    ue_50_3_477t = VocabularyTerm(
        code="UE_50_3_477T",
        label="UE/50/3/477T",
        description="""UE/50/3/477T""",
    )

    ue_50__1_066 = VocabularyTerm(
        code="UE_50_-1_066",
        label="UE/50/-1/066",
        description="""UE/50/-1/066""",
    )

    ue_50__1_066f = VocabularyTerm(
        code="UE_50_-1_066F",
        label="UE/50/-1/066F",
        description="""UE/50/-1/066F""",
    )

    ue_50__1_068 = VocabularyTerm(
        code="UE_50_-1_068",
        label="UE/50/-1/068",
        description="""UE/50/-1/068""",
    )

    ue_50__1_069f = VocabularyTerm(
        code="UE_50_-1_069F",
        label="UE/50/-1/069F",
        description="""UE/50/-1/069F""",
    )

    ue_50__1_070 = VocabularyTerm(
        code="UE_50_-1_070",
        label="UE/50/-1/070",
        description="""UE/50/-1/070""",
    )

    ue_50__1_070b = VocabularyTerm(
        code="UE_50_-1_070B",
        label="UE/50/-1/070B",
        description="""UE/50/-1/070B""",
    )

    ue_50__1_071 = VocabularyTerm(
        code="UE_50_-1_071",
        label="UE/50/-1/071",
        description="""UE/50/-1/071""",
    )

    ue_50__1_072 = VocabularyTerm(
        code="UE_50_-1_072",
        label="UE/50/-1/072",
        description="""UE/50/-1/072""",
    )

    ue_50__1_073 = VocabularyTerm(
        code="UE_50_-1_073",
        label="UE/50/-1/073",
        description="""UE/50/-1/073""",
    )

    ue_50__1_074f = VocabularyTerm(
        code="UE_50_-1_074F",
        label="UE/50/-1/074F",
        description="""UE/50/-1/074F""",
    )

    ue_50__1_075 = VocabularyTerm(
        code="UE_50_-1_075",
        label="UE/50/-1/075",
        description="""UE/50/-1/075""",
    )

    ue_50__1_076 = VocabularyTerm(
        code="UE_50_-1_076",
        label="UE/50/-1/076",
        description="""UE/50/-1/076""",
    )

    ue_50__1_077b = VocabularyTerm(
        code="UE_50_-1_077B",
        label="UE/50/-1/077B",
        description="""UE/50/-1/077B""",
    )

    ue_50__1_077f = VocabularyTerm(
        code="UE_50_-1_077F",
        label="UE/50/-1/077F",
        description="""UE/50/-1/077F""",
    )

    ue_50__1_077t = VocabularyTerm(
        code="UE_50_-1_077T",
        label="UE/50/-1/077T",
        description="""UE/50/-1/077T""",
    )

    ue_50__1_078 = VocabularyTerm(
        code="UE_50_-1_078",
        label="UE/50/-1/078",
        description="""UE/50/-1/078""",
    )

    ue_50__1_079 = VocabularyTerm(
        code="UE_50_-1_079",
        label="UE/50/-1/079",
        description="""UE/50/-1/079""",
    )

    ue_50__1_080 = VocabularyTerm(
        code="UE_50_-1_080",
        label="UE/50/-1/080",
        description="""UE/50/-1/080""",
    )

    ue_50__1_080f = VocabularyTerm(
        code="UE_50_-1_080F",
        label="UE/50/-1/080F",
        description="""UE/50/-1/080F""",
    )

    ue_50__1_081 = VocabularyTerm(
        code="UE_50_-1_081",
        label="UE/50/-1/081",
        description="""UE/50/-1/081""",
    )

    ue_50__1_082 = VocabularyTerm(
        code="UE_50_-1_082",
        label="UE/50/-1/082",
        description="""UE/50/-1/082""",
    )

    ue_50__1_082b = VocabularyTerm(
        code="UE_50_-1_082B",
        label="UE/50/-1/082B",
        description="""UE/50/-1/082B""",
    )

    ue_50__1_082f = VocabularyTerm(
        code="UE_50_-1_082F",
        label="UE/50/-1/082F",
        description="""UE/50/-1/082F""",
    )

    ue_50__1_083 = VocabularyTerm(
        code="UE_50_-1_083",
        label="UE/50/-1/083",
        description="""UE/50/-1/083""",
    )

    ue_50__1_084f = VocabularyTerm(
        code="UE_50_-1_084F",
        label="UE/50/-1/084F",
        description="""UE/50/-1/084F""",
    )

    ue_50__1_098 = VocabularyTerm(
        code="UE_50_-1_098",
        label="UE/50/-1/098",
        description="""UE/50/-1/098""",
    )

    ue_50__1_098f = VocabularyTerm(
        code="UE_50_-1_098F",
        label="UE/50/-1/098F",
        description="""UE/50/-1/098F""",
    )

    ue_50__1_098t = VocabularyTerm(
        code="UE_50_-1_098T",
        label="UE/50/-1/098T",
        description="""UE/50/-1/098T""",
    )

    ue_50__1_a1 = VocabularyTerm(
        code="UE_50_-1_A1",
        label="UE/50/-1/A1",
        description="""UE/50/-1/A1""",
    )

    ue_51_0_101 = VocabularyTerm(
        code="UE_51_0_101",
        label="UE/51/0/101",
        description="""UE/51/0/101""",
    )

    ue_51_0_102 = VocabularyTerm(
        code="UE_51_0_102",
        label="UE/51/0/102",
        description="""UE/51/0/102""",
    )

    ue_51_0_102f = VocabularyTerm(
        code="UE_51_0_102F",
        label="UE/51/0/102F",
        description="""UE/51/0/102F""",
    )

    ue_51_0_103 = VocabularyTerm(
        code="UE_51_0_103",
        label="UE/51/0/103",
        description="""UE/51/0/103""",
    )

    ue_51_0_104 = VocabularyTerm(
        code="UE_51_0_104",
        label="UE/51/0/104",
        description="""UE/51/0/104""",
    )

    ue_51_0_105 = VocabularyTerm(
        code="UE_51_0_105",
        label="UE/51/0/105",
        description="""UE/51/0/105""",
    )

    ue_51_0_106 = VocabularyTerm(
        code="UE_51_0_106",
        label="UE/51/0/106",
        description="""UE/51/0/106""",
    )

    ue_51_0_107 = VocabularyTerm(
        code="UE_51_0_107",
        label="UE/51/0/107",
        description="""UE/51/0/107""",
    )

    ue_51_0_108h = VocabularyTerm(
        code="UE_51_0_108H",
        label="UE/51/0/108H",
        description="""UE/51/0/108H""",
    )

    ue_51_0_109f = VocabularyTerm(
        code="UE_51_0_109F",
        label="UE/51/0/109F",
        description="""UE/51/0/109F""",
    )

    ue_51_0_110f = VocabularyTerm(
        code="UE_51_0_110F",
        label="UE/51/0/110F",
        description="""UE/51/0/110F""",
    )

    ue_51_0_110t = VocabularyTerm(
        code="UE_51_0_110T",
        label="UE/51/0/110T",
        description="""UE/51/0/110T""",
    )

    ue_51_0_112 = VocabularyTerm(
        code="UE_51_0_112",
        label="UE/51/0/112",
        description="""UE/51/0/112""",
    )

    ue_51_0_113 = VocabularyTerm(
        code="UE_51_0_113",
        label="UE/51/0/113",
        description="""UE/51/0/113""",
    )

    ue_51_0_114 = VocabularyTerm(
        code="UE_51_0_114",
        label="UE/51/0/114",
        description="""UE/51/0/114""",
    )

    ue_51_0_115 = VocabularyTerm(
        code="UE_51_0_115",
        label="UE/51/0/115",
        description="""UE/51/0/115""",
    )

    ue_51_0_116 = VocabularyTerm(
        code="UE_51_0_116",
        label="UE/51/0/116",
        description="""UE/51/0/116""",
    )

    ue_51_0_118 = VocabularyTerm(
        code="UE_51_0_118",
        label="UE/51/0/118",
        description="""UE/51/0/118""",
    )

    ue_51_0_124f = VocabularyTerm(
        code="UE_51_0_124F",
        label="UE/51/0/124F",
        description="""UE/51/0/124F""",
    )

    ue_51_0_126 = VocabularyTerm(
        code="UE_51_0_126",
        label="UE/51/0/126",
        description="""UE/51/0/126""",
    )

    ue_51_0_126b = VocabularyTerm(
        code="UE_51_0_126B",
        label="UE/51/0/126B",
        description="""UE/51/0/126B""",
    )

    ue_51_0_128 = VocabularyTerm(
        code="UE_51_0_128",
        label="UE/51/0/128",
        description="""UE/51/0/128""",
    )

    ue_51_0_129 = VocabularyTerm(
        code="UE_51_0_129",
        label="UE/51/0/129",
        description="""UE/51/0/129""",
    )

    ue_51_0_130 = VocabularyTerm(
        code="UE_51_0_130",
        label="UE/51/0/130",
        description="""UE/51/0/130""",
    )

    ue_51_0_131 = VocabularyTerm(
        code="UE_51_0_131",
        label="UE/51/0/131",
        description="""UE/51/0/131""",
    )

    ue_51_0_132 = VocabularyTerm(
        code="UE_51_0_132",
        label="UE/51/0/132",
        description="""UE/51/0/132""",
    )

    ue_51_0_132b = VocabularyTerm(
        code="UE_51_0_132B",
        label="UE/51/0/132B",
        description="""UE/51/0/132B""",
    )

    ue_51_0_133 = VocabularyTerm(
        code="UE_51_0_133",
        label="UE/51/0/133",
        description="""UE/51/0/133""",
    )

    ue_51_0_134 = VocabularyTerm(
        code="UE_51_0_134",
        label="UE/51/0/134",
        description="""UE/51/0/134""",
    )

    ue_51_0_134b = VocabularyTerm(
        code="UE_51_0_134B",
        label="UE/51/0/134B",
        description="""UE/51/0/134B""",
    )

    ue_51_0_135 = VocabularyTerm(
        code="UE_51_0_135",
        label="UE/51/0/135",
        description="""UE/51/0/135""",
    )

    ue_51_0_135f = VocabularyTerm(
        code="UE_51_0_135F",
        label="UE/51/0/135F",
        description="""UE/51/0/135F""",
    )

    ue_51_0_136 = VocabularyTerm(
        code="UE_51_0_136",
        label="UE/51/0/136",
        description="""UE/51/0/136""",
    )

    ue_51_0_137 = VocabularyTerm(
        code="UE_51_0_137",
        label="UE/51/0/137",
        description="""UE/51/0/137""",
    )

    ue_51_0_138 = VocabularyTerm(
        code="UE_51_0_138",
        label="UE/51/0/138",
        description="""UE/51/0/138""",
    )

    ue_51_0_138f = VocabularyTerm(
        code="UE_51_0_138F",
        label="UE/51/0/138F",
        description="""UE/51/0/138F""",
    )

    ue_51_0_139 = VocabularyTerm(
        code="UE_51_0_139",
        label="UE/51/0/139",
        description="""UE/51/0/139""",
    )

    ue_51_0_140 = VocabularyTerm(
        code="UE_51_0_140",
        label="UE/51/0/140",
        description="""UE/51/0/140""",
    )

    ue_51_0_141 = VocabularyTerm(
        code="UE_51_0_141",
        label="UE/51/0/141",
        description="""UE/51/0/141""",
    )

    ue_51_0_143f = VocabularyTerm(
        code="UE_51_0_143F",
        label="UE/51/0/143F",
        description="""UE/51/0/143F""",
    )

    ue_51_0_145 = VocabularyTerm(
        code="UE_51_0_145",
        label="UE/51/0/145",
        description="""UE/51/0/145""",
    )

    ue_51_0_145b = VocabularyTerm(
        code="UE_51_0_145B",
        label="UE/51/0/145B",
        description="""UE/51/0/145B""",
    )

    ue_51_0_147 = VocabularyTerm(
        code="UE_51_0_147",
        label="UE/51/0/147",
        description="""UE/51/0/147""",
    )

    ue_51_0_a1 = VocabularyTerm(
        code="UE_51_0_A1",
        label="UE/51/0/A1",
        description="""UE/51/0/A1""",
    )

    ue_51_1_200 = VocabularyTerm(
        code="UE_51_1_200",
        label="UE/51/1/200",
        description="""UE/51/1/200""",
    )

    ue_51_1_200f = VocabularyTerm(
        code="UE_51_1_200F",
        label="UE/51/1/200F",
        description="""UE/51/1/200F""",
    )

    ue_51_1_201 = VocabularyTerm(
        code="UE_51_1_201",
        label="UE/51/1/201",
        description="""UE/51/1/201""",
    )

    ue_51_1_202 = VocabularyTerm(
        code="UE_51_1_202",
        label="UE/51/1/202",
        description="""UE/51/1/202""",
    )

    ue_51_1_203 = VocabularyTerm(
        code="UE_51_1_203",
        label="UE/51/1/203",
        description="""UE/51/1/203""",
    )

    ue_51_1_204 = VocabularyTerm(
        code="UE_51_1_204",
        label="UE/51/1/204",
        description="""UE/51/1/204""",
    )

    ue_51_1_205 = VocabularyTerm(
        code="UE_51_1_205",
        label="UE/51/1/205",
        description="""UE/51/1/205""",
    )

    ue_51_1_206 = VocabularyTerm(
        code="UE_51_1_206",
        label="UE/51/1/206",
        description="""UE/51/1/206""",
    )

    ue_51_1_207 = VocabularyTerm(
        code="UE_51_1_207",
        label="UE/51/1/207",
        description="""UE/51/1/207""",
    )

    ue_51_1_208d = VocabularyTerm(
        code="UE_51_1_208D",
        label="UE/51/1/208D",
        description="""UE/51/1/208D""",
    )

    ue_51_1_209 = VocabularyTerm(
        code="UE_51_1_209",
        label="UE/51/1/209",
        description="""UE/51/1/209""",
    )

    ue_51_1_210f = VocabularyTerm(
        code="UE_51_1_210F",
        label="UE/51/1/210F",
        description="""UE/51/1/210F""",
    )

    ue_51_1_210t = VocabularyTerm(
        code="UE_51_1_210T",
        label="UE/51/1/210T",
        description="""UE/51/1/210T""",
    )

    ue_51_1_211 = VocabularyTerm(
        code="UE_51_1_211",
        label="UE/51/1/211",
        description="""UE/51/1/211""",
    )

    ue_51_1_212 = VocabularyTerm(
        code="UE_51_1_212",
        label="UE/51/1/212",
        description="""UE/51/1/212""",
    )

    ue_51_1_213 = VocabularyTerm(
        code="UE_51_1_213",
        label="UE/51/1/213",
        description="""UE/51/1/213""",
    )

    ue_51_1_214 = VocabularyTerm(
        code="UE_51_1_214",
        label="UE/51/1/214",
        description="""UE/51/1/214""",
    )

    ue_51_1_215 = VocabularyTerm(
        code="UE_51_1_215",
        label="UE/51/1/215",
        description="""UE/51/1/215""",
    )

    ue_51_1_216 = VocabularyTerm(
        code="UE_51_1_216",
        label="UE/51/1/216",
        description="""UE/51/1/216""",
    )

    ue_51_1_219 = VocabularyTerm(
        code="UE_51_1_219",
        label="UE/51/1/219",
        description="""UE/51/1/219""",
    )

    ue_51_1_235 = VocabularyTerm(
        code="UE_51_1_235",
        label="UE/51/1/235",
        description="""UE/51/1/235""",
    )

    ue_51_1_a1 = VocabularyTerm(
        code="UE_51_1_A1",
        label="UE/51/1/A1",
        description="""UE/51/1/A1""",
    )

    ue_51_2_302 = VocabularyTerm(
        code="UE_51_2_302",
        label="UE/51/2/302",
        description="""UE/51/2/302""",
    )

    ue_51_2_304 = VocabularyTerm(
        code="UE_51_2_304",
        label="UE/51/2/304",
        description="""UE/51/2/304""",
    )

    ue_51_2_308 = VocabularyTerm(
        code="UE_51_2_308",
        label="UE/51/2/308",
        description="""UE/51/2/308""",
    )

    ue_51_2_308f = VocabularyTerm(
        code="UE_51_2_308F",
        label="UE/51/2/308F",
        description="""UE/51/2/308F""",
    )

    ue_51_2_309 = VocabularyTerm(
        code="UE_51_2_309",
        label="UE/51/2/309",
        description="""UE/51/2/309""",
    )

    ue_51_2_310t = VocabularyTerm(
        code="UE_51_2_310T",
        label="UE/51/2/310T",
        description="""UE/51/2/310T""",
    )

    ue_51_2_312 = VocabularyTerm(
        code="UE_51_2_312",
        label="UE/51/2/312",
        description="""UE/51/2/312""",
    )

    ue_51_2_314 = VocabularyTerm(
        code="UE_51_2_314",
        label="UE/51/2/314",
        description="""UE/51/2/314""",
    )

    ue_51_2_314f = VocabularyTerm(
        code="UE_51_2_314F",
        label="UE/51/2/314F",
        description="""UE/51/2/314F""",
    )

    ue_51_2_a1 = VocabularyTerm(
        code="UE_51_2_A1",
        label="UE/51/2/A1",
        description="""UE/51/2/A1""",
    )

    ue_51__1_000 = VocabularyTerm(
        code="UE_51_-1_000",
        label="UE/51/-1/000",
        description="""UE/51/-1/000""",
    )

    ue_51__1_001 = VocabularyTerm(
        code="UE_51_-1_001",
        label="UE/51/-1/001",
        description="""UE/51/-1/001""",
    )

    ue_51__1_002 = VocabularyTerm(
        code="UE_51_-1_002",
        label="UE/51/-1/002",
        description="""UE/51/-1/002""",
    )

    ue_51__1_003 = VocabularyTerm(
        code="UE_51_-1_003",
        label="UE/51/-1/003",
        description="""UE/51/-1/003""",
    )

    ue_51__1_004 = VocabularyTerm(
        code="UE_51_-1_004",
        label="UE/51/-1/004",
        description="""UE/51/-1/004""",
    )

    ue_51__1_004f = VocabularyTerm(
        code="UE_51_-1_004F",
        label="UE/51/-1/004F",
        description="""UE/51/-1/004F""",
    )

    ue_51__1_006 = VocabularyTerm(
        code="UE_51_-1_006",
        label="UE/51/-1/006",
        description="""UE/51/-1/006""",
    )

    ue_51__1_007 = VocabularyTerm(
        code="UE_51_-1_007",
        label="UE/51/-1/007",
        description="""UE/51/-1/007""",
    )

    ue_51__1_008 = VocabularyTerm(
        code="UE_51_-1_008",
        label="UE/51/-1/008",
        description="""UE/51/-1/008""",
    )

    ue_51__1_009f = VocabularyTerm(
        code="UE_51_-1_009F",
        label="UE/51/-1/009F",
        description="""UE/51/-1/009F""",
    )

    ue_51__1_010f = VocabularyTerm(
        code="UE_51_-1_010F",
        label="UE/51/-1/010F",
        description="""UE/51/-1/010F""",
    )

    ue_51__1_010t = VocabularyTerm(
        code="UE_51_-1_010T",
        label="UE/51/-1/010T",
        description="""UE/51/-1/010T""",
    )

    ue_51__1_011 = VocabularyTerm(
        code="UE_51_-1_011",
        label="UE/51/-1/011",
        description="""UE/51/-1/011""",
    )

    ue_51__1_012 = VocabularyTerm(
        code="UE_51_-1_012",
        label="UE/51/-1/012",
        description="""UE/51/-1/012""",
    )

    ue_51__1_013 = VocabularyTerm(
        code="UE_51_-1_013",
        label="UE/51/-1/013",
        description="""UE/51/-1/013""",
    )

    ue_51__1_014 = VocabularyTerm(
        code="UE_51_-1_014",
        label="UE/51/-1/014",
        description="""UE/51/-1/014""",
    )

    ue_51__1_015 = VocabularyTerm(
        code="UE_51_-1_015",
        label="UE/51/-1/015",
        description="""UE/51/-1/015""",
    )

    ue_51__1_016 = VocabularyTerm(
        code="UE_51_-1_016",
        label="UE/51/-1/016",
        description="""UE/51/-1/016""",
    )

    ue_51__1_018b = VocabularyTerm(
        code="UE_51_-1_018B",
        label="UE/51/-1/018B",
        description="""UE/51/-1/018B""",
    )

    ue_51__1_022 = VocabularyTerm(
        code="UE_51_-1_022",
        label="UE/51/-1/022",
        description="""UE/51/-1/022""",
    )

    ue_51__1_022b = VocabularyTerm(
        code="UE_51_-1_022B",
        label="UE/51/-1/022B",
        description="""UE/51/-1/022B""",
    )

    ue_51__1_022f = VocabularyTerm(
        code="UE_51_-1_022F",
        label="UE/51/-1/022F",
        description="""UE/51/-1/022F""",
    )

    ue_51__1_024 = VocabularyTerm(
        code="UE_51_-1_024",
        label="UE/51/-1/024",
        description="""UE/51/-1/024""",
    )

    ue_51__1_024b = VocabularyTerm(
        code="UE_51_-1_024B",
        label="UE/51/-1/024B",
        description="""UE/51/-1/024B""",
    )

    ue_51__1_026 = VocabularyTerm(
        code="UE_51_-1_026",
        label="UE/51/-1/026",
        description="""UE/51/-1/026""",
    )

    ue_51__1_026b = VocabularyTerm(
        code="UE_51_-1_026B",
        label="UE/51/-1/026B",
        description="""UE/51/-1/026B""",
    )

    ue_51__1_026c = VocabularyTerm(
        code="UE_51_-1_026C",
        label="UE/51/-1/026C",
        description="""UE/51/-1/026C""",
    )

    ue_51__1_026f = VocabularyTerm(
        code="UE_51_-1_026F",
        label="UE/51/-1/026F",
        description="""UE/51/-1/026F""",
    )

    ue_51__1_027b = VocabularyTerm(
        code="UE_51_-1_027B",
        label="UE/51/-1/027B",
        description="""UE/51/-1/027B""",
    )

    ue_51__1_028f = VocabularyTerm(
        code="UE_51_-1_028F",
        label="UE/51/-1/028F",
        description="""UE/51/-1/028F""",
    )

    ue_51__1_029 = VocabularyTerm(
        code="UE_51_-1_029",
        label="UE/51/-1/029",
        description="""UE/51/-1/029""",
    )

    ue_51__1_029f = VocabularyTerm(
        code="UE_51_-1_029F",
        label="UE/51/-1/029F",
        description="""UE/51/-1/029F""",
    )

    ue_51__1_030b = VocabularyTerm(
        code="UE_51_-1_030B",
        label="UE/51/-1/030B",
        description="""UE/51/-1/030B""",
    )

    ue_51__1_030f = VocabularyTerm(
        code="UE_51_-1_030F",
        label="UE/51/-1/030F",
        description="""UE/51/-1/030F""",
    )

    ue_51__1_032 = VocabularyTerm(
        code="UE_51_-1_032",
        label="UE/51/-1/032",
        description="""UE/51/-1/032""",
    )

    ue_51__1_032b = VocabularyTerm(
        code="UE_51_-1_032B",
        label="UE/51/-1/032B",
        description="""UE/51/-1/032B""",
    )

    ue_51__1_033 = VocabularyTerm(
        code="UE_51_-1_033",
        label="UE/51/-1/033",
        description="""UE/51/-1/033""",
    )

    ue_51__1_033b = VocabularyTerm(
        code="UE_51_-1_033B",
        label="UE/51/-1/033B",
        description="""UE/51/-1/033B""",
    )

    ue_51__1_034 = VocabularyTerm(
        code="UE_51_-1_034",
        label="UE/51/-1/034",
        description="""UE/51/-1/034""",
    )

    ue_51__1_034b = VocabularyTerm(
        code="UE_51_-1_034B",
        label="UE/51/-1/034B",
        description="""UE/51/-1/034B""",
    )

    ue_51__1_035b = VocabularyTerm(
        code="UE_51_-1_035B",
        label="UE/51/-1/035B",
        description="""UE/51/-1/035B""",
    )

    ue_51__1_035f = VocabularyTerm(
        code="UE_51_-1_035F",
        label="UE/51/-1/035F",
        description="""UE/51/-1/035F""",
    )

    ue_51__1_036 = VocabularyTerm(
        code="UE_51_-1_036",
        label="UE/51/-1/036",
        description="""UE/51/-1/036""",
    )

    ue_51__1_036b = VocabularyTerm(
        code="UE_51_-1_036B",
        label="UE/51/-1/036B",
        description="""UE/51/-1/036B""",
    )

    ue_51__1_037f = VocabularyTerm(
        code="UE_51_-1_037F",
        label="UE/51/-1/037F",
        description="""UE/51/-1/037F""",
    )

    ue_51__1_039b = VocabularyTerm(
        code="UE_51_-1_039B",
        label="UE/51/-1/039B",
        description="""UE/51/-1/039B""",
    )

    ue_51__1_040 = VocabularyTerm(
        code="UE_51_-1_040",
        label="UE/51/-1/040",
        description="""UE/51/-1/040""",
    )

    ue_51__1_040b = VocabularyTerm(
        code="UE_51_-1_040B",
        label="UE/51/-1/040B",
        description="""UE/51/-1/040B""",
    )

    ue_51__1_040c = VocabularyTerm(
        code="UE_51_-1_040C",
        label="UE/51/-1/040C",
        description="""UE/51/-1/040C""",
    )

    ue_51__1_041 = VocabularyTerm(
        code="UE_51_-1_041",
        label="UE/51/-1/041",
        description="""UE/51/-1/041""",
    )

    ue_51__1_041b = VocabularyTerm(
        code="UE_51_-1_041B",
        label="UE/51/-1/041B",
        description="""UE/51/-1/041B""",
    )

    ue_51__1_043f = VocabularyTerm(
        code="UE_51_-1_043F",
        label="UE/51/-1/043F",
        description="""UE/51/-1/043F""",
    )

    ue_51__1_043t = VocabularyTerm(
        code="UE_51_-1_043T",
        label="UE/51/-1/043T",
        description="""UE/51/-1/043T""",
    )

    ue_51__1_045 = VocabularyTerm(
        code="UE_51_-1_045",
        label="UE/51/-1/045",
        description="""UE/51/-1/045""",
    )

    ue_51__1_045b = VocabularyTerm(
        code="UE_51_-1_045B",
        label="UE/51/-1/045B",
        description="""UE/51/-1/045B""",
    )

    ue_51__1_045f = VocabularyTerm(
        code="UE_51_-1_045F",
        label="UE/51/-1/045F",
        description="""UE/51/-1/045F""",
    )

    ue_51__1_045h = VocabularyTerm(
        code="UE_51_-1_045H",
        label="UE/51/-1/045H",
        description="""UE/51/-1/045H""",
    )

    ue_51__1_047 = VocabularyTerm(
        code="UE_51_-1_047",
        label="UE/51/-1/047",
        description="""UE/51/-1/047""",
    )

    ue_51__1_047b = VocabularyTerm(
        code="UE_51_-1_047B",
        label="UE/51/-1/047B",
        description="""UE/51/-1/047B""",
    )

    ue_51__1_049 = VocabularyTerm(
        code="UE_51_-1_049",
        label="UE/51/-1/049",
        description="""UE/51/-1/049""",
    )

    ue_51__1_a1 = VocabularyTerm(
        code="UE_51_-1_A1",
        label="UE/51/-1/A1",
        description="""UE/51/-1/A1""",
    )

    ue_60_0_100 = VocabularyTerm(
        code="UE_60_0_100",
        label="UE/60/0/100",
        description="""UE/60/0/100""",
    )

    ue_60_0_101 = VocabularyTerm(
        code="UE_60_0_101",
        label="UE/60/0/101",
        description="""UE/60/0/101""",
    )

    ue_60_0_102 = VocabularyTerm(
        code="UE_60_0_102",
        label="UE/60/0/102",
        description="""UE/60/0/102""",
    )

    ue_60_0_102b = VocabularyTerm(
        code="UE_60_0_102B",
        label="UE/60/0/102B",
        description="""UE/60/0/102B""",
    )

    ue_60_0_103 = VocabularyTerm(
        code="UE_60_0_103",
        label="UE/60/0/103",
        description="""UE/60/0/103""",
    )

    ue_60_0_104 = VocabularyTerm(
        code="UE_60_0_104",
        label="UE/60/0/104",
        description="""UE/60/0/104""",
    )

    ue_60_0_104b = VocabularyTerm(
        code="UE_60_0_104B",
        label="UE/60/0/104B",
        description="""UE/60/0/104B""",
    )

    ue_60_0_104f = VocabularyTerm(
        code="UE_60_0_104F",
        label="UE/60/0/104F",
        description="""UE/60/0/104F""",
    )

    ue_60_0_105 = VocabularyTerm(
        code="UE_60_0_105",
        label="UE/60/0/105",
        description="""UE/60/0/105""",
    )

    ue_60_0_106 = VocabularyTerm(
        code="UE_60_0_106",
        label="UE/60/0/106",
        description="""UE/60/0/106""",
    )

    ue_60_0_107 = VocabularyTerm(
        code="UE_60_0_107",
        label="UE/60/0/107",
        description="""UE/60/0/107""",
    )

    ue_60_0_108 = VocabularyTerm(
        code="UE_60_0_108",
        label="UE/60/0/108",
        description="""UE/60/0/108""",
    )

    ue_60_0_109f = VocabularyTerm(
        code="UE_60_0_109F",
        label="UE/60/0/109F",
        description="""UE/60/0/109F""",
    )

    ue_60_0_109t = VocabularyTerm(
        code="UE_60_0_109T",
        label="UE/60/0/109T",
        description="""UE/60/0/109T""",
    )

    ue_60_0_112 = VocabularyTerm(
        code="UE_60_0_112",
        label="UE/60/0/112",
        description="""UE/60/0/112""",
    )

    ue_60_0_113f = VocabularyTerm(
        code="UE_60_0_113F",
        label="UE/60/0/113F",
        description="""UE/60/0/113F""",
    )

    ue_60_0_115 = VocabularyTerm(
        code="UE_60_0_115",
        label="UE/60/0/115",
        description="""UE/60/0/115""",
    )

    ue_60_0_116 = VocabularyTerm(
        code="UE_60_0_116",
        label="UE/60/0/116",
        description="""UE/60/0/116""",
    )

    ue_60_0_117 = VocabularyTerm(
        code="UE_60_0_117",
        label="UE/60/0/117",
        description="""UE/60/0/117""",
    )

    ue_60_0_118f = VocabularyTerm(
        code="UE_60_0_118F",
        label="UE/60/0/118F",
        description="""UE/60/0/118F""",
    )

    ue_60_0_120t = VocabularyTerm(
        code="UE_60_0_120T",
        label="UE/60/0/120T",
        description="""UE/60/0/120T""",
    )

    ue_60_0_121 = VocabularyTerm(
        code="UE_60_0_121",
        label="UE/60/0/121",
        description="""UE/60/0/121""",
    )

    ue_60_0_122d = VocabularyTerm(
        code="UE_60_0_122D",
        label="UE/60/0/122D",
        description="""UE/60/0/122D""",
    )

    ue_60_0_122h = VocabularyTerm(
        code="UE_60_0_122H",
        label="UE/60/0/122H",
        description="""UE/60/0/122H""",
    )

    ue_60_0_122wc = VocabularyTerm(
        code="UE_60_0_122WC",
        label="UE/60/0/122WC",
        description="""UE/60/0/122WC""",
    )

    ue_60_0_123 = VocabularyTerm(
        code="UE_60_0_123",
        label="UE/60/0/123",
        description="""UE/60/0/123""",
    )

    ue_60_0_126 = VocabularyTerm(
        code="UE_60_0_126",
        label="UE/60/0/126",
        description="""UE/60/0/126""",
    )

    ue_60_0_127 = VocabularyTerm(
        code="UE_60_0_127",
        label="UE/60/0/127",
        description="""UE/60/0/127""",
    )

    ue_60_0_128 = VocabularyTerm(
        code="UE_60_0_128",
        label="UE/60/0/128",
        description="""UE/60/0/128""",
    )

    ue_60_0_129 = VocabularyTerm(
        code="UE_60_0_129",
        label="UE/60/0/129",
        description="""UE/60/0/129""",
    )

    ue_60_0_129b = VocabularyTerm(
        code="UE_60_0_129B",
        label="UE/60/0/129B",
        description="""UE/60/0/129B""",
    )

    ue_60_0_131 = VocabularyTerm(
        code="UE_60_0_131",
        label="UE/60/0/131",
        description="""UE/60/0/131""",
    )

    ue_60_0_132 = VocabularyTerm(
        code="UE_60_0_132",
        label="UE/60/0/132",
        description="""UE/60/0/132""",
    )

    ue_60_0_133 = VocabularyTerm(
        code="UE_60_0_133",
        label="UE/60/0/133",
        description="""UE/60/0/133""",
    )

    ue_60_0_133t = VocabularyTerm(
        code="UE_60_0_133T",
        label="UE/60/0/133T",
        description="""UE/60/0/133T""",
    )

    ue_60_0_135 = VocabularyTerm(
        code="UE_60_0_135",
        label="UE/60/0/135",
        description="""UE/60/0/135""",
    )

    ue_60_0_136 = VocabularyTerm(
        code="UE_60_0_136",
        label="UE/60/0/136",
        description="""UE/60/0/136""",
    )

    ue_60_0_139 = VocabularyTerm(
        code="UE_60_0_139",
        label="UE/60/0/139",
        description="""UE/60/0/139""",
    )

    ue_60_0_140f = VocabularyTerm(
        code="UE_60_0_140F",
        label="UE/60/0/140F",
        description="""UE/60/0/140F""",
    )

    ue_60_0_140t = VocabularyTerm(
        code="UE_60_0_140T",
        label="UE/60/0/140T",
        description="""UE/60/0/140T""",
    )

    ue_60_0_141 = VocabularyTerm(
        code="UE_60_0_141",
        label="UE/60/0/141",
        description="""UE/60/0/141""",
    )

    ue_60_0_142 = VocabularyTerm(
        code="UE_60_0_142",
        label="UE/60/0/142",
        description="""UE/60/0/142""",
    )

    ue_60_0_142d = VocabularyTerm(
        code="UE_60_0_142D",
        label="UE/60/0/142D",
        description="""UE/60/0/142D""",
    )

    ue_60_0_142h = VocabularyTerm(
        code="UE_60_0_142H",
        label="UE/60/0/142H",
        description="""UE/60/0/142H""",
    )

    ue_60_0_143 = VocabularyTerm(
        code="UE_60_0_143",
        label="UE/60/0/143",
        description="""UE/60/0/143""",
    )

    ue_60_0_146 = VocabularyTerm(
        code="UE_60_0_146",
        label="UE/60/0/146",
        description="""UE/60/0/146""",
    )

    ue_60_0_147 = VocabularyTerm(
        code="UE_60_0_147",
        label="UE/60/0/147",
        description="""UE/60/0/147""",
    )

    ue_60_0_148 = VocabularyTerm(
        code="UE_60_0_148",
        label="UE/60/0/148",
        description="""UE/60/0/148""",
    )

    ue_60_0_148f = VocabularyTerm(
        code="UE_60_0_148F",
        label="UE/60/0/148F",
        description="""UE/60/0/148F""",
    )

    ue_60_0_150 = VocabularyTerm(
        code="UE_60_0_150",
        label="UE/60/0/150",
        description="""UE/60/0/150""",
    )

    ue_60_0_151 = VocabularyTerm(
        code="UE_60_0_151",
        label="UE/60/0/151",
        description="""UE/60/0/151""",
    )

    ue_60_0_152 = VocabularyTerm(
        code="UE_60_0_152",
        label="UE/60/0/152",
        description="""UE/60/0/152""",
    )

    ue_60_0_153 = VocabularyTerm(
        code="UE_60_0_153",
        label="UE/60/0/153",
        description="""UE/60/0/153""",
    )

    ue_60_0_154 = VocabularyTerm(
        code="UE_60_0_154",
        label="UE/60/0/154",
        description="""UE/60/0/154""",
    )

    ue_60_0_154f = VocabularyTerm(
        code="UE_60_0_154F",
        label="UE/60/0/154F",
        description="""UE/60/0/154F""",
    )

    ue_60_0_155 = VocabularyTerm(
        code="UE_60_0_155",
        label="UE/60/0/155",
        description="""UE/60/0/155""",
    )

    ue_60_0_156 = VocabularyTerm(
        code="UE_60_0_156",
        label="UE/60/0/156",
        description="""UE/60/0/156""",
    )

    ue_60_0_160 = VocabularyTerm(
        code="UE_60_0_160",
        label="UE/60/0/160",
        description="""UE/60/0/160""",
    )

    ue_60_0_163 = VocabularyTerm(
        code="UE_60_0_163",
        label="UE/60/0/163",
        description="""UE/60/0/163""",
    )

    ue_60_0_164 = VocabularyTerm(
        code="UE_60_0_164",
        label="UE/60/0/164",
        description="""UE/60/0/164""",
    )

    ue_60_0_165 = VocabularyTerm(
        code="UE_60_0_165",
        label="UE/60/0/165",
        description="""UE/60/0/165""",
    )

    ue_60_0_169 = VocabularyTerm(
        code="UE_60_0_169",
        label="UE/60/0/169",
        description="""UE/60/0/169""",
    )

    ue_60_0_170f = VocabularyTerm(
        code="UE_60_0_170F",
        label="UE/60/0/170F",
        description="""UE/60/0/170F""",
    )

    ue_60_0_171f = VocabularyTerm(
        code="UE_60_0_171F",
        label="UE/60/0/171F",
        description="""UE/60/0/171F""",
    )

    ue_60_0_172 = VocabularyTerm(
        code="UE_60_0_172",
        label="UE/60/0/172",
        description="""UE/60/0/172""",
    )

    ue_60_0_173 = VocabularyTerm(
        code="UE_60_0_173",
        label="UE/60/0/173",
        description="""UE/60/0/173""",
    )

    ue_60_0_174 = VocabularyTerm(
        code="UE_60_0_174",
        label="UE/60/0/174",
        description="""UE/60/0/174""",
    )

    ue_60_0_176 = VocabularyTerm(
        code="UE_60_0_176",
        label="UE/60/0/176",
        description="""UE/60/0/176""",
    )

    ue_60_0_177 = VocabularyTerm(
        code="UE_60_0_177",
        label="UE/60/0/177",
        description="""UE/60/0/177""",
    )

    ue_60_0_177b = VocabularyTerm(
        code="UE_60_0_177B",
        label="UE/60/0/177B",
        description="""UE/60/0/177B""",
    )

    ue_60_0_178 = VocabularyTerm(
        code="UE_60_0_178",
        label="UE/60/0/178",
        description="""UE/60/0/178""",
    )

    ue_60_0_178b = VocabularyTerm(
        code="UE_60_0_178B",
        label="UE/60/0/178B",
        description="""UE/60/0/178B""",
    )

    ue_60_0_179 = VocabularyTerm(
        code="UE_60_0_179",
        label="UE/60/0/179",
        description="""UE/60/0/179""",
    )

    ue_60_0_179b = VocabularyTerm(
        code="UE_60_0_179B",
        label="UE/60/0/179B",
        description="""UE/60/0/179B""",
    )

    ue_60_0_180 = VocabularyTerm(
        code="UE_60_0_180",
        label="UE/60/0/180",
        description="""UE/60/0/180""",
    )

    ue_60_0_181f = VocabularyTerm(
        code="UE_60_0_181F",
        label="UE/60/0/181F",
        description="""UE/60/0/181F""",
    )

    ue_60_0_182 = VocabularyTerm(
        code="UE_60_0_182",
        label="UE/60/0/182",
        description="""UE/60/0/182""",
    )

    ue_60_0_183t = VocabularyTerm(
        code="UE_60_0_183T",
        label="UE/60/0/183T",
        description="""UE/60/0/183T""",
    )

    ue_60_0_186 = VocabularyTerm(
        code="UE_60_0_186",
        label="UE/60/0/186",
        description="""UE/60/0/186""",
    )

    ue_60_0_187 = VocabularyTerm(
        code="UE_60_0_187",
        label="UE/60/0/187",
        description="""UE/60/0/187""",
    )

    ue_60_0_188 = VocabularyTerm(
        code="UE_60_0_188",
        label="UE/60/0/188",
        description="""UE/60/0/188""",
    )

    ue_60_0_190 = VocabularyTerm(
        code="UE_60_0_190",
        label="UE/60/0/190",
        description="""UE/60/0/190""",
    )

    ue_60_0_191 = VocabularyTerm(
        code="UE_60_0_191",
        label="UE/60/0/191",
        description="""UE/60/0/191""",
    )

    ue_60_0_192 = VocabularyTerm(
        code="UE_60_0_192",
        label="UE/60/0/192",
        description="""UE/60/0/192""",
    )

    ue_60_0_193 = VocabularyTerm(
        code="UE_60_0_193",
        label="UE/60/0/193",
        description="""UE/60/0/193""",
    )

    ue_60_0_195 = VocabularyTerm(
        code="UE_60_0_195",
        label="UE/60/0/195",
        description="""UE/60/0/195""",
    )

    ue_60_0_196 = VocabularyTerm(
        code="UE_60_0_196",
        label="UE/60/0/196",
        description="""UE/60/0/196""",
    )

    ue_60_0_197 = VocabularyTerm(
        code="UE_60_0_197",
        label="UE/60/0/197",
        description="""UE/60/0/197""",
    )

    ue_60_0_198 = VocabularyTerm(
        code="UE_60_0_198",
        label="UE/60/0/198",
        description="""UE/60/0/198""",
    )

    ue_60_0_a1 = VocabularyTerm(
        code="UE_60_0_A1",
        label="UE/60/0/A1",
        description="""UE/60/0/A1""",
    )

    ue_60_0_a2 = VocabularyTerm(
        code="UE_60_0_A2",
        label="UE/60/0/A2",
        description="""UE/60/0/A2""",
    )

    ue_60_0_a3 = VocabularyTerm(
        code="UE_60_0_A3",
        label="UE/60/0/A3",
        description="""UE/60/0/A3""",
    )

    ue_60_1_200 = VocabularyTerm(
        code="UE_60_1_200",
        label="UE/60/1/200",
        description="""UE/60/1/200""",
    )

    ue_60_1_201 = VocabularyTerm(
        code="UE_60_1_201",
        label="UE/60/1/201",
        description="""UE/60/1/201""",
    )

    ue_60_1_203 = VocabularyTerm(
        code="UE_60_1_203",
        label="UE/60/1/203",
        description="""UE/60/1/203""",
    )

    ue_60_1_204 = VocabularyTerm(
        code="UE_60_1_204",
        label="UE/60/1/204",
        description="""UE/60/1/204""",
    )

    ue_60_1_205 = VocabularyTerm(
        code="UE_60_1_205",
        label="UE/60/1/205",
        description="""UE/60/1/205""",
    )

    ue_60_1_206 = VocabularyTerm(
        code="UE_60_1_206",
        label="UE/60/1/206",
        description="""UE/60/1/206""",
    )

    ue_60_1_207 = VocabularyTerm(
        code="UE_60_1_207",
        label="UE/60/1/207",
        description="""UE/60/1/207""",
    )

    ue_60_1_208 = VocabularyTerm(
        code="UE_60_1_208",
        label="UE/60/1/208",
        description="""UE/60/1/208""",
    )

    ue_60_1_209f = VocabularyTerm(
        code="UE_60_1_209F",
        label="UE/60/1/209F",
        description="""UE/60/1/209F""",
    )

    ue_60_1_209t = VocabularyTerm(
        code="UE_60_1_209T",
        label="UE/60/1/209T",
        description="""UE/60/1/209T""",
    )

    ue_60_1_212 = VocabularyTerm(
        code="UE_60_1_212",
        label="UE/60/1/212",
        description="""UE/60/1/212""",
    )

    ue_60_1_213 = VocabularyTerm(
        code="UE_60_1_213",
        label="UE/60/1/213",
        description="""UE/60/1/213""",
    )

    ue_60_1_214 = VocabularyTerm(
        code="UE_60_1_214",
        label="UE/60/1/214",
        description="""UE/60/1/214""",
    )

    ue_60_1_215 = VocabularyTerm(
        code="UE_60_1_215",
        label="UE/60/1/215",
        description="""UE/60/1/215""",
    )

    ue_60_1_216 = VocabularyTerm(
        code="UE_60_1_216",
        label="UE/60/1/216",
        description="""UE/60/1/216""",
    )

    ue_60_1_217 = VocabularyTerm(
        code="UE_60_1_217",
        label="UE/60/1/217",
        description="""UE/60/1/217""",
    )

    ue_60_1_218 = VocabularyTerm(
        code="UE_60_1_218",
        label="UE/60/1/218",
        description="""UE/60/1/218""",
    )

    ue_60_1_219 = VocabularyTerm(
        code="UE_60_1_219",
        label="UE/60/1/219",
        description="""UE/60/1/219""",
    )

    ue_60_1_220f = VocabularyTerm(
        code="UE_60_1_220F",
        label="UE/60/1/220F",
        description="""UE/60/1/220F""",
    )

    ue_60_1_220t = VocabularyTerm(
        code="UE_60_1_220T",
        label="UE/60/1/220T",
        description="""UE/60/1/220T""",
    )

    ue_60_1_221 = VocabularyTerm(
        code="UE_60_1_221",
        label="UE/60/1/221",
        description="""UE/60/1/221""",
    )

    ue_60_1_222b = VocabularyTerm(
        code="UE_60_1_222B",
        label="UE/60/1/222B",
        description="""UE/60/1/222B""",
    )

    ue_60_1_222d = VocabularyTerm(
        code="UE_60_1_222D",
        label="UE/60/1/222D",
        description="""UE/60/1/222D""",
    )

    ue_60_1_222h = VocabularyTerm(
        code="UE_60_1_222H",
        label="UE/60/1/222H",
        description="""UE/60/1/222H""",
    )

    ue_60_1_224 = VocabularyTerm(
        code="UE_60_1_224",
        label="UE/60/1/224",
        description="""UE/60/1/224""",
    )

    ue_60_1_225 = VocabularyTerm(
        code="UE_60_1_225",
        label="UE/60/1/225",
        description="""UE/60/1/225""",
    )

    ue_60_1_226 = VocabularyTerm(
        code="UE_60_1_226",
        label="UE/60/1/226",
        description="""UE/60/1/226""",
    )

    ue_60_1_227 = VocabularyTerm(
        code="UE_60_1_227",
        label="UE/60/1/227",
        description="""UE/60/1/227""",
    )

    ue_60_1_228 = VocabularyTerm(
        code="UE_60_1_228",
        label="UE/60/1/228",
        description="""UE/60/1/228""",
    )

    ue_60_1_229 = VocabularyTerm(
        code="UE_60_1_229",
        label="UE/60/1/229",
        description="""UE/60/1/229""",
    )

    ue_60_1_231 = VocabularyTerm(
        code="UE_60_1_231",
        label="UE/60/1/231",
        description="""UE/60/1/231""",
    )

    ue_60_1_232 = VocabularyTerm(
        code="UE_60_1_232",
        label="UE/60/1/232",
        description="""UE/60/1/232""",
    )

    ue_60_1_235 = VocabularyTerm(
        code="UE_60_1_235",
        label="UE/60/1/235",
        description="""UE/60/1/235""",
    )

    ue_60_1_236 = VocabularyTerm(
        code="UE_60_1_236",
        label="UE/60/1/236",
        description="""UE/60/1/236""",
    )

    ue_60_1_237 = VocabularyTerm(
        code="UE_60_1_237",
        label="UE/60/1/237",
        description="""UE/60/1/237""",
    )

    ue_60_1_239 = VocabularyTerm(
        code="UE_60_1_239",
        label="UE/60/1/239",
        description="""UE/60/1/239""",
    )

    ue_60_1_240f = VocabularyTerm(
        code="UE_60_1_240F",
        label="UE/60/1/240F",
        description="""UE/60/1/240F""",
    )

    ue_60_1_240t = VocabularyTerm(
        code="UE_60_1_240T",
        label="UE/60/1/240T",
        description="""UE/60/1/240T""",
    )

    ue_60_1_241 = VocabularyTerm(
        code="UE_60_1_241",
        label="UE/60/1/241",
        description="""UE/60/1/241""",
    )

    ue_60_1_242 = VocabularyTerm(
        code="UE_60_1_242",
        label="UE/60/1/242",
        description="""UE/60/1/242""",
    )

    ue_60_1_243 = VocabularyTerm(
        code="UE_60_1_243",
        label="UE/60/1/243",
        description="""UE/60/1/243""",
    )

    ue_60_1_265 = VocabularyTerm(
        code="UE_60_1_265",
        label="UE/60/1/265",
        description="""UE/60/1/265""",
    )

    ue_60_1_269 = VocabularyTerm(
        code="UE_60_1_269",
        label="UE/60/1/269",
        description="""UE/60/1/269""",
    )

    ue_60_1_276a = VocabularyTerm(
        code="UE_60_1_276A",
        label="UE/60/1/276A",
        description="""UE/60/1/276A""",
    )

    ue_60_1_279 = VocabularyTerm(
        code="UE_60_1_279",
        label="UE/60/1/279",
        description="""UE/60/1/279""",
    )

    ue_60_1_283t = VocabularyTerm(
        code="UE_60_1_283T",
        label="UE/60/1/283T",
        description="""UE/60/1/283T""",
    )

    ue_60_1_290 = VocabularyTerm(
        code="UE_60_1_290",
        label="UE/60/1/290",
        description="""UE/60/1/290""",
    )

    ue_60_1_291 = VocabularyTerm(
        code="UE_60_1_291",
        label="UE/60/1/291",
        description="""UE/60/1/291""",
    )

    ue_60_1_292 = VocabularyTerm(
        code="UE_60_1_292",
        label="UE/60/1/292",
        description="""UE/60/1/292""",
    )

    ue_60_1_293 = VocabularyTerm(
        code="UE_60_1_293",
        label="UE/60/1/293",
        description="""UE/60/1/293""",
    )

    ue_60_1_294 = VocabularyTerm(
        code="UE_60_1_294",
        label="UE/60/1/294",
        description="""UE/60/1/294""",
    )

    ue_60_1_295 = VocabularyTerm(
        code="UE_60_1_295",
        label="UE/60/1/295",
        description="""UE/60/1/295""",
    )

    ue_60_1_296 = VocabularyTerm(
        code="UE_60_1_296",
        label="UE/60/1/296",
        description="""UE/60/1/296""",
    )

    ue_60_1_297 = VocabularyTerm(
        code="UE_60_1_297",
        label="UE/60/1/297",
        description="""UE/60/1/297""",
    )

    ue_60_1_a1 = VocabularyTerm(
        code="UE_60_1_A1",
        label="UE/60/1/A1",
        description="""UE/60/1/A1""",
    )

    ue_60_1_a2 = VocabularyTerm(
        code="UE_60_1_A2",
        label="UE/60/1/A2",
        description="""UE/60/1/A2""",
    )

    ue_60_1_a3 = VocabularyTerm(
        code="UE_60_1_A3",
        label="UE/60/1/A3",
        description="""UE/60/1/A3""",
    )

    ue_60_2_300 = VocabularyTerm(
        code="UE_60_2_300",
        label="UE/60/2/300",
        description="""UE/60/2/300""",
    )

    ue_60_2_301 = VocabularyTerm(
        code="UE_60_2_301",
        label="UE/60/2/301",
        description="""UE/60/2/301""",
    )

    ue_60_2_302 = VocabularyTerm(
        code="UE_60_2_302",
        label="UE/60/2/302",
        description="""UE/60/2/302""",
    )

    ue_60_2_303 = VocabularyTerm(
        code="UE_60_2_303",
        label="UE/60/2/303",
        description="""UE/60/2/303""",
    )

    ue_60_2_304 = VocabularyTerm(
        code="UE_60_2_304",
        label="UE/60/2/304",
        description="""UE/60/2/304""",
    )

    ue_60_2_305 = VocabularyTerm(
        code="UE_60_2_305",
        label="UE/60/2/305",
        description="""UE/60/2/305""",
    )

    ue_60_2_306 = VocabularyTerm(
        code="UE_60_2_306",
        label="UE/60/2/306",
        description="""UE/60/2/306""",
    )

    ue_60_2_307 = VocabularyTerm(
        code="UE_60_2_307",
        label="UE/60/2/307",
        description="""UE/60/2/307""",
    )

    ue_60_2_308 = VocabularyTerm(
        code="UE_60_2_308",
        label="UE/60/2/308",
        description="""UE/60/2/308""",
    )

    ue_60_2_309t = VocabularyTerm(
        code="UE_60_2_309T",
        label="UE/60/2/309T",
        description="""UE/60/2/309T""",
    )

    ue_60_2_310 = VocabularyTerm(
        code="UE_60_2_310",
        label="UE/60/2/310",
        description="""UE/60/2/310""",
    )

    ue_60_2_312 = VocabularyTerm(
        code="UE_60_2_312",
        label="UE/60/2/312",
        description="""UE/60/2/312""",
    )

    ue_60_2_313 = VocabularyTerm(
        code="UE_60_2_313",
        label="UE/60/2/313",
        description="""UE/60/2/313""",
    )

    ue_60_2_314 = VocabularyTerm(
        code="UE_60_2_314",
        label="UE/60/2/314",
        description="""UE/60/2/314""",
    )

    ue_60_2_315 = VocabularyTerm(
        code="UE_60_2_315",
        label="UE/60/2/315",
        description="""UE/60/2/315""",
    )

    ue_60_2_316 = VocabularyTerm(
        code="UE_60_2_316",
        label="UE/60/2/316",
        description="""UE/60/2/316""",
    )

    ue_60_2_318 = VocabularyTerm(
        code="UE_60_2_318",
        label="UE/60/2/318",
        description="""UE/60/2/318""",
    )

    ue_60_2_319 = VocabularyTerm(
        code="UE_60_2_319",
        label="UE/60/2/319",
        description="""UE/60/2/319""",
    )

    ue_60_2_320f = VocabularyTerm(
        code="UE_60_2_320F",
        label="UE/60/2/320F",
        description="""UE/60/2/320F""",
    )

    ue_60_2_320t = VocabularyTerm(
        code="UE_60_2_320T",
        label="UE/60/2/320T",
        description="""UE/60/2/320T""",
    )

    ue_60_2_321 = VocabularyTerm(
        code="UE_60_2_321",
        label="UE/60/2/321",
        description="""UE/60/2/321""",
    )

    ue_60_2_322d = VocabularyTerm(
        code="UE_60_2_322D",
        label="UE/60/2/322D",
        description="""UE/60/2/322D""",
    )

    ue_60_2_322h = VocabularyTerm(
        code="UE_60_2_322H",
        label="UE/60/2/322H",
        description="""UE/60/2/322H""",
    )

    ue_60_2_323 = VocabularyTerm(
        code="UE_60_2_323",
        label="UE/60/2/323",
        description="""UE/60/2/323""",
    )

    ue_60_2_324 = VocabularyTerm(
        code="UE_60_2_324",
        label="UE/60/2/324",
        description="""UE/60/2/324""",
    )

    ue_60_2_325 = VocabularyTerm(
        code="UE_60_2_325",
        label="UE/60/2/325",
        description="""UE/60/2/325""",
    )

    ue_60_2_326 = VocabularyTerm(
        code="UE_60_2_326",
        label="UE/60/2/326",
        description="""UE/60/2/326""",
    )

    ue_60_2_327 = VocabularyTerm(
        code="UE_60_2_327",
        label="UE/60/2/327",
        description="""UE/60/2/327""",
    )

    ue_60_2_328 = VocabularyTerm(
        code="UE_60_2_328",
        label="UE/60/2/328",
        description="""UE/60/2/328""",
    )

    ue_60_2_329 = VocabularyTerm(
        code="UE_60_2_329",
        label="UE/60/2/329",
        description="""UE/60/2/329""",
    )

    ue_60_2_330 = VocabularyTerm(
        code="UE_60_2_330",
        label="UE/60/2/330",
        description="""UE/60/2/330""",
    )

    ue_60_2_331 = VocabularyTerm(
        code="UE_60_2_331",
        label="UE/60/2/331",
        description="""UE/60/2/331""",
    )

    ue_60_2_332 = VocabularyTerm(
        code="UE_60_2_332",
        label="UE/60/2/332",
        description="""UE/60/2/332""",
    )

    ue_60_2_333 = VocabularyTerm(
        code="UE_60_2_333",
        label="UE/60/2/333",
        description="""UE/60/2/333""",
    )

    ue_60_2_335 = VocabularyTerm(
        code="UE_60_2_335",
        label="UE/60/2/335",
        description="""UE/60/2/335""",
    )

    ue_60_2_336 = VocabularyTerm(
        code="UE_60_2_336",
        label="UE/60/2/336",
        description="""UE/60/2/336""",
    )

    ue_60_2_339 = VocabularyTerm(
        code="UE_60_2_339",
        label="UE/60/2/339",
        description="""UE/60/2/339""",
    )

    ue_60_2_340f = VocabularyTerm(
        code="UE_60_2_340F",
        label="UE/60/2/340F",
        description="""UE/60/2/340F""",
    )

    ue_60_2_340t = VocabularyTerm(
        code="UE_60_2_340T",
        label="UE/60/2/340T",
        description="""UE/60/2/340T""",
    )

    ue_60_2_341 = VocabularyTerm(
        code="UE_60_2_341",
        label="UE/60/2/341",
        description="""UE/60/2/341""",
    )

    ue_60_2_342 = VocabularyTerm(
        code="UE_60_2_342",
        label="UE/60/2/342",
        description="""UE/60/2/342""",
    )

    ue_60_2_342d = VocabularyTerm(
        code="UE_60_2_342D",
        label="UE/60/2/342D",
        description="""UE/60/2/342D""",
    )

    ue_60_2_342h = VocabularyTerm(
        code="UE_60_2_342H",
        label="UE/60/2/342H",
        description="""UE/60/2/342H""",
    )

    ue_60_2_343 = VocabularyTerm(
        code="UE_60_2_343",
        label="UE/60/2/343",
        description="""UE/60/2/343""",
    )

    ue_60_2_390 = VocabularyTerm(
        code="UE_60_2_390",
        label="UE/60/2/390",
        description="""UE/60/2/390""",
    )

    ue_60_2_390b = VocabularyTerm(
        code="UE_60_2_390B",
        label="UE/60/2/390B",
        description="""UE/60/2/390B""",
    )

    ue_60_2_390f = VocabularyTerm(
        code="UE_60_2_390F",
        label="UE/60/2/390F",
        description="""UE/60/2/390F""",
    )

    ue_60_2_391 = VocabularyTerm(
        code="UE_60_2_391",
        label="UE/60/2/391",
        description="""UE/60/2/391""",
    )

    ue_60_2_392 = VocabularyTerm(
        code="UE_60_2_392",
        label="UE/60/2/392",
        description="""UE/60/2/392""",
    )

    ue_60_2_393 = VocabularyTerm(
        code="UE_60_2_393",
        label="UE/60/2/393",
        description="""UE/60/2/393""",
    )

    ue_60_2_394 = VocabularyTerm(
        code="UE_60_2_394",
        label="UE/60/2/394",
        description="""UE/60/2/394""",
    )

    ue_60_2_395 = VocabularyTerm(
        code="UE_60_2_395",
        label="UE/60/2/395",
        description="""UE/60/2/395""",
    )

    ue_60_2_396 = VocabularyTerm(
        code="UE_60_2_396",
        label="UE/60/2/396",
        description="""UE/60/2/396""",
    )

    ue_60_2_397 = VocabularyTerm(
        code="UE_60_2_397",
        label="UE/60/2/397",
        description="""UE/60/2/397""",
    )

    ue_60_2_a1 = VocabularyTerm(
        code="UE_60_2_A1",
        label="UE/60/2/A1",
        description="""UE/60/2/A1""",
    )

    ue_60_2_a2 = VocabularyTerm(
        code="UE_60_2_A2",
        label="UE/60/2/A2",
        description="""UE/60/2/A2""",
    )

    ue_60_3_409 = VocabularyTerm(
        code="UE_60_3_409",
        label="UE/60/3/409",
        description="""UE/60/3/409""",
    )

    ue_60_3_413 = VocabularyTerm(
        code="UE_60_3_413",
        label="UE/60/3/413",
        description="""UE/60/3/413""",
    )

    ue_60_3_420t = VocabularyTerm(
        code="UE_60_3_420T",
        label="UE/60/3/420T",
        description="""UE/60/3/420T""",
    )

    ue_60_3_425 = VocabularyTerm(
        code="UE_60_3_425",
        label="UE/60/3/425",
        description="""UE/60/3/425""",
    )

    ue_60_3_440 = VocabularyTerm(
        code="UE_60_3_440",
        label="UE/60/3/440",
        description="""UE/60/3/440""",
    )

    ue_60_3_490 = VocabularyTerm(
        code="UE_60_3_490",
        label="UE/60/3/490",
        description="""UE/60/3/490""",
    )

    ue_60__1_001 = VocabularyTerm(
        code="UE_60_-1_001",
        label="UE/60/-1/001",
        description="""UE/60/-1/001""",
    )

    ue_60__1_002 = VocabularyTerm(
        code="UE_60_-1_002",
        label="UE/60/-1/002",
        description="""UE/60/-1/002""",
    )

    ue_60__1_003 = VocabularyTerm(
        code="UE_60_-1_003",
        label="UE/60/-1/003",
        description="""UE/60/-1/003""",
    )

    ue_60__1_004 = VocabularyTerm(
        code="UE_60_-1_004",
        label="UE/60/-1/004",
        description="""UE/60/-1/004""",
    )

    ue_60__1_004f = VocabularyTerm(
        code="UE_60_-1_004F",
        label="UE/60/-1/004F",
        description="""UE/60/-1/004F""",
    )

    ue_60__1_005 = VocabularyTerm(
        code="UE_60_-1_005",
        label="UE/60/-1/005",
        description="""UE/60/-1/005""",
    )

    ue_60__1_007 = VocabularyTerm(
        code="UE_60_-1_007",
        label="UE/60/-1/007",
        description="""UE/60/-1/007""",
    )

    ue_60__1_008 = VocabularyTerm(
        code="UE_60_-1_008",
        label="UE/60/-1/008",
        description="""UE/60/-1/008""",
    )

    ue_60__1_009f = VocabularyTerm(
        code="UE_60_-1_009F",
        label="UE/60/-1/009F",
        description="""UE/60/-1/009F""",
    )

    ue_60__1_009t = VocabularyTerm(
        code="UE_60_-1_009T",
        label="UE/60/-1/009T",
        description="""UE/60/-1/009T""",
    )

    ue_60__1_010 = VocabularyTerm(
        code="UE_60_-1_010",
        label="UE/60/-1/010",
        description="""UE/60/-1/010""",
    )

    ue_60__1_012 = VocabularyTerm(
        code="UE_60_-1_012",
        label="UE/60/-1/012",
        description="""UE/60/-1/012""",
    )

    ue_60__1_014 = VocabularyTerm(
        code="UE_60_-1_014",
        label="UE/60/-1/014",
        description="""UE/60/-1/014""",
    )

    ue_60__1_015 = VocabularyTerm(
        code="UE_60_-1_015",
        label="UE/60/-1/015",
        description="""UE/60/-1/015""",
    )

    ue_60__1_016 = VocabularyTerm(
        code="UE_60_-1_016",
        label="UE/60/-1/016",
        description="""UE/60/-1/016""",
    )

    ue_60__1_017 = VocabularyTerm(
        code="UE_60_-1_017",
        label="UE/60/-1/017",
        description="""UE/60/-1/017""",
    )

    ue_60__1_018f = VocabularyTerm(
        code="UE_60_-1_018F",
        label="UE/60/-1/018F",
        description="""UE/60/-1/018F""",
    )

    ue_60__1_020t = VocabularyTerm(
        code="UE_60_-1_020T",
        label="UE/60/-1/020T",
        description="""UE/60/-1/020T""",
    )

    ue_60__1_021 = VocabularyTerm(
        code="UE_60_-1_021",
        label="UE/60/-1/021",
        description="""UE/60/-1/021""",
    )

    ue_60__1_022 = VocabularyTerm(
        code="UE_60_-1_022",
        label="UE/60/-1/022",
        description="""UE/60/-1/022""",
    )

    ue_60__1_025 = VocabularyTerm(
        code="UE_60_-1_025",
        label="UE/60/-1/025",
        description="""UE/60/-1/025""",
    )

    ue_60__1_026 = VocabularyTerm(
        code="UE_60_-1_026",
        label="UE/60/-1/026",
        description="""UE/60/-1/026""",
    )

    ue_60__1_030 = VocabularyTerm(
        code="UE_60_-1_030",
        label="UE/60/-1/030",
        description="""UE/60/-1/030""",
    )

    ue_60__1_031 = VocabularyTerm(
        code="UE_60_-1_031",
        label="UE/60/-1/031",
        description="""UE/60/-1/031""",
    )

    ue_60__1_034 = VocabularyTerm(
        code="UE_60_-1_034",
        label="UE/60/-1/034",
        description="""UE/60/-1/034""",
    )

    ue_60__1_035 = VocabularyTerm(
        code="UE_60_-1_035",
        label="UE/60/-1/035",
        description="""UE/60/-1/035""",
    )

    ue_60__1_036 = VocabularyTerm(
        code="UE_60_-1_036",
        label="UE/60/-1/036",
        description="""UE/60/-1/036""",
    )

    ue_60__1_039 = VocabularyTerm(
        code="UE_60_-1_039",
        label="UE/60/-1/039",
        description="""UE/60/-1/039""",
    )

    ue_60__1_040f = VocabularyTerm(
        code="UE_60_-1_040F",
        label="UE/60/-1/040F",
        description="""UE/60/-1/040F""",
    )

    ue_60__1_040t = VocabularyTerm(
        code="UE_60_-1_040T",
        label="UE/60/-1/040T",
        description="""UE/60/-1/040T""",
    )

    ue_60__1_042 = VocabularyTerm(
        code="UE_60_-1_042",
        label="UE/60/-1/042",
        description="""UE/60/-1/042""",
    )

    ue_60__1_046 = VocabularyTerm(
        code="UE_60_-1_046",
        label="UE/60/-1/046",
        description="""UE/60/-1/046""",
    )

    ue_60__1_047 = VocabularyTerm(
        code="UE_60_-1_047",
        label="UE/60/-1/047",
        description="""UE/60/-1/047""",
    )

    ue_60__1_048 = VocabularyTerm(
        code="UE_60_-1_048",
        label="UE/60/-1/048",
        description="""UE/60/-1/048""",
    )

    ue_60__1_048f = VocabularyTerm(
        code="UE_60_-1_048F",
        label="UE/60/-1/048F",
        description="""UE/60/-1/048F""",
    )

    ue_60__1_050 = VocabularyTerm(
        code="UE_60_-1_050",
        label="UE/60/-1/050",
        description="""UE/60/-1/050""",
    )

    ue_60__1_051 = VocabularyTerm(
        code="UE_60_-1_051",
        label="UE/60/-1/051",
        description="""UE/60/-1/051""",
    )

    ue_60__1_052 = VocabularyTerm(
        code="UE_60_-1_052",
        label="UE/60/-1/052",
        description="""UE/60/-1/052""",
    )

    ue_60__1_053 = VocabularyTerm(
        code="UE_60_-1_053",
        label="UE/60/-1/053",
        description="""UE/60/-1/053""",
    )

    ue_60__1_054 = VocabularyTerm(
        code="UE_60_-1_054",
        label="UE/60/-1/054",
        description="""UE/60/-1/054""",
    )

    ue_60__1_055 = VocabularyTerm(
        code="UE_60_-1_055",
        label="UE/60/-1/055",
        description="""UE/60/-1/055""",
    )

    ue_60__1_060 = VocabularyTerm(
        code="UE_60_-1_060",
        label="UE/60/-1/060",
        description="""UE/60/-1/060""",
    )

    ue_60__1_063 = VocabularyTerm(
        code="UE_60_-1_063",
        label="UE/60/-1/063",
        description="""UE/60/-1/063""",
    )

    ue_60__1_064 = VocabularyTerm(
        code="UE_60_-1_064",
        label="UE/60/-1/064",
        description="""UE/60/-1/064""",
    )

    ue_60__1_065 = VocabularyTerm(
        code="UE_60_-1_065",
        label="UE/60/-1/065",
        description="""UE/60/-1/065""",
    )

    ue_60__1_065f = VocabularyTerm(
        code="UE_60_-1_065F",
        label="UE/60/-1/065F",
        description="""UE/60/-1/065F""",
    )

    ue_60__1_069 = VocabularyTerm(
        code="UE_60_-1_069",
        label="UE/60/-1/069",
        description="""UE/60/-1/069""",
    )

    ue_60__1_070 = VocabularyTerm(
        code="UE_60_-1_070",
        label="UE/60/-1/070",
        description="""UE/60/-1/070""",
    )

    ue_60__1_070f = VocabularyTerm(
        code="UE_60_-1_070F",
        label="UE/60/-1/070F",
        description="""UE/60/-1/070F""",
    )

    ue_60__1_071 = VocabularyTerm(
        code="UE_60_-1_071",
        label="UE/60/-1/071",
        description="""UE/60/-1/071""",
    )

    ue_60__1_071f = VocabularyTerm(
        code="UE_60_-1_071F",
        label="UE/60/-1/071F",
        description="""UE/60/-1/071F""",
    )

    ue_60__1_071t = VocabularyTerm(
        code="UE_60_-1_071T",
        label="UE/60/-1/071T",
        description="""UE/60/-1/071T""",
    )

    ue_60__1_073 = VocabularyTerm(
        code="UE_60_-1_073",
        label="UE/60/-1/073",
        description="""UE/60/-1/073""",
    )

    ue_60__1_073b = VocabularyTerm(
        code="UE_60_-1_073B",
        label="UE/60/-1/073B",
        description="""UE/60/-1/073B""",
    )

    ue_60__1_074 = VocabularyTerm(
        code="UE_60_-1_074",
        label="UE/60/-1/074",
        description="""UE/60/-1/074""",
    )

    ue_60__1_090 = VocabularyTerm(
        code="UE_60_-1_090",
        label="UE/60/-1/090",
        description="""UE/60/-1/090""",
    )

    ue_60__1_090f = VocabularyTerm(
        code="UE_60_-1_090F",
        label="UE/60/-1/090F",
        description="""UE/60/-1/090F""",
    )

    ue_60__1_091 = VocabularyTerm(
        code="UE_60_-1_091",
        label="UE/60/-1/091",
        description="""UE/60/-1/091""",
    )

    ue_60__1_096 = VocabularyTerm(
        code="UE_60_-1_096",
        label="UE/60/-1/096",
        description="""UE/60/-1/096""",
    )

    ue_60__1_096b = VocabularyTerm(
        code="UE_60_-1_096B",
        label="UE/60/-1/096B",
        description="""UE/60/-1/096B""",
    )

    ue_60__1_096f = VocabularyTerm(
        code="UE_60_-1_096F",
        label="UE/60/-1/096F",
        description="""UE/60/-1/096F""",
    )

    ue_60__1_097 = VocabularyTerm(
        code="UE_60_-1_097",
        label="UE/60/-1/097",
        description="""UE/60/-1/097""",
    )

    ue_60__1_a1 = VocabularyTerm(
        code="UE_60_-1_A1",
        label="UE/60/-1/A1",
        description="""UE/60/-1/A1""",
    )

    ue_60__1_a2 = VocabularyTerm(
        code="UE_60_-1_A2",
        label="UE/60/-1/A2",
        description="""UE/60/-1/A2""",
    )

    ue_60__2_0054t = VocabularyTerm(
        code="UE_60_-2_0054T",
        label="UE/60/-2/0054T",
        description="""UE/60/-2/0054T""",
    )

    ue_60__2_0079 = VocabularyTerm(
        code="UE_60_-2_0079",
        label="UE/60/-2/0079",
        description="""UE/60/-2/0079""",
    )

    ue_60__2_0080 = VocabularyTerm(
        code="UE_60_-2_0080",
        label="UE/60/-2/0080",
        description="""UE/60/-2/0080""",
    )

    ue_60__2_0080b = VocabularyTerm(
        code="UE_60_-2_0080B",
        label="UE/60/-2/0080B",
        description="""UE/60/-2/0080B""",
    )

    ue_60__2_0081f = VocabularyTerm(
        code="UE_60_-2_0081F",
        label="UE/60/-2/0081F",
        description="""UE/60/-2/0081F""",
    )

    ue_60__2_0082 = VocabularyTerm(
        code="UE_60_-2_0082",
        label="UE/60/-2/0082",
        description="""UE/60/-2/0082""",
    )

    ue_60__2_0083t = VocabularyTerm(
        code="UE_60_-2_0083T",
        label="UE/60/-2/0083T",
        description="""UE/60/-2/0083T""",
    )

    ue_60__2_0084 = VocabularyTerm(
        code="UE_60_-2_0084",
        label="UE/60/-2/0084",
        description="""UE/60/-2/0084""",
    )

    ue_60__2_0086 = VocabularyTerm(
        code="UE_60_-2_0086",
        label="UE/60/-2/0086",
        description="""UE/60/-2/0086""",
    )

    ue_60__2_0087f = VocabularyTerm(
        code="UE_60_-2_0087F",
        label="UE/60/-2/0087F",
        description="""UE/60/-2/0087F""",
    )

    ue_60__2_0087t = VocabularyTerm(
        code="UE_60_-2_0087T",
        label="UE/60/-2/0087T",
        description="""UE/60/-2/0087T""",
    )

    ue_60__2_0088 = VocabularyTerm(
        code="UE_60_-2_0088",
        label="UE/60/-2/0088",
        description="""UE/60/-2/0088""",
    )

    ue_60__2_0089 = VocabularyTerm(
        code="UE_60_-2_0089",
        label="UE/60/-2/0089",
        description="""UE/60/-2/0089""",
    )

    ue_60__2_0091 = VocabularyTerm(
        code="UE_60_-2_0091",
        label="UE/60/-2/0091",
        description="""UE/60/-2/0091""",
    )

    ue_60__2_0093 = VocabularyTerm(
        code="UE_60_-2_0093",
        label="UE/60/-2/0093",
        description="""UE/60/-2/0093""",
    )

    ue_60__2_0094 = VocabularyTerm(
        code="UE_60_-2_0094",
        label="UE/60/-2/0094",
        description="""UE/60/-2/0094""",
    )

    ue_60__2_0094f = VocabularyTerm(
        code="UE_60_-2_0094F",
        label="UE/60/-2/0094F",
        description="""UE/60/-2/0094F""",
    )

    ue_60__2_0096 = VocabularyTerm(
        code="UE_60_-2_0096",
        label="UE/60/-2/0096",
        description="""UE/60/-2/0096""",
    )

    ue_60__2_0098 = VocabularyTerm(
        code="UE_60_-2_0098",
        label="UE/60/-2/0098",
        description="""UE/60/-2/0098""",
    )

    ue_60__2_0098f = VocabularyTerm(
        code="UE_60_-2_0098F",
        label="UE/60/-2/0098F",
        description="""UE/60/-2/0098F""",
    )

    ue_60__2_0098t = VocabularyTerm(
        code="UE_60_-2_0098T",
        label="UE/60/-2/0098T",
        description="""UE/60/-2/0098T""",
    )

    ue_60__2_a3 = VocabularyTerm(
        code="UE_60_-2_A3",
        label="UE/60/-2/A3",
        description="""UE/60/-2/A3""",
    )

    ue_90_0_101 = VocabularyTerm(
        code="UE_90_0_101",
        label="UE/90/0/101",
        description="""UE/90/0/101""",
    )

    ue_90_0_102 = VocabularyTerm(
        code="UE_90_0_102",
        label="UE/90/0/102",
        description="""UE/90/0/102""",
    )

    ue_90_0_103 = VocabularyTerm(
        code="UE_90_0_103",
        label="UE/90/0/103",
        description="""UE/90/0/103""",
    )

    ue_90_0_103f = VocabularyTerm(
        code="UE_90_0_103F",
        label="UE/90/0/103F",
        description="""UE/90/0/103F""",
    )

    ue_90_0_104 = VocabularyTerm(
        code="UE_90_0_104",
        label="UE/90/0/104",
        description="""UE/90/0/104""",
    )

    ue_90_0_105wc = VocabularyTerm(
        code="UE_90_0_105WC",
        label="UE/90/0/105WC",
        description="""UE/90/0/105WC""",
    )

    ue_90__1_003f = VocabularyTerm(
        code="UE_90_-1_003F",
        label="UE/90/-1/003F",
        description="""UE/90/-1/003F""",
    )

    ue_90__1_003t = VocabularyTerm(
        code="UE_90_-1_003T",
        label="UE/90/-1/003T",
        description="""UE/90/-1/003T""",
    )

    ue_91_0_100 = VocabularyTerm(
        code="UE_91_0_100",
        label="UE/91/0/100",
        description="""UE/91/0/100""",
    )

    ue_91_0_100f = VocabularyTerm(
        code="UE_91_0_100F",
        label="UE/91/0/100F",
        description="""UE/91/0/100F""",
    )

    ue_91_0_101 = VocabularyTerm(
        code="UE_91_0_101",
        label="UE/91/0/101",
        description="""UE/91/0/101""",
    )

    ue_91_0_102 = VocabularyTerm(
        code="UE_91_0_102",
        label="UE/91/0/102",
        description="""UE/91/0/102""",
    )

    ue_91_0_102f = VocabularyTerm(
        code="UE_91_0_102F",
        label="UE/91/0/102F",
        description="""UE/91/0/102F""",
    )

    ue_91_0_103 = VocabularyTerm(
        code="UE_91_0_103",
        label="UE/91/0/103",
        description="""UE/91/0/103""",
    )

    ue_91_0_104 = VocabularyTerm(
        code="UE_91_0_104",
        label="UE/91/0/104",
        description="""UE/91/0/104""",
    )

    ue_91_0_104d = VocabularyTerm(
        code="UE_91_0_104D",
        label="UE/91/0/104D",
        description="""UE/91/0/104D""",
    )

    ue_91_0_104f = VocabularyTerm(
        code="UE_91_0_104F",
        label="UE/91/0/104F",
        description="""UE/91/0/104F""",
    )

    ue_91_0_104h = VocabularyTerm(
        code="UE_91_0_104H",
        label="UE/91/0/104H",
        description="""UE/91/0/104H""",
    )

    ue_91_0_105 = VocabularyTerm(
        code="UE_91_0_105",
        label="UE/91/0/105",
        description="""UE/91/0/105""",
    )

    ue_91_0_106 = VocabularyTerm(
        code="UE_91_0_106",
        label="UE/91/0/106",
        description="""UE/91/0/106""",
    )

    ue_91_0_106b = VocabularyTerm(
        code="UE_91_0_106B",
        label="UE/91/0/106B",
        description="""UE/91/0/106B""",
    )

    ue_91_0_107 = VocabularyTerm(
        code="UE_91_0_107",
        label="UE/91/0/107",
        description="""UE/91/0/107""",
    )

    ue_91_0_108 = VocabularyTerm(
        code="UE_91_0_108",
        label="UE/91/0/108",
        description="""UE/91/0/108""",
    )

    ue_91_0_109 = VocabularyTerm(
        code="UE_91_0_109",
        label="UE/91/0/109",
        description="""UE/91/0/109""",
    )

    ue_91_0_110f = VocabularyTerm(
        code="UE_91_0_110F",
        label="UE/91/0/110F",
        description="""UE/91/0/110F""",
    )

    ue_91_0_111 = VocabularyTerm(
        code="UE_91_0_111",
        label="UE/91/0/111",
        description="""UE/91/0/111""",
    )

    ue_91_0_112 = VocabularyTerm(
        code="UE_91_0_112",
        label="UE/91/0/112",
        description="""UE/91/0/112""",
    )

    ue_91_0_112b = VocabularyTerm(
        code="UE_91_0_112B",
        label="UE/91/0/112B",
        description="""UE/91/0/112B""",
    )

    ue_91_0_113 = VocabularyTerm(
        code="UE_91_0_113",
        label="UE/91/0/113",
        description="""UE/91/0/113""",
    )

    ue_91_0_114f = VocabularyTerm(
        code="UE_91_0_114F",
        label="UE/91/0/114F",
        description="""UE/91/0/114F""",
    )

    ue_91_0_115 = VocabularyTerm(
        code="UE_91_0_115",
        label="UE/91/0/115",
        description="""UE/91/0/115""",
    )

    ue_91_0_116f = VocabularyTerm(
        code="UE_91_0_116F",
        label="UE/91/0/116F",
        description="""UE/91/0/116F""",
    )

    ue_91_0_117 = VocabularyTerm(
        code="UE_91_0_117",
        label="UE/91/0/117",
        description="""UE/91/0/117""",
    )

    ue_91_0_117f = VocabularyTerm(
        code="UE_91_0_117F",
        label="UE/91/0/117F",
        description="""UE/91/0/117F""",
    )

    ue_91_0_118wc = VocabularyTerm(
        code="UE_91_0_118WC",
        label="UE/91/0/118WC",
        description="""UE/91/0/118WC""",
    )

    ue_91_0_121 = VocabularyTerm(
        code="UE_91_0_121",
        label="UE/91/0/121",
        description="""UE/91/0/121""",
    )

    ue_92_1_0_102 = VocabularyTerm(
        code="UE_92_1_0_102",
        label="UE/92.1/0/102",
        description="""UE/92.1/0/102""",
    )

    ue_92_1_0_102b = VocabularyTerm(
        code="UE_92_1_0_102B",
        label="UE/92.1/0/102B",
        description="""UE/92.1/0/102B""",
    )

    ue_92_1_0_103 = VocabularyTerm(
        code="UE_92_1_0_103",
        label="UE/92.1/0/103",
        description="""UE/92.1/0/103""",
    )

    ue_92_1_0_103b = VocabularyTerm(
        code="UE_92_1_0_103B",
        label="UE/92.1/0/103B",
        description="""UE/92.1/0/103B""",
    )

    ue_92_2_0_100 = VocabularyTerm(
        code="UE_92_2_0_100",
        label="UE/92.2/0/100",
        description="""UE/92.2/0/100""",
    )

    ue_92_2_0_100b = VocabularyTerm(
        code="UE_92_2_0_100B",
        label="UE/92.2/0/100B",
        description="""UE/92.2/0/100B""",
    )

    ue_92_2_0_101 = VocabularyTerm(
        code="UE_92_2_0_101",
        label="UE/92.2/0/101",
        description="""UE/92.2/0/101""",
    )

    ue_92_2_0_101b = VocabularyTerm(
        code="UE_92_2_0_101B",
        label="UE/92.2/0/101B",
        description="""UE/92.2/0/101B""",
    )

    ue_93_0_100 = VocabularyTerm(
        code="UE_93_0_100",
        label="UE/93/0/100",
        description="""UE/93/0/100""",
    )

    ue_93_0_101 = VocabularyTerm(
        code="UE_93_0_101",
        label="UE/93/0/101",
        description="""UE/93/0/101""",
    )

    ue_93_0_102 = VocabularyTerm(
        code="UE_93_0_102",
        label="UE/93/0/102",
        description="""UE/93/0/102""",
    )

    ue_93_0_103 = VocabularyTerm(
        code="UE_93_0_103",
        label="UE/93/0/103",
        description="""UE/93/0/103""",
    )

    ue_93_0_106 = VocabularyTerm(
        code="UE_93_0_106",
        label="UE/93/0/106",
        description="""UE/93/0/106""",
    )

    ue_93_0_107 = VocabularyTerm(
        code="UE_93_0_107",
        label="UE/93/0/107",
        description="""UE/93/0/107""",
    )

    ue_93_0_110 = VocabularyTerm(
        code="UE_93_0_110",
        label="UE/93/0/110",
        description="""UE/93/0/110""",
    )

    ue_93_0_111 = VocabularyTerm(
        code="UE_93_0_111",
        label="UE/93/0/111",
        description="""UE/93/0/111""",
    )

    ue_94_0_101 = VocabularyTerm(
        code="UE_94_0_101",
        label="UE/94/0/101",
        description="""UE/94/0/101""",
    )

    ue_94_0_102 = VocabularyTerm(
        code="UE_94_0_102",
        label="UE/94/0/102",
        description="""UE/94/0/102""",
    )

    ue_94_0_104 = VocabularyTerm(
        code="UE_94_0_104",
        label="UE/94/0/104",
        description="""UE/94/0/104""",
    )

    ue_94_0_105 = VocabularyTerm(
        code="UE_94_0_105",
        label="UE/94/0/105",
        description="""UE/94/0/105""",
    )

    ue_94_0_106 = VocabularyTerm(
        code="UE_94_0_106",
        label="UE/94/0/106",
        description="""UE/94/0/106""",
    )

    ue_94__1_002 = VocabularyTerm(
        code="UE_94_-1_002",
        label="UE/94/-1/002",
        description="""UE/94/-1/002""",
    )

    ue_94__1_002f = VocabularyTerm(
        code="UE_94_-1_002F",
        label="UE/94/-1/002F",
        description="""UE/94/-1/002F""",
    )

    ue_94__1_002t = VocabularyTerm(
        code="UE_94_-1_002T",
        label="UE/94/-1/002T",
        description="""UE/94/-1/002T""",
    )

    ue_94__1_003 = VocabularyTerm(
        code="UE_94_-1_003",
        label="UE/94/-1/003",
        description="""UE/94/-1/003""",
    )

    ue_94__1_004 = VocabularyTerm(
        code="UE_94_-1_004",
        label="UE/94/-1/004",
        description="""UE/94/-1/004""",
    )

    ue_94__1_005 = VocabularyTerm(
        code="UE_94_-1_005",
        label="UE/94/-1/005",
        description="""UE/94/-1/005""",
    )

    ue_94__1_006 = VocabularyTerm(
        code="UE_94_-1_006",
        label="UE/94/-1/006",
        description="""UE/94/-1/006""",
    )

    ue_94__1_007 = VocabularyTerm(
        code="UE_94_-1_007",
        label="UE/94/-1/007",
        description="""UE/94/-1/007""",
    )

    ue_94__1_008 = VocabularyTerm(
        code="UE_94_-1_008",
        label="UE/94/-1/008",
        description="""UE/94/-1/008""",
    )

    ue_95__1_001 = VocabularyTerm(
        code="UE_95_-1_001",
        label="UE/95/-1/001",
        description="""UE/95/-1/001""",
    )

    ue_96_0_100h = VocabularyTerm(
        code="UE_96_0_100H",
        label="UE/96/0/100H",
        description="""UE/96/0/100H""",
    )

    ue_96_0_101d = VocabularyTerm(
        code="UE_96_0_101D",
        label="UE/96/0/101D",
        description="""UE/96/0/101D""",
    )

    ue_96_0_103 = VocabularyTerm(
        code="UE_96_0_103",
        label="UE/96/0/103",
        description="""UE/96/0/103""",
    )

    ue_96_0_105 = VocabularyTerm(
        code="UE_96_0_105",
        label="UE/96/0/105",
        description="""UE/96/0/105""",
    )

    ue_96_0_106 = VocabularyTerm(
        code="UE_96_0_106",
        label="UE/96/0/106",
        description="""UE/96/0/106""",
    )

    ue_96_0_106b = VocabularyTerm(
        code="UE_96_0_106B",
        label="UE/96/0/106B",
        description="""UE/96/0/106B""",
    )

    ue_96_0_107f = VocabularyTerm(
        code="UE_96_0_107F",
        label="UE/96/0/107F",
        description="""UE/96/0/107F""",
    )

    ue_96_0_107h = VocabularyTerm(
        code="UE_96_0_107H",
        label="UE/96/0/107H",
        description="""UE/96/0/107H""",
    )

    ue_96_0_111 = VocabularyTerm(
        code="UE_96_0_111",
        label="UE/96/0/111",
        description="""UE/96/0/111""",
    )

    ue_96_0_112 = VocabularyTerm(
        code="UE_96_0_112",
        label="UE/96/0/112",
        description="""UE/96/0/112""",
    )

    ue_96_0_114 = VocabularyTerm(
        code="UE_96_0_114",
        label="UE/96/0/114",
        description="""UE/96/0/114""",
    )

    ue_96_0_116 = VocabularyTerm(
        code="UE_96_0_116",
        label="UE/96/0/116",
        description="""UE/96/0/116""",
    )

    ue_96_0_118 = VocabularyTerm(
        code="UE_96_0_118",
        label="UE/96/0/118",
        description="""UE/96/0/118""",
    )

    ue_96_0_120 = VocabularyTerm(
        code="UE_96_0_120",
        label="UE/96/0/120",
        description="""UE/96/0/120""",
    )

    ue_96_0_122 = VocabularyTerm(
        code="UE_96_0_122",
        label="UE/96/0/122",
        description="""UE/96/0/122""",
    )

    ue_96_0_124 = VocabularyTerm(
        code="UE_96_0_124",
        label="UE/96/0/124",
        description="""UE/96/0/124""",
    )

    ue_97_0_100 = VocabularyTerm(
        code="UE_97_0_100",
        label="UE/97/0/100",
        description="""UE/97/0/100""",
    )

    ue_97_0_100f = VocabularyTerm(
        code="UE_97_0_100F",
        label="UE/97/0/100F",
        description="""UE/97/0/100F""",
    )

    ue_97_0_101 = VocabularyTerm(
        code="UE_97_0_101",
        label="UE/97/0/101",
        description="""UE/97/0/101""",
    )

    ue_97_0_101f = VocabularyTerm(
        code="UE_97_0_101F",
        label="UE/97/0/101F",
        description="""UE/97/0/101F""",
    )

    ue_97_0_105 = VocabularyTerm(
        code="UE_97_0_105",
        label="UE/97/0/105",
        description="""UE/97/0/105""",
    )

    ue_97_0_108 = VocabularyTerm(
        code="UE_97_0_108",
        label="UE/97/0/108",
        description="""UE/97/0/108""",
    )

    ue_97_0_108b = VocabularyTerm(
        code="UE_97_0_108B",
        label="UE/97/0/108B",
        description="""UE/97/0/108B""",
    )

    ue_97_0_109 = VocabularyTerm(
        code="UE_97_0_109",
        label="UE/97/0/109",
        description="""UE/97/0/109""",
    )

    ue_97_0_112 = VocabularyTerm(
        code="UE_97_0_112",
        label="UE/97/0/112",
        description="""UE/97/0/112""",
    )

    ue_97_0_112b = VocabularyTerm(
        code="UE_97_0_112B",
        label="UE/97/0/112B",
        description="""UE/97/0/112B""",
    )

    ue_97_0_113 = VocabularyTerm(
        code="UE_97_0_113",
        label="UE/97/0/113",
        description="""UE/97/0/113""",
    )

    ue_97_0_115b = VocabularyTerm(
        code="UE_97_0_115B",
        label="UE/97/0/115B",
        description="""UE/97/0/115B""",
    )

    ue_97_0_116 = VocabularyTerm(
        code="UE_97_0_116",
        label="UE/97/0/116",
        description="""UE/97/0/116""",
    )

    ue_97_0_116b = VocabularyTerm(
        code="UE_97_0_116B",
        label="UE/97/0/116B",
        description="""UE/97/0/116B""",
    )

    ue_97_0_117 = VocabularyTerm(
        code="UE_97_0_117",
        label="UE/97/0/117",
        description="""UE/97/0/117""",
    )

    ue_97_0_117b = VocabularyTerm(
        code="UE_97_0_117B",
        label="UE/97/0/117B",
        description="""UE/97/0/117B""",
    )

    ue_97_0_119b = VocabularyTerm(
        code="UE_97_0_119B",
        label="UE/97/0/119B",
        description="""UE/97/0/119B""",
    )

    ue_97_0_119c = VocabularyTerm(
        code="UE_97_0_119C",
        label="UE/97/0/119C",
        description="""UE/97/0/119C""",
    )

    ue_97_0_119d = VocabularyTerm(
        code="UE_97_0_119D",
        label="UE/97/0/119D",
        description="""UE/97/0/119D""",
    )

    ue_97_0_121 = VocabularyTerm(
        code="UE_97_0_121",
        label="UE/97/0/121",
        description="""UE/97/0/121""",
    )

    ue_97_0_121b = VocabularyTerm(
        code="UE_97_0_121B",
        label="UE/97/0/121B",
        description="""UE/97/0/121B""",
    )

    ue_97_0_121c = VocabularyTerm(
        code="UE_97_0_121C",
        label="UE/97/0/121C",
        description="""UE/97/0/121C""",
    )

    ue_97_0_121f = VocabularyTerm(
        code="UE_97_0_121F",
        label="UE/97/0/121F",
        description="""UE/97/0/121F""",
    )

    ue_97_0_123 = VocabularyTerm(
        code="UE_97_0_123",
        label="UE/97/0/123",
        description="""UE/97/0/123""",
    )

    ue_97_0_123b = VocabularyTerm(
        code="UE_97_0_123B",
        label="UE/97/0/123B",
        description="""UE/97/0/123B""",
    )

    ue_97_0_123c = VocabularyTerm(
        code="UE_97_0_123C",
        label="UE/97/0/123C",
        description="""UE/97/0/123C""",
    )

    ue_97_0_123h = VocabularyTerm(
        code="UE_97_0_123H",
        label="UE/97/0/123H",
        description="""UE/97/0/123H""",
    )

    ue_97_0_125 = VocabularyTerm(
        code="UE_97_0_125",
        label="UE/97/0/125",
        description="""UE/97/0/125""",
    )

    ue_97_0_125f = VocabularyTerm(
        code="UE_97_0_125F",
        label="UE/97/0/125F",
        description="""UE/97/0/125F""",
    )

    ue_97_0_126 = VocabularyTerm(
        code="UE_97_0_126",
        label="UE/97/0/126",
        description="""UE/97/0/126""",
    )

    ue_97_0_126f = VocabularyTerm(
        code="UE_97_0_126F",
        label="UE/97/0/126F",
        description="""UE/97/0/126F""",
    )

    ue_97_0_127 = VocabularyTerm(
        code="UE_97_0_127",
        label="UE/97/0/127",
        description="""UE/97/0/127""",
    )

    ue_97_0_127f = VocabularyTerm(
        code="UE_97_0_127F",
        label="UE/97/0/127F",
        description="""UE/97/0/127F""",
    )

    ue_97_0_129 = VocabularyTerm(
        code="UE_97_0_129",
        label="UE/97/0/129",
        description="""UE/97/0/129""",
    )

    ue_97_0_130 = VocabularyTerm(
        code="UE_97_0_130",
        label="UE/97/0/130",
        description="""UE/97/0/130""",
    )

    ue_97_0_131 = VocabularyTerm(
        code="UE_97_0_131",
        label="UE/97/0/131",
        description="""UE/97/0/131""",
    )

    ue_98_0_101 = VocabularyTerm(
        code="UE_98_0_101",
        label="UE/98/0/101",
        description="""UE/98/0/101""",
    )

    ue_98_0_101f = VocabularyTerm(
        code="UE_98_0_101F",
        label="UE/98/0/101F",
        description="""UE/98/0/101F""",
    )

    ue_98_0_102 = VocabularyTerm(
        code="UE_98_0_102",
        label="UE/98/0/102",
        description="""UE/98/0/102""",
    )

    ue_98_0_103 = VocabularyTerm(
        code="UE_98_0_103",
        label="UE/98/0/103",
        description="""UE/98/0/103""",
    )

    ue_98_0_104 = VocabularyTerm(
        code="UE_98_0_104",
        label="UE/98/0/104",
        description="""UE/98/0/104""",
    )

    ue_98_0_106 = VocabularyTerm(
        code="UE_98_0_106",
        label="UE/98/0/106",
        description="""UE/98/0/106""",
    )

    ue_98_0_107 = VocabularyTerm(
        code="UE_98_0_107",
        label="UE/98/0/107",
        description="""UE/98/0/107""",
    )

    ue_98_0_108 = VocabularyTerm(
        code="UE_98_0_108",
        label="UE/98/0/108",
        description="""UE/98/0/108""",
    )

    ue_98_0_109 = VocabularyTerm(
        code="UE_98_0_109",
        label="UE/98/0/109",
        description="""UE/98/0/109""",
    )

    ue_98_0_110 = VocabularyTerm(
        code="UE_98_0_110",
        label="UE/98/0/110",
        description="""UE/98/0/110""",
    )

    ue_98_0_111 = VocabularyTerm(
        code="UE_98_0_111",
        label="UE/98/0/111",
        description="""UE/98/0/111""",
    )

    ue_98_0_112 = VocabularyTerm(
        code="UE_98_0_112",
        label="UE/98/0/112",
        description="""UE/98/0/112""",
    )

    ue_98_0_113 = VocabularyTerm(
        code="UE_98_0_113",
        label="UE/98/0/113",
        description="""UE/98/0/113""",
    )

    ue_98_0_114h = VocabularyTerm(
        code="UE_98_0_114H",
        label="UE/98/0/114H",
        description="""UE/98/0/114H""",
    )

    ue_98_0_115d = VocabularyTerm(
        code="UE_98_0_115D",
        label="UE/98/0/115D",
        description="""UE/98/0/115D""",
    )

    ue_99_0_10 = VocabularyTerm(
        code="UE_99_0_10",
        label="UE/99/0/10",
        description="""UE/99/0/10""",
    )

    ue_99_0_110 = VocabularyTerm(
        code="UE_99_0_110",
        label="UE/99/0/110",
        description="""UE/99/0/110""",
    )


class BamOe(VocabularyType):
    defs = VocabularyTypeDef(
        code="BAM_OE",
        description="""BAM Organizational Entity (OE) [Effective 01.01.2024]//BAM Organisationseinheit (OE) [Stand 01.01.2024]""",
    )

    oe_1 = VocabularyTerm(
        code="OE_1",
        label="1 Analytical Chemistry, Reference Materials",
        description="""Department 1 Analytical Chemistry, Reference Materials//Abteilung 1 Analytische Chemie; Referenzmaterialien""",
    )

    oe_1_0 = VocabularyTerm(
        code="OE_1.0",
        label="1.0 Self-Driving Lab für Advanced Materials",
        description="""Division 1.0 Self-Driving Lab für Advanced Materials//Fachbereich Self-Driving Lab für Advanced Materials""",
    )

    oe_1_1 = VocabularyTerm(
        code="OE_1.1",
        label="1.1 Inorganic Trace Analysis",
        description="""Division 1.1 Inorganic Trace Analysis//Fachbereich 1.1 Anorganische Spurenanalytik""",
    )

    oe_1_2 = VocabularyTerm(
        code="OE_1.2",
        label="1.2 Biophotonics",
        description="""Division 1.2 Biophotonics//Fachbereich 1.2 Biophotonik""",
    )

    oe_1_3 = VocabularyTerm(
        code="OE_1.3",
        label="1.3 Instrumental Analytics",
        description="""Division 1.3 Instrumental Analytics//Fachbereich 1.3 Instrumentelle Analytik""",
    )

    oe_1_4 = VocabularyTerm(
        code="OE_1.4",
        label="1.4 Process Analytical Technology",
        description="""Division 1.4 Process Analytical Technology//Fachbereich 1.4 Prozessanalytik""",
    )

    oe_1_5 = VocabularyTerm(
        code="OE_1.5",
        label="1.5 Protein Analysis",
        description="""Division 1.5 Protein Analysis//Fachbereich 1.5 Proteinanalytik""",
    )

    oe_1_6 = VocabularyTerm(
        code="OE_1.6",
        label="1.6 Inorganic Reference Materials",
        description="""Division 1.6 Inorganic Reference Materials//Fachbereich 1.6 Anorganische Referenzmaterialien""",
    )

    oe_1_7 = VocabularyTerm(
        code="OE_1.7",
        label="1.7 Organic Trace and Food Analysis",
        description="""Division 1.7 Organic Trace and Food Analysis//Fachbereich 1.7 Organische Spuren- und Lebensmittelanalytik""",
    )

    oe_1_8 = VocabularyTerm(
        code="OE_1.8",
        label="1.8 Environmental Analysis",
        description="""Division 1.8 Environmental Analysis//Fachbereich 1.8 Umweltanalytik""",
    )

    oe_1_9 = VocabularyTerm(
        code="OE_1.9",
        label="1.9 Chemical and Optical Sensing",
        description="""Division 1.9 Chemical and Optical Sensing//Fachbereich 1.9 Chemische und optische Sensorik""",
    )

    oe_2 = VocabularyTerm(
        code="OE_2",
        label="2 Process and Plant Safety",
        description="""Department 2 Process and Plant Safety//Abteilung 2 Prozess- und Anlagensicherheit""",
    )

    oe_2_1 = VocabularyTerm(
        code="OE_2.1",
        label="2.1 Safety of Energy Carriers",
        description="""Division 2.1 Safety of Energy Carriers//Fachbereich 2.1 Sicherheit von Energieträgern""",
    )

    oe_2_2 = VocabularyTerm(
        code="OE_2.2",
        label="2.2 Process Simulation",
        description="""Division 2.2 Process Simulation//Fachbereich 2.2 Prozesssimulation""",
    )

    oe_2_3 = VocabularyTerm(
        code="OE_2.3",
        label="2.3 Classification of Hazardous Substances and Dangerous Goods",
        description="""Division 2.3 Classification of Hazardous Substances and Dangerous Goods//Fachbereich 2.3 Einstufung von Gefahrstoffen und -gütern""",
    )

    oe_2_4 = VocabularyTerm(
        code="OE_2.4",
        label="2.4 Testing and Evaluation of Explosives and Pyrotechnics",
        description="""Division 2.4 Testing and Evaluation of Explosives and Pyrotechnics//Fachbereich 2.4 Prüfung und Bewertung von Explosivstoffen/Pyrotechnik""",
    )

    oe_2_5 = VocabularyTerm(
        code="OE_2.5",
        label="2.5 Conformity Assessment Explosives and Pyrotechnics",
        description="""Division 2.5 Conformity Assessment Explosives and Pyrotechnics//Fachbereich 2.5 Konformitätsbewertung Explosivstoffe/Pyrotechnik""",
    )

    oe_3 = VocabularyTerm(
        code="OE_3",
        label="3 Containment Systems for Dangerous Goods; Energy Storage",
        description="""Department 3 Containment Systems for Dangerous Goods; Energy Storage//Abteilung 3 Gefahrgutumschließungen; Energiespeicher""",
    )

    oe_3_1 = VocabularyTerm(
        code="OE_3.1",
        label="3.1 Safety of Dangerous Goods Packagings and Batteries",
        description="""Division 3.1 Safety of Dangerous Goods Packagings and Batteries//Fachbereich 3.1 Sicherheit von Gefahrgutverpackungen und Batterien""",
    )

    oe_3_2 = VocabularyTerm(
        code="OE_3.2",
        label="3.2 Tanks for Dangerous Goods and Accident Mechanics",
        description="""Division 3.2 Tanks for Dangerous Goods and Accident Mechanics//Fachbereich 3.2 Gefahrguttanks und Unfallmechanik""",
    )

    oe_3_3 = VocabularyTerm(
        code="OE_3.3",
        label="3.3 Safety of Transport Containers",
        description="""Division 3.3 Safety of Transport Containers//Fachbereich 3.3 Sicherheit von Transportbehältern""",
    )

    oe_3_4 = VocabularyTerm(
        code="OE_3.4",
        label="3.4 Safety of Storage Containers",
        description="""Division 3.4 Safety of Storage Containers//Fachbereich 3.4 Sicherheit von Lagerbehältern""",
    )

    oe_3_5 = VocabularyTerm(
        code="OE_3.5",
        label="3.5 Safety of Gas Storage Systems",
        description="""Division 3.5 Safety of Gas Storage Systems//Fachbereich 3.5 Sicherheit von Gasspeichern""",
    )

    oe_3_6 = VocabularyTerm(
        code="OE_3.6",
        label="3.6 Electrochemical Energy Materials",
        description="""Division 3.6 Electrochemical Energy Materials//Fachbereich 3.6 Elektrochemische Energiematerialien""",
    )

    oe_4 = VocabularyTerm(
        code="OE_4",
        label="4 Materials and the Environment",
        description="""Department 4 Materials and the Environment//Abteilung 4 Material und Umwelt""",
    )

    oe_4_0 = VocabularyTerm(
        code="OE_4.0",
        label="4.0 Model Biofilms and Geomycology",
        description="""Division 4.0  Model Biofilms and Geomycology//Fachbereich 4.0  Modellbiofilme und Geomykologie""",
    )

    oe_4_1 = VocabularyTerm(
        code="OE_4.1",
        label="4.1 Biodeterioration and Reference Organisms",
        description="""Division 4.1 Biodeterioration and Reference Organisms//Fachbereich 4.1 Biologische Materialschädigung und Referenzorganismen""",
    )

    oe_4_2 = VocabularyTerm(
        code="OE_4.2",
        label="4.2 Material-Microbiome Interactions",
        description="""Division 4.2 Material-Microbiome Interactions//Fachbereich 4.2 Material-Mikrobiom Wechselwirkungen""",
    )

    oe_4_3 = VocabularyTerm(
        code="OE_4.3",
        label="4.3 Molecular and Applied Entomology",
        description="""Division 4.3 Molecular and Applied Entomology//Fachbereich 4.3 Molekulare und angewandte Entomologie""",
    )

    oe_4_4 = VocabularyTerm(
        code="OE_4.4",
        label="4.4 Thermochemical Residues Treatment and Resource Recovery",
        description="""Division 4.4 Thermochemical Residues Treatment and Resource Recovery//Fachbereich 4.4 Thermochemische Reststoffbehandlung und Wertstoffrückgewinnung""",
    )

    oe_4_5 = VocabularyTerm(
        code="OE_4.5",
        label="4.5 Analysis of Artefacts and Cultural Assets",
        description="""Division 4.5 Analysis of Artefacts and Cultural Assets//Fachbereich 4.5 Kunst- und Kulturgutanalyse""",
    )

    oe_5 = VocabularyTerm(
        code="OE_5",
        label="5 Materials Engineering",
        description="""Department 5 Materials Engineering//Abteilung 5 Werkstofftechnik""",
    )

    oe_5_1 = VocabularyTerm(
        code="OE_5.1",
        label="5.1 Materialography, Fractography and Ageing of Engineered Materials",
        description="""Division 5.1 Materialography, Fractography and Ageing of Engineered Materials//Fachbereich 5.1 Materialographie, Fraktographie und Alterung technischer Werkstoffe""",
    )

    oe_5_2 = VocabularyTerm(
        code="OE_5.2",
        label="5.2 Metallic High-Temperature Materials",
        description="""Division 5.2 Metallic High-Temperature Materials//Fachbereich 5.2 Metallische Hochtemperaturwerkstoffe""",
    )

    oe_5_3 = VocabularyTerm(
        code="OE_5.3",
        label="5.3 Polymer Matrix Composites",
        description="""Division 5.3 Polymer Matrix Composites//Fachbereich 5.3 Polymere Verbundwerkstoffe""",
    )

    oe_5_4 = VocabularyTerm(
        code="OE_5.4",
        label="5.4 Advanced Multi-materials Processing",
        description="""Division 5.4 Advanced Multi-materials Processing//Fachbereich 5.4 Multimateriale Fertigungsprozesse""",
    )

    oe_5_5 = VocabularyTerm(
        code="OE_5.5",
        label="5.5 Materials Modelling",
        description="""Division 5.5 Materials Modelling//Fachbereich 5.5 Materialmodellierung""",
    )

    oe_5_6 = VocabularyTerm(
        code="OE_5.6",
        label="5.6 Glasses",
        description="""Division 5.6 Glasses//Fachbereich 5.6 Glas""",
    )

    oe_6 = VocabularyTerm(
        code="OE_6",
        label="6 Materials Chemistry",
        description="""Department 6 Materials Chemistry//Abteilung 6 Materialchemie""",
    )

    oe_6_1 = VocabularyTerm(
        code="OE_6.1",
        label="6.1 Surface Analysis and Interfacial Chemistry",
        description="""Division 6.1 Surface Analysis and Interfacial Chemistry//Fachbereich 6.1 Oberflächenanalytik und Grenzflächenchemie""",
    )

    oe_6_2 = VocabularyTerm(
        code="OE_6.2",
        label="6.2 Material and Surface Technologies",
        description="""Division 6.2 Material and Surface Technologies//Fachbereich 6.2 Material- und Oberflächentechnologien""",
    )

    oe_6_3 = VocabularyTerm(
        code="OE_6.3",
        label="6.3 Structure Analysis",
        description="""Division 6.3 Structure Analysis//Fachbereich 6.3 Strukturanalytik (Structure Analysis)""",
    )

    oe_6_4 = VocabularyTerm(
        code="OE_6.4",
        label="6.4 Materials Informatics",
        description="""Division 6.4 Materials Informatics//Fachbereich 6.4 Materialinformatik (Materials Informatics)""",
    )

    oe_6_5 = VocabularyTerm(
        code="OE_6.5",
        label="6.5 Synthesis and Scattering of Nanostructured Materials",
        description="""Division 6.5 Synthesis and Scattering of Nanostructured Materials//Fachbereich 6.5 Synthese und Streuverfahren nanostrukturierter Materialien""",
    )

    oe_6_6 = VocabularyTerm(
        code="OE_6.6",
        label="6.6 Physical and Chemical Analysis of Polymers",
        description="""Division 6.6 Physical and Chemical Analysis of Polymers//Fachbereich 6.6 Physik und chemische Analytik der Polymere""",
    )

    oe_6_7 = VocabularyTerm(
        code="OE_6.7",
        label="6.7 Surface Modification and Measurement Technology",
        description="""Division 6.7 Surface Modification and Measurement Technology//Fachbereich 6.7 Materialsynthese und Design""",
    )

    oe_7 = VocabularyTerm(
        code="OE_7",
        label="7 Safety of Structures",
        description="""Department 7 Safety of Structures//Abteilung 7 Bauwerkssicherheit""",
    )

    oe_7_1 = VocabularyTerm(
        code="OE_7.1",
        label="7.1 Building Materials",
        description="""Division 7.1 Building Materials//Fachbereich 7.1 Baustoffe""",
    )

    oe_7_2 = VocabularyTerm(
        code="OE_7.2",
        label="7.2 Buildings and Structures",
        description="""Division 7.2 Buildings and Structures//Fachbereich 7.2 Ingenieurbau""",
    )

    oe_7_3 = VocabularyTerm(
        code="OE_7.3",
        label="7.3 Fire Engineering",
        description="""Division 7.3 Fire Engineering//Fachbereich 7.3 Brandingenieurwesen""",
    )

    oe_7_4 = VocabularyTerm(
        code="OE_7.4",
        label="7.4 Technology of Construction Materials",
        description="""Division 7.4 Technology of Construction Materials//Fachbereich 7.4 Baustofftechnologie""",
    )

    oe_7_5 = VocabularyTerm(
        code="OE_7.5",
        label="7.5 Technical Properties of Polymeric Materials",
        description="""Division 7.5 Technical Properties of Polymeric Materials//Fachbereich 7.5 Technische Eigenschaften von Polymerwerkstoffen""",
    )

    oe_7_6 = VocabularyTerm(
        code="OE_7.6",
        label="7.6 Corrosion and Corrosion Protection",
        description="""Division 7.6 Corrosion and Corrosion Protection//Fachbereich 7.6 Korrosion und Korrosionsschutz""",
    )

    oe_7_7 = VocabularyTerm(
        code="OE_7.7",
        label="7.7 Modelling and Simulation",
        description="""Division 7.7 Modelling and Simulation//Fachbereich 7.7 Modellierung und Simulation""",
    )

    oe_8 = VocabularyTerm(
        code="OE_8",
        label="8 Non-Destructive Testing",
        description="""Department 8 Non-Destructive Testing//Abteilung 8 Zerstörungsfreie Prüfung""",
    )

    oe_8_1 = VocabularyTerm(
        code="OE_8.1",
        label="8.1 Sensors, Measurement and Testing Methods",
        description="""Division 8.1 Sensors, Measurement and Testing Methods//Fachbereich 8.1 Sensorik, mess- und prüftechnische Verfahren""",
    )

    oe_8_2 = VocabularyTerm(
        code="OE_8.2",
        label="8.2 Non-destructive Testing Methods for Civil Engineering",
        description="""Division 8.2 Non-destructive Testing Methods for Civil Engineering//Fachbereich 8.2 Zerstörungsfreie Prüfmethoden für das Bauwesen""",
    )

    oe_8_3 = VocabularyTerm(
        code="OE_8.3",
        label="8.3 Thermographic Methods",
        description="""Division 8.3 Thermographic Methods//Fachbereich 8.3 Thermografische Verfahren""",
    )

    oe_8_4 = VocabularyTerm(
        code="OE_8.4",
        label="8.4 Acoustic and Electromagnetic Methods",
        description="""Division 8.4 Acoustic and Electromagnetic Methods//Fachbereich 8.4 Akustische und elektromagnetische Verfahren""",
    )

    oe_8_5 = VocabularyTerm(
        code="OE_8.5",
        label="8.5 X-ray Imaging",
        description="""Division 8.5 X-ray Imaging//Fachbereich 8.5 Röntgenbildgebung""",
    )

    oe_8_6 = VocabularyTerm(
        code="OE_8.6",
        label="8.6 Fibre Optic Sensors",
        description="""Division 8.6 Fibre Optic Sensors//Fachbereich 8.6 Faseroptische Sensorik""",
    )

    oe_8_7 = VocabularyTerm(
        code="OE_8.7",
        label="8.7 Thermographic Methods",
        description="""Division 8.7 Thermographic Methods//Fachbereich 8.7 Thermografische Verfahren""",
    )

    oe_9 = VocabularyTerm(
        code="OE_9",
        label="9 Component Safety",
        description="""Department 9 Component Safety//Abteilung 9 Komponentensicherheit""",
    )

    oe_9_1 = VocabularyTerm(
        code="OE_9.1",
        label="9.1 Components for Energy Carriers",
        description="""Division 9.1 Components for Energy Carriers//Fachbereich 9.1 Komponenten für Energieträger""",
    )

    oe_9_2 = VocabularyTerm(
        code="OE_9.2",
        label="9.2 Testing Devices and Equipment",
        description="""Division 9.2 Testing Devices and Equipment//Fachbereich 9.2 Versuchsanlagen und Prüftechnik""",
    )

    oe_9_3 = VocabularyTerm(
        code="OE_9.3",
        label="9.3 Welding Technology",
        description="""Division 9.3 Welding Technology//Fachbereich 9.3 Schweißtechnische Fertigungsverfahren""",
    )

    oe_9_4 = VocabularyTerm(
        code="OE_9.4",
        label="9.4 Weld Mechanics",
        description="""Division 9.4 Weld Mechanics//Fachbereich 9.4 Integrität von Schweißverbindungen""",
    )

    oe_9_5 = VocabularyTerm(
        code="OE_9.5",
        label="9.5 Macrotribology and Wear Protection",
        description="""Division 9.5 Macrotribology and Wear Protection//Fachbereich 9.5 Tribologie und Verschleißschutz""",
    )

    oe_9_6 = VocabularyTerm(
        code="OE_9.6",
        label="9.6 Additive Manufacturing of Metallic Components",
        description="""Division 9.6 Additive Manufacturing of Metallic Components//Fachbereich 9.6 Additive Fertigung metallischer Komponenten""",
    )

    oe_s = VocabularyTerm(
        code="OE_S",
        label="S Quality Infrastructure",
        description="""Department S Quality Infrastructure//Abteilung S Qualitätsinfrastruktur""",
    )

    oe_s_1 = VocabularyTerm(
        code="OE_S.1",
        label="S.1 Quality in Testing",
        description="""Section S.1 Quality in Testing//Referat S.1 Qualität im Prüfwesen""",
    )

    oe_s_2 = VocabularyTerm(
        code="OE_S.2",
        label="S.2 Digitalization of Quality Infrastructure",
        description="""Section S.2 Digitalization of Quality Infrastructure//Referat S.2 Digitalisierung der Qualitätsinfrastruktur""",
    )

    oe_s_3 = VocabularyTerm(
        code="OE_S.3",
        label="S.3 Ecodesign and Energy Labelling",
        description="""Section S.3 Ecodesign and Energy Labelling//Referat S.3 Ökodesign und Energieverbrauchskennzeichnung""",
    )

    oe_s_4 = VocabularyTerm(
        code="OE_S.4",
        label="S.4 Ecodesign and Energy Labelling",
        description="""Section S.4 Ecodesign and Energy Labelling//Referat S.4 Ökodesign und Energieverbrauchskennzeichnung""",
    )

    oe_vp_1 = VocabularyTerm(
        code="OE_VP.1",
        label="VP.1 eScience",
        description="""Section VP.1 eScience//Referat VP.1 eScience""",
    )

    oe_vp_2 = VocabularyTerm(
        code="OE_VP.2",
        label="VP.2 Information Technology",
        description="""Section VP.2 Information Technology//Referat VP.2 Informationstechnik""",
    )


class BamRoom(VocabularyType):
    defs = VocabularyTypeDef(
        code="BAM_ROOM",
        description="""BAM Room//BAM Raum""",
    )

    roo_8_a1 = VocabularyTerm(
        code="ROO_8_A1",
        label="8.A1",
        description="""Room 8.A1//Raum 8.A1""",
    )

    roo_8_a2 = VocabularyTerm(
        code="ROO_8_A2",
        label="8.A2",
        description="""Room 8.A2//Raum 8.A2""",
    )

    roo_01_200f = VocabularyTerm(
        code="ROO_01_200F",
        label="01.200F",
        description="""Room 01.200F//Raum 01.200F""",
    )

    roo_01_200t = VocabularyTerm(
        code="ROO_01_200T",
        label="01.200T",
        description="""Room 01.200T//Raum 01.200T""",
    )

    roo_01_201 = VocabularyTerm(
        code="ROO_01_201",
        label="01.201",
        description="""Room 01.201//Raum 01.201""",
    )

    roo_01_202f = VocabularyTerm(
        code="ROO_01_202F",
        label="01.202F",
        description="""Room 01.202F//Raum 01.202F""",
    )

    roo_01_203 = VocabularyTerm(
        code="ROO_01_203",
        label="01.203",
        description="""Room 01.203//Raum 01.203""",
    )

    roo_01_205 = VocabularyTerm(
        code="ROO_01_205",
        label="01.205",
        description="""Room 01.205//Raum 01.205""",
    )

    roo_01_205a1 = VocabularyTerm(
        code="ROO_01_205A1",
        label="01.205A1",
        description="""Room 01.205A1//Raum 01.205A1""",
    )

    roo_01_205f = VocabularyTerm(
        code="ROO_01_205F",
        label="01.205F",
        description="""Room 01.205F//Raum 01.205F""",
    )

    roo_01_206 = VocabularyTerm(
        code="ROO_01_206",
        label="01.206",
        description="""Room 01.206//Raum 01.206""",
    )

    roo_01_206f = VocabularyTerm(
        code="ROO_01_206F",
        label="01.206F",
        description="""Room 01.206F//Raum 01.206F""",
    )

    roo_01_207 = VocabularyTerm(
        code="ROO_01_207",
        label="01.207",
        description="""Room 01.207//Raum 01.207""",
    )

    roo_01_208 = VocabularyTerm(
        code="ROO_01_208",
        label="01.208",
        description="""Room 01.208//Raum 01.208""",
    )

    roo_01_210 = VocabularyTerm(
        code="ROO_01_210",
        label="01.210",
        description="""Room 01.210//Raum 01.210""",
    )

    roo_01_211 = VocabularyTerm(
        code="ROO_01_211",
        label="01.211",
        description="""Room 01.211//Raum 01.211""",
    )

    roo_01_212b = VocabularyTerm(
        code="ROO_01_212B",
        label="01.212B",
        description="""Room 01.212B//Raum 01.212B""",
    )

    roo_01_212c = VocabularyTerm(
        code="ROO_01_212C",
        label="01.212C",
        description="""Room 01.212C//Raum 01.212C""",
    )

    roo_01_213 = VocabularyTerm(
        code="ROO_01_213",
        label="01.213",
        description="""Room 01.213//Raum 01.213""",
    )

    roo_01_213b = VocabularyTerm(
        code="ROO_01_213B",
        label="01.213B",
        description="""Room 01.213B//Raum 01.213B""",
    )

    roo_01_214 = VocabularyTerm(
        code="ROO_01_214",
        label="01.214",
        description="""Room 01.214//Raum 01.214""",
    )

    roo_01_214b = VocabularyTerm(
        code="ROO_01_214B",
        label="01.214B",
        description="""Room 01.214B//Raum 01.214B""",
    )

    roo_01_216 = VocabularyTerm(
        code="ROO_01_216",
        label="01.216",
        description="""Room 01.216//Raum 01.216""",
    )

    roo_01_217 = VocabularyTerm(
        code="ROO_01_217",
        label="01.217",
        description="""Room 01.217//Raum 01.217""",
    )

    roo_01_217b = VocabularyTerm(
        code="ROO_01_217B",
        label="01.217B",
        description="""Room 01.217B//Raum 01.217B""",
    )

    roo_01_219f = VocabularyTerm(
        code="ROO_01_219F",
        label="01.219F",
        description="""Room 01.219F//Raum 01.219F""",
    )

    roo_01_220a2 = VocabularyTerm(
        code="ROO_01_220A2",
        label="01.220A2",
        description="""Room 01.220A2//Raum 01.220A2""",
    )

    roo_01_220f = VocabularyTerm(
        code="ROO_01_220F",
        label="01.220F",
        description="""Room 01.220F//Raum 01.220F""",
    )

    roo_01_221b = VocabularyTerm(
        code="ROO_01_221B",
        label="01.221B",
        description="""Room 01.221B//Raum 01.221B""",
    )

    roo_01_221c = VocabularyTerm(
        code="ROO_01_221C",
        label="01.221C",
        description="""Room 01.221C//Raum 01.221C""",
    )

    roo_01_221e = VocabularyTerm(
        code="ROO_01_221E",
        label="01.221E",
        description="""Room 01.221E//Raum 01.221E""",
    )

    roo_01_221f = VocabularyTerm(
        code="ROO_01_221F",
        label="01.221F",
        description="""Room 01.221F//Raum 01.221F""",
    )

    roo_01_221t = VocabularyTerm(
        code="ROO_01_221T",
        label="01.221T",
        description="""Room 01.221T//Raum 01.221T""",
    )

    roo_01_222f = VocabularyTerm(
        code="ROO_01_222F",
        label="01.222F",
        description="""Room 01.222F//Raum 01.222F""",
    )

    roo_01_223 = VocabularyTerm(
        code="ROO_01_223",
        label="01.223",
        description="""Room 01.223//Raum 01.223""",
    )

    roo_01_224 = VocabularyTerm(
        code="ROO_01_224",
        label="01.224",
        description="""Room 01.224//Raum 01.224""",
    )

    roo_01_225 = VocabularyTerm(
        code="ROO_01_225",
        label="01.225",
        description="""Room 01.225//Raum 01.225""",
    )

    roo_01_225b = VocabularyTerm(
        code="ROO_01_225B",
        label="01.225B",
        description="""Room 01.225B//Raum 01.225B""",
    )

    roo_01_226 = VocabularyTerm(
        code="ROO_01_226",
        label="01.226",
        description="""Room 01.226//Raum 01.226""",
    )

    roo_01_226b = VocabularyTerm(
        code="ROO_01_226B",
        label="01.226B",
        description="""Room 01.226B//Raum 01.226B""",
    )

    roo_01_227 = VocabularyTerm(
        code="ROO_01_227",
        label="01.227",
        description="""Room 01.227//Raum 01.227""",
    )

    roo_01_227b = VocabularyTerm(
        code="ROO_01_227B",
        label="01.227B",
        description="""Room 01.227B//Raum 01.227B""",
    )

    roo_01_228 = VocabularyTerm(
        code="ROO_01_228",
        label="01.228",
        description="""Room 01.228//Raum 01.228""",
    )

    roo_01_228b = VocabularyTerm(
        code="ROO_01_228B",
        label="01.228B",
        description="""Room 01.228B//Raum 01.228B""",
    )

    roo_01_229 = VocabularyTerm(
        code="ROO_01_229",
        label="01.229",
        description="""Room 01.229//Raum 01.229""",
    )

    roo_01_229b = VocabularyTerm(
        code="ROO_01_229B",
        label="01.229B",
        description="""Room 01.229B//Raum 01.229B""",
    )

    roo_01_229d = VocabularyTerm(
        code="ROO_01_229D",
        label="01.229D",
        description="""Room 01.229D//Raum 01.229D""",
    )

    roo_01_229h = VocabularyTerm(
        code="ROO_01_229H",
        label="01.229H",
        description="""Room 01.229H//Raum 01.229H""",
    )

    roo_01_230 = VocabularyTerm(
        code="ROO_01_230",
        label="01.230",
        description="""Room 01.230//Raum 01.230""",
    )

    roo_01_231 = VocabularyTerm(
        code="ROO_01_231",
        label="01.231",
        description="""Room 01.231//Raum 01.231""",
    )

    roo_01_232 = VocabularyTerm(
        code="ROO_01_232",
        label="01.232",
        description="""Room 01.232//Raum 01.232""",
    )

    roo_01_233 = VocabularyTerm(
        code="ROO_01_233",
        label="01.233",
        description="""Room 01.233//Raum 01.233""",
    )

    roo_01_s00 = VocabularyTerm(
        code="ROO_01_S00",
        label="01.S00",
        description="""Room 01.S00//Raum 01.S00""",
    )

    roo_01_s01 = VocabularyTerm(
        code="ROO_01_S01",
        label="01.S01",
        description="""Room 01.S01//Raum 01.S01""",
    )

    roo_01_s02 = VocabularyTerm(
        code="ROO_01_S02",
        label="01.S02",
        description="""Room 01.S02//Raum 01.S02""",
    )

    roo_01_s03 = VocabularyTerm(
        code="ROO_01_S03",
        label="01.S03",
        description="""Room 01.S03//Raum 01.S03""",
    )

    roo_01_s04 = VocabularyTerm(
        code="ROO_01_S04",
        label="01.S04",
        description="""Room 01.S04//Raum 01.S04""",
    )

    roo_01_s05 = VocabularyTerm(
        code="ROO_01_S05",
        label="01.S05",
        description="""Room 01.S05//Raum 01.S05""",
    )

    roo_01_s06 = VocabularyTerm(
        code="ROO_01_S06",
        label="01.S06",
        description="""Room 01.S06//Raum 01.S06""",
    )

    roo_01_s08 = VocabularyTerm(
        code="ROO_01_S08",
        label="01.S08",
        description="""Room 01.S08//Raum 01.S08""",
    )

    roo_01_s09 = VocabularyTerm(
        code="ROO_01_S09",
        label="01.S09",
        description="""Room 01.S09//Raum 01.S09""",
    )

    roo_01_s10 = VocabularyTerm(
        code="ROO_01_S10",
        label="01.S10",
        description="""Room 01.S10//Raum 01.S10""",
    )

    roo_01_s11 = VocabularyTerm(
        code="ROO_01_S11",
        label="01.S11",
        description="""Room 01.S11//Raum 01.S11""",
    )

    roo_01_s12 = VocabularyTerm(
        code="ROO_01_S12",
        label="01.S12",
        description="""Room 01.S12//Raum 01.S12""",
    )

    roo_01_s13 = VocabularyTerm(
        code="ROO_01_S13",
        label="01.S13",
        description="""Room 01.S13//Raum 01.S13""",
    )

    roo_01_s14 = VocabularyTerm(
        code="ROO_01_S14",
        label="01.S14",
        description="""Room 01.S14//Raum 01.S14""",
    )

    roo_01_s15 = VocabularyTerm(
        code="ROO_01_S15",
        label="01.S15",
        description="""Room 01.S15//Raum 01.S15""",
    )

    roo_01_s16 = VocabularyTerm(
        code="ROO_01_S16",
        label="01.S16",
        description="""Room 01.S16//Raum 01.S16""",
    )

    roo_02_300f = VocabularyTerm(
        code="ROO_02_300F",
        label="02.300F",
        description="""Room 02.300F//Raum 02.300F""",
    )

    roo_02_300t = VocabularyTerm(
        code="ROO_02_300T",
        label="02.300T",
        description="""Room 02.300T//Raum 02.300T""",
    )

    roo_02_301 = VocabularyTerm(
        code="ROO_02_301",
        label="02.301",
        description="""Room 02.301//Raum 02.301""",
    )

    roo_02_302f = VocabularyTerm(
        code="ROO_02_302F",
        label="02.302F",
        description="""Room 02.302F//Raum 02.302F""",
    )

    roo_02_303 = VocabularyTerm(
        code="ROO_02_303",
        label="02.303",
        description="""Room 02.303//Raum 02.303""",
    )

    roo_02_305a1 = VocabularyTerm(
        code="ROO_02_305A1",
        label="02.305A1",
        description="""Room 02.305A1//Raum 02.305A1""",
    )

    roo_02_305f = VocabularyTerm(
        code="ROO_02_305F",
        label="02.305F",
        description="""Room 02.305F//Raum 02.305F""",
    )

    roo_02_306f = VocabularyTerm(
        code="ROO_02_306F",
        label="02.306F",
        description="""Room 02.306F//Raum 02.306F""",
    )

    roo_02_307 = VocabularyTerm(
        code="ROO_02_307",
        label="02.307",
        description="""Room 02.307//Raum 02.307""",
    )

    roo_02_308 = VocabularyTerm(
        code="ROO_02_308",
        label="02.308",
        description="""Room 02.308//Raum 02.308""",
    )

    roo_02_310 = VocabularyTerm(
        code="ROO_02_310",
        label="02.310",
        description="""Room 02.310//Raum 02.310""",
    )

    roo_02_311 = VocabularyTerm(
        code="ROO_02_311",
        label="02.311",
        description="""Room 02.311//Raum 02.311""",
    )

    roo_02_312 = VocabularyTerm(
        code="ROO_02_312",
        label="02.312",
        description="""Room 02.312//Raum 02.312""",
    )

    roo_02_312b = VocabularyTerm(
        code="ROO_02_312B",
        label="02.312B",
        description="""Room 02.312B//Raum 02.312B""",
    )

    roo_02_312c = VocabularyTerm(
        code="ROO_02_312C",
        label="02.312C",
        description="""Room 02.312C//Raum 02.312C""",
    )

    roo_02_313 = VocabularyTerm(
        code="ROO_02_313",
        label="02.313",
        description="""Room 02.313//Raum 02.313""",
    )

    roo_02_313b = VocabularyTerm(
        code="ROO_02_313B",
        label="02.313B",
        description="""Room 02.313B//Raum 02.313B""",
    )

    roo_02_314 = VocabularyTerm(
        code="ROO_02_314",
        label="02.314",
        description="""Room 02.314//Raum 02.314""",
    )

    roo_02_314b = VocabularyTerm(
        code="ROO_02_314B",
        label="02.314B",
        description="""Room 02.314B//Raum 02.314B""",
    )

    roo_02_315 = VocabularyTerm(
        code="ROO_02_315",
        label="02.315",
        description="""Room 02.315//Raum 02.315""",
    )

    roo_02_315b = VocabularyTerm(
        code="ROO_02_315B",
        label="02.315B",
        description="""Room 02.315B//Raum 02.315B""",
    )

    roo_02_316 = VocabularyTerm(
        code="ROO_02_316",
        label="02.316",
        description="""Room 02.316//Raum 02.316""",
    )

    roo_02_317 = VocabularyTerm(
        code="ROO_02_317",
        label="02.317",
        description="""Room 02.317//Raum 02.317""",
    )

    roo_02_317b = VocabularyTerm(
        code="ROO_02_317B",
        label="02.317B",
        description="""Room 02.317B//Raum 02.317B""",
    )

    roo_02_318 = VocabularyTerm(
        code="ROO_02_318",
        label="02.318",
        description="""Room 02.318//Raum 02.318""",
    )

    roo_02_319f = VocabularyTerm(
        code="ROO_02_319F",
        label="02.319F",
        description="""Room 02.319F//Raum 02.319F""",
    )

    roo_02_320a2 = VocabularyTerm(
        code="ROO_02_320A2",
        label="02.320A2",
        description="""Room 02.320A2//Raum 02.320A2""",
    )

    roo_02_320f = VocabularyTerm(
        code="ROO_02_320F",
        label="02.320F",
        description="""Room 02.320F//Raum 02.320F""",
    )

    roo_02_321b = VocabularyTerm(
        code="ROO_02_321B",
        label="02.321B",
        description="""Room 02.321B//Raum 02.321B""",
    )

    roo_02_321c = VocabularyTerm(
        code="ROO_02_321C",
        label="02.321C",
        description="""Room 02.321C//Raum 02.321C""",
    )

    roo_02_321e = VocabularyTerm(
        code="ROO_02_321E",
        label="02.321E",
        description="""Room 02.321E//Raum 02.321E""",
    )

    roo_02_321f = VocabularyTerm(
        code="ROO_02_321F",
        label="02.321F",
        description="""Room 02.321F//Raum 02.321F""",
    )

    roo_02_321t = VocabularyTerm(
        code="ROO_02_321T",
        label="02.321T",
        description="""Room 02.321T//Raum 02.321T""",
    )

    roo_02_322f = VocabularyTerm(
        code="ROO_02_322F",
        label="02.322F",
        description="""Room 02.322F//Raum 02.322F""",
    )

    roo_02_323 = VocabularyTerm(
        code="ROO_02_323",
        label="02.323",
        description="""Room 02.323//Raum 02.323""",
    )

    roo_02_324 = VocabularyTerm(
        code="ROO_02_324",
        label="02.324",
        description="""Room 02.324//Raum 02.324""",
    )

    roo_02_325 = VocabularyTerm(
        code="ROO_02_325",
        label="02.325",
        description="""Room 02.325//Raum 02.325""",
    )

    roo_02_325b = VocabularyTerm(
        code="ROO_02_325B",
        label="02.325B",
        description="""Room 02.325B//Raum 02.325B""",
    )

    roo_02_326 = VocabularyTerm(
        code="ROO_02_326",
        label="02.326",
        description="""Room 02.326//Raum 02.326""",
    )

    roo_02_327 = VocabularyTerm(
        code="ROO_02_327",
        label="02.327",
        description="""Room 02.327//Raum 02.327""",
    )

    roo_02_328 = VocabularyTerm(
        code="ROO_02_328",
        label="02.328",
        description="""Room 02.328//Raum 02.328""",
    )

    roo_02_329 = VocabularyTerm(
        code="ROO_02_329",
        label="02.329",
        description="""Room 02.329//Raum 02.329""",
    )

    roo_02_329b = VocabularyTerm(
        code="ROO_02_329B",
        label="02.329B",
        description="""Room 02.329B//Raum 02.329B""",
    )

    roo_02_329d = VocabularyTerm(
        code="ROO_02_329D",
        label="02.329D",
        description="""Room 02.329D//Raum 02.329D""",
    )

    roo_02_329h = VocabularyTerm(
        code="ROO_02_329H",
        label="02.329H",
        description="""Room 02.329H//Raum 02.329H""",
    )

    roo_02_330 = VocabularyTerm(
        code="ROO_02_330",
        label="02.330",
        description="""Room 02.330//Raum 02.330""",
    )

    roo_02_331 = VocabularyTerm(
        code="ROO_02_331",
        label="02.331",
        description="""Room 02.331//Raum 02.331""",
    )

    roo_02_332 = VocabularyTerm(
        code="ROO_02_332",
        label="02.332",
        description="""Room 02.332//Raum 02.332""",
    )

    roo_02_s01 = VocabularyTerm(
        code="ROO_02_S01",
        label="02.S01",
        description="""Room 02.S01//Raum 02.S01""",
    )

    roo_02_s02 = VocabularyTerm(
        code="ROO_02_S02",
        label="02.S02",
        description="""Room 02.S02//Raum 02.S02""",
    )

    roo_02_s03 = VocabularyTerm(
        code="ROO_02_S03",
        label="02.S03",
        description="""Room 02.S03//Raum 02.S03""",
    )

    roo_02_s04 = VocabularyTerm(
        code="ROO_02_S04",
        label="02.S04",
        description="""Room 02.S04//Raum 02.S04""",
    )

    roo_02_s05 = VocabularyTerm(
        code="ROO_02_S05",
        label="02.S05",
        description="""Room 02.S05//Raum 02.S05""",
    )

    roo_02_s06 = VocabularyTerm(
        code="ROO_02_S06",
        label="02.S06",
        description="""Room 02.S06//Raum 02.S06""",
    )

    roo_02_s08 = VocabularyTerm(
        code="ROO_02_S08",
        label="02.S08",
        description="""Room 02.S08//Raum 02.S08""",
    )

    roo_02_s09 = VocabularyTerm(
        code="ROO_02_S09",
        label="02.S09",
        description="""Room 02.S09//Raum 02.S09""",
    )

    roo_02_s10 = VocabularyTerm(
        code="ROO_02_S10",
        label="02.S10",
        description="""Room 02.S10//Raum 02.S10""",
    )

    roo_02_s11 = VocabularyTerm(
        code="ROO_02_S11",
        label="02.S11",
        description="""Room 02.S11//Raum 02.S11""",
    )

    roo_02_s12 = VocabularyTerm(
        code="ROO_02_S12",
        label="02.S12",
        description="""Room 02.S12//Raum 02.S12""",
    )

    roo_02_s13 = VocabularyTerm(
        code="ROO_02_S13",
        label="02.S13",
        description="""Room 02.S13//Raum 02.S13""",
    )

    roo_02_s14 = VocabularyTerm(
        code="ROO_02_S14",
        label="02.S14",
        description="""Room 02.S14//Raum 02.S14""",
    )

    roo_02_s15 = VocabularyTerm(
        code="ROO_02_S15",
        label="02.S15",
        description="""Room 02.S15//Raum 02.S15""",
    )

    roo_02_s16 = VocabularyTerm(
        code="ROO_02_S16",
        label="02.S16",
        description="""Room 02.S16//Raum 02.S16""",
    )

    roo_03_400f = VocabularyTerm(
        code="ROO_03_400F",
        label="03.400F",
        description="""Room 03.400F//Raum 03.400F""",
    )

    roo_03_400t = VocabularyTerm(
        code="ROO_03_400T",
        label="03.400T",
        description="""Room 03.400T//Raum 03.400T""",
    )

    roo_03_401 = VocabularyTerm(
        code="ROO_03_401",
        label="03.401",
        description="""Room 03.401//Raum 03.401""",
    )

    roo_03_402f = VocabularyTerm(
        code="ROO_03_402F",
        label="03.402F",
        description="""Room 03.402F//Raum 03.402F""",
    )

    roo_03_403 = VocabularyTerm(
        code="ROO_03_403",
        label="03.403",
        description="""Room 03.403//Raum 03.403""",
    )

    roo_03_405a1 = VocabularyTerm(
        code="ROO_03_405A1",
        label="03.405A1",
        description="""Room 03.405A1//Raum 03.405A1""",
    )

    roo_03_405f = VocabularyTerm(
        code="ROO_03_405F",
        label="03.405F",
        description="""Room 03.405F//Raum 03.405F""",
    )

    roo_03_406 = VocabularyTerm(
        code="ROO_03_406",
        label="03.406",
        description="""Room 03.406//Raum 03.406""",
    )

    roo_03_406f = VocabularyTerm(
        code="ROO_03_406F",
        label="03.406F",
        description="""Room 03.406F//Raum 03.406F""",
    )

    roo_03_407 = VocabularyTerm(
        code="ROO_03_407",
        label="03.407",
        description="""Room 03.407//Raum 03.407""",
    )

    roo_03_410 = VocabularyTerm(
        code="ROO_03_410",
        label="03.410",
        description="""Room 03.410//Raum 03.410""",
    )

    roo_03_411 = VocabularyTerm(
        code="ROO_03_411",
        label="03.411",
        description="""Room 03.411//Raum 03.411""",
    )

    roo_03_412 = VocabularyTerm(
        code="ROO_03_412",
        label="03.412",
        description="""Room 03.412//Raum 03.412""",
    )

    roo_03_412b = VocabularyTerm(
        code="ROO_03_412B",
        label="03.412B",
        description="""Room 03.412B//Raum 03.412B""",
    )

    roo_03_412c = VocabularyTerm(
        code="ROO_03_412C",
        label="03.412C",
        description="""Room 03.412C//Raum 03.412C""",
    )

    roo_03_413 = VocabularyTerm(
        code="ROO_03_413",
        label="03.413",
        description="""Room 03.413//Raum 03.413""",
    )

    roo_03_413b = VocabularyTerm(
        code="ROO_03_413B",
        label="03.413B",
        description="""Room 03.413B//Raum 03.413B""",
    )

    roo_03_414 = VocabularyTerm(
        code="ROO_03_414",
        label="03.414",
        description="""Room 03.414//Raum 03.414""",
    )

    roo_03_414b = VocabularyTerm(
        code="ROO_03_414B",
        label="03.414B",
        description="""Room 03.414B//Raum 03.414B""",
    )

    roo_03_416 = VocabularyTerm(
        code="ROO_03_416",
        label="03.416",
        description="""Room 03.416//Raum 03.416""",
    )

    roo_03_417b = VocabularyTerm(
        code="ROO_03_417B",
        label="03.417B",
        description="""Room 03.417B//Raum 03.417B""",
    )

    roo_03_419f = VocabularyTerm(
        code="ROO_03_419F",
        label="03.419F",
        description="""Room 03.419F//Raum 03.419F""",
    )

    roo_03_420a2 = VocabularyTerm(
        code="ROO_03_420A2",
        label="03.420A2",
        description="""Room 03.420A2//Raum 03.420A2""",
    )

    roo_03_420f = VocabularyTerm(
        code="ROO_03_420F",
        label="03.420F",
        description="""Room 03.420F//Raum 03.420F""",
    )

    roo_03_421b = VocabularyTerm(
        code="ROO_03_421B",
        label="03.421B",
        description="""Room 03.421B//Raum 03.421B""",
    )

    roo_03_421c = VocabularyTerm(
        code="ROO_03_421C",
        label="03.421C",
        description="""Room 03.421C//Raum 03.421C""",
    )

    roo_03_421e = VocabularyTerm(
        code="ROO_03_421E",
        label="03.421E",
        description="""Room 03.421E//Raum 03.421E""",
    )

    roo_03_421f = VocabularyTerm(
        code="ROO_03_421F",
        label="03.421F",
        description="""Room 03.421F//Raum 03.421F""",
    )

    roo_03_421t = VocabularyTerm(
        code="ROO_03_421T",
        label="03.421T",
        description="""Room 03.421T//Raum 03.421T""",
    )

    roo_03_422f = VocabularyTerm(
        code="ROO_03_422F",
        label="03.422F",
        description="""Room 03.422F//Raum 03.422F""",
    )

    roo_03_423 = VocabularyTerm(
        code="ROO_03_423",
        label="03.423",
        description="""Room 03.423//Raum 03.423""",
    )

    roo_03_424 = VocabularyTerm(
        code="ROO_03_424",
        label="03.424",
        description="""Room 03.424//Raum 03.424""",
    )

    roo_03_425 = VocabularyTerm(
        code="ROO_03_425",
        label="03.425",
        description="""Room 03.425//Raum 03.425""",
    )

    roo_03_425b = VocabularyTerm(
        code="ROO_03_425B",
        label="03.425B",
        description="""Room 03.425B//Raum 03.425B""",
    )

    roo_03_426 = VocabularyTerm(
        code="ROO_03_426",
        label="03.426",
        description="""Room 03.426//Raum 03.426""",
    )

    roo_03_426b = VocabularyTerm(
        code="ROO_03_426B",
        label="03.426B",
        description="""Room 03.426B//Raum 03.426B""",
    )

    roo_03_427 = VocabularyTerm(
        code="ROO_03_427",
        label="03.427",
        description="""Room 03.427//Raum 03.427""",
    )

    roo_03_427b = VocabularyTerm(
        code="ROO_03_427B",
        label="03.427B",
        description="""Room 03.427B//Raum 03.427B""",
    )

    roo_03_428 = VocabularyTerm(
        code="ROO_03_428",
        label="03.428",
        description="""Room 03.428//Raum 03.428""",
    )

    roo_03_428b = VocabularyTerm(
        code="ROO_03_428B",
        label="03.428B",
        description="""Room 03.428B//Raum 03.428B""",
    )

    roo_03_429 = VocabularyTerm(
        code="ROO_03_429",
        label="03.429",
        description="""Room 03.429//Raum 03.429""",
    )

    roo_03_429b = VocabularyTerm(
        code="ROO_03_429B",
        label="03.429B",
        description="""Room 03.429B//Raum 03.429B""",
    )

    roo_03_429d = VocabularyTerm(
        code="ROO_03_429D",
        label="03.429D",
        description="""Room 03.429D//Raum 03.429D""",
    )

    roo_03_429h = VocabularyTerm(
        code="ROO_03_429H",
        label="03.429H",
        description="""Room 03.429H//Raum 03.429H""",
    )

    roo_03_430 = VocabularyTerm(
        code="ROO_03_430",
        label="03.430",
        description="""Room 03.430//Raum 03.430""",
    )

    roo_03_431 = VocabularyTerm(
        code="ROO_03_431",
        label="03.431",
        description="""Room 03.431//Raum 03.431""",
    )

    roo_03_432 = VocabularyTerm(
        code="ROO_03_432",
        label="03.432",
        description="""Room 03.432//Raum 03.432""",
    )

    roo_03_s00 = VocabularyTerm(
        code="ROO_03_S00",
        label="03.S00",
        description="""Room 03.S00//Raum 03.S00""",
    )

    roo_03_s01 = VocabularyTerm(
        code="ROO_03_S01",
        label="03.S01",
        description="""Room 03.S01//Raum 03.S01""",
    )

    roo_03_s02 = VocabularyTerm(
        code="ROO_03_S02",
        label="03.S02",
        description="""Room 03.S02//Raum 03.S02""",
    )

    roo_03_s03 = VocabularyTerm(
        code="ROO_03_S03",
        label="03.S03",
        description="""Room 03.S03//Raum 03.S03""",
    )

    roo_03_s04 = VocabularyTerm(
        code="ROO_03_S04",
        label="03.S04",
        description="""Room 03.S04//Raum 03.S04""",
    )

    roo_03_s05 = VocabularyTerm(
        code="ROO_03_S05",
        label="03.S05",
        description="""Room 03.S05//Raum 03.S05""",
    )

    roo_03_s06 = VocabularyTerm(
        code="ROO_03_S06",
        label="03.S06",
        description="""Room 03.S06//Raum 03.S06""",
    )

    roo_03_s07 = VocabularyTerm(
        code="ROO_03_S07",
        label="03.S07",
        description="""Room 03.S07//Raum 03.S07""",
    )

    roo_03_s08 = VocabularyTerm(
        code="ROO_03_S08",
        label="03.S08",
        description="""Room 03.S08//Raum 03.S08""",
    )

    roo_03_s09 = VocabularyTerm(
        code="ROO_03_S09",
        label="03.S09",
        description="""Room 03.S09//Raum 03.S09""",
    )

    roo_03_s10 = VocabularyTerm(
        code="ROO_03_S10",
        label="03.S10",
        description="""Room 03.S10//Raum 03.S10""",
    )

    roo_03_s11 = VocabularyTerm(
        code="ROO_03_S11",
        label="03.S11",
        description="""Room 03.S11//Raum 03.S11""",
    )

    roo_03_s12 = VocabularyTerm(
        code="ROO_03_S12",
        label="03.S12",
        description="""Room 03.S12//Raum 03.S12""",
    )

    roo_03_s13 = VocabularyTerm(
        code="ROO_03_S13",
        label="03.S13",
        description="""Room 03.S13//Raum 03.S13""",
    )

    roo_03_s14 = VocabularyTerm(
        code="ROO_03_S14",
        label="03.S14",
        description="""Room 03.S14//Raum 03.S14""",
    )

    roo_03_s15 = VocabularyTerm(
        code="ROO_03_S15",
        label="03.S15",
        description="""Room 03.S15//Raum 03.S15""",
    )

    roo_03_s16 = VocabularyTerm(
        code="ROO_03_S16",
        label="03.S16",
        description="""Room 03.S16//Raum 03.S16""",
    )

    roo_04_500f = VocabularyTerm(
        code="ROO_04_500F",
        label="04.500F",
        description="""Room 04.500F//Raum 04.500F""",
    )

    roo_04_500t = VocabularyTerm(
        code="ROO_04_500T",
        label="04.500T",
        description="""Room 04.500T//Raum 04.500T""",
    )

    roo_04_501 = VocabularyTerm(
        code="ROO_04_501",
        label="04.501",
        description="""Room 04.501//Raum 04.501""",
    )

    roo_04_502f = VocabularyTerm(
        code="ROO_04_502F",
        label="04.502F",
        description="""Room 04.502F//Raum 04.502F""",
    )

    roo_04_503 = VocabularyTerm(
        code="ROO_04_503",
        label="04.503",
        description="""Room 04.503//Raum 04.503""",
    )

    roo_04_505 = VocabularyTerm(
        code="ROO_04_505",
        label="04.505",
        description="""Room 04.505//Raum 04.505""",
    )

    roo_04_505a1 = VocabularyTerm(
        code="ROO_04_505A1",
        label="04.505A1",
        description="""Room 04.505A1//Raum 04.505A1""",
    )

    roo_04_505f = VocabularyTerm(
        code="ROO_04_505F",
        label="04.505F",
        description="""Room 04.505F//Raum 04.505F""",
    )

    roo_04_506 = VocabularyTerm(
        code="ROO_04_506",
        label="04.506",
        description="""Room 04.506//Raum 04.506""",
    )

    roo_04_506f = VocabularyTerm(
        code="ROO_04_506F",
        label="04.506F",
        description="""Room 04.506F//Raum 04.506F""",
    )

    roo_04_507 = VocabularyTerm(
        code="ROO_04_507",
        label="04.507",
        description="""Room 04.507//Raum 04.507""",
    )

    roo_04_508 = VocabularyTerm(
        code="ROO_04_508",
        label="04.508",
        description="""Room 04.508//Raum 04.508""",
    )

    roo_04_510 = VocabularyTerm(
        code="ROO_04_510",
        label="04.510",
        description="""Room 04.510//Raum 04.510""",
    )

    roo_04_511 = VocabularyTerm(
        code="ROO_04_511",
        label="04.511",
        description="""Room 04.511//Raum 04.511""",
    )

    roo_04_512 = VocabularyTerm(
        code="ROO_04_512",
        label="04.512",
        description="""Room 04.512//Raum 04.512""",
    )

    roo_04_512b = VocabularyTerm(
        code="ROO_04_512B",
        label="04.512B",
        description="""Room 04.512B//Raum 04.512B""",
    )

    roo_04_512c = VocabularyTerm(
        code="ROO_04_512C",
        label="04.512C",
        description="""Room 04.512C//Raum 04.512C""",
    )

    roo_04_513 = VocabularyTerm(
        code="ROO_04_513",
        label="04.513",
        description="""Room 04.513//Raum 04.513""",
    )

    roo_04_513b = VocabularyTerm(
        code="ROO_04_513B",
        label="04.513B",
        description="""Room 04.513B//Raum 04.513B""",
    )

    roo_04_514 = VocabularyTerm(
        code="ROO_04_514",
        label="04.514",
        description="""Room 04.514//Raum 04.514""",
    )

    roo_04_514b = VocabularyTerm(
        code="ROO_04_514B",
        label="04.514B",
        description="""Room 04.514B//Raum 04.514B""",
    )

    roo_04_515 = VocabularyTerm(
        code="ROO_04_515",
        label="04.515",
        description="""Room 04.515//Raum 04.515""",
    )

    roo_04_516 = VocabularyTerm(
        code="ROO_04_516",
        label="04.516",
        description="""Room 04.516//Raum 04.516""",
    )

    roo_04_517 = VocabularyTerm(
        code="ROO_04_517",
        label="04.517",
        description="""Room 04.517//Raum 04.517""",
    )

    roo_04_517b = VocabularyTerm(
        code="ROO_04_517B",
        label="04.517B",
        description="""Room 04.517B//Raum 04.517B""",
    )

    roo_04_518 = VocabularyTerm(
        code="ROO_04_518",
        label="04.518",
        description="""Room 04.518//Raum 04.518""",
    )

    roo_04_519f = VocabularyTerm(
        code="ROO_04_519F",
        label="04.519F",
        description="""Room 04.519F//Raum 04.519F""",
    )

    roo_04_520a2 = VocabularyTerm(
        code="ROO_04_520A2",
        label="04.520A2",
        description="""Room 04.520A2//Raum 04.520A2""",
    )

    roo_04_520f = VocabularyTerm(
        code="ROO_04_520F",
        label="04.520F",
        description="""Room 04.520F//Raum 04.520F""",
    )

    roo_04_521b = VocabularyTerm(
        code="ROO_04_521B",
        label="04.521B",
        description="""Room 04.521B//Raum 04.521B""",
    )

    roo_04_521c = VocabularyTerm(
        code="ROO_04_521C",
        label="04.521C",
        description="""Room 04.521C//Raum 04.521C""",
    )

    roo_04_521e = VocabularyTerm(
        code="ROO_04_521E",
        label="04.521E",
        description="""Room 04.521E//Raum 04.521E""",
    )

    roo_04_521f = VocabularyTerm(
        code="ROO_04_521F",
        label="04.521F",
        description="""Room 04.521F//Raum 04.521F""",
    )

    roo_04_521t = VocabularyTerm(
        code="ROO_04_521T",
        label="04.521T",
        description="""Room 04.521T//Raum 04.521T""",
    )

    roo_04_522f = VocabularyTerm(
        code="ROO_04_522F",
        label="04.522F",
        description="""Room 04.522F//Raum 04.522F""",
    )

    roo_04_523 = VocabularyTerm(
        code="ROO_04_523",
        label="04.523",
        description="""Room 04.523//Raum 04.523""",
    )

    roo_04_524 = VocabularyTerm(
        code="ROO_04_524",
        label="04.524",
        description="""Room 04.524//Raum 04.524""",
    )

    roo_04_525 = VocabularyTerm(
        code="ROO_04_525",
        label="04.525",
        description="""Room 04.525//Raum 04.525""",
    )

    roo_04_525b = VocabularyTerm(
        code="ROO_04_525B",
        label="04.525B",
        description="""Room 04.525B//Raum 04.525B""",
    )

    roo_04_526 = VocabularyTerm(
        code="ROO_04_526",
        label="04.526",
        description="""Room 04.526//Raum 04.526""",
    )

    roo_04_527 = VocabularyTerm(
        code="ROO_04_527",
        label="04.527",
        description="""Room 04.527//Raum 04.527""",
    )

    roo_04_527b = VocabularyTerm(
        code="ROO_04_527B",
        label="04.527B",
        description="""Room 04.527B//Raum 04.527B""",
    )

    roo_04_528 = VocabularyTerm(
        code="ROO_04_528",
        label="04.528",
        description="""Room 04.528//Raum 04.528""",
    )

    roo_04_528wc = VocabularyTerm(
        code="ROO_04_528WC",
        label="04.528WC",
        description="""Room 04.528WC//Raum 04.528WC""",
    )

    roo_04_529 = VocabularyTerm(
        code="ROO_04_529",
        label="04.529",
        description="""Room 04.529//Raum 04.529""",
    )

    roo_04_529b = VocabularyTerm(
        code="ROO_04_529B",
        label="04.529B",
        description="""Room 04.529B//Raum 04.529B""",
    )

    roo_04_529d = VocabularyTerm(
        code="ROO_04_529D",
        label="04.529D",
        description="""Room 04.529D//Raum 04.529D""",
    )

    roo_04_529h = VocabularyTerm(
        code="ROO_04_529H",
        label="04.529H",
        description="""Room 04.529H//Raum 04.529H""",
    )

    roo_04_530 = VocabularyTerm(
        code="ROO_04_530",
        label="04.530",
        description="""Room 04.530//Raum 04.530""",
    )

    roo_04_531 = VocabularyTerm(
        code="ROO_04_531",
        label="04.531",
        description="""Room 04.531//Raum 04.531""",
    )

    roo_04_532 = VocabularyTerm(
        code="ROO_04_532",
        label="04.532",
        description="""Room 04.532//Raum 04.532""",
    )

    roo_04_s00 = VocabularyTerm(
        code="ROO_04_S00",
        label="04.S00",
        description="""Room 04.S00//Raum 04.S00""",
    )

    roo_04_s01 = VocabularyTerm(
        code="ROO_04_S01",
        label="04.S01",
        description="""Room 04.S01//Raum 04.S01""",
    )

    roo_04_s02 = VocabularyTerm(
        code="ROO_04_S02",
        label="04.S02",
        description="""Room 04.S02//Raum 04.S02""",
    )

    roo_04_s03 = VocabularyTerm(
        code="ROO_04_S03",
        label="04.S03",
        description="""Room 04.S03//Raum 04.S03""",
    )

    roo_04_s04 = VocabularyTerm(
        code="ROO_04_S04",
        label="04.S04",
        description="""Room 04.S04//Raum 04.S04""",
    )

    roo_04_s05 = VocabularyTerm(
        code="ROO_04_S05",
        label="04.S05",
        description="""Room 04.S05//Raum 04.S05""",
    )

    roo_04_s06 = VocabularyTerm(
        code="ROO_04_S06",
        label="04.S06",
        description="""Room 04.S06//Raum 04.S06""",
    )

    roo_04_s07 = VocabularyTerm(
        code="ROO_04_S07",
        label="04.S07",
        description="""Room 04.S07//Raum 04.S07""",
    )

    roo_04_s08 = VocabularyTerm(
        code="ROO_04_S08",
        label="04.S08",
        description="""Room 04.S08//Raum 04.S08""",
    )

    roo_04_s09 = VocabularyTerm(
        code="ROO_04_S09",
        label="04.S09",
        description="""Room 04.S09//Raum 04.S09""",
    )

    roo_04_s10 = VocabularyTerm(
        code="ROO_04_S10",
        label="04.S10",
        description="""Room 04.S10//Raum 04.S10""",
    )

    roo_04_s11 = VocabularyTerm(
        code="ROO_04_S11",
        label="04.S11",
        description="""Room 04.S11//Raum 04.S11""",
    )

    roo_04_s12 = VocabularyTerm(
        code="ROO_04_S12",
        label="04.S12",
        description="""Room 04.S12//Raum 04.S12""",
    )

    roo_04_s13 = VocabularyTerm(
        code="ROO_04_S13",
        label="04.S13",
        description="""Room 04.S13//Raum 04.S13""",
    )

    roo_04_s14 = VocabularyTerm(
        code="ROO_04_S14",
        label="04.S14",
        description="""Room 04.S14//Raum 04.S14""",
    )

    roo_04_s15 = VocabularyTerm(
        code="ROO_04_S15",
        label="04.S15",
        description="""Room 04.S15//Raum 04.S15""",
    )

    roo_04_s16 = VocabularyTerm(
        code="ROO_04_S16",
        label="04.S16",
        description="""Room 04.S16//Raum 04.S16""",
    )

    roo_05_62 = VocabularyTerm(
        code="ROO_05_62",
        label="05.62",
        description="""Room 05.62//Raum 05.62""",
    )

    roo_05_600f = VocabularyTerm(
        code="ROO_05_600F",
        label="05.600F",
        description="""Room 05.600F//Raum 05.600F""",
    )

    roo_05_600t = VocabularyTerm(
        code="ROO_05_600T",
        label="05.600T",
        description="""Room 05.600T//Raum 05.600T""",
    )

    roo_05_601 = VocabularyTerm(
        code="ROO_05_601",
        label="05.601",
        description="""Room 05.601//Raum 05.601""",
    )

    roo_05_602f = VocabularyTerm(
        code="ROO_05_602F",
        label="05.602F",
        description="""Room 05.602F//Raum 05.602F""",
    )

    roo_05_603 = VocabularyTerm(
        code="ROO_05_603",
        label="05.603",
        description="""Room 05.603//Raum 05.603""",
    )

    roo_05_605 = VocabularyTerm(
        code="ROO_05_605",
        label="05.605",
        description="""Room 05.605//Raum 05.605""",
    )

    roo_05_605a1 = VocabularyTerm(
        code="ROO_05_605A1",
        label="05.605A1",
        description="""Room 05.605A1//Raum 05.605A1""",
    )

    roo_05_605f = VocabularyTerm(
        code="ROO_05_605F",
        label="05.605F",
        description="""Room 05.605F//Raum 05.605F""",
    )

    roo_05_606 = VocabularyTerm(
        code="ROO_05_606",
        label="05.606",
        description="""Room 05.606//Raum 05.606""",
    )

    roo_05_606f = VocabularyTerm(
        code="ROO_05_606F",
        label="05.606F",
        description="""Room 05.606F//Raum 05.606F""",
    )

    roo_05_607 = VocabularyTerm(
        code="ROO_05_607",
        label="05.607",
        description="""Room 05.607//Raum 05.607""",
    )

    roo_05_610 = VocabularyTerm(
        code="ROO_05_610",
        label="05.610",
        description="""Room 05.610//Raum 05.610""",
    )

    roo_05_612 = VocabularyTerm(
        code="ROO_05_612",
        label="05.612",
        description="""Room 05.612//Raum 05.612""",
    )

    roo_05_612b = VocabularyTerm(
        code="ROO_05_612B",
        label="05.612B",
        description="""Room 05.612B//Raum 05.612B""",
    )

    roo_05_612c = VocabularyTerm(
        code="ROO_05_612C",
        label="05.612C",
        description="""Room 05.612C//Raum 05.612C""",
    )

    roo_05_613 = VocabularyTerm(
        code="ROO_05_613",
        label="05.613",
        description="""Room 05.613//Raum 05.613""",
    )

    roo_05_613b = VocabularyTerm(
        code="ROO_05_613B",
        label="05.613B",
        description="""Room 05.613B//Raum 05.613B""",
    )

    roo_05_614 = VocabularyTerm(
        code="ROO_05_614",
        label="05.614",
        description="""Room 05.614//Raum 05.614""",
    )

    roo_05_614b = VocabularyTerm(
        code="ROO_05_614B",
        label="05.614B",
        description="""Room 05.614B//Raum 05.614B""",
    )

    roo_05_616 = VocabularyTerm(
        code="ROO_05_616",
        label="05.616",
        description="""Room 05.616//Raum 05.616""",
    )

    roo_05_616b = VocabularyTerm(
        code="ROO_05_616B",
        label="05.616B",
        description="""Room 05.616B//Raum 05.616B""",
    )

    roo_05_617b = VocabularyTerm(
        code="ROO_05_617B",
        label="05.617B",
        description="""Room 05.617B//Raum 05.617B""",
    )

    roo_05_619f = VocabularyTerm(
        code="ROO_05_619F",
        label="05.619F",
        description="""Room 05.619F//Raum 05.619F""",
    )

    roo_05_620a2 = VocabularyTerm(
        code="ROO_05_620A2",
        label="05.620A2",
        description="""Room 05.620A2//Raum 05.620A2""",
    )

    roo_05_620f = VocabularyTerm(
        code="ROO_05_620F",
        label="05.620F",
        description="""Room 05.620F//Raum 05.620F""",
    )

    roo_05_621b = VocabularyTerm(
        code="ROO_05_621B",
        label="05.621B",
        description="""Room 05.621B//Raum 05.621B""",
    )

    roo_05_621c = VocabularyTerm(
        code="ROO_05_621C",
        label="05.621C",
        description="""Room 05.621C//Raum 05.621C""",
    )

    roo_05_621e = VocabularyTerm(
        code="ROO_05_621E",
        label="05.621E",
        description="""Room 05.621E//Raum 05.621E""",
    )

    roo_05_621f = VocabularyTerm(
        code="ROO_05_621F",
        label="05.621F",
        description="""Room 05.621F//Raum 05.621F""",
    )

    roo_05_621t = VocabularyTerm(
        code="ROO_05_621T",
        label="05.621T",
        description="""Room 05.621T//Raum 05.621T""",
    )

    roo_05_622f = VocabularyTerm(
        code="ROO_05_622F",
        label="05.622F",
        description="""Room 05.622F//Raum 05.622F""",
    )

    roo_05_623 = VocabularyTerm(
        code="ROO_05_623",
        label="05.623",
        description="""Room 05.623//Raum 05.623""",
    )

    roo_05_625 = VocabularyTerm(
        code="ROO_05_625",
        label="05.625",
        description="""Room 05.625//Raum 05.625""",
    )

    roo_05_625b = VocabularyTerm(
        code="ROO_05_625B",
        label="05.625B",
        description="""Room 05.625B//Raum 05.625B""",
    )

    roo_05_626 = VocabularyTerm(
        code="ROO_05_626",
        label="05.626",
        description="""Room 05.626//Raum 05.626""",
    )

    roo_05_626b = VocabularyTerm(
        code="ROO_05_626B",
        label="05.626B",
        description="""Room 05.626B//Raum 05.626B""",
    )

    roo_05_627 = VocabularyTerm(
        code="ROO_05_627",
        label="05.627",
        description="""Room 05.627//Raum 05.627""",
    )

    roo_05_628 = VocabularyTerm(
        code="ROO_05_628",
        label="05.628",
        description="""Room 05.628//Raum 05.628""",
    )

    roo_05_629 = VocabularyTerm(
        code="ROO_05_629",
        label="05.629",
        description="""Room 05.629//Raum 05.629""",
    )

    roo_05_629b = VocabularyTerm(
        code="ROO_05_629B",
        label="05.629B",
        description="""Room 05.629B//Raum 05.629B""",
    )

    roo_05_629d = VocabularyTerm(
        code="ROO_05_629D",
        label="05.629D",
        description="""Room 05.629D//Raum 05.629D""",
    )

    roo_05_629h = VocabularyTerm(
        code="ROO_05_629H",
        label="05.629H",
        description="""Room 05.629H//Raum 05.629H""",
    )

    roo_05_630 = VocabularyTerm(
        code="ROO_05_630",
        label="05.630",
        description="""Room 05.630//Raum 05.630""",
    )

    roo_05_631 = VocabularyTerm(
        code="ROO_05_631",
        label="05.631",
        description="""Room 05.631//Raum 05.631""",
    )

    roo_05_632 = VocabularyTerm(
        code="ROO_05_632",
        label="05.632",
        description="""Room 05.632//Raum 05.632""",
    )

    roo_05_633 = VocabularyTerm(
        code="ROO_05_633",
        label="05.633",
        description="""Room 05.633//Raum 05.633""",
    )

    roo_05_s00 = VocabularyTerm(
        code="ROO_05_S00",
        label="05.S00",
        description="""Room 05.S00//Raum 05.S00""",
    )

    roo_05_s01 = VocabularyTerm(
        code="ROO_05_S01",
        label="05.S01",
        description="""Room 05.S01//Raum 05.S01""",
    )

    roo_05_s02 = VocabularyTerm(
        code="ROO_05_S02",
        label="05.S02",
        description="""Room 05.S02//Raum 05.S02""",
    )

    roo_05_s03 = VocabularyTerm(
        code="ROO_05_S03",
        label="05.S03",
        description="""Room 05.S03//Raum 05.S03""",
    )

    roo_05_s04 = VocabularyTerm(
        code="ROO_05_S04",
        label="05.S04",
        description="""Room 05.S04//Raum 05.S04""",
    )

    roo_05_s05 = VocabularyTerm(
        code="ROO_05_S05",
        label="05.S05",
        description="""Room 05.S05//Raum 05.S05""",
    )

    roo_05_s06 = VocabularyTerm(
        code="ROO_05_S06",
        label="05.S06",
        description="""Room 05.S06//Raum 05.S06""",
    )

    roo_05_s07 = VocabularyTerm(
        code="ROO_05_S07",
        label="05.S07",
        description="""Room 05.S07//Raum 05.S07""",
    )

    roo_05_s08 = VocabularyTerm(
        code="ROO_05_S08",
        label="05.S08",
        description="""Room 05.S08//Raum 05.S08""",
    )

    roo_05_s09 = VocabularyTerm(
        code="ROO_05_S09",
        label="05.S09",
        description="""Room 05.S09//Raum 05.S09""",
    )

    roo_05_s10 = VocabularyTerm(
        code="ROO_05_S10",
        label="05.S10",
        description="""Room 05.S10//Raum 05.S10""",
    )

    roo_05_s11 = VocabularyTerm(
        code="ROO_05_S11",
        label="05.S11",
        description="""Room 05.S11//Raum 05.S11""",
    )

    roo_05_s12 = VocabularyTerm(
        code="ROO_05_S12",
        label="05.S12",
        description="""Room 05.S12//Raum 05.S12""",
    )

    roo_05_s13 = VocabularyTerm(
        code="ROO_05_S13",
        label="05.S13",
        description="""Room 05.S13//Raum 05.S13""",
    )

    roo_05_s14 = VocabularyTerm(
        code="ROO_05_S14",
        label="05.S14",
        description="""Room 05.S14//Raum 05.S14""",
    )

    roo_05_s15 = VocabularyTerm(
        code="ROO_05_S15",
        label="05.S15",
        description="""Room 05.S15//Raum 05.S15""",
    )

    roo_05_s16 = VocabularyTerm(
        code="ROO_05_S16",
        label="05.S16",
        description="""Room 05.S16//Raum 05.S16""",
    )

    roo_06_700f = VocabularyTerm(
        code="ROO_06_700F",
        label="06.700F",
        description="""Room 06.700F//Raum 06.700F""",
    )

    roo_06_700t = VocabularyTerm(
        code="ROO_06_700T",
        label="06.700T",
        description="""Room 06.700T//Raum 06.700T""",
    )

    roo_06_701 = VocabularyTerm(
        code="ROO_06_701",
        label="06.701",
        description="""Room 06.701//Raum 06.701""",
    )

    roo_06_702f = VocabularyTerm(
        code="ROO_06_702F",
        label="06.702F",
        description="""Room 06.702F//Raum 06.702F""",
    )

    roo_06_703 = VocabularyTerm(
        code="ROO_06_703",
        label="06.703",
        description="""Room 06.703//Raum 06.703""",
    )

    roo_06_705 = VocabularyTerm(
        code="ROO_06_705",
        label="06.705",
        description="""Room 06.705//Raum 06.705""",
    )

    roo_06_705a1 = VocabularyTerm(
        code="ROO_06_705A1",
        label="06.705A1",
        description="""Room 06.705A1//Raum 06.705A1""",
    )

    roo_06_705f = VocabularyTerm(
        code="ROO_06_705F",
        label="06.705F",
        description="""Room 06.705F//Raum 06.705F""",
    )

    roo_06_706 = VocabularyTerm(
        code="ROO_06_706",
        label="06.706",
        description="""Room 06.706//Raum 06.706""",
    )

    roo_06_706f = VocabularyTerm(
        code="ROO_06_706F",
        label="06.706F",
        description="""Room 06.706F//Raum 06.706F""",
    )

    roo_06_708 = VocabularyTerm(
        code="ROO_06_708",
        label="06.708",
        description="""Room 06.708//Raum 06.708""",
    )

    roo_06_710 = VocabularyTerm(
        code="ROO_06_710",
        label="06.710",
        description="""Room 06.710//Raum 06.710""",
    )

    roo_06_712 = VocabularyTerm(
        code="ROO_06_712",
        label="06.712",
        description="""Room 06.712//Raum 06.712""",
    )

    roo_06_712b = VocabularyTerm(
        code="ROO_06_712B",
        label="06.712B",
        description="""Room 06.712B//Raum 06.712B""",
    )

    roo_06_712c = VocabularyTerm(
        code="ROO_06_712C",
        label="06.712C",
        description="""Room 06.712C//Raum 06.712C""",
    )

    roo_06_713 = VocabularyTerm(
        code="ROO_06_713",
        label="06.713",
        description="""Room 06.713//Raum 06.713""",
    )

    roo_06_713b = VocabularyTerm(
        code="ROO_06_713B",
        label="06.713B",
        description="""Room 06.713B//Raum 06.713B""",
    )

    roo_06_714b = VocabularyTerm(
        code="ROO_06_714B",
        label="06.714B",
        description="""Room 06.714B//Raum 06.714B""",
    )

    roo_06_715 = VocabularyTerm(
        code="ROO_06_715",
        label="06.715",
        description="""Room 06.715//Raum 06.715""",
    )

    roo_06_715b = VocabularyTerm(
        code="ROO_06_715B",
        label="06.715B",
        description="""Room 06.715B//Raum 06.715B""",
    )

    roo_06_716b = VocabularyTerm(
        code="ROO_06_716B",
        label="06.716B",
        description="""Room 06.716B//Raum 06.716B""",
    )

    roo_06_717 = VocabularyTerm(
        code="ROO_06_717",
        label="06.717",
        description="""Room 06.717//Raum 06.717""",
    )

    roo_06_719f = VocabularyTerm(
        code="ROO_06_719F",
        label="06.719F",
        description="""Room 06.719F//Raum 06.719F""",
    )

    roo_06_720a2 = VocabularyTerm(
        code="ROO_06_720A2",
        label="06.720A2",
        description="""Room 06.720A2//Raum 06.720A2""",
    )

    roo_06_720f = VocabularyTerm(
        code="ROO_06_720F",
        label="06.720F",
        description="""Room 06.720F//Raum 06.720F""",
    )

    roo_06_721b = VocabularyTerm(
        code="ROO_06_721B",
        label="06.721B",
        description="""Room 06.721B//Raum 06.721B""",
    )

    roo_06_721c = VocabularyTerm(
        code="ROO_06_721C",
        label="06.721C",
        description="""Room 06.721C//Raum 06.721C""",
    )

    roo_06_721e = VocabularyTerm(
        code="ROO_06_721E",
        label="06.721E",
        description="""Room 06.721E//Raum 06.721E""",
    )

    roo_06_721f = VocabularyTerm(
        code="ROO_06_721F",
        label="06.721F",
        description="""Room 06.721F//Raum 06.721F""",
    )

    roo_06_721t = VocabularyTerm(
        code="ROO_06_721T",
        label="06.721T",
        description="""Room 06.721T//Raum 06.721T""",
    )

    roo_06_722f = VocabularyTerm(
        code="ROO_06_722F",
        label="06.722F",
        description="""Room 06.722F//Raum 06.722F""",
    )

    roo_06_723 = VocabularyTerm(
        code="ROO_06_723",
        label="06.723",
        description="""Room 06.723//Raum 06.723""",
    )

    roo_06_724 = VocabularyTerm(
        code="ROO_06_724",
        label="06.724",
        description="""Room 06.724//Raum 06.724""",
    )

    roo_06_724b = VocabularyTerm(
        code="ROO_06_724B",
        label="06.724B",
        description="""Room 06.724B//Raum 06.724B""",
    )

    roo_06_725 = VocabularyTerm(
        code="ROO_06_725",
        label="06.725",
        description="""Room 06.725//Raum 06.725""",
    )

    roo_06_725b = VocabularyTerm(
        code="ROO_06_725B",
        label="06.725B",
        description="""Room 06.725B//Raum 06.725B""",
    )

    roo_06_726 = VocabularyTerm(
        code="ROO_06_726",
        label="06.726",
        description="""Room 06.726//Raum 06.726""",
    )

    roo_06_726b = VocabularyTerm(
        code="ROO_06_726B",
        label="06.726B",
        description="""Room 06.726B//Raum 06.726B""",
    )

    roo_06_727 = VocabularyTerm(
        code="ROO_06_727",
        label="06.727",
        description="""Room 06.727//Raum 06.727""",
    )

    roo_06_727b = VocabularyTerm(
        code="ROO_06_727B",
        label="06.727B",
        description="""Room 06.727B//Raum 06.727B""",
    )

    roo_06_728 = VocabularyTerm(
        code="ROO_06_728",
        label="06.728",
        description="""Room 06.728//Raum 06.728""",
    )

    roo_06_728b = VocabularyTerm(
        code="ROO_06_728B",
        label="06.728B",
        description="""Room 06.728B//Raum 06.728B""",
    )

    roo_06_729 = VocabularyTerm(
        code="ROO_06_729",
        label="06.729",
        description="""Room 06.729//Raum 06.729""",
    )

    roo_06_729b = VocabularyTerm(
        code="ROO_06_729B",
        label="06.729B",
        description="""Room 06.729B//Raum 06.729B""",
    )

    roo_06_729d = VocabularyTerm(
        code="ROO_06_729D",
        label="06.729D",
        description="""Room 06.729D//Raum 06.729D""",
    )

    roo_06_729h = VocabularyTerm(
        code="ROO_06_729H",
        label="06.729H",
        description="""Room 06.729H//Raum 06.729H""",
    )

    roo_06_730 = VocabularyTerm(
        code="ROO_06_730",
        label="06.730",
        description="""Room 06.730//Raum 06.730""",
    )

    roo_06_731 = VocabularyTerm(
        code="ROO_06_731",
        label="06.731",
        description="""Room 06.731//Raum 06.731""",
    )

    roo_06_732 = VocabularyTerm(
        code="ROO_06_732",
        label="06.732",
        description="""Room 06.732//Raum 06.732""",
    )

    roo_06_733 = VocabularyTerm(
        code="ROO_06_733",
        label="06.733",
        description="""Room 06.733//Raum 06.733""",
    )

    roo_06_s00 = VocabularyTerm(
        code="ROO_06_S00",
        label="06.S00",
        description="""Room 06.S00//Raum 06.S00""",
    )

    roo_06_s01 = VocabularyTerm(
        code="ROO_06_S01",
        label="06.S01",
        description="""Room 06.S01//Raum 06.S01""",
    )

    roo_06_s02 = VocabularyTerm(
        code="ROO_06_S02",
        label="06.S02",
        description="""Room 06.S02//Raum 06.S02""",
    )

    roo_06_s03 = VocabularyTerm(
        code="ROO_06_S03",
        label="06.S03",
        description="""Room 06.S03//Raum 06.S03""",
    )

    roo_06_s04 = VocabularyTerm(
        code="ROO_06_S04",
        label="06.S04",
        description="""Room 06.S04//Raum 06.S04""",
    )

    roo_06_s05 = VocabularyTerm(
        code="ROO_06_S05",
        label="06.S05",
        description="""Room 06.S05//Raum 06.S05""",
    )

    roo_06_s06 = VocabularyTerm(
        code="ROO_06_S06",
        label="06.S06",
        description="""Room 06.S06//Raum 06.S06""",
    )

    roo_06_s07 = VocabularyTerm(
        code="ROO_06_S07",
        label="06.S07",
        description="""Room 06.S07//Raum 06.S07""",
    )

    roo_06_s08 = VocabularyTerm(
        code="ROO_06_S08",
        label="06.S08",
        description="""Room 06.S08//Raum 06.S08""",
    )

    roo_06_s09 = VocabularyTerm(
        code="ROO_06_S09",
        label="06.S09",
        description="""Room 06.S09//Raum 06.S09""",
    )

    roo_06_s10 = VocabularyTerm(
        code="ROO_06_S10",
        label="06.S10",
        description="""Room 06.S10//Raum 06.S10""",
    )

    roo_06_s11 = VocabularyTerm(
        code="ROO_06_S11",
        label="06.S11",
        description="""Room 06.S11//Raum 06.S11""",
    )

    roo_06_s12 = VocabularyTerm(
        code="ROO_06_S12",
        label="06.S12",
        description="""Room 06.S12//Raum 06.S12""",
    )

    roo_06_s13 = VocabularyTerm(
        code="ROO_06_S13",
        label="06.S13",
        description="""Room 06.S13//Raum 06.S13""",
    )

    roo_06_s14 = VocabularyTerm(
        code="ROO_06_S14",
        label="06.S14",
        description="""Room 06.S14//Raum 06.S14""",
    )

    roo_06_s15 = VocabularyTerm(
        code="ROO_06_S15",
        label="06.S15",
        description="""Room 06.S15//Raum 06.S15""",
    )

    roo_06_s16 = VocabularyTerm(
        code="ROO_06_S16",
        label="06.S16",
        description="""Room 06.S16//Raum 06.S16""",
    )

    roo_07_800f = VocabularyTerm(
        code="ROO_07_800F",
        label="07.800F",
        description="""Room 07.800F//Raum 07.800F""",
    )

    roo_07_800t = VocabularyTerm(
        code="ROO_07_800T",
        label="07.800T",
        description="""Room 07.800T//Raum 07.800T""",
    )

    roo_07_801 = VocabularyTerm(
        code="ROO_07_801",
        label="07.801",
        description="""Room 07.801//Raum 07.801""",
    )

    roo_07_802f = VocabularyTerm(
        code="ROO_07_802F",
        label="07.802F",
        description="""Room 07.802F//Raum 07.802F""",
    )

    roo_07_803 = VocabularyTerm(
        code="ROO_07_803",
        label="07.803",
        description="""Room 07.803//Raum 07.803""",
    )

    roo_07_805a1 = VocabularyTerm(
        code="ROO_07_805A1",
        label="07.805A1",
        description="""Room 07.805A1//Raum 07.805A1""",
    )

    roo_07_805f = VocabularyTerm(
        code="ROO_07_805F",
        label="07.805F",
        description="""Room 07.805F//Raum 07.805F""",
    )

    roo_07_806 = VocabularyTerm(
        code="ROO_07_806",
        label="07.806",
        description="""Room 07.806//Raum 07.806""",
    )

    roo_07_806f = VocabularyTerm(
        code="ROO_07_806F",
        label="07.806F",
        description="""Room 07.806F//Raum 07.806F""",
    )

    roo_07_807 = VocabularyTerm(
        code="ROO_07_807",
        label="07.807",
        description="""Room 07.807//Raum 07.807""",
    )

    roo_07_810 = VocabularyTerm(
        code="ROO_07_810",
        label="07.810",
        description="""Room 07.810//Raum 07.810""",
    )

    roo_07_812 = VocabularyTerm(
        code="ROO_07_812",
        label="07.812",
        description="""Room 07.812//Raum 07.812""",
    )

    roo_07_812b = VocabularyTerm(
        code="ROO_07_812B",
        label="07.812B",
        description="""Room 07.812B//Raum 07.812B""",
    )

    roo_07_812c = VocabularyTerm(
        code="ROO_07_812C",
        label="07.812C",
        description="""Room 07.812C//Raum 07.812C""",
    )

    roo_07_813 = VocabularyTerm(
        code="ROO_07_813",
        label="07.813",
        description="""Room 07.813//Raum 07.813""",
    )

    roo_07_813b = VocabularyTerm(
        code="ROO_07_813B",
        label="07.813B",
        description="""Room 07.813B//Raum 07.813B""",
    )

    roo_07_814 = VocabularyTerm(
        code="ROO_07_814",
        label="07.814",
        description="""Room 07.814//Raum 07.814""",
    )

    roo_07_815 = VocabularyTerm(
        code="ROO_07_815",
        label="07.815",
        description="""Room 07.815//Raum 07.815""",
    )

    roo_07_816 = VocabularyTerm(
        code="ROO_07_816",
        label="07.816",
        description="""Room 07.816//Raum 07.816""",
    )

    roo_07_816b = VocabularyTerm(
        code="ROO_07_816B",
        label="07.816B",
        description="""Room 07.816B//Raum 07.816B""",
    )

    roo_07_819f = VocabularyTerm(
        code="ROO_07_819F",
        label="07.819F",
        description="""Room 07.819F//Raum 07.819F""",
    )

    roo_07_820a2 = VocabularyTerm(
        code="ROO_07_820A2",
        label="07.820A2",
        description="""Room 07.820A2//Raum 07.820A2""",
    )

    roo_07_820f = VocabularyTerm(
        code="ROO_07_820F",
        label="07.820F",
        description="""Room 07.820F//Raum 07.820F""",
    )

    roo_07_821b = VocabularyTerm(
        code="ROO_07_821B",
        label="07.821B",
        description="""Room 07.821B//Raum 07.821B""",
    )

    roo_07_821c = VocabularyTerm(
        code="ROO_07_821C",
        label="07.821C",
        description="""Room 07.821C//Raum 07.821C""",
    )

    roo_07_821e = VocabularyTerm(
        code="ROO_07_821E",
        label="07.821E",
        description="""Room 07.821E//Raum 07.821E""",
    )

    roo_07_821f = VocabularyTerm(
        code="ROO_07_821F",
        label="07.821F",
        description="""Room 07.821F//Raum 07.821F""",
    )

    roo_07_821t = VocabularyTerm(
        code="ROO_07_821T",
        label="07.821T",
        description="""Room 07.821T//Raum 07.821T""",
    )

    roo_07_822f = VocabularyTerm(
        code="ROO_07_822F",
        label="07.822F",
        description="""Room 07.822F//Raum 07.822F""",
    )

    roo_07_823 = VocabularyTerm(
        code="ROO_07_823",
        label="07.823",
        description="""Room 07.823//Raum 07.823""",
    )

    roo_07_824 = VocabularyTerm(
        code="ROO_07_824",
        label="07.824",
        description="""Room 07.824//Raum 07.824""",
    )

    roo_07_825 = VocabularyTerm(
        code="ROO_07_825",
        label="07.825",
        description="""Room 07.825//Raum 07.825""",
    )

    roo_07_826 = VocabularyTerm(
        code="ROO_07_826",
        label="07.826",
        description="""Room 07.826//Raum 07.826""",
    )

    roo_07_826b = VocabularyTerm(
        code="ROO_07_826B",
        label="07.826B",
        description="""Room 07.826B//Raum 07.826B""",
    )

    roo_07_827 = VocabularyTerm(
        code="ROO_07_827",
        label="07.827",
        description="""Room 07.827//Raum 07.827""",
    )

    roo_07_827b = VocabularyTerm(
        code="ROO_07_827B",
        label="07.827B",
        description="""Room 07.827B//Raum 07.827B""",
    )

    roo_07_828 = VocabularyTerm(
        code="ROO_07_828",
        label="07.828",
        description="""Room 07.828//Raum 07.828""",
    )

    roo_07_828b = VocabularyTerm(
        code="ROO_07_828B",
        label="07.828B",
        description="""Room 07.828B//Raum 07.828B""",
    )

    roo_07_829 = VocabularyTerm(
        code="ROO_07_829",
        label="07.829",
        description="""Room 07.829//Raum 07.829""",
    )

    roo_07_829b = VocabularyTerm(
        code="ROO_07_829B",
        label="07.829B",
        description="""Room 07.829B//Raum 07.829B""",
    )

    roo_07_829d = VocabularyTerm(
        code="ROO_07_829D",
        label="07.829D",
        description="""Room 07.829D//Raum 07.829D""",
    )

    roo_07_829h = VocabularyTerm(
        code="ROO_07_829H",
        label="07.829H",
        description="""Room 07.829H//Raum 07.829H""",
    )

    roo_07_830 = VocabularyTerm(
        code="ROO_07_830",
        label="07.830",
        description="""Room 07.830//Raum 07.830""",
    )

    roo_07_831 = VocabularyTerm(
        code="ROO_07_831",
        label="07.831",
        description="""Room 07.831//Raum 07.831""",
    )

    roo_07_832 = VocabularyTerm(
        code="ROO_07_832",
        label="07.832",
        description="""Room 07.832//Raum 07.832""",
    )

    roo_07_s00 = VocabularyTerm(
        code="ROO_07_S00",
        label="07.S00",
        description="""Room 07.S00//Raum 07.S00""",
    )

    roo_07_s02 = VocabularyTerm(
        code="ROO_07_S02",
        label="07.S02",
        description="""Room 07.S02//Raum 07.S02""",
    )

    roo_07_s03 = VocabularyTerm(
        code="ROO_07_S03",
        label="07.S03",
        description="""Room 07.S03//Raum 07.S03""",
    )

    roo_07_s04 = VocabularyTerm(
        code="ROO_07_S04",
        label="07.S04",
        description="""Room 07.S04//Raum 07.S04""",
    )

    roo_07_s05 = VocabularyTerm(
        code="ROO_07_S05",
        label="07.S05",
        description="""Room 07.S05//Raum 07.S05""",
    )

    roo_07_s06 = VocabularyTerm(
        code="ROO_07_S06",
        label="07.S06",
        description="""Room 07.S06//Raum 07.S06""",
    )

    roo_07_s07 = VocabularyTerm(
        code="ROO_07_S07",
        label="07.S07",
        description="""Room 07.S07//Raum 07.S07""",
    )

    roo_07_s08 = VocabularyTerm(
        code="ROO_07_S08",
        label="07.S08",
        description="""Room 07.S08//Raum 07.S08""",
    )

    roo_07_s09 = VocabularyTerm(
        code="ROO_07_S09",
        label="07.S09",
        description="""Room 07.S09//Raum 07.S09""",
    )

    roo_07_s10 = VocabularyTerm(
        code="ROO_07_S10",
        label="07.S10",
        description="""Room 07.S10//Raum 07.S10""",
    )

    roo_07_s11 = VocabularyTerm(
        code="ROO_07_S11",
        label="07.S11",
        description="""Room 07.S11//Raum 07.S11""",
    )

    roo_07_s12 = VocabularyTerm(
        code="ROO_07_S12",
        label="07.S12",
        description="""Room 07.S12//Raum 07.S12""",
    )

    roo_07_s13 = VocabularyTerm(
        code="ROO_07_S13",
        label="07.S13",
        description="""Room 07.S13//Raum 07.S13""",
    )

    roo_07_s14 = VocabularyTerm(
        code="ROO_07_S14",
        label="07.S14",
        description="""Room 07.S14//Raum 07.S14""",
    )

    roo_07_s15 = VocabularyTerm(
        code="ROO_07_S15",
        label="07.S15",
        description="""Room 07.S15//Raum 07.S15""",
    )

    roo_07_s16 = VocabularyTerm(
        code="ROO_07_S16",
        label="07.S16",
        description="""Room 07.S16//Raum 07.S16""",
    )

    roo_08_900 = VocabularyTerm(
        code="ROO_08_900",
        label="08.900",
        description="""Room 08.900//Raum 08.900""",
    )

    roo_08_900t = VocabularyTerm(
        code="ROO_08_900T",
        label="08.900T",
        description="""Room 08.900T//Raum 08.900T""",
    )

    roo_08_901 = VocabularyTerm(
        code="ROO_08_901",
        label="08.901",
        description="""Room 08.901//Raum 08.901""",
    )

    roo_08_901f = VocabularyTerm(
        code="ROO_08_901F",
        label="08.901F",
        description="""Room 08.901F//Raum 08.901F""",
    )

    roo_08_902f = VocabularyTerm(
        code="ROO_08_902F",
        label="08.902F",
        description="""Room 08.902F//Raum 08.902F""",
    )

    roo_08_905a1 = VocabularyTerm(
        code="ROO_08_905A1",
        label="08.905A1",
        description="""Room 08.905A1//Raum 08.905A1""",
    )

    roo_08_905f = VocabularyTerm(
        code="ROO_08_905F",
        label="08.905F",
        description="""Room 08.905F//Raum 08.905F""",
    )

    roo_08_920a2 = VocabularyTerm(
        code="ROO_08_920A2",
        label="08.920A2",
        description="""Room 08.920A2//Raum 08.920A2""",
    )

    roo_08_921 = VocabularyTerm(
        code="ROO_08_921",
        label="08.921",
        description="""Room 08.921//Raum 08.921""",
    )

    roo_08_921f = VocabularyTerm(
        code="ROO_08_921F",
        label="08.921F",
        description="""Room 08.921F//Raum 08.921F""",
    )

    roo_08_921t = VocabularyTerm(
        code="ROO_08_921T",
        label="08.921T",
        description="""Room 08.921T//Raum 08.921T""",
    )

    roo_08_922 = VocabularyTerm(
        code="ROO_08_922",
        label="08.922",
        description="""Room 08.922//Raum 08.922""",
    )

    roo_08_922f = VocabularyTerm(
        code="ROO_08_922F",
        label="08.922F",
        description="""Room 08.922F//Raum 08.922F""",
    )

    roo_08_s00 = VocabularyTerm(
        code="ROO_08_S00",
        label="08.S00",
        description="""Room 08.S00//Raum 08.S00""",
    )

    roo_23 = VocabularyTerm(
        code="ROO_23",
        label="23",
        description="""Room 23//Raum 23""",
    )

    roo_32 = VocabularyTerm(
        code="ROO_32",
        label="32",
        description="""Room 32//Raum 32""",
    )

    roo_52 = VocabularyTerm(
        code="ROO_52",
        label="52",
        description="""Room 52//Raum 52""",
    )

    roo_95 = VocabularyTerm(
        code="ROO_95",
        label="95",
        description="""Room 95//Raum 95""",
    )

    roo_96 = VocabularyTerm(
        code="ROO_96",
        label="96",
        description="""Room 96//Raum 96""",
    )

    roo_96f = VocabularyTerm(
        code="ROO_96F",
        label="96F",
        description="""Room 96F//Raum 96F""",
    )

    roo_97 = VocabularyTerm(
        code="ROO_97",
        label="97",
        description="""Room 97//Raum 97""",
    )

    roo_98 = VocabularyTerm(
        code="ROO_98",
        label="98",
        description="""Room 98//Raum 98""",
    )

    roo_98f = VocabularyTerm(
        code="ROO_98F",
        label="98F",
        description="""Room 98F//Raum 98F""",
    )

    roo_99 = VocabularyTerm(
        code="ROO_99",
        label="99",
        description="""Room 99//Raum 99""",
    )

    roo_000 = VocabularyTerm(
        code="ROO_000",
        label="000",
        description="""Room 000//Raum 000""",
    )

    roo_000b = VocabularyTerm(
        code="ROO_000B",
        label="000B",
        description="""Room 000B//Raum 000B""",
    )

    roo_000f = VocabularyTerm(
        code="ROO_000F",
        label="000F",
        description="""Room 000F//Raum 000F""",
    )

    roo_000t = VocabularyTerm(
        code="ROO_000T",
        label="000T",
        description="""Room 000T//Raum 000T""",
    )

    roo_000tb = VocabularyTerm(
        code="ROO_000TB",
        label="000TB",
        description="""Room 000TB//Raum 000TB""",
    )

    roo_001 = VocabularyTerm(
        code="ROO_001",
        label="001",
        description="""Room 001//Raum 001""",
    )

    roo_001at = VocabularyTerm(
        code="ROO_001AT",
        label="001AT",
        description="""Room 001AT//Raum 001AT""",
    )

    roo_001b = VocabularyTerm(
        code="ROO_001B",
        label="001B",
        description="""Room 001B//Raum 001B""",
    )

    roo_001f = VocabularyTerm(
        code="ROO_001F",
        label="001F",
        description="""Room 001F//Raum 001F""",
    )

    roo_001h = VocabularyTerm(
        code="ROO_001H",
        label="001H",
        description="""Room 001H//Raum 001H""",
    )

    roo_001t = VocabularyTerm(
        code="ROO_001T",
        label="001T",
        description="""Room 001T//Raum 001T""",
    )

    roo_002 = VocabularyTerm(
        code="ROO_002",
        label="002",
        description="""Room 002//Raum 002""",
    )

    roo_002a = VocabularyTerm(
        code="ROO_002A",
        label="002A",
        description="""Room 002A//Raum 002A""",
    )

    roo_002at = VocabularyTerm(
        code="ROO_002AT",
        label="002AT",
        description="""Room 002AT//Raum 002AT""",
    )

    roo_002b = VocabularyTerm(
        code="ROO_002B",
        label="002B",
        description="""Room 002B//Raum 002B""",
    )

    roo_002c = VocabularyTerm(
        code="ROO_002C",
        label="002C",
        description="""Room 002C//Raum 002C""",
    )

    roo_002f = VocabularyTerm(
        code="ROO_002F",
        label="002F",
        description="""Room 002F//Raum 002F""",
    )

    roo_002h = VocabularyTerm(
        code="ROO_002H",
        label="002H",
        description="""Room 002H//Raum 002H""",
    )

    roo_002t = VocabularyTerm(
        code="ROO_002T",
        label="002T",
        description="""Room 002T//Raum 002T""",
    )

    roo_003 = VocabularyTerm(
        code="ROO_003",
        label="003",
        description="""Room 003//Raum 003""",
    )

    roo_003a = VocabularyTerm(
        code="ROO_003A",
        label="003A",
        description="""Room 003A//Raum 003A""",
    )

    roo_003ab = VocabularyTerm(
        code="ROO_003AB",
        label="003AB",
        description="""Room 003AB//Raum 003AB""",
    )

    roo_003b = VocabularyTerm(
        code="ROO_003B",
        label="003B",
        description="""Room 003B//Raum 003B""",
    )

    roo_003f = VocabularyTerm(
        code="ROO_003F",
        label="003F",
        description="""Room 003F//Raum 003F""",
    )

    roo_003h = VocabularyTerm(
        code="ROO_003H",
        label="003H",
        description="""Room 003H//Raum 003H""",
    )

    roo_003t = VocabularyTerm(
        code="ROO_003T",
        label="003T",
        description="""Room 003T//Raum 003T""",
    )

    roo_004 = VocabularyTerm(
        code="ROO_004",
        label="004",
        description="""Room 004//Raum 004""",
    )

    roo_004b = VocabularyTerm(
        code="ROO_004B",
        label="004B",
        description="""Room 004B//Raum 004B""",
    )

    roo_004f = VocabularyTerm(
        code="ROO_004F",
        label="004F",
        description="""Room 004F//Raum 004F""",
    )

    roo_005 = VocabularyTerm(
        code="ROO_005",
        label="005",
        description="""Room 005//Raum 005""",
    )

    roo_005d = VocabularyTerm(
        code="ROO_005D",
        label="005D",
        description="""Room 005D//Raum 005D""",
    )

    roo_005f = VocabularyTerm(
        code="ROO_005F",
        label="005F",
        description="""Room 005F//Raum 005F""",
    )

    roo_005t = VocabularyTerm(
        code="ROO_005T",
        label="005T",
        description="""Room 005T//Raum 005T""",
    )

    roo_006 = VocabularyTerm(
        code="ROO_006",
        label="006",
        description="""Room 006//Raum 006""",
    )

    roo_006b = VocabularyTerm(
        code="ROO_006B",
        label="006B",
        description="""Room 006B//Raum 006B""",
    )

    roo_006h = VocabularyTerm(
        code="ROO_006H",
        label="006H",
        description="""Room 006H//Raum 006H""",
    )

    roo_006t = VocabularyTerm(
        code="ROO_006T",
        label="006T",
        description="""Room 006T//Raum 006T""",
    )

    roo_007 = VocabularyTerm(
        code="ROO_007",
        label="007",
        description="""Room 007//Raum 007""",
    )

    roo_007b = VocabularyTerm(
        code="ROO_007B",
        label="007B",
        description="""Room 007B//Raum 007B""",
    )

    roo_007f = VocabularyTerm(
        code="ROO_007F",
        label="007F",
        description="""Room 007F//Raum 007F""",
    )

    roo_007t = VocabularyTerm(
        code="ROO_007T",
        label="007T",
        description="""Room 007T//Raum 007T""",
    )

    roo_008 = VocabularyTerm(
        code="ROO_008",
        label="008",
        description="""Room 008//Raum 008""",
    )

    roo_008d = VocabularyTerm(
        code="ROO_008D",
        label="008D",
        description="""Room 008D//Raum 008D""",
    )

    roo_008t = VocabularyTerm(
        code="ROO_008T",
        label="008T",
        description="""Room 008T//Raum 008T""",
    )

    roo_009 = VocabularyTerm(
        code="ROO_009",
        label="009",
        description="""Room 009//Raum 009""",
    )

    roo_009b = VocabularyTerm(
        code="ROO_009B",
        label="009B",
        description="""Room 009B//Raum 009B""",
    )

    roo_009d = VocabularyTerm(
        code="ROO_009D",
        label="009D",
        description="""Room 009D//Raum 009D""",
    )

    roo_009f = VocabularyTerm(
        code="ROO_009F",
        label="009F",
        description="""Room 009F//Raum 009F""",
    )

    roo_009t = VocabularyTerm(
        code="ROO_009T",
        label="009T",
        description="""Room 009T//Raum 009T""",
    )

    roo_010 = VocabularyTerm(
        code="ROO_010",
        label="010",
        description="""Room 010//Raum 010""",
    )

    roo_010a = VocabularyTerm(
        code="ROO_010A",
        label="010A",
        description="""Room 010A//Raum 010A""",
    )

    roo_010ab = VocabularyTerm(
        code="ROO_010AB",
        label="010AB",
        description="""Room 010AB//Raum 010AB""",
    )

    roo_010b = VocabularyTerm(
        code="ROO_010B",
        label="010B",
        description="""Room 010B//Raum 010B""",
    )

    roo_010f = VocabularyTerm(
        code="ROO_010F",
        label="010F",
        description="""Room 010F//Raum 010F""",
    )

    roo_010t = VocabularyTerm(
        code="ROO_010T",
        label="010T",
        description="""Room 010T//Raum 010T""",
    )

    roo_011 = VocabularyTerm(
        code="ROO_011",
        label="011",
        description="""Room 011//Raum 011""",
    )

    roo_011b = VocabularyTerm(
        code="ROO_011B",
        label="011B",
        description="""Room 011B//Raum 011B""",
    )

    roo_011d = VocabularyTerm(
        code="ROO_011D",
        label="011D",
        description="""Room 011D//Raum 011D""",
    )

    roo_011f = VocabularyTerm(
        code="ROO_011F",
        label="011F",
        description="""Room 011F//Raum 011F""",
    )

    roo_012 = VocabularyTerm(
        code="ROO_012",
        label="012",
        description="""Room 012//Raum 012""",
    )

    roo_012ah = VocabularyTerm(
        code="ROO_012AH",
        label="012AH",
        description="""Room 012AH//Raum 012AH""",
    )

    roo_012b = VocabularyTerm(
        code="ROO_012B",
        label="012B",
        description="""Room 012B//Raum 012B""",
    )

    roo_012c = VocabularyTerm(
        code="ROO_012C",
        label="012C",
        description="""Room 012C//Raum 012C""",
    )

    roo_012f = VocabularyTerm(
        code="ROO_012F",
        label="012F",
        description="""Room 012F//Raum 012F""",
    )

    roo_013 = VocabularyTerm(
        code="ROO_013",
        label="013",
        description="""Room 013//Raum 013""",
    )

    roo_013a = VocabularyTerm(
        code="ROO_013A",
        label="013A",
        description="""Room 013A//Raum 013A""",
    )

    roo_013af = VocabularyTerm(
        code="ROO_013AF",
        label="013AF",
        description="""Room 013AF//Raum 013AF""",
    )

    roo_013b = VocabularyTerm(
        code="ROO_013B",
        label="013B",
        description="""Room 013B//Raum 013B""",
    )

    roo_013f = VocabularyTerm(
        code="ROO_013F",
        label="013F",
        description="""Room 013F//Raum 013F""",
    )

    roo_013h = VocabularyTerm(
        code="ROO_013H",
        label="013H",
        description="""Room 013H//Raum 013H""",
    )

    roo_013t = VocabularyTerm(
        code="ROO_013T",
        label="013T",
        description="""Room 013T//Raum 013T""",
    )

    roo_014 = VocabularyTerm(
        code="ROO_014",
        label="014",
        description="""Room 014//Raum 014""",
    )

    roo_014at = VocabularyTerm(
        code="ROO_014AT",
        label="014AT",
        description="""Room 014AT//Raum 014AT""",
    )

    roo_014b = VocabularyTerm(
        code="ROO_014B",
        label="014B",
        description="""Room 014B//Raum 014B""",
    )

    roo_014d = VocabularyTerm(
        code="ROO_014D",
        label="014D",
        description="""Room 014D//Raum 014D""",
    )

    roo_014f = VocabularyTerm(
        code="ROO_014F",
        label="014F",
        description="""Room 014F//Raum 014F""",
    )

    roo_014h = VocabularyTerm(
        code="ROO_014H",
        label="014H",
        description="""Room 014H//Raum 014H""",
    )

    roo_014t = VocabularyTerm(
        code="ROO_014T",
        label="014T",
        description="""Room 014T//Raum 014T""",
    )

    roo_015 = VocabularyTerm(
        code="ROO_015",
        label="015",
        description="""Room 015//Raum 015""",
    )

    roo_015a = VocabularyTerm(
        code="ROO_015A",
        label="015A",
        description="""Room 015A//Raum 015A""",
    )

    roo_015b = VocabularyTerm(
        code="ROO_015B",
        label="015B",
        description="""Room 015B//Raum 015B""",
    )

    roo_015f = VocabularyTerm(
        code="ROO_015F",
        label="015F",
        description="""Room 015F//Raum 015F""",
    )

    roo_015h = VocabularyTerm(
        code="ROO_015H",
        label="015H",
        description="""Room 015H//Raum 015H""",
    )

    roo_015t = VocabularyTerm(
        code="ROO_015T",
        label="015T",
        description="""Room 015T//Raum 015T""",
    )

    roo_016 = VocabularyTerm(
        code="ROO_016",
        label="016",
        description="""Room 016//Raum 016""",
    )

    roo_016f = VocabularyTerm(
        code="ROO_016F",
        label="016F",
        description="""Room 016F//Raum 016F""",
    )

    roo_016t = VocabularyTerm(
        code="ROO_016T",
        label="016T",
        description="""Room 016T//Raum 016T""",
    )

    roo_017 = VocabularyTerm(
        code="ROO_017",
        label="017",
        description="""Room 017//Raum 017""",
    )

    roo_017a = VocabularyTerm(
        code="ROO_017A",
        label="017A",
        description="""Room 017A//Raum 017A""",
    )

    roo_017b = VocabularyTerm(
        code="ROO_017B",
        label="017B",
        description="""Room 017B//Raum 017B""",
    )

    roo_017d = VocabularyTerm(
        code="ROO_017D",
        label="017D",
        description="""Room 017D//Raum 017D""",
    )

    roo_017f = VocabularyTerm(
        code="ROO_017F",
        label="017F",
        description="""Room 017F//Raum 017F""",
    )

    roo_017t = VocabularyTerm(
        code="ROO_017T",
        label="017T",
        description="""Room 017T//Raum 017T""",
    )

    roo_018 = VocabularyTerm(
        code="ROO_018",
        label="018",
        description="""Room 018//Raum 018""",
    )

    roo_018a = VocabularyTerm(
        code="ROO_018A",
        label="018A",
        description="""Room 018A//Raum 018A""",
    )

    roo_018b = VocabularyTerm(
        code="ROO_018B",
        label="018B",
        description="""Room 018B//Raum 018B""",
    )

    roo_018f = VocabularyTerm(
        code="ROO_018F",
        label="018F",
        description="""Room 018F//Raum 018F""",
    )

    roo_018t = VocabularyTerm(
        code="ROO_018T",
        label="018T",
        description="""Room 018T//Raum 018T""",
    )

    roo_019 = VocabularyTerm(
        code="ROO_019",
        label="019",
        description="""Room 019//Raum 019""",
    )

    roo_019f = VocabularyTerm(
        code="ROO_019F",
        label="019F",
        description="""Room 019F//Raum 019F""",
    )

    roo_019t = VocabularyTerm(
        code="ROO_019T",
        label="019T",
        description="""Room 019T//Raum 019T""",
    )

    roo_020 = VocabularyTerm(
        code="ROO_020",
        label="020",
        description="""Room 020//Raum 020""",
    )

    roo_020b = VocabularyTerm(
        code="ROO_020B",
        label="020B",
        description="""Room 020B//Raum 020B""",
    )

    roo_020f = VocabularyTerm(
        code="ROO_020F",
        label="020F",
        description="""Room 020F//Raum 020F""",
    )

    roo_020t = VocabularyTerm(
        code="ROO_020T",
        label="020T",
        description="""Room 020T//Raum 020T""",
    )

    roo_021 = VocabularyTerm(
        code="ROO_021",
        label="021",
        description="""Room 021//Raum 021""",
    )

    roo_021b = VocabularyTerm(
        code="ROO_021B",
        label="021B",
        description="""Room 021B//Raum 021B""",
    )

    roo_021f = VocabularyTerm(
        code="ROO_021F",
        label="021F",
        description="""Room 021F//Raum 021F""",
    )

    roo_022 = VocabularyTerm(
        code="ROO_022",
        label="022",
        description="""Room 022//Raum 022""",
    )

    roo_022a = VocabularyTerm(
        code="ROO_022A",
        label="022A",
        description="""Room 022A//Raum 022A""",
    )

    roo_022b = VocabularyTerm(
        code="ROO_022B",
        label="022B",
        description="""Room 022B//Raum 022B""",
    )

    roo_022f = VocabularyTerm(
        code="ROO_022F",
        label="022F",
        description="""Room 022F//Raum 022F""",
    )

    roo_022t = VocabularyTerm(
        code="ROO_022T",
        label="022T",
        description="""Room 022T//Raum 022T""",
    )

    roo_023 = VocabularyTerm(
        code="ROO_023",
        label="023",
        description="""Room 023//Raum 023""",
    )

    roo_023b = VocabularyTerm(
        code="ROO_023B",
        label="023B",
        description="""Room 023B//Raum 023B""",
    )

    roo_023f = VocabularyTerm(
        code="ROO_023F",
        label="023F",
        description="""Room 023F//Raum 023F""",
    )

    roo_023t = VocabularyTerm(
        code="ROO_023T",
        label="023T",
        description="""Room 023T//Raum 023T""",
    )

    roo_024 = VocabularyTerm(
        code="ROO_024",
        label="024",
        description="""Room 024//Raum 024""",
    )

    roo_024b = VocabularyTerm(
        code="ROO_024B",
        label="024B",
        description="""Room 024B//Raum 024B""",
    )

    roo_024f = VocabularyTerm(
        code="ROO_024F",
        label="024F",
        description="""Room 024F//Raum 024F""",
    )

    roo_024t = VocabularyTerm(
        code="ROO_024T",
        label="024T",
        description="""Room 024T//Raum 024T""",
    )

    roo_024tb = VocabularyTerm(
        code="ROO_024TB",
        label="024TB",
        description="""Room 024TB//Raum 024TB""",
    )

    roo_025 = VocabularyTerm(
        code="ROO_025",
        label="025",
        description="""Room 025//Raum 025""",
    )

    roo_025b = VocabularyTerm(
        code="ROO_025B",
        label="025B",
        description="""Room 025B//Raum 025B""",
    )

    roo_025f = VocabularyTerm(
        code="ROO_025F",
        label="025F",
        description="""Room 025F//Raum 025F""",
    )

    roo_025h = VocabularyTerm(
        code="ROO_025H",
        label="025H",
        description="""Room 025H//Raum 025H""",
    )

    roo_025t = VocabularyTerm(
        code="ROO_025T",
        label="025T",
        description="""Room 025T//Raum 025T""",
    )

    roo_026 = VocabularyTerm(
        code="ROO_026",
        label="026",
        description="""Room 026//Raum 026""",
    )

    roo_026a = VocabularyTerm(
        code="ROO_026A",
        label="026A",
        description="""Room 026A//Raum 026A""",
    )

    roo_026b = VocabularyTerm(
        code="ROO_026B",
        label="026B",
        description="""Room 026B//Raum 026B""",
    )

    roo_026c = VocabularyTerm(
        code="ROO_026C",
        label="026C",
        description="""Room 026C//Raum 026C""",
    )

    roo_026f = VocabularyTerm(
        code="ROO_026F",
        label="026F",
        description="""Room 026F//Raum 026F""",
    )

    roo_027 = VocabularyTerm(
        code="ROO_027",
        label="027",
        description="""Room 027//Raum 027""",
    )

    roo_027b = VocabularyTerm(
        code="ROO_027B",
        label="027B",
        description="""Room 027B//Raum 027B""",
    )

    roo_028 = VocabularyTerm(
        code="ROO_028",
        label="028",
        description="""Room 028//Raum 028""",
    )

    roo_028b = VocabularyTerm(
        code="ROO_028B",
        label="028B",
        description="""Room 028B//Raum 028B""",
    )

    roo_028f = VocabularyTerm(
        code="ROO_028F",
        label="028F",
        description="""Room 028F//Raum 028F""",
    )

    roo_029 = VocabularyTerm(
        code="ROO_029",
        label="029",
        description="""Room 029//Raum 029""",
    )

    roo_029b = VocabularyTerm(
        code="ROO_029B",
        label="029B",
        description="""Room 029B//Raum 029B""",
    )

    roo_029f = VocabularyTerm(
        code="ROO_029F",
        label="029F",
        description="""Room 029F//Raum 029F""",
    )

    roo_029t = VocabularyTerm(
        code="ROO_029T",
        label="029T",
        description="""Room 029T//Raum 029T""",
    )

    roo_030 = VocabularyTerm(
        code="ROO_030",
        label="030",
        description="""Room 030//Raum 030""",
    )

    roo_030a = VocabularyTerm(
        code="ROO_030A",
        label="030A",
        description="""Room 030A//Raum 030A""",
    )

    roo_030b = VocabularyTerm(
        code="ROO_030B",
        label="030B",
        description="""Room 030B//Raum 030B""",
    )

    roo_030f = VocabularyTerm(
        code="ROO_030F",
        label="030F",
        description="""Room 030F//Raum 030F""",
    )

    roo_031 = VocabularyTerm(
        code="ROO_031",
        label="031",
        description="""Room 031//Raum 031""",
    )

    roo_031a = VocabularyTerm(
        code="ROO_031A",
        label="031A",
        description="""Room 031A//Raum 031A""",
    )

    roo_031f = VocabularyTerm(
        code="ROO_031F",
        label="031F",
        description="""Room 031F//Raum 031F""",
    )

    roo_031h = VocabularyTerm(
        code="ROO_031H",
        label="031H",
        description="""Room 031H//Raum 031H""",
    )

    roo_031t = VocabularyTerm(
        code="ROO_031T",
        label="031T",
        description="""Room 031T//Raum 031T""",
    )

    roo_032 = VocabularyTerm(
        code="ROO_032",
        label="032",
        description="""Room 032//Raum 032""",
    )

    roo_032b = VocabularyTerm(
        code="ROO_032B",
        label="032B",
        description="""Room 032B//Raum 032B""",
    )

    roo_032f = VocabularyTerm(
        code="ROO_032F",
        label="032F",
        description="""Room 032F//Raum 032F""",
    )

    roo_033 = VocabularyTerm(
        code="ROO_033",
        label="033",
        description="""Room 033//Raum 033""",
    )

    roo_033b = VocabularyTerm(
        code="ROO_033B",
        label="033B",
        description="""Room 033B//Raum 033B""",
    )

    roo_033f = VocabularyTerm(
        code="ROO_033F",
        label="033F",
        description="""Room 033F//Raum 033F""",
    )

    roo_034 = VocabularyTerm(
        code="ROO_034",
        label="034",
        description="""Room 034//Raum 034""",
    )

    roo_034at = VocabularyTerm(
        code="ROO_034AT",
        label="034AT",
        description="""Room 034AT//Raum 034AT""",
    )

    roo_034b = VocabularyTerm(
        code="ROO_034B",
        label="034B",
        description="""Room 034B//Raum 034B""",
    )

    roo_034d = VocabularyTerm(
        code="ROO_034D",
        label="034D",
        description="""Room 034D//Raum 034D""",
    )

    roo_034f = VocabularyTerm(
        code="ROO_034F",
        label="034F",
        description="""Room 034F//Raum 034F""",
    )

    roo_034h = VocabularyTerm(
        code="ROO_034H",
        label="034H",
        description="""Room 034H//Raum 034H""",
    )

    roo_034t = VocabularyTerm(
        code="ROO_034T",
        label="034T",
        description="""Room 034T//Raum 034T""",
    )

    roo_035 = VocabularyTerm(
        code="ROO_035",
        label="035",
        description="""Room 035//Raum 035""",
    )

    roo_035b = VocabularyTerm(
        code="ROO_035B",
        label="035B",
        description="""Room 035B//Raum 035B""",
    )

    roo_035f = VocabularyTerm(
        code="ROO_035F",
        label="035F",
        description="""Room 035F//Raum 035F""",
    )

    roo_036 = VocabularyTerm(
        code="ROO_036",
        label="036",
        description="""Room 036//Raum 036""",
    )

    roo_036b = VocabularyTerm(
        code="ROO_036B",
        label="036B",
        description="""Room 036B//Raum 036B""",
    )

    roo_037 = VocabularyTerm(
        code="ROO_037",
        label="037",
        description="""Room 037//Raum 037""",
    )

    roo_037a = VocabularyTerm(
        code="ROO_037A",
        label="037A",
        description="""Room 037A//Raum 037A""",
    )

    roo_037f = VocabularyTerm(
        code="ROO_037F",
        label="037F",
        description="""Room 037F//Raum 037F""",
    )

    roo_037h = VocabularyTerm(
        code="ROO_037H",
        label="037H",
        description="""Room 037H//Raum 037H""",
    )

    roo_037t = VocabularyTerm(
        code="ROO_037T",
        label="037T",
        description="""Room 037T//Raum 037T""",
    )

    roo_038 = VocabularyTerm(
        code="ROO_038",
        label="038",
        description="""Room 038//Raum 038""",
    )

    roo_038a = VocabularyTerm(
        code="ROO_038A",
        label="038A",
        description="""Room 038A//Raum 038A""",
    )

    roo_038t = VocabularyTerm(
        code="ROO_038T",
        label="038T",
        description="""Room 038T//Raum 038T""",
    )

    roo_039 = VocabularyTerm(
        code="ROO_039",
        label="039",
        description="""Room 039//Raum 039""",
    )

    roo_039b = VocabularyTerm(
        code="ROO_039B",
        label="039B",
        description="""Room 039B//Raum 039B""",
    )

    roo_039c = VocabularyTerm(
        code="ROO_039C",
        label="039C",
        description="""Room 039C//Raum 039C""",
    )

    roo_039f = VocabularyTerm(
        code="ROO_039F",
        label="039F",
        description="""Room 039F//Raum 039F""",
    )

    roo_039h = VocabularyTerm(
        code="ROO_039H",
        label="039H",
        description="""Room 039H//Raum 039H""",
    )

    roo_040 = VocabularyTerm(
        code="ROO_040",
        label="040",
        description="""Room 040//Raum 040""",
    )

    roo_040b = VocabularyTerm(
        code="ROO_040B",
        label="040B",
        description="""Room 040B//Raum 040B""",
    )

    roo_040c = VocabularyTerm(
        code="ROO_040C",
        label="040C",
        description="""Room 040C//Raum 040C""",
    )

    roo_040f = VocabularyTerm(
        code="ROO_040F",
        label="040F",
        description="""Room 040F//Raum 040F""",
    )

    roo_040t = VocabularyTerm(
        code="ROO_040T",
        label="040T",
        description="""Room 040T//Raum 040T""",
    )

    roo_041 = VocabularyTerm(
        code="ROO_041",
        label="041",
        description="""Room 041//Raum 041""",
    )

    roo_041b = VocabularyTerm(
        code="ROO_041B",
        label="041B",
        description="""Room 041B//Raum 041B""",
    )

    roo_041f = VocabularyTerm(
        code="ROO_041F",
        label="041F",
        description="""Room 041F//Raum 041F""",
    )

    roo_041t = VocabularyTerm(
        code="ROO_041T",
        label="041T",
        description="""Room 041T//Raum 041T""",
    )

    roo_042 = VocabularyTerm(
        code="ROO_042",
        label="042",
        description="""Room 042//Raum 042""",
    )

    roo_042b = VocabularyTerm(
        code="ROO_042B",
        label="042B",
        description="""Room 042B//Raum 042B""",
    )

    roo_042f = VocabularyTerm(
        code="ROO_042F",
        label="042F",
        description="""Room 042F//Raum 042F""",
    )

    roo_042t = VocabularyTerm(
        code="ROO_042T",
        label="042T",
        description="""Room 042T//Raum 042T""",
    )

    roo_043 = VocabularyTerm(
        code="ROO_043",
        label="043",
        description="""Room 043//Raum 043""",
    )

    roo_043f = VocabularyTerm(
        code="ROO_043F",
        label="043F",
        description="""Room 043F//Raum 043F""",
    )

    roo_043t = VocabularyTerm(
        code="ROO_043T",
        label="043T",
        description="""Room 043T//Raum 043T""",
    )

    roo_044 = VocabularyTerm(
        code="ROO_044",
        label="044",
        description="""Room 044//Raum 044""",
    )

    roo_044d = VocabularyTerm(
        code="ROO_044D",
        label="044D",
        description="""Room 044D//Raum 044D""",
    )

    roo_044h = VocabularyTerm(
        code="ROO_044H",
        label="044H",
        description="""Room 044H//Raum 044H""",
    )

    roo_045 = VocabularyTerm(
        code="ROO_045",
        label="045",
        description="""Room 045//Raum 045""",
    )

    roo_045b = VocabularyTerm(
        code="ROO_045B",
        label="045B",
        description="""Room 045B//Raum 045B""",
    )

    roo_045f = VocabularyTerm(
        code="ROO_045F",
        label="045F",
        description="""Room 045F//Raum 045F""",
    )

    roo_045h = VocabularyTerm(
        code="ROO_045H",
        label="045H",
        description="""Room 045H//Raum 045H""",
    )

    roo_045t = VocabularyTerm(
        code="ROO_045T",
        label="045T",
        description="""Room 045T//Raum 045T""",
    )

    roo_046 = VocabularyTerm(
        code="ROO_046",
        label="046",
        description="""Room 046//Raum 046""",
    )

    roo_047 = VocabularyTerm(
        code="ROO_047",
        label="047",
        description="""Room 047//Raum 047""",
    )

    roo_047b = VocabularyTerm(
        code="ROO_047B",
        label="047B",
        description="""Room 047B//Raum 047B""",
    )

    roo_048 = VocabularyTerm(
        code="ROO_048",
        label="048",
        description="""Room 048//Raum 048""",
    )

    roo_048f = VocabularyTerm(
        code="ROO_048F",
        label="048F",
        description="""Room 048F//Raum 048F""",
    )

    roo_049 = VocabularyTerm(
        code="ROO_049",
        label="049",
        description="""Room 049//Raum 049""",
    )

    roo_050 = VocabularyTerm(
        code="ROO_050",
        label="050",
        description="""Room 050//Raum 050""",
    )

    roo_050b = VocabularyTerm(
        code="ROO_050B",
        label="050B",
        description="""Room 050B//Raum 050B""",
    )

    roo_050f = VocabularyTerm(
        code="ROO_050F",
        label="050F",
        description="""Room 050F//Raum 050F""",
    )

    roo_051 = VocabularyTerm(
        code="ROO_051",
        label="051",
        description="""Room 051//Raum 051""",
    )

    roo_051b = VocabularyTerm(
        code="ROO_051B",
        label="051B",
        description="""Room 051B//Raum 051B""",
    )

    roo_051f = VocabularyTerm(
        code="ROO_051F",
        label="051F",
        description="""Room 051F//Raum 051F""",
    )

    roo_052 = VocabularyTerm(
        code="ROO_052",
        label="052",
        description="""Room 052//Raum 052""",
    )

    roo_052b = VocabularyTerm(
        code="ROO_052B",
        label="052B",
        description="""Room 052B//Raum 052B""",
    )

    roo_052f = VocabularyTerm(
        code="ROO_052F",
        label="052F",
        description="""Room 052F//Raum 052F""",
    )

    roo_052t = VocabularyTerm(
        code="ROO_052T",
        label="052T",
        description="""Room 052T//Raum 052T""",
    )

    roo_053 = VocabularyTerm(
        code="ROO_053",
        label="053",
        description="""Room 053//Raum 053""",
    )

    roo_053t = VocabularyTerm(
        code="ROO_053T",
        label="053T",
        description="""Room 053T//Raum 053T""",
    )

    roo_054 = VocabularyTerm(
        code="ROO_054",
        label="054",
        description="""Room 054//Raum 054""",
    )

    roo_055 = VocabularyTerm(
        code="ROO_055",
        label="055",
        description="""Room 055//Raum 055""",
    )

    roo_055b = VocabularyTerm(
        code="ROO_055B",
        label="055B",
        description="""Room 055B//Raum 055B""",
    )

    roo_056 = VocabularyTerm(
        code="ROO_056",
        label="056",
        description="""Room 056//Raum 056""",
    )

    roo_056b = VocabularyTerm(
        code="ROO_056B",
        label="056B",
        description="""Room 056B//Raum 056B""",
    )

    roo_056f = VocabularyTerm(
        code="ROO_056F",
        label="056F",
        description="""Room 056F//Raum 056F""",
    )

    roo_056h = VocabularyTerm(
        code="ROO_056H",
        label="056H",
        description="""Room 056H//Raum 056H""",
    )

    roo_056t = VocabularyTerm(
        code="ROO_056T",
        label="056T",
        description="""Room 056T//Raum 056T""",
    )

    roo_057 = VocabularyTerm(
        code="ROO_057",
        label="057",
        description="""Room 057//Raum 057""",
    )

    roo_057b = VocabularyTerm(
        code="ROO_057B",
        label="057B",
        description="""Room 057B//Raum 057B""",
    )

    roo_057h = VocabularyTerm(
        code="ROO_057H",
        label="057H",
        description="""Room 057H//Raum 057H""",
    )

    roo_058 = VocabularyTerm(
        code="ROO_058",
        label="058",
        description="""Room 058//Raum 058""",
    )

    roo_058b = VocabularyTerm(
        code="ROO_058B",
        label="058B",
        description="""Room 058B//Raum 058B""",
    )

    roo_059 = VocabularyTerm(
        code="ROO_059",
        label="059",
        description="""Room 059//Raum 059""",
    )

    roo_059d = VocabularyTerm(
        code="ROO_059D",
        label="059D",
        description="""Room 059D//Raum 059D""",
    )

    roo_059h = VocabularyTerm(
        code="ROO_059H",
        label="059H",
        description="""Room 059H//Raum 059H""",
    )

    roo_060 = VocabularyTerm(
        code="ROO_060",
        label="060",
        description="""Room 060//Raum 060""",
    )

    roo_060b = VocabularyTerm(
        code="ROO_060B",
        label="060B",
        description="""Room 060B//Raum 060B""",
    )

    roo_060f = VocabularyTerm(
        code="ROO_060F",
        label="060F",
        description="""Room 060F//Raum 060F""",
    )

    roo_061 = VocabularyTerm(
        code="ROO_061",
        label="061",
        description="""Room 061//Raum 061""",
    )

    roo_061b = VocabularyTerm(
        code="ROO_061B",
        label="061B",
        description="""Room 061B//Raum 061B""",
    )

    roo_061c = VocabularyTerm(
        code="ROO_061C",
        label="061C",
        description="""Room 061C//Raum 061C""",
    )

    roo_061d = VocabularyTerm(
        code="ROO_061D",
        label="061D",
        description="""Room 061D//Raum 061D""",
    )

    roo_061f = VocabularyTerm(
        code="ROO_061F",
        label="061F",
        description="""Room 061F//Raum 061F""",
    )

    roo_061t = VocabularyTerm(
        code="ROO_061T",
        label="061T",
        description="""Room 061T//Raum 061T""",
    )

    roo_062 = VocabularyTerm(
        code="ROO_062",
        label="062",
        description="""Room 062//Raum 062""",
    )

    roo_062b = VocabularyTerm(
        code="ROO_062B",
        label="062B",
        description="""Room 062B//Raum 062B""",
    )

    roo_062f = VocabularyTerm(
        code="ROO_062F",
        label="062F",
        description="""Room 062F//Raum 062F""",
    )

    roo_062t = VocabularyTerm(
        code="ROO_062T",
        label="062T",
        description="""Room 062T//Raum 062T""",
    )

    roo_063 = VocabularyTerm(
        code="ROO_063",
        label="063",
        description="""Room 063//Raum 063""",
    )

    roo_064 = VocabularyTerm(
        code="ROO_064",
        label="064",
        description="""Room 064//Raum 064""",
    )

    roo_065 = VocabularyTerm(
        code="ROO_065",
        label="065",
        description="""Room 065//Raum 065""",
    )

    roo_065f = VocabularyTerm(
        code="ROO_065F",
        label="065F",
        description="""Room 065F//Raum 065F""",
    )

    roo_066 = VocabularyTerm(
        code="ROO_066",
        label="066",
        description="""Room 066//Raum 066""",
    )

    roo_066f = VocabularyTerm(
        code="ROO_066F",
        label="066F",
        description="""Room 066F//Raum 066F""",
    )

    roo_067 = VocabularyTerm(
        code="ROO_067",
        label="067",
        description="""Room 067//Raum 067""",
    )

    roo_067b = VocabularyTerm(
        code="ROO_067B",
        label="067B",
        description="""Room 067B//Raum 067B""",
    )

    roo_068 = VocabularyTerm(
        code="ROO_068",
        label="068",
        description="""Room 068//Raum 068""",
    )

    roo_068b = VocabularyTerm(
        code="ROO_068B",
        label="068B",
        description="""Room 068B//Raum 068B""",
    )

    roo_069 = VocabularyTerm(
        code="ROO_069",
        label="069",
        description="""Room 069//Raum 069""",
    )

    roo_069b = VocabularyTerm(
        code="ROO_069B",
        label="069B",
        description="""Room 069B//Raum 069B""",
    )

    roo_069f = VocabularyTerm(
        code="ROO_069F",
        label="069F",
        description="""Room 069F//Raum 069F""",
    )

    roo_070 = VocabularyTerm(
        code="ROO_070",
        label="070",
        description="""Room 070//Raum 070""",
    )

    roo_070b = VocabularyTerm(
        code="ROO_070B",
        label="070B",
        description="""Room 070B//Raum 070B""",
    )

    roo_070f = VocabularyTerm(
        code="ROO_070F",
        label="070F",
        description="""Room 070F//Raum 070F""",
    )

    roo_070t = VocabularyTerm(
        code="ROO_070T",
        label="070T",
        description="""Room 070T//Raum 070T""",
    )

    roo_071 = VocabularyTerm(
        code="ROO_071",
        label="071",
        description="""Room 071//Raum 071""",
    )

    roo_071b = VocabularyTerm(
        code="ROO_071B",
        label="071B",
        description="""Room 071B//Raum 071B""",
    )

    roo_071f = VocabularyTerm(
        code="ROO_071F",
        label="071F",
        description="""Room 071F//Raum 071F""",
    )

    roo_071t = VocabularyTerm(
        code="ROO_071T",
        label="071T",
        description="""Room 071T//Raum 071T""",
    )

    roo_072 = VocabularyTerm(
        code="ROO_072",
        label="072",
        description="""Room 072//Raum 072""",
    )

    roo_072b = VocabularyTerm(
        code="ROO_072B",
        label="072B",
        description="""Room 072B//Raum 072B""",
    )

    roo_072c = VocabularyTerm(
        code="ROO_072C",
        label="072C",
        description="""Room 072C//Raum 072C""",
    )

    roo_072f = VocabularyTerm(
        code="ROO_072F",
        label="072F",
        description="""Room 072F//Raum 072F""",
    )

    roo_073 = VocabularyTerm(
        code="ROO_073",
        label="073",
        description="""Room 073//Raum 073""",
    )

    roo_073b = VocabularyTerm(
        code="ROO_073B",
        label="073B",
        description="""Room 073B//Raum 073B""",
    )

    roo_073t = VocabularyTerm(
        code="ROO_073T",
        label="073T",
        description="""Room 073T//Raum 073T""",
    )

    roo_074 = VocabularyTerm(
        code="ROO_074",
        label="074",
        description="""Room 074//Raum 074""",
    )

    roo_074f = VocabularyTerm(
        code="ROO_074F",
        label="074F",
        description="""Room 074F//Raum 074F""",
    )

    roo_074t = VocabularyTerm(
        code="ROO_074T",
        label="074T",
        description="""Room 074T//Raum 074T""",
    )

    roo_075 = VocabularyTerm(
        code="ROO_075",
        label="075",
        description="""Room 075//Raum 075""",
    )

    roo_075b = VocabularyTerm(
        code="ROO_075B",
        label="075B",
        description="""Room 075B//Raum 075B""",
    )

    roo_075f = VocabularyTerm(
        code="ROO_075F",
        label="075F",
        description="""Room 075F//Raum 075F""",
    )

    roo_075t = VocabularyTerm(
        code="ROO_075T",
        label="075T",
        description="""Room 075T//Raum 075T""",
    )

    roo_076 = VocabularyTerm(
        code="ROO_076",
        label="076",
        description="""Room 076//Raum 076""",
    )

    roo_076b = VocabularyTerm(
        code="ROO_076B",
        label="076B",
        description="""Room 076B//Raum 076B""",
    )

    roo_076t = VocabularyTerm(
        code="ROO_076T",
        label="076T",
        description="""Room 076T//Raum 076T""",
    )

    roo_077b = VocabularyTerm(
        code="ROO_077B",
        label="077B",
        description="""Room 077B//Raum 077B""",
    )

    roo_077f = VocabularyTerm(
        code="ROO_077F",
        label="077F",
        description="""Room 077F//Raum 077F""",
    )

    roo_077t = VocabularyTerm(
        code="ROO_077T",
        label="077T",
        description="""Room 077T//Raum 077T""",
    )

    roo_078 = VocabularyTerm(
        code="ROO_078",
        label="078",
        description="""Room 078//Raum 078""",
    )

    roo_078b = VocabularyTerm(
        code="ROO_078B",
        label="078B",
        description="""Room 078B//Raum 078B""",
    )

    roo_078t = VocabularyTerm(
        code="ROO_078T",
        label="078T",
        description="""Room 078T//Raum 078T""",
    )

    roo_079 = VocabularyTerm(
        code="ROO_079",
        label="079",
        description="""Room 079//Raum 079""",
    )

    roo_079b = VocabularyTerm(
        code="ROO_079B",
        label="079B",
        description="""Room 079B//Raum 079B""",
    )

    roo_080 = VocabularyTerm(
        code="ROO_080",
        label="080",
        description="""Room 080//Raum 080""",
    )

    roo_080b = VocabularyTerm(
        code="ROO_080B",
        label="080B",
        description="""Room 080B//Raum 080B""",
    )

    roo_080f = VocabularyTerm(
        code="ROO_080F",
        label="080F",
        description="""Room 080F//Raum 080F""",
    )

    roo_080k = VocabularyTerm(
        code="ROO_080K",
        label="080K",
        description="""Room 080K//Raum 080K""",
    )

    roo_081 = VocabularyTerm(
        code="ROO_081",
        label="081",
        description="""Room 081//Raum 081""",
    )

    roo_081f = VocabularyTerm(
        code="ROO_081F",
        label="081F",
        description="""Room 081F//Raum 081F""",
    )

    roo_082 = VocabularyTerm(
        code="ROO_082",
        label="082",
        description="""Room 082//Raum 082""",
    )

    roo_082b = VocabularyTerm(
        code="ROO_082B",
        label="082B",
        description="""Room 082B//Raum 082B""",
    )

    roo_082f = VocabularyTerm(
        code="ROO_082F",
        label="082F",
        description="""Room 082F//Raum 082F""",
    )

    roo_083 = VocabularyTerm(
        code="ROO_083",
        label="083",
        description="""Room 083//Raum 083""",
    )

    roo_084 = VocabularyTerm(
        code="ROO_084",
        label="084",
        description="""Room 084//Raum 084""",
    )

    roo_084b = VocabularyTerm(
        code="ROO_084B",
        label="084B",
        description="""Room 084B//Raum 084B""",
    )

    roo_084f = VocabularyTerm(
        code="ROO_084F",
        label="084F",
        description="""Room 084F//Raum 084F""",
    )

    roo_084t = VocabularyTerm(
        code="ROO_084T",
        label="084T",
        description="""Room 084T//Raum 084T""",
    )

    roo_085 = VocabularyTerm(
        code="ROO_085",
        label="085",
        description="""Room 085//Raum 085""",
    )

    roo_085b = VocabularyTerm(
        code="ROO_085B",
        label="085B",
        description="""Room 085B//Raum 085B""",
    )

    roo_086 = VocabularyTerm(
        code="ROO_086",
        label="086",
        description="""Room 086//Raum 086""",
    )

    roo_086b = VocabularyTerm(
        code="ROO_086B",
        label="086B",
        description="""Room 086B//Raum 086B""",
    )

    roo_086c = VocabularyTerm(
        code="ROO_086C",
        label="086C",
        description="""Room 086C//Raum 086C""",
    )

    roo_086f = VocabularyTerm(
        code="ROO_086F",
        label="086F",
        description="""Room 086F//Raum 086F""",
    )

    roo_087 = VocabularyTerm(
        code="ROO_087",
        label="087",
        description="""Room 087//Raum 087""",
    )

    roo_087b = VocabularyTerm(
        code="ROO_087B",
        label="087B",
        description="""Room 087B//Raum 087B""",
    )

    roo_088 = VocabularyTerm(
        code="ROO_088",
        label="088",
        description="""Room 088//Raum 088""",
    )

    roo_088b = VocabularyTerm(
        code="ROO_088B",
        label="088B",
        description="""Room 088B//Raum 088B""",
    )

    roo_089 = VocabularyTerm(
        code="ROO_089",
        label="089",
        description="""Room 089//Raum 089""",
    )

    roo_090 = VocabularyTerm(
        code="ROO_090",
        label="090",
        description="""Room 090//Raum 090""",
    )

    roo_090b = VocabularyTerm(
        code="ROO_090B",
        label="090B",
        description="""Room 090B//Raum 090B""",
    )

    roo_090f = VocabularyTerm(
        code="ROO_090F",
        label="090F",
        description="""Room 090F//Raum 090F""",
    )

    roo_090t = VocabularyTerm(
        code="ROO_090T",
        label="090T",
        description="""Room 090T//Raum 090T""",
    )

    roo_091 = VocabularyTerm(
        code="ROO_091",
        label="091",
        description="""Room 091//Raum 091""",
    )

    roo_091k = VocabularyTerm(
        code="ROO_091K",
        label="091K",
        description="""Room 091K//Raum 091K""",
    )

    roo_092 = VocabularyTerm(
        code="ROO_092",
        label="092",
        description="""Room 092//Raum 092""",
    )

    roo_092f = VocabularyTerm(
        code="ROO_092F",
        label="092F",
        description="""Room 092F//Raum 092F""",
    )

    roo_093 = VocabularyTerm(
        code="ROO_093",
        label="093",
        description="""Room 093//Raum 093""",
    )

    roo_093b = VocabularyTerm(
        code="ROO_093B",
        label="093B",
        description="""Room 093B//Raum 093B""",
    )

    roo_093h = VocabularyTerm(
        code="ROO_093H",
        label="093H",
        description="""Room 093H//Raum 093H""",
    )

    roo_093t = VocabularyTerm(
        code="ROO_093T",
        label="093T",
        description="""Room 093T//Raum 093T""",
    )

    roo_094 = VocabularyTerm(
        code="ROO_094",
        label="094",
        description="""Room 094//Raum 094""",
    )

    roo_094b = VocabularyTerm(
        code="ROO_094B",
        label="094B",
        description="""Room 094B//Raum 094B""",
    )

    roo_094t = VocabularyTerm(
        code="ROO_094T",
        label="094T",
        description="""Room 094T//Raum 094T""",
    )

    roo_095 = VocabularyTerm(
        code="ROO_095",
        label="095",
        description="""Room 095//Raum 095""",
    )

    roo_095f = VocabularyTerm(
        code="ROO_095F",
        label="095F",
        description="""Room 095F//Raum 095F""",
    )

    roo_096 = VocabularyTerm(
        code="ROO_096",
        label="096",
        description="""Room 096//Raum 096""",
    )

    roo_096b = VocabularyTerm(
        code="ROO_096B",
        label="096B",
        description="""Room 096B//Raum 096B""",
    )

    roo_096f = VocabularyTerm(
        code="ROO_096F",
        label="096F",
        description="""Room 096F//Raum 096F""",
    )

    roo_097 = VocabularyTerm(
        code="ROO_097",
        label="097",
        description="""Room 097//Raum 097""",
    )

    roo_098 = VocabularyTerm(
        code="ROO_098",
        label="098",
        description="""Room 098//Raum 098""",
    )

    roo_098b = VocabularyTerm(
        code="ROO_098B",
        label="098B",
        description="""Room 098B//Raum 098B""",
    )

    roo_098f = VocabularyTerm(
        code="ROO_098F",
        label="098F",
        description="""Room 098F//Raum 098F""",
    )

    roo_098t = VocabularyTerm(
        code="ROO_098T",
        label="098T",
        description="""Room 098T//Raum 098T""",
    )

    roo_099 = VocabularyTerm(
        code="ROO_099",
        label="099",
        description="""Room 099//Raum 099""",
    )

    roo_100 = VocabularyTerm(
        code="ROO_100",
        label="100",
        description="""Room 100//Raum 100""",
    )

    roo_100b = VocabularyTerm(
        code="ROO_100B",
        label="100B",
        description="""Room 100B//Raum 100B""",
    )

    roo_100d = VocabularyTerm(
        code="ROO_100D",
        label="100D",
        description="""Room 100D//Raum 100D""",
    )

    roo_100f = VocabularyTerm(
        code="ROO_100F",
        label="100F",
        description="""Room 100F//Raum 100F""",
    )

    roo_100h = VocabularyTerm(
        code="ROO_100H",
        label="100H",
        description="""Room 100H//Raum 100H""",
    )

    roo_100t = VocabularyTerm(
        code="ROO_100T",
        label="100T",
        description="""Room 100T//Raum 100T""",
    )

    roo_100wc = VocabularyTerm(
        code="ROO_100WC",
        label="100WC",
        description="""Room 100WC//Raum 100WC""",
    )

    roo_101 = VocabularyTerm(
        code="ROO_101",
        label="101",
        description="""Room 101//Raum 101""",
    )

    roo_101a = VocabularyTerm(
        code="ROO_101A",
        label="101A",
        description="""Room 101A//Raum 101A""",
    )

    roo_101aaf = VocabularyTerm(
        code="ROO_101AAF",
        label="101AAF",
        description="""Room 101AAF//Raum 101AAF""",
    )

    roo_101aat = VocabularyTerm(
        code="ROO_101AAT",
        label="101AAT",
        description="""Room 101AAT//Raum 101AAT""",
    )

    roo_101ab = VocabularyTerm(
        code="ROO_101AB",
        label="101AB",
        description="""Room 101AB//Raum 101AB""",
    )

    roo_101ad = VocabularyTerm(
        code="ROO_101AD",
        label="101AD",
        description="""Room 101AD//Raum 101AD""",
    )

    roo_101at = VocabularyTerm(
        code="ROO_101AT",
        label="101AT",
        description="""Room 101AT//Raum 101AT""",
    )

    roo_101b = VocabularyTerm(
        code="ROO_101B",
        label="101B",
        description="""Room 101B//Raum 101B""",
    )

    roo_101d = VocabularyTerm(
        code="ROO_101D",
        label="101D",
        description="""Room 101D//Raum 101D""",
    )

    roo_101f = VocabularyTerm(
        code="ROO_101F",
        label="101F",
        description="""Room 101F//Raum 101F""",
    )

    roo_101h = VocabularyTerm(
        code="ROO_101H",
        label="101H",
        description="""Room 101H//Raum 101H""",
    )

    roo_101t = VocabularyTerm(
        code="ROO_101T",
        label="101T",
        description="""Room 101T//Raum 101T""",
    )

    roo_101wc = VocabularyTerm(
        code="ROO_101WC",
        label="101WC",
        description="""Room 101WC//Raum 101WC""",
    )

    roo_102 = VocabularyTerm(
        code="ROO_102",
        label="102",
        description="""Room 102//Raum 102""",
    )

    roo_102a = VocabularyTerm(
        code="ROO_102A",
        label="102A",
        description="""Room 102A//Raum 102A""",
    )

    roo_102af = VocabularyTerm(
        code="ROO_102AF",
        label="102AF",
        description="""Room 102AF//Raum 102AF""",
    )

    roo_102b = VocabularyTerm(
        code="ROO_102B",
        label="102B",
        description="""Room 102B//Raum 102B""",
    )

    roo_102f = VocabularyTerm(
        code="ROO_102F",
        label="102F",
        description="""Room 102F//Raum 102F""",
    )

    roo_102t = VocabularyTerm(
        code="ROO_102T",
        label="102T",
        description="""Room 102T//Raum 102T""",
    )

    roo_103 = VocabularyTerm(
        code="ROO_103",
        label="103",
        description="""Room 103//Raum 103""",
    )

    roo_103b = VocabularyTerm(
        code="ROO_103B",
        label="103B",
        description="""Room 103B//Raum 103B""",
    )

    roo_103f = VocabularyTerm(
        code="ROO_103F",
        label="103F",
        description="""Room 103F//Raum 103F""",
    )

    roo_103t = VocabularyTerm(
        code="ROO_103T",
        label="103T",
        description="""Room 103T//Raum 103T""",
    )

    roo_103_mob = VocabularyTerm(
        code="ROO_103_MOB",
        label="103 MOB",
        description="""Room 103 MOB//Raum 103 MOB""",
    )

    roo_104 = VocabularyTerm(
        code="ROO_104",
        label="104",
        description="""Room 104//Raum 104""",
    )

    roo_104a = VocabularyTerm(
        code="ROO_104A",
        label="104A",
        description="""Room 104A//Raum 104A""",
    )

    roo_104b = VocabularyTerm(
        code="ROO_104B",
        label="104B",
        description="""Room 104B//Raum 104B""",
    )

    roo_104d = VocabularyTerm(
        code="ROO_104D",
        label="104D",
        description="""Room 104D//Raum 104D""",
    )

    roo_104f = VocabularyTerm(
        code="ROO_104F",
        label="104F",
        description="""Room 104F//Raum 104F""",
    )

    roo_104h = VocabularyTerm(
        code="ROO_104H",
        label="104H",
        description="""Room 104H//Raum 104H""",
    )

    roo_105 = VocabularyTerm(
        code="ROO_105",
        label="105",
        description="""Room 105//Raum 105""",
    )

    roo_105b = VocabularyTerm(
        code="ROO_105B",
        label="105B",
        description="""Room 105B//Raum 105B""",
    )

    roo_105d = VocabularyTerm(
        code="ROO_105D",
        label="105D",
        description="""Room 105D//Raum 105D""",
    )

    roo_105f = VocabularyTerm(
        code="ROO_105F",
        label="105F",
        description="""Room 105F//Raum 105F""",
    )

    roo_105h = VocabularyTerm(
        code="ROO_105H",
        label="105H",
        description="""Room 105H//Raum 105H""",
    )

    roo_105t = VocabularyTerm(
        code="ROO_105T",
        label="105T",
        description="""Room 105T//Raum 105T""",
    )

    roo_105wc = VocabularyTerm(
        code="ROO_105WC",
        label="105WC",
        description="""Room 105WC//Raum 105WC""",
    )

    roo_106 = VocabularyTerm(
        code="ROO_106",
        label="106",
        description="""Room 106//Raum 106""",
    )

    roo_106b = VocabularyTerm(
        code="ROO_106B",
        label="106B",
        description="""Room 106B//Raum 106B""",
    )

    roo_106f = VocabularyTerm(
        code="ROO_106F",
        label="106F",
        description="""Room 106F//Raum 106F""",
    )

    roo_106h = VocabularyTerm(
        code="ROO_106H",
        label="106H",
        description="""Room 106H//Raum 106H""",
    )

    roo_106t = VocabularyTerm(
        code="ROO_106T",
        label="106T",
        description="""Room 106T//Raum 106T""",
    )

    roo_106wc = VocabularyTerm(
        code="ROO_106WC",
        label="106WC",
        description="""Room 106WC//Raum 106WC""",
    )

    roo_107 = VocabularyTerm(
        code="ROO_107",
        label="107",
        description="""Room 107//Raum 107""",
    )

    roo_107b = VocabularyTerm(
        code="ROO_107B",
        label="107B",
        description="""Room 107B//Raum 107B""",
    )

    roo_107f = VocabularyTerm(
        code="ROO_107F",
        label="107F",
        description="""Room 107F//Raum 107F""",
    )

    roo_107h = VocabularyTerm(
        code="ROO_107H",
        label="107H",
        description="""Room 107H//Raum 107H""",
    )

    roo_107t = VocabularyTerm(
        code="ROO_107T",
        label="107T",
        description="""Room 107T//Raum 107T""",
    )

    roo_108 = VocabularyTerm(
        code="ROO_108",
        label="108",
        description="""Room 108//Raum 108""",
    )

    roo_108a = VocabularyTerm(
        code="ROO_108A",
        label="108A",
        description="""Room 108A//Raum 108A""",
    )

    roo_108b = VocabularyTerm(
        code="ROO_108B",
        label="108B",
        description="""Room 108B//Raum 108B""",
    )

    roo_108d = VocabularyTerm(
        code="ROO_108D",
        label="108D",
        description="""Room 108D//Raum 108D""",
    )

    roo_108f = VocabularyTerm(
        code="ROO_108F",
        label="108F",
        description="""Room 108F//Raum 108F""",
    )

    roo_108h = VocabularyTerm(
        code="ROO_108H",
        label="108H",
        description="""Room 108H//Raum 108H""",
    )

    roo_108t = VocabularyTerm(
        code="ROO_108T",
        label="108T",
        description="""Room 108T//Raum 108T""",
    )

    roo_108wc = VocabularyTerm(
        code="ROO_108WC",
        label="108WC",
        description="""Room 108WC//Raum 108WC""",
    )

    roo_109 = VocabularyTerm(
        code="ROO_109",
        label="109",
        description="""Room 109//Raum 109""",
    )

    roo_109b = VocabularyTerm(
        code="ROO_109B",
        label="109B",
        description="""Room 109B//Raum 109B""",
    )

    roo_109d = VocabularyTerm(
        code="ROO_109D",
        label="109D",
        description="""Room 109D//Raum 109D""",
    )

    roo_109f = VocabularyTerm(
        code="ROO_109F",
        label="109F",
        description="""Room 109F//Raum 109F""",
    )

    roo_109h = VocabularyTerm(
        code="ROO_109H",
        label="109H",
        description="""Room 109H//Raum 109H""",
    )

    roo_109t = VocabularyTerm(
        code="ROO_109T",
        label="109T",
        description="""Room 109T//Raum 109T""",
    )

    roo_109wc = VocabularyTerm(
        code="ROO_109WC",
        label="109WC",
        description="""Room 109WC//Raum 109WC""",
    )

    roo_110 = VocabularyTerm(
        code="ROO_110",
        label="110",
        description="""Room 110//Raum 110""",
    )

    roo_110a = VocabularyTerm(
        code="ROO_110A",
        label="110A",
        description="""Room 110A//Raum 110A""",
    )

    roo_110b = VocabularyTerm(
        code="ROO_110B",
        label="110B",
        description="""Room 110B//Raum 110B""",
    )

    roo_110f = VocabularyTerm(
        code="ROO_110F",
        label="110F",
        description="""Room 110F//Raum 110F""",
    )

    roo_110t = VocabularyTerm(
        code="ROO_110T",
        label="110T",
        description="""Room 110T//Raum 110T""",
    )

    roo_111 = VocabularyTerm(
        code="ROO_111",
        label="111",
        description="""Room 111//Raum 111""",
    )

    roo_111b = VocabularyTerm(
        code="ROO_111B",
        label="111B",
        description="""Room 111B//Raum 111B""",
    )

    roo_111d = VocabularyTerm(
        code="ROO_111D",
        label="111D",
        description="""Room 111D//Raum 111D""",
    )

    roo_111f = VocabularyTerm(
        code="ROO_111F",
        label="111F",
        description="""Room 111F//Raum 111F""",
    )

    roo_111h = VocabularyTerm(
        code="ROO_111H",
        label="111H",
        description="""Room 111H//Raum 111H""",
    )

    roo_111t = VocabularyTerm(
        code="ROO_111T",
        label="111T",
        description="""Room 111T//Raum 111T""",
    )

    roo_112 = VocabularyTerm(
        code="ROO_112",
        label="112",
        description="""Room 112//Raum 112""",
    )

    roo_112a = VocabularyTerm(
        code="ROO_112A",
        label="112A",
        description="""Room 112A//Raum 112A""",
    )

    roo_112ad = VocabularyTerm(
        code="ROO_112AD",
        label="112AD",
        description="""Room 112AD//Raum 112AD""",
    )

    roo_112b = VocabularyTerm(
        code="ROO_112B",
        label="112B",
        description="""Room 112B//Raum 112B""",
    )

    roo_112f = VocabularyTerm(
        code="ROO_112F",
        label="112F",
        description="""Room 112F//Raum 112F""",
    )

    roo_112h = VocabularyTerm(
        code="ROO_112H",
        label="112H",
        description="""Room 112H//Raum 112H""",
    )

    roo_113 = VocabularyTerm(
        code="ROO_113",
        label="113",
        description="""Room 113//Raum 113""",
    )

    roo_113b = VocabularyTerm(
        code="ROO_113B",
        label="113B",
        description="""Room 113B//Raum 113B""",
    )

    roo_113f = VocabularyTerm(
        code="ROO_113F",
        label="113F",
        description="""Room 113F//Raum 113F""",
    )

    roo_113h = VocabularyTerm(
        code="ROO_113H",
        label="113H",
        description="""Room 113H//Raum 113H""",
    )

    roo_113t = VocabularyTerm(
        code="ROO_113T",
        label="113T",
        description="""Room 113T//Raum 113T""",
    )

    roo_114 = VocabularyTerm(
        code="ROO_114",
        label="114",
        description="""Room 114//Raum 114""",
    )

    roo_114ad = VocabularyTerm(
        code="ROO_114AD",
        label="114AD",
        description="""Room 114AD//Raum 114AD""",
    )

    roo_114at = VocabularyTerm(
        code="ROO_114AT",
        label="114AT",
        description="""Room 114AT//Raum 114AT""",
    )

    roo_114b = VocabularyTerm(
        code="ROO_114B",
        label="114B",
        description="""Room 114B//Raum 114B""",
    )

    roo_114d = VocabularyTerm(
        code="ROO_114D",
        label="114D",
        description="""Room 114D//Raum 114D""",
    )

    roo_114f = VocabularyTerm(
        code="ROO_114F",
        label="114F",
        description="""Room 114F//Raum 114F""",
    )

    roo_114h = VocabularyTerm(
        code="ROO_114H",
        label="114H",
        description="""Room 114H//Raum 114H""",
    )

    roo_114t = VocabularyTerm(
        code="ROO_114T",
        label="114T",
        description="""Room 114T//Raum 114T""",
    )

    roo_115 = VocabularyTerm(
        code="ROO_115",
        label="115",
        description="""Room 115//Raum 115""",
    )

    roo_115at = VocabularyTerm(
        code="ROO_115AT",
        label="115AT",
        description="""Room 115AT//Raum 115AT""",
    )

    roo_115b = VocabularyTerm(
        code="ROO_115B",
        label="115B",
        description="""Room 115B//Raum 115B""",
    )

    roo_115d = VocabularyTerm(
        code="ROO_115D",
        label="115D",
        description="""Room 115D//Raum 115D""",
    )

    roo_115f = VocabularyTerm(
        code="ROO_115F",
        label="115F",
        description="""Room 115F//Raum 115F""",
    )

    roo_115t = VocabularyTerm(
        code="ROO_115T",
        label="115T",
        description="""Room 115T//Raum 115T""",
    )

    roo_115wc = VocabularyTerm(
        code="ROO_115WC",
        label="115WC",
        description="""Room 115WC//Raum 115WC""",
    )

    roo_116 = VocabularyTerm(
        code="ROO_116",
        label="116",
        description="""Room 116//Raum 116""",
    )

    roo_116a = VocabularyTerm(
        code="ROO_116A",
        label="116A",
        description="""Room 116A//Raum 116A""",
    )

    roo_116b = VocabularyTerm(
        code="ROO_116B",
        label="116B",
        description="""Room 116B//Raum 116B""",
    )

    roo_116d = VocabularyTerm(
        code="ROO_116D",
        label="116D",
        description="""Room 116D//Raum 116D""",
    )

    roo_116f = VocabularyTerm(
        code="ROO_116F",
        label="116F",
        description="""Room 116F//Raum 116F""",
    )

    roo_116h = VocabularyTerm(
        code="ROO_116H",
        label="116H",
        description="""Room 116H//Raum 116H""",
    )

    roo_116t = VocabularyTerm(
        code="ROO_116T",
        label="116T",
        description="""Room 116T//Raum 116T""",
    )

    roo_117 = VocabularyTerm(
        code="ROO_117",
        label="117",
        description="""Room 117//Raum 117""",
    )

    roo_117a = VocabularyTerm(
        code="ROO_117A",
        label="117A",
        description="""Room 117A//Raum 117A""",
    )

    roo_117b = VocabularyTerm(
        code="ROO_117B",
        label="117B",
        description="""Room 117B//Raum 117B""",
    )

    roo_117f = VocabularyTerm(
        code="ROO_117F",
        label="117F",
        description="""Room 117F//Raum 117F""",
    )

    roo_117h = VocabularyTerm(
        code="ROO_117H",
        label="117H",
        description="""Room 117H//Raum 117H""",
    )

    roo_117wc = VocabularyTerm(
        code="ROO_117WC",
        label="117WC",
        description="""Room 117WC//Raum 117WC""",
    )

    roo_118 = VocabularyTerm(
        code="ROO_118",
        label="118",
        description="""Room 118//Raum 118""",
    )

    roo_118a = VocabularyTerm(
        code="ROO_118A",
        label="118A",
        description="""Room 118A//Raum 118A""",
    )

    roo_118b = VocabularyTerm(
        code="ROO_118B",
        label="118B",
        description="""Room 118B//Raum 118B""",
    )

    roo_118f = VocabularyTerm(
        code="ROO_118F",
        label="118F",
        description="""Room 118F//Raum 118F""",
    )

    roo_118t = VocabularyTerm(
        code="ROO_118T",
        label="118T",
        description="""Room 118T//Raum 118T""",
    )

    roo_118wc = VocabularyTerm(
        code="ROO_118WC",
        label="118WC",
        description="""Room 118WC//Raum 118WC""",
    )

    roo_119 = VocabularyTerm(
        code="ROO_119",
        label="119",
        description="""Room 119//Raum 119""",
    )

    roo_119a = VocabularyTerm(
        code="ROO_119A",
        label="119A",
        description="""Room 119A//Raum 119A""",
    )

    roo_119b = VocabularyTerm(
        code="ROO_119B",
        label="119B",
        description="""Room 119B//Raum 119B""",
    )

    roo_119c = VocabularyTerm(
        code="ROO_119C",
        label="119C",
        description="""Room 119C//Raum 119C""",
    )

    roo_119d = VocabularyTerm(
        code="ROO_119D",
        label="119D",
        description="""Room 119D//Raum 119D""",
    )

    roo_119f = VocabularyTerm(
        code="ROO_119F",
        label="119F",
        description="""Room 119F//Raum 119F""",
    )

    roo_119h = VocabularyTerm(
        code="ROO_119H",
        label="119H",
        description="""Room 119H//Raum 119H""",
    )

    roo_119t = VocabularyTerm(
        code="ROO_119T",
        label="119T",
        description="""Room 119T//Raum 119T""",
    )

    roo_120 = VocabularyTerm(
        code="ROO_120",
        label="120",
        description="""Room 120//Raum 120""",
    )

    roo_120a = VocabularyTerm(
        code="ROO_120A",
        label="120A",
        description="""Room 120A//Raum 120A""",
    )

    roo_120b = VocabularyTerm(
        code="ROO_120B",
        label="120B",
        description="""Room 120B//Raum 120B""",
    )

    roo_120f = VocabularyTerm(
        code="ROO_120F",
        label="120F",
        description="""Room 120F//Raum 120F""",
    )

    roo_120h = VocabularyTerm(
        code="ROO_120H",
        label="120H",
        description="""Room 120H//Raum 120H""",
    )

    roo_120t = VocabularyTerm(
        code="ROO_120T",
        label="120T",
        description="""Room 120T//Raum 120T""",
    )

    roo_121 = VocabularyTerm(
        code="ROO_121",
        label="121",
        description="""Room 121//Raum 121""",
    )

    roo_121a = VocabularyTerm(
        code="ROO_121A",
        label="121A",
        description="""Room 121A//Raum 121A""",
    )

    roo_121b = VocabularyTerm(
        code="ROO_121B",
        label="121B",
        description="""Room 121B//Raum 121B""",
    )

    roo_121c = VocabularyTerm(
        code="ROO_121C",
        label="121C",
        description="""Room 121C//Raum 121C""",
    )

    roo_121d = VocabularyTerm(
        code="ROO_121D",
        label="121D",
        description="""Room 121D//Raum 121D""",
    )

    roo_121f = VocabularyTerm(
        code="ROO_121F",
        label="121F",
        description="""Room 121F//Raum 121F""",
    )

    roo_122 = VocabularyTerm(
        code="ROO_122",
        label="122",
        description="""Room 122//Raum 122""",
    )

    roo_122a = VocabularyTerm(
        code="ROO_122A",
        label="122A",
        description="""Room 122A//Raum 122A""",
    )

    roo_122b = VocabularyTerm(
        code="ROO_122B",
        label="122B",
        description="""Room 122B//Raum 122B""",
    )

    roo_122d = VocabularyTerm(
        code="ROO_122D",
        label="122D",
        description="""Room 122D//Raum 122D""",
    )

    roo_122f = VocabularyTerm(
        code="ROO_122F",
        label="122F",
        description="""Room 122F//Raum 122F""",
    )

    roo_122h = VocabularyTerm(
        code="ROO_122H",
        label="122H",
        description="""Room 122H//Raum 122H""",
    )

    roo_122t = VocabularyTerm(
        code="ROO_122T",
        label="122T",
        description="""Room 122T//Raum 122T""",
    )

    roo_122wc = VocabularyTerm(
        code="ROO_122WC",
        label="122WC",
        description="""Room 122WC//Raum 122WC""",
    )

    roo_123 = VocabularyTerm(
        code="ROO_123",
        label="123",
        description="""Room 123//Raum 123""",
    )

    roo_123b = VocabularyTerm(
        code="ROO_123B",
        label="123B",
        description="""Room 123B//Raum 123B""",
    )

    roo_123c = VocabularyTerm(
        code="ROO_123C",
        label="123C",
        description="""Room 123C//Raum 123C""",
    )

    roo_123f = VocabularyTerm(
        code="ROO_123F",
        label="123F",
        description="""Room 123F//Raum 123F""",
    )

    roo_123h = VocabularyTerm(
        code="ROO_123H",
        label="123H",
        description="""Room 123H//Raum 123H""",
    )

    roo_124 = VocabularyTerm(
        code="ROO_124",
        label="124",
        description="""Room 124//Raum 124""",
    )

    roo_124a = VocabularyTerm(
        code="ROO_124A",
        label="124A",
        description="""Room 124A//Raum 124A""",
    )

    roo_124b = VocabularyTerm(
        code="ROO_124B",
        label="124B",
        description="""Room 124B//Raum 124B""",
    )

    roo_124d = VocabularyTerm(
        code="ROO_124D",
        label="124D",
        description="""Room 124D//Raum 124D""",
    )

    roo_124f = VocabularyTerm(
        code="ROO_124F",
        label="124F",
        description="""Room 124F//Raum 124F""",
    )

    roo_124t = VocabularyTerm(
        code="ROO_124T",
        label="124T",
        description="""Room 124T//Raum 124T""",
    )

    roo_125 = VocabularyTerm(
        code="ROO_125",
        label="125",
        description="""Room 125//Raum 125""",
    )

    roo_125b = VocabularyTerm(
        code="ROO_125B",
        label="125B",
        description="""Room 125B//Raum 125B""",
    )

    roo_125f = VocabularyTerm(
        code="ROO_125F",
        label="125F",
        description="""Room 125F//Raum 125F""",
    )

    roo_125h = VocabularyTerm(
        code="ROO_125H",
        label="125H",
        description="""Room 125H//Raum 125H""",
    )

    roo_125t = VocabularyTerm(
        code="ROO_125T",
        label="125T",
        description="""Room 125T//Raum 125T""",
    )

    roo_126 = VocabularyTerm(
        code="ROO_126",
        label="126",
        description="""Room 126//Raum 126""",
    )

    roo_126b = VocabularyTerm(
        code="ROO_126B",
        label="126B",
        description="""Room 126B//Raum 126B""",
    )

    roo_126f = VocabularyTerm(
        code="ROO_126F",
        label="126F",
        description="""Room 126F//Raum 126F""",
    )

    roo_126t = VocabularyTerm(
        code="ROO_126T",
        label="126T",
        description="""Room 126T//Raum 126T""",
    )

    roo_127 = VocabularyTerm(
        code="ROO_127",
        label="127",
        description="""Room 127//Raum 127""",
    )

    roo_127b = VocabularyTerm(
        code="ROO_127B",
        label="127B",
        description="""Room 127B//Raum 127B""",
    )

    roo_127f = VocabularyTerm(
        code="ROO_127F",
        label="127F",
        description="""Room 127F//Raum 127F""",
    )

    roo_128 = VocabularyTerm(
        code="ROO_128",
        label="128",
        description="""Room 128//Raum 128""",
    )

    roo_128b = VocabularyTerm(
        code="ROO_128B",
        label="128B",
        description="""Room 128B//Raum 128B""",
    )

    roo_128dh = VocabularyTerm(
        code="ROO_128DH",
        label="128DH",
        description="""Room 128DH//Raum 128DH""",
    )

    roo_129 = VocabularyTerm(
        code="ROO_129",
        label="129",
        description="""Room 129//Raum 129""",
    )

    roo_129b = VocabularyTerm(
        code="ROO_129B",
        label="129B",
        description="""Room 129B//Raum 129B""",
    )

    roo_129f = VocabularyTerm(
        code="ROO_129F",
        label="129F",
        description="""Room 129F//Raum 129F""",
    )

    roo_129t = VocabularyTerm(
        code="ROO_129T",
        label="129T",
        description="""Room 129T//Raum 129T""",
    )

    roo_130 = VocabularyTerm(
        code="ROO_130",
        label="130",
        description="""Room 130//Raum 130""",
    )

    roo_130a = VocabularyTerm(
        code="ROO_130A",
        label="130A",
        description="""Room 130A//Raum 130A""",
    )

    roo_130b = VocabularyTerm(
        code="ROO_130B",
        label="130B",
        description="""Room 130B//Raum 130B""",
    )

    roo_130dh = VocabularyTerm(
        code="ROO_130DH",
        label="130DH",
        description="""Room 130DH//Raum 130DH""",
    )

    roo_130f = VocabularyTerm(
        code="ROO_130F",
        label="130F",
        description="""Room 130F//Raum 130F""",
    )

    roo_131 = VocabularyTerm(
        code="ROO_131",
        label="131",
        description="""Room 131//Raum 131""",
    )

    roo_131a = VocabularyTerm(
        code="ROO_131A",
        label="131A",
        description="""Room 131A//Raum 131A""",
    )

    roo_131b = VocabularyTerm(
        code="ROO_131B",
        label="131B",
        description="""Room 131B//Raum 131B""",
    )

    roo_131f = VocabularyTerm(
        code="ROO_131F",
        label="131F",
        description="""Room 131F//Raum 131F""",
    )

    roo_131h = VocabularyTerm(
        code="ROO_131H",
        label="131H",
        description="""Room 131H//Raum 131H""",
    )

    roo_131t = VocabularyTerm(
        code="ROO_131T",
        label="131T",
        description="""Room 131T//Raum 131T""",
    )

    roo_132 = VocabularyTerm(
        code="ROO_132",
        label="132",
        description="""Room 132//Raum 132""",
    )

    roo_132a = VocabularyTerm(
        code="ROO_132A",
        label="132A",
        description="""Room 132A//Raum 132A""",
    )

    roo_132aaf = VocabularyTerm(
        code="ROO_132AAF",
        label="132AAF",
        description="""Room 132AAF//Raum 132AAF""",
    )

    roo_132b = VocabularyTerm(
        code="ROO_132B",
        label="132B",
        description="""Room 132B//Raum 132B""",
    )

    roo_132t = VocabularyTerm(
        code="ROO_132T",
        label="132T",
        description="""Room 132T//Raum 132T""",
    )

    roo_133 = VocabularyTerm(
        code="ROO_133",
        label="133",
        description="""Room 133//Raum 133""",
    )

    roo_133t = VocabularyTerm(
        code="ROO_133T",
        label="133T",
        description="""Room 133T//Raum 133T""",
    )

    roo_134 = VocabularyTerm(
        code="ROO_134",
        label="134",
        description="""Room 134//Raum 134""",
    )

    roo_134aat = VocabularyTerm(
        code="ROO_134AAT",
        label="134AAT",
        description="""Room 134AAT//Raum 134AAT""",
    )

    roo_134at = VocabularyTerm(
        code="ROO_134AT",
        label="134AT",
        description="""Room 134AT//Raum 134AT""",
    )

    roo_134b = VocabularyTerm(
        code="ROO_134B",
        label="134B",
        description="""Room 134B//Raum 134B""",
    )

    roo_134d = VocabularyTerm(
        code="ROO_134D",
        label="134D",
        description="""Room 134D//Raum 134D""",
    )

    roo_134t = VocabularyTerm(
        code="ROO_134T",
        label="134T",
        description="""Room 134T//Raum 134T""",
    )

    roo_134wc = VocabularyTerm(
        code="ROO_134WC",
        label="134WC",
        description="""Room 134WC//Raum 134WC""",
    )

    roo_135 = VocabularyTerm(
        code="ROO_135",
        label="135",
        description="""Room 135//Raum 135""",
    )

    roo_135a = VocabularyTerm(
        code="ROO_135A",
        label="135A",
        description="""Room 135A//Raum 135A""",
    )

    roo_135f = VocabularyTerm(
        code="ROO_135F",
        label="135F",
        description="""Room 135F//Raum 135F""",
    )

    roo_136 = VocabularyTerm(
        code="ROO_136",
        label="136",
        description="""Room 136//Raum 136""",
    )

    roo_136b = VocabularyTerm(
        code="ROO_136B",
        label="136B",
        description="""Room 136B//Raum 136B""",
    )

    roo_136f = VocabularyTerm(
        code="ROO_136F",
        label="136F",
        description="""Room 136F//Raum 136F""",
    )

    roo_136t = VocabularyTerm(
        code="ROO_136T",
        label="136T",
        description="""Room 136T//Raum 136T""",
    )

    roo_137 = VocabularyTerm(
        code="ROO_137",
        label="137",
        description="""Room 137//Raum 137""",
    )

    roo_137f = VocabularyTerm(
        code="ROO_137F",
        label="137F",
        description="""Room 137F//Raum 137F""",
    )

    roo_137t = VocabularyTerm(
        code="ROO_137T",
        label="137T",
        description="""Room 137T//Raum 137T""",
    )

    roo_138 = VocabularyTerm(
        code="ROO_138",
        label="138",
        description="""Room 138//Raum 138""",
    )

    roo_138f = VocabularyTerm(
        code="ROO_138F",
        label="138F",
        description="""Room 138F//Raum 138F""",
    )

    roo_138t = VocabularyTerm(
        code="ROO_138T",
        label="138T",
        description="""Room 138T//Raum 138T""",
    )

    roo_139 = VocabularyTerm(
        code="ROO_139",
        label="139",
        description="""Room 139//Raum 139""",
    )

    roo_139b = VocabularyTerm(
        code="ROO_139B",
        label="139B",
        description="""Room 139B//Raum 139B""",
    )

    roo_139d = VocabularyTerm(
        code="ROO_139D",
        label="139D",
        description="""Room 139D//Raum 139D""",
    )

    roo_139f = VocabularyTerm(
        code="ROO_139F",
        label="139F",
        description="""Room 139F//Raum 139F""",
    )

    roo_139h = VocabularyTerm(
        code="ROO_139H",
        label="139H",
        description="""Room 139H//Raum 139H""",
    )

    roo_140 = VocabularyTerm(
        code="ROO_140",
        label="140",
        description="""Room 140//Raum 140""",
    )

    roo_140f = VocabularyTerm(
        code="ROO_140F",
        label="140F",
        description="""Room 140F//Raum 140F""",
    )

    roo_140t = VocabularyTerm(
        code="ROO_140T",
        label="140T",
        description="""Room 140T//Raum 140T""",
    )

    roo_141 = VocabularyTerm(
        code="ROO_141",
        label="141",
        description="""Room 141//Raum 141""",
    )

    roo_141b = VocabularyTerm(
        code="ROO_141B",
        label="141B",
        description="""Room 141B//Raum 141B""",
    )

    roo_141d = VocabularyTerm(
        code="ROO_141D",
        label="141D",
        description="""Room 141D//Raum 141D""",
    )

    roo_141h = VocabularyTerm(
        code="ROO_141H",
        label="141H",
        description="""Room 141H//Raum 141H""",
    )

    roo_141t = VocabularyTerm(
        code="ROO_141T",
        label="141T",
        description="""Room 141T//Raum 141T""",
    )

    roo_142 = VocabularyTerm(
        code="ROO_142",
        label="142",
        description="""Room 142//Raum 142""",
    )

    roo_142b = VocabularyTerm(
        code="ROO_142B",
        label="142B",
        description="""Room 142B//Raum 142B""",
    )

    roo_142d = VocabularyTerm(
        code="ROO_142D",
        label="142D",
        description="""Room 142D//Raum 142D""",
    )

    roo_142h = VocabularyTerm(
        code="ROO_142H",
        label="142H",
        description="""Room 142H//Raum 142H""",
    )

    roo_143 = VocabularyTerm(
        code="ROO_143",
        label="143",
        description="""Room 143//Raum 143""",
    )

    roo_143b = VocabularyTerm(
        code="ROO_143B",
        label="143B",
        description="""Room 143B//Raum 143B""",
    )

    roo_143d = VocabularyTerm(
        code="ROO_143D",
        label="143D",
        description="""Room 143D//Raum 143D""",
    )

    roo_143f = VocabularyTerm(
        code="ROO_143F",
        label="143F",
        description="""Room 143F//Raum 143F""",
    )

    roo_143h = VocabularyTerm(
        code="ROO_143H",
        label="143H",
        description="""Room 143H//Raum 143H""",
    )

    roo_144 = VocabularyTerm(
        code="ROO_144",
        label="144",
        description="""Room 144//Raum 144""",
    )

    roo_145 = VocabularyTerm(
        code="ROO_145",
        label="145",
        description="""Room 145//Raum 145""",
    )

    roo_145b = VocabularyTerm(
        code="ROO_145B",
        label="145B",
        description="""Room 145B//Raum 145B""",
    )

    roo_145t = VocabularyTerm(
        code="ROO_145T",
        label="145T",
        description="""Room 145T//Raum 145T""",
    )

    roo_146 = VocabularyTerm(
        code="ROO_146",
        label="146",
        description="""Room 146//Raum 146""",
    )

    roo_147 = VocabularyTerm(
        code="ROO_147",
        label="147",
        description="""Room 147//Raum 147""",
    )

    roo_148 = VocabularyTerm(
        code="ROO_148",
        label="148",
        description="""Room 148//Raum 148""",
    )

    roo_148f = VocabularyTerm(
        code="ROO_148F",
        label="148F",
        description="""Room 148F//Raum 148F""",
    )

    roo_149 = VocabularyTerm(
        code="ROO_149",
        label="149",
        description="""Room 149//Raum 149""",
    )

    roo_149f = VocabularyTerm(
        code="ROO_149F",
        label="149F",
        description="""Room 149F//Raum 149F""",
    )

    roo_150 = VocabularyTerm(
        code="ROO_150",
        label="150",
        description="""Room 150//Raum 150""",
    )

    roo_150ad = VocabularyTerm(
        code="ROO_150AD",
        label="150AD",
        description="""Room 150AD//Raum 150AD""",
    )

    roo_150at = VocabularyTerm(
        code="ROO_150AT",
        label="150AT",
        description="""Room 150AT//Raum 150AT""",
    )

    roo_150b = VocabularyTerm(
        code="ROO_150B",
        label="150B",
        description="""Room 150B//Raum 150B""",
    )

    roo_150f = VocabularyTerm(
        code="ROO_150F",
        label="150F",
        description="""Room 150F//Raum 150F""",
    )

    roo_150t = VocabularyTerm(
        code="ROO_150T",
        label="150T",
        description="""Room 150T//Raum 150T""",
    )

    roo_151 = VocabularyTerm(
        code="ROO_151",
        label="151",
        description="""Room 151//Raum 151""",
    )

    roo_151b = VocabularyTerm(
        code="ROO_151B",
        label="151B",
        description="""Room 151B//Raum 151B""",
    )

    roo_151f = VocabularyTerm(
        code="ROO_151F",
        label="151F",
        description="""Room 151F//Raum 151F""",
    )

    roo_152 = VocabularyTerm(
        code="ROO_152",
        label="152",
        description="""Room 152//Raum 152""",
    )

    roo_152a = VocabularyTerm(
        code="ROO_152A",
        label="152A",
        description="""Room 152A//Raum 152A""",
    )

    roo_153 = VocabularyTerm(
        code="ROO_153",
        label="153",
        description="""Room 153//Raum 153""",
    )

    roo_153h = VocabularyTerm(
        code="ROO_153H",
        label="153H",
        description="""Room 153H//Raum 153H""",
    )

    roo_153t = VocabularyTerm(
        code="ROO_153T",
        label="153T",
        description="""Room 153T//Raum 153T""",
    )

    roo_154 = VocabularyTerm(
        code="ROO_154",
        label="154",
        description="""Room 154//Raum 154""",
    )

    roo_154f = VocabularyTerm(
        code="ROO_154F",
        label="154F",
        description="""Room 154F//Raum 154F""",
    )

    roo_155 = VocabularyTerm(
        code="ROO_155",
        label="155",
        description="""Room 155//Raum 155""",
    )

    roo_155d = VocabularyTerm(
        code="ROO_155D",
        label="155D",
        description="""Room 155D//Raum 155D""",
    )

    roo_155f = VocabularyTerm(
        code="ROO_155F",
        label="155F",
        description="""Room 155F//Raum 155F""",
    )

    roo_155wc = VocabularyTerm(
        code="ROO_155WC",
        label="155WC",
        description="""Room 155WC//Raum 155WC""",
    )

    roo_156 = VocabularyTerm(
        code="ROO_156",
        label="156",
        description="""Room 156//Raum 156""",
    )

    roo_156t = VocabularyTerm(
        code="ROO_156T",
        label="156T",
        description="""Room 156T//Raum 156T""",
    )

    roo_157 = VocabularyTerm(
        code="ROO_157",
        label="157",
        description="""Room 157//Raum 157""",
    )

    roo_158 = VocabularyTerm(
        code="ROO_158",
        label="158",
        description="""Room 158//Raum 158""",
    )

    roo_158b = VocabularyTerm(
        code="ROO_158B",
        label="158B",
        description="""Room 158B//Raum 158B""",
    )

    roo_158f = VocabularyTerm(
        code="ROO_158F",
        label="158F",
        description="""Room 158F//Raum 158F""",
    )

    roo_159 = VocabularyTerm(
        code="ROO_159",
        label="159",
        description="""Room 159//Raum 159""",
    )

    roo_159d = VocabularyTerm(
        code="ROO_159D",
        label="159D",
        description="""Room 159D//Raum 159D""",
    )

    roo_160 = VocabularyTerm(
        code="ROO_160",
        label="160",
        description="""Room 160//Raum 160""",
    )

    roo_160f = VocabularyTerm(
        code="ROO_160F",
        label="160F",
        description="""Room 160F//Raum 160F""",
    )

    roo_161 = VocabularyTerm(
        code="ROO_161",
        label="161",
        description="""Room 161//Raum 161""",
    )

    roo_161b = VocabularyTerm(
        code="ROO_161B",
        label="161B",
        description="""Room 161B//Raum 161B""",
    )

    roo_161f = VocabularyTerm(
        code="ROO_161F",
        label="161F",
        description="""Room 161F//Raum 161F""",
    )

    roo_161t = VocabularyTerm(
        code="ROO_161T",
        label="161T",
        description="""Room 161T//Raum 161T""",
    )

    roo_162 = VocabularyTerm(
        code="ROO_162",
        label="162",
        description="""Room 162//Raum 162""",
    )

    roo_162b = VocabularyTerm(
        code="ROO_162B",
        label="162B",
        description="""Room 162B//Raum 162B""",
    )

    roo_162f = VocabularyTerm(
        code="ROO_162F",
        label="162F",
        description="""Room 162F//Raum 162F""",
    )

    roo_162h = VocabularyTerm(
        code="ROO_162H",
        label="162H",
        description="""Room 162H//Raum 162H""",
    )

    roo_162t = VocabularyTerm(
        code="ROO_162T",
        label="162T",
        description="""Room 162T//Raum 162T""",
    )

    roo_163 = VocabularyTerm(
        code="ROO_163",
        label="163",
        description="""Room 163//Raum 163""",
    )

    roo_163b = VocabularyTerm(
        code="ROO_163B",
        label="163B",
        description="""Room 163B//Raum 163B""",
    )

    roo_164 = VocabularyTerm(
        code="ROO_164",
        label="164",
        description="""Room 164//Raum 164""",
    )

    roo_165 = VocabularyTerm(
        code="ROO_165",
        label="165",
        description="""Room 165//Raum 165""",
    )

    roo_165f = VocabularyTerm(
        code="ROO_165F",
        label="165F",
        description="""Room 165F//Raum 165F""",
    )

    roo_165h = VocabularyTerm(
        code="ROO_165H",
        label="165H",
        description="""Room 165H//Raum 165H""",
    )

    roo_166 = VocabularyTerm(
        code="ROO_166",
        label="166",
        description="""Room 166//Raum 166""",
    )

    roo_167 = VocabularyTerm(
        code="ROO_167",
        label="167",
        description="""Room 167//Raum 167""",
    )

    roo_167b = VocabularyTerm(
        code="ROO_167B",
        label="167B",
        description="""Room 167B//Raum 167B""",
    )

    roo_168 = VocabularyTerm(
        code="ROO_168",
        label="168",
        description="""Room 168//Raum 168""",
    )

    roo_168f = VocabularyTerm(
        code="ROO_168F",
        label="168F",
        description="""Room 168F//Raum 168F""",
    )

    roo_169 = VocabularyTerm(
        code="ROO_169",
        label="169",
        description="""Room 169//Raum 169""",
    )

    roo_169f = VocabularyTerm(
        code="ROO_169F",
        label="169F",
        description="""Room 169F//Raum 169F""",
    )

    roo_170 = VocabularyTerm(
        code="ROO_170",
        label="170",
        description="""Room 170//Raum 170""",
    )

    roo_170b = VocabularyTerm(
        code="ROO_170B",
        label="170B",
        description="""Room 170B//Raum 170B""",
    )

    roo_170f = VocabularyTerm(
        code="ROO_170F",
        label="170F",
        description="""Room 170F//Raum 170F""",
    )

    roo_171 = VocabularyTerm(
        code="ROO_171",
        label="171",
        description="""Room 171//Raum 171""",
    )

    roo_171f = VocabularyTerm(
        code="ROO_171F",
        label="171F",
        description="""Room 171F//Raum 171F""",
    )

    roo_172 = VocabularyTerm(
        code="ROO_172",
        label="172",
        description="""Room 172//Raum 172""",
    )

    roo_173 = VocabularyTerm(
        code="ROO_173",
        label="173",
        description="""Room 173//Raum 173""",
    )

    roo_173t = VocabularyTerm(
        code="ROO_173T",
        label="173T",
        description="""Room 173T//Raum 173T""",
    )

    roo_174 = VocabularyTerm(
        code="ROO_174"