<!-- ---
hide: toc
--- -->

# Welcome to the `bam-masterdata` documentation page.

The `bam-masterdata` is a Python package designed to define and handle the [Masterdata](references/glossary.md#masterdata) used in the BAM Data Store project. The BAM Data Store is the central system for Research Data Management at the Bundesanstalt für Materialforschung und -prüfung (BAM). It is a customized instance of [openBIS](https://openbis.ch/).
<!-- This documentation page is divided according to the [diataxis method](https://www.diataxis.fr/). -->


<div markdown="block" class="home-grid">

<div markdown="block">

<h3>Tutorials</h3>

The **Tutorials** are designed to guide you through the general and basic functionalities of the package. They are ideal for learning the software during your first interaction.

- [Getting Started](tutorials/getting_started.md)
- [Automating Metadata with Parsers](tutorials/parsing.md)

</div>

<div markdown="block">

<h3>How-to guides</h3>

The **How-to guides** provide step-by-step instructions for a variety of tasks. These serve as a quick reference for practical applications when you need specific information.

- Parsing
    - [Use the Parser app](howtos/parsing/parser_app.md)
    - [Create new parsers](howtos/parsing/create_new_parsers.md)

</div>

<div markdown="block">

<h3>Explanations</h3>

The **Explanations** offer theoretical insights into the core concepts.

- [Parsing Structure](explanations/parsing_structure.md)
- [Schema Definitions](explanations/schema_defs.md)

</div>

<div markdown="block">

<h3>References</h3>

The **References** include a glossary of terms and the automatically generated API documentation.

- [Glossary](references/glossary.md)
- [API Reference](references/api.md)
- [Extra](references/extra.md)

</div>

</div>


## Contact
This documentation is a work in progress. If you have questions that are not yet addressed, please contact [datastore@bam.de](mailto:datastore@bam.de).

