# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AclPolicyArgs', 'AclPolicy']

@pulumi.input_type
class AclPolicyArgs:
    def __init__(__self__, *,
                 rules_hcl: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 job_acl: Optional[pulumi.Input['AclPolicyJobAclArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AclPolicy resource.
        :param pulumi.Input[_builtins.str] rules_hcl: `(string: <required>)` - The contents of the policy to register,
               as HCL or JSON.
        :param pulumi.Input[_builtins.str] description: `(string: "")` - A description of the policy.
        :param pulumi.Input['AclPolicyJobAclArgs'] job_acl: `(``JobACL``: <optional>)` - Options for assigning the
               ACL rules to a job, group, or task.
        :param pulumi.Input[_builtins.str] name: `(string: <required>)` - A unique name for the policy.
        """
        pulumi.set(__self__, "rules_hcl", rules_hcl)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if job_acl is not None:
            pulumi.set(__self__, "job_acl", job_acl)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="rulesHcl")
    def rules_hcl(self) -> pulumi.Input[_builtins.str]:
        """
        `(string: <required>)` - The contents of the policy to register,
        as HCL or JSON.
        """
        return pulumi.get(self, "rules_hcl")

    @rules_hcl.setter
    def rules_hcl(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rules_hcl", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: "")` - A description of the policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="jobAcl")
    def job_acl(self) -> Optional[pulumi.Input['AclPolicyJobAclArgs']]:
        """
        `(``JobACL``: <optional>)` - Options for assigning the
        ACL rules to a job, group, or task.
        """
        return pulumi.get(self, "job_acl")

    @job_acl.setter
    def job_acl(self, value: Optional[pulumi.Input['AclPolicyJobAclArgs']]):
        pulumi.set(self, "job_acl", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: <required>)` - A unique name for the policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _AclPolicyState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 job_acl: Optional[pulumi.Input['AclPolicyJobAclArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rules_hcl: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AclPolicy resources.
        :param pulumi.Input[_builtins.str] description: `(string: "")` - A description of the policy.
        :param pulumi.Input['AclPolicyJobAclArgs'] job_acl: `(``JobACL``: <optional>)` - Options for assigning the
               ACL rules to a job, group, or task.
        :param pulumi.Input[_builtins.str] name: `(string: <required>)` - A unique name for the policy.
        :param pulumi.Input[_builtins.str] rules_hcl: `(string: <required>)` - The contents of the policy to register,
               as HCL or JSON.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if job_acl is not None:
            pulumi.set(__self__, "job_acl", job_acl)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rules_hcl is not None:
            pulumi.set(__self__, "rules_hcl", rules_hcl)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: "")` - A description of the policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="jobAcl")
    def job_acl(self) -> Optional[pulumi.Input['AclPolicyJobAclArgs']]:
        """
        `(``JobACL``: <optional>)` - Options for assigning the
        ACL rules to a job, group, or task.
        """
        return pulumi.get(self, "job_acl")

    @job_acl.setter
    def job_acl(self, value: Optional[pulumi.Input['AclPolicyJobAclArgs']]):
        pulumi.set(self, "job_acl", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: <required>)` - A unique name for the policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="rulesHcl")
    def rules_hcl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: <required>)` - The contents of the policy to register,
        as HCL or JSON.
        """
        return pulumi.get(self, "rules_hcl")

    @rules_hcl.setter
    def rules_hcl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rules_hcl", value)


@pulumi.type_token("nomad:index/aclPolicy:AclPolicy")
class AclPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 job_acl: Optional[pulumi.Input[Union['AclPolicyJobAclArgs', 'AclPolicyJobAclArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rules_hcl: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an ACL policy registered in Nomad.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: `(string: "")` - A description of the policy.
        :param pulumi.Input[Union['AclPolicyJobAclArgs', 'AclPolicyJobAclArgsDict']] job_acl: `(``JobACL``: <optional>)` - Options for assigning the
               ACL rules to a job, group, or task.
        :param pulumi.Input[_builtins.str] name: `(string: <required>)` - A unique name for the policy.
        :param pulumi.Input[_builtins.str] rules_hcl: `(string: <required>)` - The contents of the policy to register,
               as HCL or JSON.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AclPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an ACL policy registered in Nomad.

        :param str resource_name: The name of the resource.
        :param AclPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AclPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 job_acl: Optional[pulumi.Input[Union['AclPolicyJobAclArgs', 'AclPolicyJobAclArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rules_hcl: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AclPolicyArgs.__new__(AclPolicyArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["job_acl"] = job_acl
            __props__.__dict__["name"] = name
            if rules_hcl is None and not opts.urn:
                raise TypeError("Missing required property 'rules_hcl'")
            __props__.__dict__["rules_hcl"] = rules_hcl
        super(AclPolicy, __self__).__init__(
            'nomad:index/aclPolicy:AclPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            job_acl: Optional[pulumi.Input[Union['AclPolicyJobAclArgs', 'AclPolicyJobAclArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            rules_hcl: Optional[pulumi.Input[_builtins.str]] = None) -> 'AclPolicy':
        """
        Get an existing AclPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: `(string: "")` - A description of the policy.
        :param pulumi.Input[Union['AclPolicyJobAclArgs', 'AclPolicyJobAclArgsDict']] job_acl: `(``JobACL``: <optional>)` - Options for assigning the
               ACL rules to a job, group, or task.
        :param pulumi.Input[_builtins.str] name: `(string: <required>)` - A unique name for the policy.
        :param pulumi.Input[_builtins.str] rules_hcl: `(string: <required>)` - The contents of the policy to register,
               as HCL or JSON.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AclPolicyState.__new__(_AclPolicyState)

        __props__.__dict__["description"] = description
        __props__.__dict__["job_acl"] = job_acl
        __props__.__dict__["name"] = name
        __props__.__dict__["rules_hcl"] = rules_hcl
        return AclPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `(string: "")` - A description of the policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="jobAcl")
    def job_acl(self) -> pulumi.Output[Optional['outputs.AclPolicyJobAcl']]:
        """
        `(``JobACL``: <optional>)` - Options for assigning the
        ACL rules to a job, group, or task.
        """
        return pulumi.get(self, "job_acl")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        `(string: <required>)` - A unique name for the policy.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="rulesHcl")
    def rules_hcl(self) -> pulumi.Output[_builtins.str]:
        """
        `(string: <required>)` - The contents of the policy to register,
        as HCL or JSON.
        """
        return pulumi.get(self, "rules_hcl")

