# mypy-boto3-mturk

[![PyPI - mypy-boto3-mturk](https://img.shields.io/pypi/v/mypy-boto3-mturk.svg?color=blue)](https://pypi.org/project/mypy-boto3-mturk)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-mturk.svg?color=blue)](https://pypi.org/project/mypy-boto3-mturk)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.MTurk 1.14.46](https://boto3.amazonaws.com/v1/documentation/api/1.14.46/reference/services/mturk.html#MTurk) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `MTurk` service.

```bash
python -m pip install boto3-stubs[mturk]
```

## How to use

### Client annotations

`MTurkClient` provides annotations for `boto3.client("mturk")`.

```python
import boto3

from mypy_boto3_mturk import MTurkClient
from mypy_boto3_mturk.paginator import (
    ListAssignmentsForHITPaginator,
    ListBonusPaymentsPaginator,
    ListHITsForQualificationTypePaginator,
    ListHITsPaginator,
    ListQualificationRequestsPaginator,
    ListQualificationTypesPaginator,
    ListReviewableHITsPaginator,
    ListWorkerBlocksPaginator,
    ListWorkersWithQualificationTypePaginator,
)
from mypy_boto3_mturk.type_defs import AssignmentTypeDef, ...

client: MTurkClient = boto3.client("mturk")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: MTurkClient = session.client("mturk")
```

### Paginators annotations

`mypy_boto3_mturk.paginator` module contains type annotations for all paginators.

```python

client: MTurkClient = boto3.client("mturk")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_assignments_for_hit_paginator: ListAssignmentsForHITPaginator = client.get_paginator("list_assignments_for_hit")
list_bonus_payments_paginator: ListBonusPaymentsPaginator = client.get_paginator("list_bonus_payments")
list_hits_paginator: ListHITsPaginator = client.get_paginator("list_hits")
list_hits_for_qualification_type_paginator: ListHITsForQualificationTypePaginator = client.get_paginator("list_hits_for_qualification_type")
list_qualification_requests_paginator: ListQualificationRequestsPaginator = client.get_paginator("list_qualification_requests")
list_qualification_types_paginator: ListQualificationTypesPaginator = client.get_paginator("list_qualification_types")
list_reviewable_hits_paginator: ListReviewableHITsPaginator = client.get_paginator("list_reviewable_hits")
list_worker_blocks_paginator: ListWorkerBlocksPaginator = client.get_paginator("list_worker_blocks")
list_workers_with_qualification_type_paginator: ListWorkersWithQualificationTypePaginator = client.get_paginator("list_workers_with_qualification_type")
```







### Typed dictionations

`mypy_boto3_mturk.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> AssignmentTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_mturk` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("mturk")

session_client = boto3.Session().client("mturk")
```
