// ==UserScript==
// @name ITA Matrix Powertools
// @namespace https://github.com/adamhwang/ita-matrix-powertools
// @description Adds new features and builds fare purchase links for ITA Matrix
// @version 0.56.1
// @icon https://raw.githubusercontent.com/adamhwang/ita-matrix-powertools/master/icons/icon32.png
// @require https://greasemonkey.github.io/gm4-polyfill/gm4-polyfill.js
// @grant GM.getValue
// @grant GM_setValue
// @grant GM.setValue
// @grant GM_setValue
// @include /https?://((new)|(old))?matrix\.itasoftware\.com/.*$/
// @license GPL-2.0-only
// @downloadURL https://update.greasyfork.org/scripts/395661/ITA%20Matrix%20Powertools.user.js
// @updateURL https://update.greasyfork.org/scripts/395661/ITA%20Matrix%20Powertools.meta.js
// ==/UserScript==

/*
 Written by paul21, Steppo & Adam Hwang (IAkH) of FlyerTalk.com
 http://www.flyertalk.com/forum/members/paul21.html
 Includes contriutions by https://github.com/adamhwang/ita-matrix-powertools/blob/master/AUTHORS
 GNU General Public License v2.0
*/

//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool:
//     `npm run build`
//
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/base64-js/index.js":
/***/ ((__unused_webpack_module, exports) => {

"use strict";
var __webpack_unused_export__;


__webpack_unused_export__ = byteLength
__webpack_unused_export__ = toByteArray
exports.fromByteArray = fromByteArray

var lookup = []
var revLookup = []
var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array

var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'
for (var i = 0, len = code.length; i < len; ++i) {
  lookup[i] = code[i]
  revLookup[code.charCodeAt(i)] = i
}

// Support decoding URL-safe base64 strings, as Node.js does.
// See: https://en.wikipedia.org/wiki/Base64#URL_applications
revLookup['-'.charCodeAt(0)] = 62
revLookup['_'.charCodeAt(0)] = 63

function getLens (b64) {
  var len = b64.length

  if (len % 4 > 0) {
    throw new Error('Invalid string. Length must be a multiple of 4')
  }

  // Trim off extra bytes after placeholder bytes are found
  // See: https://github.com/beatgammit/base64-js/issues/42
  var validLen = b64.indexOf('=')
  if (validLen === -1) validLen = len

  var placeHoldersLen = validLen === len
    ? 0
    : 4 - (validLen % 4)

  return [validLen, placeHoldersLen]
}

// base64 is 4/3 + up to two characters of the original data
function byteLength (b64) {
  var lens = getLens(b64)
  var validLen = lens[0]
  var placeHoldersLen = lens[1]
  return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
}

function _byteLength (b64, validLen, placeHoldersLen) {
  return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
}

function toByteArray (b64) {
  var tmp
  var lens = getLens(b64)
  var validLen = lens[0]
  var placeHoldersLen = lens[1]

  var arr = new Arr(_byteLength(b64, validLen, placeHoldersLen))

  var curByte = 0

  // if there are placeholders, only get up to the last complete 4 chars
  var len = placeHoldersLen > 0
    ? validLen - 4
    : validLen

  var i
  for (i = 0; i < len; i += 4) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 18) |
      (revLookup[b64.charCodeAt(i + 1)] << 12) |
      (revLookup[b64.charCodeAt(i + 2)] << 6) |
      revLookup[b64.charCodeAt(i + 3)]
    arr[curByte++] = (tmp >> 16) & 0xFF
    arr[curByte++] = (tmp >> 8) & 0xFF
    arr[curByte++] = tmp & 0xFF
  }

  if (placeHoldersLen === 2) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 2) |
      (revLookup[b64.charCodeAt(i + 1)] >> 4)
    arr[curByte++] = tmp & 0xFF
  }

  if (placeHoldersLen === 1) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 10) |
      (revLookup[b64.charCodeAt(i + 1)] << 4) |
      (revLookup[b64.charCodeAt(i + 2)] >> 2)
    arr[curByte++] = (tmp >> 8) & 0xFF
    arr[curByte++] = tmp & 0xFF
  }

  return arr
}

function tripletToBase64 (num) {
  return lookup[num >> 18 & 0x3F] +
    lookup[num >> 12 & 0x3F] +
    lookup[num >> 6 & 0x3F] +
    lookup[num & 0x3F]
}

function encodeChunk (uint8, start, end) {
  var tmp
  var output = []
  for (var i = start; i < end; i += 3) {
    tmp =
      ((uint8[i] << 16) & 0xFF0000) +
      ((uint8[i + 1] << 8) & 0xFF00) +
      (uint8[i + 2] & 0xFF)
    output.push(tripletToBase64(tmp))
  }
  return output.join('')
}

function fromByteArray (uint8) {
  var tmp
  var len = uint8.length
  var extraBytes = len % 3 // if we have 1 byte left, pad 2 bytes
  var parts = []
  var maxChunkLength = 16383 // must be multiple of 3

  // go through the array every three bytes, we'll deal with trailing stuff later
  for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
    parts.push(encodeChunk(uint8, i, (i + maxChunkLength) > len2 ? len2 : (i + maxChunkLength)))
  }

  // pad the end with zeros, but make sure to not forget the extra bytes
  if (extraBytes === 1) {
    tmp = uint8[len - 1]
    parts.push(
      lookup[tmp >> 2] +
      lookup[(tmp << 4) & 0x3F] +
      '=='
    )
  } else if (extraBytes === 2) {
    tmp = (uint8[len - 2] << 8) + uint8[len - 1]
    parts.push(
      lookup[tmp >> 10] +
      lookup[(tmp >> 4) & 0x3F] +
      lookup[(tmp << 2) & 0x3F] +
      '='
    )
  }

  return parts.join('')
}


/***/ }),

/***/ "./node_modules/date-fns/_lib/assign/index.js":
/***/ ((module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = assign;
function assign(target, object) {
  if (target == null) {
    throw new TypeError('assign requires that input parameter not be null or undefined');
  }
  for (var property in object) {
    if (Object.prototype.hasOwnProperty.call(object, property)) {
      ;
      target[property] = object[property];
    }
  }
  return target;
}
module.exports = exports.default;

/***/ }),

/***/ "./node_modules/date-fns/_lib/cloneObject/index.js":
/***/ ((module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = (__webpack_require__("./node_modules/date-fns/node_modules/@babel/runtime/helpers/interopRequireDefault.js")["default"]);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = cloneObject;
var _index = _interopRequireDefault(__webpack_require__("./node_modules/date-fns/_lib/assign/index.js"));
function cloneObject(object) {
  return (0, _index.default)({}, object);
}
module.exports = exports.default;

/***/ }),

/***/ "./node_modules/date-fns/_lib/getTimezoneOffsetInMilliseconds/index.js":
/***/ ((module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = getTimezoneOffsetInMilliseconds;
/**
 * Google Chrome as of 67.0.3396.87 introduced timezones with offset that includes seconds.
 * They usually appear for dates that denote time before the timezones were introduced
 * (e.g. for 'Europe/Prague' timezone the offset is GMT+00:57:44 before 1 October 1891
 * and GMT+01:00:00 after that date)
 *
 * Date#getTimezoneOffset returns the offset in minutes and would return 57 for the example above,
 * which would lead to incorrect calculations.
 *
 * This function returns the timezone offset in milliseconds that takes seconds in account.
 */
function getTimezoneOffsetInMilliseconds(date) {
  var utcDate = new Date(Date.UTC(date.getFullYear(), date.getMonth(), date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds(), date.getMilliseconds()));
  utcDate.setUTCFullYear(date.getFullYear());
  return date.getTime() - utcDate.getTime();
}
module.exports = exports.default;

/***/ }),

/***/ "./node_modules/date-fns/_lib/toInteger/index.js":
/***/ ((module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = toInteger;
function toInteger(dirtyNumber) {
  if (dirtyNumber === null || dirtyNumber === true || dirtyNumber === false) {
    return NaN;
  }
  var number = Number(dirtyNumber);
  if (isNaN(number)) {
    return number;
  }
  return number < 0 ? Math.ceil(number) : Math.floor(number);
}
module.exports = exports.default;

/***/ }),

/***/ "./src/matrix5/index.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _print_links__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/print/links.tsx");
/* harmony import */ var _print_settings__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/print/settings.ts");
/* harmony import */ var _settings_itaSettings__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/settings/itaSettings.ts");
/* harmony import */ var _settings_userSettings__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/matrix5/settings/userSettings.js");
/* harmony import */ var _unsafe_policy__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/unsafe-policy.ts");
/* harmony import */ var _parse_itin__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/matrix5/parse/itin.ts");






(async () => {
    await (0,_settings_userSettings__WEBPACK_IMPORTED_MODULE_3__.loadUserSettings)();
    const appRoot = document.querySelector("app-root");
    if (!appRoot)
        return;
    (0,_print_settings__WEBPACK_IMPORTED_MODULE_1__.createUsersettings)(appRoot);
    injectCss();
    const isUserscript = !(typeof GM === "undefined" || typeof GM.info === "undefined");
    if (window.top === window.self) {
        if (!isUserscript || document.readyState == "complete") {
            startScript();
        }
        else {
            window.addEventListener("load", () => startScript(), false);
        }
    }
})();
let oldHref;
function startScript() {
    pageChanged();
    var bodyList = document.querySelector("body");
    var observer = new MutationObserver(function (mutations) {
        mutations.forEach(function (mutation) {
            if (oldHref != document.location.href) {
                oldHref = document.location.href;
                pageChanged();
            }
        });
    });
    var config = {
        childList: true,
        subtree: true,
    };
    observer.observe(bodyList, config);
}
function pageChanged() {
    setTimeout(async () => {
        const steps = document.querySelectorAll(".mat-step-header");
        if (steps.length > 0 &&
            steps[steps.length - 1].attributes["aria-selected"].value === "true") {
            // if we are on the last step (Itinerary)
            await (0,_parse_itin__WEBPACK_IMPORTED_MODULE_5__.readItinerary)();
            (0,_print_links__WEBPACK_IMPORTED_MODULE_0__.printLinksContainer)();
        }
    }, 200);
}
function injectCss() {
    let css = "", head = document.head || document.getElementsByTagName("head")[0], style = document.createElement("style");
    css +=
        ".pt-hover-menu, .pt-hover-menu-flex { position:absolute; padding: 8px; z-index: 1; background-color: #FFF; border: 1px solid #808080; display:none; }";
    css += ".pt-hover-container:hover .pt-hover-menu { display:inline; }";
    css += ".pt-hover-container:hover .pt-hover-menu-flex { display:flex; }";
    css += ".pt-textlink a { text-decoration: none; color: black; }";
    css += `.${_settings_itaSettings__WEBPACK_IMPORTED_MODULE_2__["default"].resultpage.mcDiv}.powertoolslinkinlinecontainer { background-color: #f2f2f2; }`;
    css +=
        ".pt-history-item:hover .pt-history-action { visibility: visible !important; }";
    style.appendChild(document.createTextNode((0,_unsafe_policy__WEBPACK_IMPORTED_MODULE_4__.unsafeHTML)(css)));
    head.appendChild(style);
}


/***/ }),

/***/ "./src/matrix5/links/index.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   allCarriers: () => (/* binding */ allCarriers),
/* harmony export */   anyCarriers: () => (/* binding */ anyCarriers),
/* harmony export */   register: () => (/* binding */ register),
/* harmony export */   validatePax: () => (/* binding */ validatePax)
/* harmony export */ });
/* harmony import */ var _settings_userSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/settings/userSettings.js");
/* harmony import */ var _settings_paxSettings__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/settings/paxSettings.js");
/* harmony import */ var _print_links__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/print/links.tsx");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/matrix5/parse/itin.ts");




const req = __webpack_require__("./src/matrix5/links sync recursive .[jt]s$");
req.keys().forEach(req);
/**
 * Registers a link
 */
function register(type, factory) {
    (0,_print_links__WEBPACK_IMPORTED_MODULE_2__.registerLink)(type, factory);
}
function allCarriers(...args) {
    return (_settings_userSettings__WEBPACK_IMPORTED_MODULE_0__["default"].showAllAirlines ||
        _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.carriers.every((cxr) => args.some((arg) => cxr === arg)));
}
function anyCarriers(...args) {
    return (_settings_userSettings__WEBPACK_IMPORTED_MODULE_0__["default"].showAllAirlines ||
        _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.carriers.some((cxr) => args.some((arg) => cxr === arg)));
}
function validatePax(config) {
    var tmpChildren = new Array();
    // push cur children
    for (var i = 0; i < _settings_paxSettings__WEBPACK_IMPORTED_MODULE_1__["default"].cAges.length; i++) {
        tmpChildren.push(_settings_paxSettings__WEBPACK_IMPORTED_MODULE_1__["default"].cAges[i]);
    }
    var ret = {
        adults: _settings_paxSettings__WEBPACK_IMPORTED_MODULE_1__["default"].adults,
        children: new Array(),
        infLap: _settings_paxSettings__WEBPACK_IMPORTED_MODULE_1__["default"].infantsLap,
        infSeat: 0,
    };
    if (config.sepInfSeat === true) {
        ret.infSeat = _settings_paxSettings__WEBPACK_IMPORTED_MODULE_1__["default"].infantsSeat;
    }
    else {
        for (var i = 0; i < _settings_paxSettings__WEBPACK_IMPORTED_MODULE_1__["default"].infantsSeat; i++) {
            tmpChildren.push(config.childMinAge);
        }
    }
    // process children
    for (var i = 0; i < tmpChildren.length; i++) {
        if (tmpChildren[i] < config.childAsAdult) {
            ret.children.push(tmpChildren[i]);
        }
        else {
            ret.adults++;
        }
    }
    // check Pax-Count
    if (config.maxPaxcount <=
        ret.adults +
            (config.countInf && ret.infLap) +
            ret.infSeat +
            ret.children.length) {
        console.log("Too many passengers");
        return;
    }
    if (0 === ret.adults + ret.infSeat + ret.children.length) {
        console.log("No passengers");
        return;
    }
    return ret;
}


/***/ }),

/***/ "./src/matrix5/links/otas/priceline.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXTERNAL MODULE: ./node_modules/base64-js/index.js
var base64_js = __webpack_require__("./node_modules/base64-js/index.js");
// EXTERNAL MODULE: ./src/matrix5/utils.js
var utils = __webpack_require__("./src/matrix5/utils.js");
// EXTERNAL MODULE: ./src/matrix5/links/index.ts
var links = __webpack_require__("./src/matrix5/links/index.ts");
// EXTERNAL MODULE: ./src/matrix5/parse/itin.ts
var itin = __webpack_require__("./src/matrix5/parse/itin.ts");
;// CONCATENATED MODULE: ./node_modules/@protobuf-ts/runtime/build/es2015/lower-camel-case.js
/**
 * Converts snake_case to lowerCamelCase.
 *
 * Should behave like protoc:
 * https://github.com/protocolbuffers/protobuf/blob/e8ae137c96444ea313485ed1118c5e43b2099cf1/src/google/protobuf/compiler/java/java_helpers.cc#L118
 */
function lowerCamelCase(snakeCase) {
    let capNext = false;
    const sb = [];
    for (let i = 0; i < snakeCase.length; i++) {
        let next = snakeCase.charAt(i);
        if (next == '_') {
            capNext = true;
        }
        else if (/\d/.test(next)) {
            sb.push(next);
            capNext = true;
        }
        else if (capNext) {
            sb.push(next.toUpperCase());
            capNext = false;
        }
        else if (i == 0) {
            sb.push(next.toLowerCase());
        }
        else {
            sb.push(next);
        }
    }
    return sb.join('');
}

;// CONCATENATED MODULE: ./node_modules/@protobuf-ts/runtime/build/es2015/reflection-info.js

/**
 * Scalar value types. This is a subset of field types declared by protobuf
 * enum google.protobuf.FieldDescriptorProto.Type The types GROUP and MESSAGE
 * are omitted, but the numerical values are identical.
 */
var ScalarType;
(function (ScalarType) {
    // 0 is reserved for errors.
    // Order is weird for historical reasons.
    ScalarType[ScalarType["DOUBLE"] = 1] = "DOUBLE";
    ScalarType[ScalarType["FLOAT"] = 2] = "FLOAT";
    // Not ZigZag encoded.  Negative numbers take 10 bytes.  Use TYPE_SINT64 if
    // negative values are likely.
    ScalarType[ScalarType["INT64"] = 3] = "INT64";
    ScalarType[ScalarType["UINT64"] = 4] = "UINT64";
    // Not ZigZag encoded.  Negative numbers take 10 bytes.  Use TYPE_SINT32 if
    // negative values are likely.
    ScalarType[ScalarType["INT32"] = 5] = "INT32";
    ScalarType[ScalarType["FIXED64"] = 6] = "FIXED64";
    ScalarType[ScalarType["FIXED32"] = 7] = "FIXED32";
    ScalarType[ScalarType["BOOL"] = 8] = "BOOL";
    ScalarType[ScalarType["STRING"] = 9] = "STRING";
    // Tag-delimited aggregate.
    // Group type is deprecated and not supported in proto3. However, Proto3
    // implementations should still be able to parse the group wire format and
    // treat group fields as unknown fields.
    // TYPE_GROUP = 10,
    // TYPE_MESSAGE = 11,  // Length-delimited aggregate.
    // New in version 2.
    ScalarType[ScalarType["BYTES"] = 12] = "BYTES";
    ScalarType[ScalarType["UINT32"] = 13] = "UINT32";
    // TYPE_ENUM = 14,
    ScalarType[ScalarType["SFIXED32"] = 15] = "SFIXED32";
    ScalarType[ScalarType["SFIXED64"] = 16] = "SFIXED64";
    ScalarType[ScalarType["SINT32"] = 17] = "SINT32";
    ScalarType[ScalarType["SINT64"] = 18] = "SINT64";
})(ScalarType || (ScalarType = {}));
/**
 * JavaScript representation of 64 bit integral types. Equivalent to the
 * field option "jstype".
 *
 * By default, protobuf-ts represents 64 bit types as `bigint`.
 *
 * You can change the default behaviour by enabling the plugin parameter
 * `long_type_string`, which will represent 64 bit types as `string`.
 *
 * Alternatively, you can change the behaviour for individual fields
 * with the field option "jstype":
 *
 * ```protobuf
 * uint64 my_field = 1 [jstype = JS_STRING];
 * uint64 other_field = 2 [jstype = JS_NUMBER];
 * ```
 */
var LongType;
(function (LongType) {
    /**
     * Use JavaScript `bigint`.
     *
     * Field option `[jstype = JS_NORMAL]`.
     */
    LongType[LongType["BIGINT"] = 0] = "BIGINT";
    /**
     * Use JavaScript `string`.
     *
     * Field option `[jstype = JS_STRING]`.
     */
    LongType[LongType["STRING"] = 1] = "STRING";
    /**
     * Use JavaScript `number`.
     *
     * Large values will loose precision.
     *
     * Field option `[jstype = JS_NUMBER]`.
     */
    LongType[LongType["NUMBER"] = 2] = "NUMBER";
})(LongType || (LongType = {}));
/**
 * Protobuf 2.1.0 introduced packed repeated fields.
 * Setting the field option `[packed = true]` enables packing.
 *
 * In proto3, all repeated fields are packed by default.
 * Setting the field option `[packed = false]` disables packing.
 *
 * Packed repeated fields are encoded with a single tag,
 * then a length-delimiter, then the element values.
 *
 * Unpacked repeated fields are encoded with a tag and
 * value for each element.
 *
 * `bytes` and `string` cannot be packed.
 */
var RepeatType;
(function (RepeatType) {
    /**
     * The field is not repeated.
     */
    RepeatType[RepeatType["NO"] = 0] = "NO";
    /**
     * The field is repeated and should be packed.
     * Invalid for `bytes` and `string`, they cannot be packed.
     */
    RepeatType[RepeatType["PACKED"] = 1] = "PACKED";
    /**
     * The field is repeated but should not be packed.
     * The only valid repeat type for repeated `bytes` and `string`.
     */
    RepeatType[RepeatType["UNPACKED"] = 2] = "UNPACKED";
})(RepeatType || (RepeatType = {}));
/**
 * Turns PartialFieldInfo into FieldInfo.
 */
function normalizeFieldInfo(field) {
    var _a, _b, _c, _d;
    field.localName = (_a = field.localName) !== null && _a !== void 0 ? _a : lowerCamelCase(field.name);
    field.jsonName = (_b = field.jsonName) !== null && _b !== void 0 ? _b : lowerCamelCase(field.name);
    field.repeat = (_c = field.repeat) !== null && _c !== void 0 ? _c : RepeatType.NO;
    field.opt = (_d = field.opt) !== null && _d !== void 0 ? _d : (field.repeat ? false : field.oneof ? false : field.kind == "message");
    return field;
}
/**
 * Read custom field options from a generated message type.
 *
 * @deprecated use readFieldOption()
 */
function readFieldOptions(messageType, fieldName, extensionName, extensionType) {
    var _a;
    const options = (_a = messageType.fields.find((m, i) => m.localName == fieldName || i == fieldName)) === null || _a === void 0 ? void 0 : _a.options;
    return options && options[extensionName] ? extensionType.fromJson(options[extensionName]) : undefined;
}
function readFieldOption(messageType, fieldName, extensionName, extensionType) {
    var _a;
    const options = (_a = messageType.fields.find((m, i) => m.localName == fieldName || i == fieldName)) === null || _a === void 0 ? void 0 : _a.options;
    if (!options) {
        return undefined;
    }
    const optionVal = options[extensionName];
    if (optionVal === undefined) {
        return optionVal;
    }
    return extensionType ? extensionType.fromJson(optionVal) : optionVal;
}
function readMessageOption(messageType, extensionName, extensionType) {
    const options = messageType.options;
    const optionVal = options[extensionName];
    if (optionVal === undefined) {
        return optionVal;
    }
    return extensionType ? extensionType.fromJson(optionVal) : optionVal;
}

;// CONCATENATED MODULE: ./node_modules/@protobuf-ts/runtime/build/es2015/oneof.js
/**
 * Is the given value a valid oneof group?
 *
 * We represent protobuf `oneof` as algebraic data types (ADT) in generated
 * code. But when working with messages of unknown type, the ADT does not
 * help us.
 *
 * This type guard checks if the given object adheres to the ADT rules, which
 * are as follows:
 *
 * 1) Must be an object.
 *
 * 2) Must have a "oneofKind" discriminator property.
 *
 * 3) If "oneofKind" is `undefined`, no member field is selected. The object
 * must not have any other properties.
 *
 * 4) If "oneofKind" is a `string`, the member field with this name is
 * selected.
 *
 * 5) If a member field is selected, the object must have a second property
 * with this name. The property must not be `undefined`.
 *
 * 6) No extra properties are allowed. The object has either one property
 * (no selection) or two properties (selection).
 *
 */
function isOneofGroup(any) {
    if (typeof any != 'object' || any === null || !any.hasOwnProperty('oneofKind')) {
        return false;
    }
    switch (typeof any.oneofKind) {
        case "string":
            if (any[any.oneofKind] === undefined)
                return false;
            return Object.keys(any).length == 2;
        case "undefined":
            return Object.keys(any).length == 1;
        default:
            return false;
    }
}
/**
 * Returns the value of the given field in a oneof group.
 */
function getOneofValue(oneof, kind) {
    return oneof[kind];
}
function setOneofValue(oneof, kind, value) {
    if (oneof.oneofKind !== undefined) {
        delete oneof[oneof.oneofKind];
    }
    oneof.oneofKind = kind;
    if (value !== undefined) {
        oneof[kind] = value;
    }
}
function setUnknownOneofValue(oneof, kind, value) {
    if (oneof.oneofKind !== undefined) {
        delete oneof[oneof.oneofKind];
    }
    oneof.oneofKind = kind;
    if (value !== undefined && kind !== undefined) {
        oneof[kind] = value;
    }
}
/**
 * Removes the selected field in a oneof group.
 *
 * Note that the recommended way to modify a oneof group is to set
 * a new object:
 *
 * ```ts
 * message.result = { oneofKind: undefined };
 * ```
 */
function clearOneofValue(oneof) {
    if (oneof.oneofKind !== undefined) {
        delete oneof[oneof.oneofKind];
    }
    oneof.oneofKind = undefined;
}
/**
 * Returns the selected value of the given oneof group.
 *
 * Not that the recommended way to access a oneof group is to check
 * the "oneofKind" property and let TypeScript narrow down the union
 * type for you:
 *
 * ```ts
 * if (message.result.oneofKind === "error") {
 *   message.result.error; // string
 * }
 * ```
 *
 * In the rare case you just need the value, and do not care about
 * which protobuf field is selected, you can use this function
 * for convenience.
 */
function getSelectedOneofValue(oneof) {
    if (oneof.oneofKind === undefined) {
        return undefined;
    }
    return oneof[oneof.oneofKind];
}

;// CONCATENATED MODULE: ./node_modules/@protobuf-ts/runtime/build/es2015/reflection-type-check.js


// noinspection JSMethodCanBeStatic
class ReflectionTypeCheck {
    constructor(info) {
        var _a;
        this.fields = (_a = info.fields) !== null && _a !== void 0 ? _a : [];
    }
    prepare() {
        if (this.data)
            return;
        const req = [], known = [], oneofs = [];
        for (let field of this.fields) {
            if (field.oneof) {
                if (!oneofs.includes(field.oneof)) {
                    oneofs.push(field.oneof);
                    req.push(field.oneof);
                    known.push(field.oneof);
                }
            }
            else {
                known.push(field.localName);
                switch (field.kind) {
                    case "scalar":
                    case "enum":
                        if (!field.opt || field.repeat)
                            req.push(field.localName);
                        break;
                    case "message":
                        if (field.repeat)
                            req.push(field.localName);
                        break;
                    case "map":
                        req.push(field.localName);
                        break;
                }
            }
        }
        this.data = { req, known, oneofs: Object.values(oneofs) };
    }
    /**
     * Is the argument a valid message as specified by the
     * reflection information?
     *
     * Checks all field types recursively. The `depth`
     * specifies how deep into the structure the check will be.
     *
     * With a depth of 0, only the presence of fields
     * is checked.
     *
     * With a depth of 1 or more, the field types are checked.
     *
     * With a depth of 2 or more, the members of map, repeated
     * and message fields are checked.
     *
     * Message fields will be checked recursively with depth - 1.
     *
     * The number of map entries / repeated values being checked
     * is < depth.
     */
    is(message, depth, allowExcessProperties = false) {
        if (depth < 0)
            return true;
        if (message === null || message === undefined || typeof message != 'object')
            return false;
        this.prepare();
        let keys = Object.keys(message), data = this.data;
        // if a required field is missing in arg, this cannot be a T
        if (keys.length < data.req.length || data.req.some(n => !keys.includes(n)))
            return false;
        if (!allowExcessProperties) {
            // if the arg contains a key we dont know, this is not a literal T
            if (keys.some(k => !data.known.includes(k)))
                return false;
        }
        // "With a depth of 0, only the presence and absence of fields is checked."
        // "With a depth of 1 or more, the field types are checked."
        if (depth < 1) {
            return true;
        }
        // check oneof group
        for (const name of data.oneofs) {
            const group = message[name];
            if (!isOneofGroup(group))
                return false;
            if (group.oneofKind === undefined)
                continue;
            const field = this.fields.find(f => f.localName === group.oneofKind);
            if (!field)
                return false; // we found no field, but have a kind, something is wrong
            if (!this.field(group[group.oneofKind], field, allowExcessProperties, depth))
                return false;
        }
        // check types
        for (const field of this.fields) {
            if (field.oneof !== undefined)
                continue;
            if (!this.field(message[field.localName], field, allowExcessProperties, depth))
                return false;
        }
        return true;
    }
    field(arg, field, allowExcessProperties, depth) {
        let repeated = field.repeat;
        switch (field.kind) {
            case "scalar":
                if (arg === undefined)
                    return field.opt;
                if (repeated)
                    return this.scalars(arg, field.T, depth, field.L);
                return this.scalar(arg, field.T, field.L);
            case "enum":
                if (arg === undefined)
                    return field.opt;
                if (repeated)
                    return this.scalars(arg, ScalarType.INT32, depth);
                return this.scalar(arg, ScalarType.INT32);
            case "message":
                if (arg === undefined)
                    return true;
                if (repeated)
                    return this.messages(arg, field.T(), allowExcessProperties, depth);
                return this.message(arg, field.T(), allowExcessProperties, depth);
            case "map":
                if (typeof arg != 'object' || arg === null)
                    return false;
                if (depth < 2)
                    return true;
                if (!this.mapKeys(arg, field.K, depth))
                    return false;
                switch (field.V.kind) {
                    case "scalar":
                        return this.scalars(Object.values(arg), field.V.T, depth, field.V.L);
                    case "enum":
                        return this.scalars(Object.values(arg), ScalarType.INT32, depth);
                    case "message":
                        return this.messages(Object.values(arg), field.V.T(), allowExcessProperties, depth);
                }
                break;
        }
        return true;
    }
    message(arg, type, allowExcessProperties, depth) {
        if (allowExcessProperties) {
            return type.isAssignable(arg, depth);
        }
        return type.is(arg, depth);
    }
    messages(arg, type, allowExcessProperties, depth) {
        if (!Array.isArray(arg))
            return false;
        if (depth < 2)
            return true;
        if (allowExcessProperties) {
            for (let i = 0; i < arg.length && i < depth; i++)
                if (!type.isAssignable(arg[i], depth - 1))
                    return false;
        }
        else {
            for (let i = 0; i < arg.length && i < depth; i++)
                if (!type.is(arg[i], depth - 1))
                    return false;
        }
        return true;
    }
    scalar(arg, type, longType) {
        let argType = typeof arg;
        switch (type) {
            case ScalarType.UINT64:
            case ScalarType.FIXED64:
            case ScalarType.INT64:
            case ScalarType.SFIXED64:
            case ScalarType.SINT64:
                switch (longType) {
                    case LongType.BIGINT:
                        return argType == "bigint";
                    case LongType.NUMBER:
                        return argType == "number" && !isNaN(arg);
                    default:
                        return argType == "string";
                }
            case ScalarType.BOOL:
                return argType == 'boolean';
            case ScalarType.STRING:
                return argType == 'string';
            case ScalarType.BYTES:
                return arg instanceof Uint8Array;
            case ScalarType.DOUBLE:
            case ScalarType.FLOAT:
                return argType == 'number' && !isNaN(arg);
            default:
                // case ScalarType.UINT32:
                // case ScalarType.FIXED32:
                // case ScalarType.INT32:
                // case ScalarType.SINT32:
                // case ScalarType.SFIXED32:
                return argType == 'number' && Number.isInteger(arg);
        }
    }
    scalars(arg, type, depth, longType) {
        if (!Array.isArray(arg))
            return false;
        if (depth < 2)
            return true;
        if (Array.isArray(arg))
            for (let i = 0; i < arg.length && i < depth; i++)
                if (!this.scalar(arg[i], type, longType))
                    return false;
        return true;
    }
    mapKeys(map, type, depth) {
        let keys = Object.keys(map);
        switch (type) {
            case ScalarType.INT32:
            case ScalarType.FIXED32:
            case ScalarType.SFIXED32:
            case ScalarType.SINT32:
            case ScalarType.UINT32:
                return this.scalars(keys.slice(0, depth).map(k => parseInt(k)), type, depth);
            case ScalarType.BOOL:
                return this.scalars(keys.slice(0, depth).map(k => k == 'true' ? true : k == 'false' ? false : k), type, depth);
            default:
                return this.scalars(keys, type, depth, LongType.STRING);
        }
    }
}

;// CONCATENATED MODULE: ./node_modules/@protobuf-ts/runtime/build/es2015/json-typings.js
/**
 * Get the type of a JSON value.
 * Distinguishes between array, null and object.
 */
function typeofJsonValue(value) {
    let t = typeof value;
    if (t == "object") {
        if (Array.isArray(value))
            return "array";
        if (value === null)
            return "null";
    }
    return t;
}
/**
 * Is this a JSON object (instead of an array or null)?
 */
function isJsonObject(value) {
    return value !== null && typeof value == "object" && !Array.isArray(value);
}

;// CONCATENATED MODULE: ./node_modules/@protobuf-ts/runtime/build/es2015/base64.js
// lookup table from base64 character to byte
let encTable = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'.split('');
// lookup table from base64 character *code* to byte because lookup by number is fast
let decTable = [];
for (let i = 0; i < encTable.length; i++)
    decTable[encTable[i].charCodeAt(0)] = i;
// support base64url variants
decTable["-".charCodeAt(0)] = encTable.indexOf("+");
decTable["_".charCodeAt(0)] = encTable.indexOf("/");
/**
 * Decodes a base64 string to a byte array.
 *
 * - ignores white-space, including line breaks and tabs
 * - allows inner padding (can decode concatenated base64 strings)
 * - does not require padding
 * - understands base64url encoding:
 *   "-" instead of "+",
 *   "_" instead of "/",
 *   no padding
 */
function base64decode(base64Str) {
    // estimate byte size, not accounting for inner padding and whitespace
    let es = base64Str.length * 3 / 4;
    // if (es % 3 !== 0)
    // throw new Error('invalid base64 string');
    if (base64Str[base64Str.length - 2] == '=')
        es -= 2;
    else if (base64Str[base64Str.length - 1] == '=')
        es -= 1;
    let bytes = new Uint8Array(es), bytePos = 0, // position in byte array
    groupPos = 0, // position in base64 group
    b, // current byte
    p = 0 // previous byte
    ;
    for (let i = 0; i < base64Str.length; i++) {
        b = decTable[base64Str.charCodeAt(i)];
        if (b === undefined) {
            // noinspection FallThroughInSwitchStatementJS
            switch (base64Str[i]) {
                case '=':
                    groupPos = 0; // reset state when padding found
                case '\n':
                case '\r':
                case '\t':
                case ' ':
                    continue; // skip white-space, and padding
                default:
                    throw Error(`invalid base64 string.`);
            }
        }
        switch (groupPos) {
            case 0:
                p = b;
                groupPos = 1;
                break;
            case 1:
                bytes[bytePos++] = p << 2 | (b & 48) >> 4;
                p = b;
                groupPos = 2;
                break;
            case 2:
                bytes[bytePos++] = (p & 15) << 4 | (b & 60) >> 2;
                p = b;
                groupPos = 3;
                break;
            case 3:
                bytes[bytePos++] = (p & 3) << 6 | b;
                groupPos = 0;
                break;
        }
    }
    if (groupPos == 1)
        throw Error(`invalid base64 string.`);
    return bytes.subarray(0, bytePos);
}
/**
 * Encodes a byte array to a base64 string.
 * Adds padding at the end.
 * Does not insert newlines.
 */
function base64encode(bytes) {
    let base64 = '', groupPos = 0, // position in base64 group
    b, // current byte
    p = 0; // carry over from previous byte
    for (let i = 0; i < bytes.length; i++) {
        b = bytes[i];
        switch (groupPos) {
            case 0:
                base64 += encTable[b >> 2];
                p = (b & 3) << 4;
                groupPos = 1;
                break;
            case 1:
                base64 += encTable[p | b >> 4];
                p = (b & 15) << 2;
                groupPos = 2;
                break;
            case 2:
                base64 += encTable[p | b >> 6];
                base64 += encTable[b & 63];
                groupPos = 0;
                break;
        }
    }
    // padding required?
    if (groupPos) {
        base64 += encTable[p];
        base64 += '=';
        if (groupPos == 1)
            base64 += '=';
    }
    return base64;
}

;// CONCATENATED MODULE: ./node_modules/@protobuf-ts/runtime/build/es2015/goog-varint.js
// Copyright 2008 Google Inc.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
// * Neither the name of Google Inc. nor the names of its
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Code generated by the Protocol Buffer compiler is owned by the owner
// of the input file used when generating it.  This code is not
// standalone and requires a support library to be linked with it.  This
// support library is itself covered by the above license.
/**
 * Read a 64 bit varint as two JS numbers.
 *
 * Returns tuple:
 * [0]: low bits
 * [0]: high bits
 *
 * Copyright 2008 Google Inc.  All rights reserved.
 *
 * See https://github.com/protocolbuffers/protobuf/blob/8a71927d74a4ce34efe2d8769fda198f52d20d12/js/experimental/runtime/kernel/buffer_decoder.js#L175
 */
function varint64read() {
    let lowBits = 0;
    let highBits = 0;
    for (let shift = 0; shift < 28; shift += 7) {
        let b = this.buf[this.pos++];
        lowBits |= (b & 0x7F) << shift;
        if ((b & 0x80) == 0) {
            this.assertBounds();
            return [lowBits, highBits];
        }
    }
    let middleByte = this.buf[this.pos++];
    // last four bits of the first 32 bit number
    lowBits |= (middleByte & 0x0F) << 28;
    // 3 upper bits are part of the next 32 bit number
    highBits = (middleByte & 0x70) >> 4;
    if ((middleByte & 0x80) == 0) {
        this.assertBounds();
        return [lowBits, highBits];
    }
    for (let shift = 3; shift <= 31; shift += 7) {
        let b = this.buf[this.pos++];
        highBits |= (b & 0x7F) << shift;
        if ((b & 0x80) == 0) {
            this.assertBounds();
            return [lowBits, highBits];
        }
    }
    throw new Error('invalid varint');
}
/**
 * Write a 64 bit varint, given as two JS numbers, to the given bytes array.
 *
 * Copyright 2008 Google Inc.  All rights reserved.
 *
 * See https://github.com/protocolbuffers/protobuf/blob/8a71927d74a4ce34efe2d8769fda198f52d20d12/js/experimental/runtime/kernel/writer.js#L344
 */
function varint64write(lo, hi, bytes) {
    for (let i = 0; i < 28; i = i + 7) {
        const shift = lo >>> i;
        const hasNext = !((shift >>> 7) == 0 && hi == 0);
        const byte = (hasNext ? shift | 0x80 : shift) & 0xFF;
        bytes.push(byte);
        if (!hasNext) {
            return;
        }
    }
    const splitBits = ((lo >>> 28) & 0x0F) | ((hi & 0x07) << 4);
    const hasMoreBits = !((hi >> 3) == 0);
    bytes.push((hasMoreBits ? splitBits | 0x80 : splitBits) & 0xFF);
    if (!hasMoreBits) {
        return;
    }
    for (let i = 3; i < 31; i = i + 7) {
        const shift = hi >>> i;
        const hasNext = !((shift >>> 7) == 0);
        const byte = (hasNext ? shift | 0x80 : shift) & 0xFF;
        bytes.push(byte);
        if (!hasNext) {
            return;
        }
    }
    bytes.push((hi >>> 31) & 0x01);
}
// constants for binary math
const TWO_PWR_32_DBL = (1 << 16) * (1 << 16);
/**
 * Parse decimal string of 64 bit integer value as two JS numbers.
 *
 * Returns tuple:
 * [0]: minus sign?
 * [1]: low bits
 * [2]: high bits
 *
 * Copyright 2008 Google Inc.
 */
function int64fromString(dec) {
    // Check for minus sign.
    let minus = dec[0] == '-';
    if (minus)
        dec = dec.slice(1);
    // Work 6 decimal digits at a time, acting like we're converting base 1e6
    // digits to binary. This is safe to do with floating point math because
    // Number.isSafeInteger(ALL_32_BITS * 1e6) == true.
    const base = 1e6;
    let lowBits = 0;
    let highBits = 0;
    function add1e6digit(begin, end) {
        // Note: Number('') is 0.
        const digit1e6 = Number(dec.slice(begin, end));
        highBits *= base;
        lowBits = lowBits * base + digit1e6;
        // Carry bits from lowBits to highBits
        if (lowBits >= TWO_PWR_32_DBL) {
            highBits = highBits + ((lowBits / TWO_PWR_32_DBL) | 0);
            lowBits = lowBits % TWO_PWR_32_DBL;
        }
    }
    add1e6digit(-24, -18);
    add1e6digit(-18, -12);
    add1e6digit(-12, -6);
    add1e6digit(-6);
    return [minus, lowBits, highBits];
}
/**
 * Format 64 bit integer value (as two JS numbers) to decimal string.
 *
 * Copyright 2008 Google Inc.
 */
function int64toString(bitsLow, bitsHigh) {
    // Skip the expensive conversion if the number is small enough to use the
    // built-in conversions.
    if ((bitsHigh >>> 0) <= 0x1FFFFF) {
        return '' + (TWO_PWR_32_DBL * bitsHigh + (bitsLow >>> 0));
    }
    // What this code is doing is essentially converting the input number from
    // base-2 to base-1e7, which allows us to represent the 64-bit range with
    // only 3 (very large) digits. Those digits are then trivial to convert to
    // a base-10 string.
    // The magic numbers used here are -
    // 2^24 = 16777216 = (1,6777216) in base-1e7.
    // 2^48 = 281474976710656 = (2,8147497,6710656) in base-1e7.
    // Split 32:32 representation into 16:24:24 representation so our
    // intermediate digits don't overflow.
    let low = bitsLow & 0xFFFFFF;
    let mid = (((bitsLow >>> 24) | (bitsHigh << 8)) >>> 0) & 0xFFFFFF;
    let high = (bitsHigh >> 16) & 0xFFFF;
    // Assemble our three base-1e7 digits, ignoring carries. The maximum
    // value in a digit at this step is representable as a 48-bit integer, which
    // can be stored in a 64-bit floating point number.
    let digitA = low + (mid * 6777216) + (high * 6710656);
    let digitB = mid + (high * 8147497);
    let digitC = (high * 2);
    // Apply carries from A to B and from B to C.
    let base = 10000000;
    if (digitA >= base) {
        digitB += Math.floor(digitA / base);
        digitA %= base;
    }
    if (digitB >= base) {
        digitC += Math.floor(digitB / base);
        digitB %= base;
    }
    // Convert base-1e7 digits to base-10, with optional leading zeroes.
    function decimalFrom1e7(digit1e7, needLeadingZeros) {
        let partial = digit1e7 ? String(digit1e7) : '';
        if (needLeadingZeros) {
            return '0000000'.slice(partial.length) + partial;
        }
        return partial;
    }
    return decimalFrom1e7(digitC, /*needLeadingZeros=*/ 0) +
        decimalFrom1e7(digitB, /*needLeadingZeros=*/ digitC) +
        // If the final 1e7 digit didn't need leading zeros, we would have
        // returned via the trivial code path at the top.
        decimalFrom1e7(digitA, /*needLeadingZeros=*/ 1);
}
/**
 * Write a 32 bit varint, signed or unsigned. Same as `varint64write(0, value, bytes)`
 *
 * Copyright 2008 Google Inc.  All rights reserved.
 *
 * See https://github.com/protocolbuffers/protobuf/blob/1b18833f4f2a2f681f4e4a25cdf3b0a43115ec26/js/binary/encoder.js#L144
 */
function varint32write(value, bytes) {
    if (value >= 0) {
        // write value as varint 32
        while (value > 0x7f) {
            bytes.push((value & 0x7f) | 0x80);
            value = value >>> 7;
        }
        bytes.push(value);
    }
    else {
        for (let i = 0; i < 9; i++) {
            bytes.push(value & 127 | 128);
            value = value >> 7;
        }
        bytes.push(1);
    }
}
/**
 * Read an unsigned 32 bit varint.
 *
 * See https://github.com/protocolbuffers/protobuf/blob/8a71927d74a4ce34efe2d8769fda198f52d20d12/js/experimental/runtime/kernel/buffer_decoder.js#L220
 */
function varint32read() {
    let b = this.buf[this.pos++];
    let result = b & 0x7F;
    if ((b & 0x80) == 0) {
        this.assertBounds();
        return result;
    }
    b = this.buf[this.pos++];
    result |= (b & 0x7F) << 7;
    if ((b & 0x80) == 0) {
        this.assertBounds();
        return result;
    }
    b = this.buf[this.pos++];
    result |= (b & 0x7F) << 14;
    if ((b & 0x80) == 0) {
        this.assertBounds();
        return result;
    }
    b = this.buf[this.pos++];
    result |= (b & 0x7F) << 21;
    if ((b & 0x80) == 0) {
        this.assertBounds();
        return result;
    }
    // Extract only last 4 bits
    b = this.buf[this.pos++];
    result |= (b & 0x0F) << 28;
    for (let readBytes = 5; ((b & 0x80) !== 0) && readBytes < 10; readBytes++)
        b = this.buf[this.pos++];
    if ((b & 0x80) != 0)
        throw new Error('invalid varint');
    this.assertBounds();
    // Result can have 32 bits, convert it to unsigned
    return result >>> 0;
}

;// CONCATENATED MODULE: ./node_modules/@protobuf-ts/runtime/build/es2015/pb-long.js

let BI;
function detectBi() {
    const dv = new DataView(new ArrayBuffer(8));
    const ok = globalThis.BigInt !== undefined
        && typeof dv.getBigInt64 === "function"
        && typeof dv.getBigUint64 === "function"
        && typeof dv.setBigInt64 === "function"
        && typeof dv.setBigUint64 === "function";
    BI = ok ? {
        MIN: BigInt("-9223372036854775808"),
        MAX: BigInt("9223372036854775807"),
        UMIN: BigInt("0"),
        UMAX: BigInt("18446744073709551615"),
        C: BigInt,
        V: dv,
    } : undefined;
}
detectBi();
function assertBi(bi) {
    if (!bi)
        throw new Error("BigInt unavailable, see https://github.com/timostamm/protobuf-ts/blob/v1.0.8/MANUAL.md#bigint-support");
}
// used to validate from(string) input (when bigint is unavailable)
const RE_DECIMAL_STR = /^-?[0-9]+$/;
// constants for binary math
const pb_long_TWO_PWR_32_DBL = 0x100000000;
const HALF_2_PWR_32 = 0x080000000;
// base class for PbLong and PbULong provides shared code
class SharedPbLong {
    /**
     * Create a new instance with the given bits.
     */
    constructor(lo, hi) {
        this.lo = lo | 0;
        this.hi = hi | 0;
    }
    /**
     * Is this instance equal to 0?
     */
    isZero() {
        return this.lo == 0 && this.hi == 0;
    }
    /**
     * Convert to a native number.
     */
    toNumber() {
        let result = this.hi * pb_long_TWO_PWR_32_DBL + (this.lo >>> 0);
        if (!Number.isSafeInteger(result))
            throw new Error("cannot convert to safe number");
        return result;
    }
}
/**
 * 64-bit unsigned integer as two 32-bit values.
 * Converts between `string`, `number` and `bigint` representations.
 */
class PbULong extends SharedPbLong {
    /**
     * Create instance from a `string`, `number` or `bigint`.
     */
    static from(value) {
        if (BI)
            // noinspection FallThroughInSwitchStatementJS
            switch (typeof value) {
                case "string":
                    if (value == "0")
                        return this.ZERO;
                    if (value == "")
                        throw new Error('string is no integer');
                    value = BI.C(value);
                case "number":
                    if (value === 0)
                        return this.ZERO;
                    value = BI.C(value);
                case "bigint":
                    if (!value)
                        return this.ZERO;
                    if (value < BI.UMIN)
                        throw new Error('signed value for ulong');
                    if (value > BI.UMAX)
                        throw new Error('ulong too large');
                    BI.V.setBigUint64(0, value, true);
                    return new PbULong(BI.V.getInt32(0, true), BI.V.getInt32(4, true));
            }
        else
            switch (typeof value) {
                case "string":
                    if (value == "0")
                        return this.ZERO;
                    value = value.trim();
                    if (!RE_DECIMAL_STR.test(value))
                        throw new Error('string is no integer');
                    let [minus, lo, hi] = int64fromString(value);
                    if (minus)
                        throw new Error('signed value for ulong');
                    return new PbULong(lo, hi);
                case "number":
                    if (value == 0)
                        return this.ZERO;
                    if (!Number.isSafeInteger(value))
                        throw new Error('number is no integer');
                    if (value < 0)
                        throw new Error('signed value for ulong');
                    return new PbULong(value, value / pb_long_TWO_PWR_32_DBL);
            }
        throw new Error('unknown value ' + typeof value);
    }
    /**
     * Convert to decimal string.
     */
    toString() {
        return BI ? this.toBigInt().toString() : int64toString(this.lo, this.hi);
    }
    /**
     * Convert to native bigint.
     */
    toBigInt() {
        assertBi(BI);
        BI.V.setInt32(0, this.lo, true);
        BI.V.setInt32(4, this.hi, true);
        return BI.V.getBigUint64(0, true);
    }
}
/**
 * ulong 0 singleton.
 */
PbULong.ZERO = new PbULong(0, 0);
/**
 * 64-bit signed integer as two 32-bit values.
 * Converts between `string`, `number` and `bigint` representations.
 */
class PbLong extends SharedPbLong {
    /**
     * Create instance from a `string`, `number` or `bigint`.
     */
    static from(value) {
        if (BI)
            // noinspection FallThroughInSwitchStatementJS
            switch (typeof value) {
                case "string":
                    if (value == "0")
                        return this.ZERO;
                    if (value == "")
                        throw new Error('string is no integer');
                    value = BI.C(value);
                case "number":
                    if (value === 0)
                        return this.ZERO;
                    value = BI.C(value);
                case "bigint":
                    if (!value)
                        return this.ZERO;
                    if (value < BI.MIN)
                        throw new Error('signed long too small');
                    if (value > BI.MAX)
                        throw new Error('signed long too large');
                    BI.V.setBigInt64(0, value, true);
                    return new PbLong(BI.V.getInt32(0, true), BI.V.getInt32(4, true));
            }
        else
            switch (typeof value) {
                case "string":
                    if (value == "0")
                        return this.ZERO;
                    value = value.trim();
                    if (!RE_DECIMAL_STR.test(value))
                        throw new Error('string is no integer');
                    let [minus, lo, hi] = int64fromString(value);
                    if (minus) {
                        if (hi > HALF_2_PWR_32 || (hi == HALF_2_PWR_32 && lo != 0))
                            throw new Error('signed long too small');
                    }
                    else if (hi >= HALF_2_PWR_32)
                        throw new Error('signed long too large');
                    let pbl = new PbLong(lo, hi);
                    return minus ? pbl.negate() : pbl;
                case "number":
                    if (value == 0)
                        return this.ZERO;
                    if (!Number.isSafeInteger(value))
                        throw new Error('number is no integer');
                    return value > 0
                        ? new PbLong(value, value / pb_long_TWO_PWR_32_DBL)
                        : new PbLong(-value, -value / pb_long_TWO_PWR_32_DBL).negate();
            }
        throw new Error('unknown value ' + typeof value);
    }
    /**
     * Do we have a minus sign?
     */
    isNegative() {
        return (this.hi & HALF_2_PWR_32) !== 0;
    }
    /**
     * Negate two's complement.
     * Invert all the bits and add one to the result.
     */
    negate() {
        let hi = ~this.hi, lo = this.lo;
        if (lo)
            lo = ~lo + 1;
        else
            hi += 1;
        return new PbLong(lo, hi);
    }
    /**
     * Convert to decimal string.
     */
    toString() {
        if (BI)
            return this.toBigInt().toString();
        if (this.isNegative()) {
            let n = this.negate();
            return '-' + int64toString(n.lo, n.hi);
        }
        return int64toString(this.lo, this.hi);
    }
    /**
     * Convert to native bigint.
     */
    toBigInt() {
        assertBi(BI);
        BI.V.setInt32(0, this.lo, true);
        BI.V.setInt32(4, this.hi, true);
        return BI.V.getBigInt64(0, true);
    }
}
/**
 * long 0 singleton.
 */
PbLong.ZERO = new PbLong(0, 0);

;// CONCATENATED MODULE: ./node_modules/@protobuf-ts/runtime/build/es2015/assert.js
/**
 * assert that condition is true or throw error (with message)
 */
function assert(condition, msg) {
    if (!condition) {
        throw new Error(msg);
    }
}
/**
 * assert that value cannot exist = type `never`. throw runtime error if it does.
 */
function assertNever(value, msg) {
    throw new Error(msg !== null && msg !== void 0 ? msg : 'Unexpected object: ' + value);
}
const FLOAT32_MAX = 3.4028234663852886e+38, FLOAT32_MIN = -3.4028234663852886e+38, UINT32_MAX = 0xFFFFFFFF, INT32_MAX = 0X7FFFFFFF, INT32_MIN = -0X80000000;
function assertInt32(arg) {
    if (typeof arg !== "number")
        throw new Error('invalid int 32: ' + typeof arg);
    if (!Number.isInteger(arg) || arg > INT32_MAX || arg < INT32_MIN)
        throw new Error('invalid int 32: ' + arg);
}
function assertUInt32(arg) {
    if (typeof arg !== "number")
        throw new Error('invalid uint 32: ' + typeof arg);
    if (!Number.isInteger(arg) || arg > UINT32_MAX || arg < 0)
        throw new Error('invalid uint 32: ' + arg);
}
function assertFloat32(arg) {
    if (typeof arg !== "number")
        throw new Error('invalid float 32: ' + typeof arg);
    if (!Number.isFinite(arg))
        return;
    if (arg > FLOAT32_MAX || arg < FLOAT32_MIN)
        throw new Error('invalid float 32: ' + arg);
}

;// CONCATENATED MODULE: ./node_modules/@protobuf-ts/runtime/build/es2015/reflection-long-convert.js

/**
 * Utility method to convert a PbLong or PbUlong to a JavaScript
 * representation during runtime.
 *
 * Works with generated field information, `undefined` is equivalent
 * to `STRING`.
 */
function reflectionLongConvert(long, type) {
    switch (type) {
        case LongType.BIGINT:
            return long.toBigInt();
        case LongType.NUMBER:
            return long.toNumber();
        default:
            // case undefined:
            // case LongType.STRING:
            return long.toString();
    }
}

;// CONCATENATED MODULE: ./node_modules/@protobuf-ts/runtime/build/es2015/reflection-json-reader.js






/**
 * Reads proto3 messages in canonical JSON format using reflection information.
 *
 * https://developers.google.com/protocol-buffers/docs/proto3#json
 */
class ReflectionJsonReader {
    constructor(info) {
        this.info = info;
    }
    prepare() {
        var _a;
        if (this.fMap === undefined) {
            this.fMap = {};
            const fieldsInput = (_a = this.info.fields) !== null && _a !== void 0 ? _a : [];
            for (const field of fieldsInput) {
                this.fMap[field.name] = field;
                this.fMap[field.jsonName] = field;
                this.fMap[field.localName] = field;
            }
        }
    }
    // Cannot parse JSON <type of jsonValue> for <type name>#<fieldName>.
    assert(condition, fieldName, jsonValue) {
        if (!condition) {
            let what = typeofJsonValue(jsonValue);
            if (what == "number" || what == "boolean")
                what = jsonValue.toString();
            throw new Error(`Cannot parse JSON ${what} for ${this.info.typeName}#${fieldName}`);
        }
    }
    /**
     * Reads a message from canonical JSON format into the target message.
     *
     * Repeated fields are appended. Map entries are added, overwriting
     * existing keys.
     *
     * If a message field is already present, it will be merged with the
     * new data.
     */
    read(input, message, options) {
        this.prepare();
        const oneofsHandled = [];
        for (const [jsonKey, jsonValue] of Object.entries(input)) {
            const field = this.fMap[jsonKey];
            if (!field) {
                if (!options.ignoreUnknownFields)
                    throw new Error(`Found unknown field while reading ${this.info.typeName} from JSON format. JSON key: ${jsonKey}`);
                continue;
            }
            const localName = field.localName;
            // handle oneof ADT
            let target; // this will be the target for the field value, whether it is member of a oneof or not
            if (field.oneof) {
                if (jsonValue === null && (field.kind !== 'enum' || field.T()[0] !== 'google.protobuf.NullValue')) {
                    continue;
                }
                // since json objects are unordered by specification, it is not possible to take the last of multiple oneofs
                if (oneofsHandled.includes(field.oneof))
                    throw new Error(`Multiple members of the oneof group "${field.oneof}" of ${this.info.typeName} are present in JSON.`);
                oneofsHandled.push(field.oneof);
                target = message[field.oneof] = {
                    oneofKind: localName
                };
            }
            else {
                target = message;
            }
            // we have handled oneof above. we just have read the value into `target`.
            if (field.kind == 'map') {
                if (jsonValue === null) {
                    continue;
                }
                // check input
                this.assert(isJsonObject(jsonValue), field.name, jsonValue);
                // our target to put map entries into
                const fieldObj = target[localName];
                // read entries
                for (const [jsonObjKey, jsonObjValue] of Object.entries(jsonValue)) {
                    this.assert(jsonObjValue !== null, field.name + " map value", null);
                    // read value
                    let val;
                    switch (field.V.kind) {
                        case "message":
                            val = field.V.T().internalJsonRead(jsonObjValue, options);
                            break;
                        case "enum":
                            val = this.enum(field.V.T(), jsonObjValue, field.name, options.ignoreUnknownFields);
                            if (val === false)
                                continue;
                            break;
                        case "scalar":
                            val = this.scalar(jsonObjValue, field.V.T, field.V.L, field.name);
                            break;
                    }
                    this.assert(val !== undefined, field.name + " map value", jsonObjValue);
                    // read key
                    let key = jsonObjKey;
                    if (field.K == ScalarType.BOOL)
                        key = key == "true" ? true : key == "false" ? false : key;
                    key = this.scalar(key, field.K, LongType.STRING, field.name).toString();
                    fieldObj[key] = val;
                }
            }
            else if (field.repeat) {
                if (jsonValue === null)
                    continue;
                // check input
                this.assert(Array.isArray(jsonValue), field.name, jsonValue);
                // our target to put array entries into
                const fieldArr = target[localName];
                // read array entries
                for (const jsonItem of jsonValue) {
                    this.assert(jsonItem !== null, field.name, null);
                    let val;
                    switch (field.kind) {
                        case "message":
                            val = field.T().internalJsonRead(jsonItem, options);
                            break;
                        case "enum":
                            val = this.enum(field.T(), jsonItem, field.name, options.ignoreUnknownFields);
                            if (val === false)
                                continue;
                            break;
                        case "scalar":
                            val = this.scalar(jsonItem, field.T, field.L, field.name);
                            break;
                    }
                    this.assert(val !== undefined, field.name, jsonValue);
                    fieldArr.push(val);
                }
            }
            else {
                switch (field.kind) {
                    case "message":
                        if (jsonValue === null && field.T().typeName != 'google.protobuf.Value') {
                            this.assert(field.oneof === undefined, field.name + " (oneof member)", null);
                            continue;
                        }
                        target[localName] = field.T().internalJsonRead(jsonValue, options, target[localName]);
                        break;
                    case "enum":
                        let val = this.enum(field.T(), jsonValue, field.name, options.ignoreUnknownFields);
                        if (val === false)
                            continue;
                        target[localName] = val;
                        break;
                    case "scalar":
                        target[localName] = this.scalar(jsonValue, field.T, field.L, field.name);
                        break;
                }
            }
        }
    }
    /**
     * Returns `false` for unrecognized string representations.
     *
     * google.protobuf.NullValue accepts only JSON `null` (or the old `"NULL_VALUE"`).
     */
    enum(type, json, fieldName, ignoreUnknownFields) {
        if (type[0] == 'google.protobuf.NullValue')
            assert(json === null || json === "NULL_VALUE", `Unable to parse field ${this.info.typeName}#${fieldName}, enum ${type[0]} only accepts null.`);
        if (json === null)
            // we require 0 to be default value for all enums
            return 0;
        switch (typeof json) {
            case "number":
                assert(Number.isInteger(json), `Unable to parse field ${this.info.typeName}#${fieldName}, enum can only be integral number, got ${json}.`);
                return json;
            case "string":
                let localEnumName = json;
                if (type[2] && json.substring(0, type[2].length) === type[2])
                    // lookup without the shared prefix
                    localEnumName = json.substring(type[2].length);
                let enumNumber = type[1][localEnumName];
                if (typeof enumNumber === 'undefined' && ignoreUnknownFields) {
                    return false;
                }
                assert(typeof enumNumber == "number", `Unable to parse field ${this.info.typeName}#${fieldName}, enum ${type[0]} has no value for "${json}".`);
                return enumNumber;
        }
        assert(false, `Unable to parse field ${this.info.typeName}#${fieldName}, cannot parse enum value from ${typeof json}".`);
    }
    scalar(json, type, longType, fieldName) {
        let e;
        try {
            switch (type) {
                // float, double: JSON value will be a number or one of the special string values "NaN", "Infinity", and "-Infinity".
                // Either numbers or strings are accepted. Exponent notation is also accepted.
                case ScalarType.DOUBLE:
                case ScalarType.FLOAT:
                    if (json === null)
                        return .0;
                    if (json === "NaN")
                        return Number.NaN;
                    if (json === "Infinity")
                        return Number.POSITIVE_INFINITY;
                    if (json === "-Infinity")
                        return Number.NEGATIVE_INFINITY;
                    if (json === "") {
                        e = "empty string";
                        break;
                    }
                    if (typeof json == "string" && json.trim().length !== json.length) {
                        e = "extra whitespace";
                        break;
                    }
                    if (typeof json != "string" && typeof json != "number") {
                        break;
                    }
                    let float = Number(json);
                    if (Number.isNaN(float)) {
                        e = "not a number";
                        break;
                    }
                    if (!Number.isFinite(float)) {
                        // infinity and -infinity are handled by string representation above, so this is an error
                        e = "too large or small";
                        break;
                    }
                    if (type == ScalarType.FLOAT)
                        assertFloat32(float);
                    return float;
                // int32, fixed32, uint32: JSON value will be a decimal number. Either numbers or strings are accepted.
                case ScalarType.INT32:
                case ScalarType.FIXED32:
                case ScalarType.SFIXED32:
                case ScalarType.SINT32:
                case ScalarType.UINT32:
                    if (json === null)
                        return 0;
                    let int32;
                    if (typeof json == "number")
                        int32 = json;
                    else if (json === "")
                        e = "empty string";
                    else if (typeof json == "string") {
                        if (json.trim().length !== json.length)
                            e = "extra whitespace";
                        else
                            int32 = Number(json);
                    }
                    if (int32 === undefined)
                        break;
                    if (type == ScalarType.UINT32)
                        assertUInt32(int32);
                    else
                        assertInt32(int32);
                    return int32;
                // int64, fixed64, uint64: JSON value will be a decimal string. Either numbers or strings are accepted.
                case ScalarType.INT64:
                case ScalarType.SFIXED64:
                case ScalarType.SINT64:
                    if (json === null)
                        return reflectionLongConvert(PbLong.ZERO, longType);
                    if (typeof json != "number" && typeof json != "string")
                        break;
                    return reflectionLongConvert(PbLong.from(json), longType);
                case ScalarType.FIXED64:
                case ScalarType.UINT64:
                    if (json === null)
                        return reflectionLongConvert(PbULong.ZERO, longType);
                    if (typeof json != "number" && typeof json != "string")
                        break;
                    return reflectionLongConvert(PbULong.from(json), longType);
                // bool:
                case ScalarType.BOOL:
                    if (json === null)
                        return false;
                    if (typeof json !== "boolean")
                        break;
                    return json;
                // string:
                case ScalarType.STRING:
                    if (json === null)
                        return "";
                    if (typeof json !== "string") {
                        e = "extra whitespace";
                        break;
                    }
                    try {
                        encodeURIComponent(json);
                    }
                    catch (e) {
                        e = "invalid UTF8";
                        break;
                    }
                    return json;
                // bytes: JSON value will be the data encoded as a string using standard base64 encoding with paddings.
                // Either standard or URL-safe base64 encoding with/without paddings are accepted.
                case ScalarType.BYTES:
                    if (json === null || json === "")
                        return new Uint8Array(0);
                    if (typeof json !== 'string')
                        break;
                    return base64decode(json);
            }
        }
        catch (error) {
            e = error.message;
        }
        this.assert(false, fieldName + (e ? " - " + e : ""), json);
    }
}

;// CONCATENATED MODULE: ./node_modules/@protobuf-ts/runtime/build/es2015/reflection-json-writer.js




/**
 * Writes proto3 messages in canonical JSON format using reflection
 * information.
 *
 * https://developers.google.com/protocol-buffers/docs/proto3#json
 */
class ReflectionJsonWriter {
    constructor(info) {
        var _a;
        this.fields = (_a = info.fields) !== null && _a !== void 0 ? _a : [];
    }
    /**
     * Converts the message to a JSON object, based on the field descriptors.
     */
    write(message, options) {
        const json = {}, source = message;
        for (const field of this.fields) {
            // field is not part of a oneof, simply write as is
            if (!field.oneof) {
                let jsonValue = this.field(field, source[field.localName], options);
                if (jsonValue !== undefined)
                    json[options.useProtoFieldName ? field.name : field.jsonName] = jsonValue;
                continue;
            }
            // field is part of a oneof
            const group = source[field.oneof];
            if (group.oneofKind !== field.localName)
                continue; // not selected, skip
            const opt = field.kind == 'scalar' || field.kind == 'enum'
                ? Object.assign(Object.assign({}, options), { emitDefaultValues: true }) : options;
            let jsonValue = this.field(field, group[field.localName], opt);
            assert(jsonValue !== undefined);
            json[options.useProtoFieldName ? field.name : field.jsonName] = jsonValue;
        }
        return json;
    }
    field(field, value, options) {
        let jsonValue = undefined;
        if (field.kind == 'map') {
            assert(typeof value == "object" && value !== null);
            const jsonObj = {};
            switch (field.V.kind) {
                case "scalar":
                    for (const [entryKey, entryValue] of Object.entries(value)) {
                        const val = this.scalar(field.V.T, entryValue, field.name, false, true);
                        assert(val !== undefined);
                        jsonObj[entryKey.toString()] = val; // JSON standard allows only (double quoted) string as property key
                    }
                    break;
                case "message":
                    const messageType = field.V.T();
                    for (const [entryKey, entryValue] of Object.entries(value)) {
                        const val = this.message(messageType, entryValue, field.name, options);
                        assert(val !== undefined);
                        jsonObj[entryKey.toString()] = val; // JSON standard allows only (double quoted) string as property key
                    }
                    break;
                case "enum":
                    const enumInfo = field.V.T();
                    for (const [entryKey, entryValue] of Object.entries(value)) {
                        assert(entryValue === undefined || typeof entryValue == 'number');
                        const val = this.enum(enumInfo, entryValue, field.name, false, true, options.enumAsInteger);
                        assert(val !== undefined);
                        jsonObj[entryKey.toString()] = val; // JSON standard allows only (double quoted) string as property key
                    }
                    break;
            }
            if (options.emitDefaultValues || Object.keys(jsonObj).length > 0)
                jsonValue = jsonObj;
        }
        else if (field.repeat) {
            assert(Array.isArray(value));
            const jsonArr = [];
            switch (field.kind) {
                case "scalar":
                    for (let i = 0; i < value.length; i++) {
                        const val = this.scalar(field.T, value[i], field.name, field.opt, true);
                        assert(val !== undefined);
                        jsonArr.push(val);
                    }
                    break;
                case "enum":
                    const enumInfo = field.T();
                    for (let i = 0; i < value.length; i++) {
                        assert(value[i] === undefined || typeof value[i] == 'number');
                        const val = this.enum(enumInfo, value[i], field.name, field.opt, true, options.enumAsInteger);
                        assert(val !== undefined);
                        jsonArr.push(val);
                    }
                    break;
                case "message":
                    const messageType = field.T();
                    for (let i = 0; i < value.length; i++) {
                        const val = this.message(messageType, value[i], field.name, options);
                        assert(val !== undefined);
                        jsonArr.push(val);
                    }
                    break;
            }
            // add converted array to json output
            if (options.emitDefaultValues || jsonArr.length > 0 || options.emitDefaultValues)
                jsonValue = jsonArr;
        }
        else {
            switch (field.kind) {
                case "scalar":
                    jsonValue = this.scalar(field.T, value, field.name, field.opt, options.emitDefaultValues);
                    break;
                case "enum":
                    jsonValue = this.enum(field.T(), value, field.name, field.opt, options.emitDefaultValues, options.enumAsInteger);
                    break;
                case "message":
                    jsonValue = this.message(field.T(), value, field.name, options);
                    break;
            }
        }
        return jsonValue;
    }
    /**
     * Returns `null` as the default for google.protobuf.NullValue.
     */
    enum(type, value, fieldName, optional, emitDefaultValues, enumAsInteger) {
        if (type[0] == 'google.protobuf.NullValue')
            return !emitDefaultValues && !optional ? undefined : null;
        if (value === undefined) {
            assert(optional);
            return undefined;
        }
        if (value === 0 && !emitDefaultValues && !optional)
            // we require 0 to be default value for all enums
            return undefined;
        assert(typeof value == 'number');
        assert(Number.isInteger(value));
        if (enumAsInteger || !type[1].hasOwnProperty(value))
            // if we don't now the enum value, just return the number
            return value;
        if (type[2])
            // restore the dropped prefix
            return type[2] + type[1][value];
        return type[1][value];
    }
    message(type, value, fieldName, options) {
        if (value === undefined)
            return options.emitDefaultValues ? null : undefined;
        return type.internalJsonWrite(value, options);
    }
    scalar(type, value, fieldName, optional, emitDefaultValues) {
        if (value === undefined) {
            assert(optional);
            return undefined;
        }
        const ed = emitDefaultValues || optional;
        // noinspection FallThroughInSwitchStatementJS
        switch (type) {
            // int32, fixed32, uint32: JSON value will be a decimal number. Either numbers or strings are accepted.
            case ScalarType.INT32:
            case ScalarType.SFIXED32:
            case ScalarType.SINT32:
                if (value === 0)
                    return ed ? 0 : undefined;
                assertInt32(value);
                return value;
            case ScalarType.FIXED32:
            case ScalarType.UINT32:
                if (value === 0)
                    return ed ? 0 : undefined;
                assertUInt32(value);
                return value;
            // float, double: JSON value will be a number or one of the special string values "NaN", "Infinity", and "-Infinity".
            // Either numbers or strings are accepted. Exponent notation is also accepted.
            case ScalarType.FLOAT:
                assertFloat32(value);
            case ScalarType.DOUBLE:
                if (value === 0)
                    return ed ? 0 : undefined;
                assert(typeof value == 'number');
                if (Number.isNaN(value))
                    return 'NaN';
                if (value === Number.POSITIVE_INFINITY)
                    return 'Infinity';
                if (value === Number.NEGATIVE_INFINITY)
                    return '-Infinity';
                return value;
            // string:
            case ScalarType.STRING:
                if (value === "")
                    return ed ? '' : undefined;
                assert(typeof value == 'string');
                return value;
            // bool:
            case ScalarType.BOOL:
                if (value === false)
                    return ed ? false : undefined;
                assert(typeof value == 'boolean');
                return value;
            // JSON value will be a decimal string. Either numbers or strings are accepted.
            case ScalarType.UINT64:
            case ScalarType.FIXED64:
                assert(typeof value == 'number' || typeof value == 'string' || typeof value == 'bigint');
                let ulong = PbULong.from(value);
                if (ulong.isZero() && !ed)
                    return undefined;
                return ulong.toString();
            // JSON value will be a decimal string. Either numbers or strings are accepted.
            case ScalarType.INT64:
            case ScalarType.SFIXED64:
            case ScalarType.SINT64:
                assert(typeof value == 'number' || typeof value == 'string' || typeof value == 'bigint');
                let long = PbLong.from(value);
                if (long.isZero() && !ed)
                    return undefined;
                return long.toString();
            // bytes: JSON value will be the data encoded as a string using standard base64 encoding with paddings.
            // Either standard or URL-safe base64 encoding with/without paddings are accepted.
            case ScalarType.BYTES:
                assert(value instanceof Uint8Array);
                if (!value.byteLength)
                    return ed ? "" : undefined;
                return base64encode(value);
        }
    }
}

;// CONCATENATED MODULE: ./node_modules/@protobuf-ts/runtime/build/es2015/binary-format-contract.js
/**
 * This handler implements the default behaviour for unknown fields.
 * When reading data, unknown fields are stored on the message, in a
 * symbol property.
 * When writing data, the symbol property is queried and unknown fields
 * are serialized into the output again.
 */
var UnknownFieldHandler;
(function (UnknownFieldHandler) {
    /**
     * The symbol used to store unknown fields for a message.
     * The property must conform to `UnknownFieldContainer`.
     */
    UnknownFieldHandler.symbol = Symbol.for("protobuf-ts/unknown");
    /**
     * Store an unknown field during binary read directly on the message.
     * This method is compatible with `BinaryReadOptions.readUnknownField`.
     */
    UnknownFieldHandler.onRead = (typeName, message, fieldNo, wireType, data) => {
        let container = is(message) ? message[UnknownFieldHandler.symbol] : message[UnknownFieldHandler.symbol] = [];
        container.push({ no: fieldNo, wireType, data });
    };
    /**
     * Write unknown fields stored for the message to the writer.
     * This method is compatible with `BinaryWriteOptions.writeUnknownFields`.
     */
    UnknownFieldHandler.onWrite = (typeName, message, writer) => {
        for (let { no, wireType, data } of UnknownFieldHandler.list(message))
            writer.tag(no, wireType).raw(data);
    };
    /**
     * List unknown fields stored for the message.
     * Note that there may be multiples fields with the same number.
     */
    UnknownFieldHandler.list = (message, fieldNo) => {
        if (is(message)) {
            let all = message[UnknownFieldHandler.symbol];
            return fieldNo ? all.filter(uf => uf.no == fieldNo) : all;
        }
        return [];
    };
    /**
     * Returns the last unknown field by field number.
     */
    UnknownFieldHandler.last = (message, fieldNo) => UnknownFieldHandler.list(message, fieldNo).slice(-1)[0];
    const is = (message) => message && Array.isArray(message[UnknownFieldHandler.symbol]);
})(UnknownFieldHandler || (UnknownFieldHandler = {}));
/**
 * Merges binary write or read options. Later values override earlier values.
 */
function mergeBinaryOptions(a, b) {
    return Object.assign(Object.assign({}, a), b);
}
/**
 * Protobuf binary format wire types.
 *
 * A wire type provides just enough information to find the length of the
 * following value.
 *
 * See https://developers.google.com/protocol-buffers/docs/encoding#structure
 */
var WireType;
(function (WireType) {
    /**
     * Used for int32, int64, uint32, uint64, sint32, sint64, bool, enum
     */
    WireType[WireType["Varint"] = 0] = "Varint";
    /**
     * Used for fixed64, sfixed64, double.
     * Always 8 bytes with little-endian byte order.
     */
    WireType[WireType["Bit64"] = 1] = "Bit64";
    /**
     * Used for string, bytes, embedded messages, packed repeated fields
     *
     * Only repeated numeric types (types which use the varint, 32-bit,
     * or 64-bit wire types) can be packed. In proto3, such fields are
     * packed by default.
     */
    WireType[WireType["LengthDelimited"] = 2] = "LengthDelimited";
    /**
     * Used for groups
     * @deprecated
     */
    WireType[WireType["StartGroup"] = 3] = "StartGroup";
    /**
     * Used for groups
     * @deprecated
     */
    WireType[WireType["EndGroup"] = 4] = "EndGroup";
    /**
     * Used for fixed32, sfixed32, float.
     * Always 4 bytes with little-endian byte order.
     */
    WireType[WireType["Bit32"] = 5] = "Bit32";
})(WireType || (WireType = {}));

;// CONCATENATED MODULE: ./node_modules/@protobuf-ts/runtime/build/es2015/reflection-scalar-default.js



/**
 * Creates the default value for a scalar type.
 */
function reflectionScalarDefault(type, longType = LongType.STRING) {
    switch (type) {
        case ScalarType.BOOL:
            return false;
        case ScalarType.UINT64:
        case ScalarType.FIXED64:
            return reflectionLongConvert(PbULong.ZERO, longType);
        case ScalarType.INT64:
        case ScalarType.SFIXED64:
        case ScalarType.SINT64:
            return reflectionLongConvert(PbLong.ZERO, longType);
        case ScalarType.DOUBLE:
        case ScalarType.FLOAT:
            return 0.0;
        case ScalarType.BYTES:
            return new Uint8Array(0);
        case ScalarType.STRING:
            return "";
        default:
            // case ScalarType.INT32:
            // case ScalarType.UINT32:
            // case ScalarType.SINT32:
            // case ScalarType.FIXED32:
            // case ScalarType.SFIXED32:
            return 0;
    }
}

;// CONCATENATED MODULE: ./node_modules/@protobuf-ts/runtime/build/es2015/reflection-binary-reader.js




/**
 * Reads proto3 messages in binary format using reflection information.
 *
 * https://developers.google.com/protocol-buffers/docs/encoding
 */
class ReflectionBinaryReader {
    constructor(info) {
        this.info = info;
    }
    prepare() {
        var _a;
        if (!this.fieldNoToField) {
            const fieldsInput = (_a = this.info.fields) !== null && _a !== void 0 ? _a : [];
            this.fieldNoToField = new Map(fieldsInput.map(field => [field.no, field]));
        }
    }
    /**
     * Reads a message from binary format into the target message.
     *
     * Repeated fields are appended. Map entries are added, overwriting
     * existing keys.
     *
     * If a message field is already present, it will be merged with the
     * new data.
     */
    read(reader, message, options, length) {
        this.prepare();
        const end = length === undefined ? reader.len : reader.pos + length;
        while (reader.pos < end) {
            // read the tag and find the field
            const [fieldNo, wireType] = reader.tag(), field = this.fieldNoToField.get(fieldNo);
            if (!field) {
                let u = options.readUnknownField;
                if (u == "throw")
                    throw new Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.info.typeName}`);
                let d = reader.skip(wireType);
                if (u !== false)
                    (u === true ? UnknownFieldHandler.onRead : u)(this.info.typeName, message, fieldNo, wireType, d);
                continue;
            }
            // target object for the field we are reading
            let target = message, repeated = field.repeat, localName = field.localName;
            // if field is member of oneof ADT, use ADT as target
            if (field.oneof) {
                target = target[field.oneof];
                // if other oneof member selected, set new ADT
                if (target.oneofKind !== localName)
                    target = message[field.oneof] = {
                        oneofKind: localName
                    };
            }
            // we have handled oneof above, we just have read the value into `target[localName]`
            switch (field.kind) {
                case "scalar":
                case "enum":
                    let T = field.kind == "enum" ? ScalarType.INT32 : field.T;
                    let L = field.kind == "scalar" ? field.L : undefined;
                    if (repeated) {
                        let arr = target[localName]; // safe to assume presence of array, oneof cannot contain repeated values
                        if (wireType == WireType.LengthDelimited && T != ScalarType.STRING && T != ScalarType.BYTES) {
                            let e = reader.uint32() + reader.pos;
                            while (reader.pos < e)
                                arr.push(this.scalar(reader, T, L));
                        }
                        else
                            arr.push(this.scalar(reader, T, L));
                    }
                    else
                        target[localName] = this.scalar(reader, T, L);
                    break;
                case "message":
                    if (repeated) {
                        let arr = target[localName]; // safe to assume presence of array, oneof cannot contain repeated values
                        let msg = field.T().internalBinaryRead(reader, reader.uint32(), options);
                        arr.push(msg);
                    }
                    else
                        target[localName] = field.T().internalBinaryRead(reader, reader.uint32(), options, target[localName]);
                    break;
                case "map":
                    let [mapKey, mapVal] = this.mapEntry(field, reader, options);
                    // safe to assume presence of map object, oneof cannot contain repeated values
                    target[localName][mapKey] = mapVal;
                    break;
            }
        }
    }
    /**
     * Read a map field, expecting key field = 1, value field = 2
     */
    mapEntry(field, reader, options) {
        let length = reader.uint32();
        let end = reader.pos + length;
        let key = undefined; // javascript only allows number or string for object properties
        let val = undefined;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case 1:
                    if (field.K == ScalarType.BOOL)
                        key = reader.bool().toString();
                    else
                        // long types are read as string, number types are okay as number
                        key = this.scalar(reader, field.K, LongType.STRING);
                    break;
                case 2:
                    switch (field.V.kind) {
                        case "scalar":
                            val = this.scalar(reader, field.V.T, field.V.L);
                            break;
                        case "enum":
                            val = reader.int32();
                            break;
                        case "message":
                            val = field.V.T().internalBinaryRead(reader, reader.uint32(), options);
                            break;
                    }
                    break;
                default:
                    throw new Error(`Unknown field ${fieldNo} (wire type ${wireType}) in map entry for ${this.info.typeName}#${field.name}`);
            }
        }
        if (key === undefined) {
            let keyRaw = reflectionScalarDefault(field.K);
            key = field.K == ScalarType.BOOL ? keyRaw.toString() : keyRaw;
        }
        if (val === undefined)
            switch (field.V.kind) {
                case "scalar":
                    val = reflectionScalarDefault(field.V.T, field.V.L);
                    break;
                case "enum":
                    val = 0;
                    break;
                case "message":
                    val = field.V.T().create();
                    break;
            }
        return [key, val];
    }
    scalar(reader, type, longType) {
        switch (type) {
            case ScalarType.INT32:
                return reader.int32();
            case ScalarType.STRING:
                return reader.string();
            case ScalarType.BOOL:
                return reader.bool();
            case ScalarType.DOUBLE:
                return reader.double();
            case ScalarType.FLOAT:
                return reader.float();
            case ScalarType.INT64:
                return reflectionLongConvert(reader.int64(), longType);
            case ScalarType.UINT64:
                return reflectionLongConvert(reader.uint64(), longType);
            case ScalarType.FIXED64:
                return reflectionLongConvert(reader.fixed64(), longType);
            case ScalarType.FIXED32:
                return reader.fixed32();
            case ScalarType.BYTES:
                return reader.bytes();
            case ScalarType.UINT32:
                return reader.uint32();
            case ScalarType.SFIXED32:
                return reader.sfixed32();
            case ScalarType.SFIXED64:
                return reflectionLongConvert(reader.sfixed64(), longType);
            case ScalarType.SINT32:
                return reader.sint32();
            case ScalarType.SINT64:
                return reflectionLongConvert(reader.sint64(), longType);
        }
    }
}

;// CONCATENATED MODULE: ./node_modules/@protobuf-ts/runtime/build/es2015/reflection-binary-writer.js




/**
 * Writes proto3 messages in binary format using reflection information.
 *
 * https://developers.google.com/protocol-buffers/docs/encoding
 */
class ReflectionBinaryWriter {
    constructor(info) {
        this.info = info;
    }
    prepare() {
        if (!this.fields) {
            const fieldsInput = this.info.fields ? this.info.fields.concat() : [];
            this.fields = fieldsInput.sort((a, b) => a.no - b.no);
        }
    }
    /**
     * Writes the message to binary format.
     */
    write(message, writer, options) {
        this.prepare();
        for (const field of this.fields) {
            let value, // this will be our field value, whether it is member of a oneof or not
            emitDefault, // whether we emit the default value (only true for oneof members)
            repeated = field.repeat, localName = field.localName;
            // handle oneof ADT
            if (field.oneof) {
                const group = message[field.oneof];
                if (group.oneofKind !== localName)
                    continue; // if field is not selected, skip
                value = group[localName];
                emitDefault = true;
            }
            else {
                value = message[localName];
                emitDefault = false;
            }
            // we have handled oneof above. we just have to honor `emitDefault`.
            switch (field.kind) {
                case "scalar":
                case "enum":
                    let T = field.kind == "enum" ? ScalarType.INT32 : field.T;
                    if (repeated) {
                        assert(Array.isArray(value));
                        if (repeated == RepeatType.PACKED)
                            this.packed(writer, T, field.no, value);
                        else
                            for (const item of value)
                                this.scalar(writer, T, field.no, item, true);
                    }
                    else if (value === undefined)
                        assert(field.opt);
                    else
                        this.scalar(writer, T, field.no, value, emitDefault || field.opt);
                    break;
                case "message":
                    if (repeated) {
                        assert(Array.isArray(value));
                        for (const item of value)
                            this.message(writer, options, field.T(), field.no, item);
                    }
                    else {
                        this.message(writer, options, field.T(), field.no, value);
                    }
                    break;
                case "map":
                    assert(typeof value == 'object' && value !== null);
                    for (const [key, val] of Object.entries(value))
                        this.mapEntry(writer, options, field, key, val);
                    break;
            }
        }
        let u = options.writeUnknownFields;
        if (u !== false)
            (u === true ? UnknownFieldHandler.onWrite : u)(this.info.typeName, message, writer);
    }
    mapEntry(writer, options, field, key, value) {
        writer.tag(field.no, WireType.LengthDelimited);
        writer.fork();
        // javascript only allows number or string for object properties
        // we convert from our representation to the protobuf type
        let keyValue = key;
        switch (field.K) {
            case ScalarType.INT32:
            case ScalarType.FIXED32:
            case ScalarType.UINT32:
            case ScalarType.SFIXED32:
            case ScalarType.SINT32:
                keyValue = Number.parseInt(key);
                break;
            case ScalarType.BOOL:
                assert(key == 'true' || key == 'false');
                keyValue = key == 'true';
                break;
        }
        // write key, expecting key field number = 1
        this.scalar(writer, field.K, 1, keyValue, true);
        // write value, expecting value field number = 2
        switch (field.V.kind) {
            case 'scalar':
                this.scalar(writer, field.V.T, 2, value, true);
                break;
            case 'enum':
                this.scalar(writer, ScalarType.INT32, 2, value, true);
                break;
            case 'message':
                this.message(writer, options, field.V.T(), 2, value);
                break;
        }
        writer.join();
    }
    message(writer, options, handler, fieldNo, value) {
        if (value === undefined)
            return;
        handler.internalBinaryWrite(value, writer.tag(fieldNo, WireType.LengthDelimited).fork(), options);
        writer.join();
    }
    /**
     * Write a single scalar value.
     */
    scalar(writer, type, fieldNo, value, emitDefault) {
        let [wireType, method, isDefault] = this.scalarInfo(type, value);
        if (!isDefault || emitDefault) {
            writer.tag(fieldNo, wireType);
            writer[method](value);
        }
    }
    /**
     * Write an array of scalar values in packed format.
     */
    packed(writer, type, fieldNo, value) {
        if (!value.length)
            return;
        assert(type !== ScalarType.BYTES && type !== ScalarType.STRING);
        // write tag
        writer.tag(fieldNo, WireType.LengthDelimited);
        // begin length-delimited
        writer.fork();
        // write values without tags
        let [, method,] = this.scalarInfo(type);
        for (let i = 0; i < value.length; i++)
            writer[method](value[i]);
        // end length delimited
        writer.join();
    }
    /**
     * Get information for writing a scalar value.
     *
     * Returns tuple:
     * [0]: appropriate WireType
     * [1]: name of the appropriate method of IBinaryWriter
     * [2]: whether the given value is a default value
     *
     * If argument `value` is omitted, [2] is always false.
     */
    scalarInfo(type, value) {
        let t = WireType.Varint;
        let m;
        let i = value === undefined;
        let d = value === 0;
        switch (type) {
            case ScalarType.INT32:
                m = "int32";
                break;
            case ScalarType.STRING:
                d = i || !value.length;
                t = WireType.LengthDelimited;
                m = "string";
                break;
            case ScalarType.BOOL:
                d = value === false;
                m = "bool";
                break;
            case ScalarType.UINT32:
                m = "uint32";
                break;
            case ScalarType.DOUBLE:
                t = WireType.Bit64;
                m = "double";
                break;
            case ScalarType.FLOAT:
                t = WireType.Bit32;
                m = "float";
                break;
            case ScalarType.INT64:
                d = i || PbLong.from(value).isZero();
                m = "int64";
                break;
            case ScalarType.UINT64:
                d = i || PbULong.from(value).isZero();
                m = "uint64";
                break;
            case ScalarType.FIXED64:
                d = i || PbULong.from(value).isZero();
                t = WireType.Bit64;
                m = "fixed64";
                break;
            case ScalarType.BYTES:
                d = i || !value.byteLength;
                t = WireType.LengthDelimited;
                m = "bytes";
                break;
            case ScalarType.FIXED32:
                t = WireType.Bit32;
                m = "fixed32";
                break;
            case ScalarType.SFIXED32:
                t = WireType.Bit32;
                m = "sfixed32";
                break;
            case ScalarType.SFIXED64:
                d = i || PbLong.from(value).isZero();
                t = WireType.Bit64;
                m = "sfixed64";
                break;
            case ScalarType.SINT32:
                m = "sint32";
                break;
            case ScalarType.SINT64:
                d = i || PbLong.from(value).isZero();
                m = "sint64";
                break;
        }
        return [t, m, i || d];
    }
}

;// CONCATENATED MODULE: ./node_modules/@protobuf-ts/runtime/build/es2015/message-type-contract.js
/**
 * The symbol used as a key on message objects to store the message type.
 *
 * Note that this is an experimental feature - it is here to stay, but
 * implementation details may change without notice.
 */
const MESSAGE_TYPE = Symbol.for("protobuf-ts/message-type");

;// CONCATENATED MODULE: ./node_modules/@protobuf-ts/runtime/build/es2015/reflection-create.js


/**
 * Creates an instance of the generic message, using the field
 * information.
 */
function reflectionCreate(type) {
    const msg = {};
    Object.defineProperty(msg, MESSAGE_TYPE, { enumerable: false, value: type });
    for (let field of type.fields) {
        let name = field.localName;
        if (field.opt)
            continue;
        if (field.oneof)
            msg[field.oneof] = { oneofKind: undefined };
        else if (field.repeat)
            msg[name] = [];
        else
            switch (field.kind) {
                case "scalar":
                    msg[name] = reflectionScalarDefault(field.T, field.L);
                    break;
                case "enum":
                    // we require 0 to be default value for all enums
                    msg[name] = 0;
                    break;
                case "map":
                    msg[name] = {};
                    break;
            }
    }
    return msg;
}

;// CONCATENATED MODULE: ./node_modules/@protobuf-ts/runtime/build/es2015/reflection-merge-partial.js
/**
 * Copy partial data into the target message.
 *
 * If a singular scalar or enum field is present in the source, it
 * replaces the field in the target.
 *
 * If a singular message field is present in the source, it is merged
 * with the target field by calling mergePartial() of the responsible
 * message type.
 *
 * If a repeated field is present in the source, its values replace
 * all values in the target array, removing extraneous values.
 * Repeated message fields are copied, not merged.
 *
 * If a map field is present in the source, entries are added to the
 * target map, replacing entries with the same key. Entries that only
 * exist in the target remain. Entries with message values are copied,
 * not merged.
 *
 * Note that this function differs from protobuf merge semantics,
 * which appends repeated fields.
 */
function reflectionMergePartial(info, target, source) {
    let fieldValue, // the field value we are working with
    input = source, output; // where we want our field value to go
    for (let field of info.fields) {
        let name = field.localName;
        if (field.oneof) {
            const group = input[field.oneof]; // this is the oneof`s group in the source
            if ((group === null || group === void 0 ? void 0 : group.oneofKind) == undefined) { // the user is free to omit
                continue; // we skip this field, and all other members too
            }
            fieldValue = group[name]; // our value comes from the the oneof group of the source
            output = target[field.oneof]; // and our output is the oneof group of the target
            output.oneofKind = group.oneofKind; // always update discriminator
            if (fieldValue == undefined) {
                delete output[name]; // remove any existing value
                continue; // skip further work on field
            }
        }
        else {
            fieldValue = input[name]; // we are using the source directly
            output = target; // we want our field value to go directly into the target
            if (fieldValue == undefined) {
                continue; // skip further work on field, existing value is used as is
            }
        }
        if (field.repeat)
            output[name].length = fieldValue.length; // resize target array to match source array
        // now we just work with `fieldValue` and `output` to merge the value
        switch (field.kind) {
            case "scalar":
            case "enum":
                if (field.repeat)
                    for (let i = 0; i < fieldValue.length; i++)
                        output[name][i] = fieldValue[i]; // not a reference type
                else
                    output[name] = fieldValue; // not a reference type
                break;
            case "message":
                let T = field.T();
                if (field.repeat)
                    for (let i = 0; i < fieldValue.length; i++)
                        output[name][i] = T.create(fieldValue[i]);
                else if (output[name] === undefined)
                    output[name] = T.create(fieldValue); // nothing to merge with
                else
                    T.mergePartial(output[name], fieldValue);
                break;
            case "map":
                // Map and repeated fields are simply overwritten, not appended or merged
                switch (field.V.kind) {
                    case "scalar":
                    case "enum":
                        Object.assign(output[name], fieldValue); // elements are not reference types
                        break;
                    case "message":
                        let T = field.V.T();
                        for (let k of Object.keys(fieldValue))
                            output[name][k] = T.create(fieldValue[k]);
                        break;
                }
                break;
        }
    }
}

;// CONCATENATED MODULE: ./node_modules/@protobuf-ts/runtime/build/es2015/json-format-contract.js
const defaultsWrite = {
    emitDefaultValues: false,
    enumAsInteger: false,
    useProtoFieldName: false,
    prettySpaces: 0,
}, defaultsRead = {
    ignoreUnknownFields: false,
};
/**
 * Make options for reading JSON data from partial options.
 */
function jsonReadOptions(options) {
    return options ? Object.assign(Object.assign({}, defaultsRead), options) : defaultsRead;
}
/**
 * Make options for writing JSON data from partial options.
 */
function jsonWriteOptions(options) {
    return options ? Object.assign(Object.assign({}, defaultsWrite), options) : defaultsWrite;
}
/**
 * Merges JSON write or read options. Later values override earlier values. Type registries are merged.
 */
function mergeJsonOptions(a, b) {
    var _a, _b;
    let c = Object.assign(Object.assign({}, a), b);
    c.typeRegistry = [...((_a = a === null || a === void 0 ? void 0 : a.typeRegistry) !== null && _a !== void 0 ? _a : []), ...((_b = b === null || b === void 0 ? void 0 : b.typeRegistry) !== null && _b !== void 0 ? _b : [])];
    return c;
}

;// CONCATENATED MODULE: ./node_modules/@protobuf-ts/runtime/build/es2015/reflection-equals.js

/**
 * Determines whether two message of the same type have the same field values.
 * Checks for deep equality, traversing repeated fields, oneof groups, maps
 * and messages recursively.
 * Will also return true if both messages are `undefined`.
 */
function reflectionEquals(info, a, b) {
    if (a === b)
        return true;
    if (!a || !b)
        return false;
    for (let field of info.fields) {
        let localName = field.localName;
        let val_a = field.oneof ? a[field.oneof][localName] : a[localName];
        let val_b = field.oneof ? b[field.oneof][localName] : b[localName];
        switch (field.kind) {
            case "enum":
            case "scalar":
                let t = field.kind == "enum" ? ScalarType.INT32 : field.T;
                if (!(field.repeat
                    ? repeatedPrimitiveEq(t, val_a, val_b)
                    : primitiveEq(t, val_a, val_b)))
                    return false;
                break;
            case "map":
                if (!(field.V.kind == "message"
                    ? repeatedMsgEq(field.V.T(), objectValues(val_a), objectValues(val_b))
                    : repeatedPrimitiveEq(field.V.kind == "enum" ? ScalarType.INT32 : field.V.T, objectValues(val_a), objectValues(val_b))))
                    return false;
                break;
            case "message":
                let T = field.T();
                if (!(field.repeat
                    ? repeatedMsgEq(T, val_a, val_b)
                    : T.equals(val_a, val_b)))
                    return false;
                break;
        }
    }
    return true;
}
const objectValues = Object.values;
function primitiveEq(type, a, b) {
    if (a === b)
        return true;
    if (type !== ScalarType.BYTES)
        return false;
    let ba = a;
    let bb = b;
    if (ba.length !== bb.length)
        return false;
    for (let i = 0; i < ba.length; i++)
        if (ba[i] != bb[i])
            return false;
    return true;
}
function repeatedPrimitiveEq(type, a, b) {
    if (a.length !== b.length)
        return false;
    for (let i = 0; i < a.length; i++)
        if (!primitiveEq(type, a[i], b[i]))
            return false;
    return true;
}
function repeatedMsgEq(type, a, b) {
    if (a.length !== b.length)
        return false;
    for (let i = 0; i < a.length; i++)
        if (!type.equals(a[i], b[i]))
            return false;
    return true;
}

;// CONCATENATED MODULE: ./node_modules/@protobuf-ts/runtime/build/es2015/binary-writer.js



const binary_writer_defaultsWrite = {
    writeUnknownFields: true,
    writerFactory: () => new BinaryWriter(),
};
/**
 * Make options for writing binary data form partial options.
 */
function binaryWriteOptions(options) {
    return options ? Object.assign(Object.assign({}, binary_writer_defaultsWrite), options) : binary_writer_defaultsWrite;
}
class BinaryWriter {
    constructor(textEncoder) {
        /**
         * Previous fork states.
         */
        this.stack = [];
        this.textEncoder = textEncoder !== null && textEncoder !== void 0 ? textEncoder : new TextEncoder();
        this.chunks = [];
        this.buf = [];
    }
    /**
     * Return all bytes written and reset this writer.
     */
    finish() {
        this.chunks.push(new Uint8Array(this.buf)); // flush the buffer
        let len = 0;
        for (let i = 0; i < this.chunks.length; i++)
            len += this.chunks[i].length;
        let bytes = new Uint8Array(len);
        let offset = 0;
        for (let i = 0; i < this.chunks.length; i++) {
            bytes.set(this.chunks[i], offset);
            offset += this.chunks[i].length;
        }
        this.chunks = [];
        return bytes;
    }
    /**
     * Start a new fork for length-delimited data like a message
     * or a packed repeated field.
     *
     * Must be joined later with `join()`.
     */
    fork() {
        this.stack.push({ chunks: this.chunks, buf: this.buf });
        this.chunks = [];
        this.buf = [];
        return this;
    }
    /**
     * Join the last fork. Write its length and bytes, then
     * return to the previous state.
     */
    join() {
        // get chunk of fork
        let chunk = this.finish();
        // restore previous state
        let prev = this.stack.pop();
        if (!prev)
            throw new Error('invalid state, fork stack empty');
        this.chunks = prev.chunks;
        this.buf = prev.buf;
        // write length of chunk as varint
        this.uint32(chunk.byteLength);
        return this.raw(chunk);
    }
    /**
     * Writes a tag (field number and wire type).
     *
     * Equivalent to `uint32( (fieldNo << 3 | type) >>> 0 )`.
     *
     * Generated code should compute the tag ahead of time and call `uint32()`.
     */
    tag(fieldNo, type) {
        return this.uint32((fieldNo << 3 | type) >>> 0);
    }
    /**
     * Write a chunk of raw bytes.
     */
    raw(chunk) {
        if (this.buf.length) {
            this.chunks.push(new Uint8Array(this.buf));
            this.buf = [];
        }
        this.chunks.push(chunk);
        return this;
    }
    /**
     * Write a `uint32` value, an unsigned 32 bit varint.
     */
    uint32(value) {
        assertUInt32(value);
        // write value as varint 32, inlined for speed
        while (value > 0x7f) {
            this.buf.push((value & 0x7f) | 0x80);
            value = value >>> 7;
        }
        this.buf.push(value);
        return this;
    }
    /**
     * Write a `int32` value, a signed 32 bit varint.
     */
    int32(value) {
        assertInt32(value);
        varint32write(value, this.buf);
        return this;
    }
    /**
     * Write a `bool` value, a variant.
     */
    bool(value) {
        this.buf.push(value ? 1 : 0);
        return this;
    }
    /**
     * Write a `bytes` value, length-delimited arbitrary data.
     */
    bytes(value) {
        this.uint32(value.byteLength); // write length of chunk as varint
        return this.raw(value);
    }
    /**
     * Write a `string` value, length-delimited data converted to UTF-8 text.
     */
    string(value) {
        let chunk = this.textEncoder.encode(value);
        this.uint32(chunk.byteLength); // write length of chunk as varint
        return this.raw(chunk);
    }
    /**
     * Write a `float` value, 32-bit floating point number.
     */
    float(value) {
        assertFloat32(value);
        let chunk = new Uint8Array(4);
        new DataView(chunk.buffer).setFloat32(0, value, true);
        return this.raw(chunk);
    }
    /**
     * Write a `double` value, a 64-bit floating point number.
     */
    double(value) {
        let chunk = new Uint8Array(8);
        new DataView(chunk.buffer).setFloat64(0, value, true);
        return this.raw(chunk);
    }
    /**
     * Write a `fixed32` value, an unsigned, fixed-length 32-bit integer.
     */
    fixed32(value) {
        assertUInt32(value);
        let chunk = new Uint8Array(4);
        new DataView(chunk.buffer).setUint32(0, value, true);
        return this.raw(chunk);
    }
    /**
     * Write a `sfixed32` value, a signed, fixed-length 32-bit integer.
     */
    sfixed32(value) {
        assertInt32(value);
        let chunk = new Uint8Array(4);
        new DataView(chunk.buffer).setInt32(0, value, true);
        return this.raw(chunk);
    }
    /**
     * Write a `sint32` value, a signed, zigzag-encoded 32-bit varint.
     */
    sint32(value) {
        assertInt32(value);
        // zigzag encode
        value = ((value << 1) ^ (value >> 31)) >>> 0;
        varint32write(value, this.buf);
        return this;
    }
    /**
     * Write a `fixed64` value, a signed, fixed-length 64-bit integer.
     */
    sfixed64(value) {
        let chunk = new Uint8Array(8);
        let view = new DataView(chunk.buffer);
        let long = PbLong.from(value);
        view.setInt32(0, long.lo, true);
        view.setInt32(4, long.hi, true);
        return this.raw(chunk);
    }
    /**
     * Write a `fixed64` value, an unsigned, fixed-length 64 bit integer.
     */
    fixed64(value) {
        let chunk = new Uint8Array(8);
        let view = new DataView(chunk.buffer);
        let long = PbULong.from(value);
        view.setInt32(0, long.lo, true);
        view.setInt32(4, long.hi, true);
        return this.raw(chunk);
    }
    /**
     * Write a `int64` value, a signed 64-bit varint.
     */
    int64(value) {
        let long = PbLong.from(value);
        varint64write(long.lo, long.hi, this.buf);
        return this;
    }
    /**
     * Write a `sint64` value, a signed, zig-zag-encoded 64-bit varint.
     */
    sint64(value) {
        let long = PbLong.from(value), 
        // zigzag encode
        sign = long.hi >> 31, lo = (long.lo << 1) ^ sign, hi = ((long.hi << 1) | (long.lo >>> 31)) ^ sign;
        varint64write(lo, hi, this.buf);
        return this;
    }
    /**
     * Write a `uint64` value, an unsigned 64-bit varint.
     */
    uint64(value) {
        let long = PbULong.from(value);
        varint64write(long.lo, long.hi, this.buf);
        return this;
    }
}

;// CONCATENATED MODULE: ./node_modules/@protobuf-ts/runtime/build/es2015/binary-reader.js



const binary_reader_defaultsRead = {
    readUnknownField: true,
    readerFactory: bytes => new BinaryReader(bytes),
};
/**
 * Make options for reading binary data form partial options.
 */
function binaryReadOptions(options) {
    return options ? Object.assign(Object.assign({}, binary_reader_defaultsRead), options) : binary_reader_defaultsRead;
}
class BinaryReader {
    constructor(buf, textDecoder) {
        this.varint64 = varint64read; // dirty cast for `this`
        /**
         * Read a `uint32` field, an unsigned 32 bit varint.
         */
        this.uint32 = varint32read; // dirty cast for `this` and access to protected `buf`
        this.buf = buf;
        this.len = buf.length;
        this.pos = 0;
        this.view = new DataView(buf.buffer, buf.byteOffset, buf.byteLength);
        this.textDecoder = textDecoder !== null && textDecoder !== void 0 ? textDecoder : new TextDecoder("utf-8", {
            fatal: true,
            ignoreBOM: true,
        });
    }
    /**
     * Reads a tag - field number and wire type.
     */
    tag() {
        let tag = this.uint32(), fieldNo = tag >>> 3, wireType = tag & 7;
        if (fieldNo <= 0 || wireType < 0 || wireType > 5)
            throw new Error("illegal tag: field no " + fieldNo + " wire type " + wireType);
        return [fieldNo, wireType];
    }
    /**
     * Skip one element on the wire and return the skipped data.
     * Supports WireType.StartGroup since v2.0.0-alpha.23.
     */
    skip(wireType) {
        let start = this.pos;
        // noinspection FallThroughInSwitchStatementJS
        switch (wireType) {
            case WireType.Varint:
                while (this.buf[this.pos++] & 0x80) {
                    // ignore
                }
                break;
            case WireType.Bit64:
                this.pos += 4;
            case WireType.Bit32:
                this.pos += 4;
                break;
            case WireType.LengthDelimited:
                let len = this.uint32();
                this.pos += len;
                break;
            case WireType.StartGroup:
                // From descriptor.proto: Group type is deprecated, not supported in proto3.
                // But we must still be able to parse and treat as unknown.
                let t;
                while ((t = this.tag()[1]) !== WireType.EndGroup) {
                    this.skip(t);
                }
                break;
            default:
                throw new Error("cant skip wire type " + wireType);
        }
        this.assertBounds();
        return this.buf.subarray(start, this.pos);
    }
    /**
     * Throws error if position in byte array is out of range.
     */
    assertBounds() {
        if (this.pos > this.len)
            throw new RangeError("premature EOF");
    }
    /**
     * Read a `int32` field, a signed 32 bit varint.
     */
    int32() {
        return this.uint32() | 0;
    }
    /**
     * Read a `sint32` field, a signed, zigzag-encoded 32-bit varint.
     */
    sint32() {
        let zze = this.uint32();
        // decode zigzag
        return (zze >>> 1) ^ -(zze & 1);
    }
    /**
     * Read a `int64` field, a signed 64-bit varint.
     */
    int64() {
        return new PbLong(...this.varint64());
    }
    /**
     * Read a `uint64` field, an unsigned 64-bit varint.
     */
    uint64() {
        return new PbULong(...this.varint64());
    }
    /**
     * Read a `sint64` field, a signed, zig-zag-encoded 64-bit varint.
     */
    sint64() {
        let [lo, hi] = this.varint64();
        // decode zig zag
        let s = -(lo & 1);
        lo = ((lo >>> 1 | (hi & 1) << 31) ^ s);
        hi = (hi >>> 1 ^ s);
        return new PbLong(lo, hi);
    }
    /**
     * Read a `bool` field, a variant.
     */
    bool() {
        let [lo, hi] = this.varint64();
        return lo !== 0 || hi !== 0;
    }
    /**
     * Read a `fixed32` field, an unsigned, fixed-length 32-bit integer.
     */
    fixed32() {
        return this.view.getUint32((this.pos += 4) - 4, true);
    }
    /**
     * Read a `sfixed32` field, a signed, fixed-length 32-bit integer.
     */
    sfixed32() {
        return this.view.getInt32((this.pos += 4) - 4, true);
    }
    /**
     * Read a `fixed64` field, an unsigned, fixed-length 64 bit integer.
     */
    fixed64() {
        return new PbULong(this.sfixed32(), this.sfixed32());
    }
    /**
     * Read a `fixed64` field, a signed, fixed-length 64-bit integer.
     */
    sfixed64() {
        return new PbLong(this.sfixed32(), this.sfixed32());
    }
    /**
     * Read a `float` field, 32-bit floating point number.
     */
    float() {
        return this.view.getFloat32((this.pos += 4) - 4, true);
    }
    /**
     * Read a `double` field, a 64-bit floating point number.
     */
    double() {
        return this.view.getFloat64((this.pos += 8) - 8, true);
    }
    /**
     * Read a `bytes` field, length-delimited arbitrary data.
     */
    bytes() {
        let len = this.uint32();
        let start = this.pos;
        this.pos += len;
        this.assertBounds();
        return this.buf.subarray(start, start + len);
    }
    /**
     * Read a `string` field, length-delimited data converted to UTF-8 text.
     */
    string() {
        return this.textDecoder.decode(this.bytes());
    }
}

;// CONCATENATED MODULE: ./node_modules/@protobuf-ts/runtime/build/es2015/message-type.js













/**
 * This standard message type provides reflection-based
 * operations to work with a message.
 */
class MessageType {
    constructor(name, fields, options) {
        this.defaultCheckDepth = 16;
        this.typeName = name;
        this.fields = fields.map(normalizeFieldInfo);
        this.options = options !== null && options !== void 0 ? options : {};
        this.refTypeCheck = new ReflectionTypeCheck(this);
        this.refJsonReader = new ReflectionJsonReader(this);
        this.refJsonWriter = new ReflectionJsonWriter(this);
        this.refBinReader = new ReflectionBinaryReader(this);
        this.refBinWriter = new ReflectionBinaryWriter(this);
    }
    create(value) {
        let message = reflectionCreate(this);
        if (value !== undefined) {
            reflectionMergePartial(this, message, value);
        }
        return message;
    }
    /**
     * Clone the message.
     *
     * Unknown fields are discarded.
     */
    clone(message) {
        let copy = this.create();
        reflectionMergePartial(this, copy, message);
        return copy;
    }
    /**
     * Determines whether two message of the same type have the same field values.
     * Checks for deep equality, traversing repeated fields, oneof groups, maps
     * and messages recursively.
     * Will also return true if both messages are `undefined`.
     */
    equals(a, b) {
        return reflectionEquals(this, a, b);
    }
    /**
     * Is the given value assignable to our message type
     * and contains no [excess properties](https://www.typescriptlang.org/docs/handbook/interfaces.html#excess-property-checks)?
     */
    is(arg, depth = this.defaultCheckDepth) {
        return this.refTypeCheck.is(arg, depth, false);
    }
    /**
     * Is the given value assignable to our message type,
     * regardless of [excess properties](https://www.typescriptlang.org/docs/handbook/interfaces.html#excess-property-checks)?
     */
    isAssignable(arg, depth = this.defaultCheckDepth) {
        return this.refTypeCheck.is(arg, depth, true);
    }
    /**
     * Copy partial data into the target message.
     */
    mergePartial(target, source) {
        reflectionMergePartial(this, target, source);
    }
    /**
     * Create a new message from binary format.
     */
    fromBinary(data, options) {
        let opt = binaryReadOptions(options);
        return this.internalBinaryRead(opt.readerFactory(data), data.byteLength, opt);
    }
    /**
     * Read a new message from a JSON value.
     */
    fromJson(json, options) {
        return this.internalJsonRead(json, jsonReadOptions(options));
    }
    /**
     * Read a new message from a JSON string.
     * This is equivalent to `T.fromJson(JSON.parse(json))`.
     */
    fromJsonString(json, options) {
        let value = JSON.parse(json);
        return this.fromJson(value, options);
    }
    /**
     * Write the message to canonical JSON value.
     */
    toJson(message, options) {
        return this.internalJsonWrite(message, jsonWriteOptions(options));
    }
    /**
     * Convert the message to canonical JSON string.
     * This is equivalent to `JSON.stringify(T.toJson(t))`
     */
    toJsonString(message, options) {
        var _a;
        let value = this.toJson(message, options);
        return JSON.stringify(value, null, (_a = options === null || options === void 0 ? void 0 : options.prettySpaces) !== null && _a !== void 0 ? _a : 0);
    }
    /**
     * Write the message to binary format.
     */
    toBinary(message, options) {
        let opt = binaryWriteOptions(options);
        return this.internalBinaryWrite(message, opt.writerFactory(), opt).finish();
    }
    /**
     * This is an internal method. If you just want to read a message from
     * JSON, use `fromJson()` or `fromJsonString()`.
     *
     * Reads JSON value and merges the fields into the target
     * according to protobuf rules. If the target is omitted,
     * a new instance is created first.
     */
    internalJsonRead(json, options, target) {
        if (json !== null && typeof json == "object" && !Array.isArray(json)) {
            let message = target !== null && target !== void 0 ? target : this.create();
            this.refJsonReader.read(json, message, options);
            return message;
        }
        throw new Error(`Unable to parse message ${this.typeName} from JSON ${typeofJsonValue(json)}.`);
    }
    /**
     * This is an internal method. If you just want to write a message
     * to JSON, use `toJson()` or `toJsonString().
     *
     * Writes JSON value and returns it.
     */
    internalJsonWrite(message, options) {
        return this.refJsonWriter.write(message, options);
    }
    /**
     * This is an internal method. If you just want to write a message
     * in binary format, use `toBinary()`.
     *
     * Serializes the message in binary format and appends it to the given
     * writer. Returns passed writer.
     */
    internalBinaryWrite(message, writer, options) {
        this.refBinWriter.write(message, writer, options);
        return writer;
    }
    /**
     * This is an internal method. If you just want to read a message from
     * binary data, use `fromBinary()`.
     *
     * Reads data from binary format and merges the fields into
     * the target according to protobuf rules. If the target is
     * omitted, a new instance is created first.
     */
    internalBinaryRead(reader, length, options, target) {
        let message = target !== null && target !== void 0 ? target : this.create();
        this.refBinReader.read(reader, message, options, length);
        return message;
    }
}

;// CONCATENATED MODULE: ./src/generated/priceline/priceKey.ts
// @generated by protobuf-ts 2.9.1 with parameter long_type_string,optimize_code_size,force_server_none
// @generated from protobuf file "priceline/priceKey.proto" (syntax proto3)
// tslint:disable

// @generated message type with reflection information, may provide speed optimized methods
class ReferrerMessage$Type extends MessageType {
    constructor() {
        super("ReferrerMessage", [
            { no: 1, name: "referrer", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "referrer_unknown", kind: "message", T: () => ReferrerMessage_UnknownMessage }
        ]);
    }
}
/**
 * @generated MessageType for protobuf message ReferrerMessage
 */
const ReferrerMessage = new ReferrerMessage$Type();
// @generated message type with reflection information, may provide speed optimized methods
class ReferrerMessage_UnknownMessage$Type extends MessageType {
    constructor() {
        super("ReferrerMessage.UnknownMessage", [
            { no: 10, name: "always_seventy_six", kind: "scalar", T: 5 /*ScalarType.INT32*/ }
        ]);
    }
}
/**
 * @generated MessageType for protobuf message ReferrerMessage.UnknownMessage
 */
const ReferrerMessage_UnknownMessage = new ReferrerMessage_UnknownMessage$Type();
// @generated message type with reflection information, may provide speed optimized methods
class SearchMessage$Type extends MessageType {
    constructor() {
        super("SearchMessage", [
            { no: 1, name: "unknown_random", kind: "scalar", opt: true, T: 5 /*ScalarType.INT32*/ },
            { no: 2, name: "unknown_one", kind: "scalar", T: 5 /*ScalarType.INT32*/ },
            { no: 3, name: "price", kind: "scalar", T: 1 /*ScalarType.DOUBLE*/ },
            { no: 4, name: "itinerary", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => SearchMessage_ItineraryMessage },
            { no: 5, name: "fares", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => SearchMessage_FareMessage }
        ]);
    }
}
/**
 * @generated MessageType for protobuf message SearchMessage
 */
const SearchMessage = new SearchMessage$Type();
// @generated message type with reflection information, may provide speed optimized methods
class SearchMessage_ItineraryMessage$Type extends MessageType {
    constructor() {
        super("SearchMessage.ItineraryMessage", [
            { no: 1, name: "index", kind: "scalar", T: 5 /*ScalarType.INT32*/ },
            { no: 2, name: "segments", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => SearchMessage_ItineraryMessage_SegmentMessage }
        ]);
    }
}
/**
 * @generated MessageType for protobuf message SearchMessage.ItineraryMessage
 */
const SearchMessage_ItineraryMessage = new SearchMessage_ItineraryMessage$Type();
// @generated message type with reflection information, may provide speed optimized methods
class SearchMessage_ItineraryMessage_SegmentMessage$Type extends MessageType {
    constructor() {
        super("SearchMessage.ItineraryMessage.SegmentMessage", [
            { no: 1, name: "index", kind: "scalar", T: 5 /*ScalarType.INT32*/ },
            { no: 2, name: "departure", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 3, name: "arrival", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 4, name: "origin", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 5, name: "destination", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 6, name: "flight_number", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 7, name: "carrier", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 8, name: "booking_code", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 9, name: "cabin", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
}
/**
 * @generated MessageType for protobuf message SearchMessage.ItineraryMessage.SegmentMessage
 */
const SearchMessage_ItineraryMessage_SegmentMessage = new SearchMessage_ItineraryMessage_SegmentMessage$Type();
// @generated message type with reflection information, may provide speed optimized methods
class SearchMessage_FareMessage$Type extends MessageType {
    constructor() {
        super("SearchMessage.FareMessage", [
            { no: 1, name: "fare_type", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "segment_index", kind: "scalar", T: 5 /*ScalarType.INT32*/ },
            { no: 3, name: "fare_basis", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
}
/**
 * @generated MessageType for protobuf message SearchMessage.FareMessage
 */
const SearchMessage_FareMessage = new SearchMessage_FareMessage$Type();
// @generated message type with reflection information, may provide speed optimized methods
class PriceKeyMessage$Type extends MessageType {
    constructor() {
        super("PriceKeyMessage", [
            { no: 1, name: "signature", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "referrer", kind: "message", T: () => ReferrerMessage },
            { no: 3, name: "pax", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => PriceKeyMessage_PassengerMessage },
            { no: 4, name: "search", kind: "message", T: () => SearchMessage }
        ]);
    }
}
/**
 * @generated MessageType for protobuf message PriceKeyMessage
 */
const PriceKeyMessage = new PriceKeyMessage$Type();
// @generated message type with reflection information, may provide speed optimized methods
class PriceKeyMessage_PassengerMessage$Type extends MessageType {
    constructor() {
        super("PriceKeyMessage.PassengerMessage", [
            { no: 1, name: "value", kind: "scalar", T: 5 /*ScalarType.INT32*/ },
            { no: 2, name: "type", kind: "scalar", T: 5 /*ScalarType.INT32*/ }
        ]);
    }
}
/**
 * @generated MessageType for protobuf message PriceKeyMessage.PassengerMessage
 */
const PriceKeyMessage_PassengerMessage = new PriceKeyMessage_PassengerMessage$Type();

;// CONCATENATED MODULE: ./src/generated/priceline/signature.ts
// @generated by protobuf-ts 2.9.1 with parameter long_type_string,optimize_code_size,force_server_none
// @generated from protobuf file "priceline/signature.proto" (syntax proto3)
// tslint:disable

// @generated message type with reflection information, may provide speed optimized methods
class SignatureMessage$Type extends MessageType {
    constructor() {
        super("SignatureMessage", [
            { no: 1, name: "version", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "guid", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 3, name: "always_one", kind: "scalar", T: 5 /*ScalarType.INT32*/ },
            { no: 4, name: "type", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 5, name: "unknown", kind: "message", T: () => SignatureMessage_UnknownMessage },
            { no: 6, name: "server_name", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 7, name: "workflow_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
}
/**
 * @generated MessageType for protobuf message SignatureMessage
 */
const SignatureMessage = new SignatureMessage$Type();
// @generated message type with reflection information, may provide speed optimized methods
class SignatureMessage_UnknownMessage$Type extends MessageType {
    constructor() {
        super("SignatureMessage.UnknownMessage", [
            { no: 1, name: "unknown_plus_one", kind: "scalar", T: 5 /*ScalarType.INT32*/ },
            { no: 2, name: "unknown_one", kind: "scalar", T: 5 /*ScalarType.INT32*/ }
        ]);
    }
}
/**
 * @generated MessageType for protobuf message SignatureMessage.UnknownMessage
 */
const SignatureMessage_UnknownMessage = new SignatureMessage_UnknownMessage$Type();

// EXTERNAL MODULE: ./src/matrix5/settings/appSettings.ts
var appSettings = __webpack_require__("./src/matrix5/settings/appSettings.ts");
;// CONCATENATED MODULE: ./src/matrix5/links/otas/priceline.ts







var cabins = ["ECO", "PEC", "BUS", "FST"];
function printPriceline() {
    var _a;
    const pax = (0,links.validatePax)({
        maxPaxcount: 9,
        countInf: true,
        childAsAdult: 18,
        sepInfSeat: false,
        childMinAge: 2,
    });
    if (!pax) {
        (0,utils.printNotification)("Error: Failed to validate Passengers in printPriceline");
        return;
    }
    const unknownRandom = (0,utils.getRandomInt)(200);
    const signture = {
        version: "v1",
        guid: (0,utils.uuidv4)(),
        alwaysOne: 1,
        type: "CLASSIC",
        unknown: {
            unknownPlusOne: unknownRandom + 1,
            unknownOne: 1,
        },
        serverName: "guse4",
        workflowId: `WORKFLOW_ID_${(0,utils.uuidv4)()}`,
    };
    const passengers = [];
    if (pax.adults) {
        passengers.push({
            value: pax.adults,
            type: 1,
        });
    }
    if ((_a = pax.children) === null || _a === void 0 ? void 0 : _a.length) {
        passengers.push({
            value: pax.children.length,
            type: 2,
        });
    }
    const fares = [];
    let segmentIndex = 0;
    const priceKey = {
        signature: (0,utils.toUrlSafeBase64)((0,base64_js.fromByteArray)(SignatureMessage.toBinary(signture))),
        referrer: {
            referrer: "KAYAKSEARCH",
            referrerUnknown: {
                alwaysSeventySix: 76,
            },
        },
        pax: passengers,
        search: {
            unknownRandom,
            unknownOne: 1,
            price: itin.currentItin.price,
            itinerary: itin.currentItin.itin.map((itin, i) => ({
                index: i + 1,
                segments: itin.seg.map((seg, j) => {
                    segmentIndex++;
                    passengers.forEach((p) => {
                        fares.push({
                            fareType: p.type === 2 ? "CHD" : "ADT",
                            segmentIndex,
                            fareBasis: seg.farebase,
                        });
                    });
                    return {
                        index: segmentIndex,
                        departure: `${seg.dep.year}-${(0,utils.to2digits)(seg.dep.month)}-${(0,utils.to2digits)(seg.dep.day)}T${seg.dep.time24}`,
                        arrival: `${seg.arr.year}-${(0,utils.to2digits)(seg.arr.month)}-${(0,utils.to2digits)(seg.arr.day)}T${seg.arr.time24}`,
                        origin: seg.orig,
                        destination: seg.dest,
                        flightNumber: seg.fnr + "",
                        carrier: seg.farecarrier,
                        bookingCode: seg.bookingclass,
                        cabin: cabins[(0,appSettings.getCabin)(seg.cabin)],
                    };
                }),
            })),
            fares,
        },
    };
    const url = `https://www.priceline.com/m/fly/search/${itin.currentItin.itin
        .map((itin) => `${itin.orig}-${itin.dest}-${itin.dep.year}${(0,utils.to2digits)(itin.dep.month)}${(0,utils.to2digits)(itin.dep.day)}`)
        .join("/")}/details/?price-key=M-${(0,utils.toUrlSafeBase64)((0,base64_js.fromByteArray)(PriceKeyMessage.toBinary(priceKey)))}&item-key=META&refid=COUK100109861`;
    return {
        url,
        title: "Priceline",
    };
}
(0,links.register)("otas", printPriceline);


/***/ }),

/***/ "./src/matrix5/parse/itin.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   currentItin: () => (/* binding */ currentItin),
/* harmony export */   getCurrentSegs: () => (/* binding */ getCurrentSegs),
/* harmony export */   getTripType: () => (/* binding */ getTripType),
/* harmony export */   isMulticity: () => (/* binding */ isMulticity),
/* harmony export */   isOneway: () => (/* binding */ isOneway),
/* harmony export */   isRoundtrip: () => (/* binding */ isRoundtrip),
/* harmony export */   readItinerary: () => (/* binding */ readItinerary)
/* harmony export */ });
/* harmony import */ var _settings_itaSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/settings/itaSettings.ts");

const doNothing = new Promise(() => { });
// initialize local storage for current itin
let currentItin = {};
async function readItinerary() {
    Object.assign(currentItin, await readItinerary5());
    console.log("parsed itinerary: ", currentItin);
}
async function readItinerary5() {
    const bookingDetails = await getBookingDetails();
    return {
        itin: bookingDetails.itinerary.slices.map((itin) => {
            const fareMap = bookingDetails.tickets
                .flatMap((t) => t.pricings.flatMap((p) => p.fares))
                .reduce((acc, fare) => {
                fare.bookingInfos.forEach((bi) => {
                    acc[`${bi.segment.origin}${bi.segment.destination}${bi.bookingCode}`] = {
                        carrier: fare.carrier,
                        code: fare.code,
                    };
                });
                return acc;
            }, {});
            const segments = itin.segments.flatMap((seg) => seg.legs.map((leg) => {
                const fare = fareMap[`${seg.origin.code}${seg.destination.code}${seg.bookingInfos[0].bookingCode}`];
                return {
                    arr: isoToDateObj(leg.arrival),
                    dep: isoToDateObj(leg.departure),
                    orig: leg.origin.code,
                    dest: leg.destination.code,
                    carrier: seg.carrier.code,
                    fnr: seg.flight.number,
                    duration: seg.duration,
                    cabin: getCabin(seg.bookingInfos[0].cabin),
                    bookingclass: seg.bookingInfos[0].bookingCode,
                    farebase: fare.code,
                    farecarrier: fare.carrier,
                };
            }));
            return {
                arr: isoToDateObj(itin.arrival),
                dep: isoToDateObj(itin.departure),
                orig: itin.origin.code,
                dest: itin.destination.code,
                seg: segments,
            };
        }),
        price: +bookingDetails.displayTotal.substring(3),
        numPax: bookingDetails.passengerCount,
        carriers: [
            ...new Set(bookingDetails.itinerary.slices.flatMap((itin) => itin.segments.map((seg) => seg.carrier.code))),
        ],
        cur: bookingDetails.displayTotal.substring(0, 3),
        farebases: [
            ...new Set(bookingDetails.tickets.flatMap((t) => t.pricings.flatMap((p) => p.fares.code))),
        ],
        dist: bookingDetails.itinerary.distance.value,
    };
}
function getBookingDetails() {
    return new Promise((resolve, reject) => {
        (function _wait() {
            setTimeout(async () => {
                var _a, _b, _c;
                const copyAsJsonButton = document.querySelector(_settings_itaSettings__WEBPACK_IMPORTED_MODULE_0__["default"].resultpage.copyAsJsonButton);
                if (!copyAsJsonButton) {
                    return _wait();
                }
                const clipboard = (_b = (_a = window === null || window === void 0 ? void 0 : window.navigator) === null || _a === void 0 ? void 0 : _a.clipboard) !== null && _b !== void 0 ? _b : (_c = unsafeWindow === null || unsafeWindow === void 0 ? void 0 : unsafeWindow.navigator) === null || _c === void 0 ? void 0 : _c.clipboard;
                if (!clipboard) {
                    return reject("Could not access the clipboard");
                }
                const _writeText = clipboard.writeText;
                clipboard.writeText = (data) => {
                    clipboard.writeText = _writeText;
                    resolve(JSON.parse(data));
                    return doNothing;
                };
                copyAsJsonButton.click();
            }, 200);
        })();
    });
}
function isoToDateObj(isoDate) {
    const time24 = isoDate.substring(11, 16);
    let hour12 = +time24.substring(0, 2);
    if (hour12 > 12)
        hour12 -= 12;
    const time = hour12 + time24.substring(2, 5);
    return {
        day: +isoDate.substring(8, 10),
        month: +isoDate.substring(5, 7),
        year: +isoDate.substring(0, 4),
        time,
        time24,
    };
}
function getCabin(cabin) {
    switch (cabin) {
        case "PREMIUM-COACH":
            return 1;
        case "BUSINESS":
            return 2;
        case "FIRST":
            return 3;
        default:
            return 0;
    }
}
function getCurrentSegs() {
    return currentItin.itin
        .map(function (p) {
        return p.seg;
    })
        .reduce(function (a, b) {
        return a.concat(b);
    }, []);
}
function getTripType(ow, rt, mc) {
    return currentItin.itin.length > 1
        ? currentItin.itin.length === 2 &&
            currentItin.itin[0].orig === currentItin.itin[1].dest &&
            currentItin.itin[0].dest === currentItin.itin[1].orig
            ? rt
            : mc
        : ow;
}
function isOneway() {
    return getTripType(true, false, false);
}
function isRoundtrip() {
    return getTripType(false, true, false);
}
function isMulticity() {
    return getTripType(false, false, true);
}



/***/ }),

/***/ "./src/matrix5/print/links.tsx":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  printLinksContainer: () => (/* binding */ printLinksContainer),
  registerLink: () => (/* binding */ registerLink)
});

// UNUSED EXPORTS: getSidebarContainer, printImage

;// CONCATENATED MODULE: ./node_modules/dom-chef/index.js
var svgTagNames = [
	"a",
	"altGlyph",
	"altGlyphDef",
	"altGlyphItem",
	"animate",
	"animateColor",
	"animateMotion",
	"animateTransform",
	"animation",
	"audio",
	"canvas",
	"circle",
	"clipPath",
	"color-profile",
	"cursor",
	"defs",
	"desc",
	"discard",
	"ellipse",
	"feBlend",
	"feColorMatrix",
	"feComponentTransfer",
	"feComposite",
	"feConvolveMatrix",
	"feDiffuseLighting",
	"feDisplacementMap",
	"feDistantLight",
	"feDropShadow",
	"feFlood",
	"feFuncA",
	"feFuncB",
	"feFuncG",
	"feFuncR",
	"feGaussianBlur",
	"feImage",
	"feMerge",
	"feMergeNode",
	"feMorphology",
	"feOffset",
	"fePointLight",
	"feSpecularLighting",
	"feSpotLight",
	"feTile",
	"feTurbulence",
	"filter",
	"font",
	"font-face",
	"font-face-format",
	"font-face-name",
	"font-face-src",
	"font-face-uri",
	"foreignObject",
	"g",
	"glyph",
	"glyphRef",
	"handler",
	"hkern",
	"iframe",
	"image",
	"line",
	"linearGradient",
	"listener",
	"marker",
	"mask",
	"metadata",
	"missing-glyph",
	"mpath",
	"path",
	"pattern",
	"polygon",
	"polyline",
	"prefetch",
	"radialGradient",
	"rect",
	"script",
	"set",
	"solidColor",
	"stop",
	"style",
	"svg",
	"switch",
	"symbol",
	"tbreak",
	"text",
	"textArea",
	"textPath",
	"title",
	"tref",
	"tspan",
	"unknown",
	"use",
	"video",
	"view",
	"vkern"
];

const svgTags = new Set(svgTagNames);
svgTags.delete('a');
svgTags.delete('audio');
svgTags.delete('canvas');
svgTags.delete('iframe');
svgTags.delete('script');
svgTags.delete('video');
// Copied from Preact
const IS_NON_DIMENSIONAL = /acit|ex(?:s|g|n|p|$)|rph|ows|mnc|ntw|ine[ch]|zoo|^ord/i;
const isFragment = (type) => {
    return type === DocumentFragment;
};
const setCSSProps = (element, style) => {
    for (const [name, value] of Object.entries(style)) {
        if (name.startsWith('-')) {
            element.style.setProperty(name, value);
        }
        else if (typeof value === 'number' && !IS_NON_DIMENSIONAL.test(name)) {
            element.style[name] = `${value}px`;
        }
        else {
            element.style[name] = value;
        }
    }
};
const create = (type) => {
    if (typeof type === 'string') {
        if (svgTags.has(type)) {
            return document.createElementNS('http://www.w3.org/2000/svg', type);
        }
        return document.createElement(type);
    }
    if (isFragment(type)) {
        return document.createDocumentFragment();
    }
    return type(type.defaultProps);
};
const setAttribute = (element, name, value) => {
    if (value === undefined || value === null) {
        return;
    }
    // Naive support for xlink namespace
    // Full list: https://github.com/facebook/react/blob/1843f87/src/renderers/dom/shared/SVGDOMPropertyConfig.js#L258-L264
    if (/^xlink[AHRST]/.test(name)) {
        element.setAttributeNS('http://www.w3.org/1999/xlink', name.replace('xlink', 'xlink:').toLowerCase(), value);
    }
    else {
        element.setAttribute(name, value);
    }
};
const addChildren = (parent, children) => {
    for (const child of children) {
        if (child instanceof Node) {
            parent.appendChild(child);
        }
        else if (Array.isArray(child)) {
            addChildren(parent, child);
        }
        else if (typeof child !== 'boolean' &&
            typeof child !== 'undefined' &&
            child !== null) {
            parent.appendChild(document.createTextNode(child));
        }
    }
};
const h = (type, attributes, ...children) => {
    var _a;
    const element = create(type);
    addChildren(element, children);
    if (element instanceof DocumentFragment || !attributes) {
        return element;
    }
    // Set attributes
    for (let [name, value] of Object.entries(attributes)) {
        if (name === 'htmlFor') {
            name = 'for';
        }
        if (name === 'class' || name === 'className') {
            const existingClassname = (_a = element.getAttribute('class')) !== null && _a !== void 0 ? _a : '';
            setAttribute(element, 'class', (existingClassname + ' ' + String(value)).trim());
        }
        else if (name === 'style') {
            setCSSProps(element, value);
        }
        else if (name.startsWith('on')) {
            const eventName = name.slice(2).toLowerCase().replace(/^-/, '');
            element.addEventListener(eventName, value);
        }
        else if (name === 'dangerouslySetInnerHTML' && '__html' in value) {
            element.innerHTML = value.__html;
        }
        else if (name !== 'key' && value !== false) {
            setAttribute(element, name, value === true ? '' : value);
        }
    }
    return element;
};
// Improve TypeScript support for DocumentFragment
// https://github.com/Microsoft/TypeScript/issues/20469
const React = {
    createElement: h,
    Fragment: typeof DocumentFragment === 'function' ? DocumentFragment : () => { }
};

/* harmony default export */ const dom_chef = (React);


// EXTERNAL MODULE: ./src/matrix5/settings/userSettings.js
var userSettings = __webpack_require__("./src/matrix5/settings/userSettings.js");
// EXTERNAL MODULE: ./src/matrix5/settings/itaSettings.ts
var itaSettings = __webpack_require__("./src/matrix5/settings/itaSettings.ts");
// EXTERNAL MODULE: ./src/matrix5/utils.js
var utils = __webpack_require__("./src/matrix5/utils.js");
// EXTERNAL MODULE: ./src/unsafe-policy.ts
var unsafe_policy = __webpack_require__("./src/unsafe-policy.ts");
;// CONCATENATED MODULE: ./src/matrix5/print/links.tsx





const links = {};
__webpack_require__("./src/matrix5/links/index.ts");
/**
 * Registers a link
 */
function registerLink(type, factory) {
    if (!links[type])
        links[type] = [];
    links[type].push(factory);
}
function printLinksContainer() {
    // do nothing if editor mode is active
    if ((0,utils.findtargets)("editoritem").length > 0) {
        return;
    }
    // empty outputcontainer
    const div = getSidebarContainer();
    if (!div)
        return;
    div.innerHTML = (0,unsafe_policy.unsafeHTML)("");
    //  S&D powertool items
    const elems = (0,utils.findtargets)("powertoolsitem");
    for (let i = elems.length - 1; i >= 1; i--) {
        elems[i].parentElement.removeChild(elems[i]);
    }
    const groups = Object.keys(links);
    groups.forEach((group, i) => {
        const groupLinks = links[group]
            .map((link) => link())
            .sort((a, b) => {
            return a.title.localeCompare(b.title);
        });
        groupLinks.forEach((link) => {
            if (!link)
                return;
            if (link.img) {
                printImage(link);
            }
            else {
                printUrlInline(link);
            }
        });
        links[group].length && i != groups.length - 1 && printSeperator();
    });
}
// Inline Stuff
function printUrlInline(link) {
    const item = dom_chef.createElement("li", { class: "powertoolsitem" }, printLink(link));
    const container = getSidebarContainer();
    container && container.appendChild(item);
}
function printImage(link) {
    const container = getSidebarContainer();
    let item = (dom_chef.createElement("img", { src: link.img, style: { marginTop: "10px" }, class: !link.url ? "powertoolsitem" : "" }));
    if (link.url) {
        item = (dom_chef.createElement("a", { href: link.url, target: "_blank", class: "powertoolsitem" }, item));
    }
    if (userSettings["default"].enableIMGautoload == 1) {
        container && container.appendChild(item);
    }
    else {
        const id = Math.random().toString();
        container &&
            container.appendChild(dom_chef.createElement("div", { id: id, class: "powertoolsitem powertoolsimage", onClick: () => {
                    this.outerHTML = item;
                } },
                dom_chef.createElement("span", null, link.title)));
    }
}
function getSidebarContainer() {
    return (document.getElementById("powertoolslinkcontainer") ||
        createUrlContainerInline());
}
function createUrlContainerInline() {
    const target = (0,utils.findtarget)(itaSettings["default"].resultpage.mcDiv, 1);
    if (!target)
        return;
    const matCard = (dom_chef.createElement("mat-card", { class: "mat-mdc-card mdc-card mat-elevation-z8 powertoolslinkinlinecontainer" },
        dom_chef.createElement("mat-card-content", { class: "mat-mdc-card-content" },
            dom_chef.createElement("h2", { class: itaSettings["default"].resultpage.mcHeader }, "Powertools"),
            dom_chef.createElement("ul", { id: "powertoolslinkcontainer", style: { paddingLeft: "20px" } }))));
    target.prepend(matCard);
    return document.getElementById("powertoolslinkcontainer");
}
function printLink(link) {
    const extra = document.createElement("div");
    link.extra && extra.insertAdjacentHTML("beforeend", (0,unsafe_policy.unsafeHTML)(link.extra));
    return (dom_chef.createElement("div", null,
        dom_chef.createElement("label", { style: { fontSize: `${Number(userSettings["default"].linkFontsize)}%` } },
            dom_chef.createElement("a", { href: link.url, target: "_blank", onClick: (e) => {
                    var _a;
                    (_a = link.onclick) === null || _a === void 0 ? void 0 : _a.apply(this, e);
                    if (userSettings["default"].enableAffiliates !== 0) {
                        e.preventDefault();
                        window.open(`https://go.skimresources.com/?id=${!!location.hostname.match(/^old/i)
                            ? "122783X1686784"
                            : "122783X1611548"}&url=${encodeURIComponent(e.target.href)}&sref=${encodeURIComponent(window.location.href)}`, e.target.target);
                        return false;
                    }
                    return true;
                } },
                "Use ",
                link.title)),
        (extra === null || extra === void 0 ? void 0 : extra.childNodes) && Array.from(extra.childNodes),
        link.desc && (dom_chef.createElement(dom_chef.Fragment, null,
            dom_chef.createElement("br", null),
            dom_chef.createElement("label", { style: {
                    fontSize: `${Number(userSettings["default"].linkFontsize) - 15}%`,
                } }, link.desc)))));
}
function printSeperator() {
    const container = getSidebarContainer();
    container && container.appendChild(dom_chef.createElement("hr", { class: "powertoolsitem" }));
}


/***/ }),

/***/ "./src/matrix5/print/settings.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  createUsersettings: () => (/* binding */ createUsersettings)
});

// UNUSED EXPORTS: processPassengers

// EXTERNAL MODULE: ./src/matrix5/settings/appSettings.ts
var appSettings = __webpack_require__("./src/matrix5/settings/appSettings.ts");
// EXTERNAL MODULE: ./src/matrix5/settings/userSettings.js
var userSettings = __webpack_require__("./src/matrix5/settings/userSettings.js");
// EXTERNAL MODULE: ./src/matrix5/settings/paxSettings.js
var paxSettings = __webpack_require__("./src/matrix5/settings/paxSettings.js");
// EXTERNAL MODULE: ./src/matrix5/utils.js
var utils = __webpack_require__("./src/matrix5/utils.js");
// EXTERNAL MODULE: ./src/matrix5/print/links.tsx + 1 modules
var links = __webpack_require__("./src/matrix5/print/links.tsx");
;// CONCATENATED MODULE: ./src/matrix5/print/index.ts


async function render() {
    (0,links.printLinksContainer)();
}
function cleanUp() {
    // empty outputcontainer
    if (document.getElementById("powertoolslinkcontainer") != undefined) {
        var div = document.getElementById("powertoolslinkcontainer");
        div.innerHTML = "";
    }
    //  S&D powertool items
    var elems = findtargets("powertoolsitem");
    for (var i = elems.length - 1; i >= 0; i--) {
        elems[i].parentElement.removeChild(elems[i]);
    }
    // S&D price breakdown
    var pbd = findtarget("pricebreakdown", 1);
    if (pbd != undefined)
        pbd.parentElement.removeChild(pbd);
}

// EXTERNAL MODULE: ./src/unsafe-policy.ts
var unsafe_policy = __webpack_require__("./src/unsafe-policy.ts");
;// CONCATENATED MODULE: ./src/matrix5/print/settings.ts







/**************************************** Settings Stuff *****************************************/
function createUsersettings(target) {
    var str = "";
    var settingscontainer = document.createElement("div");
    settingscontainer.setAttribute("id", "mptSettingsContainer");
    settingscontainer.setAttribute("style", "border-bottom: 1px dashed grey;");
    settingscontainer.innerHTML = (0,unsafe_policy.unsafeHTML)('<div style="display:inline-block;float:left;cursor:pointer;" id="passengerVisToggler">Passengers (<label id="mtpPaxCount">1a</label>)</div><div id="mptStartparse" class="invis" style="margin-left:20px;display:none;cursor:pointer">Editor-Mode:Parse!</div><div id="mtpNotification" style="margin-left:50px;display:inline-block;"></div><div style="display:inline-block;float:right;"><div id="settingsVisToggler" style="display:inline-block;cursor:pointer;">Settings</div> (v' +
        appSettings["default"].version +
        ') <div id="mptCabintoggler" style="display:inline-block;">(Cabin: <span id="mptcabin"><label style="width:30px;text-align:center;cursor:pointer;display:inline-block">Auto</label></span>)</div></div><div id="mptSettings" class="invis" style="display:none;border-top: 1px dotted grey;"></div><div id="mptPassengers" class="invis" style="display:none;border-top: 1px dotted grey;"></div><div style="clear:both;"></div>');
    target.parentElement.insertBefore(settingscontainer, target);
    document.getElementById("settingsVisToggler").onclick = function () {
        (0,utils.toggleVis)(document.getElementById("mptSettings"));
    };
    document.getElementById("passengerVisToggler").onclick = function () {
        (0,utils.toggleVis)(document.getElementById("mptPassengers"));
    };
    // Build settings
    target = document.getElementById("mptSettings");
    str =
        '<div id="mptrestoredefault" style="text-align:right;font-weight:bold;text-decoration:underline;">Restore Defaults</div>';
    str +=
        '<div style="text-align:center;font-weight:bold">**** Display Settings: ****</div>';
    str += '<div style="margin:5px 0;"><div style="float:left;width:33%">';
    str += '</div><div style="float:left;width:33%">';
    str +=
        '<div id="mptenableIMGautoload">Images autoload: <label style="cursor:pointer;">' +
            printSettingsvalue("enableIMGautoload") +
            "</label></div>";
    str +=
        '<div id="mptshowAllAirlines">Show all airline links: <label style="cursor:pointer;">' +
            printSettingsvalue("showAllAirlines") +
            "</label></div>";
    str += '</div><div style="float:left;width:33%">';
    str +=
        '<div id="mptlinkFontsize">Link font size: <label style="cursor:pointer;">' +
            printSettingsvalue("linkFontsize") +
            "</label>%</div>";
    str += '</div><div style="float:left;width:33%">';
    str +=
        '<div id="mptenableAffiliates" title="Enables affiliate links to support the development of ITA Matrix Powertools">Support this tool: <label style="cursor:pointer;">' +
            printSettingsvalue("enableAffiliates") +
            "</label></div>";
    str += '</div><div style="clear:both"></div></div>';
    str +=
        '<div style="text-align:center;font-weight:bold">**** Link Settings: ****</div>';
    str +=
        '<div style="text-align:center;font-style:italic;">Disclosure: Some of these links are affiliate links</div>';
    str += '<div style="margin:5px 0">';
    Object.keys(userSettings.registeredSettings).forEach((setting) => {
        str += `<div id="mpt${setting}" style="width:33%;float:left;">${userSettings.registeredSettings[setting].name}: <label style="cursor:pointer;">${printSettingsvalue(setting)}</label></div>`;
    });
    str += '<div style="clear:both"></div></div>';
    str +=
        '<div style="text-align:center;font-weight:bold"><label id="configcloser" style="cursor:pointer;text-decoration:underline;">Close</label><div>';
    target.innerHTML = (0,unsafe_policy.unsafeHTML)(str);
    // these onClick event handlers need only be added once:
    document.getElementById("mptrestoredefault").onclick = function () {
        restoreDefaultSettings();
    };
    document.getElementById("mptenableIMGautoload").onclick = function () {
        toggleSettings("enableIMGautoload");
    };
    document.getElementById("mptlinkFontsize").onclick = function () {
        toggleSettings("linkFontsize");
    };
    document.getElementById("mptshowAllAirlines").onclick = function () {
        toggleSettings("showAllAirlines");
    };
    document.getElementById("mptenableAffiliates").onclick = function () {
        toggleSettings("enableAffiliates");
    };
    document.getElementById("mptCabintoggler").onclick = function () {
        toggleSettings("cabin");
    };
    document.getElementById("configcloser").onclick = function () {
        (0,utils.toggleVis)(document.getElementById("mptSettings"));
    };
    document.getElementById("mptStartparse").onclick = function () {
        setTimeout(async function () {
            await render();
        }, 50);
    };
    Object.keys(userSettings.registeredSettings).forEach((setting) => {
        document.getElementById("mpt" + setting).onclick = function () {
            toggleSettings(setting);
        };
    });
    // Build passengers
    target = document.getElementById("mptPassengers");
    str = '<div style="float:left;width:25%">';
    str +=
        '<div style="margin:2px 0"><label style="width:100px;display:inline-block">Adults: </label> <select name="numAdults" id="numAdults" style="width:50px">';
    for (var i = 1; i <= 9; i++) {
        str += "<option>" + i + "</option>";
    }
    str += "</select></div>";
    str +=
        '<div style="margin:2px 0"><label style="width:100px;display:inline-block">Infants (Lap): </label> <select name="numInfantsLap" id="numInfantsLap" style="width:50px">';
    for (var i = 0; i <= 9; i++) {
        str += "<option>" + i + "</option>";
    }
    str += "</select></div>";
    str +=
        '<div style="margin:2px 0"><label style="width:100px;display:inline-block">Infants (Seat): </label> <select name="numInfantsSeat" id="numInfantsSeat" style="width:50px">';
    for (var i = 0; i <= 9; i++) {
        str += "<option>" + i + "</option>";
    }
    str += "</select></div>";
    str += '</div><div style="float:left;width:25%">';
    for (var k = 1; k <= 3; k++) {
        str +=
            '<div style="margin:2px 0"><label style="width:100px;display:inline-block">Child ' +
                k +
                ' - Age: </label> <select name="child' +
                k +
                'age" id="child' +
                k +
                'age" style="width:50px">';
        str += '<option value="-1">-</option>';
        for (var i = 2; i <= 17; i++) {
            str += '<option value="' + i + '">' + i + "</option>";
        }
        str += "</select></div>";
    }
    str += '</div><div style="float:left;width:25%">';
    for (var k = 4; k <= 6; k++) {
        str +=
            '<div style="margin:2px 0"><label style="width:100px;display:inline-block">Child ' +
                k +
                ' - Age: </label> <select name="child' +
                k +
                'age" id="child' +
                k +
                'age" style="width:50px">';
        str += '<option value="-1">-</option>';
        for (var i = 2; i <= 17; i++) {
            str += '<option value="' + i + '">' + i + "</option>";
        }
        str += "</select></div>";
    }
    str += '</div><div style="float:left;width:25%">';
    for (var k = 7; k <= 8; k++) {
        str +=
            '<div style="margin:2px 0"><label style="width:100px;display:inline-block">Child ' +
                k +
                ' - Age: </label> <select name="child' +
                k +
                'age" id="child' +
                k +
                'age" style="width:50px">';
        str += '<option value="-1">-</option>';
        for (var i = 2; i <= 17; i++) {
            str += '<option value="' + i + '">' + i + "</option>";
        }
        str += "</select></div>";
    }
    str +=
        '<div style="width:150px;margin:2px 0"><div id="mtpConfirmPax" style="float:left;width:50%;text-align:center;cursor:pointer;font-weight:bold">Confirm</div><div id="mtpCancelPax" style="float:left;width:50%;text-align:center;cursor:pointer;font-weight:bold">Cancel</div></div>';
    str += '</div><div style="clear:both;"></div>';
    target.innerHTML = (0,unsafe_policy.unsafeHTML)(str);
    document.getElementById("mtpCancelPax").onclick = function () {
        (0,utils.toggleVis)(document.getElementById("mptPassengers"));
    };
    document.getElementById("mtpConfirmPax").onclick = function () {
        processPassengers();
        (0,utils.toggleVis)(document.getElementById("mptPassengers"));
        // reload links
        (0,links.printLinksContainer)();
    };
}
function restoreDefaultSettings() {
    // this function will remove any saved settings and restore default values
    if (window.confirm("Are you sure you want to reset any saved settings to the default values? The page will automatically reload to complete the reset.")) {
        (async () => {
            if (typeof GM === "undefined" || typeof GM.info != "undefined") {
                await (0,userSettings.saveUserSettings)(null);
            }
            // Reload the current page:
            window.location.reload();
        })(); // end async for GM4
    }
}
function toggleSettings(target) {
    console.log("toggleSettings called. target=" + target);
    if (userSettings.registeredSettings[target] && userSettings.registeredSettings[target].values) {
        const pos = findPositionForValue(userSettings["default"][target], userSettings.registeredSettings[target].values);
        if (pos >= userSettings.registeredSettings[target].values.length - 1 || pos === -1) {
            userSettings["default"][target] = userSettings.registeredSettings[target].values[0].value;
        }
        else {
            userSettings["default"][target] =
                userSettings.registeredSettings[target].values[pos + 1].value;
        }
    }
    else {
        switch (target) {
            case "linkFontsize":
                if (userSettings["default"].linkFontsize <= 190 &&
                    userSettings["default"].linkFontsize >= 50) {
                    userSettings["default"].linkFontsize += 10;
                }
                else {
                    userSettings["default"].linkFontsize = 50;
                }
                break;
            case "cabin":
                if (appSettings["default"].cabin === "Auto") {
                    appSettings["default"].cabin = "Y";
                }
                else if (appSettings["default"].cabin === "Y") {
                    appSettings["default"].cabin = "Y+";
                }
                else if (appSettings["default"].cabin === "Y+") {
                    appSettings["default"].cabin = "C";
                }
                else if (appSettings["default"].cabin === "C") {
                    appSettings["default"].cabin = "F";
                }
                else if (appSettings["default"].cabin === "F") {
                    appSettings["default"].cabin = "Auto";
                }
                // refresh links
                (0,links.printLinksContainer)();
                break;
            default:
                if (userSettings["default"][target] == 1) {
                    userSettings["default"][target] = 0;
                }
                else {
                    userSettings["default"][target] = 1;
                }
        }
    }
    document.getElementById("mpt" + target).firstElementChild.innerHTML =
        (0,unsafe_policy.unsafeHTML)(printSettingsvalue(target));
    (0,userSettings.saveUserSettings)();
}
function processPassengers() {
    let e = document.getElementById("numAdults");
    paxSettings["default"].adults = Number(e.options[e.selectedIndex].value);
    e = document.getElementById("numInfantsLap");
    paxSettings["default"].infantsLap = Number(e.options[e.selectedIndex].value);
    e = document.getElementById("numInfantsSeat");
    paxSettings["default"].infantsSeat = Number(e.options[e.selectedIndex].value);
    paxSettings["default"].cAges = new Array();
    for (let i = 1; i <= 8; i++) {
        processChild("child" + i + "age");
    }
    const paxText = paxSettings["default"].adults +
        "a" +
        (paxSettings["default"].cAges.length > 0
            ? " " + paxSettings["default"].cAges.length + "c"
            : "") +
        (paxSettings["default"].infantsLap + paxSettings["default"].infantsSeat > 0
            ? " " +
                (paxSettings["default"].infantsLap + paxSettings["default"].infantsSeat) +
                "i"
            : "");
    document.getElementById("mtpPaxCount").innerHTML = (0,unsafe_policy.unsafeHTML)(paxText);
}
function processChild(target) {
    const e = document.getElementById(target);
    const tmp = Number(e.options[e.selectedIndex].value);
    if (tmp >= 2) {
        paxSettings["default"].cAges.push(tmp);
    }
}
function printSettingsvalue(target) {
    if (userSettings.registeredSettings[target]) {
        return findNameForValue(userSettings["default"][target], userSettings.registeredSettings[target].values);
    }
    switch (target) {
        case "linkFontsize":
            return userSettings["default"].linkFontsize.toString();
        case "cabin":
            return appSettings["default"].cabin;
        default:
            return boolToEnabled(userSettings["default"][target]);
    }
}
function findNameForValue(needle, haystack) {
    var ret = "Unknown";
    for (var i in haystack) {
        if (haystack[i].value == needle) {
            return haystack[i].name;
        }
    }
    return ret;
}
function findPositionForValue(needle, haystack) {
    return haystack.findIndex((o) => o.value == needle);
}
function boolToEnabled(value) {
    if (value == 1) {
        return "enabled";
    }
    else {
        return "disabled";
    }
}


/***/ }),

/***/ "./src/matrix5/settings/appSettings.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   getCabin: () => (/* binding */ getCabin),
/* harmony export */   getForcedCabin: () => (/* binding */ getForcedCabin)
/* harmony export */ });
/* unused harmony exports reset, getCabinFromITA */
/* harmony import */ var _print_settings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/print/settings.ts");


// General settings
const appSettings = {
    isUserscript: !(typeof GM === "undefined" || typeof GM.info === "undefined"),
    itaLanguage: "en",
    version: "0.56.1",
    retrycount: 1,
    laststatus: "",
    scriptrunning: 1,
    cabin: "Auto",
};
function reset() {
    // reset Notification due to pagechange
    clearNotification();
    // reset Editor Mode
    document.getElementById("mptStartparse").setAttribute("class", "invis");
    document.getElementById("mptStartparse").style.display = "none";
    appSettings.itaLanguage = "en";
    appSettings.retrycount = 1;
    // reset pax and cabin
    const search = JSON.parse(window.localStorage["savedSearch.0"] || "{}");
    const x = search[3] || {};
    appSettings.cabin = getCabinFromITA(x[8]);
    document.getElementById("mptcabin").firstElementChild.innerHTML =
        appSettings.cabin;
    const itaPax = x[5] || {};
    const itaAdults = itaPax[1] || 1;
    const itaChildren = itaPax[2] || 0;
    const itaInfantLap = itaPax[3] || 0;
    const itaInfantSeat = itaPax[4] || 0;
    const itaSeniors = itaPax[5] || 0;
    const itaYouths = itaPax[6] || 0;
    let e = document.getElementById("numAdults");
    e.value = Math.min(9, itaAdults + itaSeniors + itaYouths).toString();
    e = document.getElementById("numInfantsLap");
    e.value = itaInfantLap;
    e = document.getElementById("numInfantsSeat");
    e.value = itaInfantSeat;
    const ages = [
        ...new Array(itaYouths).fill(17),
        ...new Array(itaChildren).fill(11),
    ];
    for (let i = 1; i <= 8; i++) {
        e = document.getElementById("child" + i + "age");
        e.value = ages[i - 1] || -1;
    }
    processPassengers();
}
function getCabinFromITA(itaCabin) {
    switch (itaCabin) {
        case "FIRST":
            return "F";
        case "BUSINESS":
            return "C";
        case "PREMIUM-COACH":
            return "Y+";
        default:
            return "Y";
    }
}
function getCabin(autoCabin) {
    return appSettings.cabin === "Auto" ? autoCabin : getForcedCabin();
}
function getForcedCabin() {
    switch (appSettings.cabin) {
        case "Y":
            return 0;
        case "Y+":
            return 1;
        case "C":
            return 2;
        case "F":
            return 3;
        default:
            return 0;
    }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (appSettings);


/***/ }),

/***/ "./src/matrix5/settings/itaSettings.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* unused harmony export findTargetSetVersion */

// ITA Matrix CSS class definitions:
const itaSettings = [
    {
        matrixVersion: 5,
        startpage: {
            maindiv: "mat-app-background",
        },
        resultpage: {
            mcDiv: "info-container",
            mcHeader: "info-title",
            copyAsJsonButton: "button.share-button:nth-child(4)",
        },
    },
];
const classSettings = itaSettings[0];
function findTargetSetVersion(classSelector, nth) {
    for (let setting of itaSettings) {
        const className = classSelector(setting);
        const target = findtarget(className, nth);
        if (target) {
            console.log(`ITA Version detected: ${className}`);
            Object.assign(classSettings, setting);
            return target;
        }
    }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (classSettings);


/***/ }),

/***/ "./src/unsafe-policy.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   unsafeHTML: () => (/* binding */ unsafeHTML),
/* harmony export */   unsafeScript: () => (/* binding */ unsafeScript)
/* harmony export */ });
/* unused harmony export unsafeScriptURL */
let unsafePolicy = null;
if (window.trustedTypes && window.trustedTypes.createPolicy) {
    unsafePolicy = window.trustedTypes.createPolicy("unsafePolicy", {
        createHTML: (string) => string,
        createScriptURL: (string) => string,
        createScript: (string) => string,
    });
}
const unsafeHTML = (string) => unsafePolicy ? unsafePolicy.createHTML(string) : string;
const unsafeScriptURL = (string) => unsafePolicy ? unsafePolicy.createScriptURL(string) : string;
const unsafeScript = (string) => unsafePolicy ? unsafePolicy.createScript(string) : string;


/***/ }),

/***/ "./src/matrix5/links/airlines/aa.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _settings_userSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/settings/userSettings.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/matrix5/utils.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/parse/itin.ts");





const aaEditions = [
  { value: "en_AU", name: "Australia" },
  { value: "en_BE", name: "Belgium" },
  { value: "en_CN", name: "China" },
  { value: "en_DK", name: "Denmark" },
  { value: "en_FI", name: "Finland" },
  { value: "en_FR", name: "France / English" },
  { value: "fr_FR", name: "France / French" },
  { value: "en_DE", name: "Germany / English" },
  { value: "de_DE", name: "Germany / Deutsch" },
  { value: "en_GR", name: "Greece" },
  { value: "en_HK", name: "Hong Kong" },
  { value: "en_IN", name: "India" },
  { value: "en_IE", name: "Ireland" },
  { value: "en_IL", name: "Israel" },
  { value: "en_IT", name: "Italy" },
  { value: "en_JP", name: "Japan" },
  { value: "en_KR", name: "Korea" },
  { value: "en_NL", name: "Netherlands" },
  { value: "en_NZ", name: "New Zealand" },
  { value: "en_NO", name: "Norway" },
  { value: "en_PT", name: "Portugal" },
  { value: "en_RU", name: "Russia" },
  { value: "en_ES", name: "Spain / English" },
  { value: "es_ES", name: "Spain / Spanish" },
  { value: "en_SE", name: "Sweden" },
  { value: "en_CH", name: "Switzerland" },
];

function printAA() {
  if (!(0,___WEBPACK_IMPORTED_MODULE_1__.anyCarriers)("AA")) {
    return;
  }

  var createUrl = function (edition) {
    var url =
      "http://i11l-services.aa.com/xaa/mseGateway/entryPoint.php?PARAM=";
    var search = "1,,USD0.00," + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin.length + ",";
    var legs = new Array();
    var leg = "";
    var segs = new Array();
    var seg = "";

    //Build multi-city search based on legs
    for (var i = 0; i < _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin.length; i++) {
      // walks each leg
      segs = new Array();
      for (var j = 0; j < _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg.length; j++) {
        //walks each segment of leg
        var k = 0;
        // lets have a look if we need to skip segments - Flightnumber has to be the same and it must be just a layover
        while (j + k < _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg.length - 1) {
          if (
            _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j + k].fnr !=
              _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j + k + 1].fnr ||
            _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j + k].layoverduration >= 1440
          )
            break;
          k++;
        }
        seg =
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j + k].arr.year +
          "-" +
          ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j + k].arr.month).slice(-2) +
          "-" +
          ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j + k].arr.day).slice(-2) +
          "T" +
          ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j + k].arr.time24).slice(-5) +
          (typeof _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j + k].arr.offset == "undefined"
            ? "+00:00"
            : _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j + k].arr.offset) +
          ",";
        seg += _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].bookingclass + ",";
        seg +=
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].dep.year +
          "-" +
          ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].dep.month).slice(-2) +
          "-" +
          ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].dep.day).slice(-2) +
          "T" +
          ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].dep.time24).slice(-5) +
          (typeof _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].dep.offset == "undefined"
            ? "+00:00"
            : _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].dep.offset) +
          ",";
        seg += _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j + k].dest + ",";
        seg +=
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].carrier +
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].fnr +
          ",";
        seg += _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].orig; // NO , here!
        segs.push(seg);
        j += k;
      }
      search += segs.length + "," + segs.join() + ",";
      //build leg structure
      leg =
        _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].dep.year +
        "-" +
        ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].dep.month).slice(-2) +
        "-" +
        ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].dep.day).slice(-2) +
        ",";
      leg += _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].dest + ",,";
      leg += _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].orig + ","; // USE , here!
      legs.push(leg);
    }
    search += "DIRECT,";
    search += edition[0].toUpperCase() + ","; // Language
    search += "3,";
    // validate Passengers here: Max Paxcount = 7 (Infs not included) - >11 = Adult - InfSeat = Child
    var pax = (0,___WEBPACK_IMPORTED_MODULE_1__.validatePax)({
      maxPaxcount: 7,
      countInf: false,
      childAsAdult: 12,
      sepInfSeat: false,
      childMinAge: 2,
    });
    if (!pax) {
      (0,_utils__WEBPACK_IMPORTED_MODULE_3__.printNotification)("Error: Failed to validate Passengers in printAA");
      return;
    }
    search += pax.adults + ","; // ADT
    search += pax.children.length + ","; // Child
    search += pax.infLap + ","; // Inf
    search += "0,"; // Senior
    search += edition[1].toUpperCase() + ","; // Country
    // push outer search
    search += _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin.length + "," + legs.join();
    url += encodeURIComponent(search);
    return url;
  };

  // get edition
  var edition = _settings_userSettings__WEBPACK_IMPORTED_MODULE_0__["default"].aaEdition.split("_");
  if (edition.length != 2) {
    (0,_utils__WEBPACK_IMPORTED_MODULE_3__.printNotification)("Error:Invalid AA-Edition");
    return;
  }
  var url = createUrl(edition);
  if (!url) {
    return;
  }
  var extra =
    ' <span class="pt-hover-container">[+]<span class="pt-hover-menu">';
  extra += aaEditions
    .map(function (obj, i) {
      return (
        '<a href="' +
        createUrl(obj.value.split("_")) +
        '" target="_blank">' +
        obj.name +
        "</a>"
      );
    })
    .join("<br/>");
  extra += "</span></span>";

  return {
    url,
    title: "American",
    desc: "Europe/Asia/Pacific",
    extra,
  };
}

(0,___WEBPACK_IMPORTED_MODULE_1__.register)("airlines", printAA);
(0,_settings_userSettings__WEBPACK_IMPORTED_MODULE_0__.registerSetting)(
  "American (Europe/Asia/Pacific)",
  "aaEdition",
  aaEditions,
  "en_DE",
);


/***/ }),

/***/ "./src/matrix5/links/airlines/aaSabre.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXTERNAL MODULE: ./src/matrix5/settings/userSettings.js
var userSettings = __webpack_require__("./src/matrix5/settings/userSettings.js");
// EXTERNAL MODULE: ./src/matrix5/utils.js
var utils = __webpack_require__("./src/matrix5/utils.js");
// EXTERNAL MODULE: ./src/matrix5/links/index.ts
var links = __webpack_require__("./src/matrix5/links/index.ts");
// EXTERNAL MODULE: ./src/matrix5/parse/itin.ts
var itin = __webpack_require__("./src/matrix5/parse/itin.ts");
// EXTERNAL MODULE: ./node_modules/date-fns/_lib/cloneObject/index.js
var cloneObject = __webpack_require__("./node_modules/date-fns/_lib/cloneObject/index.js");
// EXTERNAL MODULE: ./node_modules/date-fns/_lib/toInteger/index.js
var toInteger = __webpack_require__("./node_modules/date-fns/_lib/toInteger/index.js");
// EXTERNAL MODULE: ./node_modules/date-fns/_lib/getTimezoneOffsetInMilliseconds/index.js
var getTimezoneOffsetInMilliseconds = __webpack_require__("./node_modules/date-fns/_lib/getTimezoneOffsetInMilliseconds/index.js");
;// CONCATENATED MODULE: ./node_modules/date-fns-tz/esm/_lib/tzTokenizeDate/index.js
/**
 * Returns the [year, month, day, hour, minute, seconds] tokens of the provided
 * `date` as it will be rendered in the `timeZone`.
 */
function tzTokenizeDate(date, timeZone) {
  var dtf = getDateTimeFormat(timeZone)
  return dtf.formatToParts ? partsOffset(dtf, date) : hackyOffset(dtf, date)
}

var typeToPos = {
  year: 0,
  month: 1,
  day: 2,
  hour: 3,
  minute: 4,
  second: 5,
}

function partsOffset(dtf, date) {
  try {
    var formatted = dtf.formatToParts(date)
    var filled = []
    for (var i = 0; i < formatted.length; i++) {
      var pos = typeToPos[formatted[i].type]

      if (pos >= 0) {
        filled[pos] = parseInt(formatted[i].value, 10)
      }
    }
    return filled
  } catch (error) {
    if (error instanceof RangeError) {
      return [NaN]
    }
    throw error
  }
}

function hackyOffset(dtf, date) {
  var formatted = dtf.format(date).replace(/\u200E/g, '')
  var parsed = /(\d+)\/(\d+)\/(\d+),? (\d+):(\d+):(\d+)/.exec(formatted)
  // var [, fMonth, fDay, fYear, fHour, fMinute, fSecond] = parsed
  // return [fYear, fMonth, fDay, fHour, fMinute, fSecond]
  return [parsed[3], parsed[1], parsed[2], parsed[4], parsed[5], parsed[6]]
}

// Get a cached Intl.DateTimeFormat instance for the IANA `timeZone`. This can be used
// to get deterministic local date/time output according to the `en-US` locale which
// can be used to extract local time parts as necessary.
var dtfCache = {}
function getDateTimeFormat(timeZone) {
  if (!dtfCache[timeZone]) {
    // New browsers use `hourCycle`, IE and Chrome <73 does not support it and uses `hour12`
    var testDateFormatted = new Intl.DateTimeFormat('en-US', {
      hour12: false,
      timeZone: 'America/New_York',
      year: 'numeric',
      month: 'numeric',
      day: '2-digit',
      hour: '2-digit',
      minute: '2-digit',
      second: '2-digit',
    }).format(new Date('2014-06-25T04:00:00.123Z'))
    var hourCycleSupported =
      testDateFormatted === '06/25/2014, 00:00:00' ||
      testDateFormatted === '‎06‎/‎25‎/‎2014‎ ‎00‎:‎00‎:‎00'

    dtfCache[timeZone] = hourCycleSupported
      ? new Intl.DateTimeFormat('en-US', {
          hour12: false,
          timeZone: timeZone,
          year: 'numeric',
          month: 'numeric',
          day: '2-digit',
          hour: '2-digit',
          minute: '2-digit',
          second: '2-digit',
        })
      : new Intl.DateTimeFormat('en-US', {
          hourCycle: 'h23',
          timeZone: timeZone,
          year: 'numeric',
          month: 'numeric',
          day: '2-digit',
          hour: '2-digit',
          minute: '2-digit',
          second: '2-digit',
        })
  }
  return dtfCache[timeZone]
}

;// CONCATENATED MODULE: ./node_modules/date-fns-tz/esm/_lib/newDateUTC/index.js
/**
 * Use instead of `new Date(Date.UTC(...))` to support years below 100 which doesn't work
 * otherwise due to the nature of the
 * [`Date` constructor](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date#interpretation_of_two-digit_years.
 *
 * For `Date.UTC(...)`, use `newDateUTC(...).getTime()`.
 */
function newDateUTC(fullYear, month, day, hour, minute, second, millisecond) {
  var utcDate = new Date(0)
  utcDate.setUTCFullYear(fullYear, month, day)
  utcDate.setUTCHours(hour, minute, second, millisecond)
  return utcDate
}

;// CONCATENATED MODULE: ./node_modules/date-fns-tz/esm/_lib/tzParseTimezone/index.js



var MILLISECONDS_IN_HOUR = 3600000
var MILLISECONDS_IN_MINUTE = 60000

var patterns = {
  timezone: /([Z+-].*)$/,
  timezoneZ: /^(Z)$/,
  timezoneHH: /^([+-]\d{2})$/,
  timezoneHHMM: /^([+-]\d{2}):?(\d{2})$/,
}

// Parse various time zone offset formats to an offset in milliseconds
function tzParseTimezone(timezoneString, date, isUtcDate) {
  var token
  var absoluteOffset

  // Empty string
  if (!timezoneString) {
    return 0
  }

  // Z
  token = patterns.timezoneZ.exec(timezoneString)
  if (token) {
    return 0
  }

  var hours

  // ±hh
  token = patterns.timezoneHH.exec(timezoneString)
  if (token) {
    hours = parseInt(token[1], 10)

    if (!validateTimezone(hours)) {
      return NaN
    }

    return -(hours * MILLISECONDS_IN_HOUR)
  }

  // ±hh:mm or ±hhmm
  token = patterns.timezoneHHMM.exec(timezoneString)
  if (token) {
    hours = parseInt(token[1], 10)
    var minutes = parseInt(token[2], 10)

    if (!validateTimezone(hours, minutes)) {
      return NaN
    }

    absoluteOffset = Math.abs(hours) * MILLISECONDS_IN_HOUR + minutes * MILLISECONDS_IN_MINUTE
    return hours > 0 ? -absoluteOffset : absoluteOffset
  }

  // IANA time zone
  if (isValidTimezoneIANAString(timezoneString)) {
    date = new Date(date || Date.now())
    var utcDate = isUtcDate ? date : toUtcDate(date)

    var offset = calcOffset(utcDate, timezoneString)

    var fixedOffset = isUtcDate ? offset : fixOffset(date, offset, timezoneString)

    return -fixedOffset
  }

  return NaN
}

function toUtcDate(date) {
  return newDateUTC(
    date.getFullYear(),
    date.getMonth(),
    date.getDate(),
    date.getHours(),
    date.getMinutes(),
    date.getSeconds(),
    date.getMilliseconds()
  )
}

function calcOffset(date, timezoneString) {
  var tokens = tzTokenizeDate(date, timezoneString)

  // ms dropped because it's not provided by tzTokenizeDate
  var asUTC = newDateUTC(
    tokens[0],
    tokens[1] - 1,
    tokens[2],
    tokens[3] % 24,
    tokens[4],
    tokens[5],
    0
  ).getTime()

  var asTS = date.getTime()
  var over = asTS % 1000
  asTS -= over >= 0 ? over : 1000 + over
  return asUTC - asTS
}

function fixOffset(date, offset, timezoneString) {
  var localTS = date.getTime()

  // Our UTC time is just a guess because our offset is just a guess
  var utcGuess = localTS - offset

  // Test whether the zone matches the offset for this ts
  var o2 = calcOffset(new Date(utcGuess), timezoneString)

  // If so, offset didn't change, and we're done
  if (offset === o2) {
    return offset
  }

  // If not, change the ts by the difference in the offset
  utcGuess -= o2 - offset

  // If that gives us the local time we want, we're done
  var o3 = calcOffset(new Date(utcGuess), timezoneString)
  if (o2 === o3) {
    return o2
  }

  // If it's different, we're in a hole time. The offset has changed, but we don't adjust the time
  return Math.max(o2, o3)
}

function validateTimezone(hours, minutes) {
  return -23 <= hours && hours <= 23 && (minutes == null || (0 <= minutes && minutes <= 59))
}

var validIANATimezoneCache = {}
function isValidTimezoneIANAString(timeZoneString) {
  if (validIANATimezoneCache[timeZoneString]) return true
  try {
    new Intl.DateTimeFormat(undefined, { timeZone: timeZoneString })
    validIANATimezoneCache[timeZoneString] = true
    return true
  } catch (error) {
    return false
  }
}

;// CONCATENATED MODULE: ./node_modules/date-fns-tz/esm/_lib/tzPattern/index.js
/** Regex to identify the presence of a time zone specifier in a date string */
var tzPattern = /(Z|[+-]\d{2}(?::?\d{2})?| UTC| [a-zA-Z]+\/[a-zA-Z_]+(?:\/[a-zA-Z_]+)?)$/

/* harmony default export */ const _lib_tzPattern = (tzPattern);

;// CONCATENATED MODULE: ./node_modules/date-fns-tz/esm/toDate/index.js





var toDate_MILLISECONDS_IN_HOUR = 3600000
var toDate_MILLISECONDS_IN_MINUTE = 60000
var DEFAULT_ADDITIONAL_DIGITS = 2

var toDate_patterns = {
  dateTimePattern: /^([0-9W+-]+)(T| )(.*)/,
  datePattern: /^([0-9W+-]+)(.*)/,
  plainTime: /:/,

  // year tokens
  YY: /^(\d{2})$/,
  YYY: [
    /^([+-]\d{2})$/, // 0 additional digits
    /^([+-]\d{3})$/, // 1 additional digit
    /^([+-]\d{4})$/, // 2 additional digits
  ],
  YYYY: /^(\d{4})/,
  YYYYY: [
    /^([+-]\d{4})/, // 0 additional digits
    /^([+-]\d{5})/, // 1 additional digit
    /^([+-]\d{6})/, // 2 additional digits
  ],

  // date tokens
  MM: /^-(\d{2})$/,
  DDD: /^-?(\d{3})$/,
  MMDD: /^-?(\d{2})-?(\d{2})$/,
  Www: /^-?W(\d{2})$/,
  WwwD: /^-?W(\d{2})-?(\d{1})$/,

  HH: /^(\d{2}([.,]\d*)?)$/,
  HHMM: /^(\d{2}):?(\d{2}([.,]\d*)?)$/,
  HHMMSS: /^(\d{2}):?(\d{2}):?(\d{2}([.,]\d*)?)$/,

  // time zone tokens (to identify the presence of a tz)
  timeZone: _lib_tzPattern,
}

/**
 * @name toDate
 * @category Common Helpers
 * @summary Convert the given argument to an instance of Date.
 *
 * @description
 * Convert the given argument to an instance of Date.
 *
 * If the argument is an instance of Date, the function returns its clone.
 *
 * If the argument is a number, it is treated as a timestamp.
 *
 * If an argument is a string, the function tries to parse it.
 * Function accepts complete ISO 8601 formats as well as partial implementations.
 * ISO 8601: http://en.wikipedia.org/wiki/ISO_8601
 * If the function cannot parse the string or the values are invalid, it returns Invalid Date.
 *
 * If the argument is none of the above, the function returns Invalid Date.
 *
 * **Note**: *all* Date arguments passed to any *date-fns* function is processed by `toDate`.
 * All *date-fns* functions will throw `RangeError` if `options.additionalDigits` is not 0, 1, 2 or undefined.
 *
 * @param {Date|String|Number} argument - the value to convert
 * @param {OptionsWithTZ} [options] - the object with options. See [Options]{@link https://date-fns.org/docs/Options}
 * @param {0|1|2} [options.additionalDigits=2] - the additional number of digits in the extended year format
 * @param {String} [options.timeZone=''] - used to specify the IANA time zone offset of a date String.
 * @returns {Date} the parsed date in the local time zone
 * @throws {TypeError} 1 argument required
 * @throws {RangeError} `options.additionalDigits` must be 0, 1 or 2
 *
 * @example
 * // Convert string '2014-02-11T11:30:30' to date:
 * var result = toDate('2014-02-11T11:30:30')
 * //=> Tue Feb 11 2014 11:30:30
 *
 * @example
 * // Convert string '+02014101' to date,
 * // if the additional number of digits in the extended year format is 1:
 * var result = toDate('+02014101', {additionalDigits: 1})
 * //=> Fri Apr 11 2014 00:00:00
 */
function toDate(argument, dirtyOptions) {
  if (arguments.length < 1) {
    throw new TypeError('1 argument required, but only ' + arguments.length + ' present')
  }

  if (argument === null) {
    return new Date(NaN)
  }

  var options = dirtyOptions || {}

  var additionalDigits =
    options.additionalDigits == null
      ? DEFAULT_ADDITIONAL_DIGITS
      : toInteger(options.additionalDigits)
  if (additionalDigits !== 2 && additionalDigits !== 1 && additionalDigits !== 0) {
    throw new RangeError('additionalDigits must be 0, 1 or 2')
  }

  // Clone the date
  if (
    argument instanceof Date ||
    (typeof argument === 'object' && Object.prototype.toString.call(argument) === '[object Date]')
  ) {
    // Prevent the date to lose the milliseconds when passed to new Date() in IE10
    return new Date(argument.getTime())
  } else if (
    typeof argument === 'number' ||
    Object.prototype.toString.call(argument) === '[object Number]'
  ) {
    return new Date(argument)
  } else if (
    !(
      typeof argument === 'string' || Object.prototype.toString.call(argument) === '[object String]'
    )
  ) {
    return new Date(NaN)
  }

  var dateStrings = splitDateString(argument)

  var parseYearResult = parseYear(dateStrings.date, additionalDigits)
  var year = parseYearResult.year
  var restDateString = parseYearResult.restDateString

  var date = parseDate(restDateString, year)

  if (isNaN(date)) {
    return new Date(NaN)
  }

  if (date) {
    var timestamp = date.getTime()
    var time = 0
    var offset

    if (dateStrings.time) {
      time = parseTime(dateStrings.time)

      if (isNaN(time)) {
        return new Date(NaN)
      }
    }

    if (dateStrings.timeZone || options.timeZone) {
      offset = tzParseTimezone(dateStrings.timeZone || options.timeZone, new Date(timestamp + time))
      if (isNaN(offset)) {
        return new Date(NaN)
      }
    } else {
      // get offset accurate to hour in time zones that change offset
      offset = getTimezoneOffsetInMilliseconds(new Date(timestamp + time))
      offset = getTimezoneOffsetInMilliseconds(new Date(timestamp + time + offset))
    }

    return new Date(timestamp + time + offset)
  } else {
    return new Date(NaN)
  }
}

function splitDateString(dateString) {
  var dateStrings = {}
  var parts = toDate_patterns.dateTimePattern.exec(dateString)
  var timeString

  if (!parts) {
    parts = toDate_patterns.datePattern.exec(dateString)
    if (parts) {
      dateStrings.date = parts[1]
      timeString = parts[2]
    } else {
      dateStrings.date = null
      timeString = dateString
    }
  } else {
    dateStrings.date = parts[1]
    timeString = parts[3]
  }

  if (timeString) {
    var token = toDate_patterns.timeZone.exec(timeString)
    if (token) {
      dateStrings.time = timeString.replace(token[1], '')
      dateStrings.timeZone = token[1].trim()
    } else {
      dateStrings.time = timeString
    }
  }

  return dateStrings
}

function parseYear(dateString, additionalDigits) {
  var patternYYY = toDate_patterns.YYY[additionalDigits]
  var patternYYYYY = toDate_patterns.YYYYY[additionalDigits]

  var token

  // YYYY or ±YYYYY
  token = toDate_patterns.YYYY.exec(dateString) || patternYYYYY.exec(dateString)
  if (token) {
    var yearString = token[1]
    return {
      year: parseInt(yearString, 10),
      restDateString: dateString.slice(yearString.length),
    }
  }

  // YY or ±YYY
  token = toDate_patterns.YY.exec(dateString) || patternYYY.exec(dateString)
  if (token) {
    var centuryString = token[1]
    return {
      year: parseInt(centuryString, 10) * 100,
      restDateString: dateString.slice(centuryString.length),
    }
  }

  // Invalid ISO-formatted year
  return {
    year: null,
  }
}

function parseDate(dateString, year) {
  // Invalid ISO-formatted year
  if (year === null) {
    return null
  }

  var token
  var date
  var month
  var week

  // YYYY
  if (dateString.length === 0) {
    date = new Date(0)
    date.setUTCFullYear(year)
    return date
  }

  // YYYY-MM
  token = toDate_patterns.MM.exec(dateString)
  if (token) {
    date = new Date(0)
    month = parseInt(token[1], 10) - 1

    if (!validateDate(year, month)) {
      return new Date(NaN)
    }

    date.setUTCFullYear(year, month)
    return date
  }

  // YYYY-DDD or YYYYDDD
  token = toDate_patterns.DDD.exec(dateString)
  if (token) {
    date = new Date(0)
    var dayOfYear = parseInt(token[1], 10)

    if (!validateDayOfYearDate(year, dayOfYear)) {
      return new Date(NaN)
    }

    date.setUTCFullYear(year, 0, dayOfYear)
    return date
  }

  // yyyy-MM-dd or YYYYMMDD
  token = toDate_patterns.MMDD.exec(dateString)
  if (token) {
    date = new Date(0)
    month = parseInt(token[1], 10) - 1
    var day = parseInt(token[2], 10)

    if (!validateDate(year, month, day)) {
      return new Date(NaN)
    }

    date.setUTCFullYear(year, month, day)
    return date
  }

  // YYYY-Www or YYYYWww
  token = toDate_patterns.Www.exec(dateString)
  if (token) {
    week = parseInt(token[1], 10) - 1

    if (!validateWeekDate(year, week)) {
      return new Date(NaN)
    }

    return dayOfISOWeekYear(year, week)
  }

  // YYYY-Www-D or YYYYWwwD
  token = toDate_patterns.WwwD.exec(dateString)
  if (token) {
    week = parseInt(token[1], 10) - 1
    var dayOfWeek = parseInt(token[2], 10) - 1

    if (!validateWeekDate(year, week, dayOfWeek)) {
      return new Date(NaN)
    }

    return dayOfISOWeekYear(year, week, dayOfWeek)
  }

  // Invalid ISO-formatted date
  return null
}

function parseTime(timeString) {
  var token
  var hours
  var minutes

  // hh
  token = toDate_patterns.HH.exec(timeString)
  if (token) {
    hours = parseFloat(token[1].replace(',', '.'))

    if (!validateTime(hours)) {
      return NaN
    }

    return (hours % 24) * toDate_MILLISECONDS_IN_HOUR
  }

  // hh:mm or hhmm
  token = toDate_patterns.HHMM.exec(timeString)
  if (token) {
    hours = parseInt(token[1], 10)
    minutes = parseFloat(token[2].replace(',', '.'))

    if (!validateTime(hours, minutes)) {
      return NaN
    }

    return (hours % 24) * toDate_MILLISECONDS_IN_HOUR + minutes * toDate_MILLISECONDS_IN_MINUTE
  }

  // hh:mm:ss or hhmmss
  token = toDate_patterns.HHMMSS.exec(timeString)
  if (token) {
    hours = parseInt(token[1], 10)
    minutes = parseInt(token[2], 10)
    var seconds = parseFloat(token[3].replace(',', '.'))

    if (!validateTime(hours, minutes, seconds)) {
      return NaN
    }

    return (hours % 24) * toDate_MILLISECONDS_IN_HOUR + minutes * toDate_MILLISECONDS_IN_MINUTE + seconds * 1000
  }

  // Invalid ISO-formatted time
  return null
}

function dayOfISOWeekYear(isoWeekYear, week, day) {
  week = week || 0
  day = day || 0
  var date = new Date(0)
  date.setUTCFullYear(isoWeekYear, 0, 4)
  var fourthOfJanuaryDay = date.getUTCDay() || 7
  var diff = week * 7 + day + 1 - fourthOfJanuaryDay
  date.setUTCDate(date.getUTCDate() + diff)
  return date
}

// Validation functions

var DAYS_IN_MONTH = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31]
var DAYS_IN_MONTH_LEAP_YEAR = [31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31]

function isLeapYearIndex(year) {
  return year % 400 === 0 || (year % 4 === 0 && year % 100 !== 0)
}

function validateDate(year, month, date) {
  if (month < 0 || month > 11) {
    return false
  }

  if (date != null) {
    if (date < 1) {
      return false
    }

    var isLeapYear = isLeapYearIndex(year)
    if (isLeapYear && date > DAYS_IN_MONTH_LEAP_YEAR[month]) {
      return false
    }
    if (!isLeapYear && date > DAYS_IN_MONTH[month]) {
      return false
    }
  }

  return true
}

function validateDayOfYearDate(year, dayOfYear) {
  if (dayOfYear < 1) {
    return false
  }

  var isLeapYear = isLeapYearIndex(year)
  if (isLeapYear && dayOfYear > 366) {
    return false
  }
  if (!isLeapYear && dayOfYear > 365) {
    return false
  }

  return true
}

function validateWeekDate(year, week, day) {
  if (week < 0 || week > 52) {
    return false
  }

  if (day != null && (day < 0 || day > 6)) {
    return false
  }

  return true
}

function validateTime(hours, minutes, seconds) {
  if (hours != null && (hours < 0 || hours >= 25)) {
    return false
  }

  if (minutes != null && (minutes < 0 || minutes >= 60)) {
    return false
  }

  if (seconds != null && (seconds < 0 || seconds >= 60)) {
    return false
  }

  return true
}

;// CONCATENATED MODULE: ./node_modules/date-fns-tz/esm/zonedTimeToUtc/index.js






/**
 * @name zonedTimeToUtc
 * @category Time Zone Helpers
 * @summary Get the UTC date/time from a date representing local time in a given time zone
 *
 * @description
 * Returns a date instance with the UTC time of the provided date of which the values
 * represented the local time in the time zone specified. In other words, if the input
 * date represented local time in time time zone, the timestamp of the output date will
 * give the equivalent UTC of that local time regardless of the current system time zone.
 *
 * @param {Date|String|Number} date - the date with values representing the local time
 * @param {String} timeZone - the time zone of this local time, can be an offset or IANA time zone
 * @param {OptionsWithTZ} [options] - the object with options. See [Options]{@link https://date-fns.org/docs/Options}
 * @param {0|1|2} [options.additionalDigits=2] - passed to `toDate`. See [toDate]{@link https://date-fns.org/docs/toDate}
 * @returns {Date} the new date with the equivalent time in the time zone
 * @throws {TypeError} 2 arguments required
 * @throws {RangeError} `options.additionalDigits` must be 0, 1 or 2
 *
 * @example
 * // In June 10am in Los Angeles is 5pm UTC
 * const result = zonedTimeToUtc(new Date(2014, 5, 25, 10, 0, 0), 'America/Los_Angeles')
 * //=> 2014-06-25T17:00:00.000Z
 */
function zonedTimeToUtc(date, timeZone, options) {
  if (typeof date === 'string' && !date.match(_lib_tzPattern)) {
    var extendedOptions = cloneObject(options)
    extendedOptions.timeZone = timeZone
    return toDate(date, extendedOptions)
  }

  var d = toDate(date, options)

  var utc = newDateUTC(
    d.getFullYear(),
    d.getMonth(),
    d.getDate(),
    d.getHours(),
    d.getMinutes(),
    d.getSeconds(),
    d.getMilliseconds()
  ).getTime()

  var offsetMilliseconds = tzParseTimezone(timeZone, new Date(utc))

  return new Date(utc + offsetMilliseconds)
}

;// CONCATENATED MODULE: ./src/matrix5/json/timezones.json
const timezones_namespaceObject = JSON.parse('{"AAA":"Pacific/Tahiti","AAB":"Australia/Brisbane","AAC":"Africa/Cairo","AAD":"Africa/Mogadishu","AAE":"Africa/Algiers","AAF":"America/New_York","AAG":"America/Sao_Paulo","AAH":"Europe/Berlin","AAI":"America/Belem","AAJ":"America/Paramaribo","AAK":"Pacific/Tarawa","AAL":"Europe/Copenhagen","AAM":"Africa/Johannesburg","AAN":"Asia/Dubai","AAO":"America/Caracas","AAP":"Asia/Makassar","AAQ":"Europe/Moscow","AAR":"Europe/Copenhagen","AAS":"Asia/Jayapura","AAT":"Asia/Shanghai","AAU":"Pacific/Apia","AAV":"Asia/Manila","AAW":"Asia/Karachi","AAX":"America/Sao_Paulo","AAY":"Asia/Aden","ABA":"Asia/Krasnoyarsk","ABB":"Africa/Lagos","ABC":"Europe/Madrid","ABD":"Asia/Tehran","ABE":"America/New_York","ABF":"Pacific/Tarawa","ABG":"Australia/Brisbane","ABH":"Australia/Brisbane","ABI":"America/Chicago","ABJ":"Africa/Abidjan","ABK":"Africa/Addis_Ababa","ABL":"America/Anchorage","ABM":"Australia/Brisbane","ABN":"America/Paramaribo","ABO":"Africa/Abidjan","ABP":"Pacific/Port_Moresby","ABQ":"America/Denver","ABR":"America/Chicago","ABS":"Africa/Cairo","ABT":"Asia/Riyadh","ABU":"Asia/Makassar","ABV":"Africa/Lagos","ABW":"Pacific/Port_Moresby","ABX":"Australia/Sydney","ABY":"America/New_York","ABZ":"Europe/London","ACA":"America/Mexico_City","ACB":"America/New_York","ACC":"Africa/Accra","ACD":"America/Bogota","ACE":"Atlantic/Canary","ACH":"Europe/Zurich","ACI":"Europe/London","ACJ":"Asia/Colombo","ACK":"America/New_York","ACL":"America/Bogota","ACM":"America/Bogota","ACN":"America/Matamoros","ACO":"Europe/Zurich","ACP":"Asia/Tehran","ACR":"America/Bogota","ACS":"Asia/Krasnoyarsk","ACT":"America/Chicago","ACU":"America/Panama","ACV":"America/Los_Angeles","ACX":"Asia/Shanghai","ACY":"America/New_York","ACZ":"Asia/Tehran","ADA":"Europe/Istanbul","ADB":"Europe/Istanbul","ADC":"Pacific/Port_Moresby","ADD":"Africa/Addis_Ababa","ADE":"Asia/Aden","ADF":"Europe/Istanbul","ADG":"America/New_York","ADH":"Asia/Yakutsk","ADI":"Africa/Windhoek","ADJ":"Asia/Amman","ADK":"America/Adak","ADL":"Australia/Adelaide","ADM":"America/Chicago","ADN":"America/Bogota","ADO":"Australia/Adelaide","ADP":"Asia/Colombo","ADQ":"America/Anchorage","ADR":"America/New_York","ADS":"America/Chicago","ADT":"America/Chicago","ADU":"Asia/Tehran","ADV":"Africa/Khartoum","ADW":"America/New_York","ADX":"Europe/London","ADY":"Africa/Johannesburg","ADZ":"America/Bogota","AEA":"Pacific/Tarawa","AEB":"Asia/Shanghai","AED":"America/Anchorage","AEE":"Africa/Juba","AEG":"Asia/Jakarta","AEH":"Africa/Ndjamena","AEI":"Europe/Madrid","AEK":"Pacific/Port_Moresby","AEL":"America/Chicago","AEM":"Asia/Vladivostok","AEO":"Africa/Nouakchott","AEP":"America/Argentina/Buenos_Aires","AEQ":"Asia/Shanghai","AER":"Europe/Moscow","AES":"Europe/Oslo","AET":"America/Anchorage","AEU":"Asia/Tehran","AEX":"America/Chicago","AEY":"Atlantic/Reykjavik","AFA":"America/Argentina/Buenos_Aires","AFD":"Africa/Johannesburg","AFF":"America/Denver","AFI":"America/Bogota","AFL":"America/Campo_Grande","AFN":"America/New_York","AFO":"America/Denver","AFR":"Pacific/Port_Moresby","AFS":"Asia/Tashkent","AFT":"Pacific/Guadalcanal","AFW":"America/Chicago","AFY":"Europe/Istanbul","AFZ":"Asia/Tehran","AGA":"Africa/Casablanca","AGB":"Europe/Berlin","AGC":"America/New_York","AGD":"Asia/Jayapura","AGE":"Europe/Berlin","AGF":"Europe/Paris","AGG":"Pacific/Port_Moresby","AGH":"Europe/Stockholm","AGI":"America/Paramaribo","AGJ":"Asia/Tokyo","AGK":"Pacific/Port_Moresby","AGL":"Pacific/Port_Moresby","AGM":"America/Godthab","AGN":"America/Anchorage","AGO":"America/Chicago","AGP":"Europe/Madrid","AGQ":"Europe/Athens","AGR":"Asia/Kolkata","AGS":"America/New_York","AGT":"America/Asuncion","AGU":"America/Mexico_City","AGV":"America/Caracas","AGW":"Australia/Brisbane","AGX":"Asia/Kolkata","AGY":"Australia/Perth","AGZ":"Africa/Johannesburg","AHA":"Asia/Tokyo","AHB":"Asia/Riyadh","AHC":"America/Los_Angeles","AHD":"America/Chicago","AHE":"Pacific/Tahiti","AHF":"America/Chicago","AHH":"America/Chicago","AHI":"Asia/Jayapura","AHJ":"Asia/Shanghai","AHL":"America/Guyana","AHN":"America/New_York","AHO":"Europe/Rome","AHS":"America/Tegucigalpa","AHT":"America/Adak","AHU":"Africa/Casablanca","AHY":"Indian/Antananarivo","AHZ":"Europe/Paris","AIA":"America/Denver","AIB":"America/Anchorage","AIC":"Pacific/Majuro","AID":"America/Indiana/Indianapolis","AIE":"Pacific/Port_Moresby","AIF":"America/Sao_Paulo","AIG":"Africa/Bangui","AIH":"Pacific/Port_Moresby","AII":"Africa/Djibouti","AIK":"America/New_York","AIL":"America/Panama","AIM":"Pacific/Majuro","AIN":"America/Anchorage","AIO":"America/Chicago","AIP":"Asia/Kolkata","AIR":"America/Campo_Grande","AIS":"Pacific/Tarawa","AIT":"Pacific/Rarotonga","AIU":"Pacific/Rarotonga","AIV":"America/Chicago","AIW":"Africa/Windhoek","AIY":"America/New_York","AIZ":"America/Chicago","AJA":"Europe/Paris","AJF":"Asia/Riyadh","AJI":"Europe/Istanbul","AJJ":"Africa/Nouakchott","AJK":"Asia/Tehran","AJL":"Asia/Kolkata","AJN":"Indian/Comoro","AJO":"Asia/Aden","AJR":"Europe/Stockholm","AJS":"America/Tijuana","AJU":"America/Belem","AJY":"Africa/Niamey","AKA":"Asia/Shanghai","AKB":"America/Adak","AKC":"America/New_York","AKD":"Asia/Kolkata","AKE":"Africa/Libreville","AKF":"Africa/Tripoli","AKG":"Pacific/Port_Moresby","AKH":"Asia/Riyadh","AKI":"America/Anchorage","AKJ":"Asia/Tokyo","AKK":"America/Anchorage","AKL":"Pacific/Auckland","AKM":"Africa/Ndjamena","AKN":"America/Anchorage","AKO":"America/Denver","AKP":"America/Anchorage","AKQ":"Asia/Jakarta","AKR":"Africa/Lagos","AKS":"Pacific/Guadalcanal","AKT":"Asia/Nicosia","AKU":"Asia/Shanghai","AKV":"America/Toronto","AKW":"Asia/Tehran","AKX":"Asia/Aqtobe","AKY":"Asia/Yangon","ALA":"Asia/Almaty","ALB":"America/New_York","ALC":"Europe/Madrid","ALD":"America/Lima","ALE":"America/Chicago","ALF":"Europe/Oslo","ALG":"Africa/Algiers","ALH":"Australia/Perth","ALI":"America/Chicago","ALJ":"Africa/Johannesburg","ALK":"Africa/Addis_Ababa","ALL":"Europe/Rome","ALM":"America/Denver","ALN":"America/Chicago","ALO":"America/Chicago","ALP":"Asia/Damascus","ALQ":"America/Sao_Paulo","ALR":"Pacific/Auckland","ALS":"America/Denver","ALT":"America/Porto_Velho","ALU":"Africa/Mogadishu","ALV":"Europe/Andorra","ALW":"America/Los_Angeles","ALX":"America/Chicago","ALY":"Africa/Cairo","ALZ":"America/Anchorage","AMA":"America/Chicago","AMB":"Indian/Antananarivo","AMC":"Africa/Ndjamena","AMD":"Asia/Kolkata","AME":"Africa/Maputo","AMF":"Pacific/Port_Moresby","AMG":"Pacific/Port_Moresby","AMH":"Africa/Addis_Ababa","AMI":"Asia/Makassar","AMJ":"America/Sao_Paulo","AMK":"America/Denver","AML":"America/Panama","AMM":"Asia/Amman","AMN":"America/New_York","AMO":"Africa/Ndjamena","AMP":"Indian/Antananarivo","AMQ":"Asia/Jayapura","AMR":"Europe/Madrid","AMS":"Europe/Amsterdam","AMT":"Australia/Darwin","AMU":"Pacific/Port_Moresby","AMV":"Europe/Moscow","AMW":"America/Chicago","AMX":"Australia/Darwin","AMY":"Indian/Antananarivo","AMZ":"Pacific/Auckland","ANA":"Africa/Nairobi","ANB":"America/Chicago","ANC":"America/Anchorage","AND":"America/New_York","ANE":"Europe/Paris","ANF":"America/Santiago","ANG":"Europe/Paris","ANH":"Pacific/Guadalcanal","ANI":"America/Anchorage","ANJ":"Africa/Brazzaville","ANK":"Europe/Istanbul","ANL":"Africa/Luanda","ANM":"Indian/Antananarivo","ANN":"America/Anchorage","ANO":"Africa/Maputo","ANP":"America/New_York","ANQ":"America/Indiana/Indianapolis","ANR":"Europe/Brussels","ANS":"America/Lima","ANT":"Europe/Vienna","ANU":"America/Antigua","ANV":"America/Anchorage","ANW":"America/Chicago","ANX":"Europe/Oslo","ANY":"America/Chicago","ANZ":"Australia/Darwin","AOA":"Pacific/Port_Moresby","AOB":"Pacific/Port_Moresby","AOC":"Europe/Berlin","AOD":"Africa/Ndjamena","AOE":"Europe/Istanbul","AOG":"Asia/Shanghai","AOH":"America/New_York","AOI":"Europe/Rome","AOJ":"Asia/Tokyo","AOK":"Europe/Athens","AOL":"America/Argentina/Buenos_Aires","AOM":"Asia/Muscat","AON":"Pacific/Port_Moresby","AOO":"America/New_York","AOP":"America/Lima","AOQ":"America/Godthab","AOR":"Asia/Kuala_Lumpur","AOS":"America/Anchorage","AOT":"Europe/Rome","AOU":"Asia/Vientiane","AOY":"Asia/Tehran","APA":"America/Denver","APB":"America/La_Paz","APC":"America/Los_Angeles","APE":"America/Lima","APF":"America/New_York","APG":"America/New_York","APH":"America/New_York","API":"America/Bogota","APK":"Pacific/Tahiti","APL":"Africa/Maputo","APN":"America/New_York","APO":"America/Bogota","APP":"Pacific/Port_Moresby","APQ":"America/Belem","APR":"Pacific/Port_Moresby","APS":"America/Sao_Paulo","APT":"America/Chicago","APU":"America/Sao_Paulo","APV":"America/Los_Angeles","APW":"Pacific/Apia","APX":"America/Sao_Paulo","APY":"America/Belem","APZ":"America/Argentina/Buenos_Aires","AQA":"America/Sao_Paulo","AQG":"Asia/Shanghai","AQI":"Asia/Riyadh","AQJ":"Asia/Amman","AQM":"America/Porto_Velho","AQP":"America/Lima","AQS":"Pacific/Fiji","AQY":"America/Anchorage","ARA":"America/Chicago","ARB":"America/New_York","ARC":"America/Anchorage","ARD":"Asia/Makassar","ARE":"America/Puerto_Rico","ARF":"America/Bogota","ARG":"America/Chicago","ARH":"Europe/Moscow","ARI":"America/Santiago","ARJ":"Asia/Jayapura","ARK":"Africa/Dar_es_Salaam","ARL":"Africa/Ouagadougou","ARM":"Australia/Sydney","ARN":"Europe/Stockholm","ARO":"America/Bogota","ARP":"Pacific/Port_Moresby","ARQ":"America/Bogota","ARR":"America/Argentina/Buenos_Aires","ARS":"America/Sao_Paulo","ART":"America/New_York","ARU":"America/Sao_Paulo","ARV":"America/Chicago","ARW":"Europe/Bucharest","ARX":"America/Belem","ARY":"Australia/Sydney","ARZ":"Africa/Luanda","ASA":"Africa/Asmara","ASB":"Asia/Ashgabat","ASC":"America/La_Paz","ASD":"America/Nassau","ASE":"America/Denver","ASF":"Europe/Samara","ASG":"Pacific/Auckland","ASH":"America/New_York","ASI":"Atlantic/St_Helena","ASJ":"Asia/Tokyo","ASK":"Africa/Abidjan","ASL":"America/Chicago","ASM":"Africa/Asmara","ASN":"America/Chicago","ASO":"Africa/Addis_Ababa","ASP":"Australia/Darwin","ASQ":"America/Los_Angeles","ASR":"Europe/Istanbul","ASS":"Africa/Johannesburg","AST":"America/Los_Angeles","ASU":"America/Asuncion","ASV":"Africa/Nairobi","ASW":"Africa/Cairo","ASX":"America/Chicago","ASY":"America/Chicago","ASZ":"Pacific/Port_Moresby","ATA":"America/Lima","ATB":"Africa/Khartoum","ATC":"America/Nassau","ATD":"Pacific/Guadalcanal","ATE":"America/Chicago","ATF":"America/Guayaquil","ATG":"Asia/Karachi","ATH":"Europe/Athens","ATI":"America/Montevideo","ATJ":"Indian/Antananarivo","ATK":"America/Anchorage","ATL":"America/New_York","ATM":"America/Belem","ATN":"Pacific/Port_Moresby","ATO":"America/New_York","ATP":"Pacific/Port_Moresby","ATQ":"Asia/Kolkata","ATR":"Africa/Nouakchott","ATS":"America/Denver","ATT":"America/Anchorage","ATU":"America/Adak","ATV":"Africa/Ndjamena","ATW":"America/Chicago","ATX":"Asia/Almaty","ATY":"America/Chicago","ATZ":"Africa/Cairo","AUA":"America/Aruba","AUB":"America/Campo_Grande","AUC":"America/Bogota","AUD":"Australia/Brisbane","AUE":"Africa/Cairo","AUF":"Europe/Paris","AUG":"America/New_York","AUH":"Asia/Dubai","AUI":"Pacific/Port_Moresby","AUJ":"Pacific/Port_Moresby","AUK":"America/Anchorage","AUL":"Pacific/Majuro","AUM":"America/Chicago","AUN":"America/Los_Angeles","AUO":"America/Chicago","AUP":"Pacific/Port_Moresby","AUQ":"Pacific/Marquesas","AUR":"Europe/Paris","AUS":"America/Chicago","AUT":"Asia/Jayapura","AUU":"Australia/Brisbane","AUV":"Pacific/Port_Moresby","AUW":"America/Chicago","AUX":"America/Belem","AUY":"Pacific/Efate","AUZ":"America/Chicago","AVA":"Asia/Shanghai","AVB":"Europe/Rome","AVF":"Europe/Paris","AVG":"Australia/Darwin","AVI":"America/Havana","AVK":"Asia/Ulaanbaatar","AVL":"America/New_York","AVN":"Europe/Paris","AVO":"America/New_York","AVP":"America/New_York","AVR":"Europe/Lisbon","AVU":"Pacific/Guadalcanal","AVV":"Australia/Sydney","AVW":"America/Phoenix","AVX":"America/Los_Angeles","AWA":"Africa/Addis_Ababa","AWB":"Pacific/Port_Moresby","AWD":"Pacific/Efate","AWE":"Africa/Libreville","AWH":"Africa/Addis_Ababa","AWK":"Pacific/Wake","AWM":"America/Chicago","AWN":"Australia/Adelaide","AWP":"Australia/Darwin","AWR":"Pacific/Port_Moresby","AWT":"Asia/Kolkata","AWZ":"Asia/Tehran","AXA":"America/Anguilla","AXB":"America/New_York","AXC":"Australia/Brisbane","AXD":"Europe/Athens","AXE":"America/Sao_Paulo","AXF":"Asia/Shanghai","AXG":"America/Chicago","AXJ":"Asia/Tokyo","AXK":"Asia/Aden","AXL":"Australia/Darwin","AXM":"America/Bogota","AXN":"America/Chicago","AXP":"America/Nassau","AXR":"Pacific/Tahiti","AXS":"America/Chicago","AXT":"Asia/Tokyo","AXU":"Africa/Addis_Ababa","AXV":"America/New_York","AXX":"America/Denver","AYA":"America/Bogota","AYC":"America/Bogota","AYD":"Australia/Darwin","AYE":"America/New_York","AYG":"America/Bogota","AYH":"Europe/London","AYI":"America/Bogota","AYK":"Asia/Qostanay","AYL":"Australia/Darwin","AYN":"Asia/Shanghai","AYO":"America/Asuncion","AYP":"America/Lima","AYQ":"Australia/Darwin","AYR":"Australia/Brisbane","AYS":"America/New_York","AYT":"Europe/Istanbul","AYU":"Pacific/Port_Moresby","AYW":"Asia/Jayapura","AYX":"America/Lima","AYZ":"America/New_York","AZA":"America/Phoenix","AZB":"Pacific/Port_Moresby","AZD":"Asia/Tehran","AZG":"America/Mexico_City","AZI":"Asia/Dubai","AZN":"Asia/Tashkent","AZO":"America/New_York","AZP":"America/Mexico_City","AZR":"Africa/Algiers","AZS":"America/Santo_Domingo","AZT":"America/Bogota","AZZ":"Africa/Luanda","BAA":"Pacific/Port_Moresby","BAB":"America/Los_Angeles","BAC":"America/Bogota","BAD":"America/Chicago","BAE":"Europe/Paris","BAF":"America/New_York","BAG":"Asia/Manila","BAH":"Asia/Bahrain","BAI":"America/Costa_Rica","BAJ":"Pacific/Port_Moresby","BAK":"Asia/Baku","BAL":"Europe/Istanbul","BAM":"America/Los_Angeles","BAN":"Africa/Lubumbashi","BAP":"Pacific/Port_Moresby","BAQ":"America/Bogota","BAR":"Asia/Shanghai","BAS":"Pacific/Guadalcanal","BAT":"America/Sao_Paulo","BAV":"Asia/Shanghai","BAW":"Africa/Libreville","BAX":"Asia/Krasnoyarsk","BAY":"Europe/Bucharest","BAZ":"America/Porto_Velho","BBA":"America/Santiago","BBB":"America/Chicago","BBC":"America/Chicago","BBD":"America/Chicago","BBE":"Australia/Perth","BBF":"America/New_York","BBG":"Pacific/Tarawa","BBH":"Europe/Berlin","BBI":"Asia/Kolkata","BBJ":"Europe/Berlin","BBK":"Africa/Gaborone","BBL":"Australia/Brisbane","BBM":"Asia/Phnom_Penh","BBN":"Asia/Kuala_Lumpur","BBO":"Africa/Mogadishu","BBP":"Europe/London","BBQ":"America/Antigua","BBR":"America/Guadeloupe","BBS":"Europe/London","BBT":"Africa/Bangui","BBU":"Europe/Bucharest","BBV":"Africa/Abidjan","BBW":"America/Chicago","BBX":"America/New_York","BBY":"Africa/Bangui","BBZ":"Africa/Lusaka","BCA":"America/Havana","BCB":"America/New_York","BCC":"America/Anchorage","BCD":"Asia/Manila","BCE":"America/Denver","BCF":"Africa/Bangui","BCG":"America/Guyana","BCH":"Asia/Jayapura","BCI":"Australia/Brisbane","BCJ":"America/Denver","BCK":"Australia/Brisbane","BCL":"America/Costa_Rica","BCM":"Europe/Bucharest","BCN":"Europe/Madrid","BCO":"Africa/Addis_Ababa","BCP":"Pacific/Port_Moresby","BCQ":"Africa/Tripoli","BCR":"America/Porto_Velho","BCS":"America/Chicago","BCT":"America/New_York","BCU":"Africa/Lagos","BCV":"America/Belize","BCW":"Africa/Maputo","BCX":"Asia/Yekaterinburg","BCY":"Africa/Addis_Ababa","BCZ":"Australia/Darwin","BDA":"Atlantic/Bermuda","BDB":"Australia/Brisbane","BDC":"America/Belem","BDD":"Australia/Brisbane","BDE":"America/Chicago","BDF":"America/Chicago","BDG":"America/Denver","BDH":"Asia/Tehran","BDI":"Indian/Mahe","BDJ":"Asia/Makassar","BDK":"Africa/Abidjan","BDL":"America/New_York","BDM":"Europe/Istanbul","BDN":"Asia/Karachi","BDO":"Asia/Jakarta","BDP":"Asia/Kathmandu","BDQ":"Asia/Kolkata","BDR":"America/New_York","BDS":"Europe/Rome","BDT":"Africa/Kinshasa","BDU":"Europe/Oslo","BDV":"Africa/Lubumbashi","BDW":"Australia/Perth","BDX":"America/Denver","BDY":"America/Los_Angeles","BDZ":"Pacific/Port_Moresby","BEA":"Pacific/Port_Moresby","BEB":"Europe/London","BEC":"America/Chicago","BED":"America/New_York","BEE":"Australia/Perth","BEF":"America/Managua","BEG":"Europe/Belgrade","BEH":"America/New_York","BEI":"Africa/Addis_Ababa","BEJ":"Asia/Makassar","BEK":"Asia/Kolkata","BEL":"America/Belem","BEM":"Africa/Casablanca","BEN":"Africa/Tripoli","BEO":"Australia/Sydney","BEP":"Asia/Kolkata","BEQ":"Europe/London","BES":"Europe/Paris","BET":"America/Anchorage","BEU":"Australia/Brisbane","BEV":"Asia/Jerusalem","BEW":"Africa/Maputo","BEX":"Europe/London","BEY":"Asia/Beirut","BEZ":"Pacific/Tarawa","BFA":"America/Asuncion","BFB":"America/Anchorage","BFC":"Australia/Brisbane","BFD":"America/New_York","BFE":"Europe/Berlin","BFF":"America/Denver","BFG":"America/Denver","BFH":"America/Sao_Paulo","BFI":"America/Los_Angeles","BFJ":"Asia/Shanghai","BFK":"America/Denver","BFL":"America/Los_Angeles","BFM":"America/Chicago","BFN":"Africa/Johannesburg","BFO":"Africa/Harare","BFP":"America/New_York","BFQ":"America/Panama","BFR":"America/Indiana/Indianapolis","BFS":"Europe/London","BFT":"America/New_York","BFU":"Asia/Shanghai","BFV":"Asia/Bangkok","BFW":"Africa/Algiers","BFX":"Africa/Douala","BGA":"America/Bogota","BGB":"Africa/Libreville","BGC":"Europe/Lisbon","BGD":"America/Chicago","BGE":"America/New_York","BGF":"Africa/Bangui","BGG":"Europe/Istanbul","BGH":"Africa/Nouakchott","BGI":"America/Barbados","BGJ":"Atlantic/Reykjavik","BGK":"America/Belize","BGL":"Asia/Kathmandu","BGM":"America/New_York","BGN":"Asia/Magadan","BGO":"Europe/Oslo","BGP":"Africa/Libreville","BGQ":"America/Anchorage","BGR":"America/New_York","BGS":"America/Chicago","BGT":"America/Phoenix","BGU":"Africa/Bangui","BGV":"America/Sao_Paulo","BGW":"Asia/Baghdad","BGX":"America/Sao_Paulo","BGY":"Europe/Rome","BGZ":"Europe/Lisbon","BHA":"America/Guayaquil","BHB":"America/New_York","BHC":"Asia/Karachi","BHD":"Europe/London","BHE":"Pacific/Auckland","BHF":"America/Bogota","BHG":"America/Tegucigalpa","BHH":"Asia/Riyadh","BHI":"America/Argentina/Buenos_Aires","BHJ":"Asia/Kolkata","BHK":"Asia/Tashkent","BHL":"America/Tijuana","BHM":"America/Chicago","BHN":"Asia/Aden","BHO":"Asia/Kolkata","BHP":"Asia/Kathmandu","BHQ":"Australia/Adelaide","BHR":"Asia/Kathmandu","BHS":"Australia/Sydney","BHT":"Australia/Brisbane","BHU":"Asia/Kolkata","BHV":"Asia/Karachi","BHW":"Asia/Karachi","BHX":"Europe/London","BHY":"Asia/Shanghai","BIA":"Europe/Paris","BIB":"Africa/Mogadishu","BIC":"America/Anchorage","BID":"America/New_York","BIE":"America/Chicago","BIF":"America/Denver","BIG":"America/Anchorage","BIH":"America/Los_Angeles","BII":"Pacific/Majuro","BIJ":"Pacific/Port_Moresby","BIK":"Asia/Jayapura","BIL":"America/Denver","BIM":"America/Nassau","BIN":"Asia/Kabul","BIO":"Europe/Madrid","BIP":"Australia/Brisbane","BIQ":"Europe/Paris","BIR":"Asia/Kathmandu","BIS":"America/Chicago","BIT":"Asia/Kathmandu","BIU":"Atlantic/Reykjavik","BIV":"Africa/Bangui","BIW":"Australia/Perth","BIX":"America/Chicago","BIY":"Africa/Johannesburg","BIZ":"Pacific/Port_Moresby","BJA":"Africa/Algiers","BJB":"Asia/Tehran","BJC":"America/Denver","BJD":"Atlantic/Reykjavik","BJE":"Africa/Khartoum","BJF":"Europe/Oslo","BJG":"Asia/Makassar","BJH":"Asia/Kathmandu","BJI":"America/Chicago","BJJ":"America/New_York","BJK":"Asia/Jayapura","BJL":"Africa/Banjul","BJM":"Africa/Bujumbura","BJN":"Africa/Maputo","BJO":"America/La_Paz","BJP":"America/Sao_Paulo","BJQ":"Asia/Muscat","BJR":"Africa/Addis_Ababa","BJT":"Asia/Colombo","BJU":"Asia/Kathmandu","BJV":"Europe/Istanbul","BJW":"Asia/Makassar","BJX":"America/Mexico_City","BJY":"Europe/Belgrade","BJZ":"Europe/Madrid","BKB":"Asia/Kolkata","BKC":"America/Anchorage","BKD":"America/Chicago","BKE":"America/Los_Angeles","BKF":"America/Anchorage","BKG":"America/Chicago","BKH":"Pacific/Honolulu","BKI":"Asia/Kuala_Lumpur","BKJ":"Africa/Conakry","BKK":"Asia/Bangkok","BKL":"America/New_York","BKM":"Asia/Kuala_Lumpur","BKN":"Asia/Ashgabat","BKO":"Africa/Bamako","BKP":"Australia/Brisbane","BKQ":"Australia/Brisbane","BKR":"Africa/Ndjamena","BKS":"Asia/Jakarta","BKT":"America/New_York","BKU":"Indian/Antananarivo","BKV":"Asia/Shanghai","BKW":"America/New_York","BKX":"America/Chicago","BKY":"Africa/Lubumbashi","BKZ":"Africa/Dar_es_Salaam","BLA":"America/Caracas","BLB":"America/Panama","BLC":"Africa/Douala","BLD":"America/Los_Angeles","BLE":"Europe/Stockholm","BLF":"America/New_York","BLG":"Asia/Kuala_Lumpur","BLH":"America/Los_Angeles","BLI":"America/Los_Angeles","BLJ":"Africa/Algiers","BLK":"Europe/London","BLL":"Europe/Copenhagen","BLM":"America/New_York","BLN":"Australia/Sydney","BLO":"Atlantic/Reykjavik","BLP":"America/Lima","BLQ":"Europe/Rome","BLR":"Asia/Kolkata","BLS":"Australia/Brisbane","BLT":"Australia/Brisbane","BLU":"America/Los_Angeles","BLV":"America/Chicago","BLW":"Africa/Mogadishu","BLX":"Europe/Rome","BLY":"Europe/Dublin","BLZ":"Africa/Blantyre","BMA":"Europe/Stockholm","BMB":"Africa/Kinshasa","BMC":"America/Denver","BMD":"Indian/Antananarivo","BME":"Australia/Perth","BMF":"Africa/Bangui","BMG":"America/Indiana/Indianapolis","BMH":"Pacific/Port_Moresby","BMI":"America/Chicago","BMJ":"America/Guyana","BMK":"Europe/Berlin","BML":"America/New_York","BMM":"Africa/Libreville","BMN":"Asia/Baghdad","BMO":"Asia/Yangon","BMP":"Australia/Brisbane","BMQ":"Africa/Nairobi","BMR":"Europe/Berlin","BMS":"America/Belem","BMT":"America/Chicago","BMU":"Asia/Makassar","BMV":"Asia/Ho_Chi_Minh","BMW":"Africa/Algiers","BMX":"America/Anchorage","BMY":"Pacific/Noumea","BMZ":"Pacific/Port_Moresby","BNA":"America/Chicago","BNB":"Africa/Kinshasa","BNC":"Africa/Lubumbashi","BND":"Asia/Tehran","BNE":"Australia/Brisbane","BNF":"America/Anchorage","BNG":"America/Los_Angeles","BNH":"America/New_York","BNI":"Africa/Lagos","BNK":"Australia/Sydney","BNL":"America/New_York","BNM":"Pacific/Port_Moresby","BNN":"Europe/Oslo","BNO":"America/Los_Angeles","BNP":"Asia/Karachi","BNQ":"Asia/Manila","BNR":"Africa/Ouagadougou","BNS":"America/Caracas","BNT":"Pacific/Port_Moresby","BNU":"America/Sao_Paulo","BNV":"Pacific/Port_Moresby","BNW":"America/Chicago","BNX":"Europe/Sarajevo","BNY":"Pacific/Guadalcanal","BNZ":"Pacific/Port_Moresby","BOA":"Africa/Kinshasa","BOB":"Pacific/Tahiti","BOC":"America/Panama","BOD":"Europe/Paris","BOE":"Africa/Brazzaville","BOF":"America/New_York","BOG":"America/Bogota","BOH":"Europe/London","BOI":"America/Denver","BOJ":"Europe/Sofia","BOK":"America/Los_Angeles","BOL":"Europe/London","BOM":"Asia/Kolkata","BON":"America/Curacao","BOO":"Europe/Oslo","BOP":"Africa/Bangui","BOQ":"Pacific/Port_Moresby","BOR":"Europe/Paris","BOS":"America/New_York","BOT":"Pacific/Port_Moresby","BOU":"Europe/Paris","BOV":"Pacific/Port_Moresby","BOW":"America/New_York","BOX":"Australia/Darwin","BOY":"Africa/Ouagadougou","BOZ":"Africa/Bangui","BPA":"America/New_York","BPB":"Pacific/Port_Moresby","BPC":"Africa/Douala","BPD":"Pacific/Port_Moresby","BPE":"Asia/Shanghai","BPF":"Pacific/Guadalcanal","BPG":"America/Campo_Grande","BPH":"Asia/Manila","BPI":"America/Denver","BPK":"Pacific/Port_Moresby","BPL":"Asia/Shanghai","BPN":"Asia/Makassar","BPS":"America/Belem","BPT":"America/Chicago","BPU":"Asia/Tokyo","BPX":"Asia/Shanghai","BPY":"Indian/Antananarivo","BQA":"Asia/Manila","BQB":"Australia/Perth","BQE":"Africa/Bissau","BQG":"Asia/Vladivostok","BQH":"Europe/London","BQI":"Africa/Windhoek","BQJ":"Asia/Vladivostok","BQK":"America/New_York","BQL":"Australia/Brisbane","BQN":"America/Puerto_Rico","BQO":"Africa/Abidjan","BQQ":"America/Belem","BQS":"Asia/Yakutsk","BQT":"Europe/Minsk","BQU":"America/St_Vincent","BQV":"America/Anchorage","BQW":"Australia/Perth","BRA":"America/Belem","BRB":"America/Belem","BRC":"America/Argentina/Buenos_Aires","BRD":"America/Chicago","BRE":"Europe/Berlin","BRG":"America/New_York","BRH":"Pacific/Port_Moresby","BRI":"Europe/Rome","BRJ":"Australia/Sydney","BRK":"Australia/Sydney","BRL":"America/Chicago","BRM":"America/Caracas","BRN":"Europe/Zurich","BRO":"America/Chicago","BRP":"Pacific/Port_Moresby","BRQ":"Europe/Prague","BRR":"Europe/London","BRS":"Europe/London","BRT":"Australia/Darwin","BRU":"Europe/Brussels","BRV":"Europe/Berlin","BRW":"America/Anchorage","BRX":"America/Santo_Domingo","BRY":"America/New_York","BSA":"Africa/Mogadishu","BSB":"America/Sao_Paulo","BSC":"America/Bogota","BSD":"Asia/Shanghai","BSE":"Asia/Kuala_Lumpur","BSF":"Pacific/Honolulu","BSG":"Africa/Malabo","BSH":"Europe/London","BSI":"Asia/Manila","BSJ":"Australia/Sydney","BSK":"Africa/Algiers","BSL":"Europe/Paris","BSM":"Asia/Tehran","BSN":"Africa/Bangui","BSO":"Asia/Manila","BSP":"Pacific/Port_Moresby","BSQ":"America/Phoenix","BSR":"Asia/Baghdad","BSS":"America/Belem","BST":"Asia/Kabul","BSU":"Africa/Kinshasa","BSV":"Indian/Antananarivo","BSW":"America/Anchorage","BSX":"Asia/Yangon","BSY":"Africa/Mogadishu","BSZ":"America/Anchorage","BTA":"Africa/Douala","BTB":"Africa/Brazzaville","BTC":"Asia/Colombo","BTD":"Australia/Darwin","BTE":"Africa/Freetown","BTF":"America/Denver","BTG":"Africa/Bangui","BTH":"Asia/Jakarta","BTI":"America/Anchorage","BTJ":"Asia/Jakarta","BTK":"Asia/Irkutsk","BTL":"America/New_York","BTM":"America/Denver","BTN":"America/New_York","BTO":"America/Paramaribo","BTP":"America/New_York","BTQ":"Africa/Kigali","BTR":"America/Chicago","BTS":"Europe/Bratislava","BTT":"America/Anchorage","BTU":"Asia/Kuala_Lumpur","BTV":"America/New_York","BTW":"Asia/Makassar","BTX":"Australia/Brisbane","BTY":"America/Los_Angeles","BUA":"Pacific/Bougainville","BUB":"America/Chicago","BUC":"Australia/Brisbane","BUD":"Europe/Budapest","BUF":"America/New_York","BUG":"Africa/Luanda","BUI":"Asia/Jayapura","BUJ":"Africa/Algiers","BUK":"Asia/Aden","BUL":"Pacific/Port_Moresby","BUM":"America/Chicago","BUN":"America/Bogota","BUO":"Africa/Mogadishu","BUP":"Asia/Kolkata","BUQ":"Africa/Harare","BUR":"America/Los_Angeles","BUS":"Asia/Tbilisi","BUT":"Asia/Thimphu","BUU":"Asia/Jakarta","BUV":"America/Montevideo","BUW":"Asia/Makassar","BUX":"Africa/Lubumbashi","BUY":"Australia/Perth","BUZ":"Asia/Tehran","BVA":"Europe/Paris","BVB":"America/Porto_Velho","BVC":"Atlantic/Cape_Verde","BVD":"America/Anchorage","BVE":"Europe/Paris","BVF":"Pacific/Fiji","BVG":"Europe/Oslo","BVH":"America/Porto_Velho","BVI":"Australia/Brisbane","BVJ":"Asia/Yekaterinburg","BVK":"America/La_Paz","BVL":"America/La_Paz","BVM":"America/Belem","BVO":"America/Chicago","BVP":"Pacific/Port_Moresby","BVR":"Atlantic/Cape_Verde","BVS":"America/Belem","BVU":"America/Anchorage","BVV":"Asia/Magadan","BVW":"Australia/Brisbane","BVX":"America/Chicago","BVY":"America/New_York","BVZ":"Australia/Perth","BWA":"Asia/Kathmandu","BWB":"Australia/Perth","BWC":"America/Los_Angeles","BWD":"America/Chicago","BWE":"Europe/Berlin","BWF":"Europe/London","BWG":"America/Chicago","BWH":"Asia/Kuala_Lumpur","BWI":"America/New_York","BWJ":"Pacific/Port_Moresby","BWK":"Europe/Zagreb","BWL":"America/Chicago","BWM":"America/Denver","BWN":"Asia/Brunei","BWO":"Europe/Saratov","BWP":"Pacific/Port_Moresby","BWQ":"Australia/Sydney","BWS":"America/Los_Angeles","BWT":"Australia/Hobart","BWU":"Australia/Sydney","BWX":"Asia/Jakarta","BWY":"Europe/London","BXA":"America/Chicago","BXB":"Asia/Jayapura","BXC":"America/New_York","BXD":"Asia/Jayapura","BXE":"Africa/Dakar","BXF":"Australia/Perth","BXG":"Australia/Sydney","BXH":"Asia/Almaty","BXI":"Africa/Abidjan","BXJ":"Asia/Almaty","BXK":"America/Phoenix","BXL":"Pacific/Fiji","BXM":"Asia/Jayapura","BXN":"Europe/Istanbul","BXO":"Europe/Zurich","BXR":"Asia/Tehran","BXS":"America/Los_Angeles","BXT":"Asia/Makassar","BXU":"Asia/Manila","BXV":"Atlantic/Reykjavik","BXX":"Africa/Mogadishu","BXY":"Asia/Qyzylorda","BXZ":"Pacific/Port_Moresby","BYA":"America/Anchorage","BYB":"Asia/Muscat","BYC":"America/La_Paz","BYD":"Asia/Aden","BYF":"Europe/Paris","BYG":"America/Denver","BYH":"America/Chicago","BYI":"America/Denver","BYJ":"Europe/Lisbon","BYK":"Africa/Abidjan","BYL":"Africa/Monrovia","BYM":"America/Havana","BYN":"Asia/Ulaanbaatar","BYO":"America/Campo_Grande","BYP":"Australia/Perth","BYQ":"Asia/Makassar","BYR":"Europe/Copenhagen","BYS":"America/Los_Angeles","BYT":"Europe/Dublin","BYU":"Europe/Berlin","BYW":"America/Los_Angeles","BYX":"Australia/Darwin","BZA":"America/Managua","BZB":"Africa/Maputo","BZC":"America/Sao_Paulo","BZD":"Australia/Sydney","BZE":"America/Belize","BZF":"America/Los_Angeles","BZG":"Europe/Warsaw","BZH":"Africa/Harare","BZI":"Europe/Istanbul","BZK":"Europe/Moscow","BZL":"Asia/Dhaka","BZM":"Indian/Antananarivo","BZN":"America/Denver","BZO":"Europe/Rome","BZP":"Australia/Brisbane","BZR":"Europe/Paris","BZS":"America/New_York","BZT":"America/Chicago","BZU":"Africa/Lubumbashi","BZV":"Africa/Brazzaville","BZX":"Asia/Shanghai","BZY":"Europe/Chisinau","BZZ":"Europe/London","CAA":"America/Tegucigalpa","CAB":"Africa/Luanda","CAC":"America/Sao_Paulo","CAD":"America/New_York","CAE":"America/New_York","CAF":"America/Porto_Velho","CAG":"Europe/Rome","CAH":"Asia/Ho_Chi_Minh","CAI":"Africa/Cairo","CAJ":"America/Caracas","CAK":"America/New_York","CAL":"Europe/London","CAM":"America/La_Paz","CAN":"Asia/Shanghai","CAO":"America/Denver","CAP":"America/Port-au-Prince","CAQ":"America/Bogota","CAR":"America/New_York","CAS":"Africa/Casablanca","CAT":"Europe/Lisbon","CAU":"America/Belem","CAV":"Africa/Luanda","CAW":"America/Sao_Paulo","CAX":"Europe/London","CAY":"America/Cayenne","CAZ":"Australia/Sydney","CBA":"America/Anchorage","CBB":"America/La_Paz","CBC":"Australia/Perth","CBD":"Asia/Kolkata","CBE":"America/New_York","CBF":"America/Chicago","CBG":"Europe/London","CBH":"Africa/Algiers","CBI":"Australia/Hobart","CBJ":"America/Santo_Domingo","CBK":"America/Chicago","CBL":"America/Caracas","CBM":"America/Chicago","CBN":"Asia/Jakarta","CBO":"Asia/Manila","CBP":"Europe/Lisbon","CBQ":"Africa/Lagos","CBR":"Australia/Sydney","CBS":"America/Caracas","CBT":"Africa/Luanda","CBU":"Europe/Berlin","CBV":"America/Guatemala","CBW":"America/Sao_Paulo","CBX":"Australia/Sydney","CBY":"Australia/Brisbane","CBZ":"America/Anchorage","CCA":"America/La_Paz","CCB":"America/Los_Angeles","CCC":"America/Havana","CCD":"America/Los_Angeles","CCE":"Africa/Cairo","CCF":"Europe/Paris","CCG":"America/Chicago","CCH":"America/Santiago","CCI":"America/Sao_Paulo","CCJ":"Asia/Kolkata","CCK":"Indian/Cocos","CCL":"Australia/Brisbane","CCM":"America/Sao_Paulo","CCN":"Asia/Kabul","CCO":"America/Bogota","CCP":"America/Santiago","CCQ":"America/Belem","CCR":"America/Los_Angeles","CCS":"America/Caracas","CCT":"America/Argentina/Buenos_Aires","CCU":"Asia/Kolkata","CCV":"Pacific/Efate","CCW":"Australia/Adelaide","CCX":"America/Campo_Grande","CCY":"America/Chicago","CCZ":"America/Nassau","CDA":"Australia/Darwin","CDB":"America/Anchorage","CDC":"America/Denver","CDD":"America/Tegucigalpa","CDE":"Asia/Shanghai","CDF":"Europe/Rome","CDG":"Europe/Paris","CDH":"America/Chicago","CDI":"America/Sao_Paulo","CDJ":"America/Belem","CDK":"America/New_York","CDL":"America/Anchorage","CDN":"America/New_York","CDO":"Africa/Johannesburg","CDP":"Asia/Kolkata","CDQ":"Australia/Brisbane","CDR":"America/Denver","CDS":"America/Chicago","CDT":"Europe/Madrid","CDU":"Australia/Sydney","CDV":"America/Anchorage","CDW":"America/New_York","CDY":"Asia/Manila","CDZ":"Europe/Madrid","CEA":"America/Chicago","CEB":"Asia/Manila","CEC":"America/Los_Angeles","CED":"Australia/Adelaide","CEE":"Europe/Moscow","CEF":"America/New_York","CEG":"Europe/London","CEH":"Africa/Blantyre","CEI":"Asia/Bangkok","CEK":"Asia/Yekaterinburg","CEM":"America/Anchorage","CEN":"America/Hermosillo","CEO":"Africa/Luanda","CEP":"America/La_Paz","CEQ":"Europe/Paris","CER":"Europe/Paris","CES":"Australia/Sydney","CET":"Europe/Paris","CEU":"America/New_York","CEV":"America/Indiana/Indianapolis","CEW":"America/New_York","CEX":"America/Anchorage","CEY":"America/Chicago","CEZ":"America/Denver","CFA":"America/Anchorage","CFB":"America/Sao_Paulo","CFC":"America/Sao_Paulo","CFD":"America/Chicago","CFE":"Europe/Paris","CFF":"Africa/Luanda","CFG":"America/Havana","CFH":"Australia/Adelaide","CFI":"Australia/Darwin","CFK":"Africa/Algiers","CFM":"America/Edmonton","CFN":"Europe/Dublin","CFO":"America/Campo_Grande","CFP":"Australia/Brisbane","CFQ":"America/Vancouver","CFR":"Europe/Paris","CFS":"Australia/Sydney","CFT":"America/Phoenix","CFU":"Europe/Athens","CFV":"America/Chicago","CGA":"America/Anchorage","CGB":"America/Campo_Grande","CGC":"Pacific/Port_Moresby","CGD":"Asia/Shanghai","CGE":"America/New_York","CGF":"America/New_York","CGG":"Asia/Manila","CGH":"America/Sao_Paulo","CGI":"America/Chicago","CGJ":"Africa/Lusaka","CGK":"Asia/Jakarta","CGM":"Asia/Manila","CGN":"Europe/Berlin","CGO":"Asia/Shanghai","CGP":"Asia/Dhaka","CGQ":"Asia/Shanghai","CGR":"America/Campo_Grande","CGS":"America/New_York","CGT":"Africa/Nouakchott","CGV":"Australia/Perth","CGY":"Asia/Manila","CGZ":"America/Phoenix","CHA":"America/New_York","CHB":"Asia/Karachi","CHC":"Pacific/Auckland","CHE":"Europe/Tallinn","CHF":"Asia/Seoul","CHG":"Asia/Shanghai","CHH":"America/Lima","CHJ":"Africa/Harare","CHK":"America/Chicago","CHL":"America/Denver","CHM":"America/Lima","CHN":"Asia/Seoul","CHO":"America/New_York","CHP":"America/Anchorage","CHQ":"Europe/Athens","CHR":"Europe/Paris","CHS":"America/New_York","CHT":"Pacific/Chatham","CHU":"America/Anchorage","CHV":"Europe/Lisbon","CHX":"America/Panama","CHY":"Pacific/Guadalcanal","CHZ":"America/Los_Angeles","CIA":"Europe/Rome","CIC":"America/Los_Angeles","CID":"America/Chicago","CIE":"Australia/Perth","CIF":"Asia/Shanghai","CIG":"America/Denver","CIH":"Asia/Shanghai","CIJ":"America/La_Paz","CIK":"America/Anchorage","CIL":"America/Anchorage","CIM":"America/Bogota","CIN":"America/Chicago","CIO":"America/Asuncion","CIP":"Africa/Lusaka","CIQ":"America/Guatemala","CIR":"America/Chicago","CIS":"Pacific/Enderbury","CIT":"Asia/Almaty","CIU":"America/New_York","CIV":"America/Anchorage","CIW":"America/St_Vincent","CIX":"America/Lima","CIY":"Europe/Rome","CIZ":"America/Porto_Velho","CJA":"America/Lima","CJB":"Asia/Kolkata","CJC":"America/Santiago","CJD":"America/Bogota","CJF":"Australia/Perth","CJH":"America/Vancouver","CJJ":"Asia/Seoul","CJL":"Asia/Karachi","CJM":"Asia/Bangkok","CJN":"Asia/Jakarta","CJS":"America/Ojinaga","CJT":"America/Mexico_City","CJU":"Asia/Seoul","CKA":"America/Chicago","CKB":"America/New_York","CKC":"Europe/Kiev","CKD":"America/Anchorage","CKE":"America/Los_Angeles","CKG":"Asia/Shanghai","CKH":"Asia/Magadan","CKI":"Australia/Darwin","CKK":"America/Chicago","CKL":"Europe/Moscow","CKM":"America/Chicago","CKN":"America/Chicago","CKO":"America/Sao_Paulo","CKR":"America/Los_Angeles","CKS":"America/Belem","CKT":"Asia/Tehran","CKU":"America/Anchorage","CKV":"America/Chicago","CKW":"Australia/Perth","CKX":"America/Anchorage","CKY":"Africa/Conakry","CKZ":"Europe/Istanbul","CLA":"Asia/Dhaka","CLD":"America/Los_Angeles","CLE":"America/New_York","CLF":"Europe/London","CLG":"America/Los_Angeles","CLH":"Australia/Sydney","CLI":"America/Chicago","CLJ":"Europe/Bucharest","CLK":"America/Chicago","CLL":"America/Chicago","CLM":"America/Los_Angeles","CLN":"America/Belem","CLO":"America/Bogota","CLP":"America/Anchorage","CLQ":"America/Mexico_City","CLR":"America/Los_Angeles","CLS":"America/Los_Angeles","CLT":"America/New_York","CLU":"America/Indiana/Indianapolis","CLV":"America/Sao_Paulo","CLW":"America/New_York","CLX":"America/Argentina/Buenos_Aires","CLY":"Europe/Paris","CLZ":"America/Caracas","CMA":"Australia/Brisbane","CMB":"Asia/Colombo","CMC":"America/Belem","CMD":"Australia/Sydney","CME":"America/Mexico_City","CMF":"Europe/Paris","CMG":"America/Campo_Grande","CMH":"America/New_York","CMI":"America/Chicago","CMJ":"Asia/Taipei","CMK":"Africa/Blantyre","CML":"Australia/Brisbane","CMM":"America/Guatemala","CMN":"Africa/Casablanca","CMO":"Africa/Mogadishu","CMP":"America/Belem","CMQ":"Australia/Brisbane","CMR":"Europe/Paris","CMS":"Africa/Mogadishu","CMT":"America/Belem","CMU":"Pacific/Port_Moresby","CMV":"Pacific/Auckland","CMW":"America/Havana","CMX":"America/New_York","CMY":"America/Chicago","CMZ":"Africa/Maputo","CNA":"America/Hermosillo","CNB":"Australia/Sydney","CNC":"Australia/Brisbane","CND":"Europe/Bucharest","CNE":"America/Denver","CNF":"America/Sao_Paulo","CNG":"Europe/Paris","CNH":"America/New_York","CNI":"Asia/Shanghai","CNJ":"Australia/Brisbane","CNK":"America/Chicago","CNL":"Europe/Copenhagen","CNM":"America/Denver","CNN":"Asia/Kolkata","CNO":"America/Los_Angeles","CNP":"America/Scoresbysund","CNQ":"America/Argentina/Buenos_Aires","CNR":"America/Santiago","CNS":"Australia/Brisbane","CNT":"America/Argentina/Buenos_Aires","CNU":"America/Chicago","CNV":"America/Belem","CNW":"America/Chicago","CNX":"Asia/Bangkok","CNY":"America/Denver","CNZ":"Africa/Luanda","COA":"America/Los_Angeles","COB":"Australia/Darwin","COC":"America/Argentina/Buenos_Aires","COD":"America/Denver","COE":"America/Los_Angeles","COF":"America/New_York","COG":"America/Bogota","COH":"Asia/Kolkata","COI":"America/New_York","COJ":"Australia/Sydney","COK":"Asia/Kolkata","COL":"Europe/London","COM":"America/Chicago","CON":"America/New_York","COO":"Africa/Porto-Novo","COP":"America/New_York","COQ":"Asia/Ulaanbaatar","COR":"America/Argentina/Buenos_Aires","COS":"America/Denver","COT":"America/Chicago","COU":"America/Chicago","COV":"Europe/Lisbon","COW":"America/Santiago","COY":"Australia/Perth","COZ":"America/Santo_Domingo","CPA":"Africa/Monrovia","CPB":"America/Bogota","CPC":"America/Argentina/Buenos_Aires","CPD":"Australia/Adelaide","CPE":"America/Mexico_City","CPF":"Asia/Jakarta","CPG":"America/Argentina/Buenos_Aires","CPH":"Europe/Copenhagen","CPI":"Pacific/Port_Moresby","CPL":"America/Bogota","CPM":"America/Los_Angeles","CPN":"Pacific/Port_Moresby","CPO":"America/Santiago","CPP":"America/Santiago","CPQ":"America/Sao_Paulo","CPR":"America/Denver","CPS":"America/Chicago","CPT":"Africa/Johannesburg","CPU":"America/Belem","CPV":"America/Belem","CPX":"America/Puerto_Rico","CQA":"America/Campo_Grande","CQD":"Asia/Tehran","CQF":"Europe/Paris","CQP":"Australia/Brisbane","CQS":"America/Porto_Velho","CQT":"America/Bogota","CQW":"Asia/Shanghai","CRA":"Europe/Bucharest","CRB":"Australia/Sydney","CRC":"America/Bogota","CRD":"America/Argentina/Buenos_Aires","CRE":"America/New_York","CRF":"Africa/Bangui","CRG":"America/New_York","CRH":"Australia/Brisbane","CRI":"America/Nassau","CRJ":"Australia/Adelaide","CRK":"Asia/Manila","CRL":"Europe/Brussels","CRM":"Asia/Manila","CRO":"America/Los_Angeles","CRP":"America/Chicago","CRQ":"America/Belem","CRR":"America/Argentina/Buenos_Aires","CRS":"America/Chicago","CRT":"America/Chicago","CRU":"America/Grenada","CRV":"Europe/Rome","CRW":"America/New_York","CRX":"America/Chicago","CRY":"Australia/Perth","CRZ":"Asia/Ashgabat","CSA":"Europe/London","CSB":"Europe/Bucharest","CSC":"America/Costa_Rica","CSD":"Australia/Darwin","CSE":"America/Denver","CSF":"Europe/Paris","CSG":"America/New_York","CSH":"Europe/Moscow","CSI":"Australia/Sydney","CSJ":"Asia/Ho_Chi_Minh","CSK":"Africa/Dakar","CSM":"America/Chicago","CSN":"America/Los_Angeles","CSO":"Europe/Berlin","CSP":"America/Anchorage","CSQ":"America/Chicago","CSR":"America/Bogota","CSS":"America/Campo_Grande","CST":"Pacific/Fiji","CSU":"America/Sao_Paulo","CSV":"America/Chicago","CSW":"America/Porto_Velho","CSX":"Asia/Shanghai","CSY":"Europe/Moscow","CSZ":"America/Argentina/Buenos_Aires","CTA":"Europe/Rome","CTB":"America/Denver","CTC":"America/Argentina/Buenos_Aires","CTD":"America/Panama","CTE":"America/Panama","CTF":"America/Guatemala","CTG":"America/Bogota","CTH":"America/New_York","CTI":"Africa/Luanda","CTK":"America/Chicago","CTL":"Australia/Brisbane","CTM":"America/Cancun","CTN":"Australia/Brisbane","CTO":"America/New_York","CTP":"America/Belem","CTQ":"America/Sao_Paulo","CTR":"Australia/Darwin","CTS":"Asia/Tokyo","CTT":"Europe/Paris","CTU":"Asia/Shanghai","CTW":"America/Phoenix","CTX":"America/New_York","CTY":"America/New_York","CTZ":"America/New_York","CUA":"America/Mazatlan","CUB":"America/New_York","CUC":"America/Bogota","CUD":"Australia/Brisbane","CUE":"America/Guayaquil","CUF":"Europe/Rome","CUG":"Australia/Sydney","CUH":"America/Chicago","CUI":"America/Bogota","CUJ":"Asia/Manila","CUK":"America/Belize","CUL":"America/Mazatlan","CUM":"America/Caracas","CUN":"America/Cancun","CUO":"America/Bogota","CUP":"America/Caracas","CUQ":"Australia/Brisbane","CUR":"America/Curacao","CUS":"America/Denver","CUT":"America/Argentina/Buenos_Aires","CUU":"America/Mazatlan","CUV":"America/Caracas","CUW":"America/Anchorage","CUX":"America/Chicago","CUY":"Australia/Perth","CUZ":"America/Lima","CVA":"America/New_York","CVB":"Pacific/Port_Moresby","CVC":"Australia/Adelaide","CVE":"America/Bogota","CVF":"Europe/Paris","CVG":"America/New_York","CVH":"America/Argentina/Buenos_Aires","CVI":"America/Argentina/Buenos_Aires","CVJ":"America/Mexico_City","CVL":"Pacific/Port_Moresby","CVM":"America/Mexico_City","CVN":"America/Denver","CVO":"America/Los_Angeles","CVQ":"Australia/Perth","CVR":"America/Los_Angeles","CVS":"America/Denver","CVT":"Europe/London","CVU":"Atlantic/Azores","CWA":"America/Chicago","CWB":"America/Sao_Paulo","CWC":"Europe/Kiev","CWF":"America/Chicago","CWG":"America/New_York","CWI":"America/Chicago","CWJ":"Asia/Shanghai","CWL":"Europe/London","CWO":"America/Chicago","CWP":"Asia/Karachi","CWR":"Australia/Adelaide","CWS":"America/Los_Angeles","CWT":"Australia/Sydney","CWW":"Australia/Sydney","CXA":"America/Caracas","CXB":"Asia/Dhaka","CXC":"America/Anchorage","CXF":"America/Anchorage","CXH":"America/Vancouver","CXI":"Pacific/Kiritimati","CXJ":"America/Sao_Paulo","CXL":"America/Los_Angeles","CXN":"Africa/Mogadishu","CXO":"America/Chicago","CXP":"Asia/Jakarta","CXQ":"Australia/Perth","CXR":"Asia/Ho_Chi_Minh","CXT":"Australia/Brisbane","CXY":"America/Nassau","CYA":"America/Port-au-Prince","CYB":"America/Cayman","CYC":"America/Belize","CYD":"America/Belize","CYE":"America/New_York","CYF":"America/Anchorage","CYG":"Australia/Sydney","CYI":"Asia/Taipei","CYL":"America/Tegucigalpa","CYM":"America/Anchorage","CYO":"America/Havana","CYP":"Asia/Manila","CYR":"America/Montevideo","CYS":"America/Denver","CYT":"America/Anchorage","CYU":"Asia/Manila","CYW":"America/Mexico_City","CYX":"Asia/Magadan","CYZ":"Asia/Manila","CZA":"America/Mexico_City","CZB":"America/Sao_Paulo","CZC":"America/Anchorage","CZE":"America/Caracas","CZF":"America/Anchorage","CZH":"America/Belize","CZJ":"America/Panama","CZK":"America/Los_Angeles","CZL":"Africa/Algiers","CZM":"America/Cancun","CZN":"America/Anchorage","CZO":"America/Anchorage","CZP":"America/Anchorage","CZS":"America/Rio_Branco","CZT":"America/Chicago","CZU":"America/Bogota","CZW":"Europe/Warsaw","CZX":"Asia/Shanghai","CZY":"Australia/Brisbane","CZZ":"America/Los_Angeles","DAA":"America/New_York","DAB":"America/New_York","DAC":"Asia/Dhaka","DAD":"Asia/Ho_Chi_Minh","DAE":"Asia/Kolkata","DAF":"Pacific/Port_Moresby","DAG":"America/Los_Angeles","DAH":"Asia/Aden","DAI":"Asia/Kolkata","DAJ":"Australia/Brisbane","DAK":"Africa/Cairo","DAL":"America/Chicago","DAM":"Asia/Damascus","DAN":"America/New_York","DAO":"Pacific/Port_Moresby","DAP":"Asia/Kathmandu","DAR":"Africa/Dar_es_Salaam","DAS":"America/Edmonton","DAT":"Asia/Shanghai","DAU":"Pacific/Port_Moresby","DAV":"America/Panama","DAX":"Asia/Shanghai","DAY":"America/New_York","DAZ":"Asia/Kabul","DBA":"Asia/Karachi","DBB":"Africa/Cairo","DBC":"Asia/Shanghai","DBD":"Asia/Kolkata","DBM":"Africa/Addis_Ababa","DBN":"America/New_York","DBO":"Australia/Sydney","DBP":"Pacific/Port_Moresby","DBQ":"America/Chicago","DBS":"America/Denver","DBT":"Africa/Addis_Ababa","DBU":"Asia/Colombo","DBV":"Europe/Zagreb","DBY":"Australia/Brisbane","DCA":"America/New_York","DCF":"America/Dominica","DCI":"Europe/Rome","DCK":"America/Anchorage","DCM":"Europe/Paris","DCN":"Australia/Perth","DCR":"America/Indiana/Indianapolis","DCT":"America/Nassau","DCU":"America/Chicago","DCY":"Asia/Shanghai","DDC":"America/Chicago","DDD":"Indian/Maldives","DDG":"Asia/Shanghai","DDI":"Australia/Brisbane","DDM":"Pacific/Port_Moresby","DDN":"Australia/Brisbane","DDU":"Asia/Karachi","DEA":"Asia/Karachi","DEB":"Europe/Budapest","DEC":"America/Chicago","DED":"Asia/Kolkata","DEE":"Asia/Magadan","DEF":"Asia/Tehran","DEH":"America/Chicago","DEI":"Indian/Mahe","DEL":"Asia/Kolkata","DEM":"Africa/Addis_Ababa","DEN":"America/Denver","DEO":"America/New_York","DEP":"Asia/Kolkata","DEQ":"Asia/Shanghai","DER":"Pacific/Port_Moresby","DES":"Indian/Mahe","DET":"America/New_York","DEX":"Asia/Jayapura","DEZ":"Asia/Damascus","DFI":"America/New_York","DFP":"Australia/Brisbane","DFW":"America/Chicago","DGA":"America/Belize","DGB":"America/Anchorage","DGC":"Africa/Addis_Ababa","DGD":"Australia/Perth","DGE":"Australia/Sydney","DGF":"America/Vancouver","DGL":"America/Phoenix","DGM":"Asia/Colombo","DGN":"America/New_York","DGO":"America/Mexico_City","DGP":"Europe/Riga","DGR":"Pacific/Auckland","DGT":"Asia/Manila","DGU":"Africa/Ouagadougou","DGW":"America/Denver","DHA":"Asia/Riyadh","DHB":"America/Los_Angeles","DHD":"Australia/Brisbane","DHF":"Asia/Dubai","DHG":"Asia/Vladivostok","DHI":"Asia/Kathmandu","DHL":"Asia/Aden","DHM":"Asia/Kolkata","DHN":"America/Chicago","DHR":"Europe/Amsterdam","DHT":"America/Chicago","DIB":"Asia/Kolkata","DIC":"Africa/Lubumbashi","DIE":"Indian/Antananarivo","DIG":"Asia/Shanghai","DIJ":"Europe/Paris","DIK":"America/Denver","DIL":"Asia/Dili","DIM":"Africa/Abidjan","DIN":"Asia/Ho_Chi_Minh","DIO":"America/Anchorage","DIP":"Africa/Ouagadougou","DIQ":"America/Sao_Paulo","DIR":"Africa/Addis_Ababa","DIS":"Africa/Brazzaville","DIU":"Asia/Kolkata","DIV":"Africa/Abidjan","DIW":"Asia/Colombo","DIY":"Europe/Istanbul","DJA":"Africa/Porto-Novo","DJB":"Asia/Jakarta","DJE":"Africa/Tunis","DJG":"Africa/Algiers","DJJ":"Asia/Jayapura","DJM":"Africa/Brazzaville","DJN":"America/Anchorage","DJO":"Africa/Abidjan","DJU":"Atlantic/Reykjavik","DKA":"Africa/Lagos","DKI":"Australia/Brisbane","DKK":"America/New_York","DKR":"Africa/Dakar","DKS":"Asia/Krasnoyarsk","DKV":"Australia/Darwin","DLA":"Africa/Douala","DLC":"Asia/Shanghai","DLD":"Europe/Oslo","DLE":"Europe/Paris","DLF":"America/Chicago","DLG":"America/Anchorage","DLH":"America/Chicago","DLI":"Asia/Ho_Chi_Minh","DLK":"Australia/Adelaide","DLL":"America/New_York","DLM":"Europe/Istanbul","DLN":"America/Denver","DLO":"America/Anchorage","DLP":"Europe/Paris","DLR":"Asia/Vladivostok","DLS":"America/Los_Angeles","DLU":"Asia/Shanghai","DLV":"Australia/Darwin","DLY":"Pacific/Efate","DLZ":"Asia/Ulaanbaatar","DMA":"America/Phoenix","DMB":"Asia/Almaty","DMD":"Australia/Brisbane","DME":"Europe/Moscow","DMK":"Asia/Bangkok","DMM":"Asia/Riyadh","DMN":"America/Denver","DMO":"America/Chicago","DMR":"Asia/Aden","DMT":"America/Campo_Grande","DMU":"Asia/Kolkata","DNA":"Asia/Tokyo","DNB":"Australia/Brisbane","DNC":"Africa/Abidjan","DND":"Europe/London","DNF":"Africa/Tripoli","DNG":"Australia/Perth","DNH":"Asia/Shanghai","DNI":"Africa/Khartoum","DNK":"Europe/Kiev","DNL":"America/New_York","DNM":"Australia/Perth","DNN":"America/New_York","DNO":"America/Belem","DNP":"Asia/Kathmandu","DNQ":"Australia/Sydney","DNR":"Europe/Paris","DNS":"America/Chicago","DNU":"Pacific/Port_Moresby","DNV":"America/Chicago","DNX":"Africa/Khartoum","DNZ":"Europe/Istanbul","DOA":"Indian/Antananarivo","DOB":"Asia/Jayapura","DOC":"Europe/London","DOD":"Africa/Dar_es_Salaam","DOE":"America/Paramaribo","DOF":"America/Anchorage","DOG":"Africa/Khartoum","DOH":"Asia/Qatar","DOI":"Pacific/Port_Moresby","DOL":"Europe/Paris","DOM":"America/Dominica","DON":"America/Guatemala","DOO":"Pacific/Port_Moresby","DOP":"Asia/Kathmandu","DOR":"Africa/Ouagadougou","DOS":"Pacific/Bougainville","DOU":"America/Campo_Grande","DOV":"America/New_York","DOX":"Australia/Perth","DOY":"Asia/Shanghai","DPA":"America/Chicago","DPB":"America/Argentina/Salta","DPE":"Europe/Paris","DPG":"America/Denver","DPK":"America/New_York","DPL":"Asia/Manila","DPO":"Australia/Hobart","DPS":"Asia/Makassar","DPT":"Asia/Vladivostok","DPU":"Pacific/Port_Moresby","DQA":"Asia/Shanghai","DQM":"Asia/Muscat","DQO":"America/Chicago","DRA":"America/Los_Angeles","DRB":"Australia/Perth","DRC":"Africa/Luanda","DRD":"Australia/Brisbane","DRE":"America/New_York","DRF":"America/Anchorage","DRG":"America/Anchorage","DRH":"Asia/Jayapura","DRI":"America/Chicago","DRJ":"America/Paramaribo","DRK":"America/Costa_Rica","DRM":"Europe/Athens","DRN":"Australia/Brisbane","DRO":"America/Denver","DRR":"Australia/Brisbane","DRS":"Europe/Berlin","DRT":"America/Chicago","DRU":"America/Denver","DRV":"Indian/Maldives","DRW":"Australia/Darwin","DRY":"Australia/Perth","DSA":"Europe/London","DSC":"Africa/Douala","DSD":"America/Guadeloupe","DSE":"Africa/Addis_Ababa","DSG":"Asia/Manila","DSI":"America/Chicago","DSK":"Asia/Karachi","DSL":"Africa/Freetown","DSM":"America/Chicago","DSN":"Asia/Shanghai","DSS":"Africa/Dakar","DSV":"America/New_York","DSX":"Asia/Taipei","DTA":"America/Denver","DTB":"Asia/Jakarta","DTD":"Asia/Makassar","DTE":"Asia/Manila","DTH":"America/Los_Angeles","DTI":"America/Sao_Paulo","DTL":"America/Chicago","DTM":"Europe/Berlin","DTN":"America/Chicago","DTR":"America/Los_Angeles","DTU":"Asia/Shanghai","DTW":"America/New_York","DUA":"America/Chicago","DUB":"Europe/Dublin","DUC":"America/Chicago","DUD":"Pacific/Auckland","DUE":"Africa/Luanda","DUF":"America/New_York","DUG":"America/Phoenix","DUH":"Europe/Tirane","DUJ":"America/New_York","DUK":"Africa/Johannesburg","DUM":"Asia/Jakarta","DUN":"America/Godthab","DUQ":"America/Vancouver","DUR":"Africa/Johannesburg","DUS":"Europe/Berlin","DUT":"America/Anchorage","DVA":"Europe/Bucharest","DVD":"Indian/Antananarivo","DVK":"America/Edmonton","DVL":"America/Chicago","DVN":"America/Chicago","DVO":"Asia/Manila","DVP":"Australia/Brisbane","DVR":"Australia/Darwin","DVT":"America/Phoenix","DWA":"Africa/Blantyre","DWB":"Indian/Antananarivo","DWC":"Asia/Dubai","DWD":"Asia/Riyadh","DWF":"America/New_York","DWH":"America/Chicago","DWN":"America/Chicago","DWO":"Asia/Colombo","DWR":"Asia/Kabul","DWS":"America/New_York","DXA":"Europe/Paris","DXB":"Asia/Dubai","DXD":"Australia/Brisbane","DXE":"America/Chicago","DXR":"America/New_York","DYA":"Australia/Brisbane","DYG":"Asia/Shanghai","DYL":"America/New_York","DYM":"Australia/Brisbane","DYR":"Asia/Anadyr","DYS":"America/Chicago","DYU":"Asia/Dushanbe","DYW":"Australia/Darwin","DZA":"Indian/Mayotte","DZI":"America/Bogota","DZN":"Asia/Almaty","DZO":"America/Montevideo","DZU":"Asia/Shanghai","EAA":"America/Anchorage","EAB":"Asia/Aden","EAE":"Pacific/Efate","EAL":"Pacific/Majuro","EAM":"Asia/Riyadh","EAN":"America/Denver","EAR":"America/Chicago","EAS":"Europe/Madrid","EAT":"America/Los_Angeles","EAU":"America/Chicago","EBA":"Europe/Rome","EBB":"Africa/Kampala","EBD":"Africa/Khartoum","EBG":"America/Bogota","EBH":"Africa/Algiers","EBJ":"Europe/Copenhagen","EBL":"Asia/Baghdad","EBM":"Africa/Tunis","EBN":"Pacific/Majuro","EBO":"Pacific/Majuro","EBR":"America/Chicago","EBS":"America/Chicago","EBU":"Europe/Paris","EBW":"Africa/Douala","ECA":"America/New_York","ECG":"America/New_York","ECH":"Australia/Sydney","ECI":"America/Managua","ECN":"Asia/Famagusta","ECO":"America/Bogota","ECP":"America/Chicago","ECR":"America/Bogota","ECS":"America/Denver","EDA":"America/Anchorage","EDB":"Africa/Khartoum","EDC":"America/Chicago","EDD":"Australia/Darwin","EDE":"America/New_York","EDF":"America/Anchorage","EDG":"America/New_York","EDI":"Europe/London","EDK":"America/Chicago","EDL":"Africa/Nairobi","EDM":"Europe/Paris","EDN":"Asia/Vladivostok","EDO":"Europe/Istanbul","EDQ":"America/Tegucigalpa","EDR":"Australia/Brisbane","EDW":"America/Los_Angeles","EED":"America/Los_Angeles","EEK":"America/Anchorage","EEN":"America/New_York","EFB":"America/Anchorage","EFD":"America/Chicago","EFG":"Pacific/Port_Moresby","EFK":"America/New_York","EFL":"Europe/Athens","EFW":"America/Chicago","EGA":"Pacific/Port_Moresby","EGC":"Europe/Paris","EGE":"America/Denver","EGI":"America/Chicago","EGL":"Africa/Addis_Ababa","EGM":"Pacific/Guadalcanal","EGN":"Africa/Khartoum","EGO":"Europe/Moscow","EGP":"America/Chicago","EGS":"Atlantic/Reykjavik","EGV":"America/Chicago","EGX":"America/Anchorage","EHL":"America/Argentina/Buenos_Aires","EHM":"America/Anchorage","EIA":"Pacific/Port_Moresby","EIB":"Europe/Berlin","EIE":"Asia/Krasnoyarsk","EIH":"Australia/Brisbane","EIL":"America/Anchorage","EIN":"Europe/Amsterdam","EIS":"America/Tortola","EIY":"Asia/Jerusalem","EJA":"America/Bogota","EJH":"Asia/Riyadh","EJN":"Asia/Shanghai","EJT":"Pacific/Majuro","EKA":"America/Los_Angeles","EKB":"Asia/Almaty","EKD":"Australia/Darwin","EKE":"America/Guyana","EKI":"America/Indiana/Indianapolis","EKN":"America/New_York","EKO":"America/Los_Angeles","EKS":"Asia/Magadan","EKT":"Europe/Stockholm","EKX":"America/New_York","ELA":"America/Chicago","ELB":"America/Bogota","ELC":"Australia/Darwin","ELD":"America/Chicago","ELE":"America/Panama","ELF":"Africa/Khartoum","ELG":"Africa/Algiers","ELH":"America/Nassau","ELI":"America/Anchorage","ELJ":"America/Bogota","ELK":"America/Chicago","ELL":"Africa/Johannesburg","ELM":"America/New_York","ELN":"America/Los_Angeles","ELO":"America/Argentina/Buenos_Aires","ELP":"America/Denver","ELQ":"Asia/Riyadh","ELR":"Asia/Jayapura","ELS":"Africa/Johannesburg","ELT":"Africa/Cairo","ELU":"Africa/Algiers","ELV":"America/Anchorage","ELW":"America/Anchorage","ELX":"America/Caracas","ELY":"America/Los_Angeles","ELZ":"America/New_York","EMA":"Europe/London","EMB":"America/Los_Angeles","EMD":"Australia/Brisbane","EME":"Europe/Berlin","EMG":"Africa/Johannesburg","EMI":"Pacific/Port_Moresby","EMK":"America/Anchorage","EML":"Europe/Zurich","EMM":"America/Denver","EMN":"Africa/Nouakchott","EMO":"Pacific/Port_Moresby","EMP":"America/Chicago","EMR":"America/Guatemala","EMS":"Pacific/Port_Moresby","EMT":"America/Los_Angeles","EMX":"America/Argentina/Buenos_Aires","EMY":"Africa/Cairo","ENA":"America/Anchorage","ENB":"Australia/Perth","ENC":"Europe/Paris","END":"America/Chicago","ENE":"Asia/Makassar","ENF":"Europe/Helsinki","ENH":"Asia/Shanghai","ENI":"Asia/Manila","ENJ":"America/Guatemala","ENK":"Europe/London","ENL":"America/Chicago","ENN":"America/Anchorage","ENO":"America/Asuncion","ENQ":"America/Tegucigalpa","ENS":"Europe/Amsterdam","ENT":"Pacific/Majuro","ENU":"Africa/Lagos","ENV":"America/Denver","ENW":"America/Chicago","ENY":"Asia/Shanghai","EOH":"America/Bogota","EOI":"Europe/London","EOK":"America/Chicago","EOR":"America/Caracas","EOS":"America/Chicago","EOZ":"America/Caracas","EPA":"America/Argentina/Buenos_Aires","EPG":"America/Chicago","EPH":"America/Los_Angeles","EPI":"Pacific/Efate","EPK":"Asia/Nicosia","EPL":"Europe/Paris","EPN":"Africa/Brazzaville","EPR":"Australia/Perth","EPS":"America/Santo_Domingo","EPT":"Pacific/Port_Moresby","EPU":"Europe/Tallinn","EQS":"America/Argentina/Buenos_Aires","ERA":"Africa/Mogadishu","ERB":"Australia/Adelaide","ERC":"Europe/Istanbul","ERD":"Europe/Kiev","ERE":"Pacific/Port_Moresby","ERF":"Europe/Berlin","ERG":"Asia/Irkutsk","ERH":"Africa/Casablanca","ERI":"America/New_York","ERL":"Asia/Shanghai","ERM":"America/Sao_Paulo","ERN":"America/Eirunepe","ERO":"America/Anchorage","ERQ":"Australia/Brisbane","ERR":"America/New_York","ERS":"Africa/Windhoek","ERT":"Asia/Ulaanbaatar","ERU":"Pacific/Port_Moresby","ERV":"America/Chicago","ERZ":"Europe/Istanbul","ESA":"Pacific/Port_Moresby","ESB":"Europe/Istanbul","ESC":"America/New_York","ESD":"America/Los_Angeles","ESE":"America/Tijuana","ESF":"America/Chicago","ESG":"America/Asuncion","ESH":"Europe/London","ESI":"America/Sao_Paulo","ESK":"Europe/Istanbul","ESL":"Europe/Moscow","ESM":"America/Guayaquil","ESN":"America/New_York","ESO":"America/Denver","ESP":"America/New_York","ESR":"America/Santiago","ESS":"Europe/Berlin","EST":"America/Chicago","ESU":"Africa/Casablanca","ESW":"America/Los_Angeles","ETB":"America/Chicago","ETD":"Australia/Adelaide","ETE":"Africa/Addis_Ababa","ETH":"Asia/Jerusalem","ETL":"Asia/Vladivostok","ETM":"Asia/Jerusalem","ETN":"America/Chicago","ETR":"America/Guayaquil","ETS":"America/Chicago","ETZ":"Europe/Paris","EUA":"Pacific/Tongatapu","EUC":"Australia/Perth","EUE":"America/Los_Angeles","EUF":"America/Chicago","EUG":"America/Los_Angeles","EUM":"Europe/Berlin","EUN":"Africa/Casablanca","EUQ":"Asia/Manila","EUX":"America/Curacao","EVA":"America/Chicago","EVD":"Australia/Darwin","EVE":"Europe/Oslo","EVG":"Europe/Stockholm","EVH":"Australia/Sydney","EVM":"America/Chicago","EVN":"Asia/Yerevan","EVV":"America/Chicago","EVW":"America/Denver","EVX":"Europe/Paris","EWB":"America/New_York","EWD":"America/Anchorage","EWE":"Asia/Jayapura","EWI":"Asia/Jayapura","EWK":"America/Chicago","EWN":"America/New_York","EWO":"Africa/Brazzaville","EWR":"America/New_York","EWY":"Europe/London","EXI":"America/Anchorage","EXM":"Australia/Perth","EXT":"Europe/London","EYK":"Asia/Yekaterinburg","EYL":"Africa/Bamako","EYP":"America/Bogota","EYR":"America/Los_Angeles","EYS":"Africa/Nairobi","EYW":"America/New_York","EZE":"America/Argentina/Buenos_Aires","EZS":"Europe/Istanbul","EZV":"Asia/Yekaterinburg","FAA":"Africa/Conakry","FAB":"Europe/London","FAC":"Pacific/Tahiti","FAE":"Atlantic/Faroe","FAF":"America/New_York","FAG":"Atlantic/Reykjavik","FAH":"Asia/Kabul","FAI":"America/Anchorage","FAJ":"America/Puerto_Rico","FAK":"America/Anchorage","FAL":"America/Chicago","FAM":"America/Chicago","FAN":"Europe/Oslo","FAO":"Europe/Lisbon","FAQ":"Pacific/Port_Moresby","FAR":"America/Chicago","FAS":"Atlantic/Reykjavik","FAT":"America/Los_Angeles","FAU":"Asia/Muscat","FAV":"Pacific/Tahiti","FAY":"America/New_York","FAZ":"Asia/Tehran","FBA":"America/Porto_Velho","FBD":"Asia/Kabul","FBE":"America/Sao_Paulo","FBG":"America/New_York","FBK":"America/Anchorage","FBL":"America/Chicago","FBM":"Africa/Lubumbashi","FBR":"America/Denver","FBS":"America/Los_Angeles","FBY":"America/Chicago","FCA":"America/Denver","FCB":"Africa/Johannesburg","FCH":"America/Los_Angeles","FCM":"America/Chicago","FCN":"Europe/Berlin","FCO":"Europe/Rome","FCS":"America/Denver","FCT":"America/Los_Angeles","FCY":"America/Chicago","FDB":"America/Campo_Grande","FDE":"Europe/Oslo","FDF":"America/Martinique","FDH":"Europe/Berlin","FDK":"America/New_York","FDR":"America/Chicago","FDU":"Africa/Kinshasa","FDY":"America/New_York","FEA":"Europe/London","FEB":"Asia/Kathmandu","FEC":"America/Belem","FEG":"Asia/Tashkent","FEJ":"America/Rio_Branco","FEK":"Africa/Abidjan","FEL":"Europe/Berlin","FEN":"America/Noronha","FEP":"America/Chicago","FES":"Europe/Madrid","FET":"America/Chicago","FEW":"America/Denver","FEZ":"Africa/Casablanca","FFA":"America/New_York","FFD":"Europe/London","FFL":"America/Chicago","FFM":"America/Chicago","FFO":"America/New_York","FFT":"America/New_York","FFU":"America/Santiago","FGD":"Africa/Nouakchott","FGI":"Pacific/Apia","FGL":"Pacific/Auckland","FGR":"Europe/Madrid","FGU":"Pacific/Tahiti","FHU":"America/Phoenix","FHZ":"Pacific/Tahiti","FIC":"America/Anchorage","FID":"America/New_York","FIE":"Europe/London","FIG":"Africa/Conakry","FIH":"Africa/Kinshasa","FIK":"Australia/Darwin","FIL":"America/Denver","FIN":"Pacific/Port_Moresby","FIV":"America/Anchorage","FIZ":"Australia/Perth","FJR":"Asia/Dubai","FKB":"Europe/Berlin","FKH":"Europe/London","FKI":"Africa/Lubumbashi","FKJ":"Asia/Tokyo","FKL":"America/New_York","FKN":"America/New_York","FKQ":"Asia/Jayapura","FKS":"Asia/Tokyo","FLA":"America/Bogota","FLB":"America/Belem","FLC":"Australia/Sydney","FLD":"America/Chicago","FLF":"Europe/Berlin","FLG":"America/Phoenix","FLH":"Europe/London","FLI":"Atlantic/Reykjavik","FLJ":"America/Anchorage","FLL":"America/New_York","FLM":"America/Asuncion","FLN":"America/Sao_Paulo","FLO":"America/New_York","FLP":"America/Chicago","FLR":"Europe/Rome","FLS":"Australia/Hobart","FLT":"America/Anchorage","FLV":"America/Chicago","FLW":"Atlantic/Azores","FLX":"America/Los_Angeles","FLY":"Australia/Sydney","FLZ":"Asia/Jakarta","FMA":"America/Argentina/Buenos_Aires","FMC":"America/Anchorage","FME":"America/New_York","FMG":"America/Costa_Rica","FMH":"America/New_York","FMI":"Africa/Lubumbashi","FMM":"Europe/Berlin","FMN":"America/Denver","FMO":"Europe/Berlin","FMS":"America/Chicago","FMU":"America/Los_Angeles","FMY":"America/New_York","FNA":"Africa/Freetown","FNB":"Europe/Berlin","FNC":"Europe/Lisbon","FND":"Indian/Maldives","FNE":"Pacific/Port_Moresby","FNG":"Africa/Ouagadougou","FNH":"Africa/Addis_Ababa","FNI":"Europe/Paris","FNJ":"Asia/Pyongyang","FNK":"America/Anchorage","FNL":"America/Denver","FNR":"America/Anchorage","FNT":"America/New_York","FOA":"Europe/London","FOB":"America/Los_Angeles","FOC":"Asia/Shanghai","FOD":"America/Chicago","FOE":"America/Chicago","FOG":"Europe/Rome","FOK":"America/New_York","FOM":"Africa/Douala","FON":"America/Costa_Rica","FOO":"Asia/Jayapura","FOP":"America/New_York","FOR":"America/Belem","FOS":"Australia/Perth","FOT":"Australia/Sydney","FOU":"Africa/Libreville","FOX":"America/Anchorage","FOY":"Africa/Monrovia","FPO":"America/Nassau","FPR":"America/New_York","FPY":"America/New_York","FRA":"Europe/Berlin","FRB":"Australia/Sydney","FRC":"America/Sao_Paulo","FRD":"America/Los_Angeles","FRE":"Pacific/Guadalcanal","FRG":"America/New_York","FRH":"America/Indiana/Indianapolis","FRI":"America/Chicago","FRJ":"Europe/Paris","FRK":"Indian/Mahe","FRL":"Europe/Rome","FRM":"America/Chicago","FRN":"America/Anchorage","FRO":"Europe/Oslo","FRP":"America/Anchorage","FRQ":"Pacific/Port_Moresby","FRR":"America/New_York","FRS":"America/Guatemala","FRT":"America/Santiago","FRU":"Asia/Bishkek","FRW":"Africa/Gaborone","FRY":"America/New_York","FRZ":"Europe/Berlin","FSC":"Europe/Paris","FSD":"America/Chicago","FSI":"America/Chicago","FSK":"America/Chicago","FSL":"Australia/Perth","FSM":"America/Chicago","FSN":"America/Chicago","FSP":"America/Miquelon","FSS":"Europe/London","FST":"America/Chicago","FSU":"America/Denver","FSZ":"Asia/Tokyo","FTA":"Pacific/Efate","FTE":"America/Argentina/Buenos_Aires","FTI":"Pacific/Pago_Pago","FTK":"America/Chicago","FTL":"America/Anchorage","FTU":"Indian/Antananarivo","FTW":"America/Chicago","FTX":"Africa/Brazzaville","FTY":"America/New_York","FUB":"Pacific/Port_Moresby","FUD":"Asia/Shanghai","FUE":"Atlantic/Canary","FUG":"Asia/Shanghai","FUJ":"Asia/Tokyo","FUK":"Asia/Tokyo","FUL":"America/Los_Angeles","FUM":"Pacific/Port_Moresby","FUN":"Pacific/Funafuti","FUO":"Asia/Shanghai","FUP":"Europe/Stockholm","FUT":"Pacific/Wallis","FVL":"Australia/Perth","FVM":"Indian/Maldives","FVR":"Australia/Perth","FWA":"America/Indiana/Indianapolis","FWH":"America/Chicago","FWL":"America/Anchorage","FWM":"Europe/London","FXE":"America/New_York","FXM":"America/Anchorage","FXO":"Africa/Maputo","FXY":"America/Chicago","FYJ":"Asia/Shanghai","FYM":"America/Chicago","FYN":"Asia/Shanghai","FYT":"Africa/Ndjamena","FYU":"America/Anchorage","FYV":"America/Chicago","FZO":"Europe/London","GAA":"America/Bogota","GAB":"America/Los_Angeles","GAC":"America/Tegucigalpa","GAD":"America/Chicago","GAE":"Africa/Tunis","GAF":"Africa/Tunis","GAG":"America/Chicago","GAH":"Australia/Brisbane","GAI":"America/New_York","GAJ":"Asia/Tokyo","GAK":"America/Anchorage","GAL":"America/Anchorage","GAM":"America/Anchorage","GAN":"Indian/Maldives","GAO":"America/Havana","GAP":"Pacific/Port_Moresby","GAQ":"Africa/Bamako","GAR":"Pacific/Port_Moresby","GAS":"Africa/Nairobi","GAT":"Europe/Paris","GAU":"Asia/Kolkata","GAV":"Asia/Jayapura","GAW":"Asia/Yangon","GAX":"Africa/Libreville","GAY":"Asia/Kolkata","GAZ":"Pacific/Port_Moresby","GBA":"Pacific/Efate","GBB":"Asia/Baku","GBC":"Pacific/Port_Moresby","GBD":"America/Chicago","GBE":"Africa/Gaborone","GBF":"Pacific/Port_Moresby","GBG":"America/Chicago","GBH":"America/Anchorage","GBI":"Asia/Kolkata","GBJ":"America/Guadeloupe","GBK":"Africa/Freetown","GBL":"Australia/Darwin","GBM":"Africa/Mogadishu","GBO":"America/New_York","GBP":"Australia/Brisbane","GBR":"America/New_York","GBS":"Pacific/Auckland","GBT":"Asia/Tehran","GBU":"Africa/Khartoum","GBV":"Australia/Perth","GBW":"Australia/Perth","GBZ":"Pacific/Auckland","GCA":"America/Bogota","GCC":"America/Denver","GCH":"Asia/Tehran","GCI":"Europe/London","GCJ":"Africa/Johannesburg","GCK":"America/Chicago","GCM":"America/Cayman","GCN":"America/Phoenix","GCT":"America/Phoenix","GCV":"America/Sao_Paulo","GCW":"America/Phoenix","GCY":"America/Chicago","GDA":"Africa/Bangui","GDC":"America/New_York","GDD":"Australia/Perth","GDE":"Africa/Addis_Ababa","GDG":"Asia/Yakutsk","GDH":"America/Anchorage","GDI":"Africa/Bangui","GDJ":"Africa/Kinshasa","GDL":"America/Mexico_City","GDM":"America/New_York","GDN":"Europe/Warsaw","GDO":"America/Caracas","GDP":"America/Belem","GDQ":"Africa/Addis_Ababa","GDT":"America/Grand_Turk","GDV":"America/Denver","GDW":"America/New_York","GDX":"Asia/Magadan","GDZ":"Europe/Moscow","GEA":"Pacific/Noumea","GEB":"Asia/Jayapura","GEC":"Asia/Famagusta","GED":"America/New_York","GEE":"Australia/Hobart","GEF":"Pacific/Guadalcanal","GEG":"America/Los_Angeles","GEI":"Pacific/Bougainville","GEK":"America/Anchorage","GEL":"America/Sao_Paulo","GEM":"Africa/Lagos","GEN":"Europe/Madrid","GEO":"America/Guyana","GER":"America/Havana","GES":"Asia/Manila","GET":"Australia/Perth","GEV":"Europe/Stockholm","GEW":"Pacific/Port_Moresby","GEX":"Australia/Sydney","GEY":"America/Denver","GFA":"America/Denver","GFB":"America/Anchorage","GFD":"America/Indiana/Indianapolis","GFE":"Australia/Sydney","GFF":"Australia/Sydney","GFK":"America/Chicago","GFL":"America/New_York","GFN":"Australia/Sydney","GFO":"America/Guyana","GFR":"Europe/Paris","GFY":"Africa/Windhoek","GGB":"America/Cuiaba","GGC":"Africa/Luanda","GGD":"Australia/Brisbane","GGE":"America/New_York","GGF":"America/Santarem","GGG":"America/Chicago","GGH":"America/Campo_Grande","GGJ":"America/Sao_Paulo","GGL":"America/Bogota","GGM":"Africa/Nairobi","GGN":"Africa/Abidjan","GGO":"Africa/Abidjan","GGR":"Africa/Mogadishu","GGS":"America/Argentina/Buenos_Aires","GGT":"America/Nassau","GGW":"America/Denver","GHA":"Africa/Algiers","GHB":"America/Nassau","GHC":"America/Nassau","GHD":"Africa/Addis_Ababa","GHE":"America/Panama","GHF":"Europe/Berlin","GHK":"Asia/Jerusalem","GHM":"America/Chicago","GHN":"Asia/Shanghai","GHS":"Asia/Makassar","GHT":"Africa/Tripoli","GHU":"America/Argentina/Buenos_Aires","GIB":"Europe/Gibraltar","GIC":"Australia/Brisbane","GID":"Africa/Bujumbura","GIF":"America/New_York","GIG":"America/Sao_Paulo","GII":"Africa/Conakry","GIL":"Asia/Karachi","GIM":"Africa/Libreville","GIR":"America/Bogota","GIS":"Pacific/Auckland","GIT":"Africa/Dar_es_Salaam","GIU":"Asia/Colombo","GIY":"Africa/Johannesburg","GIZ":"Asia/Riyadh","GJA":"America/Tegucigalpa","GJL":"Africa/Algiers","GJM":"America/Porto_Velho","GJR":"Atlantic/Reykjavik","GJT":"America/Denver","GKA":"Pacific/Port_Moresby","GKE":"Europe/Berlin","GKH":"Asia/Kathmandu","GKK":"Indian/Maldives","GKL":"Australia/Brisbane","GKN":"America/Anchorage","GKO":"Africa/Libreville","GKT":"America/New_York","GLA":"Europe/London","GLC":"Africa/Addis_Ababa","GLD":"America/Denver","GLE":"America/Chicago","GLF":"America/Costa_Rica","GLG":"Australia/Brisbane","GLH":"America/Chicago","GLI":"Australia/Sydney","GLK":"Africa/Mogadishu","GLL":"Europe/Oslo","GLM":"Australia/Brisbane","GLN":"Africa/Casablanca","GLO":"Europe/London","GLP":"Pacific/Port_Moresby","GLQ":"America/Anchorage","GLR":"America/New_York","GLS":"America/Chicago","GLT":"Australia/Brisbane","GLU":"Asia/Thimphu","GLV":"America/Anchorage","GLW":"America/Chicago","GLX":"Asia/Jayapura","GLY":"Australia/Perth","GLZ":"Europe/Amsterdam","GMA":"Africa/Kinshasa","GMB":"Africa/Addis_Ababa","GMC":"America/Bogota","GMD":"Africa/Casablanca","GME":"Europe/Minsk","GMI":"Pacific/Port_Moresby","GMM":"Africa/Brazzaville","GMN":"Pacific/Auckland","GMO":"Africa/Lagos","GMP":"Asia/Seoul","GMQ":"Asia/Shanghai","GMR":"Pacific/Gambier","GMS":"America/Belem","GMT":"America/Anchorage","GMU":"America/New_York","GMV":"America/Denver","GMY":"Europe/Berlin","GMZ":"Atlantic/Canary","GNA":"Europe/Minsk","GNB":"Europe/Paris","GND":"America/Grenada","GNE":"Europe/Brussels","GNF":"America/Los_Angeles","GNG":"America/Denver","GNI":"Asia/Taipei","GNM":"America/Belem","GNN":"Africa/Addis_Ababa","GNR":"America/Argentina/Buenos_Aires","GNS":"Asia/Jakarta","GNT":"America/Denver","GNU":"America/Anchorage","GNV":"America/New_York","GNY":"Europe/Istanbul","GNZ":"Africa/Gaborone","GOA":"Europe/Rome","GOB":"Africa/Addis_Ababa","GOC":"Pacific/Port_Moresby","GOE":"Pacific/Port_Moresby","GOF":"America/Chicago","GOG":"Africa/Windhoek","GOH":"America/Godthab","GOI":"Asia/Kolkata","GOJ":"Europe/Moscow","GOK":"America/Chicago","GOL":"America/Los_Angeles","GOM":"Africa/Lubumbashi","GON":"America/New_York","GOO":"Australia/Brisbane","GOP":"Asia/Kolkata","GOQ":"Asia/Shanghai","GOR":"Africa/Addis_Ababa","GOS":"Australia/Sydney","GOT":"Europe/Stockholm","GOU":"Africa/Douala","GOV":"Australia/Darwin","GOZ":"Europe/Sofia","GPA":"Europe/Athens","GPB":"America/Sao_Paulo","GPD":"Australia/Brisbane","GPI":"America/Bogota","GPL":"America/Costa_Rica","GPN":"Australia/Darwin","GPO":"America/Argentina/Buenos_Aires","GPS":"Pacific/Galapagos","GPT":"America/Chicago","GPZ":"America/Chicago","GQJ":"Europe/London","GQQ":"America/New_York","GRA":"America/Bogota","GRB":"America/Chicago","GRC":"Africa/Monrovia","GRD":"America/New_York","GRE":"America/Chicago","GRF":"America/Los_Angeles","GRG":"Asia/Kabul","GRH":"Pacific/Port_Moresby","GRI":"America/Chicago","GRJ":"Africa/Johannesburg","GRK":"America/Chicago","GRL":"Pacific/Port_Moresby","GRM":"America/Chicago","GRN":"America/Denver","GRO":"Europe/Madrid","GRP":"America/Belem","GRQ":"Europe/Amsterdam","GRR":"America/New_York","GRS":"Europe/Rome","GRT":"Asia/Karachi","GRU":"America/Sao_Paulo","GRV":"Europe/Moscow","GRW":"Atlantic/Azores","GRX":"Europe/Madrid","GRY":"Atlantic/Reykjavik","GRZ":"Europe/Vienna","GSA":"Asia/Kuala_Lumpur","GSB":"America/New_York","GSC":"Australia/Perth","GSE":"Europe/Stockholm","GSH":"America/Indiana/Indianapolis","GSI":"Pacific/Guadalcanal","GSJ":"America/Guatemala","GSL":"America/Edmonton","GSM":"Asia/Tehran","GSN":"Australia/Adelaide","GSO":"America/New_York","GSP":"America/New_York","GSQ":"Africa/Cairo","GSR":"Africa/Mogadishu","GSS":"Africa/Johannesburg","GST":"America/Anchorage","GSU":"Africa/Khartoum","GSV":"Europe/Saratov","GSY":"Europe/London","GTA":"Pacific/Guadalcanal","GTB":"Asia/Kuala_Lumpur","GTC":"America/Nassau","GTE":"Australia/Darwin","GTF":"America/Denver","GTG":"America/Chicago","GTI":"Europe/Berlin","GTK":"Asia/Kuala_Lumpur","GTN":"Pacific/Auckland","GTO":"Asia/Makassar","GTP":"America/Los_Angeles","GTR":"America/Chicago","GTS":"Australia/Darwin","GTT":"Australia/Brisbane","GTW":"Europe/Prague","GTY":"America/New_York","GTZ":"Africa/Dar_es_Salaam","GUA":"America/Guatemala","GUB":"America/Mazatlan","GUC":"America/Denver","GUD":"Africa/Bamako","GUE":"Pacific/Port_Moresby","GUF":"America/Chicago","GUG":"Pacific/Port_Moresby","GUH":"Australia/Sydney","GUI":"America/Caracas","GUJ":"America/Sao_Paulo","GUL":"Australia/Sydney","GUM":"Pacific/Guam","GUO":"Africa/Mogadishu","GUP":"America/Denver","GUQ":"America/Caracas","GUR":"Pacific/Port_Moresby","GUS":"America/Indiana/Indianapolis","GUT":"Europe/Berlin","GUU":"Atlantic/Reykjavik","GUV":"Pacific/Port_Moresby","GUW":"Asia/Atyrau","GUX":"Asia/Kolkata","GUY":"America/Chicago","GUZ":"America/Sao_Paulo","GVA":"Europe/Zurich","GVE":"America/New_York","GVI":"Pacific/Port_Moresby","GVL":"America/New_York","GVP":"Australia/Brisbane","GVR":"America/Sao_Paulo","GVT":"America/Chicago","GVW":"America/Chicago","GVX":"Europe/Stockholm","GWA":"Asia/Yangon","GWD":"Asia/Karachi","GWE":"Africa/Harare","GWL":"Asia/Kolkata","GWN":"Pacific/Port_Moresby","GWO":"America/Chicago","GWS":"America/Denver","GWT":"Europe/Berlin","GWV":"America/New_York","GWW":"Europe/Berlin","GWY":"Europe/Dublin","GXA":"Asia/Jakarta","GXF":"Asia/Aden","GXG":"Africa/Luanda","GXH":"Asia/Shanghai","GXQ":"America/Santiago","GXX":"Africa/Douala","GXY":"America/Denver","GYA":"America/La_Paz","GYB":"Australia/Perth","GYD":"Asia/Baku","GYE":"America/Guayaquil","GYG":"Asia/Yakutsk","GYI":"Africa/Kigali","GYL":"Australia/Perth","GYM":"America/Hermosillo","GYN":"America/Sao_Paulo","GYP":"Australia/Brisbane","GYR":"America/Phoenix","GYS":"Asia/Shanghai","GYU":"Asia/Shanghai","GYZ":"Australia/Perth","GZA":"Asia/Gaza","GZG":"Asia/Shanghai","GZI":"Asia/Kabul","GZM":"Europe/Malta","GZO":"Pacific/Guadalcanal","GZP":"Europe/Istanbul","GZT":"Europe/Istanbul","GZW":"Asia/Tehran","HAA":"Europe/Oslo","HAB":"America/Chicago","HAC":"Asia/Tokyo","HAD":"Europe/Stockholm","HAE":"America/Phoenix","HAF":"America/Los_Angeles","HAH":"Indian/Comoro","HAI":"America/New_York","HAJ":"Europe/Berlin","HAK":"Asia/Shanghai","HAL":"Africa/Windhoek","HAM":"Europe/Berlin","HAN":"Asia/Ho_Chi_Minh","HAO":"America/New_York","HAP":"Australia/Brisbane","HAQ":"Indian/Maldives","HAR":"America/New_York","HAS":"Asia/Riyadh","HAT":"Australia/Brisbane","HAU":"Europe/Oslo","HAV":"America/Havana","HAW":"Europe/London","HAX":"America/Chicago","HAY":"America/Anchorage","HAZ":"Pacific/Port_Moresby","HBA":"Australia/Hobart","HBB":"America/Denver","HBC":"America/Anchorage","HBD":"Pacific/Port_Moresby","HBE":"Africa/Cairo","HBG":"America/Chicago","HBH":"America/Anchorage","HBI":"America/Nassau","HBK":"America/Phoenix","HBN":"Asia/Ho_Chi_Minh","HBO":"America/Chicago","HBQ":"Asia/Shanghai","HBR":"America/Chicago","HBT":"Asia/Colombo","HBU":"Asia/Ulaanbaatar","HBX":"Asia/Kolkata","HCA":"America/Chicago","HCB":"America/Anchorage","HCC":"America/New_York","HCJ":"Asia/Shanghai","HCM":"Africa/Mogadishu","HCN":"Asia/Taipei","HCQ":"Australia/Perth","HCR":"America/Anchorage","HCW":"America/New_York","HDA":"America/Anchorage","HDB":"Europe/Berlin","HDD":"Asia/Karachi","HDE":"America/Chicago","HDF":"Europe/Berlin","HDG":"Asia/Shanghai","HDH":"Pacific/Honolulu","HDK":"Indian/Maldives","HDM":"Asia/Tehran","HDN":"America/Denver","HDR":"Asia/Tehran","HDS":"Africa/Johannesburg","HDY":"Asia/Bangkok","HEA":"Asia/Kabul","HEB":"Asia/Yangon","HED":"America/Anchorage","HEE":"America/Chicago","HEH":"Asia/Yangon","HEI":"Europe/Berlin","HEK":"Asia/Shanghai","HEL":"Europe/Helsinki","HEM":"Europe/Helsinki","HEO":"Pacific/Port_Moresby","HER":"Europe/Athens","HES":"America/Los_Angeles","HET":"Asia/Shanghai","HEV":"Europe/Madrid","HEW":"Asia/Shanghai","HEX":"America/Santo_Domingo","HEY":"America/Chicago","HEZ":"America/Chicago","HFA":"Asia/Jerusalem","HFD":"America/New_York","HFE":"Asia/Shanghai","HFF":"America/New_York","HFN":"Atlantic/Reykjavik","HFS":"Europe/Stockholm","HFT":"Europe/Oslo","HGA":"Africa/Mogadishu","HGD":"Australia/Brisbane","HGE":"America/Caracas","HGH":"Asia/Shanghai","HGL":"Europe/Berlin","HGN":"Asia/Bangkok","HGO":"Africa/Abidjan","HGR":"America/New_York","HGS":"Africa/Freetown","HGT":"America/Los_Angeles","HGU":"Pacific/Port_Moresby","HGZ":"America/Anchorage","HHE":"Asia/Tokyo","HHH":"America/New_York","HHI":"Pacific/Honolulu","HHN":"Europe/Berlin","HHP":"Asia/Hong_Kong","HHQ":"Asia/Bangkok","HHR":"America/Los_Angeles","HHZ":"Pacific/Tahiti","HIA":"Asia/Shanghai","HIB":"America/Chicago","HID":"Australia/Brisbane","HIE":"America/New_York","HIF":"America/Denver","HIG":"Australia/Brisbane","HIH":"Australia/Brisbane","HII":"America/Phoenix","HIJ":"Asia/Tokyo","HIK":"Pacific/Honolulu","HIL":"Africa/Addis_Ababa","HIM":"Asia/Colombo","HIN":"Asia/Seoul","HIO":"America/Los_Angeles","HIP":"Australia/Brisbane","HIR":"Pacific/Guadalcanal","HIS":"Australia/Brisbane","HIT":"Pacific/Port_Moresby","HIW":"Asia/Tokyo","HJJ":"Asia/Shanghai","HJR":"Asia/Kolkata","HJT":"Asia/Ulaanbaatar","HKA":"America/Chicago","HKB":"America/Anchorage","HKD":"Asia/Tokyo","HKG":"Asia/Hong_Kong","HKK":"Pacific/Auckland","HKN":"Pacific/Port_Moresby","HKR":"Africa/Nairobi","HKS":"America/Chicago","HKT":"Asia/Bangkok","HKV":"Europe/Sofia","HKY":"America/New_York","HLA":"Africa/Johannesburg","HLB":"America/Indiana/Indianapolis","HLC":"America/Chicago","HLD":"Asia/Shanghai","HLE":"Atlantic/St_Helena","HLF":"Europe/Stockholm","HLG":"America/New_York","HLH":"Asia/Shanghai","HLI":"America/Los_Angeles","HLL":"Australia/Perth","HLM":"America/New_York","HLN":"America/Denver","HLP":"Asia/Jakarta","HLR":"America/Chicago","HLS":"Australia/Hobart","HLT":"Australia/Sydney","HLU":"Pacific/Noumea","HLV":"Australia/Brisbane","HLW":"Africa/Johannesburg","HLY":"Europe/London","HLZ":"Pacific/Auckland","HMA":"Asia/Yekaterinburg","HMB":"Africa/Cairo","HME":"Africa/Algiers","HMG":"Australia/Darwin","HMI":"Asia/Shanghai","HMJ":"Europe/Kiev","HMN":"America/Denver","HMO":"America/Hermosillo","HMR":"Europe/Oslo","HMS":"America/Anchorage","HMT":"America/Los_Angeles","HMV":"Europe/Stockholm","HMY":"Asia/Seoul","HNA":"Asia/Tokyo","HNB":"America/Indiana/Indianapolis","HNC":"America/New_York","HND":"Asia/Tokyo","HNE":"America/Anchorage","HNG":"Pacific/Noumea","HNH":"America/Anchorage","HNI":"Pacific/Port_Moresby","HNK":"Australia/Brisbane","HNL":"Pacific/Honolulu","HNM":"Pacific/Honolulu","HNN":"Pacific/Port_Moresby","HNS":"America/Anchorage","HNX":"America/Denver","HNY":"Asia/Shanghai","HOA":"Africa/Nairobi","HOB":"America/Denver","HOC":"Pacific/Port_Moresby","HOD":"Asia/Aden","HOE":"Asia/Vientiane","HOF":"Asia/Riyadh","HOG":"America/Havana","HOH":"Europe/Vienna","HOI":"Pacific/Tahiti","HOK":"Australia/Darwin","HOL":"America/Anchorage","HOM":"America/Anchorage","HON":"America/Chicago","HOO":"Asia/Ho_Chi_Minh","HOP":"America/Chicago","HOQ":"Europe/Berlin","HOR":"Atlantic/Azores","HOS":"America/Argentina/Buenos_Aires","HOT":"America/Chicago","HOU":"America/Chicago","HOV":"Europe/Oslo","HOX":"Asia/Yangon","HOY":"Europe/London","HPA":"Pacific/Tongatapu","HPB":"America/Anchorage","HPE":"Australia/Brisbane","HPG":"Asia/Shanghai","HPH":"Asia/Ho_Chi_Minh","HPN":"America/New_York","HPT":"America/Chicago","HPV":"Pacific/Honolulu","HPY":"America/Chicago","HQM":"America/Los_Angeles","HRA":"Asia/Karachi","HRB":"Asia/Shanghai","HRC":"Asia/Almaty","HRE":"Africa/Harare","HRG":"Africa/Cairo","HRI":"Asia/Colombo","HRK":"Europe/Kiev","HRL":"America/Chicago","HRM":"Africa/Algiers","HRN":"Australia/Brisbane","HRO":"America/Chicago","HRR":"America/Bogota","HRS":"Africa/Johannesburg","HRT":"Europe/London","HRY":"Australia/Darwin","HRZ":"America/Sao_Paulo","HSB":"America/Chicago","HSC":"Asia/Shanghai","HSG":"Asia/Tokyo","HSH":"America/Los_Angeles","HSI":"America/Chicago","HSK":"Europe/Madrid","HSL":"America/Anchorage","HSM":"Australia/Sydney","HSN":"Asia/Shanghai","HSP":"America/New_York","HSS":"Asia/Kolkata","HST":"America/New_York","HSV":"America/Chicago","HSZ":"Asia/Taipei","HTA":"Asia/Yakutsk","HTB":"America/Guadeloupe","HTF":"Europe/London","HTG":"Asia/Krasnoyarsk","HTH":"America/Los_Angeles","HTI":"Australia/Brisbane","HTL":"America/New_York","HTM":"Asia/Ulaanbaatar","HTN":"Asia/Shanghai","HTO":"America/New_York","HTR":"Asia/Tokyo","HTS":"America/New_York","HTT":"Asia/Shanghai","HTU":"Australia/Sydney","HTV":"America/Chicago","HTW":"America/New_York","HTY":"Europe/Istanbul","HTZ":"America/Bogota","HUA":"America/Chicago","HUB":"Australia/Darwin","HUC":"America/Puerto_Rico","HUD":"America/Chicago","HUE":"Africa/Addis_Ababa","HUF":"America/Indiana/Indianapolis","HUG":"America/Guatemala","HUH":"Pacific/Tahiti","HUI":"Asia/Ho_Chi_Minh","HUJ":"America/Chicago","HUK":"Africa/Gaborone","HUL":"America/New_York","HUM":"America/Chicago","HUN":"Asia/Taipei","HUO":"Asia/Shanghai","HUQ":"Africa/Tripoli","HUS":"America/Anchorage","HUT":"America/Chicago","HUU":"America/Lima","HUV":"Europe/Stockholm","HUW":"America/Porto_Velho","HUX":"America/Mexico_City","HUY":"Europe/London","HUZ":"Asia/Shanghai","HVA":"Indian/Antananarivo","HVB":"Australia/Brisbane","HVD":"Asia/Ulaanbaatar","HVE":"America/Denver","HVG":"Europe/Oslo","HVK":"Atlantic/Reykjavik","HVM":"Atlantic/Reykjavik","HVN":"America/New_York","HVR":"America/Denver","HVS":"America/New_York","HWA":"Pacific/Port_Moresby","HWD":"America/Los_Angeles","HWI":"America/Anchorage","HWK":"Australia/Adelaide","HWN":"Africa/Harare","HWO":"America/New_York","HXD":"Asia/Shanghai","HXX":"Australia/Sydney","HYA":"America/New_York","HYC":"Europe/London","HYD":"Asia/Kolkata","HYF":"Pacific/Port_Moresby","HYG":"America/Anchorage","HYL":"America/Anchorage","HYN":"Asia/Shanghai","HYR":"America/Chicago","HYS":"America/Chicago","HYV":"Europe/Helsinki","HZB":"Europe/Paris","HZG":"Asia/Shanghai","HZH":"Asia/Shanghai","HZK":"Atlantic/Reykjavik","HZL":"America/New_York","HZP":"America/Edmonton","HZV":"Africa/Johannesburg","IAA":"Asia/Krasnoyarsk","IAB":"America/Chicago","IAD":"America/New_York","IAG":"America/New_York","IAH":"America/Chicago","IAM":"Africa/Algiers","IAN":"America/Anchorage","IAO":"Asia/Manila","IAQ":"Asia/Tehran","IAR":"Europe/Moscow","IAS":"Europe/Bucharest","IAU":"Pacific/Port_Moresby","IBA":"Africa/Lagos","IBE":"America/Bogota","IBI":"Pacific/Port_Moresby","IBO":"Africa/Maputo","IBP":"America/Lima","IBR":"Asia/Tokyo","IBZ":"Europe/Madrid","ICA":"America/Caracas","ICI":"Pacific/Fiji","ICK":"America/Paramaribo","ICL":"America/Chicago","ICN":"Asia/Seoul","ICO":"Asia/Manila","ICR":"America/Havana","ICT":"America/Chicago","ICY":"America/Anchorage","IDA":"America/Denver","IDB":"Europe/Stockholm","IDF":"Africa/Kinshasa","IDG":"America/Chicago","IDI":"America/New_York","IDK":"Australia/Adelaide","IDN":"Pacific/Port_Moresby","IDO":"America/Belem","IDP":"America/Chicago","IDR":"Asia/Kolkata","IDY":"Europe/Paris","IEG":"Europe/Warsaw","IEJ":"Asia/Tokyo","IES":"Europe/Berlin","IEV":"Europe/Kiev","IFA":"America/Chicago","IFF":"Australia/Brisbane","IFH":"Asia/Tehran","IFJ":"Atlantic/Reykjavik","IFL":"Australia/Brisbane","IFN":"Asia/Tehran","IFO":"Europe/Kiev","IFP":"America/Phoenix","IFU":"Indian/Maldives","IGA":"America/Nassau","IGB":"America/Argentina/Buenos_Aires","IGD":"Europe/Istanbul","IGE":"Africa/Libreville","IGG":"America/Anchorage","IGH":"Australia/Brisbane","IGL":"Europe/Istanbul","IGM":"America/Phoenix","IGN":"Asia/Manila","IGO":"America/Bogota","IGR":"America/Argentina/Buenos_Aires","IGS":"Europe/Berlin","IGT":"Europe/Moscow","IGU":"America/Sao_Paulo","IHA":"Asia/Tokyo","IHC":"Africa/Maputo","IHN":"Asia/Aden","IHO":"Indian/Antananarivo","IHR":"Asia/Tehran","IHU":"Pacific/Port_Moresby","IIA":"Europe/Dublin","IIL":"Asia/Tehran","IIN":"Asia/Tokyo","IIS":"Pacific/Bougainville","IJK":"Europe/Samara","IJU":"America/Sao_Paulo","IJX":"America/Chicago","IKA":"Asia/Tehran","IKB":"America/New_York","IKE":"America/Godthab","IKI":"Asia/Tokyo","IKK":"America/Chicago","IKL":"Africa/Kinshasa","IKO":"America/Anchorage","IKP":"Australia/Brisbane","IKS":"Asia/Yakutsk","IKT":"Asia/Irkutsk","IKU":"Asia/Bishkek","ILA":"Asia/Jayapura","ILB":"America/Campo_Grande","ILD":"Europe/Madrid","ILE":"America/Chicago","ILF":"America/Winnipeg","ILG":"America/New_York","ILH":"Europe/Berlin","ILI":"America/Anchorage","ILK":"Indian/Antananarivo","ILL":"America/Chicago","ILM":"America/New_York","ILN":"America/New_York","ILO":"Asia/Manila","ILP":"Pacific/Noumea","ILQ":"America/Lima","ILR":"Africa/Lagos","ILS":"America/El_Salvador","ILU":"Africa/Nairobi","ILY":"Europe/London","ILZ":"Europe/Bratislava","IMA":"Pacific/Port_Moresby","IMB":"America/Guyana","IMD":"Pacific/Port_Moresby","IMF":"Asia/Kolkata","IMG":"Africa/Maputo","IMI":"Pacific/Majuro","IMK":"Asia/Kathmandu","IML":"America/Denver","IMM":"America/New_York","IMN":"Pacific/Port_Moresby","IMO":"Africa/Bangui","IMP":"America/Belem","IMT":"America/Chicago","IMZ":"Asia/Kabul","INA":"Europe/Moscow","INB":"America/Belize","INC":"Asia/Shanghai","IND":"America/Indiana/Indianapolis","INE":"Africa/Maputo","INF":"Africa/Algiers","ING":"America/Argentina/Buenos_Aires","INH":"Africa/Maputo","INI":"Europe/Belgrade","INJ":"Australia/Brisbane","INK":"America/Chicago","INL":"America/Chicago","INM":"Australia/Adelaide","INN":"Europe/Vienna","INO":"Africa/Kinshasa","INQ":"Europe/Dublin","INS":"America/Los_Angeles","INT":"America/New_York","INU":"Pacific/Nauru","INV":"Europe/London","INW":"America/Phoenix","INX":"Asia/Jayapura","INY":"Africa/Johannesburg","INZ":"Africa/Algiers","IOA":"Europe/Athens","IOK":"Pacific/Port_Moresby","IOM":"Europe/London","ION":"Africa/Brazzaville","IOP":"Pacific/Port_Moresby","IOQ":"America/Godthab","IOR":"Europe/Dublin","IOS":"America/Belem","IOT":"America/Godthab","IOU":"Pacific/Noumea","IOW":"America/Chicago","IPA":"Pacific/Efate","IPC":"Pacific/Easter","IPE":"Asia/Manila","IPG":"America/Porto_Velho","IPH":"Asia/Kuala_Lumpur","IPI":"America/Bogota","IPL":"America/Los_Angeles","IPN":"America/Sao_Paulo","IPT":"America/New_York","IPU":"America/Belem","IPW":"Europe/London","IQA":"Asia/Baghdad","IQM":"Asia/Shanghai","IQN":"Asia/Shanghai","IQQ":"America/Santiago","IQT":"America/Lima","IRA":"Pacific/Guadalcanal","IRB":"America/Chicago","IRC":"America/Anchorage","IRD":"Asia/Dhaka","IRE":"America/Belem","IRG":"Australia/Brisbane","IRI":"Africa/Dar_es_Salaam","IRJ":"America/Argentina/Buenos_Aires","IRK":"America/Chicago","IRM":"Asia/Yekaterinburg","IRN":"America/Tegucigalpa","IRO":"Africa/Bangui","IRP":"Africa/Lubumbashi","IRS":"America/New_York","IRZ":"America/Porto_Velho","ISA":"Australia/Brisbane","ISB":"Asia/Karachi","ISC":"Europe/London","ISD":"America/Bogota","ISE":"Europe/Istanbul","ISG":"Asia/Tokyo","ISH":"Europe/Rome","ISI":"Australia/Brisbane","ISJ":"America/Mexico_City","ISK":"Asia/Kolkata","ISL":"Europe/Istanbul","ISM":"America/New_York","ISN":"America/Chicago","ISO":"America/New_York","ISP":"America/New_York","ISQ":"America/New_York","ISS":"America/New_York","IST":"Europe/Istanbul","ISU":"Asia/Baghdad","ISW":"America/Chicago","ITA":"America/Porto_Velho","ITB":"America/Belem","ITE":"America/Belem","ITH":"America/New_York","ITI":"America/Sao_Paulo","ITK":"Pacific/Port_Moresby","ITM":"Asia/Tokyo","ITN":"America/Belem","ITO":"Pacific/Honolulu","ITP":"America/Sao_Paulo","ITQ":"America/Sao_Paulo","ITR":"America/Sao_Paulo","ITU":"Asia/Magadan","IUE":"Pacific/Niue","IUI":"America/Godthab","IUL":"Asia/Jayapura","IUM":"America/Vancouver","IUS":"Pacific/Bougainville","IVA":"Indian/Antananarivo","IVC":"Pacific/Auckland","IVG":"Europe/Podgorica","IVH":"America/Anchorage","IVL":"Europe/Helsinki","IVO":"America/Bogota","IVR":"Australia/Sydney","IVW":"Australia/Darwin","IWA":"Europe/Moscow","IWD":"America/Chicago","IWJ":"Asia/Tokyo","IWK":"Asia/Tokyo","IWO":"Asia/Tokyo","IWS":"America/Chicago","IXA":"Asia/Kolkata","IXB":"Asia/Kolkata","IXC":"Asia/Kolkata","IXD":"Asia/Kolkata","IXE":"Asia/Kolkata","IXG":"Asia/Kolkata","IXH":"Asia/Kolkata","IXI":"Asia/Kolkata","IXJ":"Asia/Kolkata","IXK":"Asia/Kolkata","IXL":"Asia/Kolkata","IXM":"Asia/Kolkata","IXN":"Asia/Kolkata","IXP":"Asia/Kolkata","IXQ":"Asia/Kolkata","IXR":"Asia/Kolkata","IXS":"Asia/Kolkata","IXT":"Asia/Kolkata","IXU":"Asia/Kolkata","IXV":"Asia/Kolkata","IXW":"Asia/Kolkata","IXY":"Asia/Kolkata","IXZ":"Asia/Kolkata","IYK":"America/Los_Angeles","IZA":"America/Sao_Paulo","IZO":"Asia/Tokyo","IZT":"America/Mexico_City","JAA":"Asia/Kabul","JAB":"Australia/Darwin","JAC":"America/Denver","JAD":"Australia/Perth","JAE":"America/Lima","JAF":"Asia/Colombo","JAG":"Asia/Karachi","JAH":"Europe/Paris","JAI":"Asia/Kolkata","JAJ":"America/New_York","JAK":"America/Port-au-Prince","JAL":"America/Mexico_City","JAM":"Europe/Sofia","JAN":"America/Chicago","JAO":"America/New_York","JAP":"America/Costa_Rica","JAQ":"Pacific/Port_Moresby","JAR":"Asia/Tehran","JAS":"America/Chicago","JAT":"Pacific/Majuro","JAU":"America/Lima","JAV":"America/Godthab","JAX":"America/New_York","JBB":"Asia/Jakarta","JBC":"America/New_York","JBP":"America/Los_Angeles","JBQ":"America/Santo_Domingo","JBR":"America/Chicago","JBS":"America/Sao_Paulo","JBT":"America/Anchorage","JCA":"Europe/Paris","JCB":"America/Sao_Paulo","JCC":"America/Los_Angeles","JCD":"America/St_Thomas","JCE":"America/Los_Angeles","JCH":"America/Godthab","JCI":"America/Chicago","JCJ":"Asia/Seoul","JCK":"Australia/Brisbane","JCM":"America/Belem","JCN":"Asia/Seoul","JCO":"Europe/Malta","JCR":"America/Porto_Velho","JCT":"America/Chicago","JCU":"Africa/Ceuta","JCY":"America/Chicago","JDA":"America/Los_Angeles","JDB":"America/Chicago","JDF":"America/Sao_Paulo","JDH":"Asia/Kolkata","JDM":"America/New_York","JDN":"America/Denver","JDO":"America/Belem","JDP":"Europe/Paris","JDR":"America/Sao_Paulo","JDT":"America/Chicago","JDX":"America/Chicago","JDY":"America/Los_Angeles","JDZ":"Asia/Shanghai","JED":"Asia/Riyadh","JEE":"America/Port-au-Prince","JEF":"America/Chicago","JEG":"America/Godthab","JEJ":"Pacific/Majuro","JEK":"Africa/Lusaka","JEM":"America/Los_Angeles","JEQ":"America/Belem","JER":"Europe/London","JEV":"Europe/Paris","JFK":"America/New_York","JFM":"Australia/Perth","JFN":"America/New_York","JFR":"America/Godthab","JGA":"Asia/Kolkata","JGB":"Asia/Kolkata","JGC":"America/Phoenix","JGD":"Asia/Shanghai","JGE":"Asia/Seoul","JGL":"America/New_York","JGN":"Asia/Shanghai","JGO":"America/Godthab","JGP":"America/Chicago","JGQ":"America/Chicago","JGR":"America/Godthab","JGS":"Asia/Shanghai","JGX":"America/Los_Angeles","JHB":"Asia/Kuala_Lumpur","JHC":"America/New_York","JHE":"Europe/Stockholm","JHG":"Asia/Shanghai","JHL":"America/Edmonton","JHM":"Pacific/Honolulu","JHQ":"Australia/Brisbane","JHS":"America/Godthab","JHW":"America/New_York","JIA":"America/Campo_Grande","JIB":"Africa/Djibouti","JIC":"Asia/Shanghai","JID":"America/Los_Angeles","JIJ":"Africa/Addis_Ababa","JIK":"Europe/Athens","JIL":"Asia/Shanghai","JIM":"Africa/Addis_Ababa","JIN":"Africa/Kampala","JIO":"Asia/Jayapura","JIP":"America/Guayaquil","JIQ":"Asia/Shanghai","JIR":"Asia/Kathmandu","JIU":"Asia/Shanghai","JIW":"Asia/Karachi","JJA":"Pacific/Guadalcanal","JJD":"America/Belem","JJG":"America/Sao_Paulo","JJI":"America/Lima","JJM":"Africa/Nairobi","JJN":"Asia/Shanghai","JJU":"America/Godthab","JKG":"Europe/Stockholm","JKH":"Europe/Athens","JKL":"Europe/Athens","JKR":"Asia/Kathmandu","JKV":"America/Chicago","JLA":"America/Anchorage","JLB":"America/Los_Angeles","JLD":"Europe/Stockholm","JLH":"America/Chicago","JLN":"America/Chicago","JLO":"Europe/Rome","JLP":"Europe/Paris","JLR":"Asia/Kolkata","JLS":"America/Sao_Paulo","JLX":"America/Los_Angeles","JMA":"America/Chicago","JMB":"Africa/Luanda","JMC":"America/Los_Angeles","JMD":"America/Chicago","JMH":"America/Chicago","JMJ":"Asia/Shanghai","JMK":"Europe/Athens","JMM":"Europe/Stockholm","JMN":"America/Chicago","JMO":"Asia/Kathmandu","JMS":"America/Chicago","JMU":"Asia/Shanghai","JMY":"Africa/Freetown","JNA":"America/Sao_Paulo","JNB":"Africa/Johannesburg","JNG":"Asia/Shanghai","JNH":"America/Chicago","JNI":"America/Argentina/Buenos_Aires","JNJ":"Asia/Muscat","JNN":"America/Godthab","JNP":"America/Los_Angeles","JNS":"America/Godthab","JNU":"America/Anchorage","JNX":"Europe/Athens","JNZ":"Asia/Shanghai","JOC":"America/Los_Angeles","JOE":"Europe/Helsinki","JOG":"Asia/Jakarta","JOH":"Africa/Johannesburg","JOI":"America/Sao_Paulo","JOK":"Europe/Moscow","JOL":"Asia/Manila","JOM":"Africa/Dar_es_Salaam","JON":"Pacific/Honolulu","JOP":"Pacific/Port_Moresby","JOR":"America/Los_Angeles","JOS":"Africa/Lagos","JOT":"America/Chicago","JPA":"America/Belem","JPD":"America/Los_Angeles","JPN":"America/New_York","JPR":"America/Porto_Velho","JPT":"America/Chicago","JPU":"Europe/Paris","JQA":"America/Godthab","JQE":"America/Panama","JRC":"America/Chicago","JRD":"America/Los_Angeles","JRE":"America/New_York","JRF":"Pacific/Honolulu","JRG":"Asia/Kolkata","JRH":"Asia/Kolkata","JRK":"America/Godthab","JRN":"America/Campo_Grande","JRO":"Africa/Dar_es_Salaam","JRS":"Asia/Jerusalem","JSA":"Asia/Kolkata","JSD":"America/New_York","JSG":"America/Los_Angeles","JSH":"Europe/Athens","JSI":"Europe/Athens","JSJ":"Asia/Shanghai","JSK":"Asia/Tehran","JSL":"America/New_York","JSM":"America/Argentina/Buenos_Aires","JSN":"America/Los_Angeles","JSO":"Europe/Stockholm","JSP":"Asia/Seoul","JSR":"Asia/Dhaka","JSS":"Europe/Athens","JST":"America/New_York","JSU":"America/Godthab","JSY":"Europe/Athens","JTC":"America/Sao_Paulo","JTI":"America/Sao_Paulo","JTO":"America/Los_Angeles","JTR":"Europe/Athens","JTY":"Europe/Athens","JUA":"America/Campo_Grande","JUB":"Africa/Juba","JUC":"America/Los_Angeles","JUH":"Asia/Shanghai","JUI":"Europe/Berlin","JUJ":"America/Argentina/Buenos_Aires","JUK":"America/Godthab","JUL":"America/Lima","JUM":"Asia/Kathmandu","JUN":"Australia/Brisbane","JUO":"America/Bogota","JUP":"America/Los_Angeles","JUR":"Australia/Perth","JUT":"America/Tegucigalpa","JUU":"America/Godthab","JUV":"America/Godthab","JUZ":"Asia/Shanghai","JVA":"Indian/Antananarivo","JVI":"America/New_York","JVL":"America/Chicago","JWA":"Africa/Gaborone","JWC":"America/Los_Angeles","JWH":"America/Chicago","JWL":"America/Chicago","JWN":"Asia/Tehran","JXA":"Asia/Shanghai","JXN":"America/New_York","JYR":"Asia/Tehran","JYV":"Europe/Helsinki","JZH":"Asia/Shanghai","KAA":"Africa/Lusaka","KAB":"Africa/Harare","KAC":"Asia/Damascus","KAD":"Africa/Lagos","KAE":"America/Anchorage","KAF":"Pacific/Bougainville","KAG":"Asia/Seoul","KAH":"Australia/Sydney","KAI":"America/Guyana","KAJ":"Europe/Helsinki","KAK":"Pacific/Port_Moresby","KAL":"America/Anchorage","KAM":"Asia/Aden","KAN":"Africa/Lagos","KAO":"Europe/Helsinki","KAP":"Africa/Lubumbashi","KAQ":"Pacific/Port_Moresby","KAR":"America/Guyana","KAS":"Africa/Windhoek","KAT":"Pacific/Auckland","KAU":"Europe/Helsinki","KAV":"America/Caracas","KAW":"Asia/Yangon","KAX":"Australia/Perth","KAY":"Pacific/Fiji","KAZ":"Asia/Jayapura","KBA":"Africa/Freetown","KBB":"Australia/Darwin","KBC":"America/Anchorage","KBD":"Australia/Perth","KBE":"America/Anchorage","KBF":"Asia/Jayapura","KBG":"Africa/Kampala","KBH":"Africa/Dar_es_Salaam","KBI":"Africa/Douala","KBJ":"Australia/Darwin","KBK":"America/Anchorage","KBL":"Asia/Kabul","KBM":"Pacific/Port_Moresby","KBN":"Africa/Lubumbashi","KBO":"Africa/Lubumbashi","KBP":"Europe/Kiev","KBQ":"Africa/Blantyre","KBR":"Asia/Kuala_Lumpur","KBS":"Africa/Freetown","KBT":"Pacific/Majuro","KBU":"Asia/Makassar","KBV":"Asia/Bangkok","KBW":"America/Anchorage","KBX":"Asia/Jayapura","KBY":"Australia/Adelaide","KBZ":"Pacific/Auckland","KCA":"Asia/Shanghai","KCB":"America/Paramaribo","KCC":"America/Anchorage","KCD":"Asia/Jayapura","KCE":"Australia/Brisbane","KCF":"Asia/Karachi","KCG":"America/Anchorage","KCH":"Asia/Kuala_Lumpur","KCI":"Asia/Jayapura","KCJ":"Pacific/Port_Moresby","KCK":"Asia/Irkutsk","KCL":"America/Anchorage","KCM":"Europe/Istanbul","KCN":"America/Anchorage","KCO":"Europe/Istanbul","KCP":"Europe/Kiev","KCQ":"America/Anchorage","KCS":"Australia/Darwin","KCT":"Asia/Colombo","KCU":"Africa/Kampala","KCZ":"Asia/Tokyo","KDA":"Africa/Dakar","KDB":"Australia/Perth","KDC":"Africa/Porto-Novo","KDD":"Asia/Karachi","KDE":"Pacific/Port_Moresby","KDF":"Africa/Algiers","KDH":"Asia/Kabul","KDI":"Asia/Makassar","KDJ":"Africa/Libreville","KDK":"America/Anchorage","KDL":"Europe/Tallinn","KDM":"Indian/Maldives","KDN":"Africa/Libreville","KDO":"Indian/Maldives","KDP":"Pacific/Port_Moresby","KDQ":"Pacific/Port_Moresby","KDR":"Pacific/Port_Moresby","KDS":"Australia/Brisbane","KDT":"Asia/Bangkok","KDU":"Asia/Karachi","KDV":"Pacific/Fiji","KDW":"Asia/Colombo","KDX":"Africa/Khartoum","KDY":"Asia/Yakutsk","KDZ":"Asia/Colombo","KEA":"Asia/Jayapura","KEB":"America/Anchorage","KEC":"Africa/Lubumbashi","KED":"Africa/Nouakchott","KEE":"Africa/Brazzaville","KEF":"Atlantic/Reykjavik","KEG":"Pacific/Port_Moresby","KEH":"America/Los_Angeles","KEI":"Asia/Jayapura","KEJ":"Asia/Novokuznetsk","KEK":"America/Anchorage","KEL":"Europe/Berlin","KEM":"Europe/Helsinki","KEN":"Africa/Freetown","KEO":"Africa/Abidjan","KEP":"Asia/Kathmandu","KEQ":"Asia/Jayapura","KER":"Asia/Tehran","KES":"America/Winnipeg","KET":"Asia/Yangon","KEU":"Africa/Nairobi","KEV":"Europe/Helsinki","KEW":"America/Winnipeg","KEX":"Pacific/Port_Moresby","KEY":"Africa/Nairobi","KEZ":"Asia/Colombo","KFA":"Africa/Nouakchott","KFE":"Australia/Perth","KFG":"Australia/Darwin","KFM":"America/Edmonton","KFP":"America/Anchorage","KFS":"Europe/Istanbul","KGA":"Africa/Lubumbashi","KGB":"Pacific/Port_Moresby","KGC":"Australia/Adelaide","KGD":"Europe/Kaliningrad","KGE":"Pacific/Guadalcanal","KGF":"Asia/Almaty","KGG":"Africa/Dakar","KGH":"Pacific/Port_Moresby","KGI":"Australia/Perth","KGJ":"Africa/Blantyre","KGK":"America/Anchorage","KGL":"Africa/Kigali","KGN":"Africa/Kinshasa","KGO":"Europe/Kiev","KGP":"Asia/Yekaterinburg","KGQ":"America/Godthab","KGR":"Australia/Darwin","KGS":"Europe/Athens","KGT":"Asia/Shanghai","KGU":"Asia/Kuala_Lumpur","KGW":"Pacific/Port_Moresby","KGX":"America/Anchorage","KGY":"Australia/Brisbane","KGZ":"America/Anchorage","KHA":"Asia/Tehran","KHC":"Europe/Simferopol","KHD":"Asia/Tehran","KHE":"Europe/Kiev","KHG":"Asia/Shanghai","KHH":"Asia/Taipei","KHI":"Asia/Karachi","KHJ":"Europe/Helsinki","KHK":"Asia/Tehran","KHL":"Asia/Dhaka","KHM":"Asia/Yangon","KHN":"Asia/Shanghai","KHO":"Africa/Johannesburg","KHQ":"America/Godthab","KHR":"Asia/Ulaanbaatar","KHS":"Asia/Muscat","KHT":"Asia/Kabul","KHU":"Europe/Kiev","KHV":"Asia/Vladivostok","KHW":"Africa/Gaborone","KHX":"Africa/Kampala","KHY":"Asia/Tehran","KHZ":"Pacific/Tahiti","KIA":"Pacific/Port_Moresby","KIB":"America/Anchorage","KIC":"America/Los_Angeles","KID":"Europe/Stockholm","KIE":"Pacific/Bougainville","KIF":"America/Winnipeg","KIG":"Africa/Johannesburg","KIH":"Asia/Tehran","KII":"Pacific/Port_Moresby","KIJ":"Asia/Tokyo","KIK":"Asia/Baghdad","KIL":"Africa/Kinshasa","KIM":"Africa/Johannesburg","KIN":"America/Jamaica","KIO":"Pacific/Majuro","KIP":"America/Chicago","KIQ":"Pacific/Port_Moresby","KIR":"Europe/Dublin","KIS":"Africa/Nairobi","KIT":"Europe/Athens","KIU":"Africa/Nairobi","KIV":"Europe/Chisinau","KIW":"Africa/Lusaka","KIX":"Asia/Tokyo","KIY":"Africa/Dar_es_Salaam","KIZ":"Pacific/Port_Moresby","KJA":"Asia/Krasnoyarsk","KJH":"Asia/Shanghai","KJI":"Asia/Shanghai","KJK":"Europe/Brussels","KJP":"Asia/Tokyo","KJT":"Asia/Jakarta","KJU":"Pacific/Port_Moresby","KKA":"America/Anchorage","KKB":"America/Anchorage","KKC":"Asia/Bangkok","KKD":"Pacific/Port_Moresby","KKE":"Pacific/Auckland","KKF":"America/Anchorage","KKG":"America/Guyana","KKH":"America/Anchorage","KKI":"America/Anchorage","KKJ":"Asia/Tokyo","KKK":"America/Anchorage","KKL":"America/Anchorage","KKM":"Asia/Bangkok","KKN":"Europe/Oslo","KKO":"Pacific/Auckland","KKP":"Australia/Brisbane","KKQ":"Asia/Yekaterinburg","KKR":"Pacific/Tahiti","KKS":"Asia/Tehran","KKT":"America/Chicago","KKU":"America/Anchorage","KKW":"Africa/Kinshasa","KKX":"Asia/Tokyo","KKY":"Europe/Dublin","KKZ":"Asia/Phnom_Penh","KLB":"Africa/Lusaka","KLC":"Africa/Dakar","KLD":"Europe/Moscow","KLE":"Africa/Douala","KLF":"Europe/Moscow","KLG":"America/Anchorage","KLH":"Asia/Kolkata","KLI":"Africa/Kinshasa","KLJ":"Europe/Vilnius","KLK":"Africa/Nairobi","KLL":"America/Anchorage","KLM":"Asia/Tehran","KLN":"America/Anchorage","KLO":"Asia/Manila","KLP":"America/Anchorage","KLQ":"Asia/Jakarta","KLR":"Europe/Stockholm","KLS":"America/Los_Angeles","KLT":"Europe/Berlin","KLU":"Europe/Vienna","KLV":"Europe/Prague","KLW":"America/Anchorage","KLX":"Europe/Athens","KLY":"Africa/Lubumbashi","KLZ":"Africa/Johannesburg","KMA":"Pacific/Port_Moresby","KMB":"Pacific/Port_Moresby","KMC":"Asia/Riyadh","KMD":"Africa/Libreville","KME":"Africa/Kigali","KMF":"Pacific/Port_Moresby","KMG":"Asia/Shanghai","KMH":"Africa/Johannesburg","KMI":"Asia/Tokyo","KMJ":"Asia/Tokyo","KMK":"Africa/Brazzaville","KML":"Australia/Brisbane","KMM":"Asia/Jayapura","KMN":"Africa/Lubumbashi","KMO":"America/Anchorage","KMP":"Africa/Windhoek","KMQ":"Asia/Tokyo","KMR":"Pacific/Port_Moresby","KMS":"Africa/Accra","KMT":"Asia/Phnom_Penh","KMU":"Africa/Mogadishu","KMV":"Asia/Yangon","KMW":"Europe/Moscow","KMX":"Asia/Riyadh","KMY":"America/Anchorage","KMZ":"Africa/Lusaka","KNA":"America/Santiago","KNB":"America/Denver","KNC":"Asia/Shanghai","KND":"Africa/Lubumbashi","KNE":"Pacific/Port_Moresby","KNF":"Europe/London","KNG":"Asia/Jayapura","KNH":"Asia/Taipei","KNI":"Australia/Perth","KNJ":"Africa/Brazzaville","KNK":"America/Anchorage","KNL":"Pacific/Port_Moresby","KNM":"Africa/Lubumbashi","KNN":"Africa/Conakry","KNO":"Asia/Jakarta","KNP":"Africa/Luanda","KNQ":"Pacific/Noumea","KNR":"Asia/Tehran","KNS":"Australia/Hobart","KNT":"America/Chicago","KNU":"Asia/Kolkata","KNV":"America/Vancouver","KNW":"America/Anchorage","KNX":"Australia/Perth","KNY":"America/Regina","KNZ":"Africa/Bamako","KOA":"Pacific/Honolulu","KOB":"Africa/Douala","KOC":"Pacific/Noumea","KOD":"Asia/Makassar","KOE":"Asia/Makassar","KOF":"Africa/Johannesburg","KOG":"Asia/Vientiane","KOH":"Australia/Brisbane","KOI":"Europe/London","KOJ":"Asia/Tokyo","KOK":"Europe/Helsinki","KOL":"Africa/Bangui","KOM":"Pacific/Port_Moresby","KON":"Asia/Ho_Chi_Minh","KOO":"Africa/Lubumbashi","KOP":"Asia/Bangkok","KOQ":"Europe/Berlin","KOR":"Pacific/Port_Moresby","KOS":"Asia/Phnom_Penh","KOT":"America/Anchorage","KOU":"Africa/Libreville","KOV":"Asia/Almaty","KOW":"Asia/Shanghai","KOX":"Asia/Jayapura","KOY":"America/Anchorage","KOZ":"America/Anchorage","KPA":"Pacific/Port_Moresby","KPB":"America/Anchorage","KPC":"America/Anchorage","KPE":"Pacific/Port_Moresby","KPF":"Pacific/Port_Moresby","KPG":"America/Guyana","KPH":"America/Anchorage","KPI":"Asia/Kuala_Lumpur","KPK":"America/Anchorage","KPL":"Pacific/Port_Moresby","KPM":"Pacific/Port_Moresby","KPN":"America/Anchorage","KPO":"Asia/Seoul","KPP":"Australia/Brisbane","KPR":"America/Anchorage","KPS":"Australia/Sydney","KPT":"America/Los_Angeles","KPV":"America/Anchorage","KPW":"Asia/Kamchatka","KPY":"America/Anchorage","KQA":"America/Anchorage","KQB":"Australia/Adelaide","KQH":"Asia/Kolkata","KQL":"Pacific/Port_Moresby","KQT":"Asia/Dushanbe","KRA":"Australia/Sydney","KRB":"Australia/Brisbane","KRC":"Asia/Jakarta","KRD":"Australia/Darwin","KRE":"Africa/Bujumbura","KRF":"Europe/Stockholm","KRG":"America/Guyana","KRH":"Europe/London","KRI":"Pacific/Port_Moresby","KRJ":"Pacific/Port_Moresby","KRK":"Europe/Warsaw","KRL":"Asia/Shanghai","KRM":"America/Guyana","KRN":"Europe/Stockholm","KRO":"Asia/Yekaterinburg","KRP":"Europe/Copenhagen","KRQ":"Europe/Kiev","KRR":"Europe/Moscow","KRS":"Europe/Oslo","KRT":"Africa/Khartoum","KRU":"Pacific/Port_Moresby","KRV":"Africa/Nairobi","KRW":"Asia/Ashgabat","KRX":"Pacific/Port_Moresby","KRY":"Asia/Shanghai","KRZ":"Africa/Kinshasa","KSA":"Pacific/Pohnpei","KSB":"Pacific/Port_Moresby","KSC":"Europe/Bratislava","KSD":"Europe/Stockholm","KSE":"Africa/Kampala","KSF":"Europe/Berlin","KSG":"Pacific/Port_Moresby","KSH":"Asia/Tehran","KSI":"Africa/Conakry","KSJ":"Europe/Athens","KSK":"Europe/Stockholm","KSL":"Africa/Khartoum","KSM":"America/Anchorage","KSN":"Asia/Qostanay","KSO":"Europe/Athens","KSP":"Pacific/Port_Moresby","KSQ":"Asia/Tashkent","KSR":"Asia/Makassar","KSS":"Africa/Bamako","KST":"Africa/Khartoum","KSU":"Europe/Oslo","KSV":"Australia/Brisbane","KSW":"Asia/Jerusalem","KSX":"Pacific/Port_Moresby","KSY":"Europe/Istanbul","KSZ":"Europe/Moscow","KTA":"Australia/Perth","KTB":"America/Anchorage","KTC":"Africa/Abidjan","KTD":"Asia/Tokyo","KTE":"Asia/Kuala_Lumpur","KTF":"Pacific/Auckland","KTG":"Asia/Jakarta","KTH":"America/Anchorage","KTI":"Asia/Phnom_Penh","KTJ":"Africa/Nairobi","KTK":"Pacific/Bougainville","KTL":"Africa/Nairobi","KTM":"Asia/Kathmandu","KTN":"America/Anchorage","KTO":"America/Guyana","KTP":"America/Jamaica","KTQ":"Europe/Helsinki","KTR":"Australia/Darwin","KTS":"America/Anchorage","KTT":"Europe/Helsinki","KTU":"Asia/Kolkata","KTV":"America/Caracas","KTW":"Europe/Warsaw","KTX":"Africa/Bamako","KUA":"Asia/Kuala_Lumpur","KUC":"Pacific/Tarawa","KUD":"Asia/Kuala_Lumpur","KUE":"Pacific/Guadalcanal","KUF":"Europe/Samara","KUG":"Australia/Brisbane","KUH":"Asia/Tokyo","KUI":"Pacific/Auckland","KUJ":"Asia/Tokyo","KUK":"America/Anchorage","KUL":"Asia/Kuala_Lumpur","KUM":"Asia/Tokyo","KUN":"Europe/Vilnius","KUO":"Europe/Helsinki","KUP":"Pacific/Port_Moresby","KUQ":"Pacific/Port_Moresby","KUR":"Asia/Kabul","KUS":"America/Godthab","KUT":"Asia/Tbilisi","KUU":"Asia/Kolkata","KUV":"Asia/Seoul","KUW":"America/Anchorage","KUX":"Pacific/Port_Moresby","KUY":"Pacific/Port_Moresby","KUZ":"America/Godthab","KVA":"Europe/Athens","KVB":"Europe/Stockholm","KVC":"America/Anchorage","KVD":"Asia/Baku","KVE":"Pacific/Port_Moresby","KVG":"Pacific/Port_Moresby","KVK":"Europe/Moscow","KVL":"America/Anchorage","KVO":"Europe/Belgrade","KVR":"Asia/Vladivostok","KVU":"Pacific/Fiji","KVX":"Europe/Moscow","KWA":"Pacific/Majuro","KWB":"Asia/Jakarta","KWE":"Asia/Shanghai","KWF":"America/Anchorage","KWG":"Europe/Kiev","KWH":"Asia/Kabul","KWI":"Asia/Kuwait","KWJ":"Asia/Seoul","KWK":"America/Anchorage","KWL":"Asia/Shanghai","KWM":"Australia/Brisbane","KWN":"America/Anchorage","KWO":"Pacific/Port_Moresby","KWP":"America/Anchorage","KWR":"Pacific/Guadalcanal","KWS":"Pacific/Guadalcanal","KWT":"America/Anchorage","KWV":"Pacific/Bougainville","KWX":"Pacific/Port_Moresby","KWY":"Africa/Nairobi","KWZ":"Africa/Lubumbashi","KXA":"America/Anchorage","KXE":"Africa/Johannesburg","KXF":"Pacific/Fiji","KXK":"Asia/Vladivostok","KXR":"Pacific/Bougainville","KXU":"Pacific/Tahiti","KYA":"Europe/Istanbul","KYD":"Asia/Taipei","KYE":"Asia/Beirut","KYF":"Australia/Perth","KYI":"Australia/Adelaide","KYK":"America/Anchorage","KYL":"America/New_York","KYN":"Europe/London","KYO":"America/New_York","KYP":"Asia/Yangon","KYS":"Africa/Bamako","KYT":"Asia/Yangon","KYU":"America/Anchorage","KYX":"Pacific/Port_Moresby","KYZ":"Asia/Krasnoyarsk","KZB":"America/Anchorage","KZC":"Asia/Phnom_Penh","KZD":"Asia/Phnom_Penh","KZF":"Pacific/Port_Moresby","KZG":"Europe/Berlin","KZH":"America/Anchorage","KZI":"Europe/Athens","KZK":"Asia/Phnom_Penh","KZN":"Europe/Moscow","KZO":"Asia/Qyzylorda","KZR":"Europe/Istanbul","KZS":"Europe/Athens","LAA":"America/Denver","LAB":"Pacific/Port_Moresby","LAC":"Asia/Kuala_Lumpur","LAD":"Africa/Luanda","LAE":"Pacific/Port_Moresby","LAF":"America/Indiana/Indianapolis","LAG":"America/Caracas","LAH":"Asia/Jayapura","LAI":"Europe/Paris","LAJ":"America/Sao_Paulo","LAK":"America/Edmonton","LAL":"America/New_York","LAM":"America/Denver","LAN":"America/New_York","LAO":"Asia/Manila","LAP":"America/Mazatlan","LAQ":"Africa/Tripoli","LAR":"America/Denver","LAS":"America/Los_Angeles","LAU":"Africa/Nairobi","LAV":"Pacific/Apia","LAW":"America/Chicago","LAX":"America/Los_Angeles","LAY":"Africa/Johannesburg","LAZ":"America/Belem","LBA":"Europe/London","LBB":"America/Chicago","LBC":"Europe/Berlin","LBD":"Asia/Dushanbe","LBE":"America/New_York","LBF":"America/Chicago","LBG":"Europe/Paris","LBH":"Australia/Sydney","LBI":"Europe/Paris","LBJ":"Asia/Makassar","LBK":"Africa/Nairobi","LBL":"America/Chicago","LBM":"Africa/Maputo","LBN":"Africa/Nairobi","LBO":"Africa/Lubumbashi","LBP":"Asia/Kuala_Lumpur","LBQ":"Africa/Libreville","LBR":"America/Porto_Velho","LBS":"Pacific/Fiji","LBT":"America/New_York","LBU":"Asia/Kuala_Lumpur","LBV":"Africa/Libreville","LBW":"Asia/Makassar","LBX":"Asia/Manila","LBY":"Europe/Paris","LBZ":"Africa/Luanda","LCA":"Asia/Nicosia","LCB":"America/Campo_Grande","LCC":"Europe/Rome","LCD":"Africa/Johannesburg","LCE":"America/Tegucigalpa","LCF":"America/Guatemala","LCG":"Europe/Madrid","LCH":"America/Chicago","LCI":"America/New_York","LCJ":"Europe/Warsaw","LCK":"America/New_York","LCL":"America/Havana","LCM":"America/Argentina/Buenos_Aires","LCN":"Australia/Adelaide","LCO":"Africa/Brazzaville","LCP":"America/Argentina/Buenos_Aires","LCQ":"America/New_York","LCR":"America/Bogota","LCS":"America/Costa_Rica","LCV":"Europe/Rome","LCX":"Asia/Shanghai","LCY":"Europe/London","LDA":"Asia/Kolkata","LDB":"America/Sao_Paulo","LDC":"Australia/Brisbane","LDE":"Europe/Paris","LDG":"Europe/Moscow","LDH":"Australia/Sydney","LDI":"Africa/Dar_es_Salaam","LDJ":"America/New_York","LDK":"Europe/Stockholm","LDM":"America/New_York","LDN":"Asia/Kathmandu","LDO":"America/Paramaribo","LDR":"Asia/Aden","LDS":"Asia/Shanghai","LDU":"Asia/Kuala_Lumpur","LDV":"Europe/Paris","LDW":"Australia/Perth","LDX":"America/Cayenne","LDY":"Europe/London","LDZ":"Africa/Johannesburg","LEA":"Australia/Perth","LEB":"America/New_York","LEC":"America/Belem","LED":"Europe/Moscow","LEE":"America/New_York","LEF":"Africa/Maseru","LEG":"Africa/Nouakchott","LEH":"Europe/Paris","LEI":"Europe/Madrid","LEJ":"Europe/Berlin","LEK":"Africa/Conakry","LEL":"Australia/Darwin","LEM":"America/Denver","LEN":"Europe/Madrid","LEO":"Africa/Libreville","LEP":"America/Sao_Paulo","LEQ":"Europe/London","LER":"Australia/Perth","LES":"Africa/Maseru","LET":"America/Bogota","LEU":"Europe/Madrid","LEV":"Pacific/Fiji","LEW":"America/New_York","LEX":"America/New_York","LEY":"Europe/Amsterdam","LEZ":"America/Tegucigalpa","LFB":"Africa/Maputo","LFI":"America/New_York","LFK":"America/Chicago","LFM":"Asia/Tehran","LFN":"America/New_York","LFO":"Africa/Addis_Ababa","LFP":"Australia/Brisbane","LFQ":"Asia/Shanghai","LFR":"America/Caracas","LFT":"America/Chicago","LFW":"Africa/Lome","LGA":"America/New_York","LGB":"America/Los_Angeles","LGC":"America/New_York","LGD":"America/Los_Angeles","LGE":"Australia/Perth","LGF":"America/Phoenix","LGG":"Europe/Brussels","LGH":"Australia/Adelaide","LGI":"America/Nassau","LGK":"Asia/Kuala_Lumpur","LGL":"Asia/Kuala_Lumpur","LGM":"Pacific/Port_Moresby","LGN":"Pacific/Port_Moresby","LGO":"Europe/Berlin","LGP":"Asia/Manila","LGQ":"America/Guayaquil","LGR":"America/Santiago","LGS":"America/Argentina/Buenos_Aires","LGT":"America/Bogota","LGU":"America/Denver","LGW":"Europe/London","LGX":"Africa/Mogadishu","LGY":"America/Caracas","LHA":"Europe/Berlin","LHB":"America/Anchorage","LHE":"Asia/Karachi","LHG":"Australia/Sydney","LHI":"Asia/Jayapura","LHK":"Asia/Shanghai","LHN":"Asia/Taipei","LHP":"Pacific/Bougainville","LHR":"Europe/London","LHS":"America/Argentina/Buenos_Aires","LHU":"Africa/Windhoek","LHV":"America/New_York","LHW":"Asia/Shanghai","LIA":"Asia/Shanghai","LIB":"Australia/Darwin","LIC":"America/Denver","LID":"Europe/Amsterdam","LIE":"Africa/Kinshasa","LIF":"Pacific/Noumea","LIG":"Europe/Paris","LIH":"Pacific/Honolulu","LII":"Asia/Jayapura","LIJ":"America/Anchorage","LIK":"Pacific/Majuro","LIL":"Europe/Paris","LIM":"America/Lima","LIN":"Europe/Rome","LIO":"America/Costa_Rica","LIP":"America/Sao_Paulo","LIQ":"Africa/Kinshasa","LIR":"America/Costa_Rica","LIS":"Europe/Lisbon","LIT":"America/Chicago","LIU":"Europe/Rome","LIV":"America/Anchorage","LIW":"Asia/Yangon","LIX":"Africa/Blantyre","LIY":"America/New_York","LIZ":"America/New_York","LJA":"Africa/Lubumbashi","LJC":"America/New_York","LJG":"Asia/Shanghai","LJN":"America/Chicago","LJU":"Europe/Ljubljana","LKA":"Asia/Makassar","LKB":"Pacific/Fiji","LKC":"Africa/Brazzaville","LKD":"Australia/Brisbane","LKE":"America/Los_Angeles","LKG":"Africa/Nairobi","LKH":"Asia/Kuala_Lumpur","LKI":"America/Chicago","LKK":"America/Anchorage","LKL":"Europe/Oslo","LKN":"Europe/Oslo","LKO":"Asia/Kolkata","LKP":"America/New_York","LKR":"Africa/Mogadishu","LKS":"America/Chicago","LKT":"Africa/Abidjan","LKU":"Africa/Nairobi","LKV":"America/Los_Angeles","LKY":"Africa/Dar_es_Salaam","LKZ":"Europe/London","LLA":"Europe/Stockholm","LLB":"Asia/Shanghai","LLC":"Asia/Manila","LLE":"Africa/Johannesburg","LLF":"Asia/Shanghai","LLG":"Australia/Brisbane","LLH":"America/Tegucigalpa","LLI":"Africa/Addis_Ababa","LLJ":"Asia/Makassar","LLK":"Asia/Baku","LLL":"Australia/Perth","LLM":"Pacific/Guadalcanal","LLN":"Asia/Jayapura","LLO":"Asia/Makassar","LLP":"Australia/Brisbane","LLS":"America/Argentina/Buenos_Aires","LLU":"America/Godthab","LLV":"Asia/Shanghai","LLW":"Africa/Blantyre","LLX":"America/New_York","LLY":"America/New_York","LMA":"America/Anchorage","LMB":"Africa/Blantyre","LMC":"America/Bogota","LMD":"America/Argentina/Buenos_Aires","LME":"Europe/Paris","LMG":"Pacific/Port_Moresby","LMH":"America/Tegucigalpa","LMI":"Pacific/Port_Moresby","LML":"Pacific/Majuro","LMM":"America/Mazatlan","LMN":"Asia/Kuala_Lumpur","LMO":"Europe/London","LMP":"Europe/Rome","LMQ":"Africa/Tripoli","LMR":"Africa/Johannesburg","LMS":"America/Chicago","LMT":"America/Los_Angeles","LMU":"Asia/Jakarta","LMX":"America/Bogota","LMY":"Pacific/Port_Moresby","LMZ":"Africa/Maputo","LNA":"America/New_York","LNB":"Pacific/Efate","LNC":"Pacific/Port_Moresby","LND":"America/Denver","LNE":"Pacific/Efate","LNF":"Pacific/Port_Moresby","LNG":"Pacific/Port_Moresby","LNH":"Australia/Darwin","LNI":"America/Anchorage","LNJ":"Asia/Shanghai","LNK":"America/Chicago","LNL":"Asia/Shanghai","LNM":"Pacific/Port_Moresby","LNN":"America/New_York","LNO":"Australia/Perth","LNP":"America/New_York","LNQ":"Pacific/Port_Moresby","LNR":"America/Chicago","LNS":"America/New_York","LNU":"Asia/Makassar","LNV":"Pacific/Port_Moresby","LNX":"Europe/Moscow","LNY":"Pacific/Honolulu","LNZ":"Europe/Vienna","LOA":"Australia/Brisbane","LOB":"America/Santiago","LOC":"Australia/Adelaide","LOD":"Pacific/Efate","LOE":"Asia/Bangkok","LOF":"Pacific/Majuro","LOG":"America/Los_Angeles","LOH":"America/Guayaquil","LOI":"America/Sao_Paulo","LOK":"Africa/Nairobi","LOL":"America/Los_Angeles","LOM":"America/Mexico_City","LOO":"Africa/Algiers","LOP":"Asia/Makassar","LOQ":"Africa/Gaborone","LOR":"America/Chicago","LOS":"Africa/Lagos","LOT":"America/Chicago","LOU":"America/New_York","LOV":"America/Mexico_City","LOW":"America/New_York","LOY":"Africa/Nairobi","LOZ":"America/New_York","LPA":"Atlantic/Canary","LPB":"America/La_Paz","LPC":"America/Los_Angeles","LPD":"America/Bogota","LPE":"America/Bogota","LPF":"Asia/Shanghai","LPG":"America/Argentina/Buenos_Aires","LPH":"Europe/London","LPI":"Europe/Stockholm","LPJ":"America/Caracas","LPK":"Europe/Moscow","LPL":"Europe/London","LPM":"Pacific/Efate","LPO":"America/Chicago","LPP":"Europe/Helsinki","LPQ":"Asia/Vientiane","LPS":"America/Los_Angeles","LPT":"Asia/Bangkok","LPU":"Asia/Makassar","LPW":"America/Anchorage","LPX":"Europe/Riga","LPY":"Europe/Paris","LQK":"America/New_York","LQM":"America/Bogota","LQN":"Asia/Kabul","LRA":"Europe/Athens","LRB":"Africa/Maseru","LRD":"America/Chicago","LRE":"Australia/Brisbane","LRF":"America/Chicago","LRG":"Asia/Karachi","LRH":"Europe/Paris","LRI":"America/Bogota","LRJ":"America/Chicago","LRL":"Africa/Lome","LRM":"America/Santo_Domingo","LRN":"America/Los_Angeles","LRO":"America/Los_Angeles","LRQ":"America/Winnipeg","LRR":"Asia/Tehran","LRS":"Europe/Athens","LRT":"Europe/Paris","LRU":"America/Denver","LRV":"America/Caracas","LSA":"Pacific/Port_Moresby","LSB":"America/Denver","LSC":"America/Santiago","LSE":"America/Chicago","LSF":"America/New_York","LSH":"Asia/Yangon","LSI":"Europe/London","LSJ":"Pacific/Port_Moresby","LSK":"America/Denver","LSL":"America/Costa_Rica","LSM":"Asia/Kuala_Lumpur","LSN":"America/Los_Angeles","LSO":"Europe/Paris","LSP":"America/Caracas","LSQ":"America/Santiago","LSR":"America/Anchorage","LSS":"America/Guadeloupe","LST":"Australia/Hobart","LSU":"Asia/Kuala_Lumpur","LSV":"America/Los_Angeles","LSW":"Asia/Jakarta","LSX":"Asia/Jakarta","LSY":"Australia/Sydney","LSZ":"Europe/Zagreb","LTA":"Africa/Johannesburg","LTB":"Australia/Hobart","LTC":"Africa/Ndjamena","LTD":"Africa/Tripoli","LTF":"Pacific/Port_Moresby","LTG":"Asia/Kathmandu","LTH":"America/Los_Angeles","LTI":"Asia/Ulaanbaatar","LTK":"Asia/Damascus","LTL":"Africa/Libreville","LTM":"America/Guyana","LTN":"Europe/London","LTO":"America/Mazatlan","LTP":"Australia/Brisbane","LTQ":"Europe/Paris","LTR":"Europe/Dublin","LTS":"America/Chicago","LTT":"Europe/Paris","LTU":"Asia/Kolkata","LTV":"Australia/Brisbane","LTW":"America/New_York","LTX":"America/Guayaquil","LUA":"Asia/Kathmandu","LUB":"America/Guyana","LUC":"Pacific/Fiji","LUD":"Africa/Windhoek","LUE":"Europe/Bratislava","LUF":"America/Phoenix","LUG":"Europe/Zurich","LUH":"Asia/Kolkata","LUI":"America/Tegucigalpa","LUJ":"Africa/Johannesburg","LUK":"America/New_York","LUL":"America/Chicago","LUM":"Asia/Shanghai","LUN":"Africa/Lusaka","LUO":"Africa/Luanda","LUP":"Pacific/Honolulu","LUQ":"America/Argentina/Buenos_Aires","LUR":"America/Anchorage","LUS":"Africa/Kinshasa","LUT":"Australia/Brisbane","LUU":"Australia/Brisbane","LUV":"Asia/Jayapura","LUW":"Asia/Makassar","LUX":"Europe/Luxembourg","LUZ":"Europe/Warsaw","LVA":"Europe/Paris","LVB":"America/Sao_Paulo","LVD":"America/Anchorage","LVI":"Africa/Lusaka","LVK":"America/Los_Angeles","LVL":"America/New_York","LVM":"America/Denver","LVO":"Australia/Perth","LVP":"Asia/Tehran","LVS":"America/Denver","LWA":"Asia/Manila","LWB":"America/New_York","LWC":"America/Chicago","LWE":"Asia/Makassar","LWH":"Australia/Brisbane","LWI":"Pacific/Port_Moresby","LWK":"Europe/London","LWL":"America/Los_Angeles","LWM":"America/New_York","LWN":"Asia/Yerevan","LWO":"Europe/Kiev","LWR":"Europe/Amsterdam","LWS":"America/Los_Angeles","LWT":"America/Denver","LWV":"America/Chicago","LWY":"Asia/Kuala_Lumpur","LXA":"Asia/Shanghai","LXG":"Asia/Vientiane","LXI":"Asia/Shanghai","LXN":"America/Chicago","LXR":"Africa/Cairo","LXS":"Europe/Athens","LXU":"Africa/Lusaka","LXV":"America/Denver","LYA":"Asia/Shanghai","LYB":"America/Cayman","LYC":"Europe/Stockholm","LYE":"Europe/London","LYG":"Asia/Shanghai","LYH":"America/New_York","LYI":"Asia/Shanghai","LYK":"Asia/Makassar","LYN":"Europe/Paris","LYO":"America/Chicago","LYP":"Asia/Karachi","LYR":"Arctic/Longyearbyen","LYS":"Europe/Paris","LYT":"Australia/Brisbane","LYU":"America/Chicago","LYX":"Europe/London","LZA":"Africa/Kinshasa","LZC":"America/Mexico_City","LZD":"Asia/Shanghai","LZH":"Asia/Shanghai","LZI":"Africa/Kinshasa","LZM":"Africa/Luanda","LZN":"Asia/Shanghai","LZO":"Asia/Shanghai","LZR":"Australia/Brisbane","LZY":"Asia/Shanghai","MAA":"Asia/Kolkata","MAB":"America/Belem","MAC":"America/New_York","MAD":"Europe/Madrid","MAE":"America/Los_Angeles","MAF":"America/Chicago","MAG":"Pacific/Port_Moresby","MAH":"Europe/Madrid","MAI":"Africa/Blantyre","MAJ":"Pacific/Majuro","MAK":"Africa/Juba","MAL":"Asia/Jayapura","MAM":"America/Matamoros","MAN":"Europe/London","MAO":"America/Porto_Velho","MAP":"Pacific/Port_Moresby","MAQ":"Asia/Bangkok","MAR":"America/Caracas","MAS":"Pacific/Port_Moresby","MAT":"Africa/Kinshasa","MAU":"Pacific/Tahiti","MAV":"Pacific/Majuro","MAW":"America/Chicago","MAX":"Africa/Dakar","MAY":"America/Nassau","MAZ":"America/Puerto_Rico","MBA":"Africa/Nairobi","MBB":"Australia/Perth","MBC":"Africa/Libreville","MBD":"Africa/Johannesburg","MBE":"Asia/Tokyo","MBF":"Australia/Sydney","MBG":"America/Chicago","MBH":"Australia/Brisbane","MBI":"Africa/Dar_es_Salaam","MBJ":"America/Jamaica","MBK":"America/Campo_Grande","MBL":"America/New_York","MBM":"Africa/Johannesburg","MBN":"Australia/Perth","MBO":"Asia/Manila","MBP":"America/Lima","MBQ":"Africa/Kampala","MBR":"Africa/Nouakchott","MBS":"America/New_York","MBT":"Asia/Manila","MBU":"Pacific/Guadalcanal","MBV":"Pacific/Port_Moresby","MBW":"Australia/Sydney","MBX":"Europe/Ljubljana","MBY":"America/Chicago","MBZ":"America/Porto_Velho","MCA":"Africa/Conakry","MCB":"America/Chicago","MCC":"America/Los_Angeles","MCD":"America/New_York","MCE":"America/Los_Angeles","MCF":"America/New_York","MCG":"America/Anchorage","MCH":"America/Guayaquil","MCI":"America/Chicago","MCJ":"America/Bogota","MCK":"America/Chicago","MCL":"America/Anchorage","MCM":"Europe/Monaco","MCN":"America/New_York","MCO":"America/New_York","MCP":"America/Belem","MCQ":"Europe/Budapest","MCR":"America/Guatemala","MCS":"America/Argentina/Buenos_Aires","MCT":"Asia/Muscat","MCU":"Europe/Paris","MCV":"Australia/Darwin","MCW":"America/Chicago","MCX":"Europe/Moscow","MCY":"Australia/Brisbane","MCZ":"America/Belem","MDA":"America/Chicago","MDB":"America/Belize","MDC":"Asia/Makassar","MDD":"America/Chicago","MDE":"America/Bogota","MDF":"America/Chicago","MDG":"Asia/Shanghai","MDH":"America/Chicago","MDI":"Africa/Lagos","MDJ":"America/Los_Angeles","MDK":"Africa/Kinshasa","MDL":"Asia/Yangon","MDM":"Pacific/Port_Moresby","MDN":"America/Indiana/Indianapolis","MDO":"America/Anchorage","MDP":"Asia/Jayapura","MDQ":"America/Argentina/Buenos_Aires","MDR":"Africa/Nairobi","MDS":"America/Grand_Turk","MDT":"America/New_York","MDU":"Pacific/Port_Moresby","MDV":"Africa/Libreville","MDW":"America/Chicago","MDX":"America/Argentina/Buenos_Aires","MDY":"Pacific/Midway","MDZ":"America/Argentina/Buenos_Aires","MEA":"America/Sao_Paulo","MEB":"Australia/Sydney","MEC":"America/Guayaquil","MED":"Asia/Riyadh","MEE":"Pacific/Noumea","MEF":"Africa/Ndjamena","MEG":"Africa/Luanda","MEH":"Europe/Oslo","MEI":"America/Chicago","MEJ":"America/New_York","MEK":"Africa/Casablanca","MEL":"Australia/Sydney","MEM":"America/Chicago","MEN":"Europe/Paris","MEO":"America/New_York","MEP":"Asia/Kuala_Lumpur","MEQ":"Asia/Jakarta","MER":"America/Los_Angeles","MES":"Asia/Jakarta","MET":"Australia/Brisbane","MEU":"America/Belem","MEV":"America/Los_Angeles","MEW":"Africa/Lubumbashi","MEX":"America/Mexico_City","MEY":"Asia/Kathmandu","MEZ":"Africa/Johannesburg","MFA":"Africa/Dar_es_Salaam","MFB":"America/Bogota","MFC":"Africa/Maseru","MFD":"America/New_York","MFE":"America/Chicago","MFF":"Africa/Libreville","MFG":"Asia/Karachi","MFH":"America/Los_Angeles","MFI":"America/Chicago","MFJ":"Pacific/Fiji","MFK":"Asia/Taipei","MFL":"Australia/Brisbane","MFM":"Asia/Macau","MFN":"Pacific/Auckland","MFO":"Pacific/Port_Moresby","MFP":"Australia/Darwin","MFQ":"Africa/Niamey","MFR":"America/Los_Angeles","MFS":"America/Bogota","MFT":"America/Lima","MFU":"Africa/Lusaka","MFV":"America/New_York","MFW":"Africa/Maputo","MFX":"Europe/Paris","MFY":"Asia/Aden","MFZ":"Pacific/Port_Moresby","MGA":"America/Managua","MGB":"Australia/Adelaide","MGC":"America/Chicago","MGD":"America/La_Paz","MGE":"America/New_York","MGF":"America/Sao_Paulo","MGG":"Pacific/Port_Moresby","MGH":"Africa/Johannesburg","MGI":"America/Chicago","MGJ":"America/New_York","MGK":"Asia/Yangon","MGL":"Europe/Berlin","MGM":"America/Chicago","MGN":"America/Bogota","MGO":"Africa/Libreville","MGP":"Pacific/Port_Moresby","MGQ":"Africa/Mogadishu","MGR":"America/New_York","MGS":"Pacific/Rarotonga","MGT":"Australia/Darwin","MGU":"Asia/Yangon","MGV":"Australia/Perth","MGW":"America/New_York","MGX":"Africa/Libreville","MGY":"America/New_York","MGZ":"Asia/Yangon","MHA":"America/Guyana","MHB":"Pacific/Auckland","MHC":"America/Santiago","MHD":"Asia/Tehran","MHE":"America/Chicago","MHF":"America/Bogota","MHG":"Europe/Berlin","MHH":"America/Nassau","MHI":"Africa/Djibouti","MHK":"America/Chicago","MHL":"America/Chicago","MHM":"Pacific/Guadalcanal","MHN":"America/Denver","MHO":"Australia/Perth","MHP":"Europe/Minsk","MHQ":"Europe/Helsinki","MHR":"America/Los_Angeles","MHS":"America/Los_Angeles","MHT":"America/New_York","MHU":"Australia/Sydney","MHV":"America/Los_Angeles","MHW":"America/La_Paz","MHX":"Pacific/Rarotonga","MHY":"Pacific/Port_Moresby","MHZ":"Europe/London","MIA":"America/New_York","MIB":"America/Chicago","MIC":"America/Chicago","MID":"America/Mexico_City","MIE":"America/Indiana/Indianapolis","MIF":"America/Chicago","MIG":"Asia/Shanghai","MIH":"Australia/Perth","MII":"America/Sao_Paulo","MIJ":"Pacific/Majuro","MIK":"Europe/Helsinki","MIM":"Australia/Sydney","MIN":"Australia/Adelaide","MIO":"America/Chicago","MIP":"Asia/Jerusalem","MIQ":"America/Chicago","MIR":"Africa/Tunis","MIS":"Pacific/Port_Moresby","MIT":"America/Los_Angeles","MIU":"Africa/Lagos","MIV":"America/New_York","MIW":"America/Chicago","MIX":"America/Bogota","MIZ":"Australia/Darwin","MJA":"Indian/Antananarivo","MJB":"Pacific/Majuro","MJC":"Africa/Abidjan","MJD":"Asia/Karachi","MJE":"Pacific/Majuro","MJF":"Europe/Oslo","MJG":"America/Havana","MJH":"Asia/Riyadh","MJI":"Africa/Tripoli","MJJ":"Pacific/Port_Moresby","MJK":"Australia/Perth","MJL":"Africa/Libreville","MJM":"Africa/Lubumbashi","MJN":"Indian/Antananarivo","MJO":"Africa/Windhoek","MJP":"Australia/Perth","MJQ":"America/Chicago","MJR":"America/Argentina/Buenos_Aires","MJT":"Europe/Athens","MJU":"Asia/Makassar","MJV":"Europe/Madrid","MJW":"Africa/Harare","MJX":"America/New_York","MJY":"Asia/Jakarta","MJZ":"Asia/Yakutsk","MKA":"Europe/Prague","MKB":"Africa/Libreville","MKC":"America/Chicago","MKD":"Africa/Addis_Ababa","MKE":"America/Chicago","MKF":"America/New_York","MKG":"America/New_York","MKH":"Africa/Maseru","MKI":"Africa/Bangui","MKJ":"Africa/Brazzaville","MKK":"Pacific/Honolulu","MKL":"America/Chicago","MKM":"Asia/Kuala_Lumpur","MKN":"Pacific/Port_Moresby","MKO":"America/Chicago","MKP":"Pacific/Tahiti","MKQ":"Asia/Jayapura","MKR":"Australia/Perth","MKS":"Africa/Addis_Ababa","MKT":"America/Chicago","MKU":"Africa/Libreville","MKV":"Australia/Darwin","MKW":"Asia/Jayapura","MKX":"Asia/Aden","MKY":"Australia/Brisbane","MKZ":"Asia/Kuala_Lumpur","MLA":"Europe/Malta","MLB":"America/New_York","MLC":"America/Chicago","MLD":"America/Denver","MLE":"Indian/Maldives","MLF":"America/Denver","MLG":"Asia/Jakarta","MLH":"Europe/Zurich","MLI":"America/Chicago","MLJ":"America/New_York","MLK":"America/Denver","MLL":"America/Anchorage","MLM":"America/Mexico_City","MLN":"Europe/Madrid","MLO":"Europe/Athens","MLP":"Asia/Manila","MLQ":"Pacific/Port_Moresby","MLR":"Australia/Adelaide","MLS":"America/Denver","MLT":"America/New_York","MLU":"America/Chicago","MLV":"Australia/Brisbane","MLW":"Africa/Monrovia","MLX":"Europe/Istanbul","MLY":"America/Anchorage","MLZ":"America/Montevideo","MMB":"Asia/Tokyo","MMC":"America/Mexico_City","MMD":"Asia/Tokyo","MME":"Europe/London","MMF":"Africa/Douala","MMG":"Australia/Perth","MMH":"America/Los_Angeles","MMI":"America/New_York","MMJ":"Asia/Tokyo","MMK":"Europe/Moscow","MML":"America/Chicago","MMM":"Australia/Brisbane","MMN":"America/New_York","MMO":"Atlantic/Cape_Verde","MMP":"America/Bogota","MMQ":"Africa/Lusaka","MMR":"America/Chicago","MMS":"America/Chicago","MMT":"America/New_York","MMU":"America/New_York","MMW":"Africa/Maputo","MMX":"Europe/Stockholm","MMY":"Asia/Tokyo","MMZ":"Asia/Kabul","MNA":"Asia/Makassar","MNB":"Africa/Kinshasa","MNC":"Africa/Maputo","MND":"America/Bogota","MNE":"Australia/Adelaide","MNF":"Pacific/Fiji","MNG":"Australia/Darwin","MNH":"Asia/Muscat","MNI":"America/Montserrat","MNJ":"Indian/Antananarivo","MNK":"Pacific/Tarawa","MNL":"Asia/Manila","MNM":"America/Chicago","MNN":"America/New_York","MNO":"Africa/Lubumbashi","MNQ":"Australia/Brisbane","MNR":"Africa/Lusaka","MNS":"Africa/Lusaka","MNT":"America/Anchorage","MNU":"Asia/Yangon","MNV":"Australia/Darwin","MNW":"Australia/Darwin","MNX":"America/Porto_Velho","MNY":"Pacific/Guadalcanal","MNZ":"America/New_York","MOA":"America/Havana","MOB":"America/Chicago","MOC":"America/Sao_Paulo","MOD":"America/Los_Angeles","MOE":"Asia/Yangon","MOF":"Asia/Makassar","MOG":"Asia/Yangon","MOH":"Asia/Makassar","MOI":"Pacific/Rarotonga","MOJ":"America/Paramaribo","MOK":"Africa/Abidjan","MOL":"Europe/Oslo","MOM":"Africa/Nouakchott","MON":"Pacific/Auckland","MOO":"Australia/Adelaide","MOP":"America/New_York","MOQ":"Indian/Antananarivo","MOR":"America/New_York","MOS":"America/Anchorage","MOT":"America/Chicago","MOU":"America/Anchorage","MOV":"Australia/Brisbane","MOX":"America/Chicago","MOY":"America/Bogota","MOZ":"Pacific/Tahiti","MPA":"Africa/Windhoek","MPB":"America/New_York","MPC":"Asia/Jakarta","MPD":"Asia/Karachi","MPE":"America/New_York","MPF":"Pacific/Port_Moresby","MPG":"Pacific/Port_Moresby","MPH":"Asia/Manila","MPI":"America/Panama","MPJ":"America/Chicago","MPK":"Asia/Seoul","MPL":"Europe/Paris","MPM":"Africa/Maputo","MPN":"Atlantic/Stanley","MPO":"America/New_York","MPP":"America/Panama","MPQ":"Asia/Amman","MPR":"America/Chicago","MPS":"America/Chicago","MPT":"Asia/Jayapura","MPU":"Pacific/Port_Moresby","MPV":"America/New_York","MPX":"Pacific/Port_Moresby","MPY":"America/Cayenne","MPZ":"America/Chicago","MQA":"Australia/Perth","MQB":"America/Chicago","MQC":"America/Miquelon","MQD":"America/Argentina/Buenos_Aires","MQE":"Australia/Darwin","MQF":"Asia/Yekaterinburg","MQG":"Africa/Windhoek","MQH":"America/Sao_Paulo","MQI":"America/New_York","MQJ":"Asia/Magadan","MQK":"America/La_Paz","MQL":"Australia/Sydney","MQM":"Europe/Istanbul","MQN":"Europe/Oslo","MQO":"Pacific/Port_Moresby","MQP":"Africa/Johannesburg","MQQ":"Africa/Ndjamena","MQR":"America/Bogota","MQS":"America/St_Vincent","MQT":"America/New_York","MQU":"America/Bogota","MQV":"Africa/Algiers","MQW":"America/New_York","MQX":"Africa/Addis_Ababa","MQY":"America/Chicago","MQZ":"Australia/Perth","MRA":"Africa/Tripoli","MRB":"America/New_York","MRC":"America/Chicago","MRD":"America/Caracas","MRE":"Africa/Nairobi","MRF":"America/Chicago","MRG":"Australia/Brisbane","MRH":"Pacific/Port_Moresby","MRI":"America/Anchorage","MRJ":"America/Tegucigalpa","MRK":"America/New_York","MRL":"Australia/Brisbane","MRM":"Pacific/Port_Moresby","MRN":"America/New_York","MRO":"Pacific/Auckland","MRP":"Australia/Adelaide","MRQ":"Asia/Manila","MRR":"America/Guayaquil","MRS":"Europe/Paris","MRT":"Australia/Darwin","MRU":"Indian/Mauritius","MRV":"Europe/Moscow","MRW":"Europe/Copenhagen","MRX":"Asia/Tehran","MRY":"America/Los_Angeles","MRZ":"Australia/Sydney","MSA":"America/Winnipeg","MSC":"America/Phoenix","MSD":"America/Denver","MSE":"Europe/London","MSF":"Australia/Darwin","MSG":"Africa/Maseru","MSH":"Asia/Muscat","MSI":"Asia/Jakarta","MSJ":"Asia/Tokyo","MSK":"America/Nassau","MSL":"America/Chicago","MSM":"Africa/Kinshasa","MSN":"America/Chicago","MSO":"America/Denver","MSP":"America/Chicago","MSQ":"Europe/Minsk","MSR":"Europe/Istanbul","MSS":"America/New_York","MST":"Europe/Amsterdam","MSU":"Africa/Maseru","MSV":"America/New_York","MSW":"Africa/Asmara","MSX":"Africa/Brazzaville","MSY":"America/Chicago","MSZ":"Africa/Luanda","MTA":"Pacific/Auckland","MTB":"America/Bogota","MTC":"America/New_York","MTD":"Australia/Darwin","MTE":"America/Porto_Velho","MTF":"Africa/Addis_Ababa","MTG":"America/Campo_Grande","MTH":"America/New_York","MTI":"Atlantic/Cape_Verde","MTJ":"America/Denver","MTK":"Pacific/Tarawa","MTL":"Australia/Sydney","MTM":"America/Anchorage","MTN":"America/New_York","MTO":"America/Chicago","MTP":"America/New_York","MTQ":"Australia/Brisbane","MTR":"America/Bogota","MTS":"Africa/Mbabane","MTT":"America/Mexico_City","MTU":"Africa/Maputo","MTV":"Pacific/Efate","MTW":"America/Chicago","MTX":"America/Anchorage","MTY":"America/Mexico_City","MTZ":"Asia/Jerusalem","MUA":"Pacific/Guadalcanal","MUB":"Africa/Gaborone","MUC":"Europe/Berlin","MUD":"Africa/Maputo","MUE":"Pacific/Honolulu","MUF":"Asia/Jayapura","MUG":"America/Mazatlan","MUH":"Africa/Cairo","MUI":"America/New_York","MUJ":"Africa/Addis_Ababa","MUK":"Pacific/Rarotonga","MUL":"America/New_York","MUM":"Africa/Nairobi","MUN":"America/Caracas","MUO":"America/Denver","MUP":"Australia/Darwin","MUQ":"Australia/Perth","MUR":"Asia/Kuala_Lumpur","MUT":"America/Chicago","MUU":"America/New_York","MUV":"America/New_York","MUW":"Africa/Algiers","MUX":"Asia/Karachi","MUY":"Africa/Brazzaville","MUZ":"Africa/Dar_es_Salaam","MVA":"Atlantic/Reykjavik","MVB":"Africa/Libreville","MVC":"America/Chicago","MVD":"America/Montevideo","MVE":"America/Chicago","MVF":"America/Belem","MVG":"Africa/Libreville","MVH":"Australia/Sydney","MVI":"Pacific/Bougainville","MVJ":"America/Jamaica","MVK":"Australia/Adelaide","MVL":"America/New_York","MVM":"America/Phoenix","MVN":"America/Chicago","MVO":"Africa/Ndjamena","MVP":"America/Bogota","MVQ":"Europe/Minsk","MVR":"Africa/Douala","MVS":"America/Belem","MVT":"Pacific/Tahiti","MVU":"Australia/Brisbane","MVV":"Europe/Paris","MVW":"America/Los_Angeles","MVX":"Africa/Libreville","MVY":"America/New_York","MVZ":"Africa/Harare","MWA":"America/Chicago","MWB":"Australia/Perth","MWC":"America/Chicago","MWD":"Asia/Karachi","MWE":"Africa/Khartoum","MWF":"Pacific/Efate","MWG":"Pacific/Port_Moresby","MWH":"America/Los_Angeles","MWI":"Pacific/Port_Moresby","MWJ":"America/Guyana","MWK":"Asia/Jakarta","MWL":"America/Chicago","MWM":"America/Chicago","MWN":"Africa/Dar_es_Salaam","MWO":"America/New_York","MWP":"Asia/Kathmandu","MWQ":"Asia/Yangon","MWS":"America/Los_Angeles","MWT":"Australia/Adelaide","MWU":"Pacific/Port_Moresby","MWV":"Asia/Phnom_Penh","MWW":"Europe/Brussels","MWX":"Asia/Seoul","MWY":"Australia/Brisbane","MWZ":"Africa/Dar_es_Salaam","MXA":"America/Chicago","MXB":"Asia/Jayapura","MXC":"America/Denver","MXD":"Australia/Brisbane","MXE":"America/New_York","MXF":"America/Chicago","MXG":"America/New_York","MXH":"Pacific/Port_Moresby","MXI":"Asia/Manila","MXJ":"Africa/Lagos","MXK":"Pacific/Port_Moresby","MXL":"America/Tijuana","MXM":"Indian/Antananarivo","MXN":"Europe/Paris","MXO":"America/Chicago","MXP":"Europe/Rome","MXQ":"Australia/Brisbane","MXR":"Europe/Kiev","MXS":"Pacific/Apia","MXT":"Indian/Antananarivo","MXU":"Australia/Perth","MXV":"Asia/Ulaanbaatar","MXW":"Asia/Ulaanbaatar","MXX":"Europe/Stockholm","MXY":"America/Anchorage","MXZ":"Asia/Shanghai","MYA":"Australia/Sydney","MYB":"Africa/Libreville","MYC":"America/Caracas","MYD":"Africa/Nairobi","MYE":"Asia/Tokyo","MYF":"America/Los_Angeles","MYG":"America/Nassau","MYH":"America/Phoenix","MYI":"Australia/Brisbane","MYJ":"Asia/Tokyo","MYK":"America/Anchorage","MYL":"America/Denver","MYM":"America/Guyana","MYN":"Asia/Aden","MYO":"Australia/Perth","MYP":"Asia/Ashgabat","MYQ":"Asia/Kolkata","MYR":"America/New_York","MYS":"Africa/Addis_Ababa","MYT":"Asia/Yangon","MYU":"America/Anchorage","MYV":"America/Los_Angeles","MYW":"Africa/Dar_es_Salaam","MYX":"Pacific/Port_Moresby","MYY":"Asia/Kuala_Lumpur","MYZ":"Africa/Blantyre","MZA":"America/Lima","MZB":"Africa/Maputo","MZC":"Africa/Libreville","MZD":"America/Guayaquil","MZE":"America/Belize","MZF":"Africa/Johannesburg","MZG":"Asia/Taipei","MZH":"Europe/Istanbul","MZI":"Africa/Bamako","MZJ":"America/Phoenix","MZK":"Pacific/Tarawa","MZL":"America/Bogota","MZM":"Europe/Paris","MZN":"Pacific/Port_Moresby","MZO":"America/Havana","MZP":"Pacific/Auckland","MZQ":"Africa/Johannesburg","MZR":"Asia/Kabul","MZS":"Asia/Kuala_Lumpur","MZT":"America/Mazatlan","MZU":"Asia/Kolkata","MZV":"Asia/Kuala_Lumpur","MZW":"Africa/Algiers","MZX":"Africa/Addis_Ababa","MZY":"Africa/Johannesburg","MZZ":"America/Indiana/Indianapolis","NAA":"Australia/Sydney","NAB":"America/New_York","NAC":"Australia/Adelaide","NAD":"America/Bogota","NAE":"Africa/Porto-Novo","NAF":"Asia/Makassar","NAG":"Asia/Kolkata","NAH":"Asia/Makassar","NAI":"America/Guyana","NAJ":"Asia/Baku","NAK":"Asia/Bangkok","NAL":"Europe/Moscow","NAM":"Asia/Jayapura","NAN":"Pacific/Fiji","NAO":"Asia/Shanghai","NAP":"Europe/Rome","NAQ":"America/Godthab","NAR":"America/Bogota","NAS":"America/Nassau","NAT":"America/Belem","NAU":"Pacific/Tahiti","NAV":"Europe/Istanbul","NAW":"Asia/Bangkok","NBA":"Pacific/Port_Moresby","NBB":"America/Bogota","NBC":"Europe/Moscow","NBE":"Africa/Tunis","NBG":"America/Chicago","NBH":"Australia/Sydney","NBL":"America/Panama","NBN":"Africa/Lagos","NBO":"Africa/Nairobi","NBP":"America/New_York","NBR":"Australia/Brisbane","NBS":"Asia/Shanghai","NBV":"America/Sao_Paulo","NBW":"America/Havana","NBX":"Asia/Jayapura","NCA":"America/Grand_Turk","NCE":"Europe/Paris","NCG":"America/Mexico_City","NCH":"Africa/Dar_es_Salaam","NCI":"America/Bogota","NCJ":"America/Argentina/Cordoba","NCL":"Europe/London","NCN":"America/Anchorage","NCO":"America/New_York","NCP":"Asia/Manila","NCQ":"America/New_York","NCR":"America/Managua","NCS":"Africa/Johannesburg","NCT":"America/Costa_Rica","NCU":"Asia/Tashkent","NCY":"Europe/Paris","NDA":"Asia/Jayapura","NDB":"Africa/Nouakchott","NDC":"Asia/Kolkata","NDD":"Africa/Luanda","NDE":"Africa/Nairobi","NDF":"Africa/Luanda","NDG":"Asia/Shanghai","NDI":"Pacific/Port_Moresby","NDJ":"Africa/Ndjamena","NDK":"Pacific/Majuro","NDL":"Africa/Bangui","NDM":"Africa/Addis_Ababa","NDN":"Pacific/Port_Moresby","NDO":"Europe/Madrid","NDR":"Africa/Casablanca","NDS":"Australia/Perth","NDU":"Africa/Windhoek","NDV":"America/New_York","NDY":"Europe/London","NDZ":"Europe/Berlin","NEA":"America/New_York","NEC":"America/Argentina/Buenos_Aires","NEF":"Asia/Yekaterinburg","NEG":"America/Jamaica","NEI":"Asia/Vladivostok","NEJ":"Africa/Addis_Ababa","NEK":"Africa/Addis_Ababa","NEL":"America/New_York","NEN":"America/New_York","NER":"Asia/Yakutsk","NES":"America/New_York","NEU":"Asia/Vientiane","NEV":"America/St_Kitts","NEW":"America/Chicago","NFB":"America/New_York","NFG":"Asia/Yekaterinburg","NFL":"America/Los_Angeles","NFO":"Pacific/Tongatapu","NFR":"Africa/Tripoli","NGA":"Australia/Sydney","NGB":"Asia/Shanghai","NGC":"America/Phoenix","NGD":"America/Tortola","NGE":"Africa/Douala","NGF":"Pacific/Honolulu","NGI":"Pacific/Fiji","NGK":"Asia/Magadan","NGL":"Africa/Johannesburg","NGM":"Pacific/Guam","NGN":"America/Panama","NGO":"Asia/Tokyo","NGP":"America/Chicago","NGQ":"Asia/Shanghai","NGR":"Pacific/Port_Moresby","NGS":"Asia/Tokyo","NGU":"America/New_York","NGW":"America/Chicago","NGX":"Asia/Kathmandu","NGZ":"America/Los_Angeles","NHA":"Asia/Ho_Chi_Minh","NHD":"Asia/Dubai","NHF":"Africa/Khartoum","NHK":"America/New_York","NHS":"Asia/Karachi","NHT":"Europe/London","NHV":"Pacific/Marquesas","NHX":"America/Chicago","NHZ":"America/New_York","NIA":"Africa/Monrovia","NIB":"America/Anchorage","NIE":"America/Anchorage","NIF":"Australia/Perth","NIG":"Pacific/Tarawa","NIK":"Africa/Dakar","NIM":"Africa/Niamey","NIN":"America/Anchorage","NIO":"Africa/Kinshasa","NIP":"America/New_York","NIQ":"America/Godthab","NIR":"America/Chicago","NIS":"Pacific/Port_Moresby","NIT":"Europe/Paris","NIU":"Pacific/Tahiti","NIX":"Africa/Bamako","NJA":"Asia/Tokyo","NJC":"Asia/Yekaterinburg","NJF":"Asia/Baghdad","NJJ":"Asia/Shanghai","NJK":"America/Los_Angeles","NKA":"Africa/Libreville","NKB":"Australia/Perth","NKC":"Africa/Nouakchott","NKD":"Asia/Jayapura","NKG":"Asia/Shanghai","NKI":"America/Anchorage","NKL":"Africa/Lubumbashi","NKM":"Asia/Tokyo","NKN":"Pacific/Port_Moresby","NKO":"Indian/Antananarivo","NKS":"Africa/Douala","NKT":"Europe/Istanbul","NKU":"Africa/Maseru","NKX":"America/Los_Angeles","NKY":"Africa/Brazzaville","NLA":"Africa/Lusaka","NLC":"America/Los_Angeles","NLD":"America/Matamoros","NLE":"America/New_York","NLF":"Australia/Brisbane","NLG":"America/Anchorage","NLH":"Asia/Shanghai","NLI":"Asia/Vladivostok","NLK":"Pacific/Norfolk","NLL":"Australia/Perth","NLO":"Africa/Kinshasa","NLP":"Africa/Johannesburg","NLS":"Australia/Perth","NLT":"Asia/Shanghai","NLU":"America/Mexico_City","NLV":"Europe/Kiev","NMA":"Asia/Tashkent","NMB":"Asia/Kolkata","NMC":"America/Nassau","NME":"America/Anchorage","NMF":"Indian/Maldives","NMG":"America/Panama","NMN":"Pacific/Port_Moresby","NMP":"Australia/Brisbane","NMR":"Australia/Brisbane","NMS":"Asia/Yangon","NMT":"Asia/Yangon","NMU":"Pacific/Majuro","NNA":"Africa/Casablanca","NNB":"Pacific/Guadalcanal","NND":"Africa/Maputo","NNG":"Asia/Shanghai","NNI":"Africa/Windhoek","NNK":"America/Anchorage","NNL":"America/Anchorage","NNM":"Europe/Moscow","NNR":"Europe/Dublin","NNT":"Asia/Bangkok","NNU":"America/Sao_Paulo","NNX":"Asia/Makassar","NNY":"Asia/Shanghai","NOA":"Australia/Sydney","NOB":"America/Costa_Rica","NOC":"Europe/Dublin","NOD":"Europe/Berlin","NOE":"Europe/Berlin","NOG":"America/Hermosillo","NOH":"America/Chicago","NOI":"Europe/Moscow","NOJ":"Asia/Yekaterinburg","NOK":"America/Campo_Grande","NOL":"America/Anchorage","NOM":"Pacific/Port_Moresby","NON":"Pacific/Tarawa","NOO":"Pacific/Port_Moresby","NOP":"Europe/Istanbul","NOR":"Atlantic/Reykjavik","NOS":"Indian/Antananarivo","NOT":"America/Los_Angeles","NOU":"Pacific/Noumea","NOV":"Africa/Luanda","NOZ":"Asia/Novokuznetsk","NPA":"America/Chicago","NPE":"Pacific/Auckland","NPG":"Pacific/Port_Moresby","NPH":"America/Denver","NPL":"Pacific/Auckland","NPO":"Asia/Makassar","NPP":"Australia/Darwin","NPT":"America/New_York","NPU":"America/Bogota","NPY":"Africa/Dar_es_Salaam","NQA":"America/Chicago","NQI":"America/Chicago","NQL":"America/Sao_Paulo","NQN":"America/Argentina/Buenos_Aires","NQT":"Europe/London","NQU":"America/Bogota","NQX":"America/New_York","NQY":"Europe/London","NRA":"Australia/Sydney","NRB":"America/New_York","NRC":"America/Los_Angeles","NRD":"Europe/Berlin","NRE":"Asia/Jayapura","NRG":"Australia/Perth","NRI":"America/Chicago","NRK":"Europe/Stockholm","NRL":"Europe/London","NRM":"Africa/Bamako","NRN":"Europe/Berlin","NRR":"America/Puerto_Rico","NRS":"America/Los_Angeles","NRT":"Asia/Tokyo","NRV":"Pacific/Guam","NRY":"Australia/Darwin","NSB":"America/Nassau","NSE":"America/New_York","NSF":"America/New_York","NSH":"Asia/Tehran","NSI":"Africa/Douala","NSK":"Asia/Krasnoyarsk","NSL":"America/Chicago","NSM":"Australia/Perth","NSN":"Pacific/Auckland","NSO":"Australia/Sydney","NSQ":"America/Godthab","NST":"Asia/Bangkok","NSV":"Australia/Brisbane","NSX":"America/Tortola","NSY":"Europe/Rome","NTA":"Pacific/Fiji","NTB":"Europe/Oslo","NTD":"America/Los_Angeles","NTE":"Europe/Paris","NTG":"Asia/Shanghai","NTI":"Asia/Jayapura","NTJ":"America/Denver","NTL":"Australia/Sydney","NTM":"America/Belem","NTN":"Australia/Brisbane","NTO":"Atlantic/Cape_Verde","NTQ":"Asia/Tokyo","NTR":"America/Mexico_City","NTT":"Pacific/Tongatapu","NTU":"America/New_York","NTX":"Asia/Jakarta","NTY":"Africa/Johannesburg","NUA":"Asia/Colombo","NUB":"Australia/Darwin","NUD":"Africa/Khartoum","NUE":"Europe/Berlin","NUF":"Asia/Colombo","NUG":"Pacific/Port_Moresby","NUH":"America/Bogota","NUI":"America/Anchorage","NUJ":"Asia/Tehran","NUK":"Pacific/Tahiti","NUL":"America/Anchorage","NUM":"Asia/Riyadh","NUN":"America/Chicago","NUP":"America/Anchorage","NUQ":"America/Los_Angeles","NUR":"Australia/Adelaide","NUS":"Pacific/Efate","NUT":"Pacific/Port_Moresby","NUU":"Africa/Nairobi","NUW":"America/Los_Angeles","NUX":"Asia/Yekaterinburg","NVA":"America/Bogota","NVD":"America/Chicago","NVG":"America/Managua","NVI":"Asia/Tashkent","NVK":"Europe/Oslo","NVP":"America/Porto_Velho","NVR":"Europe/Moscow","NVS":"Europe/Paris","NVT":"America/Sao_Paulo","NVY":"Asia/Kolkata","NWA":"Indian/Comoro","NWH":"America/New_York","NWI":"Europe/London","NWP":"America/St_Johns","NWS":"America/New_York","NWT":"Pacific/Port_Moresby","NWU":"Atlantic/Bermuda","NXX":"America/New_York","NYA":"Asia/Yekaterinburg","NYE":"Africa/Nairobi","NYG":"America/New_York","NYI":"Africa/Accra","NYK":"Africa/Nairobi","NYM":"Asia/Yekaterinburg","NYN":"Australia/Sydney","NYO":"Europe/Stockholm","NYR":"Asia/Yakutsk","NYS":"America/New_York","NYT":"Asia/Yangon","NYU":"Asia/Yangon","NYW":"Asia/Yangon","NZA":"Africa/Luanda","NZC":"America/Lima","NZE":"Africa/Conakry","NZH":"Asia/Shanghai","NZL":"Asia/Shanghai","NZO":"Africa/Nairobi","NZW":"America/New_York","NZY":"America/Los_Angeles","OAA":"Asia/Kabul","OAG":"Australia/Sydney","OAH":"Asia/Kabul","OAI":"Asia/Kabul","OAJ":"America/New_York","OAK":"America/Los_Angeles","OAL":"America/Porto_Velho","OAM":"Pacific/Auckland","OAN":"America/Tegucigalpa","OAR":"America/Los_Angeles","OAS":"Asia/Kabul","OAX":"America/Mexico_City","OAZ":"Asia/Kabul","OBA":"Australia/Brisbane","OBC":"Africa/Djibouti","OBD":"Asia/Jayapura","OBE":"America/New_York","OBF":"Europe/Berlin","OBI":"America/Porto_Velho","OBK":"America/Chicago","OBL":"Europe/Brussels","OBM":"Pacific/Port_Moresby","OBN":"Europe/London","OBO":"Asia/Tokyo","OBS":"Europe/Paris","OBU":"America/Anchorage","OBX":"Pacific/Port_Moresby","OBY":"America/Scoresbysund","OCA":"America/New_York","OCC":"America/Guayaquil","OCE":"America/New_York","OCF":"America/New_York","OCH":"America/Chicago","OCI":"America/Anchorage","OCJ":"America/Jamaica","OCM":"Australia/Perth","OCN":"America/Los_Angeles","OCV":"America/Bogota","OCW":"America/New_York","ODA":"Africa/Bangui","ODB":"Europe/Madrid","ODD":"Australia/Adelaide","ODE":"Europe/Copenhagen","ODH":"Europe/London","ODJ":"Africa/Bangui","ODL":"Australia/Adelaide","ODM":"America/New_York","ODN":"Asia/Kuala_Lumpur","ODO":"Asia/Irkutsk","ODR":"Australia/Perth","ODS":"Europe/Kiev","ODW":"America/Los_Angeles","ODY":"Asia/Vientiane","OEA":"America/Indiana/Indianapolis","OEC":"Asia/Jayapura","OEL":"Europe/Moscow","OEM":"America/Paramaribo","OEO":"America/Chicago","OER":"Europe/Stockholm","OES":"America/Argentina/Buenos_Aires","OFF":"America/Chicago","OFI":"Africa/Abidjan","OFJ":"Atlantic/Reykjavik","OFK":"America/Chicago","OFU":"Pacific/Pago_Pago","OGA":"America/Denver","OGB":"America/New_York","OGD":"America/Denver","OGE":"Pacific/Port_Moresby","OGG":"Pacific/Honolulu","OGL":"America/Guyana","OGM":"America/Panama","OGN":"Asia/Tokyo","OGO":"Africa/Abidjan","OGR":"Africa/Ndjamena","OGS":"America/New_York","OGU":"Europe/Istanbul","OGX":"Africa/Algiers","OGZ":"Europe/Moscow","OHA":"Pacific/Auckland","OHC":"America/Anchorage","OHD":"Europe/Skopje","OHE":"Asia/Shanghai","OHH":"Asia/Magadan","OHI":"Africa/Windhoek","OHO":"Asia/Vladivostok","OHP":"Europe/London","OHR":"Europe/Berlin","OHS":"Asia/Muscat","OHT":"Asia/Karachi","OIA":"America/Belem","OIC":"America/New_York","OIL":"America/New_York","OIM":"Asia/Tokyo","OIR":"Asia/Tokyo","OIT":"Asia/Tokyo","OJC":"America/Chicago","OJU":"Asia/Makassar","OKA":"Asia/Tokyo","OKB":"Australia/Brisbane","OKC":"America/Chicago","OKD":"Asia/Tokyo","OKE":"Asia/Tokyo","OKF":"Africa/Windhoek","OKG":"Africa/Brazzaville","OKH":"Europe/London","OKI":"Asia/Tokyo","OKJ":"Asia/Tokyo","OKK":"America/Indiana/Indianapolis","OKL":"Asia/Jayapura","OKM":"America/Chicago","OKN":"Africa/Libreville","OKO":"Asia/Tokyo","OKP":"Pacific/Port_Moresby","OKQ":"Asia/Jayapura","OKR":"Australia/Brisbane","OKS":"America/Chicago","OKT":"Asia/Yekaterinburg","OKU":"Africa/Windhoek","OKV":"Pacific/Port_Moresby","OKY":"Australia/Brisbane","OLA":"Europe/Oslo","OLB":"Europe/Rome","OLC":"America/Porto_Velho","OLD":"America/New_York","OLE":"America/New_York","OLF":"America/Denver","OLG":"Africa/Nairobi","OLH":"America/Anchorage","OLI":"Atlantic/Reykjavik","OLJ":"Pacific/Efate","OLK":"America/Asuncion","OLL":"Africa/Brazzaville","OLM":"America/Los_Angeles","OLO":"Europe/Prague","OLP":"Australia/Adelaide","OLQ":"Pacific/Port_Moresby","OLR":"Asia/Kabul","OLS":"America/Phoenix","OLU":"America/Chicago","OLV":"America/Chicago","OLX":"Africa/Nairobi","OLY":"America/Chicago","OLZ":"Asia/Yakutsk","OMA":"America/Chicago","OMB":"Africa/Libreville","OMC":"Asia/Manila","OMD":"Africa/Windhoek","OME":"America/Anchorage","OMF":"Asia/Amman","OMG":"Africa/Windhoek","OMH":"Asia/Tehran","OMI":"Asia/Tehran","OMJ":"Asia/Tokyo","OMK":"America/Los_Angeles","OML":"Pacific/Port_Moresby","OMM":"Asia/Muscat","OMN":"Asia/Kolkata","OMO":"Europe/Sarajevo","OMR":"Europe/Bucharest","OMS":"Asia/Omsk","OMY":"Asia/Phnom_Penh","ONA":"America/Chicago","ONB":"Pacific/Port_Moresby","OND":"Africa/Windhoek","ONE":"Pacific/Guadalcanal","ONG":"Australia/Brisbane","ONH":"America/New_York","ONI":"Asia/Jayapura","ONJ":"Asia/Tokyo","ONK":"Asia/Yakutsk","ONL":"America/Chicago","ONM":"America/Denver","ONN":"America/Anchorage","ONO":"America/Los_Angeles","ONP":"America/Los_Angeles","ONQ":"Europe/Istanbul","ONR":"Australia/Brisbane","ONS":"Australia/Perth","ONT":"America/Los_Angeles","ONU":"Pacific/Fiji","ONX":"America/Panama","ONY":"America/Chicago","OOA":"America/Chicago","OOK":"America/Anchorage","OOL":"Australia/Brisbane","OOM":"Australia/Sydney","OOR":"Australia/Brisbane","OOT":"Pacific/Tarawa","OPA":"Atlantic/Reykjavik","OPB":"Pacific/Port_Moresby","OPF":"America/New_York","OPI":"Australia/Darwin","OPL":"America/Chicago","OPO":"Europe/Lisbon","OPS":"America/Campo_Grande","OPU":"Pacific/Port_Moresby","OPW":"Africa/Windhoek","ORA":"America/Argentina/Buenos_Aires","ORB":"Europe/Stockholm","ORC":"America/Bogota","ORD":"America/Chicago","ORE":"Europe/Paris","ORF":"America/New_York","ORG":"America/Paramaribo","ORH":"America/New_York","ORI":"America/Anchorage","ORJ":"America/Guyana","ORK":"Europe/Dublin","ORL":"America/New_York","ORM":"Europe/London","ORN":"Africa/Algiers","ORO":"America/Tegucigalpa","ORP":"Africa/Gaborone","ORQ":"America/New_York","ORR":"Australia/Adelaide","ORS":"Australia/Brisbane","ORT":"America/Anchorage","ORU":"America/La_Paz","ORV":"America/Anchorage","ORW":"Asia/Karachi","ORX":"America/Porto_Velho","ORY":"Europe/Paris","ORZ":"America/Belize","OSB":"America/Chicago","OSC":"America/New_York","OSD":"Europe/Stockholm","OSE":"Pacific/Port_Moresby","OSF":"Europe/Moscow","OSG":"Pacific/Port_Moresby","OSH":"America/Chicago","OSI":"Europe/Zagreb","OSJ":"Africa/Nairobi","OSK":"Europe/Stockholm","OSL":"Europe/Oslo","OSM":"Asia/Baghdad","OSN":"Asia/Seoul","OSO":"Australia/Brisbane","OSP":"Europe/Warsaw","OSR":"Europe/Prague","OSS":"Asia/Bishkek","OST":"Europe/Brussels","OSU":"America/New_York","OSW":"Asia/Yekaterinburg","OSX":"America/Chicago","OSY":"Europe/Oslo","OSZ":"Europe/Warsaw","OTA":"Africa/Addis_Ababa","OTC":"Africa/Ndjamena","OTD":"America/Panama","OTG":"America/Chicago","OTH":"America/Los_Angeles","OTI":"Asia/Jayapura","OTJ":"Africa/Windhoek","OTK":"America/Los_Angeles","OTL":"Africa/Nouakchott","OTM":"America/Chicago","OTN":"America/Indiana/Indianapolis","OTO":"America/Denver","OTP":"Europe/Bucharest","OTR":"America/Costa_Rica","OTS":"America/Los_Angeles","OTT":"America/Campo_Grande","OTU":"America/Bogota","OTV":"Pacific/Guadalcanal","OTY":"Pacific/Bougainville","OTZ":"America/Anchorage","OUA":"Africa/Ouagadougou","OUD":"Africa/Casablanca","OUE":"Africa/Brazzaville","OUG":"Africa/Ouagadougou","OUH":"Africa/Johannesburg","OUK":"Europe/London","OUL":"Europe/Helsinki","OUM":"Africa/Ndjamena","OUN":"America/Chicago","OUR":"Africa/Douala","OUS":"America/Sao_Paulo","OUT":"Africa/Ndjamena","OUU":"Africa/Libreville","OUZ":"Africa/Nouakchott","OVA":"Indian/Antananarivo","OVB":"Asia/Novosibirsk","OVD":"Europe/Madrid","OVE":"America/Los_Angeles","OVG":"Africa/Johannesburg","OVL":"America/Santiago","OVR":"America/Argentina/Buenos_Aires","OVS":"Asia/Yekaterinburg","OWA":"America/Chicago","OWB":"America/Chicago","OWD":"America/New_York","OWE":"Africa/Libreville","OWK":"America/New_York","OXB":"Africa/Bissau","OXC":"America/New_York","OXD":"America/New_York","OXF":"Europe/London","OXO":"Australia/Brisbane","OXR":"America/Los_Angeles","OXY":"Australia/Brisbane","OYA":"America/Argentina/Buenos_Aires","OYE":"Africa/Libreville","OYG":"Africa/Kampala","OYK":"America/Belem","OYL":"Africa/Nairobi","OYN":"Australia/Sydney","OYO":"America/Argentina/Buenos_Aires","OYP":"America/Cayenne","OYS":"America/Los_Angeles","OZA":"America/Chicago","OZC":"Asia/Manila","OZG":"Africa/Casablanca","OZH":"Europe/Kiev","OZI":"Europe/Madrid","OZP":"Europe/Madrid","OZR":"America/Chicago","OZU":"Europe/Madrid","OZZ":"Africa/Casablanca","PAA":"Asia/Yangon","PAB":"Asia/Kolkata","PAC":"America/Panama","PAD":"Europe/Berlin","PAE":"America/Los_Angeles","PAF":"Africa/Kampala","PAG":"Asia/Manila","PAH":"America/Chicago","PAI":"Asia/Phnom_Penh","PAJ":"Asia/Karachi","PAK":"Pacific/Honolulu","PAL":"America/Bogota","PAM":"America/Chicago","PAN":"Asia/Bangkok","PAO":"America/Los_Angeles","PAP":"America/Port-au-Prince","PAQ":"America/Anchorage","PAR":"Europe/Paris","PAS":"Europe/Athens","PAT":"Asia/Kolkata","PAU":"Asia/Yangon","PAV":"America/Belem","PAW":"Pacific/Port_Moresby","PAX":"America/Port-au-Prince","PAY":"Asia/Kuala_Lumpur","PAZ":"America/Mexico_City","PBA":"America/Anchorage","PBB":"America/Campo_Grande","PBC":"America/Mexico_City","PBD":"Asia/Kolkata","PBE":"America/Bogota","PBF":"America/Chicago","PBG":"America/New_York","PBH":"Asia/Thimphu","PBI":"America/New_York","PBJ":"Pacific/Efate","PBK":"America/Anchorage","PBL":"America/Caracas","PBM":"America/Paramaribo","PBN":"Africa/Luanda","PBO":"Australia/Perth","PBP":"America/Costa_Rica","PBQ":"America/Porto_Velho","PBR":"America/Guatemala","PBS":"Asia/Bangkok","PBT":"America/Asuncion","PBU":"Asia/Yangon","PBV":"America/Campo_Grande","PBX":"America/Campo_Grande","PBY":"Australia/Brisbane","PBZ":"Africa/Johannesburg","PCA":"America/Anchorage","PCB":"Asia/Jakarta","PCC":"America/Bogota","PCD":"America/Chicago","PCE":"America/Anchorage","PCG":"America/Guatemala","PCH":"America/Tegucigalpa","PCJ":"America/Asuncion","PCK":"America/Anchorage","PCL":"America/Lima","PCM":"America/Mexico_City","PCN":"Pacific/Auckland","PCO":"America/Mazatlan","PCP":"Africa/Sao_Tome","PCQ":"Asia/Vientiane","PCR":"America/Bogota","PCS":"America/Belem","PCT":"America/New_York","PCU":"America/Chicago","PCV":"America/Tijuana","PDA":"America/Bogota","PDB":"America/Anchorage","PDC":"Pacific/Noumea","PDD":"Africa/Maputo","PDE":"Australia/Adelaide","PDF":"America/Belem","PDG":"Asia/Jakarta","PDI":"Pacific/Port_Moresby","PDK":"America/New_York","PDL":"Atlantic/Azores","PDM":"America/Panama","PDN":"Australia/Adelaide","PDO":"Asia/Jakarta","PDP":"America/Montevideo","PDR":"America/Belem","PDS":"America/Matamoros","PDT":"America/Los_Angeles","PDU":"America/Montevideo","PDV":"Europe/Sofia","PDX":"America/Los_Angeles","PDZ":"America/Caracas","PEA":"Australia/Adelaide","PEB":"Africa/Maputo","PEC":"America/Anchorage","PED":"Europe/Prague","PEE":"Asia/Yekaterinburg","PEF":"Europe/Berlin","PEG":"Europe/Rome","PEH":"America/Argentina/Buenos_Aires","PEI":"America/Bogota","PEK":"Asia/Shanghai","PEL":"Africa/Maseru","PEM":"America/Lima","PEN":"Asia/Kuala_Lumpur","PEP":"Australia/Darwin","PEQ":"America/Chicago","PER":"Australia/Perth","PES":"Europe/Moscow","PET":"America/Sao_Paulo","PEU":"America/Tegucigalpa","PEV":"Europe/Budapest","PEW":"Asia/Karachi","PEX":"Europe/Moscow","PEY":"Australia/Adelaide","PEZ":"Europe/Moscow","PFA":"America/Anchorage","PFB":"America/Sao_Paulo","PFC":"America/Los_Angeles","PFD":"America/Anchorage","PFJ":"Atlantic/Reykjavik","PFO":"Asia/Nicosia","PFQ":"Asia/Tehran","PFR":"Africa/Lubumbashi","PGA":"America/Phoenix","PGB":"Pacific/Port_Moresby","PGC":"America/New_York","PGD":"America/New_York","PGE":"Pacific/Port_Moresby","PGF":"Europe/Paris","PGG":"America/Belem","PGH":"Asia/Kolkata","PGI":"Africa/Luanda","PGK":"Asia/Jakarta","PGL":"America/Chicago","PGM":"America/Anchorage","PGN":"Pacific/Port_Moresby","PGO":"America/Denver","PGP":"Africa/Sao_Tome","PGQ":"Asia/Makassar","PGR":"America/Chicago","PGS":"America/Phoenix","PGU":"Asia/Tehran","PGV":"America/New_York","PGX":"Europe/Paris","PGZ":"America/Sao_Paulo","PHA":"Asia/Ho_Chi_Minh","PHB":"America/Belem","PHC":"Africa/Lagos","PHD":"America/New_York","PHE":"Australia/Perth","PHF":"America/New_York","PHG":"Africa/Lagos","PHH":"Asia/Ho_Chi_Minh","PHI":"America/Belem","PHJ":"Australia/Sydney","PHK":"America/New_York","PHL":"America/New_York","PHM":"Europe/Berlin","PHN":"America/New_York","PHO":"America/Anchorage","PHP":"America/Chicago","PHQ":"Australia/Brisbane","PHR":"Pacific/Fiji","PHS":"Asia/Bangkok","PHT":"America/Chicago","PHU":"Asia/Ho_Chi_Minh","PHW":"Africa/Johannesburg","PHX":"America/Phoenix","PHY":"Asia/Bangkok","PHZ":"Asia/Bangkok","PIA":"America/Chicago","PIB":"America/Chicago","PIC":"America/Grand_Turk","PID":"America/Nassau","PIE":"America/New_York","PIF":"Asia/Taipei","PIG":"America/Porto_Velho","PIH":"America/Denver","PIK":"Europe/London","PIL":"America/Asuncion","PIM":"America/New_York","PIN":"America/Porto_Velho","PIO":"America/Lima","PIP":"America/Anchorage","PIQ":"America/Guyana","PIR":"America/Chicago","PIS":"Europe/Paris","PIT":"America/New_York","PIU":"America/Lima","PIV":"America/Sao_Paulo","PIW":"America/Winnipeg","PIX":"Atlantic/Azores","PIZ":"America/Anchorage","PJA":"Europe/Stockholm","PJB":"America/Phoenix","PJC":"America/Asuncion","PJG":"Asia/Karachi","PJM":"America/Costa_Rica","PJS":"America/Anchorage","PKA":"America/Anchorage","PKB":"America/New_York","PKC":"Asia/Kamchatka","PKD":"America/Chicago","PKE":"Australia/Sydney","PKF":"America/Chicago","PKG":"Asia/Kuala_Lumpur","PKH":"Europe/Athens","PKJ":"America/Guatemala","PKK":"Asia/Yangon","PKL":"Pacific/Auckland","PKM":"America/Guyana","PKN":"Asia/Jakarta","PKO":"Africa/Porto-Novo","PKP":"Pacific/Tahiti","PKR":"Asia/Kathmandu","PKS":"Asia/Vientiane","PKT":"Australia/Darwin","PKU":"Asia/Jakarta","PKV":"Europe/Moscow","PKW":"Africa/Gaborone","PKX":"Asia/Shanghai","PKY":"Asia/Jakarta","PKZ":"Asia/Vientiane","PLA":"America/Bogota","PLB":"America/New_York","PLC":"America/Bogota","PLD":"America/Costa_Rica","PLE":"Pacific/Port_Moresby","PLF":"Africa/Ndjamena","PLH":"Europe/London","PLI":"America/St_Vincent","PLJ":"America/Belize","PLK":"America/Chicago","PLL":"America/Porto_Velho","PLM":"Asia/Jakarta","PLN":"America/New_York","PLO":"Australia/Adelaide","PLP":"America/Panama","PLQ":"Europe/Vilnius","PLR":"America/Chicago","PLS":"America/Grand_Turk","PLT":"America/Bogota","PLU":"America/Sao_Paulo","PLV":"Europe/Kiev","PLW":"Asia/Makassar","PLX":"Asia/Almaty","PLY":"America/Indiana/Indianapolis","PLZ":"Africa/Johannesburg","PMA":"Africa/Dar_es_Salaam","PMB":"America/Chicago","PMC":"America/Santiago","PMD":"America/Los_Angeles","PME":"Europe/London","PMF":"Europe/Rome","PMG":"America/Campo_Grande","PMH":"America/New_York","PMI":"Europe/Madrid","PMK":"Australia/Brisbane","PML":"America/Anchorage","PMM":"Asia/Bangkok","PMN":"Pacific/Port_Moresby","PMO":"Europe/Rome","PMP":"Pacific/Port_Moresby","PMQ":"America/Argentina/Buenos_Aires","PMR":"Pacific/Auckland","PMS":"Asia/Damascus","PMT":"America/Guyana","PMU":"America/Anchorage","PMV":"America/Caracas","PMW":"America/Belem","PMX":"America/New_York","PMY":"America/Argentina/Buenos_Aires","PMZ":"America/Costa_Rica","PNA":"Europe/Madrid","PNB":"America/Belem","PNC":"America/Chicago","PND":"America/Belize","PNE":"America/New_York","PNF":"America/Anchorage","PNG":"America/Sao_Paulo","PNH":"Asia/Phnom_Penh","PNI":"Pacific/Pohnpei","PNJ":"Asia/Shanghai","PNK":"Asia/Jakarta","PNL":"Europe/Rome","PNN":"America/New_York","PNO":"America/Mexico_City","PNP":"Pacific/Port_Moresby","PNQ":"Asia/Kolkata","PNR":"Africa/Brazzaville","PNS":"America/Chicago","PNT":"America/Santiago","PNU":"America/Denver","PNV":"Europe/Vilnius","PNX":"America/Chicago","PNY":"Asia/Kolkata","PNZ":"America/Belem","POA":"America/Sao_Paulo","POB":"America/New_York","POC":"America/Los_Angeles","POD":"Africa/Dakar","POE":"America/Chicago","POF":"America/Chicago","POG":"Africa/Libreville","POH":"America/Chicago","POI":"America/La_Paz","POJ":"America/Sao_Paulo","POL":"Africa/Maputo","POM":"Pacific/Port_Moresby","PON":"America/Guatemala","POO":"America/Sao_Paulo","POP":"America/Santo_Domingo","POR":"Europe/Helsinki","POS":"America/Port_of_Spain","POT":"America/Jamaica","POU":"America/New_York","POV":"Europe/Bratislava","POW":"Europe/Ljubljana","POX":"Europe/Paris","POY":"America/Denver","POZ":"Europe/Warsaw","PPA":"America/Chicago","PPB":"America/Sao_Paulo","PPC":"America/Anchorage","PPD":"America/Puerto_Rico","PPE":"America/Hermosillo","PPF":"America/Chicago","PPG":"Pacific/Pago_Pago","PPH":"America/Caracas","PPI":"Australia/Adelaide","PPJ":"Asia/Jakarta","PPK":"Asia/Almaty","PPL":"Asia/Kathmandu","PPM":"America/New_York","PPN":"America/Bogota","PPO":"America/Nassau","PPP":"Australia/Brisbane","PPQ":"Pacific/Auckland","PPR":"Asia/Jakarta","PPS":"Asia/Manila","PPT":"Pacific/Tahiti","PPU":"Asia/Yangon","PPV":"America/Anchorage","PPW":"Europe/London","PPX":"Pacific/Port_Moresby","PPY":"America/Sao_Paulo","PPZ":"America/Caracas","PQC":"Asia/Ho_Chi_Minh","PQI":"America/New_York","PQM":"America/Mexico_City","PQQ":"Australia/Sydney","PQS":"America/Anchorage","PQT":"America/Godthab","PRA":"America/Argentina/Buenos_Aires","PRB":"America/Los_Angeles","PRC":"America/Phoenix","PRD":"Australia/Perth","PRE":"America/Bogota","PRF":"America/Anchorage","PRG":"Europe/Prague","PRH":"Asia/Bangkok","PRI":"Indian/Mahe","PRJ":"Europe/Rome","PRK":"Africa/Johannesburg","PRL":"America/Anchorage","PRM":"Europe/Lisbon","PRN":"Europe/Belgrade","PRO":"America/Chicago","PRP":"Europe/Paris","PRQ":"America/Argentina/Buenos_Aires","PRR":"America/Guyana","PRS":"Pacific/Guadalcanal","PRU":"Asia/Yangon","PRV":"Europe/Prague","PRW":"America/Chicago","PRX":"America/Chicago","PRY":"Africa/Johannesburg","PRZ":"America/Los_Angeles","PSA":"Europe/Rome","PSB":"America/New_York","PSC":"America/Los_Angeles","PSD":"Africa/Cairo","PSE":"America/Puerto_Rico","PSF":"America/New_York","PSG":"America/Anchorage","PSH":"Europe/Berlin","PSI":"Asia/Karachi","PSJ":"Asia/Makassar","PSK":"America/New_York","PSL":"Europe/London","PSM":"America/New_York","PSN":"America/Chicago","PSO":"America/Bogota","PSP":"America/Los_Angeles","PSQ":"America/New_York","PSR":"Europe/Rome","PSS":"America/Argentina/Buenos_Aires","PST":"America/Havana","PSU":"Asia/Jakarta","PSV":"Europe/London","PSW":"America/Sao_Paulo","PSX":"America/Chicago","PSY":"Atlantic/Stanley","PSZ":"America/La_Paz","PTA":"America/Anchorage","PTB":"America/New_York","PTC":"America/Anchorage","PTD":"America/Anchorage","PTF":"Pacific/Fiji","PTG":"Africa/Johannesburg","PTH":"America/Anchorage","PTI":"Australia/Brisbane","PTJ":"Australia/Sydney","PTK":"America/New_York","PTL":"America/Anchorage","PTM":"America/Caracas","PTN":"America/Chicago","PTO":"America/Sao_Paulo","PTP":"America/Guadeloupe","PTQ":"America/Belem","PTR":"America/Anchorage","PTS":"America/Chicago","PTT":"America/Chicago","PTU":"America/Anchorage","PTV":"America/Los_Angeles","PTW":"America/New_York","PTX":"America/Bogota","PTY":"America/Panama","PTZ":"America/Guayaquil","PUA":"Pacific/Port_Moresby","PUB":"America/Denver","PUC":"America/Denver","PUD":"America/Argentina/Buenos_Aires","PUE":"America/Panama","PUF":"Europe/Paris","PUG":"Australia/Adelaide","PUH":"America/Mexico_City","PUI":"Pacific/Port_Moresby","PUJ":"America/Santo_Domingo","PUK":"Pacific/Tahiti","PUL":"America/Los_Angeles","PUM":"Asia/Makassar","PUN":"Africa/Lubumbashi","PUO":"America/Anchorage","PUP":"Africa/Ouagadougou","PUQ":"America/Santiago","PUR":"America/La_Paz","PUS":"Asia/Seoul","PUT":"Asia/Kolkata","PUU":"America/Bogota","PUV":"Pacific/Noumea","PUW":"America/Los_Angeles","PUX":"America/Santiago","PUY":"Europe/Zagreb","PUZ":"America/Managua","PVA":"America/Bogota","PVC":"America/New_York","PVD":"America/New_York","PVE":"America/Panama","PVF":"America/Los_Angeles","PVG":"Asia/Shanghai","PVH":"America/Porto_Velho","PVI":"America/Sao_Paulo","PVK":"Europe/Athens","PVL":"America/New_York","PVN":"Europe/Sofia","PVO":"America/Guayaquil","PVR":"America/Mexico_City","PVS":"Asia/Kamchatka","PVU":"America/Denver","PVW":"America/Chicago","PVY":"America/Anchorage","PVZ":"America/New_York","PWA":"America/Chicago","PWD":"America/Denver","PWE":"Asia/Anadyr","PWI":"Africa/Addis_Ababa","PWK":"America/Chicago","PWL":"Asia/Jakarta","PWM":"America/New_York","PWN":"America/Nassau","PWO":"Africa/Lubumbashi","PWQ":"Asia/Almaty","PWR":"America/Anchorage","PWT":"America/Los_Angeles","PWY":"America/Denver","PXA":"Asia/Jakarta","PXH":"Australia/Adelaide","PXL":"America/Phoenix","PXM":"America/Mexico_City","PXO":"Europe/Lisbon","PXR":"Asia/Bangkok","PXS":"Europe/Madrid","PXU":"Asia/Ho_Chi_Minh","PYA":"America/Bogota","PYB":"Asia/Kolkata","PYC":"America/Panama","PYE":"Pacific/Rarotonga","PYG":"Asia/Kolkata","PYH":"America/Caracas","PYJ":"Asia/Yakutsk","PYL":"America/Anchorage","PYM":"America/New_York","PYN":"America/Bogota","PYO":"America/Guayaquil","PYR":"Europe/Athens","PYS":"America/Los_Angeles","PYV":"America/Panama","PYX":"Asia/Bangkok","PYY":"Asia/Bangkok","PZA":"America/Bogota","PZB":"Africa/Johannesburg","PZE":"Europe/London","PZH":"Asia/Karachi","PZI":"Asia/Shanghai","PZK":"Pacific/Rarotonga","PZL":"Africa/Johannesburg","PZO":"America/Caracas","PZU":"Africa/Khartoum","PZY":"Europe/Bratislava","QAC":"America/Sao_Paulo","QAK":"America/Sao_Paulo","QBC":"America/Vancouver","QBX":"America/Belem","QCJ":"America/Sao_Paulo","QCN":"America/Sao_Paulo","QCP":"America/Belem","QCR":"America/Sao_Paulo","QCU":"America/Godthab","QDB":"America/Campo_Grande","QDC":"America/Sao_Paulo","QDF":"America/Sao_Paulo","QDP":"America/Campo_Grande","QDV":"America/Sao_Paulo","QET":"Asia/Seoul","QFG":"America/Godthab","QFI":"America/Godthab","QFK":"Europe/Oslo","QFN":"America/Godthab","QFQ":"Europe/Oslo","QFT":"America/Godthab","QFX":"America/Godthab","QGC":"America/Sao_Paulo","QGF":"America/Sao_Paulo","QGP":"America/Sao_Paulo","QGQ":"America/Godthab","QGU":"Asia/Tokyo","QHB":"America/Sao_Paulo","QHN":"America/Sao_Paulo","QHV":"America/Sao_Paulo","QID":"America/Sao_Paulo","QIG":"America/Belem","QIQ":"America/Sao_Paulo","QIT":"America/Sao_Paulo","QJE":"America/Godthab","QJH":"America/Godthab","QJI":"America/Godthab","QLA":"Europe/London","QLR":"Europe/Lisbon","QLX":"Europe/Vienna","QMF":"America/Sao_Paulo","QMK":"America/Godthab","QMM":"Europe/Rome","QMQ":"Africa/Tripoli","QMV":"America/New_York","QNS":"America/Sao_Paulo","QNV":"America/Sao_Paulo","QOA":"America/Sao_Paulo","QOQ":"America/Godthab","QOW":"Africa/Lagos","QPG":"Asia/Singapore","QPK":"Europe/Berlin","QPW":"America/Godthab","QRA":"Africa/Johannesburg","QRC":"Pacific/Easter","QRE":"America/Campo_Grande","QRF":"America/Argentina/Buenos_Aires","QRH":"Europe/Amsterdam","QRM":"Australia/Brisbane","QRO":"America/Mexico_City","QRR":"Australia/Brisbane","QRW":"Africa/Lagos","QRY":"America/Godthab","QSC":"America/Sao_Paulo","QSF":"Africa/Algiers","QSM":"Europe/Berlin","QSR":"Europe/Rome","QSZ":"Asia/Shanghai","QTL":"America/Sao_Paulo","QUB":"Africa/Tripoli","QUF":"Europe/Tallinn","QUG":"Europe/London","QUN":"Asia/Seoul","QUO":"Africa/Lagos","QUP":"America/Godthab","QUT":"Asia/Tokyo","QUV":"America/Godthab","QUW":"America/Godthab","QVP":"America/Sao_Paulo","QWG":"America/New_York","QXC":"America/Belem","QXD":"America/Sao_Paulo","QYI":"Europe/Amsterdam","QZN":"Africa/Algiers","RAA":"Pacific/Port_Moresby","RAB":"Pacific/Port_Moresby","RAC":"America/Chicago","RAD":"America/Tortola","RAE":"Asia/Riyadh","RAF":"Africa/Cairo","RAG":"Pacific/Auckland","RAH":"Asia/Riyadh","RAI":"Atlantic/Cape_Verde","RAJ":"Asia/Kolkata","RAK":"Africa/Casablanca","RAL":"America/Los_Angeles","RAM":"Australia/Darwin","RAN":"Europe/Rome","RAO":"America/Sao_Paulo","RAP":"America/Denver","RAQ":"Asia/Makassar","RAR":"Pacific/Rarotonga","RAS":"Asia/Tehran","RAT":"Asia/Yekaterinburg","RAU":"Asia/Dhaka","RAV":"America/Bogota","RAW":"Pacific/Bougainville","RAX":"Pacific/Port_Moresby","RAY":"Europe/London","RAZ":"Asia/Karachi","RBA":"Africa/Casablanca","RBB":"America/Porto_Velho","RBC":"Australia/Sydney","RBD":"America/Chicago","RBE":"Asia/Phnom_Penh","RBF":"America/Los_Angeles","RBG":"America/Los_Angeles","RBH":"America/Anchorage","RBI":"Pacific/Fiji","RBJ":"Asia/Tokyo","RBK":"America/Los_Angeles","RBL":"America/Los_Angeles","RBM":"Europe/Berlin","RBN":"America/New_York","RBO":"America/La_Paz","RBP":"Pacific/Port_Moresby","RBQ":"America/La_Paz","RBR":"America/Rio_Branco","RBS":"Australia/Sydney","RBT":"Africa/Nairobi","RBU":"Australia/Perth","RBV":"Pacific/Guadalcanal","RBW":"America/New_York","RBX":"Africa/Juba","RBY":"America/Anchorage","RCA":"America/Denver","RCB":"Africa/Johannesburg","RCE":"America/Los_Angeles","RCH":"America/Bogota","RCK":"America/Chicago","RCL":"Pacific/Efate","RCM":"Australia/Brisbane","RCN":"Australia/Adelaide","RCO":"Europe/Paris","RCP":"America/Anchorage","RCQ":"America/Argentina/Buenos_Aires","RCR":"America/Indiana/Indianapolis","RCS":"Europe/London","RCT":"America/New_York","RCU":"America/Argentina/Buenos_Aires","RCY":"America/Nassau","RDA":"Australia/Darwin","RDB":"America/Anchorage","RDC":"America/Belem","RDD":"America/Los_Angeles","RDE":"Asia/Jayapura","RDG":"America/New_York","RDM":"America/Los_Angeles","RDN":"Asia/Kuala_Lumpur","RDO":"Europe/Warsaw","RDP":"Asia/Kolkata","RDR":"America/Chicago","RDS":"America/Argentina/Buenos_Aires","RDT":"Africa/Dakar","RDU":"America/New_York","RDV":"America/Anchorage","RDZ":"Europe/Paris","REA":"Pacific/Tahiti","REB":"Europe/Berlin","REC":"America/Belem","RED":"America/New_York","REE":"America/Chicago","REG":"Europe/Rome","REH":"America/New_York","REI":"America/Cayenne","REL":"America/Argentina/Buenos_Aires","REN":"Asia/Yekaterinburg","REO":"America/Los_Angeles","REP":"Asia/Phnom_Penh","RER":"America/Guatemala","RES":"America/Argentina/Buenos_Aires","RET":"Europe/Oslo","REU":"Europe/Madrid","REW":"Asia/Kolkata","REX":"America/Matamoros","REY":"America/La_Paz","REZ":"America/Sao_Paulo","RFA":"Africa/Bangui","RFD":"America/Chicago","RFG":"America/Chicago","RFK":"America/Chicago","RFN":"Atlantic/Reykjavik","RFP":"Pacific/Tahiti","RFR":"America/Costa_Rica","RFS":"America/Managua","RGA":"America/Argentina/Buenos_Aires","RGE":"Pacific/Port_Moresby","RGH":"Asia/Kolkata","RGI":"Pacific/Tahiti","RGK":"Asia/Krasnoyarsk","RGL":"America/Argentina/Buenos_Aires","RGN":"Asia/Yangon","RGR":"America/Chicago","RGS":"Europe/Madrid","RGT":"Asia/Jakarta","RHA":"Atlantic/Reykjavik","RHD":"America/Argentina/Buenos_Aires","RHE":"Europe/Paris","RHG":"Africa/Kigali","RHI":"America/Chicago","RHL":"Australia/Perth","RHN":"Africa/Windhoek","RHO":"Europe/Athens","RHP":"Asia/Kathmandu","RHT":"Asia/Shanghai","RHV":"America/Los_Angeles","RIA":"America/Sao_Paulo","RIB":"America/La_Paz","RIC":"America/New_York","RID":"America/Indiana/Indianapolis","RIE":"America/Chicago","RIF":"America/Denver","RIG":"America/Sao_Paulo","RIH":"America/Panama","RIJ":"America/Lima","RIL":"America/Denver","RIM":"America/Lima","RIN":"Pacific/Guadalcanal","RIR":"America/Los_Angeles","RIS":"Asia/Tokyo","RIT":"America/Panama","RIV":"America/Los_Angeles","RIW":"America/Denver","RIX":"Europe/Riga","RIY":"Asia/Aden","RIZ":"Asia/Shanghai","RJA":"Asia/Kolkata","RJB":"Asia/Kathmandu","RJH":"Asia/Dhaka","RJI":"Asia/Kolkata","RJK":"Europe/Zagreb","RJL":"Europe/Madrid","RJM":"Asia/Jayapura","RJN":"Asia/Tehran","RKA":"Pacific/Tahiti","RKC":"America/Los_Angeles","RKD":"America/New_York","RKE":"Europe/Copenhagen","RKH":"America/New_York","RKI":"Asia/Jakarta","RKO":"Asia/Jakarta","RKP":"America/Chicago","RKR":"America/Chicago","RKS":"America/Denver","RKT":"Asia/Dubai","RKU":"Pacific/Port_Moresby","RKV":"Atlantic/Reykjavik","RKW":"America/New_York","RKY":"Australia/Brisbane","RKZ":"Asia/Shanghai","RLA":"America/Chicago","RLD":"America/Los_Angeles","RLG":"Europe/Berlin","RLI":"America/Chicago","RLK":"Asia/Shanghai","RLO":"America/Argentina/Buenos_Aires","RLP":"Australia/Brisbane","RLR":"Indian/Antananarivo","RLT":"Africa/Niamey","RLU":"America/Anchorage","RMA":"Australia/Brisbane","RMB":"Asia/Muscat","RMC":"America/Chicago","RMD":"Asia/Kolkata","RME":"America/New_York","RMF":"Africa/Cairo","RMG":"America/New_York","RMI":"Europe/Rome","RMK":"Australia/Adelaide","RML":"Asia/Colombo","RMN":"Pacific/Port_Moresby","RMP":"America/Anchorage","RMQ":"Asia/Taipei","RMS":"Europe/Berlin","RMT":"Pacific/Gambier","RMU":"Europe/Madrid","RMY":"America/Los_Angeles","RNA":"Pacific/Guadalcanal","RNB":"Europe/Stockholm","RNC":"America/Chicago","RND":"America/Chicago","RNE":"Europe/Paris","RNG":"America/Denver","RNH":"America/Chicago","RNI":"America/Managua","RNJ":"Asia/Tokyo","RNL":"Pacific/Guadalcanal","RNM":"Asia/Muscat","RNN":"Europe/Copenhagen","RNO":"America/Los_Angeles","RNP":"Pacific/Majuro","RNR":"Pacific/Port_Moresby","RNS":"Europe/Paris","RNT":"America/Los_Angeles","RNU":"Asia/Kuala_Lumpur","RNZ":"America/Indiana/Indianapolis","ROA":"America/New_York","ROB":"Africa/Monrovia","ROC":"America/New_York","ROD":"Africa/Johannesburg","ROF":"America/Los_Angeles","ROG":"America/Chicago","ROH":"Australia/Brisbane","ROI":"Asia/Bangkok","ROK":"Australia/Brisbane","ROL":"America/Denver","RON":"America/Bogota","ROO":"America/Campo_Grande","ROP":"Pacific/Saipan","ROR":"Pacific/Palau","ROS":"America/Argentina/Buenos_Aires","ROT":"Pacific/Auckland","ROU":"Europe/Sofia","ROV":"Europe/Moscow","ROW":"America/Denver","ROX":"America/Chicago","ROY":"America/Argentina/Buenos_Aires","ROZ":"Europe/Madrid","RPA":"Asia/Kathmandu","RPB":"Australia/Darwin","RPM":"Australia/Darwin","RPN":"Asia/Jerusalem","RPR":"Asia/Kolkata","RPV":"Australia/Darwin","RPX":"America/Denver","RQA":"Asia/Shanghai","RRA":"Europe/Madrid","RRE":"Australia/Adelaide","RRG":"Indian/Mauritius","RRI":"Pacific/Guadalcanal","RRJ":"America/Sao_Paulo","RRK":"Asia/Kolkata","RRL":"America/Chicago","RRM":"Africa/Maputo","RRN":"America/Belem","RRO":"Europe/Rome","RRR":"Pacific/Tahiti","RRS":"Europe/Oslo","RRT":"America/Chicago","RRV":"Australia/Darwin","RSA":"America/Argentina/Buenos_Aires","RSB":"Australia/Brisbane","RSD":"America/Nassau","RSE":"Australia/Sydney","RSG":"America/Belem","RSH":"America/Anchorage","RSI":"America/Panama","RSJ":"America/Los_Angeles","RSK":"Asia/Jayapura","RSL":"America/Chicago","RSN":"America/Chicago","RSP":"America/Anchorage","RSS":"Africa/Khartoum","RST":"America/Chicago","RSU":"Asia/Seoul","RSW":"America/New_York","RSX":"America/New_York","RTA":"Pacific/Fiji","RTB":"America/Tegucigalpa","RTC":"Asia/Kolkata","RTD":"America/New_York","RTE":"America/Anchorage","RTG":"Asia/Makassar","RTI":"Asia/Makassar","RTL":"America/Chicago","RTM":"Europe/Amsterdam","RTN":"America/Denver","RTP":"Australia/Brisbane","RTS":"Australia/Perth","RTW":"Europe/Saratov","RTY":"Australia/Adelaide","RUA":"Africa/Kampala","RUD":"Asia/Tehran","RUF":"Asia/Jayapura","RUG":"Asia/Shanghai","RUH":"Asia/Riyadh","RUI":"America/Denver","RUK":"Asia/Kathmandu","RUL":"Indian/Maldives","RUM":"Asia/Kathmandu","RUN":"Indian/Reunion","RUP":"Asia/Kolkata","RUR":"Pacific/Tahiti","RUS":"Pacific/Guadalcanal","RUT":"America/New_York","RUU":"Pacific/Port_Moresby","RUV":"America/Guatemala","RUY":"America/Tegucigalpa","RVA":"Indian/Antananarivo","RVC":"Africa/Monrovia","RVD":"America/Sao_Paulo","RVE":"America/Bogota","RVH":"Europe/Moscow","RVI":"Europe/Moscow","RVK":"Europe/Oslo","RVN":"Europe/Helsinki","RVO":"Africa/Johannesburg","RVR":"America/Denver","RVS":"America/Chicago","RVT":"Australia/Perth","RVV":"Pacific/Tahiti","RVY":"America/Montevideo","RWB":"America/Anchorage","RWF":"America/Chicago","RWI":"America/New_York","RWL":"America/Denver","RWN":"Europe/Kiev","RWS":"America/Sao_Paulo","RXA":"Asia/Aden","RXE":"America/Denver","RXS":"Asia/Manila","RYB":"Europe/Moscow","RYG":"Europe/Oslo","RYK":"Asia/Karachi","RYL":"Africa/Lusaka","RYN":"Europe/Paris","RYO":"America/Argentina/Buenos_Aires","RZA":"America/Argentina/Buenos_Aires","RZE":"Europe/Warsaw","RZH":"Asia/Vladivostok","RZN":"Europe/Moscow","RZP":"Asia/Manila","RZR":"Asia/Tehran","RZS":"Asia/Karachi","RZZ":"America/New_York","SAA":"America/Denver","SAB":"America/Curacao","SAC":"America/Los_Angeles","SAD":"America/Phoenix","SAE":"America/Godthab","SAF":"America/Denver","SAG":"Asia/Kolkata","SAH":"Asia/Aden","SAI":"Europe/San_Marino","SAK":"Atlantic/Reykjavik","SAL":"America/El_Salvador","SAM":"Pacific/Port_Moresby","SAN":"America/Los_Angeles","SAP":"America/Tegucigalpa","SAQ":"America/Nassau","SAR":"America/Chicago","SAS":"America/Los_Angeles","SAT":"America/Chicago","SAU":"Asia/Makassar","SAV":"America/New_York","SAW":"Europe/Istanbul","SAX":"America/Panama","SAY":"Europe/Rome","SAZ":"Africa/Monrovia","SBA":"America/Los_Angeles","SBB":"America/Caracas","SBC":"Pacific/Port_Moresby","SBD":"America/Los_Angeles","SBE":"Pacific/Port_Moresby","SBF":"Asia/Kabul","SBG":"Asia/Jakarta","SBH":"America/Guadeloupe","SBI":"Africa/Conakry","SBJ":"America/Sao_Paulo","SBK":"Europe/Paris","SBL":"America/La_Paz","SBM":"America/Chicago","SBN":"America/Indiana/Indianapolis","SBO":"America/Denver","SBP":"America/Los_Angeles","SBQ":"Asia/Karachi","SBR":"Australia/Brisbane","SBS":"America/Denver","SBT":"Asia/Yekaterinburg","SBU":"Africa/Johannesburg","SBV":"Pacific/Bougainville","SBW":"Asia/Kuala_Lumpur","SBX":"America/Denver","SBY":"America/New_York","SBZ":"Europe/Bucharest","SCA":"America/Bogota","SCB":"America/Chicago","SCC":"America/Anchorage","SCD":"America/Tegucigalpa","SCE":"America/New_York","SCF":"America/Phoenix","SCG":"Australia/Brisbane","SCH":"America/New_York","SCI":"America/Caracas","SCJ":"America/Anchorage","SCK":"America/Los_Angeles","SCL":"America/Santiago","SCM":"America/Anchorage","SCN":"Europe/Berlin","SCO":"Asia/Aqtau","SCP":"Europe/Paris","SCQ":"Europe/Madrid","SCR":"Europe/Stockholm","SCS":"Europe/London","SCT":"Asia/Aden","SCU":"America/Havana","SCV":"Europe/Bucharest","SCW":"Europe/Moscow","SCX":"America/Mexico_City","SCY":"Pacific/Galapagos","SCZ":"Pacific/Guadalcanal","SDB":"Africa/Johannesburg","SDC":"America/Guyana","SDD":"Africa/Luanda","SDE":"America/Argentina/Buenos_Aires","SDF":"America/New_York","SDG":"Asia/Tehran","SDH":"America/Tegucigalpa","SDI":"Pacific/Port_Moresby","SDJ":"Asia/Tokyo","SDK":"Asia/Kuala_Lumpur","SDL":"Europe/Stockholm","SDM":"America/Los_Angeles","SDN":"Europe/Oslo","SDO":"Asia/Tokyo","SDP":"America/Anchorage","SDQ":"America/Santo_Domingo","SDR":"Europe/Madrid","SDS":"Asia/Tokyo","SDT":"Asia/Karachi","SDU":"America/Sao_Paulo","SDV":"Asia/Jerusalem","SDW":"Asia/Dhaka","SDX":"America/Phoenix","SDY":"America/Denver","SEA":"America/Los_Angeles","SEB":"Africa/Tripoli","SEC":"Europe/Paris","SED":"Asia/Jerusalem","SEE":"America/Los_Angeles","SEF":"America/New_York","SEG":"America/New_York","SEH":"Asia/Jayapura","SEK":"Asia/Magadan","SEM":"America/Chicago","SEN":"Europe/London","SEO":"Africa/Abidjan","SEP":"America/Chicago","SEQ":"Asia/Jakarta","SER":"America/Indiana/Indianapolis","SES":"America/Chicago","SET":"America/Belem","SEU":"Africa/Dar_es_Salaam","SEV":"Europe/Kiev","SEW":"Africa/Cairo","SEX":"Europe/Berlin","SEY":"Africa/Nouakchott","SEZ":"Indian/Mahe","SFA":"Africa/Tunis","SFB":"America/New_York","SFC":"America/Guadeloupe","SFD":"America/Caracas","SFE":"Asia/Manila","SFF":"America/Los_Angeles","SFG":"America/Marigot","SFH":"America/Tijuana","SFI":"Africa/Casablanca","SFJ":"America/Godthab","SFK":"America/Belem","SFL":"Atlantic/Cape_Verde","SFM":"America/New_York","SFN":"America/Argentina/Buenos_Aires","SFO":"America/Los_Angeles","SFP":"Australia/Brisbane","SFR":"America/Los_Angeles","SFS":"Asia/Manila","SFT":"Europe/Stockholm","SFU":"Pacific/Port_Moresby","SFV":"America/Sao_Paulo","SFW":"America/Panama","SFX":"America/Caracas","SFZ":"America/New_York","SGA":"Asia/Kabul","SGB":"Pacific/Port_Moresby","SGC":"Asia/Yekaterinburg","SGD":"Europe/Copenhagen","SGE":"Europe/Berlin","SGF":"America/Chicago","SGG":"America/Godthab","SGH":"America/New_York","SGI":"Asia/Karachi","SGJ":"Pacific/Port_Moresby","SGK":"Pacific/Port_Moresby","SGL":"Asia/Manila","SGM":"America/Mazatlan","SGN":"Asia/Ho_Chi_Minh","SGO":"Australia/Brisbane","SGP":"Australia/Perth","SGQ":"Asia/Makassar","SGR":"America/Chicago","SGT":"America/Chicago","SGU":"America/Denver","SGV":"America/Argentina/Buenos_Aires","SGW":"America/Anchorage","SGX":"Africa/Dar_es_Salaam","SGY":"America/Anchorage","SGZ":"Asia/Bangkok","SHA":"Asia/Shanghai","SHB":"Asia/Tokyo","SHC":"Africa/Addis_Ababa","SHD":"America/New_York","SHE":"Asia/Shanghai","SHF":"Asia/Shanghai","SHG":"America/Anchorage","SHH":"America/Anchorage","SHI":"Asia/Tokyo","SHJ":"Asia/Dubai","SHK":"Africa/Maseru","SHL":"Asia/Kolkata","SHM":"Asia/Tokyo","SHN":"America/Los_Angeles","SHO":"Africa/Mbabane","SHP":"Asia/Shanghai","SHQ":"Australia/Brisbane","SHR":"America/Denver","SHS":"Asia/Shanghai","SHT":"Australia/Sydney","SHU":"Australia/Darwin","SHV":"America/Chicago","SHW":"Asia/Riyadh","SHX":"America/Anchorage","SHY":"Africa/Dar_es_Salaam","SHZ":"Africa/Maseru","SIA":"Asia/Shanghai","SIB":"Africa/Brazzaville","SIC":"America/Panama","SID":"Atlantic/Cape_Verde","SIE":"Europe/Lisbon","SIF":"Asia/Kathmandu","SIG":"America/Puerto_Rico","SIH":"Asia/Kathmandu","SII":"Africa/Casablanca","SIJ":"Atlantic/Reykjavik","SIK":"America/Chicago","SIL":"Pacific/Port_Moresby","SIM":"Pacific/Port_Moresby","SIN":"Asia/Singapore","SIO":"Australia/Hobart","SIP":"Europe/Simferopol","SIQ":"Asia/Jakarta","SIR":"Europe/Zurich","SIS":"Africa/Johannesburg","SIT":"America/Anchorage","SIU":"America/Managua","SIV":"America/Indiana/Indianapolis","SIX":"Australia/Sydney","SIY":"America/Los_Angeles","SIZ":"Pacific/Port_Moresby","SJA":"America/Lima","SJB":"America/La_Paz","SJC":"America/Los_Angeles","SJD":"America/Mazatlan","SJE":"America/Bogota","SJF":"America/St_Thomas","SJG":"America/Bogota","SJH":"America/Bogota","SJI":"Asia/Manila","SJJ":"Europe/Sarajevo","SJK":"America/Sao_Paulo","SJL":"America/Porto_Velho","SJM":"America/Santo_Domingo","SJN":"America/Phoenix","SJO":"America/Costa_Rica","SJP":"America/Sao_Paulo","SJQ":"Africa/Lusaka","SJR":"America/Bogota","SJS":"America/La_Paz","SJT":"America/Chicago","SJU":"America/Puerto_Rico","SJV":"America/La_Paz","SJW":"Asia/Shanghai","SJX":"America/Belize","SJY":"Europe/Helsinki","SJZ":"Atlantic/Azores","SKA":"America/Los_Angeles","SKB":"America/St_Kitts","SKC":"Pacific/Port_Moresby","SKD":"Asia/Tashkent","SKE":"Europe/Oslo","SKF":"America/Chicago","SKG":"Europe/Athens","SKH":"Asia/Kathmandu","SKI":"Africa/Algiers","SKJ":"America/Anchorage","SKK":"America/Anchorage","SKL":"Europe/London","SKM":"America/Guyana","SKN":"Europe/Oslo","SKO":"Africa/Lagos","SKP":"Europe/Skopje","SKQ":"Africa/Maseru","SKR":"Africa/Addis_Ababa","SKS":"Europe/Copenhagen","SKT":"Asia/Karachi","SKU":"Europe/Athens","SKV":"Africa/Cairo","SKW":"America/Anchorage","SKX":"Europe/Moscow","SKY":"America/New_York","SKZ":"Asia/Karachi","SLA":"America/Argentina/Buenos_Aires","SLB":"America/Chicago","SLC":"America/Denver","SLD":"Europe/Bratislava","SLE":"America/Los_Angeles","SLF":"Asia/Riyadh","SLG":"America/Chicago","SLH":"Pacific/Efate","SLI":"Africa/Lusaka","SLJ":"Australia/Perth","SLK":"America/New_York","SLL":"Asia/Muscat","SLM":"Europe/Madrid","SLN":"America/Chicago","SLO":"America/Chicago","SLP":"America/Mexico_City","SLQ":"America/Anchorage","SLR":"America/Chicago","SLS":"Europe/Sofia","SLT":"America/Denver","SLU":"America/St_Lucia","SLV":"Asia/Kolkata","SLW":"America/Mexico_City","SLX":"America/Grand_Turk","SLY":"Asia/Yekaterinburg","SLZ":"America/Belem","SMA":"Atlantic/Azores","SMB":"America/Santiago","SMC":"America/Bogota","SMD":"America/Indiana/Indianapolis","SME":"America/New_York","SMF":"America/Los_Angeles","SMG":"America/Lima","SMH":"Pacific/Port_Moresby","SMI":"Europe/Athens","SMJ":"Pacific/Port_Moresby","SMK":"America/Anchorage","SML":"America/Nassau","SMM":"Asia/Kuala_Lumpur","SMN":"America/Denver","SMO":"America/Los_Angeles","SMP":"Pacific/Port_Moresby","SMQ":"Asia/Jakarta","SMR":"America/Bogota","SMS":"Indian/Antananarivo","SMT":"America/Campo_Grande","SMU":"America/Anchorage","SMV":"Europe/Zurich","SMW":"Africa/Casablanca","SMX":"America/Los_Angeles","SMY":"Africa/Dakar","SMZ":"America/Paramaribo","SNA":"America/Los_Angeles","SNB":"Australia/Darwin","SNC":"America/Guayaquil","SND":"Asia/Vientiane","SNE":"Atlantic/Cape_Verde","SNF":"America/Caracas","SNG":"America/La_Paz","SNH":"Australia/Brisbane","SNI":"Africa/Monrovia","SNJ":"America/Havana","SNK":"America/Chicago","SNL":"America/Chicago","SNM":"America/La_Paz","SNN":"Europe/Dublin","SNO":"Asia/Bangkok","SNP":"America/Anchorage","SNQ":"America/Tijuana","SNR":"Europe/Paris","SNS":"America/Los_Angeles","SNT":"America/Bogota","SNU":"America/Havana","SNV":"America/Caracas","SNW":"Asia/Yangon","SNX":"Asia/Tehran","SNY":"America/Denver","SNZ":"America/Belem","SOA":"Asia/Ho_Chi_Minh","SOB":"Europe/Budapest","SOC":"Asia/Jakarta","SOD":"America/Sao_Paulo","SOE":"Africa/Brazzaville","SOF":"Europe/Sofia","SOG":"Europe/Oslo","SOH":"America/Bogota","SOI":"Australia/Brisbane","SOJ":"Europe/Oslo","SOK":"Africa/Maseru","SOL":"America/Anchorage","SOM":"America/Caracas","SON":"Pacific/Efate","SOO":"Europe/Stockholm","SOP":"America/New_York","SOQ":"Asia/Jayapura","SOR":"Asia/Damascus","SOT":"Europe/Helsinki","SOU":"Europe/London","SOV":"America/Anchorage","SOW":"America/Phoenix","SOX":"America/Bogota","SOY":"Europe/London","SOZ":"Europe/Paris","SPA":"America/New_York","SPB":"America/St_Thomas","SPC":"Atlantic/Canary","SPD":"Asia/Dhaka","SPE":"Asia/Kuala_Lumpur","SPF":"America/Denver","SPG":"America/New_York","SPH":"Pacific/Port_Moresby","SPI":"America/Chicago","SPJ":"Europe/Athens","SPM":"Europe/Berlin","SPN":"Pacific/Saipan","SPO":"Europe/Madrid","SPP":"Africa/Luanda","SPQ":"America/Los_Angeles","SPR":"America/Belize","SPS":"America/Chicago","SPT":"Asia/Kuala_Lumpur","SPU":"Europe/Zagreb","SPV":"Pacific/Port_Moresby","SPW":"America/Chicago","SPX":"Africa/Cairo","SPY":"Africa/Abidjan","SPZ":"America/Chicago","SQA":"America/Los_Angeles","SQB":"America/Bogota","SQC":"Australia/Perth","SQD":"Asia/Shanghai","SQE":"America/Bogota","SQF":"America/Bogota","SQG":"Asia/Jakarta","SQH":"Asia/Ho_Chi_Minh","SQI":"America/Chicago","SQJ":"Asia/Shanghai","SQK":"Africa/Cairo","SQL":"America/Los_Angeles","SQM":"America/Sao_Paulo","SQN":"Asia/Jayapura","SQO":"Europe/Stockholm","SQP":"Australia/Brisbane","SQQ":"Europe/Vilnius","SQR":"Asia/Jayapura","SQS":"America/Belize","SQT":"Pacific/Port_Moresby","SQU":"America/Lima","SQV":"America/Los_Angeles","SQW":"Europe/Copenhagen","SQX":"America/Sao_Paulo","SQY":"America/Sao_Paulo","SQZ":"Europe/London","SRA":"America/Sao_Paulo","SRB":"America/La_Paz","SRC":"America/Chicago","SRD":"America/La_Paz","SRE":"America/La_Paz","SRF":"America/Los_Angeles","SRG":"Asia/Jakarta","SRH":"Africa/Ndjamena","SRI":"Asia/Makassar","SRJ":"America/La_Paz","SRK":"America/Thule","SRL":"America/Mazatlan","SRM":"Australia/Brisbane","SRN":"Australia/Hobart","SRO":"America/Bogota","SRP":"Europe/Oslo","SRQ":"America/New_York","SRS":"America/Bogota","SRT":"Africa/Kampala","SRU":"America/Los_Angeles","SRV":"America/Anchorage","SRW":"America/New_York","SRX":"Africa/Tripoli","SRY":"Asia/Tehran","SRZ":"America/La_Paz","SSA":"America/Belem","SSB":"America/St_Thomas","SSC":"America/New_York","SSD":"America/Bogota","SSE":"Asia/Kolkata","SSF":"America/Chicago","SSG":"Africa/Malabo","SSH":"Africa/Cairo","SSI":"America/New_York","SSJ":"Europe/Oslo","SSK":"Australia/Perth","SSL":"America/Bogota","SSM":"America/New_York","SSN":"Asia/Seoul","SSO":"America/Sao_Paulo","SSP":"Australia/Brisbane","SSQ":"America/Toronto","SSR":"Pacific/Efate","SSS":"Pacific/Port_Moresby","SST":"America/Argentina/Buenos_Aires","SSU":"America/New_York","SSV":"Asia/Manila","SSW":"America/Los_Angeles","SSX":"Africa/Johannesburg","SSY":"Africa/Luanda","SSZ":"America/Sao_Paulo","STA":"Europe/Copenhagen","STB":"America/Caracas","STC":"America/Chicago","STD":"America/Caracas","STE":"America/Chicago","STF":"Australia/Brisbane","STG":"America/Anchorage","STH":"Australia/Brisbane","STI":"America/Santo_Domingo","STJ":"America/Chicago","STK":"America/Denver","STL":"America/Chicago","STM":"America/Belem","STN":"Europe/London","STP":"America/Chicago","STQ":"America/New_York","STR":"Europe/Berlin","STS":"America/Los_Angeles","STT":"America/St_Thomas","STV":"Asia/Kolkata","STW":"Europe/Moscow","STX":"America/St_Thomas","STY":"America/Montevideo","STZ":"America/Campo_Grande","SUA":"America/New_York","SUB":"Asia/Jakarta","SUC":"America/Denver","SUD":"America/Chicago","SUE":"America/Chicago","SUF":"Europe/Rome","SUG":"Asia/Manila","SUH":"Asia/Muscat","SUI":"Asia/Tbilisi","SUJ":"Europe/Bucharest","SUK":"Asia/Vladivostok","SUL":"Asia/Karachi","SUM":"America/New_York","SUN":"America/Denver","SUO":"America/Los_Angeles","SUP":"Asia/Jakarta","SUQ":"America/Guayaquil","SUR":"America/Toronto","SUS":"America/Chicago","SUT":"Africa/Dar_es_Salaam","SUU":"America/Los_Angeles","SUV":"Pacific/Fiji","SUW":"America/Chicago","SUX":"America/Chicago","SUY":"Asia/Yakutsk","SUZ":"Pacific/Port_Moresby","SVA":"America/Anchorage","SVB":"Indian/Antananarivo","SVC":"America/Denver","SVD":"America/St_Vincent","SVE":"America/Los_Angeles","SVF":"Africa/Porto-Novo","SVG":"Europe/Oslo","SVH":"America/New_York","SVI":"America/Bogota","SVJ":"Europe/Oslo","SVK":"America/Belize","SVL":"Europe/Helsinki","SVM":"Australia/Brisbane","SVN":"America/New_York","SVO":"Europe/Moscow","SVP":"Africa/Luanda","SVQ":"Europe/Madrid","SVR":"America/Thule","SVS":"America/Anchorage","SVT":"Africa/Gaborone","SVU":"Pacific/Fiji","SVV":"America/Caracas","SVW":"America/Anchorage","SVX":"Asia/Yekaterinburg","SVY":"Pacific/Guadalcanal","SVZ":"America/Caracas","SWA":"Asia/Shanghai","SWB":"Australia/Perth","SWC":"Australia/Sydney","SWD":"America/Anchorage","SWE":"Pacific/Port_Moresby","SWF":"America/New_York","SWG":"Pacific/Port_Moresby","SWH":"Australia/Sydney","SWI":"Europe/London","SWJ":"Pacific/Efate","SWL":"Asia/Manila","SWM":"America/Campo_Grande","SWN":"Asia/Karachi","SWO":"America/Chicago","SWP":"Africa/Windhoek","SWQ":"Asia/Makassar","SWR":"Pacific/Port_Moresby","SWS":"Europe/London","SWT":"Asia/Omsk","SWU":"Asia/Seoul","SWV":"Asia/Magadan","SWW":"America/Chicago","SWX":"Africa/Gaborone","SWY":"Asia/Kuala_Lumpur","SWZ":"Australia/Sydney","SXA":"Pacific/Port_Moresby","SXB":"Europe/Paris","SXD":"Europe/Paris","SXE":"Australia/Sydney","SXF":"Europe/Berlin","SXG":"Africa/Lusaka","SXH":"Pacific/Port_Moresby","SXI":"Asia/Tehran","SXJ":"Asia/Shanghai","SXK":"Asia/Jayapura","SXL":"Europe/Dublin","SXM":"America/Curacao","SXN":"Africa/Gaborone","SXO":"America/Campo_Grande","SXP":"America/Anchorage","SXQ":"America/Anchorage","SXR":"Asia/Kolkata","SXS":"Asia/Kuala_Lumpur","SXT":"Asia/Kuala_Lumpur","SXU":"Africa/Addis_Ababa","SXV":"Asia/Kolkata","SXW":"Pacific/Port_Moresby","SXX":"America/Belem","SXY":"America/New_York","SXZ":"Europe/Istanbul","SYA":"America/Adak","SYB":"America/Anchorage","SYC":"America/Lima","SYD":"Australia/Sydney","SYE":"Asia/Aden","SYF":"America/Vancouver","SYG":"Europe/Oslo","SYI":"America/Chicago","SYJ":"Asia/Tehran","SYK":"Atlantic/Reykjavik","SYL":"America/Los_Angeles","SYM":"Asia/Shanghai","SYN":"America/Chicago","SYO":"Asia/Tokyo","SYP":"America/Panama","SYQ":"America/Costa_Rica","SYR":"America/New_York","SYS":"Asia/Yakutsk","SYT":"Europe/Paris","SYU":"Australia/Brisbane","SYV":"America/New_York","SYW":"Asia/Karachi","SYX":"Asia/Shanghai","SYY":"Europe/London","SYZ":"Asia/Tehran","SZA":"Africa/Luanda","SZB":"Asia/Kuala_Lumpur","SZC":"America/Costa_Rica","SZD":"Europe/London","SZE":"Africa/Addis_Ababa","SZF":"Europe/Istanbul","SZG":"Europe/Vienna","SZH":"Asia/Makassar","SZI":"Asia/Almaty","SZJ":"America/Havana","SZK":"Africa/Johannesburg","SZL":"America/Chicago","SZM":"Africa/Windhoek","SZN":"America/Los_Angeles","SZO":"Asia/Shanghai","SZP":"America/Los_Angeles","SZQ":"America/Argentina/Buenos_Aires","SZR":"Europe/Sofia","SZS":"Pacific/Auckland","SZT":"America/Mexico_City","SZU":"Africa/Bamako","SZV":"Asia/Shanghai","SZW":"Europe/Berlin","SZX":"Asia/Shanghai","SZY":"Europe/Warsaw","SZZ":"Europe/Warsaw","TAA":"Pacific/Guadalcanal","TAB":"America/Port_of_Spain","TAC":"Asia/Manila","TAD":"America/Denver","TAE":"Asia/Seoul","TAF":"Africa/Algiers","TAG":"Asia/Manila","TAH":"Pacific/Efate","TAI":"Asia/Aden","TAJ":"Pacific/Port_Moresby","TAK":"Asia/Tokyo","TAL":"America/Anchorage","TAM":"America/Mexico_City","TAN":"Australia/Brisbane","TAO":"Asia/Shanghai","TAP":"America/Mexico_City","TAQ":"Australia/Adelaide","TAR":"Europe/Rome","TAS":"Asia/Tashkent","TAT":"Europe/Bratislava","TAU":"America/Bogota","TAV":"Pacific/Pago_Pago","TAW":"America/Montevideo","TAX":"Asia/Jayapura","TAY":"Europe/Tallinn","TAZ":"Asia/Ashgabat","TBA":"Pacific/Port_Moresby","TBB":"Asia/Ho_Chi_Minh","TBC":"America/Phoenix","TBD":"America/Bogota","TBE":"Pacific/Port_Moresby","TBF":"Pacific/Tarawa","TBG":"Pacific/Port_Moresby","TBH":"Asia/Manila","TBI":"America/Nassau","TBJ":"Africa/Tunis","TBK":"Australia/Darwin","TBL":"Australia/Perth","TBM":"Asia/Pontianak","TBN":"America/Chicago","TBO":"Africa/Dar_es_Salaam","TBP":"America/Lima","TBR":"America/New_York","TBS":"Asia/Tbilisi","TBT":"America/Rio_Branco","TBU":"Pacific/Tongatapu","TBV":"Pacific/Majuro","TBW":"Europe/Moscow","TBY":"Africa/Gaborone","TBZ":"Asia/Tehran","TCA":"Australia/Darwin","TCB":"America/Nassau","TCC":"America/Denver","TCD":"America/Bogota","TCE":"Europe/Bucharest","TCF":"America/Tegucigalpa","TCG":"Asia/Shanghai","TCH":"Africa/Libreville","TCJ":"Pacific/Port_Moresby","TCK":"Pacific/Port_Moresby","TCL":"America/Chicago","TCM":"America/Los_Angeles","TCN":"America/Mexico_City","TCO":"America/Bogota","TCP":"Africa/Cairo","TCQ":"America/Lima","TCR":"Asia/Kolkata","TCS":"America/Denver","TCT":"America/Anchorage","TCU":"Africa/Johannesburg","TCV":"Africa/Maputo","TCW":"Australia/Sydney","TCX":"Asia/Tehran","TCY":"Africa/Windhoek","TCZ":"Asia/Shanghai","TDA":"America/Bogota","TDB":"Pacific/Port_Moresby","TDD":"America/La_Paz","TDG":"Asia/Manila","TDJ":"Africa/Djibouti","TDK":"Asia/Almaty","TDL":"America/Argentina/Buenos_Aires","TDN":"Australia/Perth","TDO":"America/Los_Angeles","TDR":"Australia/Brisbane","TDT":"Africa/Johannesburg","TDV":"Indian/Antananarivo","TDW":"America/Chicago","TDX":"Asia/Bangkok","TDZ":"America/New_York","TEA":"America/Tegucigalpa","TEB":"America/New_York","TEC":"America/Sao_Paulo","TED":"Europe/Copenhagen","TEE":"Africa/Algiers","TEF":"Australia/Perth","TEG":"Africa/Ouagadougou","TEH":"America/Anchorage","TEI":"Asia/Kolkata","TEK":"America/Anchorage","TEL":"Asia/Kuala_Lumpur","TEM":"Australia/Sydney","TEN":"Asia/Shanghai","TEO":"Pacific/Port_Moresby","TEP":"Pacific/Port_Moresby","TEQ":"Europe/Istanbul","TER":"Atlantic/Azores","TES":"Africa/Asmara","TET":"Africa/Maputo","TEU":"Pacific/Auckland","TEV":"Europe/Madrid","TEX":"America/Denver","TEY":"Atlantic/Reykjavik","TEZ":"Asia/Kolkata","TFB":"Pacific/Port_Moresby","TFF":"America/Porto_Velho","TFI":"Pacific/Port_Moresby","TFL":"America/Sao_Paulo","TFM":"Pacific/Port_Moresby","TFN":"Atlantic/Canary","TFR":"Africa/Cairo","TFS":"Atlantic/Canary","TFT":"Asia/Karachi","TFU":"Asia/Shanghai","TFY":"Africa/Casablanca","TGA":"Asia/Singapore","TGB":"Asia/Manila","TGC":"Asia/Kuala_Lumpur","TGD":"Europe/Podgorica","TGE":"America/Chicago","TGF":"Europe/Paris","TGG":"Asia/Kuala_Lumpur","TGH":"Pacific/Efate","TGI":"America/Lima","TGJ":"Pacific/Noumea","TGK":"Europe/Moscow","TGL":"Pacific/Port_Moresby","TGM":"Europe/Bucharest","TGN":"Australia/Sydney","TGO":"Asia/Shanghai","TGP":"Asia/Krasnoyarsk","TGQ":"America/Campo_Grande","TGR":"Africa/Algiers","TGS":"Africa/Maputo","TGT":"Africa/Dar_es_Salaam","TGU":"America/Tegucigalpa","TGV":"Europe/Sofia","TGZ":"America/Mexico_City","THA":"America/Chicago","THB":"Africa/Maseru","THC":"Africa/Monrovia","THD":"Asia/Ho_Chi_Minh","THE":"America/Belem","THG":"Australia/Brisbane","THH":"Pacific/Auckland","THI":"Africa/Nouakchott","THK":"Asia/Vientiane","THL":"Asia/Yangon","THM":"America/Chicago","THN":"Europe/Stockholm","THO":"Atlantic/Reykjavik","THP":"America/Denver","THQ":"Asia/Shanghai","THR":"Asia/Tehran","THS":"Asia/Bangkok","THT":"Africa/Nouakchott","THU":"America/Thule","THV":"America/New_York","THW":"Asia/Colombo","THX":"Asia/Krasnoyarsk","THY":"Africa/Johannesburg","THZ":"Africa/Niamey","TIA":"Europe/Tirane","TIB":"America/Bogota","TIC":"Pacific/Majuro","TID":"Africa/Algiers","TIE":"Africa/Addis_Ababa","TIF":"Asia/Riyadh","TIG":"Pacific/Port_Moresby","TIH":"Pacific/Tahiti","TII":"Asia/Kabul","TIJ":"America/Tijuana","TIK":"America/Chicago","TIM":"Asia/Jayapura","TIN":"Africa/Algiers","TIO":"Asia/Yangon","TIP":"Africa/Tripoli","TIQ":"Pacific/Saipan","TIR":"Asia/Kolkata","TIS":"Australia/Brisbane","TIU":"Pacific/Auckland","TIV":"Europe/Podgorica","TIW":"America/Los_Angeles","TIX":"America/New_York","TIY":"Africa/Nouakchott","TIZ":"Pacific/Port_Moresby","TJA":"America/La_Paz","TJB":"Asia/Jakarta","TJC":"America/Panama","TJG":"Asia/Makassar","TJH":"Asia/Tokyo","TJI":"America/Tegucigalpa","TJK":"Europe/Istanbul","TJL":"America/Campo_Grande","TJM":"Asia/Yekaterinburg","TJN":"Pacific/Tahiti","TJQ":"Asia/Jakarta","TJS":"Asia/Makassar","TJU":"Asia/Dushanbe","TJV":"Asia/Kolkata","TKA":"America/Anchorage","TKB":"Pacific/Port_Moresby","TKC":"Africa/Douala","TKD":"Africa/Accra","TKE":"America/Anchorage","TKF":"America/Los_Angeles","TKG":"Asia/Jakarta","TKH":"Asia/Bangkok","TKI":"America/Anchorage","TKJ":"America/Anchorage","TKK":"Pacific/Chuuk","TKL":"America/Anchorage","TKM":"America/Guatemala","TKN":"Asia/Tokyo","TKO":"Africa/Maseru","TKP":"Pacific/Tahiti","TKQ":"Africa/Dar_es_Salaam","TKR":"Asia/Dhaka","TKS":"Asia/Tokyo","TKT":"Asia/Bangkok","TKU":"Europe/Helsinki","TKV":"Pacific/Tahiti","TKW":"Pacific/Port_Moresby","TKX":"Pacific/Tahiti","TKY":"Australia/Perth","TKZ":"Pacific/Auckland","TLA":"America/Anchorage","TLB":"Asia/Karachi","TLC":"America/Mexico_City","TLD":"Africa/Gaborone","TLE":"Indian/Antananarivo","TLF":"America/Anchorage","TLG":"Pacific/Guadalcanal","TLH":"America/New_York","TLI":"Asia/Makassar","TLJ":"America/Anchorage","TLK":"Asia/Yakutsk","TLL":"Europe/Tallinn","TLM":"Africa/Algiers","TLN":"Europe/Paris","TLO":"Pacific/Port_Moresby","TLP":"Pacific/Port_Moresby","TLQ":"Asia/Shanghai","TLR":"America/Los_Angeles","TLS":"Europe/Paris","TLT":"America/Anchorage","TLU":"America/Bogota","TLV":"Asia/Jerusalem","TLW":"Pacific/Port_Moresby","TLX":"America/Santiago","TLY":"Asia/Vladivostok","TLZ":"America/Sao_Paulo","TMA":"America/New_York","TMB":"America/New_York","TMC":"Asia/Makassar","TMD":"Africa/Nouakchott","TME":"America/Bogota","TMF":"Indian/Maldives","TMG":"Asia/Kuala_Lumpur","TMH":"Asia/Jayapura","TMI":"Asia/Kathmandu","TMJ":"Asia/Tashkent","TML":"Africa/Accra","TMM":"Indian/Antananarivo","TMN":"Pacific/Tarawa","TMO":"America/Caracas","TMP":"Europe/Helsinki","TMQ":"Africa/Ouagadougou","TMR":"Africa/Algiers","TMS":"Africa/Sao_Tome","TMT":"America/Belem","TMU":"America/Costa_Rica","TMW":"Australia/Sydney","TMX":"Africa/Algiers","TMY":"Asia/Jayapura","TMZ":"Pacific/Auckland","TNA":"Asia/Shanghai","TNB":"Asia/Makassar","TNC":"America/Anchorage","TND":"America/Havana","TNE":"Asia/Tokyo","TNF":"Europe/Paris","TNG":"Africa/Casablanca","TNH":"Asia/Shanghai","TNI":"Asia/Kolkata","TNJ":"Asia/Jakarta","TNK":"America/Anchorage","TNL":"Europe/Kiev","TNM":"Antarctica/Palmer","TNN":"Asia/Taipei","TNO":"America/Costa_Rica","TNP":"America/Los_Angeles","TNQ":"Pacific/Kiritimati","TNR":"Indian/Antananarivo","TNS":"America/Edmonton","TNT":"America/New_York","TNU":"America/Chicago","TNV":"Pacific/Kiritimati","TNW":"America/Guayaquil","TNX":"Asia/Phnom_Penh","TNZ":"Asia/Ulaanbaatar","TOA":"America/Los_Angeles","TOB":"Africa/Tripoli","TOC":"America/New_York","TOD":"Asia/Kuala_Lumpur","TOE":"Africa/Tunis","TOF":"Asia/Tomsk","TOG":"America/Anchorage","TOH":"Pacific/Efate","TOI":"America/Chicago","TOJ":"Europe/Madrid","TOK":"Pacific/Bougainville","TOL":"America/New_York","TOM":"Africa/Bamako","TON":"Pacific/Bougainville","TOO":"America/Costa_Rica","TOP":"America/Chicago","TOQ":"America/Santiago","TOR":"America/Denver","TOS":"Europe/Oslo","TOT":"America/Paramaribo","TOU":"Pacific/Noumea","TOV":"America/Tortola","TOW":"America/Sao_Paulo","TOX":"Asia/Yekaterinburg","TOY":"Asia/Tokyo","TOZ":"Africa/Abidjan","TPA":"America/New_York","TPC":"America/Guayaquil","TPE":"Asia/Taipei","TPF":"America/New_York","TPG":"Asia/Kuala_Lumpur","TPH":"America/Los_Angeles","TPI":"Pacific/Port_Moresby","TPJ":"Asia/Kathmandu","TPK":"Asia/Jakarta","TPL":"America/Chicago","TPN":"America/Guayaquil","TPO":"America/Anchorage","TPP":"America/Lima","TPQ":"America/Mazatlan","TPR":"Australia/Perth","TPS":"Europe/Rome","TPT":"Africa/Monrovia","TPU":"Asia/Kathmandu","TPX":"Pacific/Tahiti","TQA":"America/Godthab","TQD":"Asia/Baghdad","TQI":"America/Godthab","TQL":"Asia/Yekaterinburg","TQN":"Asia/Kabul","TQP":"Australia/Brisbane","TQQ":"Asia/Makassar","TQR":"Europe/Rome","TQS":"America/Bogota","TRA":"Asia/Tokyo","TRB":"America/Bogota","TRC":"America/Mexico_City","TRD":"Europe/Oslo","TRE":"Europe/London","TRF":"Europe/Oslo","TRG":"Pacific/Auckland","TRH":"America/Los_Angeles","TRI":"America/New_York","TRJ":"Pacific/Port_Moresby","TRK":"Asia/Makassar","TRL":"America/Chicago","TRM":"America/Los_Angeles","TRN":"Europe/Rome","TRO":"Australia/Sydney","TRQ":"America/Rio_Branco","TRR":"Asia/Colombo","TRS":"Europe/Rome","TRT":"America/Denver","TRU":"America/Lima","TRV":"Asia/Kolkata","TRW":"Pacific/Tarawa","TRX":"America/Chicago","TRY":"Africa/Kampala","TRZ":"Asia/Kolkata","TSA":"Asia/Taipei","TSB":"Africa/Windhoek","TSC":"America/Guayaquil","TSD":"Africa/Johannesburg","TSE":"Asia/Almaty","TSF":"Europe/Rome","TSG":"America/Anchorage","TSH":"Africa/Lubumbashi","TSI":"Pacific/Port_Moresby","TSJ":"Asia/Tokyo","TSK":"Pacific/Port_Moresby","TSL":"America/Mexico_City","TSM":"America/Denver","TSN":"Asia/Shanghai","TSO":"Europe/London","TSP":"America/Los_Angeles","TSQ":"America/Sao_Paulo","TSR":"Europe/Bucharest","TSS":"America/New_York","TST":"Asia/Bangkok","TSU":"Pacific/Tarawa","TSV":"Australia/Brisbane","TSW":"Pacific/Port_Moresby","TSX":"Asia/Makassar","TSY":"Asia/Jakarta","TSZ":"Asia/Ulaanbaatar","TTA":"Africa/Casablanca","TTB":"Europe/Rome","TTC":"America/Santiago","TTD":"America/Los_Angeles","TTE":"Asia/Jayapura","TTG":"America/Argentina/Buenos_Aires","TTH":"Asia/Muscat","TTI":"Pacific/Tahiti","TTJ":"Asia/Tokyo","TTK":"Europe/London","TTL":"Pacific/Fiji","TTM":"America/Bogota","TTN":"America/New_York","TTO":"America/Chicago","TTQ":"America/Costa_Rica","TTR":"Asia/Makassar","TTS":"Indian/Antananarivo","TTT":"Asia/Taipei","TTU":"Africa/Casablanca","TUA":"America/Guayaquil","TUB":"Pacific/Tahiti","TUC":"America/Argentina/Buenos_Aires","TUD":"Africa/Dakar","TUE":"America/Panama","TUF":"Europe/Paris","TUG":"Asia/Manila","TUH":"America/Chicago","TUI":"Asia/Riyadh","TUK":"Asia/Karachi","TUL":"America/Chicago","TUM":"Australia/Sydney","TUN":"Africa/Tunis","TUO":"Pacific/Auckland","TUP":"America/Chicago","TUQ":"Africa/Ouagadougou","TUR":"America/Belem","TUS":"America/Phoenix","TUT":"Pacific/Port_Moresby","TUU":"Asia/Riyadh","TUV":"America/Caracas","TUW":"America/Panama","TUX":"America/Vancouver","TUY":"America/Mexico_City","TUZ":"America/Belem","TVA":"Indian/Antananarivo","TVC":"America/New_York","TVF":"America/Chicago","TVI":"America/New_York","TVL":"America/Los_Angeles","TVS":"Asia/Shanghai","TVU":"Pacific/Fiji","TVY":"Asia/Yangon","TWA":"America/Anchorage","TWB":"Australia/Brisbane","TWC":"Asia/Shanghai","TWD":"America/Los_Angeles","TWE":"America/Anchorage","TWF":"America/Denver","TWH":"America/Los_Angeles","TWN":"Australia/Brisbane","TWP":"Australia/Brisbane","TWT":"Asia/Manila","TWU":"Asia/Kuala_Lumpur","TWY":"Pacific/Port_Moresby","TWZ":"Pacific/Auckland","TXE":"Asia/Jakarta","TXF":"America/Belem","TXK":"America/Chicago","TXL":"Europe/Berlin","TXM":"Asia/Jayapura","TXN":"Asia/Shanghai","TXR":"Australia/Brisbane","TXU":"Africa/Abidjan","TYA":"Europe/Moscow","TYB":"Australia/Sydney","TYD":"Asia/Yakutsk","TYE":"America/Anchorage","TYF":"Europe/Stockholm","TYG":"Australia/Brisbane","TYL":"America/Lima","TYM":"America/Nassau","TYN":"Asia/Shanghai","TYP":"Australia/Darwin","TYR":"America/Chicago","TYS":"America/New_York","TYT":"America/Montevideo","TYZ":"America/Phoenix","TZA":"America/Belize","TZL":"Europe/Sarajevo","TZM":"America/Mexico_City","TZN":"America/Nassau","TZX":"Europe/Istanbul","UAB":"Europe/Istanbul","UAC":"America/Hermosillo","UAE":"Pacific/Port_Moresby","UAH":"Pacific/Marquesas","UAI":"Asia/Dili","UAK":"America/Godthab","UAL":"Africa/Luanda","UAM":"Pacific/Guam","UAP":"Pacific/Marquesas","UAQ":"America/Argentina/Buenos_Aires","UAR":"Africa/Casablanca","UAS":"Africa/Nairobi","UAX":"America/Guatemala","UBA":"America/Sao_Paulo","UBB":"Australia/Brisbane","UBI":"Pacific/Bougainville","UBJ":"Asia/Tokyo","UBN":"Asia/Ulaanbaatar","UBP":"Asia/Bangkok","UBR":"Asia/Jayapura","UBS":"America/Chicago","UBT":"America/Sao_Paulo","UBU":"Australia/Perth","UCA":"America/New_York","UCB":"Asia/Shanghai","UCC":"America/Los_Angeles","UCE":"America/Chicago","UCK":"Europe/Kiev","UCN":"Africa/Monrovia","UCT":"Europe/Moscow","UCY":"America/Chicago","UDA":"Australia/Brisbane","UDD":"America/Los_Angeles","UDE":"Europe/Amsterdam","UDI":"America/Sao_Paulo","UDJ":"Europe/Kiev","UDN":"Europe/Rome","UDO":"Asia/Vientiane","UDR":"Asia/Kolkata","UEE":"Australia/Hobart","UEL":"Africa/Maputo","UEO":"Asia/Tokyo","UER":"Europe/Madrid","UES":"America/Chicago","UET":"Asia/Karachi","UFA":"Asia/Yekaterinburg","UGA":"Asia/Ulaanbaatar","UGB":"America/Anchorage","UGC":"Asia/Tashkent","UGI":"America/Anchorage","UGL":"Antarctica/Palmer","UGN":"America/Chicago","UGO":"Africa/Luanda","UGS":"America/Anchorage","UGT":"Asia/Ulaanbaatar","UGU":"Asia/Jayapura","UHE":"Europe/Prague","UHF":"Europe/London","UIB":"America/Bogota","UIH":"Asia/Ho_Chi_Minh","UII":"America/Tegucigalpa","UIK":"Asia/Irkutsk","UIL":"America/Los_Angeles","UIN":"America/Chicago","UIO":"America/Guayaquil","UIP":"Europe/Paris","UIQ":"Pacific/Efate","UIR":"Australia/Sydney","UIT":"Pacific/Majuro","UIZ":"America/New_York","UJE":"Pacific/Majuro","UKA":"Africa/Nairobi","UKB":"Asia/Tokyo","UKG":"Asia/Vladivostok","UKH":"Asia/Muscat","UKI":"America/Los_Angeles","UKK":"Asia/Almaty","UKN":"America/Chicago","UKR":"Asia/Aden","UKS":"Europe/Simferopol","UKT":"America/New_York","UKU":"Pacific/Port_Moresby","UKX":"Asia/Irkutsk","ULA":"America/Argentina/Buenos_Aires","ULB":"Pacific/Efate","ULC":"America/Santiago","ULD":"Africa/Johannesburg","ULE":"Pacific/Port_Moresby","ULG":"Asia/Ulaanbaatar","ULH":"Asia/Riyadh","ULI":"Pacific/Chuuk","ULK":"Asia/Yakutsk","ULL":"Europe/London","ULM":"America/Chicago","ULN":"Asia/Ulaanbaatar","ULO":"Asia/Ulaanbaatar","ULP":"Australia/Brisbane","ULQ":"America/Bogota","ULS":"America/Bogota","ULU":"Africa/Kampala","ULV":"Europe/Samara","ULX":"Africa/Johannesburg","ULY":"Europe/Samara","ULZ":"Asia/Ulaanbaatar","UMB":"America/Anchorage","UMC":"Pacific/Port_Moresby","UMD":"America/Godthab","UME":"Europe/Stockholm","UMI":"America/Lima","UMM":"America/Anchorage","UMR":"Australia/Adelaide","UMS":"Asia/Yakutsk","UMT":"America/Anchorage","UMU":"America/Sao_Paulo","UMY":"Europe/Kiev","UMZ":"America/Chicago","UNA":"America/Belem","UNC":"America/Bogota","UND":"Asia/Kabul","UNE":"Africa/Maseru","UNG":"Pacific/Port_Moresby","UNI":"America/St_Vincent","UNK":"America/Anchorage","UNN":"Asia/Bangkok","UNR":"Asia/Ulaanbaatar","UNS":"America/Anchorage","UNT":"Europe/London","UNU":"America/Chicago","UOL":"Asia/Makassar","UON":"Asia/Vientiane","UOS":"America/Chicago","UOX":"America/Chicago","UPA":"America/Havana","UPB":"America/Havana","UPC":"America/Caracas","UPF":"Europe/Berlin","UPG":"Asia/Makassar","UPK":"America/Godthab","UPL":"America/Costa_Rica","UPN":"America/Mexico_City","UPP":"Pacific/Honolulu","UPR":"Pacific/Port_Moresby","UPV":"Europe/London","UQE":"America/Anchorage","URA":"Asia/Oral","URB":"America/Sao_Paulo","URC":"Asia/Shanghai","URD":"Europe/Berlin","URE":"Europe/Tallinn","URG":"America/Sao_Paulo","URI":"America/Bogota","URJ":"Asia/Yekaterinburg","URM":"America/Caracas","URN":"Asia/Kabul","URO":"Europe/Paris","URR":"America/Bogota","URS":"Europe/Moscow","URT":"Asia/Bangkok","URU":"Pacific/Port_Moresby","URY":"Asia/Riyadh","URZ":"Asia/Kabul","USA":"America/New_York","USH":"America/Argentina/Buenos_Aires","USI":"America/Guyana","USJ":"Asia/Almaty","USK":"Europe/Moscow","USL":"Australia/Perth","USM":"Asia/Bangkok","USN":"Asia/Seoul","USO":"Pacific/Port_Moresby","USQ":"Europe/Istanbul","USR":"Asia/Vladivostok","USS":"America/Havana","UST":"America/New_York","USU":"Asia/Manila","UTA":"Africa/Harare","UTB":"Australia/Brisbane","UTC":"Europe/Amsterdam","UTD":"Australia/Darwin","UTE":"Africa/Johannesburg","UTG":"Africa/Maseru","UTH":"Asia/Bangkok","UTI":"Europe/Helsinki","UTK":"Pacific/Majuro","UTM":"America/Chicago","UTN":"Africa/Johannesburg","UTO":"America/Anchorage","UTP":"Asia/Bangkok","UTR":"Asia/Bangkok","UTS":"Europe/Moscow","UTT":"Africa/Johannesburg","UTU":"America/Panama","UTW":"Africa/Johannesburg","UUA":"Europe/Moscow","UUD":"Asia/Irkutsk","UUK":"America/Anchorage","UUN":"Asia/Ulaanbaatar","UUS":"Asia/Sakhalin","UUU":"Pacific/Port_Moresby","UVA":"America/Chicago","UVE":"Pacific/Noumea","UVF":"America/St_Lucia","UVI":"America/Sao_Paulo","UVL":"Africa/Cairo","UVO":"Pacific/Port_Moresby","UWA":"America/New_York","UYL":"Africa/Khartoum","UYN":"Asia/Shanghai","UYU":"America/La_Paz","UZC":"Europe/Belgrade","UZH":"Asia/Riyadh","UZR":"Asia/Almaty","UZU":"America/Argentina/Buenos_Aires","VAA":"Europe/Helsinki","VAB":"America/Bogota","VAC":"Europe/Berlin","VAD":"America/New_York","VAF":"Europe/Paris","VAG":"America/Sao_Paulo","VAH":"America/La_Paz","VAI":"Pacific/Port_Moresby","VAK":"America/Anchorage","VAL":"America/Belem","VAM":"Indian/Maldives","VAN":"Europe/Istanbul","VAO":"Pacific/Guadalcanal","VAP":"America/Santiago","VAR":"Europe/Sofia","VAS":"Europe/Istanbul","VAT":"Indian/Antananarivo","VAU":"Pacific/Fiji","VAV":"Pacific/Tongatapu","VAW":"Europe/Oslo","VAZ":"Europe/Paris","VBA":"Asia/Yangon","VBC":"Asia/Yangon","VBG":"America/Los_Angeles","VBM":"America/Anchorage","VBP":"Asia/Yangon","VBS":"Europe/Rome","VBV":"Pacific/Fiji","VBY":"Europe/Stockholm","VCA":"Asia/Ho_Chi_Minh","VCB":"America/Anchorage","VCC":"Africa/Douala","VCD":"Australia/Darwin","VCE":"Europe/Rome","VCF":"America/Argentina/Buenos_Aires","VCH":"America/Montevideo","VCL":"Asia/Ho_Chi_Minh","VCP":"America/Sao_Paulo","VCR":"America/Caracas","VCS":"Asia/Ho_Chi_Minh","VCT":"America/Chicago","VCV":"America/Los_Angeles","VDA":"Asia/Jerusalem","VDB":"Europe/Oslo","VDC":"America/Belem","VDE":"Atlantic/Canary","VDF":"America/New_York","VDH":"Asia/Ho_Chi_Minh","VDI":"America/New_York","VDM":"America/Argentina/Buenos_Aires","VDO":"Asia/Ho_Chi_Minh","VDP":"America/Caracas","VDR":"America/Argentina/Buenos_Aires","VDS":"Europe/Oslo","VDU":"America/Chicago","VDY":"Asia/Kolkata","VDZ":"America/Anchorage","VEE":"America/Anchorage","VEG":"America/Guyana","VEJ":"Europe/Copenhagen","VEL":"America/Denver","VER":"America/Mexico_City","VEV":"Pacific/Guadalcanal","VEX":"America/Chicago","VEY":"Atlantic/Reykjavik","VFA":"Africa/Harare","VGA":"Asia/Kolkata","VGD":"Europe/Moscow","VGO":"Europe/Madrid","VGS":"America/Argentina/Buenos_Aires","VGT":"America/Los_Angeles","VGZ":"America/Bogota","VHC":"Africa/Luanda","VHM":"Europe/Stockholm","VHN":"America/Chicago","VHO":"Africa/Maputo","VHV":"Asia/Yakutsk","VHY":"Europe/Paris","VHZ":"Pacific/Tahiti","VIA":"America/Sao_Paulo","VIB":"America/Mazatlan","VIC":"Europe/Rome","VID":"Europe/Sofia","VIE":"Europe/Vienna","VIF":"Europe/Rome","VIG":"America/Caracas","VIH":"America/Chicago","VII":"Asia/Ho_Chi_Minh","VIJ":"America/Tortola","VIL":"Africa/Casablanca","VIN":"Europe/Kiev","VIQ":"Asia/Jayapura","VIR":"Africa/Johannesburg","VIS":"America/Los_Angeles","VIT":"Europe/Madrid","VIU":"Pacific/Guadalcanal","VIV":"Pacific/Port_Moresby","VIX":"America/Sao_Paulo","VIY":"Europe/Paris","VJB":"Africa/Maputo","VJI":"America/New_York","VJQ":"Africa/Maputo","VKG":"Asia/Ho_Chi_Minh","VKO":"Europe/Moscow","VKS":"America/Chicago","VKT":"Europe/Moscow","VKW":"America/Anchorage","VLA":"America/Chicago","VLC":"Europe/Madrid","VLD":"America/New_York","VLE":"America/Phoenix","VLG":"America/Argentina/Buenos_Aires","VLI":"Pacific/Efate","VLK":"Europe/Moscow","VLL":"Europe/Madrid","VLM":"America/La_Paz","VLN":"America/Caracas","VLO":"America/Los_Angeles","VLP":"America/Campo_Grande","VLR":"America/Santiago","VLS":"Pacific/Efate","VLU":"Europe/Moscow","VLV":"America/Caracas","VLY":"Europe/London","VME":"America/Argentina/Buenos_Aires","VMI":"America/Asuncion","VMU":"Pacific/Port_Moresby","VNA":"Asia/Vientiane","VNC":"America/New_York","VND":"Indian/Antananarivo","VNE":"Europe/Paris","VNG":"Asia/Vientiane","VNO":"Europe/Vilnius","VNR":"Australia/Brisbane","VNS":"Asia/Kolkata","VNX":"Africa/Maputo","VNY":"America/Los_Angeles","VOG":"Europe/Samara","VOH":"Indian/Antananarivo","VOI":"Africa/Monrovia","VOK":"America/Chicago","VOL":"Europe/Athens","VOT":"America/Sao_Paulo","VOZ":"Europe/Moscow","VPE":"Africa/Luanda","VPG":"Africa/Nairobi","VPN":"Atlantic/Reykjavik","VPS":"America/Chicago","VPY":"Africa/Maputo","VPZ":"America/Chicago","VQQ":"America/New_York","VQS":"America/Puerto_Rico","VRA":"America/Havana","VRB":"America/New_York","VRC":"Asia/Manila","VRE":"Africa/Johannesburg","VRK":"Europe/Helsinki","VRL":"Europe/Lisbon","VRN":"Europe/Rome","VRO":"America/Havana","VRS":"America/Chicago","VRU":"Africa/Johannesburg","VRY":"Europe/Oslo","VSA":"America/Mexico_City","VSE":"Europe/Lisbon","VSF":"America/New_York","VSO":"Asia/Ho_Chi_Minh","VST":"Europe/Stockholm","VTA":"America/Tegucigalpa","VTB":"Europe/Minsk","VTE":"Asia/Vientiane","VTF":"Pacific/Fiji","VTG":"Asia/Ho_Chi_Minh","VTL":"Europe/Paris","VTM":"Asia/Jerusalem","VTN":"America/Chicago","VTU":"America/Havana","VTZ":"Asia/Kolkata","VUP":"America/Bogota","VUS":"Europe/Moscow","VUU":"Africa/Blantyre","VVB":"Indian/Antananarivo","VVC":"America/Bogota","VVI":"America/La_Paz","VVK":"Europe/Stockholm","VVN":"America/Lima","VVO":"Asia/Vladivostok","VVZ":"Africa/Algiers","VXC":"Africa/Maputo","VXE":"Atlantic/Cape_Verde","VXO":"Europe/Stockholm","VYD":"Africa/Johannesburg","VYI":"Asia/Yakutsk","VYS":"America/Chicago","WAA":"America/Anchorage","WAB":"Pacific/Port_Moresby","WAC":"Africa/Addis_Ababa","WAD":"Indian/Antananarivo","WAE":"Asia/Riyadh","WAF":"Asia/Karachi","WAG":"Pacific/Auckland","WAH":"America/Chicago","WAI":"Indian/Antananarivo","WAJ":"Pacific/Port_Moresby","WAK":"Indian/Antananarivo","WAL":"America/New_York","WAM":"Indian/Antananarivo","WAN":"Australia/Brisbane","WAO":"Pacific/Port_Moresby","WAP":"America/Santiago","WAQ":"Indian/Antananarivo","WAR":"Asia/Jayapura","WAT":"Europe/Dublin","WAU":"Australia/Sydney","WAV":"Australia/Darwin","WAW":"Europe/Warsaw","WAX":"Africa/Tripoli","WAY":"America/New_York","WAZ":"Australia/Brisbane","WBA":"Asia/Jayapura","WBB":"America/Anchorage","WBC":"Pacific/Port_Moresby","WBD":"Indian/Antananarivo","WBE":"Indian/Antananarivo","WBG":"Europe/Berlin","WBI":"America/Denver","WBM":"Pacific/Port_Moresby","WBN":"America/New_York","WBO":"Indian/Antananarivo","WBQ":"America/Anchorage","WBR":"America/New_York","WBU":"America/Denver","WBW":"America/New_York","WCA":"America/Santiago","WCD":"Australia/Perth","WCH":"America/Santiago","WCR":"America/Anchorage","WDA":"Asia/Aden","WDB":"America/Anchorage","WDG":"America/Chicago","WDH":"Africa/Windhoek","WDI":"Australia/Brisbane","WDN":"America/Los_Angeles","WDR":"America/New_York","WDS":"Asia/Shanghai","WDY":"America/Anchorage","WEA":"America/Chicago","WED":"Pacific/Port_Moresby","WEF":"Asia/Shanghai","WEH":"Asia/Shanghai","WEI":"Australia/Brisbane","WEL":"Africa/Johannesburg","WEM":"Europe/London","WEP":"Pacific/Port_Moresby","WES":"Africa/Monrovia","WET":"Asia/Jayapura","WEW":"Australia/Sydney","WEX":"Europe/Dublin","WFB":"America/Anchorage","WFD":"Europe/London","WFI":"Indian/Antananarivo","WFK":"America/New_York","WGA":"Australia/Sydney","WGB":"Asia/Karachi","WGC":"Asia/Kolkata","WGE":"Australia/Sydney","WGL":"America/Guayaquil","WGN":"Asia/Shanghai","WGO":"America/New_York","WGP":"Asia/Makassar","WGT":"Australia/Sydney","WGU":"Pacific/Port_Moresby","WGY":"Africa/Libreville","WHD":"America/Anchorage","WHF":"Africa/Khartoum","WHK":"Pacific/Auckland","WHL":"Australia/Sydney","WHO":"Pacific/Auckland","WHP":"America/Los_Angeles","WHS":"Europe/London","WHT":"America/Chicago","WHU":"Asia/Shanghai","WIC":"Europe/London","WID":"Europe/Berlin","WIE":"Europe/Berlin","WIK":"Pacific/Auckland","WIL":"Africa/Nairobi","WIN":"Australia/Brisbane","WIO":"Australia/Sydney","WIR":"Pacific/Auckland","WIT":"Australia/Perth","WIU":"Pacific/Port_Moresby","WJA":"Pacific/Majuro","WJF":"America/Los_Angeles","WJR":"Africa/Nairobi","WJU":"Asia/Seoul","WKA":"Pacific/Auckland","WKB":"Australia/Sydney","WKF":"Africa/Johannesburg","WKI":"Africa/Harare","WKJ":"Asia/Tokyo","WKK":"America/Anchorage","WKL":"Pacific/Honolulu","WKN":"Pacific/Bougainville","WKR":"America/Nassau","WLA":"Australia/Perth","WLB":"America/Anchorage","WLC":"Australia/Sydney","WLD":"America/Chicago","WLE":"Australia/Brisbane","WLG":"Pacific/Auckland","WLH":"Pacific/Efate","WLK":"America/Anchorage","WLL":"Australia/Brisbane","WLM":"America/New_York","WLN":"America/Anchorage","WLO":"Australia/Darwin","WLP":"Australia/Perth","WLR":"America/Anchorage","WLS":"Pacific/Wallis","WLW":"America/Los_Angeles","WMA":"Indian/Antananarivo","WMB":"Australia/Sydney","WMC":"America/Los_Angeles","WMD":"Indian/Antananarivo","WME":"Australia/Perth","WMH":"America/Chicago","WMI":"Europe/Warsaw","WMK":"America/Anchorage","WML":"Indian/Antananarivo","WMN":"Indian/Antananarivo","WMO":"America/Anchorage","WMP":"Indian/Antananarivo","WMR":"Indian/Antananarivo","WMT":"Asia/Shanghai","WMV":"Indian/Antananarivo","WMX":"Asia/Jayapura","WNA":"America/Anchorage","WND":"Australia/Perth","WNE":"Africa/Accra","WNH":"Asia/Shanghai","WNI":"Asia/Makassar","WNN":"America/Winnipeg","WNP":"Asia/Manila","WNR":"Australia/Brisbane","WNS":"Asia/Karachi","WNU":"Pacific/Port_Moresby","WNZ":"Asia/Shanghai","WOA":"Pacific/Port_Moresby","WOB":"Europe/London","WOD":"America/Anchorage","WOE":"Europe/Amsterdam","WOG":"Australia/Darwin","WOI":"Africa/Monrovia","WOK":"America/Caracas","WOL":"Australia/Sydney","WON":"Australia/Brisbane","WOO":"America/Anchorage","WOR":"Indian/Antananarivo","WOT":"Asia/Taipei","WOW":"America/Anchorage","WPA":"America/Santiago","WPB":"Indian/Antananarivo","WPC":"America/Edmonton","WPK":"Australia/Brisbane","WPL":"America/Vancouver","WPM":"Pacific/Port_Moresby","WPO":"America/Denver","WPR":"America/Santiago","WPU":"America/Santiago","WRA":"Africa/Addis_Ababa","WRB":"America/New_York","WRE":"Pacific/Auckland","WRG":"America/Anchorage","WRH":"America/Anchorage","WRI":"America/New_York","WRL":"America/Denver","WRN":"Australia/Perth","WRO":"Europe/Warsaw","WRW":"Australia/Perth","WRY":"Europe/London","WRZ":"Asia/Colombo","WSA":"Pacific/Port_Moresby","WSB":"America/Anchorage","WSD":"America/Denver","WSF":"America/Anchorage","WSG":"America/New_York","WSH":"America/New_York","WSK":"Asia/Shanghai","WSM":"America/Anchorage","WSN":"America/Anchorage","WSO":"America/Paramaribo","WSP":"America/Managua","WSR":"Asia/Jayapura","WST":"America/New_York","WSU":"Pacific/Port_Moresby","WSX":"America/Los_Angeles","WSY":"Australia/Brisbane","WSZ":"Pacific/Auckland","WTA":"Indian/Antananarivo","WTB":"Australia/Brisbane","WTD":"America/Nassau","WTE":"Pacific/Majuro","WTK":"America/Anchorage","WTL":"America/Anchorage","WTN":"Europe/London","WTO":"Pacific/Majuro","WTP":"Pacific/Port_Moresby","WTR":"America/Phoenix","WTS":"Indian/Antananarivo","WTT":"Pacific/Port_Moresby","WTZ":"Pacific/Auckland","WUA":"Asia/Shanghai","WUD":"Australia/Adelaide","WUG":"Pacific/Port_Moresby","WUH":"Asia/Shanghai","WUI":"Australia/Perth","WUM":"Pacific/Port_Moresby","WUN":"Australia/Perth","WUS":"Asia/Shanghai","WUT":"Asia/Shanghai","WUU":"Africa/Juba","WUV":"Pacific/Port_Moresby","WUX":"Asia/Shanghai","WUZ":"Asia/Shanghai","WVB":"Africa/Windhoek","WVI":"America/Los_Angeles","WVK":"Indian/Antananarivo","WVL":"America/New_York","WVN":"Europe/Berlin","WWA":"America/Anchorage","WWD":"America/New_York","WWI":"Australia/Perth","WWK":"Pacific/Port_Moresby","WWP":"America/Anchorage","WWR":"America/Chicago","WWT":"America/Anchorage","WWY":"Australia/Sydney","WXN":"Asia/Shanghai","WYA":"Australia/Adelaide","WYB":"America/Anchorage","WYE":"Africa/Freetown","WYN":"Australia/Perth","WYS":"America/Denver","WZA":"Africa/Accra","WZQ":"Asia/Shanghai","WZY":"America/Nassau","XAI":"Asia/Shanghai","XAL":"America/Hermosillo","XAP":"America/Sao_Paulo","XAR":"Africa/Ouagadougou","XAU":"America/Cayenne","XAY":"Asia/Vientiane","XBB":"America/Vancouver","XBE":"America/Winnipeg","XBG":"Africa/Ouagadougou","XBJ":"Asia/Tehran","XBL":"Africa/Addis_Ababa","XBN":"Pacific/Port_Moresby","XBO":"Africa/Ouagadougou","XBR":"America/Toronto","XCH":"Indian/Christmas","XCL":"America/Regina","XCM":"America/Toronto","XCN":"Asia/Manila","XCO":"Australia/Sydney","XCR":"Europe/Paris","XDE":"Africa/Ouagadougou","XDJ":"Africa/Ouagadougou","XEN":"Asia/Shanghai","XEO":"America/Godthab","XEQ":"America/Godthab","XES":"America/Chicago","XEX":"Europe/Paris","XFN":"Asia/Shanghai","XFW":"Europe/Berlin","XGA":"Africa/Ouagadougou","XGB":"Europe/Paris","XGG":"Africa/Ouagadougou","XGL":"America/Winnipeg","XGN":"Africa/Luanda","XGR":"America/Toronto","XIC":"Asia/Shanghai","XIE":"Asia/Vientiane","XIG":"America/Belem","XIJ":"Asia/Kuwait","XIL":"Asia/Shanghai","XIN":"Asia/Shanghai","XIQ":"America/Godthab","XIY":"Asia/Shanghai","XJD":"Asia/Qatar","XKA":"Africa/Ouagadougou","XKH":"Asia/Vientiane","XKO":"America/Vancouver","XKS":"America/Winnipeg","XKY":"Africa/Ouagadougou","XLB":"America/Winnipeg","XLF":"America/Toronto","XLO":"Asia/Ho_Chi_Minh","XLS":"Africa/Dakar","XLU":"Africa/Ouagadougou","XLW":"Europe/Berlin","XMA":"Asia/Manila","XMC":"Australia/Sydney","XMD":"America/Chicago","XMG":"Asia/Kathmandu","XMH":"Pacific/Tahiti","XMI":"Africa/Dar_es_Salaam","XML":"Australia/Adelaide","XMN":"Asia/Shanghai","XMP":"America/Vancouver","XMS":"America/Guayaquil","XMY":"Australia/Brisbane","XNA":"America/Chicago","XNG":"Asia/Ho_Chi_Minh","XNH":"Asia/Baghdad","XNN":"Asia/Shanghai","XNT":"Asia/Shanghai","XNU":"Africa/Ouagadougou","XPA":"Africa/Ouagadougou","XPD":"America/Argentina/Buenos_Aires","XPK":"America/Winnipeg","XPL":"America/Tegucigalpa","XPP":"America/Winnipeg","XPR":"America/Denver","XPU":"America/Anchorage","XQC":"Asia/Baghdad","XQP":"America/Costa_Rica","XQU":"America/Vancouver","XRH":"Australia/Sydney","XRR":"America/Vancouver","XRY":"Europe/Madrid","XSB":"Asia/Dubai","XSC":"America/Grand_Turk","XSD":"America/Los_Angeles","XSE":"Africa/Ouagadougou","XSI":"America/Winnipeg","XSM":"America/New_York","XSO":"Asia/Manila","XSP":"Asia/Singapore","XTG":"Australia/Brisbane","XTL":"America/Winnipeg","XTO":"Australia/Brisbane","XTR":"Australia/Brisbane","XUZ":"Asia/Shanghai","XVL":"Asia/Ho_Chi_Minh","XWA":"America/Chicago","XYA":"Pacific/Guadalcanal","XYE":"Asia/Yangon","XYR":"Pacific/Port_Moresby","XYT":"Europe/Paris","XZA":"Africa/Ouagadougou","XZD":"Europe/Oslo","YAA":"America/Vancouver","YAB":"America/Iqaluit","YAC":"America/Winnipeg","YAD":"America/Winnipeg","YAE":"America/Vancouver","YAF":"America/Toronto","YAG":"America/Winnipeg","YAH":"America/Toronto","YAI":"America/Santiago","YAJ":"America/Vancouver","YAK":"America/Anchorage","YAL":"America/Vancouver","YAM":"America/Toronto","YAN":"Africa/Lubumbashi","YAO":"Africa/Douala","YAP":"Pacific/Chuuk","YAQ":"America/Vancouver","YAR":"America/Toronto","YAS":"Pacific/Fiji","YAT":"America/Toronto","YAU":"America/Toronto","YAV":"America/Vancouver","YAW":"America/Halifax","YAX":"America/Winnipeg","YAY":"America/St_Johns","YAZ":"America/Vancouver","YBA":"America/Edmonton","YBB":"America/Edmonton","YBC":"America/Toronto","YBD":"America/Vancouver","YBE":"America/Regina","YBF":"America/Vancouver","YBG":"America/Toronto","YBH":"America/Vancouver","YBI":"America/Halifax","YBJ":"America/Toronto","YBK":"America/Winnipeg","YBL":"America/Vancouver","YBM":"America/Vancouver","YBN":"America/Toronto","YBO":"America/Vancouver","YBP":"Asia/Shanghai","YBQ":"America/Vancouver","YBR":"America/Winnipeg","YBS":"America/Toronto","YBT":"America/Winnipeg","YBV":"America/Winnipeg","YBW":"America/Vancouver","YBX":"America/Blanc-Sablon","YBY":"America/Edmonton","YCA":"America/Vancouver","YCB":"America/Edmonton","YCC":"America/Toronto","YCD":"America/Vancouver","YCE":"America/Toronto","YCF":"America/Vancouver","YCG":"America/Vancouver","YCH":"America/Halifax","YCI":"America/Toronto","YCJ":"America/Vancouver","YCK":"America/Edmonton","YCL":"America/Halifax","YCM":"America/Toronto","YCN":"America/Toronto","YCO":"America/Edmonton","YCQ":"America/Dawson_Creek","YCR":"America/Winnipeg","YCS":"America/Winnipeg","YCT":"America/Edmonton","YCU":"Asia/Shanghai","YCW":"America/Vancouver","YCX":"America/Halifax","YCY":"America/Toronto","YCZ":"America/Edmonton","YDA":"America/Vancouver","YDB":"America/Vancouver","YDC":"America/Edmonton","YDE":"America/Halifax","YDF":"America/St_Johns","YDG":"America/Halifax","YDH":"America/St_Johns","YDI":"America/Halifax","YDJ":"America/Regina","YDK":"America/Toronto","YDL":"America/Vancouver","YDN":"America/Winnipeg","YDO":"America/Toronto","YDP":"America/Halifax","YDQ":"America/Dawson_Creek","YDR":"America/Regina","YDS":"America/Vancouver","YDT":"America/Vancouver","YDU":"America/Winnipeg","YDV":"America/Winnipeg","YDW":"America/Winnipeg","YDX":"America/Vancouver","YEC":"Asia/Seoul","YED":"America/Edmonton","YEG":"America/Edmonton","YEI":"Europe/Istanbul","YEK":"America/Winnipeg","YEL":"America/Toronto","YEM":"America/Toronto","YEN":"America/Regina","YEO":"Europe/London","YEP":"America/Vancouver","YEQ":"Pacific/Port_Moresby","YER":"America/Toronto","YES":"Asia/Tehran","YET":"America/Edmonton","YEU":"America/Winnipeg","YEV":"America/Edmonton","YEY":"America/Toronto","YFA":"America/Toronto","YFB":"America/Toronto","YFC":"America/Halifax","YFE":"America/Toronto","YFG":"America/Toronto","YFH":"America/Toronto","YFI":"America/Edmonton","YFJ":"America/Edmonton","YFL":"America/Vancouver","YFO":"America/Winnipeg","YFR":"America/Edmonton","YFS":"America/Edmonton","YFX":"America/St_Johns","YGA":"America/Toronto","YGB":"America/Vancouver","YGC":"America/Edmonton","YGE":"America/Vancouver","YGG":"America/Vancouver","YGH":"America/Edmonton","YGJ":"Asia/Tokyo","YGK":"America/Toronto","YGL":"America/Toronto","YGM":"America/Winnipeg","YGN":"America/Vancouver","YGO":"America/Winnipeg","YGP":"America/Toronto","YGQ":"America/Toronto","YGR":"America/Halifax","YGS":"America/Vancouver","YGT":"America/Toronto","YGV":"America/Toronto","YGW":"America/Toronto","YGX":"America/Winnipeg","YGY":"America/Toronto","YGZ":"America/Toronto","YHA":"America/St_Johns","YHB":"America/Regina","YHC":"America/Vancouver","YHD":"America/Winnipeg","YHE":"America/Vancouver","YHF":"America/Toronto","YHG":"America/St_Johns","YHH":"America/Vancouver","YHI":"America/Edmonton","YHK":"America/Edmonton","YHM":"America/Toronto","YHN":"America/Toronto","YHO":"America/Halifax","YHP":"America/Winnipeg","YHR":"America/Blanc-Sablon","YHS":"America/Vancouver","YHT":"America/Vancouver","YHU":"America/Toronto","YHY":"America/Edmonton","YHZ":"America/Halifax","YIA":"Asia/Jakarta","YIB":"America/Atikokan","YIC":"Asia/Shanghai","YIE":"Asia/Shanghai","YIF":"America/Blanc-Sablon","YIG":"America/Vancouver","YIH":"Asia/Shanghai","YIK":"America/Toronto","YIN":"Asia/Shanghai","YIO":"America/Toronto","YIP":"America/New_York","YIV":"America/Winnipeg","YIW":"Asia/Shanghai","YJA":"America/Edmonton","YJF":"America/Edmonton","YJN":"America/Toronto","YJO":"America/Vancouver","YJP":"America/Edmonton","YJT":"America/St_Johns","YKA":"America/Vancouver","YKC":"America/Regina","YKD":"America/Toronto","YKE":"America/Winnipeg","YKF":"America/Toronto","YKG":"America/Toronto","YKH":"Asia/Shanghai","YKJ":"America/Regina","YKK":"America/Vancouver","YKL":"America/Toronto","YKM":"America/Los_Angeles","YKN":"America/Chicago","YKO":"Europe/Istanbul","YKQ":"America/Toronto","YKS":"Asia/Yakutsk","YKT":"America/Vancouver","YKU":"America/Toronto","YKX":"America/Toronto","YKY":"America/Regina","YKZ":"America/Toronto","YLA":"America/Vancouver","YLB":"America/Edmonton","YLC":"America/Toronto","YLD":"America/Toronto","YLE":"America/Edmonton","YLF":"America/Toronto","YLG":"Australia/Perth","YLH":"America/Toronto","YLI":"Europe/Helsinki","YLJ":"America/Regina","YLL":"America/Edmonton","YLM":"America/Vancouver","YLN":"Asia/Shanghai","YLO":"America/Winnipeg","YLP":"America/Toronto","YLQ":"America/Toronto","YLR":"America/Winnipeg","YLS":"America/Toronto","YLT":"America/Winnipeg","YLW":"America/Vancouver","YLX":"Asia/Shanghai","YLY":"America/Vancouver","YMA":"America/Vancouver","YMB":"America/Vancouver","YMC":"America/Toronto","YMD":"America/Edmonton","YME":"America/Toronto","YMF":"America/Vancouver","YMG":"America/Toronto","YMH":"America/St_Johns","YMI":"America/Winnipeg","YMJ":"America/Regina","YMK":"Asia/Yekaterinburg","YML":"America/Toronto","YMM":"America/Edmonton","YMN":"America/Halifax","YMO":"America/Toronto","YMP":"America/Vancouver","YMR":"America/Vancouver","YMS":"America/Lima","YMT":"America/Toronto","YMU":"America/Vancouver","YMV":"America/Iqaluit","YMW":"America/Toronto","YMX":"America/Toronto","YNA":"America/Toronto","YNB":"Asia/Riyadh","YNC":"America/Toronto","YND":"America/Toronto","YNE":"America/Winnipeg","YNG":"America/New_York","YNH":"America/Edmonton","YNI":"America/Toronto","YNJ":"Asia/Shanghai","YNK":"America/Vancouver","YNL":"America/Regina","YNM":"America/Toronto","YNN":"Australia/Perth","YNO":"America/Winnipeg","YNP":"America/Halifax","YNR":"America/Winnipeg","YNS":"America/Toronto","YNT":"Asia/Shanghai","YNY":"Asia/Seoul","YNZ":"Asia/Shanghai","YOA":"America/Edmonton","YOC":"America/Vancouver","YOD":"America/Edmonton","YOE":"America/Edmonton","YOG":"America/Toronto","YOH":"America/Winnipeg","YOJ":"America/Edmonton","YOK":"Asia/Tokyo","YOL":"Africa/Lagos","YON":"Asia/Thimphu","YOO":"America/Toronto","YOP":"America/Edmonton","YOS":"America/Toronto","YOT":"Asia/Jerusalem","YOW":"America/Toronto","YOY":"America/Toronto","YPA":"America/Regina","YPB":"America/Vancouver","YPC":"America/Edmonton","YPD":"America/Toronto","YPE":"America/Edmonton","YPF":"America/Vancouver","YPG":"America/Winnipeg","YPH":"America/Toronto","YPI":"America/Vancouver","YPJ":"America/Toronto","YPL":"America/Atikokan","YPM":"America/Winnipeg","YPN":"America/Toronto","YPO":"America/Toronto","YPP":"America/Edmonton","YPQ":"America/Toronto","YPR":"America/Vancouver","YPS":"America/Halifax","YPT":"America/Vancouver","YPW":"America/Vancouver","YPX":"America/Toronto","YPY":"America/Edmonton","YPZ":"America/Vancouver","YQA":"America/Toronto","YQB":"America/Toronto","YQC":"America/Toronto","YQD":"America/Winnipeg","YQE":"America/Vancouver","YQF":"America/Edmonton","YQG":"America/Toronto","YQH":"America/Vancouver","YQI":"America/Halifax","YQJ":"America/Vancouver","YQK":"America/Winnipeg","YQL":"America/Edmonton","YQM":"America/Halifax","YQN":"America/Toronto","YQQ":"America/Vancouver","YQR":"America/Regina","YQS":"America/Toronto","YQT":"America/Toronto","YQU":"America/Edmonton","YQV":"America/Regina","YQW":"America/Regina","YQX":"America/St_Johns","YQY":"America/Halifax","YQZ":"America/Vancouver","YR6":"America/Vancouver","YRA":"America/Edmonton","YRB":"America/Winnipeg","YRC":"America/Vancouver","YRD":"America/Vancouver","YRE":"America/Winnipeg","YRF":"America/Halifax","YRG":"America/Halifax","YRI":"America/Toronto","YRJ":"America/Toronto","YRL":"America/Winnipeg","YRM":"America/Edmonton","YRN":"America/Vancouver","YRO":"America/Toronto","YRQ":"America/Toronto","YRR":"America/Vancouver","YRS":"America/Winnipeg","YRT":"America/Winnipeg","YRV":"America/Vancouver","YSA":"America/Halifax","YSB":"America/Toronto","YSC":"America/Toronto","YSD":"America/Edmonton","YSE":"America/Vancouver","YSF":"America/Regina","YSG":"America/Edmonton","YSH":"America/Toronto","YSI":"America/Toronto","YSJ":"America/Halifax","YSK":"America/Toronto","YSL":"America/Halifax","YSM":"America/Edmonton","YSN":"America/Vancouver","YSO":"America/Halifax","YSP":"America/Toronto","YSQ":"Asia/Shanghai","YSR":"America/Toronto","YST":"America/Winnipeg","YSU":"America/Halifax","YSV":"America/Halifax","YSX":"America/Vancouver","YSY":"America/Edmonton","YSZ":"America/Vancouver","YTA":"America/Toronto","YTB":"America/Vancouver","YTC":"America/Vancouver","YTD":"America/Winnipeg","YTE":"America/Toronto","YTF":"America/Toronto","YTG":"America/Vancouver","YTH":"America/Winnipeg","YTJ":"America/Toronto","YTK":"America/Toronto","YTL":"America/Winnipeg","YTM":"America/Toronto","YTN":"America/Toronto","YTP":"America/Vancouver","YTQ":"America/Toronto","YTR":"America/Toronto","YTS":"America/Toronto","YTT":"America/Regina","YTU":"America/Vancouver","YTX":"America/Vancouver","YTY":"Asia/Shanghai","YTZ":"America/Toronto","YUA":"Asia/Shanghai","YUB":"America/Edmonton","YUD":"America/Toronto","YUE":"Australia/Darwin","YUF":"America/Edmonton","YUL":"America/Toronto","YUM":"America/Phoenix","YUS":"Asia/Shanghai","YUT":"America/Winnipeg","YUX":"America/Toronto","YUY":"America/Toronto","YVB":"America/Toronto","YVC":"America/Regina","YVD":"Pacific/Port_Moresby","YVE":"America/Vancouver","YVG":"America/Edmonton","YVM":"America/Toronto","YVO":"America/Toronto","YVP":"America/Toronto","YVQ":"America/Edmonton","YVR":"America/Vancouver","YVT":"America/Regina","YVV":"America/Toronto","YVZ":"America/Winnipeg","YWA":"America/Toronto","YWB":"America/Toronto","YWF":"America/Halifax","YWG":"America/Winnipeg","YWH":"America/Vancouver","YWJ":"America/Edmonton","YWK":"America/Halifax","YWL":"America/Vancouver","YWM":"America/St_Johns","YWN":"America/Toronto","YWO":"America/Edmonton","YWP":"America/Toronto","YWQ":"America/Toronto","YWR":"America/Toronto","YWS":"America/Vancouver","YWY":"America/Edmonton","YXC":"America/Edmonton","YXE":"America/Regina","YXF":"America/Vancouver","YXH":"America/Edmonton","YXI":"America/Toronto","YXJ":"America/Dawson_Creek","YXK":"America/Toronto","YXL":"America/Winnipeg","YXN":"America/Winnipeg","YXP":"America/Toronto","YXQ":"America/Vancouver","YXR":"America/Toronto","YXS":"America/Vancouver","YXT":"America/Vancouver","YXU":"America/Toronto","YXX":"America/Vancouver","YXY":"America/Vancouver","YXZ":"America/Toronto","YYA":"Asia/Shanghai","YYB":"America/Toronto","YYC":"America/Edmonton","YYD":"America/Vancouver","YYE":"America/Dawson_Creek","YYF":"America/Vancouver","YYG":"America/Halifax","YYH":"America/Edmonton","YYI":"America/Winnipeg","YYJ":"America/Vancouver","YYL":"America/Winnipeg","YYM":"America/Edmonton","YYN":"America/Regina","YYQ":"America/Winnipeg","YYR":"America/Halifax","YYT":"America/St_Johns","YYU":"America/Toronto","YYW":"America/Toronto","YYY":"America/Toronto","YYZ":"America/Toronto","YZA":"America/Vancouver","YZC":"America/Vancouver","YZE":"America/Toronto","YZF":"America/Edmonton","YZG":"America/Toronto","YZH":"America/Edmonton","YZM":"America/St_Johns","YZP":"America/Vancouver","YZR":"America/Toronto","YZS":"America/Atikokan","YZT":"America/Vancouver","YZU":"America/Edmonton","YZV":"America/Toronto","YZW":"America/Vancouver","YZX":"America/Halifax","YZY":"Asia/Shanghai","YZZ":"America/Vancouver","ZAA":"America/Vancouver","ZAC":"America/Winnipeg","ZAD":"Europe/Zagreb","ZAG":"Europe/Zagreb","ZAH":"Asia/Tehran","ZAJ":"Asia/Kabul","ZAL":"America/Santiago","ZAM":"Asia/Manila","ZAO":"Europe/Paris","ZAR":"Africa/Lagos","ZAT":"Asia/Shanghai","ZAZ":"Europe/Madrid","ZBE":"Europe/Prague","ZBF":"America/Halifax","ZBK":"Europe/Podgorica","ZBL":"Australia/Brisbane","ZBM":"America/Toronto","ZBO":"Australia/Brisbane","ZBR":"Asia/Tehran","ZBY":"Asia/Vientiane","ZCL":"America/Mexico_City","ZCO":"America/Santiago","ZDY":"Asia/Dubai","ZEC":"Africa/Johannesburg","ZEG":"Asia/Jayapura","ZEL":"America/Vancouver","ZEM":"America/Toronto","ZEN":"Pacific/Port_Moresby","ZER":"Asia/Kolkata","ZFA":"America/Vancouver","ZFB":"America/Halifax","ZFD":"America/Regina","ZFL":"America/Winnipeg","ZFM":"America/Edmonton","ZFN":"America/Edmonton","ZFW":"America/Edmonton","ZGF":"America/Vancouver","ZGI":"America/Winnipeg","ZGL":"Australia/Brisbane","ZGM":"Africa/Lusaka","ZGR":"America/Winnipeg","ZGS":"America/Blanc-Sablon","ZGU":"Pacific/Efate","ZHA":"Asia/Shanghai","ZHM":"Asia/Dhaka","ZHP":"America/Edmonton","ZHY":"Asia/Shanghai","ZIA":"Europe/Moscow","ZIC":"America/Santiago","ZIG":"Africa/Dakar","ZIH":"America/Mexico_City","ZIS":"Africa/Tripoli","ZIX":"Asia/Yakutsk","ZIZ":"Asia/Karachi","ZJG":"America/Winnipeg","ZJN":"America/Winnipeg","ZKB":"Africa/Lusaka","ZKE":"America/Toronto","ZKG":"America/Blanc-Sablon","ZKL":"Asia/Shanghai","ZKM":"Africa/Libreville","ZKP":"Asia/Magadan","ZLO":"America/Mexico_City","ZLT":"America/Blanc-Sablon","ZLX":"Africa/Khartoum","ZMD":"America/Rio_Branco","ZMH":"America/Vancouver","ZMM":"America/Mexico_City","ZMT":"America/Vancouver","ZNA":"America/Vancouver","ZNC":"America/Anchorage","ZND":"Africa/Niamey","ZNE":"Australia/Perth","ZNU":"America/Vancouver","ZNZ":"Africa/Dar_es_Salaam","ZOF":"America/Vancouver","ZOS":"America/Santiago","ZPB":"America/Winnipeg","ZPC":"America/Santiago","ZPH":"America/New_York","ZPO":"America/Winnipeg","ZQN":"Pacific/Auckland","ZQS":"America/Vancouver","ZQW":"Europe/Berlin","ZQZ":"Asia/Shanghai","ZRH":"Europe/Zurich","ZRI":"Asia/Jayapura","ZRJ":"America/Winnipeg","ZRM":"Asia/Jayapura","ZSA":"America/Nassau","ZSE":"Indian/Reunion","ZSJ":"America/Winnipeg","ZSP":"America/Toronto","ZSS":"Africa/Abidjan","ZST":"America/Vancouver","ZSW":"America/Vancouver","ZTA":"Pacific/Tahiti","ZTB":"America/Blanc-Sablon","ZTH":"Europe/Athens","ZTM":"America/Winnipeg","ZTR":"Europe/Kiev","ZTS":"America/Vancouver","ZTU":"Asia/Baku","ZUC":"America/Winnipeg","ZUD":"America/Santiago","ZUE":"Africa/Abidjan","ZUH":"Asia/Shanghai","ZUL":"Asia/Riyadh","ZUM":"America/Halifax","ZVA":"Indian/Antananarivo","ZVG":"Australia/Perth","ZVK":"Asia/Vientiane","ZWA":"Indian/Antananarivo","ZWL":"America/Regina","ZWN":"Europe/Berlin","ZXQ":"Europe/Oslo","ZXT":"Asia/Baku","ZYI":"Asia/Shanghai","ZYL":"Asia/Dhaka","ZZO":"Asia/Vladivostok","ZZU":"Africa/Blantyre","ZZV":"America/New_York"}');
;// CONCATENATED MODULE: ./src/matrix5/links/airlines/aaSabre.js







const aaSabreEditions = [
  { value: "BS", name: "Bahamas (USD)" },
  { value: "VG", name: "British Virgin Islands (USD)" },
  { value: "CA", name: "Canada (CAD)" },
  { value: "PR", name: "Puerto Rico (USD)" },
  { value: "GB", name: "United Kingdom (GBP)" },
  { value: "US", name: "United States (USD)" },
];

function printAaSabre() {
  if (!(0,links.anyCarriers)("AA")) {
    return;
  }

  let datetimeToEpoch = function (y, m, d, t, ap) {
    /**
     * This function converts a datetime from the local timezone of the
     * departing airport to its epoch value, while accounting for
     * daylight savings time (DST) differences in future months.
     *
     * This function accepts the IATA code for a given airport and
     * retrieves the timezone from a static array of known airport data
     * (sourced from https://www.flightstats.com, reduced to
     * airports with IATA code, and converted to keyed json format).
     *
     * @param y 4-digit year
     * @param m 2-digit month
     * @param d 2-digit day
     * @param t 24-hour formatted time (HH:MM)
     * @param y 4-digit year
     * @param ap IATA airport code
     * @returns Adjusted datetime string with offset in format YYYY-MM-DDTHH:MM:00+XX:00
     */

    let datetimeStr =
      y +
      "-" +
      ("0" + m).slice(-2) +
      "-" +
      ("0" + d).slice(-2) +
      "T" +
      t +
      ":00";

    return zonedTimeToUtc(datetimeStr, timezones_namespaceObject[ap]).getTime();
  };

  // validate Passengers here: Max Paxcount = 7 (Infs not included) - >11 = Adult - InfSeat = Child
  var createUrl = function (edition) {
    var pax = (0,links.validatePax)({
      maxPaxcount: 6,
      countInf: true,
      childAsAdult: 12,
      sepInfSeat: false,
      childMinAge: 2,
    });
    if (!pax) {
      (0,utils.printNotification)("Error: Failed to validate Passengers in printAaSabre");
      return false;
    }
    var url = "https://www.aa.com/goto/metasearch?ITEN=GOOGLE,0,";
    url += (edition || "US") + ",";
    url += (0,itin.isOneway)() ? "oneWay" : "multi";
    url +=
      ",4,A" +
      pax.adults +
      "S0C" +
      pax.children.length +
      "I" +
      pax.infLap +
      "Y0L0,0,";
    url += itin.currentItin.itin[0].orig + ",0," + itin.currentItin.itin[0].dest;
    url += ",0";

    if (itin.currentItin.itin.length > 1) {
      for (var i = 0; i < itin.currentItin.itin.length; i++) {
        url += ",0,0";
      }
    } else {
      url += ",0"; // for oneWay only
    }

    if (itin.currentItin.itin.length == 2) {
      // insert additional parameter zeros for roundtrips or 2-leg multi-city:
      url += ",0,0";
    } else if (itin.currentItin.itin.length == 1) {
      // insert the departure time before the price for oneWay only:
      url +=
        "," +
        datetimeToEpoch(
          itin.currentItin.itin[0].seg[0].dep.year,
          itin.currentItin.itin[0].seg[0].dep.month,
          itin.currentItin.itin[0].seg[0].dep.day,
          itin.currentItin.itin[0].seg[0].dep.time24,
          itin.currentItin.itin[0].seg[0].orig,
        );
    }
    url += "," + itin.currentItin.price + ",1,";

    // this part for RT and multi-city only:
    if (itin.currentItin.itin.length > 1) {
      var addon = "";
      for (var i = 0; i < itin.currentItin.itin.length; i++) {
        addon +=
          "#" +
          itin.currentItin.itin[i].orig +
          "|" +
          itin.currentItin.itin[i].dest +
          "|0|0|";
        addon += datetimeToEpoch(
          itin.currentItin.itin[i].seg[0].dep.year,
          itin.currentItin.itin[i].seg[0].dep.month,
          itin.currentItin.itin[i].seg[0].dep.day,
          itin.currentItin.itin[i].seg[0].dep.time24,
          itin.currentItin.itin[i].seg[0].orig,
        );
      }
      url += encodeURIComponent(addon) + ",";
    }

    var itinsegs = new Array();

    // Build multi-city search based on legs:
    for (var i = 0; i < itin.currentItin.itin.length; i++) {
      // outer loop traverses each leg
      for (var j = 0; j < itin.currentItin.itin[i].seg.length; j++) {
        // inner loop traverses each segment of the leg
        var k = 0;
        // skip this segment ONLY IF the flight number is the
        // same as the next segment and it is only a layover
        while (j + k < itin.currentItin.itin[i].seg.length - 1) {
          if (
            itin.currentItin.itin[i].seg[j + k].fnr !==
              itin.currentItin.itin[i].seg[j + k + 1].fnr ||
            itin.currentItin.itin[i].seg[j + k].layoverduration >= 1440
          )
            break;
          k++;
        }
        let itinseg =
          "#" +
          itin.currentItin.itin[i].seg[j].carrier +
          "|" +
          itin.currentItin.itin[i].seg[j].fnr +
          "|" +
          itin.currentItin.itin[i].seg[j].bookingclass +
          "|" +
          itin.currentItin.itin[i].seg[j].orig +
          "|" +
          itin.currentItin.itin[i].seg[j + k].dest +
          "|" +
          datetimeToEpoch(
            itin.currentItin.itin[i].seg[j].dep.year,
            itin.currentItin.itin[i].seg[j].dep.month,
            itin.currentItin.itin[i].seg[j].dep.day,
            itin.currentItin.itin[i].seg[j].dep.time24,
            itin.currentItin.itin[i].seg[j].orig,
          );
        itinseg += "|" + i;
        itinsegs.push(itinseg);
        j += k;
      }
    }
    url += encodeURIComponent(itinsegs.join(""));
    return url;
  };
  var url = createUrl(userSettings["default"].aaSabreEdition.toUpperCase());
  if (!url) {
    return;
  }
  var extra =
    ' <span class="pt-hover-container">[+]<span class="pt-hover-menu">';
  extra += aaSabreEditions
    .map(function (edition, i) {
      return (
        '<a href="' +
        createUrl(edition.value.toUpperCase()) +
        '" target="_blank">' +
        edition.name +
        "</a>"
      );
    })
    .join("<br/>");
  extra += "</span></span>";

  return {
    url,
    title: "American",
    desc: "America & UK",
    extra,
  };
}

(0,links.register)("airlines", printAaSabre);
(0,userSettings.registerSetting)(
  "American (America & UK)",
  "aaSabreEdition",
  aaSabreEditions,
  "US",
);


/***/ }),

/***/ "./src/matrix5/links/airlines/ac.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _settings_userSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/settings/userSettings.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./src/matrix5/utils.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/parse/itin.ts");
/* harmony import */ var _print_amadeus__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/matrix5/print/amadeus.js");
/* harmony import */ var _unsafe_policy__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/unsafe-policy.ts");







const acEditions = [
  { name: "Algeria", value: "dz" },
  { name: "Antigua", value: "ag" },
  { name: "Argentina", value: "ar" },
  { name: "Australia", value: "au" },
  { name: "Austria", value: "at" },
  { name: "Bahamas", value: "bs" },
  { name: "Bahrain", value: "bh" },
  { name: "Barbados", value: "bb" },
  { name: "Belgium", value: "be" },
  { name: "Bermuda", value: "bm" },
  { name: "Canada", value: "ca" },
  { name: "Cayman Islands", value: "ky" },
  { name: "Chile", value: "cl" },
  { name: "China", value: "cn" },
  { name: "Colombia", value: "co" },
  { name: "Costa Rica", value: "cr" },
  { name: "Croatia", value: "hr" },
  { name: "Czech Republic", value: "cz" },
  { name: "Denmark", value: "dk" },
  { name: "Dominican Republic", value: "do" },
  { name: "Egypt", value: "eg" },
  { name: "Finland", value: "fi" },
  { name: "France", value: "fr" },
  { name: "Germany", value: "de" },
  { name: "Greece", value: "gr" },
  { name: "Haiti", value: "ht" },
  { name: "Hong Kong SAR, China", value: "hk" },
  { name: "Hungary", value: "hu" },
  { name: "India", value: "in" },
  { name: "Indonesia", value: "id" },
  { name: "Ireland", value: "ie" },
  { name: "Israel", value: "il" },
  { name: "Italy", value: "it" },
  { name: "Jamaica", value: "jm" },
  { name: "Japan", value: "jp" },
  { name: "Jordan", value: "jo" },
  { name: "Kuwait", value: "kw" },
  { name: "Malaysia", value: "my" },
  { name: "Mexico", value: "mx" },
  { name: "Morocco", value: "ma" },
  { name: "Mozambique", value: "mz" },
  { name: "Netherlands", value: "nl" },
  { name: "New Zealand", value: "nz" },
  { name: "Nigeria", value: "ng" },
  { name: "Norway", value: "no" },
  { name: "Panama", value: "pa" },
  { name: "Peru", value: "pe" },
  { name: "Poland", value: "pl" },
  { name: "Portugal", value: "pt" },
  { name: "Qatar", value: "qa" },
  { name: "Russia", value: "ru" },
  { name: "Romania", value: "ro" },
  { name: "Saudi Arabia", value: "sa" },
  { name: "Singapore", value: "sg" },
  { name: "South Africa", value: "za" },
  { name: "South Korea", value: "kr" },
  { name: "Spain", value: "es" },
  { name: "St. Lucia", value: "lc" },
  { name: "Sweden", value: "se" },
  { name: "Switzerland", value: "ch" },
  { name: "Taiwan, China", value: "tw" },
  { name: "Thailand", value: "th" },
  { name: "Trinidad &amp; Tobago", value: "tt" },
  { name: "Turkey", value: "tr" },
  { name: "Turks and Caicos Island", value: "tc" },
  { name: "Ukraine", value: "ua" },
  { name: "United Arab Emirates", value: "ae" },
  { name: "United Kingdom", value: "gb" },
  { name: "United States", value: "us" },
  { name: "Venezuela", value: "ve" },
  { name: "Vietnam", value: "vn" },
];

function printAC() {
  if (!(0,___WEBPACK_IMPORTED_MODULE_1__.anyCarriers)("AC")) {
    return;
  }

  var createUrl = function (edition) {
    var acUrl =
      "https://book.aircanada.com/pl/AConline/en/RedirectionServlet?FareRequest=YES&PRICING_MODE=0&fromThirdParty=YES";
    acUrl +=
      "&country=" + edition + "&countryOfResidence=" + edition + "&language=en";
    // validate Passengers here: Max Paxcount = 7 (Infs not included) - >11 = Adult - InfSeat = Child
    var pax = (0,___WEBPACK_IMPORTED_MODULE_1__.validatePax)({
      maxPaxcount: 9,
      countInf: true,
      childAsAdult: 16,
      sepInfSeat: false,
      childMinAge: 2,
    });
    if (!pax) {
      (0,_utils__WEBPACK_IMPORTED_MODULE_5__.printNotification)("Error: Failed to validate Passengers in printAC");
      return;
    }
    var paxConfig = { allowinf: 0, youthage: 12 }; // AC does not allow booking of infants for int. flights
    var amadeusConfig = { sepcabin: 1, detailed: 1, allowpremium: 1 };
    var tmpPax = (0,_print_amadeus__WEBPACK_IMPORTED_MODULE_3__.getAmadeusPax)(pax, paxConfig);
    acUrl += tmpPax.url;
    acUrl += "&numberOfAdults=" + tmpPax.adults;
    acUrl += "&numberOfInfants=" + tmpPax.infants;
    acUrl += "&numberOfYouth=" + tmpPax.youth;
    acUrl += "&numberOfChildren=" + tmpPax.children;
    acUrl += "&tripType=" + (0,_print_amadeus__WEBPACK_IMPORTED_MODULE_3__.getAmadeusTriptype)();
    for (var i = 0; i < _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin.length; i++) {
      acUrl +=
        "&departure" +
        (i + 1) +
        "=" +
        ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].dep.day).slice(-2) +
        "/" +
        ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].dep.month).slice(-2) +
        "/" +
        _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].dep.year +
        "&org" +
        (i + 1) +
        "=" +
        _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].orig +
        "&dest" +
        (i + 1) +
        "=" +
        _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].dest;
    }
    acUrl += (0,_print_amadeus__WEBPACK_IMPORTED_MODULE_3__.getAmadeusUrl)(amadeusConfig);
    return acUrl;
  };
  var acUrl = createUrl(_settings_userSettings__WEBPACK_IMPORTED_MODULE_0__["default"].acEdition.toUpperCase());
  if (!acUrl) {
    return;
  }
  var extra =
    ' <span class="pt-hover-container">[+]<span class="pt-hover-menu">';
  extra += acEditions
    .map(function (edition, i) {
      return (
        '<a href="' +
        createUrl(edition.value.toUpperCase()) +
        '" target="_blank">' +
        edition.name +
        "</a>"
      );
    })
    .join("<br/>");
  extra += '<br/><a href="javascript:addACPromo();">Add Promo Code</a>';
  extra += "</span></span>";
  extra += addACPromoControls(acUrl);

  return {
    url: acUrl,
    title: "Air Canada",
    extra,
  };
}

function addACPromoControls(url) {
  var script = document.createElement("script");
  script.appendChild(
    document.createTextNode((0,_unsafe_policy__WEBPACK_IMPORTED_MODULE_4__.unsafeScript)("(" + addACPromo + ")();")),
  );
  (
    document.body ||
    document.head ||
    document.documentElement
  ).insertAdjacentHTML("beforeend", (0,_unsafe_policy__WEBPACK_IMPORTED_MODULE_4__.unsafeHTML)(script.outerHTML));

  var label = "Open";
  var extra =
    '<input type="input" id="ac-promo-input" size="8" style="display:none;margin:0 5px;"></input>';
  extra +=
    '<label style="font-size:' + Number(_settings_userSettings__WEBPACK_IMPORTED_MODULE_0__["default"].linkFontsize) + '%;">';
  extra +=
    '<a id="ac-promo-link" style="display:none" target="_blank" href="' +
    url +
    '">' +
    label +
    "</a></label>";
  return extra;
}

function addACPromo() {
  window.addACPromo = function () {
    var input = document.getElementById("ac-promo-input");
    input.style.display = "inline";
    input.addEventListener("change", (event) => {
      var replacement =
        event.target.value != ""
          ? "&AUTHORIZATION_ID=" + event.target.value
          : "";
      var link = document.getElementById("ac-promo-link");
      var match = link.href.match(/(&AUTHORIZATION_ID=.*)/g);
      if (match == null) {
        link.href += replacement;
      } else {
        link.href = link.href.replace(match, replacement);
      }
    });

    var link = document.getElementById("ac-promo-link");
    link.style.display = "inline";
  };
}

(0,___WEBPACK_IMPORTED_MODULE_1__.register)("airlines", printAC);
(0,_settings_userSettings__WEBPACK_IMPORTED_MODULE_0__.registerSetting)("Air Canada", "acEdition", acEditions, "us");


/***/ }),

/***/ "./src/matrix5/links/airlines/af.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _settings_appSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/settings/appSettings.ts");
/* harmony import */ var _settings_userSettings__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/settings/userSettings.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/matrix5/utils.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/matrix5/parse/itin.ts");






const editions = [
  { name: "Brazil", value: "www.airfrance.com.br", country: "BR" },
  { name: "Finland", value: "www.airfrance.fi", country: "FI" },
  { name: "France", value: "www.airfrance.fr", country: "FR" },
  { name: "Germany", value: "www.airfrance.de", country: "DE" },
  { name: "Italy", value: "www.airfrance.it", country: "IT" },
  { name: "Netherlands", value: "www.airfrance.nl", country: "NL" },
  { name: "Spain", value: "www.airfrance.es", country: "ES" },
  { name: "United Kingdom", value: "www.airfrance.co.uk", country: "GB" },
  { name: "United States", value: "www.airfrance.us", country: "US" },
];

const cabins = ["ECONOMY", "W", "C", "F"];

function print() {
  if (!(0,___WEBPACK_IMPORTED_MODULE_2__.anyCarriers)("AF", "DL", "KL", "VS")) {
    return;
  }

  var pax = (0,___WEBPACK_IMPORTED_MODULE_2__.validatePax)({
    maxPaxcount: 9,
    countInf: true,
    childAsAdult: 12,
    sepInfSeat: false,
    childMinAge: 2,
  });
  if (!pax) {
    (0,_utils__WEBPACK_IMPORTED_MODULE_4__.printNotification)("Error: Failed to validate Passengers in printAF");
    return;
  }

  const segs = (0,_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.getCurrentSegs)();
  const cabin = cabins[(0,_settings_appSettings__WEBPACK_IMPORTED_MODULE_0__.getCabin)(Math.max(...segs.map((seg) => seg.cabin)))];

  const createUrl = function (edition) {
    const country = editions.find((e) => e.value === edition).country;
    return (
      `https://${edition}/ams/exchange?language=en&country=${country}&target=` +
      encodeURIComponent(
        `/search/summary?deviationValue=5&connections=${segs
          .map(
            (seg) =>
              `${seg.orig}:${seg.dep.year}${(0,_utils__WEBPACK_IMPORTED_MODULE_4__.to2digits)(
                seg.dep.month,
              )}${(0,_utils__WEBPACK_IMPORTED_MODULE_4__.to2digits)(seg.dep.day)}@${(0,_utils__WEBPACK_IMPORTED_MODULE_4__.to4digitTime)(seg.dep.time24)}:${
                seg.carrier
              }${(0,_utils__WEBPACK_IMPORTED_MODULE_4__.to4digits)(seg.fnr)}:${seg.bookingclass}:${seg.farebase}:${
                cabins[(0,_settings_appSettings__WEBPACK_IMPORTED_MODULE_0__.getCabin)(seg.cabin)]
              }>${seg.dest}`,
          )
          .join("-")}&cabinClass=${cabin}&pax=${pax.adults}:0:${
          pax.children.length
        }:${pax.infLap}`,
      )
    );
  };

  var url = createUrl(_settings_userSettings__WEBPACK_IMPORTED_MODULE_1__["default"].afEdition2);
  if (!url) {
    return;
  }

  var extra =
    ' <span class="pt-hover-container">[+]<span class="pt-hover-menu">';
  extra += editions
    .map(function (obj, i) {
      return (
        '<a href="' +
        createUrl(obj.value) +
        '" target="_blank">' +
        obj.name +
        "</a>"
      );
    })
    .join("<br/>");
  extra += "</span></span>";

  return {
    url,
    title: "Air France",
    extra,
  };
}

(0,___WEBPACK_IMPORTED_MODULE_2__.register)("airlines", print);
(0,_settings_userSettings__WEBPACK_IMPORTED_MODULE_1__.registerSetting)("Air France", "afEdition2", editions, "www.airfrance.us");


/***/ }),

/***/ "./src/matrix5/links/airlines/as.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/utils.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/parse/itin.ts");




function printAS() {
  if (!(0,___WEBPACK_IMPORTED_MODULE_0__.anyCarriers)("AS")) {
    return;
  }

  // validate Passengers here: Max Paxcount = 7 (Infs not included) - >11 = Adult - InfSeat = Child
  var createUrl = function () {
    var pax = (0,___WEBPACK_IMPORTED_MODULE_0__.validatePax)({
      maxPaxcount: 6,
      countInf: true,
      childAsAdult: 6,
      sepInfSeat: false,
      childMinAge: 2,
    });
    if (!pax) {
      (0,_utils__WEBPACK_IMPORTED_MODULE_2__.printNotification)("Error: Failed to validate Passengers in printAS");
      return;
    }
    var url = "https://www.alaskaair.com/planbook/shoppingstart?";
    url += "A=" + pax.adults + "&C=" + pax.children.length + "&FT=";
    url += (0,_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.isOneway)() ? "ow" : "rt";

    var k = 0;
    //Build multi-city search based on legs
    for (var i = 0; i < _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin.length; i++) {
      // walks each leg
      for (var j = 0; j < _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg.length; j++) {
        //walks each segment of leg
        var itinseg =
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j].orig +
          "|" +
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j].dest;
        itinseg +=
          "|" +
          ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j].dep.month).slice(-2) +
          "/" +
          ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j].dep.day).slice(-2);
        itinseg += "/" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j].dep.year;
        itinseg += "|" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j].fnr + "|";
        itinseg += _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j].cabin ? "f" : "c";
        url += "&F" + ++k + "=" + encodeURIComponent(itinseg);
      }
    }
    url +=
      "&DEST=" +
      _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[0].seg[_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[0].seg.length - 1].dest;
    url += "&FARE=" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.price + "&frm=cart&META=GOO_CS";
    return url;
  };
  var url = createUrl();
  if (!url) {
    return;
  }

  return {
    url,
    title: "Alaska",
  };
}

(0,___WEBPACK_IMPORTED_MODULE_0__.register)("airlines", printAS);


/***/ }),

/***/ "./src/matrix5/links/airlines/az.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _settings_userSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/settings/userSettings.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/matrix5/utils.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/parse/itin.ts");





const azEditions = [
  { value: "de_de", name: "Germany / Deutsch" },
  { value: "at_de", name: "Austria / Deutsch" },
  { value: "ch_de", name: "Switzerland / Deutsch" },
  { value: "fr_fr", name: "France / French" },
  { value: "nl_nl", name: "Netherlands / Dutch" },
  { value: "it_it", name: "Italy / Italian" },
  { value: "ca_en", name: "Canada / Englisch" },
  { value: "us_en", name: "US / Englisch" },
  { value: "gb_en", name: "GB / Englisch" },
  { value: "en_en", name: "International / Englisch" },
];

function printAZ() {
  if (!(0,___WEBPACK_IMPORTED_MODULE_1__.anyCarriers)("AZ")) {
    return;
  }

  var createUrl = function (edition) {
    var azUrl =
      "https://www.alitalia.com/" +
      edition +
      "/home-page.metasearch.json?SearchType=BrandMetasearch";
    var cabins = ["Economy", "Economy", "Business", "First"];
    var seg = 0;
    for (var i = 0; i < _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin.length; i++) {
      for (var j = 0; j < _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg.length; j++) {
        azUrl +=
          "&MetaSearchDestinations[" +
          seg +
          "].From=" +
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].orig;
        azUrl +=
          "&MetaSearchDestinations[" +
          seg +
          "].To=" +
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].dest;
        azUrl +=
          "&MetaSearchDestinations[" +
          seg +
          "].DepartureDate=" +
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].dep.year +
          "-" +
          ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].dep.month).slice(-2) +
          "-" +
          ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].dep.day).slice(-2) +
          ":" +
          ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].dep.time).slice(-5);
        azUrl +=
          "&MetaSearchDestinations[" +
          seg +
          "].ArrivalDate=" +
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].arr.year +
          "-" +
          ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].arr.month).slice(-2) +
          "-" +
          ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].arr.day).slice(-2) +
          ":" +
          ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].arr.time).slice(-5);
        azUrl +=
          "&MetaSearchDestinations[" +
          seg +
          "].Flight=" +
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].fnr;
        azUrl +=
          "&MetaSearchDestinations[" +
          seg +
          "].code=" +
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].farebase;
        azUrl += "&MetaSearchDestinations[" + seg + "].MseType=";
        azUrl +=
          "&MetaSearchDestinations[" +
          seg +
          "].bookingClass=" +
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].bookingclass;
        azUrl +=
          "&MetaSearchDestinations[" +
          seg +
          "].cabinClass=" +
          cabins[_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].cabin];
        azUrl += "&MetaSearchDestinations[" + seg + "].slices=" + i;
        seg++;
      }
    }
    var pax = (0,___WEBPACK_IMPORTED_MODULE_1__.validatePax)({
      maxPaxcount: 7,
      countInf: false,
      childAsAdult: 12,
      sepInfSeat: false,
      childMinAge: 2,
    });
    if (!pax) {
      (0,_utils__WEBPACK_IMPORTED_MODULE_3__.printNotification)("Error: Failed to validate Passengers in printAZ");
      return false;
    }
    azUrl +=
      "&children_number=" +
      pax.children.length +
      "&newborn_number=" +
      pax.infLap +
      "&adult_number=" +
      pax.adults;
    return azUrl;
  };
  // get edition
  var edition = _settings_userSettings__WEBPACK_IMPORTED_MODULE_0__["default"].azEdition;
  var azUrl = createUrl(edition);
  if (!azUrl) {
    return;
  }
  var extra =
    ' <span class="pt-hover-container">[+]<span class="pt-hover-menu">';
  extra += azEditions
    .map(function (obj, i) {
      return (
        '<a href="' +
        createUrl(obj.value) +
        '" target="_blank">' +
        obj.name +
        "</a>"
      );
    })
    .join("<br/>");
  extra += "</span></span>";

  return {
    url: azUrl,
    title: "Alitalia",
    extra,
  };
}

(0,___WEBPACK_IMPORTED_MODULE_1__.register)("airlines", printAZ);
(0,_settings_userSettings__WEBPACK_IMPORTED_MODULE_0__.registerSetting)("Alitalia", "azEdition", azEditions, "us_en");


/***/ }),

/***/ "./src/matrix5/links/airlines/ba.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _settings_appSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/settings/appSettings.ts");
/* harmony import */ var _settings_userSettings__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/settings/userSettings.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/matrix5/utils.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/matrix5/parse/itin.ts");






const baEditions = [
  { value: "AF", name: "Afghanistan" },
  { value: "AL", name: "Albania" },
  { value: "DZ", name: "Algeria" },
  { value: "AS", name: "American Samoa" },
  { value: "AD", name: "Andorra" },
  { value: "AO", name: "Angola" },
  { value: "AI", name: "Anguilla" },
  { value: "AG", name: "Antigua" },
  { value: "AR", name: "Argentina" },
  { value: "AM", name: "Armenia" },
  { value: "AW", name: "Aruba" },
  { value: "AU", name: "Australia" },
  { value: "AT", name: "Austria" },
  { value: "AZ", name: "Azerbaijan" },
  { value: "BS", name: "Bahamas" },
  { value: "BH", name: "Bahrain" },
  { value: "BD", name: "Bangladesh" },
  { value: "BB", name: "Barbados" },
  { value: "BY", name: "Belarus" },
  { value: "BE", name: "Belgium" },
  { value: "BZ", name: "Belize" },
  { value: "BJ", name: "Benin Republic" },
  { value: "BM", name: "Bermuda" },
  { value: "BT", name: "Bhutan" },
  { value: "BO", name: "Bolivia" },
  { value: "BA", name: "Bosnia-Herzegovina" },
  { value: "BW", name: "Botswana" },
  { value: "BR", name: "Brazil" },
  { value: "VG", name: "British Virgin Islands" },
  { value: "BN", name: "Brunei" },
  { value: "BG", name: "Bulgaria" },
  { value: "BF", name: "Burkina Faso" },
  { value: "BI", name: "Burundi" },
  { value: "KH", name: "Cambodia" },
  { value: "CA", name: "Canada" },
  { value: "CV", name: "Cape Verde" },
  { value: "KY", name: "Cayman Islands" },
  { value: "CF", name: "Central African Rep" },
  { value: "TD", name: "Chad" },
  { value: "CL", name: "Chile" },
  { value: "CN", name: "China" },
  { value: "CX", name: "Christmas Island" },
  { value: "CC", name: "Cocos Islands" },
  { value: "CO", name: "Colombia" },
  { value: "CG", name: "Congo" },
  { value: "CK", name: "Cook Islands" },
  { value: "CR", name: "Costa Rica" },
  { value: "HR", name: "Croatia" },
  { value: "CU", name: "Cuba" },
  { value: "CY", name: "Cyprus" },
  { value: "CZ", name: "Czech Republic" },
  { value: "DK", name: "Denmark" },
  { value: "DJ", name: "Djibouti" },
  { value: "DM", name: "Dominica" },
  { value: "DO", name: "Dominican Rep" },
  { value: "EC", name: "Ecuador" },
  { value: "EG", name: "Egypt" },
  { value: "SV", name: "El Salvador" },
  { value: "GQ", name: "Equatorial Guinea" },
  { value: "ER", name: "Eritrea" },
  { value: "EE", name: "Estonia" },
  { value: "ET", name: "Ethiopia" },
  { value: "FO", name: "Faeroe Is" },
  { value: "FK", name: "Falkland Is" },
  { value: "FJ", name: "Fiji" },
  { value: "FI", name: "Finland" },
  { value: "FR", name: "France" },
  { value: "GF", name: "French Guyana" },
  { value: "PF", name: "French Polynesia" },
  { value: "GA", name: "Gabon" },
  { value: "GM", name: "Gambia" },
  { value: "GE", name: "Georgia" },
  { value: "DE", name: "Germany" },
  { value: "GH", name: "Ghana" },
  { value: "GI", name: "Gibraltar (UK)" },
  { value: "GR", name: "Greece" },
  { value: "GL", name: "Greenland" },
  { value: "GD", name: "Grenada" },
  { value: "GP", name: "Guadeloupe" },
  { value: "GU", name: "Guam" },
  { value: "GT", name: "Guatemala" },
  { value: "GN", name: "Guinea" },
  { value: "GW", name: "Guinea Bissau" },
  { value: "GY", name: "Guyana" },
  { value: "HT", name: "Haiti" },
  { value: "HN", name: "Honduras" },
  { value: "HK", name: "Hong Kong" },
  { value: "HU", name: "Hungary" },
  { value: "IS", name: "Iceland" },
  { value: "IN", name: "India" },
  { value: "ID", name: "Indonesia" },
  { value: "IR", name: "Iran" },
  { value: "IQ", name: "Iraq" },
  { value: "IE", name: "Ireland" },
  { value: "IL", name: "Israel" },
  { value: "IT", name: "Italy" },
  { value: "CI", name: "Ivory Coast" },
  { value: "JM", name: "Jamaica" },
  { value: "JP", name: "Japan" },
  { value: "JO", name: "Jordan" },
  { value: "KZ", name: "Kazakhstan" },
  { value: "KE", name: "Kenya" },
  { value: "KI", name: "Kiribati" },
  { value: "XK", name: "Kosovo" },
  { value: "KW", name: "Kuwait" },
  { value: "KG", name: "Kyrgyzstan" },
  { value: "LA", name: "Laos" },
  { value: "LV", name: "Latvia" },
  { value: "LB", name: "Lebanon" },
  { value: "LS", name: "Lesotho" },
  { value: "LR", name: "Liberia" },
  { value: "LY", name: "Libya" },
  { value: "LI", name: "Liechtenstein" },
  { value: "LT", name: "Lithuania" },
  { value: "LU", name: "Luxembourg" },
  { value: "MO", name: "Macau" },
  { value: "MK", name: "Macedonia" },
  { value: "MG", name: "Madagascar" },
  { value: "MW", name: "Malawi" },
  { value: "MY", name: "Malaysia" },
  { value: "MV", name: "Maldives" },
  { value: "ML", name: "Mali" },
  { value: "MT", name: "Malta" },
  { value: "MP", name: "Mariana Islands" },
  { value: "MH", name: "Marshall Islands" },
  { value: "MQ", name: "Martinique" },
  { value: "MR", name: "Mauritania" },
  { value: "MU", name: "Mauritius" },
  { value: "MX", name: "Mexico" },
  { value: "FM", name: "Micronesia" },
  { value: "UM", name: "Minor Island" },
  { value: "MD", name: "Moldova" },
  { value: "MC", name: "Monaco" },
  { value: "ME", name: "Montenegro" },
  { value: "MS", name: "Montserrat" },
  { value: "MA", name: "Morocco" },
  { value: "MZ", name: "Mozambique" },
  { value: "MM", name: "Myanmar" },
  { value: "NA", name: "Namibia" },
  { value: "NR", name: "Nauru" },
  { value: "NP", name: "Nepal" },
  { value: "AN", name: "Netherland Antilles" },
  { value: "NL", name: "Netherlands" },
  { value: "NC", name: "New Caledonia" },
  { value: "NZ", name: "New Zealand" },
  { value: "NI", name: "Nicaragua" },
  { value: "NE", name: "Niger" },
  { value: "NG", name: "Nigeria" },
  { value: "NU", name: "Niue" },
  { value: "NF", name: "Norfolk Island" },
  { value: "NO", name: "Norway" },
  { value: "OM", name: "Oman" },
  { value: "PK", name: "Pakistan" },
  { value: "PA", name: "Panama" },
  { value: "PG", name: "Papua New Guinea" },
  { value: "PY", name: "Paraguay" },
  { value: "KP", name: "Peoples Rep Korea" },
  { value: "PE", name: "Peru" },
  { value: "PH", name: "Philippines" },
  { value: "PL", name: "Poland" },
  { value: "PT", name: "Portugal" },
  { value: "PR", name: "Puerto Rico" },
  { value: "QA", name: "Qatar" },
  { value: "CM", name: "Republic Cameroon" },
  { value: "RE", name: "Reunion" },
  { value: "RO", name: "Romania" },
  { value: "RU", name: "Russia" },
  { value: "RW", name: "Rwanda" },
  { value: "SM", name: "San Marino" },
  { value: "SA", name: "Saudi Arabia" },
  { value: "SN", name: "Senegal" },
  { value: "RS", name: "Serbia" },
  { value: "SC", name: "Seychelles" },
  { value: "SL", name: "Sierra Leone" },
  { value: "SG", name: "Singapore" },
  { value: "SK", name: "Slovakia" },
  { value: "SI", name: "Slovenia" },
  { value: "SB", name: "Solomon Island" },
  { value: "SO", name: "Somalia" },
  { value: "ZA", name: "South Africa" },
  { value: "KR", name: "South Korea" },
  { value: "ES", name: "Spain" },
  { value: "LK", name: "Sri Lanka" },
  { value: "KN", name: "St Kitts and Nevis" },
  { value: "LC", name: "St Lucia" },
  { value: "VC", name: "St Vincent" },
  { value: "SD", name: "Sudan" },
  { value: "SR", name: "Suriname" },
  { value: "SZ", name: "Swaziland" },
  { value: "SE", name: "Sweden" },
  { value: "CH", name: "Switzerland" },
  { value: "SY", name: "Syria" },
  { value: "TW", name: "Taiwan" },
  { value: "TJ", name: "Tajikistan" },
  { value: "TZ", name: "Tanzania" },
  { value: "TH", name: "Thailand" },
  { value: "TL", name: "Timor - Leste" },
  { value: "TG", name: "Togo" },
  { value: "TO", name: "Tonga" },
  { value: "TT", name: "Trinidad and Tobago" },
  { value: "TN", name: "Tunisia" },
  { value: "TR", name: "Turkey" },
  { value: "TM", name: "Turkmenistan" },
  { value: "TC", name: "Turks Caicos" },
  { value: "TV", name: "Tuvalu" },
  { value: "VI", name: "US Virgin Islands" },
  { value: "US", name: "USA" },
  { value: "UG", name: "Uganda" },
  { value: "UA", name: "Ukraine" },
  { value: "AE", name: "United Arab Emirates" },
  { value: "GB", name: "United Kingdom" },
  { value: "UY", name: "Uruguay" },
  { value: "UZ", name: "Uzbekistan" },
  { value: "VU", name: "Vanuatu" },
  { value: "VE", name: "Venezuela" },
  { value: "VN", name: "Vietnam" },
  { value: "WS", name: "Western Samoa" },
  { value: "YE", name: "Yemen Republic" },
  { value: "ZM", name: "Zambia" },
  { value: "ZW", name: "Zimbabwe" },
];

function printBA() {
  if (!(0,___WEBPACK_IMPORTED_MODULE_2__.anyCarriers)("IB", "EI", "BA")) {
    return;
  }

  var createUrl = function (edition, language) {
    // 0 = Economy; 1=Premium Economy; 2=Business; 3=First
    var cabins = ["M", "W", "C", "F"];
    var pax = (0,___WEBPACK_IMPORTED_MODULE_2__.validatePax)({
      maxPaxcount: 9,
      countInf: false,
      childAsAdult: 16,
      sepInfSeat: false,
      childMinAge: 2,
    });
    if (!pax) {
      (0,_utils__WEBPACK_IMPORTED_MODULE_4__.printNotification)("Error: Failed to validate Passengers in printBA");
      return false;
    }
    var tmpPax = { c: 0, y: 0 };
    for (i = 0; i < pax.children.length; i++) {
      if (pax.children[i] > 11) {
        tmpPax.y++;
      } else {
        tmpPax.c++;
      }
    }
    var url =
      "https://www.britishairways.com/travel/fx/public/" +
      language +
      "_" +
      edition +
      "?eId=111054&data=F" +
      pax.adults +
      tmpPax.y +
      tmpPax.c +
      pax.infLap +
      "LF";
    var mincabin = 3;
    //Build multi-city search based on legs
    for (var i = 0; i < _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin.length; i++) {
      // walks each leg
      for (var j = 0; j < _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].seg.length; j++) {
        //walks each segment of leg
        var k = 0;
        // lets have a look if we need to skip segments - fnr has to be the same and it must be just a layover
        while (j + k < _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].seg.length - 1) {
          if (
            _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].seg[j + k].fnr !=
              _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].seg[j + k + 1].fnr ||
            _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].seg[j + k].layoverduration >= 1440
          )
            break;
          k++;
        }
        url +=
          ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].seg[j].dep.day).slice(-2) +
          ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].seg[j].dep.month).slice(-2) +
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].seg[j].dep.year +
          ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].seg[j].dep.time.replace(":", "")).slice(
            -4,
          );
        url +=
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].seg[j].carrier +
          ("000" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].seg[j].fnr).slice(-4);
        url += cabins[_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].seg[j].cabin];
        url +=
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].seg[j].orig + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].seg[j + k].dest;
        if (_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin.length == 2 && i == 1) {
          url += "F";
        } else {
          url += "T";
        }
        if (_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].seg[j].cabin < mincabin) {
          mincabin = _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].seg[j].cabin;
        }
        j += k;
      }
    }
    url +=
      "&p=EUR6666.66&e=SL&c=" +
      cabins[_settings_appSettings__WEBPACK_IMPORTED_MODULE_0__["default"].cabin === "Auto" ? mincabin : (0,_settings_appSettings__WEBPACK_IMPORTED_MODULE_0__.getForcedCabin)()] +
      "&source=FareQuoteEmail&isEmailHBOFareQuote=false";
    return url;
  };
  // get edition
  var url = createUrl(_settings_userSettings__WEBPACK_IMPORTED_MODULE_1__["default"].baEdition, _settings_userSettings__WEBPACK_IMPORTED_MODULE_1__["default"].baLanguage);
  if (!url) {
    return;
  }
  var extra =
    ' <span class="pt-hover-container">[+]<span class="pt-hover-menu">';
  extra += baEditions
    .map(function (obj, i) {
      return (
        '<a href="' +
        createUrl(obj.value, _settings_userSettings__WEBPACK_IMPORTED_MODULE_1__["default"].baLanguage) +
        '" target="_blank">' +
        obj.name +
        "</a>"
      );
    })
    .join("<br/>");
  extra += "</span></span>";

  return {
    url,
    title: "British Airways",
    extra,
  };
}

(0,___WEBPACK_IMPORTED_MODULE_2__.register)("airlines", printBA);
(0,_settings_userSettings__WEBPACK_IMPORTED_MODULE_1__.registerSetting)("British Airways", "baEdition", baEditions, "US");


/***/ }),

/***/ "./src/matrix5/links/airlines/cz.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _settings_userSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/settings/userSettings.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/matrix5/utils.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _print_amadeus__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/print/amadeus.js");





const czEditions = [
  { value: "AR-GB", name: "Argentina / English" },
  { value: "AU-GB", name: "Australia / English" },
  { value: "AZ-GB", name: "Azerbaijan / English" },
  { value: "BD-GB", name: "Bangladesh / English" },
  { value: "BE-GB", name: "Belgium / English" },
  { value: "BR-GB", name: "Brazil / English" },
  { value: "KH-GB", name: "Cambodia / English" },
  { value: "CA-GB", name: "Canada / English" },
  { value: "CA-FR", name: "Canada / French" },
  { value: "CN-GB", name: "China / English" },
  { value: "DK-GB", name: "Denmark / English" },
  { value: "FI-GB", name: "Finland / English" },
  { value: "FR-GB", name: "France / English" },
  { value: "FR-FR", name: "France / French" },
  { value: "GE-GB", name: "Georgia / English" },
  { value: "DE-GB", name: "Germany / English" },
  { value: "DE-DE", name: "Germany / German" },
  { value: "GR-GB", name: "Greece / English" },
  { value: "HK-GB", name: "Hong Kong / English" },
  { value: "IN-GB", name: "India / English" },
  { value: "ID-GB", name: "Indonesia / English" },
  { value: "IR-GB", name: "Iran / English" },
  { value: "IE-GB", name: "Ireland / English" },
  { value: "IT-GB", name: "Italy / English" },
  { value: "JP-GB", name: "Japan / English" },
  { value: "JO-GB", name: "Jordan / English" },
  { value: "KZ-GB", name: "Kazakhstan / English" },
  { value: "KE-GB", name: "Kenya / English" },
  { value: "KG-GB", name: "Kyrgyzstan / English" },
  { value: "MY-GB", name: "Malaysia / English" },
  { value: "MV-GB", name: "Maldives / English" },
  { value: "MO-GB", name: "Macau / English" },
  { value: "MM-GB", name: "Myanmar / English" },
  { value: "NP-GB", name: "Nepal / English" },
  { value: "NL-GB", name: "Netherlands / English" },
  { value: "NZ-GB", name: "New Zealand / English" },
  { value: "NO-GB", name: "Norway / English" },
  { value: "PK-GB", name: "Pakistan / English" },
  { value: "PA-GB", name: "Panama / English" },
  { value: "PE-GB", name: "Peru / English" },
  { value: "PH-GB", name: "Philippines / English" },
  { value: "PT-GB", name: "Portugal / English" },
  { value: "RU-GB", name: "Russia / English" },
  { value: "SA-GB", name: "Saudi Arabia / English" },
  { value: "SG-GB", name: "Singapore / English" },
  { value: "ZA-GB", name: "South Africa / English" },
  { value: "KR-GB", name: "South Korea / English" },
  { value: "ES-GB", name: "Spain / English" },
  { value: "SE-GB", name: "Sweden / English" },
  { value: "CH-GB", name: "Switzerland / English" },
  { value: "TW-GB", name: "Taiwan / English" },
  { value: "TJ-GB", name: "Tajikistan / English" },
  { value: "TZ-GB", name: "Tanzania / English" },
  { value: "TH-GB", name: "Thailand / English" },
  { value: "TR-GB", name: "Turkey / English" },
  { value: "TM-GB", name: "Turkmenistan / English" },
  { value: "UA-GB", name: "Ukraine / English" },
  { value: "GB-GB", name: "United Kingdom / English" },
  { value: "AE-GB", name: "United Arab Emirates / English" },
  { value: "UG-GB", name: "Uganda / English" },
  { value: "US-GB", name: "United  States / English" },
  { value: "UZ-GB", name: "Uzbekistan / English" },
  { value: "VE-GB", name: "Venezuela / English" },
  { value: "VN-GB", name: "Vietnam / English" },
];

function printCZ() {
  if (!(0,___WEBPACK_IMPORTED_MODULE_1__.anyCarriers)("CZ")) {
    return;
  }

  var createUrl = function (edition) {
    var paxConfig = { allowinf: 1, youthage: 0 };
    var pax = (0,___WEBPACK_IMPORTED_MODULE_1__.validatePax)({
      maxPaxcount: 9,
      countInf: false,
      childAsAdult: 12,
      sepInfSeat: false,
      childMinAge: 2,
    });
    if (!pax) {
      (0,_utils__WEBPACK_IMPORTED_MODULE_3__.printNotification)("Error: Failed to validate Passengers in printCZ");
      return;
    }
    var amadeusConfig = {
      sepcabin: 0,
      detailed: 0,
      allowpremium: 0,
      inctimes: 0,
    };
    var url =
      "http://global.csair.com/CZPortal/dyn/portal/doEnc?SITE=J00YJ00Y&BOOKING_FLOW=REVENUE&IS_FLEXIBLE=FALSE&LANGUAGE=" +
      edition[1] +
      "&PRICING_TYPE=O&COUNTRY_SITE=" +
      edition[0] +
      "&DISPLAY_TYPE=1";
    var tmpPax = (0,_print_amadeus__WEBPACK_IMPORTED_MODULE_2__.getAmadeusPax)(pax, paxConfig);
    url += tmpPax.url;
    url += "&NB_ADT=" + tmpPax.adults;
    url += "&NB_INF=" + tmpPax.infants;
    url += "&NB_CHD=" + tmpPax.children;
    url += "&TRIP_TYPE=M";
    url += (0,_print_amadeus__WEBPACK_IMPORTED_MODULE_2__.getAmadeusUrl)(amadeusConfig);
    return url;
  };
  // get edition
  var edition = _settings_userSettings__WEBPACK_IMPORTED_MODULE_0__["default"].czEdition.split("-");
  if (edition.length != 2) {
    (0,_utils__WEBPACK_IMPORTED_MODULE_3__.printNotification)("Error:Invalid CZ-Edition");
    return;
  }
  var url = createUrl(edition);
  if (!url) {
    return;
  }
  var extra =
    ' <span class="pt-hover-container">[+]<span class="pt-hover-menu">';
  extra += czEditions
    .map(function (obj, i) {
      return (
        '<a href="' +
        createUrl(obj.value.split("-")) +
        '" target="_blank">' +
        obj.name +
        "</a>"
      );
    })
    .join("<br/>");
  extra += "</span></span>";

  return {
    url,
    title: "China Southern",
    extra,
  };
}

(0,___WEBPACK_IMPORTED_MODULE_1__.register)("airlines", printCZ);
(0,_settings_userSettings__WEBPACK_IMPORTED_MODULE_0__.registerSetting)("China Southern", "czEdition", czEditions, "US-GB");


/***/ }),

/***/ "./src/matrix5/links/airlines/dl.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _settings_userSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/settings/userSettings.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/matrix5/utils.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/parse/itin.ts");





const dlEditions = [
  { value: "de_de", name: "Germany" },
  { value: "www_us", name: "US" },
];

function printDL() {
  if (!(0,___WEBPACK_IMPORTED_MODULE_1__.anyCarriers)("AF", "DL", "KL", "VS")) {
    return;
  }

  var createUrl = function (edition) {
    var pax = (0,___WEBPACK_IMPORTED_MODULE_1__.validatePax)({
      maxPaxcount: 9,
      countInf: true,
      childAsAdult: 12,
      sepInfSeat: false,
      childMinAge: 2,
    });
    if (!pax) {
      (0,_utils__WEBPACK_IMPORTED_MODULE_3__.printNotification)("Error: Failed to validate Passengers in printDL");
      return;
    }
    let url = `https://${edition[0]}.delta.com/flight-search/search?tripType=multiCity`;
    url += `&paxCount=${pax.adults + pax.children.length}`;
    url += "&price=" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.price;
    url += "&currencyCd=" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.cur;
    url += "&exitCountry=" + edition[1].toUpperCase();

    const fares = [];

    let segnum = 0;
    _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin.forEach((itin, legnum) => {
      itin.seg.forEach((seg) => {
        const hour = seg.dep.time24.split(":")[0];
        const time =
          (0,_utils__WEBPACK_IMPORTED_MODULE_3__.to2digits)(+hour - (+hour < 12 ? 0 : 12)) + (+hour < 12 ? "A" : "P");
        const values = [
          legnum,
          seg.bookingclass,
          seg.orig,
          seg.dest,
          seg.carrier,
          seg.fnr,
          (0,_utils__WEBPACK_IMPORTED_MODULE_3__.monthnumberToName)(seg.dep.month),
          (0,_utils__WEBPACK_IMPORTED_MODULE_3__.to2digits)(seg.dep.day),
          seg.dep.year,
          time,
        ];
        url += `&itinSegment[${segnum}]=${values.join(":")}`;

        fares.push(seg.farebase);
        segnum++;
      });
    });

    url += `&fareBasis=${fares.join(":")}`;
    url += `&numOfSegments=${segnum}`;

    return url;
  };
  // get edition
  var edition = _settings_userSettings__WEBPACK_IMPORTED_MODULE_0__["default"].dlEdition.split("_");
  if (edition.length != 2) {
    (0,_utils__WEBPACK_IMPORTED_MODULE_3__.printNotification)("Error:Invalid Delta-Edition");
    return;
  }
  var url = createUrl(edition);
  if (!url) {
    return;
  }
  var extra =
    ' <span class="pt-hover-container">[+]<span class="pt-hover-menu">';
  extra += dlEditions
    .map(function (obj, i) {
      return (
        '<a href="' +
        createUrl(obj.value.split("_")) +
        '" target="_blank">' +
        obj.name +
        "</a>"
      );
    })
    .join("<br/>");
  extra += "</span></span>";

  return {
    url,
    title: "Delta",
    extra,
  };
}

(0,___WEBPACK_IMPORTED_MODULE_1__.register)("airlines", printDL);
(0,_settings_userSettings__WEBPACK_IMPORTED_MODULE_0__.registerSetting)("Delta", "dlEdition", dlEditions, "www_us");


/***/ }),

/***/ "./src/matrix5/links/airlines/ek.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _settings_userSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/settings/userSettings.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/matrix5/utils.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/parse/itin.ts");
/* harmony import */ var _settings_appSettings__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/matrix5/settings/appSettings.ts");






const cabins = ["0", "0", "1", "2"];

const editions = [
  { name: "Arabic (AE)", value: "/ae/arabic" },
  { name: "Arabic (BH)", value: "/bh/arabic" },
  { name: "Arabic (DZ)", value: "/dz/arabic" },
  { name: "Arabic (EG)", value: "/eg/arabic" },
  { name: "Arabic (IQ)", value: "/iq/arabic" },
  { name: "Arabic (JO)", value: "/jo/arabic" },
  { name: "Arabic (KW)", value: "/kw/arabic" },
  { name: "Arabic (LB)", value: "/lb/arabic" },
  { name: "Arabic (LY)", value: "/ly/arabic" },
  { name: "Arabic (MA)", value: "/ma/arabic" },
  { name: "Arabic (OM)", value: "/om/arabic" },
  { name: "Arabic (QA)", value: "/qa/arabic" },
  { name: "Arabic (SA)", value: "/sa/arabic" },
  { name: "Arabic (SD)", value: "/sd/arabic" },
  { name: "Arabic (SY)", value: "/sy/arabic" },
  { name: "Arabic (YE)", value: "/ye/arabic" },
  { name: "Chinese (CN)", value: "/cn/chinese" },
  { name: "Chinese (HK)", value: "/hk/chinese" },
  { name: "Chinese (TW)", value: "/tw/chinese" },
  { name: "Czech (CZ)", value: "/cz/czech" },
  { name: "Danish (DK)", value: "/dk/danish" },
  { name: "Dutch (BE)", value: "/be/dutch" },
  { name: "Dutch (NL)", value: "/nl/dutch" },
  { name: "English (AF)", value: "/af/english" },
  { name: "English (AU)", value: "/au/english" },
  { name: "English (BD)", value: "/bd/english" },
  { name: "English (BG)", value: "/bg/english" },
  { name: "English (EE)", value: "/ee/english" },
  { name: "English (ET)", value: "/et/english" },
  { name: "English (FI)", value: "/fi/english" },
  { name: "English (GH)", value: "/gh/english" },
  { name: "English (Global)", value: "/global/english" },
  { name: "English (HR)", value: "/hr/english" },
  { name: "English (IE)", value: "/ie/english" },
  { name: "English (IN)", value: "/in/english" },
  { name: "English (IR)", value: "/ir/english" },
  { name: "English (IS)", value: "/is/english" },
  { name: "English (KE)", value: "/ke/english" },
  { name: "English (KH)", value: "/kh/english" },
  { name: "English (LK)", value: "/lk/english" },
  { name: "English (LT)", value: "/lt/english" },
  { name: "English (LV)", value: "/lv/english" },
  { name: "English (MM)", value: "/mm/english" },
  { name: "English (MT)", value: "/mt/english" },
  { name: "English (MU)", value: "/mu/english" },
  { name: "English (MV)", value: "/mv/english" },
  { name: "English (MY)", value: "/my/english" },
  { name: "English (NG)", value: "/ng/english" },
  { name: "English (NZ)", value: "/nz/english" },
  { name: "English (PH)", value: "/ph/english" },
  { name: "English (PK)", value: "/pk/english" },
  { name: "English (RO)", value: "/ro/english" },
  { name: "English (SC)", value: "/sc/english" },
  { name: "English (SG)", value: "/sg/english" },
  { name: "English (TZ)", value: "/tz/english" },
  { name: "English (UG)", value: "/ug/english" },
  { name: "English (UK)", value: "/uk/english" },
  { name: "English (US)", value: "/us/english" },
  { name: "English (ZA)", value: "/za/english" },
  { name: "English (ZM)", value: "/zm/english" },
  { name: "English (ZW)", value: "/zw/english" },
  { name: "French (CA)", value: "/ca/french" },
  { name: "French (CI)", value: "/ci/french" },
  { name: "French (FR)", value: "/fr/french" },
  { name: "French (GN)", value: "/gn/french" },
  { name: "French (SN)", value: "/sn/french" },
  { name: "French (TN)", value: "/tn/french" },
  { name: "German (AT)", value: "/at/german" },
  { name: "German (DE)", value: "/de/german" },
  { name: "Greek (CY)", value: "/cy/greek" },
  { name: "Greek (GR)", value: "/gr/greek" },
  { name: "Hungarian (HU)", value: "/hu/hungarian" },
  { name: "Indonesian (ID)", value: "/id/indonesian" },
  { name: "Italian (CH)", value: "/ch/italian" },
  { name: "Italian (IT)", value: "/it/italian" },
  { name: "Japanese (JP)", value: "/jp/japanese" },
  { name: "Korean (KR)", value: "/kr/korean" },
  { name: "Norwegian (NO)", value: "/no/norwegian" },
  { name: "Polish (PL)", value: "/pl/polish" },
  { name: "Portuguese (AO)", value: "/ao/portuguese" },
  { name: "Portuguese (BR)", value: "/br/portuguese" },
  { name: "Portuguese (PT)", value: "/pt/portuguese" },
  { name: "Russian (RU)", value: "/ru/russian" },
  { name: "Russian (UA)", value: "/ua/russian" },
  { name: "Spanish (AR)", value: "/ar/spanish" },
  { name: "Spanish (CL)", value: "/cl/spanish" },
  { name: "Spanish (CO)", value: "/co/spanish" },
  { name: "Spanish (EC)", value: "/ec/spanish" },
  { name: "Spanish (ES)", value: "/es/spanish" },
  { name: "Spanish (MX)", value: "/mx/spanish" },
  { name: "Spanish (PA)", value: "/pa/spanish" },
  { name: "Spanish (PE)", value: "/pe/spanish" },
  { name: "Spanish (UY)", value: "/uy/spanish" },
  { name: "Swedish (SE)", value: "/se/swedish" },
  { name: "Thai (TH)", value: "/th/thai" },
  { name: "Turkish (TR)", value: "/tr/turkish" },
  { name: "Vietnamese (VN)", value: "/vn/vietnamese" },
];

function print() {
  if (!(0,___WEBPACK_IMPORTED_MODULE_1__.anyCarriers)("EK")) {
    return;
  }

  const pax = (0,___WEBPACK_IMPORTED_MODULE_1__.validatePax)({
    maxPaxcount: 9,
    countInf: false,
    childAsAdult: 12,
    sepInfSeat: false,
    childMinAge: 2,
  });
  if (!pax) {
    (0,_utils__WEBPACK_IMPORTED_MODULE_4__.printNotification)("Error: Failed to validate Passengers in printEK");
    return;
  }

  let desc = "";
  const createUrl = function (edition) {
    let url = `https://www.emirates.com/sessionhandler.aspx?pageurl=/IBE.aspx&pub=${edition}&j=f&section=IBE&j=t&seldcity1=${
      _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[0].orig
    }&selacity1=${_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[0].dest}&selddate1=${formatDate(
      _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[0].dep,
    )}&seladults=${pax.adults}&selofw=0&selteenager=0&selchildren=${
      pax.children.length
    }&selinfants=${pax.infLap}&selcabinclass=${
      cabins[(0,_settings_appSettings__WEBPACK_IMPORTED_MODULE_3__.getCabin)(Math.max(...(0,_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.getCurrentSegs)().map((seg) => seg.cabin)))]
    }&selcabinclass1=${
      cabins[
        (0,_settings_appSettings__WEBPACK_IMPORTED_MODULE_3__.getCabin)(Math.max(..._matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[0].seg.map((seg) => seg.cabin)))
      ]
    }&showsearch=false&showTeenager=false&showOFW=false&chkFlexibleDates=false&resultby=0&multiCity=`;
    if ((0,_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.isOneway)()) {
      url += `&seladate1=&TID=OW`;
    } else if ((0,_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.isRoundtrip)()) {
      url += `&seladate1=${formatDate(_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[1].dep)}&TID=SB`;
    } else {
      // open-jaw and multi-city for mobile only (TID=AS)
      url =
        `https://mobile.emirates.com${edition}/CAB/IBE/searchResults.xhtml?cugoDisabledCabinClass=true&flexiDate=false&searchType=MC&classTypeRadioMulti=0&bookingType=Revenue&originInterlineFlag=false&destInterlineFlag=false&totalAdults=${pax.adults}&totalTeens=0&totalChildren=${pax.children.length}&totalInfants=${pax.infLap}&` +
        _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin
          .map(
            (itin) =>
              `fromCity=${itin.orig}&toCity=${itin.dest}&classType=${
                cabins[(0,_settings_appSettings__WEBPACK_IMPORTED_MODULE_3__.getCabin)(Math.max(...itin.seg.map((seg) => seg.cabin)))]
              }&departDay=${(0,_utils__WEBPACK_IMPORTED_MODULE_4__.to2digits)(itin.dep.day)}&departMonth=${(0,_utils__WEBPACK_IMPORTED_MODULE_4__.to2digits)(
                itin.dep.month,
              )}&departYear=${
                itin.dep.year
              }&returnDay=&returnMonth=&returnYear=`,
          )
          .join("&");
      desc = "Mobile (or resize browser)";
    }
    return url;
  };

  const url = createUrl(_settings_userSettings__WEBPACK_IMPORTED_MODULE_0__["default"].ekEdition);
  if (!url) {
    return;
  }
  let extra =
    ' <span class="pt-hover-container">[+]<span class="pt-hover-menu">';
  extra += editions
    .map(function (edition, i) {
      return (
        '<a href="' +
        createUrl(edition.value) +
        '" target="_blank">' +
        edition.name +
        "</a>"
      );
    })
    .join("<br/>");
  extra += "</span></span>";

  return {
    url,
    title: "Emirates",
    desc,
    extra,
  };
}

function formatDate(date) {
  return `${(0,_utils__WEBPACK_IMPORTED_MODULE_4__.to2digits)(date.day)}-${(0,_utils__WEBPACK_IMPORTED_MODULE_4__.monthnumberToName)(date.month)}-${(0,_utils__WEBPACK_IMPORTED_MODULE_4__.to2digits)(
    date.year,
  )}`;
}

(0,___WEBPACK_IMPORTED_MODULE_1__.register)("airlines", print);
(0,_settings_userSettings__WEBPACK_IMPORTED_MODULE_0__.registerSetting)("Emirates", "ekEdition", editions, "/global/english");


/***/ }),

/***/ "./src/matrix5/links/airlines/ey.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/matrix5/utils.js");
/* harmony import */ var _print_links__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/print/links.tsx");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/parse/itin.ts");
/* harmony import */ var _settings_appSettings__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/settings/appSettings.ts");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/matrix5/links/index.ts");






const cabins = ["ECONOMY", "ECONOMY", "BUSINESS", "FIRST"];

function printEY() {
  if (!(0,___WEBPACK_IMPORTED_MODULE_3__.anyCarriers)("EY")) {
    return;
  }

  var createUrl = function () {
    var pax = (0,___WEBPACK_IMPORTED_MODULE_3__.validatePax)({
      maxPaxcount: 9,
      countInf: false,
      childAsAdult: 12,
      sepInfSeat: false,
      childMinAge: 2,
    });
    if (!pax) {
      (0,_utils__WEBPACK_IMPORTED_MODULE_4__.printNotification)("Error: Failed to validate Passengers in printEY");
      return;
    }

    let url =
      "https://booking.etihad.com/SSW2010/EYEY/webqtrip.html?journeySpan=" +
      (0,_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.getTripType)("OW", "RT", "MC");
    url += `&numAdults=${pax.adults}`;
    url += `&numChildren=${pax.children.length}`;
    url += `&numInfants=${pax.infLap}`;
    url += `&advertisedFare=${_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.price}`;
    url += `&currency=${_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.cur || "USD"}`;

    let segnum = 0;
    _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin.forEach((itin, legnum) => {
      itin.seg.forEach((seg) => {
        url += `&ms[${segnum}].from=${seg.orig}`;
        url += `&ms[${segnum}].to=${seg.dest}`;
        url += `&ms[${segnum}].departure=${seg.dep.year}-${(0,_utils__WEBPACK_IMPORTED_MODULE_4__.to2digits)(
          seg.dep.month,
        )}-${(0,_utils__WEBPACK_IMPORTED_MODULE_4__.to2digits)(seg.dep.day)}T${(0,_utils__WEBPACK_IMPORTED_MODULE_4__.to4digitTime)(seg.dep.time24)}`;
        url += `&ms[${segnum}].flight=${seg.fnr}`;
        url += `&ms[${segnum}].fbcode=${seg.farebase}`;
        url += `&ms[${segnum}].arrival=${seg.arr.year}-${(0,_utils__WEBPACK_IMPORTED_MODULE_4__.to2digits)(
          seg.arr.month,
        )}-${(0,_utils__WEBPACK_IMPORTED_MODULE_4__.to2digits)(seg.arr.day)}T${(0,_utils__WEBPACK_IMPORTED_MODULE_4__.to4digitTime)(seg.arr.time24)}`;
        url += `&ms[${segnum}].mktAirline=${seg.carrier}`;
        url += `&ms[${segnum}].leg=${legnum}`;
        url += `&ms[${segnum}].bkgClass=${seg.bookingclass}`;
        url += `&ms[${segnum}].appendBrandID=false`;
        url += `&ms[${segnum}].cbnClass=${cabins[(0,_settings_appSettings__WEBPACK_IMPORTED_MODULE_2__.getCabin)(seg.cabin)]}`;

        segnum++;
      });
    });

    return url;
  };

  var url = createUrl();
  if (!url) {
    return;
  }

  return {
    url,
    title: "Etihad",
  };
}

(0,_print_links__WEBPACK_IMPORTED_MODULE_0__.registerLink)("airlines", printEY);


/***/ }),

/***/ "./src/matrix5/links/airlines/ib.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _settings_userSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/settings/userSettings.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _otas_travix__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/links/otas/travix.js");




const ibEditions = [
  { value: "es-AO", name: "Angola - Español" },
  { value: "pt-AO", name: "Angola - Português" },
  { value: "es-DZ", name: "Argelia - Español" },
  { value: "fr-DZ", name: "Algérie - Français" },
  { value: "en-AR", name: "Argentina - English" },
  { value: "es-AR", name: "Argentina - Español" },
  { value: "en-BE", name: "Belgium - English" },
  { value: "es-BE", name: "Bélgica - Español" },
  { value: "fr-BE", name: "Belgique - Français" },
  { value: "es-BR", name: "Brasil - Español" },
  { value: "pt-BR", name: "Brasil - Português" },
  { value: "en-CL", name: "Chile - English" },
  { value: "es-CL", name: "Chile - Español" },
  { value: "en-CO", name: "Colombia - English" },
  { value: "es-CO", name: "Colombia - Español" },
  { value: "en-CR", name: "Costa Rica - English" },
  { value: "es-CR", name: "Costa Rica - Español" },
  { value: "en-HR", name: "Croatia - English" },
  { value: "es-HR", name: "Croacia - Español" },
  { value: "it-HR", name: "Croazia - Italiano" },
  { value: "en-CU", name: "Cuba - English" },
  { value: "es-CU", name: "Cuba - Español" },
  { value: "en-CZ", name: "Czech Republic - English" },
  { value: "es-CZ", name: "República Checa - Español" },
  { value: "en-DK", name: "Denmark - English" },
  { value: "es-DK", name: "Dinamarca - Español" },
  { value: "de-DE", name: "Deutschland - Deutsch" },
  { value: "es-DE", name: "Alemania - Español" },
  { value: "en-DO", name: "Dominican Republic - English" },
  { value: "es-DO", name: "República Dominicana - Español" },
  { value: "en-EC", name: "Ecuador - English" },
  { value: "es-EC", name: "Ecuador - Español" },
  { value: "en-SV", name: "El Salvador - English" },
  { value: "es-SV", name: "El Salvador - Español" },
  { value: "en-GQ", name: "Equatorial Guinea - English" },
  { value: "es-GQ", name: "Guinea Ecuatorial - Español" },
  { value: "ca-ES", name: "Espanya - Català" },
  { value: "en-ES", name: "Spain - English" },
  { value: "es-ES", name: "España - Español" },
  { value: "es-FR", name: "Francia - Español" },
  { value: "fr-FR", name: "France - Français" },
  { value: "en-GH", name: "Ghana - English" },
  { value: "es-GH", name: "Ghana - Español" },
  { value: "en-GR", name: "Greece - English" },
  { value: "es-GR", name: "Grecia - Español" },
  { value: "en-GT", name: "Guatemala - English" },
  { value: "es-GT", name: "Guatemala - Español" },
  { value: "en-HN", name: "Honduras - English" },
  { value: "es-HN", name: "Honduras - Español" },
  { value: "en-IE", name: "Ireland - English" },
  { value: "es-IE", name: "Irlanda - Español" },
  { value: "en-IL", name: "Israel - English" },
  { value: "es-IL", name: "Israel - Español" },
  { value: "en-IT", name: "Italy - English" },
  { value: "es-IT", name: "Italia - Español" },
  { value: "it-IT", name: "Italia - Italiano" },
  { value: "en-JP", name: "Japan - English" },
  { value: "es-JP", name: "Japón - Español" },
  { value: "ja-JP", name: "日本 - 日本語" },
  { value: "en-MT", name: "Malta - English" },
  { value: "es-MT", name: "Malta - Español" },
  { value: "it-MT", name: "Malta - Italiano" },
  { value: "es-MA", name: "Marruecos - Español" },
  { value: "fr-MA", name: "Maroc - Français" },
  { value: "es-MR", name: "Mauritania - Español" },
  { value: "fr-MR", name: "Mauritanie - Français" },
  { value: "en-MX", name: "Mexico - English" },
  { value: "es-MX", name: "México - Español" },
  { value: "en-NL", name: "Netherlands - English" },
  { value: "es-NL", name: "Holanda - Español" },
  { value: "nl-NL", name: "Nederland - Nederlands" },
  { value: "en-NI", name: "Nicaragua - English" },
  { value: "es-NI", name: "Nicaragua - Español" },
  { value: "en-NG", name: "Nigeria - English" },
  { value: "es-NG", name: "Nigeria - Español" },
  { value: "en-PA", name: "Panama - English" },
  { value: "es-PA", name: "Panamá - Español" },
  { value: "en-PE", name: "Peru - English" },
  { value: "es-PE", name: "Perú - Español" },
  { value: "es-PT", name: "Portugal - Español" },
  { value: "pt-PT", name: "Portugal - Português" },
  { value: "en-PR", name: "Puerto Rico - English" },
  { value: "es-PR", name: "Puerto Rico - Español" },
  { value: "en-RU", name: "Russian Federation - English" },
  { value: "es-RU", name: "Rusia - Español" },
  { value: "ru-RU", name: "Rossiya - Русский" },
  { value: "de-CH", name: "Schweiz - Deutsch" },
  { value: "es-CH", name: "Suiza - Español" },
  { value: "fr-CH", name: "Suisse - Français" },
  { value: "es-SN", name: "Senegal - Español" },
  { value: "fr-SN", name: "Sénégal - Français" },
  { value: "en-ZA", name: "South Africa - English" },
  { value: "es-ZA", name: "Sudáfrica - Español" },
  { value: "en-SE", name: "Sweden - English" },
  { value: "es-SE", name: "Suecia - Español" },
  { value: "en-TR", name: "Turkey - English" },
  { value: "es-TR", name: "Turquía - Español" },
  { value: "en-US", name: "USA - English" },
  { value: "es-US", name: "USA - Español" },
  { value: "en-GB", name: "United Kingdom - English" },
  { value: "es-GB", name: "Reino Unido - Español" },
  { value: "en-UY", name: "Uruguay - English" },
  { value: "es-UY", name: "Uruguay - Español" },
  { value: "en-VE", name: "Venezuela - English" },
  { value: "es-VE", name: "Venezuela - Español" },
];

function printIB() {
  if (!(0,___WEBPACK_IMPORTED_MODULE_1__.anyCarriers)("IB", "BA")) {
    return;
  }

  // 0 = Economy; 1=Premium Economy; 2=Business; 3=First
  var cabins = ["Economy", "Economy", "Business", "First"];
  var createUrl = (edition, currency) =>
    `http://www.iberia.com/web/partnerLink.do?${(0,_otas_travix__WEBPACK_IMPORTED_MODULE_2__.buildQueryString)(
      currency,
      edition[1],
      edition[0],
      cabins,
    )}`;

  // get edition
  var edition = _settings_userSettings__WEBPACK_IMPORTED_MODULE_0__["default"].ibEdition.split("-");
  var url = createUrl(edition, "USD");
  if (!url) {
    return;
  }
  var extra =
    ' <span class="pt-hover-container">[+]<span class="pt-hover-menu">';
  extra += ibEditions
    .map(function (obj, i) {
      return (
        '<a href="' +
        createUrl(obj.value.split("-"), "USD") +
        '" target="_blank">' +
        obj.name +
        "</a>"
      );
    })
    .join("<br/>");
  extra += "</span></span>";

  return {
    url,
    title: "Iberia",
    extra,
  };
}

(0,___WEBPACK_IMPORTED_MODULE_1__.register)("airlines", printIB);
(0,_settings_userSettings__WEBPACK_IMPORTED_MODULE_0__.registerSetting)("Iberia", "ibEdition", ibEditions, "en-US");


/***/ }),

/***/ "./src/matrix5/links/airlines/kl.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _settings_appSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/settings/appSettings.ts");
/* harmony import */ var _settings_userSettings__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/settings/userSettings.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/matrix5/utils.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/matrix5/parse/itin.ts");






const klEditions = [
  { value: "de_de", name: "Germany / Deutsch" },
  { value: "de_en", name: "Germany / English" },
  { value: "fr_en", name: "France / English" },
  { value: "fr_fr", name: "France / French" },
  { value: "nl_en", name: "Netherlands / English" },
  { value: "gb_en", name: "United Kingdom / English" },
  { value: "us_en", name: "US / English" },
];

const cabins = ["M", "W", "C", "F"];

function printKL() {
  if (!(0,___WEBPACK_IMPORTED_MODULE_2__.anyCarriers)("AF", "DL", "KL", "VS")) {
    return;
  }

  var createUrl = function (edition) {
    var pax = (0,___WEBPACK_IMPORTED_MODULE_2__.validatePax)({
      maxPaxcount: 9,
      countInf: false,
      childAsAdult: 12,
      sepInfSeat: false,
      childMinAge: 2,
    });
    if (!pax) {
      (0,_utils__WEBPACK_IMPORTED_MODULE_4__.printNotification)("Error: Failed to validate Passengers in printKL");
      return;
    }

    const segs = (0,_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.getCurrentSegs)();

    let url =
      "https://www.klm.com/ams/search-web/api/metasearch?application=EBT7";
    url +=
      "&trip=" +
      segs
        .map(
          (seg) =>
            `${seg.orig}:${seg.dep.year}${(0,_utils__WEBPACK_IMPORTED_MODULE_4__.to2digits)(seg.dep.month)}${(0,_utils__WEBPACK_IMPORTED_MODULE_4__.to2digits)(
              seg.dep.day,
            )}@${(0,_utils__WEBPACK_IMPORTED_MODULE_4__.to4digitTime)(seg.dep.time)}:${seg.carrier}${(0,_utils__WEBPACK_IMPORTED_MODULE_4__.to4digits)(
              seg.fnr,
            )}:${seg.bookingclass}>${seg.dest}`,
        )
        .join("-");
    url += "&ref=MS,fb=" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.farebases.join(".");
    url += "&numberOfAdults=" + pax.adults;
    url += "&numberOfChildren=" + pax.children.length;
    url += "&numberOfInfants=" + pax.infLap;
    url +=
      "&cabinClass=" +
      cabins[(0,_settings_appSettings__WEBPACK_IMPORTED_MODULE_0__.getCabin)(Math.min(...segs.map((seg) => seg.cabin)))];
    url += "&country=" + edition[0];
    url += "&language=" + edition[1];

    return url;
  };

  // get edition
  var edition = _settings_userSettings__WEBPACK_IMPORTED_MODULE_1__["default"].klEdition.split("_");
  if (edition.length != 2) {
    (0,_utils__WEBPACK_IMPORTED_MODULE_4__.printNotification)("Error:Invalid KLM-Edition");
    return;
  }
  var url = createUrl(edition);
  if (!url) {
    return;
  }
  var extra =
    ' <span class="pt-hover-container">[+]<span class="pt-hover-menu">';
  extra += klEditions
    .map(function (obj, i) {
      return (
        '<a href="' +
        createUrl(obj.value.split("_")) +
        '" target="_blank">' +
        obj.name +
        "</a>"
      );
    })
    .join("<br/>");
  extra += "</span></span>";

  return {
    url,
    title: "KLM",
    extra,
  };
}

(0,___WEBPACK_IMPORTED_MODULE_2__.register)("airlines", printKL);
(0,_settings_userSettings__WEBPACK_IMPORTED_MODULE_1__.registerSetting)("KLM", "klEdition", klEditions, "us_en");


/***/ }),

/***/ "./src/matrix5/links/airlines/la.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _settings_userSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/settings/userSettings.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/matrix5/utils.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/parse/itin.ts");





const laEditions = [
  { value: "es/ar", name: "Argentina / Spanish" },
  { value: "pt/br", name: "Brasil / Portuguese" },
  { value: "es/cl", name: "Chile / Spanish" },
  { value: "es/co", name: "Colombia / Spanish" },
  { value: "es/ec", name: "Ecuador / Spanish" },
  { value: "es/pe", name: "Peru / Spanish" },
  { value: "es/uy", name: "Uruguay / Spanish" },
  { value: "en/us", name: "US / English" },
  { value: "es/mx", name: "Mexico / Spanish" },
  { value: "en/ca", name: "Canada / English" },
  { value: "de/de", name: "Germany / German" },
  { value: "es/es", name: "Spain / Spanish" },
  { value: "fr/fr", name: "France / French" },
  { value: "en/it", name: "Italy / English" },
  { value: "en/uk", name: "UK / English" },
  { value: "en/ue", name: "Rest of Europe / English" },
  { value: "en/au", name: "Australia / English" },
  { value: "en/nz", name: "New Zealand / English" },
  { value: "es/un", name: "Other Countries / Spanish" },
  { value: "en/un", name: "Other Countries / English" },
];

function printLA() {
  if (!(0,___WEBPACK_IMPORTED_MODULE_1__.anyCarriers)("LA")) {
    return;
  }

  // NOTE: currency will be determined by the locale; the deeplink does not support manually specifying the currency
  var createUrl = function (edition) {
    var pax = (0,___WEBPACK_IMPORTED_MODULE_1__.validatePax)({
      maxPaxcount: 9,
      countInf: false,
      childAsAdult: 12,
      sepInfSeat: false,
      childMinAge: 2,
    });
    if (!pax) {
      (0,_utils__WEBPACK_IMPORTED_MODULE_3__.printNotification)("Error: Failed to validate Passengers in printLA");
      return;
    }

    const parameters = {
      passengers: {
        numberAdults: pax.adults.toString(),
        numberInfants: pax.infLap.toString(),
        numberChildren: pax.children.length.toString(),
      },
      trip: {
        flights: _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin.map((itin) => {
          return {
            amount: _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.price,
            currency: _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.cur || "USD",
            segments: itin.seg.map((seg) => {
              return {
                departure_airport: seg.orig,
                flight_number: seg.fnr,
                departure_date: formatDate(seg.dep),
                arrival_airport: seg.dest,
                farebasis: seg.farebase,
                marketing_airline: seg.carrier,
                class: seg.bookingclass,
                arrival_date: formatDate(seg.arr),
              };
            }),
          };
        }),
      },
    };

    // The booking.lan.com url as of 2/27/2020 needs to be http instead of https. Fortunately, it does redirect you
    // to https://ssl.lan.com afterwards, but the booking link seems to be more successful than starting with ssl
    return (
      `http://booking.lan.com/cgi-bin/compra/paso4.cgi?forced_home=${edition}&sessionParameters=` +
      encodeURIComponent(JSON.stringify(parameters))
    );
  };
  var url = createUrl(_settings_userSettings__WEBPACK_IMPORTED_MODULE_0__["default"].laEdition);
  if (!url) {
    return;
  }
  var extra =
    ' <span class="pt-hover-container">[+]<span class="pt-hover-menu">';
  extra += laEditions
    .map(function (obj, i) {
      return (
        '<a href="' +
        createUrl(obj.value) +
        '" target="_blank">' +
        obj.name +
        "</a>"
      );
    })
    .join("<br/>");
  extra += "</span></span>";
  return {
    url,
    title: "LATAM",
    extra,
  };
}

function formatDate(date) {
  return `${date.year}-${(0,_utils__WEBPACK_IMPORTED_MODULE_3__.to2digits)(date.month)}-${(0,_utils__WEBPACK_IMPORTED_MODULE_3__.to2digits)(date.day)}`;
}

(0,___WEBPACK_IMPORTED_MODULE_1__.register)("airlines", printLA);
(0,_settings_userSettings__WEBPACK_IMPORTED_MODULE_0__.registerSetting)("LATAM", "laEdition", laEditions, "en/us");


/***/ }),

/***/ "./src/matrix5/links/airlines/lh.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _settings_userSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/settings/userSettings.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/matrix5/utils.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _print_amadeus__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/print/amadeus.js");





const lhEditions = [
  { value: "AL-gb", name: "Albania / English" },
  { value: "DZ-fr", name: "Algeria / Français" },
  { value: "AO-gb", name: "Angola / English" },
  { value: "AR-es", name: "Argentina / Español" },
  { value: "AM-gb", name: "Armenia / English" },
  { value: "AU-gb", name: "Australia / English" },
  { value: "AT-de", name: "Austria / Deutsch" },
  { value: "AT-gb", name: "Austria / English" },
  { value: "AZ-gb", name: "Azerbaijan / English" },
  { value: "BH-gb", name: "Bahrain / English" },
  { value: "BY-gb", name: "Belarus / English" },
  { value: "BE-gb", name: "Belgium / English" },
  { value: "BA-gb", name: "Bosnia/Hercegovina / English" },
  { value: "BR-pt", name: "Brazil / Português" },
  { value: "BG-gb", name: "Bulgaria / English" },
  { value: "CA-gb", name: "Canada / English" },
  { value: "CA-fr", name: "Canada / Français" },
  { value: "CL-es", name: "Chile / Español" },
  { value: "CN-gb", name: "China / English" },
  { value: "CO-es", name: "Colombia / Español" },
  { value: "HR-gb", name: "Croatia / English" },
  { value: "CY-gb", name: "Cyprus / English" },
  { value: "CZ-gb", name: "Czech Republic / English" },
  { value: "DK-gb", name: "Denmark / English" },
  { value: "EG-gb", name: "Egypt / English" },
  { value: "GQ-gb", name: "Equatorial Guinea / English" },
  { value: "ER-gb", name: "Eritrea / English" },
  { value: "EE-gb", name: "Estonia / English" },
  { value: "ET-gb", name: "Ethiopia / English" },
  { value: "FI-gb", name: "Finland / English" },
  { value: "FR-gb", name: "France / English" },
  { value: "FR-fr", name: "France / Français" },
  { value: "GA-gb", name: "Gabon / English" },
  { value: "GE-gb", name: "Georgia / English" },
  { value: "DE-de", name: "Germany / Deutsch" },
  { value: "DE-gb", name: "Germany / English" },
  { value: "GH-gb", name: "Ghana / English" },
  { value: "GR-gb", name: "Greece / English" },
  { value: "HK-gb", name: "Hong Kong / English" },
  { value: "HU-gb", name: "Hungary / English" },
  { value: "IS-gb", name: "Iceland / English" },
  { value: "IN-gb", name: "India / English" },
  { value: "ID-gb", name: "Indonesia / English" },
  { value: "IR-gb", name: "Iran / English" },
  { value: "IQ-gb", name: "Iraq / English" },
  { value: "IE-gb", name: "Ireland / English" },
  { value: "IL-gb", name: "Israel / English" },
  { value: "IT-it", name: "Italy / Italiano" },
  { value: "IT-gb", name: "Italy / English" },
  { value: "JP-gb", name: "Japan / English" },
  { value: "JO-gb", name: "Jordan / English" },
  { value: "KZ-gb", name: "Kazakhstan / English" },
  { value: "KE-gb", name: "Kenya / English" },
  { value: "KR-gb", name: "Republic of Korea / English" },
  { value: "KW-gb", name: "Kuwait / English" },
  { value: "LV-gb", name: "Latvia / English" },
  { value: "LB-gb", name: "Lebanon / English" },
  { value: "LY-gb", name: "Libya / English" },
  { value: "LT-gb", name: "Lithuania / English" },
  { value: "LU-gb", name: "Luxembourg / English" },
  { value: "MY-gb", name: "Malaysia / English" },
  { value: "MV-gb", name: "Maldives / English" },
  { value: "MT-gb", name: "Malta / English" },
  { value: "MU-gb", name: "Mauritius / English" },
  { value: "MX-es", name: "Mexico / Español" },
  { value: "MD-gb", name: "Moldova / English" },
  { value: "MA-fr", name: "Morocco / Français" },
  { value: "NL-gb", name: "Netherlands / English" },
  { value: "NZ-gb", name: "New Zealand / English" },
  { value: "NG-gb", name: "Nigeria / English" },
  { value: "NO-gb", name: "Norway / English" },
  { value: "OM-gb", name: "Oman / English" },
  { value: "PK-gb", name: "Pakistan / English" },
  { value: "PA-es", name: "Panama / Español" },
  { value: "PH-gb", name: "Philippines / English" },
  { value: "PL-gb", name: "Poland / English" },
  { value: "PL-pl", name: "Poland / Polski" },
  { value: "PT-gb", name: "Portugal / English" },
  { value: "PT-pt", name: "Portugal / Português" },
  { value: "QA-gb", name: "Qatar / English" },
  { value: "CD-gb", name: "Republic of the Congo / English" },
  { value: "RO-gb", name: "Romania / English" },
  { value: "RU-gb", name: "Russia / English" },
  { value: "RU-ru", name: "Russia / Русский" },
  { value: "SA-gb", name: "Saudi Arabia / English" },
  { value: "RS-gb", name: "Serbia / English" },
  { value: "SG-gb", name: "Singapore / English" },
  { value: "SK-gb", name: "Slovakia / English" },
  { value: "SI-gb", name: "Slovenia / English" },
  { value: "ZA-gb", name: "South Africa / English" },
  { value: "ES-gb", name: "Spain / English" },
  { value: "ES-es", name: "Spain / Español" },
  { value: "SD-gb", name: "Sudan / English" },
  { value: "SE-gb", name: "Sweden / English" },
  { value: "CH-de", name: "Switzerland / Deutsch" },
  { value: "CH-gb", name: "Switzerland / English" },
  { value: "CH-fr", name: "Switzerland / Français" },
  { value: "TW-gb", name: "Taiwan / English " },
  { value: "TH-gb", name: "Thailand / English" },
  { value: "TN-fr", name: "Tunisia / Français" },
  { value: "TR-gb", name: "Turkey / English" },
  { value: "TM-gb", name: "Turkmenistan / English" },
  { value: "UA-gb", name: "Ukraine / English" },
  { value: "AE-gb", name: "United Arab Emirates / English" },
  { value: "UK-gb", name: "United Kingdom / English" },
  { value: "US-gb", name: "United States / English" },
  { value: "VE-es", name: "Venezuela / Español" },
  { value: "VN-gb", name: "Vietnam / English" },
  { value: "XX-gb", name: "Other countries / English" },
];

function printLH() {
  if (!(0,___WEBPACK_IMPORTED_MODULE_1__.anyCarriers)("LH", "LX", "OS", "SN")) {
    return;
  }

  var createUrl = function (edition) {
    var paxConfig = { allowinf: 1, youthage: 0 };
    var pax = (0,___WEBPACK_IMPORTED_MODULE_1__.validatePax)({
      maxPaxcount: 9,
      countInf: false,
      childAsAdult: 12,
      sepInfSeat: false,
      childMinAge: 2,
    });
    if (!pax) {
      (0,_utils__WEBPACK_IMPORTED_MODULE_3__.printNotification)("Error: Failed to validate Passengers in printLH");
      return false;
    }
    var amadeusConfig = {
      sepcabin: 0,
      detailed: 0,
      allowpremium: 1,
      inctimes: 0,
    };
    var url = "https://book.lufthansa.com/lh/dyn/air-lh/revenue/availThenFare?";
    url += "WDS_MSE_PRICE_CURRENCY=EUR&WDS_MSE_TOTAL_PRICE=1.00&";
    url +=
      "PORTAL=LH&COUNTRY_SITE=" +
      edition[0].toUpperCase() +
      "&POS=" +
      edition[0].toUpperCase() +
      "&LANGUAGE=" +
      edition[1].toUpperCase() +
      "&SECURE=TRUE&SITE=LUFTLUFT";
    var tmpPax = (0,_print_amadeus__WEBPACK_IMPORTED_MODULE_2__.getAmadeusPax)(pax, paxConfig);
    url += tmpPax.url;
    url += "&NB_ADT=" + tmpPax.adults;
    url += "&NB_INF=" + tmpPax.infants;
    url += "&NB_CHD=" + tmpPax.children;
    url += "&TRIP_TYPE=" + (0,_print_amadeus__WEBPACK_IMPORTED_MODULE_2__.getAmadeusTriptype)();
    url += (0,_print_amadeus__WEBPACK_IMPORTED_MODULE_2__.getAmadeusUrl)(amadeusConfig);

    return url;
  };
  // get edition
  var edition = _settings_userSettings__WEBPACK_IMPORTED_MODULE_0__["default"].lhEdition.split("-");
  if (edition.length != 2) {
    (0,_utils__WEBPACK_IMPORTED_MODULE_3__.printNotification)("Error:Invalid Lufthansa-Edition");
    return;
  }
  var url = createUrl(edition);
  if (!url) {
    return;
  }
  var extra =
    ' <span class="pt-hover-container">[+]<span class="pt-hover-menu">';
  extra += lhEditions
    .map(function (obj, i) {
      return (
        '<a href="' +
        createUrl(obj.value.split("-")) +
        '" target="_blank">' +
        obj.name +
        "</a>"
      );
    })
    .join("<br/>");
  extra += "</span></span>";

  return {
    url,
    title: "Lufthansa",
    extra,
  };
}

(0,___WEBPACK_IMPORTED_MODULE_1__.register)("airlines", printLH);
(0,_settings_userSettings__WEBPACK_IMPORTED_MODULE_0__.registerSetting)("Lufthansa", "lhEdition", lhEditions, "US-gb");


/***/ }),

/***/ "./src/matrix5/links/airlines/lx.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _settings_userSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/settings/userSettings.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/matrix5/utils.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _print_amadeus__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/print/amadeus.js");





const lxEditions = [
  { value: "AL-gb", name: "Albania / English" },
  { value: "DZ-fr", name: "Algeria / Français" },
  { value: "AO-gb", name: "Angola / English" },
  { value: "AR-es", name: "Argentina / Español" },
  { value: "AM-gb", name: "Armenia / English" },
  { value: "AU-gb", name: "Australia / English" },
  { value: "AT-de", name: "Austria / Deutsch" },
  { value: "AT-gb", name: "Austria / English" },
  { value: "AZ-gb", name: "Azerbaijan / English" },
  { value: "BH-gb", name: "Bahrain / English" },
  { value: "BY-gb", name: "Belarus / English" },
  { value: "BE-gb", name: "Belgium / English" },
  { value: "BA-gb", name: "Bosnia/Hercegovina / English" },
  { value: "BR-pt", name: "Brazil / Português" },
  { value: "BG-gb", name: "Bulgaria / English" },
  { value: "CA-gb", name: "Canada / English" },
  { value: "CA-fr", name: "Canada / Français" },
  { value: "CL-es", name: "Chile / Español" },
  { value: "CN-gb", name: "China / English" },
  { value: "CO-es", name: "Colombia / Español" },
  { value: "HR-gb", name: "Croatia / English" },
  { value: "CY-gb", name: "Cyprus / English" },
  { value: "CZ-gb", name: "Czech Republic / English" },
  { value: "DK-gb", name: "Denmark / English" },
  { value: "EG-gb", name: "Egypt / English" },
  { value: "GQ-gb", name: "Equatorial Guinea / English" },
  { value: "ER-gb", name: "Eritrea / English" },
  { value: "EE-gb", name: "Estonia / English" },
  { value: "ET-gb", name: "Ethiopia / English" },
  { value: "FI-gb", name: "Finland / English" },
  { value: "FR-gb", name: "France / English" },
  { value: "FR-fr", name: "France / Français" },
  { value: "GA-gb", name: "Gabon / English" },
  { value: "GE-gb", name: "Georgia / English" },
  { value: "DE-de", name: "Germany / Deutsch" },
  { value: "DE-gb", name: "Germany / English" },
  { value: "GH-gb", name: "Ghana / English" },
  { value: "GR-gb", name: "Greece / English" },
  { value: "HK-gb", name: "Hong Kong / English" },
  { value: "HU-gb", name: "Hungary / English" },
  { value: "IS-gb", name: "Iceland / English" },
  { value: "IN-gb", name: "India / English" },
  { value: "ID-gb", name: "Indonesia / English" },
  { value: "IR-gb", name: "Iran / English" },
  { value: "IQ-gb", name: "Iraq / English" },
  { value: "IE-gb", name: "Ireland / English" },
  { value: "IL-gb", name: "Israel / English" },
  { value: "IT-it", name: "Italy / Italiano" },
  { value: "IT-gb", name: "Italy / English" },
  { value: "JP-gb", name: "Japan / English" },
  { value: "JO-gb", name: "Jordan / English" },
  { value: "KZ-gb", name: "Kazakhstan / English" },
  { value: "KE-gb", name: "Kenya / English" },
  { value: "KR-gb", name: "Republic of Korea / English" },
  { value: "KW-gb", name: "Kuwait / English" },
  { value: "LV-gb", name: "Latvia / English" },
  { value: "LB-gb", name: "Lebanon / English" },
  { value: "LY-gb", name: "Libya / English" },
  { value: "LT-gb", name: "Lithuania / English" },
  { value: "LU-gb", name: "Luxembourg / English" },
  { value: "MY-gb", name: "Malaysia / English" },
  { value: "MV-gb", name: "Maldives / English" },
  { value: "MT-gb", name: "Malta / English" },
  { value: "MU-gb", name: "Mauritius / English" },
  { value: "MX-es", name: "Mexico / Español" },
  { value: "MD-gb", name: "Moldova / English" },
  { value: "MA-fr", name: "Morocco / Français" },
  { value: "NL-gb", name: "Netherlands / English" },
  { value: "NZ-gb", name: "New Zealand / English" },
  { value: "NG-gb", name: "Nigeria / English" },
  { value: "NO-gb", name: "Norway / English" },
  { value: "OM-gb", name: "Oman / English" },
  { value: "PK-gb", name: "Pakistan / English" },
  { value: "PA-es", name: "Panama / Español" },
  { value: "PH-gb", name: "Philippines / English" },
  { value: "PL-gb", name: "Poland / English" },
  { value: "PL-pl", name: "Poland / Polski" },
  { value: "PT-gb", name: "Portugal / English" },
  { value: "PT-pt", name: "Portugal / Português" },
  { value: "QA-gb", name: "Qatar / English" },
  { value: "CD-gb", name: "Republic of the Congo / English" },
  { value: "RO-gb", name: "Romania / English" },
  { value: "RU-gb", name: "Russia / English" },
  { value: "RU-ru", name: "Russia / Русский" },
  { value: "SA-gb", name: "Saudi Arabia / English" },
  { value: "RS-gb", name: "Serbia / English" },
  { value: "SG-gb", name: "Singapore / English" },
  { value: "SK-gb", name: "Slovakia / English" },
  { value: "SI-gb", name: "Slovenia / English" },
  { value: "ZA-gb", name: "South Africa / English" },
  { value: "ES-gb", name: "Spain / English" },
  { value: "ES-es", name: "Spain / Español" },
  { value: "SD-gb", name: "Sudan / English" },
  { value: "SE-gb", name: "Sweden / English" },
  { value: "CH-de", name: "Switzerland / Deutsch" },
  { value: "CH-gb", name: "Switzerland / English" },
  { value: "CH-fr", name: "Switzerland / Français" },
  { value: "TW-gb", name: "Taiwan / English " },
  { value: "TH-gb", name: "Thailand / English" },
  { value: "TN-fr", name: "Tunisia / Français" },
  { value: "TR-gb", name: "Turkey / English" },
  { value: "TM-gb", name: "Turkmenistan / English" },
  { value: "UA-gb", name: "Ukraine / English" },
  { value: "AE-gb", name: "United Arab Emirates / English" },
  { value: "UK-gb", name: "United Kingdom / English" },
  { value: "US-gb", name: "United States / English" },
  { value: "VE-es", name: "Venezuela / Español" },
  { value: "VN-gb", name: "Vietnam / English" },
  { value: "XX-gb", name: "Other countries / English" },
];

function print() {
  if (!(0,___WEBPACK_IMPORTED_MODULE_1__.anyCarriers)("LH", "LX", "OS", "SN")) {
    return;
  }

  var createUrl = function (edition) {
    var paxConfig = { allowinf: 1, youthage: 0 };
    var pax = (0,___WEBPACK_IMPORTED_MODULE_1__.validatePax)({
      maxPaxcount: 9,
      countInf: false,
      childAsAdult: 12,
      sepInfSeat: false,
      childMinAge: 2,
    });
    if (!pax) {
      (0,_utils__WEBPACK_IMPORTED_MODULE_3__.printNotification)("Error: Failed to validate Passengers in print");
      return false;
    }
    var amadeusConfig = {
      sepcabin: 0,
      detailed: 0,
      allowpremium: 1,
      inctimes: 0,
    };
    var url = "https://book.swiss.com/lh/dyn/air-lh/revenue/availThenFare?";
    url += "WDS_MSE_PRICE_CURRENCY=EUR&WDS_MSE_TOTAL_PRICE=1.00&";
    url +=
      "PORTAL=LX&COUNTRY_SITE=" +
      edition[0].toUpperCase() +
      "&POS=" +
      edition[0].toUpperCase() +
      "&LANGUAGE=" +
      edition[1].toUpperCase() +
      "&SECURE=TRUE&SITE=LUFTSWSS";
    var tmpPax = (0,_print_amadeus__WEBPACK_IMPORTED_MODULE_2__.getAmadeusPax)(pax, paxConfig);
    url += tmpPax.url;
    url += "&NB_ADT=" + tmpPax.adults;
    url += "&NB_INF=" + tmpPax.infants;
    url += "&NB_CHD=" + tmpPax.children;
    url += "&TRIP_TYPE=" + (0,_print_amadeus__WEBPACK_IMPORTED_MODULE_2__.getAmadeusTriptype)();
    url += (0,_print_amadeus__WEBPACK_IMPORTED_MODULE_2__.getAmadeusUrl)(amadeusConfig);

    return url;
  };
  // get edition
  var edition = _settings_userSettings__WEBPACK_IMPORTED_MODULE_0__["default"].lxEdition2.split("-");
  if (edition.length != 2) {
    (0,_utils__WEBPACK_IMPORTED_MODULE_3__.printNotification)("Error:Invalid Swiss-Edition");
    return;
  }
  var url = createUrl(edition);
  if (!url) {
    return;
  }
  var extra =
    ' <span class="pt-hover-container">[+]<span class="pt-hover-menu">';
  extra += lxEditions
    .map(function (obj, i) {
      return (
        '<a href="' +
        createUrl(obj.value.split("-")) +
        '" target="_blank">' +
        obj.name +
        "</a>"
      );
    })
    .join("<br/>");
  extra += "</span></span>";

  return {
    url,
    title: "Swiss",
    extra,
  };
}

(0,___WEBPACK_IMPORTED_MODULE_1__.register)("airlines", print);
(0,_settings_userSettings__WEBPACK_IMPORTED_MODULE_0__.registerSetting)("Swiss", "lxEdition2", lxEditions, "US-gb");


/***/ }),

/***/ "./src/matrix5/links/airlines/oa.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/utils.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _print_amadeus__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/print/amadeus.js");




function printOA() {
  if (!(0,___WEBPACK_IMPORTED_MODULE_0__.anyCarriers)("OA", "A3")) {
    return;
  }

  var url =
    "https://e-ticket.olympicair.com/A3Responsive/dyn/air/booking/?BOOKING_FLOW=REVENUE&FLEXIBILITY=3&DISPLAY_TYPE=2&FORCE_OVERRIDE=TRUE&PRICING_TYPE=O";
  var pax = (0,___WEBPACK_IMPORTED_MODULE_0__.validatePax)({
    maxPaxcount: 9,
    countInf: false,
    childAsAdult: 12,
    sepInfSeat: false,
    childMinAge: 2,
  });
  if (!pax) {
    (0,_utils__WEBPACK_IMPORTED_MODULE_2__.printNotification)("Error: Failed to validate Passengers in printOA");
    return;
  }
  var paxConfig = { allowinf: 1, youthage: 0 };
  var amadeusConfig = {
    sepcabin: 0,
    detailed: 0,
    allowpremium: 1,
    inctimes: 1,
  };
  var tmpPax = (0,_print_amadeus__WEBPACK_IMPORTED_MODULE_1__.getAmadeusPax)(pax, paxConfig);
  url += "&TRIP_TYPE=" + (0,_print_amadeus__WEBPACK_IMPORTED_MODULE_1__.getAmadeusTriptype)();
  url += tmpPax.url;
  url += (0,_print_amadeus__WEBPACK_IMPORTED_MODULE_1__.getAmadeusUrl)(amadeusConfig);
  url +=
    "&SITE=E00KE00K&SKIN=skin_oa&SO_GL=%3CSO_GL%3E%09%3CGLOBAL_LIST%3E%09%09%3CNAME%3ESL_TRAVELLER_TYPE_LIST%3C%2FNAME%3E%09%09%3CLIST_ELEMENT%3E%3CCODE%3EADT%3C%2FCODE%3E%3CLIST_VALUE%3EAdult%3C%2FLIST_VALUE%3E%3CLIST_VALUE%3EN%3C%2FLIST_VALUE%3E%3CLIST_VALUE%3EADT%3C%2FLIST_VALUE%3E%3C%2FLIST_ELEMENT%3E%09%09%3CLIST_ELEMENT%3E%3CCODE%3EB15%3C%2FCODE%3E%3CLIST_VALUE%3EYoung+adult%3C%2FLIST_VALUE%3E%3CLIST_VALUE%3EN%3C%2FLIST_VALUE%3E%3CLIST_VALUE%3EB15%3C%2FLIST_VALUE%3E%3C%2FLIST_ELEMENT%3E%09%09%3CLIST_ELEMENT%3E%3CCODE%3EC07%3C%2FCODE%3E%3CLIST_VALUE%3EYouth%3C%2FLIST_VALUE%3E%3CLIST_VALUE%3EN%3C%2FLIST_VALUE%3E%3CLIST_VALUE%3EC07%3C%2FLIST_VALUE%3E%3C%2FLIST_ELEMENT%3E%09%09%3CLIST_ELEMENT%3E%3CCODE%3EC03%3C%2FCODE%3E%3CLIST_VALUE%3EChild%3C%2FLIST_VALUE%3E%3CLIST_VALUE%3EN%3C%2FLIST_VALUE%3E%3CLIST_VALUE%3EC03%3C%2FLIST_VALUE%3E%3C%2FLIST_ELEMENT%3E%09%09%3CLIST_ELEMENT%3E%3CCODE%3EINF%3C%2FCODE%3E%3CLIST_VALUE%3EInfant%3C%2FLIST_VALUE%3E%3CLIST_VALUE%3EN%3C%2FLIST_VALUE%3E%3CLIST_VALUE%3EINF%3C%2FLIST_VALUE%3E%3C%2FLIST_ELEMENT%3E++++++++%3CLIST_ELEMENT%3E%3CCODE%3EUNN%3C%2FCODE%3E%3CLIST_VALUE%3EUMNR%3C%2FLIST_VALUE%3E%3CLIST_VALUE%3EN%3C%2FLIST_VALUE%3E%3CLIST_VALUE%3EUNN%3C%2FLIST_VALUE%3E%3C%2FLIST_ELEMENT%3E%09%3C%2FGLOBAL_LIST%3E%3C%2FSO_GL%3E&SO_SITE_ETKT_Q_OFFICE_ID=ATHA308OA&SO_SITE_OFFICE_ID=ATHA308OA&SO_SITE_POINT_OF_SALE=ATH&SO_SITE_POINT_OF_TICKETING=ATH&SO_SITE_PREBOOK_DURATION=I180&SO_SITE_QUEUE_OFFICE_ID=ATHA308OA&SO_SITE_SP_QUEUE_OFFICE_ID=ATHA308OA";
  url += "&LANGUAGE=GB";
  url +=
    "&WDS_ADD_BOOK_NOW_BUTTON_EMAF=TRUE&WDS_ADVERTISING_PANEL_CONF_ACTIVATED=true&WDS_AFFILIATE_STATUS=C&WDS_AMOP_DISPLAY_PRIORITY=PAYPAL:SOFORT:KLARNA:EPS:IDEAL:BANCONTACT:ENTERCASH:ALIPAY:CUP&WDS_AMOP_FEE=PAYPAL:0;KLARNA:0;SOFORT:0;ENTERCASH:0;EPS:0;IDEAL:0;BANCONTACT:0;ALIPAY:0;CUP:0;&WDS_AMOP_FEE_APPLY=PER_TRANSACTION&WDS_AMOP_FEE_CALCULATION=PER&WDS_AMOP_LIST_ACTIVATED=PAYPAL;KLARNA;SOFORT;ENTERCASH;EPS;IDEAL;BANCONTACT;ALIPAY;CUP&WDS_AMOP_LIST_DEACTIVATED=&WDS_AMOP_TIME_LIMIT=PAYPAL:48;KLARNA:0;SOFORT:0;ENTERCASH:0;EPS:0;IDEAL:0;BANCONTACT:0;ALIPAY:24;CUP:24;&WDS_ANCILLARY_IN_MILES_ENABLED=TRUE&WDS_ASSISTANCE_REQUEST_ACTIVATED=TRUE&WDS_ATCOM_TIMEOUT=2000&WDS_AVAIL_PRICE_DISPLAY_TYPE=PER_ADT_WITH_TAX_NO_FEE&WDS_BAG_PLACEHOLDER_URL=https://en.aegeanair.com/PromoSlots.axd&WDS_BAG_POLICY_PANEL_URL=https://en.aegeanair.com/PromoSlots.axd&WDS_BOOKING_LISTENER_URL=https://en.aegeanair.com/BookingListener.axd&WDS_BOUND_INDEX_EXPANDED=1&WDS_BUSINESS_MEAL_FARE_FAMILIES=BUSINESS:BUSINESTES:BUSINESSI&WDS_BUSINESS_MEAL_FREQUENT_FLYER_LEVELS=GOLD:SILVER&WDS_BUSINESS_MEAL_SUPPORTED=true&WDS_BUSINESS_ON_BOARD_DISPLAY_IN_LOGIN_PANEL=TRUE&WDS_BUSINESS_ON_BOARD_ENABLED=TRUE&WDS_BUSINESS_ON_BOARD_PAX_TYPE=ADT&WDS_CABIN_CLASS_DISPLAY=TRUE&WDS_CALENDAR_TO_UPSELL_FLEXIBLE_ACTIVATED=3&WDS_CALLCENTER_EMAIL=res1@aegeanair.com&WDS_CAR_ENABLED=FALSE&WDS_CAR_PANEL_URL=https://en.aegeanair.com/PromoSlots.axd&WDS_CC_FEE_CARD_TYPE=VI:0;CA:0;MA:0;AX:0;DC:0;TP:;&WDS_CC_FEE_NO_CARD=0&WDS_CC_FEE_ZERO_DISPLAYED=FALSE&WDS_CC_LIST=VI:CA:MA:AX:DC:TP&WDS_CFF_TOUSE=CFF01FEB14&WDS_CHANNEL=B2C&WDS_CLEAR_CONTENT_URL=https://en.aegeanair.com/PlainContent.axd&WDS_DEVICE_NAME=DESKTOP_UNKNOWN&WDS_DEVICE_OS=Windows_10&WDS_DEVICE_VIEWPORT=L&WDS_DISPLAY_EMAIL_IN_BROWSER_URL=https://en.aegeanair.com/ConfirmationEmail.axd&WDS_DISPLAY_FBA_AND_REFUNDABILITY_PER_BOUND_IN_SB=TRUE&WDS_DISPLAY_GREEK_RURAL_ID=FALSE&WDS_DISPLAY_RECEIPT=SHOW&WDS_DISPLAY_REGULATION_CONDITIONS_COUNTRY=FR&WDS_DISPLAY_REGULATION_CONDITIONS_LANG=FR&WDS_DONATION_PANEL_ACTIVATED=FALSE&WDS_DONATION_PANEL_URL=https://en.aegeanair.com/PromoSlots.axd&WDS_EMAF_BOOK_NOW_URL=https://en.aegeanair.com/PostHandler.axd&WDS_ENABLE_PARKING=FALSE&WDS_ENABLE_TOKEN=true&WDS_ENABLE_TOKEN_FOR_CAR=false&WDS_ENABLE_TOKEN_FOR_HOTEL=false&WDS_EPTS=unknown_call&WDS_EXTERNAL_CSS_URL=https://en.aegeanair.com/css/1A/responsive.css?v=10&WDS_EXTRAS_DEFAULT_PANEL_ORDER=BAGGAGE;MEALS;SPEQ;PETS;FASTTRACK;INSURANCE;PARKING;DONATION&WDS_FARE_COMPARISON_URL=https://en.aegeanair.com/FareFamilyComparison.axd&WDS_FARE_CONDITIONS_URL=https://en.aegeanair.com/ffc.axd&WDS_FASTTRACK_ELIGIBLE_AIRPORTS=LCA;ATH&WDS_FASTTRACK_ENABLED=TRUE&WDS_FASTTRACK_HANDLER_URL=https://en.aegeanair.com/FastTrackHandler.axd&WDS_FREQUENT_FLYER_PROGRAMS_OA_FLIGHTS=A3;AC;UA;MS;TK;NH;LH;SQ&WDS_GDPR_DISPLAY_PROMOS_CONFIRMATION_NO_CONSENT=FALSE&WDS_GDPR_HANDLER_URL=https://en.aegeanair.com/api/v1/members/checkgdpremailstatus&WDS_GO_TO_FINALIZE_URL=https://en.aegeanair.com/FinalizeRedirect.axd&WDS_GO_TO_MY_BOOKING_URL=https://en.aegeanair.com/MyBooking.axd&WDS_GO_TO_SEAT_SELECTION_URL=https://en.aegeanair.com/SeatRedirect.axd&WDS_HANDLE_SOS_AS_RM_FEE=TRUE&WDS_HOTEL_ENABLED=FALSE&WDS_HOTEL_PANEL_URL=https://en.aegeanair.com/PromoSlots.axd&WDS_HOTEL_POPUP_CONF_ACTIVATED=TRUE&WDS_HOTEL_POPUP_CONF_DELAY=10000&WDS_HOTEL_RECOMMENDATION_PANEL_URL=https://en.aegeanair.com/PromoSlots.axd&WDS_INSURANCE_ACTIVATED=TRUE&WDS_INSURANCE_PANEL_URL=https://en.aegeanair.com/PromoSlots.axd&WDS_INSURANCE_PRESELECT=NONE&WDS_LATE_LOGIN_ENABLED=TRUE&WDS_LATE_LOGIN_URL=https://en.aegeanair.com/api/v1/members/loyaltyauth&WDS_MEAL_FORBIDDEN_PAX_TYPE=INF&WDS_MEAL_HANDLER_URL=https://en.aegeanair.com/MealHandler.axd&WDS_MEAL_LIST_PROPOSED=BBML:BLML:CHML:DBML:FPML:GFML:KSML:LCML:LFML:NLML:LSML:MOML:HNML:SFML:VOML:VLML:AVML:VJML:VGML:RVML&WDS_MILES_EARNED_HANDLER_URL=https://en.aegeanair.com/AwardedMiles.axd&WDS_NEW_PROMOTION_TYPE=NONE&WDS_NEW_PROMOTION_WEBSERVICES_ENVIRONMENT=PRODUCTION&WDS_OBFEE_FROM_NEWPOLICY_ACTIVATED=TRUE&WDS_OLYMPIC_TRACKING=true&WDS_ONLY_DIRECT_REQUESTED=FALSE&WDS_PARKING_PANEL_URL=https://en.aegeanair.com/PromoSlots.axd&WDS_PETS_ENABLED=TRUE&WDS_PHONE_PRESELECT_COUNTRY_CODE=US&WDS_PLUSGRADE_ENABLED=false&WDS_PLUSGRADE_HANDLER_URL=https://en.aegeanair.com/PlusgradeHandler.axd&WDS_PROMO_SLOT_URL=https://en.aegeanair.com/PromoSlots.axd&WDS_PROMOCODE_ROUTE_AUTHORIZED=FALSE&WDS_PROMOTION_RBD_LIST=P&WDS_REBOOKING_HIGHSEASON_DATE=&WDS_RESKIN=TRUE&WDS_SB_HOTEL_TIMEOUT=15000&WDS_SEAT_BANNER_URL=https://en.aegeanair.com/SeatBanner.axd&WDS_SEATMAP_ENABLED=TRUE&WDS_SMS_OPTION=SHOW&WDS_SMS_PROVIDER_EMAIL=aegean_bc@mpassltd.eu&WDS_SMS_SENDER_EMAIL=defineOA@amadeus.com&WDS_SPECIAL_MEAL_LIST=BBML:BLML:CHML:DBML:FPML:GFML:KSML:LCML:LFML:NLML:LSML:MOML:HNML:SFML:VOML:VLML:AVML:VJML:VGML:RVML&WDS_SPECIAL_MEAL_SUPPORTED=TRUE&WDS_SPEQ_ENABLED=TRUE&WDS_TAX_BREAKDOWN_REGULATION_ALLOW_LANG=FR&WDS_TEALEAF_ENABLED=TRUE&WDS_TTT_ENABLED=TRUE&WDS_TTT_PROMO_FARES_REG_EXP=^PR([0-9])+$&WDS_TTT_SELECTION_PANEL_URL=https://en.aegeanair.com/PromoSlots.axd&WDS_UMNR_ENTRY_OVERRIDE=WDS_HOTEL_ENABLED:FALSE;WDS_CAR_ENABLED:FALSE;WDS_TTT_ENABLED:false;WDS_FASTTRACK_ENABLED:false;WDS_ANCILLARY_IN_MILES:false;WDS_ENABLE_PARKING:false;WDS_ASSISTANCE_REQUEST_ACTIVATED:false;WDS_LATE_LOGIN_ENABLED:false;WDS_BUSINESS_ON_BOARD_ENABLED:false&WDS_URL_FACADE_ERROR=https://www.olympicair.com/en/Travel/Reservations/Tickets&WDS_URL_FACADE_NEWSEARCH=https://www.olympicair.com/en/Travel/Reservations/Tickets&WDS_URL_WAITING_CONTENT=https://en.aegeanair.com/WaitingPage.axd&WDS_USE_A3_SOS_INSURANCE_PANEL=TRUE&WDS_USEFUL_LINKS_PANEL_URL=https://en.aegeanair.com/PromoSlots.axd&WDS_VOUCHER_BANNER_ACTIVATED=TRUE&WDS_VOUCHER_BANNER_URL=https://en.aegeanair.com/PromoSlots.axd";

  return {
    url,
    title: "Olympic Air",
  };
}

(0,___WEBPACK_IMPORTED_MODULE_0__.register)("airlines", printOA);


/***/ }),

/***/ "./src/matrix5/links/airlines/os.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _settings_userSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/settings/userSettings.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/matrix5/utils.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _print_amadeus__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/print/amadeus.js");





const osEditions = [
  { value: "AL-gb", name: "Albania / English" },
  { value: "DZ-fr", name: "Algeria / Français" },
  { value: "AO-gb", name: "Angola / English" },
  { value: "AR-es", name: "Argentina / Español" },
  { value: "AM-gb", name: "Armenia / English" },
  { value: "AU-gb", name: "Australia / English" },
  { value: "AT-de", name: "Austria / Deutsch" },
  { value: "AT-gb", name: "Austria / English" },
  { value: "AZ-gb", name: "Azerbaijan / English" },
  { value: "BH-gb", name: "Bahrain / English" },
  { value: "BY-gb", name: "Belarus / English" },
  { value: "BE-gb", name: "Belgium / English" },
  { value: "BA-gb", name: "Bosnia/Hercegovina / English" },
  { value: "BR-pt", name: "Brazil / Português" },
  { value: "BG-gb", name: "Bulgaria / English" },
  { value: "CA-gb", name: "Canada / English" },
  { value: "CA-fr", name: "Canada / Français" },
  { value: "CL-es", name: "Chile / Español" },
  { value: "CN-gb", name: "China / English" },
  { value: "CO-es", name: "Colombia / Español" },
  { value: "HR-gb", name: "Croatia / English" },
  { value: "CY-gb", name: "Cyprus / English" },
  { value: "CZ-gb", name: "Czech Republic / English" },
  { value: "DK-gb", name: "Denmark / English" },
  { value: "EG-gb", name: "Egypt / English" },
  { value: "GQ-gb", name: "Equatorial Guinea / English" },
  { value: "ER-gb", name: "Eritrea / English" },
  { value: "EE-gb", name: "Estonia / English" },
  { value: "ET-gb", name: "Ethiopia / English" },
  { value: "FI-gb", name: "Finland / English" },
  { value: "FR-gb", name: "France / English" },
  { value: "FR-fr", name: "France / Français" },
  { value: "GA-gb", name: "Gabon / English" },
  { value: "GE-gb", name: "Georgia / English" },
  { value: "DE-de", name: "Germany / Deutsch" },
  { value: "DE-gb", name: "Germany / English" },
  { value: "GH-gb", name: "Ghana / English" },
  { value: "GR-gb", name: "Greece / English" },
  { value: "HK-gb", name: "Hong Kong / English" },
  { value: "HU-gb", name: "Hungary / English" },
  { value: "IS-gb", name: "Iceland / English" },
  { value: "IN-gb", name: "India / English" },
  { value: "ID-gb", name: "Indonesia / English" },
  { value: "IR-gb", name: "Iran / English" },
  { value: "IQ-gb", name: "Iraq / English" },
  { value: "IE-gb", name: "Ireland / English" },
  { value: "IL-gb", name: "Israel / English" },
  { value: "IT-it", name: "Italy / Italiano" },
  { value: "IT-gb", name: "Italy / English" },
  { value: "JP-gb", name: "Japan / English" },
  { value: "JO-gb", name: "Jordan / English" },
  { value: "KZ-gb", name: "Kazakhstan / English" },
  { value: "KE-gb", name: "Kenya / English" },
  { value: "KR-gb", name: "Republic of Korea / English" },
  { value: "KW-gb", name: "Kuwait / English" },
  { value: "LV-gb", name: "Latvia / English" },
  { value: "LB-gb", name: "Lebanon / English" },
  { value: "LY-gb", name: "Libya / English" },
  { value: "LT-gb", name: "Lithuania / English" },
  { value: "LU-gb", name: "Luxembourg / English" },
  { value: "MY-gb", name: "Malaysia / English" },
  { value: "MV-gb", name: "Maldives / English" },
  { value: "MT-gb", name: "Malta / English" },
  { value: "MU-gb", name: "Mauritius / English" },
  { value: "MX-es", name: "Mexico / Español" },
  { value: "MD-gb", name: "Moldova / English" },
  { value: "MA-fr", name: "Morocco / Français" },
  { value: "NL-gb", name: "Netherlands / English" },
  { value: "NZ-gb", name: "New Zealand / English" },
  { value: "NG-gb", name: "Nigeria / English" },
  { value: "NO-gb", name: "Norway / English" },
  { value: "OM-gb", name: "Oman / English" },
  { value: "PK-gb", name: "Pakistan / English" },
  { value: "PA-es", name: "Panama / Español" },
  { value: "PH-gb", name: "Philippines / English" },
  { value: "PL-gb", name: "Poland / English" },
  { value: "PL-pl", name: "Poland / Polski" },
  { value: "PT-gb", name: "Portugal / English" },
  { value: "PT-pt", name: "Portugal / Português" },
  { value: "QA-gb", name: "Qatar / English" },
  { value: "CD-gb", name: "Republic of the Congo / English" },
  { value: "RO-gb", name: "Romania / English" },
  { value: "RU-gb", name: "Russia / English" },
  { value: "RU-ru", name: "Russia / Русский" },
  { value: "SA-gb", name: "Saudi Arabia / English" },
  { value: "RS-gb", name: "Serbia / English" },
  { value: "SG-gb", name: "Singapore / English" },
  { value: "SK-gb", name: "Slovakia / English" },
  { value: "SI-gb", name: "Slovenia / English" },
  { value: "ZA-gb", name: "South Africa / English" },
  { value: "ES-gb", name: "Spain / English" },
  { value: "ES-es", name: "Spain / Español" },
  { value: "SD-gb", name: "Sudan / English" },
  { value: "SE-gb", name: "Sweden / English" },
  { value: "CH-de", name: "Switzerland / Deutsch" },
  { value: "CH-gb", name: "Switzerland / English" },
  { value: "CH-fr", name: "Switzerland / Français" },
  { value: "TW-gb", name: "Taiwan / English " },
  { value: "TH-gb", name: "Thailand / English" },
  { value: "TN-fr", name: "Tunisia / Français" },
  { value: "TR-gb", name: "Turkey / English" },
  { value: "TM-gb", name: "Turkmenistan / English" },
  { value: "UA-gb", name: "Ukraine / English" },
  { value: "AE-gb", name: "United Arab Emirates / English" },
  { value: "UK-gb", name: "United Kingdom / English" },
  { value: "US-gb", name: "United States / English" },
  { value: "VE-es", name: "Venezuela / Español" },
  { value: "VN-gb", name: "Vietnam / English" },
  { value: "XX-gb", name: "Other countries / English" },
];

function print() {
  if (!(0,___WEBPACK_IMPORTED_MODULE_1__.anyCarriers)("LH", "LX", "OS", "SN")) {
    return;
  }

  var createUrl = function (edition) {
    var paxConfig = { allowinf: 1, youthage: 0 };
    var pax = (0,___WEBPACK_IMPORTED_MODULE_1__.validatePax)({
      maxPaxcount: 9,
      countInf: false,
      childAsAdult: 12,
      sepInfSeat: false,
      childMinAge: 2,
    });
    if (!pax) {
      (0,_utils__WEBPACK_IMPORTED_MODULE_3__.printNotification)("Error: Failed to validate Passengers in print");
      return false;
    }
    var amadeusConfig = {
      sepcabin: 0,
      detailed: 0,
      allowpremium: 1,
      inctimes: 0,
    };
    var url =
      "https://bookflights.austrian.com/lh/dyn/air-lh/revenue/availThenFare?";
    url += "WDS_MSE_PRICE_CURRENCY=EUR&WDS_MSE_TOTAL_PRICE=1.00&";
    url +=
      "PORTAL=OS&COUNTRY_SITE=" +
      edition[0].toUpperCase() +
      "&POS=" +
      edition[0].toUpperCase() +
      "&LANGUAGE=" +
      edition[1].toUpperCase() +
      "&SECURE=TRUE&SITE=LUFTAUST";
    var tmpPax = (0,_print_amadeus__WEBPACK_IMPORTED_MODULE_2__.getAmadeusPax)(pax, paxConfig);
    url += tmpPax.url;
    url += "&NB_ADT=" + tmpPax.adults;
    url += "&NB_INF=" + tmpPax.infants;
    url += "&NB_CHD=" + tmpPax.children;
    url += "&TRIP_TYPE=" + (0,_print_amadeus__WEBPACK_IMPORTED_MODULE_2__.getAmadeusTriptype)();
    url += (0,_print_amadeus__WEBPACK_IMPORTED_MODULE_2__.getAmadeusUrl)(amadeusConfig);

    return url;
  };
  // get edition
  var edition = _settings_userSettings__WEBPACK_IMPORTED_MODULE_0__["default"].osEdition2.split("-");
  if (edition.length != 2) {
    (0,_utils__WEBPACK_IMPORTED_MODULE_3__.printNotification)("Error:Invalid Austrian-Edition");
    return;
  }
  var url = createUrl(edition);
  if (!url) {
    return;
  }
  var extra =
    ' <span class="pt-hover-container">[+]<span class="pt-hover-menu">';
  extra += osEditions
    .map(function (obj, i) {
      return (
        '<a href="' +
        createUrl(obj.value.split("-")) +
        '" target="_blank">' +
        obj.name +
        "</a>"
      );
    })
    .join("<br/>");
  extra += "</span></span>";

  return {
    url,
    title: "Austrian",
    extra,
  };
}

(0,___WEBPACK_IMPORTED_MODULE_1__.register)("airlines", print);
(0,_settings_userSettings__WEBPACK_IMPORTED_MODULE_0__.registerSetting)("Austrian", "osEdition2", osEditions, "US-gb");


/***/ }),

/***/ "./src/matrix5/links/airlines/ps.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _otas_travix__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/links/otas/travix.js");



function printPS() {
  if (!(0,___WEBPACK_IMPORTED_MODULE_0__.anyCarriers)("PS")) {
    return;
  }

  // 0 = Economy; 1=Premium Economy; 2=Business; 3=First
  var cabins = ["Economy", "Economy", "Business", "First"];
  var createUrl = (edition, currency) =>
    `http://www.iberia.com/web/partnerLink.do?${(0,_otas_travix__WEBPACK_IMPORTED_MODULE_1__.buildQueryString)(
      currency,
      edition[1],
      edition[0],
      cabins,
    )}`;

  var url = createUrl(["EN", "US"], "USD");
  if (!url) {
    return;
  }

  return {
    url,
    title: "UIA",
  };
}

(0,___WEBPACK_IMPORTED_MODULE_0__.register)("airlines", printPS);


/***/ }),

/***/ "./src/matrix5/links/airlines/qf.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _settings_appSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/settings/appSettings.ts");
/* harmony import */ var _settings_userSettings__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/settings/userSettings.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./src/matrix5/utils.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/matrix5/parse/itin.ts");






const qfEditions = [
  { value: "EN_AU", name: "Australia" },
  { value: "EN_NZ", name: "New Zealand" },
  { value: "EN_US", name: "United States" },
];

const qfCurrencies = [
  { value: "AUD", name: "AUD" },
  { value: "NZD", name: "NZD" },
  { value: "USD", name: "USD" },
];

function printQF() {
  if (!(0,___WEBPACK_IMPORTED_MODULE_2__.anyCarriers)("QF", "JQ", "NZ")) {
    return;
  }

  /* Qantas partner deep-link */
  var createUrl = function (edition, currency) {
    // 0 = Economy; 1=Premium Economy; 2=Business; 3=First
    var travelClass = ["ECO", "PRM", "BUS", "FIR"];
    // Start the minimum cabin at highest possible (it will drop as we check each leg):
    var mincabin = 3;
    // Validate the passenger totals first:
    var pax = (0,___WEBPACK_IMPORTED_MODULE_2__.validatePax)({
      maxPaxcount: 9,
      countInf: false,
      childAsAdult: 16,
      sepInfSeat: false,
      childMinAge: 2,
    });
    if (!pax) {
      (0,_utils__WEBPACK_IMPORTED_MODULE_4__.printNotification)("Error: Failed to validate Passengers in printQF");
      return false;
    }
    var nbrChildren = pax.children.length;
    if (!nbrChildren || typeof nbrChildren === "undefined") {
      // default to 0 children if undefined:
      nbrChildren = 0;
    }

    // Build search based on legs:
    console.log("printQF: begin leg traversal...");
    var url = "";
    var prefixFltNbr = "sdcFlightNumber";
    var prefixSegRbd = "sdcSegmentRbd";
    var depAirports = "&depAirports=";
    var destAirports = "&destAirports=";
    var segDepAirports = "&depAirports=";
    var segDestAirports = "&destAirports=";
    var tmpTravelDates = "";
    var finalDest = _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[0].seg[0].dest;

    for (var i = 0; i < _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin.length; i++) {
      // walks each parent "leg" of the itinerary (a leg can have multiple flight segments)

      // Record the travel date for each leg:
      if (tmpTravelDates === "" || !tmpTravelDates) {
        tmpTravelDates +=
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].dep.year.toString() +
          ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].dep.month).slice(-2).toString() +
          ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].dep.day).slice(-2).toString() +
          "0000";
      } else {
        tmpTravelDates +=
          "%2C" +
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].dep.year.toString() +
          ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].dep.month).slice(-2).toString() +
          ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].dep.day).slice(-2).toString() +
          "0000";
      }

      // Grab the origin airport of each leg:
      if (segDepAirports.length > 13) segDepAirports += "%2C";
      segDepAirports += _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].orig.toString();
      // Grab the destination airport of each leg:
      if (segDestAirports.length > 14) segDestAirports += "%2C";
      segDestAirports += _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].dest.toString();

      for (var j = 0; j < _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].seg.length; j++) {
        // walks each flight segment of the parent leg
        var k = 0;
        // Do we need to skip segments? fnr has to be the same and it must be just a layover:
        while (j + k < _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].seg.length - 1) {
          if (
            _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].seg[j + k].fnr !=
              _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].seg[j + k + 1].fnr ||
            _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].seg[j + k].layoverduration >= 1440
          ) {
            break;
          }
          k++;
        }
        // Construct URL for this leg:
        url +=
          "&" +
          prefixFltNbr +
          (i + 1) +
          (j + 1) +
          "=" +
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].seg[j].carrier +
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].seg[j].fnr;
        url +=
          "&" +
          prefixSegRbd +
          (i + 1) +
          (j + 1) +
          "=" +
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].seg[j].bookingclass;

        // record the departing and destination airports for this leg:
        // all departing airports:
        if (depAirports.length > 13) depAirports += "%2C";
        depAirports += _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].seg[j].orig.toString();
        // all destination airports:
        if (destAirports.length > 14) destAirports += "%2C";
        destAirports += _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].seg[j].dest.toString();

        if (_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].seg[j].cabin < mincabin) {
          mincabin = _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_3__.currentItin.itin[i].seg[j].cabin;
        }
        j += k;
      }
    }

    // Add airports:
    // url += depAirports + destAirports;
    url += segDepAirports + segDestAirports;
    // Add travel dates:
    url += "&travelDates=" + tmpTravelDates;
    // Add price info:
    url += "&sdcTripPriceAmount=0.00";
    // Add device type:
    url += "&QFdeviceType=desktop";

    // Begin final deeplink URL construction:
    var urlBase =
      "https://book.qantas.com/qf-booking/dyn/air/tripflow.redirect?APPLICATION_NAME=SDC";
    // Add edition / locale:
    urlBase += "&USER_LANG=EN&USER_LOCALE=" + edition;
    // Add class(es) of service:
    urlBase +=
      "&travelClass=" +
      travelClass[_settings_appSettings__WEBPACK_IMPORTED_MODULE_0__["default"].cabin === "Auto" ? mincabin : (0,_settings_appSettings__WEBPACK_IMPORTED_MODULE_0__.getForcedCabin)()];
    // Add passenger info:
    urlBase +=
      "&numberOfAdults=" +
      pax.adults +
      "&numberOfChildren=" +
      nbrChildren.toString() +
      "&numberOfInfants=" +
      pax.infLap;
    // Add currency:
    urlBase += "&sdcPriceCurrency=" + currency;

    return urlBase + url;
  };
  // get edition
  var url = createUrl(_settings_userSettings__WEBPACK_IMPORTED_MODULE_1__["default"].qfEdition, _settings_userSettings__WEBPACK_IMPORTED_MODULE_1__["default"].qfCurrency);
  if (!url) {
    return;
  }

  var extra =
    ' <span class="pt-hover-container">[+]<span class="pt-hover-menu">';
  extra += qfEditions
    .map(function (obj, i) {
      return (
        '<a href="' +
        createUrl(obj.value, _settings_userSettings__WEBPACK_IMPORTED_MODULE_1__["default"].qfCurrency) +
        '" target="_blank">' +
        obj.name +
        "</a>"
      );
    })
    .join("<br/>");
  extra += "</span></span>";

  return {
    url,
    title: "Qantas",
    extra,
  };
}

(0,___WEBPACK_IMPORTED_MODULE_2__.register)("airlines", printQF);
(0,_settings_userSettings__WEBPACK_IMPORTED_MODULE_1__.registerSetting)("Qantas", "qfEdition", qfEditions, "EN_US");
(0,_settings_userSettings__WEBPACK_IMPORTED_MODULE_1__.registerSetting)("Qantas", "qfCurrency", qfCurrencies, "USD");


/***/ }),

/***/ "./src/matrix5/links/airlines/qr.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/matrix5/utils.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/parse/itin.ts");
/* harmony import */ var _settings_appSettings__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/settings/appSettings.ts");





var cabins = ["E", "E", "B", "F"];

function print() {
  if (!(0,___WEBPACK_IMPORTED_MODULE_0__.allCarriers)("QR")) {
    return;
  }

  const pax = (0,___WEBPACK_IMPORTED_MODULE_0__.validatePax)({
    maxPaxcount: 9,
    countInf: false,
    childAsAdult: 12,
    sepInfSeat: false,
    childMinAge: 2,
  });
  if (!pax) {
    (0,_utils__WEBPACK_IMPORTED_MODULE_3__.printNotification)("Error: Failed to validate Passengers in printQR");
    return;
  }

  const cabin =
    cabins[(0,_settings_appSettings__WEBPACK_IMPORTED_MODULE_2__.getCabin)(Math.min(...(0,_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.getCurrentSegs)().map((seg) => seg.cabin)))];

  const tripType = _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin.length > 1 ? "M" : "O";

  let url = `https://booking.qatarairways.com/nsp/views/showBooking.action?widget=MLC&selLang=${_settings_appSettings__WEBPACK_IMPORTED_MODULE_2__["default"].itaLanguage}&tripType=${tripType}&bookingClass=${cabin}&adults=${pax.adults}&children=${pax.children.length}&infants=${pax.infLap}&isMetaSearch=true&`;
  url += _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin
    .map((itin, i) => {
      let qs = `fromStation=${itin.orig}&toStation=${itin.dest}&departing=${
        itin.dep.year
      }-${(0,_utils__WEBPACK_IMPORTED_MODULE_3__.to2digits)(itin.dep.month)}-${(0,_utils__WEBPACK_IMPORTED_MODULE_3__.to2digits)(itin.dep.day)}`;
      if (i <= 1)
        qs += `&${i === 0 ? "out" : "in"}boundFltNumber=${itin.seg
          .map((seg) => seg.fnr)
          .join(",")}`;
      return qs;
    })
    .join("&");
  if (_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin.length <= 2) url += "&price=0";
  return {
    url,
    title: "Qatar Airways",
  };
}

(0,___WEBPACK_IMPORTED_MODULE_0__.register)("airlines", print);


/***/ }),

/***/ "./src/matrix5/links/airlines/sn.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _settings_userSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/settings/userSettings.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/matrix5/utils.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _print_amadeus__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/print/amadeus.js");





const snEditions = [
  { value: "AL-gb", name: "Albania / English" },
  { value: "DZ-fr", name: "Algeria / Français" },
  { value: "AO-gb", name: "Angola / English" },
  { value: "AR-es", name: "Argentina / Español" },
  { value: "AM-gb", name: "Armenia / English" },
  { value: "AU-gb", name: "Australia / English" },
  { value: "AT-de", name: "Austria / Deutsch" },
  { value: "AT-gb", name: "Austria / English" },
  { value: "AZ-gb", name: "Azerbaijan / English" },
  { value: "BH-gb", name: "Bahrain / English" },
  { value: "BY-gb", name: "Belarus / English" },
  { value: "BE-gb", name: "Belgium / English" },
  { value: "BA-gb", name: "Bosnia/Hercegovina / English" },
  { value: "BR-pt", name: "Brazil / Português" },
  { value: "BG-gb", name: "Bulgaria / English" },
  { value: "CA-gb", name: "Canada / English" },
  { value: "CA-fr", name: "Canada / Français" },
  { value: "CL-es", name: "Chile / Español" },
  { value: "CN-gb", name: "China / English" },
  { value: "CO-es", name: "Colombia / Español" },
  { value: "HR-gb", name: "Croatia / English" },
  { value: "CY-gb", name: "Cyprus / English" },
  { value: "CZ-gb", name: "Czech Republic / English" },
  { value: "DK-gb", name: "Denmark / English" },
  { value: "EG-gb", name: "Egypt / English" },
  { value: "GQ-gb", name: "Equatorial Guinea / English" },
  { value: "ER-gb", name: "Eritrea / English" },
  { value: "EE-gb", name: "Estonia / English" },
  { value: "ET-gb", name: "Ethiopia / English" },
  { value: "FI-gb", name: "Finland / English" },
  { value: "FR-gb", name: "France / English" },
  { value: "FR-fr", name: "France / Français" },
  { value: "GA-gb", name: "Gabon / English" },
  { value: "GE-gb", name: "Georgia / English" },
  { value: "DE-de", name: "Germany / Deutsch" },
  { value: "DE-gb", name: "Germany / English" },
  { value: "GH-gb", name: "Ghana / English" },
  { value: "GR-gb", name: "Greece / English" },
  { value: "HK-gb", name: "Hong Kong / English" },
  { value: "HU-gb", name: "Hungary / English" },
  { value: "IS-gb", name: "Iceland / English" },
  { value: "IN-gb", name: "India / English" },
  { value: "ID-gb", name: "Indonesia / English" },
  { value: "IR-gb", name: "Iran / English" },
  { value: "IQ-gb", name: "Iraq / English" },
  { value: "IE-gb", name: "Ireland / English" },
  { value: "IL-gb", name: "Israel / English" },
  { value: "IT-it", name: "Italy / Italiano" },
  { value: "IT-gb", name: "Italy / English" },
  { value: "JP-gb", name: "Japan / English" },
  { value: "JO-gb", name: "Jordan / English" },
  { value: "KZ-gb", name: "Kazakhstan / English" },
  { value: "KE-gb", name: "Kenya / English" },
  { value: "KR-gb", name: "Republic of Korea / English" },
  { value: "KW-gb", name: "Kuwait / English" },
  { value: "LV-gb", name: "Latvia / English" },
  { value: "LB-gb", name: "Lebanon / English" },
  { value: "LY-gb", name: "Libya / English" },
  { value: "LT-gb", name: "Lithuania / English" },
  { value: "LU-gb", name: "Luxembourg / English" },
  { value: "MY-gb", name: "Malaysia / English" },
  { value: "MV-gb", name: "Maldives / English" },
  { value: "MT-gb", name: "Malta / English" },
  { value: "MU-gb", name: "Mauritius / English" },
  { value: "MX-es", name: "Mexico / Español" },
  { value: "MD-gb", name: "Moldova / English" },
  { value: "MA-fr", name: "Morocco / Français" },
  { value: "NL-gb", name: "Netherlands / English" },
  { value: "NZ-gb", name: "New Zealand / English" },
  { value: "NG-gb", name: "Nigeria / English" },
  { value: "NO-gb", name: "Norway / English" },
  { value: "OM-gb", name: "Oman / English" },
  { value: "PK-gb", name: "Pakistan / English" },
  { value: "PA-es", name: "Panama / Español" },
  { value: "PH-gb", name: "Philippines / English" },
  { value: "PL-gb", name: "Poland / English" },
  { value: "PL-pl", name: "Poland / Polski" },
  { value: "PT-gb", name: "Portugal / English" },
  { value: "PT-pt", name: "Portugal / Português" },
  { value: "QA-gb", name: "Qatar / English" },
  { value: "CD-gb", name: "Republic of the Congo / English" },
  { value: "RO-gb", name: "Romania / English" },
  { value: "RU-gb", name: "Russia / English" },
  { value: "RU-ru", name: "Russia / Русский" },
  { value: "SA-gb", name: "Saudi Arabia / English" },
  { value: "RS-gb", name: "Serbia / English" },
  { value: "SG-gb", name: "Singapore / English" },
  { value: "SK-gb", name: "Slovakia / English" },
  { value: "SI-gb", name: "Slovenia / English" },
  { value: "ZA-gb", name: "South Africa / English" },
  { value: "ES-gb", name: "Spain / English" },
  { value: "ES-es", name: "Spain / Español" },
  { value: "SD-gb", name: "Sudan / English" },
  { value: "SE-gb", name: "Sweden / English" },
  { value: "CH-de", name: "Switzerland / Deutsch" },
  { value: "CH-gb", name: "Switzerland / English" },
  { value: "CH-fr", name: "Switzerland / Français" },
  { value: "TW-gb", name: "Taiwan / English " },
  { value: "TH-gb", name: "Thailand / English" },
  { value: "TN-fr", name: "Tunisia / Français" },
  { value: "TR-gb", name: "Turkey / English" },
  { value: "TM-gb", name: "Turkmenistan / English" },
  { value: "UA-gb", name: "Ukraine / English" },
  { value: "AE-gb", name: "United Arab Emirates / English" },
  { value: "UK-gb", name: "United Kingdom / English" },
  { value: "US-gb", name: "United States / English" },
  { value: "VE-es", name: "Venezuela / Español" },
  { value: "VN-gb", name: "Vietnam / English" },
  { value: "XX-gb", name: "Other countries / English" },
];

function print() {
  if (!(0,___WEBPACK_IMPORTED_MODULE_1__.anyCarriers)("LH", "LX", "OS", "SN")) {
    return;
  }

  var createUrl = function (edition) {
    var paxConfig = { allowinf: 1, youthage: 0 };
    var pax = (0,___WEBPACK_IMPORTED_MODULE_1__.validatePax)({
      maxPaxcount: 9,
      countInf: false,
      childAsAdult: 12,
      sepInfSeat: false,
      childMinAge: 2,
    });
    if (!pax) {
      (0,_utils__WEBPACK_IMPORTED_MODULE_3__.printNotification)("Error: Failed to validate Passengers in print");
      return false;
    }
    var amadeusConfig = {
      sepcabin: 0,
      detailed: 0,
      allowpremium: 1,
      inctimes: 0,
    };
    var url =
      "https://book.brusselsairlines.com/lh/dyn/air-lh/revenue/availThenFare?";
    url += "WDS_MSE_PRICE_CURRENCY=EUR&WDS_MSE_TOTAL_PRICE=1.00&";
    url +=
      "PORTAL=SN&COUNTRY_SITE=" +
      edition[0].toUpperCase() +
      "&POS=" +
      edition[0].toUpperCase() +
      "&LANGUAGE=" +
      edition[1].toUpperCase() +
      "&SECURE=TRUE&SITE=LUFTBRUS";
    var tmpPax = (0,_print_amadeus__WEBPACK_IMPORTED_MODULE_2__.getAmadeusPax)(pax, paxConfig);
    url += tmpPax.url;
    url += "&NB_ADT=" + tmpPax.adults;
    url += "&NB_INF=" + tmpPax.infants;
    url += "&NB_CHD=" + tmpPax.children;
    url += "&TRIP_TYPE=" + (0,_print_amadeus__WEBPACK_IMPORTED_MODULE_2__.getAmadeusTriptype)();
    url += (0,_print_amadeus__WEBPACK_IMPORTED_MODULE_2__.getAmadeusUrl)(amadeusConfig);

    return url;
  };
  // get edition
  var edition = _settings_userSettings__WEBPACK_IMPORTED_MODULE_0__["default"].snEdition.split("-");
  if (edition.length != 2) {
    (0,_utils__WEBPACK_IMPORTED_MODULE_3__.printNotification)("Error:Invalid Brussels-Edition");
    return;
  }
  var url = createUrl(edition);
  if (!url) {
    return;
  }
  var extra =
    ' <span class="pt-hover-container">[+]<span class="pt-hover-menu">';
  extra += snEditions
    .map(function (obj, i) {
      return (
        '<a href="' +
        createUrl(obj.value.split("-")) +
        '" target="_blank">' +
        obj.name +
        "</a>"
      );
    })
    .join("<br/>");
  extra += "</span></span>";

  return {
    url,
    title: "Brussels Airlines",
    extra,
  };
}

(0,___WEBPACK_IMPORTED_MODULE_1__.register)("airlines", print);
(0,_settings_userSettings__WEBPACK_IMPORTED_MODULE_0__.registerSetting)("Brussels Airlines", "snEdition", snEditions, "US-gb");


/***/ }),

/***/ "./src/matrix5/links/airlines/tk.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/utils.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/parse/itin.ts");




const cabins = ["ECONOMY", "ECONOMY", "BUSINESS", "FIRST"];
function printTK() {
  if (!(0,___WEBPACK_IMPORTED_MODULE_0__.anyCarriers)("TK")) {
    return;
  }

  const pax = (0,___WEBPACK_IMPORTED_MODULE_0__.validatePax)({
    maxPaxcount: 9,
    countInf: false,
    childAsAdult: 12,
    sepInfSeat: false,
    childMinAge: 2,
  });
  if (!pax) {
    (0,_utils__WEBPACK_IMPORTED_MODULE_2__.printNotification)("Error: Failed to validate Passengers in printTK");
    return;
  }

  let url = `https://www.turkishairlines.com/en-us/flights/booking/availability-multicity?D=1`;
  url += `&dom=0`;
  url += `&prc=${_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.price}`;
  url += `&cur=${_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.cur || "USD"}`;
  url += `&lp=PROM`;
  url += `&pax=A:${pax.adults},C:${pax.children.length},I:${pax.infLap}`;
  url += `&cc=${cabins[Math.max(...(0,_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.getCurrentSegs)().map((seg) => seg.cabin))]}`;
  _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin.forEach((itin, i) => {
    url += `&so${i}=${itin.seg.length}`;
    url += `&b${i + 1}=org:${itin.orig}/dst:${itin.dest}/fb:${itin.seg
      .map((seg) => seg.farebase)
      .join(",")}/orgd:${formatDate(itin.dep)}/fn:${itin.seg
      .map((seg) => seg.carrier + seg.fnr)
      .join(",")}`;
  });

  return {
    url,
    title: "Turkish",
  };
}

function formatDate(time) {
  return `${(0,_utils__WEBPACK_IMPORTED_MODULE_2__.to2digits)(time.day)}${(0,_utils__WEBPACK_IMPORTED_MODULE_2__.to2digits)(time.month)}${time.year
    .toString()
    .slice(-2)}`;
}

(0,___WEBPACK_IMPORTED_MODULE_0__.register)("airlines", printTK);


/***/ }),

/***/ "./src/matrix5/links/airlines/vs.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/utils.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/parse/itin.ts");




function printVS() {
  if (!(0,___WEBPACK_IMPORTED_MODULE_0__.anyCarriers)("AF", "DL", "KL", "VS")) {
    return;
  }

  var createUrl = function () {
    var pax = (0,___WEBPACK_IMPORTED_MODULE_0__.validatePax)({
      maxPaxcount: 9,
      countInf: true,
      childAsAdult: 12,
      sepInfSeat: false,
      childMinAge: 2,
    });
    if (!pax) {
      (0,_utils__WEBPACK_IMPORTED_MODULE_2__.printNotification)("Error: Failed to validate Passengers in printVS");
      return;
    }
    let url =
      "https://www.virginatlantic.com/air-shopping/priceTripAction.action?";
    url += `paxCounts[0]=${pax.adults}`;
    url += `&paxCounts[1]=${pax.children.length}`;
    url += `&paxCounts[2]=${pax.infSeat}`;
    url += `&paxCounts[3]=${pax.infLap}`;
    url += `&exitCountry=US`;
    url += `&currencyCd=${_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.cur || "USD"}`;

    const fares = [];

    let segnum = 0;
    _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin.forEach((itin, legnum) => {
      itin.seg.forEach((seg) => {
        const hour = seg.dep.time24.split(":")[0];
        const time =
          (0,_utils__WEBPACK_IMPORTED_MODULE_2__.to2digits)(+hour - (+hour < 12 ? 0 : 12)) + (+hour < 12 ? "A" : "P");
        const values = [
          legnum,
          seg.bookingclass,
          seg.orig,
          seg.dest,
          seg.carrier,
          (0,_utils__WEBPACK_IMPORTED_MODULE_2__.to4digits)(seg.fnr),
          (0,_utils__WEBPACK_IMPORTED_MODULE_2__.monthnumberToName)(seg.dep.month),
          (0,_utils__WEBPACK_IMPORTED_MODULE_2__.to2digits)(seg.dep.day),
          seg.dep.year,
          time,
        ];
        url += `&itinSegment[${segnum}]=${values.join(":")}`;

        fares.push(seg.farebase);
        segnum++;
      });
    });

    url += `&fareBasis=${fares.join(":")}`;
    url += `&numOfSegments=${segnum}`;

    return url;
  };

  var url = createUrl();
  if (!url) {
    return;
  }

  return {
    url,
    title: "Virgin Atlantic",
  };
}

(0,___WEBPACK_IMPORTED_MODULE_0__.register)("airlines", printVS);


/***/ }),

/***/ "./src/matrix5/links/meta/jetcost.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/parse/itin.ts");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/matrix5/utils.js");
/* harmony import */ var _settings_appSettings__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/settings/appSettings.ts");





const editions = [
  { name: "Argentina", host: "https://ar.jetcost.com/vuelos/busqueda" },
  { name: "Australia", host: "https://www.jetcost.com.au/flights/search" },
  { name: "Bolivia", host: "https://www.jetcost.com.bo/vuelos/busqueda" },
  { name: "Brasil", host: "https://www.jetcost.com.br/voos/pesquisa" },
  { name: "Canada (en)", host: "https://ca.jetcost.com/en/flights/search" },
  { name: "Canada (fr)", host: "https://ca.jetcost.com/fr/vols/recherche" },
  { name: "Chile", host: "https://www.jetcost.cl/vuelos/busqueda" },
  { name: "Colombia", host: "https://www.jetcost.com.co/vuelos/busqueda" },
  { name: "Danmark", host: "https://www.jetcost.dk/flyrejser/sogning" },
  { name: "Deutschland", host: "https://www.jetcost.de/fluge/suche" },
  { name: "España", host: "https://www.jetcost.es/vuelos/busqueda" },
  {
    name: "Estados Unidos (es)",
    host: "https://us.jetcost.com/es/vuelos/busqueda",
  },
  { name: "France", host: "https://www.jetcost.com/vols/recherche" },
  { name: "Hong Kong", host: "https://www.jetcost.hk/en/flights/search" },
  { name: "India", host: "https://www.jetcost.co.in/en/flights/search" },
  { name: "Indonesia", host: "https://www.jetcost.co.id/en/flights/search" },
  { name: "Ireland", host: "https://www.jetcost.ie/flights/search" },
  { name: "Italia", host: "https://www.jetcost.it/voli/ricerca" },
  { name: "Magyarország", host: "https://www.jetcost.hu/jaratok/kereses" },
  { name: "Malaysia", host: "https://www.jetcost.com.my/en/flights/search" },
  { name: "México", host: "https://www.jetcost.com.mx/vuelos/busqueda" },
  { name: "Nederland", host: "https://www.jetcost.nl/vluchten/zoeken" },
  { name: "New Zealand", host: "https://www.jetcost.co.nz/flights/search" },
  { name: "Norge", host: "https://www.jetcost.no/flyvninger/sok" },
  { name: "Österreich", host: "https://www.jetcost.at/fluge/suche" },
  { name: "Perú", host: "https://www.jetcost.com.pe/vuelos/busqueda" },
  { name: "Philippines", host: "https://www.jetcost.com.ph/en/flights/search" },
  { name: "Polska", host: "https://www.jetcost.pl/loty/wyszukiwanie" },
  { name: "Portugal", host: "https://www.jetcost.pt/voos/pesquisar" },
  { name: "România", host: "https://www.jetcost.ro/zboruri/cautare" },
  { name: "Россия", host: "https://www.jetcost.ru/reysy/poisk" },
  { name: "Singapore", host: "https://www.jetcost.com.sg/en/flights/search" },
  { name: "South Africa", host: "https://www.jetcost.co.za/en/flights/search" },
  { name: "Suomi", host: "https://www.jetcost.fi/lennot/hae" },
  { name: "Sverige", host: "https://www.jetcost.se/flighter/sokning" },
  { name: "Thailand", host: "https://www.jetcost.co.th/en/flights/search" },
  { name: "United Kingdom", host: "https://www.jetcost.co.uk/flights/search" },
  {
    name: "United States (en)",
    host: "https://us.jetcost.com/en/flights/search",
  },
  { name: "Uruguay", host: "https://www.jetcost.com.uy/vuelos/busqueda" },
  { name: "Venezuela", host: "https://www.jetcost.co.ve/vuelos/busqueda" },
  { name: "한국", host: "https://www.jetcost.co.kr/flights/search" },
];

const cabins = [0, 0, 1, 2];

function print() {
  if ((0,_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.isMulticity)()) return; // no multi segments

  var pax = (0,___WEBPACK_IMPORTED_MODULE_0__.validatePax)({
    maxPaxcount: 9,
    countInf: false,
    childAsAdult: 12,
    sepInfSeat: false,
    childMinAge: 2,
  });
  if (!pax) {
    (0,_utils__WEBPACK_IMPORTED_MODULE_3__.printNotification)("Error: Failed to validate Passengers in printOvago");
    return;
  }

  const cabin =
    cabins[(0,_settings_appSettings__WEBPACK_IMPORTED_MODULE_2__.getCabin)(Math.min(...(0,_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.getCurrentSegs)().map((seg) => seg.cabin)))];

  var createUrl = function (host) {
    return `${host}?adults=${pax.adults}&children=${
      pax.children.length
    }&infants=${pax.infLap}&cabin_class=${cabin}&${_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin
      .map(
        (seg, i) =>
          `trips[${i}][date]=${formatDate(seg.dep)}&trips[${i}][from_iata]=${
            seg.orig
          }&trips[${i}][to_iata]=${seg.dest}`,
      )
      .join("&")}`;
  };

  var url = createUrl("https://us.jetcost.com/en/flights/search");
  if (!url) {
    return;
  }

  var extra =
    ' <span class="pt-hover-container">[+]<span class="pt-hover-menu">';
  extra += editions
    .map(function (obj, i) {
      return (
        '<a href="' +
        createUrl(obj.host) +
        '" target="_blank">' +
        obj.name +
        "</a>"
      );
    })
    .join("<br/>");
  extra += "</span></span>";

  return {
    url,
    title: "Jetcost",
    extra,
  };
}

function formatDate(date) {
  return `${date.year}-${(0,_utils__WEBPACK_IMPORTED_MODULE_3__.to2digits)(date.month)}-${(0,_utils__WEBPACK_IMPORTED_MODULE_3__.to2digits)(date.day)}`;
}

(0,___WEBPACK_IMPORTED_MODULE_0__.register)("meta", print);


/***/ }),

/***/ "./src/matrix5/links/meta/kayak.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _settings_appSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/settings/appSettings.ts");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/parse/itin.ts");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/matrix5/utils.js");





const editions = [
  { name: "Kayak.ae", host: "www.kayak.ae" },
  { name: "Kayak.ar", host: "www.kayak.com.ar" },
  { name: "Kayak.at", host: "www.kayak.cat" },
  { name: "Kayak.au", host: "www.kayak.com.au" },
  { name: "Kayak.br", host: "www.kayak.com.br" },
  { name: "Kayak.ca", host: "www.ca.kayak.com" },
  { name: "Kayak.ch", host: "www.kayak.ch" },
  { name: "Kayak.cl", host: "www.kayak.cl" },
  { name: "Kayak.cn", host: "www.cn.kayak.com" },
  { name: "Kayak.co", host: "www.kayak.com.co" },
  { name: "Kayak.com", host: "www.kayak.com" },
  { name: "Kayak.de", host: "www.kayak.de" },
  { name: "Kayak.dk", host: "www.kayak.dk" },
  { name: "Kayak.es", host: "www.es.kayak.com" },
  { name: "Kayak.es", host: "www.kayak.es" },
  { name: "Kayak.fi", host: "www.fi.kayak.com" },
  { name: "Kayak.fr", host: "www.kayak.fr" },
  { name: "Kayak.gr", host: "www.gr.kayak.com" },
  { name: "Kayak.hk", host: "www.kayak.com.hk" },
  { name: "Kayak.id", host: "www.kayak.co.id" },
  { name: "Kayak.ie", host: "www.kayak.ie" },
  { name: "Kayak.in", host: "www.kayak.co.in" },
  { name: "Kayak.it", host: "www.kayak.it" },
  { name: "Kayak.jp", host: "www.kayak.co.jp" },
  { name: "Kayak.kr", host: "www.kayak.co.kr" },
  { name: "Kayak.mx", host: "www.kayak.com.mx" },
  { name: "Kayak.my", host: "www.kayak.com.my" },
  { name: "Kayak.nl", host: "www.kayak.nl" },
  { name: "Kayak.no", host: "www.kayak.no" },
  { name: "Kayak.nz", host: "www.nz.kayak.com" },
  { name: "Kayak.pe", host: "www.kayak.com.pe" },
  { name: "Kayak.pl", host: "www.kayak.pl" },
  { name: "Kayak.pt", host: "www.kayak.pt" },
  { name: "Kayak.ru", host: "www.kayak.ru" },
  { name: "Kayak.se", host: "www.kayak.se" },
  { name: "Kayak.sg", host: "www.kayak.sg" },
  { name: "Kayak.th", host: "www.kayak.co.th" },
  { name: "Kayak.tr", host: "www.kayak.com.tr" },
  { name: "Kayak.tw", host: "www.tw.kayak.com" },
  { name: "Kayak.uk", host: "www.kayak.co.uk" },
  { name: "Kayak.vn", host: "www.vn.kayak.com" },
  { name: "Kayak.za", host: "www.za.kayak.com" },
];

const cabins = ["economy", "premium", "business", "first"];

function print(method) {
  //example https://www.Kayak.ru/flights/MOW-CPH...OW/2016-05-20/
  // method: 0 = based on leg; 1 = based on segment
  const segs = !method ? _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin : (0,_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.getCurrentSegs)();
  if (method && _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin.length === segs.length) return;

  var pax = (0,___WEBPACK_IMPORTED_MODULE_1__.validatePax)({
    maxPaxcount: 9,
    countInf: false,
    childAsAdult: 12,
    sepInfSeat: true,
    childMinAge: 2,
  });
  if (!pax) {
    (0,_utils__WEBPACK_IMPORTED_MODULE_3__.printNotification)("Error: Failed to validate Passengers in printOvago");
    return;
  }

  const cabin =
    cabins[(0,_settings_appSettings__WEBPACK_IMPORTED_MODULE_0__.getCabin)(Math.min(...(0,_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.getCurrentSegs)().map((seg) => seg.cabin)))];

  const createUrl = function (host) {
    let url =
      `https://${host}/flights/` +
      segs
        .map(
          (seg) =>
            `${seg.orig}-${seg.dest}/${seg.dep.year}-${(0,_utils__WEBPACK_IMPORTED_MODULE_3__.to2digits)(
              seg.dep.month,
            )}-${(0,_utils__WEBPACK_IMPORTED_MODULE_3__.to2digits)(seg.dep.day)}`,
        )
        .join("/");

    if (pax.adults > 1 || pax.children.length || pax.infSeat || pax.infLap) {
      url += `/${_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.numPax}adults`;
    }

    if (pax.children.length || pax.infSeat || pax.infLap) {
      url += "/children";
      for (let i = 0; i < pax.infSeat; i++) {
        url += "-1S";
      }
      for (let i = 0; i < pax.infLap; i++) {
        url += "-1L";
      }
      for (let i = 0; i < pax.children.length; i++) {
        url += "-11";
      }
    }

    url += "/" + cabin;

    return url;
  };

  var url = createUrl("kayak.com");
  if (!url) {
    return;
  }

  var extra =
    ' <span class="pt-hover-container">[+]<span class="pt-hover-menu">';
  extra += editions
    .map(function (obj, i) {
      return (
        '<a href="' +
        createUrl(obj.host) +
        '" target="_blank">' +
        obj.name +
        "</a>"
      );
    })
    .join("<br/>");
  extra += "</span></span>";

  return {
    url,
    title: "Kayak",
    desc: `Based on ${segs.length} segment(s)`,
    extra,
  };
}

(0,___WEBPACK_IMPORTED_MODULE_1__.register)("meta", () => print(0));
(0,___WEBPACK_IMPORTED_MODULE_1__.register)("meta", () => print(1));


/***/ }),

/***/ "./src/matrix5/links/meta/momondo.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _settings_appSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/settings/appSettings.ts");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/parse/itin.ts");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/matrix5/utils.js");





const editions = [
  { name: "Momondo.ar", host: "www.momondo.com.ar" },
  { name: "Momondo.at", host: "www.momondo.at" },
  { name: "Momondo.au", host: "www.momondo.com.au" },
  { name: "Momondo.be", host: "www.momondo.be" },
  { name: "Momondo.br", host: "www.momondo.com.br" },
  { name: "Momondo.by", host: "www.momondo.by" },
  { name: "Momondo.ca", host: "www.momondo.ca" },
  { name: "Momondo.ch", host: "www.momondo.ch" },
  { name: "Momondo.cl", host: "www.momondo.cl" },
  { name: "Momondo.cn", host: "www.cn.momondo.com" },
  { name: "Momondo.co", host: "www.momondo.com.co" },
  { name: "Momondo.cz", host: "www.momondo.cz" },
  { name: "Momondo.de", host: "www.momondo.de" },
  { name: "Momondo.dk", host: "www.momondo.dk" },
  { name: "Momondo.ee", host: "www.momondo.ee" },
  { name: "Momondo.es", host: "www.momondo.es" },
  { name: "Momondo.fi", host: "www.momondo.fi" },
  { name: "Momondo.fr", host: "www.momondo.fr" },
  { name: "Momondo.hk", host: "www.momondo.hk" },
  { name: "Momondo.ie", host: "www.momondo.ie" },
  { name: "Momondo.in", host: "www.momondo.in" },
  { name: "Momondo.it", host: "www.momondo.it" },
  { name: "Momondo.kz", host: "www.momondo.kz" },
  { name: "Momondo.mx", host: "www.momondo.mx" },
  { name: "Momondo.nl", host: "www.momondo.nl" },
  { name: "Momondo.no", host: "www.momondo.no" },
  { name: "Momondo.nz", host: "www.momondo.co.nz" },
  { name: "Momondo.om", host: "www.momondo.com" },
  { name: "Momondo.pe", host: "www.momondo.com.pe" },
  { name: "Momondo.pl", host: "www.momondo.pl" },
  { name: "Momondo.pt", host: "www.momondo.pt" },
  { name: "Momondo.ro", host: "www.momondo.ro" },
  { name: "Momondo.ru", host: "www.momondo.ru" },
  { name: "Momondo.se", host: "www.momondo.se" },
  { name: "Momondo.tr", host: "www.momondo.com.tr" },
  { name: "Momondo.tw", host: "www.momondo.tw" },
  { name: "Momondo.ua", host: "www.momondo.ua" },
  { name: "Momondo.uk", host: "www.momondo.co.uk" },
  { name: "Momondo.za", host: "www.momondo.co.za" },
];

var cabins = ["economy", "premium", "business", "first"];

function print(method) {
  //example https://www.Momondo.ru/flightsearch/?...false&NA=false
  //pax # &AD=2&CA=0,8 – not working with children (total amount of adults + kids goes to adult)
  // method: 0 = based on leg; 1 = based on segment
  const segs = !method ? _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin : (0,_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.getCurrentSegs)();
  if (method && _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin.length === segs.length) return;

  var pax = (0,___WEBPACK_IMPORTED_MODULE_1__.validatePax)({
    maxPaxcount: 9,
    countInf: false,
    childAsAdult: 12,
    sepInfSeat: true,
    childMinAge: 2,
  });
  if (!pax) {
    (0,_utils__WEBPACK_IMPORTED_MODULE_3__.printNotification)("Error: Failed to validate Passengers in printOvago");
    return;
  }

  const cabin =
    cabins[(0,_settings_appSettings__WEBPACK_IMPORTED_MODULE_0__.getCabin)(Math.min(...(0,_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.getCurrentSegs)().map((seg) => seg.cabin)))];

  var createUrl = function (host) {
    let url =
      `https://${host}/flight-search/` +
      segs
        .map(
          (seg) =>
            `${seg.orig}-${seg.dest}/${seg.dep.year}-${(0,_utils__WEBPACK_IMPORTED_MODULE_3__.to2digits)(
              seg.dep.month,
            )}-${(0,_utils__WEBPACK_IMPORTED_MODULE_3__.to2digits)(seg.dep.day)}`,
        )
        .join("/");

    if (pax.adults > 1 || pax.children.length || pax.infSeat || pax.infLap) {
      url += `/${_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.numPax}adults`;
    }

    if (pax.children.length || pax.infSeat || pax.infLap) {
      url += "/children";
      for (let i = 0; i < pax.infSeat; i++) {
        url += "-1S";
      }
      for (let i = 0; i < pax.infLap; i++) {
        url += "-1L";
      }
      for (let i = 0; i < pax.children.length; i++) {
        url += "-11";
      }
    }

    url += "/" + cabin;

    return url;
  };

  var url = createUrl("www.momondo.com");
  var extra =
    ' <span class="pt-hover-container">[+]<span class="pt-hover-menu">';
  extra += editions
    .map(function (obj, i) {
      return (
        '<a href="' +
        createUrl(obj.host) +
        '" target="_blank">' +
        obj.name +
        "</a>"
      );
    })
    .join("<br/>");
  extra += "</span></span>";

  return {
    url,
    title: "Momondo",
    desc: `Based on ${segs.length} segment(s)`,
    extra,
  };
}

(0,___WEBPACK_IMPORTED_MODULE_1__.register)("meta", () => print(0));
(0,___WEBPACK_IMPORTED_MODULE_1__.register)("meta", () => print(1));


/***/ }),

/***/ "./src/matrix5/links/meta/skyscanner.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _settings_appSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/settings/appSettings.ts");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/parse/itin.ts");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/matrix5/utils.js");





const editions = [
  { name: "www.skyscanner.com", market: "US" },
  { name: "www.skyscanner.ae", market: "AE" },
  { name: "www.skyscanner.at", market: "AT" },
  { name: "www.skyscanner.com.au", market: "AU" },
  { name: "www.skyscanner.com.br", market: "BR" },
  { name: "www.skyscanner.ca", market: "CA" },
  { name: "www.skyscanner.ch", market: "CH" },
  { name: "www.tianxun.com", market: "CN" },
  { name: "www.espanol.skyscanner.com", market: "CO" },
  { name: "www.skyscanner.cz", market: "CZ" },
  { name: "www.skyscanner.de", market: "DE" },
  { name: "www.skyscanner.dk", market: "DK" },
  { name: "www.skyscanner.es", market: "ES" },
  { name: "www.skyscanner.fi", market: "FI" },
  { name: "www.skyscanner.fr", market: "FR" },
  { name: "www.skyscanner.gg", market: "GG" },
  { name: "gr.skyscanner.com", market: "GR" },
  { name: "www.skyscanner.com.hk", market: "HK" },
  { name: "www.skyscanner.hu", market: "HU" },
  { name: "www.skyscanner.co.id", market: "ID" },
  { name: "www.skyscanner.ie", market: "IE" },
  { name: "www.skyscanner.co.il", market: "IL" },
  { name: "www.skyscanner.co.in", market: "IN" },
  { name: "www.skyscanner.it", market: "IT" },
  { name: "www.skyscanner.jp", market: "JP" },
  { name: "www.skyscanner.co.kr", market: "KR" },
  { name: "www.skyscanner.com.mx", market: "MX" },
  { name: "www.skyscanner.com.my", market: "MY" },
  { name: "www.skyscanner.nl", market: "NL" },
  { name: "www.skyscanner.no", market: "NO" },
  { name: "www.skyscanner.co.nz", market: "NZ" },
  { name: "www.skyscanner.com.ph", market: "PH" },
  { name: "www.skyscanner.pl", market: "PL" },
  { name: "www.skyscanner.pt", market: "PT" },
  { name: "www.skyscanner.ro", market: "RO" },
  { name: "ru.skyscanner.com", market: "RU" },
  { name: "www.skyscanner.com.sa", market: "SA" },
  { name: "www.skyscanner.se", market: "SE" },
  { name: "www.skyscanner.com.sg", market: "SG" },
  { name: "www.skyscanner.co.th", market: "TH" },
  { name: "www.skyscanner.com.tr", market: "TR" },
  { name: "www.skyscanner.com.tw", market: "TW" },
  { name: "www.skyscanner.com.ua", market: "UA" },
  { name: "www.skyscanner.net", market: "UK" },
  { name: "www.skyscanner.com.vn", market: "VN" },
];

var cabins = ["", "premiumeconomy", "business", "first"];

function print(method) {
  //example https://www.skyscanner.ru/transport/d/stoc/2017-09-02/akl/akl/2017-09-16/stoc/akl/2017-09-29/syd?adults=1&children=0&adultsv2=1&childrenv2=&infants=0&cabinclass=economy&ref=day-view#results
  // method: 0 = based on leg; 1 = based on segment
  const segs = !method ? _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin : (0,_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.getCurrentSegs)();
  if (method && _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin.length === segs.length) return;

  var pax = (0,___WEBPACK_IMPORTED_MODULE_1__.validatePax)({
    maxPaxcount: 8,
    countInf: false,
    childAsAdult: 12,
    sepInfSeat: false,
    childMinAge: 2,
  });
  if (!pax) {
    (0,_utils__WEBPACK_IMPORTED_MODULE_3__.printNotification)("Error: Failed to validate Passengers in printOvago");
    return;
  }

  const cabin =
    cabins[(0,_settings_appSettings__WEBPACK_IMPORTED_MODULE_0__.getCabin)(Math.min(...(0,_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.getCurrentSegs)().map((seg) => seg.cabin)))];

  var createUrl = function (edition) {
    var url = `http://${edition.name}/transport/d/`;

    // Add the segments:
    url += segs
      .map(
        (seg) =>
          `${seg.orig}/${seg.dep.year}-${(0,_utils__WEBPACK_IMPORTED_MODULE_3__.to2digits)(seg.dep.month)}-${(0,_utils__WEBPACK_IMPORTED_MODULE_3__.to2digits)(
            seg.dep.day,
          )}/${seg.dest}`,
      )
      .join("/");

    // Add passenger info:
    url += "?adults=" + pax.adults + "adultsv2=" + pax.adults;
    if (pax.children.length || pax.infLap)
      url +=
        "&childrenv2=" +
        Array.apply(null, { length: pax.infLap })
          .map((o) => 0)
          .concat(pax.children)
          .join("|");
    if (pax.infLap) url += "&infants=" + pax.infLap;
    // Add cabin / class of service:
    url += "&cabinclass=" + cabin;
    // Add locale ("market"):
    url += "&ref=day-view&market=" + edition.market;

    return url;
  };
  var url = createUrl(editions[0]);
  var extra =
    ' <span class="pt-hover-container">[+]<span class="pt-hover-menu">';
  extra += editions
    .map(function (obj, i) {
      return (
        '<a href="' + createUrl(obj) + '" target="_blank">' + obj.name + "</a>"
      );
    })
    .join("<br/>");
  extra += "</span></span>";

  return {
    url,
    title: "Skyscanner",
    desc: `Based on ${segs.length} segment(s)`,
    extra,
  };
}

(0,___WEBPACK_IMPORTED_MODULE_1__.register)("meta", () => print(0));
(0,___WEBPACK_IMPORTED_MODULE_1__.register)("meta", () => print(1));


/***/ }),

/***/ "./src/matrix5/links/meta/tripadvisor.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _settings_appSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/settings/appSettings.ts");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/parse/itin.ts");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/matrix5/utils.js");





const editions = [
  { name: "Arabic", host: "ar.tripadvisor.com" },
  { name: "Argentina", host: "www.tripadvisor.com.ar" },
  { name: "Australia", host: "www.tripadvisor.com.au" },
  { name: "Austria", host: "www.tripadvisor.at" },
  { name: "Belgium", host: "fr.tripadvisor.be" },
  { name: "Belgium", host: "www.tripadvisor.be" },
  { name: "Brazil", host: "www.tripadvisor.com.br" },
  { name: "Canada (English)", host: "www.tripadvisor.ca" },
  { name: "Canada (French)", host: "fr.tripadvisor.ca" },
  { name: "Chile", host: "www.tripadvisor.cl" },
  { name: "China", host: "www.tripadvisor.cn" },
  { name: "Chinese International", host: "cn.tripadvisor.com" },
  { name: "Colombia", host: "www.tripadvisor.co" },
  { name: "Czech Republic", host: "www.tripadvisor.cz" },
  { name: "Denmark", host: "www.tripadvisor.dk" },
  { name: "Egypt", host: "www.tripadvisor.com.eg" },
  { name: "Finland", host: "www.tripadvisor.fi" },
  { name: "France", host: "www.tripadvisor.fr" },
  { name: "Germany", host: "www.tripadvisor.de" },
  { name: "Greece", host: "www.tripadvisor.com.gr" },
  { name: "Hong Kong", host: "en.tripadvisor.com.hk" },
  { name: "Hong Kong", host: "www.tripadvisor.com.hk" },
  { name: "Hungary", host: "www.tripadvisor.co.hu" },
  { name: "India", host: "www.tripadvisor.in" },
  { name: "Indonesia", host: "www.tripadvisor.co.id" },
  { name: "Ireland", host: "www.tripadvisor.ie" },
  { name: "Israel", host: "www.tripadvisor.co.il" },
  { name: "Italy", host: "www.tripadvisor.it" },
  { name: "Japan", host: "www.tripadvisor.jp" },
  { name: "Malaysia", host: "www.tripadvisor.com.my" },
  { name: "Mexico", host: "www.tripadvisor.com.mx" },
  { name: "New Zealand", host: "www.tripadvisor.co.nz" },
  { name: "Norway", host: "no.tripadvisor.com" },
  { name: "Peru", host: "www.tripadvisor.com.pe" },
  { name: "Philippines", host: "www.tripadvisor.com.ph" },
  { name: "Poland", host: "pl.tripadvisor.com" },
  { name: "Portugal", host: "www.tripadvisor.pt" },
  { name: "Russia", host: "www.tripadvisor.ru" },
  { name: "Serbia", host: "www.tripadvisor.rs" },
  { name: "Singapore", host: "www.tripadvisor.com.sg" },
  { name: "Slovakia", host: "www.tripadvisor.sk" },
  { name: "South Africa", host: "www.tripadvisor.co.za" },
  { name: "South Korea", host: "www.tripadvisor.co.kr" },
  { name: "Spain", host: "www.tripadvisor.es" },
  { name: "Sweden", host: "www.tripadvisor.se" },
  { name: "Switzerland", host: "www.tripadvisor.ch" },
  { name: "Switzerland", host: "fr.tripadvisor.ch" },
  { name: "Switzerland", host: "it.tripadvisor.ch" },
  { name: "Taiwan", host: "www.tripadvisor.com.tw" },
  { name: "Thailand", host: "th.tripadvisor.com" },
  { name: "The Netherlands", host: "www.tripadvisor.nl" },
  { name: "Turkey", host: "www.tripadvisor.com.tr" },
  { name: "United Kingdom", host: "www.tripadvisor.co.uk" },
  { name: "United States", host: "www.tripadvisor.com" },
  { name: "Venezuela", host: "www.tripadvisor.com.ve" },
  { name: "Vietnam", host: "www.tripadvisor.com.vn" },
];

const cabins = ["0", "3", "1", "2"];

function print(method) {
  // method: 0 = based on leg; 1 = based on segment
  const segs = !method ? _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin : (0,_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.getCurrentSegs)();
  if (method && _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin.length === segs.length) return;

  const pax = (0,___WEBPACK_IMPORTED_MODULE_1__.validatePax)({
    maxPaxcount: 8,
    countInf: false,
    childAsAdult: 12,
    sepInfSeat: false,
    childMinAge: 2,
  });
  if (!pax) {
    (0,_utils__WEBPACK_IMPORTED_MODULE_3__.printNotification)("Error: Failed to validate Passengers in printOvago");
    return;
  }

  const cabin =
    cabins[(0,_settings_appSettings__WEBPACK_IMPORTED_MODULE_0__.getCabin)(Math.min(...(0,_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.getCurrentSegs)().map((seg) => seg.cabin)))];

  const nonstop = method ? "yes" : "no";

  const createUrl = function (host) {
    let url = `https://${host}/CheapFlightsSearchResults?&cos=${cabin}&nonstop=${nonstop}`;

    let paxNum = 0;

    const addPax = (age) => (url += `&pax${paxNum++}=${age}`);

    Array.apply(null, { length: pax.adults }).forEach((o) => addPax("a"));
    Array.apply(null, { length: pax.infLap }).forEach((o) => addPax(0));
    pax.children.forEach((age) => addPax(age));

    url +=
      "&" +
      segs
        .map(
          (seg, i) =>
            `date${i * 2}=${seg.dep.year}${(0,_utils__WEBPACK_IMPORTED_MODULE_3__.to2digits)(seg.dep.month)}${(0,_utils__WEBPACK_IMPORTED_MODULE_3__.to2digits)(
              seg.dep.day,
            )}&airport${i * 2}=${seg.orig}&nearby${i * 2}=no&airport${
              i * 2 + 1
            }=${seg.dest}&nearby${i * 2 + 1}=no`,
        )
        .join("&");

    return url;
  };
  const url = createUrl("www.tripadvisor.com");
  let extra =
    ' <span class="pt-hover-container">[+]<span class="pt-hover-menu">';
  extra += editions
    .map(function (obj, i) {
      return (
        '<a href="' +
        createUrl(obj.host) +
        '" target="_blank">' +
        obj.name +
        "</a>"
      );
    })
    .join("<br/>");
  extra += "</span></span>";

  return {
    url,
    title: "Tripadvisor",
    desc: `Based on ${segs.length} segment(s)`,
    extra,
  };
}

(0,___WEBPACK_IMPORTED_MODULE_1__.register)("meta", () => print(0));
(0,___WEBPACK_IMPORTED_MODULE_1__.register)("meta", () => print(1));


/***/ }),

/***/ "./src/matrix5/links/otas/agoda.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/parse/itin.ts");
/* harmony import */ var _settings_appSettings__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/settings/appSettings.ts");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/matrix5/utils.js");





const editions = [
  { name: "English", lang: "en", pos: "US" },
  { name: "한국어", lang: "ko", pos: "KR" },
  { name: "繁體中文 (台灣)", lang: "zh", pos: "TW" },
  { name: "Español", lang: "es", pos: "ES" },
  { name: "简体中文", lang: "zh", pos: "CN" },
  { name: "日本語", lang: "ja", pos: "JP" },
  { name: "繁體中文 (香港)", lang: "zh", pos: "HK" },
  { name: "ภาษาไทย", lang: "th", pos: "TH" },
  { name: "Français", lang: "fr", pos: "FR" },
  { name: "Tiếng Việt", lang: "vi", pos: "VN" },
  { name: "Deutsch", lang: "de", pos: "DE" },
  { name: "Русский", lang: "ru", pos: "RU" },
  { name: "Bahasa Indonesia", lang: "id", pos: "ID" },
  { name: "العربية", lang: "ar", pos: "AE" },
  { name: "Português (PT)", lang: "pt", pos: "PT" },
  { name: "Português (BR)", lang: "pt", pos: "BR" },
  { name: "עברית", lang: "he", pos: "IL" },
  { name: "Język polski", lang: "pl", pos: "PL" },
  { name: "Italiano", lang: "it", pos: "IT" },
  { name: "Nederlands", lang: "nl", pos: "NL" },
  { name: "Română", lang: "ro", pos: "RO" },
  { name: "Svenska", lang: "sv", pos: "SE" },
  { name: "Türkçe", lang: "tr", pos: "TR" },
  { name: "Dansk", lang: "da", pos: "DK" },
  { name: "Українська", lang: "uk", pos: "UA" },
  { name: "Bahasa Malaysia", lang: "ms", pos: "MY" },
  { name: "Norsk", lang: "nb", pos: "NO" },
  { name: "Čeština", lang: "cs", pos: "CZ" },
  { name: "Suomi", lang: "fi", pos: "FI" },
  { name: "Magyar", lang: "hu", pos: "HU" },
  { name: "Ελληνικά", lang: "el", pos: "GR" },
  { name: "Lietuvių", lang: "lt", pos: "LT" },
  { name: "Filipino", lang: "tl", pos: "PH" },
  { name: "Slovenski jezik", lang: "sl", pos: "SI" },
  { name: "Български език", lang: "bg", pos: "BG" },
  { name: "Català", lang: "ca", pos: "ES" },
  { name: "Eesti", lang: "et", pos: "EE" },
  { name: "Latviešu", lang: "lv", pos: "LV" },
  { name: "Hrvatski", lang: "hr", pos: "HR" },
];

function buildQueryString(cur, pos = "", lang = null) {
  const cabins = ["ECO", "PEO", "BIZ", "FST"];
  const pax = (0,___WEBPACK_IMPORTED_MODULE_0__.validatePax)({
    maxPaxcount: 9,
    countInf: true,
    childAsAdult: 12,
    sepInfSeat: false,
    childMinAge: 2,
  });
  if (!pax) {
    (0,_utils__WEBPACK_IMPORTED_MODULE_3__.printNotification)("Error: Failed to validate Passengers in edestinos");
    return;
  }

  let url = `cid=1841944&currency=${cur}&DisplayedPrice=${
    _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.price
  }&TripType=${(0,_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.getTripType)("OneWay", "RoundTrip", "MultiCity")}`;
  url += "&Adult=" + pax.adults;
  url += "&Child=" + pax.children.length;
  url += "&InfantLap=" + pax.infLap;

  let j = 0;
  _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin.forEach((itin, i) => {
    const slices = [];

    itin.seg.forEach((seg) => {
      j++;
      slices.push(j);

      url += `&Cabin${j}=` + cabins[(0,_settings_appSettings__WEBPACK_IMPORTED_MODULE_2__.getCabin)(seg.cabin)];
      url += `&Carrier${j}=` + seg.carrier;
      url += `&Origin${j}=` + seg.orig;
      url += `&Destination${j}=` + seg.dest;
      url += `&BookingCode${j}=` + seg.bookingclass;
      url += `&FlightNumber${j}=` + seg.fnr;
      url += `&DepartureDate${j}=${seg.dep.year}-${(0,_utils__WEBPACK_IMPORTED_MODULE_3__.to2digits)(
        seg.dep.month,
      )}-${(0,_utils__WEBPACK_IMPORTED_MODULE_3__.to2digits)(seg.dep.day)}T${seg.dep.time24}:00`;
      url += `&FareBasis${j}=` + seg.farebase;
    });

    url += `&Slice${i + 1}=` + slices.join(",");
  });

  return url;
}

function print() {
  const createUrl = (edition) =>
    `https://www.agoda.com/bookings/details?${buildQueryString(
      _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.cur || "USD",
      edition.pos,
      edition.lang,
    )}`;

  // get edition
  const url = createUrl({ lang: "en", pos: "US" });
  if (!url) {
    return;
  }

  let container = "";
  if (editions && editions.length > 1) {
    container +=
      ' <span class="pt-hover-container">[+]<span class="pt-hover-menu-flex"><div style="margin-right: 1rem;">';
    container += editions
      .slice(1)
      .map(function (obj, i) {
        return (
          '<a href="' +
          createUrl(obj) +
          '" target="_blank">' +
          obj.name +
          "</a>"
        );
      })
      .join("<br/>");
    container += "</div></span></span>";
  }

  return {
    url,
    title: "Agoda",
    extra: container,
  };
}

(0,___WEBPACK_IMPORTED_MODULE_0__.register)("otas", print);


/***/ }),

/***/ "./src/matrix5/links/otas/cheapoair.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _settings_appSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/settings/appSettings.ts");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/matrix5/utils.js");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/parse/itin.ts");





function printCheapOair() {
  // 0 = Economy; 1=Premium Economy; 2=Business; 3=First
  var cabins = ["Economy", "PremiumEconomy", "Business", "First"];
  var coaUrl = "http://www.cheapoair.com/default.aspx?tabid=1832&ulang=en";
  var pax = (0,___WEBPACK_IMPORTED_MODULE_1__.validatePax)({
    maxPaxcount: 9,
    countInf: true,
    childAsAdult: 12,
    sepInfSeat: true,
    childMinAge: 2,
  });
  if (!pax) {
    (0,_utils__WEBPACK_IMPORTED_MODULE_3__.printNotification)("Error: Failed to validate Passengers in printCheapOair");
    return;
  }
  coaUrl +=
    "&ad=" +
    pax.adults +
    "&ch=" +
    pax.children.length +
    "&sr=0&is=" +
    pax.infSeat +
    "&il=" +
    pax.infLap;
  coaUrl += "&pos=US";
  coaUrl += "&dispr=" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.price;
  var seg = 0;
  var slices = {};
  for (var i = 0; i < _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin.length; i++) {
    slices[i] = "";
    for (var j = 0; j < _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg.length; j++) {
      seg++;
      if (slices[i]) slices[i] += ",";
      slices[i] += seg;

      coaUrl +=
        "&cbn" +
        seg +
        "=" +
        cabins[
          _settings_appSettings__WEBPACK_IMPORTED_MODULE_0__["default"].cabin === "Auto"
            ? _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].cabin
            : (0,_settings_appSettings__WEBPACK_IMPORTED_MODULE_0__.getForcedCabin)()
        ];
      coaUrl += "&carr" + seg + "=" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].carrier;
      coaUrl +=
        "&dd" +
        seg +
        "=" +
        _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].dep.year +
        ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].dep.month).slice(-2) +
        ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].dep.day).slice(-2);
      coaUrl += "&og" + seg + "=" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].orig;
      coaUrl += "&dt" + seg + "=" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].dest;
      coaUrl += "&fbc" + seg + "=" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].bookingclass;
      coaUrl += "&fnum" + seg + "=" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].fnr;
    }
    coaUrl += "&Slice" + (i + 1) + "=" + slices[i];
  }

  coaUrl += "&tt=" + (0,_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.getTripType)("OneWay", "RoundTrip", "MultiCity");

  return {
    url: coaUrl,
    title: "CheapOair",
  };
}

(0,___WEBPACK_IMPORTED_MODULE_1__.register)("otas", printCheapOair);


/***/ }),

/***/ "./src/matrix5/links/otas/edestinos.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/parse/itin.ts");
/* harmony import */ var _travix__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/links/otas/travix.js");




const editions = [
  { name: "Brazil", value: "www2.secure.edestinos.com.br" },
  { name: "Peru", value: "www2.secure.edestinos.com.pe" },
  { name: "Colombia", value: "www2.secure.edestinos.com.co" },
  { name: "Dominican Republic", value: "www2.secure.edestinos.com.do" },
  { name: "El Salvador", value: "www2.secure.edestinos.com.sv" },
  { name: "Panama", value: "www2.secure.edestinos.com.pa" },
  { name: "Nicaragua", value: "www2.secure.edestinos.com.ni" },
  { name: "Guatemala", value: "www2.secure.edestinos.com.gt" },
  { name: "Honduras", value: "www2.secure.edestinos.com.hn" },
  { name: "Paraguay", value: "www2.secure.edestinos.com.py" },
  { name: "Puerto Rico", value: "www2.secure.edestinos.com.pr" },
  { name: "Costa Rica", value: "www2.secure.edestinos.cr" },
  { name: "Bolivia", value: "www2.secure.edestinos.com.bo" },
  { name: "Argentina", value: "www2.secure.edestinos.com.ar" },
  { name: "Mexico", value: "www2.secure.edestinos.com.mx" },
  { name: "Chile", value: "www2.secure.edestinos.cl" },
  { name: "Poland", value: "www2.secure.esky.pl" },
  { name: "Romania", value: "www2.secure.esky.ro" },
  { name: "Bulgaria", value: "www2.secure.esky.bg" },
  { name: "Czech Republic", value: "www2.secure.esky.cz" },
  { name: "Slovakia", value: "www2.secure.esky.sk" },
  { name: "Hungary", value: "www2.secure.esky.hu" },
  { name: "Moldova", value: "www2.secure.esky.md" },
  { name: "Spain", value: "www2.secure.esky.es" },
  { name: "Serbia", value: "www2.secure.esky.rs" },
  { name: "Croatia", value: "www2.secure.esky.hr" },
  { name: "Bosnia and Herzegovina", value: "www2.secure.esky.ba" },
  { name: "Ireland", value: "www2.secure.esky.ie" },
  { name: "United Kingdom", value: "www2.secure.esky.co.uk" },
  { name: "Turkey", value: "www2.secure.esky.com.tr" },
  { name: "France", value: "www2.secure.esky.fr" },
  { name: "Portugal", value: "www2.secure.esky.pt" },
  { name: "Greece", value: "www2.secure.esky.gr" },
  { name: "Germany", value: "www2.secure.eskytravel.de" },
  { name: "Italy", value: "www2.secure.eskytravel.it" },
  { name: "Austria", value: "www2.secure.esky.at" },
  { name: "Switzerland", value: "www2.secure.eskytravel.ch" },
  { name: "Netherlands", value: "www2.secure.esky.nl" },
  { name: "Belgium", value: "www2.secure.eskytravel.be" },
  { name: "Finland", value: "www2.secure.esky.fi" },
  { name: "Denmark", value: "www2.secure.eskytravel.dk" },
  { name: "Sweden", value: "www2.secure.esky.se" },
  { name: "Norway", value: "www2.secure.eskytravel.no" },
  { name: "Belarus", value: "www2.secure.esky.by" },
  { name: "South Africa", value: "www2.secure.eskytravel.co.za" },
  { name: "Russia", value: "www2.secure.eskytravel.ru" },
  { name: "New Zealand", value: "www2.secure.eskytravel.co.nz" },
  { name: "eSky.eu", value: "www2.secure.esky.eu" },
  { name: "eSky.com", value: "www2.secure.esky.com" },
  { name: "eDestinos.com", value: "www2.secure.edestinos.com" },
];

function print() {
  var createUrl = (host) =>
    `https://${host}/api?${(0,_travix__WEBPACK_IMPORTED_MODULE_2__.buildQueryString)(_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.cur || "USD")}`;

  var url = createUrl("www2.secure.edestinos.com.br");
  var extra =
    ' <span class="pt-hover-container">[+]<span class="pt-hover-menu">';
  extra += editions
    .map(function (obj, i) {
      return (
        '<a href="' +
        createUrl(obj.value) +
        '" target="_blank">' +
        obj.name +
        "</a>"
      );
    })
    .join("<br/>");
  extra += "</span></span>";

  return {
    url,
    title: "eDestinos",
    extra,
  };
}

(0,___WEBPACK_IMPORTED_MODULE_0__.register)("otas", print);


/***/ }),

/***/ "./src/matrix5/links/otas/edreams.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/matrix5/utils.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/parse/itin.ts");
/* harmony import */ var _settings_appSettings__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/settings/appSettings.ts");





const eDreams = [
  { name: "eDreams.com", domain: "www.edreams.com" },
  { name: "eDreams.au", domain: "www.edreams.com.au" },
  { name: "eDreams.br", domain: "www.edreams.com.br" },
  { name: "eDreams.ca", domain: "ca.edreams.com" },
  { name: "eDreams.ch", domain: "www.edreams.ch" },
  { name: "eDreams.cl", domain: "cl.edreams.com" },
  { name: "eDreams.cn", domain: "cn.edreams.com" },
  { name: "eDreams.co", domain: "co.edreams.com" },
  { name: "eDreams.co.uk", domain: "www.edreams.co.uk" },
  { name: "eDreams.com.ar", domain: "www.edreams.com.ar" },
  { name: "eDreams.com.mx", domain: "www.edreams.com.mx" },
  { name: "eDreams.com.ru", domain: "www.edreams.com.ru" },
  { name: "eDreams.com.tr", domain: "www.edreams.com.tr" },
  { name: "eDreams.de", domain: "www.edreams.de" },
  { name: "eDreams.es", domain: "www.edreams.es" },
  { name: "eDreams.fr", domain: "www.edreams.fr" },
  { name: "eDreams.gr", domain: "www.edreams.gr" },
  { name: "eDreams.hk", domain: "www.edreams.hk" },
  { name: "eDreams.id", domain: "id.edreams.com" },
  { name: "eDreams.in", domain: "www.edreams.in" },
  { name: "eDreams.it", domain: "www.edreams.it" },
  { name: "eDreams.jp", domain: "www.edreams.jp" },
  { name: "eDreams.ma", domain: "www.edreams.ma" },
  { name: "eDreams.net", domain: "www.edreams.net" },
  { name: "eDreams.nl", domain: "nl.edreams.com" },
  { name: "eDreams.nz", domain: "nz.edreams.com" },
  { name: "eDreams.pe", domain: "www.edreams.pe" },
  { name: "eDreams.ph", domain: "www.edreams.ph" },
  { name: "eDreams.pt", domain: "www.edreams.pt" },
  { name: "eDreams.sg", domain: "sg.edreams.com" },
  { name: "eDreams.th", domain: "th.edreams.com" },
  { name: "eDreams.za", domain: "za.edreams.com" },
];

const opodo = [
  { name: "Opodo.com", domain: "www.opodo.com" },
  { name: "Opodo.at", domain: "www.opodo.at" },
  { name: "Opodo.be", domain: "www.opodo.be" },
  { name: "Opodo.ch", domain: "www.opodo.ch" },
  { name: "Opodo.co.uk", domain: "www.opodo.co.uk" },
  { name: "Opodo.com.au", domain: "www.opodo.com.au" },
  { name: "Opodo.de", domain: "www.opodo.de" },
  { name: "Opodo.dk", domain: "www.opodo.dk" },
  { name: "Opodo.es", domain: "www.opodo.es" },
  { name: "Opodo.fi", domain: "www.opodo.fi" },
  { name: "Opodo.fr", domain: "www.opodo.fr" },
  { name: "Opodo.it", domain: "www.opodo.it" },
  { name: "Opodo.nl", domain: "www.opodo.nl" },
  { name: "Opodo.no", domain: "www.opodo.no" },
  { name: "Opodo.pl", domain: "www.opodo.pl" },
  { name: "Opodo.pt", domain: "www.opodo.pt" },
  { name: "Opodo.se", domain: "www.opodo.se" },
];

const travellink = [
  { name: "Travellink.com", domain: "www.travellink.com" },
  { name: "Travellink.de", domain: "www.travellink.de" },
  { name: "Travellink.dk", domain: "www.travellink.dk" },
  { name: "Travellink.fi", domain: "www.travellink.fi" },
  { name: "Travellink.is", domain: "www.travellink.is" },
  { name: "Travellink.no", domain: "www.travellink.no" },
  { name: "Travellink.se", domain: "www.travellink.se" },
];

const cabins = ["TOURIST", "PREMIUM_ECONOMY", "BUSINESS", "FIRST"];

function printEdreams(title, editions) {
  var pax = (0,___WEBPACK_IMPORTED_MODULE_0__.validatePax)({
    maxPaxcount: 9,
    countInf: false,
    childAsAdult: 12,
    sepInfSeat: false,
    childMinAge: 2,
  });
  if (!pax) {
    (0,_utils__WEBPACK_IMPORTED_MODULE_3__.printNotification)("Error: Failed to validate Passengers in printEdreams");
    return;
  }

  const cabin =
    cabins[(0,_settings_appSettings__WEBPACK_IMPORTED_MODULE_2__.getCabin)(Math.min(...(0,_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.getCurrentSegs)().map((seg) => seg.cabin)))];

  var createUrl = function (domain) {
    const deeplink = `/results/type=M;${_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin
      .map(
        (itin, i) =>
          `dep${i}=${itin.dep.year}-${(0,_utils__WEBPACK_IMPORTED_MODULE_3__.to2digits)(itin.dep.month)}-${(0,_utils__WEBPACK_IMPORTED_MODULE_3__.to2digits)(
            itin.dep.day,
          )};from${i}=${itin.orig};to${i}=${itin.dest}`,
      )
      .join(";")};class=${cabin};adults=${pax.adults};children=${
      pax.children.length
    };infants=${
      pax.infLap
    };collectionmethod=false;airlinescodes=false;internalSearch=true`;

    const segKeys = _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin
      .map(
        (itin, i) =>
          `segmentKey${i}=0,${itin.seg
            .map((seg) => seg.carrier + seg.fnr)
            .join(",")}`,
      )
      .join("&");

    return `https://${domain}/travel/?landingPageType=TEST_AB&searchId=${new Date().getTime()}&deeplink=${deeplink}&fareItineraryKey=0,1A&${segKeys}&searchMainProductTypeName=FLIGHT`;
  };

  var url = createUrl(editions[0].domain);
  if (!url) return;

  var extra =
    ' <span class="pt-hover-container">[+]<span class="pt-hover-menu">';
  extra += editions
    .map(function (obj, i) {
      return (
        '<a href="' +
        createUrl(obj.domain) +
        '" target="_blank">' +
        obj.name +
        "</a>"
      );
    })
    .join("<br/>");
  extra += "</span></span>";

  return {
    url,
    title,
    extra,
  };
}

(0,___WEBPACK_IMPORTED_MODULE_0__.register)("otas", () => printEdreams("eDreams", eDreams));
(0,___WEBPACK_IMPORTED_MODULE_0__.register)("otas", () => printEdreams("Opodo", opodo));
(0,___WEBPACK_IMPORTED_MODULE_0__.register)("otas", () => printEdreams("Travellink", travellink));


/***/ }),

/***/ "./src/matrix5/links/otas/etraveli.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createUrl: () => (/* binding */ createUrl)
/* harmony export */ });
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/utils.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/parse/itin.ts");




const editions = [
  { name: "Gotogate", host: "www.gotogate.com" },
  { name: "Seat24.se", host: "www.seat24.se" },
  { name: "Seat24.de", host: "www.seat24.de" },
  { name: "Seat24.dk", host: "www.seat24.dk" },
  { name: "Seat24.fi", host: "www.seat24.fi" },
  { name: "Seat24.no", host: "www.seat24.no" },
  { name: "Flygvaruhuset.se", host: "www.flygvaruhuset.se" },
  { name: "Travelpartner.se", host: "www.travelpartner.se" },
  { name: "Travelpartner.fi", host: "www.travelpartner.fi" },
  { name: "Travelpartner.no", host: "www.travelpartner.no" },
  { name: "Budjet.se", host: "www.budjet.se" },
  { name: "Budjet.fi", host: "www.budjet.fi" },
  { name: "Budjet.no", host: "www.budjet.no" },
  { name: "Budjet.dk", host: "www.budjet.dk" },
  { name: "Goleif.dk", host: "www.goleif.dk" },
  { name: "Travelfinder.se", host: "www.travelfinder.se" },
  { name: "Gotogate.no", host: "www.gotogate.no" },
  { name: "Gotogate.at", host: "www.gotogate.at" },
  { name: "Gotogate.be", host: "be.gotogate.com" },
  { name: "Gotogate.bg", host: "bg.gotogate.com" },
  { name: "Gotogate.ch", host: "www.gotogate.ch" },
  { name: "Gotogate.cz", host: "cz.gotogate.com" },
  { name: "Gotogate.es", host: "www.gotogate.es" },
  { name: "Gotogate.fr", host: "www.gotogate.fr" },
  { name: "Gotogate.gr", host: "www.gotogate.gr" },
  { name: "Gotogate.hu", host: "hu.gotogate.com" },
  { name: "Gotogate.ie", host: "ie.gotogate.com" },
  { name: "Gotogate.it", host: "www.gotogate.it" },
  { name: "Gotogate.pl", host: "www.gotogate.pl" },
  { name: "Gotogate.pt", host: "www.gotogate.pt" },
  { name: "Gotogate.ro", host: "ro.gotogate.com" },
  { name: "Gotogate.sk", host: "www.gotogate.sk" },
  { name: "Gotogate.tr", host: "tr.gotogate.com" },
  { name: "Gotogate.com.ua", host: "www.gotogate.com.ua" },
  { name: "Gotogate.co.uk", host: "www.gotogate.co.uk" },
  { name: "Flybillet.dk", host: "www.flybillet.dk" },
  { name: "Travelstart.se", host: "www.travelstart.se" },
  { name: "Travelstart.de", host: "www.travelstart.de" },
  { name: "Travelstart.dk", host: "www.travelstart.dk" },
  { name: "Travelstart.fi", host: "www.travelstart.fi" },
  { name: "Travelstart.no", host: "www.travelstart.no" },
  { name: "Supersaver.se", host: "www.supersavertravel.se" },
  { name: "Supersaver.dk", host: "www.supersaver.dk" },
  { name: "Supersaver.fi", host: "www.supersaver.fi" },
  { name: "Supersaver.nl", host: "www.supersaver.nl" },
  { name: "Supersaver.no", host: "www.supersaver.no" },
  { name: "Supersaver.ru", host: "www.supersaver.ru" },
];

const convertDate = (date, withYear, titleMonth) =>
  ("0" + date.day).slice(-2) +
  (titleMonth
    ? (0,_utils__WEBPACK_IMPORTED_MODULE_2__.toTitleCase)((0,_utils__WEBPACK_IMPORTED_MODULE_2__.monthnumberToName)(date.month))
    : (0,_utils__WEBPACK_IMPORTED_MODULE_2__.monthnumberToName)(date.month)) +
  (withYear ? date.year.toString().slice(-2) : "");

const createUrl = (host) => {
  let ggUrl = "https://" + host + "/air/";
  if ((0,_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.isOneway)()) {
    ggUrl += `${_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[0].orig}${
      _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[0].dest
    }${convertDate(_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[0].dep, false)}`;
  } else if ((0,_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.isRoundtrip)()) {
    ggUrl += `${_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[0].orig}${
      _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[0].dest
    }${convertDate(_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[0].dep, false)}${convertDate(
      _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[1].dep,
      false,
    )}`;
  } else {
    ggUrl += _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin
      .map((itin) => `${itin.orig}${itin.dest}${convertDate(itin.dep, false)}`)
      .join(",");
  }
  ggUrl += "/" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.numPax;
  ggUrl +=
    "?selectionKey=" +
    _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin
      .map((itin) =>
        itin.seg
          .map(
            (seg) =>
              seg.carrier +
              seg.fnr +
              "-" +
              convertDate(seg.dep, true, true) +
              "-" +
              seg.bookingclass,
          )
          .join("_"),
      )
      .join("_");

  return ggUrl;
};

function printEtraveli() {
  const ggUrl = createUrl(editions[0].host);
  let extra =
    ' <span class="pt-hover-container">[+]<span class="pt-hover-menu">';
  extra += editions
    .map(function (obj, i) {
      return (
        '<a href="' +
        createUrl(obj.host) +
        '" target="_blank">' +
        obj.name +
        "</a>"
      );
    })
    .join("<br/>");
  extra += "</span></span>";

  return {
    url: ggUrl,
    title: editions[0].name,
    extra,
  };
}

(0,___WEBPACK_IMPORTED_MODULE_0__.register)("otas", printEtraveli);


/***/ }),

/***/ "./src/matrix5/links/otas/expedia.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _settings_appSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/settings/appSettings.ts");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/matrix5/utils.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/parse/itin.ts");





const expedia = [
  { name: "expedia.com", host: "www.expedia.com" },
  { name: "euro.expedia.net", host: "euro.expedia.net" },
  { name: "expedia.at", host: "www.expedia.at" },
  { name: "expedia.be", host: "www.expedia.be" },
  { name: "expedia.ca", host: "www.expedia.ca" },
  { name: "expedia.ch", host: "www.expedia.ch" },
  { name: "expedia.co.id", host: "www.expedia.co.id" },
  { name: "expedia.co.in", host: "www.expedia.co.in" },
  { name: "expedia.co.jp", host: "www.expedia.co.jp" },
  { name: "expedia.co.kr", host: "www.expedia.co.kr" },
  { name: "expedia.co.nz", host: "www.expedia.co.nz" },
  { name: "expedia.co.th", host: "www.expedia.co.th" },
  { name: "expedia.co.uk", host: "www.expedia.co.uk" },
  { name: "expedia.com.ar", host: "www.expedia.com.ar" },
  { name: "expedia.com.au", host: "www.expedia.com.au" },
  { name: "expedia.com.br", host: "www.expedia.com.br" },
  { name: "expedia.com.hk", host: "www.expedia.com.hk" },
  { name: "expedia.com.my", host: "www.expedia.com.my" },
  { name: "expedia.com.ph", host: "www.expedia.com.ph" },
  { name: "expedia.com.sg", host: "www.expedia.com.sg" },
  { name: "expedia.com.tw", host: "www.expedia.com.tw" },
  { name: "expedia.com.vn", host: "www.expedia.com.vn" },
  { name: "expedia.de", host: "www.expedia.de" },
  { name: "expedia.dk", host: "www.expedia.dk" },
  { name: "expedia.es", host: "www.expedia.es" },
  { name: "expedia.fi", host: "www.expedia.fi" },
  { name: "expedia.fr", host: "www.expedia.fr" },
  { name: "expedia.ie", host: "www.expedia.ie" },
  { name: "expedia.it", host: "www.expedia.it" },
  { name: "expedia.mx", host: "www.expedia.mx" },
  { name: "expedia.nl", host: "www.expedia.nl" },
  { name: "expedia.no", host: "www.expedia.no" },
  { name: "expedia.se", host: "www.expedia.se" },
];

const cheaptickets = [
  { name: "cheaptickets.com", host: "www.cheaptickets.com" },
];

const ebookers = [
  { name: "ebookers.com", host: "www.ebookers.com" },
  { name: "ebookers.ch", host: "www.ebookers.ch" },
  { name: "ebookers.de", host: "www.ebookers.de" },
  { name: "ebookers.fi", host: "www.ebookers.fi" },
  { name: "ebookers.fr", host: "www.ebookers.fr" },
  { name: "ebookers.ie", host: "www.ebookers.ie" },
];

const hotwire = [{ name: "hotwire.com", host: "vacation.hotwire.com" }];

const mrjet = [{ name: "mrjet.se", host: "www.mrjet.se" }];

const orbitz = [{ name: "orbitz.com", host: "www.orbitz.com" }];

const travelocity = [
  { name: "travelocity.com", host: "www.travelocity.com" },
  { name: "travelocity.ca", host: "www.travelocity.ca" },
];

const hotels = [
  { name: "hotels.com", host: "travel.hotels.com" },
  { name: "hoteles.com (ar)", host: "travel.ar.hoteles.com" },
  { name: "hotels.com (at)", host: "travel.at.hotels.com" },
  { name: "hotels.com (au)", host: "travel.au.hotels.com" },
  { name: "hotels.com (be)", host: "travel.be.hotels.com" },
  { name: "hotels.com (ca)", host: "travel.ca.hotels.com" },
  { name: "hotels.com (ch)", host: "travel.ch.hotels.com" },
  { name: "hoteles.com (co)", host: "travel.co.hoteles.com" },
  { name: "hotels.com (de)", host: "travel.de.hotels.com" },
  { name: "hoteles.com (es)", host: "travel.es.hoteles.com" },
  { name: "hotels.com (fi)", host: "travel.fi.hotels.com" },
  { name: "hotels.com (fr)", host: "travel.fr.hotels.com" },
  { name: "hotels.com (hu)", host: "travel.hu.hotels.com" },
  { name: "hotels.com (id)", host: "travel.id.hotels.com" },
  { name: "hotels.com (ie)", host: "travel.ie.hotels.com" },
  { name: "hotels.com (in)", host: "travel.in.hotels.com" },
  { name: "hotels.com (is)", host: "travel.is.hotels.com" },
  { name: "hotels.com (it)", host: "travel.it.hotels.com" },
  { name: "hotels.com (jp)", host: "travel.jp.hotels.com" },
  { name: "hotels.com (kr)", host: "travel.kr.hotels.com" },
  { name: "hotels.com (ms)", host: "travel.ms.hotels.com" },
  { name: "hotels.com (nl)", host: "travel.nl.hotels.com" },
  { name: "hotels.com (no)", host: "travel.no.hotels.com" },
  { name: "hotels.com (nz)", host: "travel.nz.hotels.com" },
  { name: "hotels.com (ph)", host: "travel.ph.hotels.com" },
  { name: "hoteis.com (pt)", host: "travel.pt.hoteis.com" },
  { name: "hotels.com (sg)", host: "travel.sg.hotels.com" },
  { name: "hotels.com (sv)", host: "travel.sv.hotels.com" },
  { name: "hotels.com (th)", host: "travel.th.hotels.com" },
  { name: "hotels.com (tr)", host: "travel.tr.hotels.com" },
  { name: "hotels.com (tw)", host: "travel.tw.hotels.com" },
  { name: "hotels.com (uk)", host: "travel.uk.hotels.com" },
  { name: "hotels.com (vi)", host: "travel.vi.hotels.com" },
  { name: "hoteis.com", host: "travel.hoteis.com" },
  { name: "hoteles.com", host: "travel.hoteles.com" },
  { name: "hotels.cn", host: "travel.hotels.cn" },
  { name: "hotels.com (za)", host: "travel.za.hotels.com" },
  { name: "hotels.com (zh)", host: "travel.zh.hotels.com" },
];

const wotif = [
  { name: "wotif.com", host: "www.wotif.com" },
  { name: "wotif.co.nz", host: "www.wotif.co.nz" },
  { name: "lastminute.com.au", host: "www.lastminute.com.au" },
  { name: "lastminute.co.nz", host: "www.lastminute.co.nz" },
];

function printExpedia(title, editions) {
  const pax = (0,___WEBPACK_IMPORTED_MODULE_1__.validatePax)({
    maxPaxcount: 9,
    countInf: true,
    childAsAdult: 18,
    sepInfSeat: false,
    childMinAge: 2,
  });
  if (!pax) {
    (0,_utils__WEBPACK_IMPORTED_MODULE_3__.printNotification)("Error: Failed to validate Passengers in printExpedia");
    return;
  }
  let expediaClasses = ["coach", "premium", "business", "first"];
  let minCabin = 3;
  let ExpediaCreateUrl = function (expediaBase) {
    let segUrl = "";
    for (var i = 0; i < _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin.length; i++) {
      segUrl +=
        "&legs%5B" + i + "%5D.departureAirport=" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].orig;
      segUrl +=
        "&legs%5B" + i + "%5D.arrivalAirport=" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].dest;
      segUrl +=
        "&legs%5B" +
        i +
        "%5D.departureDate=" +
        _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].arr.year.toString() +
        "-" +
        ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].dep.month).slice(-2) +
        "-" +
        ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].dep.day).slice(-2);
      for (var j = 0; j < _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg.length; j++) {
        segUrl += (
          "&legs%5B" +
          i +
          "%5D.segments%5B" +
          j +
          "%5D=" +
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].dep.year.toString() +
          "-" +
          ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].dep.month).slice(-2) +
          "-" +
          ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].dep.day).slice(-2) +
          "-" +
          expediaClasses[
            _settings_appSettings__WEBPACK_IMPORTED_MODULE_0__["default"].cabin === "Auto" ? minCabin : (0,_settings_appSettings__WEBPACK_IMPORTED_MODULE_0__.getForcedCabin)()
          ] +
          "-" +
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].orig +
          "-" +
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].dest +
          "-" +
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].carrier +
          "-" +
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].fnr
        ).toLowerCase();

        // check the min cabin:
        if (_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].cabin < minCabin) {
          minCabin = _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].cabin;
        }
      }
    }
    // Build the URL:
    let baseUrl =
      "https://" +
      expediaBase +
      "/Flight-Search-Details?action=dl&trip=MultipleDestination";
    // Add travel class to URL:
    baseUrl +=
      "&cabinClass=" +
      expediaClasses[
        _settings_appSettings__WEBPACK_IMPORTED_MODULE_0__["default"].cabin === "Auto" ? minCabin : (0,_settings_appSettings__WEBPACK_IMPORTED_MODULE_0__.getForcedCabin)()
      ];
    // Add passenger info to URL:
    baseUrl += "&adults=" + pax.adults;
    return baseUrl + segUrl;
  };
  let container = "";
  if (editions && editions.length > 1) {
    container +=
      ' <span class="pt-hover-container">[+]<span class="pt-hover-menu-flex"><div style="margin-right: 1rem;">';
    container += editions
      .slice(1)
      .map(function (obj, i) {
        return (
          '<a href="' +
          ExpediaCreateUrl(obj.host) +
          '" target="_blank">' +
          obj.name +
          "</a>"
        );
      })
      .join("<br/>");
    container += "</div></span></span>";
  }

  return {
    url: ExpediaCreateUrl(editions[0].host),
    title,
    extra: container,
  };
}

(0,___WEBPACK_IMPORTED_MODULE_1__.register)("otas", () => printExpedia("Expedia", expedia));
(0,___WEBPACK_IMPORTED_MODULE_1__.register)("otas", () => printExpedia("CheapTickets", cheaptickets));
(0,___WEBPACK_IMPORTED_MODULE_1__.register)("otas", () => printExpedia("Ebookers", ebookers));
(0,___WEBPACK_IMPORTED_MODULE_1__.register)("otas", () => printExpedia("Hotwire", hotwire));
(0,___WEBPACK_IMPORTED_MODULE_1__.register)("otas", () => printExpedia("MrJet.se", mrjet));
(0,___WEBPACK_IMPORTED_MODULE_1__.register)("otas", () => printExpedia("Orbitz", orbitz));
(0,___WEBPACK_IMPORTED_MODULE_1__.register)("otas", () => printExpedia("Travelocity", travelocity));
(0,___WEBPACK_IMPORTED_MODULE_1__.register)("otas", () => printExpedia("Hotels.com", hotels));
(0,___WEBPACK_IMPORTED_MODULE_1__.register)("otas", () => printExpedia("Wotif", wotif));


/***/ }),

/***/ "./src/matrix5/links/otas/flighthub.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/parse/itin.ts");
/* harmony import */ var _travix__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/links/otas/travix.js");




function print() {
  // 0 = Economy; 1=Premium Economy; 2=Business; 3=First
  var cabins = ["Economy", "Economy", "Business", "First"];
  var createUrl = (edition) =>
    `https://www.flighthub.com/checkout/gdeeplink?${(0,_travix__WEBPACK_IMPORTED_MODULE_2__.buildQueryString)(
      _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.cur || "USD",
      edition.country,
      edition.lang,
      cabins,
    )}`;

  // get edition
  const url = createUrl({ lang: "en", country: "US" });
  if (!url) {
    return;
  }

  return {
    url,
    title: "FlightHub",
  };
}

(0,___WEBPACK_IMPORTED_MODULE_0__.register)("otas", print);


/***/ }),

/***/ "./src/matrix5/links/otas/hop2.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/matrix5/utils.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/parse/itin.ts");
/* harmony import */ var _settings_appSettings__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/settings/appSettings.ts");





const editions = [
  { title: "Ovago", host: "ovago.com" },
  { title: "Wowfare", host: "wowfare.com" },
];

const cabins = ["Y", "S", "C", "F"];

function print() {
  var pax = (0,___WEBPACK_IMPORTED_MODULE_0__.validatePax)({
    maxPaxcount: 9,
    countInf: false,
    childAsAdult: 12,
    sepInfSeat: false,
    childMinAge: 2,
  });
  if (!pax) {
    (0,_utils__WEBPACK_IMPORTED_MODULE_3__.printNotification)("Error: Failed to validate Passengers in printHop2");
    return;
  }

  const cabin =
    cabins[(0,_settings_appSettings__WEBPACK_IMPORTED_MODULE_2__.getCabin)(Math.min(...(0,_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.getCurrentSegs)().map((seg) => seg.cabin)))];

  const segs = (0,_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.getCurrentSegs)();
  const search = `OSKDCR*${cabin}${pax.adults}${pax.children.length}${
    pax.infSeat
  }0/${_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin
    .map(
      (itin) =>
        itin.orig +
        itin.dest +
        `${itin.dep.year}-${(0,_utils__WEBPACK_IMPORTED_MODULE_3__.to2digits)(itin.dep.month)}-${(0,_utils__WEBPACK_IMPORTED_MODULE_3__.to2digits)(
          itin.dep.day,
        )}`,
    )
    .join("/")}*${segs[segs.length - 1].carrier}~#${segs
    .map((seg) => seg.carrier + seg.fnr)
    .join("#")}`;

  const createUrl = function (host) {
    return `https://${host}/ms?key=1_${btoa(search)}`;
  };

  var url = createUrl("hop2.com");
  if (!url) return;

  let extra =
    ' <span class="pt-hover-container">[+]<span class="pt-hover-menu">';
  extra += editions
    .map(function (obj, i) {
      return (
        '<a href="' +
        createUrl(obj.host) +
        '" target="_blank">' +
        obj.title +
        "</a>"
      );
    })
    .join("<br/>");
  extra += "</span></span>";

  return {
    url,
    title: "Hop2",
    extra,
  };
}

(0,___WEBPACK_IMPORTED_MODULE_0__.register)("otas", print);


/***/ }),

/***/ "./src/matrix5/links/otas/justfly.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/parse/itin.ts");
/* harmony import */ var _travix__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/links/otas/travix.js");




function print() {
  // 0 = Economy; 1=Premium Economy; 2=Business; 3=First
  var cabins = ["Economy", "Economy", "Business", "First"];
  var createUrl = (edition) =>
    `https://www.justfly.com/checkout/gdeeplink?${(0,_travix__WEBPACK_IMPORTED_MODULE_2__.buildQueryString)(
      _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.cur || "USD",
      edition.country,
      edition.lang,
      cabins,
    )}`;

  // get edition
  const url = createUrl({ lang: "en", country: "US" });
  if (!url) {
    return;
  }

  return {
    url,
    title: "Justfly",
  };
}

(0,___WEBPACK_IMPORTED_MODULE_0__.register)("otas", print);


/***/ }),

/***/ "./src/matrix5/links/otas/lucky2go.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/parse/itin.ts");
/* harmony import */ var _travix__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/links/otas/travix.js");




const editions = [
  { lang: "pl", country: "PL" },
  { lang: "bg", country: "BG" },
  { lang: "ro", country: "RO" },
  { lang: "cs", country: "CZ" },
  { lang: "hu", country: "HU" },
  { lang: "sk", country: "SK" },
  { lang: "pt", country: "PT" },
  { lang: "es", country: "ES" },
  { lang: "en", country: "GB" },
  { lang: "en", country: "IE" },
  { lang: "en", country: "US" },
  { lang: "it", country: "IT" },
  { lang: "de", country: "DE" },
  { lang: "fr", country: "FR" },
  { lang: "el", country: "GR" },
];

function printLucky2go() {
  var cabins = ["Economy", "Economy", "Business", "First"];
  var createUrl = (edition) =>
    `https://secure.lucky2go.com/flights/options/?${(0,_travix__WEBPACK_IMPORTED_MODULE_2__.buildQueryString)(
      _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.cur || "USD",
      edition.country,
      edition.lang,
      cabins,
    )}`;

  // get edition
  var url = createUrl({ lang: "en", country: "US" });
  if (!url) {
    return;
  }
  var extra =
    ' <span class="pt-hover-container">[+]<span class="pt-hover-menu">';
  extra += editions
    .map(
      (edition) =>
        `<a href="${createUrl(edition)}" target="_blank">${
          edition.lang
        }&#8209;${edition.country}</a>`,
    )
    .join("<br/>");
  extra += "</span></span>";

  return {
    url,
    title: "lucky2go",
    extra,
  };
}

(0,___WEBPACK_IMPORTED_MODULE_0__.register)("otas", printLucky2go);


/***/ }),

/***/ "./src/matrix5/links/otas/onetravel.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _settings_appSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/settings/appSettings.ts");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/matrix5/utils.js");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/parse/itin.ts");





function print() {
  // 0 = Economy; 1=Premium Economy; 2=Business; 3=First
  var cabins = ["Economy", "PremiumEconomy", "Business", "First"];
  var coaUrl = "http://www.onetravel.com/default.aspx?tabid=3582&ulang=en";
  var pax = (0,___WEBPACK_IMPORTED_MODULE_1__.validatePax)({
    maxPaxcount: 9,
    countInf: true,
    childAsAdult: 12,
    sepInfSeat: true,
    childMinAge: 2,
  });
  if (!pax) {
    (0,_utils__WEBPACK_IMPORTED_MODULE_3__.printNotification)("Error: Failed to validate Passengers in print");
    return;
  }
  coaUrl +=
    "&ad=" +
    pax.adults +
    "&ch=" +
    pax.children.length +
    "&sr=0&is=" +
    pax.infSeat +
    "&il=" +
    pax.infLap;
  coaUrl += "&pos=US";
  coaUrl += "&dispr=" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.price;
  var seg = 0;
  var slices = {};
  for (var i = 0; i < _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin.length; i++) {
    slices[i] = "";
    for (var j = 0; j < _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg.length; j++) {
      seg++;
      if (slices[i]) slices[i] += ",";
      slices[i] += seg;

      coaUrl +=
        "&cbn" +
        seg +
        "=" +
        cabins[
          _settings_appSettings__WEBPACK_IMPORTED_MODULE_0__["default"].cabin === "Auto"
            ? _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].cabin
            : (0,_settings_appSettings__WEBPACK_IMPORTED_MODULE_0__.getForcedCabin)()
        ];
      coaUrl += "&carr" + seg + "=" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].carrier;
      coaUrl +=
        "&dd" +
        seg +
        "=" +
        _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].dep.year +
        ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].dep.month).slice(-2) +
        ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].dep.day).slice(-2);
      coaUrl += "&og" + seg + "=" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].orig;
      coaUrl += "&dt" + seg + "=" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].dest;
      coaUrl += "&fbc" + seg + "=" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].bookingclass;
      coaUrl += "&fnum" + seg + "=" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.currentItin.itin[i].seg[j].fnr;
    }
    coaUrl += "&Slice" + (i + 1) + "=" + slices[i];
  }

  coaUrl += "&tt=" + (0,_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_2__.getTripType)("OneWay", "RoundTrip", "MultiCity");

  return {
    url: coaUrl,
    title: "OneTravel",
  };
}

(0,___WEBPACK_IMPORTED_MODULE_1__.register)("otas", print);


/***/ }),

/***/ "./src/matrix5/links/otas/travix.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   buildQueryString: () => (/* binding */ buildQueryString)
/* harmony export */ });
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/matrix5/utils.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/links/index.ts");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/parse/itin.ts");
/* harmony import */ var _settings_appSettings__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/matrix5/settings/appSettings.ts");





const travix = [
  {
    name: "CheapTickets.nl",
    value: "www.cheaptickets.nl",
    pos: "NL",
    cur: "EUR",
  },
  {
    name: "CheapTickets.be",
    value: "www.cheaptickets.be",
    pos: "BE",
    cur: "EUR",
  },
  {
    name: "CheapTickets.de",
    value: "www.cheaptickets.de",
    pos: "DE",
    cur: "EUR",
  },
  {
    name: "CheapTickets.ch",
    value: "www.cheaptickets.ch",
    pos: "CH",
    cur: "CHF",
  },
  {
    name: "CheapTickets.sg",
    value: "www.cheaptickets.sg",
    pos: "SG",
    cur: "SGD",
  },
  {
    name: "CheapTickets.co.th",
    value: "www.cheaptickets.co.th",
    pos: "TH",
    cur: "THB",
  },
  {
    name: "CheapTickets.hk",
    value: "www.cheaptickets.hk",
    pos: "HK",
    cur: "HKD",
  },
  {
    name: "Vliegwinkel.nl",
    value: "www.vliegwinkel.nl",
    pos: "NL",
    cur: "EUR",
  },
  {
    name: "Vayama Argentina",
    value: "www.vayama.com/es_ar",
    pos: "AR",
    cur: "ARS",
  },
  {
    name: "Vayama Chile",
    value: "www.vayama.com/es_cl",
    pos: "CL",
    cur: "CLP",
  },
  {
    name: "Vayama Colombia",
    value: "www.vayama.com/es_co",
    pos: "CO",
    cur: "COP",
  },
  { name: "Vayama Ireland", value: "www.vayama.ie", pos: "IE", cur: "EUR" },
  {
    name: "Vayama Mexico",
    value: "www.vayama.com/es_mx",
    pos: "MX",
    cur: "MXN",
  },
  {
    name: "Vayama Panama",
    value: "www.vayama.com/es_pa",
    pos: "PA",
    cur: "USD",
  },
  {
    name: "Flugladen Austria",
    value: "www.flugladen.at",
    pos: "AT",
    cur: "EUR",
  },
  {
    name: "Flugladen Deutschland",
    value: "www.flugladen.de",
    pos: "DE",
    cur: "EUR",
  },
];

const budgetairs = [
  {
    name: "BudgetAir Australia",
    value: "www.budgetair.com/en_au",
    pos: "AU",
    cur: "AUD",
  },
  {
    name: "BudgetAir Belgium",
    value: "www.budgetair.be",
    pos: "BE",
    cur: "EUR",
  },
  {
    name: "BudgetAir Canada",
    value: "www.budgetair.com/en_ca",
    pos: "CA",
    cur: "CAD",
  },
  {
    name: "BudgetAir Denmark",
    value: "www.budgetair.dk",
    pos: "DK",
    cur: "DKK",
  },
  {
    name: "BudgetAir France",
    value: "www.budgetair.fr",
    pos: "FR",
    cur: "EUR",
  },
  { name: "BudgetAir India", value: "www.budgetair.in", pos: "IN", cur: "INR" },
  {
    name: "BudgetAir Indonesia",
    value: "www.budgetair.com/id_id",
    pos: "ID",
    cur: "IDR",
  },
  { name: "BudgetAir Italy", value: "www.budgetair.it", pos: "IT", cur: "EUR" },
  {
    name: "BudgetAir Japan",
    value: "www.budgetair.com/jp",
    pos: "JP",
    cur: "JPY",
  },
  {
    name: "BudgetAir Korea",
    value: "www.budgetair.com/ko_kr",
    pos: "KR",
    cur: "KRW",
  },
  {
    name: "BudgetAir Latvia",
    value: "www.budgetair.lv",
    pos: "LV",
    cur: "EUR",
  },
  {
    name: "BudgetAir Malaysia",
    value: "www.budgetair.com/en_my",
    pos: "MY",
    cur: "MYR",
  },
  {
    name: "BudgetAir Netherlands",
    value: "www.budgetair.nl",
    pos: "NL",
    cur: "EUR",
  },
  {
    name: "BudgetAir New Zealand",
    value: "www.budgetair.com/en_nz",
    pos: "NZ",
    cur: "NZD",
  },
  {
    name: "BudgetAir Philippines",
    value: "www.budgetair.com/en_ph",
    pos: "PH",
    cur: "PHP",
  },
  {
    name: "BudgetAir Poland",
    value: "www.budgetair.com/pl_pl",
    pos: "PL",
    cur: "PLN",
  },
  {
    name: "BudgetAir Portugal",
    value: "www.budgetair.pt",
    pos: "PT",
    cur: "EUR",
  },
  {
    name: "BudgetAir Saudi Arabia",
    value: "www.budgetair.com/en_sa",
    pos: "SA",
    cur: "SAR",
  },
  {
    name: "BudgetAir South Africa",
    value: "www.budgetair.com/en_za",
    pos: "ZA",
    cur: "ZAR",
  },
  { name: "BudgetAir Spain", value: "www.budgetair.es", pos: "ES", cur: "EUR" },
  {
    name: "BudgetAir Sweden",
    value: "www.budgetair.se",
    pos: "SE",
    cur: "SEK",
  },
  {
    name: "BudgetAir Arab Emirates",
    value: "www.budgetair.com/en_ae",
    pos: "AE",
    cur: "AED",
  },
  {
    name: "BudgetAir Taiwan",
    value: "www.budgetair.com.tw",
    pos: "TW",
    cur: "TWD",
  },
  {
    name: "BudgetAir Turkey",
    value: "www.budgetair.com/tr_tr",
    pos: "TR",
    cur: "TRY",
  },
  {
    name: "BudgetAir United Kingdom",
    value: "www.budgetair.co.uk",
    pos: "GB",
    cur: "GBP",
  },
  {
    name: "BudgetAir Vietnam",
    value: "www.budgetair.com/vn",
    pos: "VN",
    cur: "VND",
  },
];

const defaultCabins = ["Economy", "PremiumEconomy", "Business", "First"];

function buildQueryString(cur, pos = "", lang = null, cabins = null) {
  var pax = (0,___WEBPACK_IMPORTED_MODULE_0__.validatePax)({
    maxPaxcount: 9,
    countInf: true,
    childAsAdult: 12,
    sepInfSeat: false,
    childMinAge: 2,
  });
  if (!pax) {
    (0,_utils__WEBPACK_IMPORTED_MODULE_3__.printNotification)("Error: Failed to validate Passengers in edestinos");
    return;
  }

  lang = lang || "en";
  cabins = cabins || defaultCabins;

  let url = `PointOfSaleCountry=${pos}&UserCurrency=${cur}&DisplayedPrice=${
    _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.price
  }&DisplayedPriceCurrency=${cur}&UserLanguage=${lang}&TripType=${(0,_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.getTripType)(
    "OneWay",
    "RoundTrip",
    "MultiCity",
  )}`;
  url += "&Adult=" + pax.adults;
  url += "&Child=" + pax.children.length;
  url += "&InfantLap=" + pax.infLap;

  let j = 0;
  _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin.forEach((itin, i) => {
    const slices = [];

    itin.seg.forEach((seg) => {
      j++;
      slices.push(j);

      url += `&Cabin${j}=` + cabins[(0,_settings_appSettings__WEBPACK_IMPORTED_MODULE_2__.getCabin)(seg.cabin)];
      url += `&Carrier${j}=` + seg.carrier;
      url += `&Origin${j}=` + seg.orig;
      url += `&Destination${j}=` + seg.dest;
      url += `&BookingCode${j}=` + seg.bookingclass;
      url += `&FlightNumber${j}=` + seg.fnr;
      url += `&DepartureDate${j}=${seg.dep.year}-${(0,_utils__WEBPACK_IMPORTED_MODULE_3__.to2digits)(
        seg.dep.month,
      )}-${(0,_utils__WEBPACK_IMPORTED_MODULE_3__.to2digits)(seg.dep.day)}`;
      url += `&FareBasis${j}=` + seg.farebase;
    });

    url += `&Slice${i + 1}=` + slices.join(",");
  });

  return url;
}

function print(displayName, editions, startValue) {
  var createUrl = (host, cur, pos) =>
    `https://${host}/checkout/googleflights?${buildQueryString(cur, pos)}`;

  var startEdition = editions.find((e) => e.value === startValue);
  var url = createUrl(startEdition.value, startEdition.pos, startEdition.cur);
  var extra =
    ' <span class="pt-hover-container">[+]<span class="pt-hover-menu">';
  extra += editions
    .map(function (obj, i) {
      return (
        '<a href="' +
        createUrl(obj.value, obj.cur, obj.pos) +
        '" target="_blank">' +
        obj.name +
        "</a>"
      );
    })
    .join("<br/>");
  extra += "</span></span>";

  return {
    url,
    title: displayName,
    extra,
  };
}

(0,___WEBPACK_IMPORTED_MODULE_0__.register)("otas", () => print("Vayama", travix, "www.vayama.ie"));
(0,___WEBPACK_IMPORTED_MODULE_0__.register)("otas", () => print("BudgetAir", budgetairs, "www.budgetair.nl"));


/***/ }),

/***/ "./src/matrix5/links/other/gcm.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/parse/itin.ts");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/links/index.ts");



function printGCM() {
  let url = "";
  // Build multi-city search based on segments
  // Keeping continous path as long as possible
  for (let i = 0; i < _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_0__.currentItin.itin.length; i++) {
    for (let j = 0; j < _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_0__.currentItin.itin[i].seg.length; j++) {
      url += _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_0__.currentItin.itin[i].seg[j].orig + "-";
      if (j + 1 < _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_0__.currentItin.itin[i].seg.length) {
        if (
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_0__.currentItin.itin[i].seg[j].dest != _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_0__.currentItin.itin[i].seg[j + 1].orig
        ) {
          url += _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_0__.currentItin.itin[i].seg[j].dest + ";";
        }
      } else {
        url += _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_0__.currentItin.itin[i].seg[j].dest + ";";
      }
    }
  }

  return {
    img: "http://www.gcmap.com/map?MR=900&MX=182x182&PM=*&P=" + url,
    url: "http://www.gcmap.com/mapui?P=" + url,
    title: "GCM",
  };
}

(0,___WEBPACK_IMPORTED_MODULE_1__.register)("other", printGCM);


/***/ }),

/***/ "./src/matrix5/links/other/wheretocredit.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/parse/itin.ts");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/links/index.ts");



function printWheretocredit() {
  return {
    url:
      "https://www.wheretocredit.com/calculator#" +
      (0,_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_0__.getCurrentSegs)()
        .map((seg) =>
          [seg.orig, seg.dest, seg.carrier, seg.bookingclass].join("-"),
        )
        .join("/"),
    title: "Where to Credit",
  };
}

(0,___WEBPACK_IMPORTED_MODULE_1__.register)("other", printWheretocredit);


/***/ }),

/***/ "./src/matrix5/links sync recursive .[jt]s$":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var map = {
	"./airlines/aa.js": "./src/matrix5/links/airlines/aa.js",
	"./airlines/aaSabre.js": "./src/matrix5/links/airlines/aaSabre.js",
	"./airlines/ac.js": "./src/matrix5/links/airlines/ac.js",
	"./airlines/af.js": "./src/matrix5/links/airlines/af.js",
	"./airlines/as.js": "./src/matrix5/links/airlines/as.js",
	"./airlines/az.js": "./src/matrix5/links/airlines/az.js",
	"./airlines/ba.js": "./src/matrix5/links/airlines/ba.js",
	"./airlines/cz.js": "./src/matrix5/links/airlines/cz.js",
	"./airlines/dl.js": "./src/matrix5/links/airlines/dl.js",
	"./airlines/ek.js": "./src/matrix5/links/airlines/ek.js",
	"./airlines/ey.js": "./src/matrix5/links/airlines/ey.js",
	"./airlines/ib.js": "./src/matrix5/links/airlines/ib.js",
	"./airlines/kl.js": "./src/matrix5/links/airlines/kl.js",
	"./airlines/la.js": "./src/matrix5/links/airlines/la.js",
	"./airlines/lh.js": "./src/matrix5/links/airlines/lh.js",
	"./airlines/lx.js": "./src/matrix5/links/airlines/lx.js",
	"./airlines/oa.js": "./src/matrix5/links/airlines/oa.js",
	"./airlines/os.js": "./src/matrix5/links/airlines/os.js",
	"./airlines/ps.js": "./src/matrix5/links/airlines/ps.js",
	"./airlines/qf.js": "./src/matrix5/links/airlines/qf.js",
	"./airlines/qr.js": "./src/matrix5/links/airlines/qr.js",
	"./airlines/sn.js": "./src/matrix5/links/airlines/sn.js",
	"./airlines/tk.js": "./src/matrix5/links/airlines/tk.js",
	"./airlines/vs.js": "./src/matrix5/links/airlines/vs.js",
	"./index.ts": "./src/matrix5/links/index.ts",
	"./meta/jetcost.js": "./src/matrix5/links/meta/jetcost.js",
	"./meta/kayak.js": "./src/matrix5/links/meta/kayak.js",
	"./meta/momondo.js": "./src/matrix5/links/meta/momondo.js",
	"./meta/skyscanner.js": "./src/matrix5/links/meta/skyscanner.js",
	"./meta/tripadvisor.js": "./src/matrix5/links/meta/tripadvisor.js",
	"./otas/agoda.js": "./src/matrix5/links/otas/agoda.js",
	"./otas/cheapoair.js": "./src/matrix5/links/otas/cheapoair.js",
	"./otas/edestinos.js": "./src/matrix5/links/otas/edestinos.js",
	"./otas/edreams.js": "./src/matrix5/links/otas/edreams.js",
	"./otas/etraveli.js": "./src/matrix5/links/otas/etraveli.js",
	"./otas/expedia.js": "./src/matrix5/links/otas/expedia.js",
	"./otas/flighthub.js": "./src/matrix5/links/otas/flighthub.js",
	"./otas/hop2.js": "./src/matrix5/links/otas/hop2.js",
	"./otas/justfly.js": "./src/matrix5/links/otas/justfly.js",
	"./otas/lucky2go.js": "./src/matrix5/links/otas/lucky2go.js",
	"./otas/onetravel.js": "./src/matrix5/links/otas/onetravel.js",
	"./otas/priceline.ts": "./src/matrix5/links/otas/priceline.ts",
	"./otas/travix.js": "./src/matrix5/links/otas/travix.js",
	"./other/gcm.js": "./src/matrix5/links/other/gcm.js",
	"./other/wheretocredit.js": "./src/matrix5/links/other/wheretocredit.js"
};


function webpackContext(req) {
	var id = webpackContextResolve(req);
	return __webpack_require__(id);
}
function webpackContextResolve(req) {
	if(!__webpack_require__.o(map, req)) {
		var e = new Error("Cannot find module '" + req + "'");
		e.code = 'MODULE_NOT_FOUND';
		throw e;
	}
	return map[req];
}
webpackContext.keys = function webpackContextKeys() {
	return Object.keys(map);
};
webpackContext.resolve = webpackContextResolve;
module.exports = webpackContext;
webpackContext.id = "./src/matrix5/links sync recursive .[jt]s$";

/***/ }),

/***/ "./src/matrix5/print/amadeus.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getAmadeusPax: () => (/* binding */ getAmadeusPax),
/* harmony export */   getAmadeusTriptype: () => (/* binding */ getAmadeusTriptype),
/* harmony export */   getAmadeusUrl: () => (/* binding */ getAmadeusUrl)
/* harmony export */ });
/* harmony import */ var _settings_appSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/settings/appSettings.ts");
/* harmony import */ var _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/matrix5/parse/itin.ts");



// **** START AMADEUS ****
function getAmadeusUrl(config) {
  config = config || {
    sepcabin: 1,
    detailed: 0,
    inctimes: 1,
    enablesegskip: 1,
    allowpremium: 1,
  };
  config.sepcabin = config.sepcabin === undefined ? 1 : config.sepcabin;
  config.detailed = config.detailed === undefined ? 0 : config.detailed;
  config.inctimes = config.inctimes === undefined ? 1 : config.inctimes;
  config.enablesegskip =
    config.enablesegskip === undefined ? 1 : config.enablesegskip;
  config.allowpremium =
    config.allowpremium === undefined ? 1 : config.allowpremium;
  var curleg = 0;
  var lastcabin = 0;
  var curseg = 0;
  var lastdest = "";
  var maxcabin = 0;
  var url = "";
  var lastarrtime = "";
  var cabins = ["E", "N", "B", "F"];
  cabins[1] = config.allowpremium != 1 ? cabins[0] : cabins[1];
  //Build multi-city search based on legs
  for (var i = 0; i < _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin.length; i++) {
    curseg = 3; // need to toggle segskip on first leg
    lastcabin = _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[0].cabin;
    // walks each leg
    for (var j = 0; j < _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg.length; j++) {
      //walks each segment of leg
      var k = 0;
      // lets have a look if we need to skip segments - Flightnumber has to be the same and it must be just a layover
      while (j + k < _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg.length - 1) {
        if (
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j + k].fnr !=
            _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j + k + 1].fnr ||
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j + k].layoverduration >= 1440 ||
          config.enablesegskip == 0
        )
          break;
        k++;
      }
      curseg++;
      if (
        curseg > 3 ||
        (_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j].cabin != lastcabin && config.sepcabin == 1)
      ) {
        if (lastdest != "") {
          //close prior flight
          url += "&E_LOCATION_" + curleg + "=" + lastdest;
          url += "&E_DATE_" + curleg + "=" + lastarrtime;
        }
        curseg = 1;
        curleg++;
        url += "&B_LOCATION_" + curleg + "=" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j].orig;
        url += "&B_ANY_TIME_" + curleg + "=FALSE";
        url +=
          "&B_DATE_" +
          curleg +
          "=" +
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j].dep.year +
          ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j].dep.month).slice(-2) +
          ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j].dep.day).slice(-2) +
          (config.inctimes == 1
            ? (
                "0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j].dep.time24.replace(":", "")
              ).slice(-4)
            : "0000");
        url +=
          "&CABIN_" + curleg + "=" + cabins[_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j].cabin];
        url += "&ALLOW_ALTERNATE_AVAILABILITY_" + curleg + "=FALSE";
        url += "&DATE_RANGE_VALUE_" + curleg + "=0";
      }
      lastarrtime =
        _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j + k].arr.year +
        ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j + k].arr.month).slice(-2) +
        ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j + k].arr.day).slice(-2) +
        (config.inctimes == 1
          ? (
              "0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j + k].arr.time24.replace(":", "")
            ).slice(-4)
          : "0000");
      if (config.detailed === 1) {
        url +=
          "&B_LOCATION_" +
          curleg +
          "_" +
          curseg +
          "=" +
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j].orig;
        url +=
          "&B_LOCATION_CITY_" +
          curleg +
          "_" +
          curseg +
          "=" +
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j].orig;
        url +=
          "&B_DATE_" +
          curleg +
          "_" +
          curseg +
          "=" +
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j].dep.year +
          ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j].dep.month).slice(-2) +
          ("0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j].dep.day).slice(-2) +
          (config.inctimes == 1
            ? (
                "0" + _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j].dep.time24.replace(":", "")
              ).slice(-4)
            : "0000");
        url +=
          "&E_LOCATION_" +
          curleg +
          "_" +
          curseg +
          "=" +
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j + k].dest;
        url +=
          "&E_LOCATION_CITY_" +
          curleg +
          "_" +
          curseg +
          "=" +
          _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j + k].dest;
        url += "&E_DATE_" + curleg + "_" + curseg + "=" + lastarrtime;
      }
      url +=
        "&AIRLINE_" +
        curleg +
        "_" +
        curseg +
        "=" +
        _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j].carrier;
      url +=
        "&FLIGHT_NUMBER_" +
        curleg +
        "_" +
        curseg +
        "=" +
        _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j].fnr;
      url +=
        "&RBD_" +
        curleg +
        "_" +
        curseg +
        "=" +
        _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j].bookingclass;
      url +=
        "&FARE_CLASS_" +
        curleg +
        "_" +
        curseg +
        "=" +
        _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j].farebase;
      lastdest = _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j + k].dest;
      lastcabin = _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j].cabin;
      if (_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j].cabin > maxcabin)
        maxcabin = _matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.currentItin.itin[i].seg[j].cabin;
      j += k;
    }
  }
  url += "&E_LOCATION_" + curleg + "=" + lastdest; // push final dest
  url += "&E_DATE_" + curleg + "=" + lastarrtime; // push arr time
  url +=
    "&CABIN=" +
    cabins[_settings_appSettings__WEBPACK_IMPORTED_MODULE_0__["default"].cabin === "Auto" ? maxcabin : (0,_settings_appSettings__WEBPACK_IMPORTED_MODULE_0__.getForcedCabin)()] +
    ""; // push cabin
  return url;
}

function getAmadeusPax(pax, config) {
  config = config || {
    allowinf: 1,
    youthage: 0,
  };
  config.allowinf = config.allowinf === undefined ? 1 : config.allowinf;
  config.youthage = config.sepyouth === undefined ? 0 : config.sepyouth;
  var tmpPax = { c: 0, y: 0 };
  var curPax = 1;
  var url = "&IS_PRIMARY_TRAVELLER_1=True";
  for (let i = 0; i < pax.children.length; i++) {
    if (pax.children[i] >= config.youthage && config.youthage > 0) {
      tmpPax.y++;
    } else if (pax.children[i] >= 12) {
      pax.adults++;
    } else {
      tmpPax.c++;
    }
  }
  for (let i = 0; i < pax.adults; i++) {
    url += "&TRAVELLER_TYPE_" + curPax + "=ADT";
    url +=
      "&HAS_INFANT_" +
      curPax +
      "=" +
      (i < pax.infLap && config.allowinf == 1 ? "True" : "False");
    url += "&IS_YOUTH_" + curPax + "=False";
    curPax++;
  }
  for (let i = 0; i < tmpPax.y; i++) {
    url += "&TRAVELLER_TYPE_" + curPax + "=ADT";
    url += "&HAS_INFANT_" + curPax + "=False";
    url += "&IS_YOUTH_" + curPax + "=True";
    curPax++;
  }
  for (let i = 0; i < tmpPax.c; i++) {
    url += "&TRAVELLER_TYPE_" + curPax + "=CHD";
    url += "&HAS_INFANT_" + curPax + "=False";
    url += "&IS_YOUTH_" + curPax + "=False";
    curPax++;
  }
  return {
    url: url,
    adults: pax.adults,
    youth: tmpPax.y,
    children: tmpPax.c,
    infants: pax.infLap,
  };
}

function getAmadeusTriptype() {
  return (0,_matrix5_parse_itin__WEBPACK_IMPORTED_MODULE_1__.getTripType)("O", "R", "M");
}
// **** END AMADEUS ****


/***/ }),

/***/ "./src/matrix5/settings/paxSettings.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
// initialize local storage for passenger details
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  adults: 1,
  infantsLap: 0,
  infantsSeat: 0,
  cAges: new Array(),
});


/***/ }),

/***/ "./src/matrix5/settings/userSettings.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   loadUserSettings: () => (/* binding */ loadUserSettings),
/* harmony export */   registerSetting: () => (/* binding */ registerSetting),
/* harmony export */   registeredSettings: () => (/* binding */ registeredSettings),
/* harmony export */   saveUserSettings: () => (/* binding */ saveUserSettings)
/* harmony export */ });
/* harmony import */ var _appSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/matrix5/settings/appSettings.ts");


const defaultSettings = {
  linkFontsize: 100, // fontsize of links - valid: 50-200
  showAllAirlines: 0, // shows all airline links regardless of search results
  enableIMGautoload: 0, // enables images to auto load - valid: 0 / 1
  enableAffiliates: 1,
};

const registeredSettings = {};

/**
 * Registers a link
 * @param {string} name
 * @param {string} id
 * @param {{ name: string, value: string }[]} values
 * @param {string} defaultValue
 */
function registerSetting(name, id, values, defaultValue) {
  registeredSettings[id] = { name, values };
  defaultSettings[id] = defaultValue;
}

async function saveUserSettings(settings = defaultSettings) {
  if (_appSettings__WEBPACK_IMPORTED_MODULE_0__["default"].isUserscript)
    await GM.setValue("mptUserSettings", JSON.stringify(settings));
  else localStorage.setItem("mptUserSettings", JSON.stringify(settings));
}

async function loadUserSettings() {
  let gmSavedUserSettings;
  if (_appSettings__WEBPACK_IMPORTED_MODULE_0__["default"].isUserscript)
    gmSavedUserSettings = await GM.getValue("mptUserSettings");
  else gmSavedUserSettings = localStorage.getItem("mptUserSettings");

  if (!gmSavedUserSettings || typeof gmSavedUserSettings !== "string") return;

  /** @type typeof defaultSettings */
  const savedUserSettings = JSON.parse(gmSavedUserSettings);
  if (!savedUserSettings) return;

  Object.assign(defaultSettings, savedUserSettings);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (defaultSettings);


/***/ }),

/***/ "./src/matrix5/utils.js":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   findtarget: () => (/* binding */ findtarget),
/* harmony export */   findtargets: () => (/* binding */ findtargets),
/* harmony export */   getRandomInt: () => (/* binding */ getRandomInt),
/* harmony export */   monthnumberToName: () => (/* binding */ monthnumberToName),
/* harmony export */   printNotification: () => (/* binding */ printNotification),
/* harmony export */   to2digits: () => (/* binding */ to2digits),
/* harmony export */   to4digitTime: () => (/* binding */ to4digitTime),
/* harmony export */   to4digits: () => (/* binding */ to4digits),
/* harmony export */   toTitleCase: () => (/* binding */ toTitleCase),
/* harmony export */   toUrlSafeBase64: () => (/* binding */ toUrlSafeBase64),
/* harmony export */   toggleVis: () => (/* binding */ toggleVis),
/* harmony export */   uuidv4: () => (/* binding */ uuidv4)
/* harmony export */ });
/* unused harmony exports hasClass, clearNotification, exRE, padChars, monthnameToNumber, toDate, dayDiff */
function findtarget(className, nth) {
  return document.getElementsByClassName(className)[(nth || 1) - 1];
}

function findtargets(className) {
  return Array.from(document.getElementsByClassName(className));
}

function hasClass(element, className) {
  return element.classList.contains(className);
}

function toggleVis(target, blockType = "block") {
  if (hasClass(target, "vis")) {
    target.setAttribute("class", "invis");
    target.style.display = "none";
  } else {
    target.setAttribute("class", "vis");
    target.style.display = blockType;
  }
}

function clearNotification() {
  var target = document.getElementById("mtpNotification");
  target.innerHTML = "";
}

function printNotification(text) {
  // log the text to the browser's developer console:
  console.log(text);
  // display for user:
  var target = document.getElementById("mtpNotification");
  if (target === null) {
    //alert("mtp Error: Notification container not Found");
    console.log("mtp Error: Notification container not Found");
  } else {
    //possibility to print multiple notifications
    var temp = document.createElement("div");
    temp.appendChild(document.createTextNode(text));
    target.appendChild(temp);
  }
}

//Parses all of the outputs of regexp matches into an array
function exRE(str, re) {
  var ret = new Array();
  var m;
  var i = 0;
  while ((m = re.exec(str)) != null) {
    if (m.index === re.lastIndex) {
      re.lastIndex++;
    }
    for (let k = 1; k < m.length; k++) {
      ret[i++] = m[k];
    }
  }
  return ret;
}

function padChars(str, chars) {
  return (chars + str).slice(chars.length * -1);
}

function to2digits(str) {
  return padChars(str, "00");
}

function to4digits(str) {
  return padChars(str, "0000");
}

function to4digitTime(time) {
  return to4digits(time.replace(":", ""));
}

function uuidv4() {
  return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function (c) {
    var r = (Math.random() * 16) | 0,
      v = c == "x" ? r : (r & 0x3) | 0x8;
    return v.toString(16);
  });
}

function getRandomInt(max) {
  return Math.floor(Math.random() * max);
}

function toUrlSafeBase64(base64) {
  return base64
    .replace(/\+/g, "-") // Convert '+' to '-'
    .replace(/\//g, "_") // Convert '/' to '_'
    .replace(/=+$/, ""); // Remove ending '='
}

const monthnames = [
  "JAN",
  "FEB",
  "MAR",
  "APR",
  "MAY",
  "JUN",
  "JUL",
  "AUG",
  "SEP",
  "OCT",
  "NOV",
  "DEC",
];

function monthnumberToName(month) {
  return monthnames[month - 1];
}

function monthnameToNumber(month) {
  return monthnames.indexOf(month.toUpperCase()) + 1;
}

/** @param {{ day: number; month: number; year: number; }} dateLike */
function toDate(dateLike) {
  return new Date(dateLike.year, dateLike.month, dateLike.day);
}

/** @param {Date} startDate */
/** @param {Date} endDate */
function dayDiff(startDate, endDate) {
  return Math.floor((endDate.getTime() - startDate.getTime()) / 86400000);
}

function toTitleCase(str) {
  return str.replace(/\w\S*/g, function (txt) {
    return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();
  });
}


/***/ }),

/***/ "./node_modules/date-fns/node_modules/@babel/runtime/helpers/interopRequireDefault.js":
/***/ ((module) => {

function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : {
    "default": obj
  };
}
module.exports = _interopRequireDefault, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
(() => {
__webpack_require__("./src/matrix5/index.ts");

})();

/******/ })()
;