# Code of conduct for open source projects in Equinor

In Equinor, [how we deliver is as important as what we deliver](https://www.equinor.com/en/careers/our-culture.html).

This principle applies to all work done in projects maintained by Equinor, as well as for any contributions by Equinor to other projects within the open-source community.

## Open, Collaborative, Courageous, Caring

As a values-based organization, our code of conduct for open-source projects is simply a reflection of our values, and how we live up to them as teams and as individuals.

This sets the expectations for how we collaborate in our open-source projects, which apply to all community members and participants of any project maintained by Equinor.

In addition to any definition or interpretation of the open source code of conduct, the company wide [Equinor code of conduct](https://www.equinor.com/content/dam/statoil/documents/ethics/equinor-code-of-conduct.pdf) always applies to all employees and hired contractors.

# Handling issues within the communities

If at any point concerns are raised that a group or member is not acting according to our values, the behaviour in question should cease, be discussed, and tried to be resolved.

We expect everyone to have a low threshold for raising issues, or in general discuss how we live up to our values.
Equally, we encourage all community members to appreciate when concerns are raised and do their best to solve them.

Project maintainers are responsible both for *what* is delivered, as well as *how* it is delivered.
This includes creating an environment for proper handling of issues raised within the communities.

# Reach out for assistance

For any problem not directly resolvable within the community, we encourage you to reach out for assistance.
An outsider’s perspective might be just what is needed for you to proceed.

Send an e-mail to opensource_at_equinor.com and invite for a discussion.
The e-mail will be handled by a team within the Equinor organization.

# Reporting an issue

For reporting direct violations of the code of conduct, or failed attempts at solving conflicts within the community, send a description of the issue to opensource_at_equinor.com.

To encourage members of the community to file reports, all reports are kept confidential unless you choose to disclose it yourself.

Consequences of violations reflect the severity of the issue, and/or repeated failure to take action following mandated decisions.

For projects maintained by Equinor, only the Equinor open-source team has the mandate to take corrective actions against individuals that have violated the code of conduct.
These decisions are never made within each project alone.
As a last resort, a potential consequence may be the exclusion from participation in that particular community.

# Ethics helpline

In Equinor, we want you to speak up whenever you see unethical behaviour that conflicts with our values or threatens our reputation.

To underline this, we continuously encourage and remind our employees and any external third parties interacting with us to raise concerns or report any suspected or potential breaches of law or company policies.

For any questions or issues that one suspect falls outside the scope of behaviour regulated, and handled within the open source code of conduct, or you wish to place an anonymous, confidential report we encourage to use the [Equinor Ethics helpline](https://secure.ethicspoint.eu/domain/media/en/gui/102166/index.html).

This helpline is hosted by a third party helpline provider.
