/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc.finitevolumeboundary.fluidboundarysystem.fluidboundarysystemreactive;

import neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc.FluidBoundaryInterface;
import neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc.finitevolumeboundary.fluidboundarynode.fluidboundaryreactivenode.FluidBoundaryNodeReactive;
import neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc.finitevolumeboundary.fluidboundarysystem.FluidBoundarySystem;
import neqsim.fluidmechanics.flownode.twophasenode.twophasepipeflownode.StratifiedFlowNode;
import neqsim.fluidmechanics.geometrydefinitions.pipe.PipeData;
import neqsim.thermo.system.SystemFurstElectrolyteEos;
import neqsim.util.ExcludeFromJacocoGeneratedReport;

public class FluidBoundarySystemReactive
extends FluidBoundarySystem {
    public FluidBoundarySystemReactive() {
    }

    public FluidBoundarySystemReactive(FluidBoundaryInterface boundary) {
        super(boundary);
        this.reactive = true;
    }

    @Override
    public void createSystem() {
        this.nodes = new FluidBoundaryNodeReactive[this.numberOfNodes];
        super.createSystem();
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.nodes[i] = new FluidBoundaryNodeReactive(this.boundary.getInterphaseSystem());
        }
        System.out.println("system created...");
    }

    @ExcludeFromJacocoGeneratedReport
    public static void main(String[] args) {
        SystemFurstElectrolyteEos testSystem = new SystemFurstElectrolyteEos(275.3, 1.01325);
        PipeData pipe1 = new PipeData(10.0, 0.025);
        testSystem.addComponent("methane", 0.061152181, 0);
        testSystem.addComponent("water", 0.1862204876, 1);
        testSystem.chemicalReactionInit();
        testSystem.setMixingRule(2);
        testSystem.init_x_y();
        StratifiedFlowNode test = new StratifiedFlowNode(testSystem, pipe1);
        test.setInterphaseModelType(10);
        test.initFlowCalc();
        test.calcFluxes();
        test.getFluidBoundary().setEnhancementType(0);
        test.calcFluxes();
    }
}

