/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidmechanics.flownode.onephasenode;

import neqsim.fluidmechanics.flownode.FlowNode;
import neqsim.fluidmechanics.geometrydefinitions.GeometryDefinitionInterface;
import neqsim.thermo.system.SystemInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class onePhaseFlowNode
extends FlowNode {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(onePhaseFlowNode.class);

    public onePhaseFlowNode() {
    }

    public onePhaseFlowNode(SystemInterface system) {
    }

    public onePhaseFlowNode(SystemInterface system, GeometryDefinitionInterface pipe) {
        super(system, pipe);
    }

    @Override
    public onePhaseFlowNode clone() {
        onePhaseFlowNode clonedSystem = null;
        try {
            clonedSystem = (onePhaseFlowNode)super.clone();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        return clonedSystem;
    }

    @Override
    public void increaseMolarRate(double moles) {
        for (int i = 0; i < this.getBulkSystem().getPhases()[0].getNumberOfComponents(); ++i) {
            double diff = this.getBulkSystem().getPhases()[0].getComponent(i).getx() * (this.molarFlowRate[0] - this.getBulkSystem().getPhases()[0].getNumberOfMolesInPhase());
            this.getBulkSystem().addComponent(this.getBulkSystem().getPhase(0).getComponent(i).getComponentName(), diff);
        }
        this.getBulkSystem().init_x_y();
        this.initFlowCalc();
    }

    @Override
    public void initFlowCalc() {
        this.initBulkSystem();
        this.molarFlowRate[0] = this.getBulkSystem().getPhases()[0].getNumberOfMolesInPhase();
        this.massFlowRate[0] = this.molarFlowRate[0] * this.getBulkSystem().getPhases()[0].getMolarMass();
        this.volumetricFlowRate[0] = this.massFlowRate[0] / this.getBulkSystem().getPhases()[0].getPhysicalProperties().getDensity();
        this.superficialVelocity[0] = this.volumetricFlowRate[0] / this.pipe.getArea();
        this.velocity[0] = this.superficialVelocity[0];
        this.init();
    }

    @Override
    public void updateMolarFlow() {
        for (int i = 0; i < this.getBulkSystem().getPhases()[0].getNumberOfComponents(); ++i) {
            double diff = this.getBulkSystem().getPhases()[0].getComponent(i).getx() * (this.molarFlowRate[0] - this.getBulkSystem().getPhases()[0].getNumberOfMolesInPhase());
            this.getBulkSystem().addComponent(this.getBulkSystem().getPhase(0).getComponent(i).getComponentName(), diff);
        }
        this.getBulkSystem().init_x_y();
        this.getBulkSystem().init(3);
    }

    public double calcReynoldsNumber() {
        this.reynoldsNumber[0] = this.getVelocity() * this.pipe.getDiameter() / this.getBulkSystem().getPhases()[0].getPhysicalProperties().getKinematicViscosity();
        return this.reynoldsNumber[0];
    }

    @Override
    public void init() {
        super.init();
        this.massFlowRate[0] = this.velocity[0] * this.getBulkSystem().getPhases()[0].getPhysicalProperties().getDensity() * this.pipe.getArea();
        this.superficialVelocity[0] = this.velocity[0];
        this.molarFlowRate[0] = this.massFlowRate[0] / this.getBulkSystem().getPhases()[0].getMolarMass();
        this.volumetricFlowRate[0] = this.superficialVelocity[0] * this.pipe.getArea();
        this.updateMolarFlow();
        this.calcReynoldsNumber();
        this.wallFrictionFactor[0] = this.specifiedFrictionFactor[0] == null ? this.interphaseTransportCoefficient.calcWallFrictionFactor(this) : this.specifiedFrictionFactor[0].doubleValue();
    }
}

