/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidmechanics.flownode.twophasenode.twophasestirredcellnode;

import neqsim.fluidmechanics.flownode.FlowNodeInterface;
import neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc.nonequilibriumfluidboundary.filmmodelboundary.KrishnaStandartFilmModel;
import neqsim.fluidmechanics.flownode.fluidboundary.interphasetransportcoefficient.interphasetwophase.stirredcell.InterphaseStirredCellFlow;
import neqsim.fluidmechanics.flownode.twophasenode.TwoPhaseFlowNode;
import neqsim.fluidmechanics.geometrydefinitions.GeometryDefinitionInterface;
import neqsim.fluidmechanics.geometrydefinitions.stirredcell.StirredCell;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkCPAstatoil;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StirredCellNode
extends TwoPhaseFlowNode {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(StirredCellNode.class);
    private double[] stirrerRate = new double[]{1.0, 1.0};
    private double[] stirrerDiameter = new double[]{1.0, 1.0};
    private double dt = 1.0;

    public StirredCellNode() {
        this.flowNodeType = "stirred cell";
    }

    public StirredCellNode(SystemInterface system, GeometryDefinitionInterface pipe) {
        super(system, pipe);
        this.flowNodeType = "stirred cell";
        this.interphaseTransportCoefficient = new InterphaseStirredCellFlow(this);
        this.fluidBoundary = new KrishnaStandartFilmModel(this);
    }

    public StirredCellNode(SystemInterface system, SystemInterface interphaseSystem, GeometryDefinitionInterface pipe) {
        super(system, pipe);
        this.flowNodeType = "stirred cell";
        this.interphaseTransportCoefficient = new InterphaseStirredCellFlow(this);
        this.fluidBoundary = new KrishnaStandartFilmModel(this);
    }

    @Override
    public double calcHydraulicDiameter() {
        return this.getGeometry().getDiameter();
    }

    @Override
    public double calcReynoldNumber() {
        this.reynoldsNumber[1] = Math.pow(this.stirrerDiameter[1], 2.0) * this.stirrerRate[1] * this.bulkSystem.getPhases()[1].getPhysicalProperties().getDensity() / this.bulkSystem.getPhases()[1].getPhysicalProperties().getViscosity();
        this.reynoldsNumber[0] = Math.pow(this.stirrerDiameter[0], 2.0) * this.stirrerRate[0] * this.bulkSystem.getPhases()[0].getPhysicalProperties().getDensity() / this.bulkSystem.getPhases()[0].getPhysicalProperties().getViscosity();
        return this.reynoldsNumber[1];
    }

    @Override
    public StirredCellNode clone() {
        StirredCellNode clonedSystem = null;
        try {
            clonedSystem = (StirredCellNode)super.clone();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        return clonedSystem;
    }

    @Override
    public void init() {
        this.calcContactLength();
        super.init();
    }

    @Override
    public void initFlowCalc() {
        this.init();
    }

    @Override
    public double calcContactLength() {
        this.wallContactLength[1] = 1.0;
        this.wallContactLength[0] = 1.0;
        this.interphaseContactLength[0] = 3.14159265 * Math.pow(this.pipe.getDiameter(), 2.0) / 4.0;
        this.interphaseContactLength[1] = this.interphaseContactLength[0];
        this.interphaseContactArea = this.interphaseContactLength[0];
        return this.wallContactLength[0];
    }

    @Override
    public double calcGasLiquidContactArea() {
        return 3.14159265 * Math.pow(this.pipe.getDiameter(), 2.0) / 4.0;
    }

    @Override
    public void update() {
        for (int componentNumber = 0; componentNumber < this.getBulkSystem().getPhases()[0].getNumberOfComponents(); ++componentNumber) {
            double liquidMolarRate = this.getFluidBoundary().getInterphaseMolarFlux(componentNumber) * this.getInterphaseContactArea() * this.getDt();
            double gasMolarRate = -this.getFluidBoundary().getInterphaseMolarFlux(componentNumber) * this.getInterphaseContactArea() * this.getDt();
            this.getBulkSystem().getPhases()[0].addMoles(componentNumber, gasMolarRate);
            this.getBulkSystem().getPhases()[1].addMoles(componentNumber, liquidMolarRate);
        }
        this.getBulkSystem().init_x_y();
        this.getBulkSystem().init(1);
        if (this.bulkSystem.isChemicalSystem()) {
            this.getOperations().chemicalEquilibrium();
        }
        this.getBulkSystem().init(1);
    }

    @Override
    public FlowNodeInterface getNextNode() {
        StirredCellNode newNode = this.clone();
        for (int i = 0; i < this.getBulkSystem().getPhases()[0].getNumberOfComponents(); ++i) {
        }
        return newNode;
    }

    public double getStirrerRate(int i) {
        return this.stirrerRate[i];
    }

    public void setStirrerSpeed(int i, double stirrerRate) {
        this.stirrerRate[i] = stirrerRate;
    }

    public void setStirrerSpeed(double stirrerRate) {
        this.stirrerRate[0] = stirrerRate;
        this.stirrerRate[1] = stirrerRate;
    }

    public double getDt() {
        return this.dt;
    }

    public void setDt(double dt) {
        this.dt = dt;
    }

    @ExcludeFromJacocoGeneratedReport
    public static void main(String[] args) {
        SystemSrkCPAstatoil testSystem = new SystemSrkCPAstatoil(313.3, 70.01325);
        ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
        StirredCell pipe1 = new StirredCell(2.0, 0.05);
        testSystem.addComponent("methane", 0.1061152181, "MSm3/hr", 0);
        testSystem.addComponent("water", 10.206862204876, "kg/min", 0);
        testSystem.addComponent("methanol", 1011.206862204876, "kg/min", 1);
        testSystem.createDatabase(true);
        testSystem.setMixingRule(10);
        testSystem.initPhysicalProperties();
        StirredCellNode test = new StirredCellNode(testSystem, pipe1);
        test.setInterphaseModelType(1);
        test.getFluidBoundary().useFiniteFluxCorrection(true);
        test.getFluidBoundary().useThermodynamicCorrections(true);
        test.setStirrerSpeed(0.16666666666666666);
        test.setStirrerDiameter(0.05);
        test.setDt(1.1);
        test.initFlowCalc();
        for (int i = 0; i < 120; ++i) {
            test.initFlowCalc();
            test.calcFluxes();
            test.update();
        }
        test.getBulkSystem().prettyPrint();
    }

    public double[] getStirrerDiameter() {
        return this.stirrerDiameter;
    }

    public void setStirrerDiameter(double stirrerDiameter) {
        this.stirrerDiameter[0] = stirrerDiameter;
        this.stirrerDiameter[1] = stirrerDiameter;
    }

    public void setStirrerDiameter(double[] stirrerDiameter) {
        this.stirrerDiameter = stirrerDiameter;
    }
}

