/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidmechanics.flowsystem.twophaseflowsystem.twophasereactorflowsystem;

import java.util.UUID;
import neqsim.fluidmechanics.flowleg.pipeleg.PipeLeg;
import neqsim.fluidmechanics.flownode.FlowNodeInterface;
import neqsim.fluidmechanics.flownode.twophasenode.twophasepipeflownode.StratifiedFlowNode;
import neqsim.fluidmechanics.flowsolver.twophaseflowsolver.twophasepipeflowsolver.TwoPhaseFixedStaggeredGridSolver;
import neqsim.fluidmechanics.flowsystem.twophaseflowsystem.TwoPhaseFlowSystem;
import neqsim.fluidmechanics.geometrydefinitions.GeometryDefinitionInterface;
import neqsim.fluidmechanics.geometrydefinitions.reactor.ReactorData;
import neqsim.fluidmechanics.util.fluidmechanicsvisualization.flowsystemvisualization.twophaseflowvisualization.twophasepipeflowvisualization.TwoPhasePipeFlowVisualization;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.util.ExcludeFromJacocoGeneratedReport;

public class TwoPhaseReactorFlowSystem
extends TwoPhaseFlowSystem {
    private static final long serialVersionUID = 1000L;

    @Override
    public void createSystem() {
        this.flowLeg = new PipeLeg[this.getNumberOfLegs()];
        for (int i = 0; i < this.getNumberOfLegs(); ++i) {
            this.flowLeg[i] = new PipeLeg();
        }
        this.flowNode = new FlowNodeInterface[this.totalNumberOfNodes];
        this.flowNode[0] = new StratifiedFlowNode(this.thermoSystem, this.equipmentGeometry[0]);
        this.flowNode[this.totalNumberOfNodes - 1] = this.flowNode[0].getNextNode();
        super.createSystem();
        this.setNodes();
    }

    @Override
    public void init() {
        int phaseNum;
        int j;
        for (j = 0; j < this.getTotalNumberOfNodes(); ++j) {
            this.flowNode[j].setInterphaseModelType(1);
            this.flowNode[j].getGeometry();
            this.flowNode[j].initFlowCalc();
            this.flowNode[j].init();
        }
        for (j = 0; j < this.getTotalNumberOfNodes(); ++j) {
            for (phaseNum = 0; phaseNum < 2; ++phaseNum) {
                this.flowNode[j].setVelocityOut(phaseNum, this.flowNode[j].getVelocity(phaseNum));
            }
        }
        for (int k = 1; k < this.getTotalNumberOfNodes(); ++k) {
            for (phaseNum = 0; phaseNum < 2; ++phaseNum) {
                this.flowNode[k].setVelocityIn(phaseNum, this.flowNode[k - 1].getVelocityOut(phaseNum));
            }
        }
    }

    @Override
    public void solveSteadyState(int type, UUID id) {
        double[] times = new double[]{0.0};
        this.display = new TwoPhasePipeFlowVisualization(this.getTotalNumberOfNodes(), 1);
        this.getTimeSeries().setTimes(times);
        SystemInterface[] systems = new SystemInterface[]{this.flowNode[0].getBulkSystem()};
        this.getTimeSeries().setInletThermoSystems(systems);
        this.getTimeSeries().setNumberOfTimeStepsInInterval(1);
        double[] outletFlowRates = new double[]{0.0, 0.0};
        this.getTimeSeries().setOutletMolarFlowRate(outletFlowRates);
        this.flowSolver = new TwoPhaseFixedStaggeredGridSolver(this, this.getSystemLength(), this.getTotalNumberOfNodes(), false);
        this.flowSolver.setSolverType(type);
        this.flowSolver.solveTDMA();
        this.getTimeSeries().init(this);
        this.display.setNextData(this);
    }

    @Override
    public void solveTransient(int type, UUID id) {
        this.calcIdentifier = id;
    }

    @ExcludeFromJacocoGeneratedReport
    public static void main(String[] args) {
        TwoPhaseReactorFlowSystem pipe = new TwoPhaseReactorFlowSystem();
        SystemSrkEos testSystem = new SystemSrkEos(295.3, 5.0);
        ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
        testSystem.addComponent("methane", 0.11152181, 0);
        testSystem.addComponent("water", 0.04962204876, 1);
        testSystem.createDatabase(true);
        testSystem.setMixingRule(2);
        pipe.setInletThermoSystem(testSystem);
        pipe.setNumberOfLegs(5);
        pipe.setNumberOfNodesInLeg(100);
        double[] height = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] length = new double[]{0.0, 1.7, 3.5, 5.0, 7.5, 10.4};
        double[] outerTemperature = new double[]{278.0, 278.0, 278.0, 278.0, 278.0, 278.0, 278.0, 275.0, 275.0, 275.0, 275.0};
        pipe.setLegHeights(height);
        pipe.setLegPositions(length);
        pipe.setLegOuterTemperatures(outerTemperature);
        GeometryDefinitionInterface[] pipeGemometry = new ReactorData[5];
        double[] pipeDiameter = new double[]{0.02588, 0.02588, 0.02588, 0.02588, 0.02588};
        for (int i = 0; i < pipeDiameter.length; ++i) {
            pipeGemometry[i] = new ReactorData(pipeDiameter[i], 1);
        }
        pipe.setEquipmentGeometry(pipeGemometry);
        pipe.createSystem();
        pipe.init();
        pipe.solveSteadyState(2);
    }
}

