/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalproperties;

import neqsim.util.exception.InvalidInputException;

public enum PhysicalPropertyType {
    MASS_DENSITY,
    DYNAMIC_VISCOSITY,
    THERMAL_CONDUCTIVITY;

    private static final PhysicalPropertyType[] copyOfValues;

    public static PhysicalPropertyType byName(String name) {
        if ((name = name.toUpperCase()).equals("DENSITY")) {
            name = "MASS_DENSITY";
        }
        if (name.equals("VISCOSITY")) {
            name = "DYNAMIC_VISCOSITY";
        }
        if (name.equals("CONDUCTIVITY")) {
            name = "THERMAL_CONDUCTIVITY";
        }
        for (PhysicalPropertyType pt : copyOfValues) {
            if (!pt.name().equals(name)) continue;
            return pt;
        }
        throw new RuntimeException(new InvalidInputException("PhysicalPropertyType", "byName", "name", "is not valid."));
    }

    static {
        copyOfValues = PhysicalPropertyType.values();
    }
}

