/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalproperties.methods.commonphasephysicalproperties.viscosity;

import neqsim.physicalproperties.methods.commonphasephysicalproperties.viscosity.Viscosity;
import neqsim.physicalproperties.system.PhysicalProperties;

public class MethaneViscosityMethod
extends Viscosity {
    private static final long serialVersionUID = 1000L;

    public MethaneViscosityMethod(PhysicalProperties phase) {
        super(phase);
    }

    @Override
    public double calcViscosity() {
        if (this.phase.getPhase().getNumberOfComponents() > 1 || !this.phase.getPhase().getComponent(0).getName().equalsIgnoreCase("methane")) {
            throw new Error("Methane viscosity model only supports PURE METHANE.");
        }
        double[] a = new double[]{0.1023, 0.023364, 0.058533, -0.040758, 0.0093324};
        double T = this.phase.getPhase().getTemperature();
        double P = this.phase.getPhase().getPressure() / 10.0;
        double lowPresVisc = 0.0;
        double temp = 0.0;
        double temp2 = 0.0;
        double temp3 = 0.0;
        double temp4 = 0.0;
        double critDens = 0.0;
        double par1 = 0.0;
        double par2 = 0.0;
        double par3 = 0.0;
        double par4 = 0.0;
        for (int i = 0; i < this.phase.getPhase().getNumberOfComponents(); ++i) {
            par1 += this.phase.getPhase().getComponent(i).getx() * this.phase.getPhase().getComponent(i).getTC();
            par2 += this.phase.getPhase().getComponent(i).getx() * this.phase.getPhase().getComponent(i).getMolarMass() * 1000.0;
            par3 += this.phase.getPhase().getComponent(i).getx() * this.phase.getPhase().getComponent(i).getPC();
            par4 += this.phase.getPhase().getComponent(i).getx() * this.phase.getPhase().getComponent(i).getCriticalVolume();
            double TR = this.phase.getPhase().getTemperature() / this.phase.getPhase().getComponent(i).getTC();
            temp2 = Math.pow(this.phase.getPhase().getComponent(i).getTC(), 0.16666666666666666) / (Math.pow(this.phase.getPhase().getComponent(i).getMolarMass() * 1000.0, 0.5) * Math.pow(this.phase.getPhase().getComponent(i).getPC(), 0.6666666666666666));
            temp = TR < 1.5 ? 3.4E-4 / temp2 * Math.pow(TR, 0.94) : 1.778E-4 / temp2 * Math.pow(4.58 * TR - 1.67, 0.625);
            temp3 += this.phase.getPhase().getComponent(i).getx() * temp * Math.pow(this.phase.getPhase().getComponent(i).getMolarMass() * 1000.0, 0.5);
            temp4 += this.phase.getPhase().getComponent(i).getx() * Math.pow(this.phase.getPhase().getComponent(i).getMolarMass() * 1000.0, 0.5);
        }
        lowPresVisc = temp3 / temp4;
        critDens = 1.0 / par4;
        double eps = Math.pow(par1, 0.16666666666666666) * Math.pow(par2, -0.5) * Math.pow(par3, -0.6666666666666666);
        double reducedDensity = this.phase.getPhase().getPhysicalProperties().getDensity() / this.phase.getPhase().getMolarMass() / critDens / 1000000.0;
        double numb = a[0] + a[1] * reducedDensity + a[2] * Math.pow(reducedDensity, 2.0) + a[3] * Math.pow(reducedDensity, 3.0) + a[4] * Math.pow(reducedDensity, 4.0);
        double viscosity_LBC = (-Math.pow(10.0, -4.0) + Math.pow(numb, 4.0)) / eps + lowPresVisc;
        viscosity_LBC /= 1000.0;
        double term_A = 0.0;
        term_A = T >= 345.0 ? 1.1 * Math.pow(T / 345.0 - 1.0, 1.2) : 0.64 * (T / 345.0 - 1.0) * (1.0 - 0.4 * Math.exp(-Math.pow(T - 298.15, 2.0) / 100.0) / (1.0 + Math.exp(-(P - 21.0))));
        double A = Math.pow(10.0, -6.0) * (term_A + 0.27 * Math.exp(-Math.pow(T - 430.0, 2.0) / 9000.0) * Math.exp(-Math.pow(P - 21.0, 2.0) / 35.0) / (1.0 + Math.exp(-(P - 15.0))));
        double B = Math.pow(10.0, -8.0) * (1.2 * Math.pow(300.0 / T, 3.0) * Math.pow(P, 1.2) / (1.0 + Math.exp(-0.6 * (P - 20.0))) + 30.0 * (1.0 - T / 400.0) * Math.exp(-Math.pow(P - 15.0, 2.0) / 20.0) + 13.0 * Math.exp(-Math.pow(P - 12.8, 2.0) / 7.0));
        double C = Math.pow(10.0, -8.0) * (1.0 / (1.0 + Math.exp(P - 15.0)) * (2.0 * P * Math.exp(-Math.pow(T - 375.0, 2.0) / 10000.0) + 8.0 * (P / 4.0 - 1.0)) + 10.0 * Math.exp(-Math.pow(T - 260.0, 2.0) / 300.0) / (1.0 + Math.exp(0.9 * (P - 12.0))));
        double D = Math.pow(10.0, -6.0) * (0.62 * (1.0 - T / 430.0) * 1.0 / (1.0 + Math.exp(-0.5 * (P - 26.0))) + 0.306 * Math.exp(-Math.pow(T - 270.0, 2.0) / 50.0) / (1.0 + Math.exp(-(P - 25.0))) - 265.2 / T * Math.exp(-Math.pow(T - 270.0, 2.0) / 160.0) / (1.0 + Math.exp(-0.5 * (P - 25.0))));
        double eta = viscosity_LBC + A - B + C - D;
        return eta;
    }
}

