/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalproperties.methods.commonphasephysicalproperties.viscosity;

import neqsim.physicalproperties.methods.commonphasephysicalproperties.viscosity.Viscosity;
import neqsim.physicalproperties.system.PhysicalProperties;

public class MuznyViscosityMethod
extends Viscosity {
    private static final long serialVersionUID = 1000L;

    public MuznyViscosityMethod(PhysicalProperties phase) {
        super(phase);
    }

    @Override
    public double calcViscosity() {
        if (this.phase.getPhase().getNumberOfComponents() > 1 || !this.phase.getPhase().getComponent(0).getName().equalsIgnoreCase("hydrogen")) {
            throw new Error("Muzny viscosity model only supports PURE HYDROGEN.");
        }
        double T = this.phase.getPhase().getTemperature();
        double rho = this.phase.getPhase().getDensity_Leachman();
        double[] a = new double[]{0.20963, -0.455274, 0.143602, -0.0335325, 0.00276981};
        double[] b = new double[]{-0.187, 2.4871, 3.7151, -11.0972, 9.0965, -3.8292, 0.5166};
        double[] c = new double[]{0.0, 6.43449673, 0.0456334068, 0.232797868, 0.95832612, 0.127941189, 0.363576595};
        double Tc = 33.145;
        double rho_sc = 90.909090909;
        double M = 2.01588;
        double sigma = 0.297;
        double epsilon_kb = 30.41;
        double Tr = T / Tc;
        double rho_r = rho / rho_sc;
        double T_star = T * 1.0 / epsilon_kb;
        double sstar = 0.0;
        for (int i = 0; i < a.length; ++i) {
            sstar += a[i] * Math.pow(Math.log(T_star), i);
        }
        double Sstar = Math.exp(sstar);
        double Bstar_eta = 0.0;
        for (int i = 0; i < b.length; ++i) {
            Bstar_eta += b[i] * Math.pow(T_star, -i);
        }
        double B_eta = Bstar_eta * Math.pow(sigma, 3.0);
        double eta_0 = 0.021357 * Math.pow(M * T, 0.5) / (Math.pow(sigma, 2.0) * Sstar);
        double eta_1 = B_eta * eta_0;
        double eta = eta_0 + eta_1 * rho + c[1] * Math.pow(rho_r, 2.0) * Math.exp(c[2] * Tr + c[3] / Tr + c[4] * Math.pow(rho_r, 2.0) / (c[5] + Tr) + c[6] * Math.pow(rho_r, 6.0));
        return eta * Math.pow(10.0, -6.0);
    }
}

