/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalproperties.methods.liquidphysicalproperties.diffusivity;

import neqsim.physicalproperties.methods.liquidphysicalproperties.LiquidPhysicalPropertyMethod;
import neqsim.physicalproperties.methods.methodinterface.DiffusivityInterface;
import neqsim.physicalproperties.system.PhysicalProperties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

abstract class Diffusivity
extends LiquidPhysicalPropertyMethod
implements DiffusivityInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Diffusivity.class);
    double[][] binaryDiffusionCoefficients;
    double[] effectiveDiffusionCoefficient;

    public Diffusivity(PhysicalProperties liquidPhase) {
        super(liquidPhase);
        this.binaryDiffusionCoefficients = new double[liquidPhase.getPhase().getNumberOfComponents()][liquidPhase.getPhase().getNumberOfComponents()];
        this.effectiveDiffusionCoefficient = new double[liquidPhase.getPhase().getNumberOfComponents()];
    }

    @Override
    public Diffusivity clone() {
        Diffusivity properties = null;
        try {
            properties = (Diffusivity)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        if (this.binaryDiffusionCoefficients != null && this.binaryDiffusionCoefficients.length > 0) {
            properties.binaryDiffusionCoefficients = (double[][])this.binaryDiffusionCoefficients.clone();
            for (int i = 0; i < this.binaryDiffusionCoefficients.length; ++i) {
                if (this.binaryDiffusionCoefficients[i] == null || properties.binaryDiffusionCoefficients[i] == null) continue;
                System.arraycopy(this.binaryDiffusionCoefficients[i], 0, properties.binaryDiffusionCoefficients[i], 0, this.binaryDiffusionCoefficients[i].length);
            }
        }
        if (this.effectiveDiffusionCoefficient != null && this.effectiveDiffusionCoefficient.length > 0) {
            properties.effectiveDiffusionCoefficient = (double[])this.effectiveDiffusionCoefficient.clone();
        }
        return properties;
    }

    @Override
    public double[][] calcDiffusionCoefficients(int binaryDiffusionCoefficientMethod, int multicomponentDiffusionMethod) {
        int j;
        int i;
        for (i = 0; i < this.liquidPhase.getPhase().getNumberOfComponents(); ++i) {
            for (j = 0; j < this.liquidPhase.getPhase().getNumberOfComponents(); ++j) {
                this.binaryDiffusionCoefficients[i][j] = this.calcBinaryDiffusionCoefficient(i, j, binaryDiffusionCoefficientMethod);
            }
        }
        for (i = 0; i < this.liquidPhase.getPhase().getNumberOfComponents(); ++i) {
            for (j = 0; j < this.liquidPhase.getPhase().getNumberOfComponents(); ++j) {
                if (i == j) continue;
                this.binaryDiffusionCoefficients[i][j] = Math.pow(this.binaryDiffusionCoefficients[i][j], this.liquidPhase.getPhase().getComponent(j).getx()) * Math.pow(this.binaryDiffusionCoefficients[j][i], this.liquidPhase.getPhase().getComponent(i).getx());
            }
        }
        return this.binaryDiffusionCoefficients;
    }

    @Override
    public void calcEffectiveDiffusionCoefficients() {
        double sum = 0.0;
        for (int i = 0; i < this.liquidPhase.getPhase().getNumberOfComponents(); ++i) {
            sum = 0.0;
            for (int j = 0; j < this.liquidPhase.getPhase().getNumberOfComponents(); ++j) {
                if (i == j) continue;
                sum += this.liquidPhase.getPhase().getComponent(j).getx() / this.binaryDiffusionCoefficients[i][j];
            }
            this.effectiveDiffusionCoefficient[i] = (1.0 - this.liquidPhase.getPhase().getComponent(i).getx()) / sum;
        }
    }

    @Override
    public double getMaxwellStefanBinaryDiffusionCoefficient(int i, int j) {
        return this.binaryDiffusionCoefficients[i][j];
    }

    @Override
    public double getEffectiveDiffusionCoefficient(int i) {
        return this.effectiveDiffusionCoefficient[i];
    }

    @Override
    public double getFickBinaryDiffusionCoefficient(int i, int j) {
        double temp = i == j ? 1.0 : 0.0;
        double nonIdealCorrection = temp + this.liquidPhase.getPhase().getComponent(i).getx() * this.liquidPhase.getPhase().getComponent(i).getdfugdn(j) * this.liquidPhase.getPhase().getNumberOfMolesInPhase();
        if (Double.isNaN(nonIdealCorrection)) {
            nonIdealCorrection = 1.0;
        }
        return this.binaryDiffusionCoefficients[i][j] * nonIdealCorrection;
    }
}

