/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process;

import java.util.UUID;
import neqsim.process.SimulationInterface;
import neqsim.util.NamedBaseClass;
import neqsim.util.exception.InvalidInputException;

public abstract class SimulationBaseClass
extends NamedBaseClass
implements SimulationInterface {
    private static final long serialVersionUID = 1000L;
    protected UUID calcIdentifier;
    protected boolean calculateSteadyState = true;
    protected double time = 0.0;
    private boolean runInSteps = false;

    public SimulationBaseClass(String name) {
        super(name);
    }

    @Override
    public UUID getCalculationIdentifier() {
        return this.calcIdentifier;
    }

    @Override
    public void setCalculationIdentifier(UUID value) {
        this.calcIdentifier = this.calcIdentifier == null || this.calcIdentifier != value ? value : value;
    }

    @Override
    public boolean getCalculateSteadyState() {
        return this.calculateSteadyState;
    }

    @Override
    public void setCalculateSteadyState(boolean steady) {
        this.calculateSteadyState = steady;
    }

    @Override
    public double getTime() {
        return this.time;
    }

    @Override
    public void setTime(double value) {
        this.time = value;
    }

    @Override
    public void increaseTime(double dt) {
        if (dt < 0.0) {
            throw new RuntimeException(new InvalidInputException(this, "increaseTime", "dt", "Negative values are not allowed. Not possible to go backwards in time."));
        }
        this.time += dt;
    }

    @Override
    public void setRunInSteps(boolean setRunSteps) {
        this.runInSteps = setRunSteps;
    }

    @Override
    public boolean isRunInSteps() {
        return this.runInSteps;
    }
}

