/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.distillation;

import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import neqsim.process.equipment.ProcessEquipmentBaseClass;
import neqsim.process.equipment.distillation.Condenser;
import neqsim.process.equipment.distillation.DistillationInterface;
import neqsim.process.equipment.distillation.Reboiler;
import neqsim.process.equipment.distillation.SimpleTray;
import neqsim.process.equipment.heatexchanger.Heater;
import neqsim.process.equipment.mixer.Mixer;
import neqsim.process.equipment.separator.Separator;
import neqsim.process.equipment.stream.Stream;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.processmodel.ProcessSystem;
import neqsim.process.util.monitor.DistillationColumnResponse;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DistillationColumn
extends ProcessEquipmentBaseClass
implements DistillationInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(DistillationColumn.class);
    private boolean doInitializion = true;
    boolean hasReboiler = false;
    boolean hasCondenser = false;
    protected ArrayList<SimpleTray> trays = new ArrayList(0);
    double condenserCoolingDuty = 10.0;
    private double reboilerTemperature = 273.15;
    private double condenserTemperature = 270.15;
    double topTrayPressure = -1.0;
    private double temperatureTolerance = 1.0E-4;
    private double massBalanceTolerance = 0.001;
    private double enthalpyBalanceTolerance = 0.001;
    Mixer feedmixer = new Mixer("temp mixer");
    double bottomTrayPressure = -1.0;
    int numberOfTrays = 1;
    int maxNumberOfIterations = 10;
    StreamInterface stream_3 = new Stream("stream_3");
    StreamInterface gasOutStream = new Stream("gasOutStream");
    StreamInterface liquidOutStream = new Stream("liquidOutStream");
    boolean stream_3isset = false;
    private double internalDiameter = 1.0;
    ProcessSystem distoperations;
    Heater heater;
    Separator separator2;
    private double err = 1.0E10;
    private Map<Integer, List<StreamInterface>> feedStreams = new HashMap<Integer, List<StreamInterface>>();

    public DistillationColumn(String name, int numberOfTraysLocal, boolean hasReboiler, boolean hasCondenser) {
        super(name);
        int i;
        this.hasReboiler = hasReboiler;
        this.hasCondenser = hasCondenser;
        this.distoperations = new ProcessSystem();
        this.numberOfTrays = numberOfTraysLocal;
        if (hasReboiler) {
            this.trays.add(new Reboiler("Reboiler"));
            ++this.numberOfTrays;
        }
        for (i = 0; i < numberOfTraysLocal; ++i) {
            this.trays.add(new SimpleTray("SimpleTray" + (i + 1)));
        }
        if (hasCondenser) {
            this.trays.add(new Condenser("Condenser"));
            ++this.numberOfTrays;
        }
        for (i = 0; i < this.numberOfTrays; ++i) {
            this.distoperations.add(this.trays.get(i));
        }
    }

    public void addFeedStream(StreamInterface inputStream, int feedTrayNumber) {
        this.feedStreams.computeIfAbsent(feedTrayNumber, k -> new ArrayList()).add(inputStream);
        this.getTray(feedTrayNumber).addStream(inputStream);
        this.feedmixer.addStream(inputStream);
        this.feedmixer.run();
        double moles = this.feedmixer.getOutletStream().getThermoSystem().getTotalNumberOfMoles();
        this.stream_3 = this.feedmixer.getOutletStream();
        this.gasOutStream.setThermoSystem(this.stream_3.getThermoSystem().clone());
        this.gasOutStream.getThermoSystem().setTotalNumberOfMoles(moles / 2.0);
        this.liquidOutStream.setThermoSystem(this.stream_3.getThermoSystem().clone());
        this.liquidOutStream.getThermoSystem().setTotalNumberOfMoles(moles / 2.0);
        this.setDoInitializion(true);
    }

    public void init() {
        int i;
        if (!this.isDoInitializion()) {
            return;
        }
        this.setDoInitializion(false);
        if (this.feedStreams.isEmpty()) {
            return;
        }
        int firstFeedTrayNumber = (Integer)this.feedStreams.keySet().stream().min(Integer::compareTo).get();
        this.getTray(firstFeedTrayNumber).run();
        if (this.getTray(firstFeedTrayNumber).getFluid().getNumberOfPhases() == 1) {
            for (int i2 = 0; i2 < this.numberOfTrays; ++i2) {
                if (this.getTray(i2).getNumberOfInputStreams() > 0 && i2 != firstFeedTrayNumber) {
                    this.getTray(firstFeedTrayNumber).addStream(this.trays.get(i2).getStream(0));
                    this.getTray(firstFeedTrayNumber).run();
                    this.getTray(firstFeedTrayNumber).removeInputStream(this.getTray(firstFeedTrayNumber).getNumberOfInputStreams() - 1);
                    if (this.getTray(firstFeedTrayNumber).getThermoSystem().getNumberOfPhases() <= 1) continue;
                    break;
                }
                if (i2 != firstFeedTrayNumber || this.getTray(i2).getNumberOfInputStreams() <= 1) continue;
                this.getTray(firstFeedTrayNumber).addStream(this.trays.get(i2).getStream(1));
                this.trays.get(firstFeedTrayNumber).run();
                this.getTray(firstFeedTrayNumber).removeInputStream(this.getTray(firstFeedTrayNumber).getNumberOfInputStreams() - 1);
                if (this.getTray(firstFeedTrayNumber).getThermoSystem().getNumberOfPhases() > 1) break;
            }
        }
        if (this.getTray(firstFeedTrayNumber).getFluid().getNumberOfPhases() == 1) {
            this.getTray(firstFeedTrayNumber).getThermoSystem().init(0);
            this.getTray(firstFeedTrayNumber).getThermoSystem().init(3);
        }
        this.trays.get(0).addStream(this.trays.get(firstFeedTrayNumber).getLiquidOutStream().clone());
        this.trays.get(0).run();
        double feedTrayTemperature = this.getTray(firstFeedTrayNumber).getTemperature();
        this.condenserTemperature = this.trays.get(this.numberOfTrays - 1).getNumberOfInputStreams() > 0 ? this.trays.get(this.numberOfTrays - 1).getThermoSystem().getTemperature() : feedTrayTemperature - 1.0;
        this.reboilerTemperature = this.trays.get(0).getThermoSystem().getTemperature();
        double deltaTempCondenser = (feedTrayTemperature - this.condenserTemperature) / ((double)this.numberOfTrays * 1.0 - (double)firstFeedTrayNumber - 1.0);
        double deltaTempReboiler = (this.reboilerTemperature - feedTrayTemperature) / ((double)firstFeedTrayNumber * 1.0);
        double delta = 0.0;
        for (i = firstFeedTrayNumber + 1; i < this.numberOfTrays; ++i) {
            this.trays.get(i).setTemperature(this.getTray(firstFeedTrayNumber).getThermoSystem().getTemperature() - (delta += deltaTempCondenser));
        }
        delta = 0.0;
        for (i = firstFeedTrayNumber - 1; i >= 0; --i) {
            this.trays.get(i).setTemperature(this.getTray(firstFeedTrayNumber).getThermoSystem().getTemperature() + (delta += deltaTempReboiler));
        }
        for (i = 1; i < this.numberOfTrays; ++i) {
            this.trays.get(i).addStream(this.trays.get(i - 1).getGasOutStream());
            this.trays.get(i).init();
            this.trays.get(i).run();
        }
        for (i = this.numberOfTrays - 2; i >= 1; --i) {
            this.trays.get(i).addStream(this.trays.get(i + 1).getLiquidOutStream());
            this.trays.get(i).init();
            this.trays.get(i).run();
        }
        int streamNumb = this.trays.get(0).getNumberOfInputStreams() - 1;
        this.trays.get(0).replaceStream(streamNumb, this.trays.get(1).getLiquidOutStream());
        this.trays.get(0).init();
        this.trays.get(0).run();
    }

    @Override
    public void run(UUID id) {
        int i;
        double errOld;
        if (this.feedStreams.isEmpty()) {
            return;
        }
        int firstFeedTrayNumber = (Integer)this.feedStreams.keySet().stream().min(Integer::compareTo).get();
        if (this.bottomTrayPressure < 0.0) {
            this.bottomTrayPressure = this.getTray(firstFeedTrayNumber).getStream(0).getPressure();
        }
        if (this.topTrayPressure < 0.0) {
            this.topTrayPressure = this.getTray(firstFeedTrayNumber).getStream(0).getPressure();
        }
        double dp = 0.0;
        if (this.numberOfTrays > 1) {
            dp = (this.bottomTrayPressure - this.topTrayPressure) / ((double)this.numberOfTrays - 1.0);
        }
        for (int i2 = 0; i2 < this.numberOfTrays; ++i2) {
            this.trays.get(i2).setPressure(this.bottomTrayPressure - (double)i2 * dp);
        }
        int[] numeroffeeds = new int[this.numberOfTrays];
        for (Map.Entry<Integer, List<StreamInterface>> entry : this.feedStreams.entrySet()) {
            int feedTrayNumber = entry.getKey();
            List<StreamInterface> trayFeeds = entry.getValue();
            for (StreamInterface feedStream : trayFeeds) {
                int n = feedTrayNumber;
                numeroffeeds[n] = numeroffeeds[n] + 1;
                SystemInterface inpS = feedStream.getThermoSystem().clone();
                this.trays.get(feedTrayNumber).getStream(numeroffeeds[feedTrayNumber] - 1).setThermoSystem(inpS);
            }
        }
        if (this.numberOfTrays == 1) {
            this.trays.get(0).run(id);
            this.gasOutStream.setThermoSystem(this.trays.get(0).getGasOutStream().getThermoSystem().clone());
            this.liquidOutStream.setThermoSystem(this.trays.get(0).getLiquidOutStream().getThermoSystem().clone());
            this.gasOutStream.setCalculationIdentifier(id);
            this.liquidOutStream.setCalculationIdentifier(id);
            this.setCalculationIdentifier(id);
            return;
        }
        if (this.isDoInitializion()) {
            this.init();
        }
        this.err = 1.0E10;
        int iter = 0;
        double massErr = 1.0E10;
        double energyErr = 1.0E10;
        double[] oldtemps = new double[this.numberOfTrays];
        this.trays.get(firstFeedTrayNumber).run(id);
        do {
            int replaceStream;
            int i3;
            ++iter;
            errOld = this.err;
            this.err = 0.0;
            for (i = 0; i < this.numberOfTrays; ++i) {
                oldtemps[i] = this.trays.get(i).getThermoSystem().getTemperature();
            }
            for (i = firstFeedTrayNumber; i > 1; --i) {
                int replaceStream1 = this.trays.get(i - 1).getNumberOfInputStreams() - 1;
                this.trays.get(i - 1).replaceStream(replaceStream1, this.trays.get(i).getLiquidOutStream());
                this.trays.get(i - 1).setPressure(this.bottomTrayPressure - (double)(i - 1) * dp);
                this.trays.get(i - 1).run(id);
            }
            int streamNumb = this.trays.get(0).getNumberOfInputStreams() - 1;
            this.trays.get(0).setPressure(this.bottomTrayPressure);
            this.trays.get(0).replaceStream(streamNumb, this.trays.get(1).getLiquidOutStream());
            this.trays.get(0).run(id);
            for (i3 = 1; i3 <= this.numberOfTrays - 1; ++i3) {
                replaceStream = this.trays.get(i3).getNumberOfInputStreams() - 2;
                if (i3 == this.numberOfTrays - 1) {
                    replaceStream = this.trays.get(i3).getNumberOfInputStreams() - 1;
                }
                this.trays.get(i3).replaceStream(replaceStream, this.trays.get(i3 - 1).getGasOutStream());
                this.trays.get(i3).run(id);
            }
            for (i3 = this.numberOfTrays - 2; i3 >= firstFeedTrayNumber; --i3) {
                replaceStream = this.trays.get(i3).getNumberOfInputStreams() - 1;
                this.trays.get(i3).replaceStream(replaceStream, this.trays.get(i3 + 1).getLiquidOutStream());
                this.trays.get(i3).run(id);
            }
            for (i3 = 0; i3 < this.numberOfTrays; ++i3) {
                this.err += Math.abs(oldtemps[i3] - this.trays.get(i3).getThermoSystem().getTemperature());
            }
            massErr = this.getMassBalanceError();
            energyErr = this.getEnergyBalanceError();
            logger.info("error iteration = " + iter + "   err = " + this.err + " massErr= " + massErr + " energyErr= " + energyErr);
        } while ((this.err > this.temperatureTolerance || massErr > this.massBalanceTolerance || energyErr > this.enthalpyBalanceTolerance) && this.err < errOld && iter < this.maxNumberOfIterations);
        this.gasOutStream.setThermoSystem(this.trays.get(this.numberOfTrays - 1).getGasOutStream().getThermoSystem().clone());
        this.gasOutStream.setCalculationIdentifier(id);
        this.liquidOutStream.setThermoSystem(this.trays.get(0).getLiquidOutStream().getThermoSystem().clone());
        this.liquidOutStream.setCalculationIdentifier(id);
        for (i = 0; i < this.numberOfTrays; ++i) {
            this.trays.get(i).setCalculationIdentifier(id);
        }
        this.setCalculationIdentifier(id);
    }

    public void runBroyden(UUID id) {
        int i;
        double errOld;
        if (this.feedStreams.isEmpty()) {
            return;
        }
        int firstFeedTrayNumber = (Integer)this.feedStreams.keySet().stream().min(Integer::compareTo).get();
        if (this.bottomTrayPressure < 0.0) {
            this.bottomTrayPressure = this.getTray(firstFeedTrayNumber).getStream(0).getPressure();
        }
        if (this.topTrayPressure < 0.0) {
            this.topTrayPressure = this.getTray(firstFeedTrayNumber).getStream(0).getPressure();
        }
        double dp = 0.0;
        if (this.numberOfTrays > 1) {
            dp = (this.bottomTrayPressure - this.topTrayPressure) / ((double)this.numberOfTrays - 1.0);
        }
        for (int i2 = 0; i2 < this.numberOfTrays; ++i2) {
            this.trays.get(i2).setPressure(this.bottomTrayPressure - (double)i2 * dp);
        }
        if (this.isDoInitializion()) {
            this.init();
        }
        this.err = 1.0E10;
        int iter = 0;
        double massErr = 1.0E10;
        double energyErr = 1.0E10;
        double[] oldtemps = new double[this.numberOfTrays];
        double[] oldDelta = new double[this.numberOfTrays];
        this.trays.get(firstFeedTrayNumber).run(id);
        do {
            int replaceStream;
            int i3;
            ++iter;
            errOld = this.err;
            this.err = 0.0;
            for (i = 0; i < this.numberOfTrays; ++i) {
                oldtemps[i] = this.trays.get(i).getThermoSystem().getTemperature();
            }
            for (i = firstFeedTrayNumber; i > 1; --i) {
                int replaceStream1 = this.trays.get(i - 1).getNumberOfInputStreams() - 1;
                this.trays.get(i - 1).replaceStream(replaceStream1, this.trays.get(i).getLiquidOutStream());
                this.trays.get(i - 1).run(id);
            }
            int streamNumb = this.trays.get(0).getNumberOfInputStreams() - 1;
            this.trays.get(0).replaceStream(streamNumb, this.trays.get(1).getLiquidOutStream());
            this.trays.get(0).run(id);
            for (i3 = 1; i3 <= this.numberOfTrays - 1; ++i3) {
                replaceStream = this.trays.get(i3).getNumberOfInputStreams() - 2;
                if (i3 == this.numberOfTrays - 1) {
                    replaceStream = this.trays.get(i3).getNumberOfInputStreams() - 1;
                }
                this.trays.get(i3).replaceStream(replaceStream, this.trays.get(i3 - 1).getGasOutStream());
                this.trays.get(i3).run(id);
            }
            for (i3 = this.numberOfTrays - 2; i3 >= firstFeedTrayNumber; --i3) {
                replaceStream = this.trays.get(i3).getNumberOfInputStreams() - 1;
                this.trays.get(i3).replaceStream(replaceStream, this.trays.get(i3 + 1).getLiquidOutStream());
                this.trays.get(i3).run(id);
            }
            double[] delta = new double[this.numberOfTrays];
            for (int i4 = 0; i4 < this.numberOfTrays; ++i4) {
                delta[i4] = this.trays.get(i4).getThermoSystem().getTemperature() - oldtemps[i4];
                double newTemp = oldtemps[i4] + delta[i4] + 0.3 * (delta[i4] - oldDelta[i4]);
                this.trays.get(i4).setTemperature(newTemp);
                oldDelta[i4] = delta[i4];
                this.err += Math.abs(newTemp - oldtemps[i4]);
            }
            massErr = this.getMassBalanceError();
            energyErr = this.getEnergyBalanceError();
            logger.info("error iteration = " + iter + "   err = " + this.err + " massErr= " + massErr + " energyErr= " + energyErr);
        } while ((this.err > this.temperatureTolerance || massErr > this.massBalanceTolerance || energyErr > this.enthalpyBalanceTolerance) && this.err < errOld && iter < this.maxNumberOfIterations);
        this.gasOutStream.setThermoSystem(this.trays.get(this.numberOfTrays - 1).getGasOutStream().getThermoSystem().clone());
        this.gasOutStream.setCalculationIdentifier(id);
        this.liquidOutStream.setThermoSystem(this.trays.get(0).getLiquidOutStream().getThermoSystem().clone());
        this.liquidOutStream.setCalculationIdentifier(id);
        for (i = 0; i < this.numberOfTrays; ++i) {
            this.trays.get(i).setCalculationIdentifier(id);
        }
        this.setCalculationIdentifier(id);
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void displayResult() {
        this.distoperations.displayResult();
    }

    public SimpleTray getTray(int trayNumber) {
        return this.trays.get(trayNumber);
    }

    @Override
    public void setNumberOfTrays(int number) {
        int change;
        int oldNumberOfTrays = this.numberOfTrays;
        int tempNumberOfTrays = number;
        if (this.hasReboiler) {
            ++tempNumberOfTrays;
        }
        if (this.hasCondenser) {
            ++tempNumberOfTrays;
        }
        if ((change = tempNumberOfTrays - oldNumberOfTrays) > 0) {
            for (int i = 0; i < change; ++i) {
                this.trays.add(1, new SimpleTray("SimpleTray" + (oldNumberOfTrays + i + 1)));
            }
        } else if (change < 0) {
            for (int i = 0; i > change; --i) {
                this.trays.remove(1);
            }
        }
        this.numberOfTrays = tempNumberOfTrays;
        this.setDoInitializion(true);
        this.init();
    }

    public void setTopCondenserDuty(double duty) {
        this.condenserCoolingDuty = duty;
    }

    public void setTopPressure(double topPressure) {
        this.topTrayPressure = topPressure;
    }

    public void setBottomPressure(double bottomPressure) {
        this.bottomTrayPressure = bottomPressure;
    }

    @Override
    public boolean solved() {
        return this.err < this.temperatureTolerance;
    }

    public void setMaxNumberOfIterations(int maxIter) {
        this.maxNumberOfIterations = maxIter;
    }

    public void setInternalDiameter(double internalDiameter) {
        this.internalDiameter = internalDiameter;
    }

    public double getInternalDiameter() {
        return this.internalDiameter;
    }

    public double getFsFactor() {
        double intArea = Math.PI * this.getInternalDiameter() * this.getInternalDiameter() / 4.0;
        return this.getGasOutStream().getThermoSystem().getFlowRate("m3/sec") / intArea * Math.sqrt(this.getGasOutStream().getThermoSystem().getDensity("kg/m3"));
    }

    public StreamInterface getGasOutStream() {
        return this.gasOutStream;
    }

    public StreamInterface getLiquidOutStream() {
        return this.liquidOutStream;
    }

    public Reboiler getReboiler() {
        return (Reboiler)this.trays.get(0);
    }

    public Condenser getCondenser() {
        return (Condenser)this.trays.get(this.trays.size() - 1);
    }

    public double getReboilerTemperature() {
        return this.reboilerTemperature;
    }

    public void setReboilerTemperature(double reboilerTemperature) {
        this.reboilerTemperature = reboilerTemperature;
    }

    public double getCondenserTemperature() {
        return this.condenserTemperature;
    }

    public void setCondenserTemperature(double condenserTemperature) {
        this.condenserTemperature = condenserTemperature;
    }

    public boolean isDoInitializion() {
        return this.doInitializion;
    }

    public void setDoInitializion(boolean doInitializion) {
        this.doInitializion = doInitializion;
    }

    public void setTemperatureTolerance(double tol) {
        this.temperatureTolerance = tol;
    }

    public void setMassBalanceTolerance(double tol) {
        this.massBalanceTolerance = tol;
    }

    public void setEnthalpyBalanceTolerance(double tol) {
        this.enthalpyBalanceTolerance = tol;
    }

    public double getTemperatureTolerance() {
        return this.temperatureTolerance;
    }

    public double getMassBalanceTolerance() {
        return this.massBalanceTolerance;
    }

    public double getEnthalpyBalanceTolerance() {
        return this.enthalpyBalanceTolerance;
    }

    public boolean massBalanceCheck() {
        double[] massInput = new double[this.numberOfTrays];
        double[] massOutput = new double[this.numberOfTrays];
        double[] massBalance = new double[this.numberOfTrays];
        for (int i = 0; i < this.numberOfTrays; ++i) {
            int numberOfInputStreams = this.trays.get(i).getNumberOfInputStreams();
            for (int j = 0; j < numberOfInputStreams; ++j) {
                int n = i;
                massInput[n] = massInput[n] + this.trays.get(i).getStream(j).getFluid().getFlowRate("kg/hr");
            }
            int n = i;
            massOutput[n] = massOutput[n] + this.trays.get(i).getGasOutStream().getFlowRate("kg/hr");
            int n2 = i;
            massOutput[n2] = massOutput[n2] + this.trays.get(i).getLiquidOutStream().getFlowRate("kg/hr");
            massBalance[i] = massInput[i] - massOutput[i];
            System.out.println("Tray " + i + ": #in=" + numberOfInputStreams + ", massIn=" + massInput[i] + ", massOut=" + massOutput[i] + ", balance=" + massBalance[i]);
        }
        double massError = 0.0;
        for (int i = 0; i < this.numberOfTrays; ++i) {
            massError += Math.abs(massBalance[i]);
        }
        return massError <= 1.0E-6;
    }

    public boolean componentMassBalanceCheck(String componentName) {
        double[] massInput = new double[this.numberOfTrays];
        double[] massOutput = new double[this.numberOfTrays];
        double[] massBalance = new double[this.numberOfTrays];
        for (int i = 0; i < this.numberOfTrays; ++i) {
            int k;
            int numberOfInputStreams = this.trays.get(i).getNumberOfInputStreams();
            for (int j = 0; j < numberOfInputStreams; ++j) {
                for (int k2 = 0; k2 < this.trays.get(i).getStream(j).getFluid().getNumberOfPhases(); ++k2) {
                    int n = i;
                    massInput[n] = massInput[n] + this.trays.get(i).getStream(j).getFluid().getPhase(k2).getComponent(componentName).getFlowRate("kg/hr");
                }
            }
            for (k = 0; k < this.trays.get(i).getGasOutStream().getFluid().getNumberOfPhases(); ++k) {
                int n = i;
                massOutput[n] = massOutput[n] + this.trays.get(i).getGasOutStream().getFluid().getPhase(k).getComponent(componentName).getFlowRate("kg/hr");
            }
            for (k = 0; k < this.trays.get(i).getLiquidOutStream().getFluid().getNumberOfPhases(); ++k) {
                int n = i;
                massOutput[n] = massOutput[n] + this.trays.get(i).getLiquidOutStream().getFluid().getPhase(k).getComponent(componentName).getFlowRate("kg/hr");
            }
            massBalance[i] = massInput[i] - massOutput[i];
            System.out.println("Tray " + i + ", comp=" + componentName + ", #in=" + numberOfInputStreams + ", massIn=" + massInput[i] + ", massOut=" + massOutput[i] + ", balance=" + massBalance[i]);
        }
        double massError = 0.0;
        for (int i = 0; i < this.numberOfTrays; ++i) {
            massError += Math.abs(massBalance[i]);
        }
        return massError < 1.0E-6;
    }

    public double getMassBalanceError() {
        double[] massInput = new double[this.numberOfTrays];
        double[] massOutput = new double[this.numberOfTrays];
        double[] massBalance = new double[this.numberOfTrays];
        for (int i = 0; i < this.numberOfTrays; ++i) {
            int numberOfInputStreams = this.trays.get(i).getNumberOfInputStreams();
            for (int j = 0; j < numberOfInputStreams; ++j) {
                int n = i;
                massInput[n] = massInput[n] + this.trays.get(i).getStream(j).getFluid().getFlowRate("kg/hr");
            }
            int n = i;
            massOutput[n] = massOutput[n] + this.trays.get(i).getGasOutStream().getFlowRate("kg/hr");
            int n2 = i;
            massOutput[n2] = massOutput[n2] + this.trays.get(i).getLiquidOutStream().getFlowRate("kg/hr");
            massBalance[i] = massInput[i] - massOutput[i];
        }
        double massError = 0.0;
        for (int i = 0; i < this.numberOfTrays; ++i) {
            massError += Math.abs(massBalance[i]);
        }
        return massError;
    }

    public double getEnergyBalanceError() {
        double[] energyInput = new double[this.numberOfTrays];
        double[] energyOutput = new double[this.numberOfTrays];
        double[] energyBalance = new double[this.numberOfTrays];
        for (int i = 0; i < this.numberOfTrays; ++i) {
            int numberOfInputStreams = this.trays.get(i).getNumberOfInputStreams();
            for (int j = 0; j < numberOfInputStreams; ++j) {
                int n = i;
                energyInput[n] = energyInput[n] + this.trays.get(i).getStream(j).getFluid().getEnthalpy();
            }
            int n = i;
            energyOutput[n] = energyOutput[n] + this.trays.get(i).getGasOutStream().getFluid().getEnthalpy();
            int n2 = i;
            energyOutput[n2] = energyOutput[n2] + this.trays.get(i).getLiquidOutStream().getFluid().getEnthalpy();
            energyBalance[i] = energyInput[i] - energyOutput[i];
        }
        double energyError = 0.0;
        for (int i = 0; i < this.numberOfTrays; ++i) {
            energyError += Math.abs(energyBalance[i]);
        }
        return energyError;
    }

    public void energyBalanceCheck() {
        double[] energyInput = new double[this.numberOfTrays];
        double[] energyOutput = new double[this.numberOfTrays];
        double[] energyBalance = new double[this.numberOfTrays];
        for (int i = 0; i < this.numberOfTrays; ++i) {
            int numberOfInputStreams = this.trays.get(i).getNumberOfInputStreams();
            for (int j = 0; j < numberOfInputStreams; ++j) {
                int n = i;
                energyInput[n] = energyInput[n] + this.trays.get(i).getStream(j).getFluid().getEnthalpy();
            }
            int n = i;
            energyOutput[n] = energyOutput[n] + this.trays.get(i).getGasOutStream().getFluid().getEnthalpy();
            int n2 = i;
            energyOutput[n2] = energyOutput[n2] + this.trays.get(i).getLiquidOutStream().getFluid().getEnthalpy();
            energyBalance[i] = energyInput[i] - energyOutput[i];
            System.out.println("Tray " + i + ", #in=" + numberOfInputStreams + ", eIn=" + energyInput[i] + ", eOut=" + energyOutput[i] + ", balance=" + energyBalance[i]);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public static void main(String[] args) {
        SystemSrkEos testSystem = new SystemSrkEos(298.15, 15.0);
        testSystem.addComponent("methane", 10.0);
        testSystem.addComponent("ethane", 10.0);
        testSystem.addComponent("propane", 10.0);
        testSystem.createDatabase(true);
        testSystem.setMixingRule(2);
        ThermodynamicOperations ops = new ThermodynamicOperations(testSystem);
        ops.TPflash();
        testSystem.display();
        Stream feed1 = new Stream("Feed1", testSystem.clone());
        Stream feed2 = new Stream("Feed2", testSystem.clone());
        DistillationColumn column = new DistillationColumn("distColumn", 5, true, true);
        column.addFeedStream(feed1, 3);
        column.addFeedStream(feed2, 3);
        ProcessSystem operations = new ProcessSystem();
        operations.add(feed1);
        operations.add(feed2);
        operations.add(column);
        operations.run();
        column.displayResult();
        System.out.println("Gas out:");
        column.getGasOutStream().getThermoSystem().display();
        System.out.println("Liquid out:");
        column.getLiquidOutStream().getThermoSystem().display();
    }

    @Override
    public String toJson() {
        return new GsonBuilder().create().toJson(new DistillationColumnResponse(this));
    }

    public int getNumerOfTrays() {
        return this.numberOfTrays;
    }
}

