/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.heatexchanger;

import com.google.gson.GsonBuilder;
import java.util.UUID;
import neqsim.process.equipment.heatexchanger.Heater;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.util.monitor.HeaterResponse;

public class Cooler
extends Heater {
    private static final long serialVersionUID = 1000L;

    public Cooler(String name) {
        super(name);
    }

    public Cooler(String name, StreamInterface inStream) {
        super(name, inStream);
    }

    @Override
    public double getEntropyProduction(String unit) {
        UUID id = UUID.randomUUID();
        this.inStream.run(id);
        this.inStream.getFluid().init(3);
        this.getOutletStream().run(id);
        this.getOutletStream().getFluid().init(3);
        double heatTransferEntropyProd = this.coolingMediumTemperature * this.getDuty();
        System.out.println("heat entropy " + heatTransferEntropyProd);
        double entrop = this.getOutletStream().getThermoSystem().getEntropy(unit) - this.inStream.getThermoSystem().getEntropy(unit);
        return entrop;
    }

    @Override
    public String toJson() {
        return new GsonBuilder().create().toJson(new HeaterResponse(this));
    }
}

