/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.heatexchanger;

import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import neqsim.process.equipment.ProcessEquipmentInterface;
import neqsim.process.equipment.heatexchanger.Heater;
import neqsim.process.equipment.heatexchanger.MultiStreamHeatExchangerInterface;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.util.monitor.MultiStreamHeatExchangerResponse;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MultiStreamHeatExchanger
extends Heater
implements MultiStreamHeatExchangerInterface {
    private static final long serialVersionUID = 1001L;
    static Logger logger = LogManager.getLogger(MultiStreamHeatExchanger.class);
    private boolean setTemperature = false;
    private List<StreamInterface> outStreams = new ArrayList<StreamInterface>();
    private List<StreamInterface> inStreams = new ArrayList<StreamInterface>();
    private SystemInterface system;
    private double NTU;
    protected double temperatureOut = 0.0;
    protected double dT = 0.0;
    private double temperatureApproach = 0.0;
    private boolean UAvalueIsSet = false;
    private double UAvalue = 500.0;
    private double duty = 0.0;
    private double hotColdDutyBalance = 1.0;
    private boolean firstTime = true;
    private double guessOutTemperature = 403.15;
    private String guessOutTemperatureUnit = "K";
    private int outStreamSpecificationNumber = 0;
    private double thermalEffectiveness = 0.0;
    private String flowArrangement = "counterflow";
    private boolean useDeltaT = false;
    private double deltaT = 1.0;
    int MAX_ITERATIONS = 100;
    int iterations = 0;

    public MultiStreamHeatExchanger(String name) {
        super(name);
    }

    public MultiStreamHeatExchanger(String name, List<StreamInterface> inStreams) {
        this(name);
        this.inStreams.addAll(inStreams);
        for (StreamInterface inStream : inStreams) {
            StreamInterface outStream = inStream.clone();
            outStream.setName(name + "_Sout" + (this.outStreams.size() + 1));
            this.outStreams.add(outStream);
        }
        this.setName(name);
    }

    @Override
    public void addInStream(StreamInterface inStream) {
        this.inStreams.add(inStream);
        StreamInterface outStream = inStream.clone();
        outStream.setName(this.getName() + "_Sout" + (this.outStreams.size() + 1));
        this.outStreams.add(outStream);
    }

    @Override
    public void setFeedStream(int index, StreamInterface inStream) {
        if (index >= this.inStreams.size()) {
            throw new IndexOutOfBoundsException("Stream index out of bounds.");
        }
        this.inStreams.set(index, inStream);
        this.outStreams.set(index, inStream.clone());
        this.setName(this.getName());
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        for (int i = 0; i < this.outStreams.size(); ++i) {
            this.outStreams.get(i).setName(name + "_Sout" + (i + 1));
        }
    }

    @Override
    public void setdT(double dT) {
        this.dT = dT;
    }

    @Override
    public StreamInterface getOutStream(int i) {
        return this.outStreams.get(i);
    }

    @Override
    public StreamInterface getInStream(int i) {
        return this.inStreams.get(i);
    }

    @Override
    public void setOutTemperature(double temperature) {
        this.temperatureOut = temperature;
    }

    @Override
    public double getOutTemperature(int i) {
        return this.outStreams.get(i).getThermoSystem().getTemperature();
    }

    @Override
    public double getInTemperature(int i) {
        return this.inStreams.get(i).getThermoSystem().getTemperature();
    }

    @Override
    public double getDuty() {
        return this.duty;
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void displayResult() {
        for (StreamInterface outStream : this.outStreams) {
            outStream.displayResult();
        }
    }

    @Override
    public double getUAvalue() {
        return this.UAvalue;
    }

    @Override
    public void setUAvalue(double UAvalue) {
        this.UAvalueIsSet = true;
        this.UAvalue = UAvalue;
    }

    @Override
    public double getGuessOutTemperature() {
        return this.guessOutTemperature;
    }

    @Override
    public void setGuessOutTemperature(double guessOutTemperature) {
        this.guessOutTemperature = guessOutTemperature;
        this.guessOutTemperatureUnit = "K";
    }

    @Override
    public void setGuessOutTemperature(double guessOutTemperature, String unit) {
        this.guessOutTemperature = guessOutTemperature;
        this.guessOutTemperatureUnit = unit;
    }

    @Override
    public double getEntropyProduction(String unit) {
        double entropyProduction = 0.0;
        for (int i = 0; i < this.inStreams.size(); ++i) {
            UUID id = UUID.randomUUID();
            this.inStreams.get(i).run(id);
            this.inStreams.get(i).getFluid().init(3);
            this.outStreams.get(i).run(id);
            this.outStreams.get(i).getFluid().init(3);
            entropyProduction += this.outStreams.get(i).getThermoSystem().getEntropy(unit) - this.inStreams.get(i).getThermoSystem().getEntropy(unit);
        }
        if (this.inStreams.size() >= 2) {
            int hotStream = 0;
            int coldStream = this.inStreams.size() - 1;
            double heatTransferEntropyProd = Math.abs(this.getDuty()) * (1.0 / this.inStreams.get(coldStream).getTemperature() - 1.0 / this.inStreams.get(hotStream).getTemperature());
            entropyProduction += heatTransferEntropyProd;
        }
        return entropyProduction;
    }

    @Override
    public double getMassBalance(String unit) {
        double massBalance = 0.0;
        for (int i = 0; i < this.inStreams.size(); ++i) {
            this.inStreams.get(i).run();
            this.inStreams.get(i).getFluid().init(3);
            this.outStreams.get(i).run();
            this.outStreams.get(i).getFluid().init(3);
            massBalance += this.outStreams.get(i).getThermoSystem().getFlowRate(unit) - this.inStreams.get(i).getThermoSystem().getFlowRate(unit);
        }
        return massBalance;
    }

    @Override
    public void runConditionAnalysis(ProcessEquipmentInterface refExchanger) {
        double heatBalanceError = 0.0;
        this.conditionAnalysisMessage = this.conditionAnalysisMessage + this.getName() + " condition analysis started/";
        MultiStreamHeatExchanger refEx = (MultiStreamHeatExchanger)refExchanger;
        for (int i = 0; i < this.inStreams.size(); ++i) {
            this.inStreams.get(i).getFluid().initProperties();
            this.outStreams.get(i).getFluid().initProperties();
            heatBalanceError += this.outStreams.get(i).getThermoSystem().getEnthalpy() - this.inStreams.get(i).getThermoSystem().getEnthalpy();
            if (Math.abs(refEx.getInStream(i).getTemperature("C") - this.getInStream(i).getTemperature("C")) > 5.0) {
                this.conditionAnalysisMessage = this.conditionAnalysisMessage + "Too high temperature difference between streams. Max difference: 5.0";
                continue;
            }
            if (!(Math.abs(refEx.getOutStream(i).getTemperature("C") - this.getOutStream(i).getTemperature("C")) > 5.0)) continue;
            this.conditionAnalysisMessage = this.conditionAnalysisMessage + "Too high temperature difference between streams. Max difference: 5.0";
        }
        if (Math.abs(heatBalanceError = heatBalanceError / (this.outStreams.get(0).getThermoSystem().getEnthalpy() - this.inStreams.get(0).getThermoSystem().getEnthalpy()) * 100.0) > 10.0) {
            String error = "Heat balance not fulfilled. Error: " + heatBalanceError + " ";
            this.conditionAnalysisMessage = this.conditionAnalysisMessage + error;
        } else {
            String message = "Heat balance ok. Enthalpy balance deviation: " + heatBalanceError + " %";
            this.conditionAnalysisMessage = this.conditionAnalysisMessage + message;
        }
        this.conditionAnalysisMessage = this.conditionAnalysisMessage + this.getName() + "/analysis ended/";
        double totalDuty = 0.0;
        for (int i = 0; i < this.inStreams.size(); ++i) {
            double dutyStream = Math.abs(this.outStreams.get(i).getThermoSystem().getEnthalpy() - this.inStreams.get(i).getThermoSystem().getEnthalpy());
            totalDuty += dutyStream;
        }
        double referenceDuty = Math.abs(((MultiStreamHeatExchanger)refExchanger).getDuty());
        this.thermalEffectiveness = ((MultiStreamHeatExchanger)refExchanger).getThermalEffectiveness() * totalDuty / referenceDuty;
    }

    @Override
    public void runConditionAnalysis() {
        this.runConditionAnalysis(this);
    }

    @Override
    public double getThermalEffectiveness() {
        return this.thermalEffectiveness;
    }

    @Override
    public void setThermalEffectiveness(double thermalEffectiveness) {
        this.thermalEffectiveness = thermalEffectiveness;
    }

    @Override
    public String getFlowArrangement() {
        return this.flowArrangement;
    }

    @Override
    public void setFlowArrangement(String flowArrangement) {
        this.flowArrangement = flowArrangement;
    }

    @Override
    public double calcThermalEffectiveness(double NTU, double Cr) {
        switch (this.flowArrangement.toLowerCase()) {
            case "counterflow": {
                if (Cr == 1.0) {
                    return NTU / (1.0 + NTU);
                }
                return (1.0 - Math.exp(-NTU * (1.0 - Cr))) / (1.0 - Cr * Math.exp(-NTU * (1.0 - Cr)));
            }
            case "parallelflow": {
                return (1.0 - Math.exp(-NTU * (1.0 + Cr))) / (1.0 + Cr);
            }
            case "crossflow": {
                return 1.0 - Math.exp(-NTU * Math.pow(1.0 + Cr, 0.22));
            }
        }
        if (Cr == 1.0) {
            return NTU / (1.0 + NTU);
        }
        return (1.0 - Math.exp(-NTU * (1.0 - Cr))) / (1.0 - Cr * Math.exp(-NTU * (1.0 - Cr)));
    }

    @Override
    public double getHotColdDutyBalance() {
        return this.hotColdDutyBalance;
    }

    @Override
    public void setHotColdDutyBalance(double hotColdDutyBalance) {
        this.hotColdDutyBalance = hotColdDutyBalance;
    }

    @Override
    public String toJson() {
        return new GsonBuilder().create().toJson(new MultiStreamHeatExchangerResponse(this));
    }

    @Override
    public void setUseDeltaT(boolean useDeltaT) {
        this.useDeltaT = useDeltaT;
    }

    @Override
    public double getDeltaT() {
        return this.deltaT;
    }

    @Override
    public void setDeltaT(double deltaT) {
        this.useDeltaT = true;
        this.deltaT = deltaT;
    }

    @Override
    public void run(UUID id) {
        double tempChange;
        double newTemp;
        double oldTemp;
        ThermodynamicOperations ops;
        double adjustedEnthalpyOut;
        double targetDeltaH;
        double enthalpyIn;
        StreamInterface outStream;
        StreamInterface inStream;
        int i;
        boolean heatingIsLimiting;
        double limitingHeat;
        if (this.firstTime) {
            int i2;
            this.firstTime = false;
            double hottestTemperature = Double.NEGATIVE_INFINITY;
            double coldestTemperature = Double.POSITIVE_INFINITY;
            int hottestIndex = -1;
            int coldestIndex = -1;
            for (i2 = 0; i2 < this.inStreams.size(); ++i2) {
                StreamInterface inStream2 = this.inStreams.get(i2);
                inStream2.run();
                double currentTemp = inStream2.getThermoSystem().getTemperature("K");
                if (currentTemp > hottestTemperature) {
                    hottestTemperature = currentTemp;
                    hottestIndex = i2;
                }
                if (!(currentTemp < coldestTemperature)) continue;
                coldestTemperature = currentTemp;
                coldestIndex = i2;
            }
            if (hottestIndex == -1 || coldestIndex == -1) {
                throw new IllegalStateException("Unable to determine hottest or coldest inlet streams.");
            }
            for (i2 = 0; i2 < this.outStreams.size(); ++i2) {
                StreamInterface outStream2 = this.outStreams.get(i2);
                SystemInterface systemOut = this.inStreams.get(i2).getThermoSystem().clone();
                outStream2.setThermoSystem(systemOut);
                if (i2 == hottestIndex) {
                    outStream2.getThermoSystem().setTemperature(coldestTemperature + this.temperatureApproach, "K");
                } else if (i2 == coldestIndex) {
                    outStream2.getThermoSystem().setTemperature(hottestTemperature - this.temperatureApproach, "K");
                } else {
                    outStream2.getThermoSystem().setTemperature(hottestTemperature - this.temperatureApproach, "K");
                }
                outStream2.run(id);
            }
            this.run();
            return;
        }
        for (StreamInterface inStream3 : this.inStreams) {
            inStream3.run(id);
        }
        for (StreamInterface outStream3 : this.outStreams) {
            outStream3.run(id);
        }
        ArrayList<Integer> heatedStreamIndices = new ArrayList<Integer>();
        ArrayList<Integer> cooledStreamIndices = new ArrayList<Integer>();
        double totalHeatGained = 0.0;
        double totalHeatLost = 0.0;
        for (int i3 = 0; i3 < this.inStreams.size(); ++i3) {
            double enthalpyIn2 = this.inStreams.get(i3).getThermoSystem().getEnthalpy();
            double enthalpyOut = this.outStreams.get(i3).getThermoSystem().getEnthalpy();
            double deltaH = enthalpyOut - enthalpyIn2;
            if (deltaH > 0.0) {
                heatedStreamIndices.add(i3);
                totalHeatGained += deltaH;
                continue;
            }
            if (!(deltaH < 0.0)) continue;
            cooledStreamIndices.add(i3);
            totalHeatLost += Math.abs(deltaH);
        }
        logger.debug(": Total Heat Gained = " + totalHeatGained + " J");
        logger.debug(": Total Heat Lost = " + totalHeatLost + " J");
        if (totalHeatGained < totalHeatLost) {
            limitingHeat = totalHeatGained;
            heatingIsLimiting = true;
            logger.debug("Limiting side: Heating");
        } else {
            limitingHeat = totalHeatLost;
            heatingIsLimiting = false;
            logger.debug("Limiting side: Cooling");
        }
        double scalingFactor = 1.0;
        if (heatingIsLimiting) {
            scalingFactor = limitingHeat / totalHeatLost;
            logger.debug("Scaling factor for cooled streams: " + scalingFactor);
        } else {
            scalingFactor = limitingHeat / totalHeatGained;
            logger.debug("Scaling factor for heated streams: " + scalingFactor);
        }
        double maxTemperatureChange = 0.0;
        Iterator iterator = cooledStreamIndices.iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            inStream = this.inStreams.get(i);
            outStream = this.outStreams.get(i);
            enthalpyIn = inStream.getThermoSystem().getEnthalpy();
            targetDeltaH = -(outStream.getThermoSystem().getEnthalpy() - enthalpyIn) * scalingFactor;
            adjustedEnthalpyOut = enthalpyIn - Math.abs(targetDeltaH);
            ops = new ThermodynamicOperations(outStream.getThermoSystem());
            ops.PHflash(adjustedEnthalpyOut);
            oldTemp = outStream.getThermoSystem().getTemperature("K");
            outStream.run(id);
            newTemp = outStream.getThermoSystem().getTemperature("K");
            tempChange = Math.abs(newTemp - oldTemp);
            if (tempChange > maxTemperatureChange) {
                maxTemperatureChange = tempChange;
            }
            logger.debug("Adjusted cooled stream " + i + ": \u0394H = " + targetDeltaH);
        }
        scalingFactor = 1.0;
        iterator = heatedStreamIndices.iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            inStream = this.inStreams.get(i);
            outStream = this.outStreams.get(i);
            enthalpyIn = inStream.getThermoSystem().getEnthalpy();
            targetDeltaH = (outStream.getThermoSystem().getEnthalpy() - enthalpyIn) * scalingFactor;
            adjustedEnthalpyOut = enthalpyIn + Math.abs(targetDeltaH);
            ops = new ThermodynamicOperations(outStream.getThermoSystem());
            ops.PHflash(adjustedEnthalpyOut);
            oldTemp = outStream.getThermoSystem().getTemperature("K");
            outStream.run(id);
            newTemp = outStream.getThermoSystem().getTemperature("K");
            tempChange = Math.abs(newTemp - oldTemp);
            if (tempChange > maxTemperatureChange) {
                maxTemperatureChange = tempChange;
            }
            logger.debug("Adjusted heated stream " + i + ": \u0394H = " + targetDeltaH);
        }
        double adjustedHottestTemp = Double.NEGATIVE_INFINITY;
        double adjustedColdestTemp = Double.POSITIVE_INFINITY;
        int adjustedHottestIndex = -1;
        int adjustedColdestIndex = -1;
        for (int i4 = 0; i4 < this.inStreams.size(); ++i4) {
            StreamInterface inStream4 = this.inStreams.get(i4);
            double currentTemp = inStream4.getThermoSystem().getTemperature("K");
            if (currentTemp > adjustedHottestTemp) {
                adjustedHottestTemp = currentTemp;
                adjustedHottestIndex = i4;
            }
            if (!(currentTemp < adjustedColdestTemp)) continue;
            adjustedColdestTemp = currentTemp;
            adjustedColdestIndex = i4;
        }
        if (adjustedHottestIndex == -1 || adjustedColdestIndex == -1) {
            throw new IllegalStateException("Unable to determine adjusted hottest or coldest inlet streams.");
        }
        double hotInletTemp = adjustedHottestTemp;
        double coldInletTemp = adjustedColdestTemp;
        StreamInterface hotOutletStream = this.outStreams.get(adjustedHottestIndex);
        double hotOutletTemp = hotOutletStream.getThermoSystem().getTemperature("K");
        StreamInterface coldOutletStream = this.outStreams.get(adjustedColdestIndex);
        double coldOutletTemp = coldOutletStream.getThermoSystem().getTemperature("K");
        double deltaT1 = hotInletTemp - coldOutletTemp;
        double deltaT2 = hotOutletTemp - coldInletTemp;
        if (deltaT1 <= 0.0 || deltaT2 <= 0.0) {
            throw new IllegalStateException("Invalid temperature differences for LMTD calculation.");
        }
        double LMTD = deltaT1 == deltaT2 ? deltaT1 : (deltaT1 - deltaT2) / Math.log(deltaT1 / deltaT2);
        double totalQ = heatingIsLimiting ? totalHeatGained : totalHeatLost;
        double UA = totalQ / LMTD;
        logger.info("Overall LMTD: " + LMTD + " K");
        logger.info("Overall UA: " + UA + " W/K");
        if (this.UAvalueIsSet && Math.abs((UA - this.getUAvalue()) / this.getUAvalue()) > 0.001 && this.iterations < this.MAX_ITERATIONS) {
            ++this.iterations;
            this.setTemperatureApproach(this.getTemperatureApproach() * UA / this.getUAvalue());
            this.firstTime = true;
            this.run(id);
            return;
        }
        logger.info("Overall LMTD: " + LMTD + " K");
        logger.info("Overall UA: " + UA + " W/K");
        logger.info("iterations: " + this.iterations);
        this.iterations = 0;
        this.setCalculationIdentifier(id);
        this.firstTime = true;
    }

    public void runSpecifiedStream(UUID id) {
    }

    public double getTemperatureApproach() {
        return this.temperatureApproach;
    }

    public void setTemperatureApproach(double temperatureApproach) {
        this.temperatureApproach = temperatureApproach;
    }

    public int numerOfFeedStreams() {
        return this.inStreams.size();
    }

    public double getDuty(int streamNumber) {
        if (streamNumber < this.inStreams.size()) {
            return this.outStreams.get(streamNumber).getThermoSystem().getEnthalpy() - this.inStreams.get(streamNumber).getThermoSystem().getEnthalpy();
        }
        throw new IndexOutOfBoundsException("Stream index out of bounds.");
    }
}

